c Multi predictor-corrector direction (Merothra)
c
c ===========================================================================
c
      subroutine cpdpcd(xs,up,dspr,dsup,prinf,duinf,upinf,
     x dxsn,ddvn,ddsprn,ddsupn,dxs,ddv,ddspr,ddsup,bounds,
     x ecolpnt,count,pivots,vcstat,diag,odiag,rowidx,nonzeros,
     x colpnt,vartyp,slktyp,barpar,corr,prstpl,dustpl,barn,cgap)
c
      common/dims/ n,n1,m,mn,nz,cfree,pivotn,denwin,rfree
      integer*4    n,n1,m,mn,nz,cfree,pivotn,denwin,rfree

      common/numer/ tplus,tzer
      real*8        tplus,tzer

      common/predp/ ccstop,barset,bargrw,barmin,mincor,maxcor,inibar
      real*8        ccstop,barset,bargrw,barmin
      integer*4     mincor,maxcor,inibar
c
      integer*4 ecolpnt(mn),count(mn),vcstat(mn),rowidx(cfree),
     x pivots(mn),colpnt(n1),vartyp(n),slktyp(m),corr,barn
      real*8 xs(mn),up(mn),dspr(mn),dsup(mn),prinf(m),duinf(mn),
     x upinf(mn),dxsn(mn),ddvn(m),ddsprn(mn),ddsupn(mn),
     x dxs(mn),ddv(m),ddspr(mn),ddsup(mn),bounds(mn),
     x diag(mn),odiag(mn),nonzeros(cfree),barpar,prstpl,dustpl,cgap
c
      integer*4 i,j,cr,mxcor
      real*8 sol,sb,ogap,ngap,obpar,ostp,ostd
c
c ---------------------------------------------------------------------------
c
c Compute ogap
c
      ogap=cgap
      if(barpar.lt.tzer)barpar=ogap/dble(barn)*barset
      obpar=barpar
      if(inibar.le.0)then
        barpar=0.0d+0
      else
        barpar=ogap/dble(barn)*barset
        if(barpar.gt.obpar*bargrw)barpar=obpar*bargrw
      endif
c
      cr=0
      mxcor=maxcor
c
c Initialize : Reset
c
      do i=1,m
        ddv(i)=0.0d+0
      enddo
      do i=1,mn
        dxs(i)=0.0d+0
        ddspr(i)=0.0d+0
        ddsup(i)=0.0d+0
      enddo
c
c Affine scaling / primal-dual direction
c
      do i=1,n
        sol=0.0d+0
        if(vcstat(i).gt.-2)then
          if(vartyp(i))10,11,12
  10      sol=duinf(i)+dspr(i)-barpar/xs(i)
     x    -dsup(i)+(barpar-dsup(i)*upinf(i))/up(i)
          goto 15
  11      sol=duinf(i)
          goto 15
  12      sol=duinf(i)+dspr(i)-barpar/xs(i)
        endif
  15    dxsn(i)=sol
      enddo
c
      do i=1,m
       j=i+n
       sol=0.0d+0
       if(vcstat(j).gt.-2)then
         if(slktyp(i))20,21,22
  20     sol=-(duinf(j)+dspr(j)-barpar/xs(j)
     x   -dsup(j)+(barpar-dsup(j)*upinf(j))/up(j))*odiag(j)
         goto 25
  21     sol=0.0d+0
         goto 25
  22     sol=-(duinf(j)+dspr(j)-barpar/xs(j))*odiag(j)
       endif
  25   dxsn(j)=prinf(i)+sol
      enddo
c
c Solve the augmented system
c
      if(cr.lt.mincor)then
        call augftr(ecolpnt,vcstat,rowidx,pivots,count,nonzeros,
     x  diag,dxsn)
        call augbtr(ecolpnt,vcstat,rowidx,pivots,count,nonzeros,
     x  diag,dxsn)
      else
        call citref(diag,odiag,pivots,rowidx,nonzeros,colpnt,
     x  ecolpnt,count,vcstat,dxsn,ddsprn,ddsupn,upinf,
     x  bounds,xs,up,vartyp,slktyp)
      endif
c
c Primal and dual variables
c Primal slacks : ds=D_s^{-1}*(b_s+dy)
c
      do i=1,m
        j=i+n
        if(vcstat(j).gt.-2)then
          ddvn(i)=dxsn(j)
          if(slktyp(i).ne.0)then
            if(slktyp(i).gt.0)then
              sb=duinf(j)+dspr(j)-barpar/xs(j)
            else
              sb=duinf(j)+dspr(j)-barpar/xs(j)
     x        -dsup(j)+(barpar-dsup(j)*upinf(j))/up(j)
            endif
            dxsn(j)=-odiag(j)*(ddvn(i)+sb)
          endif
        endif
      enddo
c
c Primal upper bounds, dual slacks
c dz=-Z+X^{-1}(mu -dx*dz -Z*dx)
c
      do i=1,mn
        if(vcstat(i).gt.-2)then
          if(i.le.n)then
            j=vartyp(i)
          else
            j=slktyp(i-n)
          endif
          if(j.lt.0)then
            ddsupn(i)=-dsup(i)+(barpar-dsup(i)*(upinf(i)-dxsn(i)))/up(i)
          endif
          if(j.ne.0)then
            ddsprn(i)=-dspr(i)+(barpar-dspr(i)*dxsn(i))/xs(i)
          else if(i.le.n)then
            ddsprn(i)=-dspr(i)
          endif
        endif
      enddo
c
c Compute primal and dual steplengths
c
      call cstpln(prstpl,xs,dxsn,up,upinf,
     x dustpl,dspr,ddsprn,dsup,ddsupn,vartyp,slktyp,vcstat)
c
c Estimate basic variables vcstat(i)=1 for basic, 0 for nonbasic
c
      do i=1,n
        if((vcstat(i).gt.-2).and.(vartyp(i).ne.0))then
          if(abs(ddsprn(i))*xs(i).gt.abs(dxsn(i))*dspr(i))then
            vcstat(i)=1
          else
            vcstat(i)=0
          endif
        endif
      enddo
      do i=1,m
        if((vcstat(i+n).gt.-2).and.(slktyp(i).ne.0))then
          if(abs(ddsprn(i+n))*xs(i+n).gt.abs(dxsn(i+n))*dspr(i+n))then
            vcstat(i+n)=1
          else
            vcstat(i+n)=0
          endif
        endif
      enddo
c
c Compute ngap
c
      ngap=0.0d+0
      do i=1,mn
        if(vcstat(i).gt.-2)then
          if(i.le.n)then
            j=vartyp(i)
          else
            j=slktyp(i-n)
          endif
          if(j.ne.0)then
            ngap=ngap+(xs(i)+prstpl*dxsn(i))*(dspr(i)+dustpl*ddsprn(i))
            if(j.lt.0)then
              ngap=ngap+(up(i)+prstpl*(upinf(i)-dxsn(i)))*
     x        (dsup(i)+dustpl*ddsupn(i))
            endif
          endif
        endif
      enddo
      cgap=ngap/dble(barn)
      ostp=prstpl
      ostd=dustpl
      do i=1,mn
        dxs(i)=dxsn(i)
        ddspr(i)=ddsprn(i)
        ddsup(i)=ddsupn(i)
      enddo
      do i=1,m
        ddv(i)=ddvn(i)
      enddo
c
c Compute barrier
c
      barpar=ngap*ngap*ngap/(ogap*ogap*dble(barn))
      if(barpar.gt.ogap/dble(barn)*barset)barpar=ogap/dble(barn)*barset
      if(barpar.gt.obpar*bargrw)barpar=obpar*bargrw
      if(barpar.lt.barmin)barpar=0.0d+0
      if(mxcor.le.0)goto 999
c
c Higher order predictor-corrector direction
c
  50  cr=cr+1
      do i=1,n
        sol=0.0d+0
        if(vcstat(i).gt.-2)then
          if(vartyp(i))30,31,32
  30      sol=duinf(i)+dspr(i)+(ddspr(i)*dxs(i)-barpar)/xs(i)
     x    -dsup(i)-(ddsup(i)*(upinf(i)-dxs(i))-barpar+dsup(i)*
     x    upinf(i))/up(i)
          goto 35
  31      sol=duinf(i)
          goto 35
  32      sol=duinf(i)+dspr(i)+(ddspr(i)*dxs(i)-barpar)/xs(i)
        endif
  35    dxsn(i)=sol
      enddo
c
      do i=1,m
       j=i+n
       sol=0.0d+0
       if(vcstat(j).gt.-2)then
         if(slktyp(i))40,41,42
  40     sol=-(duinf(j)+dspr(j)+(ddspr(j)*dxs(j)-barpar)/xs(j)
     x   -dsup(j)-(ddsup(j)*(upinf(j)-dxs(j))-barpar+dsup(j)*
     x   upinf(j))/up(j))*odiag(j)
         goto 45
  41     sol=0.0d+0
         goto 45
  42     sol=-(duinf(j)+dspr(j)+(ddspr(j)*dxs(j)-barpar)/xs(j))*odiag(j)
       endif
  45   dxsn(j)=prinf(i)+sol
      enddo
c
c Solve the augmented system
c
      if(cr.lt.mincor)then
        call augftr(ecolpnt,vcstat,rowidx,pivots,count,nonzeros,
     x  diag,dxsn)
        call augbtr(ecolpnt,vcstat,rowidx,pivots,count,nonzeros,
     x  diag,dxsn)
      else
        call citref(diag,odiag,pivots,rowidx,nonzeros,colpnt,
     x  ecolpnt,count,vcstat,dxsn,ddsprn,ddsupn,upinf,
     x  bounds,xs,up,vartyp,slktyp)
      endif
c
c Primal and dual variables
c Primal slacks : ds=D_s^{-1}*(b_s+dy)
c
      do i=1,m
        j=i+n
        if(vcstat(j).gt.-2)then
          ddvn(i)=dxsn(j)
          if(slktyp(i).ne.0)then
            if(slktyp(i).gt.0)then
              sb=duinf(j)+dspr(j)+(ddspr(j)*dxs(j)-barpar)/xs(j)
            else
              sb=duinf(j)+dspr(j)+(ddspr(j)*dxs(j)-barpar)/xs(j)
     x        -dsup(j)-(ddsup(j)*(upinf(j)-dxs(j))-barpar+dsup(j)*
     x         upinf(j))/up(j)
            endif
            dxsn(j)=-odiag(j)*(ddvn(i)+sb)
          endif
        endif
      enddo
c
c Primal upper bounds, dual slacks
c dz=-Z+X^{-1}(mu -dx*dz -Z*dx)
c
      do i=1,mn
        if(vcstat(i).gt.-2)then
          if(i.le.n)then
            j=vartyp(i)
          else
            j=slktyp(i-n)
          endif
          if(j.lt.0)then
            ddsupn(i)=
     x       -dsup(i)+(barpar-ddsup(i)*(upinf(i)-dxs(i))
     x       -dsup(i)*(upinf(i)-dxsn(i)))/up(i)
          endif
          if(j.ne.0)then
            ddsprn(i)=
     x       -dspr(i)+(barpar-ddspr(i)*dxs(i)-dspr(i)*dxsn(i))/xs(i)
          else if(i.le.n)then
            ddsprn(i)=-dspr(i)
          endif
        endif
      enddo
c
c Compute primal and dual steplengths
c
      call cstpln(prstpl,xs,dxsn,up,upinf,dustpl,dspr,
     x ddsprn,dsup,ddsupn,vartyp,slktyp,vcstat)
c
c Compute ngap
c
      ngap=0.0d+0
      do i=1,mn
        if(vcstat(i).gt.-2)then
          if(i.le.n)then
            j=vartyp(i)
          else
            j=slktyp(i-n)
          endif
          if(j.ne.0)then
            ngap=ngap+(xs(i)+prstpl*dxsn(i))*(dspr(i)+dustpl*ddsprn(i))
            if(j.lt.0)then
              ngap=ngap+(up(i)+prstpl*(upinf(i)-dxsn(i)))*
     x        (dsup(i)+dustpl*ddsupn(i))
            endif
          endif
        endif
      enddo
c
c Check corrections criteria
c
      if(cr.gt.mincor)then
        if(min(prstpl,dustpl).lt.ccstop*min(ostp,ostd))then
          if(min(prstpl,dustpl).lt.min(ostp,ostd))then
            prstpl=ostp
            dustpl=ostd
            cr=cr-1
            goto 999
          else
            mxcor=cr
          endif
        endif
      endif
c
c Continue correcting, change the actual search direction
c
      cgap=ngap/dble(barn)
      ostp=prstpl
      ostd=dustpl
      do i=1,mn
        dxs(i)=dxsn(i)
        ddspr(i)=ddsprn(i)
        ddsup(i)=ddsupn(i)
      enddo
      do i=1,m
        ddv(i)=ddvn(i)
      enddo
      if(cr.ge.mxcor)goto 999
      goto 50
c
c End of the correction loop, save the number of the corrections
c
 999  corr=cr
      return
      end
c
c ============================================================================
