function M = femX_stima3(vertices)
% function M = femX_stima3(X)
%
%   Spatial element stiffness matrix for triangles
%
%   X has dimension 3 x 2 containing the x- & y-coordinates

%   R. Andreev, 2012.10.25
%
%   The femX_* code is essentially due to
%
%       Alberty, J., Carstensen, C., Funken, S.A.
%       Remarks around 50 lines of Matlab
%       Numerical Algorithms, 20 (1999), pp. 117-137

	d = size(vertices, 2);
	G = [ones(1,d+1); vertices'] \ [zeros(1,d); eye(d)];
	M = det([ones(1,d+1); vertices']) * (G * G') / prod(1:d);
end
