function femX_show(v)
% function femX_show(V)
%
%   Plot the finite element function with degrees of freedom V

%   R. Andreev, 2012.10.25
%
%   This routine is essentially due to
%
%       Alberty, J., Carstensen, C., Funken, S.A.
%       Remarks around 50 lines of Matlab
%       Numerical Algorithms, 20 (1999), pp. 117-137
%
%   Their original documentation:
%
%     Presents two-dimensional piecewise affine function graphically.
%     SHOW(ELEMENTS3,ELEMENTS4,COORDINATES,U) presents a two-dimensional
%     spline function graphically. ELEMENTS3 denotes a set of triangles
%     with dimension (no. of triangles) x 3 and ELEMENTS4 denotes a set of 
%     parallelograms (dimension [(no. of parallelograms) x 4]). Both arrays 
%     include the number of nodes. The nodes have to be counted clockwise
%     or anti-clockwise. The coordinates of the nodes are stored in a
%     [(no. of coordinates) x 2] - dimensional array called COORDINATES.  
%     Its i'th row defines the x- and y- coordinate of the i'th node.
%     U is a [(no. of coordinates) x 1] - dimensional array containing in
%     the i'th row the value of the spline function at the i'th node.
% 
%     J. Alberty, C. Carstensen and S. A. Funken  02-11-99

	femX_init

	global femX_coordinates
	global femX_elements3 femX_elements4
	%global femX_neumann femX_dirichlet
	global femX_FreeNodes
	
	u = zeros(size(femX_coordinates, 1), 1);
	u(femX_FreeNodes) = v;

	trisurf(femX_elements3,femX_coordinates(:,1),femX_coordinates(:,2),u','facecolor','interp')
	hold on
	trisurf(femX_elements4,femX_coordinates(:,1),femX_coordinates(:,2),u','facecolor','interp')
	hold off
	view(10,40);
	%title('Solution of the Problem')
end
