function M = femX_masma4(vertices)
% function M = femX_masma4(X)
%
%   Spatial element mass matrix for a parallelogram
%
%   X has dimension 4 x 2 containing the x- & y-coordinates
%   The vertices are numbered anti-clockwise

%   R. Andreev, 2012.10.07

	D_Phi = [vertices(2,:)-vertices(1,:); vertices(4,:)-vertices(1,:)]';

	M = gallery('circul', [4 2 1 2]);
	M = M / sum(sum(M));

	M = abs(det(D_Phi)) * M;
end
