function b = femX_b(f, g)
% function b_xi = femX_b(ft, gt)
%
%   The spatial load vector
%
%
%   See Sec 7.2 in
%
%       R. Andreev
%       Space-time discretization of the heat equation
%       Numerical Algorithms, 2014
%       (see README.txt for precise reference)

%   R. Andreev, 2012.10.07
%
%   The femX_* code is essentially due to
%
%       Alberty, J., Carstensen, C., Funken, S.A.
%       Remarks around 50 lines of Matlab
%       Numerical Algorithms, 20 (1999), pp. 117-137
    
	femX_init

	global femX_coordinates
	global femX_elements3 femX_elements4
	global femX_neumann
	global femX_FreeNodes

	assert(~isempty(femX_FreeNodes), 'The vector of FEM nodes cannot be empty. Failed femX_init?');

	% Volume Forces
	b = sparse(size(femX_coordinates,1),1);
	for j = 1:size(femX_elements3,1)
		b(femX_elements3(j,:)) = b(femX_elements3(j,:)) + ...
			det([1,1,1; femX_coordinates(femX_elements3(j,:),:)']) * ...
				f(sum(femX_coordinates(femX_elements3(j,:),:))/3)/6;
	end
	for j = 1:size(femX_elements4,1)
		b(femX_elements4(j,:)) = b(femX_elements4(j,:)) + ...
			det([1,1,1; femX_coordinates(femX_elements4(j,1:3),:)']) * ...
				f(sum(femX_coordinates(femX_elements4(j,:),:))/4)/4;
	end

	% Neumann conditions
	for j = 1:size(femX_neumann,1)
		b(femX_neumann(j,:)) = b(femX_neumann(j,:)) + ...
			norm(femX_coordinates(femX_neumann(j,1),:) - ...
				femX_coordinates(femX_neumann(j,2),:)) * ...
					g(sum(femX_coordinates(femX_neumann(j,:),:))/2)/2;
	end

	b = b(femX_FreeNodes);
end
