function Stress = data_g(t, x)
% function Stress = data_g(t, x)
%
%   t is a scalar
%   x is a Nx2 matrix of coordinates
%
%   Stress is a Nx1 vector of
%   evaluations of the Neumann data g
%   at time t in the coordinates x along the outer normal
%
%   If called with one argument t returns the handle
%
%      @(varargin) data_g(t, varargin{:})
%
%   for the purpose of temporal quadrature
%
%
%   See Sec 2 and Sec 7.2 in
%
%       R. Andreev
%       Space-time discretization of the heat equation
%       Numerical Algorithms, 2014
%       (see README.txt for precise reference)

%   R. Andreev, 2012.10.07

	if (nargin == 1)
		Stress = @(varargin) data_g(t, varargin{:});
		return
	end

	Stress = zeros(size(x,1),1);
end
