function [x, w, R] = QR_Trapz(I)
% function [X, W, R] = QR_Trapz(I)
%
%   Trapezoidal quadrature for the interval (I(1),I(2))
%   having R = 2 nodes X with corresponding weights W
%
%   If called with no argument,
%   returns a function handle to itself

%   R. Andreev, 2012.10.16

	if (nargin == 0)
		x = @(J) QR_Trapz(J);
		return
	end

	assert(numel(I) == 2, 'The vector I should have two elements, namely the endpoints of the interval');

	x = [I(1), I(2)];
	w = [1, 1]/2 * diff(I);
	R = 2;
end
