%   SPACETIME       - space-time discretization of the heat equation
% Version 1.1 04-Dec-2013
%
% This is the accompanying Matlab implementation for
%
%       R. Andreev
%       Space-time discretization of the heat equation
%       Numerical Algorithms, 2014
%
% Please consult the file README.txt for further information
%
% Demo function:
%   spacetime       - Solves the heat equation and shows solution snapshots
%
% Temporal FEM:
%   femT_assemE     - Mass and stiffness matrices for 1d P1 Lagrange FEM
%   femT_assemF     - Mass matrix of 1d piecewise constant functions
%   femT_assemFE    - Temporal finite element matrices MtFE and CtFE
%
% Space-time FEM:
%   femTX_assemLoad - Assemble the space-time load vector
%
% Spatial FEM:
%   femX_b          - The spatial load vector
%   femX_init       - Initialize the spatial FEM
%   femX_MA         - Spatial mass and stiffness matrices
%   femX_masma3     - Spatial element mass matrix for a triangle
%   femX_masma4     - Spatial element mass matrix for a parallelogram
%   femX_show       - Plot a finite element function
%   femX_stima3     - Spatial element stiffness matrix for triangles
%   femX_stima4     - Spatial element stiffness matrix for a parallelogram
%
% Problem data:
%   data_f          - Source function
%   data_g          - Neumann data
%   data_h          - Initial condition
%
% Solver:
%   glsqr           - Generalized LSQR iterative solver
%
% Quadrature:
%   QR_GauLeg       - Gauss-Legendre quadrature
%   QR_Trapz        - Trapezoidal quadrature
