function vertexlist = initvert(domain_id)
% INITVERT initialize vertex list, thereby define the domain of integration
% vertexlist = initvert(domain_id) initializes predefined coordinates 
% of the simplices for various domain_id's. 
%
% Input parameters:
% domain_id  domain identification in the form 10*d+k where d is the space 
%            dimension and k is the dimension of the intersection of two
%            simplices
% 
% Output parameters:
% vertexlist list of vertices

% Alexey Chernov, University of Bonn, Germany (corresponding author)
% Current affiliation: University of Oldenburg, Germany
% Email: alexey.chernov@uni-oldenburg.de
%
% Christoph Schwab, ETH Zurich, Switzerland
% Email: schwab@sam.math.ethz.ch
%
% Tobias von Petersdorff, University of Maryland, College Park, USA
% Email: tvp@math.umd.edu
%
% Last revised July 5, 2013

switch domain_id
        case 19
            vertexlist = [0 0;1 0;0 1;-1 -1;0 -1;-1 0];
        case 20
            vertexlist = [0 0;1 0;0 1;-1 0;0 -1];
        case 21 
            vertexlist = [0 0;1 0;0 1;0 -1];
        case 22
            vertexlist = [0 0;1 0;0 1];
        case 29
            vertexlist = [0 0 0;1 0 0;0 1 0;0 0 1;-1 -1 -1;0 -1 -1;-1 0 -1;-1 -1 0];            
        case 30
            vertexlist = [0 0 0;1 0 0;0 1 0;0 0 1;-1 0 0;0 -1 0; 0 0 -1];
        case 31
            vertexlist = [0 0 0;1 0 0;0 1 0;0 0 1;0 -1 0;0 0 -1];
        case 32
            vertexlist = [0 0 0;1 0 0;0 1 0;0 0 1;0 0 -1];
        case 33
            vertexlist = [0 0 0;1 0 0;0 1 0;0 0 1];
        case 39
            vertexlist = [0 0 0 0;1 0 0 0;0 1 0 0;0 0 1 0;0 0 0 1;-1 -1 -1 -1;0 -1 -1 -1;-1 0 -1 -1;-1 -1 0 -1;-1 -1 -1 0];             
        case 40
            vertexlist = [0 0 0 0;1 0 0 0;0 1 0 0;0 0 1 0;0 0 0 1;-1 0 0 0;0 -1 0 0;0 0 -1 0; 0 0 0 -1]; 
        case 41
            vertexlist = [0 0 0 0;1 0 0 0;0 1 0 0;0 0 1 0;0 0 0 1;0 -1 0 0;0 0 -1 0;0 0 0 -1]; 
        case 42
            vertexlist = [0 0 0 0;1 0 0 0;0 1 0 0;0 0 1 0;0 0 0 1;0 0 -1 0;0 0 0 -1]; 
        case 43
            vertexlist = [0 0 0 0;1 0 0 0;0 1 0 0;0 0 1 0;0 0 0 1;0 0 0 -1]; 
        case 44
            vertexlist = [0 0 0 0;1 0 0 0;0 1 0 0;0 0 1 0;0 0 0 1]; 
        otherwise
            error('Unknown simplex location');
    end
