% demo script for the case d=3, k=2 (3d simplices sharing a face)
%
% k      dimension of the intersection of two simplices
% d      spatial dimension
% 
% Reproduces convergence curves for CGL-GL, GJ-GL and GJ-GJ in the middle 
% plot in Fig. 6 from the article "Quadrature Algorithms for High 
% Dimensional Singular Integrands on Simplices", NUMERICAL ALGORITHMS, 
% 70 (2015), pp. 847-874
%
% CGL    composite Gauss-Legendre quadrature rule
% GL     Gauss-Legendre quadrature rule
% GJ     Gauss-Jacobi quadrature rule

% Alexey Chernov, University of Bonn, Germany (corresponding author)
% Current affiliation: University of Oldenburg, Germany
% Email: alexey.chernov@uni-oldenburg.de
%
% Christoph Schwab, ETH Zurich, Switzerland
% Email: schwab@sam.math.ethz.ch
%
% Tobias von Petersdorff, University of Maryland, College Park, USA
% Email: tvp@math.umd.edu
%
% Last revised February 2, 2015

% set up the geometry (to modify initialize an new domain_id in initvert.m)

domain_id = 32;

% set up the integrand (to modify initialize a new integrand in demo_squad.m)

func_id = 1;

% changeable quadrature parameters

lmin = 2; % coarsest quadrature level for plotting convergence curves
lmax = 7; % finest   quadrature level for plotting convergence curves
llim = 8;% quadrature level for the overkill approximation of the integral

% set path

addpath('..');

% computation

% computing the limiting value by overkill
[Nlim,Qlim] = ssquad_mgr(domain_id,llim,func_id,2,'output_lim_'); 

% singular direction: CGL, regular direction GL
[N1,Q1] = ssquad_mgr(domain_id,lmin:lmax,func_id,1,'output_CGL-GL_');

% singular direction: GJ, regular direction GL
[N2,Q2] = ssquad_mgr(domain_id,lmin:lmax,func_id,2,'output_GJ-GL_');  

% singular direction: GJ, regular direction GJ
[N3,Q3] = ssquad_mgr(domain_id,lmin:lmax,func_id,32,'output_GJ-GJ_'); 

% plotting

figure(domain_id);

semilogy(N1.^(1/7),abs((Qlim-Q1)/Qlim),'ro-');
hold on;
semilogy(N2.^(1/7),abs((Qlim-Q2)/Qlim),'bs--');
semilogy(N3.^(1/7),abs((Qlim-Q3)/Qlim),'gv--');
hold off;

title('d=3, k=2');
xlabel('(# function evaluations)^{1/7}');
ylabel('relative quadrature error');
legend('CGL-GL','GJ-GL','GJ-GJ');
