function [z,w] = tensquad(x,u,y,v)
% TENSQUAD tensorization of two quadrature rules
% [z,w] = TENSQUAD(x,u,y,v) computes tensor product of quadrature rule of
% two quadrature rules: [x,u] and [y,v].
%
% Input parameters:
% [x,u] node(s) and weight(s) of the first input quadrature rule
% [y,v] node(s) and weight(s) of the second input quadrature rule
%
% Output parameters:
% [z,w] node(s) and weight(s) of the tensor product quadrature rule

% Alexey Chernov, University of Bonn, Germany (corresponding author)
% Current affiliation: University of Oldenburg, Germany
% Email: alexey.chernov@uni-oldenburg.de
%
% Christoph Schwab, ETH Zurich, Switzerland
% Email: schwab@sam.math.ethz.ch
%
% Tobias von Petersdorff, University of Maryland, College Park, USA
% Email: tvp@math.umd.edu
%
% Last revised May 7, 2014


[lx,nx] = size(x);	[ly,ny] = size(y);
    
z = zeros(lx*ly,nx+ny);
w = zeros(lx*ly,1);
% slow changing x
z(:,1:nx) = repmat(x,ly,1);
w         = repmat(u,ly,1);
% fast changing y
for i=1:ny
    y1        = repmat(y(:,i)',lx,1);
    z(:,nx+i) = reshape(y1,lx*ly,1);
end
v1 = repmat(v',lx,1);
w  = reshape(v1,lx*ly,1).*w;
