function [x,w]=glquad(n,l,r)
% GLQUAD one-dimensional Gauss-Legendre quadrature rule
% [x,w]=GLQUAD(n,a,b) computes Gauss-Legendre quadrature rule on [l,r] 
% by solving a symmetric tridiagonal eigenvalue problem (Golub/Welsch 1969)
%
% Input parameters:
% n     number of quadrature nodes and weights
% [l,r] parameters of the interval (default values [0,1])
% 
% Output parameters:
% [x,w] nodes and weights of the Gauss-Legendre quadrature rule

% Alexey Chernov, University of Bonn, Germany (corresponding author)
% Current affiliation: University of Oldenburg, Germany
% Email: alexey.chernov@uni-oldenburg.de
%
% Christoph Schwab, ETH Zurich, Switzerland
% Email: schwab@sam.math.ethz.ch
%
% Tobias von Petersdorff, University of Maryland, College Park, USA
% Email: tvp@math.umd.edu
%
% Last revised May 7, 2014

if nargin==1 % default interval [0,1]
    l=0; r=1; 
end

b=1:n-1; 
b=b./sqrt(4*b.*b-1);
J=diag(b,-1)+diag(b,1); 
[evec,eval]=eig(J);

% normalize eigenvectors

for i=1:n
    evec(:,i)=evec(:,i)./norm(evec(:,i));
end

x=diag(eval);
w=(2*(evec(1,:).*evec(1,:)))';

x=x*(r-l)/2+(r+l)/2;
w=w*(r-l)/2;


end
