function [q,wq] = gjquadrs(d,n)
% GJQUADRS Gauss-Jacobi quadrature on the reference simplex
% [q,wq] = gjquadrs(d,n) realizes a tensorized Gauss-Jacobi quadrature on 
% the reference simplex S_d = {(x_1,...,x_d) | x_i >= 0, x_1+...+x_d <= 1}.
% Uses the same collapsing coordinate transform as in C2S. 
%
% Input parameters:
% d      spatial dimension
% n      number of quadrature nodes and weights
% 
% Output parameters:
% [q,wq] nodes and weights of the computed Gauss-Jacobi quadrature rule

% Alexey Chernov, University of Bonn, Germany (corresponding author)
% Current affiliation: University of Oldenburg, Germany
% Email: alexey.chernov@uni-oldenburg.de
%
% Christoph Schwab, ETH Zurich, Switzerland
% Email: schwab@sam.math.ethz.ch
%
% Tobias von Petersdorff, University of Maryland, College Park, USA
% Email: tvp@math.umd.edu
%
% Last revised May 7, 2014

[q,wq] = gjquad(0,d-1,n);
for i=2:d
    [r,wr] = gjquad(0,d-i,n);
    [q,wq] = tensquad(q,wq,r,wr);
    q(:,i) = q(:,i).*q(:,i-1);       
end
q(:,1:d-1) = q(:,1:d-1) - q(:,2:d);  
