function [x,w]=cglquad(n)
% CGLQUAD one-dimensional Composite Gauss-Legendre quadrature rule
% [x,w]=CGLQUAD(n) computes one-dimensional composite Gauss-Legendre 
% quadrature rule. The slope parameter b and the Gevrey parameter delta 
% equal 1.
%
% Input parameters:
% n     number of quadrature nodes in the largest subinterval (coincides 
%       with the number of subintervals in the geometric subdivision)
% 
% Output parameters:
% [x,w] node(s) and weight(s) of the composite Gauss-Legendre quadrature 
%       rule

% Alexey Chernov, University of Bonn, Germany (corresponding author)
% Current affiliation: University of Oldenburg, Germany
% Email: alexey.chernov@uni-oldenburg.de
%
% Christoph Schwab, ETH Zurich, Switzerland
% Email: schwab@sam.math.ethz.ch
%
% Tobias von Petersdorff, University of Maryland, College Park, USA
% Email: tvp@math.umd.edu
%
% Last revised May 7, 2014

sigma = 0.1;    % parameter of geometric subdivision

x=[];
w=[];

xl = sigma;
xr = 1;

for j=1:n-1
    nj = n+(1-j);
    [x1,w1]=glquad(nj,xl,xr);  
    
    x = [x; x1(1:nj)];
    w = [w; w1(1:nj)];
     
    xr=xl;
    xl=xl*sigma; 
end

[x1,w1]=glquad(1,0,xr);     
x = [x; x1(1:1)]; 
w = [w; w1(1:1)];
end
