function [q,wq] = c2s(q,wq)
% C2S transforms quadrature from the unit cube to the reference simplex
% [q,wq] = C2S(q,wq) transforms the quadrature rule [q,wq] defined on 
% the unit cube [0,1]^d to the reference simplex 
% S_d = {(x_1,...,x_d) | x_i >= 0, x_1+...+x_d <= 1}. The spatial dimension
% d is determined by the second dimension of the matrix q.
%
% Input parameters:
% [q,wq] node(s) and weight(s) of a quadrature rule on the unit cube
%
% Output parameters:
% [q,wq] node(s) and weight(s) of a quadrature rule on the reference
%        simplex

% Alexey Chernov, University of Bonn, Germany (corresponding author)
% Current affiliation: University of Oldenburg, Germany
% Email: alexey.chernov@uni-oldenburg.de
%
% Christoph Schwab, ETH Zurich, Switzerland
% Email: schwab@sam.math.ethz.ch
%
% Tobias von Petersdorff, University of Maryland, College Park, USA
% Email: tvp@math.umd.edu
%
% Last revised May 7, 2014

d = size(q,2);                      
for i=2:d                           
    q(:,i) = q(:,i).*q(:,i-1);     
    if nargin==2 && nargout==2      
        wq = wq.*q(:,i-1); 
    end
end
q(:,1:d-1) = q(:,1:d-1) - q(:,2:d); 
