%STAR - MFD star generation 
% (configuration of nodes applied for the MWLS approximation) 
% based the distance criterion
%
%   [S] = star(N,x,y,X,Y,m) returns the matrix S (m x 2) 
%   of m nodes numbers of the MFD star at point (x,y), where:
%   N - total number of nodes
%   x,y - coordinates of the considered point
%   X (N x 1) - x-coordinates of nodes
%   Y (N x 1) - y-coordinates of nodes
%   m - number of nodes in the MFD star
%   Matrix S contains the nodes numbers in the first column, whereas the
%   these nodes distances from the point (x,y) are stored in the second
%   column
%
%   Example:   
%       X = [0 0 0 0 1 1 1 1 2 2 2 2 3 3 3 3]';
%       Y = [0 1 2 3 0 1 2 3 0 1 2 3 0 1 2 3]';
%       x = 1.5;
%       y = 1.5;
%       N = 16;
%       m = 12;
%       S = star(N,x,y,X,Y,m)
%       plot(X,Y,'ro','markerfacecolor','r');
%       hold on
%       plot([x*ones(m,1) X(S(:,1))]',[y*ones(m,1) ...
%           Y(S(:,1))]','b-','linewidth',2)
%
%   see also mwls, localMFDM, varMFDM, postprocessingMFDM

%Copyright by Sawomir Milewski, Cracow University of Technology,
%slawek@L5.pk.edu.pl

function [S] = star(N,x,y,X,Y,m) 
S = [1:N; sqrt((x-X').^2+(y-Y').^2)]';
S = sortrows(S,2);
S = S(1:m,:);