function [fun_params] = SetTV(fun_params,nx,ny)
%SETTV   sets up the discretization for the Total Variation function.
%
%   [FUN_PARAMS]=SETTV(FUN_PARAMS,NX,NY) returns in fiels of the structure 
%   array FUN_PARAMS the matrices representing finite difference
%   approximations:
%     FUN_PARAMS.DX is a (NX-1)*(NY-1)-by-NX*NY matrix representing the  
%     finite difference approximation of differentation with respect to X
%     FUN_PARAMS.Dy is a (NX-1)*(NY-1)-by-NX*NY matrix representing the 
%     finite difference approximation of differentation with respect to Y
% 
%   See also KLTVb_obj, KLTVn_obj, LSTVb_obj, LSTVb_obj.

%   The discrete first-order derivator operator is obatined using forward 
%   differencing as described in:
%   C. Vogel, Computational Methods for Inverse Problems, SIAM, 2002.

hx = 1/nx; hy = 1/ny; 
ForwDiffx = diff(speye(ny))/hy; Ix = speye(nx-1,nx);
ForwDiffy = (diff(speye(nx))/hx)'; Iy = speye(ny,ny-1);

Dx = kron(ForwDiffx,Ix);
Dy = kron(Iy,ForwDiffy)';

fun_params.Dx = Dx; fun_params.Dy = Dy;
fun_params.nx = nx; fun_params.ny = ny;
fun_params.hx = hx; fun_params.hy = hy; 
fun_params.hxy = 1; 
 
