function [xt,residt,ft,void,cft] = ...
    armijo_NP(x,step,gn,g0,f0,eta,TF,epsilonk)
%ARMIJO_NP   Armijo rule along the projection arc.
%   ARMIJO_NP computes the new NP iterate using the Armijo rule along
%   the projection arc for the step-length computation.
%
%   [XT]=ARMIJO_NP(X,STEP,GN,G0,F0,ETA,TF,EPSILONK) returns the 
%   new NP iterate XT. X is the current iterate. STEP is the search
%   direction. GN is the data image. F0 is the cost function at the 
%   current iterate and G0 is its gradient. ETA is the regularization 
%   parameter. TF is the fft2 of the psf image. EPSILONK is the
%   parameter for the set Ik. 
%
%   [XT,RESIDT]=ARMIJO_NP(X,STEP,GN,G0,F0,ETA,EPSILONK) also
%   returns the residual RESIDT at the new iterate.
%
%   [XT,RESIDT,FT]=ARMIJO_NP(X,STEP,GN,G0,F0,ETA,EPSILONK) also
%   returns the objective function value FT at the new iterate.
%
%   [XT,RESIDT,FT,VOID]=ARMIJO_NP(X,STEP,GN,G0,F0,ETA,EPSILONK)
%   also returns a parameter VOID:
%    0 the line search terminates successfully
%    1 the line search terminates after 50 backtracks without determining 
%    a new iterate.
%
%   [XT,RESIDT,FT,VOID,CFT]=ARMIJO_NP(X,STEP,GN,G0,F0,ETA,EPSILONK)
%   also returns the number CFT of performed ffts.

%   D. P. Bertsekas. On the Goldstein-Levitin-Poljak Gradient Projection 
%   Method. IEEE Transcations on Automatic Control, 21(2):174184, 1976

cft = 0;        
maxarm = 50;  
iarm = 1;
void = 0;
lambda = 1; 
alpha = 1e-4;
beta = 0.5;

xt = max(x+lambda*step,0);    
residt = real(ifft2(TF.*fft2(xt)))-gn; cft=cft+2;                   
ft = 0.5*residt(:)'*residt(:)+eta*0.5*xt(:)'*xt(:);
 
Ik = (x<=epsilonk & g0>0);
stept = lambda*step;
stept(Ik) = -(x(Ik)-xt(Ik));

while (ft >= f0+alpha*g0(:)'*stept(:));
    lambda = lambda*beta;
    xt = max(x+lambda*step,0); 
    residt = real(ifft2(TF.*fft2(xt)))-gn; cft=cft+2;
    ft = 0.5*residt(:)'*residt(:)+eta*0.5*xt(:)'*xt(:);
    stept = lambda*step;
    stept(Ik) = -(x(Ik)-xt(Ik));
    iarm = iarm+1;
    if iarm > maxarm
        void = 1;
        return;
    end
end  % end line search

