function [xt,void,cft] = ...
    armijo_NCGP(x,step,f0,g0,data,fun_params,epsilonk) 
%ARMIJO_NCGP   Armijo rule along the projection arc.
%   ARMIJO_NCGP computes the new NCGP iterate using the Armijo rule along
%   the projection arc for the step-length computation.
%
%   [XT]=ARMIJO_NCGP(X,STEP,F0,G0,DATA,FUN_PARAMS,EPSILONK)
%   returns the new NCGP iterate XT. X is the current iterate. STEP is the
%   search direction. F0 is the cost function at the current iterate and G0
%   is its gradient. DATA is a structure array with the problem data. 
%   FUN_PARAMS is a structure array with the objective function data. 
%   EPSILONK is the parameter for the set Ik. 
%
%   [XT,VOID]=ARMIJO_NCGP(X,STEP,F0,G0,DATA,FUN_PARAMS,EPSILONK)
%   also returns a parameter VOID:
%    0 the line search terminates successfully
%    1 the line search terminates after 50 backtracks without determining 
%    a new iterate.
%
%   [XT,VOID,CFT]=ARMIJO_NCGP(X,STEP,F0,G0,DATA,FUN_PARAMS,EPSILONK)
%   also returns the number CFT of performed ffts.

%   D. P. Bertsekas. On the Goldstein-Levitin-Poljak Gradient Projection 
%   Method. IEEE Transcations on Automatic Control, 21(2):174184, 1976

cft = 0;
maxarm = 50;
iarm = 1;
void = 0;
lambda = 1; 
alpha = 1e-4;
beta = 0.5;

fun_obj = fun_params.obj;
xt = max(x+lambda*step,0);
ft = feval(fun_obj,xt,fun_params,data); 

Ik = (x<=epsilonk & g0>0);
stept = lambda*step;
stept(Ik) = -(x(Ik)-xt(Ik));

while (ft >= f0+alpha*g0(:)'*stept(:))  ;
    lambda = lambda*beta;
    xt = max(x+lambda*step,0); 
    ft = feval(fun_obj,xt,fun_params,data);
    stept = lambda*step;
    stept(Ik) = -(x(Ik)-xt(Ik));
    iarm = iarm+1;
    if iarm > maxarm
        void = 1;
        return;
    end
end % end line search


