function [x,y,w]=omelyan_solovyan_rule(N)

%-------------------------------------------------------------------------------
% USAGE of "omelyan_solovyan_rule".
%
% [x,y,w] = omelyan_solovyan_rule(N)
%
% Compute nodes and weights of Omelyan-Solovyan rule of degree N choosen
% in 15, 17, 19, 21, 23.
%
% See also:
%
% I. P. Omelyan, V. B. Solovyan.
% Improved cubature formulae of high degrees of exactness for the square
% Journal of Computational and Applied Mathematics archive
% Volume 188 ,  Issue 2  Pages: 190 - 204, (2006).
%-------------------------------------------------------------------------------
% INPUT.
% N : degree of a Omelyan-Solovyan rule. Choose N=15, 17, 19, 21, 23.
%
% OUTPUT.
% x : Omelyan-Solovyan nodes (abscissas)
% y : Omelyan-Solovyan nodes (ordinates)
% w : Omelyan-Solovyan weights
%-------------------------------------------------------------------------------

%-------------------------------------------------------------------------------
% FUNCTIONS CALLED BY THIS CODE:
% calls    : no external routine is used by this code
%-------------------------------------------------------------------------------
% Authors:  
%          Marco Caliari     <marco.caliari@univr.it>
%          Stefano De Marchi <demarchi@math.unipd.it>   
%          Alvise Sommariva  <alvise@math.unipd.it>
%          Marco Vianello    <marcov@math.unipd.it>   
%
% Date: November 2009.
%-------------------------------------------------------------------------------

if (N ~= 15) & (N ~= 17) & (N ~= 19) & (N ~= 21) & (N ~= 23)
    disp('\n \t Warning: Set N=15 in Omelyan-Solovyan rule.');
    N=15;
end    
    
switch N
    
case 15

wxy=[0.20881470204497523521771058289754E-1,...
0.98798456650771809034922121236542,...
0.77126821223875533899886933446485;...
0.25545901574497276542640153395248E-1,...
0.90815949600657000212015099547736,...
0.95703183434690690872237176442598;...
0.31203866624933300871149690867662E-1,...
0.67928365833453304991325391003325,...
0.88260197593087253601344445274335;...
0.38010761595074827467645518285610E-1,...
0.50911373411758353514778637359508,...
0.97120312974183699854692313856226;...
0.41449061852426148002787373214871E-1,...
0.97675332466910190352385200798077,...
0.83559862608781647288448365846813E-1;...
0.79320407004083334044710201039891E-1,...
0.75619936719149244012005066365912,...
0.75619936719149244012005066365912;...
0.88901265758751523303980720079987E-1,...
0.89778569328633877480008574782677,...
0.46676265923796434848237353795400;...
0.12016982158206027507823569713056,...
0.20599307074252141729418963873618,...
0.84079448454078540426562160968883;...
0.16882043410639799754153511014621,...
0.45144312511299139017533875886564,...
0.56245686233219940637540066298377;...
0.16987162497336185160489786440053,...
0.66683824538360873834071399129626,...
0.19046630243571720761679616635243;...
0.21582538472391594202064661314968,...
0.74295704755765822553432311307323E-1,...
0.32397702249753019818251854432752];

w_c=wxy(:,1); x_c=wxy(:,2); y_c=wxy(:,3);

w=[w_c; w_c; w_c; w_c];
x=[x_c; -y_c; -x_c; y_c];
y=[y_c; x_c; -y_c; -x_c];

case 17
    
wxy=[ 0.10693483986974526468925667171638E-1	0.83395914422050762595707520328329	0.99690134998258294114169765276688
0.16771622989325482379964908559201E-1	0.96701240760377864958940778776159	0.92101565015369642619085740576658
0.21520834803173017585623196363995E-1	0.98651441086033068583570701960810	0.56251780244667252352153081833715
0.24893201532665059892584476318209E-1	0.17035060808995408160378979789427E-1	0.98204914256843033449712481990261
0.42463258472030940473501779894230E-1	0.42523896522453030941022314252505	0.95796453236865195741899809390262
0.53711265037645010830029221647514E-1	0.88194109089215356624316729768736	0.74117688569732509081061208741447
0.54579479693382460849318673206721E-1	0.69978907719058600912388980227382	0.88728024293255774907349992409998
0.67375653622461385504403959336007E-1	0.90858412958838344797723547617253	0.25843122151820770173022364732347
0.98025282885102299426881768287454E-1	0.73933759205292015806620475085721	0.47295583257297618882242532468520
0.98325651584666601742691443856667E-1	0.21246155837885419289305793553062	0
0.10576898319665727200249259468733	0.15644172095846342514322716437912	0.81259212523912311994061744159953
0.10593453574575401283483020818374	0.50398563819427997044830482422504	0.68201093297792530795370853308359
0.14990405484916921950315250394890	0.58243895074467257078462336257058	0.11846544560647891209927499369579
0.15003269160099271050559959853839	0.28970323065541272212557470108155	0.40876985953794338411643329876836];

w_c=wxy(:,1); x_c=wxy(:,2); y_c=wxy(:,3);

w=[w_c; w_c; w_c; w_c];
x=[x_c; -y_c; -x_c; y_c];
y=[y_c; x_c; -y_c; -x_c];



case 19
    
    wxy=[ 0.42157189312457273371400997162954E-2	0.93790944060174636724164305692148	0.99998546072852907260205380652647
0.99237601014741223600089798896376E-2	0.59787966519157168521483636741590	0.98732847941781540087026300838966
0.15078678879581549295330034135223E-1	0.96865781747798834472115427804246	0.89837495163532572964949889543009
0.15121496864822956266676863866018E-1	0.98871713276447330663578670732177	0.62259634389530287767136776393609
0.23821621047339582724750103846036E-1	0.98398534132338386681313796251589	0.81109463487824943619725131193050E-1
0.28746437252189671047629194361029E-1	0.36585775934555586089438861852973	0.96462400422891970516096923553526
0.31348715503861464721826917341708E-1	0.78392149176096602345110934186655	0.93756444544378175318295617860873
0.49762852666717116332578404045926E-1	0.86937144898957875204792277623522	0.74380866034597101765279618918913
0.55534775159604041101829554407116E-1	0.91889377777573801032232199904313	0.38410875822737883260638757649426
0.65013710432173970207381031565964E-1	0.14078396804456848628363687508206	0.87987957307981017658529064786666
0.73819068900731731823980126564345E-1	0.56379666815446526573028097449771	0.81879210607636015929368719928237
0.90385825968150641564727715959435E-1	0.76200274293070327698230061865243	0.15749920122732269808023356410127
0.91881833336425013923433485117405E-1	0.69745388342191267884442122044750	0.54657527460177776847334916572487
0.94967142638856099564605740671378E-1	0.52310392339404494392757182766006	0
0.10498174724102843457467466433826	0.30566836903929191370033838487568	0.65017670270687960549278395428873
0.11871336850928058424347422704556	0.44898642628288082765338494532756	0.34240465380680230945939322837053
0.12668324656651729290995285712867	0.98253418759835132805054567507033E-1	0.23509621629115532325303789785547];

w_c=wxy(:,1); x_c=wxy(:,2); y_c=wxy(:,3);

w=[w_c; w_c; w_c; w_c];
x=[x_c; -y_c; -x_c; y_c];
y=[y_c; x_c; -y_c; -x_c];

case 21
    
    wxy=[0.59245289910274777823163684444026E-2	0.99742844318071465788852153329446	0.52349333540342268677302187698119
0.63181879993530976749052313712955E-2	0.90092205722857715090631770295789	0.99213624611198765984022577926158
0.77654356771885822575525989789117E-2	0.98137581661152322617866583081353	0.93577766500519228442627576803182
0.13313236524649387539261801099149E-1	0.47562398846061921636952360049609	0.98806503981406364167006543205075
0.18028023632000303112294832251383E-1	0.68396217875524370909034162562144E-1	0.98289142121346795894575007552095
0.20759211084811453614957408545828E-1	0.96445171170290974019893928634261	0.73079564192792033198229729840349
0.24345594686962939048122829629801E-1	0.96789534067760540982739074113386	0.28416943704022564251542547384397
0.27291829813157459363923440908365E-1	0.71204626183902144323409345553631	0.95001737577395264422880843244573
0.31313724489320677669626239379042E-1	0.86686503563504933746419509606443	0.85754514904426211818642071770359
0.43028684463625497581941353350492E-1	0.29388895765490255861532312924984	0.91478375374420147743639913929870
0.47435107497760585342967184111271E-1	0.88245289720509646533706783064117	0.78310571319347967606817150072422E-1
0.49535232791099913534195616930148E-1	0.88356465549777630296872390851348	0.50650027819745540446699219481203
0.59086609737522776429493659734483E-1	0.53714330328796591598235477256257	0.82111662321535962574448188332070
0.61598898755573131953283218720393E-1	0.73297737278688849035966507531475	0.67811474157990352881988795983159
0.68662882737105569078247834904061E-1	0.74340815897994389367005251095709	0.25891212405917942502949658613377
0.77511025760449779132628565445376E-1	0.14352379867257862891820869134808	0.73714284444878233387764988974016
0.77655900861398148704502327066780E-1	0.57716374806487034338151001622839	0.42605137832252378501649531823938
0.84165159143253389201574044182295E-1	0.38010653105519745774291045326124	0.59190980196005469388929534014808
0.11664395742356559711226466539621	0.49380304750704567296572150088764	0.46968438389915362845722235027390E-1
0.12587077966701428595400393561138	0.23300694276964919884562248755586	0.27854054992870057594151995625227
0.13498395305263979164774737575571	0	0];

% ATTENTION: COUNT LAST ROW JUST ONCE!!!
w_c=wxy((1:end-1)',1); x_c=wxy((1:end-1)',2); y_c=wxy((1:end-1)',3);

w=[w_c; w_c; w_c; w_c];
x=[x_c; -y_c; -x_c; y_c];
y=[y_c; x_c; -y_c; -x_c];

w_end=wxy(end,1);

w=[w; w_end]; x=[x; 0]; y=[y; 0];

case 23
    
    wxy=[-0.22499144590180737573666435988313E-1	0.22475776435269587875683347524503	0.29562926123440075779470457695520
0.56757797279709720956600059513997E-2	0.87420793087689680287386901266229	0.99164484170232374329954582252223
0.61294541632385752564605990154598E-2	0.97602267261364022197431910391898	0.96038644389988149213812916422733
0.77307399716921584473393426863691E-2	0.98901025758028347071424940975698	0.79476170695439095037125111357424
0.79851030689059360294239183531451E-2	0.99326920924031633712313940841625	0.45269906826670511998507618989211
0.10747724909071103372536638574027E-1	0.56499592316621278816917834165965	0.98963443963546680882582623594845
0.14073722901914630236333688287280E-1	0.12479933234667809522764885071235	0.98891634511573107523317221688555
0.22950166656215871772211451659864E-1	0.90240439932034384398117518141661	0.86681747165850322502643568236158
0.23104503668552704581666880144042E-1	0.96603416099961004557874518675109	0.22128837983587450545659391256077
0.24886583460620943481070103801115E-1	0.74327403381257379390317209035852	0.93739279789140167477396439558006
0.25495608710781325077549951029551E-1	0.94397158234337348119479988763974	0.62734373811214363563025812471848
0.35148791457392415926700843453924E-1	0.36473593323821554671165638117641	0.93654053553190687038241524198386
0.39967612471275640012053163262252E-1	0.90025309287443275420616285586643	0.25070990341427951813078348104539E-1
0.42210906199290840139296408236284E-1	0.48034665839500246850252725186282E-1	0.65304687691990057591624038872149
0.45629308917602135087674549832202E-1	0.54919116214309328871373834754894	0
0.47184931543983842485535616621711E-1	0.86487537690899969927500100353866	0.42021700731140387645536924573814
0.48004360511784007777329600464972E-1	0.78769621309348012773202186731599	0.71486137179637184939863361570348
0.51407132281965816724265717022986E-1	0.57671028420945643394316234476328	0.82649643106250383189783444260321
0.54210495031621259406088939636629E-1	0.20013408262762044788586320030931	0.80824267349292209367541999626505
0.63980226470850872129000560206633E-1	0.74602728783032388650354427676695	0.20581981165646397971556679713472
0.71999854713967554049756153858067E-1	0.64177280458672645848207064078009	0.51516637687706181290564290685967
0.74130368424485001536304396403399E-1	0.40236411309752397363192555539035	0.64890781819854093908140818020446
0.87075597857073455631778823034765E-1	0.46993983120051570507268178090848	0.27714799151429808758023024246803
0.10080008323810791275764368651352	0.22491749438123049571812018957130	0.40375503517268762210602535023913
0.11197008823181576355998539793872	0.22831753386455276245209947736815	0.56116790982355323182358196190726E-1];
    
w_c=wxy(:,1); x_c=wxy(:,2); y_c=wxy(:,3);

w=[w_c; w_c; w_c; w_c];
x=[x_c; -y_c; -x_c; y_c];
y=[y_c; x_c; -y_c; -x_c];

end





