// Author:   Jeff Dicker
// For:      Dr. Yves Lucet
// Whatsit:  Unit tests for me_pe, me_pe2d

mode(-1);
__test_set = "ME PE";

function b = testpe_Quadratic1d()
//compare PE Moreau envelope algorithm with result
//computed manually for the function f(x)=x^2
	X=(1:4)';//primal grid
	f=X.^2;
	//PE algorithm on the primal grid
	n=length(f);result = me_pe(X(1),X(n),f);
	correct = [1;2;5;8];
	b = (correct == result);
endfunction

function b = testdirectvspe_Quadratic1d()
//compare results of nep and direct algorithm for the
//univariate function f(x)=x^2
	X = [1;1.2;1.4;1.6;1.8;2];//primal grid
	f=X.^2;
	//PE algorithm on the primal grid
	n=length(f);result = me_pe(X(1),X(n),f);
	correct = me_direct(X,f,X);
	//verify the result taking into account roundoff errors
	b = norm(correct - result) < 1E-10;
endfunction

function b = testPE()
//compare results of nep and direct algorithm for a
//random function
	X = [-10:0.5:10]';//primal grid
	f = rand(X);//random function
	n=length(f);desired = me_direct(X, f, X);
	result = me_pe(X(1), X(n), f);
	//verify the result taking into account roundoff errors
	b = norm(result - desired) < 1E-10
endfunction

function b = testdirect2dvspe2d_Quadratic()
//Compare direct with PE algorithm to compute the 
//Moreau envelope of the bivariate function
//f(x,y)=4*x^2+4*y^2
	Xr = (1:5)'; Xc = Xr; //primal grid
	Sr = Xr; Sc = Sr;//dual grid
	F = (4 .* (Xr.^2) * ones(1, size(Xr, 1))) + (ones(size(Xc, 1), 1) * (4 .* (Xc').^2));
	n=length(Xr);
	result = me_pe2d(Xr(1), Xr(n), Xc(1), Xc(n), F);
	correct = me_direct2d(Xr, Xc, F, Sr, Sc);	
	b = (correct == result);
endfunction

function b = testpe_QuadraticTwo()
//Compare direct with PE algorithm to compute the 
//Moreau envelope of the bivariate function
//f(x,y)=4*x^2+4*y^2
	Xr = (1:1.1:5)'; Xc = Xr; //primal grid
	Sr = Xr; Sc = Sr;//dual grid
	F = (4 .* (Xr.^2) * ones(1, size(Xr, 1))) + (ones(size(Xc, 1), 1) * (4 .* (Xc').^2));
	n=length(Xr);
	result = me_pe2d(Xr(1), Xr(n), Xc(1), Xc(n), F);
	correct = me_direct2d(Xr, Xc, F, Sr, Sc);
	//verify the result taking into account roundoff errors	
	b = norm(correct - result) < 1E-10;
endfunction

function b = testpe_QuadraticThree()
//Compare direct with PE algorithm to compute the 
//Moreau envelope of the bivariate function
//f(x,y)=x^2+y^2 on a primal grid with different stepsize
//between x and y
	hx=0.8;//stepsize for grid on x axis
	Xr = (-10:hx:10)'; 
	nx=length(Xr);
	hy=1;//stepsize for grid on y axis
	Xc = (-10:hy:10)'; 
	ny=length(Xc);
	function f=sqr(x,y),f=x.^2+y.^2,endfunction;
	//sample the function f on the grid X x Y
	[X, Y]=ndgrid(Xr,Xc);F=4 * sqr(X,Y);
	result = me_pe2d(Xr(1),Xr(nx), Xc(1),Xc(ny), F);
	correct = me_direct2d(Xr, Xc, F, Xr, Xc);
	//verify the result taking into account roundoff errors	
	b = norm(correct - result) < 1E-10;
endfunction


function b = runTestFile()
	b = %t
	b = checkForFail(testWrapper(testpe_Quadratic1d, "testpe_Quadratic1d"), b);
	b = checkForFail(testWrapper(testdirectvspe_Quadratic1d, "testdirectvspe_Quadratic1d"), b);
	b = checkForFail(testWrapper(testPE, "testPE"), b);	
	b = checkForFail(testWrapper(testdirect2dvspe2d_Quadratic, "testdirect2dvspe2d_Quadratic"), b);
	b = checkForFail(testWrapper(testpe_QuadraticTwo, "testpe_QuadraticTwo"), b);	
	b = checkForFail(testWrapper(testpe_QuadraticThree, "testpe_QuadraticThree"), b);	
endfunction
