// Original Author: Yves Lucet
// Author:          Jeff Dicker
// Whatsit:         Unit tests for lft_direct, lft_direct_d, lft_llt, lft_llt_d
// Date:            Summer 2005

mode(-1);
__test_set = "LLT: Linear Time Legendre Transform";

function b = testPartialConjugate_direct()
//compute the conjugate of a function going through (i,row(i))
//with lft_direct_d
	row = [1 2.5 5 8.5 13]';//values of the function on {1,2,3,4,5}
	conj_part = lft_direct_d(row);//conjugate computation
	b = isequal(conj_part, [0 1.5 4 7.5 12]');//verify the result
endfunction

function b = testQuadratic_direct()
//conjugate of the energy function f(x)=x^2/2
//with lft_direct
	X = [1:1:10]';//primal grid
	Y = 0.5.*(X.^2);//sample the function on X
	//compute the conjugate with dual grid = primal grid
	[Conj] = lft_direct(X, Y, X);
	// Check that the conjugate of the energy function is itself
	b = isequal(Y, Conj);
endfunction

function b = testPartialConjugate_llt()
//compute the conjugate of a function going through (i,row(i))
//with lft_llt
	row = [1 2.5 5 8.5 13]';//values of the function on {1,2,3,4,5}
	conj_part = lft_llt_d(row);//conjugate computation
	b = isequal(conj_part, [0 1.5 4 7.5 12]');//verify the result
endfunction

function b = testQuadratic_llt()
//conjugate of the energy function f(x)=x^2/2
//with lft_llt
	X = [1:1:10]';//primal grid
	Y = 0.5.*(X.^2);//sample the function on X
	//compute the conjugate with dual grid = primal grid
	[Conj] = lft_llt(X, Y, X);	
	// Check that the conjugate of the energy function is itself
	b = isequal(Y, Conj);
endfunction

function b = testCompareDirectandLLT()
//compare lft_llt with lft_direct when computing
//the conjugate of discrete data 
	X = [1:1:10]';//primal grid
	Y = [34 3 1 15 13 12 22 30 32 58]';//values of an ungiven function on X
	ConjA = lft_llt(X, Y, X);//result with llt algorithm
	ConjB = lft_direct(X, Y, X);//result with direct algorithm (quadratic)
	b = isequal(ConjA, ConjB);//verify the result
endfunction

function b = testCompareDirectandLLTandFusion()
//compare lft_llt with option fusion,  lft_llt with option fusionsci, 
//and lft_direct when computing the conjugate of discrete data 
	X = [1:1:10]';//primal grid
	Y = [34 3 1 15 13 12 22 30 32 58]';//values of an ungiven function on X
	ConjA = lft_llt(X, Y, X);//result with llt algorithm option fusionsci
	ConjAa= lft_llt(X, Y, X,1);//result with llt algorithm option fusion
	ConjB = lft_direct(X, Y, X);//result with direct algorithm (quadratic)
	b = isequal(ConjA, ConjB) & isequal(ConjA, ConjAa);//verify the result
endfunction

//runs all the above unit test functions
function b = runTestFile()
	b = %t;
	b = checkForFail(testWrapper(testPartialConjugate_direct, "testPartialConjugate_direct"), b);
	b = checkForFail(testWrapper(testQuadratic_direct, "testQuadratic_direct"), b);	
	b = checkForFail(testWrapper(testPartialConjugate_llt, "testPartialConjugate_llt"), b);
	b = checkForFail(testWrapper(testQuadratic_llt, "testQuadratic_llt"), b);
	b = checkForFail(testWrapper(testCompareDirectandLLT, "testCompareDirectandLLTandFusion"), b);
endfunction
