// Author:   Jeff Dicker
// For:      Dr. Yves Lucet
// Whatsit:  Unit tests for bb
//
// Test-script for the Linear-time Legendre Transform (Yves Lucet - 09/05/97)
// updated for Octave 2.1.53 (Yves Lucet - 11/18/04)
//
// Modified by Jeff Dicker to work with a) scilab, and b) the unit test
// platform he created - 05/06/2005
//
__test_set = "BB: Beneath and Beyond";
mode(-1);

// unit tests ==========================================================
function b = testConvexHullSet()
//tests that the convex envelope of a convex set is itself
	//planar convex set (paramSetX(i),paramSetY(i))
	paramSetX = [1 2 3  4   5 6 7]';//x-coordinates
	paramSetY = [8 4 2 1.5  2 4 8]';//y-coordinates
	//computes the convex envelope
	[convexSetX, convexSetY] = bb(paramSetX, paramSetY)
	// since paramSet is convex, they should be equal
	b = isequal(paramSetX, convexSetX)
	b = checkForFail(isequal(paramSetY, convexSetY), b)
endfunction

function b = testNonConvexHullSet()
//tests bb on a nonconvex set
	//planar convex set (paramSetX(i),paramSetY(i))
	paramSetX = [1 2 3 4 5 6 7 8]';//x-coordinates
	paramSetY = [8 5 2 1 9 2 4 9]';//y-coordinates
	//convex hull of the paramSet
	wantedSetX = [1 3 4 6 7 8]';//x-coordinates
	wantedSetY = [8 2 1 2 4 9]';//y-coordinates
	//computes the convex envelope
	[convexSetX, convexSetY] = bb(paramSetX, paramSetY)
	// verify that convexSet is the same as wantedSet
	b = isequal(wantedSetX, convexSetX)
	b = checkForFail(isequal(wantedSetX, convexSetX), b)
endfunction

function b = testNonConvexHullFunction()
//tests bb on a nonconvex set built from sampling a function
	function y=f(x), y=(x.^2-1).^2;endfunction
	//build the planar convex set (X(i),Y(i))
	X=linspace(-2,2,50)';//x-coordinates as a column vector
	Y=f(X);//y-coordinates.

	//the function f is nonconvex between -1 and 1
	//so the verteces of its convex hull include all points except 
	//those between -1 and 1.
	Xind=find(X<=-1 | X >= 1);//indices of points where f is convex
	//lower convex hull of the set (X(i),Y(i)) is (wantedX(i),wantedY(i))
	wantedSetX=X(Xind);wantedSetY=Y(Xind);

	//computes the convex envelope
	[convexSetX, convexSetY] = bb(X,Y);
	// verify that convexSet is the same as wantedSet
	b = isequal(wantedSetX, convexSetX)
	b = checkForFail(isequal(wantedSetX, convexSetX), b)
endfunction

//runs all the above unit test functions
function b = runTestFile()
	b = %t	
	r = testWrapper(testConvexHullSet, "testConvexHullSet");
	b = checkForFail(r, b);
	r = testWrapper(testNonConvexHullSet, "testNonConvexHullSet");
	b = checkForFail(r, b);
	r = testWrapper(testNonConvexHullFunction, "testNonConvexHullFunction");
	b = checkForFail(r, b);
endfunction
