//demo file: Computes the Moreau envelope and the proximal mapping
//of the smooth nonconvex function f(x)=(x^2-1)^2
//on the interval [-1.5,1.5]
//Function demoed: me_direct
mode(-1);
clear ff
//Define the function whose transforms will be computed
function f=ff(x),f=(x.^2-1).^2,endfunction

X=(-1.5:0.05:1.5)';//grid on which to evaluate the function
S=X;//Select the dual grid to be the same as the primal grid
n=length(X);m=length(S);
//evaluate the function on the grid. If your function does
//not allow for vector input, use the feval function.
f=ff(X);
//Computes the Moreau envelope
[M,p] = me_direct(X, f, S);

//plot the function f, and its moreau envelope M
scf(0);clf;
plot2d(X,[f,M]);h1=get("hdl");
labels=["f","M"];legends(labels,[1:size(labels,2)],opt="lr");
h2=get("hdl");
thickness=[2;1;1;1];line_style=[4;1;1;1];
for i=1:size(labels,2)
	h1.children(i).thickness=thickness(i);
	h1.children(i).line_style=line_style(i);
	h2.children(2*i).thickness=thickness(i);
	h2.children(2*i).line_style=line_style(i);
end
h1.parent.x_label.text="x";
h2.parent.y_label.text="f and M";
xtitle("Moreau envelope of a smooth nonconvex function");

//plot P the proximal mapping of f
scf(1);clf;
Pv=S(p);//convert from index to value
plot2d(S,Pv,style=-1);
plot2d(S,Pv);
xtitle(['Proximal Mapping'],'S','P');
