//demo file: Computes the Moreau envelope of the
//nonsmooth nonconvex function f(x)=||x|-1|
//on the interval [-2.5,2.5]
//Function demoed: me_direct

mode(-1);
clear ff
//Define the function whose transforms will be computed
function f=ff(x),f=abs(abs(x)-1),endfunction

X=(-2.5:0.25:2.5)';//define the grid on which to evaluate the function
S=X;//Select the dual grid to be the same as the primal grid
n=length(X);m=length(S);
//evaluate the function on the grid. If your function does
//not allow for vector input, use the feval function.
f=ff(X);
//Computes the Moreau envelope
[M,p,P] = me_direct(X, f, S);

//plot the function f, and its moreau envelope M
scf(0);clf;
plot2d(X,[f,M],rect=[X(1),min(f),X(length(X)),max(f)]);
p=get("hdl");
labels=["f","M"];legends(labels,[1:size(labels,2)],opt="ul");
q=get("hdl");
thickness=[2;1;1;1];line_style=[4;1;1;1];
for i=1:size(labels,2)
	p.children(i).thickness=thickness(i);
	p.children(i).line_style=line_style(i);
	q.children(2*i).thickness=thickness(i);
	q.children(2*i).line_style=line_style(i);
end
p.parent.x_label.text="x";
p.parent.y_label.text="f and M";
xtitle("Moreau envelope of a nonsmooth nonconvex function");

//plot P the proximal mapping of f
scf(1);clf;
clear Pv ;
Pv=matrix(S(P),n,m);//convert from index to value
Pvv=[Pv(1,1:10)';Pv(1,11);Pv(2,11);Pv(1,12:21)'];//manual fix to get nicer plot
Svv=[S(1:11);S(11:21)];
plot2d(Svv,Pvv,style=-1 * ones(1,m));
plot2d(Svv,Pvv);
xtitle(['Proximal mapping'],'S','P');
