//demo file: Illustrate the convergence of the
//Legendre-Fenchel conjugate of the absolute value
//function when the size of the intervals is increased.
//Function demoed: lft_direct

mode(-1);
S=(-10:1:10)';//dual grid is fixed
//consider 4 primal grids X1, X2, X3, X4 with increasing
//sizes. For each grid, the absolute value function is
//evaluated, and its conjugate computed.
X1=(-2:0.2:2)';f=abs(X1);C1 = lft_direct(X1, f, S);
X2=(-4:0.4:4)';f=abs(X2);C2 = lft_direct(X2, f, S);
X3=(-8:0.8:8)';f=abs(X3);C3 = lft_direct(X3, f, S);
X4=(-160:16:160)';f=abs(X4);C4 = lft_direct(X4, f, S);

//plot the conjugate computed on the 4 different grids
//showing that the conjugate converges to the indicator
//function of the interval [-1,1]
scf(0);clf;
plot2d([S S S S],[C1 C2 C3 C4],rect=[-3,-0.5,3,10]);
xtitle("Convergence of the discrete Legendre transform of the absolute value to the indicator of [-1,1]");
labels=["slopes in [-2,2]","slopes in [-4,4]","slopes in [-8,8]","slopes in [-160,160]"];
legends(labels,[1:size(labels,2)],opt="ul");