//demo file: Computes the lower convex envelope of the
//smooth nonconvex function f(x)=(x^2-1)^2 on the 
//interval [-2,2]
//Function demoed: bb
mode(-1);

X=[-2:0.5:2]';//grid on which to evaluate the function
Y=(X.^2-1)^2;//evaluate the function on the grid
[bbx,bby]=bb(X,Y);//compute the convex envelope
//plot the points ((X(i),Y(i)), and the verteces of the
//convex envelope.
scf(0);clf;
plot2d(X,Y,2,rect=[-3,-1,3,5]);
plot(X,Y,'squareblue');
plot(bbx,bby,'*red');
plot2d(bbx,bby,5);
xtitle("Lower convex envelope");
