/*
** MATRIXIO.C
**
** AUTHORS: 
**
**   Maria MORANDI CECCHI               Stefano DE MARCHI,            
**   University of Padua, Italy         University of Udine, Italy
**   email: mcecchi@math.unipd.it       email: demarchi@dimi.uniud.it
**   
**                       Damiano FASOLI
**                       Verona Software Srl, Italy 
**                       email: vrsoft@sis.it
**
**
**
** REVISION DATE: May, 1999  
**
** MODULES CALLED: None 
**
** --------------------------------------------------------------------------
**
** SUBROUTINES AND FUNCTIONS DESCRIPTION:
**
** >>>>>>>>>>>>>>>>>
**
** int getmat (int nrow,int nclm,double* puntmat,int matclm)
**
** This function reads from the standard input
** a matrix of 'nrow' rows and 'nclm' columns. It requires the
** exact number of columns of the matrix, i.e. 'matclm', 
** since it needs to know where
** a new row starts (matrices are visited by rows in C language). 
** The matrix is handled by means of the parameter 'puntmat' which 
** is a pointer to the matrix.
** Note: the elements of the matrix may be separated by any combination 
** of spaces, tabs and carriage returns in the input format.
**
** The macro mat(i,j) allows this function to handle the element placed is
** the i-th row and in the j-th column of the matrix pointed by puntmat.
** 
** Inputs:
**        nrow, nclm: number of rows and columns in matrix puntmat;
**        puntmat: the matrix;
**        matclm: the exact number of columns of the matrix.
**
** Function result:
**        'getmat==0': all is OK
**        'getmat==1': the matrix has too many columns (more than 'matclm').
**
** >>>>>>>>>>>>>>>>>
** 
** int putmat(int nrow,int nclm,double* puntmat,int matclm,int amp,int prec)
**
** This function writes to the standard output
** a matrix of 'nrow' rows and 'nclm' columns. It requires 
** the exact number of columns, i.e. 'matclm', since it needs 
** to know where a new row starts (matrices are visited by rows in C language).
** The matrix is handled by means of the parameter 'puntmat' which is a pointer
** to the matrix. 
** Input parameters 'amp' and 'prec' are the width of output field and the decimal
** precision of the matrix elements. Rows are separated by carriage returns in
** the output representation. 
**
** The macro mat(i,j) allows this function to handle the element placed in
** the i-th row and in the j-th column of the matrix pointed by 'puntmat'.
**
** Inputs:
**        nrow, nclm: number of rows and columns in matrix puntmat;
**        puntmat: the matrix;
**        matclm: the exact number of columns of the matrix;
**        amp: the width of output field;
**        prec: the decimal precision of the matrix elements.
**
** Function result:
**        'putmat==0': all is OK
**        'putmat==1': there are too many columns (more than 'matclm').
**
** >>>>>>>>>>>>>>>>>
** 
** int fputmat(FILE* file,int nrow,int nclm,double* puntmat,int matclm,
**             int amp,int prec)
**
** This function writes to an output file, specified by the 'file' parameter,
** a matrix of 'nrow' rows and 'nclm' columns. It requires 
** the real number of columns, i.e. 'matclm', since it needs to know where a
** new row starts (matrices are visited by rows in C language).
** The matrix is handled by means of the parameter 'puntmat' which is a pointer
** to the matrix. 
** Input parameters 'amp' and 'prec' are whe width of output field and the decimal
** precision of the matrix elements. Rows are separated by carriage returns in
** the output representation. 
**
** The macro mat(i,j) allows this function to handle the element placed in
** the i-th row and in the j-th column of the matrix pointed by puntmat.
**
** Inputs:
**        file: the name of the file where to store the matrix;
**        nrow, nclm: number of rows and columns in matrix puntmat;
**        puntmat: the matrix;
**        matclm: the exact number of columns of the matrix;
**        amp: the width of output field;
**        prec: the decimal precision of the matrix elements.
**
** Function result:
**        'fputmat==0': all is OK
**        'fputmat==1': there are too many columns (more than 'matclm').
**
** >>>>>>>>>>>>>>>>>
** 
** int copymatrix(int nrow,int nclm,double* puntmat,double* puntmatnew,
**                int matclm)
**
** This function copies the matrix 'puntmat' 
** which is 'nrow' x 'nclm' (rows and columns) and has exact 
** number of columns 'matclm' , onto the matrix 'puntmatnew' 
** which must have at least 'nrow' rows and exactly 'matclm' columns.
** 
** The macros mat(i,j) and matnew(i,j) allow this function to handle 
** the elements placed in the i-th row and in the j-th column of the 
** matrices pointed by 'puntmat' and 'puntmatnew'.
** 
** Inputs:
**        nrow, nclm: number of rows and columns in matrix puntmat;
**        puntmat: the matrix;
**        puntmatnew: the matrix where to copy 'puntmat';
**        matclm: the exact number of columns of the matrix;
**
** Function result:
**       'copymatrix==0': all is OK;
**       'copymatrix==1': nclm<0 or nclm>matclm.
**
** --------------------------------------------------------------------------
*/

#include <math.h>
#define mat(i,j) *(puntmat+(i)*matclm+(j))    /* macro used by getmat,putmat */
					      /* macro used by copymatrix */
#define matnew(i,j) *(puntmatnew+(i)*matclm+(j)) /* macro used by copymatrix */

int getmat (nrow,nclm,puntmat,matclm)
int nrow,nclm,matclm;
double *puntmat;
 {
 int i,j;

 if (nclm > matclm)
   return 1;
 for(i=0;i<nrow;++i)
  for(j=0;j<nclm;++j)
  {
   scanf(" %lf",&mat(i,j));
  }
  return 0;
 }

int putmat(nrow,nclm,puntmat,matclm,amp,prec)
int  nrow,nclm,matclm,amp,prec;
double *puntmat;
{
 int i,j;

 if (nclm > matclm)
   return 1;
 printf("\n");
 for(i=0;i<nrow;++i)
 {
  for(j=0;j<nclm;++j)
    printf("%*.*f",amp,prec,mat(i,j));
  printf("\n");
 }
 printf("\n");
 return 0;
}

int fputmat(file,nrow,nclm,puntmat,matclm,amp,prec)
FILE *file;
int  nrow,nclm,matclm,amp,prec;
double *puntmat;
{
 int i,j;

 if (nclm > matclm)
   return 1;
 for(i=0;i<nrow;++i)
 {
  for(j=0;j<nclm;++j)
    fprintf(file,"%*.*f",amp,prec,mat(i,j));
  fprintf(file,"\n");
 }
 return 0;
}

int copymatrix(nrow,nclm,puntmat,puntmatnew,matclm)
int nrow,nclm,matclm;
double *puntmat,*puntmatnew;
{
int i,j;

if (nclm < 0 || nclm > matclm)
 return 1;
for (i=0;i<nrow;++i)
 for (j=0;j<nclm;++j)
  matnew(i,j)=mat(i,j);
return 0;
}
















