/*
** INFO_VIC.C
**
** AUTHORS: 
**
**   Maria MORANDI CECCHI               Stefano DE MARCHI,            
**   University of Padua, Italy         University of Udine, Italy
**   email: mcecchi@math.unipd.it       email: demarchi@dimi.uniud.it
**   
**                       Damiano FASOLI
**                       Verona Software Srl, Italy 
**                       email: vrsoft@sis.it
**
**
**
** REVISION DATE: May, 1999  
**
** MODULES CALLED: NONE
**
** ---------------------------------------------------------------------
**
**
** SYNOPSIS: info_vic file1
**
** This program computes the maximum and the mean 
** number of neighbouring nodes for a triangulation.
**
** 'file1' is the triangulation data file in the format generated by the
** program 'do_trian'. The file has three sections. 
** The first, starting with a single capital letter `C' in the first row, 
** lists in subsequent blocks separated by -1 the index of
** a node and those of its neighbours in a counterclockwise
** order. 
** Note: this program uses only this first section and the heading of the
** second section, that is a single capital letter `B' in the row.
**
*/

#include <stdio.h>

int main(argc,argv)
int argc;
char *argv[];
{
  int N_C,N_C_MAX;
  long int temp_index, first_index;
  long int sum,n;
  FILE *trifile;

if (argc==1)
{
 printf(
 "Start the program with the name of a triangulation file as parameter.\n");
 return 1;
}
sum=0; n=0; N_C_MAX=0;
trifile=fopen(argv[1],"r");
if (trifile==NULL)
{
 printf("Cannot open file %s.\n",argv[1]);
 return 1;
}
if (fgetc(trifile)!='C')
{
 printf("File %s in a no correct format.\n",argv[1]);
 return 1;
}
fgetc(trifile); /* skipping carriage return */
while (fgetc(trifile)!='B')
{
  fseek(trifile,-1,SEEK_CUR);
  N_C=0;
  fscanf(trifile," %ld ",&temp_index); N_C++; /* Skipping base node */
  fscanf(trifile," %ld ",&first_index); N_C++; /* There is at least 1 neigh. node */
  fscanf(trifile," %ld ",&temp_index);
  while (temp_index!=-1)
  {
   N_C++;
   fscanf(trifile," %ld ",&temp_index);
  if (temp_index==first_index)
    {
     N_C--; /* N_C does not consider the repetition of the first neighbouring node */
    }
  }  /* End while of neighbouring nodes reading */
  sum=sum+N_C; n++;
  if (N_C_MAX<N_C) N_C_MAX=N_C;
}
fclose(trifile);
printf("Number of nodes: %ld\n",n);
printf("Maximum number of nodes in a cell: %d\n",N_C_MAX);
printf("Medium number of nodes in a cell: %f\n",(double)sum/(double)n);
return 0;
}








