/*
** GEN_RAND.C
**
** AUTHORS: 
**
**   Maria MORANDI CECCHI               Stefano DE MARCHI,            
**   University of Padua, Italy         University of Udine, Italy
**   email: mcecchi@math.unipd.it       email: demarchi@dimi.uniud.it
**   
**                       Damiano FASOLI
**                       Verona Software Srl, Italy 
**                       email: vrsoft@sis.it
**
**
**
** REVISION DATE: May, 1999  
**
** MODULES CALLED: NONE
**
** ---------------------------------------------------------------------
**
** SYNOPSIS:  gen_rand file1 [-o2]
**
** The program computes user-defined or random (x,y,z) points and 
** stores them in 'file1'.
**
** After started, the program uses a simple script that accepts 
** three commands:
**
** 1) random - to compute N random points between [xmin,xmax], [ymin,ymax]
**             and [zmin,zmax]. 
**             Input values: N,xmin,xmax,ymin,ymax,zmin,zmax.
**
** 2) input  - to allow the user to introduce N points. 
**             Input value: N.
**
** 3) exit   - to quit the program. 
**
** The optional second argument -o2 allows to use 2-dimensional (x,y) points
** instead of 3-dimensional (x,y,z) points.
**
** User-defined input values may be separated by any combinations of spaces, 
** tabs and carriage returns.   
** The format of the output is handled by the two constants WIDTH and PREC
** that are the width of the output field, and the number of decimal digits.      
**
** ---------------------------------------------------------------------------------
**
** FUNCTIONS AND SUBROUTINES
**
** >>>>>>>>>>>>>>>>
**
** void gen_rand(FILE* id_file,int mode)
**
** This function prompts the user for the number of points 
** to be randomly generated, N,
** and for the bounds of their (x,y)-coordinates if 'mode==0' or 
** (x,y,z)-coordinates if 'mode==1'. Then it computes N random 
** (x,y)-points if 'mode==0' or (x,y,z)-points if 'mode==1' 
** and stores them to the text file 'id_file'.
**
** >>>>>>>>>>>>>>>> 
**
** void do_input(FILE* id_file,int mode)
**
** This function prompts the user for the number of points to be introduced, N, 
** and waits for the N (x,y)-points if 'mode==0' (or for 
** the N (x,y,z)-points if mode==1) and stores them to the text file specified by
** 'id_file'.
**
** Input values may be separated by any combinations of spaces, 
** tabs and carriage returns. 
**
** Output format is handled by the two constants WIDTH and PREC
** that are the width of the output field, and the number of decimal digits. 
**
** ----------------------------------------------------------------------------------
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#define BUFFER_LENGHT 50
#define WIDTH 20   /* Format output width of real numbers written to files */
#define PREC 10    /* Decimal precision width of real numbers written to files */

void gen_rand(),do_input();

int main(argc,argv)
int argc;
char *argv[];
{
 FILE *id_file;
 char buffer_comandi[BUFFER_LENGHT];
 int write_mode=0;
 /*
 ** write_mode==0: tridimensional data in output
 ** write_mode==1: bidimensional data in output
 */

 if (argc==1)
   {
    printf("Start the program with the following parameters:\n");
    printf("First parameter: data file name to create.\n");
    printf("Second parameter: -o2        - x-y data.\n");
    printf("                   (default) - x-y-z data.\n");
    return 0;
   }
 /* opening file */
 id_file=fopen(argv[1],"w");
 if (id_file==NULL)
  {
   printf("Cannot open file: %s\n",argv[1]);
   exit(1);
  }
 printf("\nChoose one of the following commands:\n");
 printf("random   : random data with specified parameters.\n");
 printf("input    : user data.\n");
 printf("exit     : quit program.\n\n");
 if (argc>=3) if (strcmp(argv[2],"-o2")==0) write_mode=1;
 do
  {
   printf(">");
   scanf("%s",buffer_comandi);
   if (strcmp(buffer_comandi,"random")==0) gen_rand(id_file,write_mode);
   if (strcmp(buffer_comandi,"input")==0) do_input(id_file,write_mode);
  }
 while (strcmp(buffer_comandi,"exit"));
 fclose(id_file);
 return 0;
}

void gen_rand(id_file,mode)
FILE *id_file;
int mode;
{
 double x,y;
 double xmin,xmax,ymin,ymax,zmin,zmax,tempx,tempy,tempz;
 long int num_punti,i;

 printf("\nWrite the number of random points to create:\n");
 scanf("%ld",&num_punti);
 printf("Minimum and Maximum value for the x coordinate:\n");
 scanf("%lf %lf",&xmin,&xmax);
 printf("Minimum and Maximum value for the y coordinate:\n");
 scanf("%lf %lf",&ymin,&ymax);
 if (mode==0)
 {
  printf("Minimum and Maximum value for the z coordinate:\n");
  scanf("%lf %lf",&zmin,&zmax);
 }
 tempx=(xmax-xmin)/(double) (RAND_MAX);
 tempy=(ymax-ymin)/(double) (RAND_MAX);
 if (mode==0) tempz=(zmax-zmin)/(double) (RAND_MAX);
 for (i=1;i<=num_punti;i++)
 {
  if (mode==0)
  fprintf(id_file,"%*.*f %*.*f %*.*f\n",
          WIDTH,PREC,xmin+tempx*rand(),
	  WIDTH,PREC,ymin+tempy*rand(),
	  WIDTH,PREC,zmin+tempz*rand() );
  if (mode==1)
  fprintf(id_file,"%*.*f %*.*f\n",
	  WIDTH,PREC,xmin+tempx*rand(),
	  WIDTH,PREC,ymin+tempy*rand() );
 }
 printf("\n");
}

void do_input(id_file,mode)
FILE *id_file;
int mode;
{
 double x,y,z;
 long int num_punti,i;

 printf("\nNumber of points: ");
 scanf("%ld",&num_punti);
 for (i=1;i<=num_punti;i++)
 {
  if (mode==0)
  {
   scanf("%lf %lf %lf",&x,&y,&z);
   fprintf(id_file,"%*.*f %*.*f %*.*f\n",
	   WIDTH,PREC,x,WIDTH,PREC,y,WIDTH,PREC,z);
  }
  if (mode==1)
  {
   scanf("%lf %lf",&x,&y);
   fprintf(id_file,"%*.*f %*.*f\n",WIDTH,PREC,x,WIDTH,PREC,y);
  }
 }
 printf("\n");
}





