/*
** CLT_D_A.C 
**
** AUTHORS: 
**
**         Damiano FASOLI and Maria MORANDI CECCHI
**         University of Padua, Italy
**         
**         Stefano DE MARCHI,
**         University of Udine, Italy
**
**
** REVISION DATE : May, 1999  
**
** MODULES CALLED: None 
**
** -------------------------------------------------------------------------
**
** SUBROUTINES AND FUNCTIONS DESCRIPTION:
**
** >>>>>>>>>>>>>>>>
**
** double derivecptclt_v(int i,int j)
**
** GLOBAL VARIABLES USED: u1,v1,u2,v2,u3,v3,t1,t2,t3
** t1,t2,t3 must be computed externally as:
**	 t1= ((u4-u1)*(u2-u1)+(v4-v1)*(v2-v1))/
**	     (pow((u2-u1),2.)+pow((v2-v1),2.));
**	 t2= ((u4-u2)*(u3-u2)+(v4-v2)*(v3-v2))/
**	     (pow((u3-u2),2.)+pow((v3-v2),2.));
**	 t3= ((u4-u3)*(u1-u3)+(v4-v3)*(v1-v3))/
**	     (pow((u1-u3),2.)+pow((v1-v3),2.));
** 
** This function computes the derivatives of the control points
** d_i (i=1,...,19)
** of the Clough-Tocher element as a function of the unknown partial
** derivatives q1x,q1y,q2x,q2y,q3x,q3y with respect to the j-th partial
** derivative in the above order from 0 to 5. 
**
** The triangle over which the function operates is described by the
** vertices (u1,v1), (u2,v2), (u3,v3).
**
**
** >>>>>>>>>>>>>>>>
** 
** double compute_d_j_clt(int j,int i)
**
** GLOBAL VARIABLES USED: q1,q2,q3,u1,v1,u2,v2,u3,v3,t1,t2,t3
** t1,t2,t3 must be computed externally as:
**	 t1= ((u4-u1)*(u2-u1)+(v4-v1)*(v2-v1))/
**	     (pow((u2-u1),2.)+pow((v2-v1),2.));
**	 t2= ((u4-u2)*(u3-u2)+(v4-v2)*(v3-v2))/
**	     (pow((u3-u2),2.)+pow((v3-v2),2.));
**	 t3= ((u4-u3)*(u1-u3)+(v4-v3)*(v1-v3))/
**	     (pow((u1-u3),2.)+pow((v1-v3),2.));
**
** This function computes the control points d_j (j=1,...,19) of the
** Clough-Tocher element.
**
** To the unknown parameters q1x,q1y,q2x,q2y,q3x,q3y 
** we assign the value given by the i-th vector of the
** canonical basis of R^6.
** (In the body of the function the vectors of the canonical basis are
** described by e0, e1, ..., e5). 
**
** The triangle over which the function operates is described by the
** vertices (u1,v1), (u2,v2), (u3,v3).
**
** The parameters q1,q2,q3 are the values of the triangular patch relative
** to the vertices V1,V2,V3, that are, by end-point interpolation, the
** values of the control points d1,d2,d3. 
**
**
** >>>>>>>>>>>>>>>>
**
** double compute_d_j_clt_null(int j)
**
**
** GLOBAL VARIABLES USED: q1,q2,q3,t1,t2,t3 
** t1,t2,t3 must be computed externally as:
**	 t1= ((u4-u1)*(u2-u1)+(v4-v1)*(v2-v1))/
**	     (pow((u2-u1),2.)+pow((v2-v1),2.));
**	 t2= ((u4-u2)*(u3-u2)+(v4-v2)*(v3-v2))/
**	     (pow((u3-u2),2.)+pow((v3-v2),2.));
**	 t3= ((u4-u3)*(u1-u3)+(v4-v3)*(v1-v3))/
**	     (pow((u1-u3),2.)+pow((v1-v3),2.));
** 
** This function computes the control points d_j (j=1,..,19) of the
** Clough-Tocher element.
** To the unknown parameters q1x,q1y,q2x,q2y,q3x,q3y it assignes the 
** value 0.
**
** The triangle over which the function operates is described by the
** vertices (u1,v1), (u2,v2), (u3,v3).
**
** The parameters q1,q2,q3 are the values of the triangular patch relative
** to the vertices V1,V2,V3, that are, by end-point interpolation, the
** values of the control points d1,d2,d3. 
**
** 
** >>>>>>>>>>>>>>>>
**
** double sum_cpt1_prod(double b[], double c[])
**
** This function computes the sum of the control points of the product
** of two linear triangular polynomial patches. 
**
** Their control points are stored in the arrays 'b' and 'c' using 
** the indexes 0 up to 2 according to the order of visit of the 
** corresponding tridimensional indexes 'rst' (used by b_rst and c_rst) 
** ordered first with respect to r and, later, with respect to s 
** (that is 001,010,100). 
**
** In the body of the function we use the symbol 'a' for the product patch.
**
**
** ------------------------------------------------------------------------
*/

extern double u1,v1,u2,v2,u3,v3,q1,q2,q3,t1,t2,t3;

double derivecptclt_v(i,j)
int i,j;
{
 /* Beginning of derivation by lookup table */
 if (i==1)     /* d1 */
 {
  return(0.);
 }
 else if (i==2)     /* d2 */
 {
  return(0.);
 }
 else if (i==3)     /* d3 */
 {
  return(0.);
 }
 else if (i==4)     /* d4 */
 {
  if (j==0) return((u2-u1)/3);
  if (j==1) return((v2-v1)/3);
 }
 else if (i==5)     /* d5 */
 {
  if (j==0) return(-(2*u1-u2-u3)/9);
  if (j==1) return(-(2*v1-v2-v3)/9);
 }
 else if (i==6)     /* d6 */
 {
  if (j==0) return((u3-u1)/3);
  if (j==1) return((v3-v1)/3);
 }
 else if (i==7)     /* d7 */
 {
  if (j==2) return((u3-u2)/3);
  if (j==3) return((v3-v2)/3);
 }
 else if (i==8)     /* d8 */
 {
  if (j==2) return((u1-2*u2+u3)/9);
  if (j==3) return((v1-2*v2+v3)/9);
 }
 else if (i==9)     /* d9 */
 {
  if (j==2) return((u1-u2)/3);
  if (j==3) return((v1-v2)/3);
 }
 else if (i==10)     /* d10 */
 {
  if (j==4) return((u1-u3)/3);
  if (j==5) return((v1-v3)/3);
 }
 else if (i==11)     /* d11 */
 {
  if (j==4) return((u1+u2-2*u3)/9);
  if (j==5) return((v1+v2-2*v3)/9);
 }
 else if (i==12)     /* d12 */
 {
  if (j==4) return((u2-u3)/3);
  if (j==5) return((v2-v3)/3);
 }
 else if (i==13)     /* d13 */
 {
  if (j==0) return((9*t1*(u1-u2)-8*u1+7*u2+u3)/18);
  if (j==1) return((9*t1*(v1-v2)-8*v1+7*v2+v3)/18);
  if (j==2) return((9*t1*(u1-u2)-2*u1+u2+u3)/18);
  if (j==3) return((9*t1*(v1-v2)-2*v1+v2+v3)/18);
 }
 else if (i==14)     /* d14 */
 {
  if (j==2) return((9*t2*(u2-u3)+u1-8*u2+7*u3)/18);
  if (j==3) return((9*t2*(v2-v3)+v1-8*v2+7*v3)/18);
  if (j==4) return((9*t2*(u2-u3)+u1-2*u2+u3)/18);
  if (j==5) return((9*t2*(v2-v3)+v1-2*v2+v3)/18);
 }
 else if (i==15)     /* d15 */
 {
  if (j==0) return(-(9*t3*(u1-u3)-u1-u2+2*u3)/18);
  if (j==1) return(-(9*t3*(v1-v3)-v1-v2+2*v3)/18);
  if (j==4) return(-(9*t3*(u1-u3)-7*u1-u2+8*u3)/18);
  if (j==5) return(-(9*t3*(v1-v3)-7*v1-v2+8*v3)/18);
 }
 else if (i==16)     /* d16 */
 {
  if (j==0) return((9*t1*(u1-u2)+9*t3*(u3-u1)-11*u1+10*u2+u3)/54);
  if (j==1) return((9*t1*(v1-v2)+9*t3*(v3-v1)-11*v1+10*v2+v3)/54);
  if (j==2) return((9*t1*(u1-u2)-2*u1+u2+u3)/54);
  if (j==3) return((9*t1*(v1-v2)-2*v1+v2+v3)/54);
  if (j==4) return(-(9*t3*(u1-u3)-7*u1-u2+8*u3)/54);
  if (j==5) return(-(9*t3*(v1-v3)-7*v1-v2+8*v3)/54);
 }
 else if (i==17)     /* d17 */
 {
  if (j==0) return((9*t1*(u1-u2)-8*u1+7*u2+u3)/54);
  if (j==1) return((9*t1*(v1-v2)-8*v1+7*v2+v3)/54);
  if (j==2) return((9*t1*(u1-u2)+9*t2*(u2-u3)+u1-11*u2+10*u3)/54);
  if (j==3) return((9*t1*(v1-v2)+9*t2*(v2-v3)+v1-11*v2+10*v3)/54);
  if (j==4) return((9*t2*(u2-u3)+u1-2*u2+u3)/54);
  if (j==5) return((9*t2*(v2-v3)+v1-2*v2+v3)/54);
 }
 else if (i==18)     /* d18 */
 {
  if (j==0) return(-(9*t3*(u1-u3)-u1-u2+2*u3)/54);
  if (j==1) return(-(9*t3*(v1-v3)-v1-v2+2*v3)/54);
  if (j==2) return((9*t2*(u2-u3)+u1-8*u2+7*u3)/54);
  if (j==3) return((9*t2*(v2-v3)+v1-8*v2+7*v3)/54);
  if (j==4) return((9*t2*(u2-u3)+9*t3*(u3-u1)+10*u1+u2-11*u3)/54);
  if (j==5) return((9*t2*(v2-v3)+9*t3*(v3-v1)+10*v1+v2-11*v3)/54);
 }
 else if (i==19)     /* d19 */
 {
  if (j==0) return((t1*(u1-u2)+t3*(u3-u1)-u1+u2)/9);
  if (j==1) return((t1*(v1-v2)+t3*(v3-v1)-v1+v2)/9);
  if (j==2) return((t1*(u1-u2)+t2*(u2-u3)-u2+u3)/9);
  if (j==3) return((t1*(v1-v2)+t2*(v2-v3)-v2+v3)/9);
  if (j==4) return((t2*(u2-u3)+t3*(u3-u1)+u1-u3)/9);
  if (j==5) return((t2*(v2-v3)+t3*(v3-v1)+v1-v3)/9);
 }
 /* security */
 return(0.);
}

double compute_d_j_clt(j,i)
int j,i;
{
 /* Beginning of answers by lookup table */
 if (i==0) /* Computation of dj(e0) */
 {
  if (j==1) return(q1);
  if (j==2) return(q2);
  if (j==3) return(q3);
  if (j==4) return(q1+(u2-u1)/3);
  if (j==5) return(q1-(2*u1-u2-u3)/9);
  if (j==6) return(q1+(u3-u1)/3);
  if (j==7) return(q2);
  if (j==8) return(q2);
  if (j==9) return(q2);
  if (j==10) return(q3);
  if (j==11) return(q3);
  if (j==12) return(q3);
  if (j==13) return(-(18*q1*(t1-1)-18*q2*t1+9*t1*(u2-u1)+8*u1-7*u2-u3)/18);
  if (j==14) return(q2*(1-t2)+q3*t2);
  if (j==15) return((18*q1*t3+18*q3*(1-t3)+9*t3*(u3-u1)+u1+u2-2*u3)/18);
  if (j==16) return(-(18*q1*(t1-t3-2)-18*q2*t1+18*q3*(t3-1)
		      +9*t1*(u2-u1)+9*t3*(u1-u3)+11*u1-10*u2-u3)/54);
  if (j==17) return(-(18*q1*(t1-1)-18*q2*(t1-t2+2)-18*q3*t2
		      +9*t1*(u2-u1)+8*u1-7*u2-u3)/54);
  if (j==18) return((18*q1*t3+18*q2*(1-t2)+18*q3*(t2-t3+2)
		     +9*t3*(u3-u1)+u1+u2-2*u3)/54);
  if (j==19) return(-(q1*(2*t1-2*t3-3)-q2*(2*t1-2*t2+3)-q3*(2*t2-2*t3+3)
		      +t1*(u2-u1)+t3*(u1-u3)+u1-u2)/9);
 }
 else if (i==1) /* Computation of dj(e1) */
 {
  if (j==1) return(q1);
  if (j==2) return(q2);
  if (j==3) return(q3);
  if (j==4) return(q1+(v2-v1)/3);
  if (j==5) return(q1-(2*v1-v2-v3)/9);
  if (j==6) return(q1+(v3-v1)/3);
  if (j==7) return(q2);
  if (j==8) return(q2);
  if (j==9) return(q2);
  if (j==10) return(q3);
  if (j==11) return(q3);
  if (j==12) return(q3);
  if (j==13) return(-(18*q1*(t1-1)-18*q2*t1+9*t1*(v2-v1)+8*v1-7*v2-v3)/18);
  if (j==14) return(q2*(1-t2)+q3*t2);
  if (j==15) return((18*q1*t3+18*q3*(1-t3)+9*t3*(v3-v1)+v1+v2-2*v3)/18);
  if (j==16) return(-(18*q1*(t1-t3-2)-18*q2*t1+18*q3*(t3-1)
		      +9*t1*(v2-v1)+9*t3*(v1-v3)+11*v1-10*v2-v3)/54);
  if (j==17) return(-(18*q1*(t1-1)-18*q2*(t1-t2+2)-18*q3*t2
		      +9*t1*(v2-v1)+8*v1-7*v2-v3)/54);
  if (j==18) return((18*q1*t3+18*q2*(1-t2)+18*q3*(t2-t3+2)
		     +9*t3*(v3-v1)+v1+v2-2*v3)/54);
  if (j==19) return(-(q1*(2*t1-2*t3-3)-q2*(2*t1-2*t2+3)-q3*(2*t2-2*t3+3)
		      +t1*(v2-v1)+t3*(v1-v3)+v1-v2)/9);
 }
 else if (i==2) /* Computation of dj(e2) */
 {
  if (j==1) return(q1);
  if (j==2) return(q2);
  if (j==3) return(q3);
  if (j==4) return(q1);
  if (j==5) return(q1);
  if (j==6) return(q1);
  if (j==7) return(q2+(u3-u2)/3);
  if (j==8) return(q2+(u1-2*u2+u3)/9);
  if (j==9) return(q2+(u1-u2)/3);
  if (j==10) return(q3);
  if (j==11) return(q3);
  if (j==12) return(q3);
  if (j==13) return(-(18*q1*(t1-1)-18*q2*t1+9*t1*(u2-u1)+2*u1-u2-u3)/18);
  if (j==14) return(-(18*q2*(t2-1)-18*q3*t2+9*t2*(u3-u2)-u1+8*u2-7*u3)/18);
  if (j==15) return(q1*t3+q3*(1-t3));
  if (j==16) return(-(18*q1*(t1-t3-2)-18*q2*t1+18*q3*(t3-1)
		      +9*t1*(u2-u1)+2*u1-u2-u3)/54);
  if (j==17) return(-(18*q1*(t1-1)-18*q2*(t1-t2+2)-18*q3*t2
		      +9*t1*(u2-u1)+9*t2*(u3-u2)-u1+11*u2-10*u3)/54);
  if (j==18) return((18*q1*t3+18*q2*(1-t2)+18*q3*(t2-t3+2)
		     +9*t2*(u2-u3)+u1-8*u2+7*u3)/54);
  if (j==19) return(-(q1*(2*t1-2*t3-3)-q2*(2*t1-2*t2+3)-q3*(2*t2-2*t3+3)
		      +t1*(u2-u1)+t2*(u3-u2)+u2-u3)/9);
 }
 else if (i==3) /* Computation of dj(e3) */
 {
  if (j==1) return(q1);
  if (j==2) return(q2);
  if (j==3) return(q3);
  if (j==4) return(q1);
  if (j==5) return(q1);
  if (j==6) return(q1);
  if (j==7) return(q2+(v3-v2)/3);
  if (j==8) return(q2+(v1-2*v2+v3)/9);
  if (j==9) return(q2+(v1-v2)/3);
  if (j==10) return(q3);
  if (j==11) return(q3);
  if (j==12) return(q3);
  if (j==13) return(-(18*q1*(t1-1)-18*q2*t1+9*t1*(v2-v1)+2*v1-v2-v3)/18);
  if (j==14) return(-(18*q2*(t2-1)-18*q3*t2+9*t2*(v3-v2)-v1+8*v2-7*v3)/18);
  if (j==15) return(q1*t3+q3*(1-t3));
  if (j==16) return(-(18*q1*(t1-t3-2)-18*q2*t1+18*q3*(t3-1)
		      +9*t1*(v2-v1)+2*v1-v2-v3)/54);
  if (j==17) return(-(18*q1*(t1-1)-18*q2*(t1-t2+2)-18*q3*t2
		      +9*t1*(v2-v1)+9*t2*(v3-v2)-v1+11*v2-10*v3)/54);
  if (j==18) return((18*q1*t3+18*q2*(1-t2)+18*q3*(t2-t3+2)
		     +9*t2*(v2-v3)+v1-8*v2+7*v3)/54);
  if (j==19) return(-(q1*(2*t1-2*t3-3)-q2*(2*t1-2*t2+3)
		      -q3*(2*t2-2*t3+3)+t1*(v2-v1)+t2*(v3-v2)+v2-v3)/9);
 }
 else if (i==4) /* Computation of dj(e4) */
 {
  if (j==1) return(q1);
  if (j==2) return(q2);
  if (j==3) return(q3);
  if (j==4) return(q1);
  if (j==5) return(q1);
  if (j==6) return(q1);
  if (j==7) return(q2);
  if (j==8) return(q2);
  if (j==9) return(q2);
  if (j==10) return(q3+(u1-u3)/3);
  if (j==11) return(q3+(u1+u2-2*u3)/9);
  if (j==12) return(q3+(u2-u3)/3);
  if (j==13) return(q1*(1-t1)+q2*t1);
  if (j==14) return(-(18*q2*(t2-1)-18*q3*t2+9*t2*(u3-u2)-u1+2*u2-u3)/18);
  if (j==15) return((18*q1*t3+18*q3*(1-t3)+9*t3*(u3-u1)+7*u1+u2-8*u3)/18);
  if (j==16) return(-(18*q1*(t1-t3-2)-18*q2*t1+18*q3*(t3-1)
		      +9*t3*(u1-u3)-7*u1-u2+8*u3)/54);
  if (j==17) return(-(18*q1*(t1-1)-18*q2*(t1-t2+2)-18*q3*t2
		      +9*t2*(u3-u2)-u1+2*u2-u3)/54);
  if (j==18) return((18*q1*t3+18*q2*(1-t2)+18*q3*(t2-t3+2)+9*t2*(u2-u3)
		     +9*t3*(u3-u1)+10*u1+u2-11*u3)/54);
  if (j==19) return(-(q1*(2*t1-2*t3-3)-q2*(2*t1-2*t2+3)-q3*(2*t2-2*t3+3)
		      +t2*(u3-u2)+(u1-u3)*(t3-1))/9);
 }
 else if (i==5) /* Computation of dj(e5) */
 {
  if (j==1) return(q1);
  if (j==2) return(q2);
  if (j==3) return(q3);
  if (j==4) return(q1);
  if (j==5) return(q1);
  if (j==6) return(q1);
  if (j==7) return(q2);
  if (j==8) return(q2);
  if (j==9) return(q2);
  if (j==10) return(q3+(v1-v3)/3);
  if (j==11) return(q3+(v1+v2-2*v3)/9);
  if (j==12) return(q3+(v2-v3)/3);
  if (j==13) return(q1*(1-t1)+q2*t1);
  if (j==14) return(-(18*q2*(t2-1)-18*q3*t2+9*t2*(v3-v2)-v1+2*v2-v3)/18);
  if (j==15) return((18*q1*t3+18*q3*(1-t3)+9*t3*(v3-v1)+7*v1+v2-8*v3)/18);
  if (j==16) return(-(18*q1*(t1-t3-2)-18*q2*t1+18*q3*(t3-1)
		      +9*t3*(v1-v3)-7*v1-v2+8*v3)/54);
  if (j==17) return(-(18*q1*(t1-1)-18*q2*(t1-t2+2)-18*q3*t2
		      +9*t2*(v3-v2)-v1+2*v2-v3)/54);
  if (j==18) return((18*q1*t3+18*q2*(1-t2)+18*q3*(t2-t3+2)
		     +9*t2*(v2-v3)+9*t3*(v3-v1)+10*v1+v2-11*v3)/54);
  if (j==19) return(-(q1*(2*t1-2*t3-3)-q2*(2*t1-2*t2+3)-q3*(2*t2-2*t3+3)
		      +t2*(v3-v2)+(v1-v3)*(t3-1))/9);
 }
 /* security */
 return(0.);
}

double compute_d_j_clt_null(j)
int j;
{
  /* Computation of d_j(0) */
  if (j==1) return(q1);
  if (j==2) return(q2);
  if (j==3) return(q3);
  if (j==4) return(q1);
  if (j==5) return(q1);
  if (j==6) return(q1);
  if (j==7) return(q2);
  if (j==8) return(q2);
  if (j==9) return(q2);
  if (j==10) return(q3);
  if (j==11) return(q3);
  if (j==12) return(q3);
  if (j==13) return(q1*(1-t1)+q2*t1);
  if (j==14) return(q2*(1-t2)+q3*t2);
  if (j==15) return(q1*t3+q3*(1-t3));
  if (j==16) return(-(q1*(t1-t3-2)-q2*t1+q3*(t3-1))/3);
  if (j==17) return(-(q1*(t1-1)-q2*(t1-t2+2)-q3*t2)/3);
  if (j==18) return((q1*t3+q2*(1-t2)+q3*(t2-t3+2))/3);
  if (j==19) return(-(q1*(2*t1-2*t3-3)-q2*(2*t1-2*t2+3)-q3*(2*t2-2*t3+3))
		    /9);
  /* security */
  return(0.);
}

double sum_cpt1_prod(b,c)
double b[],c[];
{
 double temp=0.;

 /* adding a_002 */
 temp=temp+b[0]*c[0];
 /* adding a_011 */
 temp=temp+(b[1]*c[0]+b[0]*c[1])/2;
 /* adding a_020 */
 temp=temp+b[1]*c[1];
 /* adding a_101 */
 temp=temp+(b[2]*c[0]+b[0]*c[2])/2;
 /* adding a_110 */
 temp=temp+(b[2]*c[1]+b[1]*c[2])/2;
 /* adding a_200 */
 temp=temp+b[2]*c[2];
 return(temp);
}

