(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 3.0,
MathReader 3.0, or any compatible application. The data for the notebook 
starts with the line of stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     43232,        912]*)
(*NotebookOutlinePosition[     44070,        939]*)
(*  CellTagsIndexPosition[     44026,        935]*)
(*WindowFrame->Normal*)



Notebook[{
Cell[TextData[{
  " :Author:  Z\[EAcute]lia da ROCHA \n\n:Address: \n            Departamento \
de Matem\[AAcute]tica Aplicada da\n            Faculdade de Ci\[EHat]ncias do \
Porto\n            Rua das Taipas, 135\n            4050 Porto\n            \
Portugal\n  \n            Tel: ++351 02 2080313\n            Fax: ++351 02 \
2004109\n            Email: mrdioh@fc.up.pt\n\n :Summary:\n    The ",
  StyleBox["testshfv53",
    FontSize->18],
  " notebook contains the results produced by the package\n    shfv.m \
corresponding to the ",
  StyleBox["example 5.3",
    FontSize->18],
  " of the first paper cited bellow.    \n\n :Date: July 1999. \n\n:Available \
at http://netlib.bell-labs.com/ in the numeralgo library in netlib:     \n\n \
:Notebook Version: 1.0 \n\n :Mathematica Version: 3.0   \n \n :Keywords: \
Shohat-Favard's method, regular forms, d-dimensional canonical forms, \n \
d-orthogonal polynomial sequences.\n\n :Sources:\n \n - Z\[EAcute]lia da \
Rocha, Shohat-Favard and Chebyshev's methods in d-orthogonality, \n Numerical \
Algorithms, 20 (1999) 139 - 164.\n   \n - About the example treated here see \
p.286 of:\n   K. Douak, The relation of the d-orthogonal polynomials to the \
Appell polynomials,  \n   J. Comput. Appl. Math., 70 (1996) 279-295."
}], "Subsection"],

Cell[CellGroupData[{

Cell["\<\
Computing the moments of the d-dimensional canonical form \
performing formal computations\
\>", "Section",
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell["\<\
Loading the package shfv.m, the package datashfv53.m is \
automatically loaded\
\>", "Subsection"],

Cell[BoxData[
    \(\(\(<< shohatfavard`shfv`; \)\ \)\)], "Input"]
}, Closed]],

Cell[CellGroupData[{

Cell["\<\
The recurrence coefficients are given in the package datashfv53.m\
\
\>", "Subsection",
  AspectRatioFixed->True],

Cell[BoxData[
    \( (*\ showing\ the\ recurrence\ coefficients\ given\ *) \)], "Input"],

Cell[BoxData[
    \(\( (*\ set\ the\ values\ of\ d\ and\ imax\ *) \nd = 3; imax = \ 10; 
    \ \ \ \ \ \  (*\ for\ example\ *) \)\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(Do[\ 
      Do[Print["\<gamma[\>", d, "\<,\>", r, "\<,\>", n, "\<]=\>", \n
          \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \
\ gamma[d, r, n]\ ], \ \ \ \ \ \ \ \n
        \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ {n, 1, imax + r - d + 1}]; 
      Print["\<  \>"], \ \n\ \ \ \ \ \ {r, 0, d - 1}]\ \)\)], "Input"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]0
        \[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]"]="\[InvisibleSpace]1\/4\),
      SequenceForm[ "gamma[", 3, ",", 0, ",", 1, "]=", 
        Rational[ 1, 4]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]0
        \[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]"]="\[InvisibleSpace]1\),
      SequenceForm[ "gamma[", 3, ",", 0, ",", 2, "]=", 1],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]0
        \[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]"]="\[InvisibleSpace]5\/2\),
      SequenceForm[ "gamma[", 3, ",", 0, ",", 3, "]=", 
        Rational[ 5, 2]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]0
        \[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]"]="\[InvisibleSpace]5\),
      SequenceForm[ "gamma[", 3, ",", 0, ",", 4, "]=", 5],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]0
        \[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]"]="\[InvisibleSpace]35\/4\),
      SequenceForm[ "gamma[", 3, ",", 0, ",", 5, "]=", 
        Rational[ 35, 4]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]0
        \[InvisibleSpace]","\[InvisibleSpace]6
        \[InvisibleSpace]"]="\[InvisibleSpace]14\),
      SequenceForm[ "gamma[", 3, ",", 0, ",", 6, "]=", 14],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]0
        \[InvisibleSpace]","\[InvisibleSpace]7
        \[InvisibleSpace]"]="\[InvisibleSpace]21\),
      SequenceForm[ "gamma[", 3, ",", 0, ",", 7, "]=", 21],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]0
        \[InvisibleSpace]","\[InvisibleSpace]8
        \[InvisibleSpace]"]="\[InvisibleSpace]30\),
      SequenceForm[ "gamma[", 3, ",", 0, ",", 8, "]=", 30],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]"]="\[InvisibleSpace]3\/2\),
      SequenceForm[ "gamma[", 3, ",", 1, ",", 1, "]=", 
        Rational[ 3, 2]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]"]="\[InvisibleSpace]9\/2\),
      SequenceForm[ "gamma[", 3, ",", 1, ",", 2, "]=", 
        Rational[ 9, 2]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]"]="\[InvisibleSpace]9\),
      SequenceForm[ "gamma[", 3, ",", 1, ",", 3, "]=", 9],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]"]="\[InvisibleSpace]15\),
      SequenceForm[ "gamma[", 3, ",", 1, ",", 4, "]=", 15],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]"]="\[InvisibleSpace]45\/2\),
      SequenceForm[ "gamma[", 3, ",", 1, ",", 5, "]=", 
        Rational[ 45, 2]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]6
        \[InvisibleSpace]"]="\[InvisibleSpace]63\/2\),
      SequenceForm[ "gamma[", 3, ",", 1, ",", 6, "]=", 
        Rational[ 63, 2]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]7
        \[InvisibleSpace]"]="\[InvisibleSpace]42\),
      SequenceForm[ "gamma[", 3, ",", 1, ",", 7, "]=", 42],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]8
        \[InvisibleSpace]"]="\[InvisibleSpace]54\),
      SequenceForm[ "gamma[", 3, ",", 1, ",", 8, "]=", 54],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]9
        \[InvisibleSpace]"]="\[InvisibleSpace]135\/2\),
      SequenceForm[ "gamma[", 3, ",", 1, ",", 9, "]=", 
        Rational[ 135, 2]],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]"]="\[InvisibleSpace]4\/3\),
      SequenceForm[ "gamma[", 3, ",", 2, ",", 1, "]=", 
        Rational[ 4, 3]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]"]="\[InvisibleSpace]8\/3\),
      SequenceForm[ "gamma[", 3, ",", 2, ",", 2, "]=", 
        Rational[ 8, 3]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]"]="\[InvisibleSpace]4\),
      SequenceForm[ "gamma[", 3, ",", 2, ",", 3, "]=", 4],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]"]="\[InvisibleSpace]16\/3\),
      SequenceForm[ "gamma[", 3, ",", 2, ",", 4, "]=", 
        Rational[ 16, 3]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]"]="\[InvisibleSpace]20\/3\),
      SequenceForm[ "gamma[", 3, ",", 2, ",", 5, "]=", 
        Rational[ 20, 3]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]6
        \[InvisibleSpace]"]="\[InvisibleSpace]8\),
      SequenceForm[ "gamma[", 3, ",", 2, ",", 6, "]=", 8],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]7
        \[InvisibleSpace]"]="\[InvisibleSpace]28\/3\),
      SequenceForm[ "gamma[", 3, ",", 2, ",", 7, "]=", 
        Rational[ 28, 3]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]8
        \[InvisibleSpace]"]="\[InvisibleSpace]32\/3\),
      SequenceForm[ "gamma[", 3, ",", 2, ",", 8, "]=", 
        Rational[ 32, 3]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]9
        \[InvisibleSpace]"]="\[InvisibleSpace]12\),
      SequenceForm[ "gamma[", 3, ",", 2, ",", 9, "]=", 12],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]10
        \[InvisibleSpace]"]="\[InvisibleSpace]40\/3\),
      SequenceForm[ "gamma[", 3, ",", 2, ",", 10, "]=", 
        Rational[ 40, 3]],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(\ Do[Print["\<beta[\>", d, "\<,\>", n, "\<]=\>", beta[d, n]\ ], 
      \ \ \ \ \ \ \ \n\ \ \ \ \ \ \ \ \ \ {n, 0, imax - 1}]\)\)], "Input"],

Cell[BoxData[
    InterpretationBox[
      \("beta["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]0
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "beta[", 3, ",", 0, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("beta["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "beta[", 3, ",", 1, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("beta["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "beta[", 3, ",", 2, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("beta["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "beta[", 3, ",", 3, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("beta["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "beta[", 3, ",", 4, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("beta["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "beta[", 3, ",", 5, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("beta["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]6
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "beta[", 3, ",", 6, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("beta["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]7
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "beta[", 3, ",", 7, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("beta["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]8
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "beta[", 3, ",", 8, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("beta["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]9
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "beta[", 3, ",", 9, "]=", 0],
      Editable->False]], "Print"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Computing the moments of the d-dimensional form", "Subsection"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\( (*\ set\ the\ values\ of\ d\ and\ nmax\ *) \nd = 3; \ 
    nmax = \ 100\ \ ; \  (*\ for\ example\ *) \)\)], "Input"],

Cell[BoxData[
    \(General::"spell1" \( : \ \) 
      "Possible spelling error: new symbol name \"\!\(nmax\)\" is similar to \
existing symbol \"\!\(imax\)\"."\)], "Message"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(MemoryInUse[]\)], "Input"],

Cell[BoxData[
    \(877736\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Timing[dcanonicalform[d,nmax,Infinity]]", "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    \({66.3666666666666582`\ 
        Second, {{1, 0, 4\/3, 3\/2, 67\/12, 20, 1135\/18, 2345\/8, 
          547505\/432, 6055, 582505\/18, 16807175\/96, 1773706165\/1728, 
          19013995\/3, 105207697595\/2592, 316053012275\/1152, 
          39953736047225\/20736, 3033988582625\/216, 1656935360155075\/15552, 
          3848941950728875\/4608, 5052791584924508425\/746496, 
          293629599641753375\/5184, 182167180235827862075\/373248, 
          2154094815020045572675\/497664, 353475770678943680993225\/8957952, 
          22968833625377031266875\/62208, 5952112645915296812826875\/1679616, 
          23124649259229756871758125\/663552, 
          4190253167288399409757934375\/11943936, 
          449484225421418341456176875\/124416, 
          681270677094040710152464113125\/17915904, 
          3255097972826703136070528215625\/7962624, 
          1928845897991794779773603363160625\/429981696, 
          37483945518357427019442456319375\/746496, 
          61596331624710481680263490978044375\/107495424, 
          1909909628781517885103660133921490625\/286654464, 
          407085632591346602450504657162449871875\/5159780352, 
          11357975562161924462310263373018990625\/11943936, 
          90255192169915538464040021270474943434375\/7739670528, 
          500252771999986117912939567793580455865625\/3439853568, 
          114152063648227817143049269553489856890996875\/61917364224, 
          30634671474095567328312481361000769026140625\/1289945088, 
          7215056205717029725424690757510190973847615625\/23219011584, 
          170410963550382929113423026399279055778004434375\/41278242816, 
          124093201733764253626031151623378391999211527809375\/2229025112064, 
          245659606994281242538241157225501300902553359375\/322486272, 
          3928001135425008991076315711456426940140735206390625\/371504185344, 
          73715770133950353389848654872188739995286045915671875
            \/495338913792, 
          18933107807981645952605032145128471881303059720360515625
            \/8916100448256, 
          950685526132481802203749192133045650550841357453765625
            \/30958682112, 
          3008852350696811012735657625243027221184779898224909234375
            \/6687075336192, 
          39696319083149564139472254943570060293369837032691337890625
            \/5944066965504, 
          10740128321387035432591295539853893429314290221524633735671875
            \/106993205379072, 
          3405156106969375629986671062699474175062249527368197573171875
            \/2229025112064, 
          3776777724783060749620557496543873132520839921813982394665921875
            \/160489808068608, 
          2907609532664179391363760386761271702582489836814967324383515625
            \/7925422620672, 
          22289888668680449915392770261167618797014827798831374551957514765625
            \/3851755393646592, 
          2469949808128424872617273819207319897469487479471694297875998984375
            \/26748301344768, 
          22422030490956556381854332045986456411429574901100283818747463515625
            \/15045919506432, 
          62449186523804969427748425505511586562324695217851893774472586775703\
125\/2567836929097728, 
          18546473592223372489031775072910538861754381556194897156684389973379\
609375\/46221064723759104, 
          10740203597741465725843014762098061087204178296097015749292661285089\
84375\/160489808068608, 
          78207193841927512395381950119420575355176769975224408554720341817738\
49453125\/69331597085638656, 
          19734572472073521202696485350377072052183122411249069929406384375642\
239296875\/10271347716390912, 
          61129268807199920893808357756846055955070144581046294324609179291842\
84270390625\/184884258895036416, 
          27673438515856439294120228918089551773989932293261149249592796330346\
8539453125\/481469424205824, 
          13993649511213058859388444674381961751216151213645018468200658018289\
70468816015625\/138663194171277312, 
          22055662496962774666607471418410457677330697004276574155485842562488\
995627462890625\/123256172596690944, 
          21323558040138889286517477464836638825290772657641531525285392747072\
043567035741015625\/6655833320221310976, 
          26766208949424604575483889308282152389020303886137493062047958148218\
22319072767578125\/46221064723759104, 
          35163682941646112201054585474216593036555284727314708489720475914812\
43418094653649609375\/3327916660110655488, 
          86344858571373543893824109766795387382953149436310389440600849181818\
341779109179748046875\/4437222213480873984, 
          28885869022526192245916400003386457953680489000496199903029386413987\
229171958821127969140625/79869999842655731712, 
          12539995511169247071459450255025897380585572548139688572155035561087\
51698280097804718359375/184884258895036416, 
          38439254840722888184275453994381152051015050352966910559667976115644\
23897177507506876764453125/29951249940995899392, 
          13044604081047393356259913252839664550470062862031212904001065009665\
2370814254955489483720703125/53246666561770487808, 
          45211420380091015713862720147193062780014413039502674662988952244956\
707066644844681338640849609375/958439998111868780544, 
          45730884320947668486327474193460416113817151908824561752266312991203\
54949100759586583769501953125/4991874990165983232, 
          25795003702616264093719243256307096877403859321459695534656335657558\
180083807377160832863882275390625/1437659997167803170816, 
          22641828761155170138685375706704618306934349004741038520411629009575\
3933689759560176116968690009765625/638959998741245853696, 
          24346909341220514253114074344670870160429191905164012902853561343940\
8649580898355403576994198754775390625/34503839932027276099584, 
          62858303289814424483178427390455746669289350197860011245967772414314\
5554911400578809394652628955078125/4437222213480873984, 
          91593384985867686870542458615452656566169089305056632190880922938891\
6482044261054373889002917463857421875/319479999370622926848, 
          49825781366592082743779049830368843962352146263086064002488948121886\
831509672320881405755750162950654296875/851946664988327804928, 
          18439945413071656967666352058660226014137389813699587710350183306740\
147748506870174813726012287251646962890625/15335039969789900488704, 
          26533970736759635979137721478208347413594512609255155938155473541348\
29955663626866621015273074004946630859375/106493333123540975616, 
          11967253473420645225809199924436804326727335106896108315628191302910\
211707839350402485546919952985293891259765625/23002559954684850733056, 
          11190410686697301474665036445653471738787835519503275210809562211283\
3143182837410993717499831323580332044091796875/10223359979859933659136, 
          42698358374705602903324055289404575637475877856289993059093255761407\
732202528606342056463617722589761547532275390625/184020479637478805864448, 
          18997000907702520002378011667492953396345094018001318163638872589929\
788204579438239421951983027685522275231494140625/3833759992447475122176, 
          36781528564940512466065405355309664139293533609850090147032935940940\
96627716117950623908064181937579600423835986328125/34503839932027276099584, 
          94464964066823195251417953562099787422079966449501275701006327042405\
089053357109456647409348118989017586791804443359375/40893439919439734636544, 
          33400986646381780526937966058879963307838897981947958957280569215252\
3995311467629989319187222905457986960544443787158203125/
            6624737266949237011120128, 
          25493295438878822683490763535323158372101316214269744061402077980568\
913832397939074980263496728726072251848168496630859375/
            23002559954684850733056, 
          81264507754337233182509272744362191761825530707828095448803620881325\
826714010825628921499389116581636692050027267404345703125/
            3312368633474618505560064, 
          24153142521256053222635690706641684846924270537855700301180869716790\
40715410090426843824052280399888688254919947636346435546875/
            4416491511299491340746752, 
          97582212304668821539669171392022677124293068710950469943840958921902\
2537800132126602211371884131046832281002103450683703369140625/
            79496847203390844133441536, 
          38285364796949042023595159455690357893198738557915578870621073190689\
553087692973314167693607638725893015270037033953550048828125/
            138015359728109104398336, 
          37629761048778699656970869478919188521144107210277042533355166857437\
3920486549684673234446432657004232127125428469039041843017578125/
            59622635402543133100081152, 
          
          25537226414555041405471286137422564503033758724103860332485218047025\
13089281716655811901211396358226803850751096327948737248779296875/
            17665966045197965362987008, 
          10598265267624313641537567893718431047710558211556030050754145271577\
82742184089510353914278480149868909064950226562644941614636962890625/
            317987388813563376533766144}, {0, 1, 0, 4, 6, 335\/12, 120, 
          7945\/18, 2345, 547505\/48, 60550, 6407555\/18, 16807175\/8, 
          23058180145\/1728, 266195930\/3, 526038487975\/864, 
          316053012275\/72, 679213512802825\/20736, 3033988582625\/12, 
          31481771842946425\/15552, 19244709753644375\/1152, 
          35369541094471558975\/248832, 3229925596059287125\/2592, 
          4189845145424040827725\/373248, 2154094815020045572675\/20736, 
          8836894266973592024830625\/8957952, 
          298594837129901406469375\/31104, 5952112645915296812826875\/62208, 
          161872544814608298102306875\/165888, 
          121517341851363582882980096875\/11943936, 
          2247421127107091707280884375\/20736, 
          21119390989915262014726387506875\/17915904, 
          3255097972826703136070528215625\/248832, 
          21217304877909742577509636994766875\/143327232, 
          637227073812076259330521757429375\/373248, 
          2155871606864866858809222184231553125\/107495424, 
          1909909628781517885103660133921490625\/7962624, 
          15062168405879824290668672315010645259375\/5159780352, 
          215801535681076564783895004087360821875\/5971968, 
          1173317498208902000032520276516174264646875\/2579890176, 
          2501263859999930589564697838967902279328125\/429981696, 
          4680234609577340502865020051693084132530871875\/61917364224, 
          214442700318668971298187369527005383182984375\/214990848, 
          310247416845832278193261702572938211875447471875\/23219011584, 
          1874520599054212220247653290392069613558048778125\/10319560704, 
          620466008668821268130155758116891959996057639046875\/247669456896, 
          5650170960868468578379546616186529920758727265625\/161243136, 
          184616053364975422580586838438452066186614554700359375
            \/371504185344, 
          73715770133950353389848654872188739995286045915671875\/10319560704, 
          927722282591100651677646575111295122183849926297665265625
            \/8916100448256, 
          23767138153312045055093729803326141263771033936344140625
            \/15479341056, 
          51150489961845787216506179629131462760141258269823456984375
            \/2229025112064, 
          516052148080944333813139314266410783813807881424987392578125
            \/1486016741376, 
          569226801033512877927338663612256351753657381740805587990609375
            \/106993205379072, 
          3405156106969375629986671062699474175062249527368197573171875
            \/41278242816, 
          207722774863068341229130662309913022288646195699769031706625703125
            \/160489808068608, 
          20353266728649255739546322707328901918077428857704771270684609375
            \/990677827584, 
          42350788470492854839246263496218475714328172817779611648719278054687\
5\/1283918464548864, 
          71628544435724321305900940757012277026615136904679134638403970546875
            \/13374150672384, 
          13228997989664368265294055907132009282743449191649167453061003474218\
75\/15045919506432, 
          31224593261902484713874212752755793281162347608925946887236293387851\
5625\/213986410758144, 
          11313348891256257218309382794475428705670172749278887265577477883761\
56171875\/46221064723759104, 
          33294631152998543750113345762503989370332952717900748822807249983778\
515625\/80244904034304, 
          54745035689349258676767365083594402748623738982657085988304239272416\
946171875\/7703510787293184, 
          19734572472073521202696485350377072052183122411249069929406384375642\
239296875\/160489808068608, 
          39734024724679948580975432541949936370795593977680091310995966539697\
8477575390625\/184884258895036416, 
          30440782367442083223532251809898506951388925522587264174552075963381\
53933984375\/80244904034304, 
          93757451725127494357902579318359143733148213131421623736944408722541\
021410673046875\/138663194171277312, 
          37494626244836716933232701411297778051462184907270176064325932356231\
2925666869140625\/30814043149172736, 
          49044183492319445358990198169124269298168777112575522508156403318265\
7002041822043359375\/2218611106740436992, 
          93681731322986116014193612578987533361571063601481225717167853518763\
781167546865234375\/23110532361879552, 
          24966214888568739662748755686693781055954252156393443027701537899516\
8282684720409122265625/3327916660110655488, 
          86344858571373543893824109766795387382953149436310389440600849181818\
341779109179748046875\/61628086298345472, 
          21086684386444120339518972002472114306186756970362225929211452082210\
67729552993942341747265625/79869999842655731712, 
          46397983391326214164399965943595820308166618428116847716973631576023\
812836363618774579296875/92442129447518208, 
          96098137101807220460688634985952880127537625882417276399169940289110\
597429437687671919111328125/9983749980331966464, 
          24784747753990047376893835180395362645893119437859304517602023518363\
95045470844154300190693359375/13311666640442621952, 
          34812793692670082099674294513338658340611098040417059490501493228616\
66444131653040463075345419921875/958439998111868780544, 
          59450149617231969032225716451498540947962297481471930277946206888564\
614338309874625589003525390625/831979165027663872, 
          20378052925066848634038202172482606533149048863953159472378505169470\
96226620782795705796246699755859375/1437659997167803170816, 
          11320914380577585069342687853352309153467174502370519260205814504787\
69668448797800880584843450048828125/39934999921327865856, 
          24346909341220514253114074344670870160429191905164012902853561343940\
8649580898355403576994198754775390625/425973332494163902464, 
          25771904348823914038103155230086856134408633581122604610846786689868\
967751367423731185180757787158203125/2218611106740436992, 
          76022509538270180102550240650825704949920344123197004718431166039280\
068009673667513032787242149500166015625/319479999370622926848, 
          34878046956614457920645334881258190773646502384160244801742263685320\
7820567706246169840290251140654580078125/70995555415693983744, 
          15673953601110908422516399249861192112016781341644649553797655810729\
12558623083964859166711044416389991845703125/15335039969789900488704, 
          11409607416806643471029220235629589387845640421979717053406853622779\
7688093535955264703656742182212705126953125/53246666561770487808, 
          34705035072919871154846679780866732547509271809998714115321754778439\
6139527341161672080860678636573522846533203125/7667519984894950244352, 
          12309451755367031622131540090218818912666619071453602731890518432411\
64575011211520930892498144559383652485009765625/1277919997482491707392, 
          38001538953487986583958409207570072317353531292098093822592997627652\
88166025045964443025261977310488777730372509765625/184020479637478805864448, 
          94985004538512600011890058337464766981725470090006590818194362949648\
941022897191197109759915138427611376157470703125/212986666247081951232, 
          33471190994095866344119518873331794366757115584963582033799971706256\
2793122166733506775633840556319743638569074755859375/34503839932027276099584, 
          21726941735369334907826129319282951107078392283385293411231455219753\
17048227213517502890415006736747404496211502197265625/
            10223359979859933659136, 
          10354305860378351963350769478252788625430058374403867276756976456728\
243854655496529668894803910069197595776877757401904296875/
            2208245755649745670373376, 
          11981848856273046661240658861601884434887618620706779708858976650867\
38950122703136524072384346250125395836863919341650390625/
            11501279977342425366528, 
          77201282366620371523383809107144082173734254172436690676363439837259\
53537831028434747542441966075255485744752590403412841796875/
            3312368633474618505560064, 
          24153142521256053222635690706641684846924270537855700301180869716790\
40715410090426843824052280399888688254919947636346435546875/
            46005119909369701466112, 
          94654745935528756893479096250261996810564276649621955845525730154245\
186166612816280414503072760711542731257204034716319226806640625/
            79496847203390844133441536, 
          18759828750505030591561628133288275367667381893378633646604325863437\
88101296955692394216986774297568757748231814663723952392578125/
            69007679864054552199168, 
          41392737153656569622667956426811107373258517931304746786690683543181\
13125352046531405578910759227046553398379713159429460273193359375/
            6624737266949237011120128, 
          63843066036387603513678215343556411257584396810259650831213045117562\
827232042916395297530284908955670096268777408198718431219482421875/
            4416491511299491340746752}, {0, 0, 1, 0, 8, 15, 335\/4, 420, 
          15890\/9, 21105\/2, 2737525\/48, 333025, 6407555\/3, 218493275\/16, 
          161407261015\/1728, 665489825, 526038487975\/108, 
          5372901208675\/144, 679213512802825\/2304, 57645783069875\/24, 
          157408859214732125\/7776, 134712968275510625\/768, 
          389064952039187148725\/248832, 74288288709363603875\/5184, 
          4189845145424040827725\/31104, 53852370375501139316875\/41472, 
          114879625470656696322798125\/8957952, 
          298594837129901406469375\/2304, 41664788521407077689788125\/31104, 
          4694303799623640644966899375\/331776, 
          607586709256817914414900484375\/3981312, 
          69670054940319842925707415625\/41472, 
          21119390989915262014726387506875\/1119744, 
          35806077701093734496775810371875\/165888, 
          360694182924465623817663828911036875\/143327232, 
          22302947583422669076568261510028125\/746496, 
          2155871606864866858809222184231553125\/5971968, 
          70666656264916161748835424955095153125\/15925248, 
          286181199711716661522704773985202259928125\/5159780352, 
          2805419963853995342190635053135690684375\/3981312, 
          5866587491044510000162601382580871323234375\/644972544, 
          102551818259997154172152611397683993452453125\/859963392, 
          32761642267041383520055140361851588927716103125\/20639121408, 
          9221036113702765765822056889661231476868328125\/429981696, 
          3412721585304155060125878728302320330629922190625\/11609505792, 
          9372602995271061101238266451960348067790243890625\/2293235712, 
          14270718199382889166993582436688515079909325698078125
            \/247669456896, 
          265558035160818023183838690960766906275660181484375\/322486272, 
          184616053364975422580586838438452066186614554700359375
            \/15479341056, 
          3612072736563567316102584088737248259769016249867921875
            \/20639121408, 
          23193057064777516291941164377782378054596248157441631640625
            \/8916100448256, 
          404041348606304765936593406656544401484107576917850390625
            \/10319560704, 
          664956369503995233814580335178709015881836357507704940796875
            \/1114512556032, 
          27350763848290049692096383656119771542131817715524331806640625
            \/2972033482752, 
          569226801033512877927338663612256351753657381740805587990609375
            \/3962711310336, 
          187283585883315659649266908448471079628423724005250866524453125
            \/82556485632, 
          1454059424041478388603914636169391156020523369898383221946379921875
            \/40122452017152, 
          386712067844335859051380131439249136443471148296390654143007578125
            \/660451885056, 
          12281728656442927903381416413903357957155170117156087378128590635859\
375\/1283918464548864, 
          42260841217077349570481555046637243445702930773760689436658342622656\
25\/26748301344768, 
          66144989948321841326470279535660046413717245958245837265305017371093\
75\/2507653251072, 
          19047001889760515675463269779181033901509032041444827601214138966589\
453125\/427972821516288, 
          35071381562894397376759086662873828987577535522764550523290181439660\
841328125\/46221064723759104, 
          23306241807098980625079342033752792559233066902530524175965074988644\
9609375\/17832200896512, 
          54745035689349258676767365083594402748623738982657085988304239272416\
946171875\/240734712102912, 
          12827472106847788781752715477745096833919029567311895454114149844167\
45554296875\/320979616137216, 
          43707427197147943439072975796144930007875153375448100442095563193667\
63253329296875\/61628086298345472, 
          20395324186186195759766608712631999657430580100133466996949890895465\
6313576953125\/160489808068608, 
          15938766793271674040843438484121054434635196232341676035280549482831\
97363981441796875\/69331597085638656, 
          86237640363124448946435213245984889518363025286721404947949644419331\
97290337990234375\/20542695432781824, 
          17165464222311805875646569359193494254359071989401432877854741161392\
995071463771517578125\/2218611106740436992, 
          66514029239320142370077464931081148686715455157051670259189175998322\
28462895827431640625\/46221064723759104, 
          24966214888568739662748755686693781055954252156393443027701537899516\
8282684720409122265625/92442129447518208, 
          63031746757102687042491600129760632789555799088506584291638619902727\
38949874970121607421875/123256172596690944, 
          78020732229843245256220196409146822932891000790340235938082372704179\
505993460775866644648828125/79869999842655731712, 
          11599495847831553541099991485898955077041654607029211929243407894005\
95320909090469364482421875/61628086298345472, 
          18258646049343371887530840647331047224232148917659282515842288654931\
01351159316065766463115234375/4991874990165983232, 
          19084255770572336480208253088904429237337701967151664478553558109140\
2418501254999881114683388671875/26623333280885243904, 
          45256631800471106729576582867340255842794427452542177337651941197201\
663773711489526019979490458984375/319479999370622926848, 
          46965618197613255535458315996683847348890215010362824919577503441966\
04532726480095421531278505859375/1663958330055327744, 
          10189026462533424317019101086241303266574524431976579736189252584735\
481133103913978528981233498779296875/179707499645975396352, 
          11320914380577585069342687853352309153467174502370519260205814504787\
69668448797800880584843450048828125/986049380773527552, 
          99822328299004108437767704813150567657759686811172452901699601510157\
54632816832571546656762148945791015625/425973332494163902464, 
          21390680609523848651625618840972090591559165872331761827002832952591\
24323363496169688370002896334130859375/4437222213480873984, 
          53215756676789126071785168455577993464944240886237903302901816227496\
0476067715672591229510695046501162109375/53246666561770487808, 
          29646339913122289232548534649069462157599527026536208081480924132522\
664748255030924436424671346955639306640625/141991110831387967488, 
          67398000484776906216820516774403126081672159769071993081329919986135\
240020792610488944168574909904769649365234375/15335039969789900488704, 
          33087861508739266065984738683325809224752357223741179454879875506061\
32954712542702676406045523284168448681640625/35497777707846991872, 
          38175538580211858270331347758953405802260198990998585526853930256283\
57534800752778392889467465002308751311865234375/1916879996223737561088, 
          10955412062276658143697070680294748832273290973593706431382561404846\
3647175997825362849432334865785145071165869140625/2555839994964983414784, 
          19000769476743993291979204603785036158676765646049046911296498813826\
440830125229822215126309886552443888651862548828125/20446719959719867318272, 
          86436354130046466010819953087092937953370177781905997644556870284180\
53633083644398936988152277596912635230329833984375/425973332494163902464, 
          76983739286420492591474893408663127043541365845416238677739934924389\
44241809834870655839578332795354103687088719384765625/
            17251919966013638049792, 
          67353519379644938214261000889777148431943016078494409574817511181234\
828495043619042589602865208839169539382556568115234375/
            6815573319906622439424, 
          48665237543778254227748616547788106539521274359698176200757789346622\
7461168808336894438055783773252287001513254597889501953125/
            2208245755649745670373376, 
          11382756413459394328178625918521790213143237689671440723416027818324\
0200261656797969786876512893761912604502072337456787109375/
            23002559954684850733056, 
          77201282366620371523383809107144082173734254172436690676363439837259\
53537831028434747542441966075255485744752590403412841796875/
            69007679864054552199168, 
          23428548245618371625956619985442434301516542421720029292145443625286\
6949394778771403850933071198789202760727234920725604248046875/
            92010239818739402932224, 
          46380825508409090877804757162628378437176495558314758364307607775580\
14122164027997740310650565274865593831602997701099642113525390625/
            79496847203390844133441536, 
          20635811625555533650717790946617102904434120082716497011264758449781\
669114266512616336386854517273256335230549961300963476318359375/
            15335039969789900488704, 
          10348184288414142405666989106702776843314629482826186696672670885795\
2828133801163285139472768980676163834959492828985736506829833984375/
            3312368633474618505560064}}}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(MemoryInUse[]\)], "Input"],

Cell[BoxData[
    \(1686232\)], "Output"]
}, Open  ]]
}, Closed]]
}, Closed]]
},
FrontEndVersion->"Macintosh 3.0",
ScreenRectangle->{{0, 832}, {0, 604}},
WindowSize->{764, 580},
WindowMargins->{{4, Automatic}, {Automatic, 1}},
MacintoshSystemPageSetup->"\<\
00<0001804P000000`d26_oQon@3:`8g0dL5N`?P0080001804P000000]P2:001
0000I00000400`<30?l00BL?00400@0000000000000006P801T1T00000000000
00000000004000000000000000000000\>"
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{
Cell[1709, 49, 1294, 21, 612, "Subsection"],

Cell[CellGroupData[{
Cell[3028, 74, 143, 4, 68, "Section"],

Cell[CellGroupData[{
Cell[3196, 82, 108, 3, 44, "Subsection"],
Cell[3307, 87, 66, 1, 27, "Input"]
}, Closed]],

Cell[CellGroupData[{
Cell[3410, 93, 123, 4, 28, "Subsection"],
Cell[3536, 99, 88, 1, 27, "Input"],
Cell[3627, 102, 142, 2, 43, "Input"],

Cell[CellGroupData[{
Cell[3794, 108, 361, 6, 75, "Input"],
Cell[4158, 116, 326, 7, 38, "Print"],
Cell[4487, 125, 300, 6, 22, "Print"],
Cell[4790, 133, 326, 7, 38, "Print"],
Cell[5119, 142, 300, 6, 22, "Print"],
Cell[5422, 150, 328, 7, 38, "Print"],
Cell[5753, 159, 302, 6, 22, "Print"],
Cell[6058, 167, 302, 6, 22, "Print"],
Cell[6363, 175, 302, 6, 22, "Print"],
Cell[6668, 183, 37, 1, 22, "Print"],
Cell[6708, 186, 326, 7, 38, "Print"],
Cell[7037, 195, 326, 7, 38, "Print"],
Cell[7366, 204, 300, 6, 22, "Print"],
Cell[7669, 212, 302, 6, 22, "Print"],
Cell[7974, 220, 328, 7, 38, "Print"],
Cell[8305, 229, 328, 7, 38, "Print"],
Cell[8636, 238, 302, 6, 22, "Print"],
Cell[8941, 246, 302, 6, 22, "Print"],
Cell[9246, 254, 330, 7, 38, "Print"],
Cell[9579, 263, 37, 1, 22, "Print"],
Cell[9619, 266, 326, 7, 38, "Print"],
Cell[9948, 275, 326, 7, 38, "Print"],
Cell[10277, 284, 300, 6, 22, "Print"],
Cell[10580, 292, 328, 7, 38, "Print"],
Cell[10911, 301, 328, 7, 38, "Print"],
Cell[11242, 310, 300, 6, 22, "Print"],
Cell[11545, 318, 328, 7, 38, "Print"],
Cell[11876, 327, 328, 7, 38, "Print"],
Cell[12207, 336, 302, 6, 22, "Print"],
Cell[12512, 344, 330, 7, 38, "Print"],
Cell[12845, 353, 37, 1, 22, "Print"]
}, Open  ]],

Cell[CellGroupData[{
Cell[12919, 359, 161, 2, 43, "Input"],
Cell[13083, 363, 243, 5, 22, "Print"],
Cell[13329, 370, 243, 5, 22, "Print"],
Cell[13575, 377, 243, 5, 22, "Print"],
Cell[13821, 384, 243, 5, 22, "Print"],
Cell[14067, 391, 243, 5, 22, "Print"],
Cell[14313, 398, 243, 5, 22, "Print"],
Cell[14559, 405, 243, 5, 22, "Print"],
Cell[14805, 412, 243, 5, 22, "Print"],
Cell[15051, 419, 243, 5, 22, "Print"],
Cell[15297, 426, 243, 5, 22, "Print"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{
Cell[15589, 437, 69, 0, 28, "Subsection"],

Cell[CellGroupData[{
Cell[15683, 441, 139, 2, 43, "Input"],
Cell[15825, 445, 175, 3, 37, "Message"]
}, Open  ]],

Cell[CellGroupData[{
Cell[16037, 453, 46, 1, 27, "Input"],
Cell[16086, 456, 40, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[16163, 462, 82, 1, 27, "Input"],
Cell[16248, 465, 26817, 433, 6989, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[43102, 903, 46, 1, 27, "Input"],
Cell[43151, 906, 41, 1, 26, "Output"]
}, Open  ]]
}, Closed]]
}, Closed]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

