(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 3.0,
MathReader 3.0, or any compatible application. The data for the notebook 
starts with the line of stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[    171228,       4767]*)
(*NotebookOutlinePosition[    172068,       4794]*)
(*  CellTagsIndexPosition[    172024,       4790]*)
(*WindowFrame->Normal*)



Notebook[{
Cell[TextData[{
  " :Author:  Z\[EAcute]lia da ROCHA \n\n:Address: \n            Departamento \
de Matem\[AAcute]tica Aplicada da\n            Faculdade de Ci\[EHat]ncias do \
Porto\n            Rua das Taipas, 135\n            4050 Porto\n            \
Portugal\n  \n            Tel: ++351 02 2080313\n            Fax: ++351 02 \
2004109\n            Email: mrdioh@fc.up.pt\n\n :Summary:\n    The ",
  StyleBox["testshfv3",
    FontSize->18],
  " notebook contains the results produced by the package\n    shfv.m \
corresponding to the ",
  StyleBox["example 3",
    FontSize->18],
  " of the first paper cited bellow.    \n\n :Date:  July 1999. \n\n\
:Available at http://netlib.bell-labs.com/ in the numeralgo library in \
netlib:     \n\n :Notebook Version: 1.0 \n\n :Mathematica Version: 3.0   \n \n\
 :Keywords: Shohat-Favard's method, regular forms, d-dimensional canonical \
forms, \n d-orthogonal polynomial sequences.\n\n :Sources:\n \n - \
Z\[EAcute]lia da Rocha, Shohat-Favard and Chebyshev's methods in \
d-orthogonality, \n Numerical Algorithms, 20 (1999) 139 - 164.\n   \n - About \
the example treated here see pp. 92, 106 of:\n   K. Douak, P. Maroni, Les \
polyn\[OHat]mes orthogonaux \"classiques\" de dimension deux, Analysis 12,  \
71-107 (1992)\n"
}], "Subsection"],

Cell[CellGroupData[{

Cell["\<\
Computing the moments of the d-dimensional canonical form \
performing formal computations\
\>", "Section",
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell["\<\
Loading the package shfv.m, the package datashfv3.m is \
automatically loaded\
\>", "Subsection"],

Cell[BoxData[
    \(\(<< shohatfavard`shfv`\ ; \)\)], "Input"]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
The recurrence coefficients are given in the package \
datashfv3.m\
\>", "Subsection",
  AspectRatioFixed->True],

Cell[BoxData[
    \( (*\ showing\ the\ recurrence\ coefficients\ given\ *) \)], "Input"],

Cell[BoxData[
    \(\( (*\ set\ the\ values\ of\ d\ and\ imax\ *) \nd = 2; imax = \ 10; 
    \ \ \ \ \ \  (*\ for\ example\ *) \)\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(Do[\ 
      Do[Print["\<gamma[\>", d, "\<,\>", r, "\<,\>", n, "\<]=\>", \n
          \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \
\ gamma[d, r, n]\ ], \ \ \ \ \ \ \ \n
        \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ {n, 1, imax + r - d + 1}]; 
      Print["\<  \>"], \ \n\ \ \ \ \ \ {r, 0, d - 1}]\ \)\)], "Input"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]0
        \[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]"]="\[InvisibleSpace]90\),
      SequenceForm[ "gamma[", 2, ",", 0, ",", 1, "]=", 90],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]0
        \[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]"]="\[InvisibleSpace]7560\),
      SequenceForm[ "gamma[", 2, ",", 0, ",", 2, "]=", 7560],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]0
        \[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]"]="\[InvisibleSpace]83160\),
      SequenceForm[ "gamma[", 2, ",", 0, ",", 3, "]=", 83160],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]0
        \[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]"]="\[InvisibleSpace]450450\),
      SequenceForm[ "gamma[", 2, ",", 0, ",", 4, "]=", 450450],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]0
        \[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]"]="\[InvisibleSpace]1670760\),
      SequenceForm[ "gamma[", 2, ",", 0, ",", 5, "]=", 1670760],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]0
        \[InvisibleSpace]","\[InvisibleSpace]6
        \[InvisibleSpace]"]="\[InvisibleSpace]4883760\),
      SequenceForm[ "gamma[", 2, ",", 0, ",", 6, "]=", 4883760],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]0
        \[InvisibleSpace]","\[InvisibleSpace]7
        \[InvisibleSpace]"]="\[InvisibleSpace]12113640\),
      SequenceForm[ "gamma[", 2, ",", 0, ",", 7, "]=", 12113640],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]0
        \[InvisibleSpace]","\[InvisibleSpace]8
        \[InvisibleSpace]"]="\[InvisibleSpace]26640900\),
      SequenceForm[ "gamma[", 2, ",", 0, ",", 8, "]=", 26640900],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]0
        \[InvisibleSpace]","\[InvisibleSpace]9
        \[InvisibleSpace]"]="\[InvisibleSpace]53439750\),
      SequenceForm[ "gamma[", 2, ",", 0, ",", 9, "]=", 53439750],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]"]="\[InvisibleSpace]9\),
      SequenceForm[ "gamma[", 2, ",", 1, ",", 1, "]=", 9],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]"]="\[InvisibleSpace]450\),
      SequenceForm[ "gamma[", 2, ",", 1, ",", 2, "]=", 450],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]"]="\[InvisibleSpace]3024\),
      SequenceForm[ "gamma[", 2, ",", 1, ",", 3, "]=", 3024],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]"]="\[InvisibleSpace]10890\),
      SequenceForm[ "gamma[", 2, ",", 1, ",", 4, "]=", 10890],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]"]="\[InvisibleSpace]28665\),
      SequenceForm[ "gamma[", 2, ",", 1, ",", 5, "]=", 28665],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]6
        \[InvisibleSpace]"]="\[InvisibleSpace]62424\),
      SequenceForm[ "gamma[", 2, ",", 1, ",", 6, "]=", 62424],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]7
        \[InvisibleSpace]"]="\[InvisibleSpace]119700\),
      SequenceForm[ "gamma[", 2, ",", 1, ",", 7, "]=", 119700],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]8
        \[InvisibleSpace]"]="\[InvisibleSpace]209484\),
      SequenceForm[ "gamma[", 2, ",", 1, ",", 8, "]=", 209484],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]9
        \[InvisibleSpace]"]="\[InvisibleSpace]342225\),
      SequenceForm[ "gamma[", 2, ",", 1, ",", 9, "]=", 342225],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]10
        \[InvisibleSpace]"]="\[InvisibleSpace]529830\),
      SequenceForm[ "gamma[", 2, ",", 1, ",", 10, "]=", 529830],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(\ Do[Print["\<beta[\>", d, "\<,\>", n, "\<]=\>", beta[d, n]\ ], 
      \ \ \ \ \ \ \ \n\ \ \ \ \ \ \ \ \ \ {n, 0, imax - 1}]\)\)], "Input"],

Cell[BoxData[
    InterpretationBox[
      \("beta["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]0
        \[InvisibleSpace]"]="\[InvisibleSpace]1\),
      SequenceForm[ "beta[", 2, ",", 0, "]=", 1],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("beta["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]"]="\[InvisibleSpace]19\),
      SequenceForm[ "beta[", 2, ",", 1, "]=", 19],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("beta["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]"]="\[InvisibleSpace]64\),
      SequenceForm[ "beta[", 2, ",", 2, "]=", 64],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("beta["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]"]="\[InvisibleSpace]136\),
      SequenceForm[ "beta[", 2, ",", 3, "]=", 136],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("beta["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]"]="\[InvisibleSpace]235\),
      SequenceForm[ "beta[", 2, ",", 4, "]=", 235],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("beta["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]"]="\[InvisibleSpace]361\),
      SequenceForm[ "beta[", 2, ",", 5, "]=", 361],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("beta["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]6
        \[InvisibleSpace]"]="\[InvisibleSpace]514\),
      SequenceForm[ "beta[", 2, ",", 6, "]=", 514],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("beta["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]7
        \[InvisibleSpace]"]="\[InvisibleSpace]694\),
      SequenceForm[ "beta[", 2, ",", 7, "]=", 694],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("beta["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]8
        \[InvisibleSpace]"]="\[InvisibleSpace]901\),
      SequenceForm[ "beta[", 2, ",", 8, "]=", 901],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("beta["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]9
        \[InvisibleSpace]"]="\[InvisibleSpace]1135\),
      SequenceForm[ "beta[", 2, ",", 9, "]=", 1135],
      Editable->False]], "Print"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["\<\
The exact expressions of the moments of the d-dimensional form are \
given in the package datashfv3.m\
\>", "Subsection"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\( (*\ set\ the\ values\ of\ d\ and\ nmax\ *) \nd = 2; \ 
    nmax = \ 10\ \ ; \ \ \  (*\ for\ example\ *) \)\)], "Input"],

Cell[BoxData[
    \(General::"spell1" \( : \ \) 
      "Possible spelling error: new symbol name \"\!\(nmax\)\" is similar to \
existing symbol \"\!\(imax\)\"."\)], "Message"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Timing[\n\t
      Do[Do[Print["\<formexact[\>", d "\<,\>", r, "\<,\>", i, "\<]=\>", \n
            \t\t\t\t\ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ 
            formexact[d, r, i]\ ], {i, 0, imax}]; \n\t\t\ \ \ \ \ 
        Print["\<   \>"], {r, 1, d}\ ]\n\ \ \ \ \ \ \ \ \ \ \ \ \ \ \ ]\)], 
  "Input"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]\(2\ ","\)\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]0
        \[InvisibleSpace]"]="\[InvisibleSpace]1\),
      SequenceForm[ "formexact[", 
        Times[ 2, ","], 1, ",", 0, "]=", 1],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]\(2\ ","\)\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]"]="\[InvisibleSpace]1\),
      SequenceForm[ "formexact[", 
        Times[ 2, ","], 1, ",", 1, "]=", 1],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]\(2\ ","\)\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]"]="\[InvisibleSpace]10\),
      SequenceForm[ "formexact[", 
        Times[ 2, ","], 1, ",", 2, "]=", 10],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]\(2\ ","\)\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]"]="\[InvisibleSpace]280\),
      SequenceForm[ "formexact[", 
        Times[ 2, ","], 1, ",", 3, "]=", 280],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]\(2\ ","\)\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]"]="\[InvisibleSpace]15400\),
      SequenceForm[ "formexact[", 
        Times[ 2, ","], 1, ",", 4, "]=", 15400],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]\(2\ ","\)\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]"]="\[InvisibleSpace]1401400\),
      SequenceForm[ "formexact[", 
        Times[ 2, ","], 1, ",", 5, "]=", 1401400],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]\(2\ ","\)\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]6
        \[InvisibleSpace]"]="\[InvisibleSpace]190590400\),
      SequenceForm[ "formexact[", 
        Times[ 2, ","], 1, ",", 6, "]=", 190590400],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]\(2\ ","\)\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]7
        \[InvisibleSpace]"]="\[InvisibleSpace]36212176000\),
      SequenceForm[ "formexact[", 
        Times[ 2, ","], 1, ",", 7, "]=", 36212176000],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]\(2\ ","\)\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]8
        \[InvisibleSpace]"]="\[InvisibleSpace]9161680528000\),
      SequenceForm[ "formexact[", 
        Times[ 2, ","], 1, ",", 8, "]=", 9161680528000],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]\(2\ ","\)\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]9
        \[InvisibleSpace]"]="\[InvisibleSpace]2977546171600000\),
      SequenceForm[ "formexact[", 
        Times[ 2, ","], 1, ",", 9, "]=", 2977546171600000],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]\(2\ ","\)\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]10
        \[InvisibleSpace]"]="\[InvisibleSpace]1208883745669600000\),
      SequenceForm[ "formexact[", 
        Times[ 2, ","], 1, ",", 10, "]=", 1208883745669600000],
      Editable->False]], "Print"],

Cell[BoxData[
    \("   "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]\(2\ ","\)\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]0
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 
        Times[ 2, ","], 2, ",", 0, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]\(2\ ","\)\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]"]="\[InvisibleSpace]1\),
      SequenceForm[ "formexact[", 
        Times[ 2, ","], 2, ",", 1, "]=", 1],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]\(2\ ","\)\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]"]="\[InvisibleSpace]20\),
      SequenceForm[ "formexact[", 
        Times[ 2, ","], 2, ",", 2, "]=", 20],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]\(2\ ","\)\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]"]="\[InvisibleSpace]840\),
      SequenceForm[ "formexact[", 
        Times[ 2, ","], 2, ",", 3, "]=", 840],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]\(2\ ","\)\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]"]="\[InvisibleSpace]61600\),
      SequenceForm[ "formexact[", 
        Times[ 2, ","], 2, ",", 4, "]=", 61600],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]\(2\ ","\)\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]"]="\[InvisibleSpace]7007000\),
      SequenceForm[ "formexact[", 
        Times[ 2, ","], 2, ",", 5, "]=", 7007000],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]\(2\ ","\)\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]6
        \[InvisibleSpace]"]="\[InvisibleSpace]1143542400\),
      SequenceForm[ "formexact[", 
        Times[ 2, ","], 2, ",", 6, "]=", 1143542400],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]\(2\ ","\)\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]7
        \[InvisibleSpace]"]="\[InvisibleSpace]253485232000\),
      SequenceForm[ "formexact[", 
        Times[ 2, ","], 2, ",", 7, "]=", 253485232000],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]\(2\ ","\)\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]8
        \[InvisibleSpace]"]="\[InvisibleSpace]73293444224000\),
      SequenceForm[ "formexact[", 
        Times[ 2, ","], 2, ",", 8, "]=", 73293444224000],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]\(2\ ","\)\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]9
        \[InvisibleSpace]"]="\[InvisibleSpace]26797915544400000\),
      SequenceForm[ "formexact[", 
        Times[ 2, ","], 2, ",", 9, "]=", 26797915544400000],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]\(2\ ","\)\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]10
        \[InvisibleSpace]"]="\[InvisibleSpace]12088837456696000000\),
      SequenceForm[ "formexact[", 
        Times[ 2, ","], 2, ",", 10, "]=", 12088837456696000000],
      Editable->False]], "Print"],

Cell[BoxData[
    \("   "\)], "Print"],

Cell[BoxData[
    \({5.8333333333333428`\ Second, Null}\)], "Output"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Computing the moments of the d-dimensional form", "Subsection"],

Cell[BoxData[
    \(\( (*\ set\ the\ values\ of\ d\ and\ nmax\ *) \nd = 2; \ nmax = \ 10; 
    \ \ \  (*\ for\ example\ *) \)\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(MemoryInUse[]\)], "Input"],

Cell[BoxData[
    \(889904\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Timing[printdcanform[d,nmax,Infinity,$MachinePrecision,True,False]]\
\
\>", "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    \("   "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]0
        \[InvisibleSpace]"]="\[InvisibleSpace]1\),
      SequenceForm[ "form[", 2, ",", 1, ",", 0, "]=", 1],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]0
        \[InvisibleSpace]"]="\[InvisibleSpace]1\),
      SequenceForm[ "formexact[", 2, ",", 1, ",", 0, "]=", 1],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]"]="\[InvisibleSpace]1\),
      SequenceForm[ "form[", 2, ",", 1, ",", 1, "]=", 1],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]"]="\[InvisibleSpace]1\),
      SequenceForm[ "formexact[", 2, ",", 1, ",", 1, "]=", 1],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]"]="\[InvisibleSpace]10\),
      SequenceForm[ "form[", 2, ",", 1, ",", 2, "]=", 10],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]"]="\[InvisibleSpace]10\),
      SequenceForm[ "formexact[", 2, ",", 1, ",", 2, "]=", 10],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]"]="\[InvisibleSpace]280\),
      SequenceForm[ "form[", 2, ",", 1, ",", 3, "]=", 280],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]"]="\[InvisibleSpace]280\),
      SequenceForm[ "formexact[", 2, ",", 1, ",", 3, "]=", 280],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]"]="\[InvisibleSpace]15400\),
      SequenceForm[ "form[", 2, ",", 1, ",", 4, "]=", 15400],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]"]="\[InvisibleSpace]15400\),
      SequenceForm[ "formexact[", 2, ",", 1, ",", 4, "]=", 15400],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]"]="\[InvisibleSpace]1401400\),
      SequenceForm[ "form[", 2, ",", 1, ",", 5, "]=", 1401400],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]"]="\[InvisibleSpace]1401400\),
      SequenceForm[ "formexact[", 2, ",", 1, ",", 5, "]=", 1401400],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]6
        \[InvisibleSpace]"]="\[InvisibleSpace]190590400\),
      SequenceForm[ "form[", 2, ",", 1, ",", 6, "]=", 190590400],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]6
        \[InvisibleSpace]"]="\[InvisibleSpace]190590400\),
      SequenceForm[ "formexact[", 2, ",", 1, ",", 6, "]=", 190590400],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]7
        \[InvisibleSpace]"]="\[InvisibleSpace]36212176000\),
      SequenceForm[ "form[", 2, ",", 1, ",", 7, "]=", 36212176000],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]7
        \[InvisibleSpace]"]="\[InvisibleSpace]36212176000\),
      SequenceForm[ "formexact[", 2, ",", 1, ",", 7, "]=", 36212176000],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]8
        \[InvisibleSpace]"]="\[InvisibleSpace]9161680528000\),
      SequenceForm[ "form[", 2, ",", 1, ",", 8, "]=", 9161680528000],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]8
        \[InvisibleSpace]"]="\[InvisibleSpace]9161680528000\),
      SequenceForm[ "formexact[", 2, ",", 1, ",", 8, "]=", 9161680528000],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]9
        \[InvisibleSpace]"]="\[InvisibleSpace]2977546171600000\),
      SequenceForm[ "form[", 2, ",", 1, ",", 9, "]=", 2977546171600000],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]9
        \[InvisibleSpace]"]="\[InvisibleSpace]2977546171600000\),
      SequenceForm[ "formexact[", 2, ",", 1, ",", 9, "]=", 2977546171600000],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]10
        \[InvisibleSpace]"]="\[InvisibleSpace]1208883745669600000\),
      SequenceForm[ "form[", 2, ",", 1, ",", 10, "]=", 1208883745669600000],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]10
        \[InvisibleSpace]"]="\[InvisibleSpace]1208883745669600000\),
      SequenceForm[ 
      "formexact[", 2, ",", 1, ",", 10, "]=", 1208883745669600000],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    \("   "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]0
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 2, ",", 2, ",", 0, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]0
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 2, ",", 2, ",", 0, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]"]="\[InvisibleSpace]1\),
      SequenceForm[ "form[", 2, ",", 2, ",", 1, "]=", 1],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]"]="\[InvisibleSpace]1\),
      SequenceForm[ "formexact[", 2, ",", 2, ",", 1, "]=", 1],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]"]="\[InvisibleSpace]20\),
      SequenceForm[ "form[", 2, ",", 2, ",", 2, "]=", 20],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]"]="\[InvisibleSpace]20\),
      SequenceForm[ "formexact[", 2, ",", 2, ",", 2, "]=", 20],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]"]="\[InvisibleSpace]840\),
      SequenceForm[ "form[", 2, ",", 2, ",", 3, "]=", 840],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]"]="\[InvisibleSpace]840\),
      SequenceForm[ "formexact[", 2, ",", 2, ",", 3, "]=", 840],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]"]="\[InvisibleSpace]61600\),
      SequenceForm[ "form[", 2, ",", 2, ",", 4, "]=", 61600],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]"]="\[InvisibleSpace]61600\),
      SequenceForm[ "formexact[", 2, ",", 2, ",", 4, "]=", 61600],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]"]="\[InvisibleSpace]7007000\),
      SequenceForm[ "form[", 2, ",", 2, ",", 5, "]=", 7007000],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]"]="\[InvisibleSpace]7007000\),
      SequenceForm[ "formexact[", 2, ",", 2, ",", 5, "]=", 7007000],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]6
        \[InvisibleSpace]"]="\[InvisibleSpace]1143542400\),
      SequenceForm[ "form[", 2, ",", 2, ",", 6, "]=", 1143542400],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]6
        \[InvisibleSpace]"]="\[InvisibleSpace]1143542400\),
      SequenceForm[ "formexact[", 2, ",", 2, ",", 6, "]=", 1143542400],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]7
        \[InvisibleSpace]"]="\[InvisibleSpace]253485232000\),
      SequenceForm[ "form[", 2, ",", 2, ",", 7, "]=", 253485232000],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]7
        \[InvisibleSpace]"]="\[InvisibleSpace]253485232000\),
      SequenceForm[ "formexact[", 2, ",", 2, ",", 7, "]=", 253485232000],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]8
        \[InvisibleSpace]"]="\[InvisibleSpace]73293444224000\),
      SequenceForm[ "form[", 2, ",", 2, ",", 8, "]=", 73293444224000],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]8
        \[InvisibleSpace]"]="\[InvisibleSpace]73293444224000\),
      SequenceForm[ "formexact[", 2, ",", 2, ",", 8, "]=", 73293444224000],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]9
        \[InvisibleSpace]"]="\[InvisibleSpace]26797915544400000\),
      SequenceForm[ "form[", 2, ",", 2, ",", 9, "]=", 26797915544400000],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]9
        \[InvisibleSpace]"]="\[InvisibleSpace]26797915544400000\),
      SequenceForm[ "formexact[", 2, ",", 2, ",", 9, "]=", 26797915544400000],
      
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]10
        \[InvisibleSpace]"]="\[InvisibleSpace]12088837456696000000\),
      SequenceForm[ "form[", 2, ",", 2, ",", 10, "]=", 12088837456696000000],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]10
        \[InvisibleSpace]"]="\[InvisibleSpace]12088837456696000000\),
      SequenceForm[ 
      "formexact[", 2, ",", 2, ",", 10, "]=", 12088837456696000000],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    \({8.71666666666666856`\ Second, Null}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(MemoryInUse[]\)], "Input"],

Cell[BoxData[
    \(898856\)], "Output"]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["\<\
Computing the moments of the d-dimensional canonical form  \
performing numerical computations with the machine precision\
\>", "Section",
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell["\<\
Loading the package shfv.m, the package datashfv3.m is automaticaly \
loaded\
\>", "Subsection"],

Cell[BoxData[
    \(\(<< shohatfavard`shfv`\ ; \)\)], "Input"]
}, Closed]],

Cell[CellGroupData[{

Cell["Computing the moments of the d-dimensional form", "Subsection"],

Cell[BoxData[
    \(\( (*\ set\ the\ values\ of\ d\ and\ nmax\ *) \nd = 2; \ nmax = \ 40\ ; 
    \ \ \ \  (*\ for\ example\ *) \)\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(MemoryInUse[]\)], "Input"],

Cell[BoxData[
    \(897248\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Timing[printdcanform[d,nmax,$MachinePrecision,$MachinePrecision,\
True,True]]\
\>", "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    \("   "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("form["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["1.`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "form[", 2, ",", 1, ",", 0, "]=", 1.0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("formexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["1.`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "formexact[", 2, ",", 1, ",", 0, "]=", 1.0],
      Editable->False]], "Print"],

Cell[BoxData[
    \(MantissaExponent::"realx" \( : \ \) 
      "\!\(1\) is not an inexact real number."\)], "Message"],

Cell[BoxData[
    \(Part::"partw" \( : \ \) 
      "Part \!\(2\) of \!\(MantissaExponent[1]\) does not exist."\)], 
  "Message"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        InterpretationBox["\[Infinity]",
          DirectedInfinity[ 1]]}],
      SequenceForm[ "exactdigits[", 2, ",", 1, ",", 0, "]=", 
        DirectedInfinity[ 1]],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("form["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["1.`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "form[", 2, ",", 1, ",", 1, "]=", 1.0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("formexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["1.`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "formexact[", 2, ",", 1, ",", 1, "]=", 1.0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        InterpretationBox["\[Infinity]",
          DirectedInfinity[ 1]]}],
      SequenceForm[ "exactdigits[", 2, ",", 1, ",", 1, "]=", 
        DirectedInfinity[ 1]],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("form["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["10.`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "form[", 2, ",", 1, ",", 2, "]=", 10.0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("formexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["10.`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "formexact[", 2, ",", 1, ",", 2, "]=", 10.0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        InterpretationBox["\[Infinity]",
          DirectedInfinity[ 1]]}],
      SequenceForm[ "exactdigits[", 2, ",", 1, ",", 2, "]=", 
        DirectedInfinity[ 1]],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("form["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["279.999999999999982`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "form[", 2, ",", 1, ",", 3, "]=", 280.0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("formexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["279.999999999999982`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "formexact[", 2, ",", 1, ",", 3, "]=", 280.0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        InterpretationBox["\[Infinity]",
          DirectedInfinity[ 1]]}],
      SequenceForm[ "exactdigits[", 2, ",", 1, ",", 3, "]=", 
        DirectedInfinity[ 1]],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("form["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "4", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["15400.0000000000003`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "form[", 2, ",", 1, ",", 4, "]=", 15400.0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("formexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "4", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["15400.0000000000003`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "formexact[", 2, ",", 1, ",", 4, "]=", 15400.0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "4", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        InterpretationBox["\[Infinity]",
          DirectedInfinity[ 1]]}],
      SequenceForm[ "exactdigits[", 2, ",", 1, ",", 4, "]=", 
        DirectedInfinity[ 1]],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("form["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "5", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["1.40139999999999993`*^6",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "form[", 2, ",", 1, ",", 5, "]=", 1401400.0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("formexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "5", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["1.40139999999999993`*^6",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "formexact[", 2, ",", 1, ",", 5, "]=", 1401400.0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "5", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        InterpretationBox["\[Infinity]",
          DirectedInfinity[ 1]]}],
      SequenceForm[ "exactdigits[", 2, ",", 1, ",", 5, "]=", 
        DirectedInfinity[ 1]],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("form["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "6", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["1.90590399999999995`*^8",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "form[", 2, ",", 1, ",", 6, "]=", 190590400.0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("formexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "6", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["1.90590399999999995`*^8",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "formexact[", 2, ",", 1, ",", 6, "]=", 190590400.0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "6", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        InterpretationBox["\[Infinity]",
          DirectedInfinity[ 1]]}],
      SequenceForm[ "exactdigits[", 2, ",", 1, ",", 6, "]=", 
        DirectedInfinity[ 1]],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("form["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "7", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["3.62121760000000003`*^10",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "form[", 2, ",", 1, ",", 7, "]=", 36212176000.0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("formexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "7", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["3.62121760000000003`*^10",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "formexact[", 2, ",", 1, ",", 7, "]=", 36212176000.0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "7", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        InterpretationBox["\[Infinity]",
          DirectedInfinity[ 1]]}],
      SequenceForm[ "exactdigits[", 2, ",", 1, ",", 7, "]=", 
        DirectedInfinity[ 1]],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("form["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "8", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["9.16168052800000154`*^12",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "form[", 2, ",", 1, ",", 8, "]=", 9161680528000.0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("formexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "8", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["9.16168052800000154`*^12",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "formexact[", 2, ",", 1, ",", 8, "]=", 9161680528000.0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "8", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        InterpretationBox["\[Infinity]",
          DirectedInfinity[ 1]]}],
      SequenceForm[ "exactdigits[", 2, ",", 1, ",", 8, "]=", 
        DirectedInfinity[ 1]],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("form["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "9", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["2.97754617160000023`*^15",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "form[", 2, ",", 1, ",", 9, "]=", 2977546171600000.0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("formexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "9", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["2.97754617160000023`*^15",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "formexact[", 2, ",", 1, ",", 9, "]=", 2977546171600000.0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "9", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        InterpretationBox["\[Infinity]",
          DirectedInfinity[ 1]]}],
      SequenceForm[ "exactdigits[", 2, ",", 1, ",", 9, "]=", 
        DirectedInfinity[ 1]],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("form["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "10", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["1.20888374566961975`*^18",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "form[", 2, ",", 1, ",", 10, "]=", 1.2088837456696197*^+18],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("formexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "10", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["1.20888374566960021`*^18",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "formexact[", 2, ",", 1, ",", 10, "]=", 1.2088837456696*^+18],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "10", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["13.7052693095156685`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 2, ",", 1, ",", 10, "]=", 13.705269309515669],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("form["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "11", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["5.99606337852290405`*^20",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "form[", 2, ",", 1, ",", 11, "]=", 5.9960633785229037*^+20],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("formexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "11", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["5.99606337852121562`*^20",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "formexact[", 2, ",", 1, ",", 11, "]=", 5.9960633785212155*^+20],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "11", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["11.7725742106885267`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 2, ",", 1, ",", 11, "]=", 11.772574210688527],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("form["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "12", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["3.56765771022715849`*^23",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "form[", 2, ",", 1, ",", 12, "]=", 3.5676577102271584*^+23],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("formexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "12", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["3.56765771022012367`*^23",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "formexact[", 2, ",", 1, ",", 12, "]=", 3.5676577102201234*^+23],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "12", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["11.1527345269399402`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 2, ",", 1, ",", 12, "]=", 11.152734526939939],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("form["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "13", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["2.50806337030628512`*^26",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "form[", 2, ",", 1, ",", 13, "]=", 2.508063370306285*^+26],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("formexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "13", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["2.50806337028474679`*^26",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "formexact[", 2, ",", 1, ",", 13, "]=", 2.508063370284747*^+26],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "13", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["10.6667934498208394`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 2, ",", 1, ",", 13, "]=", 10.66679344982084],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("form["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "14", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["2.05661196368775867`*^29",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "form[", 2, ",", 1, ",", 14, "]=", 2.0566119636877589*^+29],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("formexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "14", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["2.0566119636334923`*^29",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "formexact[", 2, ",", 1, ",", 14, "]=", 2.0566119636334926*^+29],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "14", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["10.2654700731262482`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 2, ",", 1, ",", 14, "]=", 10.265470073126249],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("form["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "15", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["1.94555491770738733`*^32",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "form[", 2, ",", 1, ",", 15, "]=", 1.9455549177073874*^+32],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("formexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "15", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["1.94555491759728376`*^32",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "formexact[", 2, ",", 1, ",", 15, "]=", 1.9455549175972838*^+32],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "15", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["9.95819830970039632`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 2, ",", 1, ",", 15, "]=", 9.9581983097003963],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("form["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "16", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["2.10314486604545791`*^35",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "form[", 2, ",", 1, ",", 16, "]=", 2.103144866045458*^+35],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("formexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "16", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["2.10314486592266369`*^35",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "formexact[", 2, ",", 1, ",", 16, "]=", 2.103144865922664*^+35],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "16", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["9.91082259746123384`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 2, ",", 1, ",", 16, "]=", 9.9108225974612338],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("form["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "17", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["2.57635246031917475`*^38",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "form[", 2, ",", 1, ",", 17, "]=", 2.5763524603191749*^+38],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("formexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "17", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["2.57635246075526325`*^38",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "formexact[", 2, ",", 1, ",", 17, "]=", 2.5763524607552631*^+38],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "17", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["9.36042560973534776`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 2, ",", 1, ",", 17, "]=", 9.3604256097353478],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("form["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "18", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["3.550213686197627`*^41",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "form[", 2, ",", 1, ",", 18, "]=", 3.5502136861976265*^+41],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("formexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "18", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["3.550213690920752`*^41",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "formexact[", 2, ",", 1, ",", 18, "]=", 3.5502136909207523*^+41],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "18", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["8.32577048825702803`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 2, ",", 1, ",", 18, "]=", 8.325770488257028],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("form["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "19", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["5.46732905323612872`*^44",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "form[", 2, ",", 1, ",", 19, "]=", 5.4673290532361288*^+44],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("formexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "19", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["5.46732908401795825`*^44",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "formexact[", 2, ",", 1, ",", 19, "]=", 5.4673290840179591*^+44],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "19", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["7.51170556067737038`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 2, ",", 1, ",", 19, "]=", 7.5117055606773704],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("form["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "20", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["9.35459987971421824`*^47",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "form[", 2, ",", 1, ",", 20, "]=", 9.3545998797142195*^+47],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("formexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "20", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["9.35460006275472721`*^47",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "formexact[", 2, ",", 1, ",", 20, "]=", 9.3546000627547283*^+47],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "20", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["6.7374527857440043`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 2, ",", 1, ",", 20, "]=", 6.7374527857440043],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("form["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "21", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["1.76895476424064002`*^51",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "form[", 2, ",", 1, ",", 21, "]=", 1.76895476424064*^+51],
      
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("formexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "21", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["1.76895487186691946`*^51",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "formexact[", 2, ",", 1, ",", 21, "]=", 1.7689548718669192*^+51],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "21", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["6.96808167365681896`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 2, ",", 1, ",", 21, "]=", 6.968081673656819],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("form["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "22", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["3.67942549743770097`*^54",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "form[", 2, ",", 1, ",", 22, "]=", 3.6794254974377022*^+54],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("formexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "22", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["3.67942613348319236`*^54",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "formexact[", 2, ",", 1, ",", 22, "]=", 3.6794261334831919*^+54],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "22", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["6.19651182269101497`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 2, ",", 1, ",", 22, "]=", 6.196511822691015],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("form["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "23", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["8.38172895460285971`*^57",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "form[", 2, ",", 1, ",", 23, "]=", 8.3817289546028612*^+57],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("formexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "23", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["8.38173273207471147`*^57",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "formexact[", 2, ",", 1, ",", 23, "]=", 8.3817327320747108*^+57],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "23", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["5.42279876341108035`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 2, ",", 1, ",", 23, "]=", 5.4227987634110804],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("form["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "24", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["2.08285833520875218`*^61",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "form[", 2, ",", 1, ",", 24, "]=", 2.0828583352087523*^+61],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("formexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "24", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["2.08286058392056538`*^61",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "formexact[", 2, ",", 1, ",", 24, "]=", 2.0828605839205656*^+61],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "24", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["5.64806619857855451`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 2, ",", 1, ",", 24, "]=", 5.6480661985785545],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("form["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "25", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["5.62579320204960175`*^64",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "form[", 2, ",", 1, ",", 25, "]=", 5.6257932020496022*^+64],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("formexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "25", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["5.62580643716944628`*^64",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "formexact[", 2, ",", 1, ",", 25, "]=", 5.6258064371694474*^+64],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "25", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["4.87827212176730995`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 2, ",", 1, ",", 25, "]=", 4.87827212176731],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("form["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "26", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["1.64610383593870608`*^68",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "form[", 2, ",", 1, ",", 26, "]=", 1.6461038359387062*^+68],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("formexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "26", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["1.64611096351578041`*^68",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "formexact[", 2, ",", 1, ",", 26, "]=", 1.6461109635157804*^+68],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "26", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["5.14705807774234358`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 2, ",", 1, ",", 26, "]=", 5.1470580777423436],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("form["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "27", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["5.20168965102666902`*^71",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "form[", 2, ",", 1, ",", 27, "]=", 5.2016896510266691*^+71],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("formexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "27", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["5.20171064470986532`*^71",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "formexact[", 2, ",", 1, ",", 27, "]=", 5.201710644709866*^+71],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "27", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["4.67791136076091618`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 2, ",", 1, ",", 27, "]=", 4.6779113607609162],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("form["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "28", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["1.77017780852446797`*^75",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "form[", 2, ",", 1, ",", 28, "]=", 1.7701778085244681*^+75],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("formexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "28", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["1.7701421323947672`*^75",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "formexact[", 2, ",", 1, ",", 28, "]=", 1.7701421323947674*^+75],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "28", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["4.44762226586522047`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 2, ",", 1, ",", 28, "]=", 4.4476222658652205],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("form["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "29", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["6.47103597382207595`*^78",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "form[", 2, ",", 1, ",", 29, "]=", 6.4710359738220756*^+78],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("formexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "29", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["6.46986949390287513`*^78",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "formexact[", 2, ",", 1, ",", 29, "]=", 6.4698694939028751*^+78],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "29", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["2.93312273312871241`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 2, ",", 1, ",", 29, "]=", 2.9331227331287124],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("form["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "30", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["2.53606011416443299`*^82",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "form[", 2, ",", 1, ",", 30, "]=", 2.5360601141644333*^+82],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("formexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "30", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["2.53360089381236575`*^82",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "formexact[", 2, ",", 1, ",", 30, "]=", 2.5336008938123656*^+82],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "30", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["2.6092025556860392`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 2, ",", 1, ",", 30, "]=", 2.6092025556860392],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("form["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "31", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["1.0651884307768924`*^86",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "form[", 2, ",", 1, ",", 31, "]=", 1.0651884307768924*^+86],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("formexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "31", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["1.0605653341498562`*^86",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "formexact[", 2, ",", 1, ",", 31, "]=", 1.0605653341498563*^+86],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "31", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["2.33506702930688447`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 2, ",", 1, ",", 31, "]=", 2.3350670293068845],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("form["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "32", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["4.81898102040787712`*^89",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "form[", 2, ",", 1, ",", 32, "]=", 4.8189810204078758*^+89],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("formexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "32", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["4.73542421697910853`*^89",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "formexact[", 2, ",", 1, ",", 32, "]=", 4.7354242169791086*^+89],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "32", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["1.07801818285881267`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 2, ",", 1, ",", 32, "]=", 1.0780181828588127],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("form["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "33", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["2.40053573062633329`*^93",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "form[", 2, ",", 1, ",", 33, "]=", 2.4005357306263333*^+93],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("formexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "33", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["2.25074713033016982`*^93",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "formexact[", 2, ",", 1, ",", 33, "]=", 2.25074713033017*^+93],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "33", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["0.824521237483423874`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 2, ",", 1, ",", 33, "]=", 0.82452123748342387],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("form["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "34", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["1.40728488218978631`*^97",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "form[", 2, ",", 1, ",", 34, "]=", 1.4072848821897865*^+97],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("formexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "34", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["1.13662730081673601`*^97",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "formexact[", 2, ",", 1, ",", 34, "]=", 1.1366273008167361*^+97],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "34", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["0.567579803406232485`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 2, ",", 1, ",", 34, "]=", 0.56757980340623249],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("form["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "35", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["1.10573604059436481`*^101",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "form[", 2, ",", 1, ",", 35, "]=", 1.1057360405943645*^+101],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("formexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "35", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["6.08777582317443854`*^100",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "formexact[", 2, ",", 1, ",", 35, "]=", 6.0877758231744381*^+100],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "35", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["0.303679913268965151`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 2, ",", 1, ",", 35, "]=", 0.30367991326896515],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("form["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "36", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["1.27486538869653376`*^105",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "form[", 2, ",", 1, ",", 36, "]=", 1.2748653886965338*^+105],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("formexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "36", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["3.45237766932222456`*^104",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "formexact[", 2, ",", 1, ",", 36, "]=", 3.4523776693222239*^+104],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "36", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["0.0316909806921330527`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 2, ",", 1, ",", 36, "]=", 0.031690980692133053],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("form["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "37", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["1.97642594960127091`*^109",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "form[", 2, ",", 1, ",", 37, "]=", 1.9764259496012708*^+109],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("formexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "37", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["2.06970041275867311`*^108",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "formexact[", 2, ",", 1, ",", 37, "]=", 2.069700412758673*^+108],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "37", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        RowBox[{"-", 
          StyleBox["0.247839745267086186`",
            StyleBoxAutoDelete->True,
            PrintPrecision->2]}]}],
      SequenceForm[ 
      "exactdigits[", 2, ",", 1, ",", 37, "]=", -0.24783974526708619],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("form["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "38", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["3.54510209414025023`*^113",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "form[", 2, ",", 1, ",", 38, "]=", 3.5451020941402495*^+113],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("formexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "38", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["1.30970642119368863`*^112",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "formexact[", 2, ",", 1, ",", 38, "]=", 1.3097064211936884*^+112],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "38", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        RowBox[{"-", 
          StyleBox["0.533280238450728916`",
            StyleBoxAutoDelete->True,
            PrintPrecision->2]}]}],
      SequenceForm[ 
      "exactdigits[", 2, ",", 1, ",", 38, "]=", -0.53328023845072892],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("form["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "39", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["6.72990041308989184`*^117",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "form[", 2, ",", 1, ",", 39, "]=", 6.7299004130898922*^+117],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("formexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "39", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["8.73574182936190091`*^115",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "formexact[", 2, ",", 1, ",", 39, "]=", 8.7357418293619012*^+115],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "39", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        RowBox[{"-", 
          StyleBox["0.822334374123684597`",
            StyleBoxAutoDelete->True,
            PrintPrecision->2]}]}],
      SequenceForm[ 
      "exactdigits[", 2, ",", 1, ",", 39, "]=", -0.8223343741236846],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("form["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "40", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["1.30088857297206716`*^122",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "form[", 2, ",", 1, ",", 40, "]=", 1.3008885729720673*^+122],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("formexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "40", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["6.13336433839499139`*^119",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "formexact[", 2, ",", 1, ",", 40, "]=", 6.1333643383949909*^+119],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "40", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        RowBox[{"-", 
          StyleBox["0.11218766680428871`",
            StyleBoxAutoDelete->True,
            PrintPrecision->2]}]}],
      SequenceForm[ 
      "exactdigits[", 2, ",", 1, ",", 40, "]=", -0.11218766680428871],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    \("   "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]0
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 2, ",", 2, ",", 0, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]0
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 2, ",", 2, ",", 0, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]0
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 2, ",", 2, ",", 0, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("form["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["1.`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "form[", 2, ",", 2, ",", 1, "]=", 1.0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("formexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["1.`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "formexact[", 2, ",", 2, ",", 1, "]=", 1.0],
      Editable->False]], "Print"],

Cell[BoxData[
    \(MantissaExponent::"realx" \( : \ \) 
      "\!\(1\) is not an inexact real number."\)], "Message"],

Cell[BoxData[
    \(Part::"partw" \( : \ \) 
      "Part \!\(2\) of \!\(MantissaExponent[1]\) does not exist."\)], 
  "Message"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        InterpretationBox["\[Infinity]",
          DirectedInfinity[ 1]]}],
      SequenceForm[ "exactdigits[", 2, ",", 2, ",", 1, "]=", 
        DirectedInfinity[ 1]],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("form["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["20.`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "form[", 2, ",", 2, ",", 2, "]=", 20.0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("formexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["20.`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "formexact[", 2, ",", 2, ",", 2, "]=", 20.0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        InterpretationBox["\[Infinity]",
          DirectedInfinity[ 1]]}],
      SequenceForm[ "exactdigits[", 2, ",", 2, ",", 2, "]=", 
        DirectedInfinity[ 1]],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("form["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["840.000000000000035`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "form[", 2, ",", 2, ",", 3, "]=", 840.0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("formexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["840.000000000000035`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "formexact[", 2, ",", 2, ",", 3, "]=", 840.0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        InterpretationBox["\[Infinity]",
          DirectedInfinity[ 1]]}],
      SequenceForm[ "exactdigits[", 2, ",", 2, ",", 3, "]=", 
        DirectedInfinity[ 1]],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("form["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "4", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["61600.0000000000014`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "form[", 2, ",", 2, ",", 4, "]=", 61600.0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("formexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "4", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["61600.0000000000014`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "formexact[", 2, ",", 2, ",", 4, "]=", 61600.0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "4", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        InterpretationBox["\[Infinity]",
          DirectedInfinity[ 1]]}],
      SequenceForm[ "exactdigits[", 2, ",", 2, ",", 4, "]=", 
        DirectedInfinity[ 1]],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("form["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "5", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["7.00699999999999967`*^6",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "form[", 2, ",", 2, ",", 5, "]=", 7007000.0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("formexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "5", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["7.00699999999999967`*^6",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "formexact[", 2, ",", 2, ",", 5, "]=", 7007000.0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "5", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        InterpretationBox["\[Infinity]",
          DirectedInfinity[ 1]]}],
      SequenceForm[ "exactdigits[", 2, ",", 2, ",", 5, "]=", 
        DirectedInfinity[ 1]],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("form["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "6", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["1.14354240000000006`*^9",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "form[", 2, ",", 2, ",", 6, "]=", 1143542400.0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("formexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "6", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["1.14354240000000006`*^9",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "formexact[", 2, ",", 2, ",", 6, "]=", 1143542400.0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "6", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        InterpretationBox["\[Infinity]",
          DirectedInfinity[ 1]]}],
      SequenceForm[ "exactdigits[", 2, ",", 2, ",", 6, "]=", 
        DirectedInfinity[ 1]],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("form["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "7", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["2.53485231999999971`*^11",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "form[", 2, ",", 2, ",", 7, "]=", 253485232000.0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("formexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "7", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["2.53485231999999971`*^11",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "formexact[", 2, ",", 2, ",", 7, "]=", 253485232000.0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "7", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        InterpretationBox["\[Infinity]",
          DirectedInfinity[ 1]]}],
      SequenceForm[ "exactdigits[", 2, ",", 2, ",", 7, "]=", 
        DirectedInfinity[ 1]],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("form["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "8", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["7.32934442240000105`*^13",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "form[", 2, ",", 2, ",", 8, "]=", 73293444224000.0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("formexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "8", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["7.32934442240000105`*^13",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "formexact[", 2, ",", 2, ",", 8, "]=", 73293444224000.0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "8", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        InterpretationBox["\[Infinity]",
          DirectedInfinity[ 1]]}],
      SequenceForm[ "exactdigits[", 2, ",", 2, ",", 8, "]=", 
        DirectedInfinity[ 1]],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("form["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "9", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["2.67979155444000038`*^16",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "form[", 2, ",", 2, ",", 9, "]=", 26797915544400000.0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("formexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "9", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["2.67979155444000038`*^16",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "formexact[", 2, ",", 2, ",", 9, "]=", 26797915544400000.0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "9", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        InterpretationBox["\[Infinity]",
          DirectedInfinity[ 1]]}],
      SequenceForm[ "exactdigits[", 2, ",", 2, ",", 9, "]=", 
        DirectedInfinity[ 1]],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("form["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "10", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["1.20888374566959333`*^19",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "form[", 2, ",", 2, ",", 10, "]=", 1.2088837456695935*^+19],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("formexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "10", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["1.20888374566959977`*^19",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "formexact[", 2, ",", 2, ",", 10, "]=", 1.2088837456696001*^+19],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "10", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["14.1835200693763008`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 2, ",", 2, ",", 10, "]=", 14.183520069376302],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("form["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "11", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["6.59566971637324961`*^21",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "form[", 2, ",", 2, ",", 11, "]=", 6.59566971637325*^+21],
      
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("formexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "11", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["6.59566971637333843`*^21",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "formexact[", 2, ",", 2, ",", 11, "]=", 6.5956697163733381*^+21],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "11", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["13.0551208006584951`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 2, ",", 2, ",", 11, "]=", 13.055120800658495],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("form["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "12", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["4.28118925226466107`*^24",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "form[", 2, ",", 2, ",", 12, "]=", 4.2811892522646616*^+24],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("formexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "12", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["4.28118925226414859`*^24",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "formexact[", 2, ",", 2, ",", 12, "]=", 4.2811892522641484*^+24],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "12", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["12.2896722334684449`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 2, ",", 2, ",", 12, "]=", 12.289672233468446],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("form["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "13", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["3.26048238137418389`*^27",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "form[", 2, ",", 2, ",", 13, "]=", 3.2604823813741836*^+27],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("formexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "13", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["3.26048238137017065`*^27",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "formexact[", 2, ",", 2, ",", 13, "]=", 3.2604823813701709*^+27],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "13", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["11.3965668054542534`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 2, ",", 2, ",", 13, "]=", 11.396566805454254],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("form["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "14", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["2.87925674910512299`*^30",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "form[", 2, ",", 2, ",", 14, "]=", 2.8792567491051229*^+30],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("formexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "14", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["2.87925674908689011`*^30",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "formexact[", 2, ",", 2, ",", 14, "]=", 2.8792567490868895*^+30],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "14", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["10.7391326729507707`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 2, ",", 2, ",", 14, "]=", 10.73913267295077],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("form["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "15", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["2.91833237646120622`*^33",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "form[", 2, ",", 2, ",", 15, "]=", 2.9183323764612064*^+33],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("formexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "15", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["2.91833237639592582`*^33",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "formexact[", 2, ",", 2, ",", 15, "]=", 2.9183323763959257*^+33],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "15", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["10.1852150547289466`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 2, ",", 2, ",", 15, "]=", 10.185215054728946],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("form["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "16", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["3.36503178566069127`*^36",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "form[", 2, ",", 2, ",", 16, "]=", 3.3650317856606908*^+36],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("formexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "16", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["3.36503178547626191`*^36",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "formexact[", 2, ",", 2, ",", 16, "]=", 3.3650317854762623*^+36],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "16", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["9.73417201018709832`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 2, ",", 2, ",", 16, "]=", 9.7341720101870983],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("form["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "17", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["4.37979918356818753`*^39",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "form[", 2, ",", 2, ",", 17, "]=", 4.3797991835681877*^+39],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("formexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "17", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["4.37979918328394735`*^39",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "formexact[", 2, ",", 2, ",", 17, "]=", 4.3797991832839475*^+39],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "17", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["9.54631446806949313`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 2, ",", 2, ",", 17, "]=", 9.5463144680694931],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("form["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "18", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["6.39038464230775016`*^42",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "form[", 2, ",", 2, ",", 18, "]=", 6.3903846423077504*^+42],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("formexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "18", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["6.39038464365735503`*^42",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "formexact[", 2, ",", 2, ",", 18, "]=", 6.3903846436573551*^+42],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "18", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["8.8697934158263294`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 2, ",", 2, ",", 18, "]=", 8.8697934158263294],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("form["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "19", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["1.03879252400518784`*^46",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "form[", 2, ",", 2, ",", 19, "]=", 1.0387925240051877*^+46],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("formexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "19", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["1.03879252596341231`*^46",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "formexact[", 2, ",", 2, ",", 19, "]=", 1.0387925259634123*^+46],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "19", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["8.70813750655124607`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 2, ",", 2, ",", 19, "]=", 8.7081375065512461],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("form["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "20", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["1.8709199961038422`*^49",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "form[", 2, ",", 2, ",", 20, "]=", 1.870919996103842*^+49],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("formexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "20", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["1.87092001255094544`*^49",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "formexact[", 2, ",", 2, ",", 20, "]=", 1.8709200125509455*^+49],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "20", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["7.78391057636699201`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 2, ",", 2, ",", 20, "]=", 7.783910576366992],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("form["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "21", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["3.71480511018133885`*^52",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "form[", 2, ",", 2, ",", 21, "]=", 3.7148051101813396*^+52],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("formexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "21", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["3.71480523092053038`*^52",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "formexact[", 2, ",", 2, ",", 21, "]=", 3.71480523092053*^+52],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "21", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["6.91815174053802905`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 2, ",", 2, ",", 21, "]=", 6.9181517405380291],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("form["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "22", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["8.09473664815762639`*^55",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "form[", 2, ",", 2, ",", 22, "]=", 8.0947366481576269*^+55],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("formexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "22", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["8.09473749366302186`*^55",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "formexact[", 2, ",", 2, ",", 22, "]=", 8.0947374936630213*^+55],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "22", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["6.07288361721409586`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 2, ",", 2, ",", 22, "]=", 6.0728836172140959],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("form["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "23", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["1.92779794448372321`*^59",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "form[", 2, ",", 2, ",", 23, "]=", 1.927797944483723*^+59],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("formexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "23", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["1.92779852837718337`*^59",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "formexact[", 2, ",", 2, ",", 23, "]=", 1.9277985283771834*^+59],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "23", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["6.23366638882146162`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 2, ",", 2, ",", 23, "]=", 6.2336663888214616],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("form["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "24", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["4.99886136190213115`*^62",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "form[", 2, ",", 2, ",", 24, "]=", 4.9988613619021318*^+62],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("formexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "24", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["4.99886540140935675`*^62",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "formexact[", 2, ",", 2, ",", 24, "]=", 4.9988654014093573*^+62],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "24", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["5.39367161070921952`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 2, ",", 2, ",", 24, "]=", 5.3936716107092195],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("form["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "25", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["1.40644879706722374`*^66",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "form[", 2, ",", 2, ",", 25, "]=", 1.4064487970672239*^+66],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("formexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "25", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["1.40645160929236183`*^66",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "formexact[", 2, ",", 2, ",", 25, "]=", 1.4064516092923618*^+66],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "25", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["5.55094991400506643`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 2, ",", 2, ",", 25, "]=", 5.5509499140050664],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("form["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "26", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["4.27986902337610253`*^69",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "form[", 2, ",", 2, ",", 26, "]=", 4.279869023376102*^+69],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("formexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "26", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["4.27988850514102825`*^69",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "formexact[", 2, ",", 2, ",", 26, "]=", 4.2798885051410286*^+69],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "26", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["4.71037170129930871`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 2, ",", 2, ",", 26, "]=", 4.7103717012993087],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("form["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "27", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["1.4044490365989195`*^73",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "form[", 2, ",", 2, ",", 27, "]=", 1.4044490365989194*^+73],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("formexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "27", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["1.40446187407166389`*^73",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "formexact[", 2, ",", 2, ",", 27, "]=", 1.4044618740716639*^+73],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "27", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["4.89152046545626717`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 2, ",", 2, ",", 27, "]=", 4.8915204654562672],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("form["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "28", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["4.95632964277455023`*^76",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "form[", 2, ",", 2, ",", 28, "]=", 4.9563296427745501*^+76],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("formexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "28", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["4.95639797070534804`*^76",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "formexact[", 2, ",", 2, ",", 28, "]=", 4.9563979707053486*^+76],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "28", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["4.16540173098783839`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 2, ",", 2, ",", 28, "]=", 4.1654017309878384],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("form["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "29", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["1.87626133662631886`*^80",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "form[", 2, ",", 2, ",", 29, "]=", 1.8762613366263187*^+80],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("formexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "29", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["1.8762621532318338`*^80",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "formexact[", 2, ",", 2, ",", 29, "]=", 1.8762621532318338*^+80],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "29", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["6.08798769132390305`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 2, ",", 2, ",", 29, "]=", 6.0879876913239031],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("form["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "30", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["7.6017359962662141`*^83",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "form[", 2, ",", 2, ",", 30, "]=", 7.6017359962662124*^+83],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("formexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "30", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["7.6008026814370968`*^83",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "formexact[", 2, ",", 2, ",", 30, "]=", 7.6008026814370977*^+83],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "30", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["3.02997183376285761`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 2, ",", 2, ",", 30, "]=", 3.0299718337628576],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("form["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "31", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["3.29023147272251303`*^87",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "form[", 2, ",", 2, ",", 31, "]=", 3.290231472722513*^+87],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("formexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "31", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["3.28775253586455429`*^87",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "formexact[", 2, ",", 2, ",", 31, "]=", 3.2877525358645544*^+87],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "31", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["2.60573453518837538`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 2, ",", 2, ",", 31, "]=", 2.6057345351883754],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("form["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "32", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["1.52063772659100004`*^91",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "form[", 2, ",", 2, ",", 32, "]=", 1.5206377265910003*^+91],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("formexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "32", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["1.51533574943331483`*^91",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "formexact[", 2, ",", 2, ",", 32, "]=", 1.5153357494333147*^+91],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "32", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["2.27556214765395736`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 2, ",", 2, ",", 32, "]=", 2.2755621476539574],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("form["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "33", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["7.53560248839821689`*^94",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "form[", 2, ",", 2, ",", 33, "]=", 7.5356024883982174*^+94],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("formexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "33", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["7.42746553008956311`*^94",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "formexact[", 2, ",", 2, ",", 33, "]=", 7.4274655300895613*^+94],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "33", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["0.966025850483944736`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 2, ",", 2, ",", 33, "]=", 0.96602585048394474],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("form["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "34", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["4.08485056613504049`*^98",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "form[", 2, ",", 2, ",", 34, "]=", 4.0848505661350401*^+98],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("formexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "34", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["3.86453282277690224`*^98",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "formexact[", 2, ",", 2, ",", 34, "]=", 3.8645328227769026*^+98],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "34", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["0.656950525399281559`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 2, ",", 2, ",", 34, "]=", 0.65695052539928156],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("form["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "35", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["2.58539780777653538`*^102",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "form[", 2, ",", 2, ",", 35, "]=", 2.5853978077765357*^+102],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("formexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "35", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["2.13072153811105335`*^102",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "formexact[", 2, ",", 2, ",", 35, "]=", 2.1307215381110533*^+102],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "35", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["0.342297711777476365`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 2, ",", 2, ",", 35, "]=", 0.34229771177747637],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("form["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "36", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["2.19534514468296304`*^106",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "form[", 2, ",", 2, ",", 36, "]=", 2.1953451446829627*^+106],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("formexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "36", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["1.24285596095600037`*^106",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "formexact[", 2, ",", 2, ",", 36, "]=", 1.2428559609560004*^+106],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "36", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["0.0211399473839719576`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 2, ",", 2, ",", 36, "]=", 0.021139947383971958],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("form["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "37", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["2.78747976414071052`*^110",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "form[", 2, ",", 2, ",", 37, "]=", 2.7874797641407104*^+110],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("formexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "37", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["7.65789152720709154`*^109",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "formexact[", 2, ",", 2, ",", 37, "]=", 7.6578915272070907*^+109],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "37", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        RowBox[{"-", 
          StyleBox["0.30571469426493536`",
            StyleBoxAutoDelete->True,
            PrintPrecision->2]}]}],
      SequenceForm[ 
      "exactdigits[", 2, ",", 2, ",", 37, "]=", -0.30571469426493536],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("form["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "38", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["4.83426815680889365`*^114",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "form[", 2, ",", 2, ",", 38, "]=", 4.8342681568088944*^+114],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("formexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "38", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["4.97688440053601599`*^113",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "formexact[", 2, ",", 2, ",", 38, "]=", 4.9768844005360156*^+113],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "38", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        RowBox[{"-", 
          StyleBox["0.637147334175821811`",
            StyleBoxAutoDelete->True,
            PrintPrecision->2]}]}],
      SequenceForm[ 
      "exactdigits[", 2, ",", 2, ",", 38, "]=", -0.63714733417582181],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("form["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "39", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["9.72186733235270139`*^118",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "form[", 2, ",", 2, ",", 39, "]=", 9.7218673323527031*^+118],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("formexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "39", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["3.40693931345114231`*^117",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "formexact[", 2, ",", 2, ",", 39, "]=", 3.4069393134511416*^+117],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "39", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        RowBox[{"-", 
          StyleBox["0.972257163508132293`",
            StyleBoxAutoDelete->True,
            PrintPrecision->2]}]}],
      SequenceForm[ 
      "exactdigits[", 2, ",", 2, ",", 39, "]=", -0.97225716350813229],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("form["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "40", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["2.06856817676603466`*^123",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "form[", 2, ",", 2, ",", 40, "]=", 2.0685681767660354*^+123],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("formexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "40", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["2.45334573535799638`*^121",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "formexact[", 2, ",", 2, ",", 40, "]=", 2.4533457353579964*^+121],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "40", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        RowBox[{"-", 
          StyleBox["0.310488268332122174`",
            StyleBoxAutoDelete->True,
            PrintPrecision->2]}]}],
      SequenceForm[ 
      "exactdigits[", 2, ",", 2, ",", 40, "]=", -0.31048826833212217],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    \({48.0833333333333445`\ Second, Null}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(MemoryInUse[]\)], "Input"],

Cell[BoxData[
    \(985800\)], "Output"]
}, Open  ]]
}, Closed]]
}, Closed]]
},
FrontEndVersion->"Macintosh 3.0",
ScreenRectangle->{{0, 832}, {0, 604}},
WindowSize->{590, 412},
WindowMargins->{{84, Automatic}, {84, Automatic}},
MacintoshSystemPageSetup->"\<\
00<0001804P000000`d26_oQon@3:`8g0dL5N`?P0080001804P000000]P2:001
0000I00000400`<30?l00BL?00400@0000000000000006P801T1T00000000000
00000000004000000000000000000000\>"
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{
Cell[1709, 49, 1286, 22, 628, "Subsection"],

Cell[CellGroupData[{
Cell[3020, 75, 143, 4, 68, "Section"],

Cell[CellGroupData[{
Cell[3188, 83, 107, 3, 44, "Subsection"],
Cell[3298, 88, 62, 1, 27, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[3397, 94, 122, 4, 44, "Subsection"],
Cell[3522, 100, 88, 1, 27, "Input"],
Cell[3613, 103, 142, 2, 43, "Input"],

Cell[CellGroupData[{
Cell[3780, 109, 361, 6, 75, "Input"],
Cell[4144, 117, 302, 6, 22, "Print"],
Cell[4449, 125, 306, 6, 22, "Print"],
Cell[4758, 133, 308, 6, 22, "Print"],
Cell[5069, 141, 310, 6, 22, "Print"],
Cell[5382, 149, 312, 6, 22, "Print"],
Cell[5697, 157, 312, 6, 22, "Print"],
Cell[6012, 165, 314, 6, 22, "Print"],
Cell[6329, 173, 314, 6, 22, "Print"],
Cell[6646, 181, 314, 6, 22, "Print"],
Cell[6963, 189, 37, 1, 22, "Print"],
Cell[7003, 192, 300, 6, 22, "Print"],
Cell[7306, 200, 304, 6, 22, "Print"],
Cell[7613, 208, 306, 6, 22, "Print"],
Cell[7922, 216, 308, 6, 22, "Print"],
Cell[8233, 224, 308, 6, 22, "Print"],
Cell[8544, 232, 308, 6, 22, "Print"],
Cell[8855, 240, 310, 6, 22, "Print"],
Cell[9168, 248, 310, 6, 22, "Print"],
Cell[9481, 256, 310, 6, 22, "Print"],
Cell[9794, 264, 312, 6, 22, "Print"],
Cell[10109, 272, 37, 1, 22, "Print"]
}, Open  ]],

Cell[CellGroupData[{
Cell[10183, 278, 161, 2, 43, "Input"],
Cell[10347, 282, 243, 5, 22, "Print"],
Cell[10593, 289, 245, 5, 22, "Print"],
Cell[10841, 296, 245, 5, 22, "Print"],
Cell[11089, 303, 247, 5, 22, "Print"],
Cell[11339, 310, 247, 5, 22, "Print"],
Cell[11589, 317, 247, 5, 22, "Print"],
Cell[11839, 324, 247, 5, 22, "Print"],
Cell[12089, 331, 247, 5, 22, "Print"],
Cell[12339, 338, 247, 5, 22, "Print"],
Cell[12589, 345, 249, 5, 22, "Print"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{
Cell[12887, 356, 131, 3, 44, "Subsection"],

Cell[CellGroupData[{
Cell[13043, 363, 142, 2, 43, "Input"],
Cell[13188, 367, 175, 3, 37, "Message"]
}, Open  ]],

Cell[CellGroupData[{
Cell[13400, 375, 336, 6, 91, "Input"],
Cell[13739, 383, 314, 7, 22, "Print"],
Cell[14056, 392, 314, 7, 22, "Print"],
Cell[14373, 401, 316, 7, 22, "Print"],
Cell[14692, 410, 318, 7, 22, "Print"],
Cell[15013, 419, 322, 7, 22, "Print"],
Cell[15338, 428, 326, 7, 22, "Print"],
Cell[15667, 437, 330, 7, 22, "Print"],
Cell[16000, 446, 334, 7, 22, "Print"],
Cell[16337, 455, 338, 7, 22, "Print"],
Cell[16678, 464, 344, 7, 22, "Print"],
Cell[17025, 473, 352, 7, 22, "Print"],
Cell[17380, 482, 38, 1, 22, "Print"],
Cell[17421, 485, 314, 7, 22, "Print"],
Cell[17738, 494, 314, 7, 22, "Print"],
Cell[18055, 503, 316, 7, 22, "Print"],
Cell[18374, 512, 318, 7, 22, "Print"],
Cell[18695, 521, 322, 7, 22, "Print"],
Cell[19020, 530, 326, 7, 22, "Print"],
Cell[19349, 539, 332, 7, 22, "Print"],
Cell[19684, 548, 336, 7, 22, "Print"],
Cell[20023, 557, 340, 7, 22, "Print"],
Cell[20366, 566, 346, 7, 22, "Print"],
Cell[20715, 575, 354, 7, 22, "Print"],
Cell[21072, 584, 38, 1, 22, "Print"],
Cell[21113, 587, 69, 1, 26, "Output"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{
Cell[21231, 594, 69, 0, 28, "Subsection"],
Cell[21303, 596, 138, 2, 43, "Input"],

Cell[CellGroupData[{
Cell[21466, 602, 46, 1, 27, "Input"],
Cell[21515, 605, 40, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[21592, 611, 120, 4, 42, "Input"],
Cell[21715, 617, 38, 1, 22, "Print"],
Cell[21756, 620, 298, 6, 22, "Print"],
Cell[22057, 628, 308, 6, 22, "Print"],
Cell[22368, 636, 39, 1, 22, "Print"],
Cell[22410, 639, 298, 6, 22, "Print"],
Cell[22711, 647, 308, 6, 22, "Print"],
Cell[23022, 655, 39, 1, 22, "Print"],
Cell[23064, 658, 300, 6, 22, "Print"],
Cell[23367, 666, 310, 6, 22, "Print"],
Cell[23680, 674, 39, 1, 22, "Print"],
Cell[23722, 677, 302, 6, 22, "Print"],
Cell[24027, 685, 312, 6, 22, "Print"],
Cell[24342, 693, 39, 1, 22, "Print"],
Cell[24384, 696, 306, 6, 22, "Print"],
Cell[24693, 704, 316, 6, 22, "Print"],
Cell[25012, 712, 39, 1, 22, "Print"],
Cell[25054, 715, 310, 6, 22, "Print"],
Cell[25367, 723, 320, 6, 22, "Print"],
Cell[25690, 731, 39, 1, 22, "Print"],
Cell[25732, 734, 314, 6, 22, "Print"],
Cell[26049, 742, 324, 6, 22, "Print"],
Cell[26376, 750, 39, 1, 22, "Print"],
Cell[26418, 753, 318, 6, 22, "Print"],
Cell[26739, 761, 328, 6, 22, "Print"],
Cell[27070, 769, 39, 1, 22, "Print"],
Cell[27112, 772, 322, 6, 22, "Print"],
Cell[27437, 780, 332, 6, 22, "Print"],
Cell[27772, 788, 39, 1, 22, "Print"],
Cell[27814, 791, 328, 6, 22, "Print"],
Cell[28145, 799, 338, 6, 22, "Print"],
Cell[28486, 807, 39, 1, 22, "Print"],
Cell[28528, 810, 336, 6, 22, "Print"],
Cell[28867, 818, 353, 7, 22, "Print"],
Cell[29223, 827, 39, 1, 22, "Print"],
Cell[29265, 830, 38, 1, 22, "Print"],
Cell[29306, 833, 298, 6, 22, "Print"],
Cell[29607, 841, 308, 6, 22, "Print"],
Cell[29918, 849, 39, 1, 22, "Print"],
Cell[29960, 852, 298, 6, 22, "Print"],
Cell[30261, 860, 308, 6, 22, "Print"],
Cell[30572, 868, 39, 1, 22, "Print"],
Cell[30614, 871, 300, 6, 22, "Print"],
Cell[30917, 879, 310, 6, 22, "Print"],
Cell[31230, 887, 39, 1, 22, "Print"],
Cell[31272, 890, 302, 6, 22, "Print"],
Cell[31577, 898, 312, 6, 22, "Print"],
Cell[31892, 906, 39, 1, 22, "Print"],
Cell[31934, 909, 306, 6, 22, "Print"],
Cell[32243, 917, 316, 6, 22, "Print"],
Cell[32562, 925, 39, 1, 22, "Print"],
Cell[32604, 928, 310, 6, 22, "Print"],
Cell[32917, 936, 320, 6, 22, "Print"],
Cell[33240, 944, 39, 1, 22, "Print"],
Cell[33282, 947, 316, 6, 22, "Print"],
Cell[33601, 955, 326, 6, 22, "Print"],
Cell[33930, 963, 39, 1, 22, "Print"],
Cell[33972, 966, 320, 6, 22, "Print"],
Cell[34295, 974, 330, 6, 22, "Print"],
Cell[34628, 982, 39, 1, 22, "Print"],
Cell[34670, 985, 324, 6, 22, "Print"],
Cell[34997, 993, 334, 6, 22, "Print"],
Cell[35334, 1001, 39, 1, 22, "Print"],
Cell[35376, 1004, 330, 6, 22, "Print"],
Cell[35709, 1012, 347, 7, 22, "Print"],
Cell[36059, 1021, 39, 1, 22, "Print"],
Cell[36101, 1024, 338, 6, 22, "Print"],
Cell[36442, 1032, 355, 7, 22, "Print"],
Cell[36800, 1041, 39, 1, 22, "Print"],
Cell[36842, 1044, 70, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[36949, 1050, 46, 1, 27, "Input"],
Cell[36998, 1053, 40, 1, 26, "Output"]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[37099, 1061, 174, 4, 48, "Section"],

Cell[CellGroupData[{
Cell[37298, 1069, 106, 3, 44, "Subsection"],
Cell[37407, 1074, 62, 1, 27, "Input"]
}, Closed]],

Cell[CellGroupData[{
Cell[37506, 1080, 69, 0, 28, "Subsection"],
Cell[37578, 1082, 142, 2, 43, "Input"],

Cell[CellGroupData[{
Cell[37745, 1088, 46, 1, 27, "Input"],
Cell[37794, 1091, 40, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[37871, 1097, 128, 4, 42, "Input"],
Cell[38002, 1103, 38, 1, 22, "Print"],
Cell[38043, 1106, 475, 11, 22, "Print"],
Cell[38521, 1119, 485, 11, 22, "Print"],
Cell[39009, 1132, 118, 2, 22, "Message"],
Cell[39130, 1136, 128, 3, 22, "Message"],
Cell[39261, 1141, 498, 11, 22, "Print"],
Cell[39762, 1154, 39, 1, 22, "Print"],
Cell[39804, 1157, 475, 11, 22, "Print"],
Cell[40282, 1170, 485, 11, 22, "Print"],
Cell[40770, 1183, 498, 11, 22, "Print"],
Cell[41271, 1196, 39, 1, 22, "Print"],
Cell[41313, 1199, 477, 11, 22, "Print"],
Cell[41793, 1212, 487, 11, 22, "Print"],
Cell[42283, 1225, 498, 11, 22, "Print"],
Cell[42784, 1238, 39, 1, 22, "Print"],
Cell[42826, 1241, 494, 11, 22, "Print"],
Cell[43323, 1254, 504, 11, 22, "Print"],
Cell[43830, 1267, 498, 11, 22, "Print"],
Cell[44331, 1280, 39, 1, 22, "Print"],
Cell[44373, 1283, 496, 11, 22, "Print"],
Cell[44872, 1296, 506, 11, 22, "Print"],
Cell[45381, 1309, 498, 11, 22, "Print"],
Cell[45882, 1322, 39, 1, 22, "Print"],
Cell[45924, 1325, 501, 11, 24, "Print"],
Cell[46428, 1338, 511, 11, 24, "Print"],
Cell[46942, 1351, 498, 11, 22, "Print"],
Cell[47443, 1364, 39, 1, 22, "Print"],
Cell[47485, 1367, 503, 11, 24, "Print"],
Cell[47991, 1380, 513, 11, 24, "Print"],
Cell[48507, 1393, 498, 11, 22, "Print"],
Cell[49008, 1406, 39, 1, 22, "Print"],
Cell[49050, 1409, 506, 11, 24, "Print"],
Cell[49559, 1422, 516, 11, 24, "Print"],
Cell[50078, 1435, 498, 11, 22, "Print"],
Cell[50579, 1448, 39, 1, 22, "Print"],
Cell[50621, 1451, 508, 11, 24, "Print"],
Cell[51132, 1464, 518, 11, 24, "Print"],
Cell[51653, 1477, 498, 11, 22, "Print"],
Cell[52154, 1490, 39, 1, 22, "Print"],
Cell[52196, 1493, 511, 11, 24, "Print"],
Cell[52710, 1506, 528, 12, 24, "Print"],
Cell[53241, 1520, 498, 11, 22, "Print"],
Cell[53742, 1533, 39, 1, 22, "Print"],
Cell[53784, 1536, 525, 12, 24, "Print"],
Cell[54312, 1550, 532, 12, 24, "Print"],
Cell[54847, 1564, 529, 12, 22, "Print"],
Cell[55379, 1578, 39, 1, 22, "Print"],
Cell[55421, 1581, 525, 12, 24, "Print"],
Cell[55949, 1595, 535, 12, 24, "Print"],
Cell[56487, 1609, 529, 12, 22, "Print"],
Cell[57019, 1623, 39, 1, 22, "Print"],
Cell[57061, 1626, 525, 12, 24, "Print"],
Cell[57589, 1640, 535, 12, 24, "Print"],
Cell[58127, 1654, 529, 12, 22, "Print"],
Cell[58659, 1668, 39, 1, 22, "Print"],
Cell[58701, 1671, 524, 12, 24, "Print"],
Cell[59228, 1685, 534, 12, 24, "Print"],
Cell[59765, 1699, 528, 12, 22, "Print"],
Cell[60296, 1713, 39, 1, 22, "Print"],
Cell[60338, 1716, 525, 12, 24, "Print"],
Cell[60866, 1730, 534, 12, 24, "Print"],
Cell[61403, 1744, 529, 12, 22, "Print"],
Cell[61935, 1758, 39, 1, 22, "Print"],
Cell[61977, 1761, 525, 12, 24, "Print"],
Cell[62505, 1775, 535, 12, 24, "Print"],
Cell[63043, 1789, 529, 12, 22, "Print"],
Cell[63575, 1803, 39, 1, 22, "Print"],
Cell[63617, 1806, 524, 12, 24, "Print"],
Cell[64144, 1820, 534, 12, 24, "Print"],
Cell[64681, 1834, 529, 12, 22, "Print"],
Cell[65213, 1848, 39, 1, 22, "Print"],
Cell[65255, 1851, 525, 12, 24, "Print"],
Cell[65783, 1865, 535, 12, 24, "Print"],
Cell[66321, 1879, 529, 12, 22, "Print"],
Cell[66853, 1893, 39, 1, 22, "Print"],
Cell[66895, 1896, 523, 12, 24, "Print"],
Cell[67421, 1910, 533, 12, 24, "Print"],
Cell[67957, 1924, 528, 12, 22, "Print"],
Cell[68488, 1938, 39, 1, 22, "Print"],
Cell[68530, 1941, 525, 12, 24, "Print"],
Cell[69058, 1955, 535, 12, 24, "Print"],
Cell[69596, 1969, 529, 12, 22, "Print"],
Cell[70128, 1983, 39, 1, 22, "Print"],
Cell[70170, 1986, 525, 12, 24, "Print"],
Cell[70698, 2000, 535, 12, 24, "Print"],
Cell[71236, 2014, 528, 12, 22, "Print"],
Cell[71767, 2028, 39, 1, 22, "Print"],
Cell[71809, 2031, 523, 12, 24, "Print"],
Cell[72335, 2045, 535, 12, 24, "Print"],
Cell[72873, 2059, 528, 12, 22, "Print"],
Cell[73404, 2073, 39, 1, 22, "Print"],
Cell[73446, 2076, 525, 12, 24, "Print"],
Cell[73974, 2090, 535, 12, 24, "Print"],
Cell[74512, 2104, 528, 12, 22, "Print"],
Cell[75043, 2118, 39, 1, 22, "Print"],
Cell[75085, 2121, 525, 12, 24, "Print"],
Cell[75613, 2135, 535, 12, 24, "Print"],
Cell[76151, 2149, 529, 12, 22, "Print"],
Cell[76683, 2163, 39, 1, 22, "Print"],
Cell[76725, 2166, 525, 12, 24, "Print"],
Cell[77253, 2180, 535, 12, 24, "Print"],
Cell[77791, 2194, 529, 12, 22, "Print"],
Cell[78323, 2208, 39, 1, 22, "Print"],
Cell[78365, 2211, 525, 12, 24, "Print"],
Cell[78893, 2225, 535, 12, 24, "Print"],
Cell[79431, 2239, 527, 12, 22, "Print"],
Cell[79961, 2253, 39, 1, 22, "Print"],
Cell[80003, 2256, 525, 12, 24, "Print"],
Cell[80531, 2270, 535, 12, 24, "Print"],
Cell[81069, 2284, 529, 12, 22, "Print"],
Cell[81601, 2298, 39, 1, 22, "Print"],
Cell[81643, 2301, 525, 12, 24, "Print"],
Cell[82171, 2315, 534, 12, 24, "Print"],
Cell[82708, 2329, 529, 12, 22, "Print"],
Cell[83240, 2343, 39, 1, 22, "Print"],
Cell[83282, 2346, 525, 12, 24, "Print"],
Cell[83810, 2360, 534, 12, 24, "Print"],
Cell[84347, 2374, 529, 12, 22, "Print"],
Cell[84879, 2388, 39, 1, 22, "Print"],
Cell[84921, 2391, 525, 12, 24, "Print"],
Cell[85449, 2405, 535, 12, 24, "Print"],
Cell[85987, 2419, 529, 12, 22, "Print"],
Cell[86519, 2433, 39, 1, 22, "Print"],
Cell[86561, 2436, 525, 12, 24, "Print"],
Cell[87089, 2450, 535, 12, 24, "Print"],
Cell[87627, 2464, 528, 12, 22, "Print"],
Cell[88158, 2478, 39, 1, 22, "Print"],
Cell[88200, 2481, 524, 12, 24, "Print"],
Cell[88727, 2495, 534, 12, 24, "Print"],
Cell[89264, 2509, 529, 12, 22, "Print"],
Cell[89796, 2523, 39, 1, 22, "Print"],
Cell[89838, 2526, 525, 12, 24, "Print"],
Cell[90366, 2540, 535, 12, 24, "Print"],
Cell[90904, 2554, 529, 12, 22, "Print"],
Cell[91436, 2568, 39, 1, 22, "Print"],
Cell[91478, 2571, 525, 12, 24, "Print"],
Cell[92006, 2585, 533, 12, 24, "Print"],
Cell[92542, 2599, 531, 12, 22, "Print"],
Cell[93076, 2613, 39, 1, 22, "Print"],
Cell[93118, 2616, 525, 12, 24, "Print"],
Cell[93646, 2630, 535, 12, 24, "Print"],
Cell[94184, 2644, 531, 12, 22, "Print"],
Cell[94718, 2658, 39, 1, 22, "Print"],
Cell[94760, 2661, 527, 12, 24, "Print"],
Cell[95290, 2675, 537, 12, 24, "Print"],
Cell[95830, 2689, 531, 12, 22, "Print"],
Cell[96364, 2703, 39, 1, 22, "Print"],
Cell[96406, 2706, 527, 12, 24, "Print"],
Cell[96936, 2720, 537, 12, 24, "Print"],
Cell[97476, 2734, 533, 12, 22, "Print"],
Cell[98012, 2748, 39, 1, 22, "Print"],
Cell[98054, 2751, 527, 12, 24, "Print"],
Cell[98584, 2765, 536, 12, 24, "Print"],
Cell[99123, 2779, 562, 13, 22, "Print"],
Cell[99688, 2794, 39, 1, 22, "Print"],
Cell[99730, 2797, 527, 12, 24, "Print"],
Cell[100260, 2811, 537, 12, 24, "Print"],
Cell[100800, 2825, 562, 13, 22, "Print"],
Cell[101365, 2840, 39, 1, 22, "Print"],
Cell[101407, 2843, 527, 12, 24, "Print"],
Cell[101937, 2857, 537, 12, 24, "Print"],
Cell[102477, 2871, 561, 13, 22, "Print"],
Cell[103041, 2886, 39, 1, 22, "Print"],
Cell[103083, 2889, 527, 12, 24, "Print"],
Cell[103613, 2903, 537, 12, 24, "Print"],
Cell[104153, 2917, 561, 13, 22, "Print"],
Cell[104717, 2932, 39, 1, 22, "Print"],
Cell[104759, 2935, 38, 1, 22, "Print"],
Cell[104800, 2938, 298, 6, 22, "Print"],
Cell[105101, 2946, 308, 6, 22, "Print"],
Cell[105412, 2954, 306, 6, 22, "Print"],
Cell[105721, 2962, 39, 1, 22, "Print"],
Cell[105763, 2965, 475, 11, 22, "Print"],
Cell[106241, 2978, 485, 11, 22, "Print"],
Cell[106729, 2991, 118, 2, 22, "Message"],
Cell[106850, 2995, 128, 3, 22, "Message"],
Cell[106981, 3000, 498, 11, 22, "Print"],
Cell[107482, 3013, 39, 1, 22, "Print"],
Cell[107524, 3016, 477, 11, 22, "Print"],
Cell[108004, 3029, 487, 11, 22, "Print"],
Cell[108494, 3042, 498, 11, 22, "Print"],
Cell[108995, 3055, 39, 1, 22, "Print"],
Cell[109037, 3058, 494, 11, 22, "Print"],
Cell[109534, 3071, 504, 11, 22, "Print"],
Cell[110041, 3084, 498, 11, 22, "Print"],
Cell[110542, 3097, 39, 1, 22, "Print"],
Cell[110584, 3100, 496, 11, 22, "Print"],
Cell[111083, 3113, 506, 11, 22, "Print"],
Cell[111592, 3126, 498, 11, 22, "Print"],
Cell[112093, 3139, 39, 1, 22, "Print"],
Cell[112135, 3142, 501, 11, 24, "Print"],
Cell[112639, 3155, 511, 11, 24, "Print"],
Cell[113153, 3168, 498, 11, 22, "Print"],
Cell[113654, 3181, 39, 1, 22, "Print"],
Cell[113696, 3184, 504, 11, 24, "Print"],
Cell[114203, 3197, 514, 11, 24, "Print"],
Cell[114720, 3210, 498, 11, 22, "Print"],
Cell[115221, 3223, 39, 1, 22, "Print"],
Cell[115263, 3226, 507, 11, 24, "Print"],
Cell[115773, 3239, 517, 11, 24, "Print"],
Cell[116293, 3252, 498, 11, 22, "Print"],
Cell[116794, 3265, 39, 1, 22, "Print"],
Cell[116836, 3268, 509, 11, 24, "Print"],
Cell[117348, 3281, 519, 11, 24, "Print"],
Cell[117870, 3294, 498, 11, 22, "Print"],
Cell[118371, 3307, 39, 1, 22, "Print"],
Cell[118413, 3310, 512, 11, 24, "Print"],
Cell[118928, 3323, 529, 12, 24, "Print"],
Cell[119460, 3337, 498, 11, 22, "Print"],
Cell[119961, 3350, 39, 1, 22, "Print"],
Cell[120003, 3353, 525, 12, 24, "Print"],
Cell[120531, 3367, 535, 12, 24, "Print"],
Cell[121069, 3381, 529, 12, 22, "Print"],
Cell[121601, 3395, 39, 1, 22, "Print"],
Cell[121643, 3398, 523, 12, 24, "Print"],
Cell[122169, 3412, 535, 12, 24, "Print"],
Cell[122707, 3426, 529, 12, 22, "Print"],
Cell[123239, 3440, 39, 1, 22, "Print"],
Cell[123281, 3443, 525, 12, 24, "Print"],
Cell[123809, 3457, 535, 12, 24, "Print"],
Cell[124347, 3471, 529, 12, 22, "Print"],
Cell[124879, 3485, 39, 1, 22, "Print"],
Cell[124921, 3488, 525, 12, 24, "Print"],
Cell[125449, 3502, 535, 12, 24, "Print"],
Cell[125987, 3516, 529, 12, 22, "Print"],
Cell[126519, 3530, 39, 1, 22, "Print"],
Cell[126561, 3533, 525, 12, 24, "Print"],
Cell[127089, 3547, 535, 12, 24, "Print"],
Cell[127627, 3561, 528, 12, 22, "Print"],
Cell[128158, 3575, 39, 1, 22, "Print"],
Cell[128200, 3578, 525, 12, 24, "Print"],
Cell[128728, 3592, 535, 12, 24, "Print"],
Cell[129266, 3606, 529, 12, 22, "Print"],
Cell[129798, 3620, 39, 1, 22, "Print"],
Cell[129840, 3623, 525, 12, 24, "Print"],
Cell[130368, 3637, 535, 12, 24, "Print"],
Cell[130906, 3651, 529, 12, 22, "Print"],
Cell[131438, 3665, 39, 1, 22, "Print"],
Cell[131480, 3668, 525, 12, 24, "Print"],
Cell[132008, 3682, 535, 12, 24, "Print"],
Cell[132546, 3696, 529, 12, 22, "Print"],
Cell[133078, 3710, 39, 1, 22, "Print"],
Cell[133120, 3713, 525, 12, 24, "Print"],
Cell[133648, 3727, 535, 12, 24, "Print"],
Cell[134186, 3741, 528, 12, 22, "Print"],
Cell[134717, 3755, 39, 1, 22, "Print"],
Cell[134759, 3758, 525, 12, 24, "Print"],
Cell[135287, 3772, 535, 12, 24, "Print"],
Cell[135825, 3786, 529, 12, 22, "Print"],
Cell[136357, 3800, 39, 1, 22, "Print"],
Cell[136399, 3803, 523, 12, 24, "Print"],
Cell[136925, 3817, 535, 12, 24, "Print"],
Cell[137463, 3831, 528, 12, 22, "Print"],
Cell[137994, 3845, 39, 1, 22, "Print"],
Cell[138036, 3848, 525, 12, 24, "Print"],
Cell[138564, 3862, 533, 12, 24, "Print"],
Cell[139100, 3876, 529, 12, 22, "Print"],
Cell[139632, 3890, 39, 1, 22, "Print"],
Cell[139674, 3893, 525, 12, 24, "Print"],
Cell[140202, 3907, 535, 12, 24, "Print"],
Cell[140740, 3921, 529, 12, 22, "Print"],
Cell[141272, 3935, 39, 1, 22, "Print"],
Cell[141314, 3938, 524, 12, 24, "Print"],
Cell[141841, 3952, 535, 12, 24, "Print"],
Cell[142379, 3966, 529, 12, 22, "Print"],
Cell[142911, 3980, 39, 1, 22, "Print"],
Cell[142953, 3983, 525, 12, 24, "Print"],
Cell[143481, 3997, 535, 12, 24, "Print"],
Cell[144019, 4011, 529, 12, 22, "Print"],
Cell[144551, 4025, 39, 1, 22, "Print"],
Cell[144593, 4028, 525, 12, 24, "Print"],
Cell[145121, 4042, 535, 12, 24, "Print"],
Cell[145659, 4056, 529, 12, 22, "Print"],
Cell[146191, 4070, 39, 1, 22, "Print"],
Cell[146233, 4073, 524, 12, 24, "Print"],
Cell[146760, 4087, 535, 12, 24, "Print"],
Cell[147298, 4101, 529, 12, 22, "Print"],
Cell[147830, 4115, 39, 1, 22, "Print"],
Cell[147872, 4118, 524, 12, 24, "Print"],
Cell[148399, 4132, 535, 12, 24, "Print"],
Cell[148937, 4146, 529, 12, 22, "Print"],
Cell[149469, 4160, 39, 1, 22, "Print"],
Cell[149511, 4163, 525, 12, 24, "Print"],
Cell[150039, 4177, 535, 12, 24, "Print"],
Cell[150577, 4191, 529, 12, 22, "Print"],
Cell[151109, 4205, 39, 1, 22, "Print"],
Cell[151151, 4208, 525, 12, 24, "Print"],
Cell[151679, 4222, 534, 12, 24, "Print"],
Cell[152216, 4236, 529, 12, 22, "Print"],
Cell[152748, 4250, 39, 1, 22, "Print"],
Cell[152790, 4253, 524, 12, 24, "Print"],
Cell[153317, 4267, 534, 12, 24, "Print"],
Cell[153854, 4281, 529, 12, 22, "Print"],
Cell[154386, 4295, 39, 1, 22, "Print"],
Cell[154428, 4298, 524, 12, 24, "Print"],
Cell[154955, 4312, 535, 12, 24, "Print"],
Cell[155493, 4326, 529, 12, 22, "Print"],
Cell[156025, 4340, 39, 1, 22, "Print"],
Cell[156067, 4343, 525, 12, 24, "Print"],
Cell[156595, 4357, 535, 12, 24, "Print"],
Cell[157133, 4371, 529, 12, 22, "Print"],
Cell[157665, 4385, 39, 1, 22, "Print"],
Cell[157707, 4388, 525, 12, 24, "Print"],
Cell[158235, 4402, 535, 12, 24, "Print"],
Cell[158773, 4416, 531, 12, 22, "Print"],
Cell[159307, 4430, 39, 1, 22, "Print"],
Cell[159349, 4433, 525, 12, 24, "Print"],
Cell[159877, 4447, 535, 12, 24, "Print"],
Cell[160415, 4461, 531, 12, 22, "Print"],
Cell[160949, 4475, 39, 1, 22, "Print"],
Cell[160991, 4478, 527, 12, 24, "Print"],
Cell[161521, 4492, 537, 12, 24, "Print"],
Cell[162061, 4506, 531, 12, 22, "Print"],
Cell[162595, 4520, 39, 1, 22, "Print"],
Cell[162637, 4523, 527, 12, 24, "Print"],
Cell[163167, 4537, 537, 12, 24, "Print"],
Cell[163707, 4551, 533, 12, 22, "Print"],
Cell[164243, 4565, 39, 1, 22, "Print"],
Cell[164285, 4568, 527, 12, 24, "Print"],
Cell[164815, 4582, 537, 12, 24, "Print"],
Cell[165355, 4596, 561, 13, 22, "Print"],
Cell[165919, 4611, 39, 1, 22, "Print"],
Cell[165961, 4614, 527, 12, 24, "Print"],
Cell[166491, 4628, 537, 12, 24, "Print"],
Cell[167031, 4642, 562, 13, 22, "Print"],
Cell[167596, 4657, 39, 1, 22, "Print"],
Cell[167638, 4660, 527, 12, 24, "Print"],
Cell[168168, 4674, 537, 12, 24, "Print"],
Cell[168708, 4688, 562, 13, 22, "Print"],
Cell[169273, 4703, 39, 1, 22, "Print"],
Cell[169315, 4706, 527, 12, 24, "Print"],
Cell[169845, 4720, 537, 12, 24, "Print"],
Cell[170385, 4734, 562, 13, 22, "Print"],
Cell[170950, 4749, 39, 1, 22, "Print"],
Cell[170992, 4752, 70, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[171099, 4758, 46, 1, 27, "Input"],
Cell[171148, 4761, 40, 1, 26, "Output"]
}, Open  ]]
}, Closed]]
}, Closed]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

