(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 3.0,
MathReader 3.0, or any compatible application. The data for the notebook 
starts with the line of stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[      8334,        295]*)
(*NotebookOutlinePosition[      9174,        322]*)
(*  CellTagsIndexPosition[      9130,        318]*)
(*WindowFrame->Normal*)



Notebook[{
Cell[TextData[{
  " :Author:  Z\[EAcute]lia da ROCHA \n\n:Address: \n            Departamento \
de Matem\[AAcute]tica Aplicada da\n            Faculdade de Ci\[EHat]ncias do \
Porto\n            Rua das Taipas, 135\n            4050 Porto\n            \
Portugal\n  \n            Tel: ++351 02 2080313\n            Fax: ++351 02 \
2004109\n            Email: mrdioh@fc.up.pt\n\n :Summary:\n    The ",
  StyleBox["testmodchvnew",
    FontSize->18],
  " notebook contains the results produced by the package\n    modchv.m \
corresponding to a ",
  StyleBox["new example",
    FontSize->18],
  " given by the user.    \n\n :Date: July 1999. \n\n:Available at \
http://netlib.bell-labs.com/ in the numeralgo library in netlib:     \n\n \
:Notebook Version: 1.0 \n\n :Mathematica Version: 3.0   \n \n :Keywords: \
modified chebyshev's method, recurrence relations,  orthogonal polynomials of \
dimension d, d-dimensional forms.\n\n :Sources:\n \n - Z\[EAcute]lia da \
Rocha, Shohat-Favard and Chebyshev's methods in d-orthogonality, \n Numerical \
Algorithms,  20 (1999) 139-164."
}], "Subsection"],

Cell[CellGroupData[{

Cell["\<\
Computing the recurrence coefficients and the orthogonal \
polynomials performing formal computations\
\>", "Section",
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell["\<\
Loading the package modchv.m, the package datamodchvnew.m is \
automatically loaded\
\>", "Subsection"],

Cell[BoxData[
    \(\(<< modchebyshev`modchv`; \)\)], "Input"]
}, Closed]],

Cell[CellGroupData[{

Cell["\<\
The moments of the d-dimensional form are given in the package \
datamodchvnew.m\
\>", "Subsection",
  AspectRatioFixed->True],

Cell[BoxData[
    \( (*\ showing\ the\ moments\ given\ *) \)], "Input"],

Cell[BoxData[
    \(\( (*\ set\ the\ values\ of\ d\ and\ imax\ *) \n\(d = \); 
    \(imax = \)\ ; \ \ \ \ \ \ 
     (*\ for\ example\ *)  (*TO\ FILL\ IN\ BY\ THE\ USER*) \)\)], "Input"],

Cell[BoxData[
    \(Do[Print["\<form[\>", d, "\<,\>", r, "\<,\>", i, "\<]=\>", 
        form[d, r, i]], {r, 1, d}, {i, 0, imax}]\)], "Input"]
}, Closed]],

Cell[CellGroupData[{

Cell["\<\
The auxiliary sequence of d-orthogonal polynomials is given in the \
package datamodchvnew.m\
\>", "Subsection"],

Cell[BoxData[
    \( (*\ 
      showing\ the\ coefficients\ of\ the\ auxiliary\ sequence\ given\ *) \)],
   "Input"],

Cell[BoxData[
    \(\( (*\ set\ the\ values\ of\ d\ and\ imax\ *) \n\(d = \); 
    \(imax = \)\ ; \ \ \ \ \ \  (*\ for\ example\ *) \ 
     (*TO\ FILL\ IN\ BY\ THE\ USER*) \)\)], "Input"],

Cell[BoxData[
    \(\(Do[\ 
      Do[Print["\<auxgamma[\>", d, "\<,\>", r, "\<,\>", n, "\<]=\>", \n
          \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \
\ auxgamma[d, r, n]\ ], \ \ \ \ \ \ \ \n
        \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ {n, 1, imax + r - d + 1}]; 
      Print["\<________________\>"], \ \n\ \ \ \ \ \ {r, 0, d - 1}]\ \)\)], 
  "Input"],

Cell[BoxData[
    \(\(\ Do[Print["\<auxbeta[\>", d, "\<,\>", n, "\<]=\>", auxbeta[d, n]\ ], 
      \ \ \ \ \ \ \ \n\ \ \ \ \ \ \ \ \ \ {n, 0, imax - 1}]\)\)], "Input"]
}, Closed]],

Cell[CellGroupData[{

Cell["Computing the modified gamma coefficients", "Subsection"],

Cell[BoxData[
    \(\( (*\ set\ the\ values\ of\ d\ and\ nmax\ *) \n\(d = \); \ 
    \(nmax = \); \ \ \ \ \ 
     (*\ for\ example\ *)  (*TO\ FILL\ IN\ BY\ THE\ USER*) \)\)], "Input"],

Cell[BoxData[
    \(MemoryInUse[]\)], "Input"],

Cell["\<\
Timing[printmodgamma[d,nmax,Infinity,$MachinePrecision,True,False]]\
\
\>", "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    \(MemoryInUse[]\)], "Input"]
}, Closed]],

Cell[CellGroupData[{

Cell["Computing the modified beta coefficients", "Subsection"],

Cell[BoxData[
    \(\( (*\ set\ the\ values\ of\ d\ and\ nmax\ *) \n\(d = \); \ 
    \(nmax = \)\ ; \ \ \ \ \ 
     (*\ for\ example\ *)  (*TO\ FILL\ IN\ BY\ THE\ USER*) \)\)], "Input"],

Cell[BoxData[
    \(MemoryInUse[]\)], "Input"],

Cell["\<\
Timing[printmodbeta[d,nmax,Infinity,$MachinePrecision,True,False]]\
\
\>", "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    \(MemoryInUse[]\)], "Input"]
}, Closed]],

Cell[CellGroupData[{

Cell["\<\
Computing the d-orthogonal polynomials from the modified \
coefficients\
\>", "Subsection"],

Cell[BoxData[
    \(\( (*\ set\ the\ values\ of\ d\ and\ nmax\ *) \n\(d = \); \ 
    \(nmax = \); \ \ \ \ \ 
     (*\ for\ example\ *)  (*TO\ FILL\ IN\ BY\ THE\ USER*) \)\)], "Input"],

Cell[BoxData[
    \(MemoryInUse[]\)], "Input"],

Cell["Timing[printmoddorthpoly[d,nmax,x,Infinity]]", "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    \(MemoryInUse[]\)], "Input"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["\<\
Computing the recurrence coefficients and the orthogonal \
polynomials performing numerical computations with the machine precision\
\>",
   "Section",
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell["\<\
Loading the package modchv.m, the package datamodchvnew.m is \
automatically loaded\
\>", "Subsection"],

Cell[BoxData[
    \(\(<< modchebyshev`modchv`; \)\)], "Input"]
}, Closed]],

Cell[CellGroupData[{

Cell["Computing the modified gamma coefficients", "Subsection"],

Cell[BoxData[
    \(\( (*\ set\ the\ values\ of\ d\ and\ nmax\ *) \n\(d = \); \ 
    \(nmax = \)\ ; \ \ \ \ 
     (*\ for\ example\ *)  (*TO\ FILL\ IN\ BY\ THE\ USER*) \)\)], "Input"],

Cell[BoxData[
    \(MemoryInUse[]\)], "Input"],

Cell["\<\
Timing[printmodgamma[d,nmax,$MachinePrecision,$MachinePrecision,\
True,True]]\
\>", "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    \(MemoryInUse[]\)], "Input"]
}, Closed]],

Cell[CellGroupData[{

Cell["Computing the modified beta coefficients", "Subsection"],

Cell[BoxData[
    \(\( (*\ set\ the\ values\ of\ d\ and\ nmax\ *) \n\(d = \); \ 
    \(nmax = \)\ ; \ \ \ \ \ 
     (*\ for\ example\ *)  (*TO\ FILL\ IN\ BY\ THE\ USER*) \)\)], "Input"],

Cell[BoxData[
    \(MemoryInUse[]\)], "Input"],

Cell["\<\
Timing[printmodbeta[d,nmax,$MachinePrecision,$MachinePrecision,True,\
True]]\
\>", "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    \(MemoryInUse[]\)], "Input"]
}, Closed]],

Cell[CellGroupData[{

Cell["\<\
Computing the d-orthogonal polynomials from the modified \
coefficients\
\>", "Subsection"],

Cell[BoxData[
    \(\( (*\ set\ the\ values\ of\ d\ and\ nmax\ *) \n\(d = \); \ 
    \(nmax = \)\ ; \ \ \  (*\ for\ example\ *) \ 
     (*\ TO\ FILL\ IN\ BY\ THE\ USER*) \)\)], "Input"],

Cell[BoxData[
    \(MemoryInUse[]\)], "Input"],

Cell["Timing[printmoddorthpoly[d,nmax,x,$MachinePrecision]]", "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    \(MemoryInUse[]\)], "Input"]
}, Closed]]
}, Closed]]
},
FrontEndVersion->"Macintosh 3.0",
ScreenRectangle->{{0, 832}, {0, 604}},
WindowSize->{590, 412},
WindowMargins->{{Automatic, 87}, {Automatic, 66}},
MacintoshSystemPageSetup->"\<\
00<0001804P000000`d26_oQon@3:`8g0dL5N`?P0080001804P000000]P2:001
0000I00000400`<30?l00BL?00400@0000000000000006P801T1T00000000000
00000000004000000000000000000000\>"
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{
Cell[1709, 49, 1093, 19, 548, "Subsection"],

Cell[CellGroupData[{
Cell[2827, 72, 154, 4, 68, "Section"],

Cell[CellGroupData[{
Cell[3006, 80, 113, 3, 44, "Subsection"],
Cell[3122, 85, 62, 1, 27, "Input"]
}, Closed]],

Cell[CellGroupData[{
Cell[3221, 91, 136, 4, 28, "Subsection"],
Cell[3360, 97, 71, 1, 27, "Input"],
Cell[3434, 100, 185, 3, 43, "Input"],
Cell[3622, 105, 141, 2, 43, "Input"]
}, Closed]],

Cell[CellGroupData[{
Cell[3800, 112, 122, 3, 44, "Subsection"],
Cell[3925, 117, 116, 3, 43, "Input"],
Cell[4044, 122, 187, 3, 43, "Input"],
Cell[4234, 127, 384, 7, 75, "Input"],
Cell[4621, 136, 167, 2, 43, "Input"]
}, Closed]],

Cell[CellGroupData[{
Cell[4825, 143, 63, 0, 28, "Subsection"],
Cell[4891, 145, 183, 3, 43, "Input"],
Cell[5077, 150, 46, 1, 27, "Input"],
Cell[5126, 153, 120, 4, 42, "Input"],
Cell[5249, 159, 46, 1, 27, "Input"]
}, Closed]],

Cell[CellGroupData[{
Cell[5332, 165, 62, 0, 28, "Subsection"],
Cell[5397, 167, 185, 3, 43, "Input"],
Cell[5585, 172, 46, 1, 27, "Input"],
Cell[5634, 175, 119, 4, 42, "Input"],
Cell[5756, 181, 46, 1, 27, "Input"]
}, Closed]],

Cell[CellGroupData[{
Cell[5839, 187, 101, 3, 28, "Subsection"],
Cell[5943, 192, 183, 3, 43, "Input"],
Cell[6129, 197, 46, 1, 27, "Input"],
Cell[6178, 200, 87, 1, 27, "Input"],
Cell[6268, 203, 46, 1, 27, "Input"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[6363, 210, 187, 5, 66, "Section"],

Cell[CellGroupData[{
Cell[6575, 219, 113, 3, 44, "Subsection"],
Cell[6691, 224, 62, 1, 27, "Input"]
}, Closed]],

Cell[CellGroupData[{
Cell[6790, 230, 63, 0, 28, "Subsection"],
Cell[6856, 232, 183, 3, 43, "Input"],
Cell[7042, 237, 46, 1, 27, "Input"],
Cell[7091, 240, 128, 4, 42, "Input"],
Cell[7222, 246, 46, 1, 27, "Input"]
}, Closed]],

Cell[CellGroupData[{
Cell[7305, 252, 62, 0, 28, "Subsection"],
Cell[7370, 254, 185, 3, 43, "Input"],
Cell[7558, 259, 46, 1, 27, "Input"],
Cell[7607, 262, 127, 4, 42, "Input"],
Cell[7737, 268, 46, 1, 27, "Input"]
}, Closed]],

Cell[CellGroupData[{
Cell[7820, 274, 101, 3, 28, "Subsection"],
Cell[7924, 279, 185, 3, 43, "Input"],
Cell[8112, 284, 46, 1, 27, "Input"],
Cell[8161, 287, 96, 1, 27, "Input"],
Cell[8260, 290, 46, 1, 27, "Input"]
}, Closed]]
}, Closed]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

