(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 3.0,
MathReader 3.0, or any compatible application. The data for the notebook 
starts with the line of stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[    108083,       3142]*)
(*NotebookOutlinePosition[    108975,       3171]*)
(*  CellTagsIndexPosition[    108931,       3167]*)
(*WindowFrame->Normal*)



Notebook[{
Cell[TextData[{
  " :Author:  Z\[EAcute]lia da ROCHA \n\n:Address: \n            Departamento \
de Matem\[AAcute]tica Aplicada da\n            Faculdade de Ci\[EHat]ncias do \
Porto\n            Rua das Taipas, 135\n            4050 Porto\n            \
Portugal\n  \n            Tel: ++351 02 2080313\n            Fax: ++351 02 \
2004109\n            Email: mrdioh@fc.up.pt\n\n :Summary:\n    The ",
  StyleBox["testmodchv42",
    FontSize->18],
  " notebook contains the results produced by the package\n    modchv.m \
corresponding to the ",
  StyleBox["example 4.2",
    FontSize->18],
  " of the first paper cited bellow.    \n\n :Date: July 1999. \n\n:Available \
at http://netlib.bell-labs.com/ in the numeralgo library in netlib:     \n\n \
:Notebook Version: 1.0 \n\n :Mathematica Version: 3.0   \n \n :Keywords: \
chebyshev's method, recurrence relations,  orthogonal polynomials of \
dimension d, d-dimensional forms.\n\n :Sources:\n \n - Z\[EAcute]lia da \
Rocha, Shohat-Favard and Chebyshev's methods in d-orthogonality, \n Numerical \
Algorithms, 20 (1999) 139-164.\n   \n - About the example treated here see \
pp. 82, 92, 103, 106 of:\n   K. Douak, P. Maroni, Les polyn\[OHat]mes \
orthogonaux \"classiques\" de dimension deux, Analysis 12,  71-107 (1992)."
}], "Subsection"],

Cell[CellGroupData[{

Cell["\<\
Computing the recurrence coefficients and the orthogonal \
polynomials performing formal computations\
\>", "Section",
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell["\<\
Loading the package modchv.m, the package datamodchv42.m is \
automatically loaded\
\>", "Subsection"],

Cell[BoxData[
    \(\(<< modchebyshev`modchv`; \)\)], "Input"]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
The moments of the d-dimensional form are given in the package \
datamodchv42.m\
\>", "Subsection",
  AspectRatioFixed->True],

Cell[BoxData[
    \( (*\ showing\ the\ moments\ given\ *) \)], "Input"],

Cell[BoxData[
    \(\( (*\ set\ the\ values\ of\ d\ and\ imax\ *) \nd = 2; imax = \ 10; 
    \ \ \ \ \ \  (*\ for\ example\ *) \)\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Do[Print["\<form[\>", d, "\<,\>", r, "\<,\>", i, "\<]=\>", 
        form[d, r, i]], {r, 1, d}, {i, 0, imax}]\)], "Input"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]0
        \[InvisibleSpace]"]="\[InvisibleSpace]1\),
      SequenceForm[ "form[", 2, ",", 1, ",", 0, "]=", 1],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 2, ",", 1, ",", 1, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 2, ",", 1, ",", 2, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]"]="\[InvisibleSpace]1\),
      SequenceForm[ "form[", 2, ",", 1, ",", 3, "]=", 1],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 2, ",", 1, ",", 4, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 2, ",", 1, ",", 5, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]6
        \[InvisibleSpace]"]="\[InvisibleSpace]20\/7\),
      SequenceForm[ "form[", 2, ",", 1, ",", 6, "]=", 
        Rational[ 20, 7]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]7
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 2, ",", 1, ",", 7, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]8
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 2, ",", 1, ",", 8, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]9
        \[InvisibleSpace]"]="\[InvisibleSpace]32\/3\),
      SequenceForm[ "form[", 2, ",", 1, ",", 9, "]=", 
        Rational[ 32, 3]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]10
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 2, ",", 1, ",", 10, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]0
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 2, ",", 2, ",", 0, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]"]="\[InvisibleSpace]1\),
      SequenceForm[ "form[", 2, ",", 2, ",", 1, "]=", 1],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 2, ",", 2, ",", 2, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 2, ",", 2, ",", 3, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]"]="\[InvisibleSpace]2\),
      SequenceForm[ "form[", 2, ",", 2, ",", 4, "]=", 2],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 2, ",", 2, ",", 5, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]6
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 2, ",", 2, ",", 6, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]7
        \[InvisibleSpace]"]="\[InvisibleSpace]20\/3\),
      SequenceForm[ "form[", 2, ",", 2, ",", 7, "]=", 
        Rational[ 20, 3]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]8
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 2, ",", 2, ",", 8, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]9
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 2, ",", 2, ",", 9, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]10
        \[InvisibleSpace]"]="\[InvisibleSpace]80\/3\),
      SequenceForm[ "form[", 2, ",", 2, ",", 10, "]=", 
        Rational[ 80, 3]],
      Editable->False]], "Print"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["\<\
The auxiliary sequence of d-orthogonal polynomials is given in the \
package datamodchv42.m\
\>", "Subsection"],

Cell[BoxData[
    \( (*\ 
      showing\ the\ coefficients\ of\ the\ auxiliary\ sequence\ given\ *) \)],
   "Input"],

Cell[BoxData[
    \(\( (*\ set\ the\ values\ of\ d\ and\ imax\ *) \nd = 2; imax = \ 10; 
    \ \ \ \ \ \  (*\ for\ example\ *) \)\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(Do[\ 
      Do[Print["\<auxgamma[\>", d, "\<,\>", r, "\<,\>", n, "\<]=\>", \n
          \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \
\ auxgamma[d, r, n]\ ], \ \ \ \ \ \ \ \n
        \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ {n, 1, imax + r - d + 1}]; 
      Print["\<________________\>"], \ \n\ \ \ \ \ \ {r, 0, d - 1}]\ \)\)], 
  "Input"],

Cell[BoxData[
    InterpretationBox[
      \("auxgamma["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]0
        \[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]"]="\[InvisibleSpace]90\),
      SequenceForm[ "auxgamma[", 2, ",", 0, ",", 1, "]=", 90],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("auxgamma["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]0
        \[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]"]="\[InvisibleSpace]7560\),
      SequenceForm[ "auxgamma[", 2, ",", 0, ",", 2, "]=", 7560],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("auxgamma["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]0
        \[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]"]="\[InvisibleSpace]83160\),
      SequenceForm[ "auxgamma[", 2, ",", 0, ",", 3, "]=", 83160],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("auxgamma["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]0
        \[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]"]="\[InvisibleSpace]450450\),
      SequenceForm[ "auxgamma[", 2, ",", 0, ",", 4, "]=", 450450],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("auxgamma["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]0
        \[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]"]="\[InvisibleSpace]1670760\),
      SequenceForm[ "auxgamma[", 2, ",", 0, ",", 5, "]=", 1670760],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("auxgamma["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]0
        \[InvisibleSpace]","\[InvisibleSpace]6
        \[InvisibleSpace]"]="\[InvisibleSpace]4883760\),
      SequenceForm[ "auxgamma[", 2, ",", 0, ",", 6, "]=", 4883760],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("auxgamma["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]0
        \[InvisibleSpace]","\[InvisibleSpace]7
        \[InvisibleSpace]"]="\[InvisibleSpace]12113640\),
      SequenceForm[ "auxgamma[", 2, ",", 0, ",", 7, "]=", 12113640],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("auxgamma["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]0
        \[InvisibleSpace]","\[InvisibleSpace]8
        \[InvisibleSpace]"]="\[InvisibleSpace]26640900\),
      SequenceForm[ "auxgamma[", 2, ",", 0, ",", 8, "]=", 26640900],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("auxgamma["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]0
        \[InvisibleSpace]","\[InvisibleSpace]9
        \[InvisibleSpace]"]="\[InvisibleSpace]53439750\),
      SequenceForm[ "auxgamma[", 2, ",", 0, ",", 9, "]=", 53439750],
      Editable->False]], "Print"],

Cell[BoxData[
    \("________________"\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("auxgamma["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]"]="\[InvisibleSpace]9\),
      SequenceForm[ "auxgamma[", 2, ",", 1, ",", 1, "]=", 9],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("auxgamma["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]"]="\[InvisibleSpace]450\),
      SequenceForm[ "auxgamma[", 2, ",", 1, ",", 2, "]=", 450],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("auxgamma["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]"]="\[InvisibleSpace]3024\),
      SequenceForm[ "auxgamma[", 2, ",", 1, ",", 3, "]=", 3024],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("auxgamma["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]"]="\[InvisibleSpace]10890\),
      SequenceForm[ "auxgamma[", 2, ",", 1, ",", 4, "]=", 10890],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("auxgamma["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]"]="\[InvisibleSpace]28665\),
      SequenceForm[ "auxgamma[", 2, ",", 1, ",", 5, "]=", 28665],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("auxgamma["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]6
        \[InvisibleSpace]"]="\[InvisibleSpace]62424\),
      SequenceForm[ "auxgamma[", 2, ",", 1, ",", 6, "]=", 62424],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("auxgamma["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]7
        \[InvisibleSpace]"]="\[InvisibleSpace]119700\),
      SequenceForm[ "auxgamma[", 2, ",", 1, ",", 7, "]=", 119700],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("auxgamma["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]8
        \[InvisibleSpace]"]="\[InvisibleSpace]209484\),
      SequenceForm[ "auxgamma[", 2, ",", 1, ",", 8, "]=", 209484],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("auxgamma["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]9
        \[InvisibleSpace]"]="\[InvisibleSpace]342225\),
      SequenceForm[ "auxgamma[", 2, ",", 1, ",", 9, "]=", 342225],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("auxgamma["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]10
        \[InvisibleSpace]"]="\[InvisibleSpace]529830\),
      SequenceForm[ "auxgamma[", 2, ",", 1, ",", 10, "]=", 529830],
      Editable->False]], "Print"],

Cell[BoxData[
    \("________________"\)], "Print"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(\ Do[Print["\<auxbeta[\>", d, "\<,\>", n, "\<]=\>", auxbeta[d, n]\ ], 
      \ \ \ \ \ \ \ \n\ \ \ \ \ \ \ \ \ \ {n, 0, imax - 1}]\)\)], "Input"],

Cell[BoxData[
    InterpretationBox[
      \("auxbeta["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]0
        \[InvisibleSpace]"]="\[InvisibleSpace]1\),
      SequenceForm[ "auxbeta[", 2, ",", 0, "]=", 1],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("auxbeta["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]"]="\[InvisibleSpace]19\),
      SequenceForm[ "auxbeta[", 2, ",", 1, "]=", 19],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("auxbeta["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]"]="\[InvisibleSpace]64\),
      SequenceForm[ "auxbeta[", 2, ",", 2, "]=", 64],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("auxbeta["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]"]="\[InvisibleSpace]136\),
      SequenceForm[ "auxbeta[", 2, ",", 3, "]=", 136],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("auxbeta["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]"]="\[InvisibleSpace]235\),
      SequenceForm[ "auxbeta[", 2, ",", 4, "]=", 235],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("auxbeta["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]"]="\[InvisibleSpace]361\),
      SequenceForm[ "auxbeta[", 2, ",", 5, "]=", 361],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("auxbeta["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]6
        \[InvisibleSpace]"]="\[InvisibleSpace]514\),
      SequenceForm[ "auxbeta[", 2, ",", 6, "]=", 514],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("auxbeta["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]7
        \[InvisibleSpace]"]="\[InvisibleSpace]694\),
      SequenceForm[ "auxbeta[", 2, ",", 7, "]=", 694],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("auxbeta["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]8
        \[InvisibleSpace]"]="\[InvisibleSpace]901\),
      SequenceForm[ "auxbeta[", 2, ",", 8, "]=", 901],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("auxbeta["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]9
        \[InvisibleSpace]"]="\[InvisibleSpace]1135\),
      SequenceForm[ "auxbeta[", 2, ",", 9, "]=", 1135],
      Editable->False]], "Print"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Computing the modified gamma coefficients", "Subsection"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\( (*\ set\ the\ values\ of\ d\ and\ nmax\ *) \nd = 2; \ nmax = \ 10\ ; 
    \ \ \ \  (*\ for\ example\ *) \)\)], "Input"],

Cell[BoxData[
    \(General::"spell1" \( : \ \) 
      "Possible spelling error: new symbol name \"\!\(nmax\)\" is similar to \
existing symbol \"\!\(imax\)\"."\)], "Message"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(MemoryInUse[]\)], "Input"],

Cell[BoxData[
    \(963992\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Timing[printmodgamma[d,nmax,Infinity,$MachinePrecision,True,False]]\
\
\>", "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    \("   "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("modgamma["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]0
        \[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]"]="\[InvisibleSpace]1\),
      SequenceForm[ "modgamma[", 2, ",", 0, ",", 1, "]=", 1],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]0
        \[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]"]="\[InvisibleSpace]1\),
      SequenceForm[ "gammaexact[", 2, ",", 0, ",", 1, "]=", 1],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("modgamma["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]0
        \[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]"]="\[InvisibleSpace]1\),
      SequenceForm[ "modgamma[", 2, ",", 0, ",", 2, "]=", 1],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]0
        \[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]"]="\[InvisibleSpace]1\),
      SequenceForm[ "gammaexact[", 2, ",", 0, ",", 2, "]=", 1],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("modgamma["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]0
        \[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]"]="\[InvisibleSpace]6\/7\),
      SequenceForm[ "modgamma[", 2, ",", 0, ",", 3, "]=", 
        Rational[ 6, 7]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]0
        \[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]"]="\[InvisibleSpace]6\/7\),
      SequenceForm[ "gammaexact[", 2, ",", 0, ",", 3, "]=", 
        Rational[ 6, 7]],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("modgamma["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]0
        \[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]"]="\[InvisibleSpace]20\/21\),
      SequenceForm[ "modgamma[", 2, ",", 0, ",", 4, "]=", 
        Rational[ 20, 21]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]0
        \[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]"]="\[InvisibleSpace]20\/21\),
      SequenceForm[ "gammaexact[", 2, ",", 0, ",", 4, "]=", 
        Rational[ 20, 21]],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("modgamma["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]0
        \[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]"]="\[InvisibleSpace]6\/7\),
      SequenceForm[ "modgamma[", 2, ",", 0, ",", 5, "]=", 
        Rational[ 6, 7]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]0
        \[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]"]="\[InvisibleSpace]6\/7\),
      SequenceForm[ "gammaexact[", 2, ",", 0, ",", 5, "]=", 
        Rational[ 6, 7]],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("modgamma["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]0
        \[InvisibleSpace]","\[InvisibleSpace]6
        \[InvisibleSpace]"]="\[InvisibleSpace]14\/15\),
      SequenceForm[ "modgamma[", 2, ",", 0, ",", 6, "]=", 
        Rational[ 14, 15]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]0
        \[InvisibleSpace]","\[InvisibleSpace]6
        \[InvisibleSpace]"]="\[InvisibleSpace]14\/15\),
      SequenceForm[ "gammaexact[", 2, ",", 0, ",", 6, "]=", 
        Rational[ 14, 15]],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("modgamma["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]0
        \[InvisibleSpace]","\[InvisibleSpace]7
        \[InvisibleSpace]"]="\[InvisibleSpace]56\/65\),
      SequenceForm[ "modgamma[", 2, ",", 0, ",", 7, "]=", 
        Rational[ 56, 65]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]0
        \[InvisibleSpace]","\[InvisibleSpace]7
        \[InvisibleSpace]"]="\[InvisibleSpace]56\/65\),
      SequenceForm[ "gammaexact[", 2, ",", 0, ",", 7, "]=", 
        Rational[ 56, 65]],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("modgamma["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]0
        \[InvisibleSpace]","\[InvisibleSpace]8
        \[InvisibleSpace]"]="\[InvisibleSpace]12\/13\),
      SequenceForm[ "modgamma[", 2, ",", 0, ",", 8, "]=", 
        Rational[ 12, 13]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]0
        \[InvisibleSpace]","\[InvisibleSpace]8
        \[InvisibleSpace]"]="\[InvisibleSpace]12\/13\),
      SequenceForm[ "gammaexact[", 2, ",", 0, ",", 8, "]=", 
        Rational[ 12, 13]],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("modgamma["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]0
        \[InvisibleSpace]","\[InvisibleSpace]9
        \[InvisibleSpace]"]="\[InvisibleSpace]45\/52\),
      SequenceForm[ "modgamma[", 2, ",", 0, ",", 9, "]=", 
        Rational[ 45, 52]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]0
        \[InvisibleSpace]","\[InvisibleSpace]9
        \[InvisibleSpace]"]="\[InvisibleSpace]45\/52\),
      SequenceForm[ "gammaexact[", 2, ",", 0, ",", 9, "]=", 
        Rational[ 45, 52]],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    \("   "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("modgamma["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "modgamma[", 2, ",", 1, ",", 1, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 2, ",", 1, ",", 1, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("modgamma["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "modgamma[", 2, ",", 1, ",", 2, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 2, ",", 1, ",", 2, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("modgamma["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "modgamma[", 2, ",", 1, ",", 3, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 2, ",", 1, ",", 3, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("modgamma["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "modgamma[", 2, ",", 1, ",", 4, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 2, ",", 1, ",", 4, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("modgamma["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "modgamma[", 2, ",", 1, ",", 5, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 2, ",", 1, ",", 5, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("modgamma["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]6
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "modgamma[", 2, ",", 1, ",", 6, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]6
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 2, ",", 1, ",", 6, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("modgamma["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]7
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "modgamma[", 2, ",", 1, ",", 7, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]7
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 2, ",", 1, ",", 7, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("modgamma["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]8
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "modgamma[", 2, ",", 1, ",", 8, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]8
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 2, ",", 1, ",", 8, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("modgamma["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]9
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "modgamma[", 2, ",", 1, ",", 9, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]9
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 2, ",", 1, ",", 9, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("modgamma["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]10
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "modgamma[", 2, ",", 1, ",", 10, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]10
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 2, ",", 1, ",", 10, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    \({8.01666666666665861`\ Second, Null}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(MemoryInUse[]\)], "Input"],

Cell[BoxData[
    \(1046144\)], "Output"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Computing the modified beta coefficients", "Subsection"],

Cell[BoxData[
    \(\( (*\ set\ the\ values\ of\ d\ and\ nmax\ *) \nd = 2; \ 
    nmax = \ 10\ \ ; \ \ \  (*\ for\ example\ *) \)\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(MemoryInUse[]\)], "Input"],

Cell[BoxData[
    \(1047960\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Timing[printmodbeta[d,nmax,Infinity,$MachinePrecision,True,False]]\
\
\>", "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    InterpretationBox[
      \("modbeta["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]0
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "modbeta[", 2, ",", 0, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("betaexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]0
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "betaexact[", 2, ",", 0, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("modbeta["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "modbeta[", 2, ",", 1, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("betaexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "betaexact[", 2, ",", 1, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("modbeta["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "modbeta[", 2, ",", 2, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("betaexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "betaexact[", 2, ",", 2, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("modbeta["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "modbeta[", 2, ",", 3, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("betaexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "betaexact[", 2, ",", 3, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("modbeta["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "modbeta[", 2, ",", 4, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("betaexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "betaexact[", 2, ",", 4, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("modbeta["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "modbeta[", 2, ",", 5, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("betaexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "betaexact[", 2, ",", 5, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("modbeta["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]6
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "modbeta[", 2, ",", 6, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("betaexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]6
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "betaexact[", 2, ",", 6, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("modbeta["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]7
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "modbeta[", 2, ",", 7, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("betaexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]7
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "betaexact[", 2, ",", 7, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("modbeta["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]8
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "modbeta[", 2, ",", 8, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("betaexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]8
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "betaexact[", 2, ",", 8, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("modbeta["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]9
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "modbeta[", 2, ",", 9, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("betaexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]9
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "betaexact[", 2, ",", 9, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    \({4.84999999999999431`\ Second, Null}\)], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(MemoryInUse[]\)], "Input"],

Cell[BoxData[
    \(1050744\)], "Output"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["\<\
Computing the d-orthogonal polynomials from the modified \
coefficients\
\>", "Subsection"],

Cell[BoxData[
    \(\( (*\ set\ the\ values\ of\ d\ and\ nmax\ *) \nd = 2; \ nmax = \ 10\ ; 
    \ \ \ \  (*\ for\ example\ *) \)\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(MemoryInUse[]\)], "Input"],

Cell[BoxData[
    \(1052576\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Timing[printmoddorthpoly[d,nmax,x,Infinity]]", "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("moddorthpoly["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "x", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", 
        InterpretationBox["\[Infinity]",
          DirectedInfinity[ 1]], "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", "1"}],
      SequenceForm[ "moddorthpoly[", 2, ",", 0, ",", x, ",", 
        DirectedInfinity[ 1], "]=", 1],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("moddorthpoly["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "x", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", 
        InterpretationBox["\[Infinity]",
          DirectedInfinity[ 1]], "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", "x"}],
      SequenceForm[ "moddorthpoly[", 2, ",", 1, ",", x, ",", 
        DirectedInfinity[ 1], "]=", x],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("moddorthpoly["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "x", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", 
        InterpretationBox["\[Infinity]",
          DirectedInfinity[ 1]], "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", \(x\^2\)}],
      SequenceForm[ "moddorthpoly[", 2, ",", 2, ",", x, ",", 
        DirectedInfinity[ 1], "]=", 
        Power[ x, 2]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("moddorthpoly["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "x", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", 
        InterpretationBox["\[Infinity]",
          DirectedInfinity[ 1]], "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", \(\( - 1\) + x\^3\)}],
      SequenceForm[ "moddorthpoly[", 2, ",", 3, ",", x, ",", 
        DirectedInfinity[ 1], "]=", 
        Plus[ -1, 
          Power[ x, 3]]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("moddorthpoly["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "4", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "x", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", 
        InterpretationBox["\[Infinity]",
          DirectedInfinity[ 1]], "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", \(\( - 2\)\ x + x\^4\)}],
      SequenceForm[ "moddorthpoly[", 2, ",", 4, ",", x, ",", 
        DirectedInfinity[ 1], "]=", 
        Plus[ 
          Times[ -2, x], 
          Power[ x, 4]]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("moddorthpoly["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "x", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", 
        InterpretationBox["\[Infinity]",
          DirectedInfinity[ 1]], "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", \(\( - \(20\ x\^2\)\/7\) + x\^5\)}],
      SequenceForm[ "moddorthpoly[", 2, ",", 5, ",", x, ",", 
        DirectedInfinity[ 1], "]=", 
        Plus[ 
          Times[ 
            Rational[ -20, 7], 
            Power[ x, 2]], 
          Power[ x, 5]]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("moddorthpoly["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "6", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "x", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", 
        InterpretationBox["\[Infinity]",
          DirectedInfinity[ 1]], "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", \(20\/21 - \(80\ x\^3\)\/21 + x\^6\)}],
      SequenceForm[ "moddorthpoly[", 2, ",", 6, ",", x, ",", 
        DirectedInfinity[ 1], "]=", 
        Plus[ 
          Rational[ 20, 21], 
          Times[ 
            Rational[ -80, 21], 
            Power[ x, 3]], 
          Power[ x, 6]]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("moddorthpoly["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "7", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "x", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", 
        InterpretationBox["\[Infinity]",
          DirectedInfinity[ 1]], "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", \(\(8\ x\)\/3 - \(14\ x\^4\)\/3 + x\^7\)}],
      SequenceForm[ "moddorthpoly[", 2, ",", 7, ",", x, ",", 
        DirectedInfinity[ 1], "]=", 
        Plus[ 
          Times[ 
            Rational[ 8, 3], x], 
          Times[ 
            Rational[ -14, 3], 
            Power[ x, 4]], 
          Power[ x, 7]]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("moddorthpoly["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "8", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "x", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", 
        InterpretationBox["\[Infinity]",
          DirectedInfinity[ 1]], "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", \(\(16\ x\^2\)\/3 - \(28\ x\^5\)\/5 + x\^8\)}],
      SequenceForm[ "moddorthpoly[", 2, ",", 8, ",", x, ",", 
        DirectedInfinity[ 1], "]=", 
        Plus[ 
          Times[ 
            Rational[ 16, 3], 
            Power[ x, 2]], 
          Times[ 
            Rational[ -28, 5], 
            Power[ x, 5]], 
          Power[ x, 8]]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("moddorthpoly["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "9", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "x", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", 
        InterpretationBox["\[Infinity]",
          DirectedInfinity[ 1]], "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        \(\( - 32\/39\) + \(112\ x\^3\)\/13 - \(84\ x\^6\)\/13 + x\^9\)}],
      SequenceForm[ "moddorthpoly[", 2, ",", 9, ",", x, ",", 
        DirectedInfinity[ 1], "]=", 
        Plus[ 
          Rational[ -32, 39], 
          Times[ 
            Rational[ 112, 13], 
            Power[ x, 3]], 
          Times[ 
            Rational[ -84, 13], 
            Power[ x, 6]], 
          Power[ x, 9]]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("moddorthpoly["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "10", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "x", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", 
        InterpretationBox["\[Infinity]",
          DirectedInfinity[ 1]], "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        \(\( - \(128\ x\)\/39\) + \(168\ x\^4\)\/13 - \(96\ x\^7\)\/13 + 
          x\^10\)}],
      SequenceForm[ "moddorthpoly[", 2, ",", 10, ",", x, ",", 
        DirectedInfinity[ 1], "]=", 
        Plus[ 
          Times[ 
            Rational[ -128, 39], x], 
          Times[ 
            Rational[ 168, 13], 
            Power[ x, 4]], 
          Times[ 
            Rational[ -96, 13], 
            Power[ x, 7]], 
          Power[ x, 10]]],
      Editable->False]], "Print"],

Cell[BoxData[
    \({3.09999999999999431`\ Second, Null}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(MemoryInUse[]\)], "Input"],

Cell[BoxData[
    \(1058056\)], "Output"]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["\<\
Computing the recurrence coefficients and the orthogonal \
polynomials performing numerical computations with the machine precision\
\>",
   "Section",
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell["\<\
Loading the package modchv.m, the package datamodchv42.m is \
automatically loaded\
\>", "Subsection"],

Cell[BoxData[
    \(\(<< modchebyshev`modchv`; \)\)], "Input"]
}, Closed]],

Cell[CellGroupData[{

Cell["Computing the modified gamma coefficients", "Subsection"],

Cell[BoxData[
    \(\( (*\ set\ the\ values\ of\ d\ and\ nmax\ *) \nd = 2; \ 
    nmax = \ 10\ \ ; \ \ \  (*\ for\ example\ *) \)\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(MemoryInUse[]\)], "Input"],

Cell[BoxData[
    \(985776\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Timing[printmodgamma[d,nmax,$MachinePrecision,$MachinePrecision,\
True,True]]\
\>", "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    \("   "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("modgamma["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\),
         "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["1.`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "modgamma[", 2, ",", 0, ",", 1, "]=", 1.0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["1.`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gammaexact[", 2, ",", 0, ",", 1, "]=", 1.0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        InterpretationBox["\[Infinity]",
          DirectedInfinity[ 1]]}],
      SequenceForm[ "exactdigits[", 2, ",", 0, ",", 1, "]=", 
        DirectedInfinity[ 1]],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("modgamma["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\),
         "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["1.`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "modgamma[", 2, ",", 0, ",", 2, "]=", 1.0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["1.`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gammaexact[", 2, ",", 0, ",", 2, "]=", 1.0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        InterpretationBox["\[Infinity]",
          DirectedInfinity[ 1]]}],
      SequenceForm[ "exactdigits[", 2, ",", 0, ",", 2, "]=", 
        DirectedInfinity[ 1]],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("modgamma["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\),
         "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["0.857142865657806396`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "modgamma[", 2, ",", 0, ",", 3, "]=", 0.8571428656578064],
      
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["0.857142857142857117`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "gammaexact[", 2, ",", 0, ",", 3, "]=", 0.8571428571428571],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["7.06981793352299625`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 2, ",", 0, ",", 3, "]=", 7.0698179335229963],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("modgamma["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\),
         "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "4", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["0.952340245246887207`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "modgamma[", 2, ",", 0, ",", 4, "]=", 0.95234024524688721],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "4", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["0.952380952380952372`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "gammaexact[", 2, ",", 0, ",", 4, "]=", 0.95238095238095233],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "4", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["3.39032947250433203`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 2, ",", 0, ",", 4, "]=", 3.390329472504332],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("modgamma["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\),
         "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "5", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["1.45129150890921998`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "modgamma[", 2, ",", 0, ",", 5, "]=", 1.45129150890922],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "5", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["0.857142857142857117`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "gammaexact[", 2, ",", 0, ",", 5, "]=", 0.8571428571428571],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "5", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["0.226104884033744957`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 2, ",", 0, ",", 5, "]=", 0.22610488403374496],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("modgamma["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\),
         "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "6", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        RowBox[{"-", 
          StyleBox["26378.9295278579505`",
            StyleBoxAutoDelete->True,
            PrintPrecision->16]}]}],
      SequenceForm[ 
      "modgamma[", 2, ",", 0, ",", 6, "]=", -26378.929527857956],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "6", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["0.933333333333333392`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "gammaexact[", 2, ",", 0, ",", 6, "]=", 0.93333333333333335],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "6", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        RowBox[{"-", 
          StyleBox["0.421272533485452349`",
            StyleBoxAutoDelete->True,
            PrintPrecision->2]}]}],
      SequenceForm[ 
      "exactdigits[", 2, ",", 0, ",", 6, "]=", -0.42127253348545235],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("modgamma["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\),
         "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "7", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["3.57275700820271557`*^9",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "modgamma[", 2, ",", 0, ",", 7, "]=", 3572757008.2027159],
      
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "7", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["0.861538461538461675`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "gammaexact[", 2, ",", 0, ",", 7, "]=", 0.86153846153846159],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "7", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        RowBox[{"-", 
          StyleBox["0.55300347968984731`",
            StyleBoxAutoDelete->True,
            PrintPrecision->2]}]}],
      SequenceForm[ 
      "exactdigits[", 2, ",", 0, ",", 7, "]=", -0.55300347968984731],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("modgamma["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\),
         "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "8", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        RowBox[{"-", 
          StyleBox["5.36997835688847136`*^8",
            StyleBoxAutoDelete->True,
            PrintPrecision->16]}]}],
      SequenceForm[ 
      "modgamma[", 2, ",", 0, ",", 8, "]=", -536997835.68884706],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "8", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["0.923076923076923172`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "gammaexact[", 2, ",", 0, ",", 8, "]=", 0.92307692307692313],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "8", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        RowBox[{"-", 
          StyleBox["0.729972536073120181`",
            StyleBoxAutoDelete->True,
            PrintPrecision->2]}]}],
      SequenceForm[ 
      "exactdigits[", 2, ",", 0, ",", 8, "]=", -0.72997253607312018],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("modgamma["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\),
         "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "9", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["5.09930608239180749`*^7",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "modgamma[", 2, ",", 0, ",", 9, "]=", 50993060.823918082],
      
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "9", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["0.865384615384615329`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "gammaexact[", 2, ",", 0, ",", 9, "]=", 0.86538461538461542],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "9", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        RowBox[{"-", 
          StyleBox["0.707511073611571283`",
            StyleBoxAutoDelete->True,
            PrintPrecision->2]}]}],
      SequenceForm[ 
      "exactdigits[", 2, ",", 0, ",", 9, "]=", -0.70751107361157128],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    \("   "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("modgamma["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\),
         "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["0.`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "modgamma[", 2, ",", 1, ",", 1, "]=", 0.0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 2, ",", 1, ",", 1, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("abserror["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\),
         "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["0.`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ "abserror[", 2, ",", 1, ",", 1, "]=", 0.0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("modgamma["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\),
         "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["0.`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "modgamma[", 2, ",", 1, ",", 2, "]=", 0.0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 2, ",", 1, ",", 2, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("abserror["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\),
         "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["0.`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ "abserror[", 2, ",", 1, ",", 2, "]=", 0.0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("modgamma["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\),
         "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["0.`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "modgamma[", 2, ",", 1, ",", 3, "]=", 0.0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 2, ",", 1, ",", 3, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("abserror["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\),
         "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["0.`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ "abserror[", 2, ",", 1, ",", 3, "]=", 0.0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("modgamma["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\),
         "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "4", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["0.`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "modgamma[", 2, ",", 1, ",", 4, "]=", 0.0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 2, ",", 1, ",", 4, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("abserror["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\),
         "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "4", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["0.`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ "abserror[", 2, ",", 1, ",", 4, "]=", 0.0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("modgamma["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\),
         "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "5", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["0.00200118616112001923`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "modgamma[", 2, ",", 1, ",", 5, "]=", 0.0020011861611200195],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 2, ",", 1, ",", 5, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("abserror["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\),
         "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "5", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["0.00200118616112001923`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "abserror[", 2, ",", 1, ",", 5, "]=", 0.0020011861611200195],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("modgamma["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\),
         "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "6", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        RowBox[{"-", 
          StyleBox["62.9870555024418266`",
            StyleBoxAutoDelete->True,
            PrintPrecision->16]}]}],
      SequenceForm[ 
      "modgamma[", 2, ",", 1, ",", 6, "]=", -62.987055502441827],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]6
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 2, ",", 1, ",", 6, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("abserror["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\),
         "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "6", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["62.9870555024418266`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ "abserror[", 2, ",", 1, ",", 6, "]=", 62.987055502441827],
      
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("modgamma["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\),
         "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "7", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["904844.787447855658`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "modgamma[", 2, ",", 1, ",", 7, "]=", 904844.78744785569],
      
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]7
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 2, ",", 1, ",", 7, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("abserror["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\),
         "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "7", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["904844.787447855658`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ "abserror[", 2, ",", 1, ",", 7, "]=", 904844.78744785569],
      
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("modgamma["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\),
         "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "8", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        RowBox[{"-", 
          StyleBox["1.15138245853275722`*^7",
            StyleBoxAutoDelete->True,
            PrintPrecision->16]}]}],
      SequenceForm[ 
      "modgamma[", 2, ",", 1, ",", 8, "]=", -11513824.585327573],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]8
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 2, ",", 1, ",", 8, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("abserror["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\),
         "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "8", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["1.15138245853275722`*^7",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ "abserror[", 2, ",", 1, ",", 8, "]=", 11513824.585327573],
      
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("modgamma["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\),
         "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "9", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["186499.144575049236`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "modgamma[", 2, ",", 1, ",", 9, "]=", 186499.14457504923],
      
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]9
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 2, ",", 1, ",", 9, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("abserror["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\),
         "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "9", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["186499.144575049236`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ "abserror[", 2, ",", 1, ",", 9, "]=", 186499.14457504923],
      
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("modgamma["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\),
         "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "10", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        RowBox[{"-", 
          StyleBox["365850.089140350176`",
            StyleBoxAutoDelete->True,
            PrintPrecision->16]}]}],
      SequenceForm[ 
      "modgamma[", 2, ",", 1, ",", 10, "]=", -365850.08914035017],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]10
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 2, ",", 1, ",", 10, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("abserror["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\),
         "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "10", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["365850.089140350176`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "abserror[", 2, ",", 1, ",", 10, "]=", 365850.08914035017],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    \({10.5333333333333456`\ Second, Null}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(MemoryInUse[]\)], "Input"],

Cell[BoxData[
    \(1059376\)], "Output"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Computing the modified beta coefficients", "Subsection"],

Cell[BoxData[
    \(\( (*\ set\ the\ values\ of\ d\ and\ nmax\ *) \nd = 2; \ nmax = \ 10\ ; 
    \ \ \ \  (*\ for\ example\ *) \)\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(MemoryInUse[]\)], "Input"],

Cell[BoxData[
    \(1061160\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Timing[printmodbeta[d,nmax,$MachinePrecision,$MachinePrecision,True,\
True]]\
\>", "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("modbeta["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["0.`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "modbeta[", 2, ",", 0, "]=", 0.0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("betaexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]0
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "betaexact[", 2, ",", 0, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("abserror["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\),
         "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["0.`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ "abserror[", 2, ",", 0, "]=", 0.0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("modbeta["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["0.`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "modbeta[", 2, ",", 1, "]=", 0.0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("betaexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "betaexact[", 2, ",", 1, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("abserror["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\),
         "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["0.`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ "abserror[", 2, ",", 1, "]=", 0.0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("modbeta["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["0.`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "modbeta[", 2, ",", 2, "]=", 0.0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("betaexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "betaexact[", 2, ",", 2, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("abserror["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\),
         "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["0.`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ "abserror[", 2, ",", 2, "]=", 0.0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("modbeta["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["0.`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "modbeta[", 2, ",", 3, "]=", 0.0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("betaexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "betaexact[", 2, ",", 3, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("abserror["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\),
         "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["0.`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ "abserror[", 2, ",", 3, "]=", 0.0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("modbeta["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "4", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["5.56310012456151525`*^-6",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "modbeta[", 2, ",", 4, "]=", 5.5631001245615153*^-06],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("betaexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "betaexact[", 2, ",", 4, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("abserror["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\),
         "\[InvisibleSpace]", "4", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["5.56310012456151525`*^-6",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ "abserror[", 2, ",", 4, "]=", 5.5631001245615153*^-06],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("modbeta["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "5", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        RowBox[{"-", 
          StyleBox["0.0623107202268187165`",
            StyleBoxAutoDelete->True,
            PrintPrecision->16]}]}],
      SequenceForm[ "modbeta[", 2, ",", 5, "]=", -0.062310720226818717],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("betaexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "betaexact[", 2, ",", 5, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("abserror["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\),
         "\[InvisibleSpace]", "5", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["0.0623107202268187165`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ "abserror[", 2, ",", 5, "]=", 0.062310720226818717],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("modbeta["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "6", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["389.453170982464982`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "modbeta[", 2, ",", 6, "]=", 389.453170982465],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("betaexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]6
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "betaexact[", 2, ",", 6, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("abserror["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\),
         "\[InvisibleSpace]", "6", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["389.453170982464982`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ "abserror[", 2, ",", 6, "]=", 389.453170982465],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("modbeta["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "7", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        RowBox[{"-", 
          StyleBox["1998.58296439209048`",
            StyleBoxAutoDelete->True,
            PrintPrecision->16]}]}],
      SequenceForm[ "modbeta[", 2, ",", 7, "]=", -1998.5829643920906],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("betaexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]7
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "betaexact[", 2, ",", 7, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("abserror["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\),
         "\[InvisibleSpace]", "7", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["1998.58296439209048`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ "abserror[", 2, ",", 7, "]=", 1998.5829643920906],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("modbeta["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "8", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["4672.19823180375648`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "modbeta[", 2, ",", 8, "]=", 4672.1982318037562],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("betaexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]8
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "betaexact[", 2, ",", 8, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("abserror["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\),
         "\[InvisibleSpace]", "8", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["4672.19823180375648`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ "abserror[", 2, ",", 8, "]=", 4672.1982318037562],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("modbeta["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "9", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["2975.09222696863453`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "modbeta[", 2, ",", 9, "]=", 2975.0922269686343],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("betaexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]9
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "betaexact[", 2, ",", 9, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("abserror["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\),
         "\[InvisibleSpace]", "9", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["2975.09222696863453`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ "abserror[", 2, ",", 9, "]=", 2975.0922269686343],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    \({6.58333333333331438`\ Second, Null}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(MemoryInUse[]\)], "Input"],

Cell[BoxData[
    \(1062904\)], "Output"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["\<\
Computing the d-orthogonal polynomials from the modified \
coefficients\
\>", "Subsection"],

Cell[BoxData[
    \(\( (*\ set\ the\ values\ of\ d\ and\ nmax\ *) \nd = 2; \ nmax = \ 10; 
    \ \ \  (*\ for\ example\ *) \)\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(MemoryInUse[]\)], "Input"],

Cell[BoxData[
    \(1064688\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Timing[printmoddorthpoly[d,nmax,x,$MachinePrecision]]", "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("moddorthpoly["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "x", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["1.`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "moddorthpoly[", 2, ",", 0, ",", x, "]=", 1.0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("moddorthpoly["\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]x
        \[InvisibleSpace]"]="\[InvisibleSpace]x\),
      SequenceForm[ "moddorthpoly[", 2, ",", 1, ",", x, "]=", x],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("moddorthpoly["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "x", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        RowBox[{
          RowBox[{
            StyleBox["0.`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", "x"}], "+", \(x\^2\)}]}],
      SequenceForm[ "moddorthpoly[", 2, ",", 2, ",", x, "]=", 
        Plus[ 
          Times[ 0.0, x], 
          Power[ x, 2]]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("moddorthpoly["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "x", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        RowBox[{
          RowBox[{"-", 
            StyleBox["1.`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16]}], "+", 
          RowBox[{
            StyleBox["0.`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", "x"}], "+", 
          RowBox[{
            StyleBox["0.`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^2\)}], "+", \(x\^3\)}]}],
      SequenceForm[ "moddorthpoly[", 2, ",", 3, ",", x, "]=", 
        Plus[ -1.0, 
          Times[ 0.0, x], 
          Times[ 0.0, 
            Power[ x, 2]], 
          Power[ x, 3]]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("moddorthpoly["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "4", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "x", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        RowBox[{
          RowBox[{
            RowBox[{"-", 
              StyleBox["2.`",
                StyleBoxAutoDelete->True,
                PrintPrecision->16]}], " ", "x"}], "+", 
          RowBox[{
            StyleBox["0.`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^2\)}], "+", 
          RowBox[{
            StyleBox["0.`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^3\)}], "+", \(x\^4\)}]}],
      SequenceForm[ "moddorthpoly[", 2, ",", 4, ",", x, "]=", 
        Plus[ 
          Times[ -2.0, x], 
          Times[ 0.0, 
            Power[ x, 2]], 
          Times[ 0.0, 
            Power[ x, 3]], 
          Power[ x, 4]]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("moddorthpoly["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "x", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        RowBox[{
          RowBox[{
            StyleBox["0.0000111262002491230305`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", "x"}], "-", 
          RowBox[{
            StyleBox["2.85714286565780639`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^2\)}], "+", 
          RowBox[{
            StyleBox["0.`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^3\)}], "-", 
          RowBox[{
            StyleBox["5.56310012456151525`*^-6",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^4\)}], "+", \(x\^5\)}]}],
      SequenceForm[ "moddorthpoly[", 2, ",", 5, ",", x, "]=", 
        Plus[ 
          Times[ 1.1126200249123031*^-05, x], 
          Times[ -2.8571428656578064, 
            Power[ x, 2]], 
          Times[ 0.0, 
            Power[ x, 3]], 
          Times[ -5.5631001245615153*^-06, 
            Power[ x, 4]], 
          Power[ x, 5]]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("moddorthpoly["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "6", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "x", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        RowBox[{
          RowBox[{
            StyleBox["0.952340245246887207`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], "\[InvisibleSpace]"}], "+", 
          RowBox[{
            StyleBox["0.00400306560379094911`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", "x"}], "-", 
          RowBox[{
            StyleBox["0.178019503549805557`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^2\)}], "-", 
          RowBox[{
            StyleBox["3.8094831109046936`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^3\)}], "-", 
          RowBox[{
            StyleBox["0.00200153280189547455`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^4\)}], "+", 
          RowBox[{
            StyleBox["0.062305157126694155`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^5\)}], "+", \(x\^6\)}]}],
      SequenceForm[ "moddorthpoly[", 2, ",", 6, ",", x, "]=", 
        Plus[ 0.95234024524688721, 
          Times[ 0.0040030656037909496, x], 
          Times[ -0.17801950354980556, 
            Power[ x, 2]], 
          Times[ -3.8094831109046936, 
            Power[ x, 3]], 
          Times[ -0.0020015328018954748, 
            Power[ x, 4]], 
          Times[ 0.062305157126694155, 
            Power[ x, 5]], 
          Power[ x, 6]]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("moddorthpoly["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "7", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "x", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        RowBox[{
          RowBox[{"-", 
            StyleBox["370.891928365618639`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16]}], "+", 
          RowBox[{
            StyleBox["2.29661747661072901`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", "x"}], "-", 
          RowBox[{
            StyleBox["110.628753037794202`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^2\)}], "+", 
          RowBox[{
            StyleBox["1483.43725784242845`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^3\)}], "-", 
          RowBox[{
            StyleBox["4.48162172658661361`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^4\)}], "+", 
          RowBox[{
            StyleBox["38.7201129580881655`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^5\)}], "-", 
          RowBox[{
            StyleBox["389.390865825338305`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^6\)}], "+", \(x\^7\)}]}],
      SequenceForm[ "moddorthpoly[", 2, ",", 7, ",", x, "]=", 
        Plus[ -370.89192836561864, 
          Times[ 2.296617476610729, x], 
          Times[ -110.6287530377942, 
            Power[ x, 2]], 
          Times[ 1483.4372578424284, 
            Power[ x, 3]], 
          Times[ -4.4816217265866136, 
            Power[ x, 4]], 
          Times[ 38.720112958088166, 
            Power[ x, 5]], 
          Times[ -389.39086582533832, 
            Power[ x, 6]], 
          Power[ x, 7]]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("moddorthpoly["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "8", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "x", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        RowBox[{
          RowBox[{"-", 
            StyleBox["1.60297839645051531`*^6",
              StyleBoxAutoDelete->True,
              PrintPrecision->16]}], "+", 
          RowBox[{
            StyleBox["597.229087963974958`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", "x"}], "-", 
          RowBox[{
            StyleBox["135386.795028911377`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^2\)}], "+", 
          RowBox[{
            StyleBox["6.41165273928810997`*^6",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^3\)}], "-", 
          RowBox[{
            StyleBox["5662.52580368816538`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^4\)}], "+", 
          RowBox[{
            StyleBox["47383.3093862949805`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^5\)}], "-", 
          RowBox[{
            StyleBox["1.68303601826330506`*^6",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^6\)}], "+", 
          RowBox[{
            StyleBox["1609.19209856675209`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^7\)}], "+", \(x\^8\)}]}],
      SequenceForm[ "moddorthpoly[", 2, ",", 8, ",", x, "]=", 
        Plus[ -1602978.3964505154, 
          Times[ 597.22908796397496, x], 
          Times[ -135386.79502891138, 
            Power[ x, 2]], 
          Times[ 6411652.7392881103, 
            Power[ x, 3]], 
          Times[ -5662.525803688166, 
            Power[ x, 4]], 
          Times[ 47383.30938629499, 
            Power[ x, 5]], 
          Times[ -1683036.0182633051, 
            Power[ x, 6]], 
          Times[ 1609.1920985667523, 
            Power[ x, 7]], 
          Power[ x, 8]]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("moddorthpoly["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "9", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "x", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        RowBox[{
          RowBox[{"-", 
            StyleBox["1.83432059199203472`*^8",
              StyleBoxAutoDelete->True,
              PrintPrecision->16]}], "+", 
          RowBox[{
            StyleBox["7.74751898983666364`*^6",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", "x"}], "-", 
          RowBox[{
            StyleBox["5.18508609360587602`*^6",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^2\)}], "+", 
          RowBox[{
            StyleBox["7.33745874015049004`*^8",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^3\)}], "-", 
          RowBox[{
            StyleBox["1.15815202857683829`*^7",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^4\)}], "+", 
          RowBox[{
            StyleBox["1.82552489446687715`*^6",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^5\)}], "-", 
          RowBox[{
            StyleBox["1.92609840543251991`*^8",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^6\)}], "+", 
          RowBox[{
            StyleBox["2.3123240895081123`*^6",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^7\)}], "-", 
          RowBox[{
            StyleBox["3063.00613323700421`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^8\)}], "+", \(x\^9\)}]}],
      SequenceForm[ "moddorthpoly[", 2, ",", 9, ",", x, "]=", 
        Plus[ -183432059.19920349, 
          Times[ 7747518.989836663, x], 
          Times[ -5185086.093605876, 
            Power[ x, 2]], 
          Times[ 733745874.01504898, 
            Power[ x, 3]], 
          Times[ -11581520.285768382, 
            Power[ x, 4]], 
          Times[ 1825524.894466877, 
            Power[ x, 5]], 
          Times[ -192609840.54325199, 
            Power[ x, 6]], 
          Times[ 2312324.0895081125, 
            Power[ x, 7]], 
          Times[ -3063.0061332370042, 
            Power[ x, 8]], 
          Power[ x, 9]]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("moddorthpoly["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "10", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "x", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        RowBox[{
          StyleBox["6.45513230403905691`*^11",
            StyleBoxAutoDelete->True,
            PrintPrecision->16], "-", 
          RowBox[{
            StyleBox["2.21111196838296208`*^10",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", "x"}], "-", 
          RowBox[{
            StyleBox["1.87240226343621145`*^10",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^2\)}], "-", 
          RowBox[{
            StyleBox["2.58213198578649416`*^12",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^3\)}], "+", 
          RowBox[{
            StyleBox["3.38392719036529721`*^10",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^4\)}], "+", 
          RowBox[{
            StyleBox["6.51298374449019501`*^9",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^5\)}], "+", 
          RowBox[{
            StyleBox["6.77816590472681923`*^11",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^6\)}], "-", 
          RowBox[{
            StyleBox["6.83510237962194189`*^9",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^7\)}], "+", 
          RowBox[{
            StyleBox["1.12385506830837256`*^7",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^8\)}], "-", 
          RowBox[{
            StyleBox["6038.09836020563839`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^9\)}], "+", \(x\^10\)}]}],
      SequenceForm[ "moddorthpoly[", 2, ",", 10, ",", x, "]=", 
        Plus[ 645513230403.90576, 
          Times[ -22111119683.82962, x], 
          Times[ -18724022634.362114, 
            Power[ x, 2]], 
          Times[ -2582131985786.4941, 
            Power[ x, 3]], 
          Times[ 33839271903.652973, 
            Power[ x, 4]], 
          Times[ 6512983744.4901962, 
            Power[ x, 5]], 
          Times[ 677816590472.68188, 
            Power[ x, 6]], 
          Times[ -6835102379.6219425, 
            Power[ x, 7]], 
          Times[ 11238550.683083726, 
            Power[ x, 8]], 
          Times[ -6038.0983602056385, 
            Power[ x, 9]], 
          Power[ x, 10]]],
      Editable->False]], "Print"],

Cell[BoxData[
    \({1.76666666666667993`\ Second, Null}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(MemoryInUse[]\)], "Input"],

Cell[BoxData[
    \(1071312\)], "Output"]
}, Open  ]]
}, Closed]]
}, Closed]]
},
FrontEndVersion->"Macintosh 3.0",
ScreenRectangle->{{0, 832}, {0, 604}},
WindowSize->{764, 580},
WindowMargins->{{4, Automatic}, {Automatic, 1}},
PrintingCopies->1,
PrintingPageRange->{1, Automatic},
MacintoshSystemPageSetup->"\<\
00<0004/0B`000003;H8`_n3ohL==`Tf0fL5N`?P0080004/0B`000000]P2:001
0000I00000400`<30?l00BL?00400@2dJ?0000000000060801T1T00000000000
00000000004000000000000000000000\>"
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{
Cell[1709, 49, 1291, 21, 580, "Subsection"],

Cell[CellGroupData[{
Cell[3025, 74, 154, 4, 68, "Section"],

Cell[CellGroupData[{
Cell[3204, 82, 112, 3, 44, "Subsection"],
Cell[3319, 87, 62, 1, 27, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[3418, 93, 135, 4, 44, "Subsection"],
Cell[3556, 99, 71, 1, 27, "Input"],
Cell[3630, 102, 142, 2, 43, "Input"],

Cell[CellGroupData[{
Cell[3797, 108, 141, 2, 27, "Input"],
Cell[3941, 112, 298, 6, 22, "Print"],
Cell[4242, 120, 298, 6, 22, "Print"],
Cell[4543, 128, 298, 6, 22, "Print"],
Cell[4844, 136, 298, 6, 22, "Print"],
Cell[5145, 144, 298, 6, 22, "Print"],
Cell[5446, 152, 298, 6, 22, "Print"],
Cell[5747, 160, 326, 7, 38, "Print"],
Cell[6076, 169, 298, 6, 22, "Print"],
Cell[6377, 177, 298, 6, 22, "Print"],
Cell[6678, 185, 326, 7, 38, "Print"],
Cell[7007, 194, 300, 6, 22, "Print"],
Cell[7310, 202, 298, 6, 22, "Print"],
Cell[7611, 210, 298, 6, 22, "Print"],
Cell[7912, 218, 298, 6, 22, "Print"],
Cell[8213, 226, 298, 6, 22, "Print"],
Cell[8514, 234, 298, 6, 22, "Print"],
Cell[8815, 242, 298, 6, 22, "Print"],
Cell[9116, 250, 298, 6, 22, "Print"],
Cell[9417, 258, 326, 7, 38, "Print"],
Cell[9746, 267, 298, 6, 22, "Print"],
Cell[10047, 275, 298, 6, 22, "Print"],
Cell[10348, 283, 328, 7, 38, "Print"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{
Cell[10725, 296, 121, 3, 28, "Subsection"],
Cell[10849, 301, 116, 3, 27, "Input"],
Cell[10968, 306, 142, 2, 43, "Input"],

Cell[CellGroupData[{
Cell[11135, 312, 384, 7, 75, "Input"],
Cell[11522, 321, 308, 6, 22, "Print"],
Cell[11833, 329, 312, 6, 22, "Print"],
Cell[12148, 337, 314, 6, 22, "Print"],
Cell[12465, 345, 316, 6, 22, "Print"],
Cell[12784, 353, 318, 6, 22, "Print"],
Cell[13105, 361, 318, 6, 22, "Print"],
Cell[13426, 369, 320, 6, 22, "Print"],
Cell[13749, 377, 320, 6, 22, "Print"],
Cell[14072, 385, 320, 6, 22, "Print"],
Cell[14395, 393, 51, 1, 22, "Print"],
Cell[14449, 396, 306, 6, 22, "Print"],
Cell[14758, 404, 310, 6, 22, "Print"],
Cell[15071, 412, 312, 6, 22, "Print"],
Cell[15386, 420, 314, 6, 22, "Print"],
Cell[15703, 428, 314, 6, 22, "Print"],
Cell[16020, 436, 314, 6, 22, "Print"],
Cell[16337, 444, 316, 6, 22, "Print"],
Cell[16656, 452, 316, 6, 22, "Print"],
Cell[16975, 460, 316, 6, 22, "Print"],
Cell[17294, 468, 318, 6, 22, "Print"],
Cell[17615, 476, 51, 1, 22, "Print"]
}, Open  ]],

Cell[CellGroupData[{
Cell[17703, 482, 167, 2, 43, "Input"],
Cell[17873, 486, 249, 5, 22, "Print"],
Cell[18125, 493, 251, 5, 22, "Print"],
Cell[18379, 500, 251, 5, 22, "Print"],
Cell[18633, 507, 253, 5, 22, "Print"],
Cell[18889, 514, 253, 5, 22, "Print"],
Cell[19145, 521, 253, 5, 22, "Print"],
Cell[19401, 528, 253, 5, 22, "Print"],
Cell[19657, 535, 253, 5, 22, "Print"],
Cell[19913, 542, 253, 5, 22, "Print"],
Cell[20169, 549, 255, 5, 22, "Print"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{
Cell[20473, 560, 63, 0, 28, "Subsection"],

Cell[CellGroupData[{
Cell[20561, 564, 142, 2, 43, "Input"],
Cell[20706, 568, 175, 3, 37, "Message"]
}, Open  ]],

Cell[CellGroupData[{
Cell[20918, 576, 46, 1, 27, "Input"],
Cell[20967, 579, 40, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[21044, 585, 120, 4, 27, "Input"],
Cell[21167, 591, 38, 1, 22, "Print"],
Cell[21208, 594, 306, 6, 22, "Print"],
Cell[21517, 602, 310, 6, 22, "Print"],
Cell[21830, 610, 37, 1, 22, "Print"],
Cell[21870, 613, 306, 6, 22, "Print"],
Cell[22179, 621, 310, 6, 22, "Print"],
Cell[22492, 629, 37, 1, 22, "Print"],
Cell[22532, 632, 332, 7, 38, "Print"],
Cell[22867, 641, 336, 7, 38, "Print"],
Cell[23206, 650, 37, 1, 22, "Print"],
Cell[23246, 653, 336, 7, 38, "Print"],
Cell[23585, 662, 340, 7, 38, "Print"],
Cell[23928, 671, 37, 1, 22, "Print"],
Cell[23968, 674, 332, 7, 38, "Print"],
Cell[24303, 683, 336, 7, 38, "Print"],
Cell[24642, 692, 37, 1, 22, "Print"],
Cell[24682, 695, 336, 7, 38, "Print"],
Cell[25021, 704, 340, 7, 38, "Print"],
Cell[25364, 713, 37, 1, 22, "Print"],
Cell[25404, 716, 336, 7, 38, "Print"],
Cell[25743, 725, 340, 7, 38, "Print"],
Cell[26086, 734, 37, 1, 22, "Print"],
Cell[26126, 737, 336, 7, 38, "Print"],
Cell[26465, 746, 340, 7, 38, "Print"],
Cell[26808, 755, 37, 1, 22, "Print"],
Cell[26848, 758, 336, 7, 38, "Print"],
Cell[27187, 767, 340, 7, 38, "Print"],
Cell[27530, 776, 37, 1, 22, "Print"],
Cell[27570, 779, 38, 1, 22, "Print"],
Cell[27611, 782, 306, 6, 22, "Print"],
Cell[27920, 790, 310, 6, 22, "Print"],
Cell[28233, 798, 37, 1, 22, "Print"],
Cell[28273, 801, 306, 6, 22, "Print"],
Cell[28582, 809, 310, 6, 22, "Print"],
Cell[28895, 817, 37, 1, 22, "Print"],
Cell[28935, 820, 306, 6, 22, "Print"],
Cell[29244, 828, 310, 6, 22, "Print"],
Cell[29557, 836, 37, 1, 22, "Print"],
Cell[29597, 839, 306, 6, 22, "Print"],
Cell[29906, 847, 310, 6, 22, "Print"],
Cell[30219, 855, 37, 1, 22, "Print"],
Cell[30259, 858, 306, 6, 22, "Print"],
Cell[30568, 866, 310, 6, 22, "Print"],
Cell[30881, 874, 37, 1, 22, "Print"],
Cell[30921, 877, 306, 6, 22, "Print"],
Cell[31230, 885, 310, 6, 22, "Print"],
Cell[31543, 893, 37, 1, 22, "Print"],
Cell[31583, 896, 306, 6, 22, "Print"],
Cell[31892, 904, 310, 6, 22, "Print"],
Cell[32205, 912, 37, 1, 22, "Print"],
Cell[32245, 915, 306, 6, 22, "Print"],
Cell[32554, 923, 310, 6, 22, "Print"],
Cell[32867, 931, 37, 1, 22, "Print"],
Cell[32907, 934, 306, 6, 22, "Print"],
Cell[33216, 942, 310, 6, 22, "Print"],
Cell[33529, 950, 37, 1, 22, "Print"],
Cell[33569, 953, 308, 6, 22, "Print"],
Cell[33880, 961, 312, 6, 22, "Print"],
Cell[34195, 969, 37, 1, 22, "Print"],
Cell[34235, 972, 70, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[34342, 978, 46, 1, 27, "Input"],
Cell[34391, 981, 41, 1, 26, "Output"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{
Cell[34481, 988, 62, 0, 28, "Subsection"],
Cell[34546, 990, 142, 2, 43, "Input"],

Cell[CellGroupData[{
Cell[34713, 996, 46, 1, 27, "Input"],
Cell[34762, 999, 41, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[34840, 1005, 119, 4, 27, "Input"],
Cell[34962, 1011, 249, 5, 22, "Print"],
Cell[35214, 1018, 253, 5, 22, "Print"],
Cell[35470, 1025, 37, 1, 22, "Print"],
Cell[35510, 1028, 249, 5, 22, "Print"],
Cell[35762, 1035, 253, 5, 22, "Print"],
Cell[36018, 1042, 37, 1, 22, "Print"],
Cell[36058, 1045, 249, 5, 22, "Print"],
Cell[36310, 1052, 253, 5, 22, "Print"],
Cell[36566, 1059, 37, 1, 22, "Print"],
Cell[36606, 1062, 249, 5, 22, "Print"],
Cell[36858, 1069, 253, 5, 22, "Print"],
Cell[37114, 1076, 37, 1, 22, "Print"],
Cell[37154, 1079, 249, 5, 22, "Print"],
Cell[37406, 1086, 253, 5, 22, "Print"],
Cell[37662, 1093, 37, 1, 22, "Print"],
Cell[37702, 1096, 249, 5, 22, "Print"],
Cell[37954, 1103, 253, 5, 22, "Print"],
Cell[38210, 1110, 37, 1, 22, "Print"],
Cell[38250, 1113, 249, 5, 22, "Print"],
Cell[38502, 1120, 253, 5, 22, "Print"],
Cell[38758, 1127, 37, 1, 22, "Print"],
Cell[38798, 1130, 249, 5, 22, "Print"],
Cell[39050, 1137, 253, 5, 22, "Print"],
Cell[39306, 1144, 37, 1, 22, "Print"],
Cell[39346, 1147, 249, 5, 22, "Print"],
Cell[39598, 1154, 253, 5, 22, "Print"],
Cell[39854, 1161, 37, 1, 22, "Print"],
Cell[39894, 1164, 249, 5, 22, "Print"],
Cell[40146, 1171, 253, 5, 22, "Print"],
Cell[40402, 1178, 37, 1, 22, "Print"],
Cell[40442, 1181, 70, 1, 26, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[40549, 1187, 46, 1, 24, "Input"],
Cell[40598, 1190, 41, 1, 26, "Output"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{
Cell[40688, 1197, 101, 3, 28, "Subsection"],
Cell[40792, 1202, 142, 2, 43, "Input"],

Cell[CellGroupData[{
Cell[40959, 1208, 46, 1, 27, "Input"],
Cell[41008, 1211, 41, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[41086, 1217, 87, 1, 27, "Input"],
Cell[41176, 1220, 573, 12, 22, "Print"],
Cell[41752, 1234, 573, 12, 22, "Print"],
Cell[42328, 1248, 598, 13, 24, "Print"],
Cell[42929, 1263, 631, 14, 24, "Print"],
Cell[43563, 1279, 656, 15, 24, "Print"],
Cell[44222, 1296, 719, 17, 40, "Print"],
Cell[44944, 1315, 753, 18, 40, "Print"],
Cell[45700, 1335, 778, 19, 40, "Print"],
Cell[46481, 1356, 807, 20, 40, "Print"],
Cell[47291, 1378, 869, 22, 40, "Print"],
Cell[48163, 1402, 917, 24, 40, "Print"],
Cell[49083, 1428, 70, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[49190, 1434, 46, 1, 27, "Input"],
Cell[49239, 1437, 41, 1, 26, "Output"]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[49341, 1445, 187, 5, 48, "Section"],

Cell[CellGroupData[{
Cell[49553, 1454, 112, 3, 44, "Subsection"],
Cell[49668, 1459, 62, 1, 27, "Input"]
}, Closed]],

Cell[CellGroupData[{
Cell[49767, 1465, 63, 0, 28, "Subsection"],
Cell[49833, 1467, 142, 2, 43, "Input"],

Cell[CellGroupData[{
Cell[50000, 1473, 46, 1, 27, "Input"],
Cell[50049, 1476, 40, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[50126, 1482, 128, 4, 27, "Input"],
Cell[50257, 1488, 38, 1, 22, "Print"],
Cell[50298, 1491, 483, 11, 22, "Print"],
Cell[50784, 1504, 487, 11, 22, "Print"],
Cell[51274, 1517, 498, 11, 22, "Print"],
Cell[51775, 1530, 37, 1, 22, "Print"],
Cell[51815, 1533, 483, 11, 22, "Print"],
Cell[52301, 1546, 487, 11, 22, "Print"],
Cell[52791, 1559, 498, 11, 22, "Print"],
Cell[53292, 1572, 37, 1, 22, "Print"],
Cell[53332, 1575, 523, 12, 22, "Print"],
Cell[53858, 1589, 527, 12, 22, "Print"],
Cell[54388, 1603, 527, 12, 22, "Print"],
Cell[54918, 1617, 37, 1, 22, "Print"],
Cell[54958, 1620, 524, 12, 22, "Print"],
Cell[55485, 1634, 528, 12, 22, "Print"],
Cell[56016, 1648, 526, 12, 22, "Print"],
Cell[56545, 1662, 37, 1, 22, "Print"],
Cell[56585, 1665, 513, 11, 22, "Print"],
Cell[57101, 1678, 527, 12, 22, "Print"],
Cell[57631, 1692, 529, 12, 22, "Print"],
Cell[58163, 1706, 37, 1, 22, "Print"],
Cell[58203, 1709, 553, 13, 22, "Print"],
Cell[58759, 1724, 528, 12, 22, "Print"],
Cell[59290, 1738, 560, 13, 22, "Print"],
Cell[59853, 1753, 37, 1, 22, "Print"],
Cell[59893, 1756, 525, 12, 24, "Print"],
Cell[60421, 1770, 528, 12, 22, "Print"],
Cell[60952, 1784, 559, 13, 22, "Print"],
Cell[61514, 1799, 37, 1, 22, "Print"],
Cell[61554, 1802, 556, 13, 24, "Print"],
Cell[62113, 1817, 528, 12, 22, "Print"],
Cell[62644, 1831, 560, 13, 22, "Print"],
Cell[63207, 1846, 37, 1, 22, "Print"],
Cell[63247, 1849, 525, 12, 24, "Print"],
Cell[63775, 1863, 528, 12, 22, "Print"],
Cell[64306, 1877, 560, 13, 22, "Print"],
Cell[64869, 1892, 37, 1, 22, "Print"],
Cell[64909, 1895, 38, 1, 22, "Print"],
Cell[64950, 1898, 483, 11, 22, "Print"],
Cell[65436, 1911, 310, 6, 22, "Print"],
Cell[65749, 1919, 482, 11, 22, "Print"],
Cell[66234, 1932, 37, 1, 22, "Print"],
Cell[66274, 1935, 483, 11, 22, "Print"],
Cell[66760, 1948, 310, 6, 22, "Print"],
Cell[67073, 1956, 482, 11, 22, "Print"],
Cell[67558, 1969, 37, 1, 22, "Print"],
Cell[67598, 1972, 483, 11, 22, "Print"],
Cell[68084, 1985, 310, 6, 22, "Print"],
Cell[68397, 1993, 482, 11, 22, "Print"],
Cell[68882, 2006, 37, 1, 22, "Print"],
Cell[68922, 2009, 483, 11, 22, "Print"],
Cell[69408, 2022, 310, 6, 22, "Print"],
Cell[69721, 2030, 482, 11, 22, "Print"],
Cell[70206, 2043, 37, 1, 22, "Print"],
Cell[70246, 2046, 528, 12, 22, "Print"],
Cell[70777, 2060, 310, 6, 22, "Print"],
Cell[71090, 2068, 527, 12, 22, "Print"],
Cell[71620, 2082, 37, 1, 22, "Print"],
Cell[71660, 2085, 553, 13, 22, "Print"],
Cell[72216, 2100, 310, 6, 22, "Print"],
Cell[72529, 2108, 521, 12, 22, "Print"],
Cell[73053, 2122, 37, 1, 22, "Print"],
Cell[73093, 2125, 522, 12, 22, "Print"],
Cell[73618, 2139, 310, 6, 22, "Print"],
Cell[73931, 2147, 521, 12, 24, "Print"],
Cell[74455, 2161, 37, 1, 22, "Print"],
Cell[74495, 2164, 556, 13, 24, "Print"],
Cell[75054, 2179, 310, 6, 22, "Print"],
Cell[75367, 2187, 524, 12, 24, "Print"],
Cell[75894, 2201, 37, 1, 22, "Print"],
Cell[75934, 2204, 522, 12, 22, "Print"],
Cell[76459, 2218, 310, 6, 22, "Print"],
Cell[76772, 2226, 521, 12, 22, "Print"],
Cell[77296, 2240, 37, 1, 22, "Print"],
Cell[77336, 2243, 555, 13, 22, "Print"],
Cell[77894, 2258, 312, 6, 22, "Print"],
Cell[78209, 2266, 523, 12, 22, "Print"],
Cell[78735, 2280, 37, 1, 22, "Print"],
Cell[78775, 2283, 70, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[78882, 2289, 46, 1, 27, "Input"],
Cell[78931, 2292, 41, 1, 26, "Output"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{
Cell[79021, 2299, 62, 0, 28, "Subsection"],
Cell[79086, 2301, 142, 2, 43, "Input"],

Cell[CellGroupData[{
Cell[79253, 2307, 46, 1, 27, "Input"],
Cell[79302, 2310, 41, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[79380, 2316, 127, 4, 27, "Input"],
Cell[79510, 2322, 408, 10, 22, "Print"],
Cell[79921, 2334, 253, 5, 22, "Print"],
Cell[80177, 2341, 409, 10, 22, "Print"],
Cell[80589, 2353, 37, 1, 22, "Print"],
Cell[80629, 2356, 408, 10, 22, "Print"],
Cell[81040, 2368, 253, 5, 22, "Print"],
Cell[81296, 2375, 409, 10, 22, "Print"],
Cell[81708, 2387, 37, 1, 22, "Print"],
Cell[81748, 2390, 408, 10, 22, "Print"],
Cell[82159, 2402, 253, 5, 22, "Print"],
Cell[82415, 2409, 409, 10, 22, "Print"],
Cell[82827, 2421, 37, 1, 22, "Print"],
Cell[82867, 2424, 408, 10, 22, "Print"],
Cell[83278, 2436, 253, 5, 22, "Print"],
Cell[83534, 2443, 409, 10, 22, "Print"],
Cell[83946, 2455, 37, 1, 22, "Print"],
Cell[83986, 2458, 449, 10, 24, "Print"],
Cell[84438, 2470, 253, 5, 22, "Print"],
Cell[84694, 2477, 450, 10, 24, "Print"],
Cell[85147, 2489, 37, 1, 22, "Print"],
Cell[85187, 2492, 475, 11, 22, "Print"],
Cell[85665, 2505, 253, 5, 22, "Print"],
Cell[85921, 2512, 445, 10, 22, "Print"],
Cell[86369, 2524, 37, 1, 22, "Print"],
Cell[86409, 2527, 438, 10, 22, "Print"],
Cell[86850, 2539, 253, 5, 22, "Print"],
Cell[87106, 2546, 439, 10, 22, "Print"],
Cell[87548, 2558, 37, 1, 22, "Print"],
Cell[87588, 2561, 471, 11, 22, "Print"],
Cell[88062, 2574, 253, 5, 22, "Print"],
Cell[88318, 2581, 441, 10, 22, "Print"],
Cell[88762, 2593, 37, 1, 22, "Print"],
Cell[88802, 2596, 440, 10, 22, "Print"],
Cell[89245, 2608, 253, 5, 22, "Print"],
Cell[89501, 2615, 441, 10, 22, "Print"],
Cell[89945, 2627, 37, 1, 22, "Print"],
Cell[89985, 2630, 440, 10, 22, "Print"],
Cell[90428, 2642, 253, 5, 22, "Print"],
Cell[90684, 2649, 441, 10, 22, "Print"],
Cell[91128, 2661, 37, 1, 22, "Print"],
Cell[91168, 2664, 70, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[91275, 2670, 46, 1, 27, "Input"],
Cell[91324, 2673, 41, 1, 26, "Output"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{
Cell[91414, 2680, 101, 3, 28, "Subsection"],
Cell[91518, 2685, 138, 2, 43, "Input"],

Cell[CellGroupData[{
Cell[91681, 2691, 46, 1, 27, "Input"],
Cell[91730, 2694, 41, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[91808, 2700, 96, 1, 27, "Input"],
Cell[91907, 2703, 491, 11, 22, "Print"],
Cell[92401, 2716, 323, 7, 22, "Print"],
Cell[92727, 2725, 631, 16, 24, "Print"],
Cell[93361, 2743, 968, 26, 24, "Print"],
Cell[94332, 2771, 1058, 29, 24, "Print"],
Cell[95393, 2802, 1336, 34, 39, "Print"],
Cell[96732, 2838, 1784, 44, 41, "Print"],
Cell[98519, 2884, 1977, 50, 41, "Print"],
Cell[100499, 2936, 2214, 56, 56, "Print"],
Cell[102716, 2994, 2456, 62, 73, "Print"],
Cell[105175, 3058, 2668, 67, 75, "Print"],
Cell[107846, 3127, 70, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[107953, 3133, 46, 1, 27, "Input"],
Cell[108002, 3136, 41, 1, 26, "Output"]
}, Open  ]]
}, Closed]]
}, Closed]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

