(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 3.0,
MathReader 3.0, or any compatible application. The data for the notebook 
starts with the line of stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[    373665,      10603]*)
(*NotebookOutlinePosition[    374505,      10630]*)
(*  CellTagsIndexPosition[    374461,      10626]*)
(*WindowFrame->Normal*)



Notebook[{
Cell[TextData[{
  " :Author:  Z\[EAcute]lia da ROCHA \n\n:Address: \n            Departamento \
de Matem\[AAcute]tica Aplicada da\n            Faculdade de Ci\[EHat]ncias do \
Porto\n            Rua das Taipas, 135\n            4050 Porto\n            \
Portugal\n  \n            Tel: ++351 02 2080313\n            Fax: ++351 02 \
2004109\n            Email: mrdioh@fc.up.pt\n\n :Summary:\n    The ",
  StyleBox["testchv6",
    FontSize->18],
  " notebook contains the results produced by the package\n    chv.m \
corresponding to the ",
  StyleBox["example 6",
    FontSize->18],
  " of the first paper cited bellow.    \n\n :Date: July 1999. \n\n:Available \
at http://netlib.bell-labs.com/ in the numeralgo library in netlib:     \n\n \
:Notebook Version: 1.0 \n\n :Mathematica Version: 3.0   \n \n :Keywords: \
chebyshev's method, recurrence relations,  orthogonal polynomials of \
dimension d, d-dimensional forms.\n\n :Sources:\n \n - Z\[EAcute]lia da \
Rocha, Shohat-Favard and Chebyshev's methods in d-orthogonality, \n Numerical \
Algorithms, 20 (1999) 139-164.\n   \n - About the example treated here see \
pp. 286, 293,294 of:\n   K. Douak, The relation of the d-orthogonal \
polynomials to the Appell polynomials, J. Comput. Appl. Math.,  70 (1996) \
279-295.\n"
}], "Subsection"],

Cell[CellGroupData[{

Cell["\<\
Computing the recurrence coefficients and the orthogonal \
polynomials performing formal computations\
\>", "Section",
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell["\<\
Loading the package chv.m, the package datachv6.m is automatically \
loaded\
\>", "Subsection"],

Cell[BoxData[
    \(\(<< chebyshev`chv`; \)\)], "Input"]
}, Closed]],

Cell[CellGroupData[{

Cell["\<\
 The moments of the d-dimensional form are given in the package \
datachv6.m\
\>", "Subsection",
  AspectRatioFixed->True],

Cell[BoxData[
    \( (*\ showing\ the\ moments\ given\ *) \)], "Input"],

Cell[BoxData[
    \(\( (*\ set\ the\ values\ of\ d\ and\ imax\ *) \nd = 5; imax = \ 10; 
    \ \ \ \ \ \  (*\ for\ example\ *) \)\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Do[Do[
        Print["\<form[\>", d, "\<,\>", \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ r, 
          "\<,\>", i, "\<]=\>", form[d, r, i]], {i, 0, imax}]; \n
      \t\ \ \ \ \ \ \ Print["\<____________________\>"], {r, 1, d}]\)], 
  "Input"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]0
        \[InvisibleSpace]"]="\[InvisibleSpace]1\),
      SequenceForm[ "form[", 5, ",", 1, ",", 0, "]=", 1],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 1, ",", 1, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 1, ",", 2, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 1, ",", 3, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 1, ",", 4, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 1, ",", 5, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]6
        \[InvisibleSpace]"]="\[InvisibleSpace]1\/6\),
      SequenceForm[ "form[", 5, ",", 1, ",", 6, "]=", 
        Rational[ 1, 6]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]7
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 1, ",", 7, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]8
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 1, ",", 8, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]9
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 1, ",", 9, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]10
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 1, ",", 10, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("____________________"\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]0
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 2, ",", 0, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]"]="\[InvisibleSpace]1\),
      SequenceForm[ "form[", 5, ",", 2, ",", 1, "]=", 1],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 2, ",", 2, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 2, ",", 3, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 2, ",", 4, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 2, ",", 5, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]6
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 2, ",", 6, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]7
        \[InvisibleSpace]"]="\[InvisibleSpace]7\/6\),
      SequenceForm[ "form[", 5, ",", 2, ",", 7, "]=", 
        Rational[ 7, 6]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]8
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 2, ",", 8, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]9
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 2, ",", 9, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]10
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 2, ",", 10, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("____________________"\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]0
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 3, ",", 0, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 3, ",", 1, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]"]="\[InvisibleSpace]1\),
      SequenceForm[ "form[", 5, ",", 3, ",", 2, "]=", 1],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 3, ",", 3, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 3, ",", 4, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 3, ",", 5, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]6
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 3, ",", 6, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]7
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 3, ",", 7, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]8
        \[InvisibleSpace]"]="\[InvisibleSpace]14\/3\),
      SequenceForm[ "form[", 5, ",", 3, ",", 8, "]=", 
        Rational[ 14, 3]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]9
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 3, ",", 9, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]10
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 3, ",", 10, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("____________________"\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]0
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 4, ",", 0, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 4, ",", 1, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 4, ",", 2, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]"]="\[InvisibleSpace]1\),
      SequenceForm[ "form[", 5, ",", 4, ",", 3, "]=", 1],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 4, ",", 4, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 4, ",", 5, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]6
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 4, ",", 6, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]7
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 4, ",", 7, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]8
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 4, ",", 8, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]9
        \[InvisibleSpace]"]="\[InvisibleSpace]14\),
      SequenceForm[ "form[", 5, ",", 4, ",", 9, "]=", 14],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]10
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 4, ",", 10, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("____________________"\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]0
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 5, ",", 0, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 5, ",", 1, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 5, ",", 2, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 5, ",", 3, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]"]="\[InvisibleSpace]1\),
      SequenceForm[ "form[", 5, ",", 5, ",", 4, "]=", 1],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 5, ",", 5, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]6
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 5, ",", 6, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]7
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 5, ",", 7, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]8
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 5, ",", 8, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]9
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 5, ",", 9, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]10
        \[InvisibleSpace]"]="\[InvisibleSpace]35\),
      SequenceForm[ "form[", 5, ",", 5, ",", 10, "]=", 35],
      Editable->False]], "Print"],

Cell[BoxData[
    \("____________________"\)], "Print"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Computing the gamma coefficients", "Subsection"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\( (*\ set\ the\ values\ of\ d\ and\ nmax\ *) \nd = 5; \ nmax = \ 10\ ; 
    \ \ \ \  (*\ for\ example\ *) \)\)], "Input"],

Cell[BoxData[
    \(General::"spell1" \( : \ \) 
      "Possible spelling error: new symbol name \"\!\(nmax\)\" is similar to \
existing symbol \"\!\(imax\)\"."\)], "Message"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(MemoryInUse[]\)], "Input"],

Cell[BoxData[
    \(943760\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Timing[printgamma[d,nmax,Infinity,$MachinePrecision,True,False]]\
\>\
", "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    \("   "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]0
        \[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]"]="\[InvisibleSpace]1\/6\),
      SequenceForm[ "gamma[", 5, ",", 0, ",", 1, "]=", 
        Rational[ 1, 6]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]0
        \[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]"]="\[InvisibleSpace]1\/6\),
      SequenceForm[ "gammaexact[", 5, ",", 0, ",", 1, "]=", 
        Rational[ 1, 6]],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]0
        \[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]"]="\[InvisibleSpace]1\),
      SequenceForm[ "gamma[", 5, ",", 0, ",", 2, "]=", 1],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]0
        \[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]"]="\[InvisibleSpace]1\),
      SequenceForm[ "gammaexact[", 5, ",", 0, ",", 2, "]=", 1],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]0
        \[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]"]="\[InvisibleSpace]7\/2\),
      SequenceForm[ "gamma[", 5, ",", 0, ",", 3, "]=", 
        Rational[ 7, 2]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]0
        \[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]"]="\[InvisibleSpace]7\/2\),
      SequenceForm[ "gammaexact[", 5, ",", 0, ",", 3, "]=", 
        Rational[ 7, 2]],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]0
        \[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]"]="\[InvisibleSpace]28\/3\),
      SequenceForm[ "gamma[", 5, ",", 0, ",", 4, "]=", 
        Rational[ 28, 3]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]0
        \[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]"]="\[InvisibleSpace]28\/3\),
      SequenceForm[ "gammaexact[", 5, ",", 0, ",", 4, "]=", 
        Rational[ 28, 3]],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]0
        \[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]"]="\[InvisibleSpace]21\),
      SequenceForm[ "gamma[", 5, ",", 0, ",", 5, "]=", 21],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]0
        \[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]"]="\[InvisibleSpace]21\),
      SequenceForm[ "gammaexact[", 5, ",", 0, ",", 5, "]=", 21],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]0
        \[InvisibleSpace]","\[InvisibleSpace]6
        \[InvisibleSpace]"]="\[InvisibleSpace]42\),
      SequenceForm[ "gamma[", 5, ",", 0, ",", 6, "]=", 42],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]0
        \[InvisibleSpace]","\[InvisibleSpace]6
        \[InvisibleSpace]"]="\[InvisibleSpace]42\),
      SequenceForm[ "gammaexact[", 5, ",", 0, ",", 6, "]=", 42],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    \("   "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gamma[", 5, ",", 1, ",", 1, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 5, ",", 1, ",", 1, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gamma[", 5, ",", 1, ",", 2, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 5, ",", 1, ",", 2, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gamma[", 5, ",", 1, ",", 3, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 5, ",", 1, ",", 3, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gamma[", 5, ",", 1, ",", 4, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 5, ",", 1, ",", 4, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gamma[", 5, ",", 1, ",", 5, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 5, ",", 1, ",", 5, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]6
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gamma[", 5, ",", 1, ",", 6, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]6
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 5, ",", 1, ",", 6, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]7
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gamma[", 5, ",", 1, ",", 7, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]7
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 5, ",", 1, ",", 7, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    \("   "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gamma[", 5, ",", 2, ",", 1, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 5, ",", 2, ",", 1, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gamma[", 5, ",", 2, ",", 2, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 5, ",", 2, ",", 2, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gamma[", 5, ",", 2, ",", 3, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 5, ",", 2, ",", 3, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gamma[", 5, ",", 2, ",", 4, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 5, ",", 2, ",", 4, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gamma[", 5, ",", 2, ",", 5, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 5, ",", 2, ",", 5, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]6
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gamma[", 5, ",", 2, ",", 6, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]6
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 5, ",", 2, ",", 6, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]7
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gamma[", 5, ",", 2, ",", 7, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]7
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 5, ",", 2, ",", 7, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]8
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gamma[", 5, ",", 2, ",", 8, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]8
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 5, ",", 2, ",", 8, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    \("   "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gamma[", 5, ",", 3, ",", 1, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 5, ",", 3, ",", 1, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gamma[", 5, ",", 3, ",", 2, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 5, ",", 3, ",", 2, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gamma[", 5, ",", 3, ",", 3, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 5, ",", 3, ",", 3, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gamma[", 5, ",", 3, ",", 4, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 5, ",", 3, ",", 4, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gamma[", 5, ",", 3, ",", 5, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 5, ",", 3, ",", 5, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]6
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gamma[", 5, ",", 3, ",", 6, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]6
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 5, ",", 3, ",", 6, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]7
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gamma[", 5, ",", 3, ",", 7, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]7
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 5, ",", 3, ",", 7, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]8
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gamma[", 5, ",", 3, ",", 8, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]8
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 5, ",", 3, ",", 8, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]9
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gamma[", 5, ",", 3, ",", 9, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]9
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 5, ",", 3, ",", 9, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    \("   "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gamma[", 5, ",", 4, ",", 1, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 5, ",", 4, ",", 1, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gamma[", 5, ",", 4, ",", 2, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 5, ",", 4, ",", 2, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gamma[", 5, ",", 4, ",", 3, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 5, ",", 4, ",", 3, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gamma[", 5, ",", 4, ",", 4, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 5, ",", 4, ",", 4, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gamma[", 5, ",", 4, ",", 5, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 5, ",", 4, ",", 5, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]6
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gamma[", 5, ",", 4, ",", 6, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]6
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 5, ",", 4, ",", 6, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]7
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gamma[", 5, ",", 4, ",", 7, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]7
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 5, ",", 4, ",", 7, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]8
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gamma[", 5, ",", 4, ",", 8, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]8
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 5, ",", 4, ",", 8, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]9
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gamma[", 5, ",", 4, ",", 9, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]9
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 5, ",", 4, ",", 9, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]10
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gamma[", 5, ",", 4, ",", 10, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]10
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 5, ",", 4, ",", 10, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    \({18.0666666666666628`\ Second, Null}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(MemoryInUse[]\)], "Input"],

Cell[BoxData[
    \(1055432\)], "Output"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Computing the beta coefficients", "Subsection"],

Cell[BoxData[
    \(\( (*\ set\ the\ values\ of\ d\ and\ nmax\ *) \nd = 5; \ nmax = \ 10; 
    \ \ \ \ \  (*\ for\ example\ *) \)\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(MemoryInUse[]\)], "Input"],

Cell[BoxData[
    \(1057216\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Timing[printbeta[d,nmax,Infinity,$MachinePrecision,True,False]]\
\>\
", "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    InterpretationBox[
      \("beta["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]0
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "beta[", 5, ",", 0, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("betaexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]0
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "betaexact[", 5, ",", 0, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("beta["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "beta[", 5, ",", 1, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("betaexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "betaexact[", 5, ",", 1, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("beta["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "beta[", 5, ",", 2, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("betaexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "betaexact[", 5, ",", 2, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("beta["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "beta[", 5, ",", 3, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("betaexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "betaexact[", 5, ",", 3, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("beta["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "beta[", 5, ",", 4, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("betaexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "betaexact[", 5, ",", 4, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("beta["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "beta[", 5, ",", 5, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("betaexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "betaexact[", 5, ",", 5, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("beta["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]6
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "beta[", 5, ",", 6, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("betaexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]6
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "betaexact[", 5, ",", 6, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("beta["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]7
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "beta[", 5, ",", 7, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("betaexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]7
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "betaexact[", 5, ",", 7, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("beta["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]8
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "beta[", 5, ",", 8, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("betaexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]8
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "betaexact[", 5, ",", 8, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("beta["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]9
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "beta[", 5, ",", 9, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("betaexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]9
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "betaexact[", 5, ",", 9, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    \({4.05000000000001136`\ Second, Null}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(MemoryInUse[]\)], "Input"],

Cell[BoxData[
    \(1059992\)], "Output"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Computing the d-orthogonal polynomials", "Subsection"],

Cell[BoxData[
    \(\( (*\ set\ the\ values\ of\ d\ and\ nmax\ *) \nd = 5; \ nmax = \ 10\ ; 
    \ \ \ \  (*\ for\ example\ *) \)\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(MemoryInUse[]\)], "Input"],

Cell[BoxData[
    \(1061808\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Timing[printdorthpoly[d,nmax,x,Infinity]]", "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    InterpretationBox[
      \("dorthpoly["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]0
        \[InvisibleSpace]","\[InvisibleSpace]x
        \[InvisibleSpace]"]="\[InvisibleSpace]1\),
      SequenceForm[ "dorthpoly[", 5, ",", 0, ",", x, "]=", 1],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("dorthpoly["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]x
        \[InvisibleSpace]"]="\[InvisibleSpace]x\),
      SequenceForm[ "dorthpoly[", 5, ",", 1, ",", x, "]=", x],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("dorthpoly["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]x
        \[InvisibleSpace]"]="\[InvisibleSpace]x\^2\),
      SequenceForm[ "dorthpoly[", 5, ",", 2, ",", x, "]=", 
        Power[ x, 2]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("dorthpoly["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]x
        \[InvisibleSpace]"]="\[InvisibleSpace]x\^3\),
      SequenceForm[ "dorthpoly[", 5, ",", 3, ",", x, "]=", 
        Power[ x, 3]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("dorthpoly["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]x
        \[InvisibleSpace]"]="\[InvisibleSpace]x\^4\),
      SequenceForm[ "dorthpoly[", 5, ",", 4, ",", x, "]=", 
        Power[ x, 4]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("dorthpoly["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]x
        \[InvisibleSpace]"]="\[InvisibleSpace]x\^5\),
      SequenceForm[ "dorthpoly[", 5, ",", 5, ",", x, "]=", 
        Power[ x, 5]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("dorthpoly["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]6
        \[InvisibleSpace]","\[InvisibleSpace]x
        \[InvisibleSpace]"]="\[InvisibleSpace]\(\( - 1\/6\) + x\^6\)\),
      SequenceForm[ "dorthpoly[", 5, ",", 6, ",", x, "]=", 
        Plus[ 
          Rational[ -1, 6], 
          Power[ x, 6]]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("dorthpoly["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]7
        \[InvisibleSpace]","\[InvisibleSpace]x
        \[InvisibleSpace]"]="\[InvisibleSpace]\(\( - \(7\ x\)\/6\) + x\^7\)\),
      
      SequenceForm[ "dorthpoly[", 5, ",", 7, ",", x, "]=", 
        Plus[ 
          Times[ 
            Rational[ -7, 6], x], 
          Power[ x, 7]]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("dorthpoly["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]8
        \[InvisibleSpace]","\[InvisibleSpace]x
        \[InvisibleSpace]"]="\[InvisibleSpace]\(\( - \(14\ x\^2\)\/3\) + 
          x\^8\)\),
      SequenceForm[ "dorthpoly[", 5, ",", 8, ",", x, "]=", 
        Plus[ 
          Times[ 
            Rational[ -14, 3], 
            Power[ x, 2]], 
          Power[ x, 8]]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("dorthpoly["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]9
        \[InvisibleSpace]","\[InvisibleSpace]x
        \[InvisibleSpace]"]="\[InvisibleSpace]\(\( - 14\)\ x\^3 + x\^9\)\),
      SequenceForm[ "dorthpoly[", 5, ",", 9, ",", x, "]=", 
        Plus[ 
          Times[ -14, 
            Power[ x, 3]], 
          Power[ x, 9]]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("dorthpoly["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]10
        \[InvisibleSpace]","\[InvisibleSpace]x
        \[InvisibleSpace]"]="\[InvisibleSpace]\(\( - 35\)\ x\^4 + x\^10\)\),
      SequenceForm[ "dorthpoly[", 5, ",", 10, ",", x, "]=", 
        Plus[ 
          Times[ -35, 
            Power[ x, 4]], 
          Power[ x, 10]]],
      Editable->False]], "Print"],

Cell[BoxData[
    \({1.88333333333332575`\ Second, Null}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(MemoryInUse[]\)], "Input"],

Cell[BoxData[
    \(1066240\)], "Output"]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["\<\
Computing the recurrence coefficients and the orthogonal \
polynomials performing numerical computations with the machine precision\
\>",
   "Section",
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell["\<\
Loading the package chv.m, the package datachv6.m is automatically \
loaded\
\>", "Subsection"],

Cell[BoxData[
    \(\(<< chebyshev`chv`; \)\)], "Input"]
}, Closed]],

Cell[CellGroupData[{

Cell["Computing the gamma coefficients", "Subsection"],

Cell[BoxData[
    \(\( (*\ set\ the\ values\ of\ d\ and\ nmax\ *) \nd = 5; \ nmax = \ 50\ ; 
    \ \ \ \  (*\ for\ example\ *) \)\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(MemoryInUse[]\)], "Input"],

Cell[BoxData[
    \(965048\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Timing[printgamma[d,nmax,$MachinePrecision,$MachinePrecision,True,\
True]]\
\>", "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    \("   "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gamma["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["0.166666666666666651`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gamma[", 5, ",", 0, ",", 1, "]=", 0.16666666666666666],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["0.166666666666666651`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "gammaexact[", 5, ",", 0, ",", 1, "]=", 0.16666666666666666],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        InterpretationBox["\[Infinity]",
          DirectedInfinity[ 1]]}],
      SequenceForm[ "exactdigits[", 5, ",", 0, ",", 1, "]=", 
        DirectedInfinity[ 1]],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gamma["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["1.`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gamma[", 5, ",", 0, ",", 2, "]=", 1.0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["1.`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gammaexact[", 5, ",", 0, ",", 2, "]=", 1.0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        InterpretationBox["\[Infinity]",
          DirectedInfinity[ 1]]}],
      SequenceForm[ "exactdigits[", 5, ",", 0, ",", 2, "]=", 
        DirectedInfinity[ 1]],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gamma["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["3.5`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gamma[", 5, ",", 0, ",", 3, "]=", 3.5],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["3.5`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gammaexact[", 5, ",", 0, ",", 3, "]=", 3.5],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        InterpretationBox["\[Infinity]",
          DirectedInfinity[ 1]]}],
      SequenceForm[ "exactdigits[", 5, ",", 0, ",", 3, "]=", 
        DirectedInfinity[ 1]],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gamma["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "4", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["9.33333333333333392`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gamma[", 5, ",", 0, ",", 4, "]=", 9.3333333333333339],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "4", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["9.33333333333333392`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "gammaexact[", 5, ",", 0, ",", 4, "]=", 9.3333333333333339],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "4", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        InterpretationBox["\[Infinity]",
          DirectedInfinity[ 1]]}],
      SequenceForm[ "exactdigits[", 5, ",", 0, ",", 4, "]=", 
        DirectedInfinity[ 1]],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gamma["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "5", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["21.0000000000000008`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gamma[", 5, ",", 0, ",", 5, "]=", 21.0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "5", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["21.0000000000000008`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gammaexact[", 5, ",", 0, ",", 5, "]=", 21.0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "5", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        InterpretationBox["\[Infinity]",
          DirectedInfinity[ 1]]}],
      SequenceForm[ "exactdigits[", 5, ",", 0, ",", 5, "]=", 
        DirectedInfinity[ 1]],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gamma["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "6", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["42.0000000000000017`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gamma[", 5, ",", 0, ",", 6, "]=", 42.0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "6", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["42.0000000000000017`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gammaexact[", 5, ",", 0, ",", 6, "]=", 42.0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "6", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        InterpretationBox["\[Infinity]",
          DirectedInfinity[ 1]]}],
      SequenceForm[ "exactdigits[", 5, ",", 0, ",", 6, "]=", 
        DirectedInfinity[ 1]],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gamma["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "7", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["77.0000000000000017`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gamma[", 5, ",", 0, ",", 7, "]=", 77.0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "7", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["77.0000000000000017`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gammaexact[", 5, ",", 0, ",", 7, "]=", 77.0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "7", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        InterpretationBox["\[Infinity]",
          DirectedInfinity[ 1]]}],
      SequenceForm[ "exactdigits[", 5, ",", 0, ",", 7, "]=", 
        DirectedInfinity[ 1]],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gamma["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "8", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["131.999999999999917`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gamma[", 5, ",", 0, ",", 8, "]=", 131.99999999999991],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "8", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["131.999999999999984`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gammaexact[", 5, ",", 0, ",", 8, "]=", 132.0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "8", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["15.0692285501594902`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 5, ",", 0, ",", 8, "]=", 15.06922855015949],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gamma["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "9", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["214.50000000000009`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gamma[", 5, ",", 0, ",", 9, "]=", 214.50000000000009],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "9", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["214.500000000000001`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gammaexact[", 5, ",", 0, ",", 9, "]=", 214.5],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "9", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["15.0692285501594902`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 5, ",", 0, ",", 9, "]=", 15.06922855015949],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gamma["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "10", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["333.666666666666689`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gamma[", 5, ",", 0, ",", 10, "]=", 333.66666666666669],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "10", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["333.666666666666689`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "gammaexact[", 5, ",", 0, ",", 10, "]=", 333.66666666666669],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "10", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        InterpretationBox["\[Infinity]",
          DirectedInfinity[ 1]]}],
      SequenceForm[ "exactdigits[", 5, ",", 0, ",", 10, "]=", 
        DirectedInfinity[ 1]],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gamma["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "11", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["500.500000000000255`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gamma[", 5, ",", 0, ",", 11, "]=", 500.50000000000023],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "11", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["500.499999999999989`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gammaexact[", 5, ",", 0, ",", 11, "]=", 500.5],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "11", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["14.643259817887209`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 5, ",", 0, ",", 11, "]=", 14.643259817887209],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gamma["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "12", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["727.999999999999225`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gamma[", 5, ",", 0, ",", 12, "]=", 727.99999999999932],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "12", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["727.999999999999936`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gammaexact[", 5, ",", 0, ",", 12, "]=", 728.0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "12", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["14.1661385631675473`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 5, ",", 0, ",", 12, "]=", 14.166138563167546],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gamma["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "13", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["1031.3333333333341`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gamma[", 5, ",", 0, ",", 13, "]=", 1031.3333333333342],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "13", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["1031.33333333333321`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "gammaexact[", 5, ",", 0, ",", 13, "]=", 1031.3333333333333],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "13", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["15.0411998265592465`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 5, ",", 0, ",", 13, "]=", 15.041199826559247],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gamma["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "14", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["1427.99999999999949`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gamma[", 5, ",", 0, ",", 14, "]=", 1427.9999999999995],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "14", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["1428.00000000000011`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gammaexact[", 5, ",", 0, ",", 14, "]=", 1428.0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "14", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["15.3422298222232278`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 5, ",", 0, ",", 14, "]=", 15.342229822223228],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gamma["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "15", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["1937.9999999999967`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gamma[", 5, ",", 0, ",", 15, "]=", 1937.9999999999968],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "15", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["1938.00000000000025`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gammaexact[", 5, ",", 0, ",", 15, "]=", 1938.0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "15", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["14.4971317822089718`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 5, ",", 0, ",", 15, "]=", 14.497131782208971],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gamma["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "16", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["2583.99999999999963`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gamma[", 5, ",", 0, ",", 16, "]=", 2583.9999999999995],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "16", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["2583.99999999999963`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gammaexact[", 5, ",", 0, ",", 16, "]=", 2584.0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "16", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["15.3422298222232278`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 5, ",", 0, ",", 16, "]=", 15.342229822223228],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gamma["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "17", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["3391.50000000001483`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gamma[", 5, ",", 0, ",", 17, "]=", 3391.5000000000146],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "17", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["3391.49999999999973`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gammaexact[", 5, ",", 0, ",", 17, "]=", 3391.5],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "17", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["13.8370798439033215`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 5, ",", 0, ",", 17, "]=", 13.837079843903322],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gamma["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "18", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["4388.99999999998868`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gamma[", 5, ",", 0, ",", 18, "]=", 4388.9999999999891],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "18", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["4389.00000000000023`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gammaexact[", 5, ",", 0, ",", 18, "]=", 4389.0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "18", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["13.9620185805116214`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 5, ",", 0, ",", 18, "]=", 13.962018580511621],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gamma["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "19", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["5608.16666666665497`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gamma[", 5, ",", 0, ",", 19, "]=", 5608.1666666666542],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "19", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["5608.16666666666741`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "gammaexact[", 5, ",", 0, ",", 19, "]=", 5608.166666666667],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "19", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["13.8950717908810084`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 5, ",", 0, ",", 19, "]=", 13.895071790881008],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gamma["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "20", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["7084.00000000002183`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gamma[", 5, ",", 0, ",", 20, "]=", 7084.0000000000209],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "20", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["7084.00000000000051`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gammaexact[", 5, ",", 0, ",", 20, "]=", 7084.0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "20", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["13.6794719905416539`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 5, ",", 0, ",", 20, "]=", 13.679471990541654],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gamma["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "21", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["8855.00000000000753`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gamma[", 5, ",", 0, ",", 21, "]=", 8855.0000000000073],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "21", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["8855.00000000000042`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gammaexact[", 5, ",", 0, ",", 21, "]=", 8855.0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "21", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["14.1381098395673054`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 5, ",", 0, ",", 21, "]=", 14.138109839567305],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gamma["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "22", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["10963.3333333332849`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gamma[", 5, ",", 0, ",", 22, "]=", 10963.333333333285],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "22", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["10963.3333333333338`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "gammaexact[", 5, ",", 0, ",", 22, "]=", 10963.333333333334],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "22", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["14.3088060667362793`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 5, ",", 0, ",", 22, "]=", 14.308806066736279],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gamma["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "23", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["13454.9999999999214`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gamma[", 5, ",", 0, ",", 23, "]=", 13454.999999999924],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "23", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["13455.0000000000014`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gammaexact[", 5, ",", 0, ",", 23, "]=", 13455.0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "23", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["14.1169205404973645`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 5, ",", 0, ",", 23, "]=", 14.116920540497365],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gamma["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "24", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["16380.0000000003649`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gamma[", 5, ",", 0, ",", 24, "]=", 16380.000000000364],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "24", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["16380.0000000000034`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gammaexact[", 5, ",", 0, ",", 24, "]=", 16380.0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "24", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["13.4391398352312863`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 5, ",", 0, ",", 24, "]=", 13.439139835231286],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gamma["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "25", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["19792.4999999998405`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gamma[", 5, ",", 0, ",", 25, "]=", 19792.499999999844],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "25", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["19792.5000000000004`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gammaexact[", 5, ",", 0, ",", 25, "]=", 19792.5],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "25", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["13.8056713796516984`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 5, ",", 0, ",", 25, "]=", 13.805671379651699],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gamma["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "26", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["23750.9999999992338`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gamma[", 5, ",", 0, ",", 26, "]=", 23750.999999999236],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "26", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["23750.9999999999976`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gammaexact[", 5, ",", 0, ",", 26, "]=", 23751.0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "26", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["13.1169205404973654`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 5, ",", 0, ",", 26, "]=", 13.116920540497365],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gamma["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "27", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["28318.5000000006645`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gamma[", 5, ",", 0, ",", 27, "]=", 28318.500000000666],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "27", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["28318.500000000002`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gammaexact[", 5, ",", 0, ",", 27, "]=", 28318.5],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "27", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["13.1766887455008552`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 5, ",", 0, ",", 27, "]=", 13.176688745500854],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gamma["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "28", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["33562.6666666693207`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gamma[", 5, ",", 0, ",", 28, "]=", 33562.66666666932],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "28", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["33562.666666666665`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "gammaexact[", 5, ",", 0, ",", 28, "]=", 33562.666666666664],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "28", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["12.5758169751108295`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 5, ",", 0, ",", 28, "]=", 12.575816975110829],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gamma["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "29", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["39555.9999999924638`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gamma[", 5, ",", 0, ",", 29, "]=", 39555.999999992469],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "29", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["39555.9999999999956`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gammaexact[", 5, ",", 0, ",", 29, "]=", 39556.0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "29", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["12.123169489774368`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 5, ",", 0, ",", 29, "]=", 12.123169489774368],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gamma["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "30", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["46376.0000000064653`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gamma[", 5, ",", 0, ",", 30, "]=", 46376.000000006461],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "30", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["46376.0000000000083`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gammaexact[", 5, ",", 0, ",", 30, "]=", 46376.0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "30", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["12.1896968737887023`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 5, ",", 0, ",", 30, "]=", 12.189696873788703],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gamma["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "31", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["54105.3333333414343`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gamma[", 5, ",", 0, ",", 31, "]=", 54105.333333341434],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "31", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["54105.333333333343`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "gammaexact[", 5, ",", 0, ",", 31, "]=", 54105.333333333336],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "31", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["12.0916146752325959`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 5, ",", 0, ",", 31, "]=", 12.091614675232595],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gamma["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "32", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["62831.9999999764444`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gamma[", 5, ",", 0, ",", 32, "]=", 62831.999999976455],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "32", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["62831.99999999999`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gammaexact[", 5, ",", 0, ",", 32, "]=", 62832.0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "32", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["11.6281013266270671`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 5, ",", 0, ",", 32, "]=", 11.628101326627068],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gamma["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "33", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["72649.5000000031154`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gamma[", 5, ",", 0, ",", 33, "]=", 72649.500000003114],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "33", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["72649.5000000000068`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gammaexact[", 5, ",", 0, ",", 33, "]=", 72649.5],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "33", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["12.5066660705541332`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 5, ",", 0, ",", 33, "]=", 12.506666070554132],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gamma["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "34", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["83657.0000000563318`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gamma[", 5, ",", 0, ",", 34, "]=", 83657.00000005633],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "34", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["83657.0000000000035`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gammaexact[", 5, ",", 0, ",", 34, "]=", 83657.0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "34", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["11.2492566725843667`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 5, ",", 0, ",", 34, "]=", 11.249256672584366],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gamma["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "35", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["95959.4999999178632`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gamma[", 5, ",", 0, ",", 35, "]=", 95959.499999917854],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "35", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["95959.500000000002`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gammaexact[", 5, ",", 0, ",", 35, "]=", 95959.5],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "35", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["11.0854158976423344`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 5, ",", 0, ",", 35, "]=", 11.085415897642335],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gamma["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "36", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["109667.999999960619`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gamma[", 5, ",", 0, ",", 36, "]=", 109667.99999996062],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "36", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["109668.000000000009`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gammaexact[", 5, ",", 0, ",", 36, "]=", 109668.0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "36", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["12.4047520516417186`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 5, ",", 0, ",", 36, "]=", 12.404752051641719],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gamma["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "37", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["124899.666666999742`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gamma[", 5, ",", 0, ",", 37, "]=", 124899.66666699975],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "37", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["124899.666666666675`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "gammaexact[", 5, ",", 0, ",", 37, "]=", 124899.66666666667],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "37", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["11.4774530247529726`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 5, ",", 0, ",", 37, "]=", 11.477453024752972],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gamma["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "38", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["141777.999999457975`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gamma[", 5, ",", 0, ",", 38, "]=", 141777.99999945797],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "38", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["141778.000000000004`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gammaexact[", 5, ",", 0, ",", 38, "]=", 141778.0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "38", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["11.2659768852695463`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 5, ",", 0, ",", 38, "]=", 11.265976885269547],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gamma["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "39", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["160433.000000359253`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gamma[", 5, ",", 0, ",", 39, "]=", 160433.00000035926],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "39", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["160433.000000000003`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gammaexact[", 5, ",", 0, ",", 39, "]=", 160433.0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "39", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["11.4445939351842485`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 5, ",", 0, ",", 39, "]=", 11.444593935184249],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gamma["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "40", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["181001.333333292873`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gamma[", 5, ",", 0, ",", 40, "]=", 181001.33333329286],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "40", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["181001.333333333356`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "gammaexact[", 5, ",", 0, ",", 40, "]=", 181001.33333333334],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "40", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["12.3927227182472954`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 5, ",", 0, ",", 40, "]=", 12.392722718247295],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gamma["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "41", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["203626.500000533194`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gamma[", 5, ",", 0, ",", 41, "]=", 203626.50000053318],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "41", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["203626.500000000021`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gammaexact[", 5, ",", 0, ",", 41, "]=", 203626.5],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "41", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["11.2731243789075108`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 5, ",", 0, ",", 41, "]=", 11.273124378907511],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gamma["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "42", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["228458.999997069955`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gamma[", 5, ",", 0, ",", 42, "]=", 228458.99999706997],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "42", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["228459.000000000012`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gammaexact[", 5, ",", 0, ",", 42, "]=", 228459.0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "42", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["10.5331282099598722`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 5, ",", 0, ",", 42, "]=", 10.533128209959873],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gamma["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "43", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["255656.500007069542`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gamma[", 5, ",", 0, ",", 43, "]=", 255656.50000706955],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "43", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["255656.499999999997`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gammaexact[", 5, ",", 0, ",", 43, "]=", 255656.5],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "43", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["10.1506080300227585`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 5, ",", 0, ",", 43, "]=", 10.150608030022758],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gamma["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "44", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["285383.999989391625`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gamma[", 5, ",", 0, ",", 44, "]=", 285383.99998939165],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "44", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["285383.999999999993`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gammaexact[", 5, ",", 0, ",", 44, "]=", 285384.0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "44", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["9.97435231558534773`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 5, ",", 0, ",", 44, "]=", 9.9743523155853477],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gamma["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "45", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["317814.000011787101`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gamma[", 5, ",", 0, ",", 45, "]=", 317814.00001178711],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "45", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["317813.999999999996`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gammaexact[", 5, ",", 0, ",", 45, "]=", 317814.0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "45", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["9.92859268036585973`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 5, ",", 0, ",", 45, "]=", 9.9285926803658597],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gamma["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "46", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["353126.666653077103`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gamma[", 5, ",", 0, ",", 46, "]=", 353126.66665307712],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "46", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["353126.666666666677`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "gammaexact[", 5, ",", 0, ",", 46, "]=", 353126.66666666669],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "46", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["9.86679434981769176`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 5, ",", 0, ",", 46, "]=", 9.8667943498176918],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    \("   "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gamma[", 5, ",", 1, ",", 1, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 5, ",", 1, ",", 1, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 1, ",", 1, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gamma[", 5, ",", 1, ",", 2, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 5, ",", 1, ",", 2, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 1, ",", 2, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gamma[", 5, ",", 1, ",", 3, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 5, ",", 1, ",", 3, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 1, ",", 3, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gamma[", 5, ",", 1, ",", 4, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 5, ",", 1, ",", 4, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 1, ",", 4, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gamma[", 5, ",", 1, ",", 5, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 5, ",", 1, ",", 5, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 1, ",", 5, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]6
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gamma[", 5, ",", 1, ",", 6, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]6
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 5, ",", 1, ",", 6, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]6
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 1, ",", 6, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]7
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gamma[", 5, ",", 1, ",", 7, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]7
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 5, ",", 1, ",", 7, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]7
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 1, ",", 7, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]8
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gamma[", 5, ",", 1, ",", 8, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]8
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 5, ",", 1, ",", 8, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]8
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 1, ",", 8, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]9
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gamma[", 5, ",", 1, ",", 9, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]9
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 5, ",", 1, ",", 9, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]9
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 1, ",", 9, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]10
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gamma[", 5, ",", 1, ",", 10, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]10
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 5, ",", 1, ",", 10, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]10
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 1, ",", 10, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]11
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gamma[", 5, ",", 1, ",", 11, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]11
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 5, ",", 1, ",", 11, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]11
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 1, ",", 11, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]12
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gamma[", 5, ",", 1, ",", 12, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]12
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 5, ",", 1, ",", 12, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]12
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 1, ",", 12, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]13
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gamma[", 5, ",", 1, ",", 13, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]13
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 5, ",", 1, ",", 13, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]13
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 1, ",", 13, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]14
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gamma[", 5, ",", 1, ",", 14, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]14
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 5, ",", 1, ",", 14, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]14
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 1, ",", 14, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]15
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gamma[", 5, ",", 1, ",", 15, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]15
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 5, ",", 1, ",", 15, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]15
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 1, ",", 15, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]16
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gamma[", 5, ",", 1, ",", 16, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]16
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 5, ",", 1, ",", 16, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]16
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 1, ",", 16, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]17
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gamma[", 5, ",", 1, ",", 17, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]17
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 5, ",", 1, ",", 17, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]17
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 1, ",", 17, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]18
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gamma[", 5, ",", 1, ",", 18, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]18
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 5, ",", 1, ",", 18, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]18
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 1, ",", 18, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]19
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gamma[", 5, ",", 1, ",", 19, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]19
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 5, ",", 1, ",", 19, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]19
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 1, ",", 19, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]20
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gamma[", 5, ",", 1, ",", 20, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]20
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 5, ",", 1, ",", 20, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]20
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 1, ",", 20, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]21
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gamma[", 5, ",", 1, ",", 21, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]21
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 5, ",", 1, ",", 21, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]21
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 1, ",", 21, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]22
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gamma[", 5, ",", 1, ",", 22, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]22
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 5, ",", 1, ",", 22, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]22
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 1, ",", 22, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]23
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gamma[", 5, ",", 1, ",", 23, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]23
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 5, ",", 1, ",", 23, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]23
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 1, ",", 23, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]24
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gamma[", 5, ",", 1, ",", 24, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]24
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 5, ",", 1, ",", 24, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]24
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 1, ",", 24, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]25
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gamma[", 5, ",", 1, ",", 25, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]25
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 5, ",", 1, ",", 25, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]25
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 1, ",", 25, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]26
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gamma[", 5, ",", 1, ",", 26, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]26
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 5, ",", 1, ",", 26, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]26
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 1, ",", 26, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]27
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gamma[", 5, ",", 1, ",", 27, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]27
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 5, ",", 1, ",", 27, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]27
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 1, ",", 27, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]28
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gamma[", 5, ",", 1, ",", 28, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]28
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 5, ",", 1, ",", 28, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]28
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 1, ",", 28, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]29
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gamma[", 5, ",", 1, ",", 29, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]29
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 5, ",", 1, ",", 29, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]29
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 1, ",", 29, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]30
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gamma[", 5, ",", 1, ",", 30, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]30
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 5, ",", 1, ",", 30, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]30
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 1, ",", 30, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]31
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gamma[", 5, ",", 1, ",", 31, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]31
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 5, ",", 1, ",", 31, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]31
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 1, ",", 31, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]32
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gamma[", 5, ",", 1, ",", 32, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]32
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 5, ",", 1, ",", 32, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]32
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 1, ",", 32, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]33
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gamma[", 5, ",", 1, ",", 33, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]33
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 5, ",", 1, ",", 33, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]33
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 1, ",", 33, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]34
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gamma[", 5, ",", 1, ",", 34, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]34
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 5, ",", 1, ",", 34, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]34
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 1, ",", 34, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]35
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gamma[", 5, ",", 1, ",", 35, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]35
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 5, ",", 1, ",", 35, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]35
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 1, ",", 35, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]36
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gamma[", 5, ",", 1, ",", 36, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]36
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 5, ",", 1, ",", 36, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]36
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 1, ",", 36, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]37
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gamma[", 5, ",", 1, ",", 37, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]37
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 5, ",", 1, ",", 37, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]37
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 1, ",", 37, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]38
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gamma[", 5, ",", 1, ",", 38, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]38
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 5, ",", 1, ",", 38, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]38
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 1, ",", 38, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]39
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gamma[", 5, ",", 1, ",", 39, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]39
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 5, ",", 1, ",", 39, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]39
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 1, ",", 39, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]40
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gamma[", 5, ",", 1, ",", 40, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]40
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 5, ",", 1, ",", 40, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]40
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 1, ",", 40, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]41
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gamma[", 5, ",", 1, ",", 41, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]41
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 5, ",", 1, ",", 41, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]41
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 1, ",", 41, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]42
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gamma[", 5, ",", 1, ",", 42, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]42
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 5, ",", 1, ",", 42, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]42
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 1, ",", 42, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]43
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gamma[", 5, ",", 1, ",", 43, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]43
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 5, ",", 1, ",", 43, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]43
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 1, ",", 43, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]44
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gamma[", 5, ",", 1, ",", 44, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]44
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 5, ",", 1, ",", 44, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]44
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 1, ",", 44, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]45
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gamma[", 5, ",", 1, ",", 45, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]45
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 5, ",", 1, ",", 45, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]45
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 1, ",", 45, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]46
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gamma[", 5, ",", 1, ",", 46, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]46
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 5, ",", 1, ",", 46, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]46
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 1, ",", 46, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]47
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gamma[", 5, ",", 1, ",", 47, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]47
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 5, ",", 1, ",", 47, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]47
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 1, ",", 47, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    \("   "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gamma[", 5, ",", 2, ",", 1, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 5, ",", 2, ",", 1, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 2, ",", 1, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gamma[", 5, ",", 2, ",", 2, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 5, ",", 2, ",", 2, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 2, ",", 2, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gamma[", 5, ",", 2, ",", 3, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 5, ",", 2, ",", 3, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 2, ",", 3, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gamma[", 5, ",", 2, ",", 4, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 5, ",", 2, ",", 4, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 2, ",", 4, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gamma[", 5, ",", 2, ",", 5, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 5, ",", 2, ",", 5, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 2, ",", 5, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]6
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gamma[", 5, ",", 2, ",", 6, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]6
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 5, ",", 2, ",", 6, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]6
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 2, ",", 6, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]7
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gamma[", 5, ",", 2, ",", 7, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]7
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 5, ",", 2, ",", 7, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]7
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 2, ",", 7, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]8
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gamma[", 5, ",", 2, ",", 8, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]8
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 5, ",", 2, ",", 8, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]8
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 2, ",", 8, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]9
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gamma[", 5, ",", 2, ",", 9, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]9
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 5, ",", 2, ",", 9, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]9
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 2, ",", 9, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]10
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gamma[", 5, ",", 2, ",", 10, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]10
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 5, ",", 2, ",", 10, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]10
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 2, ",", 10, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]11
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gamma[", 5, ",", 2, ",", 11, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]11
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 5, ",", 2, ",", 11, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]11
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 2, ",", 11, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]12
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gamma[", 5, ",", 2, ",", 12, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]12
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 5, ",", 2, ",", 12, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]12
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 2, ",", 12, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]13
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gamma[", 5, ",", 2, ",", 13, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]13
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 5, ",", 2, ",", 13, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]13
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 2, ",", 13, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]14
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gamma[", 5, ",", 2, ",", 14, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]14
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 5, ",", 2, ",", 14, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]14
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 2, ",", 14, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]15
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gamma[", 5, ",", 2, ",", 15, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]15
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 5, ",", 2, ",", 15, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]15
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 2, ",", 15, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]16
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gamma[", 5, ",", 2, ",", 16, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]16
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 5, ",", 2, ",", 16, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]16
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 2, ",", 16, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]17
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gamma[", 5, ",", 2, ",", 17, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]17
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 5, ",", 2, ",", 17, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]17
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 2, ",", 17, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]18
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gamma[", 5, ",", 2, ",", 18, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]18
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 5, ",", 2, ",", 18, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]18
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 2, ",", 18, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]19
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gamma[", 5, ",", 2, ",", 19, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]19
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 5, ",", 2, ",", 19, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]19
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 2, ",", 19, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]20
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gamma[", 5, ",", 2, ",", 20, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]20
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 5, ",", 2, ",", 20, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]20
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 2, ",", 20, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]21
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gamma[", 5, ",", 2, ",", 21, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]21
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 5, ",", 2, ",", 21, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]21
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 2, ",", 21, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]22
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gamma[", 5, ",", 2, ",", 22, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]22
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 5, ",", 2, ",", 22, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]22
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 2, ",", 22, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]23
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gamma[", 5, ",", 2, ",", 23, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]23
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 5, ",", 2, ",", 23, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]23
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 2, ",", 23, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]24
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gamma[", 5, ",", 2, ",", 24, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]24
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 5, ",", 2, ",", 24, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]24
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 2, ",", 24, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]25
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gamma[", 5, ",", 2, ",", 25, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]25
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 5, ",", 2, ",", 25, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]25
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 2, ",", 25, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]26
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gamma[", 5, ",", 2, ",", 26, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]26
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 5, ",", 2, ",", 26, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]26
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 2, ",", 26, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]27
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gamma[", 5, ",", 2, ",", 27, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]27
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 5, ",", 2, ",", 27, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]27
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 2, ",", 27, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]28
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gamma[", 5, ",", 2, ",", 28, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]28
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 5, ",", 2, ",", 28, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]28
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 2, ",", 28, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]29
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gamma[", 5, ",", 2, ",", 29, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]29
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 5, ",", 2, ",", 29, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]29
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 2, ",", 29, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]30
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gamma[", 5, ",", 2, ",", 30, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]30
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 5, ",", 2, ",", 30, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]30
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 2, ",", 30, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]31
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gamma[", 5, ",", 2, ",", 31, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]31
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 5, ",", 2, ",", 31, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]31
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 2, ",", 31, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]32
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gamma[", 5, ",", 2, ",", 32, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]32
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 5, ",", 2, ",", 32, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]32
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 2, ",", 32, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]33
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gamma[", 5, ",", 2, ",", 33, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]33
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 5, ",", 2, ",", 33, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]33
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 2, ",", 33, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]34
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gamma[", 5, ",", 2, ",", 34, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]34
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 5, ",", 2, ",", 34, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]34
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 2, ",", 34, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]35
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gamma[", 5, ",", 2, ",", 35, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]35
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 5, ",", 2, ",", 35, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]35
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 2, ",", 35, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]36
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gamma[", 5, ",", 2, ",", 36, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]36
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 5, ",", 2, ",", 36, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]36
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 2, ",", 36, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]37
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gamma[", 5, ",", 2, ",", 37, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]37
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 5, ",", 2, ",", 37, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]37
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 2, ",", 37, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]38
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gamma[", 5, ",", 2, ",", 38, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]38
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 5, ",", 2, ",", 38, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]38
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 2, ",", 38, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]39
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gamma[", 5, ",", 2, ",", 39, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]39
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 5, ",", 2, ",", 39, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]39
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 2, ",", 39, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]40
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gamma[", 5, ",", 2, ",", 40, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]40
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 5, ",", 2, ",", 40, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]40
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 2, ",", 40, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]41
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gamma[", 5, ",", 2, ",", 41, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]41
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 5, ",", 2, ",", 41, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]41
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 2, ",", 41, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]42
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gamma[", 5, ",", 2, ",", 42, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]42
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 5, ",", 2, ",", 42, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]42
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 2, ",", 42, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]43
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gamma[", 5, ",", 2, ",", 43, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]43
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 5, ",", 2, ",", 43, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]43
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 2, ",", 43, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]44
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gamma[", 5, ",", 2, ",", 44, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]44
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 5, ",", 2, ",", 44, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]44
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 2, ",", 44, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]45
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gamma[", 5, ",", 2, ",", 45, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]45
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 5, ",", 2, ",", 45, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]45
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 2, ",", 45, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]46
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gamma[", 5, ",", 2, ",", 46, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]46
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 5, ",", 2, ",", 46, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]46
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 2, ",", 46, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]47
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gamma[", 5, ",", 2, ",", 47, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]47
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 5, ",", 2, ",", 47, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]47
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 2, ",", 47, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]48
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gamma[", 5, ",", 2, ",", 48, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]48
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 5, ",", 2, ",", 48, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]48
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 2, ",", 48, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    \("   "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gamma[", 5, ",", 3, ",", 1, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 5, ",", 3, ",", 1, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 3, ",", 1, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gamma[", 5, ",", 3, ",", 2, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 5, ",", 3, ",", 2, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 3, ",", 2, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gamma[", 5, ",", 3, ",", 3, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 5, ",", 3, ",", 3, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 3, ",", 3, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gamma[", 5, ",", 3, ",", 4, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 5, ",", 3, ",", 4, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 3, ",", 4, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gamma[", 5, ",", 3, ",", 5, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 5, ",", 3, ",", 5, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 3, ",", 5, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]6
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gamma[", 5, ",", 3, ",", 6, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]6
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 5, ",", 3, ",", 6, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]6
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 3, ",", 6, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]7
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gamma[", 5, ",", 3, ",", 7, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]7
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 5, ",", 3, ",", 7, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]7
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 3, ",", 7, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]8
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gamma[", 5, ",", 3, ",", 8, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]8
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 5, ",", 3, ",", 8, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]8
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 3, ",", 8, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]9
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gamma[", 5, ",", 3, ",", 9, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]9
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 5, ",", 3, ",", 9, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]9
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 3, ",", 9, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]10
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gamma[", 5, ",", 3, ",", 10, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]10
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 5, ",", 3, ",", 10, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]10
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 3, ",", 10, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]11
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gamma[", 5, ",", 3, ",", 11, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]11
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 5, ",", 3, ",", 11, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]11
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 3, ",", 11, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]12
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gamma[", 5, ",", 3, ",", 12, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]12
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 5, ",", 3, ",", 12, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]12
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 3, ",", 12, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]13
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gamma[", 5, ",", 3, ",", 13, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]13
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 5, ",", 3, ",", 13, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]13
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 3, ",", 13, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]14
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gamma[", 5, ",", 3, ",", 14, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]14
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 5, ",", 3, ",", 14, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]14
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 3, ",", 14, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]15
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gamma[", 5, ",", 3, ",", 15, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]15
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 5, ",", 3, ",", 15, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]15
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 3, ",", 15, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]16
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gamma[", 5, ",", 3, ",", 16, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]16
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 5, ",", 3, ",", 16, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]16
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 3, ",", 16, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]17
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gamma[", 5, ",", 3, ",", 17, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]17
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 5, ",", 3, ",", 17, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]17
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 3, ",", 17, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]18
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gamma[", 5, ",", 3, ",", 18, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]18
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 5, ",", 3, ",", 18, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]18
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 3, ",", 18, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]19
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gamma[", 5, ",", 3, ",", 19, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]19
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 5, ",", 3, ",", 19, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]19
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 3, ",", 19, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]20
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gamma[", 5, ",", 3, ",", 20, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]20
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 5, ",", 3, ",", 20, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]20
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 3, ",", 20, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]21
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gamma[", 5, ",", 3, ",", 21, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]21
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 5, ",", 3, ",", 21, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]21
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 3, ",", 21, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]22
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gamma[", 5, ",", 3, ",", 22, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]22
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 5, ",", 3, ",", 22, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]22
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 3, ",", 22, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]23
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gamma[", 5, ",", 3, ",", 23, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]23
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 5, ",", 3, ",", 23, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]23
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 3, ",", 23, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]24
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gamma[", 5, ",", 3, ",", 24, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]24
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 5, ",", 3, ",", 24, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]24
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 3, ",", 24, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]25
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gamma[", 5, ",", 3, ",", 25, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]25
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 5, ",", 3, ",", 25, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]25
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 3, ",", 25, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]26
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gamma[", 5, ",", 3, ",", 26, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]26
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 5, ",", 3, ",", 26, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]26
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 3, ",", 26, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]27
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gamma[", 5, ",", 3, ",", 27, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]27
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 5, ",", 3, ",", 27, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]27
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 3, ",", 27, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]28
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gamma[", 5, ",", 3, ",", 28, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]28
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 5, ",", 3, ",", 28, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]28
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 3, ",", 28, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]29
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gamma[", 5, ",", 3, ",", 29, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]29
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 5, ",", 3, ",", 29, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]29
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 3, ",", 29, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]30
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gamma[", 5, ",", 3, ",", 30, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]30
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 5, ",", 3, ",", 30, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]30
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 3, ",", 30, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]31
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gamma[", 5, ",", 3, ",", 31, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]31
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 5, ",", 3, ",", 31, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]31
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 3, ",", 31, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]32
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gamma[", 5, ",", 3, ",", 32, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]32
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 5, ",", 3, ",", 32, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]32
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 3, ",", 32, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]33
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gamma[", 5, ",", 3, ",", 33, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]33
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 5, ",", 3, ",", 33, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]33
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 3, ",", 33, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]34
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gamma[", 5, ",", 3, ",", 34, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]34
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 5, ",", 3, ",", 34, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]34
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 3, ",", 34, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]35
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gamma[", 5, ",", 3, ",", 35, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]35
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 5, ",", 3, ",", 35, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]35
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 3, ",", 35, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]36
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gamma[", 5, ",", 3, ",", 36, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]36
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 5, ",", 3, ",", 36, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]36
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 3, ",", 36, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]37
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gamma[", 5, ",", 3, ",", 37, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]37
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 5, ",", 3, ",", 37, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]37
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 3, ",", 37, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]38
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gamma[", 5, ",", 3, ",", 38, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]38
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 5, ",", 3, ",", 38, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]38
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 3, ",", 38, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]39
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gamma[", 5, ",", 3, ",", 39, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]39
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 5, ",", 3, ",", 39, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]39
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 3, ",", 39, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]40
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gamma[", 5, ",", 3, ",", 40, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]40
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 5, ",", 3, ",", 40, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]40
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 3, ",", 40, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]41
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gamma[", 5, ",", 3, ",", 41, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]41
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 5, ",", 3, ",", 41, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]41
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 3, ",", 41, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]42
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gamma[", 5, ",", 3, ",", 42, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]42
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 5, ",", 3, ",", 42, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]42
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 3, ",", 42, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]43
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gamma[", 5, ",", 3, ",", 43, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]43
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 5, ",", 3, ",", 43, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]43
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 3, ",", 43, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]44
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gamma[", 5, ",", 3, ",", 44, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]44
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 5, ",", 3, ",", 44, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]44
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 3, ",", 44, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]45
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gamma[", 5, ",", 3, ",", 45, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]45
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 5, ",", 3, ",", 45, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]45
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 3, ",", 45, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]46
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gamma[", 5, ",", 3, ",", 46, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]46
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 5, ",", 3, ",", 46, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]46
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 3, ",", 46, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]47
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gamma[", 5, ",", 3, ",", 47, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]47
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 5, ",", 3, ",", 47, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]47
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 3, ",", 47, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]48
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gamma[", 5, ",", 3, ",", 48, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]48
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 5, ",", 3, ",", 48, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]48
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 3, ",", 48, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]49
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gamma[", 5, ",", 3, ",", 49, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]49
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 5, ",", 3, ",", 49, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]49
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 3, ",", 49, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    \("   "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gamma[", 5, ",", 4, ",", 1, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 5, ",", 4, ",", 1, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 4, ",", 1, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gamma[", 5, ",", 4, ",", 2, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 5, ",", 4, ",", 2, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 4, ",", 2, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gamma[", 5, ",", 4, ",", 3, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 5, ",", 4, ",", 3, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 4, ",", 3, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gamma[", 5, ",", 4, ",", 4, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 5, ",", 4, ",", 4, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 4, ",", 4, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gamma[", 5, ",", 4, ",", 5, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 5, ",", 4, ",", 5, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 4, ",", 5, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]6
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gamma[", 5, ",", 4, ",", 6, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]6
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 5, ",", 4, ",", 6, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]6
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 4, ",", 6, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]7
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gamma[", 5, ",", 4, ",", 7, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]7
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 5, ",", 4, ",", 7, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]7
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 4, ",", 7, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]8
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gamma[", 5, ",", 4, ",", 8, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]8
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 5, ",", 4, ",", 8, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]8
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 4, ",", 8, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]9
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gamma[", 5, ",", 4, ",", 9, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]9
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 5, ",", 4, ",", 9, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]9
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 4, ",", 9, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]10
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gamma[", 5, ",", 4, ",", 10, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]10
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 5, ",", 4, ",", 10, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]10
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 4, ",", 10, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]11
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gamma[", 5, ",", 4, ",", 11, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]11
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 5, ",", 4, ",", 11, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]11
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 4, ",", 11, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]12
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gamma[", 5, ",", 4, ",", 12, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]12
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 5, ",", 4, ",", 12, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]12
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 4, ",", 12, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]13
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gamma[", 5, ",", 4, ",", 13, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]13
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 5, ",", 4, ",", 13, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]13
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 4, ",", 13, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]14
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gamma[", 5, ",", 4, ",", 14, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]14
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 5, ",", 4, ",", 14, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]14
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 4, ",", 14, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]15
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gamma[", 5, ",", 4, ",", 15, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]15
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 5, ",", 4, ",", 15, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]15
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 4, ",", 15, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]16
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gamma[", 5, ",", 4, ",", 16, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]16
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 5, ",", 4, ",", 16, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]16
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 4, ",", 16, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]17
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gamma[", 5, ",", 4, ",", 17, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]17
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 5, ",", 4, ",", 17, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]17
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 4, ",", 17, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]18
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gamma[", 5, ",", 4, ",", 18, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]18
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 5, ",", 4, ",", 18, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]18
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 4, ",", 18, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]19
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gamma[", 5, ",", 4, ",", 19, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]19
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 5, ",", 4, ",", 19, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]19
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 4, ",", 19, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]20
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gamma[", 5, ",", 4, ",", 20, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]20
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 5, ",", 4, ",", 20, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]20
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 4, ",", 20, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]21
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gamma[", 5, ",", 4, ",", 21, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]21
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 5, ",", 4, ",", 21, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]21
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 4, ",", 21, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]22
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gamma[", 5, ",", 4, ",", 22, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]22
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 5, ",", 4, ",", 22, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]22
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 4, ",", 22, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]23
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gamma[", 5, ",", 4, ",", 23, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]23
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 5, ",", 4, ",", 23, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]23
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 4, ",", 23, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]24
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gamma[", 5, ",", 4, ",", 24, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]24
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 5, ",", 4, ",", 24, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]24
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 4, ",", 24, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]25
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gamma[", 5, ",", 4, ",", 25, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]25
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 5, ",", 4, ",", 25, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]25
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 4, ",", 25, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]26
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gamma[", 5, ",", 4, ",", 26, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]26
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 5, ",", 4, ",", 26, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]26
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 4, ",", 26, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]27
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gamma[", 5, ",", 4, ",", 27, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]27
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 5, ",", 4, ",", 27, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]27
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 4, ",", 27, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]28
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gamma[", 5, ",", 4, ",", 28, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]28
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 5, ",", 4, ",", 28, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]28
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 4, ",", 28, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]29
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gamma[", 5, ",", 4, ",", 29, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]29
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 5, ",", 4, ",", 29, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]29
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 4, ",", 29, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]30
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gamma[", 5, ",", 4, ",", 30, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]30
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 5, ",", 4, ",", 30, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]30
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 4, ",", 30, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]31
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gamma[", 5, ",", 4, ",", 31, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]31
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 5, ",", 4, ",", 31, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]31
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 4, ",", 31, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]32
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gamma[", 5, ",", 4, ",", 32, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]32
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 5, ",", 4, ",", 32, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]32
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 4, ",", 32, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]33
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gamma[", 5, ",", 4, ",", 33, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]33
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 5, ",", 4, ",", 33, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]33
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 4, ",", 33, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]34
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gamma[", 5, ",", 4, ",", 34, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]34
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 5, ",", 4, ",", 34, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]34
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 4, ",", 34, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]35
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gamma[", 5, ",", 4, ",", 35, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]35
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 5, ",", 4, ",", 35, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]35
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 4, ",", 35, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]36
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gamma[", 5, ",", 4, ",", 36, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]36
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 5, ",", 4, ",", 36, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]36
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 4, ",", 36, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]37
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gamma[", 5, ",", 4, ",", 37, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]37
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 5, ",", 4, ",", 37, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]37
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 4, ",", 37, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]38
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gamma[", 5, ",", 4, ",", 38, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]38
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 5, ",", 4, ",", 38, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]38
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 4, ",", 38, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]39
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gamma[", 5, ",", 4, ",", 39, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]39
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 5, ",", 4, ",", 39, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]39
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 4, ",", 39, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]40
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gamma[", 5, ",", 4, ",", 40, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]40
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 5, ",", 4, ",", 40, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]40
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 4, ",", 40, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]41
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gamma[", 5, ",", 4, ",", 41, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]41
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 5, ",", 4, ",", 41, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]41
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 4, ",", 41, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]42
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gamma[", 5, ",", 4, ",", 42, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]42
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 5, ",", 4, ",", 42, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]42
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 4, ",", 42, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]43
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gamma[", 5, ",", 4, ",", 43, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]43
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 5, ",", 4, ",", 43, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]43
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 4, ",", 43, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]44
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gamma[", 5, ",", 4, ",", 44, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]44
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 5, ",", 4, ",", 44, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]44
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 4, ",", 44, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]45
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gamma[", 5, ",", 4, ",", 45, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]45
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 5, ",", 4, ",", 45, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]45
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 4, ",", 45, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]46
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gamma[", 5, ",", 4, ",", 46, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]46
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 5, ",", 4, ",", 46, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]46
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 4, ",", 46, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]47
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gamma[", 5, ",", 4, ",", 47, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]47
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 5, ",", 4, ",", 47, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]47
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 4, ",", 47, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]48
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gamma[", 5, ",", 4, ",", 48, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]48
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 5, ",", 4, ",", 48, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]48
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 4, ",", 48, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]49
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gamma[", 5, ",", 4, ",", 49, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]49
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 5, ",", 4, ",", 49, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]49
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 4, ",", 49, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]50
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gamma[", 5, ",", 4, ",", 50, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]50
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 5, ",", 4, ",", 50, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]50
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 4, ",", 50, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    \({155.35000000000001`\ Second, Null}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(MemoryInUse[]\)], "Input"],

Cell[BoxData[
    \(2464640\)], "Output"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Computing the beta coefficients", "Subsection"],

Cell[BoxData[
    \(\( (*\ set\ the\ values\ of\ d\ and\ nmax\ *) \nd = 5; \ nmax = \ 50\ ; 
    \ \ \ \  (*\ for\ example\ *) \)\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(MemoryInUse[]\)], "Input"],

Cell[BoxData[
    \(2466424\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Timing[printbeta[d,nmax,$MachinePrecision,$MachinePrecision,True,\
True]]\
\>", "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    InterpretationBox[
      \("beta["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]0
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "beta[", 5, ",", 0, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("betaexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]0
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "betaexact[", 5, ",", 0, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]0
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 0, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("beta["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "beta[", 5, ",", 1, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("betaexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "betaexact[", 5, ",", 1, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 1, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("beta["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "beta[", 5, ",", 2, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("betaexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "betaexact[", 5, ",", 2, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 2, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("beta["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "beta[", 5, ",", 3, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("betaexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "betaexact[", 5, ",", 3, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 3, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("beta["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "beta[", 5, ",", 4, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("betaexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "betaexact[", 5, ",", 4, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 4, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("beta["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "beta[", 5, ",", 5, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("betaexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "betaexact[", 5, ",", 5, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 5, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("beta["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]6
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "beta[", 5, ",", 6, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("betaexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]6
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "betaexact[", 5, ",", 6, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]6
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 6, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("beta["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]7
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "beta[", 5, ",", 7, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("betaexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]7
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "betaexact[", 5, ",", 7, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]7
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 7, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("beta["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]8
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "beta[", 5, ",", 8, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("betaexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]8
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "betaexact[", 5, ",", 8, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]8
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 8, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("beta["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]9
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "beta[", 5, ",", 9, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("betaexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]9
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "betaexact[", 5, ",", 9, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]9
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 9, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("beta["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]10
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "beta[", 5, ",", 10, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("betaexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]10
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "betaexact[", 5, ",", 10, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]10
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 10, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("beta["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]11
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "beta[", 5, ",", 11, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("betaexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]11
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "betaexact[", 5, ",", 11, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]11
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 11, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("beta["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]12
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "beta[", 5, ",", 12, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("betaexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]12
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "betaexact[", 5, ",", 12, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]12
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 12, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("beta["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]13
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "beta[", 5, ",", 13, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("betaexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]13
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "betaexact[", 5, ",", 13, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]13
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 13, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("beta["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]14
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "beta[", 5, ",", 14, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("betaexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]14
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "betaexact[", 5, ",", 14, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]14
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 14, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("beta["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]15
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "beta[", 5, ",", 15, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("betaexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]15
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "betaexact[", 5, ",", 15, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]15
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 15, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("beta["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]16
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "beta[", 5, ",", 16, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("betaexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]16
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "betaexact[", 5, ",", 16, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]16
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 16, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("beta["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]17
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "beta[", 5, ",", 17, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("betaexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]17
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "betaexact[", 5, ",", 17, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]17
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 17, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("beta["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]18
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "beta[", 5, ",", 18, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("betaexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]18
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "betaexact[", 5, ",", 18, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]18
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 18, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("beta["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]19
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "beta[", 5, ",", 19, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("betaexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]19
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "betaexact[", 5, ",", 19, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]19
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 19, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("beta["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]20
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "beta[", 5, ",", 20, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("betaexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]20
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "betaexact[", 5, ",", 20, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]20
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 20, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("beta["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]21
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "beta[", 5, ",", 21, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("betaexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]21
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "betaexact[", 5, ",", 21, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]21
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 21, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("beta["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]22
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "beta[", 5, ",", 22, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("betaexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]22
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "betaexact[", 5, ",", 22, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]22
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 22, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("beta["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]23
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "beta[", 5, ",", 23, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("betaexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]23
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "betaexact[", 5, ",", 23, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]23
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 23, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("beta["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]24
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "beta[", 5, ",", 24, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("betaexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]24
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "betaexact[", 5, ",", 24, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]24
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 24, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("beta["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]25
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "beta[", 5, ",", 25, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("betaexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]25
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "betaexact[", 5, ",", 25, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]25
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 25, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("beta["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]26
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "beta[", 5, ",", 26, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("betaexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]26
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "betaexact[", 5, ",", 26, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]26
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 26, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("beta["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]27
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "beta[", 5, ",", 27, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("betaexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]27
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "betaexact[", 5, ",", 27, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]27
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 27, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("beta["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]28
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "beta[", 5, ",", 28, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("betaexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]28
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "betaexact[", 5, ",", 28, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]28
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 28, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("beta["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]29
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "beta[", 5, ",", 29, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("betaexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]29
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "betaexact[", 5, ",", 29, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]29
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 29, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("beta["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]30
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "beta[", 5, ",", 30, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("betaexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]30
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "betaexact[", 5, ",", 30, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]30
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 30, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("beta["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]31
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "beta[", 5, ",", 31, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("betaexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]31
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "betaexact[", 5, ",", 31, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]31
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 31, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("beta["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]32
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "beta[", 5, ",", 32, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("betaexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]32
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "betaexact[", 5, ",", 32, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]32
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 32, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("beta["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]33
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "beta[", 5, ",", 33, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("betaexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]33
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "betaexact[", 5, ",", 33, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]33
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 33, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("beta["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]34
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "beta[", 5, ",", 34, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("betaexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]34
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "betaexact[", 5, ",", 34, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]34
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 34, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("beta["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]35
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "beta[", 5, ",", 35, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("betaexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]35
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "betaexact[", 5, ",", 35, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]35
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 35, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("beta["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]36
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "beta[", 5, ",", 36, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("betaexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]36
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "betaexact[", 5, ",", 36, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]36
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 36, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("beta["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]37
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "beta[", 5, ",", 37, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("betaexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]37
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "betaexact[", 5, ",", 37, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]37
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 37, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("beta["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]38
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "beta[", 5, ",", 38, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("betaexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]38
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "betaexact[", 5, ",", 38, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]38
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 38, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("beta["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]39
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "beta[", 5, ",", 39, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("betaexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]39
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "betaexact[", 5, ",", 39, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]39
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 39, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("beta["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]40
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "beta[", 5, ",", 40, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("betaexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]40
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "betaexact[", 5, ",", 40, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]40
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 40, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("beta["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]41
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "beta[", 5, ",", 41, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("betaexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]41
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "betaexact[", 5, ",", 41, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]41
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 41, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("beta["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]42
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "beta[", 5, ",", 42, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("betaexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]42
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "betaexact[", 5, ",", 42, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]42
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 42, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("beta["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]43
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "beta[", 5, ",", 43, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("betaexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]43
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "betaexact[", 5, ",", 43, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]43
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 43, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("beta["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]44
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "beta[", 5, ",", 44, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("betaexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]44
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "betaexact[", 5, ",", 44, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]44
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 44, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("beta["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]45
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "beta[", 5, ",", 45, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("betaexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]45
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "betaexact[", 5, ",", 45, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]45
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 45, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("beta["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]46
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "beta[", 5, ",", 46, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("betaexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]46
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "betaexact[", 5, ",", 46, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]46
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 46, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("beta["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]47
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "beta[", 5, ",", 47, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("betaexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]47
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "betaexact[", 5, ",", 47, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]47
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 47, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("beta["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]48
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "beta[", 5, ",", 48, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("betaexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]48
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "betaexact[", 5, ",", 48, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]48
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 48, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("beta["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]49
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "beta[", 5, ",", 49, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("betaexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]49
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "betaexact[", 5, ",", 49, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]49
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 49, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    \({27.3333333333333694`\ Second, Null}\)], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(MemoryInUse[]\)], "Input"],

Cell[BoxData[
    \(2472544\)], "Output"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Computing the d-orthogonal polynomials", "Subsection"],

Cell[BoxData[
    \(\( (*\ set\ the\ values\ of\ d\ and\ nmax\ *) \nd = 5; \ nmax = \ 15; 
    \ \ \ \  (*\ for\ example\ *) \)\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(MemoryInUse[]\)], "Input"],

Cell[BoxData[
    \(2474328\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Timing[printdorthpoly[d,nmax,x,$MachinePrecision]]", "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("dorthpoly["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "x", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["1.`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "dorthpoly[", 5, ",", 0, ",", x, "]=", 1.0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("dorthpoly["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]x
        \[InvisibleSpace]"]="\[InvisibleSpace]x\),
      SequenceForm[ "dorthpoly[", 5, ",", 1, ",", x, "]=", x],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("dorthpoly["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]x
        \[InvisibleSpace]"]="\[InvisibleSpace]x\^2\),
      SequenceForm[ "dorthpoly[", 5, ",", 2, ",", x, "]=", 
        Power[ x, 2]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("dorthpoly["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]x
        \[InvisibleSpace]"]="\[InvisibleSpace]x\^3\),
      SequenceForm[ "dorthpoly[", 5, ",", 3, ",", x, "]=", 
        Power[ x, 3]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("dorthpoly["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]x
        \[InvisibleSpace]"]="\[InvisibleSpace]x\^4\),
      SequenceForm[ "dorthpoly[", 5, ",", 4, ",", x, "]=", 
        Power[ x, 4]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("dorthpoly["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]x
        \[InvisibleSpace]"]="\[InvisibleSpace]x\^5\),
      SequenceForm[ "dorthpoly[", 5, ",", 5, ",", x, "]=", 
        Power[ x, 5]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("dorthpoly["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "6", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "x", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        RowBox[{
          RowBox[{"-", 
            StyleBox["0.166666666666666651`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16]}], "+", \(x\^6\)}]}],
      SequenceForm[ "dorthpoly[", 5, ",", 6, ",", x, "]=", 
        Plus[ -0.16666666666666666, 
          Power[ x, 6]]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("dorthpoly["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "7", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "x", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        RowBox[{
          RowBox[{
            RowBox[{"-", 
              StyleBox["1.16666666666666674`",
                StyleBoxAutoDelete->True,
                PrintPrecision->16]}], " ", "x"}], "+", \(x\^7\)}]}],
      SequenceForm[ "dorthpoly[", 5, ",", 7, ",", x, "]=", 
        Plus[ 
          Times[ -1.1666666666666667, x], 
          Power[ x, 7]]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("dorthpoly["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "8", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "x", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        RowBox[{
          RowBox[{
            RowBox[{"-", 
              StyleBox["4.66666666666666696`",
                StyleBoxAutoDelete->True,
                PrintPrecision->16]}], " ", \(x\^2\)}], "+", \(x\^8\)}]}],
      SequenceForm[ "dorthpoly[", 5, ",", 8, ",", x, "]=", 
        Plus[ 
          Times[ -4.666666666666667, 
            Power[ x, 2]], 
          Power[ x, 8]]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("dorthpoly["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "9", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "x", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        RowBox[{
          RowBox[{
            RowBox[{"-", 
              StyleBox["13.9999999999999991`",
                StyleBoxAutoDelete->True,
                PrintPrecision->16]}], " ", \(x\^3\)}], "+", \(x\^9\)}]}],
      SequenceForm[ "dorthpoly[", 5, ",", 9, ",", x, "]=", 
        Plus[ 
          Times[ -14.0, 
            Power[ x, 3]], 
          Power[ x, 9]]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("dorthpoly["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "10", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "x", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        RowBox[{
          RowBox[{
            RowBox[{"-", 
              StyleBox["35.`",
                StyleBoxAutoDelete->True,
                PrintPrecision->16]}], " ", \(x\^4\)}], "+", \(x\^10\)}]}],
      SequenceForm[ "dorthpoly[", 5, ",", 10, ",", x, "]=", 
        Plus[ 
          Times[ -35.0, 
            Power[ x, 4]], 
          Power[ x, 10]]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("dorthpoly["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "11", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "x", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        RowBox[{
          RowBox[{
            RowBox[{"-", 
              StyleBox["77.0000000000000017`",
                StyleBoxAutoDelete->True,
                PrintPrecision->16]}], " ", \(x\^5\)}], "+", \(x\^11\)}]}],
      SequenceForm[ "dorthpoly[", 5, ",", 11, ",", x, "]=", 
        Plus[ 
          Times[ -77.0, 
            Power[ x, 5]], 
          Power[ x, 11]]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("dorthpoly["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "12", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "x", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        RowBox[{
          RowBox[{
            StyleBox["12.8333333333333321`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], "\[InvisibleSpace]"}], "-", 
          RowBox[{
            StyleBox["154.000000000000003`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^6\)}], "+", \(x\^12\)}]}],
      SequenceForm[ "dorthpoly[", 5, ",", 12, ",", x, "]=", 
        Plus[ 12.833333333333332, 
          Times[ -154.0, 
            Power[ x, 6]], 
          Power[ x, 12]]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("dorthpoly["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "13", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "x", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        RowBox[{
          RowBox[{
            StyleBox["166.833333333333255`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", "x"}], "-", 
          RowBox[{
            StyleBox["285.999999999999854`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^7\)}], "+", \(x\^13\)}]}],
      SequenceForm[ "dorthpoly[", 5, ",", 13, ",", x, "]=", 
        Plus[ 
          Times[ 166.83333333333326, x], 
          Times[ -285.99999999999989, 
            Power[ x, 7]], 
          Power[ x, 13]]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("dorthpoly["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "14", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "x", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        RowBox[{
          RowBox[{
            StyleBox["1167.83333333333372`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^2\)}], "-", 
          RowBox[{
            StyleBox["500.499999999999989`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^8\)}], "+", \(x\^14\)}]}],
      SequenceForm[ "dorthpoly[", 5, ",", 14, ",", x, "]=", 
        Plus[ 
          Times[ 1167.8333333333337, 
            Power[ x, 2]], 
          Times[ -500.5, 
            Power[ x, 8]], 
          Power[ x, 14]]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("dorthpoly["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "15", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "x", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        RowBox[{
          RowBox[{
            StyleBox["5839.16666666666728`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^3\)}], "-", 
          RowBox[{
            StyleBox["834.166666666666678`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^9\)}], "+", \(x\^15\)}]}],
      SequenceForm[ "dorthpoly[", 5, ",", 15, ",", x, "]=", 
        Plus[ 
          Times[ 5839.1666666666679, 
            Power[ x, 3]], 
          Times[ -834.16666666666674, 
            Power[ x, 9]], 
          Power[ x, 15]]],
      Editable->False]], "Print"],

Cell[BoxData[
    \({2.94999999999998863`\ Second, Null}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(MemoryInUse[]\)], "Input"],

Cell[BoxData[
    \(2480384\)], "Output"]
}, Open  ]]
}, Closed]]
}, Closed]]
},
FrontEndVersion->"Macintosh 3.0",
ScreenRectangle->{{0, 832}, {0, 604}},
WindowSize->{590, 412},
WindowMargins->{{Automatic, 87}, {Automatic, 66}},
MacintoshSystemPageSetup->"\<\
00<0001804P000000`d26_oQon@3:`8g0dL5N`?P0080001804P000000]P2:001
0000I00000400`<30?l00BL?00400@0000000000000006P801T1T00000000000
00000000004000000000000000000000\>"
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{
Cell[1709, 49, 1292, 22, 628, "Subsection"],

Cell[CellGroupData[{
Cell[3026, 75, 154, 4, 68, "Section"],

Cell[CellGroupData[{
Cell[3205, 83, 105, 3, 44, "Subsection"],
Cell[3313, 88, 56, 1, 27, "Input"]
}, Closed]],

Cell[CellGroupData[{
Cell[3406, 94, 132, 4, 28, "Subsection"],
Cell[3541, 100, 71, 1, 27, "Input"],
Cell[3615, 103, 142, 2, 43, "Input"],

Cell[CellGroupData[{
Cell[3782, 109, 249, 5, 59, "Input"],
Cell[4034, 116, 298, 6, 22, "Print"],
Cell[4335, 124, 298, 6, 22, "Print"],
Cell[4636, 132, 298, 6, 22, "Print"],
Cell[4937, 140, 298, 6, 22, "Print"],
Cell[5238, 148, 298, 6, 22, "Print"],
Cell[5539, 156, 298, 6, 22, "Print"],
Cell[5840, 164, 324, 7, 38, "Print"],
Cell[6167, 173, 298, 6, 22, "Print"],
Cell[6468, 181, 298, 6, 22, "Print"],
Cell[6769, 189, 298, 6, 22, "Print"],
Cell[7070, 197, 300, 6, 22, "Print"],
Cell[7373, 205, 55, 1, 22, "Print"],
Cell[7431, 208, 298, 6, 22, "Print"],
Cell[7732, 216, 298, 6, 22, "Print"],
Cell[8033, 224, 298, 6, 22, "Print"],
Cell[8334, 232, 298, 6, 22, "Print"],
Cell[8635, 240, 298, 6, 22, "Print"],
Cell[8936, 248, 298, 6, 22, "Print"],
Cell[9237, 256, 298, 6, 22, "Print"],
Cell[9538, 264, 324, 7, 38, "Print"],
Cell[9865, 273, 298, 6, 22, "Print"],
Cell[10166, 281, 298, 6, 22, "Print"],
Cell[10467, 289, 300, 6, 22, "Print"],
Cell[10770, 297, 55, 1, 22, "Print"],
Cell[10828, 300, 298, 6, 22, "Print"],
Cell[11129, 308, 298, 6, 22, "Print"],
Cell[11430, 316, 298, 6, 22, "Print"],
Cell[11731, 324, 298, 6, 22, "Print"],
Cell[12032, 332, 298, 6, 22, "Print"],
Cell[12333, 340, 298, 6, 22, "Print"],
Cell[12634, 348, 298, 6, 22, "Print"],
Cell[12935, 356, 298, 6, 22, "Print"],
Cell[13236, 364, 326, 7, 38, "Print"],
Cell[13565, 373, 298, 6, 22, "Print"],
Cell[13866, 381, 300, 6, 22, "Print"],
Cell[14169, 389, 55, 1, 22, "Print"],
Cell[14227, 392, 298, 6, 22, "Print"],
Cell[14528, 400, 298, 6, 22, "Print"],
Cell[14829, 408, 298, 6, 22, "Print"],
Cell[15130, 416, 298, 6, 22, "Print"],
Cell[15431, 424, 298, 6, 22, "Print"],
Cell[15732, 432, 298, 6, 22, "Print"],
Cell[16033, 440, 298, 6, 22, "Print"],
Cell[16334, 448, 298, 6, 22, "Print"],
Cell[16635, 456, 298, 6, 22, "Print"],
Cell[16936, 464, 300, 6, 22, "Print"],
Cell[17239, 472, 300, 6, 22, "Print"],
Cell[17542, 480, 55, 1, 22, "Print"],
Cell[17600, 483, 298, 6, 22, "Print"],
Cell[17901, 491, 298, 6, 22, "Print"],
Cell[18202, 499, 298, 6, 22, "Print"],
Cell[18503, 507, 298, 6, 22, "Print"],
Cell[18804, 515, 298, 6, 22, "Print"],
Cell[19105, 523, 298, 6, 22, "Print"],
Cell[19406, 531, 298, 6, 22, "Print"],
Cell[19707, 539, 298, 6, 22, "Print"],
Cell[20008, 547, 298, 6, 22, "Print"],
Cell[20309, 555, 298, 6, 22, "Print"],
Cell[20610, 563, 302, 6, 22, "Print"],
Cell[20915, 571, 55, 1, 22, "Print"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{
Cell[21019, 578, 54, 0, 28, "Subsection"],

Cell[CellGroupData[{
Cell[21098, 582, 142, 2, 43, "Input"],
Cell[21243, 586, 175, 3, 37, "Message"]
}, Open  ]],

Cell[CellGroupData[{
Cell[21455, 594, 46, 1, 27, "Input"],
Cell[21504, 597, 40, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[21581, 603, 117, 4, 42, "Input"],
Cell[21701, 609, 38, 1, 22, "Print"],
Cell[21742, 612, 326, 7, 38, "Print"],
Cell[22071, 621, 336, 7, 38, "Print"],
Cell[22410, 630, 37, 1, 22, "Print"],
Cell[22450, 633, 300, 6, 22, "Print"],
Cell[22753, 641, 310, 6, 22, "Print"],
Cell[23066, 649, 37, 1, 22, "Print"],
Cell[23106, 652, 326, 7, 38, "Print"],
Cell[23435, 661, 336, 7, 38, "Print"],
Cell[23774, 670, 37, 1, 22, "Print"],
Cell[23814, 673, 328, 7, 38, "Print"],
Cell[24145, 682, 338, 7, 38, "Print"],
Cell[24486, 691, 37, 1, 22, "Print"],
Cell[24526, 694, 302, 6, 22, "Print"],
Cell[24831, 702, 312, 6, 22, "Print"],
Cell[25146, 710, 37, 1, 22, "Print"],
Cell[25186, 713, 302, 6, 22, "Print"],
Cell[25491, 721, 312, 6, 22, "Print"],
Cell[25806, 729, 37, 1, 22, "Print"],
Cell[25846, 732, 38, 1, 22, "Print"],
Cell[25887, 735, 300, 6, 22, "Print"],
Cell[26190, 743, 310, 6, 22, "Print"],
Cell[26503, 751, 37, 1, 22, "Print"],
Cell[26543, 754, 300, 6, 22, "Print"],
Cell[26846, 762, 310, 6, 22, "Print"],
Cell[27159, 770, 37, 1, 22, "Print"],
Cell[27199, 773, 300, 6, 22, "Print"],
Cell[27502, 781, 310, 6, 22, "Print"],
Cell[27815, 789, 37, 1, 22, "Print"],
Cell[27855, 792, 300, 6, 22, "Print"],
Cell[28158, 800, 310, 6, 22, "Print"],
Cell[28471, 808, 37, 1, 22, "Print"],
Cell[28511, 811, 300, 6, 22, "Print"],
Cell[28814, 819, 310, 6, 22, "Print"],
Cell[29127, 827, 37, 1, 22, "Print"],
Cell[29167, 830, 300, 6, 22, "Print"],
Cell[29470, 838, 310, 6, 22, "Print"],
Cell[29783, 846, 37, 1, 22, "Print"],
Cell[29823, 849, 300, 6, 22, "Print"],
Cell[30126, 857, 310, 6, 22, "Print"],
Cell[30439, 865, 37, 1, 22, "Print"],
Cell[30479, 868, 38, 1, 22, "Print"],
Cell[30520, 871, 300, 6, 22, "Print"],
Cell[30823, 879, 310, 6, 22, "Print"],
Cell[31136, 887, 37, 1, 22, "Print"],
Cell[31176, 890, 300, 6, 22, "Print"],
Cell[31479, 898, 310, 6, 22, "Print"],
Cell[31792, 906, 37, 1, 22, "Print"],
Cell[31832, 909, 300, 6, 22, "Print"],
Cell[32135, 917, 310, 6, 22, "Print"],
Cell[32448, 925, 37, 1, 22, "Print"],
Cell[32488, 928, 300, 6, 22, "Print"],
Cell[32791, 936, 310, 6, 22, "Print"],
Cell[33104, 944, 37, 1, 22, "Print"],
Cell[33144, 947, 300, 6, 22, "Print"],
Cell[33447, 955, 310, 6, 22, "Print"],
Cell[33760, 963, 37, 1, 22, "Print"],
Cell[33800, 966, 300, 6, 22, "Print"],
Cell[34103, 974, 310, 6, 22, "Print"],
Cell[34416, 982, 37, 1, 22, "Print"],
Cell[34456, 985, 300, 6, 22, "Print"],
Cell[34759, 993, 310, 6, 22, "Print"],
Cell[35072, 1001, 37, 1, 22, "Print"],
Cell[35112, 1004, 300, 6, 22, "Print"],
Cell[35415, 1012, 310, 6, 22, "Print"],
Cell[35728, 1020, 37, 1, 22, "Print"],
Cell[35768, 1023, 38, 1, 22, "Print"],
Cell[35809, 1026, 300, 6, 22, "Print"],
Cell[36112, 1034, 310, 6, 22, "Print"],
Cell[36425, 1042, 37, 1, 22, "Print"],
Cell[36465, 1045, 300, 6, 22, "Print"],
Cell[36768, 1053, 310, 6, 22, "Print"],
Cell[37081, 1061, 37, 1, 22, "Print"],
Cell[37121, 1064, 300, 6, 22, "Print"],
Cell[37424, 1072, 310, 6, 22, "Print"],
Cell[37737, 1080, 37, 1, 22, "Print"],
Cell[37777, 1083, 300, 6, 22, "Print"],
Cell[38080, 1091, 310, 6, 22, "Print"],
Cell[38393, 1099, 37, 1, 22, "Print"],
Cell[38433, 1102, 300, 6, 22, "Print"],
Cell[38736, 1110, 310, 6, 22, "Print"],
Cell[39049, 1118, 37, 1, 22, "Print"],
Cell[39089, 1121, 300, 6, 22, "Print"],
Cell[39392, 1129, 310, 6, 22, "Print"],
Cell[39705, 1137, 37, 1, 22, "Print"],
Cell[39745, 1140, 300, 6, 22, "Print"],
Cell[40048, 1148, 310, 6, 22, "Print"],
Cell[40361, 1156, 37, 1, 22, "Print"],
Cell[40401, 1159, 300, 6, 22, "Print"],
Cell[40704, 1167, 310, 6, 22, "Print"],
Cell[41017, 1175, 37, 1, 22, "Print"],
Cell[41057, 1178, 300, 6, 22, "Print"],
Cell[41360, 1186, 310, 6, 22, "Print"],
Cell[41673, 1194, 37, 1, 22, "Print"],
Cell[41713, 1197, 38, 1, 22, "Print"],
Cell[41754, 1200, 300, 6, 22, "Print"],
Cell[42057, 1208, 310, 6, 22, "Print"],
Cell[42370, 1216, 37, 1, 22, "Print"],
Cell[42410, 1219, 300, 6, 22, "Print"],
Cell[42713, 1227, 310, 6, 22, "Print"],
Cell[43026, 1235, 37, 1, 22, "Print"],
Cell[43066, 1238, 300, 6, 22, "Print"],
Cell[43369, 1246, 310, 6, 22, "Print"],
Cell[43682, 1254, 37, 1, 22, "Print"],
Cell[43722, 1257, 300, 6, 22, "Print"],
Cell[44025, 1265, 310, 6, 22, "Print"],
Cell[44338, 1273, 37, 1, 22, "Print"],
Cell[44378, 1276, 300, 6, 22, "Print"],
Cell[44681, 1284, 310, 6, 22, "Print"],
Cell[44994, 1292, 37, 1, 22, "Print"],
Cell[45034, 1295, 300, 6, 22, "Print"],
Cell[45337, 1303, 310, 6, 22, "Print"],
Cell[45650, 1311, 37, 1, 22, "Print"],
Cell[45690, 1314, 300, 6, 22, "Print"],
Cell[45993, 1322, 310, 6, 22, "Print"],
Cell[46306, 1330, 37, 1, 22, "Print"],
Cell[46346, 1333, 300, 6, 22, "Print"],
Cell[46649, 1341, 310, 6, 22, "Print"],
Cell[46962, 1349, 37, 1, 22, "Print"],
Cell[47002, 1352, 300, 6, 22, "Print"],
Cell[47305, 1360, 310, 6, 22, "Print"],
Cell[47618, 1368, 37, 1, 22, "Print"],
Cell[47658, 1371, 302, 6, 22, "Print"],
Cell[47963, 1379, 312, 6, 22, "Print"],
Cell[48278, 1387, 37, 1, 22, "Print"],
Cell[48318, 1390, 70, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[48425, 1396, 46, 1, 27, "Input"],
Cell[48474, 1399, 41, 1, 26, "Output"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{
Cell[48564, 1406, 53, 0, 28, "Subsection"],
Cell[48620, 1408, 142, 2, 43, "Input"],

Cell[CellGroupData[{
Cell[48787, 1414, 46, 1, 27, "Input"],
Cell[48836, 1417, 41, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[48914, 1423, 116, 4, 42, "Input"],
Cell[49033, 1429, 243, 5, 22, "Print"],
Cell[49279, 1436, 253, 5, 22, "Print"],
Cell[49535, 1443, 37, 1, 22, "Print"],
Cell[49575, 1446, 243, 5, 22, "Print"],
Cell[49821, 1453, 253, 5, 22, "Print"],
Cell[50077, 1460, 37, 1, 22, "Print"],
Cell[50117, 1463, 243, 5, 22, "Print"],
Cell[50363, 1470, 253, 5, 22, "Print"],
Cell[50619, 1477, 37, 1, 22, "Print"],
Cell[50659, 1480, 243, 5, 22, "Print"],
Cell[50905, 1487, 253, 5, 22, "Print"],
Cell[51161, 1494, 37, 1, 22, "Print"],
Cell[51201, 1497, 243, 5, 22, "Print"],
Cell[51447, 1504, 253, 5, 22, "Print"],
Cell[51703, 1511, 37, 1, 22, "Print"],
Cell[51743, 1514, 243, 5, 22, "Print"],
Cell[51989, 1521, 253, 5, 22, "Print"],
Cell[52245, 1528, 37, 1, 22, "Print"],
Cell[52285, 1531, 243, 5, 22, "Print"],
Cell[52531, 1538, 253, 5, 22, "Print"],
Cell[52787, 1545, 37, 1, 22, "Print"],
Cell[52827, 1548, 243, 5, 22, "Print"],
Cell[53073, 1555, 253, 5, 22, "Print"],
Cell[53329, 1562, 37, 1, 22, "Print"],
Cell[53369, 1565, 243, 5, 22, "Print"],
Cell[53615, 1572, 253, 5, 22, "Print"],
Cell[53871, 1579, 37, 1, 22, "Print"],
Cell[53911, 1582, 243, 5, 22, "Print"],
Cell[54157, 1589, 253, 5, 22, "Print"],
Cell[54413, 1596, 37, 1, 22, "Print"],
Cell[54453, 1599, 70, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[54560, 1605, 46, 1, 27, "Input"],
Cell[54609, 1608, 41, 1, 26, "Output"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{
Cell[54699, 1615, 60, 0, 28, "Subsection"],
Cell[54762, 1617, 142, 2, 43, "Input"],

Cell[CellGroupData[{
Cell[54929, 1623, 46, 1, 27, "Input"],
Cell[54978, 1626, 41, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[55056, 1632, 84, 1, 27, "Input"],
Cell[55143, 1635, 308, 6, 22, "Print"],
Cell[55454, 1643, 308, 6, 22, "Print"],
Cell[55765, 1651, 331, 7, 24, "Print"],
Cell[56099, 1660, 331, 7, 24, "Print"],
Cell[56433, 1669, 331, 7, 24, "Print"],
Cell[56767, 1678, 331, 7, 24, "Print"],
Cell[57101, 1687, 396, 9, 38, "Print"],
Cell[57500, 1698, 434, 11, 38, "Print"],
Cell[57937, 1711, 467, 12, 40, "Print"],
Cell[58407, 1725, 422, 10, 24, "Print"],
Cell[58832, 1737, 426, 10, 24, "Print"],
Cell[59261, 1749, 70, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[59368, 1755, 46, 1, 27, "Input"],
Cell[59417, 1758, 41, 1, 26, "Output"]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[59519, 1766, 187, 5, 66, "Section"],

Cell[CellGroupData[{
Cell[59731, 1775, 105, 3, 44, "Subsection"],
Cell[59839, 1780, 56, 1, 27, "Input"]
}, Closed]],

Cell[CellGroupData[{
Cell[59932, 1786, 54, 0, 28, "Subsection"],
Cell[59989, 1788, 142, 2, 43, "Input"],

Cell[CellGroupData[{
Cell[60156, 1794, 46, 1, 27, "Input"],
Cell[60205, 1797, 40, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[60282, 1803, 125, 4, 42, "Input"],
Cell[60410, 1809, 38, 1, 22, "Print"],
Cell[60451, 1812, 511, 11, 22, "Print"],
Cell[60965, 1825, 528, 12, 22, "Print"],
Cell[61496, 1839, 498, 11, 22, "Print"],
Cell[61997, 1852, 37, 1, 22, "Print"],
Cell[62037, 1855, 477, 11, 22, "Print"],
Cell[62517, 1868, 487, 11, 22, "Print"],
Cell[63007, 1881, 498, 11, 22, "Print"],
Cell[63508, 1894, 37, 1, 22, "Print"],
Cell[63548, 1897, 478, 11, 22, "Print"],
Cell[64029, 1910, 488, 11, 22, "Print"],
Cell[64520, 1923, 498, 11, 22, "Print"],
Cell[65021, 1936, 37, 1, 22, "Print"],
Cell[65061, 1939, 509, 11, 22, "Print"],
Cell[65573, 1952, 526, 12, 22, "Print"],
Cell[66102, 1966, 498, 11, 22, "Print"],
Cell[66603, 1979, 37, 1, 22, "Print"],
Cell[66643, 1982, 495, 11, 22, "Print"],
Cell[67141, 1995, 505, 11, 22, "Print"],
Cell[67649, 2008, 498, 11, 22, "Print"],
Cell[68150, 2021, 37, 1, 22, "Print"],
Cell[68190, 2024, 495, 11, 22, "Print"],
Cell[68688, 2037, 505, 11, 22, "Print"],
Cell[69196, 2050, 498, 11, 22, "Print"],
Cell[69697, 2063, 37, 1, 22, "Print"],
Cell[69737, 2066, 495, 11, 22, "Print"],
Cell[70235, 2079, 505, 11, 22, "Print"],
Cell[70743, 2092, 498, 11, 22, "Print"],
Cell[71244, 2105, 37, 1, 22, "Print"],
Cell[71284, 2108, 509, 11, 22, "Print"],
Cell[71796, 2121, 506, 11, 22, "Print"],
Cell[72305, 2134, 526, 12, 22, "Print"],
Cell[72834, 2148, 37, 1, 22, "Print"],
Cell[72874, 2151, 508, 11, 22, "Print"],
Cell[73385, 2164, 506, 11, 22, "Print"],
Cell[73894, 2177, 526, 12, 22, "Print"],
Cell[74423, 2191, 37, 1, 22, "Print"],
Cell[74463, 2194, 511, 11, 22, "Print"],
Cell[74977, 2207, 528, 12, 22, "Print"],
Cell[75508, 2221, 500, 11, 22, "Print"],
Cell[76011, 2234, 37, 1, 22, "Print"],
Cell[76051, 2237, 511, 11, 22, "Print"],
Cell[76565, 2250, 508, 11, 22, "Print"],
Cell[77076, 2263, 528, 12, 22, "Print"],
Cell[77607, 2277, 37, 1, 22, "Print"],
Cell[77647, 2280, 511, 11, 22, "Print"],
Cell[78161, 2293, 508, 11, 22, "Print"],
Cell[78672, 2306, 529, 12, 22, "Print"],
Cell[79204, 2320, 37, 1, 22, "Print"],
Cell[79244, 2323, 510, 11, 22, "Print"],
Cell[79757, 2336, 528, 12, 22, "Print"],
Cell[80288, 2350, 529, 12, 22, "Print"],
Cell[80820, 2364, 37, 1, 22, "Print"],
Cell[80860, 2367, 511, 11, 22, "Print"],
Cell[81374, 2380, 509, 11, 22, "Print"],
Cell[81886, 2393, 529, 12, 22, "Print"],
Cell[82418, 2407, 37, 1, 22, "Print"],
Cell[82458, 2410, 510, 11, 22, "Print"],
Cell[82971, 2423, 509, 11, 22, "Print"],
Cell[83483, 2436, 529, 12, 22, "Print"],
Cell[84015, 2450, 37, 1, 22, "Print"],
Cell[84055, 2453, 511, 11, 22, "Print"],
Cell[84569, 2466, 509, 11, 22, "Print"],
Cell[85081, 2479, 529, 12, 22, "Print"],
Cell[85613, 2493, 37, 1, 22, "Print"],
Cell[85653, 2496, 511, 11, 22, "Print"],
Cell[86167, 2509, 509, 11, 22, "Print"],
Cell[86679, 2522, 529, 12, 22, "Print"],
Cell[87211, 2536, 37, 1, 22, "Print"],
Cell[87251, 2539, 511, 11, 22, "Print"],
Cell[87765, 2552, 509, 11, 22, "Print"],
Cell[88277, 2565, 529, 12, 22, "Print"],
Cell[88809, 2579, 37, 1, 22, "Print"],
Cell[88849, 2582, 511, 11, 22, "Print"],
Cell[89363, 2595, 527, 12, 22, "Print"],
Cell[89893, 2609, 529, 12, 22, "Print"],
Cell[90425, 2623, 37, 1, 22, "Print"],
Cell[90465, 2626, 511, 11, 22, "Print"],
Cell[90979, 2639, 509, 11, 22, "Print"],
Cell[91491, 2652, 529, 12, 22, "Print"],
Cell[92023, 2666, 37, 1, 22, "Print"],
Cell[92063, 2669, 511, 11, 22, "Print"],
Cell[92577, 2682, 509, 11, 22, "Print"],
Cell[93089, 2695, 529, 12, 22, "Print"],
Cell[93621, 2709, 37, 1, 22, "Print"],
Cell[93661, 2712, 511, 11, 22, "Print"],
Cell[94175, 2725, 528, 12, 22, "Print"],
Cell[94706, 2739, 529, 12, 22, "Print"],
Cell[95238, 2753, 37, 1, 22, "Print"],
Cell[95278, 2756, 511, 11, 22, "Print"],
Cell[95792, 2769, 510, 11, 22, "Print"],
Cell[96305, 2782, 529, 12, 22, "Print"],
Cell[96837, 2796, 37, 1, 22, "Print"],
Cell[96877, 2799, 511, 11, 22, "Print"],
Cell[97391, 2812, 510, 11, 22, "Print"],
Cell[97904, 2825, 529, 12, 22, "Print"],
Cell[98436, 2839, 37, 1, 22, "Print"],
Cell[98476, 2842, 511, 11, 22, "Print"],
Cell[98990, 2855, 510, 11, 22, "Print"],
Cell[99503, 2868, 529, 12, 22, "Print"],
Cell[100035, 2882, 37, 1, 22, "Print"],
Cell[100075, 2885, 511, 11, 22, "Print"],
Cell[100589, 2898, 510, 11, 22, "Print"],
Cell[101102, 2911, 529, 12, 22, "Print"],
Cell[101634, 2925, 37, 1, 22, "Print"],
Cell[101674, 2928, 511, 11, 22, "Print"],
Cell[102188, 2941, 509, 11, 22, "Print"],
Cell[102700, 2954, 529, 12, 22, "Print"],
Cell[103232, 2968, 37, 1, 22, "Print"],
Cell[103272, 2971, 510, 11, 22, "Print"],
Cell[103785, 2984, 527, 12, 22, "Print"],
Cell[104315, 2998, 529, 12, 22, "Print"],
Cell[104847, 3012, 37, 1, 22, "Print"],
Cell[104887, 3015, 511, 11, 22, "Print"],
Cell[105401, 3028, 510, 11, 22, "Print"],
Cell[105914, 3041, 528, 12, 22, "Print"],
Cell[106445, 3055, 37, 1, 22, "Print"],
Cell[106485, 3058, 511, 11, 22, "Print"],
Cell[106999, 3071, 510, 11, 22, "Print"],
Cell[107512, 3084, 529, 12, 22, "Print"],
Cell[108044, 3098, 37, 1, 22, "Print"],
Cell[108084, 3101, 511, 11, 22, "Print"],
Cell[108598, 3114, 527, 12, 22, "Print"],
Cell[109128, 3128, 529, 12, 22, "Print"],
Cell[109660, 3142, 37, 1, 22, "Print"],
Cell[109700, 3145, 511, 11, 22, "Print"],
Cell[110214, 3158, 508, 11, 22, "Print"],
Cell[110725, 3171, 529, 12, 22, "Print"],
Cell[111257, 3185, 37, 1, 22, "Print"],
Cell[111297, 3188, 511, 11, 22, "Print"],
Cell[111811, 3201, 510, 11, 22, "Print"],
Cell[112324, 3214, 529, 12, 22, "Print"],
Cell[112856, 3228, 37, 1, 22, "Print"],
Cell[112896, 3231, 510, 11, 22, "Print"],
Cell[113409, 3244, 510, 11, 22, "Print"],
Cell[113922, 3257, 529, 12, 22, "Print"],
Cell[114454, 3271, 37, 1, 22, "Print"],
Cell[114494, 3274, 511, 11, 22, "Print"],
Cell[115008, 3287, 509, 11, 22, "Print"],
Cell[115520, 3300, 529, 12, 22, "Print"],
Cell[116052, 3314, 37, 1, 22, "Print"],
Cell[116092, 3317, 511, 11, 22, "Print"],
Cell[116606, 3330, 511, 11, 22, "Print"],
Cell[117120, 3343, 529, 12, 22, "Print"],
Cell[117652, 3357, 37, 1, 22, "Print"],
Cell[117692, 3360, 511, 11, 22, "Print"],
Cell[118206, 3373, 528, 12, 22, "Print"],
Cell[118737, 3387, 529, 12, 22, "Print"],
Cell[119269, 3401, 37, 1, 22, "Print"],
Cell[119309, 3404, 511, 11, 22, "Print"],
Cell[119823, 3417, 511, 11, 22, "Print"],
Cell[120337, 3430, 529, 12, 22, "Print"],
Cell[120869, 3444, 37, 1, 22, "Print"],
Cell[120909, 3447, 511, 11, 22, "Print"],
Cell[121423, 3460, 511, 11, 22, "Print"],
Cell[121937, 3473, 529, 12, 22, "Print"],
Cell[122469, 3487, 37, 1, 22, "Print"],
Cell[122509, 3490, 511, 11, 22, "Print"],
Cell[123023, 3503, 528, 12, 22, "Print"],
Cell[123554, 3517, 529, 12, 22, "Print"],
Cell[124086, 3531, 37, 1, 22, "Print"],
Cell[124126, 3534, 511, 11, 22, "Print"],
Cell[124640, 3547, 511, 11, 22, "Print"],
Cell[125154, 3560, 529, 12, 22, "Print"],
Cell[125686, 3574, 37, 1, 22, "Print"],
Cell[125726, 3577, 511, 11, 22, "Print"],
Cell[126240, 3590, 511, 11, 22, "Print"],
Cell[126754, 3603, 529, 12, 22, "Print"],
Cell[127286, 3617, 37, 1, 22, "Print"],
Cell[127326, 3620, 511, 11, 22, "Print"],
Cell[127840, 3633, 511, 11, 22, "Print"],
Cell[128354, 3646, 529, 12, 22, "Print"],
Cell[128886, 3660, 37, 1, 22, "Print"],
Cell[128926, 3663, 511, 11, 22, "Print"],
Cell[129440, 3676, 511, 11, 22, "Print"],
Cell[129954, 3689, 529, 12, 22, "Print"],
Cell[130486, 3703, 37, 1, 22, "Print"],
Cell[130526, 3706, 511, 11, 22, "Print"],
Cell[131040, 3719, 511, 11, 22, "Print"],
Cell[131554, 3732, 529, 12, 22, "Print"],
Cell[132086, 3746, 37, 1, 22, "Print"],
Cell[132126, 3749, 511, 11, 22, "Print"],
Cell[132640, 3762, 528, 12, 22, "Print"],
Cell[133171, 3776, 529, 12, 22, "Print"],
Cell[133703, 3790, 37, 1, 22, "Print"],
Cell[133743, 3793, 38, 1, 22, "Print"],
Cell[133784, 3796, 300, 6, 22, "Print"],
Cell[134087, 3804, 310, 6, 22, "Print"],
Cell[134400, 3812, 306, 6, 22, "Print"],
Cell[134709, 3820, 37, 1, 22, "Print"],
Cell[134749, 3823, 300, 6, 22, "Print"],
Cell[135052, 3831, 310, 6, 22, "Print"],
Cell[135365, 3839, 306, 6, 22, "Print"],
Cell[135674, 3847, 37, 1, 22, "Print"],
Cell[135714, 3850, 300, 6, 22, "Print"],
Cell[136017, 3858, 310, 6, 22, "Print"],
Cell[136330, 3866, 306, 6, 22, "Print"],
Cell[136639, 3874, 37, 1, 22, "Print"],
Cell[136679, 3877, 300, 6, 22, "Print"],
Cell[136982, 3885, 310, 6, 22, "Print"],
Cell[137295, 3893, 306, 6, 22, "Print"],
Cell[137604, 3901, 37, 1, 22, "Print"],
Cell[137644, 3904, 300, 6, 22, "Print"],
Cell[137947, 3912, 310, 6, 22, "Print"],
Cell[138260, 3920, 306, 6, 22, "Print"],
Cell[138569, 3928, 37, 1, 22, "Print"],
Cell[138609, 3931, 300, 6, 22, "Print"],
Cell[138912, 3939, 310, 6, 22, "Print"],
Cell[139225, 3947, 306, 6, 22, "Print"],
Cell[139534, 3955, 37, 1, 22, "Print"],
Cell[139574, 3958, 300, 6, 22, "Print"],
Cell[139877, 3966, 310, 6, 22, "Print"],
Cell[140190, 3974, 306, 6, 22, "Print"],
Cell[140499, 3982, 37, 1, 22, "Print"],
Cell[140539, 3985, 300, 6, 22, "Print"],
Cell[140842, 3993, 310, 6, 22, "Print"],
Cell[141155, 4001, 306, 6, 22, "Print"],
Cell[141464, 4009, 37, 1, 22, "Print"],
Cell[141504, 4012, 300, 6, 22, "Print"],
Cell[141807, 4020, 310, 6, 22, "Print"],
Cell[142120, 4028, 306, 6, 22, "Print"],
Cell[142429, 4036, 37, 1, 22, "Print"],
Cell[142469, 4039, 302, 6, 22, "Print"],
Cell[142774, 4047, 312, 6, 22, "Print"],
Cell[143089, 4055, 308, 6, 22, "Print"],
Cell[143400, 4063, 37, 1, 22, "Print"],
Cell[143440, 4066, 302, 6, 22, "Print"],
Cell[143745, 4074, 312, 6, 22, "Print"],
Cell[144060, 4082, 308, 6, 22, "Print"],
Cell[144371, 4090, 37, 1, 22, "Print"],
Cell[144411, 4093, 302, 6, 22, "Print"],
Cell[144716, 4101, 312, 6, 22, "Print"],
Cell[145031, 4109, 308, 6, 22, "Print"],
Cell[145342, 4117, 37, 1, 22, "Print"],
Cell[145382, 4120, 302, 6, 22, "Print"],
Cell[145687, 4128, 312, 6, 22, "Print"],
Cell[146002, 4136, 308, 6, 22, "Print"],
Cell[146313, 4144, 37, 1, 22, "Print"],
Cell[146353, 4147, 302, 6, 22, "Print"],
Cell[146658, 4155, 312, 6, 22, "Print"],
Cell[146973, 4163, 308, 6, 22, "Print"],
Cell[147284, 4171, 37, 1, 22, "Print"],
Cell[147324, 4174, 302, 6, 22, "Print"],
Cell[147629, 4182, 312, 6, 22, "Print"],
Cell[147944, 4190, 308, 6, 22, "Print"],
Cell[148255, 4198, 37, 1, 22, "Print"],
Cell[148295, 4201, 302, 6, 22, "Print"],
Cell[148600, 4209, 312, 6, 22, "Print"],
Cell[148915, 4217, 308, 6, 22, "Print"],
Cell[149226, 4225, 37, 1, 22, "Print"],
Cell[149266, 4228, 302, 6, 22, "Print"],
Cell[149571, 4236, 312, 6, 22, "Print"],
Cell[149886, 4244, 308, 6, 22, "Print"],
Cell[150197, 4252, 37, 1, 22, "Print"],
Cell[150237, 4255, 302, 6, 22, "Print"],
Cell[150542, 4263, 312, 6, 22, "Print"],
Cell[150857, 4271, 308, 6, 22, "Print"],
Cell[151168, 4279, 37, 1, 22, "Print"],
Cell[151208, 4282, 302, 6, 22, "Print"],
Cell[151513, 4290, 312, 6, 22, "Print"],
Cell[151828, 4298, 308, 6, 22, "Print"],
Cell[152139, 4306, 37, 1, 22, "Print"],
Cell[152179, 4309, 302, 6, 22, "Print"],
Cell[152484, 4317, 312, 6, 22, "Print"],
Cell[152799, 4325, 308, 6, 22, "Print"],
Cell[153110, 4333, 37, 1, 22, "Print"],
Cell[153150, 4336, 302, 6, 22, "Print"],
Cell[153455, 4344, 312, 6, 22, "Print"],
Cell[153770, 4352, 308, 6, 22, "Print"],
Cell[154081, 4360, 37, 1, 22, "Print"],
Cell[154121, 4363, 302, 6, 22, "Print"],
Cell[154426, 4371, 312, 6, 22, "Print"],
Cell[154741, 4379, 308, 6, 22, "Print"],
Cell[155052, 4387, 37, 1, 22, "Print"],
Cell[155092, 4390, 302, 6, 22, "Print"],
Cell[155397, 4398, 312, 6, 22, "Print"],
Cell[155712, 4406, 308, 6, 22, "Print"],
Cell[156023, 4414, 37, 1, 22, "Print"],
Cell[156063, 4417, 302, 6, 22, "Print"],
Cell[156368, 4425, 312, 6, 22, "Print"],
Cell[156683, 4433, 308, 6, 22, "Print"],
Cell[156994, 4441, 37, 1, 22, "Print"],
Cell[157034, 4444, 302, 6, 22, "Print"],
Cell[157339, 4452, 312, 6, 22, "Print"],
Cell[157654, 4460, 308, 6, 22, "Print"],
Cell[157965, 4468, 37, 1, 22, "Print"],
Cell[158005, 4471, 302, 6, 22, "Print"],
Cell[158310, 4479, 312, 6, 22, "Print"],
Cell[158625, 4487, 308, 6, 22, "Print"],
Cell[158936, 4495, 37, 1, 22, "Print"],
Cell[158976, 4498, 302, 6, 22, "Print"],
Cell[159281, 4506, 312, 6, 22, "Print"],
Cell[159596, 4514, 308, 6, 22, "Print"],
Cell[159907, 4522, 37, 1, 22, "Print"],
Cell[159947, 4525, 302, 6, 22, "Print"],
Cell[160252, 4533, 312, 6, 22, "Print"],
Cell[160567, 4541, 308, 6, 22, "Print"],
Cell[160878, 4549, 37, 1, 22, "Print"],
Cell[160918, 4552, 302, 6, 22, "Print"],
Cell[161223, 4560, 312, 6, 22, "Print"],
Cell[161538, 4568, 308, 6, 22, "Print"],
Cell[161849, 4576, 37, 1, 22, "Print"],
Cell[161889, 4579, 302, 6, 22, "Print"],
Cell[162194, 4587, 312, 6, 22, "Print"],
Cell[162509, 4595, 308, 6, 22, "Print"],
Cell[162820, 4603, 37, 1, 22, "Print"],
Cell[162860, 4606, 302, 6, 22, "Print"],
Cell[163165, 4614, 312, 6, 22, "Print"],
Cell[163480, 4622, 308, 6, 22, "Print"],
Cell[163791, 4630, 37, 1, 22, "Print"],
Cell[163831, 4633, 302, 6, 22, "Print"],
Cell[164136, 4641, 312, 6, 22, "Print"],
Cell[164451, 4649, 308, 6, 22, "Print"],
Cell[164762, 4657, 37, 1, 22, "Print"],
Cell[164802, 4660, 302, 6, 22, "Print"],
Cell[165107, 4668, 312, 6, 22, "Print"],
Cell[165422, 4676, 308, 6, 22, "Print"],
Cell[165733, 4684, 37, 1, 22, "Print"],
Cell[165773, 4687, 302, 6, 22, "Print"],
Cell[166078, 4695, 312, 6, 22, "Print"],
Cell[166393, 4703, 308, 6, 22, "Print"],
Cell[166704, 4711, 37, 1, 22, "Print"],
Cell[166744, 4714, 302, 6, 22, "Print"],
Cell[167049, 4722, 312, 6, 22, "Print"],
Cell[167364, 4730, 308, 6, 22, "Print"],
Cell[167675, 4738, 37, 1, 22, "Print"],
Cell[167715, 4741, 302, 6, 22, "Print"],
Cell[168020, 4749, 312, 6, 22, "Print"],
Cell[168335, 4757, 308, 6, 22, "Print"],
Cell[168646, 4765, 37, 1, 22, "Print"],
Cell[168686, 4768, 302, 6, 22, "Print"],
Cell[168991, 4776, 312, 6, 22, "Print"],
Cell[169306, 4784, 308, 6, 22, "Print"],
Cell[169617, 4792, 37, 1, 22, "Print"],
Cell[169657, 4795, 302, 6, 22, "Print"],
Cell[169962, 4803, 312, 6, 22, "Print"],
Cell[170277, 4811, 308, 6, 22, "Print"],
Cell[170588, 4819, 37, 1, 22, "Print"],
Cell[170628, 4822, 302, 6, 22, "Print"],
Cell[170933, 4830, 312, 6, 22, "Print"],
Cell[171248, 4838, 308, 6, 22, "Print"],
Cell[171559, 4846, 37, 1, 22, "Print"],
Cell[171599, 4849, 302, 6, 22, "Print"],
Cell[171904, 4857, 312, 6, 22, "Print"],
Cell[172219, 4865, 308, 6, 22, "Print"],
Cell[172530, 4873, 37, 1, 22, "Print"],
Cell[172570, 4876, 302, 6, 22, "Print"],
Cell[172875, 4884, 312, 6, 22, "Print"],
Cell[173190, 4892, 308, 6, 22, "Print"],
Cell[173501, 4900, 37, 1, 22, "Print"],
Cell[173541, 4903, 302, 6, 22, "Print"],
Cell[173846, 4911, 312, 6, 22, "Print"],
Cell[174161, 4919, 308, 6, 22, "Print"],
Cell[174472, 4927, 37, 1, 22, "Print"],
Cell[174512, 4930, 302, 6, 22, "Print"],
Cell[174817, 4938, 312, 6, 22, "Print"],
Cell[175132, 4946, 308, 6, 22, "Print"],
Cell[175443, 4954, 37, 1, 22, "Print"],
Cell[175483, 4957, 302, 6, 22, "Print"],
Cell[175788, 4965, 312, 6, 22, "Print"],
Cell[176103, 4973, 308, 6, 22, "Print"],
Cell[176414, 4981, 37, 1, 22, "Print"],
Cell[176454, 4984, 302, 6, 22, "Print"],
Cell[176759, 4992, 312, 6, 22, "Print"],
Cell[177074, 5000, 308, 6, 22, "Print"],
Cell[177385, 5008, 37, 1, 22, "Print"],
Cell[177425, 5011, 302, 6, 22, "Print"],
Cell[177730, 5019, 312, 6, 22, "Print"],
Cell[178045, 5027, 308, 6, 22, "Print"],
Cell[178356, 5035, 37, 1, 22, "Print"],
Cell[178396, 5038, 302, 6, 22, "Print"],
Cell[178701, 5046, 312, 6, 22, "Print"],
Cell[179016, 5054, 308, 6, 22, "Print"],
Cell[179327, 5062, 37, 1, 22, "Print"],
Cell[179367, 5065, 38, 1, 22, "Print"],
Cell[179408, 5068, 300, 6, 22, "Print"],
Cell[179711, 5076, 310, 6, 22, "Print"],
Cell[180024, 5084, 306, 6, 22, "Print"],
Cell[180333, 5092, 37, 1, 22, "Print"],
Cell[180373, 5095, 300, 6, 22, "Print"],
Cell[180676, 5103, 310, 6, 22, "Print"],
Cell[180989, 5111, 306, 6, 22, "Print"],
Cell[181298, 5119, 37, 1, 22, "Print"],
Cell[181338, 5122, 300, 6, 22, "Print"],
Cell[181641, 5130, 310, 6, 22, "Print"],
Cell[181954, 5138, 306, 6, 22, "Print"],
Cell[182263, 5146, 37, 1, 22, "Print"],
Cell[182303, 5149, 300, 6, 22, "Print"],
Cell[182606, 5157, 310, 6, 22, "Print"],
Cell[182919, 5165, 306, 6, 22, "Print"],
Cell[183228, 5173, 37, 1, 22, "Print"],
Cell[183268, 5176, 300, 6, 22, "Print"],
Cell[183571, 5184, 310, 6, 22, "Print"],
Cell[183884, 5192, 306, 6, 22, "Print"],
Cell[184193, 5200, 37, 1, 22, "Print"],
Cell[184233, 5203, 300, 6, 22, "Print"],
Cell[184536, 5211, 310, 6, 22, "Print"],
Cell[184849, 5219, 306, 6, 22, "Print"],
Cell[185158, 5227, 37, 1, 22, "Print"],
Cell[185198, 5230, 300, 6, 22, "Print"],
Cell[185501, 5238, 310, 6, 22, "Print"],
Cell[185814, 5246, 306, 6, 22, "Print"],
Cell[186123, 5254, 37, 1, 22, "Print"],
Cell[186163, 5257, 300, 6, 22, "Print"],
Cell[186466, 5265, 310, 6, 22, "Print"],
Cell[186779, 5273, 306, 6, 22, "Print"],
Cell[187088, 5281, 37, 1, 22, "Print"],
Cell[187128, 5284, 300, 6, 22, "Print"],
Cell[187431, 5292, 310, 6, 22, "Print"],
Cell[187744, 5300, 306, 6, 22, "Print"],
Cell[188053, 5308, 37, 1, 22, "Print"],
Cell[188093, 5311, 302, 6, 22, "Print"],
Cell[188398, 5319, 312, 6, 22, "Print"],
Cell[188713, 5327, 308, 6, 22, "Print"],
Cell[189024, 5335, 37, 1, 22, "Print"],
Cell[189064, 5338, 302, 6, 22, "Print"],
Cell[189369, 5346, 312, 6, 22, "Print"],
Cell[189684, 5354, 308, 6, 22, "Print"],
Cell[189995, 5362, 37, 1, 22, "Print"],
Cell[190035, 5365, 302, 6, 22, "Print"],
Cell[190340, 5373, 312, 6, 22, "Print"],
Cell[190655, 5381, 308, 6, 22, "Print"],
Cell[190966, 5389, 37, 1, 22, "Print"],
Cell[191006, 5392, 302, 6, 22, "Print"],
Cell[191311, 5400, 312, 6, 22, "Print"],
Cell[191626, 5408, 308, 6, 22, "Print"],
Cell[191937, 5416, 37, 1, 22, "Print"],
Cell[191977, 5419, 302, 6, 22, "Print"],
Cell[192282, 5427, 312, 6, 22, "Print"],
Cell[192597, 5435, 308, 6, 22, "Print"],
Cell[192908, 5443, 37, 1, 22, "Print"],
Cell[192948, 5446, 302, 6, 22, "Print"],
Cell[193253, 5454, 312, 6, 22, "Print"],
Cell[193568, 5462, 308, 6, 22, "Print"],
Cell[193879, 5470, 37, 1, 22, "Print"],
Cell[193919, 5473, 302, 6, 22, "Print"],
Cell[194224, 5481, 312, 6, 22, "Print"],
Cell[194539, 5489, 308, 6, 22, "Print"],
Cell[194850, 5497, 37, 1, 22, "Print"],
Cell[194890, 5500, 302, 6, 22, "Print"],
Cell[195195, 5508, 312, 6, 22, "Print"],
Cell[195510, 5516, 308, 6, 22, "Print"],
Cell[195821, 5524, 37, 1, 22, "Print"],
Cell[195861, 5527, 302, 6, 22, "Print"],
Cell[196166, 5535, 312, 6, 22, "Print"],
Cell[196481, 5543, 308, 6, 22, "Print"],
Cell[196792, 5551, 37, 1, 22, "Print"],
Cell[196832, 5554, 302, 6, 22, "Print"],
Cell[197137, 5562, 312, 6, 22, "Print"],
Cell[197452, 5570, 308, 6, 22, "Print"],
Cell[197763, 5578, 37, 1, 22, "Print"],
Cell[197803, 5581, 302, 6, 22, "Print"],
Cell[198108, 5589, 312, 6, 22, "Print"],
Cell[198423, 5597, 308, 6, 22, "Print"],
Cell[198734, 5605, 37, 1, 22, "Print"],
Cell[198774, 5608, 302, 6, 22, "Print"],
Cell[199079, 5616, 312, 6, 22, "Print"],
Cell[199394, 5624, 308, 6, 22, "Print"],
Cell[199705, 5632, 37, 1, 22, "Print"],
Cell[199745, 5635, 302, 6, 22, "Print"],
Cell[200050, 5643, 312, 6, 22, "Print"],
Cell[200365, 5651, 308, 6, 22, "Print"],
Cell[200676, 5659, 37, 1, 22, "Print"],
Cell[200716, 5662, 302, 6, 22, "Print"],
Cell[201021, 5670, 312, 6, 22, "Print"],
Cell[201336, 5678, 308, 6, 22, "Print"],
Cell[201647, 5686, 37, 1, 22, "Print"],
Cell[201687, 5689, 302, 6, 22, "Print"],
Cell[201992, 5697, 312, 6, 22, "Print"],
Cell[202307, 5705, 308, 6, 22, "Print"],
Cell[202618, 5713, 37, 1, 22, "Print"],
Cell[202658, 5716, 302, 6, 22, "Print"],
Cell[202963, 5724, 312, 6, 22, "Print"],
Cell[203278, 5732, 308, 6, 22, "Print"],
Cell[203589, 5740, 37, 1, 22, "Print"],
Cell[203629, 5743, 302, 6, 22, "Print"],
Cell[203934, 5751, 312, 6, 22, "Print"],
Cell[204249, 5759, 308, 6, 22, "Print"],
Cell[204560, 5767, 37, 1, 22, "Print"],
Cell[204600, 5770, 302, 6, 22, "Print"],
Cell[204905, 5778, 312, 6, 22, "Print"],
Cell[205220, 5786, 308, 6, 22, "Print"],
Cell[205531, 5794, 37, 1, 22, "Print"],
Cell[205571, 5797, 302, 6, 22, "Print"],
Cell[205876, 5805, 312, 6, 22, "Print"],
Cell[206191, 5813, 308, 6, 22, "Print"],
Cell[206502, 5821, 37, 1, 22, "Print"],
Cell[206542, 5824, 302, 6, 22, "Print"],
Cell[206847, 5832, 312, 6, 22, "Print"],
Cell[207162, 5840, 308, 6, 22, "Print"],
Cell[207473, 5848, 37, 1, 22, "Print"],
Cell[207513, 5851, 302, 6, 22, "Print"],
Cell[207818, 5859, 312, 6, 22, "Print"],
Cell[208133, 5867, 308, 6, 22, "Print"],
Cell[208444, 5875, 37, 1, 22, "Print"],
Cell[208484, 5878, 302, 6, 22, "Print"],
Cell[208789, 5886, 312, 6, 22, "Print"],
Cell[209104, 5894, 308, 6, 22, "Print"],
Cell[209415, 5902, 37, 1, 22, "Print"],
Cell[209455, 5905, 302, 6, 22, "Print"],
Cell[209760, 5913, 312, 6, 22, "Print"],
Cell[210075, 5921, 308, 6, 22, "Print"],
Cell[210386, 5929, 37, 1, 22, "Print"],
Cell[210426, 5932, 302, 6, 22, "Print"],
Cell[210731, 5940, 312, 6, 22, "Print"],
Cell[211046, 5948, 308, 6, 22, "Print"],
Cell[211357, 5956, 37, 1, 22, "Print"],
Cell[211397, 5959, 302, 6, 22, "Print"],
Cell[211702, 5967, 312, 6, 22, "Print"],
Cell[212017, 5975, 308, 6, 22, "Print"],
Cell[212328, 5983, 37, 1, 22, "Print"],
Cell[212368, 5986, 302, 6, 22, "Print"],
Cell[212673, 5994, 312, 6, 22, "Print"],
Cell[212988, 6002, 308, 6, 22, "Print"],
Cell[213299, 6010, 37, 1, 22, "Print"],
Cell[213339, 6013, 302, 6, 22, "Print"],
Cell[213644, 6021, 312, 6, 22, "Print"],
Cell[213959, 6029, 308, 6, 22, "Print"],
Cell[214270, 6037, 37, 1, 22, "Print"],
Cell[214310, 6040, 302, 6, 22, "Print"],
Cell[214615, 6048, 312, 6, 22, "Print"],
Cell[214930, 6056, 308, 6, 22, "Print"],
Cell[215241, 6064, 37, 1, 22, "Print"],
Cell[215281, 6067, 302, 6, 22, "Print"],
Cell[215586, 6075, 312, 6, 22, "Print"],
Cell[215901, 6083, 308, 6, 22, "Print"],
Cell[216212, 6091, 37, 1, 22, "Print"],
Cell[216252, 6094, 302, 6, 22, "Print"],
Cell[216557, 6102, 312, 6, 22, "Print"],
Cell[216872, 6110, 308, 6, 22, "Print"],
Cell[217183, 6118, 37, 1, 22, "Print"],
Cell[217223, 6121, 302, 6, 22, "Print"],
Cell[217528, 6129, 312, 6, 22, "Print"],
Cell[217843, 6137, 308, 6, 22, "Print"],
Cell[218154, 6145, 37, 1, 22, "Print"],
Cell[218194, 6148, 302, 6, 22, "Print"],
Cell[218499, 6156, 312, 6, 22, "Print"],
Cell[218814, 6164, 308, 6, 22, "Print"],
Cell[219125, 6172, 37, 1, 22, "Print"],
Cell[219165, 6175, 302, 6, 22, "Print"],
Cell[219470, 6183, 312, 6, 22, "Print"],
Cell[219785, 6191, 308, 6, 22, "Print"],
Cell[220096, 6199, 37, 1, 22, "Print"],
Cell[220136, 6202, 302, 6, 22, "Print"],
Cell[220441, 6210, 312, 6, 22, "Print"],
Cell[220756, 6218, 308, 6, 22, "Print"],
Cell[221067, 6226, 37, 1, 22, "Print"],
Cell[221107, 6229, 302, 6, 22, "Print"],
Cell[221412, 6237, 312, 6, 22, "Print"],
Cell[221727, 6245, 308, 6, 22, "Print"],
Cell[222038, 6253, 37, 1, 22, "Print"],
Cell[222078, 6256, 302, 6, 22, "Print"],
Cell[222383, 6264, 312, 6, 22, "Print"],
Cell[222698, 6272, 308, 6, 22, "Print"],
Cell[223009, 6280, 37, 1, 22, "Print"],
Cell[223049, 6283, 302, 6, 22, "Print"],
Cell[223354, 6291, 312, 6, 22, "Print"],
Cell[223669, 6299, 308, 6, 22, "Print"],
Cell[223980, 6307, 37, 1, 22, "Print"],
Cell[224020, 6310, 302, 6, 22, "Print"],
Cell[224325, 6318, 312, 6, 22, "Print"],
Cell[224640, 6326, 308, 6, 22, "Print"],
Cell[224951, 6334, 37, 1, 22, "Print"],
Cell[224991, 6337, 302, 6, 22, "Print"],
Cell[225296, 6345, 312, 6, 22, "Print"],
Cell[225611, 6353, 308, 6, 22, "Print"],
Cell[225922, 6361, 37, 1, 22, "Print"],
Cell[225962, 6364, 38, 1, 22, "Print"],
Cell[226003, 6367, 300, 6, 22, "Print"],
Cell[226306, 6375, 310, 6, 22, "Print"],
Cell[226619, 6383, 306, 6, 22, "Print"],
Cell[226928, 6391, 37, 1, 22, "Print"],
Cell[226968, 6394, 300, 6, 22, "Print"],
Cell[227271, 6402, 310, 6, 22, "Print"],
Cell[227584, 6410, 306, 6, 22, "Print"],
Cell[227893, 6418, 37, 1, 22, "Print"],
Cell[227933, 6421, 300, 6, 22, "Print"],
Cell[228236, 6429, 310, 6, 22, "Print"],
Cell[228549, 6437, 306, 6, 22, "Print"],
Cell[228858, 6445, 37, 1, 22, "Print"],
Cell[228898, 6448, 300, 6, 22, "Print"],
Cell[229201, 6456, 310, 6, 22, "Print"],
Cell[229514, 6464, 306, 6, 22, "Print"],
Cell[229823, 6472, 37, 1, 22, "Print"],
Cell[229863, 6475, 300, 6, 22, "Print"],
Cell[230166, 6483, 310, 6, 22, "Print"],
Cell[230479, 6491, 306, 6, 22, "Print"],
Cell[230788, 6499, 37, 1, 22, "Print"],
Cell[230828, 6502, 300, 6, 22, "Print"],
Cell[231131, 6510, 310, 6, 22, "Print"],
Cell[231444, 6518, 306, 6, 22, "Print"],
Cell[231753, 6526, 37, 1, 22, "Print"],
Cell[231793, 6529, 300, 6, 22, "Print"],
Cell[232096, 6537, 310, 6, 22, "Print"],
Cell[232409, 6545, 306, 6, 22, "Print"],
Cell[232718, 6553, 37, 1, 22, "Print"],
Cell[232758, 6556, 300, 6, 22, "Print"],
Cell[233061, 6564, 310, 6, 22, "Print"],
Cell[233374, 6572, 306, 6, 22, "Print"],
Cell[233683, 6580, 37, 1, 22, "Print"],
Cell[233723, 6583, 300, 6, 22, "Print"],
Cell[234026, 6591, 310, 6, 22, "Print"],
Cell[234339, 6599, 306, 6, 22, "Print"],
Cell[234648, 6607, 37, 1, 22, "Print"],
Cell[234688, 6610, 302, 6, 22, "Print"],
Cell[234993, 6618, 312, 6, 22, "Print"],
Cell[235308, 6626, 308, 6, 22, "Print"],
Cell[235619, 6634, 37, 1, 22, "Print"],
Cell[235659, 6637, 302, 6, 22, "Print"],
Cell[235964, 6645, 312, 6, 22, "Print"],
Cell[236279, 6653, 308, 6, 22, "Print"],
Cell[236590, 6661, 37, 1, 22, "Print"],
Cell[236630, 6664, 302, 6, 22, "Print"],
Cell[236935, 6672, 312, 6, 22, "Print"],
Cell[237250, 6680, 308, 6, 22, "Print"],
Cell[237561, 6688, 37, 1, 22, "Print"],
Cell[237601, 6691, 302, 6, 22, "Print"],
Cell[237906, 6699, 312, 6, 22, "Print"],
Cell[238221, 6707, 308, 6, 22, "Print"],
Cell[238532, 6715, 37, 1, 22, "Print"],
Cell[238572, 6718, 302, 6, 22, "Print"],
Cell[238877, 6726, 312, 6, 22, "Print"],
Cell[239192, 6734, 308, 6, 22, "Print"],
Cell[239503, 6742, 37, 1, 22, "Print"],
Cell[239543, 6745, 302, 6, 22, "Print"],
Cell[239848, 6753, 312, 6, 22, "Print"],
Cell[240163, 6761, 308, 6, 22, "Print"],
Cell[240474, 6769, 37, 1, 22, "Print"],
Cell[240514, 6772, 302, 6, 22, "Print"],
Cell[240819, 6780, 312, 6, 22, "Print"],
Cell[241134, 6788, 308, 6, 22, "Print"],
Cell[241445, 6796, 37, 1, 22, "Print"],
Cell[241485, 6799, 302, 6, 22, "Print"],
Cell[241790, 6807, 312, 6, 22, "Print"],
Cell[242105, 6815, 308, 6, 22, "Print"],
Cell[242416, 6823, 37, 1, 22, "Print"],
Cell[242456, 6826, 302, 6, 22, "Print"],
Cell[242761, 6834, 312, 6, 22, "Print"],
Cell[243076, 6842, 308, 6, 22, "Print"],
Cell[243387, 6850, 37, 1, 22, "Print"],
Cell[243427, 6853, 302, 6, 22, "Print"],
Cell[243732, 6861, 312, 6, 22, "Print"],
Cell[244047, 6869, 308, 6, 22, "Print"],
Cell[244358, 6877, 37, 1, 22, "Print"],
Cell[244398, 6880, 302, 6, 22, "Print"],
Cell[244703, 6888, 312, 6, 22, "Print"],
Cell[245018, 6896, 308, 6, 22, "Print"],
Cell[245329, 6904, 37, 1, 22, "Print"],
Cell[245369, 6907, 302, 6, 22, "Print"],
Cell[245674, 6915, 312, 6, 22, "Print"],
Cell[245989, 6923, 308, 6, 22, "Print"],
Cell[246300, 6931, 37, 1, 22, "Print"],
Cell[246340, 6934, 302, 6, 22, "Print"],
Cell[246645, 6942, 312, 6, 22, "Print"],
Cell[246960, 6950, 308, 6, 22, "Print"],
Cell[247271, 6958, 37, 1, 22, "Print"],
Cell[247311, 6961, 302, 6, 22, "Print"],
Cell[247616, 6969, 312, 6, 22, "Print"],
Cell[247931, 6977, 308, 6, 22, "Print"],
Cell[248242, 6985, 37, 1, 22, "Print"],
Cell[248282, 6988, 302, 6, 22, "Print"],
Cell[248587, 6996, 312, 6, 22, "Print"],
Cell[248902, 7004, 308, 6, 22, "Print"],
Cell[249213, 7012, 37, 1, 22, "Print"],
Cell[249253, 7015, 302, 6, 22, "Print"],
Cell[249558, 7023, 312, 6, 22, "Print"],
Cell[249873, 7031, 308, 6, 22, "Print"],
Cell[250184, 7039, 37, 1, 22, "Print"],
Cell[250224, 7042, 302, 6, 22, "Print"],
Cell[250529, 7050, 312, 6, 22, "Print"],
Cell[250844, 7058, 308, 6, 22, "Print"],
Cell[251155, 7066, 37, 1, 22, "Print"],
Cell[251195, 7069, 302, 6, 22, "Print"],
Cell[251500, 7077, 312, 6, 22, "Print"],
Cell[251815, 7085, 308, 6, 22, "Print"],
Cell[252126, 7093, 37, 1, 22, "Print"],
Cell[252166, 7096, 302, 6, 22, "Print"],
Cell[252471, 7104, 312, 6, 22, "Print"],
Cell[252786, 7112, 308, 6, 22, "Print"],
Cell[253097, 7120, 37, 1, 22, "Print"],
Cell[253137, 7123, 302, 6, 22, "Print"],
Cell[253442, 7131, 312, 6, 22, "Print"],
Cell[253757, 7139, 308, 6, 22, "Print"],
Cell[254068, 7147, 37, 1, 22, "Print"],
Cell[254108, 7150, 302, 6, 22, "Print"],
Cell[254413, 7158, 312, 6, 22, "Print"],
Cell[254728, 7166, 308, 6, 22, "Print"],
Cell[255039, 7174, 37, 1, 22, "Print"],
Cell[255079, 7177, 302, 6, 22, "Print"],
Cell[255384, 7185, 312, 6, 22, "Print"],
Cell[255699, 7193, 308, 6, 22, "Print"],
Cell[256010, 7201, 37, 1, 22, "Print"],
Cell[256050, 7204, 302, 6, 22, "Print"],
Cell[256355, 7212, 312, 6, 22, "Print"],
Cell[256670, 7220, 308, 6, 22, "Print"],
Cell[256981, 7228, 37, 1, 22, "Print"],
Cell[257021, 7231, 302, 6, 22, "Print"],
Cell[257326, 7239, 312, 6, 22, "Print"],
Cell[257641, 7247, 308, 6, 22, "Print"],
Cell[257952, 7255, 37, 1, 22, "Print"],
Cell[257992, 7258, 302, 6, 22, "Print"],
Cell[258297, 7266, 312, 6, 22, "Print"],
Cell[258612, 7274, 308, 6, 22, "Print"],
Cell[258923, 7282, 37, 1, 22, "Print"],
Cell[258963, 7285, 302, 6, 22, "Print"],
Cell[259268, 7293, 312, 6, 22, "Print"],
Cell[259583, 7301, 308, 6, 22, "Print"],
Cell[259894, 7309, 37, 1, 22, "Print"],
Cell[259934, 7312, 302, 6, 22, "Print"],
Cell[260239, 7320, 312, 6, 22, "Print"],
Cell[260554, 7328, 308, 6, 22, "Print"],
Cell[260865, 7336, 37, 1, 22, "Print"],
Cell[260905, 7339, 302, 6, 22, "Print"],
Cell[261210, 7347, 312, 6, 22, "Print"],
Cell[261525, 7355, 308, 6, 22, "Print"],
Cell[261836, 7363, 37, 1, 22, "Print"],
Cell[261876, 7366, 302, 6, 22, "Print"],
Cell[262181, 7374, 312, 6, 22, "Print"],
Cell[262496, 7382, 308, 6, 22, "Print"],
Cell[262807, 7390, 37, 1, 22, "Print"],
Cell[262847, 7393, 302, 6, 22, "Print"],
Cell[263152, 7401, 312, 6, 22, "Print"],
Cell[263467, 7409, 308, 6, 22, "Print"],
Cell[263778, 7417, 37, 1, 22, "Print"],
Cell[263818, 7420, 302, 6, 22, "Print"],
Cell[264123, 7428, 312, 6, 22, "Print"],
Cell[264438, 7436, 308, 6, 22, "Print"],
Cell[264749, 7444, 37, 1, 22, "Print"],
Cell[264789, 7447, 302, 6, 22, "Print"],
Cell[265094, 7455, 312, 6, 22, "Print"],
Cell[265409, 7463, 308, 6, 22, "Print"],
Cell[265720, 7471, 37, 1, 22, "Print"],
Cell[265760, 7474, 302, 6, 22, "Print"],
Cell[266065, 7482, 312, 6, 22, "Print"],
Cell[266380, 7490, 308, 6, 22, "Print"],
Cell[266691, 7498, 37, 1, 22, "Print"],
Cell[266731, 7501, 302, 6, 22, "Print"],
Cell[267036, 7509, 312, 6, 22, "Print"],
Cell[267351, 7517, 308, 6, 22, "Print"],
Cell[267662, 7525, 37, 1, 22, "Print"],
Cell[267702, 7528, 302, 6, 22, "Print"],
Cell[268007, 7536, 312, 6, 22, "Print"],
Cell[268322, 7544, 308, 6, 22, "Print"],
Cell[268633, 7552, 37, 1, 22, "Print"],
Cell[268673, 7555, 302, 6, 22, "Print"],
Cell[268978, 7563, 312, 6, 22, "Print"],
Cell[269293, 7571, 308, 6, 22, "Print"],
Cell[269604, 7579, 37, 1, 22, "Print"],
Cell[269644, 7582, 302, 6, 22, "Print"],
Cell[269949, 7590, 312, 6, 22, "Print"],
Cell[270264, 7598, 308, 6, 22, "Print"],
Cell[270575, 7606, 37, 1, 22, "Print"],
Cell[270615, 7609, 302, 6, 22, "Print"],
Cell[270920, 7617, 312, 6, 22, "Print"],
Cell[271235, 7625, 308, 6, 22, "Print"],
Cell[271546, 7633, 37, 1, 22, "Print"],
Cell[271586, 7636, 302, 6, 22, "Print"],
Cell[271891, 7644, 312, 6, 22, "Print"],
Cell[272206, 7652, 308, 6, 22, "Print"],
Cell[272517, 7660, 37, 1, 22, "Print"],
Cell[272557, 7663, 302, 6, 22, "Print"],
Cell[272862, 7671, 312, 6, 22, "Print"],
Cell[273177, 7679, 308, 6, 22, "Print"],
Cell[273488, 7687, 37, 1, 22, "Print"],
Cell[273528, 7690, 38, 1, 22, "Print"],
Cell[273569, 7693, 300, 6, 22, "Print"],
Cell[273872, 7701, 310, 6, 22, "Print"],
Cell[274185, 7709, 306, 6, 22, "Print"],
Cell[274494, 7717, 37, 1, 22, "Print"],
Cell[274534, 7720, 300, 6, 22, "Print"],
Cell[274837, 7728, 310, 6, 22, "Print"],
Cell[275150, 7736, 306, 6, 22, "Print"],
Cell[275459, 7744, 37, 1, 22, "Print"],
Cell[275499, 7747, 300, 6, 22, "Print"],
Cell[275802, 7755, 310, 6, 22, "Print"],
Cell[276115, 7763, 306, 6, 22, "Print"],
Cell[276424, 7771, 37, 1, 22, "Print"],
Cell[276464, 7774, 300, 6, 22, "Print"],
Cell[276767, 7782, 310, 6, 22, "Print"],
Cell[277080, 7790, 306, 6, 22, "Print"],
Cell[277389, 7798, 37, 1, 22, "Print"],
Cell[277429, 7801, 300, 6, 22, "Print"],
Cell[277732, 7809, 310, 6, 22, "Print"],
Cell[278045, 7817, 306, 6, 22, "Print"],
Cell[278354, 7825, 37, 1, 22, "Print"],
Cell[278394, 7828, 300, 6, 22, "Print"],
Cell[278697, 7836, 310, 6, 22, "Print"],
Cell[279010, 7844, 306, 6, 22, "Print"],
Cell[279319, 7852, 37, 1, 22, "Print"],
Cell[279359, 7855, 300, 6, 22, "Print"],
Cell[279662, 7863, 310, 6, 22, "Print"],
Cell[279975, 7871, 306, 6, 22, "Print"],
Cell[280284, 7879, 37, 1, 22, "Print"],
Cell[280324, 7882, 300, 6, 22, "Print"],
Cell[280627, 7890, 310, 6, 22, "Print"],
Cell[280940, 7898, 306, 6, 22, "Print"],
Cell[281249, 7906, 37, 1, 22, "Print"],
Cell[281289, 7909, 300, 6, 22, "Print"],
Cell[281592, 7917, 310, 6, 22, "Print"],
Cell[281905, 7925, 306, 6, 22, "Print"],
Cell[282214, 7933, 37, 1, 22, "Print"],
Cell[282254, 7936, 302, 6, 22, "Print"],
Cell[282559, 7944, 312, 6, 22, "Print"],
Cell[282874, 7952, 308, 6, 22, "Print"],
Cell[283185, 7960, 37, 1, 22, "Print"],
Cell[283225, 7963, 302, 6, 22, "Print"],
Cell[283530, 7971, 312, 6, 22, "Print"],
Cell[283845, 7979, 308, 6, 22, "Print"],
Cell[284156, 7987, 37, 1, 22, "Print"],
Cell[284196, 7990, 302, 6, 22, "Print"],
Cell[284501, 7998, 312, 6, 22, "Print"],
Cell[284816, 8006, 308, 6, 22, "Print"],
Cell[285127, 8014, 37, 1, 22, "Print"],
Cell[285167, 8017, 302, 6, 22, "Print"],
Cell[285472, 8025, 312, 6, 22, "Print"],
Cell[285787, 8033, 308, 6, 22, "Print"],
Cell[286098, 8041, 37, 1, 22, "Print"],
Cell[286138, 8044, 302, 6, 22, "Print"],
Cell[286443, 8052, 312, 6, 22, "Print"],
Cell[286758, 8060, 308, 6, 22, "Print"],
Cell[287069, 8068, 37, 1, 22, "Print"],
Cell[287109, 8071, 302, 6, 22, "Print"],
Cell[287414, 8079, 312, 6, 22, "Print"],
Cell[287729, 8087, 308, 6, 22, "Print"],
Cell[288040, 8095, 37, 1, 22, "Print"],
Cell[288080, 8098, 302, 6, 22, "Print"],
Cell[288385, 8106, 312, 6, 22, "Print"],
Cell[288700, 8114, 308, 6, 22, "Print"],
Cell[289011, 8122, 37, 1, 22, "Print"],
Cell[289051, 8125, 302, 6, 22, "Print"],
Cell[289356, 8133, 312, 6, 22, "Print"],
Cell[289671, 8141, 308, 6, 22, "Print"],
Cell[289982, 8149, 37, 1, 22, "Print"],
Cell[290022, 8152, 302, 6, 22, "Print"],
Cell[290327, 8160, 312, 6, 22, "Print"],
Cell[290642, 8168, 308, 6, 22, "Print"],
Cell[290953, 8176, 37, 1, 22, "Print"],
Cell[290993, 8179, 302, 6, 22, "Print"],
Cell[291298, 8187, 312, 6, 22, "Print"],
Cell[291613, 8195, 308, 6, 22, "Print"],
Cell[291924, 8203, 37, 1, 22, "Print"],
Cell[291964, 8206, 302, 6, 22, "Print"],
Cell[292269, 8214, 312, 6, 22, "Print"],
Cell[292584, 8222, 308, 6, 22, "Print"],
Cell[292895, 8230, 37, 1, 22, "Print"],
Cell[292935, 8233, 302, 6, 22, "Print"],
Cell[293240, 8241, 312, 6, 22, "Print"],
Cell[293555, 8249, 308, 6, 22, "Print"],
Cell[293866, 8257, 37, 1, 22, "Print"],
Cell[293906, 8260, 302, 6, 22, "Print"],
Cell[294211, 8268, 312, 6, 22, "Print"],
Cell[294526, 8276, 308, 6, 22, "Print"],
Cell[294837, 8284, 37, 1, 22, "Print"],
Cell[294877, 8287, 302, 6, 22, "Print"],
Cell[295182, 8295, 312, 6, 22, "Print"],
Cell[295497, 8303, 308, 6, 22, "Print"],
Cell[295808, 8311, 37, 1, 22, "Print"],
Cell[295848, 8314, 302, 6, 22, "Print"],
Cell[296153, 8322, 312, 6, 22, "Print"],
Cell[296468, 8330, 308, 6, 22, "Print"],
Cell[296779, 8338, 37, 1, 22, "Print"],
Cell[296819, 8341, 302, 6, 22, "Print"],
Cell[297124, 8349, 312, 6, 22, "Print"],
Cell[297439, 8357, 308, 6, 22, "Print"],
Cell[297750, 8365, 37, 1, 22, "Print"],
Cell[297790, 8368, 302, 6, 22, "Print"],
Cell[298095, 8376, 312, 6, 22, "Print"],
Cell[298410, 8384, 308, 6, 22, "Print"],
Cell[298721, 8392, 37, 1, 22, "Print"],
Cell[298761, 8395, 302, 6, 22, "Print"],
Cell[299066, 8403, 312, 6, 22, "Print"],
Cell[299381, 8411, 308, 6, 22, "Print"],
Cell[299692, 8419, 37, 1, 22, "Print"],
Cell[299732, 8422, 302, 6, 22, "Print"],
Cell[300037, 8430, 312, 6, 22, "Print"],
Cell[300352, 8438, 308, 6, 22, "Print"],
Cell[300663, 8446, 37, 1, 22, "Print"],
Cell[300703, 8449, 302, 6, 22, "Print"],
Cell[301008, 8457, 312, 6, 22, "Print"],
Cell[301323, 8465, 308, 6, 22, "Print"],
Cell[301634, 8473, 37, 1, 22, "Print"],
Cell[301674, 8476, 302, 6, 22, "Print"],
Cell[301979, 8484, 312, 6, 22, "Print"],
Cell[302294, 8492, 308, 6, 22, "Print"],
Cell[302605, 8500, 37, 1, 22, "Print"],
Cell[302645, 8503, 302, 6, 22, "Print"],
Cell[302950, 8511, 312, 6, 22, "Print"],
Cell[303265, 8519, 308, 6, 22, "Print"],
Cell[303576, 8527, 37, 1, 22, "Print"],
Cell[303616, 8530, 302, 6, 22, "Print"],
Cell[303921, 8538, 312, 6, 22, "Print"],
Cell[304236, 8546, 308, 6, 22, "Print"],
Cell[304547, 8554, 37, 1, 22, "Print"],
Cell[304587, 8557, 302, 6, 22, "Print"],
Cell[304892, 8565, 312, 6, 22, "Print"],
Cell[305207, 8573, 308, 6, 22, "Print"],
Cell[305518, 8581, 37, 1, 22, "Print"],
Cell[305558, 8584, 302, 6, 22, "Print"],
Cell[305863, 8592, 312, 6, 22, "Print"],
Cell[306178, 8600, 308, 6, 22, "Print"],
Cell[306489, 8608, 37, 1, 22, "Print"],
Cell[306529, 8611, 302, 6, 22, "Print"],
Cell[306834, 8619, 312, 6, 22, "Print"],
Cell[307149, 8627, 308, 6, 22, "Print"],
Cell[307460, 8635, 37, 1, 22, "Print"],
Cell[307500, 8638, 302, 6, 22, "Print"],
Cell[307805, 8646, 312, 6, 22, "Print"],
Cell[308120, 8654, 308, 6, 22, "Print"],
Cell[308431, 8662, 37, 1, 22, "Print"],
Cell[308471, 8665, 302, 6, 22, "Print"],
Cell[308776, 8673, 312, 6, 22, "Print"],
Cell[309091, 8681, 308, 6, 22, "Print"],
Cell[309402, 8689, 37, 1, 22, "Print"],
Cell[309442, 8692, 302, 6, 22, "Print"],
Cell[309747, 8700, 312, 6, 22, "Print"],
Cell[310062, 8708, 308, 6, 22, "Print"],
Cell[310373, 8716, 37, 1, 22, "Print"],
Cell[310413, 8719, 302, 6, 22, "Print"],
Cell[310718, 8727, 312, 6, 22, "Print"],
Cell[311033, 8735, 308, 6, 22, "Print"],
Cell[311344, 8743, 37, 1, 22, "Print"],
Cell[311384, 8746, 302, 6, 22, "Print"],
Cell[311689, 8754, 312, 6, 22, "Print"],
Cell[312004, 8762, 308, 6, 22, "Print"],
Cell[312315, 8770, 37, 1, 22, "Print"],
Cell[312355, 8773, 302, 6, 22, "Print"],
Cell[312660, 8781, 312, 6, 22, "Print"],
Cell[312975, 8789, 308, 6, 22, "Print"],
Cell[313286, 8797, 37, 1, 22, "Print"],
Cell[313326, 8800, 302, 6, 22, "Print"],
Cell[313631, 8808, 312, 6, 22, "Print"],
Cell[313946, 8816, 308, 6, 22, "Print"],
Cell[314257, 8824, 37, 1, 22, "Print"],
Cell[314297, 8827, 302, 6, 22, "Print"],
Cell[314602, 8835, 312, 6, 22, "Print"],
Cell[314917, 8843, 308, 6, 22, "Print"],
Cell[315228, 8851, 37, 1, 22, "Print"],
Cell[315268, 8854, 302, 6, 22, "Print"],
Cell[315573, 8862, 312, 6, 22, "Print"],
Cell[315888, 8870, 308, 6, 22, "Print"],
Cell[316199, 8878, 37, 1, 22, "Print"],
Cell[316239, 8881, 302, 6, 22, "Print"],
Cell[316544, 8889, 312, 6, 22, "Print"],
Cell[316859, 8897, 308, 6, 22, "Print"],
Cell[317170, 8905, 37, 1, 22, "Print"],
Cell[317210, 8908, 302, 6, 22, "Print"],
Cell[317515, 8916, 312, 6, 22, "Print"],
Cell[317830, 8924, 308, 6, 22, "Print"],
Cell[318141, 8932, 37, 1, 22, "Print"],
Cell[318181, 8935, 302, 6, 22, "Print"],
Cell[318486, 8943, 312, 6, 22, "Print"],
Cell[318801, 8951, 308, 6, 22, "Print"],
Cell[319112, 8959, 37, 1, 22, "Print"],
Cell[319152, 8962, 302, 6, 22, "Print"],
Cell[319457, 8970, 312, 6, 22, "Print"],
Cell[319772, 8978, 308, 6, 22, "Print"],
Cell[320083, 8986, 37, 1, 22, "Print"],
Cell[320123, 8989, 302, 6, 22, "Print"],
Cell[320428, 8997, 312, 6, 22, "Print"],
Cell[320743, 9005, 308, 6, 22, "Print"],
Cell[321054, 9013, 37, 1, 22, "Print"],
Cell[321094, 9016, 302, 6, 22, "Print"],
Cell[321399, 9024, 312, 6, 22, "Print"],
Cell[321714, 9032, 308, 6, 22, "Print"],
Cell[322025, 9040, 37, 1, 22, "Print"],
Cell[322065, 9043, 69, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[322171, 9049, 46, 1, 27, "Input"],
Cell[322220, 9052, 41, 1, 26, "Output"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{
Cell[322310, 9059, 53, 0, 28, "Subsection"],
Cell[322366, 9061, 142, 2, 43, "Input"],

Cell[CellGroupData[{
Cell[322533, 9067, 46, 1, 27, "Input"],
Cell[322582, 9070, 41, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[322660, 9076, 124, 4, 42, "Input"],
Cell[322787, 9082, 243, 5, 22, "Print"],
Cell[323033, 9089, 253, 5, 22, "Print"],
Cell[323289, 9096, 251, 5, 22, "Print"],
Cell[323543, 9103, 37, 1, 22, "Print"],
Cell[323583, 9106, 243, 5, 22, "Print"],
Cell[323829, 9113, 253, 5, 22, "Print"],
Cell[324085, 9120, 251, 5, 22, "Print"],
Cell[324339, 9127, 37, 1, 22, "Print"],
Cell[324379, 9130, 243, 5, 22, "Print"],
Cell[324625, 9137, 253, 5, 22, "Print"],
Cell[324881, 9144, 251, 5, 22, "Print"],
Cell[325135, 9151, 37, 1, 22, "Print"],
Cell[325175, 9154, 243, 5, 22, "Print"],
Cell[325421, 9161, 253, 5, 22, "Print"],
Cell[325677, 9168, 251, 5, 22, "Print"],
Cell[325931, 9175, 37, 1, 22, "Print"],
Cell[325971, 9178, 243, 5, 22, "Print"],
Cell[326217, 9185, 253, 5, 22, "Print"],
Cell[326473, 9192, 251, 5, 22, "Print"],
Cell[326727, 9199, 37, 1, 22, "Print"],
Cell[326767, 9202, 243, 5, 22, "Print"],
Cell[327013, 9209, 253, 5, 22, "Print"],
Cell[327269, 9216, 251, 5, 22, "Print"],
Cell[327523, 9223, 37, 1, 22, "Print"],
Cell[327563, 9226, 243, 5, 22, "Print"],
Cell[327809, 9233, 253, 5, 22, "Print"],
Cell[328065, 9240, 251, 5, 22, "Print"],
Cell[328319, 9247, 37, 1, 22, "Print"],
Cell[328359, 9250, 243, 5, 22, "Print"],
Cell[328605, 9257, 253, 5, 22, "Print"],
Cell[328861, 9264, 251, 5, 22, "Print"],
Cell[329115, 9271, 37, 1, 22, "Print"],
Cell[329155, 9274, 243, 5, 22, "Print"],
Cell[329401, 9281, 253, 5, 22, "Print"],
Cell[329657, 9288, 251, 5, 22, "Print"],
Cell[329911, 9295, 37, 1, 22, "Print"],
Cell[329951, 9298, 243, 5, 22, "Print"],
Cell[330197, 9305, 253, 5, 22, "Print"],
Cell[330453, 9312, 251, 5, 22, "Print"],
Cell[330707, 9319, 37, 1, 22, "Print"],
Cell[330747, 9322, 245, 5, 22, "Print"],
Cell[330995, 9329, 255, 5, 22, "Print"],
Cell[331253, 9336, 253, 5, 22, "Print"],
Cell[331509, 9343, 37, 1, 22, "Print"],
Cell[331549, 9346, 245, 5, 22, "Print"],
Cell[331797, 9353, 255, 5, 22, "Print"],
Cell[332055, 9360, 253, 5, 22, "Print"],
Cell[332311, 9367, 37, 1, 22, "Print"],
Cell[332351, 9370, 245, 5, 22, "Print"],
Cell[332599, 9377, 255, 5, 22, "Print"],
Cell[332857, 9384, 253, 5, 22, "Print"],
Cell[333113, 9391, 37, 1, 22, "Print"],
Cell[333153, 9394, 245, 5, 22, "Print"],
Cell[333401, 9401, 255, 5, 22, "Print"],
Cell[333659, 9408, 253, 5, 22, "Print"],
Cell[333915, 9415, 37, 1, 22, "Print"],
Cell[333955, 9418, 245, 5, 22, "Print"],
Cell[334203, 9425, 255, 5, 22, "Print"],
Cell[334461, 9432, 253, 5, 22, "Print"],
Cell[334717, 9439, 37, 1, 22, "Print"],
Cell[334757, 9442, 245, 5, 22, "Print"],
Cell[335005, 9449, 255, 5, 22, "Print"],
Cell[335263, 9456, 253, 5, 22, "Print"],
Cell[335519, 9463, 37, 1, 22, "Print"],
Cell[335559, 9466, 245, 5, 22, "Print"],
Cell[335807, 9473, 255, 5, 22, "Print"],
Cell[336065, 9480, 253, 5, 22, "Print"],
Cell[336321, 9487, 37, 1, 22, "Print"],
Cell[336361, 9490, 245, 5, 22, "Print"],
Cell[336609, 9497, 255, 5, 22, "Print"],
Cell[336867, 9504, 253, 5, 22, "Print"],
Cell[337123, 9511, 37, 1, 22, "Print"],
Cell[337163, 9514, 245, 5, 22, "Print"],
Cell[337411, 9521, 255, 5, 22, "Print"],
Cell[337669, 9528, 253, 5, 22, "Print"],
Cell[337925, 9535, 37, 1, 22, "Print"],
Cell[337965, 9538, 245, 5, 22, "Print"],
Cell[338213, 9545, 255, 5, 22, "Print"],
Cell[338471, 9552, 253, 5, 22, "Print"],
Cell[338727, 9559, 37, 1, 22, "Print"],
Cell[338767, 9562, 245, 5, 22, "Print"],
Cell[339015, 9569, 255, 5, 22, "Print"],
Cell[339273, 9576, 253, 5, 22, "Print"],
Cell[339529, 9583, 37, 1, 22, "Print"],
Cell[339569, 9586, 245, 5, 22, "Print"],
Cell[339817, 9593, 255, 5, 22, "Print"],
Cell[340075, 9600, 253, 5, 22, "Print"],
Cell[340331, 9607, 37, 1, 22, "Print"],
Cell[340371, 9610, 245, 5, 22, "Print"],
Cell[340619, 9617, 255, 5, 22, "Print"],
Cell[340877, 9624, 253, 5, 22, "Print"],
Cell[341133, 9631, 37, 1, 22, "Print"],
Cell[341173, 9634, 245, 5, 22, "Print"],
Cell[341421, 9641, 255, 5, 22, "Print"],
Cell[341679, 9648, 253, 5, 22, "Print"],
Cell[341935, 9655, 37, 1, 22, "Print"],
Cell[341975, 9658, 245, 5, 22, "Print"],
Cell[342223, 9665, 255, 5, 22, "Print"],
Cell[342481, 9672, 253, 5, 22, "Print"],
Cell[342737, 9679, 37, 1, 22, "Print"],
Cell[342777, 9682, 245, 5, 22, "Print"],
Cell[343025, 9689, 255, 5, 22, "Print"],
Cell[343283, 9696, 253, 5, 22, "Print"],
Cell[343539, 9703, 37, 1, 22, "Print"],
Cell[343579, 9706, 245, 5, 22, "Print"],
Cell[343827, 9713, 255, 5, 22, "Print"],
Cell[344085, 9720, 253, 5, 22, "Print"],
Cell[344341, 9727, 37, 1, 22, "Print"],
Cell[344381, 9730, 245, 5, 22, "Print"],
Cell[344629, 9737, 255, 5, 22, "Print"],
Cell[344887, 9744, 253, 5, 22, "Print"],
Cell[345143, 9751, 37, 1, 22, "Print"],
Cell[345183, 9754, 245, 5, 22, "Print"],
Cell[345431, 9761, 255, 5, 22, "Print"],
Cell[345689, 9768, 253, 5, 22, "Print"],
Cell[345945, 9775, 37, 1, 22, "Print"],
Cell[345985, 9778, 245, 5, 22, "Print"],
Cell[346233, 9785, 255, 5, 22, "Print"],
Cell[346491, 9792, 253, 5, 22, "Print"],
Cell[346747, 9799, 37, 1, 22, "Print"],
Cell[346787, 9802, 245, 5, 22, "Print"],
Cell[347035, 9809, 255, 5, 22, "Print"],
Cell[347293, 9816, 253, 5, 22, "Print"],
Cell[347549, 9823, 37, 1, 22, "Print"],
Cell[347589, 9826, 245, 5, 22, "Print"],
Cell[347837, 9833, 255, 5, 22, "Print"],
Cell[348095, 9840, 253, 5, 22, "Print"],
Cell[348351, 9847, 37, 1, 22, "Print"],
Cell[348391, 9850, 245, 5, 22, "Print"],
Cell[348639, 9857, 255, 5, 22, "Print"],
Cell[348897, 9864, 253, 5, 22, "Print"],
Cell[349153, 9871, 37, 1, 22, "Print"],
Cell[349193, 9874, 245, 5, 22, "Print"],
Cell[349441, 9881, 255, 5, 22, "Print"],
Cell[349699, 9888, 253, 5, 22, "Print"],
Cell[349955, 9895, 37, 1, 22, "Print"],
Cell[349995, 9898, 245, 5, 22, "Print"],
Cell[350243, 9905, 255, 5, 22, "Print"],
Cell[350501, 9912, 253, 5, 22, "Print"],
Cell[350757, 9919, 37, 1, 22, "Print"],
Cell[350797, 9922, 245, 5, 22, "Print"],
Cell[351045, 9929, 255, 5, 22, "Print"],
Cell[351303, 9936, 253, 5, 22, "Print"],
Cell[351559, 9943, 37, 1, 22, "Print"],
Cell[351599, 9946, 245, 5, 22, "Print"],
Cell[351847, 9953, 255, 5, 22, "Print"],
Cell[352105, 9960, 253, 5, 22, "Print"],
Cell[352361, 9967, 37, 1, 22, "Print"],
Cell[352401, 9970, 245, 5, 22, "Print"],
Cell[352649, 9977, 255, 5, 22, "Print"],
Cell[352907, 9984, 253, 5, 22, "Print"],
Cell[353163, 9991, 37, 1, 22, "Print"],
Cell[353203, 9994, 245, 5, 22, "Print"],
Cell[353451, 10001, 255, 5, 22, "Print"],
Cell[353709, 10008, 253, 5, 22, "Print"],
Cell[353965, 10015, 37, 1, 22, "Print"],
Cell[354005, 10018, 245, 5, 22, "Print"],
Cell[354253, 10025, 255, 5, 22, "Print"],
Cell[354511, 10032, 253, 5, 22, "Print"],
Cell[354767, 10039, 37, 1, 22, "Print"],
Cell[354807, 10042, 245, 5, 22, "Print"],
Cell[355055, 10049, 255, 5, 22, "Print"],
Cell[355313, 10056, 253, 5, 22, "Print"],
Cell[355569, 10063, 37, 1, 22, "Print"],
Cell[355609, 10066, 245, 5, 22, "Print"],
Cell[355857, 10073, 255, 5, 22, "Print"],
Cell[356115, 10080, 253, 5, 22, "Print"],
Cell[356371, 10087, 37, 1, 22, "Print"],
Cell[356411, 10090, 245, 5, 22, "Print"],
Cell[356659, 10097, 255, 5, 22, "Print"],
Cell[356917, 10104, 253, 5, 22, "Print"],
Cell[357173, 10111, 37, 1, 22, "Print"],
Cell[357213, 10114, 245, 5, 22, "Print"],
Cell[357461, 10121, 255, 5, 22, "Print"],
Cell[357719, 10128, 253, 5, 22, "Print"],
Cell[357975, 10135, 37, 1, 22, "Print"],
Cell[358015, 10138, 245, 5, 22, "Print"],
Cell[358263, 10145, 255, 5, 22, "Print"],
Cell[358521, 10152, 253, 5, 22, "Print"],
Cell[358777, 10159, 37, 1, 22, "Print"],
Cell[358817, 10162, 245, 5, 22, "Print"],
Cell[359065, 10169, 255, 5, 22, "Print"],
Cell[359323, 10176, 253, 5, 22, "Print"],
Cell[359579, 10183, 37, 1, 22, "Print"],
Cell[359619, 10186, 245, 5, 22, "Print"],
Cell[359867, 10193, 255, 5, 22, "Print"],
Cell[360125, 10200, 253, 5, 22, "Print"],
Cell[360381, 10207, 37, 1, 22, "Print"],
Cell[360421, 10210, 245, 5, 22, "Print"],
Cell[360669, 10217, 255, 5, 22, "Print"],
Cell[360927, 10224, 253, 5, 22, "Print"],
Cell[361183, 10231, 37, 1, 22, "Print"],
Cell[361223, 10234, 245, 5, 22, "Print"],
Cell[361471, 10241, 255, 5, 22, "Print"],
Cell[361729, 10248, 253, 5, 22, "Print"],
Cell[361985, 10255, 37, 1, 22, "Print"],
Cell[362025, 10258, 245, 5, 22, "Print"],
Cell[362273, 10265, 255, 5, 22, "Print"],
Cell[362531, 10272, 253, 5, 22, "Print"],
Cell[362787, 10279, 37, 1, 22, "Print"],
Cell[362827, 10282, 70, 1, 26, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[362934, 10288, 46, 1, 24, "Input"],
Cell[362983, 10291, 41, 1, 26, "Output"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{
Cell[363073, 10298, 60, 0, 28, "Subsection"],
Cell[363136, 10300, 140, 2, 43, "Input"],

Cell[CellGroupData[{
Cell[363301, 10306, 46, 1, 27, "Input"],
Cell[363350, 10309, 41, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[363428, 10315, 93, 1, 27, "Input"],
Cell[363524, 10318, 485, 11, 22, "Print"],
Cell[364012, 10331, 308, 6, 22, "Print"],
Cell[364323, 10339, 331, 7, 24, "Print"],
Cell[364657, 10348, 331, 7, 24, "Print"],
Cell[364991, 10357, 331, 7, 24, "Print"],
Cell[365325, 10366, 331, 7, 24, "Print"],
Cell[365659, 10375, 633, 15, 24, "Print"],
Cell[366295, 10392, 692, 17, 24, "Print"],
Cell[366990, 10411, 720, 18, 24, "Print"],
Cell[367713, 10431, 707, 18, 24, "Print"],
Cell[368423, 10451, 695, 18, 24, "Print"],
Cell[369121, 10471, 711, 18, 24, "Print"],
Cell[369835, 10491, 866, 21, 24, "Print"],
Cell[370704, 10514, 890, 22, 24, "Print"],
Cell[371597, 10538, 906, 23, 24, "Print"],
Cell[372506, 10563, 919, 23, 24, "Print"],
Cell[373428, 10588, 70, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[373535, 10594, 46, 1, 27, "Input"],
Cell[373584, 10597, 41, 1, 26, "Output"]
}, Open  ]]
}, Closed]]
}, Closed]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

