(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 3.0,
MathReader 3.0, or any compatible application. The data for the notebook 
starts with the line of stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[    197229,       5587]*)
(*NotebookOutlinePosition[    198069,       5614]*)
(*  CellTagsIndexPosition[    198025,       5610]*)
(*WindowFrame->Normal*)



Notebook[{
Cell[TextData[{
  " :Author:  Z\[EAcute]lia da ROCHA \n\n:Address: \n            Departamento \
de Matem\[AAcute]tica Aplicada da\n            Faculdade de Ci\[EHat]ncias do \
Porto\n            Rua das Taipas, 135\n            4050 Porto\n            \
Portugal\n  \n            Tel: ++351 02 2080313\n            Fax: ++351 02 \
2004109\n            Email: mrdioh@fc.up.pt\n\n :Summary:\n    The ",
  StyleBox["testchv53",
    FontSize->18],
  " notebook contains the results produced by the package\n    chv.m \
corresponding to the ",
  StyleBox["example 5.3",
    FontSize->18],
  " of the first paper cited bellow.    \n\n :Date: July 1999. \n\n:Available \
at http://netlib.bell-labs.com/ in the numeralgo library in netlib:     \n\n \
:Notebook Version: 1.0 \n\n :Mathematica Version: 3.0   \n \n :Keywords: \
chebyshev's method, recurrence relations,  orthogonal polynomials of \
dimension d, d-dimensional forms.\n\n :Sources:\n \n - Z\[EAcute]lia da \
Rocha, Shohat-Favard and Chebyshev's methods in d-orthogonality, \n Numerical \
Algorithms, 20 (1999) 139-164.\n   \n - About the example treated here see p. \
286 of:\n   K. Douak, The relation of the d-orthogonal polynomials to the \
Appell polynomials, J. Comput. Appl. Math.,  70 (1996) 279-295."
}], "Subsection"],

Cell[CellGroupData[{

Cell["\<\
Computing the recurrence coefficients and the orthogonal \
polynomials performing formal computations\
\>", "Section",
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell["\<\
Loading the package chv.m, the package datachv53.m is automatically \
loaded\
\>", "Subsection"],

Cell[BoxData[
    \(\(<< chebyshev`chv`; \)\)], "Input"]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
 The moments of the d-dimensional form are given in the package \
datachv53.m\
\>", "Subsection",
  AspectRatioFixed->True],

Cell[BoxData[
    \( (*\ showing\ the\ moments\ given\ *) \)], "Input"],

Cell[BoxData[
    \(\( (*\ set\ the\ values\ of\ d\ and\ imax\ *) \nd = 3; imax = \ 10; 
    \ \ \ \ \ \  (*\ for\ example\ *) \)\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Do[Do[
        Print["\<form[\>", d, "\<,\>", \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ r, 
          "\<,\>", i, "\<]=\>", form[d, r, i]], {i, 0, imax}]; \n
      \t\ \ \ \ \ \ \ Print["\<____________________\>"], {r, 1, d}]\)], 
  "Input"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]0
        \[InvisibleSpace]"]="\[InvisibleSpace]1\),
      SequenceForm[ "form[", 3, ",", 1, ",", 0, "]=", 1],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 3, ",", 1, ",", 1, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]"]="\[InvisibleSpace]4\/3\),
      SequenceForm[ "form[", 3, ",", 1, ",", 2, "]=", 
        Rational[ 4, 3]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]"]="\[InvisibleSpace]3\/2\),
      SequenceForm[ "form[", 3, ",", 1, ",", 3, "]=", 
        Rational[ 3, 2]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]"]="\[InvisibleSpace]67\/12\),
      SequenceForm[ "form[", 3, ",", 1, ",", 4, "]=", 
        Rational[ 67, 12]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]"]="\[InvisibleSpace]20\),
      SequenceForm[ "form[", 3, ",", 1, ",", 5, "]=", 20],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]6
        \[InvisibleSpace]"]="\[InvisibleSpace]1135\/18\),
      SequenceForm[ "form[", 3, ",", 1, ",", 6, "]=", 
        Rational[ 1135, 18]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]7
        \[InvisibleSpace]"]="\[InvisibleSpace]2345\/8\),
      SequenceForm[ "form[", 3, ",", 1, ",", 7, "]=", 
        Rational[ 2345, 8]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]8
        \[InvisibleSpace]"]="\[InvisibleSpace]547505\/432\),
      SequenceForm[ "form[", 3, ",", 1, ",", 8, "]=", 
        Rational[ 547505, 432]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]9
        \[InvisibleSpace]"]="\[InvisibleSpace]6055\),
      SequenceForm[ "form[", 3, ",", 1, ",", 9, "]=", 6055],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]10
        \[InvisibleSpace]"]="\[InvisibleSpace]582505\/18\),
      SequenceForm[ "form[", 3, ",", 1, ",", 10, "]=", 
        Rational[ 582505, 18]],
      Editable->False]], "Print"],

Cell[BoxData[
    \("____________________"\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]0
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 3, ",", 2, ",", 0, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]"]="\[InvisibleSpace]1\),
      SequenceForm[ "form[", 3, ",", 2, ",", 1, "]=", 1],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 3, ",", 2, ",", 2, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]"]="\[InvisibleSpace]4\),
      SequenceForm[ "form[", 3, ",", 2, ",", 3, "]=", 4],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]"]="\[InvisibleSpace]6\),
      SequenceForm[ "form[", 3, ",", 2, ",", 4, "]=", 6],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]"]="\[InvisibleSpace]335\/12\),
      SequenceForm[ "form[", 3, ",", 2, ",", 5, "]=", 
        Rational[ 335, 12]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]6
        \[InvisibleSpace]"]="\[InvisibleSpace]120\),
      SequenceForm[ "form[", 3, ",", 2, ",", 6, "]=", 120],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]7
        \[InvisibleSpace]"]="\[InvisibleSpace]7945\/18\),
      SequenceForm[ "form[", 3, ",", 2, ",", 7, "]=", 
        Rational[ 7945, 18]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]8
        \[InvisibleSpace]"]="\[InvisibleSpace]2345\),
      SequenceForm[ "form[", 3, ",", 2, ",", 8, "]=", 2345],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]9
        \[InvisibleSpace]"]="\[InvisibleSpace]547505\/48\),
      SequenceForm[ "form[", 3, ",", 2, ",", 9, "]=", 
        Rational[ 547505, 48]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]10
        \[InvisibleSpace]"]="\[InvisibleSpace]60550\),
      SequenceForm[ "form[", 3, ",", 2, ",", 10, "]=", 60550],
      Editable->False]], "Print"],

Cell[BoxData[
    \("____________________"\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]0
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 3, ",", 3, ",", 0, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 3, ",", 3, ",", 1, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]"]="\[InvisibleSpace]1\),
      SequenceForm[ "form[", 3, ",", 3, ",", 2, "]=", 1],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 3, ",", 3, ",", 3, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]"]="\[InvisibleSpace]8\),
      SequenceForm[ "form[", 3, ",", 3, ",", 4, "]=", 8],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]"]="\[InvisibleSpace]15\),
      SequenceForm[ "form[", 3, ",", 3, ",", 5, "]=", 15],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]6
        \[InvisibleSpace]"]="\[InvisibleSpace]335\/4\),
      SequenceForm[ "form[", 3, ",", 3, ",", 6, "]=", 
        Rational[ 335, 4]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]7
        \[InvisibleSpace]"]="\[InvisibleSpace]420\),
      SequenceForm[ "form[", 3, ",", 3, ",", 7, "]=", 420],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]8
        \[InvisibleSpace]"]="\[InvisibleSpace]15890\/9\),
      SequenceForm[ "form[", 3, ",", 3, ",", 8, "]=", 
        Rational[ 15890, 9]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]9
        \[InvisibleSpace]"]="\[InvisibleSpace]21105\/2\),
      SequenceForm[ "form[", 3, ",", 3, ",", 9, "]=", 
        Rational[ 21105, 2]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]10
        \[InvisibleSpace]"]="\[InvisibleSpace]2737525\/48\),
      SequenceForm[ "form[", 3, ",", 3, ",", 10, "]=", 
        Rational[ 2737525, 48]],
      Editable->False]], "Print"],

Cell[BoxData[
    \("____________________"\)], "Print"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Computing the gamma coefficients", "Subsection"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\( (*\ set\ the\ values\ of\ d\ and\ nmax\ *) \nd = 3; \ 
    nmax = \ 10\ \ ; \ \ \  (*\ for\ example\ *) \)\)], "Input"],

Cell[BoxData[
    \(General::"spell1" \( : \ \) 
      "Possible spelling error: new symbol name \"\!\(nmax\)\" is similar to \
existing symbol \"\!\(imax\)\"."\)], "Message"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(MemoryInUse[]\)], "Input"],

Cell[BoxData[
    \(953808\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Timing[printgamma[d,nmax,Infinity,$MachinePrecision,True,False]]\
\>\
", "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    \("   "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]0
        \[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]"]="\[InvisibleSpace]1\/4\),
      SequenceForm[ "gamma[", 3, ",", 0, ",", 1, "]=", 
        Rational[ 1, 4]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]0
        \[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]"]="\[InvisibleSpace]1\/4\),
      SequenceForm[ "gammaexact[", 3, ",", 0, ",", 1, "]=", 
        Rational[ 1, 4]],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]0
        \[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]"]="\[InvisibleSpace]1\),
      SequenceForm[ "gamma[", 3, ",", 0, ",", 2, "]=", 1],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]0
        \[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]"]="\[InvisibleSpace]1\),
      SequenceForm[ "gammaexact[", 3, ",", 0, ",", 2, "]=", 1],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]0
        \[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]"]="\[InvisibleSpace]5\/2\),
      SequenceForm[ "gamma[", 3, ",", 0, ",", 3, "]=", 
        Rational[ 5, 2]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]0
        \[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]"]="\[InvisibleSpace]5\/2\),
      SequenceForm[ "gammaexact[", 3, ",", 0, ",", 3, "]=", 
        Rational[ 5, 2]],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]0
        \[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]"]="\[InvisibleSpace]5\),
      SequenceForm[ "gamma[", 3, ",", 0, ",", 4, "]=", 5],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]0
        \[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]"]="\[InvisibleSpace]5\),
      SequenceForm[ "gammaexact[", 3, ",", 0, ",", 4, "]=", 5],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]0
        \[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]"]="\[InvisibleSpace]35\/4\),
      SequenceForm[ "gamma[", 3, ",", 0, ",", 5, "]=", 
        Rational[ 35, 4]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]0
        \[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]"]="\[InvisibleSpace]35\/4\),
      SequenceForm[ "gammaexact[", 3, ",", 0, ",", 5, "]=", 
        Rational[ 35, 4]],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]0
        \[InvisibleSpace]","\[InvisibleSpace]6
        \[InvisibleSpace]"]="\[InvisibleSpace]14\),
      SequenceForm[ "gamma[", 3, ",", 0, ",", 6, "]=", 14],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]0
        \[InvisibleSpace]","\[InvisibleSpace]6
        \[InvisibleSpace]"]="\[InvisibleSpace]14\),
      SequenceForm[ "gammaexact[", 3, ",", 0, ",", 6, "]=", 14],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]0
        \[InvisibleSpace]","\[InvisibleSpace]7
        \[InvisibleSpace]"]="\[InvisibleSpace]21\),
      SequenceForm[ "gamma[", 3, ",", 0, ",", 7, "]=", 21],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]0
        \[InvisibleSpace]","\[InvisibleSpace]7
        \[InvisibleSpace]"]="\[InvisibleSpace]21\),
      SequenceForm[ "gammaexact[", 3, ",", 0, ",", 7, "]=", 21],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]0
        \[InvisibleSpace]","\[InvisibleSpace]8
        \[InvisibleSpace]"]="\[InvisibleSpace]30\),
      SequenceForm[ "gamma[", 3, ",", 0, ",", 8, "]=", 30],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]0
        \[InvisibleSpace]","\[InvisibleSpace]8
        \[InvisibleSpace]"]="\[InvisibleSpace]30\),
      SequenceForm[ "gammaexact[", 3, ",", 0, ",", 8, "]=", 30],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    \("   "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]"]="\[InvisibleSpace]3\/2\),
      SequenceForm[ "gamma[", 3, ",", 1, ",", 1, "]=", 
        Rational[ 3, 2]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]"]="\[InvisibleSpace]3\/2\),
      SequenceForm[ "gammaexact[", 3, ",", 1, ",", 1, "]=", 
        Rational[ 3, 2]],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]"]="\[InvisibleSpace]9\/2\),
      SequenceForm[ "gamma[", 3, ",", 1, ",", 2, "]=", 
        Rational[ 9, 2]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]"]="\[InvisibleSpace]9\/2\),
      SequenceForm[ "gammaexact[", 3, ",", 1, ",", 2, "]=", 
        Rational[ 9, 2]],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]"]="\[InvisibleSpace]9\),
      SequenceForm[ "gamma[", 3, ",", 1, ",", 3, "]=", 9],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]"]="\[InvisibleSpace]9\),
      SequenceForm[ "gammaexact[", 3, ",", 1, ",", 3, "]=", 9],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]"]="\[InvisibleSpace]15\),
      SequenceForm[ "gamma[", 3, ",", 1, ",", 4, "]=", 15],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]"]="\[InvisibleSpace]15\),
      SequenceForm[ "gammaexact[", 3, ",", 1, ",", 4, "]=", 15],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]"]="\[InvisibleSpace]45\/2\),
      SequenceForm[ "gamma[", 3, ",", 1, ",", 5, "]=", 
        Rational[ 45, 2]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]"]="\[InvisibleSpace]45\/2\),
      SequenceForm[ "gammaexact[", 3, ",", 1, ",", 5, "]=", 
        Rational[ 45, 2]],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]6
        \[InvisibleSpace]"]="\[InvisibleSpace]63\/2\),
      SequenceForm[ "gamma[", 3, ",", 1, ",", 6, "]=", 
        Rational[ 63, 2]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]6
        \[InvisibleSpace]"]="\[InvisibleSpace]63\/2\),
      SequenceForm[ "gammaexact[", 3, ",", 1, ",", 6, "]=", 
        Rational[ 63, 2]],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]7
        \[InvisibleSpace]"]="\[InvisibleSpace]42\),
      SequenceForm[ "gamma[", 3, ",", 1, ",", 7, "]=", 42],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]7
        \[InvisibleSpace]"]="\[InvisibleSpace]42\),
      SequenceForm[ "gammaexact[", 3, ",", 1, ",", 7, "]=", 42],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]8
        \[InvisibleSpace]"]="\[InvisibleSpace]54\),
      SequenceForm[ "gamma[", 3, ",", 1, ",", 8, "]=", 54],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]8
        \[InvisibleSpace]"]="\[InvisibleSpace]54\),
      SequenceForm[ "gammaexact[", 3, ",", 1, ",", 8, "]=", 54],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]9
        \[InvisibleSpace]"]="\[InvisibleSpace]135\/2\),
      SequenceForm[ "gamma[", 3, ",", 1, ",", 9, "]=", 
        Rational[ 135, 2]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]9
        \[InvisibleSpace]"]="\[InvisibleSpace]135\/2\),
      SequenceForm[ "gammaexact[", 3, ",", 1, ",", 9, "]=", 
        Rational[ 135, 2]],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    \("   "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]"]="\[InvisibleSpace]4\/3\),
      SequenceForm[ "gamma[", 3, ",", 2, ",", 1, "]=", 
        Rational[ 4, 3]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]"]="\[InvisibleSpace]4\/3\),
      SequenceForm[ "gammaexact[", 3, ",", 2, ",", 1, "]=", 
        Rational[ 4, 3]],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]"]="\[InvisibleSpace]8\/3\),
      SequenceForm[ "gamma[", 3, ",", 2, ",", 2, "]=", 
        Rational[ 8, 3]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]"]="\[InvisibleSpace]8\/3\),
      SequenceForm[ "gammaexact[", 3, ",", 2, ",", 2, "]=", 
        Rational[ 8, 3]],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]"]="\[InvisibleSpace]4\),
      SequenceForm[ "gamma[", 3, ",", 2, ",", 3, "]=", 4],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]"]="\[InvisibleSpace]4\),
      SequenceForm[ "gammaexact[", 3, ",", 2, ",", 3, "]=", 4],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]"]="\[InvisibleSpace]16\/3\),
      SequenceForm[ "gamma[", 3, ",", 2, ",", 4, "]=", 
        Rational[ 16, 3]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]"]="\[InvisibleSpace]16\/3\),
      SequenceForm[ "gammaexact[", 3, ",", 2, ",", 4, "]=", 
        Rational[ 16, 3]],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]"]="\[InvisibleSpace]20\/3\),
      SequenceForm[ "gamma[", 3, ",", 2, ",", 5, "]=", 
        Rational[ 20, 3]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]"]="\[InvisibleSpace]20\/3\),
      SequenceForm[ "gammaexact[", 3, ",", 2, ",", 5, "]=", 
        Rational[ 20, 3]],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]6
        \[InvisibleSpace]"]="\[InvisibleSpace]8\),
      SequenceForm[ "gamma[", 3, ",", 2, ",", 6, "]=", 8],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]6
        \[InvisibleSpace]"]="\[InvisibleSpace]8\),
      SequenceForm[ "gammaexact[", 3, ",", 2, ",", 6, "]=", 8],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]7
        \[InvisibleSpace]"]="\[InvisibleSpace]28\/3\),
      SequenceForm[ "gamma[", 3, ",", 2, ",", 7, "]=", 
        Rational[ 28, 3]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]7
        \[InvisibleSpace]"]="\[InvisibleSpace]28\/3\),
      SequenceForm[ "gammaexact[", 3, ",", 2, ",", 7, "]=", 
        Rational[ 28, 3]],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]8
        \[InvisibleSpace]"]="\[InvisibleSpace]32\/3\),
      SequenceForm[ "gamma[", 3, ",", 2, ",", 8, "]=", 
        Rational[ 32, 3]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]8
        \[InvisibleSpace]"]="\[InvisibleSpace]32\/3\),
      SequenceForm[ "gammaexact[", 3, ",", 2, ",", 8, "]=", 
        Rational[ 32, 3]],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]9
        \[InvisibleSpace]"]="\[InvisibleSpace]12\),
      SequenceForm[ "gamma[", 3, ",", 2, ",", 9, "]=", 12],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]9
        \[InvisibleSpace]"]="\[InvisibleSpace]12\),
      SequenceForm[ "gammaexact[", 3, ",", 2, ",", 9, "]=", 12],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]10
        \[InvisibleSpace]"]="\[InvisibleSpace]40\/3\),
      SequenceForm[ "gamma[", 3, ",", 2, ",", 10, "]=", 
        Rational[ 40, 3]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]10
        \[InvisibleSpace]"]="\[InvisibleSpace]40\/3\),
      SequenceForm[ "gammaexact[", 3, ",", 2, ",", 10, "]=", 
        Rational[ 40, 3]],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    \({14.5333333333333385`\ Second, Null}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(MemoryInUse[]\)], "Input"],

Cell[BoxData[
    \(1026840\)], "Output"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Computing the beta coefficients", "Subsection"],

Cell[BoxData[
    \(\( (*\ set\ the\ values\ of\ d\ and\ nmax\ *) \nd = 3; \ nmax = \ 10\ ; 
    \ \ \ \  (*\ for\ example\ *) \)\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(MemoryInUse[]\)], "Input"],

Cell[BoxData[
    \(1028624\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Timing[printbeta[d,nmax,Infinity,$MachinePrecision,True,False]]\
\>\
", "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    InterpretationBox[
      \("beta["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]0
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "beta[", 3, ",", 0, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("betaexact["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]0
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "betaexact[", 3, ",", 0, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("beta["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "beta[", 3, ",", 1, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("betaexact["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "betaexact[", 3, ",", 1, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("beta["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "beta[", 3, ",", 2, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("betaexact["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "betaexact[", 3, ",", 2, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("beta["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "beta[", 3, ",", 3, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("betaexact["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "betaexact[", 3, ",", 3, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("beta["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "beta[", 3, ",", 4, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("betaexact["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "betaexact[", 3, ",", 4, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("beta["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "beta[", 3, ",", 5, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("betaexact["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "betaexact[", 3, ",", 5, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("beta["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]6
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "beta[", 3, ",", 6, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("betaexact["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]6
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "betaexact[", 3, ",", 6, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("beta["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]7
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "beta[", 3, ",", 7, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("betaexact["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]7
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "betaexact[", 3, ",", 7, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("beta["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]8
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "beta[", 3, ",", 8, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("betaexact["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]8
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "betaexact[", 3, ",", 8, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("beta["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]9
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "beta[", 3, ",", 9, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("betaexact["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]9
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "betaexact[", 3, ",", 9, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    \({3.78333333333333143`\ Second, Null}\)], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(MemoryInUse[]\)], "Input"],

Cell[BoxData[
    \(1031400\)], "Output"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Computing the d-orthogonal polynomials", "Subsection"],

Cell[BoxData[
    \(\( (*\ set\ the\ values\ of\ d\ and\ nmax\ *) \nd = 3; \ nmax = \ 10\ ; 
    \ \ \ \  (*\ for\ example\ *) \)\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(MemoryInUse[]\)], "Input"],

Cell[BoxData[
    \(1033216\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Timing[printdorthpoly[d,nmax,x,Infinity]]", "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    InterpretationBox[
      \("dorthpoly["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]0
        \[InvisibleSpace]","\[InvisibleSpace]x
        \[InvisibleSpace]"]="\[InvisibleSpace]1\),
      SequenceForm[ "dorthpoly[", 3, ",", 0, ",", x, "]=", 1],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("dorthpoly["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]x
        \[InvisibleSpace]"]="\[InvisibleSpace]x\),
      SequenceForm[ "dorthpoly[", 3, ",", 1, ",", x, "]=", x],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("dorthpoly["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]x
        \[InvisibleSpace]"]="\[InvisibleSpace]\(\( - 4\/3\) + x\^2\)\),
      SequenceForm[ "dorthpoly[", 3, ",", 2, ",", x, "]=", 
        Plus[ 
          Rational[ -4, 3], 
          Power[ x, 2]]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("dorthpoly["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]x
        \[InvisibleSpace]"]="\[InvisibleSpace]\(\( - 3\/2\) - 4\ x + x\^3\)\),
      
      SequenceForm[ "dorthpoly[", 3, ",", 3, ",", x, "]=", 
        Plus[ 
          Rational[ -3, 2], 
          Times[ -4, x], 
          Power[ x, 3]]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("dorthpoly["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]x
        \[InvisibleSpace]"]="\[InvisibleSpace]\(61\/12 - 6\ x - 8\ x\^2 + 
          x\^4\)\),
      SequenceForm[ "dorthpoly[", 3, ",", 4, ",", x, "]=", 
        Plus[ 
          Rational[ 61, 12], 
          Times[ -6, x], 
          Times[ -8, 
            Power[ x, 2]], 
          Power[ x, 4]]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("dorthpoly["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]x
        \[InvisibleSpace]"]="\[InvisibleSpace]\(20 + \(305\ x\)\/12 - 
          15\ x\^2 - \(40\ x\^3\)\/3 + x\^5\)\),
      SequenceForm[ "dorthpoly[", 3, ",", 5, ",", x, "]=", 
        Plus[ 20, 
          Times[ 
            Rational[ 305, 12], x], 
          Times[ -15, 
            Power[ x, 2]], 
          Times[ 
            Rational[ -40, 3], 
            Power[ x, 3]], 
          Power[ x, 5]]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("dorthpoly["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]6
        \[InvisibleSpace]","\[InvisibleSpace]x
        \[InvisibleSpace]"]="\[InvisibleSpace]\(\( - 145\/18\) + 120\ x + 
          \(305\ x\^2\)\/4 - 30\ x\^3 - 20\ x\^4 + x\^6\)\),
      SequenceForm[ "dorthpoly[", 3, ",", 6, ",", x, "]=", 
        Plus[ 
          Rational[ -145, 18], 
          Times[ 120, x], 
          Times[ 
            Rational[ 305, 4], 
            Power[ x, 2]], 
          Times[ -30, 
            Power[ x, 3]], 
          Times[ -20, 
            Power[ x, 4]], 
          Power[ x, 6]]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("dorthpoly["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]7
        \[InvisibleSpace]","\[InvisibleSpace]x
        \[InvisibleSpace]"]="\[InvisibleSpace]\(\( - 2135\/8\) - 
          \(1015\ x\)\/18 + 420\ x\^2 + \(2135\ x\^3\)\/12 - 
          \(105\ x\^4\)\/2 - 28\ x\^5 + x\^7\)\),
      SequenceForm[ "dorthpoly[", 3, ",", 7, ",", x, "]=", 
        Plus[ 
          Rational[ -2135, 8], 
          Times[ 
            Rational[ -1015, 18], x], 
          Times[ 420, 
            Power[ x, 2]], 
          Times[ 
            Rational[ 2135, 12], 
            Power[ x, 3]], 
          Times[ 
            Rational[ -105, 2], 
            Power[ x, 4]], 
          Times[ -28, 
            Power[ x, 5]], 
          Power[ x, 7]]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("dorthpoly["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]8
        \[InvisibleSpace]","\[InvisibleSpace]x
        \[InvisibleSpace]"]="\[InvisibleSpace]\(\( - 258895\/432\) - 
          2135\ x - \(2030\ x\^2\)\/9 + 1120\ x\^3 + \(2135\ x\^4\)\/6 - 
          84\ x\^5 - \(112\ x\^6\)\/3 + x\^8\)\),
      SequenceForm[ "dorthpoly[", 3, ",", 8, ",", x, "]=", 
        Plus[ 
          Rational[ -258895, 432], 
          Times[ -2135, x], 
          Times[ 
            Rational[ -2030, 9], 
            Power[ x, 2]], 
          Times[ 1120, 
            Power[ x, 3]], 
          Times[ 
            Rational[ 2135, 6], 
            Power[ x, 4]], 
          Times[ -84, 
            Power[ x, 5]], 
          Times[ 
            Rational[ -112, 3], 
            Power[ x, 6]], 
          Power[ x, 8]]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("dorthpoly["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]9
        \[InvisibleSpace]","\[InvisibleSpace]x
        \[InvisibleSpace]"]="\[InvisibleSpace]\(2905 - \(258895\ x\)\/48 - 
          \(19215\ x\^2\)\/2 - \(2030\ x\^3\)\/3 + 2520\ x\^4 + 
          \(1281\ x\^5\)\/2 - 126\ x\^6 - 48\ x\^7 + x\^9\)\),
      SequenceForm[ "dorthpoly[", 3, ",", 9, ",", x, "]=", 
        Plus[ 2905, 
          Times[ 
            Rational[ -258895, 48], x], 
          Times[ 
            Rational[ -19215, 2], 
            Power[ x, 2]], 
          Times[ 
            Rational[ -2030, 3], 
            Power[ x, 3]], 
          Times[ 2520, 
            Power[ x, 4]], 
          Times[ 
            Rational[ 1281, 2], 
            Power[ x, 5]], 
          Times[ -126, 
            Power[ x, 6]], 
          Times[ -48, 
            Power[ x, 7]], 
          Power[ x, 9]]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("dorthpoly["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]10
        \[InvisibleSpace]","\[InvisibleSpace]x
        \[InvisibleSpace]"]="\[InvisibleSpace]\(391895\/18 + 29050\ x - 
          \(1294475\ x\^2\)\/48 - 32025\ x\^3 - \(5075\ x\^4\)\/3 + 
          5040\ x\^5 + \(2135\ x\^6\)\/2 - 180\ x\^7 - 60\ x\^8 + x\^10\)\),
      SequenceForm[ "dorthpoly[", 3, ",", 10, ",", x, "]=", 
        Plus[ 
          Rational[ 391895, 18], 
          Times[ 29050, x], 
          Times[ 
            Rational[ -1294475, 48], 
            Power[ x, 2]], 
          Times[ -32025, 
            Power[ x, 3]], 
          Times[ 
            Rational[ -5075, 3], 
            Power[ x, 4]], 
          Times[ 5040, 
            Power[ x, 5]], 
          Times[ 
            Rational[ 2135, 2], 
            Power[ x, 6]], 
          Times[ -180, 
            Power[ x, 7]], 
          Times[ -60, 
            Power[ x, 8]], 
          Power[ x, 10]]],
      Editable->False]], "Print"],

Cell[BoxData[
    \({3.68333333333332291`\ Second, Null}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(MemoryInUse[]\)], "Input"],

Cell[BoxData[
    \(1039928\)], "Output"]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["\<\
Computing the recurrence coefficients and the orthogonal \
polynomials performing numerical computations with the machine precision\
\>",
   "Section",
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell["\<\
Loading the package chv.m, the package datachv53.m is automatically \
loaded\
\>", "Subsection"],

Cell[BoxData[
    \(\(<< chebyshev`chv`; \)\)], "Input"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Computing the gamma coefficients", "Subsection"],

Cell[BoxData[
    \(\( (*\ set\ the\ values\ of\ d\ and\ nmax\ *) \nd = 3; \ nmax = \ 20\ ; 
    \ \ \ \  (*\ for\ example\ *) \)\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(MemoryInUse[]\)], "Input"],

Cell[BoxData[
    \(972872\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Timing[printgamma[d,nmax,$MachinePrecision,$MachinePrecision,True,\
True]]\
\>", "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    \("   "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gamma["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["0.249999999999999555`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gamma[", 3, ",", 0, ",", 1, "]=", 0.24999999999999956],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["0.25`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gammaexact[", 3, ",", 0, ",", 1, "]=", 0.25],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["14.3525297788630412`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 3, ",", 0, ",", 1, "]=", 14.35252977886304],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gamma["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["1.`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gamma[", 3, ",", 0, ",", 2, "]=", 1.0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["1.`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gammaexact[", 3, ",", 0, ",", 2, "]=", 1.0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        InterpretationBox["\[Infinity]",
          DirectedInfinity[ 1]]}],
      SequenceForm[ "exactdigits[", 3, ",", 0, ",", 2, "]=", 
        DirectedInfinity[ 1]],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gamma["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["2.50000000000149213`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gamma[", 3, ",", 0, ",", 3, "]=", 2.5000000000014921],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["2.5`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gammaexact[", 3, ",", 0, ",", 3, "]=", 2.5],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["11.8261905014731949`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 3, ",", 0, ",", 3, "]=", 11.826190501473196],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gamma["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "4", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["5.0000000000041016`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gamma[", 3, ",", 0, ",", 4, "]=", 5.0000000000041016],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "4", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["5.`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gammaexact[", 3, ",", 0, ",", 4, "]=", 5.0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "4", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["11.3870458546179009`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 3, ",", 0, ",", 4, "]=", 11.387045854617901],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gamma["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "5", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["8.74999999978945197`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gamma[", 3, ",", 0, ",", 5, "]=", 8.749999999789452],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "5", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["8.75`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gammaexact[", 3, ",", 0, ",", 5, "]=", 8.75],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "5", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["9.67664883120527363`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 3, ",", 0, ",", 5, "]=", 9.6766488312052736],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gamma["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "6", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["13.9999999965319265`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gamma[", 3, ",", 0, ",", 6, "]=", 13.999999996531926],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "6", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["13.9999999999999991`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gammaexact[", 3, ",", 0, ",", 6, "]=", 14.0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "6", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["9.45991166586640375`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 3, ",", 0, ",", 6, "]=", 9.4599116658664038],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gamma["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "7", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["21.0000001153387527`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gamma[", 3, ",", 0, ",", 7, "]=", 21.000000115338754],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "7", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["21.0000000000000008`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gammaexact[", 3, ",", 0, ",", 7, "]=", 21.0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "7", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["7.93802474584993689`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 3, ",", 0, ",", 7, "]=", 7.9380247458499369],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gamma["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "8", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["30.000000421313806`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gamma[", 3, ",", 0, ",", 8, "]=", 30.000000421313807],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "8", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["30.`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gammaexact[", 3, ",", 0, ",", 8, "]=", 30.0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "8", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["7.37539430829473552`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 3, ",", 0, ",", 8, "]=", 7.3753943082947355],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gamma["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "9", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["41.2499577055377297`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gamma[", 3, ",", 0, ",", 9, "]=", 41.249957705537732],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "9", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["41.25`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gammaexact[", 3, ",", 0, ",", 9, "]=", 41.25],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "9", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["5.3737164922868299`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 3, ",", 0, ",", 9, "]=", 5.3737164922868299],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gamma["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "10", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["55.0003512275147521`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gamma[", 3, ",", 0, ",", 10, "]=", 55.000351227514756],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "10", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["55.`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gammaexact[", 3, ",", 0, ",", 10, "]=", 55.0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "10", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["4.45441146930778941`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 3, ",", 0, ",", 10, "]=", 4.4544114693077894],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gamma["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "11", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["71.5051986748644896`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gamma[", 3, ",", 0, ",", 11, "]=", 71.505198674864488],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "11", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["71.5000000000000035`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gammaexact[", 3, ",", 0, ",", 11, "]=", 71.5],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "11", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["3.28410734336163034`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 3, ",", 0, ",", 11, "]=", 3.2841073433616303],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gamma["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "12", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["90.9271020492011139`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gamma[", 3, ",", 0, ",", 12, "]=", 90.92710204920111],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "12", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["90.9999999999999964`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gammaexact[", 3, ",", 0, ",", 12, "]=", 91.0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "12", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["2.13728467976492009`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 3, ",", 0, ",", 12, "]=", 2.1372846797649201],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gamma["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "13", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["113.841933469052225`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gamma[", 3, ",", 0, ",", 13, "]=", 113.84193346905222],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "13", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["113.749999999999995`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gammaexact[", 3, ",", 0, ",", 13, "]=", 113.75],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "13", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["3.03652635174218499`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 3, ",", 0, ",", 13, "]=", 3.036526351742185],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gamma["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "14", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["143.201657707198055`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gamma[", 3, ",", 0, ",", 14, "]=", 143.20165770719805],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "14", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["139.999999999999991`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gammaexact[", 3, ",", 0, ",", 14, "]=", 140.0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "14", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["1.49462510084310284`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 3, ",", 0, ",", 14, "]=", 1.4946251008431028],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gamma["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "15", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["115.652087775952394`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gamma[", 3, ",", 0, ",", 15, "]=", 115.6520877759524],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "15", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["170.`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gammaexact[", 3, ",", 0, ",", 15, "]=", 170.0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "15", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["0.264817134686996524`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 3, ",", 0, ",", 15, "]=", 0.26481713468699652],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gamma["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "16", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["633.626174953716603`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gamma[", 3, ",", 0, ",", 16, "]=", 633.6261749537166],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "16", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["204.000000000000003`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gammaexact[", 3, ",", 0, ",", 16, "]=", 204.0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "16", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        RowBox[{"-", 
          StyleBox["0.633090732867639172`",
            StyleBoxAutoDelete->True,
            PrintPrecision->2]}]}],
      SequenceForm[ 
      "exactdigits[", 3, ",", 0, ",", 16, "]=", -0.63309073286763917],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gamma["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "17", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["278.813343822321879`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gamma[", 3, ",", 0, ",", 17, "]=", 278.81334382232188],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "17", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["242.250000000000031`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gammaexact[", 3, ",", 0, ",", 17, "]=", 242.25],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "17", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["0.43695409365000204`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 3, ",", 0, ",", 17, "]=", 0.43695409365000204],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gamma["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "18", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        RowBox[{"-", 
          StyleBox["50441.0545814937449`",
            StyleBoxAutoDelete->True,
            PrintPrecision->16]}]}],
      SequenceForm[ "gamma[", 3, ",", 0, ",", 18, "]=", -50441.054581493743],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "18", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["285.`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gammaexact[", 3, ",", 0, ",", 18, "]=", 285.0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "18", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        RowBox[{"-", 
          StyleBox["0.705231084668667129`",
            StyleBoxAutoDelete->True,
            PrintPrecision->2]}]}],
      SequenceForm[ 
      "exactdigits[", 3, ",", 0, ",", 18, "]=", -0.70523108466866713],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    \("   "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gamma["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["1.5`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gamma[", 3, ",", 1, ",", 1, "]=", 1.5],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["1.5`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gammaexact[", 3, ",", 1, ",", 1, "]=", 1.5],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        InterpretationBox["\[Infinity]",
          DirectedInfinity[ 1]]}],
      SequenceForm[ "exactdigits[", 3, ",", 1, ",", 1, "]=", 
        DirectedInfinity[ 1]],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gamma["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["4.5`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gamma[", 3, ",", 1, ",", 2, "]=", 4.5],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["4.5`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gammaexact[", 3, ",", 1, ",", 2, "]=", 4.5],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        InterpretationBox["\[Infinity]",
          DirectedInfinity[ 1]]}],
      SequenceForm[ "exactdigits[", 3, ",", 1, ",", 2, "]=", 
        DirectedInfinity[ 1]],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gamma["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["9.`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gamma[", 3, ",", 1, ",", 3, "]=", 9.0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["9.`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gammaexact[", 3, ",", 1, ",", 3, "]=", 9.0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        InterpretationBox["\[Infinity]",
          DirectedInfinity[ 1]]}],
      SequenceForm[ "exactdigits[", 3, ",", 1, ",", 3, "]=", 
        DirectedInfinity[ 1]],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gamma["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "4", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["15.0000000000009636`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gamma[", 3, ",", 1, ",", 4, "]=", 15.000000000000965],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "4", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["15.`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gammaexact[", 3, ",", 1, ",", 4, "]=", 15.0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "4", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["13.0156699579462298`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 3, ",", 1, ",", 4, "]=", 13.01566995794623],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gamma["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "5", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["22.5000000000016653`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gamma[", 3, ",", 1, ",", 5, "]=", 22.500000000001666],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "5", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["22.5`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gammaexact[", 3, ",", 1, ",", 5, "]=", 22.5],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "5", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["12.7782669491560119`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 3, ",", 1, ",", 5, "]=", 12.778266949156013],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gamma["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "6", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["31.4999999999404511`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gamma[", 3, ",", 1, ",", 6, "]=", 31.499999999940453],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "6", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["31.4999999999999991`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gammaexact[", 3, ",", 1, ",", 6, "]=", 31.5],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "6", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["11.2251398657912693`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 3, ",", 1, ",", 6, "]=", 11.22513986579127],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gamma["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "7", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["41.99999999822146`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gamma[", 3, ",", 1, ",", 7, "]=", 41.999999998221462],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "7", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["42.0000000000000017`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gammaexact[", 3, ",", 1, ",", 7, "]=", 42.0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "7", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["9.74993680109803584`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 3, ",", 1, ",", 7, "]=", 9.7499368010980358],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gamma["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "8", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["54.0000000298279836`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gamma[", 3, ",", 1, ",", 8, "]=", 54.000000029827987],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "8", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["54.0000000000000035`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gammaexact[", 3, ",", 1, ",", 8, "]=", 54.0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "8", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["8.5253760520754227`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 3, ",", 1, ",", 8, "]=", 8.5253760520754227],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gamma["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "9", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["67.5000003664986092`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gamma[", 3, ",", 1, ",", 9, "]=", 67.500000366498611],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "9", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["67.5`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gammaexact[", 3, ",", 1, ",", 9, "]=", 67.5],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "9", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["7.43592766694253448`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 3, ",", 1, ",", 9, "]=", 7.4359276669425345],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gamma["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "10", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["82.499988149877268`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gamma[", 3, ",", 1, ",", 10, "]=", 82.499988149877268],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "10", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["82.5`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gammaexact[", 3, ",", 1, ",", 10, "]=", 82.5],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "10", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["5.92627715163347179`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 3, ",", 1, ",", 10, "]=", 5.9262771516334718],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gamma["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "11", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["99.0000461322805946`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gamma[", 3, ",", 1, ",", 11, "]=", 99.000046132280602],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "11", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["99.0000000000000035`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gammaexact[", 3, ",", 1, ",", 11, "]=", 99.0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "11", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["5.33599507501902614`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 3, ",", 1, ",", 11, "]=", 5.3359950750190261],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gamma["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "12", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["117.001387050691629`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gamma[", 3, ",", 1, ",", 12, "]=", 117.00138705069163],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "12", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["116.999999999999992`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gammaexact[", 3, ",", 1, ",", 12, "]=", 117.0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "12", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["4.85790766676063157`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 3, ",", 1, ",", 12, "]=", 4.8579076667606316],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gamma["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "13", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["136.485534164361199`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gamma[", 3, ",", 1, ",", 13, "]=", 136.48553416436121],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "13", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["136.499999999999999`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gammaexact[", 3, ",", 1, ",", 13, "]=", 136.5],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "13", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["3.83965647367640894`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 3, ",", 1, ",", 13, "]=", 3.8396564736764089],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gamma["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "14", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["157.50575628435504`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gamma[", 3, ",", 1, ",", 14, "]=", 157.50575628435504],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "14", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["157.5`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gammaexact[", 3, ",", 1, ",", 14, "]=", 157.5],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "14", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["4.23985776046574169`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 3, ",", 1, ",", 14, "]=", 4.2398577604657417],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gamma["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "15", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["180.877568203017702`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gamma[", 3, ",", 1, ",", 15, "]=", 180.87756820301769],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "15", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["180.`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gammaexact[", 3, ",", 1, ",", 15, "]=", 180.0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "15", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["2.05671912096676834`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 3, ",", 1, ",", 15, "]=", 2.0567191209667683],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gamma["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "16", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["193.684379799666963`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gamma[", 3, ",", 1, ",", 16, "]=", 193.68437979966697],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "16", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["204.000000000000003`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gammaexact[", 3, ",", 1, ",", 16, "]=", 204.0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "16", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["0.986504656058724194`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 3, ",", 1, ",", 16, "]=", 0.98650465605872428],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gamma["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "17", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["293.670679923769171`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gamma[", 3, ",", 1, ",", 17, "]=", 293.67067992376917],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "17", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["229.499999999999992`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gammaexact[", 3, ",", 1, ",", 17, "]=", 229.5],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "17", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["0.192663359094711328`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 3, ",", 1, ",", 17, "]=", 0.19266335909471133],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gamma["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "18", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["712.956445171445096`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gamma[", 3, ",", 1, ",", 18, "]=", 712.95644517144513],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "18", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["256.499999999999994`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gammaexact[", 3, ",", 1, ",", 18, "]=", 256.5],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "18", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        RowBox[{"-", 
          StyleBox["0.659399343701353224`",
            StyleBoxAutoDelete->True,
            PrintPrecision->2]}]}],
      SequenceForm[ 
      "exactdigits[", 3, ",", 1, ",", 18, "]=", -0.65939934370135322],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gamma["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "19", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["7441.43941782742501`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gamma[", 3, ",", 1, ",", 19, "]=", 7441.4394178274242],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "19", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["285.`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gammaexact[", 3, ",", 1, ",", 19, "]=", 285.0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "19", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        RowBox[{"-", 
          StyleBox["0.854696999150606728`",
            StyleBoxAutoDelete->True,
            PrintPrecision->2]}]}],
      SequenceForm[ 
      "exactdigits[", 3, ",", 1, ",", 19, "]=", -0.85469699915060682],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    \("   "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gamma["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["1.33333333333333325`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gamma[", 3, ",", 2, ",", 1, "]=", 1.3333333333333333],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["1.33333333333333325`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "gammaexact[", 3, ",", 2, ",", 1, "]=", 1.3333333333333333],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        InterpretationBox["\[Infinity]",
          DirectedInfinity[ 1]]}],
      SequenceForm[ "exactdigits[", 3, ",", 2, ",", 1, "]=", 
        DirectedInfinity[ 1]],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gamma["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["2.66666666666666696`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gamma[", 3, ",", 2, ",", 2, "]=", 2.666666666666667],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["2.66666666666666651`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "gammaexact[", 3, ",", 2, ",", 2, "]=", 2.6666666666666665],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["15.3525297788630403`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 3, ",", 2, ",", 2, "]=", 15.35252977886304],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gamma["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["4.`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gamma[", 3, ",", 2, ",", 3, "]=", 4.0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["4.`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gammaexact[", 3, ",", 2, ",", 3, "]=", 4.0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        InterpretationBox["\[Infinity]",
          DirectedInfinity[ 1]]}],
      SequenceForm[ "exactdigits[", 3, ",", 2, ",", 3, "]=", 
        DirectedInfinity[ 1]],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gamma["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "4", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["5.33333333333337389`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gamma[", 3, ",", 2, ",", 4, "]=", 5.3333333333333739],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "4", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["5.33333333333333303`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "gammaexact[", 3, ",", 2, ",", 4, "]=", 5.333333333333333],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "4", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["13.3887419515174843`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 3, ",", 2, ",", 4, "]=", 13.388741951517485],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gamma["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "5", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["6.66666666666671403`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gamma[", 3, ",", 2, ",", 5, "]=", 6.666666666666714],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "5", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["6.66666666666666696`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "gammaexact[", 3, ",", 2, ",", 5, "]=", 6.666666666666667],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "5", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["13.3272239135982695`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 3, ",", 2, ",", 5, "]=", 13.327223913598269],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gamma["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "6", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["7.99999999999637356`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gamma[", 3, ",", 2, ",", 6, "]=", 7.9999999999963736],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "6", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["8.`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gammaexact[", 3, ",", 2, ",", 6, "]=", 8.0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "6", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["11.4405204032760621`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 3, ",", 2, ",", 6, "]=", 11.440520403276063],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gamma["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "7", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["9.33333333327614056`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gamma[", 3, ",", 2, ",", 7, "]=", 9.3333333332761406],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "7", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["9.33333333333333392`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "gammaexact[", 3, ",", 2, ",", 7, "]=", 9.3333333333333339],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "7", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["10.2426543799430591`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 3, ",", 2, ",", 7, "]=", 10.24265437994306],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gamma["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "8", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["10.6666666682085997`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gamma[", 3, ",", 2, ",", 8, "]=", 10.666666668208599],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "8", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["10.6666666666666665`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "gammaexact[", 3, ",", 2, ",", 8, "]=", 10.666666666666666],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "8", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["9.81193455211834297`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 3, ",", 2, ",", 8, "]=", 9.811934552118343],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gamma["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "9", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["12.0000000064184342`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gamma[", 3, ",", 2, ",", 9, "]=", 12.000000006418434],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "9", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["11.9999999999999996`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gammaexact[", 3, ",", 2, ",", 9, "]=", 12.0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "9", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["9.19257093482053377`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 3, ",", 2, ",", 9, "]=", 9.1925709348205338],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gamma["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "10", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["13.3333328631775871`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gamma[", 3, ",", 2, ",", 10, "]=", 13.333332863177587],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "10", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["13.3333333333333348`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "gammaexact[", 3, ",", 2, ",", 10, "]=", 13.333333333333334],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "10", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["7.32775825067101393`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 3, ",", 2, ",", 10, "]=", 7.3277582506710139],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gamma["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "11", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["14.6666701327005499`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gamma[", 3, ",", 2, ",", 11, "]=", 14.666670132700549],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "11", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["14.666666666666666`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "gammaexact[", 3, ",", 2, ",", 11, "]=", 14.666666666666666],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "11", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["6.4601671960553002`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 3, ",", 2, ",", 11, "]=", 6.4601671960553002],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gamma["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "12", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["16.0000451649849972`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gamma[", 3, ",", 2, ",", 12, "]=", 16.000045164984996],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "12", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["16.0000000000000008`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gammaexact[", 3, ",", 2, ",", 12, "]=", 16.0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "12", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["5.34519812970212093`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 3, ",", 2, ",", 12, "]=", 5.3451981297021209],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gamma["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "13", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["17.3326988778344563`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gamma[", 3, ",", 2, ",", 13, "]=", 17.332698877834456],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "13", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["17.3333333333333321`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "gammaexact[", 3, ",", 2, ",", 13, "]=", 17.333333333333332],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "13", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["4.19759883420043955`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 3, ",", 2, ",", 13, "]=", 4.1975988342004396],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gamma["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "14", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["18.6679225927270096`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gamma[", 3, ",", 2, ",", 14, "]=", 18.66792259272701],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "14", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["18.6666666666666678`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "gammaexact[", 3, ",", 2, ",", 14, "]=", 18.666666666666668],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "14", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["3.90103592790041453`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 3, ",", 2, ",", 14, "]=", 3.9010359279004145],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gamma["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "15", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["20.0242261757556105`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gamma[", 3, ",", 2, ",", 15, "]=", 20.024226175755611],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "15", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["20.`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gammaexact[", 3, ",", 2, ",", 15, "]=", 20.0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "15", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["2.61571513639141706`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 3, ",", 2, ",", 15, "]=", 2.6157151363914171],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gamma["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "16", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["20.9248915011720182`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gamma[", 3, ",", 2, ",", 16, "]=", 20.92489150117202],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "16", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["21.333333333333333`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "gammaexact[", 3, ",", 2, ",", 16, "]=", 21.333333333333332],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "16", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["1.38886978434603403`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 3, ",", 2, ",", 16, "]=", 1.388869784346034],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gamma["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "17", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["24.7323542021294517`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gamma[", 3, ",", 2, ",", 17, "]=", 24.73235420212945],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "17", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["22.666666666666666`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "gammaexact[", 3, ",", 2, ",", 17, "]=", 22.666666666666668],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "17", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["0.684935371048336349`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 3, ",", 2, ",", 17, "]=", 0.68493537104833635],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gamma["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "18", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["21.8278330692802047`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gamma[", 3, ",", 2, ",", 18, "]=", 21.827833069280203],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "18", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["23.9999999999999991`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gammaexact[", 3, ",", 2, ",", 18, "]=", 24.0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "18", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["0.663106802331486555`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 3, ",", 2, ",", 18, "]=", 0.66310680233148656],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gamma["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "19", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        RowBox[{"-", 
          StyleBox["105.309693881509192`",
            StyleBoxAutoDelete->True,
            PrintPrecision->16]}]}],
      SequenceForm[ "gamma[", 3, ",", 2, ",", 19, "]=", -105.3096938815092],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "19", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["25.3333333333333321`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "gammaexact[", 3, ",", 2, ",", 19, "]=", 25.333333333333332],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "19", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        RowBox[{"-", 
          StyleBox["0.116086235166070306`",
            StyleBoxAutoDelete->True,
            PrintPrecision->2]}]}],
      SequenceForm[ 
      "exactdigits[", 3, ",", 2, ",", 19, "]=", -0.11608623516607031],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gamma["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "20", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        RowBox[{"-", 
          StyleBox["5840.62837260063538`",
            StyleBoxAutoDelete->True,
            PrintPrecision->16]}]}],
      SequenceForm[ "gamma[", 3, ",", 2, ",", 20, "]=", -5840.628372600635],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "20", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["26.6666666666666696`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "gammaexact[", 3, ",", 2, ",", 20, "]=", 26.666666666666668],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "20", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        RowBox[{"-", 
          StyleBox["0.768437927436383283`",
            StyleBoxAutoDelete->True,
            PrintPrecision->2]}]}],
      SequenceForm[ 
      "exactdigits[", 3, ",", 2, ",", 20, "]=", -0.76843792743638328],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    \({29.9333333333333229`\ Second, Null}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(MemoryInUse[]\)], "Input"],

Cell[BoxData[
    \(1165664\)], "Output"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Computing the beta coefficients", "Subsection"],

Cell[BoxData[
    \(\( (*\ set\ the\ values\ of\ d\ and\ nmax\ *) \nd = 3; \ nmax = \ 20\ ; 
    \ \  (*\ for\ example\ *) \)\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(MemoryInUse[]\)], "Input"],

Cell[BoxData[
    \(1167448\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Timing[printbeta[d,nmax,$MachinePrecision,$MachinePrecision,True,\
True]]\
\>", "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    InterpretationBox[
      \("beta["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]0
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "beta[", 3, ",", 0, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("betaexact["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]0
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "betaexact[", 3, ",", 0, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]0
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 3, ",", 0, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("beta["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "beta[", 3, ",", 1, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("betaexact["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "betaexact[", 3, ",", 1, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 3, ",", 1, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("beta["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "beta[", 3, ",", 2, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("betaexact["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "betaexact[", 3, ",", 2, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 3, ",", 2, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("beta["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["0.`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "beta[", 3, ",", 3, "]=", 0.0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("betaexact["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "betaexact[", 3, ",", 3, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("abserror["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\),
         "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["0.`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ "abserror[", 3, ",", 3, "]=", 0.0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("beta["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "4", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        RowBox[{"-", 
          StyleBox["1.84741111297626048`*^-13",
            StyleBoxAutoDelete->True,
            PrintPrecision->16]}]}],
      SequenceForm[ "beta[", 3, ",", 4, "]=", -1.8474111129762605*^-13],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("betaexact["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "betaexact[", 3, ",", 4, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("abserror["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\),
         "\[InvisibleSpace]", "4", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["1.84741111297626048`*^-13",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ "abserror[", 3, ",", 4, "]=", 1.8474111129762605*^-13],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("beta["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "5", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        RowBox[{"-", 
          StyleBox["1.13686837721548172`*^-13",
            StyleBoxAutoDelete->True,
            PrintPrecision->16]}]}],
      SequenceForm[ "beta[", 3, ",", 5, "]=", -1.1368683772154818*^-13],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("betaexact["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "betaexact[", 3, ",", 5, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("abserror["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\),
         "\[InvisibleSpace]", "5", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["1.13686837721548172`*^-13",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ "abserror[", 3, ",", 5, "]=", 1.1368683772154818*^-13],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("beta["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "6", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["1.01863406598484562`*^-11",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "beta[", 3, ",", 6, "]=", 1.0186340659848458*^-11],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("betaexact["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]6
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "betaexact[", 3, ",", 6, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("abserror["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\),
         "\[InvisibleSpace]", "6", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["1.01863406598484562`*^-11",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ "abserror[", 3, ",", 6, "]=", 1.0186340659848458*^-11],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("beta["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "7", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["1.21612434411420688`*^-10",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "beta[", 3, ",", 7, "]=", 1.2161243441142072*^-10],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("betaexact["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]7
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "betaexact[", 3, ",", 7, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("abserror["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\),
         "\[InvisibleSpace]", "7", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["1.21612434411420688`*^-10",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ "abserror[", 3, ",", 7, "]=", 1.2161243441142072*^-10],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("beta["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "8", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        RowBox[{"-", 
          StyleBox["3.16072795950818363`*^-9",
            StyleBoxAutoDelete->True,
            PrintPrecision->16]}]}],
      SequenceForm[ "beta[", 3, ",", 8, "]=", -3.1607279595081838*^-09],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("betaexact["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]8
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "betaexact[", 3, ",", 8, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("abserror["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\),
         "\[InvisibleSpace]", "8", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["3.16072795950818363`*^-9",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ "abserror[", 3, ",", 8, "]=", 3.1607279595081838*^-09],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("beta["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "9", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        RowBox[{"-", 
          StyleBox["8.35390801254411918`*^-9",
            StyleBoxAutoDelete->True,
            PrintPrecision->16]}]}],
      SequenceForm[ "beta[", 3, ",", 9, "]=", -8.3539080125441182*^-09],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("betaexact["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]9
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "betaexact[", 3, ",", 9, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("abserror["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\),
         "\[InvisibleSpace]", "9", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["8.35390801254411918`*^-9",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ "abserror[", 3, ",", 9, "]=", 8.3539080125441182*^-09],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("beta["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "10", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["7.34168227580645016`*^-7",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "beta[", 3, ",", 10, "]=", 7.3416822758064505*^-07],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("betaexact["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]10
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "betaexact[", 3, ",", 10, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("abserror["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\),
         "\[InvisibleSpace]", "10", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["7.34168227580645016`*^-7",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ "abserror[", 3, ",", 10, "]=", 7.3416822758064505*^-07],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("beta["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "11", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        RowBox[{"-", 
          StyleBox["5.30872990047964155`*^-6",
            StyleBoxAutoDelete->True,
            PrintPrecision->16]}]}],
      SequenceForm[ "beta[", 3, ",", 11, "]=", -5.3087299004796419*^-06],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("betaexact["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]11
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "betaexact[", 3, ",", 11, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("abserror["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\),
         "\[InvisibleSpace]", "11", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["5.30872990047964155`*^-6",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ "abserror[", 3, ",", 11, "]=", 5.3087299004796419*^-06],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("beta["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "12", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        RowBox[{"-", 
          StyleBox["0.0000570485168441423162`",
            StyleBoxAutoDelete->True,
            PrintPrecision->16]}]}],
      SequenceForm[ "beta[", 3, ",", 12, "]=", -5.7048516844142327*^-05],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("betaexact["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]12
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "betaexact[", 3, ",", 12, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("abserror["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\),
         "\[InvisibleSpace]", "12", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["0.0000570485168441423162`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ "abserror[", 3, ",", 12, "]=", 5.7048516844142327*^-05],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("beta["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "13", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["0.000773192601778248533`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "beta[", 3, ",", 13, "]=", 0.00077319260177824845],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("betaexact["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]13
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "betaexact[", 3, ",", 13, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("abserror["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\),
         "\[InvisibleSpace]", "13", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["0.000773192601778248533`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ "abserror[", 3, ",", 13, "]=", 0.00077319260177824845],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("beta["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "14", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        RowBox[{"-", 
          StyleBox["0.00148091576270098173`",
            StyleBoxAutoDelete->True,
            PrintPrecision->16]}]}],
      SequenceForm[ "beta[", 3, ",", 14, "]=", -0.0014809157627009815],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("betaexact["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]14
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "betaexact[", 3, ",", 14, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("abserror["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\),
         "\[InvisibleSpace]", "14", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["0.00148091576270098173`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ "abserror[", 3, ",", 14, "]=", 0.0014809157627009815],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("beta["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "15", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        RowBox[{"-", 
          StyleBox["0.0239178084086767483`",
            StyleBoxAutoDelete->True,
            PrintPrecision->16]}]}],
      SequenceForm[ "beta[", 3, ",", 15, "]=", -0.023917808408676751],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("betaexact["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]15
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "betaexact[", 3, ",", 15, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("abserror["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\),
         "\[InvisibleSpace]", "15", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["0.0239178084086767483`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ "abserror[", 3, ",", 15, "]=", 0.023917808408676751],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("beta["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "16", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["0.381722400270239958`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "beta[", 3, ",", 16, "]=", 0.38172240027023996],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("betaexact["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]16
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "betaexact[", 3, ",", 16, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("abserror["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\),
         "\[InvisibleSpace]", "16", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["0.381722400270239958`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ "abserror[", 3, ",", 16, "]=", 0.38172240027023996],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("beta["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "17", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        RowBox[{"-", 
          StyleBox["2.81518840604040967`",
            StyleBoxAutoDelete->True,
            PrintPrecision->16]}]}],
      SequenceForm[ "beta[", 3, ",", 17, "]=", -2.8151884060404098],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("betaexact["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]17
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "betaexact[", 3, ",", 17, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("abserror["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\),
         "\[InvisibleSpace]", "17", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["2.81518840604040967`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ "abserror[", 3, ",", 17, "]=", 2.8151884060404098],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("beta["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "18", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["1.03244012412246477`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "beta[", 3, ",", 18, "]=", 1.0324401241224648],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("betaexact["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]18
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "betaexact[", 3, ",", 18, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("abserror["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\),
         "\[InvisibleSpace]", "18", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["1.03244012412246477`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ "abserror[", 3, ",", 18, "]=", 1.0324401241224648],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("beta["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "19", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["83.4684271804607114`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "beta[", 3, ",", 19, "]=", 83.468427180460708],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("betaexact["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]19
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "betaexact[", 3, ",", 19, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("abserror["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\),
         "\[InvisibleSpace]", "19", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["83.4684271804607114`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ "abserror[", 3, ",", 19, "]=", 83.468427180460708],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    \({10.1333333333333253`\ Second, Null}\)], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(MemoryInUse[]\)], "Input"],

Cell[BoxData[
    \(1170560\)], "Output"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Computing the d-orthogonal polynomials", "Subsection"],

Cell[BoxData[
    \(\( (*\ set\ the\ values\ of\ d\ and\ nmax\ *) \nd = 3; \ nmax = \ 15\ ; 
    \ \ \  (*\ for\ example\ *) \)\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(MemoryInUse[]\)], "Input"],

Cell[BoxData[
    \(1172344\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Timing[printdorthpoly[d,nmax,x,$MachinePrecision]]", "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("dorthpoly["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "x", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["1.`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "dorthpoly[", 3, ",", 0, ",", x, "]=", 1.0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("dorthpoly["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]x
        \[InvisibleSpace]"]="\[InvisibleSpace]x\),
      SequenceForm[ "dorthpoly[", 3, ",", 1, ",", x, "]=", x],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("dorthpoly["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "x", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        RowBox[{
          RowBox[{"-", 
            StyleBox["1.33333333333333325`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16]}], "+", \(x\^2\)}]}],
      SequenceForm[ "dorthpoly[", 3, ",", 2, ",", x, "]=", 
        Plus[ -1.3333333333333333, 
          Power[ x, 2]]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("dorthpoly["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "x", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        RowBox[{
          RowBox[{"-", 
            StyleBox["1.5`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16]}], "-", 
          RowBox[{
            StyleBox["4.`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", "x"}], "+", \(x\^3\)}]}],
      SequenceForm[ "dorthpoly[", 3, ",", 3, ",", x, "]=", 
        Plus[ -1.5, 
          Times[ -4.0, x], 
          Power[ x, 3]]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("dorthpoly["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "4", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "x", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        RowBox[{
          RowBox[{
            StyleBox["5.08333333333333392`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], "\[InvisibleSpace]"}], "-", 
          RowBox[{
            StyleBox["6.`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", "x"}], "-", 
          RowBox[{
            StyleBox["8.`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^2\)}], "+", 
          RowBox[{
            StyleBox["0.`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^3\)}], "+", \(x\^4\)}]}],
      SequenceForm[ "dorthpoly[", 3, ",", 4, ",", x, "]=", 
        Plus[ 5.0833333333333339, 
          Times[ -6.0, x], 
          Times[ -8.0, 
            Power[ x, 2]], 
          Times[ 0.0, 
            Power[ x, 3]], 
          Power[ x, 4]]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("dorthpoly["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "x", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        RowBox[{
          RowBox[{
            StyleBox["20.0000000000010036`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], "\[InvisibleSpace]"}], "+", 
          RowBox[{
            StyleBox["25.4166666666657192`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", "x"}], "-", 
          RowBox[{
            StyleBox["15.0000000000014788`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^2\)}], "-", 
          RowBox[{
            StyleBox["13.3333333333333747`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^3\)}], "+", 
          RowBox[{
            StyleBox["1.84741111297626048`*^-13",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^4\)}], "+", \(x\^5\)}]}],
      SequenceForm[ "dorthpoly[", 3, ",", 5, ",", x, "]=", 
        Plus[ 20.000000000001002, 
          Times[ 25.416666666665719, x], 
          Times[ -15.000000000001478, 
            Power[ x, 2]], 
          Times[ -13.333333333333375, 
            Power[ x, 3]], 
          Times[ 1.8474111129762605*^-13, 
            Power[ x, 4]], 
          Power[ x, 5]]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("dorthpoly["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "6", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "x", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        RowBox[{
          RowBox[{"-", 
            StyleBox["8.05555555555009306`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16]}], "+", 
          RowBox[{
            StyleBox["120.000000000008055`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", "x"}], "+", 
          RowBox[{
            StyleBox["76.2499999999962341`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^2\)}], "-", 
          RowBox[{
            StyleBox["30.0000000000039568`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^3\)}], "-", 
          RowBox[{
            StyleBox["20.0000000000000888`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^4\)}], "+", 
          RowBox[{
            StyleBox["2.98427949019174221`*^-13",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^5\)}], "+", \(x\^6\)}]}],
      SequenceForm[ "dorthpoly[", 3, ",", 6, ",", x, "]=", 
        Plus[ -8.0555555555500931, 
          Times[ 120.00000000000804, x], 
          Times[ 76.249999999996234, 
            Power[ x, 2]], 
          Times[ -30.000000000003958, 
            Power[ x, 3]], 
          Times[ -20.000000000000089, 
            Power[ x, 4]], 
          Times[ 2.9842794901917422*^-13, 
            Power[ x, 5]], 
          Power[ x, 6]]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("dorthpoly["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "7", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "x", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        RowBox[{
          RowBox[{"-", 
            StyleBox["266.874999999855733`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16]}], "-", 
          RowBox[{
            StyleBox["56.3888888899796292`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", "x"}], "+", 
          RowBox[{
            StyleBox["419.999999999202078`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^2\)}], "+", 
          RowBox[{
            StyleBox["177.916666666916327`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^3\)}], "-", 
          RowBox[{
            StyleBox["52.499999999803375`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^4\)}], "-", 
          RowBox[{
            StyleBox["27.9999999999964632`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^5\)}], "-", 
          RowBox[{
            StyleBox["9.88791271082928346`*^-12",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^6\)}], "+", \(x\^7\)}]}],
      SequenceForm[ "dorthpoly[", 3, ",", 7, ",", x, "]=", 
        Plus[ -266.87499999985573, 
          Times[ -56.388888889979626, x], 
          Times[ 419.99999999920209, 
            Power[ x, 2]], 
          Times[ 177.91666666691634, 
            Power[ x, 3]], 
          Times[ -52.499999999803379, 
            Power[ x, 4]], 
          Times[ -27.999999999996461, 
            Power[ x, 5]], 
          Times[ -9.8879127108292833*^-12, 
            Power[ x, 6]], 
          Power[ x, 7]]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("dorthpoly["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "8", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "x", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        RowBox[{
          RowBox[{"-", 
            StyleBox["599.293981447308166`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16]}], "-", 
          RowBox[{
            StyleBox["2134.99999998593015`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", "x"}], "-", 
          RowBox[{
            StyleBox["225.555555605858426`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^2\)}], "+", 
          RowBox[{
            StyleBox["1119.9999999750938`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^3\)}], "+", 
          RowBox[{
            StyleBox["355.833333339029334`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^4\)}], "-", 
          RowBox[{
            StyleBox["83.9999999963414722`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^5\)}], "-", 
          RowBox[{
            StyleBox["37.3333333332726047`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^6\)}], "-", 
          RowBox[{
            StyleBox["1.31500347122250005`*^-10",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^7\)}], "+", \(x\^8\)}]}],
      SequenceForm[ "dorthpoly[", 3, ",", 8, ",", x, "]=", 
        Plus[ -599.29398144730817, 
          Times[ -2134.9999999859301, x], 
          Times[ -225.55555560585844, 
            Power[ x, 2]], 
          Times[ 1119.9999999750937, 
            Power[ x, 3]], 
          Times[ 355.83333333902937, 
            Power[ x, 4]], 
          Times[ -83.999999996341472, 
            Power[ x, 5]], 
          Times[ -37.333333333272606, 
            Power[ x, 6]], 
          Times[ -1.3150034712224999*^-10, 
            Power[ x, 7]], 
          Power[ x, 8]]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("dorthpoly["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "9", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "x", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        RowBox[{
          RowBox[{
            StyleBox["2904.99999857054991`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], "\[InvisibleSpace]"}], "-", 
          RowBox[{
            StyleBox["5393.645839647486`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", "x"}], "-", 
          RowBox[{
            StyleBox["9607.50000125418068`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^2\)}], "-", 
          RowBox[{
            StyleBox["676.666663553383251`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^3\)}], "+", 
          RowBox[{
            StyleBox["2520.0000011430701`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^4\)}], "+", 
          RowBox[{
            StyleBox["640.499999786786666`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^5\)}], "-", 
          RowBox[{
            StyleBox["126.000000112457977`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^6\)}], "-", 
          RowBox[{
            StyleBox["48.0000000014812044`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^7\)}], "+", 
          RowBox[{
            StyleBox["3.02922761238593407`*^-9",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^8\)}], "+", \(x\^9\)}]}],
      SequenceForm[ "dorthpoly[", 3, ",", 9, ",", x, "]=", 
        Plus[ 2904.9999985705499, 
          Times[ -5393.6458396474854, x], 
          Times[ -9607.5000012541805, 
            Power[ x, 2]], 
          Times[ -676.66666355338316, 
            Power[ x, 3]], 
          Times[ 2520.0000011430702, 
            Power[ x, 4]], 
          Times[ 640.4999997867867, 
            Power[ x, 5]], 
          Times[ -126.00000011245797, 
            Power[ x, 6]], 
          Times[ -48.000000001481204, 
            Power[ x, 7]], 
          Times[ 3.0292276123859336*^-09, 
            Power[ x, 8]], 
          Power[ x, 9]]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("dorthpoly["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "10", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "x", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        RowBox[{
          RowBox[{
            StyleBox["21771.9444810305562`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], "\[InvisibleSpace]"}], "+", 
          RowBox[{
            StyleBox["29049.9999549470988`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", "x"}], "-", 
          RowBox[{
            StyleBox["26968.2292724688066`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^2\)}], "-", 
          RowBox[{
            StyleBox["32025.0000156568948`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^3\)}], "-", 
          RowBox[{
            StyleBox["1691.66664099165098`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^4\)}], "+", 
          RowBox[{
            StyleBox["5040.00000782398149`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^5\)}], "+", 
          RowBox[{
            StyleBox["1067.49999885828228`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^6\)}], "-", 
          RowBox[{
            StyleBox["180.000000541695541`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^7\)}], "-", 
          RowBox[{
            StyleBox["60.0000000078996365`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^8\)}], "+", 
          RowBox[{
            StyleBox["1.13831356249300541`*^-8",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^9\)}], "+", \(x\^10\)}]}],
      SequenceForm[ "dorthpoly[", 3, ",", 10, ",", x, "]=", 
        Plus[ 21771.944481030554, 
          Times[ 29049.999954947096, x], 
          Times[ -26968.229272468809, 
            Power[ x, 2]], 
          Times[ -32025.000015656897, 
            Power[ x, 3]], 
          Times[ -1691.6666409916511, 
            Power[ x, 4]], 
          Times[ 5040.0000078239809, 
            Power[ x, 5]], 
          Times[ 1067.4999988582822, 
            Power[ x, 6]], 
          Times[ -180.00000054169553, 
            Power[ x, 7]], 
          Times[ -60.000000007899637, 
            Power[ x, 8]], 
          Times[ 1.1383135624930053*^-08, 
            Power[ x, 9]], 
          Power[ x, 10]]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("dorthpoly["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "11", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "x", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        RowBox[{
          RowBox[{
            StyleBox["9725.24614702606093`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], "\[InvisibleSpace]"}], "+", 
          RowBox[{
            StyleBox["239491.365951538082`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", "x"}], "+", 
          RowBox[{
            StyleBox["159775.015162998634`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^2\)}], "-", 
          RowBox[{
            StyleBox["98883.4843819217645`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^3\)}], "-", 
          RowBox[{
            StyleBox["88068.7477128213025`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^4\)}], "-", 
          RowBox[{
            StyleBox["3721.66999488630967`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^5\)}], "+", 
          RowBox[{
            StyleBox["9239.99918003802633`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^6\)}], "+", 
          RowBox[{
            StyleBox["1677.50010804839959`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^7\)}], "-", 
          RowBox[{
            StyleBox["247.499956898490136`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^8\)}], "-", 
          RowBox[{
            StyleBox["73.3333328710772303`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^9\)}], "-", 
          RowBox[{
            StyleBox["7.22785091955715053`*^-7",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^10\)}], "+", \(x\^11\)}]}],
      SequenceForm[ "dorthpoly[", 3, ",", 11, ",", x, "]=", 
        Plus[ 9725.2461470260605, 
          Times[ 239491.36595153809, x], 
          Times[ 159775.01516299864, 
            Power[ x, 2]], 
          Times[ -98883.484381921749, 
            Power[ x, 3]], 
          Times[ -88068.747712821292, 
            Power[ x, 4]], 
          Times[ -3721.6699948863097, 
            Power[ x, 5]], 
          Times[ 9239.9991800380267, 
            Power[ x, 6]], 
          Times[ 1677.5001080483996, 
            Power[ x, 7]], 
          Times[ -247.49995689849015, 
            Power[ x, 8]], 
          Times[ -73.333332871077232, 
            Power[ x, 9]], 
          Times[ -7.2278509195571501*^-07, 
            Power[ x, 10]], 
          Power[ x, 11]]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("dorthpoly["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "12", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "x", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        RowBox[{
          RowBox[{"-", 
            StyleBox["534263.490291619458`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16]}], "+", 
          RowBox[{
            StyleBox["116704.128404121609`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", "x"}], "+", 
          RowBox[{
            StyleBox["1.43694913033868365`*^6",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^2\)}], "+", 
          RowBox[{
            StyleBox["639099.640542054281`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^3\)}], "-", 
          RowBox[{
            StyleBox["296650.91549964746`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^4\)}], "-", 
          RowBox[{
            StyleBox["211365.030999016667`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^5\)}], "-", 
          RowBox[{
            StyleBox["7443.29435497246372`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^6\)}], "+", 
          RowBox[{
            StyleBox["15840.0081485857064`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^7\)}], "+", 
          RowBox[{
            StyleBox["2516.2490442604235`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^8\)}], "-", 
          RowBox[{
            StyleBox["330.000334522177007`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^9\)}], "-", 
          RowBox[{
            StyleBox["88.0000030037816216`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^10\)}], "+", 
          RowBox[{
            StyleBox["4.58594480852392649`*^-6",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^11\)}], "+", \(x\^12\)}]}],
      SequenceForm[ "dorthpoly[", 3, ",", 12, ",", x, "]=", 
        Plus[ -534263.49029161944, 
          Times[ 116704.12840412161, x], 
          Times[ 1436949.1303386837, 
            Power[ x, 2]], 
          Times[ 639099.64054205432, 
            Power[ x, 3]], 
          Times[ -296650.91549964744, 
            Power[ x, 4]], 
          Times[ -211365.03099901666, 
            Power[ x, 5]], 
          Times[ -7443.2943549724641, 
            Power[ x, 6]], 
          Times[ 15840.008148585708, 
            Power[ x, 7]], 
          Times[ 2516.2490442604235, 
            Power[ x, 8]], 
          Times[ -330.00033452217701, 
            Power[ x, 9]], 
          Times[ -88.000003003781615, 
            Power[ x, 10]], 
          Times[ 4.5859448085239266*^-06, 
            Power[ x, 11]], 
          Power[ x, 12]]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("dorthpoly["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "13", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "x", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        RowBox[{
          RowBox[{"-", 
            StyleBox["2.47083438478152617`*^6",
              StyleBoxAutoDelete->True,
              PrintPrecision->16]}], "-", 
          RowBox[{
            StyleBox["6.9454284244478206`*^6",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", "x"}], "+", 
          RowBox[{
            StyleBox["758650.461944307696`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^2\)}], "+", 
          RowBox[{
            StyleBox["6.22681918930283551`*^6",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^3\)}], "+", 
          RowBox[{
            StyleBox["2.07706084841852156`*^6",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^4\)}], "-", 
          RowBox[{
            StyleBox["771304.043784593496`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^5\)}], "-", 
          RowBox[{
            StyleBox["457958.364705280196`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^6\)}], "-", 
          RowBox[{
            StyleBox["13822.442982601828`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^7\)}], "+", 
          RowBox[{
            StyleBox["25740.164954121667`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^8\)}], "+", 
          RowBox[{
            StyleBox["3634.56650391244995`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^9\)}], "-", 
          RowBox[{
            StyleBox["429.005389359517153`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^10\)}], "-", 
          RowBox[{
            StyleBox["104.000048168504988`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^11\)}], "+", 
          RowBox[{
            StyleBox["0.0000616344616526662569`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^12\)}], "+", \(x\^13\)}]}],
      SequenceForm[ "dorthpoly[", 3, ",", 13, ",", x, "]=", 
        Plus[ -2470834.3847815259, 
          Times[ -6945428.4244478196, x], 
          Times[ 758650.46194430767, 
            Power[ x, 2]], 
          Times[ 6226819.1893028356, 
            Power[ x, 3]], 
          Times[ 2077060.8484185217, 
            Power[ x, 4]], 
          Times[ -771304.04378459346, 
            Power[ x, 5]], 
          Times[ -457958.36470528017, 
            Power[ x, 6]], 
          Times[ -13822.442982601828, 
            Power[ x, 7]], 
          Times[ 25740.164954121668, 
            Power[ x, 8]], 
          Times[ 3634.5665039124497, 
            Power[ x, 9]], 
          Times[ -429.00538935951715, 
            Power[ x, 10]], 
          Times[ -104.00004816850499, 
            Power[ x, 11]], 
          Times[ 6.1634461652666249*^-05, 
            Power[ x, 12]], 
          Power[ x, 13]]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("dorthpoly["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "14", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "x", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        RowBox[{
          StyleBox["6.56746412524635125`*^6",
            StyleBoxAutoDelete->True,
            PrintPrecision->16], "-", 
          RowBox[{
            StyleBox["3.45863097676143649`*^7",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", "x"}], "-", 
          RowBox[{
            StyleBox["4.8617751384377783`*^7",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^2\)}], "+", 
          RowBox[{
            StyleBox["3.53597312673919006`*^6",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^3\)}], "+", 
          RowBox[{
            StyleBox["2.17921028088839641`*^7",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^4\)}], "+", 
          RowBox[{
            StyleBox["5.81623800027486481`*^6",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^5\)}], "-", 
          RowBox[{
            StyleBox["1.79936209396673945`*^6",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^6\)}], "-", 
          RowBox[{
            StyleBox["915896.67237564587`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^7\)}], "-", 
          RowBox[{
            StyleBox["24207.5819003510961`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^8\)}], "+", 
          RowBox[{
            StyleBox["40037.2528241998715`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^9\)}], "+", 
          RowBox[{
            StyleBox["5088.67064691069437`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^10\)}], "-", 
          RowBox[{
            StyleBox["545.926443829180829`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^11\)}], "-", 
          RowBox[{
            StyleBox["121.332747093994752`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^12\)}], "-", 
          RowBox[{
            StyleBox["0.000711558140125582205`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^13\)}], "+", \(x\^14\)}]}],
      SequenceForm[ "dorthpoly[", 3, ",", 14, ",", x, "]=", 
        Plus[ 6567464.1252463516, 
          Times[ -34586309.767614365, x], 
          Times[ -48617751.384377785, 
            Power[ x, 2]], 
          Times[ 3535973.12673919, 
            Power[ x, 3]], 
          Times[ 21792102.808883965, 
            Power[ x, 4]], 
          Times[ 5816238.000274865, 
            Power[ x, 5]], 
          Times[ -1799362.0939667395, 
            Power[ x, 6]], 
          Times[ -915896.67237564584, 
            Power[ x, 7]], 
          Times[ -24207.581900351091, 
            Power[ x, 8]], 
          Times[ 40037.252824199866, 
            Power[ x, 9]], 
          Times[ 5088.6706469106939, 
            Power[ x, 10]], 
          Times[ -545.92644382918081, 
            Power[ x, 11]], 
          Times[ -121.33274709399475, 
            Power[ x, 12]], 
          Times[ -0.00071155814012558219, 
            Power[ x, 13]], 
          Power[ x, 14]]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("dorthpoly["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "15", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "x", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        RowBox[{
          StyleBox["1.18170020303797285`*^8",
            StyleBoxAutoDelete->True,
            PrintPrecision->16], "+", 
          RowBox[{
            StyleBox["9.84682837386548293`*^7",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", "x"}], "-", 
          RowBox[{
            StyleBox["2.59471385390427666`*^8",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^2\)}], "-", 
          RowBox[{
            StyleBox["2.43090960679108336`*^8",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^3\)}], "+", 
          RowBox[{
            StyleBox["1.32902289295756292`*^7",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^4\)}], "+", 
          RowBox[{
            StyleBox["6.53860301792323372`*^7",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^5\)}], "+", 
          RowBox[{
            StyleBox["1.45384402572002553`*^7",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^6\)}], "-", 
          RowBox[{
            StyleBox["3.85714436098388944`*^6",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^7\)}], "-", 
          RowBox[{
            StyleBox["1.71737506971119247`*^6",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^8\)}], "-", 
          RowBox[{
            StyleBox["40289.8368814508245`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^9\)}], "+", 
          RowBox[{
            StyleBox["60064.1555993555265`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^10\)}], "+", 
          RowBox[{
            StyleBox["6938.3992967199557`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^11\)}], "-", 
          RowBox[{
            StyleBox["682.592812158604367`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^12\)}], "-", 
          RowBox[{
            StyleBox["140.000670740479442`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^13\)}], "+", 
          RowBox[{
            StyleBox["0.000769357622575399435`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^14\)}], "+", \(x\^15\)}]}],
      SequenceForm[ "dorthpoly[", 3, ",", 15, ",", x, "]=", 
        Plus[ 118170020.30379729, 
          Times[ 98468283.738654837, x], 
          Times[ -259471385.39042768, 
            Power[ x, 2]], 
          Times[ -243090960.67910832, 
            Power[ x, 3]], 
          Times[ 13290228.92957563, 
            Power[ x, 4]], 
          Times[ 65386030.179232344, 
            Power[ x, 5]], 
          Times[ 14538440.257200256, 
            Power[ x, 6]], 
          Times[ -3857144.3609838895, 
            Power[ x, 7]], 
          Times[ -1717375.0697111923, 
            Power[ x, 8]], 
          Times[ -40289.836881450821, 
            Power[ x, 9]], 
          Times[ 60064.155599355523, 
            Power[ x, 10]], 
          Times[ 6938.3992967199556, 
            Power[ x, 11]], 
          Times[ -682.59281215860437, 
            Power[ x, 12]], 
          Times[ -140.00067074047945, 
            Power[ x, 13]], 
          Times[ 0.00076935762257539936, 
            Power[ x, 14]], 
          Power[ x, 15]]],
      Editable->False]], "Print"],

Cell[BoxData[
    \({2.4333333333333087`\ Second, Null}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(MemoryInUse[]\)], "Input"],

Cell[BoxData[
    \(1184440\)], "Output"]
}, Open  ]]
}, Closed]]
}, Closed]]
},
FrontEndVersion->"Macintosh 3.0",
ScreenRectangle->{{0, 832}, {0, 604}},
WindowSize->{590, 412},
WindowMargins->{{Automatic, 87}, {Automatic, 66}},
MacintoshSystemPageSetup->"\<\
00<0001804P000000`d26_oQon@3:`8g0dL5N`?P0080001804P000000]P2:001
0000I00000400`<30?l00BL?00400@0000000000000006P801T1T00000000000
00000000004000000000000000000000\>"
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{
Cell[1709, 49, 1281, 21, 612, "Subsection"],

Cell[CellGroupData[{
Cell[3015, 74, 154, 4, 68, "Section"],

Cell[CellGroupData[{
Cell[3194, 82, 106, 3, 44, "Subsection"],
Cell[3303, 87, 56, 1, 27, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[3396, 93, 133, 4, 44, "Subsection"],
Cell[3532, 99, 71, 1, 27, "Input"],
Cell[3606, 102, 142, 2, 43, "Input"],

Cell[CellGroupData[{
Cell[3773, 108, 249, 5, 59, "Input"],
Cell[4025, 115, 298, 6, 22, "Print"],
Cell[4326, 123, 298, 6, 22, "Print"],
Cell[4627, 131, 324, 7, 38, "Print"],
Cell[4954, 140, 324, 7, 38, "Print"],
Cell[5281, 149, 328, 7, 38, "Print"],
Cell[5612, 158, 300, 6, 22, "Print"],
Cell[5915, 166, 332, 7, 38, "Print"],
Cell[6250, 175, 330, 7, 38, "Print"],
Cell[6583, 184, 338, 7, 38, "Print"],
Cell[6924, 193, 304, 6, 22, "Print"],
Cell[7231, 201, 338, 7, 38, "Print"],
Cell[7572, 210, 55, 1, 22, "Print"],
Cell[7630, 213, 298, 6, 22, "Print"],
Cell[7931, 221, 298, 6, 22, "Print"],
Cell[8232, 229, 298, 6, 22, "Print"],
Cell[8533, 237, 298, 6, 22, "Print"],
Cell[8834, 245, 298, 6, 22, "Print"],
Cell[9135, 253, 330, 7, 38, "Print"],
Cell[9468, 262, 302, 6, 22, "Print"],
Cell[9773, 270, 332, 7, 38, "Print"],
Cell[10108, 279, 304, 6, 22, "Print"],
Cell[10415, 287, 336, 7, 38, "Print"],
Cell[10754, 296, 308, 6, 22, "Print"],
Cell[11065, 304, 55, 1, 22, "Print"],
Cell[11123, 307, 298, 6, 22, "Print"],
Cell[11424, 315, 298, 6, 22, "Print"],
Cell[11725, 323, 298, 6, 22, "Print"],
Cell[12026, 331, 298, 6, 22, "Print"],
Cell[12327, 339, 298, 6, 22, "Print"],
Cell[12628, 347, 300, 6, 22, "Print"],
Cell[12931, 355, 328, 7, 38, "Print"],
Cell[13262, 364, 302, 6, 22, "Print"],
Cell[13567, 372, 332, 7, 38, "Print"],
Cell[13902, 381, 332, 7, 38, "Print"],
Cell[14237, 390, 340, 7, 38, "Print"],
Cell[14580, 399, 55, 1, 22, "Print"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{
Cell[14684, 406, 54, 0, 28, "Subsection"],

Cell[CellGroupData[{
Cell[14763, 410, 142, 2, 43, "Input"],
Cell[14908, 414, 175, 3, 37, "Message"]
}, Open  ]],

Cell[CellGroupData[{
Cell[15120, 422, 46, 1, 27, "Input"],
Cell[15169, 425, 40, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[15246, 431, 117, 4, 42, "Input"],
Cell[15366, 437, 38, 1, 22, "Print"],
Cell[15407, 440, 326, 7, 38, "Print"],
Cell[15736, 449, 336, 7, 38, "Print"],
Cell[16075, 458, 37, 1, 22, "Print"],
Cell[16115, 461, 300, 6, 22, "Print"],
Cell[16418, 469, 310, 6, 22, "Print"],
Cell[16731, 477, 37, 1, 22, "Print"],
Cell[16771, 480, 326, 7, 38, "Print"],
Cell[17100, 489, 336, 7, 38, "Print"],
Cell[17439, 498, 37, 1, 22, "Print"],
Cell[17479, 501, 300, 6, 22, "Print"],
Cell[17782, 509, 310, 6, 22, "Print"],
Cell[18095, 517, 37, 1, 22, "Print"],
Cell[18135, 520, 328, 7, 38, "Print"],
Cell[18466, 529, 338, 7, 38, "Print"],
Cell[18807, 538, 37, 1, 22, "Print"],
Cell[18847, 541, 302, 6, 22, "Print"],
Cell[19152, 549, 312, 6, 22, "Print"],
Cell[19467, 557, 37, 1, 22, "Print"],
Cell[19507, 560, 302, 6, 22, "Print"],
Cell[19812, 568, 312, 6, 22, "Print"],
Cell[20127, 576, 37, 1, 22, "Print"],
Cell[20167, 579, 302, 6, 22, "Print"],
Cell[20472, 587, 312, 6, 22, "Print"],
Cell[20787, 595, 37, 1, 22, "Print"],
Cell[20827, 598, 38, 1, 22, "Print"],
Cell[20868, 601, 326, 7, 38, "Print"],
Cell[21197, 610, 336, 7, 38, "Print"],
Cell[21536, 619, 37, 1, 22, "Print"],
Cell[21576, 622, 326, 7, 38, "Print"],
Cell[21905, 631, 336, 7, 38, "Print"],
Cell[22244, 640, 37, 1, 22, "Print"],
Cell[22284, 643, 300, 6, 22, "Print"],
Cell[22587, 651, 310, 6, 22, "Print"],
Cell[22900, 659, 37, 1, 22, "Print"],
Cell[22940, 662, 302, 6, 22, "Print"],
Cell[23245, 670, 312, 6, 22, "Print"],
Cell[23560, 678, 37, 1, 22, "Print"],
Cell[23600, 681, 328, 7, 38, "Print"],
Cell[23931, 690, 338, 7, 38, "Print"],
Cell[24272, 699, 37, 1, 22, "Print"],
Cell[24312, 702, 328, 7, 38, "Print"],
Cell[24643, 711, 338, 7, 38, "Print"],
Cell[24984, 720, 37, 1, 22, "Print"],
Cell[25024, 723, 302, 6, 22, "Print"],
Cell[25329, 731, 312, 6, 22, "Print"],
Cell[25644, 739, 37, 1, 22, "Print"],
Cell[25684, 742, 302, 6, 22, "Print"],
Cell[25989, 750, 312, 6, 22, "Print"],
Cell[26304, 758, 37, 1, 22, "Print"],
Cell[26344, 761, 330, 7, 38, "Print"],
Cell[26677, 770, 340, 7, 38, "Print"],
Cell[27020, 779, 37, 1, 22, "Print"],
Cell[27060, 782, 38, 1, 22, "Print"],
Cell[27101, 785, 326, 7, 38, "Print"],
Cell[27430, 794, 336, 7, 38, "Print"],
Cell[27769, 803, 37, 1, 22, "Print"],
Cell[27809, 806, 326, 7, 38, "Print"],
Cell[28138, 815, 336, 7, 38, "Print"],
Cell[28477, 824, 37, 1, 22, "Print"],
Cell[28517, 827, 300, 6, 22, "Print"],
Cell[28820, 835, 310, 6, 22, "Print"],
Cell[29133, 843, 37, 1, 22, "Print"],
Cell[29173, 846, 328, 7, 38, "Print"],
Cell[29504, 855, 338, 7, 38, "Print"],
Cell[29845, 864, 37, 1, 22, "Print"],
Cell[29885, 867, 328, 7, 38, "Print"],
Cell[30216, 876, 338, 7, 38, "Print"],
Cell[30557, 885, 37, 1, 22, "Print"],
Cell[30597, 888, 300, 6, 22, "Print"],
Cell[30900, 896, 310, 6, 22, "Print"],
Cell[31213, 904, 37, 1, 22, "Print"],
Cell[31253, 907, 328, 7, 38, "Print"],
Cell[31584, 916, 338, 7, 38, "Print"],
Cell[31925, 925, 37, 1, 22, "Print"],
Cell[31965, 928, 328, 7, 38, "Print"],
Cell[32296, 937, 338, 7, 38, "Print"],
Cell[32637, 946, 37, 1, 22, "Print"],
Cell[32677, 949, 302, 6, 22, "Print"],
Cell[32982, 957, 312, 6, 22, "Print"],
Cell[33297, 965, 37, 1, 22, "Print"],
Cell[33337, 968, 330, 7, 38, "Print"],
Cell[33670, 977, 340, 7, 38, "Print"],
Cell[34013, 986, 37, 1, 22, "Print"],
Cell[34053, 989, 70, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[34160, 995, 46, 1, 27, "Input"],
Cell[34209, 998, 41, 1, 26, "Output"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{
Cell[34299, 1005, 53, 0, 28, "Subsection"],
Cell[34355, 1007, 142, 2, 43, "Input"],

Cell[CellGroupData[{
Cell[34522, 1013, 46, 1, 27, "Input"],
Cell[34571, 1016, 41, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[34649, 1022, 116, 4, 42, "Input"],
Cell[34768, 1028, 243, 5, 22, "Print"],
Cell[35014, 1035, 253, 5, 22, "Print"],
Cell[35270, 1042, 37, 1, 22, "Print"],
Cell[35310, 1045, 243, 5, 22, "Print"],
Cell[35556, 1052, 253, 5, 22, "Print"],
Cell[35812, 1059, 37, 1, 22, "Print"],
Cell[35852, 1062, 243, 5, 22, "Print"],
Cell[36098, 1069, 253, 5, 22, "Print"],
Cell[36354, 1076, 37, 1, 22, "Print"],
Cell[36394, 1079, 243, 5, 22, "Print"],
Cell[36640, 1086, 253, 5, 22, "Print"],
Cell[36896, 1093, 37, 1, 22, "Print"],
Cell[36936, 1096, 243, 5, 22, "Print"],
Cell[37182, 1103, 253, 5, 22, "Print"],
Cell[37438, 1110, 37, 1, 22, "Print"],
Cell[37478, 1113, 243, 5, 22, "Print"],
Cell[37724, 1120, 253, 5, 22, "Print"],
Cell[37980, 1127, 37, 1, 22, "Print"],
Cell[38020, 1130, 243, 5, 22, "Print"],
Cell[38266, 1137, 253, 5, 22, "Print"],
Cell[38522, 1144, 37, 1, 22, "Print"],
Cell[38562, 1147, 243, 5, 22, "Print"],
Cell[38808, 1154, 253, 5, 22, "Print"],
Cell[39064, 1161, 37, 1, 22, "Print"],
Cell[39104, 1164, 243, 5, 22, "Print"],
Cell[39350, 1171, 253, 5, 22, "Print"],
Cell[39606, 1178, 37, 1, 22, "Print"],
Cell[39646, 1181, 243, 5, 22, "Print"],
Cell[39892, 1188, 253, 5, 22, "Print"],
Cell[40148, 1195, 37, 1, 22, "Print"],
Cell[40188, 1198, 70, 1, 26, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[40295, 1204, 46, 1, 24, "Input"],
Cell[40344, 1207, 41, 1, 26, "Output"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{
Cell[40434, 1214, 60, 0, 28, "Subsection"],
Cell[40497, 1216, 142, 2, 43, "Input"],

Cell[CellGroupData[{
Cell[40664, 1222, 46, 1, 27, "Input"],
Cell[40713, 1225, 41, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[40791, 1231, 84, 1, 27, "Input"],
Cell[40878, 1234, 308, 6, 22, "Print"],
Cell[41189, 1242, 308, 6, 22, "Print"],
Cell[41500, 1250, 396, 9, 38, "Print"],
Cell[41899, 1261, 436, 11, 38, "Print"],
Cell[42338, 1274, 496, 13, 38, "Print"],
Cell[42837, 1289, 603, 16, 40, "Print"],
Cell[43443, 1307, 670, 18, 40, "Print"],
Cell[44116, 1327, 823, 23, 40, "Print"],
Cell[44942, 1352, 895, 25, 58, "Print"],
Cell[45840, 1379, 959, 27, 58, "Print"],
Cell[46802, 1408, 1032, 29, 77, "Print"],
Cell[47837, 1439, 70, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[47944, 1445, 46, 1, 27, "Input"],
Cell[47993, 1448, 41, 1, 26, "Output"]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[48095, 1456, 187, 5, 66, "Section"],

Cell[CellGroupData[{
Cell[48307, 1465, 106, 3, 44, "Subsection"],
Cell[48416, 1470, 56, 1, 27, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[48509, 1476, 54, 0, 44, "Subsection"],
Cell[48566, 1478, 142, 2, 43, "Input"],

Cell[CellGroupData[{
Cell[48733, 1484, 46, 1, 27, "Input"],
Cell[48782, 1487, 40, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[48859, 1493, 125, 4, 42, "Input"],
Cell[48987, 1499, 38, 1, 22, "Print"],
Cell[49028, 1502, 511, 11, 22, "Print"],
Cell[49542, 1515, 490, 11, 22, "Print"],
Cell[50035, 1528, 526, 12, 22, "Print"],
Cell[50564, 1542, 37, 1, 22, "Print"],
Cell[50604, 1545, 477, 11, 22, "Print"],
Cell[51084, 1558, 487, 11, 22, "Print"],
Cell[51574, 1571, 498, 11, 22, "Print"],
Cell[52075, 1584, 37, 1, 22, "Print"],
Cell[52115, 1587, 509, 11, 22, "Print"],
Cell[52627, 1600, 488, 11, 22, "Print"],
Cell[53118, 1613, 527, 12, 22, "Print"],
Cell[53648, 1627, 37, 1, 22, "Print"],
Cell[53688, 1630, 508, 11, 22, "Print"],
Cell[54199, 1643, 487, 11, 22, "Print"],
Cell[54689, 1656, 527, 12, 22, "Print"],
Cell[55219, 1670, 37, 1, 22, "Print"],
Cell[55259, 1673, 508, 11, 22, "Print"],
Cell[55770, 1686, 490, 11, 22, "Print"],
Cell[56263, 1699, 527, 12, 22, "Print"],
Cell[56793, 1713, 37, 1, 22, "Print"],
Cell[56833, 1716, 509, 11, 22, "Print"],
Cell[57345, 1729, 505, 11, 22, "Print"],
Cell[57853, 1742, 527, 12, 22, "Print"],
Cell[58383, 1756, 37, 1, 22, "Print"],
Cell[58423, 1759, 509, 11, 22, "Print"],
Cell[58935, 1772, 505, 11, 22, "Print"],
Cell[59443, 1785, 527, 12, 22, "Print"],
Cell[59973, 1799, 37, 1, 22, "Print"],
Cell[60013, 1802, 508, 11, 22, "Print"],
Cell[60524, 1815, 489, 11, 22, "Print"],
Cell[61016, 1828, 527, 12, 22, "Print"],
Cell[61546, 1842, 37, 1, 22, "Print"],
Cell[61586, 1845, 509, 11, 22, "Print"],
Cell[62098, 1858, 492, 11, 22, "Print"],
Cell[62593, 1871, 526, 12, 22, "Print"],
Cell[63122, 1885, 37, 1, 22, "Print"],
Cell[63162, 1888, 511, 11, 22, "Print"],
Cell[63676, 1901, 491, 11, 22, "Print"],
Cell[64170, 1914, 529, 12, 22, "Print"],
Cell[64702, 1928, 37, 1, 22, "Print"],
Cell[64742, 1931, 511, 11, 22, "Print"],
Cell[65256, 1944, 507, 11, 22, "Print"],
Cell[65766, 1957, 529, 12, 22, "Print"],
Cell[66298, 1971, 37, 1, 22, "Print"],
Cell[66338, 1974, 510, 11, 22, "Print"],
Cell[66851, 1987, 507, 11, 22, "Print"],
Cell[67361, 2000, 529, 12, 22, "Print"],
Cell[67893, 2014, 37, 1, 22, "Print"],
Cell[67933, 2017, 511, 11, 22, "Print"],
Cell[68447, 2030, 509, 11, 22, "Print"],
Cell[68959, 2043, 528, 12, 22, "Print"],
Cell[69490, 2057, 37, 1, 22, "Print"],
Cell[69530, 2060, 511, 11, 22, "Print"],
Cell[70044, 2073, 508, 11, 22, "Print"],
Cell[70555, 2086, 529, 12, 22, "Print"],
Cell[71087, 2100, 37, 1, 22, "Print"],
Cell[71127, 2103, 510, 11, 22, "Print"],
Cell[71640, 2116, 493, 11, 22, "Print"],
Cell[72136, 2129, 531, 12, 22, "Print"],
Cell[72670, 2143, 37, 1, 22, "Print"],
Cell[72710, 2146, 510, 11, 22, "Print"],
Cell[73223, 2159, 508, 11, 22, "Print"],
Cell[73734, 2172, 562, 13, 22, "Print"],
Cell[74299, 2187, 37, 1, 22, "Print"],
Cell[74339, 2190, 511, 11, 22, "Print"],
Cell[74853, 2203, 509, 11, 22, "Print"],
Cell[75365, 2216, 530, 12, 22, "Print"],
Cell[75898, 2230, 37, 1, 22, "Print"],
Cell[75938, 2233, 542, 12, 22, "Print"],
Cell[76483, 2247, 493, 11, 22, "Print"],
Cell[76979, 2260, 562, 13, 22, "Print"],
Cell[77544, 2275, 37, 1, 22, "Print"],
Cell[77584, 2278, 38, 1, 22, "Print"],
Cell[77625, 2281, 478, 11, 22, "Print"],
Cell[78106, 2294, 488, 11, 22, "Print"],
Cell[78597, 2307, 498, 11, 22, "Print"],
Cell[79098, 2320, 37, 1, 22, "Print"],
Cell[79138, 2323, 478, 11, 22, "Print"],
Cell[79619, 2336, 488, 11, 22, "Print"],
Cell[80110, 2349, 498, 11, 22, "Print"],
Cell[80611, 2362, 37, 1, 22, "Print"],
Cell[80651, 2365, 477, 11, 22, "Print"],
Cell[81131, 2378, 487, 11, 22, "Print"],
Cell[81621, 2391, 498, 11, 22, "Print"],
Cell[82122, 2404, 37, 1, 22, "Print"],
Cell[82162, 2407, 509, 11, 22, "Print"],
Cell[82674, 2420, 489, 11, 22, "Print"],
Cell[83166, 2433, 526, 12, 22, "Print"],
Cell[83695, 2447, 37, 1, 22, "Print"],
Cell[83735, 2450, 509, 11, 22, "Print"],
Cell[84247, 2463, 490, 11, 22, "Print"],
Cell[84740, 2476, 527, 12, 22, "Print"],
Cell[85270, 2490, 37, 1, 22, "Print"],
Cell[85310, 2493, 509, 11, 22, "Print"],
Cell[85822, 2506, 505, 11, 22, "Print"],
Cell[86330, 2519, 526, 12, 22, "Print"],
Cell[86859, 2533, 37, 1, 22, "Print"],
Cell[86899, 2536, 507, 11, 22, "Print"],
Cell[87409, 2549, 505, 11, 22, "Print"],
Cell[87917, 2562, 527, 12, 22, "Print"],
Cell[88447, 2576, 37, 1, 22, "Print"],
Cell[88487, 2579, 509, 11, 22, "Print"],
Cell[88999, 2592, 505, 11, 22, "Print"],
Cell[89507, 2605, 526, 12, 22, "Print"],
Cell[90036, 2619, 37, 1, 22, "Print"],
Cell[90076, 2622, 509, 11, 22, "Print"],
Cell[90588, 2635, 490, 11, 22, "Print"],
Cell[91081, 2648, 527, 12, 22, "Print"],
Cell[91611, 2662, 37, 1, 22, "Print"],
Cell[91651, 2665, 510, 11, 22, "Print"],
Cell[92164, 2678, 492, 11, 22, "Print"],
Cell[92659, 2691, 529, 12, 22, "Print"],
Cell[93191, 2705, 37, 1, 22, "Print"],
Cell[93231, 2708, 511, 11, 22, "Print"],
Cell[93745, 2721, 507, 11, 22, "Print"],
Cell[94255, 2734, 529, 12, 22, "Print"],
Cell[94787, 2748, 37, 1, 22, "Print"],
Cell[94827, 2751, 511, 11, 22, "Print"],
Cell[95341, 2764, 508, 11, 22, "Print"],
Cell[95852, 2777, 529, 12, 22, "Print"],
Cell[96384, 2791, 37, 1, 22, "Print"],
Cell[96424, 2794, 511, 11, 22, "Print"],
Cell[96938, 2807, 508, 11, 22, "Print"],
Cell[97449, 2820, 529, 12, 22, "Print"],
Cell[97981, 2834, 37, 1, 22, "Print"],
Cell[98021, 2837, 510, 11, 22, "Print"],
Cell[98534, 2850, 494, 11, 22, "Print"],
Cell[99031, 2863, 529, 12, 22, "Print"],
Cell[99563, 2877, 37, 1, 22, "Print"],
Cell[99603, 2880, 511, 11, 22, "Print"],
Cell[100117, 2893, 493, 11, 22, "Print"],
Cell[100613, 2906, 529, 12, 22, "Print"],
Cell[101145, 2920, 37, 1, 22, "Print"],
Cell[101185, 2923, 511, 11, 22, "Print"],
Cell[101699, 2936, 508, 11, 22, "Print"],
Cell[102210, 2949, 531, 12, 22, "Print"],
Cell[102744, 2963, 37, 1, 22, "Print"],
Cell[102784, 2966, 511, 11, 22, "Print"],
Cell[103298, 2979, 508, 11, 22, "Print"],
Cell[103809, 2992, 531, 12, 22, "Print"],
Cell[104343, 3006, 37, 1, 22, "Print"],
Cell[104383, 3009, 511, 11, 22, "Print"],
Cell[104897, 3022, 508, 11, 22, "Print"],
Cell[105408, 3035, 562, 13, 22, "Print"],
Cell[105973, 3050, 37, 1, 22, "Print"],
Cell[106013, 3053, 511, 11, 22, "Print"],
Cell[106527, 3066, 493, 11, 22, "Print"],
Cell[107023, 3079, 562, 13, 22, "Print"],
Cell[107588, 3094, 37, 1, 22, "Print"],
Cell[107628, 3097, 38, 1, 22, "Print"],
Cell[107669, 3100, 509, 11, 22, "Print"],
Cell[108181, 3113, 526, 12, 22, "Print"],
Cell[108710, 3127, 498, 11, 22, "Print"],
Cell[109211, 3140, 37, 1, 22, "Print"],
Cell[109251, 3143, 508, 11, 22, "Print"],
Cell[109762, 3156, 526, 12, 22, "Print"],
Cell[110291, 3170, 526, 12, 22, "Print"],
Cell[110820, 3184, 37, 1, 22, "Print"],
Cell[110860, 3187, 477, 11, 22, "Print"],
Cell[111340, 3200, 487, 11, 22, "Print"],
Cell[111830, 3213, 498, 11, 22, "Print"],
Cell[112331, 3226, 37, 1, 22, "Print"],
Cell[112371, 3229, 509, 11, 22, "Print"],
Cell[112883, 3242, 525, 12, 22, "Print"],
Cell[113411, 3256, 527, 12, 22, "Print"],
Cell[113941, 3270, 37, 1, 22, "Print"],
Cell[113981, 3273, 508, 11, 22, "Print"],
Cell[114492, 3286, 525, 12, 22, "Print"],
Cell[115020, 3300, 527, 12, 22, "Print"],
Cell[115550, 3314, 37, 1, 22, "Print"],
Cell[115590, 3317, 509, 11, 22, "Print"],
Cell[116102, 3330, 487, 11, 22, "Print"],
Cell[116592, 3343, 527, 12, 22, "Print"],
Cell[117122, 3357, 37, 1, 22, "Print"],
Cell[117162, 3360, 509, 11, 22, "Print"],
Cell[117674, 3373, 526, 12, 22, "Print"],
Cell[118203, 3387, 526, 12, 22, "Print"],
Cell[118732, 3401, 37, 1, 22, "Print"],
Cell[118772, 3404, 509, 11, 22, "Print"],
Cell[119284, 3417, 526, 12, 22, "Print"],
Cell[119813, 3431, 526, 12, 22, "Print"],
Cell[120342, 3445, 37, 1, 22, "Print"],
Cell[120382, 3448, 509, 11, 22, "Print"],
Cell[120894, 3461, 505, 11, 22, "Print"],
Cell[121402, 3474, 527, 12, 22, "Print"],
Cell[121932, 3488, 37, 1, 22, "Print"],
Cell[121972, 3491, 511, 11, 22, "Print"],
Cell[122486, 3504, 528, 12, 22, "Print"],
Cell[123017, 3518, 529, 12, 22, "Print"],
Cell[123549, 3532, 37, 1, 22, "Print"],
Cell[123589, 3535, 511, 11, 22, "Print"],
Cell[124103, 3548, 527, 12, 22, "Print"],
Cell[124633, 3562, 528, 12, 22, "Print"],
Cell[125164, 3576, 37, 1, 22, "Print"],
Cell[125204, 3579, 511, 11, 22, "Print"],
Cell[125718, 3592, 507, 11, 22, "Print"],
Cell[126228, 3605, 529, 12, 22, "Print"],
Cell[126760, 3619, 37, 1, 22, "Print"],
Cell[126800, 3622, 511, 11, 22, "Print"],
Cell[127314, 3635, 528, 12, 22, "Print"],
Cell[127845, 3649, 529, 12, 22, "Print"],
Cell[128377, 3663, 37, 1, 22, "Print"],
Cell[128417, 3666, 510, 11, 22, "Print"],
Cell[128930, 3679, 528, 12, 22, "Print"],
Cell[129461, 3693, 529, 12, 22, "Print"],
Cell[129993, 3707, 37, 1, 22, "Print"],
Cell[130033, 3710, 511, 11, 22, "Print"],
Cell[130547, 3723, 491, 11, 22, "Print"],
Cell[131041, 3736, 529, 12, 22, "Print"],
Cell[131573, 3750, 37, 1, 22, "Print"],
Cell[131613, 3753, 510, 11, 22, "Print"],
Cell[132126, 3766, 527, 12, 22, "Print"],
Cell[132656, 3780, 528, 12, 22, "Print"],
Cell[133187, 3794, 37, 1, 22, "Print"],
Cell[133227, 3797, 510, 11, 22, "Print"],
Cell[133740, 3810, 527, 12, 22, "Print"],
Cell[134270, 3824, 531, 12, 22, "Print"],
Cell[134804, 3838, 37, 1, 22, "Print"],
Cell[134844, 3841, 511, 11, 22, "Print"],
Cell[135358, 3854, 507, 11, 22, "Print"],
Cell[135868, 3867, 531, 12, 22, "Print"],
Cell[136402, 3881, 37, 1, 22, "Print"],
Cell[136442, 3884, 541, 12, 22, "Print"],
Cell[136986, 3898, 528, 12, 22, "Print"],
Cell[137517, 3912, 562, 13, 22, "Print"],
Cell[138082, 3927, 37, 1, 22, "Print"],
Cell[138122, 3930, 541, 12, 22, "Print"],
Cell[138666, 3944, 528, 12, 22, "Print"],
Cell[139197, 3958, 562, 13, 22, "Print"],
Cell[139762, 3973, 37, 1, 22, "Print"],
Cell[139802, 3976, 70, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[139909, 3982, 46, 1, 27, "Input"],
Cell[139958, 3985, 41, 1, 26, "Output"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{
Cell[140048, 3992, 53, 0, 28, "Subsection"],
Cell[140104, 3994, 138, 2, 43, "Input"],

Cell[CellGroupData[{
Cell[140267, 4000, 46, 1, 27, "Input"],
Cell[140316, 4003, 41, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[140394, 4009, 124, 4, 42, "Input"],
Cell[140521, 4015, 243, 5, 22, "Print"],
Cell[140767, 4022, 253, 5, 22, "Print"],
Cell[141023, 4029, 251, 5, 22, "Print"],
Cell[141277, 4036, 37, 1, 22, "Print"],
Cell[141317, 4039, 243, 5, 22, "Print"],
Cell[141563, 4046, 253, 5, 22, "Print"],
Cell[141819, 4053, 251, 5, 22, "Print"],
Cell[142073, 4060, 37, 1, 22, "Print"],
Cell[142113, 4063, 243, 5, 22, "Print"],
Cell[142359, 4070, 253, 5, 22, "Print"],
Cell[142615, 4077, 251, 5, 22, "Print"],
Cell[142869, 4084, 37, 1, 22, "Print"],
Cell[142909, 4087, 402, 10, 22, "Print"],
Cell[143314, 4099, 253, 5, 22, "Print"],
Cell[143570, 4106, 409, 10, 22, "Print"],
Cell[143982, 4118, 37, 1, 22, "Print"],
Cell[144022, 4121, 475, 11, 24, "Print"],
Cell[144500, 4134, 253, 5, 22, "Print"],
Cell[144756, 4141, 451, 10, 24, "Print"],
Cell[145210, 4153, 37, 1, 22, "Print"],
Cell[145250, 4156, 475, 11, 24, "Print"],
Cell[145728, 4169, 253, 5, 22, "Print"],
Cell[145984, 4176, 451, 10, 24, "Print"],
Cell[146438, 4188, 37, 1, 22, "Print"],
Cell[146478, 4191, 444, 10, 24, "Print"],
Cell[146925, 4203, 253, 5, 22, "Print"],
Cell[147181, 4210, 451, 10, 24, "Print"],
Cell[147635, 4222, 37, 1, 22, "Print"],
Cell[147675, 4225, 444, 10, 24, "Print"],
Cell[148122, 4237, 253, 5, 22, "Print"],
Cell[148378, 4244, 451, 10, 24, "Print"],
Cell[148832, 4256, 37, 1, 22, "Print"],
Cell[148872, 4259, 474, 11, 24, "Print"],
Cell[149349, 4272, 253, 5, 22, "Print"],
Cell[149605, 4279, 450, 10, 24, "Print"],
Cell[150058, 4291, 37, 1, 22, "Print"],
Cell[150098, 4294, 474, 11, 24, "Print"],
Cell[150575, 4307, 253, 5, 22, "Print"],
Cell[150831, 4314, 450, 10, 24, "Print"],
Cell[151284, 4326, 37, 1, 22, "Print"],
Cell[151324, 4329, 445, 10, 24, "Print"],
Cell[151772, 4341, 255, 5, 22, "Print"],
Cell[152030, 4348, 452, 10, 24, "Print"],
Cell[152485, 4360, 37, 1, 22, "Print"],
Cell[152525, 4363, 476, 11, 24, "Print"],
Cell[153004, 4376, 255, 5, 22, "Print"],
Cell[153262, 4383, 452, 10, 24, "Print"],
Cell[153717, 4395, 37, 1, 22, "Print"],
Cell[153757, 4398, 477, 11, 22, "Print"],
Cell[154237, 4411, 255, 5, 22, "Print"],
Cell[154495, 4418, 453, 10, 22, "Print"],
Cell[154951, 4430, 37, 1, 22, "Print"],
Cell[154991, 4433, 444, 10, 22, "Print"],
Cell[155438, 4445, 255, 5, 22, "Print"],
Cell[155696, 4452, 451, 10, 22, "Print"],
Cell[156150, 4464, 37, 1, 22, "Print"],
Cell[156190, 4467, 473, 11, 22, "Print"],
Cell[156666, 4480, 255, 5, 22, "Print"],
Cell[156924, 4487, 449, 10, 22, "Print"],
Cell[157376, 4499, 37, 1, 22, "Print"],
Cell[157416, 4502, 471, 11, 22, "Print"],
Cell[157890, 4515, 255, 5, 22, "Print"],
Cell[158148, 4522, 447, 10, 22, "Print"],
Cell[158598, 4534, 37, 1, 22, "Print"],
Cell[158638, 4537, 438, 10, 22, "Print"],
Cell[159079, 4549, 255, 5, 22, "Print"],
Cell[159337, 4556, 445, 10, 22, "Print"],
Cell[159785, 4568, 37, 1, 22, "Print"],
Cell[159825, 4571, 467, 11, 22, "Print"],
Cell[160295, 4584, 255, 5, 22, "Print"],
Cell[160553, 4591, 443, 10, 22, "Print"],
Cell[160999, 4603, 37, 1, 22, "Print"],
Cell[161039, 4606, 436, 10, 22, "Print"],
Cell[161478, 4618, 255, 5, 22, "Print"],
Cell[161736, 4625, 443, 10, 22, "Print"],
Cell[162182, 4637, 37, 1, 22, "Print"],
Cell[162222, 4640, 436, 10, 22, "Print"],
Cell[162661, 4652, 255, 5, 22, "Print"],
Cell[162919, 4659, 443, 10, 22, "Print"],
Cell[163365, 4671, 37, 1, 22, "Print"],
Cell[163405, 4674, 70, 1, 26, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[163512, 4680, 46, 1, 24, "Input"],
Cell[163561, 4683, 41, 1, 26, "Output"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{
Cell[163651, 4690, 60, 0, 28, "Subsection"],
Cell[163714, 4692, 140, 2, 43, "Input"],

Cell[CellGroupData[{
Cell[163879, 4698, 46, 1, 27, "Input"],
Cell[163928, 4701, 41, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[164006, 4707, 93, 1, 27, "Input"],
Cell[164102, 4710, 485, 11, 22, "Print"],
Cell[164590, 4723, 308, 6, 22, "Print"],
Cell[164901, 4731, 631, 15, 24, "Print"],
Cell[165535, 4748, 768, 20, 24, "Print"],
Cell[166306, 4770, 1207, 32, 24, "Print"],
Cell[167516, 4804, 1541, 38, 56, "Print"],
Cell[169060, 4844, 1754, 44, 56, "Print"],
Cell[170817, 4890, 1983, 50, 56, "Print"],
Cell[172803, 4942, 2212, 56, 56, "Print"],
Cell[175018, 5000, 2451, 62, 73, "Print"],
Cell[177472, 5064, 2687, 68, 73, "Print"],
Cell[180162, 5134, 2918, 74, 90, "Print"],
Cell[183083, 5210, 3133, 80, 90, "Print"],
Cell[186219, 5292, 3373, 86, 109, "Print"],
Cell[189595, 5380, 3577, 91, 109, "Print"],
Cell[193175, 5473, 3815, 97, 126, "Print"],
Cell[196993, 5572, 69, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[197099, 5578, 46, 1, 27, "Input"],
Cell[197148, 5581, 41, 1, 26, "Output"]
}, Open  ]]
}, Closed]]
}, Closed]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

