(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 3.0,
MathReader 3.0, or any compatible application. The data for the notebook 
starts with the line of stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[    287669,       8067]*)
(*NotebookOutlinePosition[    288509,       8094]*)
(*  CellTagsIndexPosition[    288465,       8090]*)
(*WindowFrame->Normal*)



Notebook[{
Cell[TextData[{
  " :Author:  Z\[EAcute]lia da ROCHA \n\n:Address: \n            Departamento \
de Matem\[AAcute]tica Aplicada da\n            Faculdade de Ci\[EHat]ncias do \
Porto\n            Rua das Taipas, 135\n            4050 Porto\n            \
Portugal\n  \n            Tel: ++351 02 2080313\n            Fax: ++351 02 \
2004109\n            Email: mrdioh@fc.up.pt\n\n :Summary:\n    The ",
  StyleBox["testchv52",
    FontSize->18],
  " notebook contains the results produced by the package\n    chv.m \
corresponding to the ",
  StyleBox["example 5.2",
    FontSize->18],
  " of the first paper cited bellow.    \n\n :Date: July 1999. \n\n:Available \
at http://netlib.bell-labs.com/ in the numeralgo library in netlib:     \n\n \
:Notebook Version: 1.0 \n\n :Mathematica Version: 3.0   \n \n :Keywords: \
chebyshev's method, recurrence relations,  orthogonal polynomials of \
dimension d, d-dimensional forms.\n\n :Sources:\n \n - Z\[EAcute]lia da \
Rocha, Shohat-Favard and Chebyshev's methods in d-orthogonality, \n Numerical \
Algorithms, 20 (1999) 139-164.\n   \n - About the example treated here see p. \
286 of:\n   K. Douak, The relation of the d-orthogonal polynomials to the \
Appell polynomials, J. Comput. Appl. Math.,  70 (1996) 279-295.\n"
}], "Subsection"],

Cell[CellGroupData[{

Cell["\<\
Computing the recurrence coefficients and the orthogonal \
polynomials performing formal computations\
\>", "Section",
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell["\<\
Loading the package chv.m, the package datachv52.m is automatically \
loaded\
\>", "Subsection"],

Cell[BoxData[
    \(\(<< chebyshev`chv`; \)\)], "Input"]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
 The moments of the d-dimensional form are given in the package \
datachv52.m\
\>", "Subsection",
  AspectRatioFixed->True],

Cell[BoxData[
    \( (*\ showing\ the\ moments\ given\ *) \)], "Input"],

Cell[BoxData[
    \(\( (*\ set\ the\ values\ of\ d\ and\ imax\ *) \nd = 3; imax = \ 10; 
    \ \ \ \ \ \  (*\ for\ example\ *) \)\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Do[Do[
        Print["\<form[\>", d, "\<,\>", \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ r, 
          "\<,\>", i, "\<]=\>", form[d, r, i]], {i, 0, imax}]; \n
      \t\ \ \ \ \ \ \ Print["\<____________________\>"], {r, 1, d}]\)], 
  "Input"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]0
        \[InvisibleSpace]"]="\[InvisibleSpace]1\),
      SequenceForm[ "form[", 3, ",", 1, ",", 0, "]=", 1],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 3, ",", 1, ",", 1, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]"]="\[InvisibleSpace]2\/3\),
      SequenceForm[ "form[", 3, ",", 1, ",", 2, "]=", 
        Rational[ 2, 3]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]"]="\[InvisibleSpace]1\/2\),
      SequenceForm[ "form[", 3, ",", 1, ",", 3, "]=", 
        Rational[ 1, 2]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]"]="\[InvisibleSpace]19\/12\),
      SequenceForm[ "form[", 3, ",", 1, ",", 4, "]=", 
        Rational[ 19, 12]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]"]="\[InvisibleSpace]10\/3\),
      SequenceForm[ "form[", 3, ",", 1, ",", 5, "]=", 
        Rational[ 10, 3]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]6
        \[InvisibleSpace]"]="\[InvisibleSpace]85\/9\),
      SequenceForm[ "form[", 3, ",", 1, ",", 6, "]=", 
        Rational[ 85, 9]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]7
        \[InvisibleSpace]"]="\[InvisibleSpace]665\/24\),
      SequenceForm[ "form[", 3, ",", 1, ",", 7, "]=", 
        Rational[ 665, 24]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]8
        \[InvisibleSpace]"]="\[InvisibleSpace]40145\/432\),
      SequenceForm[ "form[", 3, ",", 1, ",", 8, "]=", 
        Rational[ 40145, 432]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]9
        \[InvisibleSpace]"]="\[InvisibleSpace]980\/3\),
      SequenceForm[ "form[", 3, ",", 1, ",", 9, "]=", 
        Rational[ 980, 3]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]10
        \[InvisibleSpace]"]="\[InvisibleSpace]90335\/72\),
      SequenceForm[ "form[", 3, ",", 1, ",", 10, "]=", 
        Rational[ 90335, 72]],
      Editable->False]], "Print"],

Cell[BoxData[
    \("____________________"\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]0
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 3, ",", 2, ",", 0, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]"]="\[InvisibleSpace]1\),
      SequenceForm[ "form[", 3, ",", 2, ",", 1, "]=", 1],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 3, ",", 2, ",", 2, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]"]="\[InvisibleSpace]2\),
      SequenceForm[ "form[", 3, ",", 2, ",", 3, "]=", 2],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]"]="\[InvisibleSpace]2\),
      SequenceForm[ "form[", 3, ",", 2, ",", 4, "]=", 2],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]"]="\[InvisibleSpace]95\/12\),
      SequenceForm[ "form[", 3, ",", 2, ",", 5, "]=", 
        Rational[ 95, 12]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]6
        \[InvisibleSpace]"]="\[InvisibleSpace]20\),
      SequenceForm[ "form[", 3, ",", 2, ",", 6, "]=", 20],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]7
        \[InvisibleSpace]"]="\[InvisibleSpace]595\/9\),
      SequenceForm[ "form[", 3, ",", 2, ",", 7, "]=", 
        Rational[ 595, 9]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]8
        \[InvisibleSpace]"]="\[InvisibleSpace]665\/3\),
      SequenceForm[ "form[", 3, ",", 2, ",", 8, "]=", 
        Rational[ 665, 3]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]9
        \[InvisibleSpace]"]="\[InvisibleSpace]40145\/48\),
      SequenceForm[ "form[", 3, ",", 2, ",", 9, "]=", 
        Rational[ 40145, 48]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]10
        \[InvisibleSpace]"]="\[InvisibleSpace]9800\/3\),
      SequenceForm[ "form[", 3, ",", 2, ",", 10, "]=", 
        Rational[ 9800, 3]],
      Editable->False]], "Print"],

Cell[BoxData[
    \("____________________"\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]0
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 3, ",", 3, ",", 0, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 3, ",", 3, ",", 1, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]"]="\[InvisibleSpace]1\),
      SequenceForm[ "form[", 3, ",", 3, ",", 2, "]=", 1],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 3, ",", 3, ",", 3, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]"]="\[InvisibleSpace]4\),
      SequenceForm[ "form[", 3, ",", 3, ",", 4, "]=", 4],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]"]="\[InvisibleSpace]5\),
      SequenceForm[ "form[", 3, ",", 3, ",", 5, "]=", 5],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]6
        \[InvisibleSpace]"]="\[InvisibleSpace]95\/4\),
      SequenceForm[ "form[", 3, ",", 3, ",", 6, "]=", 
        Rational[ 95, 4]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]7
        \[InvisibleSpace]"]="\[InvisibleSpace]70\),
      SequenceForm[ "form[", 3, ",", 3, ",", 7, "]=", 70],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]8
        \[InvisibleSpace]"]="\[InvisibleSpace]2380\/9\),
      SequenceForm[ "form[", 3, ",", 3, ",", 8, "]=", 
        Rational[ 2380, 9]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]9
        \[InvisibleSpace]"]="\[InvisibleSpace]1995\/2\),
      SequenceForm[ "form[", 3, ",", 3, ",", 9, "]=", 
        Rational[ 1995, 2]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]10
        \[InvisibleSpace]"]="\[InvisibleSpace]200725\/48\),
      SequenceForm[ "form[", 3, ",", 3, ",", 10, "]=", 
        Rational[ 200725, 48]],
      Editable->False]], "Print"],

Cell[BoxData[
    \("____________________"\)], "Print"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Computing the gamma coefficients", "Subsection"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\( (*\ set\ the\ values\ of\ d\ and\ nmax\ *) \nd = 3; \ nmax = \ 10\ ; 
    \ \ \ \  (*\ for\ example\ *) \)\)], "Input"],

Cell[BoxData[
    \(General::"spell1" \( : \ \) 
      "Possible spelling error: new symbol name \"\!\(nmax\)\" is similar to \
existing symbol \"\!\(imax\)\"."\)], "Message"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(MemoryInUse[]\)], "Input"],

Cell[BoxData[
    \(952480\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Timing[printgamma[d,nmax,Infinity,$MachinePrecision,True,False]]\
\>\
", "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    \("   "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]0
        \[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]"]="\[InvisibleSpace]1\/4\),
      SequenceForm[ "gamma[", 3, ",", 0, ",", 1, "]=", 
        Rational[ 1, 4]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]0
        \[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]"]="\[InvisibleSpace]1\/4\),
      SequenceForm[ "gammaexact[", 3, ",", 0, ",", 1, "]=", 
        Rational[ 1, 4]],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]0
        \[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]"]="\[InvisibleSpace]1\),
      SequenceForm[ "gamma[", 3, ",", 0, ",", 2, "]=", 1],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]0
        \[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]"]="\[InvisibleSpace]1\),
      SequenceForm[ "gammaexact[", 3, ",", 0, ",", 2, "]=", 1],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]0
        \[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]"]="\[InvisibleSpace]5\/2\),
      SequenceForm[ "gamma[", 3, ",", 0, ",", 3, "]=", 
        Rational[ 5, 2]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]0
        \[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]"]="\[InvisibleSpace]5\/2\),
      SequenceForm[ "gammaexact[", 3, ",", 0, ",", 3, "]=", 
        Rational[ 5, 2]],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]0
        \[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]"]="\[InvisibleSpace]5\),
      SequenceForm[ "gamma[", 3, ",", 0, ",", 4, "]=", 5],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]0
        \[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]"]="\[InvisibleSpace]5\),
      SequenceForm[ "gammaexact[", 3, ",", 0, ",", 4, "]=", 5],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]0
        \[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]"]="\[InvisibleSpace]35\/4\),
      SequenceForm[ "gamma[", 3, ",", 0, ",", 5, "]=", 
        Rational[ 35, 4]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]0
        \[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]"]="\[InvisibleSpace]35\/4\),
      SequenceForm[ "gammaexact[", 3, ",", 0, ",", 5, "]=", 
        Rational[ 35, 4]],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]0
        \[InvisibleSpace]","\[InvisibleSpace]6
        \[InvisibleSpace]"]="\[InvisibleSpace]14\),
      SequenceForm[ "gamma[", 3, ",", 0, ",", 6, "]=", 14],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]0
        \[InvisibleSpace]","\[InvisibleSpace]6
        \[InvisibleSpace]"]="\[InvisibleSpace]14\),
      SequenceForm[ "gammaexact[", 3, ",", 0, ",", 6, "]=", 14],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]0
        \[InvisibleSpace]","\[InvisibleSpace]7
        \[InvisibleSpace]"]="\[InvisibleSpace]21\),
      SequenceForm[ "gamma[", 3, ",", 0, ",", 7, "]=", 21],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]0
        \[InvisibleSpace]","\[InvisibleSpace]7
        \[InvisibleSpace]"]="\[InvisibleSpace]21\),
      SequenceForm[ "gammaexact[", 3, ",", 0, ",", 7, "]=", 21],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]0
        \[InvisibleSpace]","\[InvisibleSpace]8
        \[InvisibleSpace]"]="\[InvisibleSpace]30\),
      SequenceForm[ "gamma[", 3, ",", 0, ",", 8, "]=", 30],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]0
        \[InvisibleSpace]","\[InvisibleSpace]8
        \[InvisibleSpace]"]="\[InvisibleSpace]30\),
      SequenceForm[ "gammaexact[", 3, ",", 0, ",", 8, "]=", 30],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    \("   "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]"]="\[InvisibleSpace]1\/2\),
      SequenceForm[ "gamma[", 3, ",", 1, ",", 1, "]=", 
        Rational[ 1, 2]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]"]="\[InvisibleSpace]1\/2\),
      SequenceForm[ "gammaexact[", 3, ",", 1, ",", 1, "]=", 
        Rational[ 1, 2]],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]"]="\[InvisibleSpace]3\/2\),
      SequenceForm[ "gamma[", 3, ",", 1, ",", 2, "]=", 
        Rational[ 3, 2]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]"]="\[InvisibleSpace]3\/2\),
      SequenceForm[ "gammaexact[", 3, ",", 1, ",", 2, "]=", 
        Rational[ 3, 2]],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]"]="\[InvisibleSpace]3\),
      SequenceForm[ "gamma[", 3, ",", 1, ",", 3, "]=", 3],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]"]="\[InvisibleSpace]3\),
      SequenceForm[ "gammaexact[", 3, ",", 1, ",", 3, "]=", 3],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]"]="\[InvisibleSpace]5\),
      SequenceForm[ "gamma[", 3, ",", 1, ",", 4, "]=", 5],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]"]="\[InvisibleSpace]5\),
      SequenceForm[ "gammaexact[", 3, ",", 1, ",", 4, "]=", 5],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]"]="\[InvisibleSpace]15\/2\),
      SequenceForm[ "gamma[", 3, ",", 1, ",", 5, "]=", 
        Rational[ 15, 2]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]"]="\[InvisibleSpace]15\/2\),
      SequenceForm[ "gammaexact[", 3, ",", 1, ",", 5, "]=", 
        Rational[ 15, 2]],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]6
        \[InvisibleSpace]"]="\[InvisibleSpace]21\/2\),
      SequenceForm[ "gamma[", 3, ",", 1, ",", 6, "]=", 
        Rational[ 21, 2]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]6
        \[InvisibleSpace]"]="\[InvisibleSpace]21\/2\),
      SequenceForm[ "gammaexact[", 3, ",", 1, ",", 6, "]=", 
        Rational[ 21, 2]],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]7
        \[InvisibleSpace]"]="\[InvisibleSpace]14\),
      SequenceForm[ "gamma[", 3, ",", 1, ",", 7, "]=", 14],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]7
        \[InvisibleSpace]"]="\[InvisibleSpace]14\),
      SequenceForm[ "gammaexact[", 3, ",", 1, ",", 7, "]=", 14],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]8
        \[InvisibleSpace]"]="\[InvisibleSpace]18\),
      SequenceForm[ "gamma[", 3, ",", 1, ",", 8, "]=", 18],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]8
        \[InvisibleSpace]"]="\[InvisibleSpace]18\),
      SequenceForm[ "gammaexact[", 3, ",", 1, ",", 8, "]=", 18],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]9
        \[InvisibleSpace]"]="\[InvisibleSpace]45\/2\),
      SequenceForm[ "gamma[", 3, ",", 1, ",", 9, "]=", 
        Rational[ 45, 2]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]9
        \[InvisibleSpace]"]="\[InvisibleSpace]45\/2\),
      SequenceForm[ "gammaexact[", 3, ",", 1, ",", 9, "]=", 
        Rational[ 45, 2]],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    \("   "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]"]="\[InvisibleSpace]2\/3\),
      SequenceForm[ "gamma[", 3, ",", 2, ",", 1, "]=", 
        Rational[ 2, 3]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]"]="\[InvisibleSpace]2\/3\),
      SequenceForm[ "gammaexact[", 3, ",", 2, ",", 1, "]=", 
        Rational[ 2, 3]],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]"]="\[InvisibleSpace]4\/3\),
      SequenceForm[ "gamma[", 3, ",", 2, ",", 2, "]=", 
        Rational[ 4, 3]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]"]="\[InvisibleSpace]4\/3\),
      SequenceForm[ "gammaexact[", 3, ",", 2, ",", 2, "]=", 
        Rational[ 4, 3]],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]"]="\[InvisibleSpace]2\),
      SequenceForm[ "gamma[", 3, ",", 2, ",", 3, "]=", 2],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]"]="\[InvisibleSpace]2\),
      SequenceForm[ "gammaexact[", 3, ",", 2, ",", 3, "]=", 2],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]"]="\[InvisibleSpace]8\/3\),
      SequenceForm[ "gamma[", 3, ",", 2, ",", 4, "]=", 
        Rational[ 8, 3]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]"]="\[InvisibleSpace]8\/3\),
      SequenceForm[ "gammaexact[", 3, ",", 2, ",", 4, "]=", 
        Rational[ 8, 3]],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]"]="\[InvisibleSpace]10\/3\),
      SequenceForm[ "gamma[", 3, ",", 2, ",", 5, "]=", 
        Rational[ 10, 3]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]"]="\[InvisibleSpace]10\/3\),
      SequenceForm[ "gammaexact[", 3, ",", 2, ",", 5, "]=", 
        Rational[ 10, 3]],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]6
        \[InvisibleSpace]"]="\[InvisibleSpace]4\),
      SequenceForm[ "gamma[", 3, ",", 2, ",", 6, "]=", 4],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]6
        \[InvisibleSpace]"]="\[InvisibleSpace]4\),
      SequenceForm[ "gammaexact[", 3, ",", 2, ",", 6, "]=", 4],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]7
        \[InvisibleSpace]"]="\[InvisibleSpace]14\/3\),
      SequenceForm[ "gamma[", 3, ",", 2, ",", 7, "]=", 
        Rational[ 14, 3]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]7
        \[InvisibleSpace]"]="\[InvisibleSpace]14\/3\),
      SequenceForm[ "gammaexact[", 3, ",", 2, ",", 7, "]=", 
        Rational[ 14, 3]],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]8
        \[InvisibleSpace]"]="\[InvisibleSpace]16\/3\),
      SequenceForm[ "gamma[", 3, ",", 2, ",", 8, "]=", 
        Rational[ 16, 3]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]8
        \[InvisibleSpace]"]="\[InvisibleSpace]16\/3\),
      SequenceForm[ "gammaexact[", 3, ",", 2, ",", 8, "]=", 
        Rational[ 16, 3]],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]9
        \[InvisibleSpace]"]="\[InvisibleSpace]6\),
      SequenceForm[ "gamma[", 3, ",", 2, ",", 9, "]=", 6],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]9
        \[InvisibleSpace]"]="\[InvisibleSpace]6\),
      SequenceForm[ "gammaexact[", 3, ",", 2, ",", 9, "]=", 6],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]10
        \[InvisibleSpace]"]="\[InvisibleSpace]20\/3\),
      SequenceForm[ "gamma[", 3, ",", 2, ",", 10, "]=", 
        Rational[ 20, 3]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]10
        \[InvisibleSpace]"]="\[InvisibleSpace]20\/3\),
      SequenceForm[ "gammaexact[", 3, ",", 2, ",", 10, "]=", 
        Rational[ 20, 3]],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    \({13.9166666666666639`\ Second, Null}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(MemoryInUse[]\)], "Input"],

Cell[BoxData[
    \(1025432\)], "Output"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Computing the beta coefficients", "Subsection"],

Cell[BoxData[
    \(\( (*\ set\ the\ values\ of\ d\ and\ nmax\ *) \nd = 3; \ nmax = \ 10\ ; 
    \ \ \ \  (*\ for\ example\ *) \)\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(MemoryInUse[]\)], "Input"],

Cell[BoxData[
    \(1027216\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Timing[printbeta[d,nmax,Infinity,$MachinePrecision,True,False]]\
\>\
", "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    InterpretationBox[
      \("beta["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]0
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "beta[", 3, ",", 0, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("betaexact["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]0
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "betaexact[", 3, ",", 0, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("beta["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "beta[", 3, ",", 1, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("betaexact["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "betaexact[", 3, ",", 1, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("beta["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "beta[", 3, ",", 2, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("betaexact["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "betaexact[", 3, ",", 2, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("beta["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "beta[", 3, ",", 3, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("betaexact["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "betaexact[", 3, ",", 3, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("beta["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "beta[", 3, ",", 4, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("betaexact["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "betaexact[", 3, ",", 4, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("beta["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "beta[", 3, ",", 5, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("betaexact["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "betaexact[", 3, ",", 5, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("beta["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]6
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "beta[", 3, ",", 6, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("betaexact["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]6
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "betaexact[", 3, ",", 6, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("beta["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]7
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "beta[", 3, ",", 7, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("betaexact["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]7
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "betaexact[", 3, ",", 7, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("beta["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]8
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "beta[", 3, ",", 8, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("betaexact["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]8
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "betaexact[", 3, ",", 8, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("beta["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]9
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "beta[", 3, ",", 9, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("betaexact["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]9
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "betaexact[", 3, ",", 9, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    \({3.75`\ Second, Null}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(MemoryInUse[]\)], "Input"],

Cell[BoxData[
    \(1029976\)], "Output"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Computing the d-orthogonal polynomials", "Subsection"],

Cell[BoxData[
    \(\( (*\ set\ the\ values\ of\ d\ and\ nmax\ *) \nd = 3; \ nmax = \ 10; 
    \ \ \ \ \  (*\ for\ example\ *) \)\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(MemoryInUse[]\)], "Input"],

Cell[BoxData[
    \(1031808\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Timing[printdorthpoly[d,nmax,x,Infinity]]", "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    InterpretationBox[
      \("dorthpoly["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]0
        \[InvisibleSpace]","\[InvisibleSpace]x
        \[InvisibleSpace]"]="\[InvisibleSpace]1\),
      SequenceForm[ "dorthpoly[", 3, ",", 0, ",", x, "]=", 1],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("dorthpoly["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]x
        \[InvisibleSpace]"]="\[InvisibleSpace]x\),
      SequenceForm[ "dorthpoly[", 3, ",", 1, ",", x, "]=", x],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("dorthpoly["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]x
        \[InvisibleSpace]"]="\[InvisibleSpace]\(\( - 2\/3\) + x\^2\)\),
      SequenceForm[ "dorthpoly[", 3, ",", 2, ",", x, "]=", 
        Plus[ 
          Rational[ -2, 3], 
          Power[ x, 2]]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("dorthpoly["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]x
        \[InvisibleSpace]"]="\[InvisibleSpace]\(\( - 1\/2\) - 2\ x + x\^3\)\),
      
      SequenceForm[ "dorthpoly[", 3, ",", 3, ",", x, "]=", 
        Plus[ 
          Rational[ -1, 2], 
          Times[ -2, x], 
          Power[ x, 3]]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("dorthpoly["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]x
        \[InvisibleSpace]"]="\[InvisibleSpace]\(13\/12 - 2\ x - 4\ x\^2 + 
          x\^4\)\),
      SequenceForm[ "dorthpoly[", 3, ",", 4, ",", x, "]=", 
        Plus[ 
          Rational[ 13, 12], 
          Times[ -2, x], 
          Times[ -4, 
            Power[ x, 2]], 
          Power[ x, 4]]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("dorthpoly["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]x
        \[InvisibleSpace]"]="\[InvisibleSpace]\(10\/3 + \(65\ x\)\/12 - 
          5\ x\^2 - \(20\ x\^3\)\/3 + x\^5\)\),
      SequenceForm[ "dorthpoly[", 3, ",", 5, ",", x, "]=", 
        Plus[ 
          Rational[ 10, 3], 
          Times[ 
            Rational[ 65, 12], x], 
          Times[ -5, 
            Power[ x, 2]], 
          Times[ 
            Rational[ -20, 3], 
            Power[ x, 3]], 
          Power[ x, 5]]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("dorthpoly["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]6
        \[InvisibleSpace]","\[InvisibleSpace]x
        \[InvisibleSpace]"]="\[InvisibleSpace]\(5\/9 + 20\ x + 
          \(65\ x\^2\)\/4 - 10\ x\^3 - 10\ x\^4 + x\^6\)\),
      SequenceForm[ "dorthpoly[", 3, ",", 6, ",", x, "]=", 
        Plus[ 
          Rational[ 5, 9], 
          Times[ 20, x], 
          Times[ 
            Rational[ 65, 4], 
            Power[ x, 2]], 
          Times[ -10, 
            Power[ x, 3]], 
          Times[ -10, 
            Power[ x, 4]], 
          Power[ x, 6]]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("dorthpoly["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]7
        \[InvisibleSpace]","\[InvisibleSpace]x
        \[InvisibleSpace]"]="\[InvisibleSpace]\(\( - 455\/24\) + 
          \(35\ x\)\/9 + 70\ x\^2 + \(455\ x\^3\)\/12 - \(35\ x\^4\)\/2 - 
          14\ x\^5 + x\^7\)\),
      SequenceForm[ "dorthpoly[", 3, ",", 7, ",", x, "]=", 
        Plus[ 
          Rational[ -455, 24], 
          Times[ 
            Rational[ 35, 9], x], 
          Times[ 70, 
            Power[ x, 2]], 
          Times[ 
            Rational[ 455, 12], 
            Power[ x, 3]], 
          Times[ 
            Rational[ -35, 2], 
            Power[ x, 4]], 
          Times[ -14, 
            Power[ x, 5]], 
          Power[ x, 7]]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("dorthpoly["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]8
        \[InvisibleSpace]","\[InvisibleSpace]x
        \[InvisibleSpace]"]="\[InvisibleSpace]\(\( - 20335\/432\) - 
          \(455\ x\)\/3 + \(140\ x\^2\)\/9 + \(560\ x\^3\)\/3 + 
          \(455\ x\^4\)\/6 - 28\ x\^5 - \(56\ x\^6\)\/3 + x\^8\)\),
      SequenceForm[ "dorthpoly[", 3, ",", 8, ",", x, "]=", 
        Plus[ 
          Rational[ -20335, 432], 
          Times[ 
            Rational[ -455, 3], x], 
          Times[ 
            Rational[ 140, 9], 
            Power[ x, 2]], 
          Times[ 
            Rational[ 560, 3], 
            Power[ x, 3]], 
          Times[ 
            Rational[ 455, 6], 
            Power[ x, 4]], 
          Times[ -28, 
            Power[ x, 5]], 
          Times[ 
            Rational[ -56, 3], 
            Power[ x, 6]], 
          Power[ x, 8]]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("dorthpoly["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]9
        \[InvisibleSpace]","\[InvisibleSpace]x
        \[InvisibleSpace]"]="\[InvisibleSpace]\(140\/3 - \(20335\ x\)\/48 - 
          \(1365\ x\^2\)\/2 + \(140\ x\^3\)\/3 + 420\ x\^4 + 
          \(273\ x\^5\)\/2 - 42\ x\^6 - 24\ x\^7 + x\^9\)\),
      SequenceForm[ "dorthpoly[", 3, ",", 9, ",", x, "]=", 
        Plus[ 
          Rational[ 140, 3], 
          Times[ 
            Rational[ -20335, 48], x], 
          Times[ 
            Rational[ -1365, 2], 
            Power[ x, 2]], 
          Times[ 
            Rational[ 140, 3], 
            Power[ x, 3]], 
          Times[ 420, 
            Power[ x, 4]], 
          Times[ 
            Rational[ 273, 2], 
            Power[ x, 5]], 
          Times[ -42, 
            Power[ x, 6]], 
          Times[ -24, 
            Power[ x, 7]], 
          Power[ x, 9]]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("dorthpoly["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]10
        \[InvisibleSpace]","\[InvisibleSpace]x
        \[InvisibleSpace]"]="\[InvisibleSpace]\(44065\/72 + \(1400\ x\)\/3 - 
          \(101675\ x\^2\)\/48 - 2275\ x\^3 + \(350\ x\^4\)\/3 + 840\ x\^5 + 
          \(455\ x\^6\)\/2 - 60\ x\^7 - 30\ x\^8 + x\^10\)\),
      SequenceForm[ "dorthpoly[", 3, ",", 10, ",", x, "]=", 
        Plus[ 
          Rational[ 44065, 72], 
          Times[ 
            Rational[ 1400, 3], x], 
          Times[ 
            Rational[ -101675, 48], 
            Power[ x, 2]], 
          Times[ -2275, 
            Power[ x, 3]], 
          Times[ 
            Rational[ 350, 3], 
            Power[ x, 4]], 
          Times[ 840, 
            Power[ x, 5]], 
          Times[ 
            Rational[ 455, 2], 
            Power[ x, 6]], 
          Times[ -60, 
            Power[ x, 7]], 
          Times[ -30, 
            Power[ x, 8]], 
          Power[ x, 10]]],
      Editable->False]], "Print"],

Cell[BoxData[
    \({2.1666666666666714`\ Second, Null}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(MemoryInUse[]\)], "Input"],

Cell[BoxData[
    \(1038528\)], "Output"]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["\<\
Computing the recurrence coefficients and the orthogonal \
polynomials performing numerical computations with the machine precision\
\>",
   "Section",
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell["\<\
Loading the package chv.m, the package datachv52.m is automatically \
loaded\
\>", "Subsection"],

Cell[BoxData[
    \(\(<< chebyshev`chv`; \)\)], "Input"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Computing the gamma coefficients", "Subsection"],

Cell[BoxData[
    \(\( (*\ set\ the\ values\ of\ d\ and\ nmax\ *) \nd = 3; \ nmax = \ 35; 
    \ \ \ \ \  (*\ for\ example\ *) \)\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(MemoryInUse[]\)], "Input"],

Cell[BoxData[
    \(971544\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Timing[printgamma[d,nmax,$MachinePrecision,$MachinePrecision,True,\
True]]\
\>", "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    \("   "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gamma["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["0.249999999999999911`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gamma[", 3, ",", 0, ",", 1, "]=", 0.24999999999999989],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["0.25`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gammaexact[", 3, ",", 0, ",", 1, "]=", 0.25],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["14.9545897701910002`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 3, ",", 0, ",", 1, "]=", 14.954589770191001],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gamma["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["1.`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gamma[", 3, ",", 0, ",", 2, "]=", 1.0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["1.`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gammaexact[", 3, ",", 0, ",", 2, "]=", 1.0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        InterpretationBox["\[Infinity]",
          DirectedInfinity[ 1]]}],
      SequenceForm[ "exactdigits[", 3, ",", 0, ",", 2, "]=", 
        DirectedInfinity[ 1]],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gamma["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["2.50000000000001332`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gamma[", 3, ",", 0, ",", 3, "]=", 2.5000000000000133],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["2.5`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gammaexact[", 3, ",", 0, ",", 3, "]=", 2.5],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["13.8754085241433777`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 3, ",", 0, ",", 3, "]=", 13.875408524143378],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gamma["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "4", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["5.00000000000001687`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gamma[", 3, ",", 0, ",", 4, "]=", 5.0000000000000169],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "4", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["5.`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gammaexact[", 3, ",", 0, ",", 4, "]=", 5.0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "4", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["13.7727461822462293`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 3, ",", 0, ",", 4, "]=", 13.772746182246228],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gamma["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "5", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["8.75000000000019895`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gamma[", 3, ",", 0, ",", 5, "]=", 8.750000000000199],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "5", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["8.75`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gammaexact[", 3, ",", 0, ",", 5, "]=", 8.75],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "5", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["12.7012517648648959`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 3, ",", 0, ",", 5, "]=", 12.701251764864896],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gamma["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "6", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["13.9999999999969237`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gamma[", 3, ",", 0, ",", 6, "]=", 13.999999999996923],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "6", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["13.9999999999999991`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gammaexact[", 3, ",", 0, ",", 6, "]=", 14.0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "6", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["12.5119218998537506`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 3, ",", 0, ",", 6, "]=", 12.51192189985375],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gamma["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "7", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["21.0000000000104902`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gamma[", 3, ",", 0, ",", 7, "]=", 21.000000000010491],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "7", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["21.0000000000000008`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gammaexact[", 3, ",", 0, ",", 7, "]=", 21.0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "7", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["11.9791763449060173`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 3, ",", 0, ",", 7, "]=", 11.979176344906017],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gamma["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "8", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["30.0000000000415179`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gamma[", 3, ",", 0, ",", 8, "]=", 30.000000000041517],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "8", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["30.`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gammaexact[", 3, ",", 0, ",", 8, "]=", 30.0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "8", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["11.3817739098968462`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 3, ",", 0, ",", 8, "]=", 11.381773909896847],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gamma["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "9", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["41.2499999996770583`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gamma[", 3, ",", 0, ",", 9, "]=", 41.249999999677058],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "9", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["41.25`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gammaexact[", 3, ",", 0, ",", 9, "]=", 41.25],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "9", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["10.4908759086491287`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 3, ",", 0, ",", 9, "]=", 10.490875908649128],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gamma["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "10", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["55.0000000014414158`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gamma[", 3, ",", 0, ",", 10, "]=", 55.000000001441414],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "10", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["55.`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gammaexact[", 3, ",", 0, ",", 10, "]=", 55.0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "10", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["9.84121123420483989`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 3, ",", 0, ",", 10, "]=", 9.8412112342048399],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gamma["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "11", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["71.4999999985902423`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gamma[", 3, ",", 0, ",", 11, "]=", 71.499999998590241],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "11", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["71.5000000000000035`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gammaexact[", 3, ",", 0, ",", 11, "]=", 71.5],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "11", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["9.85085499468184622`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 3, ",", 0, ",", 11, "]=", 9.8508549946818462],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gamma["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "12", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["90.9999999881027221`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gamma[", 3, ",", 0, ",", 12, "]=", 90.999999988102715],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "12", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["90.9999999999999964`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gammaexact[", 3, ",", 0, ",", 12, "]=", 91.0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "12", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["8.92455213711845907`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 3, ",", 0, ",", 12, "]=", 8.9245521371184591],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gamma["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "13", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["113.75000010643046`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gamma[", 3, ",", 0, ",", 13, "]=", 113.75000010643045],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "13", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["113.749999999999995`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gammaexact[", 3, ",", 0, ",", 13, "]=", 113.75],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "13", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["8.9729341079057967`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 3, ",", 0, ",", 13, "]=", 8.9729341079057967],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gamma["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "14", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["139.999999514439688`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gamma[", 3, ",", 0, ",", 14, "]=", 139.99999951443968],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "14", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["139.999999999999991`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gammaexact[", 3, ",", 0, ",", 14, "]=", 140.0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "14", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["8.31375681028618984`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 3, ",", 0, ",", 14, "]=", 8.3137568102861898],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gamma["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "15", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["170.000001106385623`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gamma[", 3, ",", 0, ",", 15, "]=", 170.00000110638564],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "15", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["170.`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gammaexact[", 3, ",", 0, ",", 15, "]=", 170.0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "15", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["7.95609347000834432`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 3, ",", 0, ",", 15, "]=", 7.9560934700083443],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gamma["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "16", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["203.999997587586001`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gamma[", 3, ",", 0, ",", 16, "]=", 203.99999758758599],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "16", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["204.000000000000003`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gammaexact[", 3, ",", 0, ",", 16, "]=", 204.0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "16", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["7.61754815886497738`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 3, ",", 0, ",", 16, "]=", 7.6175481588649774],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gamma["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "17", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["242.250000714132029`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gamma[", 3, ",", 0, ",", 17, "]=", 242.25000071413203],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "17", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["242.250000000000031`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gammaexact[", 3, ",", 0, ",", 17, "]=", 242.25],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "17", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["8.14622148877167262`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 3, ",", 0, ",", 17, "]=", 8.1462214887716726],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gamma["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "18", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["285.000034393159928`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gamma[", 3, ",", 0, ",", 18, "]=", 285.00003439315992],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "18", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["285.`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gammaexact[", 3, ",", 0, ",", 18, "]=", 285.0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "18", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["6.46352792090480221`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 3, ",", 0, ",", 18, "]=", 6.4635279209048022],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gamma["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "19", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["332.49992388052747`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gamma[", 3, ",", 0, ",", 19, "]=", 332.49992388052743],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "19", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["332.500000000000017`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gammaexact[", 3, ",", 0, ",", 19, "]=", 332.5],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "19", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["6.11850422960823969`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 3, ",", 0, ",", 19, "]=", 6.1185042296082397],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gamma["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "20", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["384.999926458473051`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gamma[", 3, ",", 0, ",", 20, "]=", 384.99992645847306],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "20", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["385.`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gammaexact[", 3, ",", 0, ",", 20, "]=", 385.0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "20", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["6.13346735710607937`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 3, ",", 0, ",", 20, "]=", 6.1334673571060794],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gamma["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "21", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["442.749672907359403`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gamma[", 3, ",", 0, ",", 21, "]=", 442.74967290735941],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "21", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["442.750000000000021`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gammaexact[", 3, ",", 0, ",", 21, "]=", 442.75],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "21", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["5.48532922716076321`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 3, ",", 0, ",", 21, "]=", 5.4853292271607632],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gamma["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "22", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["506.003855623973386`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gamma[", 3, ",", 0, ",", 22, "]=", 506.00385562397332],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "22", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["506.000000000000049`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gammaexact[", 3, ",", 0, ",", 22, "]=", 506.0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "22", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["4.41390532805608337`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 3, ",", 0, ",", 22, "]=", 4.4139053280560834],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gamma["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "23", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["574.984271943201719`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gamma[", 3, ",", 0, ",", 23, "]=", 574.98427194320175],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "23", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["575.`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gammaexact[", 3, ",", 0, ",", 23, "]=", 575.0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "23", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["3.80332493115467151`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 3, ",", 0, ",", 23, "]=", 3.8033249311546715],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gamma["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "24", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["650.09057588318786`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gamma[", 3, ",", 0, ",", 24, "]=", 650.09057588318785],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "24", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["650.`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gammaexact[", 3, ",", 0, ",", 24, "]=", 650.0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "24", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["3.04298742255159826`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 3, ",", 0, ",", 24, "]=", 3.0429874225515983],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gamma["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "25", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["730.809561759077475`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gamma[", 3, ",", 0, ",", 25, "]=", 730.8095617590775],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "25", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["731.25`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gammaexact[", 3, ",", 0, ",", 25, "]=", 731.25],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "25", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["2.35611498057081103`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 3, ",", 0, ",", 25, "]=", 2.356114980570811],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gamma["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "26", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["820.632686896113483`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gamma[", 3, ",", 0, ",", 26, "]=", 820.63268689611346],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "26", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["819.000000000000127`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gammaexact[", 3, ",", 0, ",", 26, "]=", 819.0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "26", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["1.78709709286766527`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 3, ",", 0, ",", 26, "]=", 1.7870970928676653],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gamma["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "27", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["908.065532277008102`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gamma[", 3, ",", 0, ",", 27, "]=", 908.06553227700817],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "27", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["913.499999999999978`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gammaexact[", 3, ",", 0, ",", 27, "]=", 913.5],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "27", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["1.26484298631325398`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 3, ",", 0, ",", 27, "]=", 1.264842986313254],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gamma["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "28", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["1026.28902245596598`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gamma[", 3, ",", 0, ",", 28, "]=", 1026.289022455966],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "28", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["1015.00000000000012`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gammaexact[", 3, ",", 0, ",", 28, "]=", 1015.0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "28", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["1.94734366306708839`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 3, ",", 0, ",", 28, "]=", 1.9473436630670884],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gamma["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "29", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["1132.64059896259516`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gamma[", 3, ",", 0, ",", 29, "]=", 1132.6405989625953],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "29", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["1123.75000000000002`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gammaexact[", 3, ",", 0, ",", 29, "]=", 1123.75],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "29", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["2.05106897948114674`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 3, ",", 0, ",", 29, "]=", 2.0510689794811467],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gamma["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "30", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["1053.26506415732712`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gamma[", 3, ",", 0, ",", 30, "]=", 1053.2650641573271],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "30", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["1239.99999999999999`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gammaexact[", 3, ",", 0, ",", 30, "]=", 1240.0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "30", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["0.728774423216884237`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 3, ",", 0, ",", 30, "]=", 0.72877442321688424],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gamma["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "31", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["2382.08993327673335`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gamma[", 3, ",", 0, ",", 31, "]=", 2382.0899332767331],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "31", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["1364.0000000000001`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gammaexact[", 3, ",", 0, ",", 31, "]=", 1364.0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "31", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        RowBox[{"-", 
          StyleBox["0.00778614322735515784`",
            StyleBoxAutoDelete->True,
            PrintPrecision->2]}]}],
      SequenceForm[ 
      "exactdigits[", 3, ",", 0, ",", 31, "]=", -0.0077861432273551578],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gamma["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "32", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        RowBox[{"-", 
          StyleBox["1540.05735452537395`",
            StyleBoxAutoDelete->True,
            PrintPrecision->16]}]}],
      SequenceForm[ "gamma[", 3, ",", 0, ",", 32, "]=", -1540.057354525374],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "32", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["1495.99999999999999`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gammaexact[", 3, ",", 0, ",", 32, "]=", 1496.0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "32", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        RowBox[{"-", 
          StyleBox["0.482309971610333843`",
            StyleBoxAutoDelete->True,
            PrintPrecision->2]}]}],
      SequenceForm[ 
      "exactdigits[", 3, ",", 0, ",", 32, "]=", -0.48230997161033384],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gamma["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "33", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        RowBox[{"-", 
          StyleBox["200.803969321425901`",
            StyleBoxAutoDelete->True,
            PrintPrecision->16]}]}],
      SequenceForm[ "gamma[", 3, ",", 0, ",", 33, "]=", -200.80396932142591],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "33", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["1636.24999999999998`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gammaexact[", 3, ",", 0, ",", 33, "]=", 1636.25],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "33", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        RowBox[{"-", 
          StyleBox["1.26412191527923889`",
            StyleBoxAutoDelete->True,
            PrintPrecision->2]}]}],
      SequenceForm[ 
      "exactdigits[", 3, ",", 0, ",", 33, "]=", -1.2641219152792389],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    \("   "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gamma["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["0.5`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gamma[", 3, ",", 1, ",", 1, "]=", 0.5],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["0.5`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gammaexact[", 3, ",", 1, ",", 1, "]=", 0.5],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        InterpretationBox["\[Infinity]",
          DirectedInfinity[ 1]]}],
      SequenceForm[ "exactdigits[", 3, ",", 1, ",", 1, "]=", 
        DirectedInfinity[ 1]],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gamma["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["1.5`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gamma[", 3, ",", 1, ",", 2, "]=", 1.5],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["1.5`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gammaexact[", 3, ",", 1, ",", 2, "]=", 1.5],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        InterpretationBox["\[Infinity]",
          DirectedInfinity[ 1]]}],
      SequenceForm[ "exactdigits[", 3, ",", 1, ",", 2, "]=", 
        DirectedInfinity[ 1]],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gamma["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["3.`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gamma[", 3, ",", 1, ",", 3, "]=", 3.0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["3.`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gammaexact[", 3, ",", 1, ",", 3, "]=", 3.0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        InterpretationBox["\[Infinity]",
          DirectedInfinity[ 1]]}],
      SequenceForm[ "exactdigits[", 3, ",", 1, ",", 3, "]=", 
        DirectedInfinity[ 1]],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gamma["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "4", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["5.00000000000002575`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gamma[", 3, ",", 1, ",", 4, "]=", 5.0000000000000258],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "4", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["5.`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gammaexact[", 3, ",", 1, ",", 4, "]=", 5.0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "4", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["13.5891017853001017`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 3, ",", 1, ",", 4, "]=", 13.589101785300102],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gamma["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "5", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["7.4999999999999396`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gamma[", 3, ",", 1, ",", 5, "]=", 7.4999999999999396],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "5", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["7.5`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gammaexact[", 3, ",", 1, ",", 5, "]=", 7.5],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "5", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["13.2189908704928216`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 3, ",", 1, ",", 5, "]=", 13.218990870492823],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gamma["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "6", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["10.5000000000000914`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gamma[", 3, ",", 1, ",", 6, "]=", 10.500000000000092],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "6", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["10.5000000000000004`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gammaexact[", 3, ",", 1, ",", 6, "]=", 10.5],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "6", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["14.0344664439002775`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 3, ",", 1, ",", 6, "]=", 14.034466443900278],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gamma["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "7", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["13.9999999999995171`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gamma[", 3, ",", 1, ",", 7, "]=", 13.999999999999517],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "7", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["13.9999999999999991`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gammaexact[", 3, ",", 1, ",", 7, "]=", 14.0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "7", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["13.3159008835008796`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 3, ",", 1, ",", 7, "]=", 13.315900883500879],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gamma["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "8", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["17.9999999999977022`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gamma[", 3, ",", 1, ",", 8, "]=", 17.999999999997701],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "8", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["18.`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gammaexact[", 3, ",", 1, ",", 8, "]=", 18.0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "8", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["12.6385355112023956`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 3, ",", 1, ",", 8, "]=", 12.638535511202395],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gamma["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "9", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["22.5000000000347455`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gamma[", 3, ",", 1, ",", 9, "]=", 22.500000000034746],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "9", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["22.5`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gammaexact[", 3, ",", 1, ",", 9, "]=", 22.5],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "9", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["11.459100937083495`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 3, ",", 1, ",", 9, "]=", 11.459100937083495],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gamma["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "10", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["27.4999999999504085`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gamma[", 3, ",", 1, ",", 10, "]=", 27.499999999950408],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "10", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["27.5`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gammaexact[", 3, ",", 1, ",", 10, "]=", 27.5],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "10", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["11.3045854846181681`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 3, ",", 1, ",", 10, "]=", 11.304585484618167],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gamma["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "11", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["32.9999999995391402`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gamma[", 3, ",", 1, ",", 11, "]=", 32.999999999539142],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "11", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["32.9999999999999982`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gammaexact[", 3, ",", 1, ",", 11, "]=", 33.0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "11", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["10.3364328518701631`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 3, ",", 1, ",", 11, "]=", 10.336432851870162],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gamma["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "12", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["39.0000000030727775`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gamma[", 3, ",", 1, ",", 12, "]=", 39.000000003072778],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "12", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["39.`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gammaexact[", 3, ",", 1, ",", 12, "]=", 39.0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "12", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["9.51246887346629854`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 3, ",", 1, ",", 12, "]=", 9.5124688734662985],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gamma["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "13", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["45.4999999906565122`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gamma[", 3, ",", 1, ",", 13, "]=", 45.499999990656512],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "13", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["45.4999999999999982`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gammaexact[", 3, ",", 1, ",", 13, "]=", 45.5],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "13", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["9.02949097893795027`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 3, ",", 1, ",", 13, "]=", 9.0294909789379503],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gamma["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "14", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["52.5000000193119387`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gamma[", 3, ",", 1, ",", 14, "]=", 52.50000001931194],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "14", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["52.5`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gammaexact[", 3, ",", 1, ",", 14, "]=", 52.5],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "14", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["8.71417408550171401`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 3, ",", 1, ",", 14, "]=", 8.714174085501714],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gamma["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "15", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["59.9999999729843658`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gamma[", 3, ",", 1, ",", 15, "]=", 59.999999972984362],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "15", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["60.`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gammaexact[", 3, ",", 1, ",", 15, "]=", 60.0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "15", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["8.56838477611662341`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 3, ",", 1, ",", 15, "]=", 8.5683847761166234],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gamma["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "16", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["67.9999996232841841`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gamma[", 3, ",", 1, ",", 16, "]=", 67.999999623284182],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "16", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["67.9999999999999982`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gammaexact[", 3, ",", 1, ",", 16, "]=", 68.0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "16", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["7.42398614413292889`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 3, ",", 1, ",", 16, "]=", 7.4239861441329289],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gamma["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "17", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["76.5000019412011056`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gamma[", 3, ",", 1, ",", 17, "]=", 76.500001941201106],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "17", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["76.5000000000000035`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gammaexact[", 3, ",", 1, ",", 17, "]=", 76.5],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "17", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["6.71192946999836248`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 3, ",", 1, ",", 17, "]=", 6.7119294699983625],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gamma["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "18", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["85.4999965403315265`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gamma[", 3, ",", 1, ",", 18, "]=", 85.499996540331523],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "18", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["85.5000000000000071`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gammaexact[", 3, ",", 1, ",", 18, "]=", 85.5],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "18", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["6.46096551551141651`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 3, ",", 1, ",", 18, "]=", 6.4609655155114165],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gamma["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "19", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["95.0000093852061056`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gamma[", 3, ",", 1, ",", 19, "]=", 95.000009385206113],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "19", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["95.`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gammaexact[", 3, ",", 1, ",", 19, "]=", 95.0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "19", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["6.02755618520245839`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 3, ",", 1, ",", 19, "]=", 6.0275561852024584],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gamma["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "20", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["104.999964685727342`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gamma[", 3, ",", 1, ",", 20, "]=", 104.99996468572733],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "20", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["105.000000000000004`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gammaexact[", 3, ",", 1, ",", 20, "]=", 105.0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "20", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["6.45204973407454396`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 3, ",", 1, ",", 20, "]=", 6.452049734074544],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gamma["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "21", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["115.500041140100928`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gamma[", 3, ",", 1, ",", 21, "]=", 115.50004114010093],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "21", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["115.500000000000002`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gammaexact[", 3, ",", 1, ",", 21, "]=", 115.5],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "21", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["6.38573464714284355`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 3, ",", 1, ",", 21, "]=", 6.3857346471428436],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gamma["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "22", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["126.499826653545111`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gamma[", 3, ",", 1, ",", 22, "]=", 126.4998266535451],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "22", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["126.500000000000012`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gammaexact[", 3, ",", 1, ",", 22, "]=", 126.5],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "22", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["5.76108503565098217`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 3, ",", 1, ",", 22, "]=", 5.7610850356509822],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gamma["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "23", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["138.001569200919371`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gamma[", 3, ",", 1, ",", 23, "]=", 138.00156920091936],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "23", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["138.00000000000001`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gammaexact[", 3, ",", 1, ",", 23, "]=", 138.0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "23", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["4.80432144609813605`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 3, ",", 1, ",", 23, "]=", 4.8043214460981361],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gamma["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "24", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["149.996450584417706`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gamma[", 3, ",", 1, ",", 24, "]=", 149.99645058441772],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "24", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["150.`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gammaexact[", 3, ",", 1, ",", 24, "]=", 150.0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "24", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["4.44984314843303607`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 3, ",", 1, ",", 24, "]=", 4.4498431484330361],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gamma["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "25", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["162.502864182873274`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gamma[", 3, ",", 1, ",", 25, "]=", 162.50286418287328],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "25", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["162.5`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gammaexact[", 3, ",", 1, ",", 25, "]=", 162.5],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "25", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["4.5429992565032915`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 3, ",", 1, ",", 25, "]=", 4.5429992565032915],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gamma["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "26", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["175.498753636414184`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gamma[", 3, ",", 1, ",", 26, "]=", 175.49875363641419],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "26", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["175.500000000000007`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gammaexact[", 3, ",", 1, ",", 26, "]=", 175.5],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "26", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["4.90435524798517796`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 3, ",", 1, ",", 26, "]=", 4.904355247985178],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gamma["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "27", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["188.850699464690556`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gamma[", 3, ",", 1, ",", 27, "]=", 188.85069946469056],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "27", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["188.999999999999985`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gammaexact[", 3, ",", 1, ",", 27, "]=", 189.0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "27", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["2.82593863513152232`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 3, ",", 1, ",", 27, "]=", 2.8259386351315223],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gamma["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "28", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["204.175658181302743`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gamma[", 3, ",", 1, ",", 28, "]=", 204.17565818130274],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "28", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["203.000000000000024`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gammaexact[", 3, ",", 1, ",", 28, "]=", 203.0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "28", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["1.92971892958012603`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 3, ",", 1, ",", 28, "]=", 1.929718929580126],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gamma["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "29", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["212.532823106028567`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gamma[", 3, ",", 1, ",", 29, "]=", 212.53282310602856],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "29", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["217.499999999999982`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gammaexact[", 3, ",", 1, ",", 29, "]=", 217.5],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "29", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["1.3038903733835343`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 3, ",", 1, ",", 29, "]=", 1.3038903733835343],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gamma["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "30", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["249.892999549070049`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gamma[", 3, ",", 1, ",", 30, "]=", 249.89299954907005],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "30", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["232.500000000000017`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gammaexact[", 3, ",", 1, ",", 30, "]=", 232.5],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "30", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["0.75962551430126135`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 3, ",", 1, ",", 30, "]=", 0.75962551430126135],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gamma["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "31", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["207.525728853774804`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gamma[", 3, ",", 1, ",", 31, "]=", 207.52572885377481],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "31", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["247.999999999999998`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gammaexact[", 3, ",", 1, ",", 31, "]=", 248.0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "31", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["0.392820963205165121`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 3, ",", 1, ",", 31, "]=", 0.39282096320516513],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gamma["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "32", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["375.60019329305101`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gamma[", 3, ",", 1, ",", 32, "]=", 375.60019329305101],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "32", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["263.999999999999968`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gammaexact[", 3, ",", 1, ",", 32, "]=", 264.0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "32", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        RowBox[{"-", 
          StyleBox["0.0476649468061540737`",
            StyleBoxAutoDelete->True,
            PrintPrecision->2]}]}],
      SequenceForm[ 
      "exactdigits[", 3, ",", 1, ",", 32, "]=", -0.047664946806154074],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gamma["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "33", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["670.173834838140258`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gamma[", 3, ",", 1, ",", 33, "]=", 670.17383483814035],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "33", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["280.500000000000007`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gammaexact[", 3, ",", 1, ",", 33, "]=", 280.5],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "33", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        RowBox[{"-", 
          StyleBox["0.590701245497822213`",
            StyleBoxAutoDelete->True,
            PrintPrecision->2]}]}],
      SequenceForm[ 
      "exactdigits[", 3, ",", 1, ",", 33, "]=", -0.59070124549782221],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gamma["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "34", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        RowBox[{"-", 
          StyleBox["564.571463079929714`",
            StyleBoxAutoDelete->True,
            PrintPrecision->16]}]}],
      SequenceForm[ "gamma[", 3, ",", 1, ",", 34, "]=", -564.57146307992969],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "34", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["297.5`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gammaexact[", 3, ",", 1, ",", 34, "]=", 297.5],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "34", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        RowBox[{"-", 
          StyleBox["0.935543268997383137`",
            StyleBoxAutoDelete->True,
            PrintPrecision->2]}]}],
      SequenceForm[ 
      "exactdigits[", 3, ",", 1, ",", 34, "]=", -0.93554326899738305],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    \("   "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gamma["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["0.666666666666666607`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gamma[", 3, ",", 2, ",", 1, "]=", 0.66666666666666663],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["0.666666666666666607`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "gammaexact[", 3, ",", 2, ",", 1, "]=", 0.66666666666666663],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        InterpretationBox["\[Infinity]",
          DirectedInfinity[ 1]]}],
      SequenceForm[ "exactdigits[", 3, ",", 2, ",", 1, "]=", 
        DirectedInfinity[ 1]],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gamma["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["1.33333333333333348`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gamma[", 3, ",", 2, ",", 2, "]=", 1.3333333333333335],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["1.33333333333333325`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "gammaexact[", 3, ",", 2, ",", 2, "]=", 1.3333333333333333],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["15.6535597745270171`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 3, ",", 2, ",", 2, "]=", 15.653559774527018],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gamma["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["2.`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gamma[", 3, ",", 2, ",", 3, "]=", 2.0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["2.`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gammaexact[", 3, ",", 2, ",", 3, "]=", 2.0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        InterpretationBox["\[Infinity]",
          DirectedInfinity[ 1]]}],
      SequenceForm[ "exactdigits[", 3, ",", 2, ",", 3, "]=", 
        DirectedInfinity[ 1]],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gamma["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "4", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["2.66666666666667273`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gamma[", 3, ",", 2, ",", 4, "]=", 2.6666666666666727],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "4", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["2.66666666666666651`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "gammaexact[", 3, ",", 2, ",", 4, "]=", 2.6666666666666665],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "4", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["14.2064017431848004`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 3, ",", 2, ",", 4, "]=", 14.2064017431848],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gamma["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "5", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["3.33333333333332326`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gamma[", 3, ",", 2, ",", 5, "]=", 3.3333333333333233],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "5", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["3.33333333333333348`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "gammaexact[", 3, ",", 2, ",", 5, "]=", 3.3333333333333335],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "5", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["13.9908019428454476`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 3, ",", 2, ",", 5, "]=", 13.990801942845447],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gamma["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "6", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["4.00000000000004085`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gamma[", 3, ",", 2, ",", 6, "]=", 4.0000000000000409],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "6", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["4.`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gammaexact[", 3, ",", 2, ",", 6, "]=", 4.0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "6", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["13.3887419515174843`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 3, ",", 2, ",", 6, "]=", 13.388741951517485],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gamma["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "7", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["4.66666666666656393`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gamma[", 3, ",", 2, ",", 7, "]=", 4.6666666666665639],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "7", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["4.66666666666666696`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "gammaexact[", 3, ",", 2, ",", 7, "]=", 4.666666666666667],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "7", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["12.9870417939721406`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 3, ",", 2, ",", 7, "]=", 12.987041793972141],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gamma["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "8", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["5.33333333333364922`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gamma[", 3, ",", 2, ",", 8, "]=", 5.3333333333336492],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "8", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["5.33333333333333303`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "gammaexact[", 3, ",", 2, ",", 8, "]=", 5.333333333333333],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "8", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["12.5000497852261838`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 3, ",", 2, ",", 8, "]=", 12.500049785226183],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gamma["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "9", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["6.00000000000508038`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gamma[", 3, ",", 2, ",", 9, "]=", 6.0000000000050804],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "9", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["6.`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gammaexact[", 3, ",", 2, ",", 9, "]=", 6.0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "9", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["11.2941037544060352`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 3, ",", 2, ",", 9, "]=", 11.294103754406036],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gamma["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "10", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["6.66666666664483287`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gamma[", 3, ",", 2, ",", 10, "]=", 6.6666666666448329],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "10", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["6.66666666666666696`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "gammaexact[", 3, ",", 2, ",", 10, "]=", 6.666666666666667],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "10", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["10.6608649020471824`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 3, ",", 2, ",", 10, "]=", 10.660864902047182],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gamma["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "11", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["7.33333333333587855`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gamma[", 3, ",", 2, ",", 11, "]=", 7.3333333333358786],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "11", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["7.33333333333333303`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "gammaexact[", 3, ",", 2, ",", 11, "]=", 7.333333333333333],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "11", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["11.5942235971377316`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 3, ",", 2, ",", 11, "]=", 11.594223597137733],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gamma["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "12", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["8.00000000033668712`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gamma[", 3, ",", 2, ",", 12, "]=", 8.0000000003366871],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "12", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["8.`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gammaexact[", 3, ",", 2, ",", 12, "]=", 8.0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "12", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["9.47277349388607703`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 3, ",", 2, ",", 12, "]=", 9.472773493886077],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gamma["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "13", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["8.66666666506246663`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gamma[", 3, ",", 2, ",", 13, "]=", 8.6666666650624666],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "13", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["8.66666666666666607`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "gammaexact[", 3, ",", 2, ",", 13, "]=", 8.6666666666666661],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "13", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["8.79474163961381272`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 3, ",", 2, ",", 13, "]=", 8.7947416396138127],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gamma["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "14", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["9.33333333750709748`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gamma[", 3, ",", 2, ",", 14, "]=", 9.3333333375070975],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "14", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["9.33333333333333392`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "gammaexact[", 3, ",", 2, ",", 14, "]=", 9.3333333333333339],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "14", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["8.3794721572835833`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 3, ",", 2, ",", 14, "]=", 8.3794721572835833],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gamma["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "15", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["9.99999998944540458`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gamma[", 3, ",", 2, ",", 15, "]=", 9.9999999894454046],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "15", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["10.`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gammaexact[", 3, ",", 2, ",", 15, "]=", 10.0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "15", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["7.97655840946981342`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 3, ",", 2, ",", 15, "]=", 7.9765584094698134],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gamma["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "16", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["10.6666666653648567`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gamma[", 3, ",", 2, ",", 16, "]=", 10.666666665364856],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "16", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["10.6666666666666665`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "gammaexact[", 3, ",", 2, ",", 16, "]=", 10.666666666666666],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "16", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["9.88545232491297376`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 3, ",", 2, ",", 16, "]=", 9.8854523249129738],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gamma["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "17", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["11.3333335145415858`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gamma[", 3, ",", 2, ",", 17, "]=", 11.333333514541586],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "17", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["11.333333333333333`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "gammaexact[", 3, ",", 2, ",", 17, "]=", 11.333333333333334],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "17", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["7.74182202907227079`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 3, ",", 2, ",", 17, "]=", 7.7418220290722708],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gamma["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "18", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["11.9999994016899025`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gamma[", 3, ",", 2, ",", 18, "]=", 11.999999401689903],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "18", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["11.9999999999999996`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gammaexact[", 3, ",", 2, ",", 18, "]=", 12.0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "18", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["7.22307366830779784`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 3, ",", 2, ",", 18, "]=", 7.2230736683077978],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gamma["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "19", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["12.6666679476011778`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gamma[", 3, ",", 2, ",", 19, "]=", 12.666667947601178],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "19", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["12.666666666666666`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "gammaexact[", 3, ",", 2, ",", 19, "]=", 12.666666666666666],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "19", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["6.8924730729881638`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 3, ",", 2, ",", 19, "]=", 6.8924730729881638],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gamma["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "20", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["13.3333294102925026`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gamma[", 3, ",", 2, ",", 20, "]=", 13.333329410292503],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "20", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["13.3333333333333348`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "gammaexact[", 3, ",", 2, ",", 20, "]=", 13.333333333333334],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "20", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["6.40637717172696419`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 3, ",", 2, ",", 20, "]=", 6.4063771717269642],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gamma["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "21", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["14.00000759865698`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gamma[", 3, ",", 2, ",", 21, "]=", 14.00000759865698],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "21", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["13.9999999999999991`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gammaexact[", 3, ",", 2, ",", 21, "]=", 14.0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "21", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["6.11926316004581938`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 3, ",", 2, ",", 21, "]=", 6.1192631600458194],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gamma["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "22", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["14.6666567399993557`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gamma[", 3, ",", 2, ",", 22, "]=", 14.666656739999356],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "22", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["14.666666666666666`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "gammaexact[", 3, ",", 2, ",", 22, "]=", 14.666666666666666],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "22", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["6.00319653314143053`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 3, ",", 2, ",", 22, "]=", 6.0031965331414305],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gamma["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "23", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["15.3334463092035129`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gamma[", 3, ",", 2, ",", 23, "]=", 15.333446309203513],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "23", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["15.3333333333333339`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "gammaexact[", 3, ",", 2, ",", 23, "]=", 15.333333333333334],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "23", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["4.94701430489844362`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 3, ",", 2, ",", 23, "]=", 4.9470143048984436],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gamma["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "24", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["15.9994649902905372`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gamma[", 3, ",", 2, ",", 24, "]=", 15.999464990290537],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "24", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["16.0000000000000008`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gammaexact[", 3, ",", 2, ",", 24, "]=", 16.0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "24", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["4.27163833624451427`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 3, ",", 2, ",", 24, "]=", 4.2716383362445143],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gamma["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "25", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["16.6677948816991472`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gamma[", 3, ",", 2, ",", 25, "]=", 16.667794881699148],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "25", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["16.6666666666666678`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "gammaexact[", 3, ",", 2, ",", 25, "]=", 16.666666666666668],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "25", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["3.94760811797727662`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 3, ",", 2, ",", 25, "]=", 3.9476081179772766],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gamma["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "26", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["17.3303901811891769`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gamma[", 3, ",", 2, ",", 26, "]=", 17.330390181189177],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "26", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["17.3333333333333321`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "gammaexact[", 3, ",", 2, ",", 26, "]=", 17.333333333333332],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "26", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["3.53118728677596926`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 3, ",", 2, ",", 26, "]=", 3.5311872867759693],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gamma["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "27", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["18.0057083462084399`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gamma[", 3, ",", 2, ",", 27, "]=", 18.00570834620844],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "27", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["18.`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gammaexact[", 3, ",", 2, ",", 27, "]=", 18.0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "27", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["3.24348969500808248`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 3, ",", 2, ",", 27, "]=", 3.2434896950080825],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gamma["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "28", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["18.6979884569625127`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gamma[", 3, ",", 2, ",", 28, "]=", 18.697988456962513],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "28", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["18.6666666666666678`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "gammaexact[", 3, ",", 2, ",", 28, "]=", 18.666666666666668],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "28", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["2.50415342243193173`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 3, ",", 2, ",", 28, "]=", 2.5041534224319317],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gamma["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "29", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["19.0551854651695897`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gamma[", 3, ",", 2, ",", 29, "]=", 19.05518546516959],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "29", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["19.3333333333333321`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "gammaexact[", 3, ",", 2, ",", 29, "]=", 19.333333333333332],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "29", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["1.55572426431661359`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 3, ",", 2, ",", 29, "]=", 1.5557242643166136],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gamma["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "30", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["21.3255378150536056`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gamma[", 3, ",", 2, ",", 30, "]=", 21.325537815053607],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "30", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["20.`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gammaexact[", 3, ",", 2, ",", 30, "]=", 20.0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "30", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["0.877607878164870314`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 3, ",", 2, ",", 30, "]=", 0.8776078781648704],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gamma["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "31", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["15.7873759900422028`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gamma[", 3, ",", 2, ",", 31, "]=", 15.787375990042204],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "31", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["20.6666666666666687`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "gammaexact[", 3, ",", 2, ",", 31, "]=", 20.666666666666668],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "31", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["0.311643308656807782`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 3, ",", 2, ",", 31, "]=", 0.31164330865680778],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gamma["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "32", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["33.1569737562170852`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gamma[", 3, ",", 2, ",", 32, "]=", 33.156973756217084],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "32", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["21.333333333333333`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "gammaexact[", 3, ",", 2, ",", 32, "]=", 21.333333333333332],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "32", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        RowBox[{"-", 
          StyleBox["0.0727512136140147092`",
            StyleBoxAutoDelete->True,
            PrintPrecision->2]}]}],
      SequenceForm[ 
      "exactdigits[", 3, ",", 2, ",", 32, "]=", -0.072751213614014709],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gamma["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "33", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        RowBox[{"-", 
          StyleBox["22.5330832864361996`",
            StyleBoxAutoDelete->True,
            PrintPrecision->16]}]}],
      SequenceForm[ "gamma[", 3, ",", 2, ",", 33, "]=", -22.533083286436199],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "33", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["22.0000000000000017`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gammaexact[", 3, ",", 2, ",", 33, "]=", 22.0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "33", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        RowBox[{"-", 
          StyleBox["0.648682764925271992`",
            StyleBoxAutoDelete->True,
            PrintPrecision->2]}]}],
      SequenceForm[ 
      "exactdigits[", 3, ",", 2, ",", 33, "]=", -0.64868276492527199],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gamma["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "34", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        RowBox[{"-", 
          StyleBox["14.3556752360650152`",
            StyleBoxAutoDelete->True,
            PrintPrecision->16]}]}],
      SequenceForm[ "gamma[", 3, ",", 2, ",", 34, "]=", -14.355675236065014],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "34", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["22.666666666666666`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "gammaexact[", 3, ",", 2, ",", 34, "]=", 22.666666666666668],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "34", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        RowBox[{"-", 
          StyleBox["0.568463887222518504`",
            StyleBoxAutoDelete->True,
            PrintPrecision->2]}]}],
      SequenceForm[ 
      "exactdigits[", 3, ",", 2, ",", 34, "]=", -0.5684638872225185],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gamma["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "35", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        RowBox[{"-", 
          StyleBox["288.645390592567796`",
            StyleBoxAutoDelete->True,
            PrintPrecision->16]}]}],
      SequenceForm[ "gamma[", 3, ",", 2, ",", 35, "]=", -288.64539059256776],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "35", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["23.3333333333333303`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "gammaexact[", 3, ",", 2, ",", 35, "]=", 23.333333333333332],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "35", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        RowBox[{"-", 
          StyleBox["0.494124977362530692`",
            StyleBoxAutoDelete->True,
            PrintPrecision->2]}]}],
      SequenceForm[ 
      "exactdigits[", 3, ",", 2, ",", 35, "]=", -0.49412497736253069],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    \({57.5499999999999811`\ Second, Null}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(MemoryInUse[]\)], "Input"],

Cell[BoxData[
    \(1469032\)], "Output"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Computing the beta coefficients", "Subsection"],

Cell[BoxData[
    \(\( (*\ set\ the\ values\ of\ d\ and\ nmax\ *) \nd = 3; \ 
    nmax = \ 35\ \ ; \ \  (*\ for\ example\ *) \)\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(MemoryInUse[]\)], "Input"],

Cell[BoxData[
    \(1470816\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Timing[printbeta[d,nmax,$MachinePrecision,$MachinePrecision,True,\
True]]\
\>", "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    InterpretationBox[
      \("beta["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]0
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "beta[", 3, ",", 0, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("betaexact["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]0
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "betaexact[", 3, ",", 0, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]0
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 3, ",", 0, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("beta["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "beta[", 3, ",", 1, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("betaexact["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "betaexact[", 3, ",", 1, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 3, ",", 1, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("beta["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "beta[", 3, ",", 2, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("betaexact["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "betaexact[", 3, ",", 2, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 3, ",", 2, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("beta["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["0.`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "beta[", 3, ",", 3, "]=", 0.0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("betaexact["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "betaexact[", 3, ",", 3, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("abserror["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\),
         "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["0.`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ "abserror[", 3, ",", 3, "]=", 0.0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("beta["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "4", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        RowBox[{"-", 
          StyleBox["8.88178419700125232`*^-15",
            StyleBoxAutoDelete->True,
            PrintPrecision->16]}]}],
      SequenceForm[ "beta[", 3, ",", 4, "]=", -8.8817841970012523*^-15],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("betaexact["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "betaexact[", 3, ",", 4, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("abserror["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\),
         "\[InvisibleSpace]", "4", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["8.88178419700125232`*^-15",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ "abserror[", 3, ",", 4, "]=", 8.8817841970012523*^-15],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("beta["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "5", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["1.13686837721615408`*^-14",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "beta[", 3, ",", 5, "]=", 1.1368683772161542*^-14],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("betaexact["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "betaexact[", 3, ",", 5, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("abserror["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\),
         "\[InvisibleSpace]", "5", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["1.13686837721615408`*^-14",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ "abserror[", 3, ",", 5, "]=", 1.1368683772161542*^-14],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("beta["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "6", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        RowBox[{"-", 
          StyleBox["3.97903932025655002`*^-14",
            StyleBoxAutoDelete->True,
            PrintPrecision->16]}]}],
      SequenceForm[ "beta[", 3, ",", 6, "]=", -3.9790393202565494*^-14],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("betaexact["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]6
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "betaexact[", 3, ",", 6, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("abserror["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\),
         "\[InvisibleSpace]", "6", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["3.97903932025655002`*^-14",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ "abserror[", 3, ",", 6, "]=", 3.9790393202565494*^-14],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("beta["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "7", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["2.33870066170176205`*^-13",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "beta[", 3, ",", 7, "]=", 2.3387006617017622*^-13],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("betaexact["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]7
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "betaexact[", 3, ",", 7, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("abserror["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\),
         "\[InvisibleSpace]", "7", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["2.33870066170176205`*^-13",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ "abserror[", 3, ",", 7, "]=", 2.3387006617017622*^-13],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("beta["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "8", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        RowBox[{"-", 
          StyleBox["7.14602979964596851`*^-13",
            StyleBoxAutoDelete->True,
            PrintPrecision->16]}]}],
      SequenceForm[ "beta[", 3, ",", 8, "]=", -7.1460297996459688*^-13],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("betaexact["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]8
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "betaexact[", 3, ",", 8, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("abserror["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\),
         "\[InvisibleSpace]", "8", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["7.14602979964596851`*^-13",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ "abserror[", 3, ",", 8, "]=", 7.1460297996459688*^-13],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("beta["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "9", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        RowBox[{"-", 
          StyleBox["2.96235417148747792`*^-12",
            StyleBoxAutoDelete->True,
            PrintPrecision->16]}]}],
      SequenceForm[ "beta[", 3, ",", 9, "]=", -2.9623541714874779*^-12],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("betaexact["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]9
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "betaexact[", 3, ",", 9, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("abserror["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\),
         "\[InvisibleSpace]", "9", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["2.96235417148747792`*^-12",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ "abserror[", 3, ",", 9, "]=", 2.9623541714874779*^-12],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("beta["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "10", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["1.68663626979976637`*^-11",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "beta[", 3, ",", 10, "]=", 1.6866362697997664*^-11],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("betaexact["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]10
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "betaexact[", 3, ",", 10, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("abserror["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\),
         "\[InvisibleSpace]", "10", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["1.68663626979976637`*^-11",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ "abserror[", 3, ",", 10, "]=", 1.6866362697997664*^-11],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("beta["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "11", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        RowBox[{"-", 
          StyleBox["3.41787321487715223`*^-11",
            StyleBoxAutoDelete->True,
            PrintPrecision->16]}]}],
      SequenceForm[ "beta[", 3, ",", 11, "]=", -3.4178732148771525*^-11],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("betaexact["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]11
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "betaexact[", 3, ",", 11, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("abserror["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\),
         "\[InvisibleSpace]", "11", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["3.41787321487715223`*^-11",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ "abserror[", 3, ",", 11, "]=", 3.4178732148771525*^-11],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("beta["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "12", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        RowBox[{"-", 
          StyleBox["6.72890639390353406`*^-11",
            StyleBoxAutoDelete->True,
            PrintPrecision->16]}]}],
      SequenceForm[ "beta[", 3, ",", 12, "]=", -6.7289063939035338*^-11],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("betaexact["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]12
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "betaexact[", 3, ",", 12, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("abserror["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\),
         "\[InvisibleSpace]", "12", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["6.72890639390353406`*^-11",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ "abserror[", 3, ",", 12, "]=", 6.7289063939035338*^-11],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("beta["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "13", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["6.47081560279481671`*^-10",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "beta[", 3, ",", 13, "]=", 6.4708156027948171*^-10],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("betaexact["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]13
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "betaexact[", 3, ",", 13, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("abserror["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\),
         "\[InvisibleSpace]", "13", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["6.47081560279481671`*^-10",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ "abserror[", 3, ",", 13, "]=", 6.4708156027948171*^-10],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("beta["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "14", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        RowBox[{"-", 
          StyleBox["2.64388749039677595`*^-9",
            StyleBoxAutoDelete->True,
            PrintPrecision->16]}]}],
      SequenceForm[ "beta[", 3, ",", 14, "]=", -2.6438874903967756*^-09],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("betaexact["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]14
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "betaexact[", 3, ",", 14, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("abserror["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\),
         "\[InvisibleSpace]", "14", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["2.64388749039677595`*^-9",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ "abserror[", 3, ",", 14, "]=", 2.6438874903967756*^-09],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("beta["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "15", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["9.35631583207904782`*^-9",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "beta[", 3, ",", 15, "]=", 9.3563158320790461*^-09],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("betaexact["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]15
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "betaexact[", 3, ",", 15, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("abserror["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\),
         "\[InvisibleSpace]", "15", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["9.35631583207904782`*^-9",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ "abserror[", 3, ",", 15, "]=", 9.3563158320790461*^-09],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("beta["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "16", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        RowBox[{"-", 
          StyleBox["1.28768036495876781`*^-8",
            StyleBoxAutoDelete->True,
            PrintPrecision->16]}]}],
      SequenceForm[ "beta[", 3, ",", 16, "]=", -1.287680364958768*^-08],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("betaexact["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]16
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "betaexact[", 3, ",", 16, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("abserror["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\),
         "\[InvisibleSpace]", "16", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["1.28768036495876781`*^-8",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ "abserror[", 3, ",", 16, "]=", 1.287680364958768*^-08],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("beta["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "17", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        RowBox[{"-", 
          StyleBox["2.20776068527888469`*^-8",
            StyleBoxAutoDelete->True,
            PrintPrecision->16]}]}],
      SequenceForm[ "beta[", 3, ",", 17, "]=", -2.2077606852788845*^-08],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("betaexact["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]17
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "betaexact[", 3, ",", 17, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("abserror["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\),
         "\[InvisibleSpace]", "17", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["2.20776068527888469`*^-8",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ "abserror[", 3, ",", 17, "]=", 2.2077606852788845*^-08],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("beta["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "18", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["1.16158493905704984`*^-7",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "beta[", 3, ",", 18, "]=", 1.1615849390570499*^-07],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("betaexact["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]18
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "betaexact[", 3, ",", 18, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("abserror["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\),
         "\[InvisibleSpace]", "18", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["1.16158493905704984`*^-7",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ "abserror[", 3, ",", 18, "]=", 1.1615849390570499*^-07],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("beta["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "19", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        RowBox[{"-", 
          StyleBox["5.14168007223342637`*^-7",
            StyleBoxAutoDelete->True,
            PrintPrecision->16]}]}],
      SequenceForm[ "beta[", 3, ",", 19, "]=", -5.1416800722334266*^-07],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("betaexact["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]19
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "betaexact[", 3, ",", 19, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("abserror["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\),
         "\[InvisibleSpace]", "19", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["5.14168007223342637`*^-7",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ "abserror[", 3, ",", 19, "]=", 5.1416800722334266*^-07],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("beta["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "20", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["1.67297789784815353`*^-6",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "beta[", 3, ",", 20, "]=", 1.6729778978481537*^-06],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("betaexact["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]20
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "betaexact[", 3, ",", 20, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("abserror["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\),
         "\[InvisibleSpace]", "20", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["1.67297789784815353`*^-6",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ "abserror[", 3, ",", 20, "]=", 1.6729778978481537*^-06],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("beta["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "21", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        RowBox[{"-", 
          StyleBox["1.95218932165150391`*^-6",
            StyleBoxAutoDelete->True,
            PrintPrecision->16]}]}],
      SequenceForm[ "beta[", 3, ",", 21, "]=", -1.9521893216515037*^-06],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("betaexact["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]21
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "betaexact[", 3, ",", 21, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("abserror["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\),
         "\[InvisibleSpace]", "21", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["1.95218932165150391`*^-6",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ "abserror[", 3, ",", 21, "]=", 1.9521893216515037*^-06],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("beta["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "22", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["3.77514856396337483`*^-6",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "beta[", 3, ",", 22, "]=", 3.7751485639633748*^-06],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("betaexact["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]22
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "betaexact[", 3, ",", 22, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("abserror["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\),
         "\[InvisibleSpace]", "22", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["3.77514856396337483`*^-6",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ "abserror[", 3, ",", 22, "]=", 3.7751485639633748*^-06],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("beta["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "23", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        RowBox[{"-", 
          StyleBox["0.0000437952074223462073`",
            StyleBoxAutoDelete->True,
            PrintPrecision->16]}]}],
      SequenceForm[ "beta[", 3, ",", 23, "]=", -4.3795207422346209*^-05],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("betaexact["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]23
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "betaexact[", 3, ",", 23, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("abserror["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\),
         "\[InvisibleSpace]", "23", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["0.0000437952074223462073`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ "abserror[", 3, ",", 23, "]=", 4.3795207422346209*^-05],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("beta["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "24", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["0.000178089327305047007`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "beta[", 3, ",", 24, "]=", 0.00017808932730504701],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("betaexact["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]24
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "betaexact[", 3, ",", 24, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("abserror["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\),
         "\[InvisibleSpace]", "24", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["0.000178089327305047007`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ "abserror[", 3, ",", 24, "]=", 0.00017808932730504701],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("beta["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "25", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        RowBox[{"-", 
          StyleBox["0.000552174524163029278`",
            StyleBoxAutoDelete->True,
            PrintPrecision->16]}]}],
      SequenceForm[ "beta[", 3, ",", 25, "]=", -0.00055217452416302917],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("betaexact["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]25
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "betaexact[", 3, ",", 25, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("abserror["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\),
         "\[InvisibleSpace]", "25", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["0.000552174524163029278`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ "abserror[", 3, ",", 25, "]=", 0.00055217452416302917],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("beta["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "26", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["0.00213727954758395943`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "beta[", 3, ",", 26, "]=", 0.0021372795475839597],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("betaexact["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]26
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "betaexact[", 3, ",", 26, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("abserror["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\),
         "\[InvisibleSpace]", "26", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["0.00213727954758395943`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ "abserror[", 3, ",", 26, "]=", 0.0021372795475839597],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("beta["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "27", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        RowBox[{"-", 
          StyleBox["0.00634425181924065828`",
            StyleBoxAutoDelete->True,
            PrintPrecision->16]}]}],
      SequenceForm[ "beta[", 3, ",", 27, "]=", -0.0063442518192406584],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("betaexact["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]27
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "betaexact[", 3, ",", 27, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("abserror["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\),
         "\[InvisibleSpace]", "27", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["0.00634425181924065828`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ "abserror[", 3, ",", 27, "]=", 0.0063442518192406584],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("beta["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "28", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["0.0103160428830676798`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "beta[", 3, ",", 28, "]=", 0.010316042883067681],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("betaexact["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]28
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "betaexact[", 3, ",", 28, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("abserror["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\),
         "\[InvisibleSpace]", "28", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["0.0103160428830676798`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ "abserror[", 3, ",", 28, "]=", 0.010316042883067681],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("beta["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "29", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["0.012909126983572019`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "beta[", 3, ",", 29, "]=", 0.012909126983572021],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("betaexact["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]29
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "betaexact[", 3, ",", 29, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("abserror["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\),
         "\[InvisibleSpace]", "29", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["0.012909126983572019`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ "abserror[", 3, ",", 29, "]=", 0.012909126983572021],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("beta["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "30", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        RowBox[{"-", 
          StyleBox["0.225711990242994575`",
            StyleBoxAutoDelete->True,
            PrintPrecision->16]}]}],
      SequenceForm[ "beta[", 3, ",", 30, "]=", -0.22571199024299457],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("betaexact["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]30
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "betaexact[", 3, ",", 30, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("abserror["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\),
         "\[InvisibleSpace]", "30", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["0.225711990242994575`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ "abserror[", 3, ",", 30, "]=", 0.22571199024299457],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("beta["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "31", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["1.15811586940987165`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "beta[", 3, ",", 31, "]=", 1.1581158694098717],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("betaexact["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]31
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "betaexact[", 3, ",", 31, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("abserror["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\),
         "\[InvisibleSpace]", "31", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["1.15811586940987165`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ "abserror[", 3, ",", 31, "]=", 1.1581158694098717],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("beta["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "32", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        RowBox[{"-", 
          StyleBox["4.82961973096950103`",
            StyleBoxAutoDelete->True,
            PrintPrecision->16]}]}],
      SequenceForm[ "beta[", 3, ",", 32, "]=", -4.829619730969501],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("betaexact["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]32
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "betaexact[", 3, ",", 32, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("abserror["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\),
         "\[InvisibleSpace]", "32", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["4.82961973096950103`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ "abserror[", 3, ",", 32, "]=", 4.829619730969501],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("beta["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "33", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["8.66218615812201342`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "beta[", 3, ",", 33, "]=", 8.6621861581220134],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("betaexact["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]33
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "betaexact[", 3, ",", 33, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("abserror["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\),
         "\[InvisibleSpace]", "33", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["8.66218615812201342`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ "abserror[", 3, ",", 33, "]=", 8.6621861581220134],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("beta["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "34", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["12.1922647936117778`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "beta[", 3, ",", 34, "]=", 12.192264793611777],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("betaexact["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]34
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "betaexact[", 3, ",", 34, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("abserror["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\),
         "\[InvisibleSpace]", "34", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["12.1922647936117778`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ "abserror[", 3, ",", 34, "]=", 12.192264793611777],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    \({23.7666666666666515`\ Second, Null}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(MemoryInUse[]\)], "Input"],

Cell[BoxData[
    \(1475392\)], "Output"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Computing the d-orthogonal polynomials", "Subsection"],

Cell[BoxData[
    \(\( (*\ set\ the\ values\ of\ d\ and\ nmax\ *) \nd = 3; \ nmax = \ 15\ ; 
    \ \ \  (*\ for\ example\ *) \)\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(MemoryInUse[]\)], "Input"],

Cell[BoxData[
    \(1477176\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Timing[printdorthpoly[d,nmax,x,$MachinePrecision]]", "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("dorthpoly["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "x", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["1.`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "dorthpoly[", 3, ",", 0, ",", x, "]=", 1.0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("dorthpoly["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]x
        \[InvisibleSpace]"]="\[InvisibleSpace]x\),
      SequenceForm[ "dorthpoly[", 3, ",", 1, ",", x, "]=", x],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("dorthpoly["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "x", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        RowBox[{
          RowBox[{"-", 
            StyleBox["0.666666666666666607`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16]}], "+", \(x\^2\)}]}],
      SequenceForm[ "dorthpoly[", 3, ",", 2, ",", x, "]=", 
        Plus[ -0.66666666666666663, 
          Power[ x, 2]]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("dorthpoly["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "x", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        RowBox[{
          RowBox[{"-", 
            StyleBox["0.5`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16]}], "-", 
          RowBox[{
            StyleBox["2.`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", "x"}], "+", \(x\^3\)}]}],
      SequenceForm[ "dorthpoly[", 3, ",", 3, ",", x, "]=", 
        Plus[ -0.5, 
          Times[ -2.0, x], 
          Power[ x, 3]]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("dorthpoly["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "4", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "x", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        RowBox[{
          RowBox[{
            StyleBox["1.08333333333333348`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], "\[InvisibleSpace]"}], "-", 
          RowBox[{
            StyleBox["2.`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", "x"}], "-", 
          RowBox[{
            StyleBox["4.`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^2\)}], "+", 
          RowBox[{
            StyleBox["0.`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^3\)}], "+", \(x\^4\)}]}],
      SequenceForm[ "dorthpoly[", 3, ",", 4, ",", x, "]=", 
        Plus[ 1.0833333333333335, 
          Times[ -2.0, x], 
          Times[ -4.0, 
            Power[ x, 2]], 
          Times[ 0.0, 
            Power[ x, 3]], 
          Power[ x, 4]]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("dorthpoly["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "x", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        RowBox[{
          RowBox[{
            StyleBox["3.33333333333334591`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], "\[InvisibleSpace]"}], "+", 
          RowBox[{
            StyleBox["5.41666666666666074`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", "x"}], "-", 
          RowBox[{
            StyleBox["5.00000000000003552`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^2\)}], "-", 
          RowBox[{
            StyleBox["6.66666666666667317`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^3\)}], "+", 
          RowBox[{
            StyleBox["8.88178419700125232`*^-15",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^4\)}], "+", \(x\^5\)}]}],
      SequenceForm[ "dorthpoly[", 3, ",", 5, ",", x, "]=", 
        Plus[ 3.3333333333333459, 
          Times[ 5.4166666666666607, x], 
          Times[ -5.0000000000000355, 
            Power[ x, 2]], 
          Times[ -6.6666666666666732, 
            Power[ x, 3]], 
          Times[ 8.8817841970012523*^-15, 
            Power[ x, 4]], 
          Power[ x, 5]]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("dorthpoly["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "6", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "x", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        RowBox[{
          RowBox[{
            StyleBox["0.555555555555550029`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], "\[InvisibleSpace]"}], "+", 
          RowBox[{
            StyleBox["19.9999999999999822`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", "x"}], "+", 
          RowBox[{
            StyleBox["16.2499999999999955`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^2\)}], "-", 
          RowBox[{
            StyleBox["9.99999999999998578`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^3\)}], "-", 
          RowBox[{
            StyleBox["9.99999999999999644`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^4\)}], "-", 
          RowBox[{
            StyleBox["2.48689957516028981`*^-15",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^5\)}], "+", \(x\^6\)}]}],
      SequenceForm[ "dorthpoly[", 3, ",", 6, ",", x, "]=", 
        Plus[ 0.55555555555555003, 
          Times[ 19.999999999999982, x], 
          Times[ 16.249999999999996, 
            Power[ x, 2]], 
          Times[ -9.9999999999999858, 
            Power[ x, 3]], 
          Times[ -9.9999999999999964, 
            Power[ x, 4]], 
          Times[ -2.4868995751602898*^-15, 
            Power[ x, 5]], 
          Power[ x, 6]]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("dorthpoly["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "7", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "x", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        RowBox[{
          RowBox[{"-", 
            StyleBox["18.958333333333428`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16]}], "+", 
          RowBox[{
            StyleBox["3.88888888888939554`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", "x"}], "+", 
          RowBox[{
            StyleBox["70.0000000000007371`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^2\)}], "+", 
          RowBox[{
            StyleBox["37.9166666666665452`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^3\)}], "-", 
          RowBox[{
            StyleBox["17.5000000000003597`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^4\)}], "-", 
          RowBox[{
            StyleBox["14.0000000000000373`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^5\)}], "+", 
          RowBox[{
            StyleBox["3.73034936274051975`*^-14",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^6\)}], "+", \(x\^7\)}]}],
      SequenceForm[ "dorthpoly[", 3, ",", 7, ",", x, "]=", 
        Plus[ -18.958333333333428, 
          Times[ 3.8888888888893955, x], 
          Times[ 70.000000000000739, 
            Power[ x, 2]], 
          Times[ 37.916666666666544, 
            Power[ x, 3]], 
          Times[ -17.500000000000359, 
            Power[ x, 4]], 
          Times[ -14.000000000000037, 
            Power[ x, 5]], 
          Times[ 3.7303493627405203*^-14, 
            Power[ x, 6]], 
          Power[ x, 7]]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("dorthpoly["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "8", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "x", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        RowBox[{
          RowBox[{"-", 
            StyleBox["47.0717592592554012`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16]}], "-", 
          RowBox[{
            StyleBox["151.666666666665577`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", "x"}], "+", 
          RowBox[{
            StyleBox["15.555555555543008`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^2\)}], "+", 
          RowBox[{
            StyleBox["186.666666666658116`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^3\)}], "+", 
          RowBox[{
            StyleBox["75.8333333333359593`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^4\)}], "-", 
          RowBox[{
            StyleBox["27.9999999999971649`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^5\)}], "-", 
          RowBox[{
            StyleBox["18.6666666666666003`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^6\)}], "-", 
          RowBox[{
            StyleBox["1.96566572542770998`*^-13",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^7\)}], "+", \(x\^8\)}]}],
      SequenceForm[ "dorthpoly[", 3, ",", 8, ",", x, "]=", 
        Plus[ -47.071759259255401, 
          Times[ -151.66666666666558, x], 
          Times[ 15.555555555543009, 
            Power[ x, 2]], 
          Times[ 186.66666666665813, 
            Power[ x, 3]], 
          Times[ 75.833333333335958, 
            Power[ x, 4]], 
          Times[ -27.999999999997165, 
            Power[ x, 5]], 
          Times[ -18.6666666666666, 
            Power[ x, 6]], 
          Times[ -1.9656657254277101*^-13, 
            Power[ x, 7]], 
          Power[ x, 8]]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("dorthpoly["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "9", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "x", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        RowBox[{
          RowBox[{
            StyleBox["46.6666666666499541`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], "\[InvisibleSpace]"}], "-", 
          RowBox[{
            StyleBox["423.645833333415122`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", "x"}], "-", 
          RowBox[{
            StyleBox["682.500000000020712`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^2\)}], "+", 
          RowBox[{
            StyleBox["46.6666666667507268`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^3\)}], "+", 
          RowBox[{
            StyleBox["420.000000000048068`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^4\)}], "+", 
          RowBox[{
            StyleBox["136.49999999999034`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^5\)}], "-", 
          RowBox[{
            StyleBox["42.0000000000102158`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^6\)}], "-", 
          RowBox[{
            StyleBox["24.0000000000002478`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^7\)}], "+", 
          RowBox[{
            StyleBox["5.18036407421825906`*^-13",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^8\)}], "+", \(x\^9\)}]}],
      SequenceForm[ "dorthpoly[", 3, ",", 9, ",", x, "]=", 
        Plus[ 46.666666666649952, 
          Times[ -423.64583333341517, x], 
          Times[ -682.5000000000208, 
            Power[ x, 2]], 
          Times[ 46.666666666750729, 
            Power[ x, 3]], 
          Times[ 420.00000000004809, 
            Power[ x, 4]], 
          Times[ 136.49999999999034, 
            Power[ x, 5]], 
          Times[ -42.000000000010218, 
            Power[ x, 6]], 
          Times[ -24.000000000000249, 
            Power[ x, 7]], 
          Times[ 5.1803640742182587*^-13, 
            Power[ x, 8]], 
          Power[ x, 9]]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("dorthpoly["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "10", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "x", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        RowBox[{
          RowBox[{
            StyleBox["612.013888889195545`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], "\[InvisibleSpace]"}], "+", 
          RowBox[{
            StyleBox["466.666666665949314`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", "x"}], "-", 
          RowBox[{
            StyleBox["2118.2291666687969`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^2\)}], "-", 
          RowBox[{
            StyleBox["2275.00000000058566`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^3\)}], "+", 
          RowBox[{
            StyleBox["116.666666667664942`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^4\)}], "+", 
          RowBox[{
            StyleBox["840.000000000546265`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^5\)}], "+", 
          RowBox[{
            StyleBox["227.499999999949187`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^6\)}], "-", 
          RowBox[{
            StyleBox["60.000000000077831`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^7\)}], "-", 
          RowBox[{
            StyleBox["30.000000000005329`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^8\)}], "+", 
          RowBox[{
            StyleBox["3.48039057890930347`*^-12",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^9\)}], "+", \(x\^10\)}]}],
      SequenceForm[ "dorthpoly[", 3, ",", 10, ",", x, "]=", 
        Plus[ 612.01388888919553, 
          Times[ 466.66666666594932, x], 
          Times[ -2118.229166668797, 
            Power[ x, 2]], 
          Times[ -2275.0000000005857, 
            Power[ x, 3]], 
          Times[ 116.66666666766494, 
            Power[ x, 4]], 
          Times[ 840.00000000054627, 
            Power[ x, 5]], 
          Times[ 227.49999999994918, 
            Power[ x, 6]], 
          Times[ -60.000000000077833, 
            Power[ x, 7]], 
          Times[ -30.000000000005329, 
            Power[ x, 8]], 
          Times[ 3.4803905789093038*^-12, 
            Power[ x, 9]], 
          Power[ x, 10]]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("dorthpoly["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "11", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "x", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        RowBox[{
          RowBox[{
            StyleBox["1316.75347221536886`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], "\[InvisibleSpace]"}], "+", 
          RowBox[{
            StyleBox["6732.1527777665775`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", "x"}], "+", 
          RowBox[{
            StyleBox["2566.66666668372611`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^2\)}], "-", 
          RowBox[{
            StyleBox["7766.84027774894314`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^3\)}], "-", 
          RowBox[{
            StyleBox["6256.24999999566089`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^4\)}], "+", 
          RowBox[{
            StyleBox["256.666666658033415`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^5\)}], "+", 
          RowBox[{
            StyleBox["1539.99999999650611`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^6\)}], "+", 
          RowBox[{
            StyleBox["357.50000000040174`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^7\)}], "-", 
          RowBox[{
            StyleBox["82.4999999996100363`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^8\)}], "-", 
          RowBox[{
            StyleBox["36.6666666666501583`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^9\)}], "-", 
          RowBox[{
            StyleBox["1.33859721190883584`*^-11",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^10\)}], "+", \(x\^11\)}]}],
      SequenceForm[ "dorthpoly[", 3, ",", 11, ",", x, "]=", 
        Plus[ 1316.7534722153689, 
          Times[ 6732.1527777665779, x], 
          Times[ 2566.6666666837264, 
            Power[ x, 2]], 
          Times[ -7766.8402777489437, 
            Power[ x, 3]], 
          Times[ -6256.2499999956608, 
            Power[ x, 4]], 
          Times[ 256.66666665803342, 
            Power[ x, 5]], 
          Times[ 1539.9999999965062, 
            Power[ x, 6]], 
          Times[ 357.50000000040171, 
            Power[ x, 7]], 
          Times[ -82.49999999961004, 
            Power[ x, 8]], 
          Times[ -36.666666666650158, 
            Power[ x, 9]], 
          Times[ -1.3385972119088359*^-11, 
            Power[ x, 10]], 
          Power[ x, 11]]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("dorthpoly["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "12", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "x", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        RowBox[{
          RowBox[{"-", 
            StyleBox["3829.72511571212947`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16]}], "+", 
          RowBox[{
            StyleBox["15801.0416668261992`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", "x"}], "+", 
          RowBox[{
            StyleBox["40392.9166667364736`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^2\)}], "+", 
          RowBox[{
            StyleBox["10266.6666664889882`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^3\)}], "-", 
          RowBox[{
            StyleBox["23300.520833482059`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^4\)}], "-", 
          RowBox[{
            StyleBox["15014.9999999951582`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^5\)}], "+", 
          RowBox[{
            StyleBox["513.333333369295896`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^6\)}], "+", 
          RowBox[{
            StyleBox["2640.00000000827306`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^7\)}], "+", 
          RowBox[{
            StyleBox["536.24999999800611`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^8\)}], "-", 
          RowBox[{
            StyleBox["110.000000000839182`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^9\)}], "-", 
          RowBox[{
            StyleBox["43.9999999999860413`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^10\)}], "+", 
          RowBox[{
            StyleBox["2.07927600296831682`*^-11",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^11\)}], "+", \(x\^12\)}]}],
      SequenceForm[ "dorthpoly[", 3, ",", 12, ",", x, "]=", 
        Plus[ -3829.7251157121291, 
          Times[ 15801.041666826199, x], 
          Times[ 40392.916666736477, 
            Power[ x, 2]], 
          Times[ 10266.666666488989, 
            Power[ x, 3]], 
          Times[ -23300.520833482056, 
            Power[ x, 4]], 
          Times[ -15014.999999995156, 
            Power[ x, 5]], 
          Times[ 513.33333336929593, 
            Power[ x, 6]], 
          Times[ 2640.0000000082732, 
            Power[ x, 7]], 
          Times[ 536.24999999800616, 
            Power[ x, 8]], 
          Times[ -110.00000000083919, 
            Power[ x, 9]], 
          Times[ -43.999999999986038, 
            Power[ x, 10]], 
          Times[ 2.0792760029683167*^-11, 
            Power[ x, 11]], 
          Power[ x, 12]]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("dorthpoly["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "13", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "x", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        RowBox[{
          RowBox[{"-", 
            StyleBox["33297.1527782183951`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16]}], "-", 
          RowBox[{
            StyleBox["49786.4265048609144`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", "x"}], "+", 
          RowBox[{
            StyleBox["102706.770835289229`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^2\)}], "+", 
          RowBox[{
            StyleBox["175035.972224266149`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^3\)}], "+", 
          RowBox[{
            StyleBox["33366.6666664055933`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^4\)}], "-", 
          RowBox[{
            StyleBox["60581.3541676702005`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^5\)}], "-", 
          RowBox[{
            StyleBox["32532.5000002835418`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^6\)}], "+", 
          RowBox[{
            StyleBox["953.333333432884089`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^7\)}], "+", 
          RowBox[{
            StyleBox["4290.00000005533532`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^8\)}], "+", 
          RowBox[{
            StyleBox["774.583333334594481`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^9\)}], "-", 
          RowBox[{
            StyleBox["143.000000003231946`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^10\)}], "-", 
          RowBox[{
            StyleBox["52.0000000003227302`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^11\)}], "+", 
          RowBox[{
            StyleBox["8.80818239687184956`*^-11",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^12\)}], "+", \(x\^13\)}]}],
      SequenceForm[ "dorthpoly[", 3, ",", 13, ",", x, "]=", 
        Plus[ -33297.152778218398, 
          Times[ -49786.426504860909, x], 
          Times[ 102706.77083528924, 
            Power[ x, 2]], 
          Times[ 175035.97222426615, 
            Power[ x, 3]], 
          Times[ 33366.666666405588, 
            Power[ x, 4]], 
          Times[ -60581.354167670208, 
            Power[ x, 5]], 
          Times[ -32532.50000028354, 
            Power[ x, 6]], 
          Times[ 953.33333343288405, 
            Power[ x, 7]], 
          Times[ 4290.0000000553355, 
            Power[ x, 8]], 
          Times[ 774.5833333345945, 
            Power[ x, 9]], 
          Times[ -143.00000000323195, 
            Power[ x, 10]], 
          Times[ -52.000000000322729, 
            Power[ x, 11]], 
          Times[ 8.8081823968718499*^-11, 
            Power[ x, 12]], 
          Power[ x, 13]]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("dorthpoly["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "14", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "x", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        RowBox[{
          RowBox[{"-", 
            StyleBox["61921.4274569193712`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16]}], "-", 
          RowBox[{
            StyleBox["466160.138852688632`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", "x"}], "-", 
          RowBox[{
            StyleBox["348504.985546291035`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^2\)}], "+", 
          RowBox[{
            StyleBox["479298.263815167846`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^3\)}], "+", 
          RowBox[{
            StyleBox["612625.902741288896`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^4\)}], "+", 
          RowBox[{
            StyleBox["93426.6666821708113`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^5\)}], "-", 
          RowBox[{
            StyleBox["141356.493039267583`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^6\)}], "-", 
          RowBox[{
            StyleBox["65064.9999979302418`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^7\)}], "+", 
          RowBox[{
            StyleBox["1668.33333173082039`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^8\)}], "+", 
          RowBox[{
            StyleBox["6673.33333283003593`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^9\)}], "+", 
          RowBox[{
            StyleBox["1084.41666669168657`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^10\)}], "-", 
          RowBox[{
            StyleBox["181.99999997283669`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^11\)}], "-", 
          RowBox[{
            StyleBox["60.6666666653851915`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^12\)}], "-", 
          RowBox[{
            StyleBox["5.58999736310763317`*^-10",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^13\)}], "+", \(x\^14\)}]}],
      SequenceForm[ "dorthpoly[", 3, ",", 14, ",", x, "]=", 
        Plus[ -61921.42745691938, 
          Times[ -466160.13885268866, x], 
          Times[ -348504.98554629105, 
            Power[ x, 2]], 
          Times[ 479298.26381516783, 
            Power[ x, 3]], 
          Times[ 612625.90274128888, 
            Power[ x, 4]], 
          Times[ 93426.666682170791, 
            Power[ x, 5]], 
          Times[ -141356.49303926757, 
            Power[ x, 6]], 
          Times[ -65064.999997930237, 
            Power[ x, 7]], 
          Times[ 1668.3333317308206, 
            Power[ x, 8]], 
          Times[ 6673.3333328300369, 
            Power[ x, 9]], 
          Times[ 1084.4166666916865, 
            Power[ x, 10]], 
          Times[ -181.99999997283669, 
            Power[ x, 11]], 
          Times[ -60.666666665385193, 
            Power[ x, 12]], 
          Times[ -5.5899973631076321*^-10, 
            Power[ x, 13]], 
          Power[ x, 14]]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("dorthpoly["\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "15", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "x", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        RowBox[{
          RowBox[{
            StyleBox["365201.35267848568`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], "\[InvisibleSpace]"}], "-", 
          RowBox[{
            StyleBox["928821.412825848469`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", "x"}], "-", 
          RowBox[{
            StyleBox["3.49620104259558539`*^6",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^2\)}], "-", 
          RowBox[{
            StyleBox["1.74252492714936302`*^6",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^3\)}], "+", 
          RowBox[{
            StyleBox["1.79736849070672981`*^6",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^4\)}], "+", 
          RowBox[{
            StyleBox["1.83787770866939901`*^6",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^5\)}], "+", 
          RowBox[{
            StyleBox["233566.666468669259`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^6\)}], "-", 
          RowBox[{
            StyleBox["302906.770965470872`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^7\)}], "-", 
          RowBox[{
            StyleBox["121996.875007857119`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^8\)}], "+", 
          RowBox[{
            StyleBox["2780.55556692455052`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^9\)}], "+", 
          RowBox[{
            StyleBox["10010.0000025802615`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^10\)}], "+", 
          RowBox[{
            StyleBox["1478.74999977483128`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^11\)}], "-", 
          RowBox[{
            StyleBox["227.500000124711121`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^12\)}], "-", 
          RowBox[{
            StyleBox["70.0000000028922908`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^13\)}], "+", 
          RowBox[{
            StyleBox["2.08488775408601245`*^-9",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^14\)}], "+", \(x\^15\)}]}],
      SequenceForm[ "dorthpoly[", 3, ",", 15, ",", x, "]=", 
        Plus[ 365201.35267848568, 
          Times[ -928821.41282584856, x], 
          Times[ -3496201.0425955853, 
            Power[ x, 2]], 
          Times[ -1742524.9271493629, 
            Power[ x, 3]], 
          Times[ 1797368.4907067299, 
            Power[ x, 4]], 
          Times[ 1837877.7086693991, 
            Power[ x, 5]], 
          Times[ 233566.66646866925, 
            Power[ x, 6]], 
          Times[ -302906.77096547087, 
            Power[ x, 7]], 
          Times[ -121996.87500785712, 
            Power[ x, 8]], 
          Times[ 2780.5555669245505, 
            Power[ x, 9]], 
          Times[ 10010.000002580262, 
            Power[ x, 10]], 
          Times[ 1478.7499997748314, 
            Power[ x, 11]], 
          Times[ -227.50000012471114, 
            Power[ x, 12]], 
          Times[ -70.000000002892293, 
            Power[ x, 13]], 
          Times[ 2.0848877540860124*^-09, 
            Power[ x, 14]], 
          Power[ x, 15]]],
      Editable->False]], "Print"],

Cell[BoxData[
    \({2.65000000000000568`\ Second, Null}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(MemoryInUse[]\)], "Input"],

Cell[BoxData[
    \(1489272\)], "Output"]
}, Open  ]]
}, Closed]]
}, Closed]]
},
FrontEndVersion->"Macintosh 3.0",
ScreenRectangle->{{0, 832}, {0, 604}},
WindowSize->{590, 412},
WindowMargins->{{Automatic, 87}, {Automatic, 66}},
MacintoshSystemPageSetup->"\<\
00<0001804P000000`d26_oQon@3:`8g0dL5N`?P0080001804P000000]P2:001
0000I00000400`<30?l00BL?00400@0000000000000006P801T1T00000000000
00000000004000000000000000000000\>"
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{
Cell[1709, 49, 1283, 21, 628, "Subsection"],

Cell[CellGroupData[{
Cell[3017, 74, 154, 4, 68, "Section"],

Cell[CellGroupData[{
Cell[3196, 82, 106, 3, 44, "Subsection"],
Cell[3305, 87, 56, 1, 27, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[3398, 93, 133, 4, 44, "Subsection"],
Cell[3534, 99, 71, 1, 27, "Input"],
Cell[3608, 102, 142, 2, 43, "Input"],

Cell[CellGroupData[{
Cell[3775, 108, 249, 5, 59, "Input"],
Cell[4027, 115, 298, 6, 22, "Print"],
Cell[4328, 123, 298, 6, 22, "Print"],
Cell[4629, 131, 324, 7, 38, "Print"],
Cell[4956, 140, 324, 7, 38, "Print"],
Cell[5283, 149, 328, 7, 38, "Print"],
Cell[5614, 158, 326, 7, 38, "Print"],
Cell[5943, 167, 326, 7, 38, "Print"],
Cell[6272, 176, 330, 7, 38, "Print"],
Cell[6605, 185, 336, 7, 38, "Print"],
Cell[6944, 194, 328, 7, 38, "Print"],
Cell[7275, 203, 336, 7, 38, "Print"],
Cell[7614, 212, 55, 1, 22, "Print"],
Cell[7672, 215, 298, 6, 22, "Print"],
Cell[7973, 223, 298, 6, 22, "Print"],
Cell[8274, 231, 298, 6, 22, "Print"],
Cell[8575, 239, 298, 6, 22, "Print"],
Cell[8876, 247, 298, 6, 22, "Print"],
Cell[9177, 255, 328, 7, 38, "Print"],
Cell[9508, 264, 300, 6, 22, "Print"],
Cell[9811, 272, 328, 7, 38, "Print"],
Cell[10142, 281, 328, 7, 38, "Print"],
Cell[10473, 290, 334, 7, 38, "Print"],
Cell[10810, 299, 332, 7, 38, "Print"],
Cell[11145, 308, 55, 1, 22, "Print"],
Cell[11203, 311, 298, 6, 22, "Print"],
Cell[11504, 319, 298, 6, 22, "Print"],
Cell[11805, 327, 298, 6, 22, "Print"],
Cell[12106, 335, 298, 6, 22, "Print"],
Cell[12407, 343, 298, 6, 22, "Print"],
Cell[12708, 351, 298, 6, 22, "Print"],
Cell[13009, 359, 326, 7, 38, "Print"],
Cell[13338, 368, 300, 6, 22, "Print"],
Cell[13641, 376, 330, 7, 38, "Print"],
Cell[13974, 385, 330, 7, 38, "Print"],
Cell[14307, 394, 338, 7, 38, "Print"],
Cell[14648, 403, 55, 1, 22, "Print"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{
Cell[14752, 410, 54, 0, 28, "Subsection"],

Cell[CellGroupData[{
Cell[14831, 414, 142, 2, 43, "Input"],
Cell[14976, 418, 175, 3, 37, "Message"]
}, Open  ]],

Cell[CellGroupData[{
Cell[15188, 426, 46, 1, 27, "Input"],
Cell[15237, 429, 40, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[15314, 435, 117, 4, 42, "Input"],
Cell[15434, 441, 38, 1, 22, "Print"],
Cell[15475, 444, 326, 7, 38, "Print"],
Cell[15804, 453, 336, 7, 38, "Print"],
Cell[16143, 462, 37, 1, 22, "Print"],
Cell[16183, 465, 300, 6, 22, "Print"],
Cell[16486, 473, 310, 6, 22, "Print"],
Cell[16799, 481, 37, 1, 22, "Print"],
Cell[16839, 484, 326, 7, 38, "Print"],
Cell[17168, 493, 336, 7, 38, "Print"],
Cell[17507, 502, 37, 1, 22, "Print"],
Cell[17547, 505, 300, 6, 22, "Print"],
Cell[17850, 513, 310, 6, 22, "Print"],
Cell[18163, 521, 37, 1, 22, "Print"],
Cell[18203, 524, 328, 7, 38, "Print"],
Cell[18534, 533, 338, 7, 38, "Print"],
Cell[18875, 542, 37, 1, 22, "Print"],
Cell[18915, 545, 302, 6, 22, "Print"],
Cell[19220, 553, 312, 6, 22, "Print"],
Cell[19535, 561, 37, 1, 22, "Print"],
Cell[19575, 564, 302, 6, 22, "Print"],
Cell[19880, 572, 312, 6, 22, "Print"],
Cell[20195, 580, 37, 1, 22, "Print"],
Cell[20235, 583, 302, 6, 22, "Print"],
Cell[20540, 591, 312, 6, 22, "Print"],
Cell[20855, 599, 37, 1, 22, "Print"],
Cell[20895, 602, 38, 1, 22, "Print"],
Cell[20936, 605, 326, 7, 38, "Print"],
Cell[21265, 614, 336, 7, 38, "Print"],
Cell[21604, 623, 37, 1, 22, "Print"],
Cell[21644, 626, 326, 7, 38, "Print"],
Cell[21973, 635, 336, 7, 38, "Print"],
Cell[22312, 644, 37, 1, 22, "Print"],
Cell[22352, 647, 300, 6, 22, "Print"],
Cell[22655, 655, 310, 6, 22, "Print"],
Cell[22968, 663, 37, 1, 22, "Print"],
Cell[23008, 666, 300, 6, 22, "Print"],
Cell[23311, 674, 310, 6, 22, "Print"],
Cell[23624, 682, 37, 1, 22, "Print"],
Cell[23664, 685, 328, 7, 38, "Print"],
Cell[23995, 694, 338, 7, 38, "Print"],
Cell[24336, 703, 37, 1, 22, "Print"],
Cell[24376, 706, 328, 7, 38, "Print"],
Cell[24707, 715, 338, 7, 38, "Print"],
Cell[25048, 724, 37, 1, 22, "Print"],
Cell[25088, 727, 302, 6, 22, "Print"],
Cell[25393, 735, 312, 6, 22, "Print"],
Cell[25708, 743, 37, 1, 22, "Print"],
Cell[25748, 746, 302, 6, 22, "Print"],
Cell[26053, 754, 312, 6, 22, "Print"],
Cell[26368, 762, 37, 1, 22, "Print"],
Cell[26408, 765, 328, 7, 38, "Print"],
Cell[26739, 774, 338, 7, 38, "Print"],
Cell[27080, 783, 37, 1, 22, "Print"],
Cell[27120, 786, 38, 1, 22, "Print"],
Cell[27161, 789, 326, 7, 38, "Print"],
Cell[27490, 798, 336, 7, 38, "Print"],
Cell[27829, 807, 37, 1, 22, "Print"],
Cell[27869, 810, 326, 7, 38, "Print"],
Cell[28198, 819, 336, 7, 38, "Print"],
Cell[28537, 828, 37, 1, 22, "Print"],
Cell[28577, 831, 300, 6, 22, "Print"],
Cell[28880, 839, 310, 6, 22, "Print"],
Cell[29193, 847, 37, 1, 22, "Print"],
Cell[29233, 850, 326, 7, 38, "Print"],
Cell[29562, 859, 336, 7, 38, "Print"],
Cell[29901, 868, 37, 1, 22, "Print"],
Cell[29941, 871, 328, 7, 38, "Print"],
Cell[30272, 880, 338, 7, 38, "Print"],
Cell[30613, 889, 37, 1, 22, "Print"],
Cell[30653, 892, 300, 6, 22, "Print"],
Cell[30956, 900, 310, 6, 22, "Print"],
Cell[31269, 908, 37, 1, 22, "Print"],
Cell[31309, 911, 328, 7, 38, "Print"],
Cell[31640, 920, 338, 7, 38, "Print"],
Cell[31981, 929, 37, 1, 22, "Print"],
Cell[32021, 932, 328, 7, 38, "Print"],
Cell[32352, 941, 338, 7, 38, "Print"],
Cell[32693, 950, 37, 1, 22, "Print"],
Cell[32733, 953, 300, 6, 22, "Print"],
Cell[33036, 961, 310, 6, 22, "Print"],
Cell[33349, 969, 37, 1, 22, "Print"],
Cell[33389, 972, 330, 7, 38, "Print"],
Cell[33722, 981, 340, 7, 38, "Print"],
Cell[34065, 990, 37, 1, 22, "Print"],
Cell[34105, 993, 70, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[34212, 999, 46, 1, 27, "Input"],
Cell[34261, 1002, 41, 1, 26, "Output"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{
Cell[34351, 1009, 53, 0, 28, "Subsection"],
Cell[34407, 1011, 142, 2, 43, "Input"],

Cell[CellGroupData[{
Cell[34574, 1017, 46, 1, 27, "Input"],
Cell[34623, 1020, 41, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[34701, 1026, 116, 4, 42, "Input"],
Cell[34820, 1032, 243, 5, 22, "Print"],
Cell[35066, 1039, 253, 5, 22, "Print"],
Cell[35322, 1046, 37, 1, 22, "Print"],
Cell[35362, 1049, 243, 5, 22, "Print"],
Cell[35608, 1056, 253, 5, 22, "Print"],
Cell[35864, 1063, 37, 1, 22, "Print"],
Cell[35904, 1066, 243, 5, 22, "Print"],
Cell[36150, 1073, 253, 5, 22, "Print"],
Cell[36406, 1080, 37, 1, 22, "Print"],
Cell[36446, 1083, 243, 5, 22, "Print"],
Cell[36692, 1090, 253, 5, 22, "Print"],
Cell[36948, 1097, 37, 1, 22, "Print"],
Cell[36988, 1100, 243, 5, 22, "Print"],
Cell[37234, 1107, 253, 5, 22, "Print"],
Cell[37490, 1114, 37, 1, 22, "Print"],
Cell[37530, 1117, 243, 5, 22, "Print"],
Cell[37776, 1124, 253, 5, 22, "Print"],
Cell[38032, 1131, 37, 1, 22, "Print"],
Cell[38072, 1134, 243, 5, 22, "Print"],
Cell[38318, 1141, 253, 5, 22, "Print"],
Cell[38574, 1148, 37, 1, 22, "Print"],
Cell[38614, 1151, 243, 5, 22, "Print"],
Cell[38860, 1158, 253, 5, 22, "Print"],
Cell[39116, 1165, 37, 1, 22, "Print"],
Cell[39156, 1168, 243, 5, 22, "Print"],
Cell[39402, 1175, 253, 5, 22, "Print"],
Cell[39658, 1182, 37, 1, 22, "Print"],
Cell[39698, 1185, 243, 5, 22, "Print"],
Cell[39944, 1192, 253, 5, 22, "Print"],
Cell[40200, 1199, 37, 1, 22, "Print"],
Cell[40240, 1202, 55, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[40332, 1208, 46, 1, 27, "Input"],
Cell[40381, 1211, 41, 1, 26, "Output"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{
Cell[40471, 1218, 60, 0, 28, "Subsection"],
Cell[40534, 1220, 142, 2, 43, "Input"],

Cell[CellGroupData[{
Cell[40701, 1226, 46, 1, 27, "Input"],
Cell[40750, 1229, 41, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[40828, 1235, 84, 1, 27, "Input"],
Cell[40915, 1238, 308, 6, 22, "Print"],
Cell[41226, 1246, 308, 6, 22, "Print"],
Cell[41537, 1254, 396, 9, 38, "Print"],
Cell[41936, 1265, 436, 11, 38, "Print"],
Cell[42375, 1278, 496, 13, 38, "Print"],
Cell[42874, 1293, 627, 17, 40, "Print"],
Cell[43504, 1312, 652, 18, 40, "Print"],
Cell[44159, 1332, 810, 23, 40, "Print"],
Cell[44972, 1357, 950, 27, 58, "Print"],
Cell[45925, 1386, 972, 28, 58, "Print"],
Cell[46900, 1416, 1049, 30, 77, "Print"],
Cell[47952, 1448, 69, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[48058, 1454, 46, 1, 27, "Input"],
Cell[48107, 1457, 41, 1, 26, "Output"]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[48209, 1465, 187, 5, 66, "Section"],

Cell[CellGroupData[{
Cell[48421, 1474, 106, 3, 44, "Subsection"],
Cell[48530, 1479, 56, 1, 27, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[48623, 1485, 54, 0, 44, "Subsection"],
Cell[48680, 1487, 142, 2, 43, "Input"],

Cell[CellGroupData[{
Cell[48847, 1493, 46, 1, 27, "Input"],
Cell[48896, 1496, 40, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[48973, 1502, 125, 4, 42, "Input"],
Cell[49101, 1508, 38, 1, 22, "Print"],
Cell[49142, 1511, 511, 11, 22, "Print"],
Cell[49656, 1524, 490, 11, 22, "Print"],
Cell[50149, 1537, 527, 12, 22, "Print"],
Cell[50679, 1551, 37, 1, 22, "Print"],
Cell[50719, 1554, 477, 11, 22, "Print"],
Cell[51199, 1567, 487, 11, 22, "Print"],
Cell[51689, 1580, 498, 11, 22, "Print"],
Cell[52190, 1593, 37, 1, 22, "Print"],
Cell[52230, 1596, 509, 11, 22, "Print"],
Cell[52742, 1609, 488, 11, 22, "Print"],
Cell[53233, 1622, 527, 12, 22, "Print"],
Cell[53763, 1636, 37, 1, 22, "Print"],
Cell[53803, 1639, 509, 11, 22, "Print"],
Cell[54315, 1652, 487, 11, 22, "Print"],
Cell[54805, 1665, 527, 12, 22, "Print"],
Cell[55335, 1679, 37, 1, 22, "Print"],
Cell[55375, 1682, 508, 11, 22, "Print"],
Cell[55886, 1695, 490, 11, 22, "Print"],
Cell[56379, 1708, 527, 12, 22, "Print"],
Cell[56909, 1722, 37, 1, 22, "Print"],
Cell[56949, 1725, 509, 11, 22, "Print"],
Cell[57461, 1738, 505, 11, 22, "Print"],
Cell[57969, 1751, 526, 12, 22, "Print"],
Cell[58498, 1765, 37, 1, 22, "Print"],
Cell[58538, 1768, 509, 11, 22, "Print"],
Cell[59050, 1781, 505, 11, 22, "Print"],
Cell[59558, 1794, 527, 12, 22, "Print"],
Cell[60088, 1808, 37, 1, 22, "Print"],
Cell[60128, 1811, 509, 11, 22, "Print"],
Cell[60640, 1824, 489, 11, 22, "Print"],
Cell[61132, 1837, 527, 12, 22, "Print"],
Cell[61662, 1851, 37, 1, 22, "Print"],
Cell[61702, 1854, 509, 11, 22, "Print"],
Cell[62214, 1867, 492, 11, 22, "Print"],
Cell[62709, 1880, 527, 12, 22, "Print"],
Cell[63239, 1894, 37, 1, 22, "Print"],
Cell[63279, 1897, 511, 11, 22, "Print"],
Cell[63793, 1910, 491, 11, 22, "Print"],
Cell[64287, 1923, 529, 12, 22, "Print"],
Cell[64819, 1937, 37, 1, 22, "Print"],
Cell[64859, 1940, 511, 11, 22, "Print"],
Cell[65373, 1953, 507, 11, 22, "Print"],
Cell[65883, 1966, 529, 12, 22, "Print"],
Cell[66415, 1980, 37, 1, 22, "Print"],
Cell[66455, 1983, 511, 11, 22, "Print"],
Cell[66969, 1996, 507, 11, 22, "Print"],
Cell[67479, 2009, 529, 12, 22, "Print"],
Cell[68011, 2023, 37, 1, 22, "Print"],
Cell[68051, 2026, 510, 11, 22, "Print"],
Cell[68564, 2039, 509, 11, 22, "Print"],
Cell[69076, 2052, 528, 12, 22, "Print"],
Cell[69607, 2066, 37, 1, 22, "Print"],
Cell[69647, 2069, 511, 11, 22, "Print"],
Cell[70161, 2082, 508, 11, 22, "Print"],
Cell[70672, 2095, 529, 12, 22, "Print"],
Cell[71204, 2109, 37, 1, 22, "Print"],
Cell[71244, 2112, 511, 11, 22, "Print"],
Cell[71758, 2125, 493, 11, 22, "Print"],
Cell[72254, 2138, 529, 12, 22, "Print"],
Cell[72786, 2152, 37, 1, 22, "Print"],
Cell[72826, 2155, 511, 11, 22, "Print"],
Cell[73340, 2168, 508, 11, 22, "Print"],
Cell[73851, 2181, 529, 12, 22, "Print"],
Cell[74383, 2195, 37, 1, 22, "Print"],
Cell[74423, 2198, 511, 11, 22, "Print"],
Cell[74937, 2211, 509, 11, 22, "Print"],
Cell[75449, 2224, 529, 12, 22, "Print"],
Cell[75981, 2238, 37, 1, 22, "Print"],
Cell[76021, 2241, 511, 11, 22, "Print"],
Cell[76535, 2254, 493, 11, 22, "Print"],
Cell[77031, 2267, 529, 12, 22, "Print"],
Cell[77563, 2281, 37, 1, 22, "Print"],
Cell[77603, 2284, 510, 11, 22, "Print"],
Cell[78116, 2297, 508, 11, 22, "Print"],
Cell[78627, 2310, 529, 12, 22, "Print"],
Cell[79159, 2324, 37, 1, 22, "Print"],
Cell[79199, 2327, 511, 11, 22, "Print"],
Cell[79713, 2340, 493, 11, 22, "Print"],
Cell[80209, 2353, 529, 12, 22, "Print"],
Cell[80741, 2367, 37, 1, 22, "Print"],
Cell[80781, 2370, 511, 11, 22, "Print"],
Cell[81295, 2383, 509, 11, 22, "Print"],
Cell[81807, 2396, 529, 12, 22, "Print"],
Cell[82339, 2410, 37, 1, 22, "Print"],
Cell[82379, 2413, 511, 11, 22, "Print"],
Cell[82893, 2426, 508, 11, 22, "Print"],
Cell[83404, 2439, 529, 12, 22, "Print"],
Cell[83936, 2453, 37, 1, 22, "Print"],
Cell[83976, 2456, 511, 11, 22, "Print"],
Cell[84490, 2469, 493, 11, 22, "Print"],
Cell[84986, 2482, 529, 12, 22, "Print"],
Cell[85518, 2496, 37, 1, 22, "Print"],
Cell[85558, 2499, 510, 11, 22, "Print"],
Cell[86071, 2512, 493, 11, 22, "Print"],
Cell[86567, 2525, 529, 12, 22, "Print"],
Cell[87099, 2539, 37, 1, 22, "Print"],
Cell[87139, 2542, 510, 11, 22, "Print"],
Cell[87652, 2555, 496, 11, 22, "Print"],
Cell[88151, 2568, 528, 12, 22, "Print"],
Cell[88682, 2582, 37, 1, 22, "Print"],
Cell[88722, 2585, 511, 11, 22, "Print"],
Cell[89236, 2598, 508, 11, 22, "Print"],
Cell[89747, 2611, 529, 12, 22, "Print"],
Cell[90279, 2625, 37, 1, 22, "Print"],
Cell[90319, 2628, 511, 11, 22, "Print"],
Cell[90833, 2641, 508, 11, 22, "Print"],
Cell[91344, 2654, 528, 12, 22, "Print"],
Cell[91875, 2668, 37, 1, 22, "Print"],
Cell[91915, 2671, 510, 11, 22, "Print"],
Cell[92428, 2684, 509, 11, 22, "Print"],
Cell[92940, 2697, 529, 12, 22, "Print"],
Cell[93472, 2711, 37, 1, 22, "Print"],
Cell[93512, 2714, 511, 11, 22, "Print"],
Cell[94026, 2727, 510, 11, 22, "Print"],
Cell[94539, 2740, 529, 12, 22, "Print"],
Cell[95071, 2754, 37, 1, 22, "Print"],
Cell[95111, 2757, 511, 11, 22, "Print"],
Cell[95625, 2770, 509, 11, 22, "Print"],
Cell[96137, 2783, 531, 12, 22, "Print"],
Cell[96671, 2797, 37, 1, 22, "Print"],
Cell[96711, 2800, 511, 11, 22, "Print"],
Cell[97225, 2813, 508, 11, 22, "Print"],
Cell[97736, 2826, 566, 13, 22, "Print"],
Cell[98305, 2841, 37, 1, 22, "Print"],
Cell[98345, 2844, 541, 12, 22, "Print"],
Cell[98889, 2858, 509, 11, 22, "Print"],
Cell[99401, 2871, 562, 13, 22, "Print"],
Cell[99966, 2886, 37, 1, 22, "Print"],
Cell[100006, 2889, 542, 12, 22, "Print"],
Cell[100551, 2903, 510, 11, 22, "Print"],
Cell[101064, 2916, 560, 13, 22, "Print"],
Cell[101627, 2931, 37, 1, 22, "Print"],
Cell[101667, 2934, 38, 1, 22, "Print"],
Cell[101708, 2937, 478, 11, 22, "Print"],
Cell[102189, 2950, 488, 11, 22, "Print"],
Cell[102680, 2963, 498, 11, 22, "Print"],
Cell[103181, 2976, 37, 1, 22, "Print"],
Cell[103221, 2979, 478, 11, 22, "Print"],
Cell[103702, 2992, 488, 11, 22, "Print"],
Cell[104193, 3005, 498, 11, 22, "Print"],
Cell[104694, 3018, 37, 1, 22, "Print"],
Cell[104734, 3021, 477, 11, 22, "Print"],
Cell[105214, 3034, 487, 11, 22, "Print"],
Cell[105704, 3047, 498, 11, 22, "Print"],
Cell[106205, 3060, 37, 1, 22, "Print"],
Cell[106245, 3063, 509, 11, 22, "Print"],
Cell[106757, 3076, 487, 11, 22, "Print"],
Cell[107247, 3089, 527, 12, 22, "Print"],
Cell[107777, 3103, 37, 1, 22, "Print"],
Cell[107817, 3106, 508, 11, 22, "Print"],
Cell[108328, 3119, 488, 11, 22, "Print"],
Cell[108819, 3132, 527, 12, 22, "Print"],
Cell[109349, 3146, 37, 1, 22, "Print"],
Cell[109389, 3149, 509, 11, 22, "Print"],
Cell[109901, 3162, 505, 11, 22, "Print"],
Cell[110409, 3175, 527, 12, 22, "Print"],
Cell[110939, 3189, 37, 1, 22, "Print"],
Cell[110979, 3192, 509, 11, 22, "Print"],
Cell[111491, 3205, 505, 11, 22, "Print"],
Cell[111999, 3218, 527, 12, 22, "Print"],
Cell[112529, 3232, 37, 1, 22, "Print"],
Cell[112569, 3235, 509, 11, 22, "Print"],
Cell[113081, 3248, 489, 11, 22, "Print"],
Cell[113573, 3261, 527, 12, 22, "Print"],
Cell[114103, 3275, 37, 1, 22, "Print"],
Cell[114143, 3278, 509, 11, 22, "Print"],
Cell[114655, 3291, 490, 11, 22, "Print"],
Cell[115148, 3304, 526, 12, 22, "Print"],
Cell[115677, 3318, 37, 1, 22, "Print"],
Cell[115717, 3321, 511, 11, 22, "Print"],
Cell[116231, 3334, 492, 11, 22, "Print"],
Cell[116726, 3347, 529, 12, 22, "Print"],
Cell[117258, 3361, 37, 1, 22, "Print"],
Cell[117298, 3364, 511, 11, 22, "Print"],
Cell[117812, 3377, 507, 11, 22, "Print"],
Cell[118322, 3390, 529, 12, 22, "Print"],
Cell[118854, 3404, 37, 1, 22, "Print"],
Cell[118894, 3407, 511, 11, 22, "Print"],
Cell[119408, 3420, 491, 11, 22, "Print"],
Cell[119902, 3433, 529, 12, 22, "Print"],
Cell[120434, 3447, 37, 1, 22, "Print"],
Cell[120474, 3450, 511, 11, 22, "Print"],
Cell[120988, 3463, 507, 11, 22, "Print"],
Cell[121498, 3476, 529, 12, 22, "Print"],
Cell[122030, 3490, 37, 1, 22, "Print"],
Cell[122070, 3493, 510, 11, 22, "Print"],
Cell[122583, 3506, 492, 11, 22, "Print"],
Cell[123078, 3519, 528, 12, 22, "Print"],
Cell[123609, 3533, 37, 1, 22, "Print"],
Cell[123649, 3536, 511, 11, 22, "Print"],
Cell[124163, 3549, 491, 11, 22, "Print"],
Cell[124657, 3562, 529, 12, 22, "Print"],
Cell[125189, 3576, 37, 1, 22, "Print"],
Cell[125229, 3579, 511, 11, 22, "Print"],
Cell[125743, 3592, 507, 11, 22, "Print"],
Cell[126253, 3605, 529, 12, 22, "Print"],
Cell[126785, 3619, 37, 1, 22, "Print"],
Cell[126825, 3622, 511, 11, 22, "Print"],
Cell[127339, 3635, 507, 11, 22, "Print"],
Cell[127849, 3648, 529, 12, 22, "Print"],
Cell[128381, 3662, 37, 1, 22, "Print"],
Cell[128421, 3665, 511, 11, 22, "Print"],
Cell[128935, 3678, 507, 11, 22, "Print"],
Cell[129445, 3691, 529, 12, 22, "Print"],
Cell[129977, 3705, 37, 1, 22, "Print"],
Cell[130017, 3708, 511, 11, 22, "Print"],
Cell[130531, 3721, 491, 11, 22, "Print"],
Cell[131025, 3734, 529, 12, 22, "Print"],
Cell[131557, 3748, 37, 1, 22, "Print"],
Cell[131597, 3751, 511, 11, 22, "Print"],
Cell[132111, 3764, 508, 11, 22, "Print"],
Cell[132622, 3777, 528, 12, 22, "Print"],
Cell[133153, 3791, 37, 1, 22, "Print"],
Cell[133193, 3794, 511, 11, 22, "Print"],
Cell[133707, 3807, 508, 11, 22, "Print"],
Cell[134218, 3820, 529, 12, 22, "Print"],
Cell[134750, 3834, 37, 1, 22, "Print"],
Cell[134790, 3837, 510, 11, 22, "Print"],
Cell[135303, 3850, 508, 11, 22, "Print"],
Cell[135814, 3863, 529, 12, 22, "Print"],
Cell[136346, 3877, 37, 1, 22, "Print"],
Cell[136386, 3880, 511, 11, 22, "Print"],
Cell[136900, 3893, 507, 11, 22, "Print"],
Cell[137410, 3906, 529, 12, 22, "Print"],
Cell[137942, 3920, 37, 1, 22, "Print"],
Cell[137982, 3923, 511, 11, 22, "Print"],
Cell[138496, 3936, 493, 11, 22, "Print"],
Cell[138992, 3949, 529, 12, 22, "Print"],
Cell[139524, 3963, 37, 1, 22, "Print"],
Cell[139564, 3966, 511, 11, 22, "Print"],
Cell[140078, 3979, 494, 11, 22, "Print"],
Cell[140575, 3992, 528, 12, 22, "Print"],
Cell[141106, 4006, 37, 1, 22, "Print"],
Cell[141146, 4009, 511, 11, 22, "Print"],
Cell[141660, 4022, 508, 11, 22, "Print"],
Cell[142171, 4035, 528, 12, 22, "Print"],
Cell[142702, 4049, 37, 1, 22, "Print"],
Cell[142742, 4052, 511, 11, 22, "Print"],
Cell[143256, 4065, 508, 11, 22, "Print"],
Cell[143767, 4078, 529, 12, 22, "Print"],
Cell[144299, 4092, 37, 1, 22, "Print"],
Cell[144339, 4095, 511, 11, 22, "Print"],
Cell[144853, 4108, 508, 11, 22, "Print"],
Cell[145364, 4121, 528, 12, 22, "Print"],
Cell[145895, 4135, 37, 1, 22, "Print"],
Cell[145935, 4138, 511, 11, 22, "Print"],
Cell[146449, 4151, 508, 11, 22, "Print"],
Cell[146960, 4164, 528, 12, 22, "Print"],
Cell[147491, 4178, 37, 1, 22, "Print"],
Cell[147531, 4181, 511, 11, 22, "Print"],
Cell[148045, 4194, 508, 11, 22, "Print"],
Cell[148556, 4207, 530, 12, 22, "Print"],
Cell[149089, 4221, 37, 1, 22, "Print"],
Cell[149129, 4224, 511, 11, 22, "Print"],
Cell[149643, 4237, 508, 11, 22, "Print"],
Cell[150154, 4250, 531, 12, 22, "Print"],
Cell[150688, 4264, 37, 1, 22, "Print"],
Cell[150728, 4267, 510, 11, 22, "Print"],
Cell[151241, 4280, 508, 11, 22, "Print"],
Cell[151752, 4293, 564, 13, 22, "Print"],
Cell[152319, 4308, 37, 1, 22, "Print"],
Cell[152359, 4311, 511, 11, 22, "Print"],
Cell[152873, 4324, 508, 11, 22, "Print"],
Cell[153384, 4337, 562, 13, 22, "Print"],
Cell[153949, 4352, 37, 1, 22, "Print"],
Cell[153989, 4355, 542, 12, 22, "Print"],
Cell[154534, 4369, 494, 11, 22, "Print"],
Cell[155031, 4382, 562, 13, 22, "Print"],
Cell[155596, 4397, 37, 1, 22, "Print"],
Cell[155636, 4400, 38, 1, 22, "Print"],
Cell[155677, 4403, 511, 11, 22, "Print"],
Cell[156191, 4416, 528, 12, 22, "Print"],
Cell[156722, 4430, 498, 11, 22, "Print"],
Cell[157223, 4443, 37, 1, 22, "Print"],
Cell[157263, 4446, 509, 11, 22, "Print"],
Cell[157775, 4459, 526, 12, 22, "Print"],
Cell[158304, 4473, 527, 12, 22, "Print"],
Cell[158834, 4487, 37, 1, 22, "Print"],
Cell[158874, 4490, 477, 11, 22, "Print"],
Cell[159354, 4503, 487, 11, 22, "Print"],
Cell[159844, 4516, 498, 11, 22, "Print"],
Cell[160345, 4529, 37, 1, 22, "Print"],
Cell[160385, 4532, 509, 11, 22, "Print"],
Cell[160897, 4545, 526, 12, 22, "Print"],
Cell[161426, 4559, 525, 12, 22, "Print"],
Cell[161954, 4573, 37, 1, 22, "Print"],
Cell[161994, 4576, 509, 11, 22, "Print"],
Cell[162506, 4589, 526, 12, 22, "Print"],
Cell[163035, 4603, 527, 12, 22, "Print"],
Cell[163565, 4617, 37, 1, 22, "Print"],
Cell[163605, 4620, 509, 11, 22, "Print"],
Cell[164117, 4633, 487, 11, 22, "Print"],
Cell[164607, 4646, 527, 12, 22, "Print"],
Cell[165137, 4660, 37, 1, 22, "Print"],
Cell[165177, 4663, 509, 11, 22, "Print"],
Cell[165689, 4676, 525, 12, 22, "Print"],
Cell[166217, 4690, 527, 12, 22, "Print"],
Cell[166747, 4704, 37, 1, 22, "Print"],
Cell[166787, 4707, 509, 11, 22, "Print"],
Cell[167299, 4720, 525, 12, 22, "Print"],
Cell[167827, 4734, 527, 12, 22, "Print"],
Cell[168357, 4748, 37, 1, 22, "Print"],
Cell[168397, 4751, 509, 11, 22, "Print"],
Cell[168909, 4764, 487, 11, 22, "Print"],
Cell[169399, 4777, 527, 12, 22, "Print"],
Cell[169929, 4791, 37, 1, 22, "Print"],
Cell[169969, 4794, 511, 11, 22, "Print"],
Cell[170483, 4807, 527, 12, 22, "Print"],
Cell[171013, 4821, 529, 12, 22, "Print"],
Cell[171545, 4835, 37, 1, 22, "Print"],
Cell[171585, 4838, 511, 11, 22, "Print"],
Cell[172099, 4851, 527, 12, 22, "Print"],
Cell[172629, 4865, 529, 12, 22, "Print"],
Cell[173161, 4879, 37, 1, 22, "Print"],
Cell[173201, 4882, 511, 11, 22, "Print"],
Cell[173715, 4895, 489, 11, 22, "Print"],
Cell[174207, 4908, 528, 12, 22, "Print"],
Cell[174738, 4922, 37, 1, 22, "Print"],
Cell[174778, 4925, 511, 11, 22, "Print"],
Cell[175292, 4938, 528, 12, 22, "Print"],
Cell[175823, 4952, 529, 12, 22, "Print"],
Cell[176355, 4966, 37, 1, 22, "Print"],
Cell[176395, 4969, 511, 11, 22, "Print"],
Cell[176909, 4982, 528, 12, 22, "Print"],
Cell[177440, 4996, 528, 12, 22, "Print"],
Cell[177971, 5010, 37, 1, 22, "Print"],
Cell[178011, 5013, 511, 11, 22, "Print"],
Cell[178525, 5026, 491, 11, 22, "Print"],
Cell[179019, 5039, 529, 12, 22, "Print"],
Cell[179551, 5053, 37, 1, 22, "Print"],
Cell[179591, 5056, 511, 11, 22, "Print"],
Cell[180105, 5069, 528, 12, 22, "Print"],
Cell[180636, 5083, 529, 12, 22, "Print"],
Cell[181168, 5097, 37, 1, 22, "Print"],
Cell[181208, 5100, 511, 11, 22, "Print"],
Cell[181722, 5113, 527, 12, 22, "Print"],
Cell[182252, 5127, 529, 12, 22, "Print"],
Cell[182784, 5141, 37, 1, 22, "Print"],
Cell[182824, 5144, 511, 11, 22, "Print"],
Cell[183338, 5157, 507, 11, 22, "Print"],
Cell[183848, 5170, 529, 12, 22, "Print"],
Cell[184380, 5184, 37, 1, 22, "Print"],
Cell[184420, 5187, 511, 11, 22, "Print"],
Cell[184934, 5200, 527, 12, 22, "Print"],
Cell[185464, 5214, 528, 12, 22, "Print"],
Cell[185995, 5228, 37, 1, 22, "Print"],
Cell[186035, 5231, 511, 11, 22, "Print"],
Cell[186549, 5244, 528, 12, 22, "Print"],
Cell[187080, 5258, 529, 12, 22, "Print"],
Cell[187612, 5272, 37, 1, 22, "Print"],
Cell[187652, 5275, 508, 11, 22, "Print"],
Cell[188163, 5288, 507, 11, 22, "Print"],
Cell[188673, 5301, 529, 12, 22, "Print"],
Cell[189205, 5315, 37, 1, 22, "Print"],
Cell[189245, 5318, 511, 11, 22, "Print"],
Cell[189759, 5331, 527, 12, 22, "Print"],
Cell[190289, 5345, 529, 12, 22, "Print"],
Cell[190821, 5359, 37, 1, 22, "Print"],
Cell[190861, 5362, 511, 11, 22, "Print"],
Cell[191375, 5375, 528, 12, 22, "Print"],
Cell[191906, 5389, 529, 12, 22, "Print"],
Cell[192438, 5403, 37, 1, 22, "Print"],
Cell[192478, 5406, 511, 11, 22, "Print"],
Cell[192992, 5419, 507, 11, 22, "Print"],
Cell[193502, 5432, 529, 12, 22, "Print"],
Cell[194034, 5446, 37, 1, 22, "Print"],
Cell[194074, 5449, 511, 11, 22, "Print"],
Cell[194588, 5462, 528, 12, 22, "Print"],
Cell[195119, 5476, 529, 12, 22, "Print"],
Cell[195651, 5490, 37, 1, 22, "Print"],
Cell[195691, 5493, 511, 11, 22, "Print"],
Cell[196205, 5506, 528, 12, 22, "Print"],
Cell[196736, 5520, 529, 12, 22, "Print"],
Cell[197268, 5534, 37, 1, 22, "Print"],
Cell[197308, 5537, 510, 11, 22, "Print"],
Cell[197821, 5550, 491, 11, 22, "Print"],
Cell[198315, 5563, 529, 12, 22, "Print"],
Cell[198847, 5577, 37, 1, 22, "Print"],
Cell[198887, 5580, 511, 11, 22, "Print"],
Cell[199401, 5593, 528, 12, 22, "Print"],
Cell[199932, 5607, 529, 12, 22, "Print"],
Cell[200464, 5621, 37, 1, 22, "Print"],
Cell[200504, 5624, 510, 11, 22, "Print"],
Cell[201017, 5637, 528, 12, 22, "Print"],
Cell[201548, 5651, 529, 12, 22, "Print"],
Cell[202080, 5665, 37, 1, 22, "Print"],
Cell[202120, 5668, 511, 11, 22, "Print"],
Cell[202634, 5681, 491, 11, 22, "Print"],
Cell[203128, 5694, 530, 12, 22, "Print"],
Cell[203661, 5708, 37, 1, 22, "Print"],
Cell[203701, 5711, 511, 11, 22, "Print"],
Cell[204215, 5724, 528, 12, 22, "Print"],
Cell[204746, 5738, 531, 12, 22, "Print"],
Cell[205280, 5752, 37, 1, 22, "Print"],
Cell[205320, 5755, 511, 11, 22, "Print"],
Cell[205834, 5768, 527, 12, 22, "Print"],
Cell[206364, 5782, 564, 13, 22, "Print"],
Cell[206931, 5797, 37, 1, 22, "Print"],
Cell[206971, 5800, 542, 12, 22, "Print"],
Cell[207516, 5814, 507, 11, 22, "Print"],
Cell[208026, 5827, 562, 13, 22, "Print"],
Cell[208591, 5842, 37, 1, 22, "Print"],
Cell[208631, 5845, 542, 12, 22, "Print"],
Cell[209176, 5859, 527, 12, 22, "Print"],
Cell[209706, 5873, 561, 13, 22, "Print"],
Cell[210270, 5888, 37, 1, 22, "Print"],
Cell[210310, 5891, 542, 12, 22, "Print"],
Cell[210855, 5905, 528, 12, 22, "Print"],
Cell[211386, 5919, 562, 13, 22, "Print"],
Cell[211951, 5934, 37, 1, 22, "Print"],
Cell[211991, 5937, 70, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[212098, 5943, 46, 1, 27, "Input"],
Cell[212147, 5946, 41, 1, 26, "Output"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{
Cell[212237, 5953, 53, 0, 28, "Subsection"],
Cell[212293, 5955, 140, 2, 43, "Input"],

Cell[CellGroupData[{
Cell[212458, 5961, 46, 1, 27, "Input"],
Cell[212507, 5964, 41, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[212585, 5970, 124, 4, 42, "Input"],
Cell[212712, 5976, 243, 5, 22, "Print"],
Cell[212958, 5983, 253, 5, 22, "Print"],
Cell[213214, 5990, 251, 5, 22, "Print"],
Cell[213468, 5997, 37, 1, 22, "Print"],
Cell[213508, 6000, 243, 5, 22, "Print"],
Cell[213754, 6007, 253, 5, 22, "Print"],
Cell[214010, 6014, 251, 5, 22, "Print"],
Cell[214264, 6021, 37, 1, 22, "Print"],
Cell[214304, 6024, 243, 5, 22, "Print"],
Cell[214550, 6031, 253, 5, 22, "Print"],
Cell[214806, 6038, 251, 5, 22, "Print"],
Cell[215060, 6045, 37, 1, 22, "Print"],
Cell[215100, 6048, 402, 10, 22, "Print"],
Cell[215505, 6060, 253, 5, 22, "Print"],
Cell[215761, 6067, 409, 10, 22, "Print"],
Cell[216173, 6079, 37, 1, 22, "Print"],
Cell[216213, 6082, 475, 11, 24, "Print"],
Cell[216691, 6095, 253, 5, 22, "Print"],
Cell[216947, 6102, 451, 10, 24, "Print"],
Cell[217401, 6114, 37, 1, 22, "Print"],
Cell[217441, 6117, 444, 10, 24, "Print"],
Cell[217888, 6129, 253, 5, 22, "Print"],
Cell[218144, 6136, 451, 10, 24, "Print"],
Cell[218598, 6148, 37, 1, 22, "Print"],
Cell[218638, 6151, 475, 11, 24, "Print"],
Cell[219116, 6164, 253, 5, 22, "Print"],
Cell[219372, 6171, 451, 10, 24, "Print"],
Cell[219826, 6183, 37, 1, 22, "Print"],
Cell[219866, 6186, 444, 10, 24, "Print"],
Cell[220313, 6198, 253, 5, 22, "Print"],
Cell[220569, 6205, 451, 10, 24, "Print"],
Cell[221023, 6217, 37, 1, 22, "Print"],
Cell[221063, 6220, 475, 11, 24, "Print"],
Cell[221541, 6233, 253, 5, 22, "Print"],
Cell[221797, 6240, 451, 10, 24, "Print"],
Cell[222251, 6252, 37, 1, 22, "Print"],
Cell[222291, 6255, 475, 11, 24, "Print"],
Cell[222769, 6268, 253, 5, 22, "Print"],
Cell[223025, 6275, 451, 10, 24, "Print"],
Cell[223479, 6287, 37, 1, 22, "Print"],
Cell[223519, 6290, 446, 10, 24, "Print"],
Cell[223968, 6302, 255, 5, 22, "Print"],
Cell[224226, 6309, 453, 10, 24, "Print"],
Cell[224682, 6321, 37, 1, 22, "Print"],
Cell[224722, 6324, 477, 11, 24, "Print"],
Cell[225202, 6337, 255, 5, 22, "Print"],
Cell[225460, 6344, 453, 10, 24, "Print"],
Cell[225916, 6356, 37, 1, 22, "Print"],
Cell[225956, 6359, 477, 11, 24, "Print"],
Cell[226436, 6372, 255, 5, 22, "Print"],
Cell[226694, 6379, 453, 10, 24, "Print"],
Cell[227150, 6391, 37, 1, 22, "Print"],
Cell[227190, 6394, 446, 10, 24, "Print"],
Cell[227639, 6406, 255, 5, 22, "Print"],
Cell[227897, 6413, 453, 10, 24, "Print"],
Cell[228353, 6425, 37, 1, 22, "Print"],
Cell[228393, 6428, 476, 11, 24, "Print"],
Cell[228872, 6441, 255, 5, 22, "Print"],
Cell[229130, 6448, 452, 10, 24, "Print"],
Cell[229585, 6460, 37, 1, 22, "Print"],
Cell[229625, 6463, 445, 10, 24, "Print"],
Cell[230073, 6475, 255, 5, 22, "Print"],
Cell[230331, 6482, 452, 10, 24, "Print"],
Cell[230786, 6494, 37, 1, 22, "Print"],
Cell[230826, 6497, 475, 11, 24, "Print"],
Cell[231304, 6510, 255, 5, 22, "Print"],
Cell[231562, 6517, 451, 10, 24, "Print"],
Cell[232016, 6529, 37, 1, 22, "Print"],
Cell[232056, 6532, 476, 11, 24, "Print"],
Cell[232535, 6545, 255, 5, 22, "Print"],
Cell[232793, 6552, 452, 10, 24, "Print"],
Cell[233248, 6564, 37, 1, 22, "Print"],
Cell[233288, 6567, 445, 10, 24, "Print"],
Cell[233736, 6579, 255, 5, 22, "Print"],
Cell[233994, 6586, 452, 10, 24, "Print"],
Cell[234449, 6598, 37, 1, 22, "Print"],
Cell[234489, 6601, 476, 11, 24, "Print"],
Cell[234968, 6614, 255, 5, 22, "Print"],
Cell[235226, 6621, 452, 10, 24, "Print"],
Cell[235681, 6633, 37, 1, 22, "Print"],
Cell[235721, 6636, 445, 10, 24, "Print"],
Cell[236169, 6648, 255, 5, 22, "Print"],
Cell[236427, 6655, 452, 10, 24, "Print"],
Cell[236882, 6667, 37, 1, 22, "Print"],
Cell[236922, 6670, 476, 11, 24, "Print"],
Cell[237401, 6683, 255, 5, 22, "Print"],
Cell[237659, 6690, 452, 10, 24, "Print"],
Cell[238114, 6702, 37, 1, 22, "Print"],
Cell[238154, 6705, 445, 10, 24, "Print"],
Cell[238602, 6717, 255, 5, 22, "Print"],
Cell[238860, 6724, 452, 10, 24, "Print"],
Cell[239315, 6736, 37, 1, 22, "Print"],
Cell[239355, 6739, 477, 11, 22, "Print"],
Cell[239835, 6752, 255, 5, 22, "Print"],
Cell[240093, 6759, 453, 10, 22, "Print"],
Cell[240549, 6771, 37, 1, 22, "Print"],
Cell[240589, 6774, 444, 10, 22, "Print"],
Cell[241036, 6786, 255, 5, 22, "Print"],
Cell[241294, 6793, 451, 10, 22, "Print"],
Cell[241748, 6805, 37, 1, 22, "Print"],
Cell[241788, 6808, 475, 11, 22, "Print"],
Cell[242266, 6821, 255, 5, 22, "Print"],
Cell[242524, 6828, 451, 10, 22, "Print"],
Cell[242978, 6840, 37, 1, 22, "Print"],
Cell[243018, 6843, 442, 10, 22, "Print"],
Cell[243463, 6855, 255, 5, 22, "Print"],
Cell[243721, 6862, 449, 10, 22, "Print"],
Cell[244173, 6874, 37, 1, 22, "Print"],
Cell[244213, 6877, 473, 11, 22, "Print"],
Cell[244689, 6890, 255, 5, 22, "Print"],
Cell[244947, 6897, 449, 10, 22, "Print"],
Cell[245399, 6909, 37, 1, 22, "Print"],
Cell[245439, 6912, 440, 10, 22, "Print"],
Cell[245882, 6924, 255, 5, 22, "Print"],
Cell[246140, 6931, 447, 10, 22, "Print"],
Cell[246590, 6943, 37, 1, 22, "Print"],
Cell[246630, 6946, 439, 10, 22, "Print"],
Cell[247072, 6958, 255, 5, 22, "Print"],
Cell[247330, 6965, 446, 10, 22, "Print"],
Cell[247779, 6977, 37, 1, 22, "Print"],
Cell[247819, 6980, 469, 11, 22, "Print"],
Cell[248291, 6993, 255, 5, 22, "Print"],
Cell[248549, 7000, 445, 10, 22, "Print"],
Cell[248997, 7012, 37, 1, 22, "Print"],
Cell[249037, 7015, 436, 10, 22, "Print"],
Cell[249476, 7027, 255, 5, 22, "Print"],
Cell[249734, 7034, 443, 10, 22, "Print"],
Cell[250180, 7046, 37, 1, 22, "Print"],
Cell[250220, 7049, 466, 11, 22, "Print"],
Cell[250689, 7062, 255, 5, 22, "Print"],
Cell[250947, 7069, 442, 10, 22, "Print"],
Cell[251392, 7081, 37, 1, 22, "Print"],
Cell[251432, 7084, 436, 10, 22, "Print"],
Cell[251871, 7096, 255, 5, 22, "Print"],
Cell[252129, 7103, 443, 10, 22, "Print"],
Cell[252575, 7115, 37, 1, 22, "Print"],
Cell[252615, 7118, 436, 10, 22, "Print"],
Cell[253054, 7130, 255, 5, 22, "Print"],
Cell[253312, 7137, 443, 10, 22, "Print"],
Cell[253758, 7149, 37, 1, 22, "Print"],
Cell[253798, 7152, 70, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[253905, 7158, 46, 1, 27, "Input"],
Cell[253954, 7161, 41, 1, 26, "Output"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{
Cell[254044, 7168, 60, 0, 28, "Subsection"],
Cell[254107, 7170, 140, 2, 43, "Input"],

Cell[CellGroupData[{
Cell[254272, 7176, 46, 1, 27, "Input"],
Cell[254321, 7179, 41, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[254399, 7185, 93, 1, 27, "Input"],
Cell[254495, 7188, 485, 11, 22, "Print"],
Cell[254983, 7201, 308, 6, 22, "Print"],
Cell[255294, 7209, 633, 15, 24, "Print"],
Cell[255930, 7226, 768, 20, 24, "Print"],
Cell[256701, 7248, 1207, 32, 24, "Print"],
Cell[257911, 7282, 1541, 38, 56, "Print"],
Cell[259455, 7322, 1772, 44, 56, "Print"],
Cell[261230, 7368, 1981, 50, 56, "Print"],
Cell[263214, 7420, 2209, 56, 73, "Print"],
Cell[265426, 7478, 2453, 62, 73, "Print"],
Cell[267882, 7542, 2683, 68, 73, "Print"],
Cell[270568, 7612, 2915, 74, 90, "Print"],
Cell[273486, 7688, 3130, 80, 90, "Print"],
Cell[276619, 7770, 3361, 86, 90, "Print"],
Cell[279983, 7858, 3593, 92, 107, "Print"],
Cell[283579, 7952, 3850, 98, 124, "Print"],
Cell[287432, 8052, 70, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[287539, 8058, 46, 1, 27, "Input"],
Cell[287588, 8061, 41, 1, 26, "Output"]
}, Open  ]]
}, Closed]]
}, Closed]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

