(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 3.0,
MathReader 3.0, or any compatible application. The data for the notebook 
starts with the line of stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[    240029,       6583]*)
(*NotebookOutlinePosition[    240869,       6610]*)
(*  CellTagsIndexPosition[    240825,       6606]*)
(*WindowFrame->Normal*)



Notebook[{
Cell[TextData[{
  " :Author:  Z\[EAcute]lia da ROCHA \n\n:Address: \n            Departamento \
de Matem\[AAcute]tica Aplicada da\n            Faculdade de Ci\[EHat]ncias do \
Porto\n            Rua das Taipas, 135\n            4050 Porto\n            \
Portugal\n  \n            Tel: ++351 02 2080313\n            Fax: ++351 02 \
2004109\n            Email: mrdioh@fc.up.pt\n\n :Summary:\n    The ",
  StyleBox["testchv3",
    FontSize->18],
  " notebook contains the results produced by the package\n    chv.m \
corresponding to the ",
  StyleBox["example 3",
    FontSize->18],
  " of the first paper cited bellow.    \n\n :Date: July 1999.\n\n:Available \
at http://netlib.bell-labs.com/ in the numeralgo library in netlib:     \n\n \
:Notebook Version: 1.0 \n\n :Mathematica Version: 3.0   \n \n :Keywords: \
chebyshev's method, recurrence relations,  orthogonal polynomials of \
dimension d, d-dimensional forms.\n\n :Sources:\n \n - Z\[EAcute]lia da \
Rocha, Shohat-Favard and Chebyshev's methods in d-orthogonality, \n Numerical \
Algorithms,  20 (1999) 139-164.\n   \n - About the example treated here see \
pp. 92, 106 of:\n   K. Douak, P. Maroni, Les polyn\[OHat]mes orthogonaux \
\"classiques\" de dimension deux, Analysis 12,  71-107 (1992)\n"
}], "Subsection"],

Cell[CellGroupData[{

Cell["\<\
Computing the recurrence coefficients and the orthogonal \
polynomials performing formal computations\
\>", "Section",
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell["\<\
Loading the package chv.m, the package datachv3.m is automatically \
loaded\
\>", "Subsection"],

Cell[BoxData[
    \(\(<< chebyshev`chv`; \)\)], "Input"]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
 The moments of the d-dimensional form are given in the package \
datachv3.m\
\>", "Subsection",
  AspectRatioFixed->True],

Cell[BoxData[
    \( (*\ showing\ the\ moments\ given\ *) \)], "Input"],

Cell[BoxData[
    \(\( (*\ set\ the\ values\ of\ d\ and\ imax\ *) \nd = 2; imax = \ 10; 
    \ \ \ \ \ \  (*\ for\ example\ *) \)\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Do[Print["\<form[\>", d, "\<,\>", r, "\<,\>", i, "\<]=\>", 
        form[d, r, i]], {r, 1, d}, {i, 0, imax}]\)], "Input"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]0
        \[InvisibleSpace]"]="\[InvisibleSpace]1\),
      SequenceForm[ "form[", 2, ",", 1, ",", 0, "]=", 1],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]"]="\[InvisibleSpace]1\),
      SequenceForm[ "form[", 2, ",", 1, ",", 1, "]=", 1],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]"]="\[InvisibleSpace]10\),
      SequenceForm[ "form[", 2, ",", 1, ",", 2, "]=", 10],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]"]="\[InvisibleSpace]280\),
      SequenceForm[ "form[", 2, ",", 1, ",", 3, "]=", 280],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]"]="\[InvisibleSpace]15400\),
      SequenceForm[ "form[", 2, ",", 1, ",", 4, "]=", 15400],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]"]="\[InvisibleSpace]1401400\),
      SequenceForm[ "form[", 2, ",", 1, ",", 5, "]=", 1401400],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]6
        \[InvisibleSpace]"]="\[InvisibleSpace]190590400\),
      SequenceForm[ "form[", 2, ",", 1, ",", 6, "]=", 190590400],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]7
        \[InvisibleSpace]"]="\[InvisibleSpace]36212176000\),
      SequenceForm[ "form[", 2, ",", 1, ",", 7, "]=", 36212176000],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]8
        \[InvisibleSpace]"]="\[InvisibleSpace]9161680528000\),
      SequenceForm[ "form[", 2, ",", 1, ",", 8, "]=", 9161680528000],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]9
        \[InvisibleSpace]"]="\[InvisibleSpace]2977546171600000\),
      SequenceForm[ "form[", 2, ",", 1, ",", 9, "]=", 2977546171600000],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]10
        \[InvisibleSpace]"]="\[InvisibleSpace]1208883745669600000\),
      SequenceForm[ "form[", 2, ",", 1, ",", 10, "]=", 1208883745669600000],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]0
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 2, ",", 2, ",", 0, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]"]="\[InvisibleSpace]1\),
      SequenceForm[ "form[", 2, ",", 2, ",", 1, "]=", 1],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]"]="\[InvisibleSpace]20\),
      SequenceForm[ "form[", 2, ",", 2, ",", 2, "]=", 20],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]"]="\[InvisibleSpace]840\),
      SequenceForm[ "form[", 2, ",", 2, ",", 3, "]=", 840],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]"]="\[InvisibleSpace]61600\),
      SequenceForm[ "form[", 2, ",", 2, ",", 4, "]=", 61600],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]"]="\[InvisibleSpace]7007000\),
      SequenceForm[ "form[", 2, ",", 2, ",", 5, "]=", 7007000],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]6
        \[InvisibleSpace]"]="\[InvisibleSpace]1143542400\),
      SequenceForm[ "form[", 2, ",", 2, ",", 6, "]=", 1143542400],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]7
        \[InvisibleSpace]"]="\[InvisibleSpace]253485232000\),
      SequenceForm[ "form[", 2, ",", 2, ",", 7, "]=", 253485232000],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]8
        \[InvisibleSpace]"]="\[InvisibleSpace]73293444224000\),
      SequenceForm[ "form[", 2, ",", 2, ",", 8, "]=", 73293444224000],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]9
        \[InvisibleSpace]"]="\[InvisibleSpace]26797915544400000\),
      SequenceForm[ "form[", 2, ",", 2, ",", 9, "]=", 26797915544400000],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]10
        \[InvisibleSpace]"]="\[InvisibleSpace]12088837456696000000\),
      SequenceForm[ "form[", 2, ",", 2, ",", 10, "]=", 12088837456696000000],
      Editable->False]], "Print"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Computing the gamma coefficients", "Subsection"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\( (*\ set\ the\ values\ of\ d\ and\ nmax\ *) \nd = 2; \ nmax = \ 10\ ; 
    \ \ \ \  (*\ for\ example\ *) \)\)], "Input"],

Cell[BoxData[
    \(General::"spell1" \( : \ \) 
      "Possible spelling error: new symbol name \"\!\(nmax\)\" is similar to \
existing symbol \"\!\(imax\)\"."\)], "Message"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(MemoryInUse[]\)], "Input"],

Cell[BoxData[
    \(938904\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Timing[printgamma[d,nmax,Infinity,$MachinePrecision,True,False]]\
\>\
", "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    \("   "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]0
        \[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]"]="\[InvisibleSpace]90\),
      SequenceForm[ "gamma[", 2, ",", 0, ",", 1, "]=", 90],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]0
        \[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]"]="\[InvisibleSpace]90\),
      SequenceForm[ "gammaexact[", 2, ",", 0, ",", 1, "]=", 90],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]0
        \[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]"]="\[InvisibleSpace]7560\),
      SequenceForm[ "gamma[", 2, ",", 0, ",", 2, "]=", 7560],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]0
        \[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]"]="\[InvisibleSpace]7560\),
      SequenceForm[ "gammaexact[", 2, ",", 0, ",", 2, "]=", 7560],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]0
        \[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]"]="\[InvisibleSpace]83160\),
      SequenceForm[ "gamma[", 2, ",", 0, ",", 3, "]=", 83160],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]0
        \[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]"]="\[InvisibleSpace]83160\),
      SequenceForm[ "gammaexact[", 2, ",", 0, ",", 3, "]=", 83160],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]0
        \[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]"]="\[InvisibleSpace]450450\),
      SequenceForm[ "gamma[", 2, ",", 0, ",", 4, "]=", 450450],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]0
        \[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]"]="\[InvisibleSpace]450450\),
      SequenceForm[ "gammaexact[", 2, ",", 0, ",", 4, "]=", 450450],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]0
        \[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]"]="\[InvisibleSpace]1670760\),
      SequenceForm[ "gamma[", 2, ",", 0, ",", 5, "]=", 1670760],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]0
        \[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]"]="\[InvisibleSpace]1670760\),
      SequenceForm[ "gammaexact[", 2, ",", 0, ",", 5, "]=", 1670760],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]0
        \[InvisibleSpace]","\[InvisibleSpace]6
        \[InvisibleSpace]"]="\[InvisibleSpace]4883760\),
      SequenceForm[ "gamma[", 2, ",", 0, ",", 6, "]=", 4883760],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]0
        \[InvisibleSpace]","\[InvisibleSpace]6
        \[InvisibleSpace]"]="\[InvisibleSpace]4883760\),
      SequenceForm[ "gammaexact[", 2, ",", 0, ",", 6, "]=", 4883760],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]0
        \[InvisibleSpace]","\[InvisibleSpace]7
        \[InvisibleSpace]"]="\[InvisibleSpace]12113640\),
      SequenceForm[ "gamma[", 2, ",", 0, ",", 7, "]=", 12113640],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]0
        \[InvisibleSpace]","\[InvisibleSpace]7
        \[InvisibleSpace]"]="\[InvisibleSpace]12113640\),
      SequenceForm[ "gammaexact[", 2, ",", 0, ",", 7, "]=", 12113640],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]0
        \[InvisibleSpace]","\[InvisibleSpace]8
        \[InvisibleSpace]"]="\[InvisibleSpace]26640900\),
      SequenceForm[ "gamma[", 2, ",", 0, ",", 8, "]=", 26640900],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]0
        \[InvisibleSpace]","\[InvisibleSpace]8
        \[InvisibleSpace]"]="\[InvisibleSpace]26640900\),
      SequenceForm[ "gammaexact[", 2, ",", 0, ",", 8, "]=", 26640900],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]0
        \[InvisibleSpace]","\[InvisibleSpace]9
        \[InvisibleSpace]"]="\[InvisibleSpace]53439750\),
      SequenceForm[ "gamma[", 2, ",", 0, ",", 9, "]=", 53439750],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]0
        \[InvisibleSpace]","\[InvisibleSpace]9
        \[InvisibleSpace]"]="\[InvisibleSpace]53439750\),
      SequenceForm[ "gammaexact[", 2, ",", 0, ",", 9, "]=", 53439750],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    \("   "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]"]="\[InvisibleSpace]9\),
      SequenceForm[ "gamma[", 2, ",", 1, ",", 1, "]=", 9],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]"]="\[InvisibleSpace]9\),
      SequenceForm[ "gammaexact[", 2, ",", 1, ",", 1, "]=", 9],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]"]="\[InvisibleSpace]450\),
      SequenceForm[ "gamma[", 2, ",", 1, ",", 2, "]=", 450],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]"]="\[InvisibleSpace]450\),
      SequenceForm[ "gammaexact[", 2, ",", 1, ",", 2, "]=", 450],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]"]="\[InvisibleSpace]3024\),
      SequenceForm[ "gamma[", 2, ",", 1, ",", 3, "]=", 3024],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]"]="\[InvisibleSpace]3024\),
      SequenceForm[ "gammaexact[", 2, ",", 1, ",", 3, "]=", 3024],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]"]="\[InvisibleSpace]10890\),
      SequenceForm[ "gamma[", 2, ",", 1, ",", 4, "]=", 10890],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]"]="\[InvisibleSpace]10890\),
      SequenceForm[ "gammaexact[", 2, ",", 1, ",", 4, "]=", 10890],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]"]="\[InvisibleSpace]28665\),
      SequenceForm[ "gamma[", 2, ",", 1, ",", 5, "]=", 28665],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]"]="\[InvisibleSpace]28665\),
      SequenceForm[ "gammaexact[", 2, ",", 1, ",", 5, "]=", 28665],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]6
        \[InvisibleSpace]"]="\[InvisibleSpace]62424\),
      SequenceForm[ "gamma[", 2, ",", 1, ",", 6, "]=", 62424],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]6
        \[InvisibleSpace]"]="\[InvisibleSpace]62424\),
      SequenceForm[ "gammaexact[", 2, ",", 1, ",", 6, "]=", 62424],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]7
        \[InvisibleSpace]"]="\[InvisibleSpace]119700\),
      SequenceForm[ "gamma[", 2, ",", 1, ",", 7, "]=", 119700],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]7
        \[InvisibleSpace]"]="\[InvisibleSpace]119700\),
      SequenceForm[ "gammaexact[", 2, ",", 1, ",", 7, "]=", 119700],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]8
        \[InvisibleSpace]"]="\[InvisibleSpace]209484\),
      SequenceForm[ "gamma[", 2, ",", 1, ",", 8, "]=", 209484],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]8
        \[InvisibleSpace]"]="\[InvisibleSpace]209484\),
      SequenceForm[ "gammaexact[", 2, ",", 1, ",", 8, "]=", 209484],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]9
        \[InvisibleSpace]"]="\[InvisibleSpace]342225\),
      SequenceForm[ "gamma[", 2, ",", 1, ",", 9, "]=", 342225],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]9
        \[InvisibleSpace]"]="\[InvisibleSpace]342225\),
      SequenceForm[ "gammaexact[", 2, ",", 1, ",", 9, "]=", 342225],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]10
        \[InvisibleSpace]"]="\[InvisibleSpace]529830\),
      SequenceForm[ "gamma[", 2, ",", 1, ",", 10, "]=", 529830],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]10
        \[InvisibleSpace]"]="\[InvisibleSpace]529830\),
      SequenceForm[ "gammaexact[", 2, ",", 1, ",", 10, "]=", 529830],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    \({7.`\ Second, Null}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(MemoryInUse[]\)], "Input"],

Cell[BoxData[
    \(989664\)], "Output"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Computing the beta coefficients", "Subsection"],

Cell[BoxData[
    \(\( (*\ set\ the\ values\ of\ d\ and\ nmax\ *) \nd = 2; \ nmax = \ 10; 
    \ \ \ \ \  (*\ for\ example\ *) \)\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(MemoryInUse[]\)], "Input"],

Cell[BoxData[
    \(991464\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Timing[printbeta[d,nmax,Infinity,$MachinePrecision,True,False]]\
\>\
", "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    InterpretationBox[
      \("beta["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]0
        \[InvisibleSpace]"]="\[InvisibleSpace]1\),
      SequenceForm[ "beta[", 2, ",", 0, "]=", 1],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("betaexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]0
        \[InvisibleSpace]"]="\[InvisibleSpace]1\),
      SequenceForm[ "betaexact[", 2, ",", 0, "]=", 1],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("beta["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]"]="\[InvisibleSpace]19\),
      SequenceForm[ "beta[", 2, ",", 1, "]=", 19],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("betaexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]"]="\[InvisibleSpace]19\),
      SequenceForm[ "betaexact[", 2, ",", 1, "]=", 19],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("beta["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]"]="\[InvisibleSpace]64\),
      SequenceForm[ "beta[", 2, ",", 2, "]=", 64],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("betaexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]"]="\[InvisibleSpace]64\),
      SequenceForm[ "betaexact[", 2, ",", 2, "]=", 64],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("beta["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]"]="\[InvisibleSpace]136\),
      SequenceForm[ "beta[", 2, ",", 3, "]=", 136],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("betaexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]"]="\[InvisibleSpace]136\),
      SequenceForm[ "betaexact[", 2, ",", 3, "]=", 136],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("beta["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]"]="\[InvisibleSpace]235\),
      SequenceForm[ "beta[", 2, ",", 4, "]=", 235],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("betaexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]"]="\[InvisibleSpace]235\),
      SequenceForm[ "betaexact[", 2, ",", 4, "]=", 235],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("beta["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]"]="\[InvisibleSpace]361\),
      SequenceForm[ "beta[", 2, ",", 5, "]=", 361],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("betaexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]"]="\[InvisibleSpace]361\),
      SequenceForm[ "betaexact[", 2, ",", 5, "]=", 361],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("beta["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]6
        \[InvisibleSpace]"]="\[InvisibleSpace]514\),
      SequenceForm[ "beta[", 2, ",", 6, "]=", 514],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("betaexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]6
        \[InvisibleSpace]"]="\[InvisibleSpace]514\),
      SequenceForm[ "betaexact[", 2, ",", 6, "]=", 514],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("beta["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]7
        \[InvisibleSpace]"]="\[InvisibleSpace]694\),
      SequenceForm[ "beta[", 2, ",", 7, "]=", 694],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("betaexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]7
        \[InvisibleSpace]"]="\[InvisibleSpace]694\),
      SequenceForm[ "betaexact[", 2, ",", 7, "]=", 694],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("beta["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]8
        \[InvisibleSpace]"]="\[InvisibleSpace]901\),
      SequenceForm[ "beta[", 2, ",", 8, "]=", 901],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("betaexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]8
        \[InvisibleSpace]"]="\[InvisibleSpace]901\),
      SequenceForm[ "betaexact[", 2, ",", 8, "]=", 901],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("beta["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]9
        \[InvisibleSpace]"]="\[InvisibleSpace]1135\),
      SequenceForm[ "beta[", 2, ",", 9, "]=", 1135],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("betaexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]9
        \[InvisibleSpace]"]="\[InvisibleSpace]1135\),
      SequenceForm[ "betaexact[", 2, ",", 9, "]=", 1135],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    \({3.61666666666666003`\ Second, Null}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(MemoryInUse[]\)], "Input"],

Cell[BoxData[
    \(994560\)], "Output"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Computing the d-orthogonal polynomials", "Subsection"],

Cell[BoxData[
    \(\( (*\ set\ the\ values\ of\ d\ and\ nmax\ *) \nd = 2; \ nmax = \ 10\ ; 
    \ \ \ \  (*\ for\ example\ *) \)\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(MemoryInUse[]\)], "Input"],

Cell[BoxData[
    \(996376\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Timing[printdorthpoly[d,nmax,x,Infinity]]", "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    InterpretationBox[
      \("dorthpoly["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]0
        \[InvisibleSpace]","\[InvisibleSpace]x
        \[InvisibleSpace]"]="\[InvisibleSpace]1\),
      SequenceForm[ "dorthpoly[", 2, ",", 0, ",", x, "]=", 1],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("dorthpoly["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]x
        \[InvisibleSpace]"]="\[InvisibleSpace]\(\( - 1\) + x\)\),
      SequenceForm[ "dorthpoly[", 2, ",", 1, ",", x, "]=", 
        Plus[ -1, x]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("dorthpoly["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]x
        \[InvisibleSpace]"]="\[InvisibleSpace]\(10 - 20\ x + x\^2\)\),
      SequenceForm[ "dorthpoly[", 2, ",", 2, ",", x, "]=", 
        Plus[ 10, 
          Times[ -20, x], 
          Power[ x, 2]]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("dorthpoly["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]x
        \[InvisibleSpace]"]="\[InvisibleSpace]\(\( - 280\) + 840\ x - 
          84\ x\^2 + x\^3\)\),
      SequenceForm[ "dorthpoly[", 2, ",", 3, ",", x, "]=", 
        Plus[ -280, 
          Times[ 840, x], 
          Times[ -84, 
            Power[ x, 2]], 
          Power[ x, 3]]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("dorthpoly["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]x
        \[InvisibleSpace]"]="\[InvisibleSpace]\(15400 - 61600\ x + 
          9240\ x\^2 - 220\ x\^3 + x\^4\)\),
      SequenceForm[ "dorthpoly[", 2, ",", 4, ",", x, "]=", 
        Plus[ 15400, 
          Times[ -61600, x], 
          Times[ 9240, 
            Power[ x, 2]], 
          Times[ -220, 
            Power[ x, 3]], 
          Power[ x, 4]]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("dorthpoly["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]x
        \[InvisibleSpace]"]="\[InvisibleSpace]\(\( - 1401400\) + 7007000\ x - 
          1401400\ x\^2 + 50050\ x\^3 - 455\ x\^4 + x\^5\)\),
      SequenceForm[ "dorthpoly[", 2, ",", 5, ",", x, "]=", 
        Plus[ -1401400, 
          Times[ 7007000, x], 
          Times[ -1401400, 
            Power[ x, 2]], 
          Times[ 50050, 
            Power[ x, 3]], 
          Times[ -455, 
            Power[ x, 4]], 
          Power[ x, 5]]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("dorthpoly["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]6
        \[InvisibleSpace]","\[InvisibleSpace]x
        \[InvisibleSpace]"]="\[InvisibleSpace]\(190590400 - 1143542400\ x + 
          285885600\ x\^2 - 13613600\ x\^3 + 185640\ x\^4 - 816\ x\^5 + 
          x\^6\)\),
      SequenceForm[ "dorthpoly[", 2, ",", 6, ",", x, "]=", 
        Plus[ 190590400, 
          Times[ -1143542400, x], 
          Times[ 285885600, 
            Power[ x, 2]], 
          Times[ -13613600, 
            Power[ x, 3]], 
          Times[ 185640, 
            Power[ x, 4]], 
          Times[ -816, 
            Power[ x, 5]], 
          Power[ x, 6]]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("dorthpoly["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]7
        \[InvisibleSpace]","\[InvisibleSpace]x
        \[InvisibleSpace]"]="\[InvisibleSpace]\(\( - 36212176000\) + 
          253485232000\ x - 76045569600\ x\^2 + 4526522000\ x\^3 - 
          82300400\ x\^4 + 542640\ x\^5 - 1330\ x\^6 + x\^7\)\),
      SequenceForm[ "dorthpoly[", 2, ",", 7, ",", x, "]=", 
        Plus[ -36212176000, 
          Times[ 253485232000, x], 
          Times[ -76045569600, 
            Power[ x, 2]], 
          Times[ 4526522000, 
            Power[ x, 3]], 
          Times[ -82300400, 
            Power[ x, 4]], 
          Times[ 542640, 
            Power[ x, 5]], 
          Times[ -1330, 
            Power[ x, 6]], 
          Power[ x, 7]]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("dorthpoly["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]8
        \[InvisibleSpace]","\[InvisibleSpace]x
        \[InvisibleSpace]"]="\[InvisibleSpace]\(9161680528000 - 
          73293444224000\ x + 25652705478400\ x\^2 - 1832336105600\ x\^3 + 
          41644002400\ x\^4 - 366101120\ x\^5 + 1345960\ x\^6 - 2024\ x\^7 + 
          x\^8\)\),
      SequenceForm[ "dorthpoly[", 2, ",", 8, ",", x, "]=", 
        Plus[ 9161680528000, 
          Times[ -73293444224000, x], 
          Times[ 25652705478400, 
            Power[ x, 2]], 
          Times[ -1832336105600, 
            Power[ x, 3]], 
          Times[ 41644002400, 
            Power[ x, 4]], 
          Times[ -366101120, 
            Power[ x, 5]], 
          Times[ 1345960, 
            Power[ x, 6]], 
          Times[ -2024, 
            Power[ x, 7]], 
          Power[ x, 8]]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("dorthpoly["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]9
        \[InvisibleSpace]","\[InvisibleSpace]x
        \[InvisibleSpace]"]="\[InvisibleSpace]\(\( - 2977546171600000\) + 
          26797915544400000\ x - 10719166217760000\ x\^2 + 
          893263851480000\ x\^3 - 24361741404000\ x\^4 + 267711444000\ x\^5 - 
          1312311000\ x\^6 + 2960100\ x\^7 - 2925\ x\^8 + x\^9\)\),
      SequenceForm[ "dorthpoly[", 2, ",", 9, ",", x, "]=", 
        Plus[ -2977546171600000, 
          Times[ 26797915544400000, x], 
          Times[ -10719166217760000, 
            Power[ x, 2]], 
          Times[ 893263851480000, 
            Power[ x, 3]], 
          Times[ -24361741404000, 
            Power[ x, 4]], 
          Times[ 267711444000, 
            Power[ x, 5]], 
          Times[ -1312311000, 
            Power[ x, 6]], 
          Times[ 2960100, 
            Power[ x, 7]], 
          Times[ -2925, 
            Power[ x, 8]], 
          Power[ x, 9]]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("dorthpoly["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]10
        \[InvisibleSpace]","\[InvisibleSpace]x
        \[InvisibleSpace]"]="\[InvisibleSpace]\(1208883745669600000 - 
          12088837456696000000\ x + 5439976855513200000\ x\^2 - 
          518093033858400000\ x\^3 + 16484778350040000\ x\^4 - 
          217381692528000\ x\^5 + 1331995665000\ x\^6 - 4006002000\ x\^7 + 
          5937750\ x\^8 - 4060\ x\^9 + x\^10\)\),
      SequenceForm[ "dorthpoly[", 2, ",", 10, ",", x, "]=", 
        Plus[ 1208883745669600000, 
          Times[ -12088837456696000000, x], 
          Times[ 5439976855513200000, 
            Power[ x, 2]], 
          Times[ -518093033858400000, 
            Power[ x, 3]], 
          Times[ 16484778350040000, 
            Power[ x, 4]], 
          Times[ -217381692528000, 
            Power[ x, 5]], 
          Times[ 1331995665000, 
            Power[ x, 6]], 
          Times[ -4006002000, 
            Power[ x, 7]], 
          Times[ 5937750, 
            Power[ x, 8]], 
          Times[ -4060, 
            Power[ x, 9]], 
          Power[ x, 10]]],
      Editable->False]], "Print"],

Cell[BoxData[
    \({1.93333333333333712`\ Second, Null}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(MemoryInUse[]\)], "Input"],

Cell[BoxData[
    \(1003672\)], "Output"]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["\<\
Computing the recurrence coefficients and the orthogonal \
polynomials performing numerical computations with the machine precision\
\>",
   "Section",
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell["\<\
Loading the package chv.m, the package datachv3.m is automatically \
loaded\
\>", "Subsection"],

Cell[BoxData[
    \(\(<< chebyshev`chv`; \)\)], "Input"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Computing the gamma coefficients", "Subsection"],

Cell[BoxData[
    \(\( (*\ set\ the\ values\ of\ d\ and\ nmax\ *) \nd = 2; \ 
    nmax = \ 25\ \ \ ; \  (*\ for\ example\ *) \)\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(MemoryInUse[]\)], "Input"],

Cell[BoxData[
    \(958816\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Timing[printgamma[d,nmax,$MachinePrecision,$MachinePrecision,True,\
True]]\
\>", "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    \("   "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gamma["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["90.`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gamma[", 2, ",", 0, ",", 1, "]=", 90.0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["90.`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gammaexact[", 2, ",", 0, ",", 1, "]=", 90.0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        InterpretationBox["\[Infinity]",
          DirectedInfinity[ 1]]}],
      SequenceForm[ "exactdigits[", 2, ",", 0, ",", 1, "]=", 
        DirectedInfinity[ 1]],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gamma["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["7559.9999999999996`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gamma[", 2, ",", 0, ",", 2, "]=", 7560.0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["7559.9999999999996`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gammaexact[", 2, ",", 0, ",", 2, "]=", 7560.0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        InterpretationBox["\[Infinity]",
          DirectedInfinity[ 1]]}],
      SequenceForm[ "exactdigits[", 2, ",", 0, ",", 2, "]=", 
        DirectedInfinity[ 1]],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gamma["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["83159.9999999999894`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gamma[", 2, ",", 0, ",", 3, "]=", 83160.0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["83159.9999999999894`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gammaexact[", 2, ",", 0, ",", 3, "]=", 83160.0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        InterpretationBox["\[Infinity]",
          DirectedInfinity[ 1]]}],
      SequenceForm[ "exactdigits[", 2, ",", 0, ",", 3, "]=", 
        DirectedInfinity[ 1]],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gamma["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "4", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["450450.000000000017`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gamma[", 2, ",", 0, ",", 4, "]=", 450450.00000000006],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "4", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["450450.000000000017`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gammaexact[", 2, ",", 0, ",", 4, "]=", 450450.0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "4", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["15.2350198525753599`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 2, ",", 0, ",", 4, "]=", 15.235019852575359],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gamma["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "5", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["1.67076000000000419`*^6",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gamma[", 2, ",", 0, ",", 5, "]=", 1670760.0000000042],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "5", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["1.67076000000000002`*^6",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gammaexact[", 2, ",", 0, ",", 5, "]=", 1670760.0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "5", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["14.3776873561440909`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 2, ",", 0, ",", 5, "]=", 14.37768735614409],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gamma["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "6", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["4.8837600000013337`*^6",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gamma[", 2, ",", 0, ",", 6, "]=", 4883760.0000013337],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "6", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["4.88376000000000054`*^6",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gammaexact[", 2, ",", 0, ",", 6, "]=", 4883760.0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "6", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["11.8749568519475978`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 2, ",", 0, ",", 6, "]=", 11.874956851947598],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gamma["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "7", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["1.21136400000315136`*^7",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gamma[", 2, ",", 0, ",", 7, "]=", 12113640.000031514],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "7", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["1.2113640000000001`*^7",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gammaexact[", 2, ",", 0, ",", 7, "]=", 12113640.0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "7", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["11.5014951838335477`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 2, ",", 0, ",", 7, "]=", 11.501495183833548],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gamma["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "8", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["2.66408999999759021`*^7",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gamma[", 2, ",", 0, ",", 8, "]=", 26640899.999975901],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "8", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["2.66408999999999984`*^7",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gammaexact[", 2, ",", 0, ",", 8, "]=", 26640900.0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "8", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["11.6180027274509845`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 2, ",", 0, ",", 8, "]=", 11.618002727450985],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gamma["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "9", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["5.34397499899704531`*^7",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gamma[", 2, ",", 0, ",", 9, "]=", 53439749.989970446],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "9", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["5.34397500000000036`*^7",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gammaexact[", 2, ",", 0, ",", 9, "]=", 53439750.0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "9", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["8.99871836311357675`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 2, ",", 0, ",", 9, "]=", 8.9987183631135768],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gamma["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "10", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["9.96811198002977683`*^7",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gamma[", 2, ",", 0, ",", 10, "]=", 99681119.800297767],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "10", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["9.96811199999999963`*^7",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gammaexact[", 2, ",", 0, ",", 10, "]=", 99681120.0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "10", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["7.69961707880879764`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 2, ",", 0, ",", 10, "]=", 7.6996170788087976],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gamma["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "11", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["1.75301277168312763`*^8",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gamma[", 2, ",", 0, ",", 11, "]=", 175301277.16831279],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "11", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["1.75301279999999977`*^8",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gammaexact[", 2, ",", 0, ",", 11, "]=", 175301280.0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "11", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["7.54795472047692683`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 2, ",", 0, ",", 11, "]=", 7.5479547204769268],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gamma["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "12", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["2.9363603378901244`*^8",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gamma[", 2, ",", 0, ",", 12, "]=", 293636033.78901249],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "12", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["2.93636070000000017`*^8",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gammaexact[", 2, ",", 0, ",", 12, "]=", 293636070.0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "12", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["6.44115963139518665`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 2, ",", 0, ",", 12, "]=", 6.4411596313951867],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gamma["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "13", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["4.72120328584714421`*^8",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gamma[", 2, ",", 0, ",", 13, "]=", 472120328.58471435],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "13", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["4.72120739999999994`*^8",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gammaexact[", 2, ",", 0, ",", 13, "]=", 472120740.0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "13", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["5.38571957664522393`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 2, ",", 0, ",", 13, "]=", 5.3857195766452239],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gamma["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "14", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["7.33051435193249734`*^8",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gamma[", 2, ",", 0, ",", 14, "]=", 733051435.1932497],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "14", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["7.33055399999999934`*^8",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gammaexact[", 2, ",", 0, ",", 14, "]=", 733055400.0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "14", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["4.40177797589359975`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 2, ",", 0, ",", 14, "]=", 4.4017779758935998],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gamma["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "15", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["1.1044045685348347`*^9",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gamma[", 2, ",", 0, ",", 15, "]=", 1104404568.5348349],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "15", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["1.10443607999999993`*^9",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gammaexact[", 2, ",", 0, ",", 15, "]=", 1104436080.0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "15", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["4.50153140328930412`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 2, ",", 0, ",", 15, "]=", 4.5015314032893041],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gamma["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "16", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["1.62065022107199823`*^9",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gamma[", 2, ",", 0, ",", 16, "]=", 1620650221.0719981],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "16", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["1.62085140000000009`*^9",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gammaexact[", 2, ",", 0, ",", 16, "]=", 1620851400.0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "16", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["3.69641751035449317`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 2, ",", 0, ",", 16, "]=", 3.6964175103544932],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gamma["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "17", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["2.32348098636453759`*^9",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gamma[", 2, ",", 0, ",", 17, "]=", 2323480986.3645372],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "17", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["2.32444484999999989`*^9",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gammaexact[", 2, ",", 0, ",", 17, "]=", 2324444850.0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "17", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["3.01598440443239201`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 2, ",", 0, ",", 17, "]=", 3.015984404432392],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gamma["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "18", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["3.26343105984141024`*^9",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gamma[", 2, ",", 0, ",", 18, "]=", 3263431059.8414102],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "18", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["3.26594267999999976`*^9",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gammaexact[", 2, ",", 0, ",", 18, "]=", 3265942680.0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "18", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["2.60004603989574167`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 2, ",", 0, ",", 18, "]=", 2.6000460398957417],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gamma["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "19", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["4.51573048191326442`*^9",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gamma[", 2, ",", 0, ",", 19, "]=", 4515730481.9132643],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "19", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["4.50574739999999973`*^9",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gammaexact[", 2, ",", 0, ",", 19, "]=", 4505747400.0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "19", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["2.00073536539569296`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 2, ",", 0, ",", 19, "]=", 2.000735365395693],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gamma["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "20", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["6.31127993168357726`*^9",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gamma[", 2, ",", 0, ",", 20, "]=", 6311279931.6835775],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "20", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["6.11509688999999934`*^9",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gammaexact[", 2, ",", 0, ",", 20, "]=", 6115096890.0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "20", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["0.707338536311581833`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 2, ",", 0, ",", 20, "]=", 0.70733853631158183],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gamma["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "21", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["9.93420450263947429`*^9",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gamma[", 2, ",", 0, ",", 21, "]=", 9934204502.639473],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "21", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["8.1772891199999993`*^9",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gammaexact[", 2, ",", 0, ",", 21, "]=", 8177289120.0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "21", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        RowBox[{"-", 
          StyleBox["0.244750845309924969`",
            StyleBoxAutoDelete->True,
            PrintPrecision->2]}]}],
      SequenceForm[ 
      "exactdigits[", 2, ",", 0, ",", 21, "]=", -0.24475084530992497],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gamma["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "22", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["2.5693452863627213`*^10",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gamma[", 2, ",", 0, ",", 22, "]=", 25693452863.627213],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "22", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["1.07889724799999986`*^10",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gammaexact[", 2, ",", 0, ",", 22, "]=", 10788972480.0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "22", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        RowBox[{"-", 
          StyleBox["0.173316839781122666`",
            StyleBoxAutoDelete->True,
            PrintPrecision->2]}]}],
      SequenceForm[ 
      "exactdigits[", 2, ",", 0, ",", 22, "]=", -0.17331683978112267],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gamma["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "23", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["1.29838012224216981`*^11",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gamma[", 2, ",", 0, ",", 23, "]=", 129838012224.217],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "23", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["1.40615017200000007`*^10",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gammaexact[", 2, ",", 0, ",", 23, "]=", 14061501720.0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "23", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        RowBox[{"-", 
          StyleBox["0.0636204558232780215`",
            StyleBoxAutoDelete->True,
            PrintPrecision->2]}]}],
      SequenceForm[ 
      "exactdigits[", 2, ",", 0, ",", 23, "]=", -0.063620455823278022],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gamma["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "24", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["2.75396783898238073`*^11",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gamma[", 2, ",", 0, ",", 24, "]=", 275396783898.23804],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "24", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["1.81223594999999999`*^10",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gammaexact[", 2, ",", 0, ",", 24, "]=", 18122359500.0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "24", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        RowBox[{"-", 
          StyleBox["0.410396615223996619`",
            StyleBoxAutoDelete->True,
            PrintPrecision->2]}]}],
      SequenceForm[ 
      "exactdigits[", 2, ",", 0, ",", 24, "]=", -0.41039661522399662],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    \("   "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gamma["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["9.`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gamma[", 2, ",", 1, ",", 1, "]=", 9.0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["9.`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gammaexact[", 2, ",", 1, ",", 1, "]=", 9.0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        InterpretationBox["\[Infinity]",
          DirectedInfinity[ 1]]}],
      SequenceForm[ "exactdigits[", 2, ",", 1, ",", 1, "]=", 
        DirectedInfinity[ 1]],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gamma["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["450.`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gamma[", 2, ",", 1, ",", 2, "]=", 450.0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["450.`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gammaexact[", 2, ",", 1, ",", 2, "]=", 450.0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        InterpretationBox["\[Infinity]",
          DirectedInfinity[ 1]]}],
      SequenceForm[ "exactdigits[", 2, ",", 1, ",", 2, "]=", 
        DirectedInfinity[ 1]],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gamma["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["3024.00000000000002`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gamma[", 2, ",", 1, ",", 3, "]=", 3024.0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["3024.00000000000002`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gammaexact[", 2, ",", 1, ",", 3, "]=", 3024.0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        InterpretationBox["\[Infinity]",
          DirectedInfinity[ 1]]}],
      SequenceForm[ "exactdigits[", 2, ",", 1, ",", 3, "]=", 
        DirectedInfinity[ 1]],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gamma["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "4", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["10889.9999999999996`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gamma[", 2, ",", 1, ",", 4, "]=", 10890.0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "4", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["10889.9999999999996`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gammaexact[", 2, ",", 1, ",", 4, "]=", 10890.0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "4", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        InterpretationBox["\[Infinity]",
          DirectedInfinity[ 1]]}],
      SequenceForm[ "exactdigits[", 2, ",", 1, ",", 4, "]=", 
        DirectedInfinity[ 1]],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gamma["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "5", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["28664.9999999999991`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gamma[", 2, ",", 1, ",", 5, "]=", 28664.999999999996],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "5", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["28664.9999999999991`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gammaexact[", 2, ",", 1, ",", 5, "]=", 28665.0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "5", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["15.439139835231284`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 2, ",", 1, ",", 5, "]=", 15.439139835231284],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gamma["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "6", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["62423.9999999999195`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gamma[", 2, ",", 1, ",", 6, "]=", 62423.99999999992],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "6", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["62423.9999999999994`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gammaexact[", 2, ",", 1, ",", 6, "]=", 62424.0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "6", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["14.0967171544090774`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 2, ",", 1, ",", 6, "]=", 14.096717154409077],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gamma["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "7", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["119700.000000003337`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gamma[", 2, ",", 1, ",", 7, "]=", 119700.00000000335],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "7", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["119700.000000000006`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gammaexact[", 2, ",", 1, ",", 7, "]=", 119700.0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "7", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["13.475352007885728`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 2, ",", 1, ",", 7, "]=", 13.475352007885729],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gamma["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "8", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["209484.000000272452`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gamma[", 2, ",", 1, ",", 8, "]=", 209484.00000027244],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "8", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["209484.000000000003`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gammaexact[", 2, ",", 1, ",", 8, "]=", 209484.0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "8", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["11.5647276029965295`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 2, ",", 1, ",", 8, "]=", 11.564727602996529],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gamma["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "9", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["342225.000004055113`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gamma[", 2, ",", 1, ",", 9, "]=", 342225.00000405509],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "9", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["342225.000000000001`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gammaexact[", 2, ",", 1, ",", 9, "]=", 342225.0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "9", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["10.3919989771319087`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 2, ",", 1, ",", 9, "]=", 10.391998977131909],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gamma["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "10", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["529830.000029174108`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gamma[", 2, ",", 1, ",", 10, "]=", 529830.00002917415],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "10", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["529830.000000000023`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gammaexact[", 2, ",", 1, ",", 10, "]=", 529830.0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "10", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["9.53500185823384072`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 2, ",", 1, ",", 10, "]=", 9.5350018582338407],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gamma["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "11", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["785664.000127767891`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gamma[", 2, ",", 1, ",", 11, "]=", 785664.00012776791],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "11", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["785663.999999999962`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gammaexact[", 2, ",", 1, ",", 11, "]=", 785664.0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "11", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["8.89357820523041375`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 2, ",", 1, ",", 11, "]=", 8.8935782052304138],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gamma["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "12", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["1.12454999856434256`*^6",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gamma[", 2, ",", 1, ",", 12, "]=", 1124549.9985643425],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "12", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["1.12454999999999993`*^6",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gammaexact[", 2, ",", 1, ",", 12, "]=", 1124550.0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "12", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["8.84294915667417136`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 2, ",", 1, ",", 12, "]=", 8.8429491566741714],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gamma["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "13", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["1.56276894991725301`*^6",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gamma[", 2, ",", 1, ",", 13, "]=", 1562768.9499172531],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "13", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["1.56276899999999985`*^6",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gammaexact[", 2, ",", 1, ",", 13, "]=", 1562769.0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "13", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["7.30031185935375326`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 2, ",", 1, ",", 13, "]=", 7.3003118593537533],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gamma["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "14", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["2.11805925878964274`*^6",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gamma[", 2, ",", 1, ",", 14, "]=", 2118059.2587896427],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "14", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["2.11805999999999983`*^6",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gammaexact[", 2, ",", 1, ",", 14, "]=", 2118060.0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "14", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["6.13005852070669376`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 2, ",", 1, ",", 14, "]=", 6.1300585207066938],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gamma["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "15", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["2.80961232831943839`*^6",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gamma[", 2, ",", 1, ",", 15, "]=", 2809612.3283194383],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "15", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["2.80961999999999978`*^6",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gammaexact[", 2, ",", 1, ",", 15, "]=", 2809620.0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "15", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["5.11510948888811167`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 2, ",", 1, ",", 15, "]=", 5.1151094888881117],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gamma["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "16", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["3.6580410777184511`*^6",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gamma[", 2, ",", 1, ",", 16, "]=", 3658041.0777184512],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "16", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["3.65810400000000024`*^6",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gammaexact[", 2, ",", 1, ",", 16, "]=", 3658104.0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "16", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["4.20119553833562697`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 2, ",", 1, ",", 16, "]=", 4.201195538335627],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gamma["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "17", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["4.68519558826225512`*^6",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gamma[", 2, ",", 1, ",", 17, "]=", 4685195.5882622553],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "17", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["4.68562499999999992`*^6",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gammaexact[", 2, ",", 1, ",", 17, "]=", 4685625.0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "17", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["3.36712608852557337`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 2, ",", 1, ",", 17, "]=", 3.3671260885255734],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gamma["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "18", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["5.91332013060775629`*^6",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gamma[", 2, ",", 1, ",", 18, "]=", 5913320.1306077568],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "18", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["5.91575399999999973`*^6",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gammaexact[", 2, ",", 1, ",", 18, "]=", 5915754.0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "18", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["2.61370273085121684`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 2, ",", 1, ",", 18, "]=", 2.6137027308512168],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gamma["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "19", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["7.36302260779444583`*^6",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gamma[", 2, ",", 1, ",", 19, "]=", 7363022.607794445],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "19", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["7.37352000000000096`*^6",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gammaexact[", 2, ",", 1, ",", 19, "]=", 7373520.0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "19", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["1.97891857630164569`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 2, ",", 1, ",", 19, "]=", 1.9789185763016457],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gamma["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "20", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["9.06408555330206766`*^6",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gamma[", 2, ",", 1, ",", 20, "]=", 9064085.5533020664],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "20", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["9.08540999999999954`*^6",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gammaexact[", 2, ",", 1, ",", 20, "]=", 9085410.0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "20", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["1.67112222858490344`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 2, ",", 1, ",", 20, "]=", 1.6711222285849034],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gamma["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "21", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["1.12329020962008807`*^7",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gamma[", 2, ",", 1, ",", 21, "]=", 11232902.096200882],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "21", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["1.10793689999999989`*^7",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gammaexact[", 2, ",", 1, ",", 21, "]=", 11079369.0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "21", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["1.81379799186041434`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 2, ",", 1, ",", 21, "]=", 1.8137979918604143],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gamma["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "22", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["1.53662180476647458`*^7",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gamma[", 2, ",", 1, ",", 22, "]=", 15366218.047664745],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "22", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["1.33848000000000011`*^7",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gammaexact[", 2, ",", 1, ",", 22, "]=", 13384800.0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "22", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["0.703023885572037876`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 2, ",", 1, ",", 22, "]=", 0.70302388557203788],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gamma["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "23", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["2.3652963239473963`*^7",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gamma[", 2, ",", 1, ",", 23, "]=", 23652963.239473961],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "23", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["1.60325640000000007`*^7",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gammaexact[", 2, ",", 1, ",", 23, "]=", 16032564.0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "23", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["0.118022274991311348`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 2, ",", 1, ",", 23, "]=", 0.11802227499131135],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gamma["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "24", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["7.96716213569451081`*^6",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gamma[", 2, ",", 1, ",", 24, "]=", 7967162.1356945112],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "24", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["1.90549800000000004`*^7",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gammaexact[", 2, ",", 1, ",", 24, "]=", 19054980.0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "24", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        RowBox[{"-", 
          StyleBox["1.04484608332321737`",
            StyleBoxAutoDelete->True,
            PrintPrecision->2]}]}],
      SequenceForm[ 
      "exactdigits[", 2, ",", 1, ",", 24, "]=", -1.0448460833232174],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gamma["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "25", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["5.74267718258754378`*^6",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gamma[", 2, ",", 1, ",", 25, "]=", 5742677.1825875435],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "25", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["2.24858249999999992`*^7",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gammaexact[", 2, ",", 1, ",", 25, "]=", 22485825.0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "25", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        RowBox[{"-", 
          StyleBox["1.22383711143587881`",
            StyleBoxAutoDelete->True,
            PrintPrecision->2]}]}],
      SequenceForm[ 
      "exactdigits[", 2, ",", 1, ",", 25, "]=", -1.2238371114358788],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    \({24.9666666666666703`\ Second, Null}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(MemoryInUse[]\)], "Input"],

Cell[BoxData[
    \(1169888\)], "Output"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Computing the beta coefficients", "Subsection"],

Cell[BoxData[
    \(\( (*\ set\ the\ values\ of\ d\ and\ nmax\ *) \nd = 2; \ nmax = \ 25\ ; 
    \ \ \ \  (*\ for\ example\ *) \)\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(MemoryInUse[]\)], "Input"],

Cell[BoxData[
    \(1171672\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Timing[printbeta[d,nmax,$MachinePrecision,$MachinePrecision,True,\
True]]\
\>", "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("beta["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["1.`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "beta[", 2, ",", 0, "]=", 1.0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("betaexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["1.`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "betaexact[", 2, ",", 0, "]=", 1.0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        InterpretationBox["\[Infinity]",
          DirectedInfinity[ 1]]}],
      SequenceForm[ "exactdigits[", 2, ",", 0, "]=", 
        DirectedInfinity[ 1]],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("beta["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["19.`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "beta[", 2, ",", 1, "]=", 19.0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("betaexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["19.`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "betaexact[", 2, ",", 1, "]=", 19.0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        InterpretationBox["\[Infinity]",
          DirectedInfinity[ 1]]}],
      SequenceForm[ "exactdigits[", 2, ",", 1, "]=", 
        DirectedInfinity[ 1]],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("beta["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["64.0000000000000035`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "beta[", 2, ",", 2, "]=", 64.0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("betaexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["64.0000000000000035`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "betaexact[", 2, ",", 2, "]=", 64.0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        InterpretationBox["\[Infinity]",
          DirectedInfinity[ 1]]}],
      SequenceForm[ "exactdigits[", 2, ",", 2, "]=", 
        DirectedInfinity[ 1]],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("beta["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["135.999999999999987`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "beta[", 2, ",", 3, "]=", 136.0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("betaexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["135.999999999999987`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "betaexact[", 2, ",", 3, "]=", 136.0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        InterpretationBox["\[Infinity]",
          DirectedInfinity[ 1]]}],
      SequenceForm[ "exactdigits[", 2, ",", 3, "]=", 
        DirectedInfinity[ 1]],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("beta["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "4", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["235.000000000000008`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "beta[", 2, ",", 4, "]=", 235.0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("betaexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "4", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["235.000000000000008`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "betaexact[", 2, ",", 4, "]=", 235.0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "4", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        InterpretationBox["\[Infinity]",
          DirectedInfinity[ 1]]}],
      SequenceForm[ "exactdigits[", 2, ",", 4, "]=", 
        DirectedInfinity[ 1]],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("beta["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "5", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["361.000000000000031`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "beta[", 2, ",", 5, "]=", 361.0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("betaexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["361.000000000000031`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "betaexact[", 2, ",", 5, "]=", 361.0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        InterpretationBox["\[Infinity]",
          DirectedInfinity[ 1]]}],
      SequenceForm[ "exactdigits[", 2, ",", 5, "]=", 
        DirectedInfinity[ 1]],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("beta["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "6", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["513.999999999989753`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "beta[", 2, ",", 6, "]=", 513.99999999998977],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("betaexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "6", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["513.999999999999968`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "betaexact[", 2, ",", 6, "]=", 514.0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "6", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["12.9900473041118647`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ "exactdigits[", 2, ",", 6, "]=", 12.990047304111865],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("beta["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "7", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["693.99999999972497`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "beta[", 2, ",", 7, "]=", 693.99999999972488],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("betaexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "7", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["694.000000000000039`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "betaexact[", 2, ",", 7, "]=", 694.0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "7", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["11.5604744475707588`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ "exactdigits[", 2, ",", 7, "]=", 11.560474447570758],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("beta["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "8", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["900.999999997656964`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "beta[", 2, ",", 8, "]=", 900.99999999765703],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("betaexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "8", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["900.999999999999978`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "betaexact[", 2, ",", 8, "]=", 901.0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "8", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["10.6302328943104673`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ "exactdigits[", 2, ",", 8, "]=", 10.630232894310467],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("beta["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "9", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["1135.0000000013154`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "beta[", 2, ",", 9, "]=", 1135.0000000013154],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("betaexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "9", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["1135.`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "betaexact[", 2, ",", 9, "]=", 1135.0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "9", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["11.8809564545994405`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ "exactdigits[", 2, ",", 9, "]=", 11.88095645459944],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("beta["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "10", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["1396.00000017423496`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "beta[", 2, ",", 10, "]=", 1396.0000001742349],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("betaexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "10", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["1395.9999999999999`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "betaexact[", 2, ",", 10, "]=", 1396.0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "10", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["9.75886495954344113`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ "exactdigits[", 2, ",", 10, "]=", 9.7588649595434411],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("beta["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "11", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["1684.00000237782343`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "beta[", 2, ",", 11, "]=", 1684.0000023778234],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("betaexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "11", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["1683.99999999999998`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "betaexact[", 2, ",", 11, "]=", 1684.0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "11", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["8.62382039959402391`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ "exactdigits[", 2, ",", 11, "]=", 8.6238203995940239],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("beta["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "12", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["1999.000029242357`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "beta[", 2, ",", 12, "]=", 1999.0000292423572],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("betaexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "12", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["1999.00000000000019`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "betaexact[", 2, ",", 12, "]=", 1999.0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "12", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["7.53398762241954855`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ "exactdigits[", 2, ",", 12, "]=", 7.5339876224195486],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("beta["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "13", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["2341.00031037442368`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "beta[", 2, ",", 13, "]=", 2341.0003103744239],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("betaexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "13", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["2341.00000000000019`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "betaexact[", 2, ",", 13, "]=", 2341.0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "13", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["6.50811407360411919`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ "exactdigits[", 2, ",", 13, "]=", 6.5081140736041192],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("beta["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "14", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["2710.00268188725979`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "beta[", 2, ",", 14, "]=", 2710.0026818872598],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("betaexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "14", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["2709.99999999999996`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "betaexact[", 2, ",", 14, "]=", 2710.0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "14", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["5.571559482819044`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ "exactdigits[", 2, ",", 14, "]=", 5.571559482819044],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("beta["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "15", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["3106.01905854786419`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "beta[", 2, ",", 15, "]=", 3106.019058547864],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("betaexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "15", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["3106.00000000000031`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "betaexact[", 2, ",", 15, "]=", 3106.0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "15", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["4.71991019282017099`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ "exactdigits[", 2, ",", 15, "]=", 4.719910192820171],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("beta["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "16", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["3529.11334470752757`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "beta[", 2, ",", 16, "]=", 3529.1133447075276],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("betaexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "16", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["3528.99999999999991`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "betaexact[", 2, ",", 16, "]=", 3529.0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "16", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["3.94559875383660063`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ "exactdigits[", 2, ",", 16, "]=", 3.9455987538366006],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("beta["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "17", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["3979.56405326474182`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "beta[", 2, ",", 17, "]=", 3979.5640532647417],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("betaexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "17", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["3979.00000000000009`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "betaexact[", 2, ",", 17, "]=", 3979.0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "17", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["3.24867988273451047`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ "exactdigits[", 2, ",", 17, "]=", 3.2486798827345105],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("beta["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "18", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["4458.22028262231917`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "beta[", 2, ",", 18, "]=", 4458.2202826223192],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("betaexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "18", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["4456.0000000000004`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "betaexact[", 2, ",", 18, "]=", 4456.0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "18", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["2.65359174018835286`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ "exactdigits[", 2, ",", 18, "]=", 2.6535917401883529],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("beta["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "19", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["4965.14290546259307`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "beta[", 2, ",", 19, "]=", 4965.1429054625933],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("betaexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "19", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["4959.99999999999996`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "betaexact[", 2, ",", 19, "]=", 4960.0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "19", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["2.28879145885048984`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ "exactdigits[", 2, ",", 19, "]=", 2.2887914588504898],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("beta["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "20", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["5476.83786546926576`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "beta[", 2, ",", 20, "]=", 5476.8378654692651],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("betaexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "20", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["5491.00000000000054`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "betaexact[", 2, ",", 20, "]=", 5491.0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "20", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["1.84887128442479475`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ "exactdigits[", 2, ",", 20, "]=", 1.8488712844247948],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("beta["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "21", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["5787.55102409488131`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "beta[", 2, ",", 21, "]=", 5787.5510240948815],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("betaexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "21", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["6048.99999999999948`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "betaexact[", 2, ",", 21, "]=", 6049.0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "21", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["0.582613054961222065`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ "exactdigits[", 2, ",", 21, "]=", 0.58261305496122207],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("beta["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "22", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["4979.28867179902834`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "beta[", 2, ",", 22, "]=", 4979.2886717990286],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("betaexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "22", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["6634.00000000000034`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "betaexact[", 2, ",", 22, "]=", 6634.0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "22", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        RowBox[{"-", 
          StyleBox["0.218722240103086384`",
            StyleBoxAutoDelete->True,
            PrintPrecision->2]}]}],
      SequenceForm[ "exactdigits[", 2, ",", 22, "]=", -0.21872224010308638],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("beta["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "23", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["2785.63126227484536`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "beta[", 2, ",", 23, "]=", 2785.6312622748451],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("betaexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "23", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["7246.00000000000044`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "betaexact[", 2, ",", 23, "]=", 7246.0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "23", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        RowBox[{"-", 
          StyleBox["0.649370763227774094`",
            StyleBoxAutoDelete->True,
            PrintPrecision->2]}]}],
      SequenceForm[ "exactdigits[", 2, ",", 23, "]=", -0.64937076322777409],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("beta["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "24", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["5280.60405407131661`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "beta[", 2, ",", 24, "]=", 5280.6040540713175],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("betaexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "24", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["7884.99999999999978`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "betaexact[", 2, ",", 24, "]=", 7885.0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "24", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        RowBox[{"-", 
          StyleBox["0.415707010641157115`",
            StyleBoxAutoDelete->True,
            PrintPrecision->2]}]}],
      SequenceForm[ "exactdigits[", 2, ",", 24, "]=", -0.41570701064115712],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    \({12.6000000000000222`\ Second, Null}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(MemoryInUse[]\)], "Input"],

Cell[BoxData[
    \(1175864\)], "Output"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Computing the d-orthogonal polynomials", "Subsection"],

Cell[BoxData[
    \(\( (*\ set\ the\ values\ of\ d\ and\ nmax\ *) \nd = 2; \ 
    nmax = \ 25\ \ \ ; \ \  (*\ for\ example\ *) \)\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(MemoryInUse[]\)], "Input"],

Cell[BoxData[
    \(1177648\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Timing[printdorthpoly[d,nmax,x,$MachinePrecision]]", "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("dorthpoly["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "x", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["1.`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "dorthpoly[", 2, ",", 0, ",", x, "]=", 1.0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("dorthpoly["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "x", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        RowBox[{
          RowBox[{"-", 
            StyleBox["1.`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16]}], "+", "x"}]}],
      SequenceForm[ "dorthpoly[", 2, ",", 1, ",", x, "]=", 
        Plus[ -1.0, x]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("dorthpoly["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "x", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        RowBox[{
          RowBox[{
            StyleBox["10.`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], "\[InvisibleSpace]"}], "-", 
          RowBox[{
            StyleBox["20.`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", "x"}], "+", \(x\^2\)}]}],
      SequenceForm[ "dorthpoly[", 2, ",", 2, ",", x, "]=", 
        Plus[ 10.0, 
          Times[ -20.0, x], 
          Power[ x, 2]]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("dorthpoly["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "x", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        RowBox[{
          RowBox[{"-", 
            StyleBox["279.999999999999982`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16]}], "+", 
          RowBox[{
            StyleBox["840.000000000000035`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", "x"}], "-", 
          RowBox[{
            StyleBox["84.0000000000000035`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^2\)}], "+", \(x\^3\)}]}],
      SequenceForm[ "dorthpoly[", 2, ",", 3, ",", x, "]=", 
        Plus[ -280.0, 
          Times[ 840.0, x], 
          Times[ -84.0, 
            Power[ x, 2]], 
          Power[ x, 3]]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("dorthpoly["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "4", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "x", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        RowBox[{
          RowBox[{
            StyleBox["15400.0000000000003`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], "\[InvisibleSpace]"}], "-", 
          RowBox[{
            StyleBox["61600.0000000000014`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", "x"}], "+", 
          RowBox[{
            StyleBox["9240.00000000000021`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^2\)}], "-", 
          RowBox[{
            StyleBox["220.000000000000017`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^3\)}], "+", \(x\^4\)}]}],
      SequenceForm[ "dorthpoly[", 2, ",", 4, ",", x, "]=", 
        Plus[ 15400.0, 
          Times[ -61600.0, x], 
          Times[ 9240.0, 
            Power[ x, 2]], 
          Times[ -220.0, 
            Power[ x, 3]], 
          Power[ x, 4]]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("dorthpoly["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "x", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        RowBox[{
          RowBox[{"-", 
            StyleBox["1.40139999999999993`*^6",
              StyleBoxAutoDelete->True,
              PrintPrecision->16]}], "+", 
          RowBox[{
            StyleBox["7.00699999999999967`*^6",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", "x"}], "-", 
          RowBox[{
            StyleBox["1.40139999999999993`*^6",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^2\)}], "+", 
          RowBox[{
            StyleBox["50049.9999999999989`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^3\)}], "-", 
          RowBox[{
            StyleBox["454.999999999999982`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^4\)}], "+", \(x\^5\)}]}],
      SequenceForm[ "dorthpoly[", 2, ",", 5, ",", x, "]=", 
        Plus[ -1401400.0, 
          Times[ 7007000.0, x], 
          Times[ -1401400.0, 
            Power[ x, 2]], 
          Times[ 50050.0, 
            Power[ x, 3]], 
          Times[ -455.0, 
            Power[ x, 4]], 
          Power[ x, 5]]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("dorthpoly["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "6", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "x", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        RowBox[{
          StyleBox["1.90590400000000066`*^8",
            StyleBoxAutoDelete->True,
            PrintPrecision->16], "-", 
          RowBox[{
            StyleBox["1.14354240000000029`*^9",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", "x"}], "+", 
          RowBox[{
            StyleBox["2.85885600000000028`*^8",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^2\)}], "-", 
          RowBox[{
            StyleBox["1.3613599999999999`*^7",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^3\)}], "+", 
          RowBox[{
            StyleBox["185640.`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^4\)}], "-", 
          RowBox[{
            StyleBox["816.000000000000014`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^5\)}], "+", \(x\^6\)}]}],
      SequenceForm[ "dorthpoly[", 2, ",", 6, ",", x, "]=", 
        Plus[ 190590400.00000006, 
          Times[ -1143542400.0000002, x], 
          Times[ 285885600.0, 
            Power[ x, 2]], 
          Times[ -13613600.0, 
            Power[ x, 3]], 
          Times[ 185640.0, 
            Power[ x, 4]], 
          Times[ -816.0, 
            Power[ x, 5]], 
          Power[ x, 6]]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("dorthpoly["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "7", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "x", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        RowBox[{
          RowBox[{"-", 
            StyleBox["3.62121759999982417`*^10",
              StyleBoxAutoDelete->True,
              PrintPrecision->16]}], "+", 
          RowBox[{
            StyleBox["2.5348523199998918`*^11",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", "x"}], "-", 
          RowBox[{
            StyleBox["7.60455695999972025`*^10",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^2\)}], "+", 
          RowBox[{
            StyleBox["4.52652199999986493`*^9",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^3\)}], "-", 
          RowBox[{
            StyleBox["8.23003999999981417`*^7",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^4\)}], "+", 
          RowBox[{
            StyleBox["542639.999999991751`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^5\)}], "-", 
          RowBox[{
            StyleBox["1329.99999999998985`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^6\)}], "+", \(x\^7\)}]}],
      SequenceForm[ "dorthpoly[", 2, ",", 7, ",", x, "]=", 
        Plus[ -36212175999.998245, 
          Times[ 253485231999.9892, x], 
          Times[ -76045569599.997208, 
            Power[ x, 2]], 
          Times[ 4526521999.9998655, 
            Power[ x, 3]], 
          Times[ -82300399.999998152, 
            Power[ x, 4]], 
          Times[ 542639.99999999173, 
            Power[ x, 5]], 
          Times[ -1329.9999999999898, 
            Power[ x, 6]], 
          Power[ x, 7]]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("dorthpoly["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "8", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "x", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        RowBox[{
          StyleBox["9.16168052799004506`*^12",
            StyleBoxAutoDelete->True,
            PrintPrecision->16], "-", 
          RowBox[{
            StyleBox["7.32934442239282368`*^13",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", "x"}], "+", 
          RowBox[{
            StyleBox["2.56527054783780483`*^13",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^2\)}], "-", 
          RowBox[{
            StyleBox["1.83233610559867976`*^12",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^3\)}], "+", 
          RowBox[{
            StyleBox["4.16440023999759212`*^10",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^4\)}], "-", 
          RowBox[{
            StyleBox["3.66101119999841717`*^8",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^5\)}], "+", 
          RowBox[{
            StyleBox["1.34595999999961546`*^6",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^6\)}], "-", 
          RowBox[{
            StyleBox["2023.99999999971447`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^7\)}], "+", \(x\^8\)}]}],
      SequenceForm[ "dorthpoly[", 2, ",", 8, ",", x, "]=", 
        Plus[ 9161680527990.0449, 
          Times[ -73293444223928.234, x], 
          Times[ 25652705478378.047, 
            Power[ x, 2]], 
          Times[ -1832336105598.6794, 
            Power[ x, 3]], 
          Times[ 41644002399.975922, 
            Power[ x, 4]], 
          Times[ -366101119.99984169, 
            Power[ x, 5]], 
          Times[ 1345959.9999996154, 
            Power[ x, 6]], 
          Times[ -2023.9999999997146, 
            Power[ x, 7]], 
          Power[ x, 8]]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("dorthpoly["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "9", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "x", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        RowBox[{
          RowBox[{"-", 
            StyleBox["2.97754617156607395`*^15",
              StyleBoxAutoDelete->True,
              PrintPrecision->16]}], "+", 
          RowBox[{
            StyleBox["2.67979155441328531`*^16",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", "x"}], "-", 
          RowBox[{
            StyleBox["1.07191662176689206`*^16",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^2\)}], "+", 
          RowBox[{
            StyleBox["8.93263851473718872`*^14",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^3\)}], "-", 
          RowBox[{
            StyleBox["2.43617414038632285`*^13",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^4\)}], "+", 
          RowBox[{
            StyleBox["2.67711443998855092`*^11",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^5\)}], "-", 
          RowBox[{
            StyleBox["1.31231099999601297`*^9",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^6\)}], "+", 
          RowBox[{
            StyleBox["2.96009999999434381`*^6",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^7\)}], "-", 
          RowBox[{
            StyleBox["2924.9999999973717`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^8\)}], "+", \(x\^9\)}]}],
      SequenceForm[ "dorthpoly[", 2, ",", 9, ",", x, "]=", 
        Plus[ -2977546171566074.0, 
          Times[ 26797915544132848.0, x], 
          Times[ -10719166217668920.0, 
            Power[ x, 2]], 
          Times[ 893263851473719.0, 
            Power[ x, 3]], 
          Times[ -24361741403863.23, 
            Power[ x, 4]], 
          Times[ 267711443998.85507, 
            Power[ x, 5]], 
          Times[ -1312310999.9960129, 
            Power[ x, 6]], 
          Times[ 2960099.9999943436, 
            Power[ x, 7]], 
          Times[ -2924.9999999973716, 
            Power[ x, 8]], 
          Power[ x, 9]]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("dorthpoly["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "10", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "x", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        RowBox[{
          StyleBox["1.20888374560034583`*^18",
            StyleBoxAutoDelete->True,
            PrintPrecision->16], "-", 
          RowBox[{
            StyleBox["1.2088837456148942`*^19",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", "x"}], "+", 
          RowBox[{
            StyleBox["5.43997685532523878`*^18",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^2\)}], "-", 
          RowBox[{
            StyleBox["5.18093033845263839`*^17",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^3\)}], "+", 
          RowBox[{
            StyleBox["1.64847783497478701`*^16",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^4\)}], "-", 
          RowBox[{
            StyleBox["2.17381692525472169`*^14",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^5\)}], "+", 
          RowBox[{
            StyleBox["1.33199566499069743`*^12",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^6\)}], "-", 
          RowBox[{
            StyleBox["4.00600199998535266`*^9",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^7\)}], "+", 
          RowBox[{
            StyleBox["5.93774999999115227`*^6",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^8\)}], "-", 
          RowBox[{
            StyleBox["4059.99999999868688`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^9\)}], "+", \(x\^10\)}]}],
      SequenceForm[ "dorthpoly[", 2, ",", 10, ",", x, "]=", 
        Plus[ 1.2088837456003461*^+18, 
          Times[ -1.2088837456148943*^+19, x], 
          Times[ 5.4399768553252383*^+18, 
            Power[ x, 2]], 
          Times[ -5.1809303384526374*^+17, 
            Power[ x, 3]], 
          Times[ 16484778349747870.0, 
            Power[ x, 4]], 
          Times[ -217381692525472.19, 
            Power[ x, 5]], 
          Times[ 1331995664990.6973, 
            Power[ x, 6]], 
          Times[ -4006001999.9853525, 
            Power[ x, 7]], 
          Times[ 5937749.9999911524, 
            Power[ x, 8]], 
          Times[ -4059.9999999986867, 
            Power[ x, 9]], 
          Power[ x, 10]]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("dorthpoly["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "11", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "x", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        RowBox[{
          RowBox[{"-", 
            StyleBox["5.99606337804761313`*^20",
              StyleBoxAutoDelete->True,
              PrintPrecision->16]}], "+", 
          RowBox[{
            StyleBox["6.59566971633667797`*^21",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", "x"}], "-", 
          RowBox[{
            StyleBox["3.29783485834863743`*^21",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^2\)}], "+", 
          RowBox[{
            StyleBox["3.53339449121992021`*^20",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^3\)}], "-", 
          RowBox[{
            StyleBox["1.28487072410823689`*^19",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^4\)}], "+", 
          RowBox[{
            StyleBox["1.97672419095298579`*^17",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^5\)}], "-", 
          RowBox[{
            StyleBox["1.45347366981487251`*^15",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^6\)}], "+", 
          RowBox[{
            StyleBox["5.46418672856455778`*^12",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^7\)}], "-", 
          RowBox[{
            StyleBox["1.07987880009135928`*^10",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^8\)}], "+", 
          RowBox[{
            StyleBox["1.10756800006675359`*^7",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^9\)}], "-", 
          RowBox[{
            StyleBox["5456.00000017292163`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^10\)}], "+", \(x\^11\)}]}],
      SequenceForm[ "dorthpoly[", 2, ",", 11, ",", x, "]=", 
        Plus[ -5.996063378047613*^+20, 
          Times[ 6.5956697163366777*^+21, x], 
          Times[ -3.2978348583486373*^+21, 
            Power[ x, 2]], 
          Times[ 3.5333944912199202*^+20, 
            Power[ x, 3]], 
          Times[ -1.2848707241082368*^+19, 
            Power[ x, 4]], 
          Times[ 1.9767241909529856*^+17, 
            Power[ x, 5]], 
          Times[ -1453473669814872.5, 
            Power[ x, 6]], 
          Times[ 5464186728564.5576, 
            Power[ x, 7]], 
          Times[ -10798788000.913593, 
            Power[ x, 8]], 
          Times[ 11075680.000667537, 
            Power[ x, 9]], 
          Times[ -5456.0000001729213, 
            Power[ x, 10]], 
          Power[ x, 11]]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("dorthpoly["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "12", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "x", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        RowBox[{
          StyleBox["3.56765771669964859`*^23",
            StyleBoxAutoDelete->True,
            PrintPrecision->16], "-", 
          RowBox[{
            StyleBox["4.28118926139270694`*^24",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", "x"}], "+", 
          RowBox[{
            StyleBox["2.35465409416256887`*^24",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^2\)}], "-", 
          RowBox[{
            StyleBox["2.80315963602788187`*^23",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^3\)}], "+", 
          RowBox[{
            StyleBox["1.14674712375964826`*^22",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^4\)}], "-", 
          RowBox[{
            StyleBox["2.01625867884648801`*^20",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^5\)}], "+", 
          RowBox[{
            StyleBox["1.72963367021606151`*^18",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^6\)}], "-", 
          RowBox[{
            StyleBox["7.80285866060242661`*^15",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^7\)}], "+", 
          RowBox[{
            StyleBox["1.92758366064445674`*^13",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^8\)}], "-", 
          RowBox[{
            StyleBox["2.63601184276563271`*^10",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^9\)}], "+", 
          RowBox[{
            StyleBox["1.94779200138043719`*^7",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^10\)}], "-", 
          RowBox[{
            StyleBox["7140.00000255074507`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^11\)}], "+", \(x\^12\)}]}],
      SequenceForm[ "dorthpoly[", 2, ",", 12, ",", x, "]=", 
        Plus[ 3.5676577166996487*^+23, 
          Times[ -4.2811892613927073*^+24, x], 
          Times[ 2.3546540941625688*^+24, 
            Power[ x, 2]], 
          Times[ -2.8031596360278823*^+23, 
            Power[ x, 3]], 
          Times[ 1.1467471237596483*^+22, 
            Power[ x, 4]], 
          Times[ -2.0162586788464879*^+20, 
            Power[ x, 5]], 
          Times[ 1.7296336702160614*^+18, 
            Power[ x, 6]], 
          Times[ -7802858660602426.0, 
            Power[ x, 7]], 
          Times[ 19275836606444.566, 
            Power[ x, 8]], 
          Times[ -26360118427.656326, 
            Power[ x, 9]], 
          Times[ 19477920.013804372, 
            Power[ x, 10]], 
          Times[ -7140.0000025507452, 
            Power[ x, 11]], 
          Power[ x, 12]]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("dorthpoly["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "13", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "x", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        RowBox[{
          RowBox[{"-", 
            StyleBox["2.50806346235171284`*^26",
              StyleBoxAutoDelete->True,
              PrintPrecision->16]}], "+", 
          RowBox[{
            StyleBox["3.26048249999351602`*^27",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", "x"}], "-", 
          RowBox[{
            StyleBox["1.95628949763118136`*^27",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^2\)}], "+", 
          RowBox[{
            StyleBox["2.56180767055454783`*^26",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^3\)}], "-", 
          RowBox[{
            StyleBox["1.16445802919285723`*^25",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^4\)}], "+", 
          RowBox[{
            StyleBox["2.30332356757921719`*^23",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^5\)}], "-", 
          RowBox[{
            StyleBox["2.25816035317702201`*^21",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^6\)}], "+", 
          RowBox[{
            StyleBox["1.1885054450107968`*^19",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^7\)}], "-", 
          RowBox[{
            StyleBox["3.52323747281365928`*^16",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^8\)}], "+", 
          RowBox[{
            StyleBox["6.02262813706148936`*^13",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^9\)}], "-", 
          RowBox[{
            StyleBox["5.93362375896383564`*^10",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^10\)}], "+", 
          RowBox[{
            StyleBox["3.26262302291294048`*^7",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^11\)}], "-", 
          RowBox[{
            StyleBox["9139.0000317931026`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^12\)}], "+", \(x\^13\)}]}],
      SequenceForm[ "dorthpoly[", 2, ",", 13, ",", x, "]=", 
        Plus[ -2.5080634623517127*^+26, 
          Times[ 3.2604824999935156*^+27, x], 
          Times[ -1.9562894976311815*^+27, 
            Power[ x, 2]], 
          Times[ 2.5618076705545474*^+26, 
            Power[ x, 3]], 
          Times[ -1.1644580291928572*^+25, 
            Power[ x, 4]], 
          Times[ 2.3033235675792171*^+23, 
            Power[ x, 5]], 
          Times[ -2.258160353177022*^+21, 
            Power[ x, 6]], 
          Times[ 1.1885054450107965*^+19, 
            Power[ x, 7]], 
          Times[ -35232374728136588.0, 
            Power[ x, 8]], 
          Times[ 60226281370614.891, 
            Power[ x, 9]], 
          Times[ -59336237589.638359, 
            Power[ x, 10]], 
          Times[ 32626230.2291294, 
            Power[ x, 11]], 
          Times[ -9139.0000317931026, 
            Power[ x, 12]], 
          Power[ x, 13]]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("dorthpoly["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "14", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "x", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        RowBox[{
          StyleBox["2.05661290889066616`*^29",
            StyleBoxAutoDelete->True,
            PrintPrecision->16], "-", 
          RowBox[{
            StyleBox["2.87925800006513412`*^30",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", "x"}], "+", 
          RowBox[{
            StyleBox["1.87151764538065989`*^30",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^2\)}], "-", 
          RowBox[{
            StyleBox["2.67359655023212683`*^29",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^3\)}], "+", 
          RowBox[{
            StyleBox["1.33679822940427728`*^28",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^4\)}], "-", 
          RowBox[{
            StyleBox["2.93801798253871346`*^26",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^5\)}], "+", 
          RowBox[{
            StyleBox["3.2404608934966701`*^24",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^6\)}], "-", 
          RowBox[{
            StyleBox["1.94914933931725542`*^22",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^7\)}], "+", 
          RowBox[{
            StyleBox["6.74112889699904371`*^19",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^8\)}], "-", 
          RowBox[{
            StyleBox["1.38279562261472822`*^17",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^9\)}], "+", 
          RowBox[{
            StyleBox["1.70295021578267169`*^14",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^10\)}], "-", 
          RowBox[{
            StyleBox["1.24849718409771281`*^11",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^11\)}], "+", 
          RowBox[{
            StyleBox["5.24578631901516523`*^7",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^12\)}], "-", 
          RowBox[{
            StyleBox["11480.0003421675267`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^13\)}], "+", \(x\^14\)}]}],
      SequenceForm[ "dorthpoly[", 2, ",", 14, ",", x, "]=", 
        Plus[ 2.056612908890666*^+29, 
          Times[ -2.8792580000651342*^+30, x], 
          Times[ 1.87151764538066*^+30, 
            Power[ x, 2]], 
          Times[ -2.6735965502321268*^+29, 
            Power[ x, 3]], 
          Times[ 1.3367982294042772*^+28, 
            Power[ x, 4]], 
          Times[ -2.9380179825387135*^+26, 
            Power[ x, 5]], 
          Times[ 3.2404608934966704*^+24, 
            Power[ x, 6]], 
          Times[ -1.9491493393172556*^+22, 
            Power[ x, 7]], 
          Times[ 6.7411288969990439*^+19, 
            Power[ x, 8]], 
          Times[ -1.382795622614728*^+17, 
            Power[ x, 9]], 
          Times[ 170295021578267.16, 
            Power[ x, 10]], 
          Times[ -124849718409.77129, 
            Power[ x, 11]], 
          Times[ 52457863.190151662, 
            Power[ x, 12]], 
          Times[ -11480.000342167526, 
            Power[ x, 13]], 
          Power[ x, 14]]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("dorthpoly["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "15", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "x", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        RowBox[{
          RowBox[{"-", 
            StyleBox["1.94556319411764029`*^32",
              StyleBoxAutoDelete->True,
              PrintPrecision->16]}], "+", 
          RowBox[{
            StyleBox["2.91834389690195816`*^33",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", "x"}], "-", 
          RowBox[{
            StyleBox["2.04284007748969642`*^33",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^2\)}], "+", 
          RowBox[{
            StyleBox["3.16153719044790282`*^32",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^3\)}], "-", 
          RowBox[{
            StyleBox["1.72447427099916295`*^31",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^4\)}], "+", 
          RowBox[{
            StyleBox["4.16905733672257206`*^29",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^5\)}], "-", 
          RowBox[{
            StyleBox["5.10913728301594538`*^27",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^6\)}], "+", 
          RowBox[{
            StyleBox["3.45730988384555892`*^25",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^7\)}], "-", 
          RowBox[{
            StyleBox["1.36652524101627648`*^23",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^8\)}], "+", 
          RowBox[{
            StyleBox["3.27031588442874054`*^20",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^9\)}], "-", 
          RowBox[{
            StyleBox["4.83297782039214052`*^17",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^10\)}], "+", 
          RowBox[{
            StyleBox["4.42904743432705583`*^14",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^11\)}], "-", 
          RowBox[{
            StyleBox["2.48125845036323733`*^11",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^12\)}], "+", 
          RowBox[{
            StyleBox["8.14506356467026826`*^7",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^13\)}], "-", 
          RowBox[{
            StyleBox["14190.0030240547847`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^14\)}], "+", \(x\^15\)}]}],
      SequenceForm[ "dorthpoly[", 2, ",", 15, ",", x, "]=", 
        Plus[ -1.9455631941176403*^+32, 
          Times[ 2.9183438969019584*^+33, x], 
          Times[ -2.0428400774896963*^+33, 
            Power[ x, 2]], 
          Times[ 3.161537190447903*^+32, 
            Power[ x, 3]], 
          Times[ -1.7244742709991629*^+31, 
            Power[ x, 4]], 
          Times[ 4.1690573367225713*^+29, 
            Power[ x, 5]], 
          Times[ -5.1091372830159453*^+27, 
            Power[ x, 6]], 
          Times[ 3.4573098838455592*^+25, 
            Power[ x, 7]], 
          Times[ -1.3665252410162765*^+23, 
            Power[ x, 8]], 
          Times[ 3.2703158844287405*^+20, 
            Power[ x, 9]], 
          Times[ -4.8329778203921408*^+17, 
            Power[ x, 10]], 
          Times[ 442904743432705.56, 
            Power[ x, 11]], 
          Times[ -248125845036.32373, 
            Power[ x, 12]], 
          Times[ 81450635.646702677, 
            Power[ x, 13]], 
          Times[ -14190.003024054786, 
            Power[ x, 14]], 
          Power[ x, 15]]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("dorthpoly["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "16", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "x", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        RowBox[{
          StyleBox["2.10321089777120606`*^35",
            StyleBoxAutoDelete->True,
            PrintPrecision->16], "-", 
          RowBox[{
            StyleBox["3.36512892214108694`*^36",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", "x"}], "+", 
          RowBox[{
            StyleBox["2.52384033290844378`*^36",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^2\)}], "-", 
          RowBox[{
            StyleBox["4.20639012971853265`*^35",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^3\)}], "+", 
          RowBox[{
            StyleBox["2.48558816731558618`*^34",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^4\)}], "-", 
          RowBox[{
            StyleBox["6.55538207350243062`*^32",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^5\)}], "+", 
          RowBox[{
            StyleBox["8.83689231944488007`*^30",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^6\)}], "-", 
          RowBox[{
            StyleBox["6.64426572755051303`*^28",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^7\)}], "+", 
          RowBox[{
            StyleBox["2.95445997398519963`*^26",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^8\)}], "-", 
          RowBox[{
            StyleBox["8.08055869663008152`*^23",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^9\)}], "+", 
          RowBox[{
            StyleBox["1.39319723245691239`*^21",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^10\)}], "-", 
          RowBox[{
            StyleBox["1.53210575312555485`*^18",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^11\)}], "+", 
          RowBox[{
            StyleBox["1.07290144498701334`*^15",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^12\)}], "-", 
          RowBox[{
            StyleBox["4.69591772630548298`*^11",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^13\)}], "+", 
          RowBox[{
            StyleBox["1.22715443151949221`*^8",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^14\)}], "-", 
          RowBox[{
            StyleBox["17296.0220826026507`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^15\)}], "+", \(x\^16\)}]}],
      SequenceForm[ "dorthpoly[", 2, ",", 16, ",", x, "]=", 
        Plus[ 2.1032108977712059*^+35, 
          Times[ -3.3651289221410871*^+36, x], 
          Times[ 2.5238403329084436*^+36, 
            Power[ x, 2]], 
          Times[ -4.2063901297185327*^+35, 
            Power[ x, 3]], 
          Times[ 2.4855881673155862*^+34, 
            Power[ x, 4]], 
          Times[ -6.5553820735024303*^+32, 
            Power[ x, 5]], 
          Times[ 8.8368923194448803*^+30, 
            Power[ x, 6]], 
          Times[ -6.6442657275505109*^+28, 
            Power[ x, 7]], 
          Times[ 2.9544599739852*^+26, 
            Power[ x, 8]], 
          Times[ -8.0805586966300811*^+23, 
            Power[ x, 9]], 
          Times[ 1.3931972324569123*^+21, 
            Power[ x, 10]], 
          Times[ -1.5321057531255544*^+18, 
            Power[ x, 11]], 
          Times[ 1072901444987013.5, 
            Power[ x, 12]], 
          Times[ -469591772630.54828, 
            Power[ x, 13]], 
          Times[ 122715443.15194921, 
            Power[ x, 14]], 
          Times[ -17296.022082602649, 
            Power[ x, 15]], 
          Power[ x, 16]]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("dorthpoly["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "17", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "x", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        RowBox[{
          RowBox[{"-", 
            StyleBox["2.57685225496578507`*^38",
              StyleBoxAutoDelete->True,
              PrintPrecision->16]}], "+", 
          RowBox[{
            StyleBox["4.38057554236524637`*^39",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", "x"}], "-", 
          RowBox[{
            StyleBox["3.5044034466855245`*^39",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^2\)}], "+", 
          RowBox[{
            StyleBox["6.25776527626710876`*^38",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^3\)}], "-", 
          RowBox[{
            StyleBox["3.9821546229975917`*^37",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^4\)}], "+", 
          RowBox[{
            StyleBox["1.13774226612440898`*^36",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^5\)}], "-", 
          RowBox[{
            StyleBox["1.67312785796076539`*^34",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^6\)}], "+", 
          RowBox[{
            StyleBox["1.38377239384154403`*^32",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^7\)}], "-", 
          RowBox[{
            StyleBox["6.83673858306662207`*^29",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^8\)}], "+", 
          RowBox[{
            StyleBox["2.10358834635650859`*^27",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^9\)}], "-", 
          RowBox[{
            StyleBox["4.14495827489640511`*^24",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^10\)}], "+", 
          RowBox[{
            StyleBox["5.3178929457143349`*^21",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^11\)}], "-", 
          RowBox[{
            StyleBox["4.46877673036151712`*^18",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^12\)}], "+", 
          RowBox[{
            StyleBox["2.44487283016509859`*^15",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^13\)}], "-", 
          RowBox[{
            StyleBox["8.51865271273383584`*^11",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^14\)}], "+", 
          RowBox[{
            StyleBox["1.80097024416299902`*^8",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^15\)}], "-", 
          RowBox[{
            StyleBox["20825.1354273101751`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^16\)}], "+", \(x\^17\)}]}],
      SequenceForm[ "dorthpoly[", 2, ",", 17, ",", x, "]=", 
        Plus[ -2.5768522549657851*^+38, 
          Times[ 4.3805755423652465*^+39, x], 
          Times[ -3.5044034466855238*^+39, 
            Power[ x, 2]], 
          Times[ 6.2577652762671091*^+38, 
            Power[ x, 3]], 
          Times[ -3.9821546229975915*^+37, 
            Power[ x, 4]], 
          Times[ 1.1377422661244091*^+36, 
            Power[ x, 5]], 
          Times[ -1.6731278579607653*^+34, 
            Power[ x, 6]], 
          Times[ 1.3837723938415437*^+32, 
            Power[ x, 7]], 
          Times[ -6.8367385830666226*^+29, 
            Power[ x, 8]], 
          Times[ 2.1035883463565085*^+27, 
            Power[ x, 9]], 
          Times[ -4.1449582748964047*^+24, 
            Power[ x, 10]], 
          Times[ 5.3178929457143344*^+21, 
            Power[ x, 11]], 
          Times[ -4.4687767303615171*^+18, 
            Power[ x, 12]], 
          Times[ 2444872830165098.5, 
            Power[ x, 13]], 
          Times[ -851865271273.38367, 
            Power[ x, 14]], 
          Times[ 180097024.41629988, 
            Power[ x, 15]], 
          Times[ -20825.135427310175, 
            Power[ x, 16]], 
          Power[ x, 17]]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("dorthpoly["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "18", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "x", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        RowBox[{
          StyleBox["3.55387160566957671`*^41",
            StyleBoxAutoDelete->True,
            PrintPrecision->16], "-", 
          RowBox[{
            StyleBox["6.39636614796207059`*^42",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", "x"}], "+", 
          RowBox[{
            StyleBox["5.43642219008657257`*^42",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^2\)}], "-", 
          RowBox[{
            StyleBox["1.03542072500273185`*^42",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^3\)}], "+", 
          RowBox[{
            StyleBox["7.05911993776981105`*^40",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^4\)}], "-", 
          RowBox[{
            StyleBox["2.17187342280606188`*^39",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^5\)}], "+", 
          RowBox[{
            StyleBox["3.45984926248846003`*^37",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^6\)}], "-", 
          RowBox[{
            StyleBox["3.12146421758867909`*^35",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^7\)}], "+", 
          RowBox[{
            StyleBox["1.6963448098722214`*^33",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^8\)}], "-", 
          RowBox[{
            StyleBox["5.79914244482657093`*^30",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^9\)}], "+", 
          RowBox[{
            StyleBox["1.28545704296356255`*^28",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^10\)}], "-", 
          RowBox[{
            StyleBox["1.88474324358342961`*^25",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^11\)}], "+", 
          RowBox[{
            StyleBox["1.84770482728454119`*^22",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^12\)}], "-", 
          RowBox[{
            StyleBox["1.21301784493445663`*^19",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^13\)}], "+", 
          RowBox[{
            StyleBox["5.28297642062006023`*^15",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^14\)}], "-", 
          RowBox[{
            StyleBox["1.48915831960560858`*^12",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^15\)}], "+", 
          RowBox[{
            StyleBox["2.58286789178931242`*^8",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^16\)}], "-", 
          RowBox[{
            StyleBox["24804.6994805749188`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^17\)}], "+", \(x\^18\)}]}],
      SequenceForm[ "dorthpoly[", 2, ",", 18, ",", x, "]=", 
        Plus[ 3.5538716056695763*^+41, 
          Times[ -6.3963661479620696*^+42, x], 
          Times[ 5.4364221900865737*^+42, 
            Power[ x, 2]], 
          Times[ -1.035420725002732*^+42, 
            Power[ x, 3]], 
          Times[ 7.0591199377698114*^+40, 
            Power[ x, 4]], 
          Times[ -2.1718734228060623*^+39, 
            Power[ x, 5]], 
          Times[ 3.4598492624884604*^+37, 
            Power[ x, 6]], 
          Times[ -3.1214642175886791*^+35, 
            Power[ x, 7]], 
          Times[ 1.6963448098722215*^+33, 
            Power[ x, 8]], 
          Times[ -5.7991424448265704*^+30, 
            Power[ x, 9]], 
          Times[ 1.2854570429635626*^+28, 
            Power[ x, 10]], 
          Times[ -1.8847432435834298*^+25, 
            Power[ x, 11]], 
          Times[ 1.8477048272845411*^+22, 
            Power[ x, 12]], 
          Times[ -1.2130178449344565*^+19, 
            Power[ x, 13]], 
          Times[ 5282976420620061.0, 
            Power[ x, 14]], 
          Times[ -1489158319605.6086, 
            Power[ x, 15]], 
          Times[ 258286789.17893127, 
            Power[ x, 16]], 
          Times[ -24804.699480574916, 
            Power[ x, 17]], 
          Power[ x, 18]]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("dorthpoly["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "19", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "x", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        RowBox[{
          RowBox[{"-", 
            StyleBox["5.49296069262657216`*^44",
              StyleBoxAutoDelete->True,
              PrintPrecision->16]}], "+", 
          RowBox[{
            StyleBox["1.04318322120276585`*^46",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", "x"}], "-", 
          RowBox[{
            StyleBox["9.38459961796597497`*^45",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^2\)}], "+", 
          RowBox[{
            StyleBox["1.89849991013117005`*^45",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^3\)}], "-", 
          RowBox[{
            StyleBox["1.38021155078552904`*^44",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^4\)}], "+", 
          RowBox[{
            StyleBox["4.5485776591170719`*^42",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^5\)}], "-", 
          RowBox[{
            StyleBox["7.80145198384060467`*^40",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^6\)}], "+", 
          RowBox[{
            StyleBox["7.62325336853173229`*^38",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^7\)}], "-", 
          RowBox[{
            StyleBox["4.51850602781021493`*^36",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^8\)}], "+", 
          RowBox[{
            StyleBox["1.69885104132744624`*^34",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^9\)}], "-", 
          RowBox[{
            StyleBox["4.1834251131020439`*^31",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^10\)}], "+", 
          RowBox[{
            StyleBox["6.89939911686032836`*^28",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^11\)}], "-", 
          RowBox[{
            StyleBox["7.72897425176574959`*^25",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^12\)}], "+", 
          RowBox[{
            StyleBox["5.91898276992105643`*^22",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^13\)}], "-", 
          RowBox[{
            StyleBox["3.09306260220786999`*^19",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^14\)}], "+", 
          RowBox[{
            StyleBox["1.08971878636267627`*^16",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^15\)}], "-", 
          RowBox[{
            StyleBox["2.51983551029793328`*^12",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^16\)}], "+", 
          RowBox[{
            StyleBox["3.62958283376973867`*^8",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^17\)}], "-", 
          RowBox[{
            StyleBox["29262.9197631972317`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^18\)}], "+", \(x\^19\)}]}],
      SequenceForm[ "dorthpoly[", 2, ",", 19, ",", x, "]=", 
        Plus[ -5.4929606926265706*^+44, 
          Times[ 1.0431832212027658*^+46, x], 
          Times[ -9.3845996179659742*^+45, 
            Power[ x, 2]], 
          Times[ 1.8984999101311702*^+45, 
            Power[ x, 3]], 
          Times[ -1.3802115507855292*^+44, 
            Power[ x, 4]], 
          Times[ 4.5485776591170717*^+42, 
            Power[ x, 5]], 
          Times[ -7.8014519838406043*^+40, 
            Power[ x, 6]], 
          Times[ 7.6232533685317324*^+38, 
            Power[ x, 7]], 
          Times[ -4.518506027810215*^+36, 
            Power[ x, 8]], 
          Times[ 1.6988510413274458*^+34, 
            Power[ x, 9]], 
          Times[ -4.1834251131020441*^+31, 
            Power[ x, 10]], 
          Times[ 6.8993991168603275*^+28, 
            Power[ x, 11]], 
          Times[ -7.7289742517657501*^+25, 
            Power[ x, 12]], 
          Times[ 5.9189827699210568*^+22, 
            Power[ x, 13]], 
          Times[ -3.0930626022078697*^+19, 
            Power[ x, 14]], 
          Times[ 10897187863626762.0, 
            Power[ x, 15]], 
          Times[ -2519835510297.9336, 
            Power[ x, 16]], 
          Times[ 362958283.37697387, 
            Power[ x, 17]], 
          Times[ -29262.919763197235, 
            Power[ x, 18]], 
          Power[ x, 19]]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("dorthpoly["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "20", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "x", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        RowBox[{
          StyleBox["9.51547752071359376`*^47",
            StyleBoxAutoDelete->True,
            PrintPrecision->16], "-", 
          RowBox[{
            StyleBox["1.89952047243551227`*^49",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", "x"}], "+", 
          RowBox[{
            StyleBox["1.80141896089687563`*^49",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^2\)}], "-", 
          RowBox[{
            StyleBox["3.85406030942980137`*^48",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^3\)}], "+", 
          RowBox[{
            StyleBox["2.97383532740658207`*^47",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^4\)}], "-", 
          RowBox[{
            StyleBox["1.04437495851651407`*^46",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^5\)}], "+", 
          RowBox[{
            StyleBox["1.9175370815276576`*^44",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^6\)}], "-", 
          RowBox[{
            StyleBox["2.01631217839799603`*^42",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^7\)}], "+", 
          RowBox[{
            StyleBox["1.29382508024206654`*^40",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^8\)}], "-", 
          RowBox[{
            StyleBox["5.30345866001991517`*^37",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^9\)}], "+", 
          RowBox[{
            StyleBox["1.4357983851095164`*^35",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^10\)}], "-", 
          RowBox[{
            StyleBox["2.62979782789389338`*^32",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^11\)}], "+", 
          RowBox[{
            StyleBox["3.31285228518269203`*^29",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^12\)}], "-", 
          RowBox[{
            StyleBox["2.89839591366164306`*^26",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^13\)}], "+", 
          RowBox[{
            StyleBox["1.76646134817854587`*^23",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^14\)}], "-", 
          RowBox[{
            StyleBox["7.46597488820820842`*^19",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^15\)}], "+", 
          RowBox[{
            StyleBox["2.15747211962750418`*^16",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^16\)}], "-", 
          RowBox[{
            StyleBox["4.14260112399081847`*^12",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^17\)}], "+", 
          RowBox[{
            StyleBox["5.0088983922453929`*^8",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^18\)}], "-", 
          RowBox[{
            StyleBox["34228.062668659831`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^19\)}], "+", \(x\^20\)}]}],
      SequenceForm[ "dorthpoly[", 2, ",", 20, ",", x, "]=", 
        Plus[ 9.515477520713594*^+47, 
          Times[ -1.8995204724355122*^+49, x], 
          Times[ 1.8014189608968752*^+49, 
            Power[ x, 2]], 
          Times[ -3.8540603094298012*^+48, 
            Power[ x, 3]], 
          Times[ 2.9738353274065822*^+47, 
            Power[ x, 4]], 
          Times[ -1.0443749585165139*^+46, 
            Power[ x, 5]], 
          Times[ 1.9175370815276575*^+44, 
            Power[ x, 6]], 
          Times[ -2.016312178397996*^+42, 
            Power[ x, 7]], 
          Times[ 1.2938250802420666*^+40, 
            Power[ x, 8]], 
          Times[ -5.3034586600199152*^+37, 
            Power[ x, 9]], 
          Times[ 1.4357983851095162*^+35, 
            Power[ x, 10]], 
          Times[ -2.629797827893893*^+32, 
            Power[ x, 11]], 
          Times[ 3.3128522851826919*^+29, 
            Power[ x, 12]], 
          Times[ -2.8983959136616432*^+26, 
            Power[ x, 13]], 
          Times[ 1.7664613481785458*^+23, 
            Power[ x, 14]], 
          Times[ -7.4659748882082071*^+19, 
            Power[ x, 15]], 
          Times[ 21574721196275040.0, 
            Power[ x, 16]], 
          Times[ -4142601123990.8184, 
            Power[ x, 17]], 
          Times[ 500889839.22453922, 
            Power[ x, 18]], 
          Times[ -34228.062668659826, 
            Power[ x, 19]], 
          Power[ x, 20]]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("dorthpoly["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "21", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "x", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        RowBox[{
          RowBox[{"-", 
            StyleBox["1.83743882731013492`*^51",
              StyleBoxAutoDelete->True,
              PrintPrecision->16]}], "+", 
          RowBox[{
            StyleBox["3.83638539847602988`*^52",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", "x"}], "-", 
          RowBox[{
            StyleBox["3.81663945464615395`*^52",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^2\)}], "+", 
          RowBox[{
            StyleBox["8.59359294923065242`*^51",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^3\)}], "-", 
          RowBox[{
            StyleBox["7.00310725977598202`*^50",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^4\)}], "+", 
          RowBox[{
            StyleBox["2.60750046883990682`*^49",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^5\)}], "-", 
          RowBox[{
            StyleBox["5.09754904799724073`*^47",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^6\)}], "+", 
          RowBox[{
            StyleBox["5.7345556342794266`*^45",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^7\)}], "-", 
          RowBox[{
            StyleBox["3.95811248426260764`*^43",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^8\)}], "+", 
          RowBox[{
            StyleBox["1.7560213537187792`*^41",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^9\)}], "-", 
          RowBox[{
            StyleBox["5.18256627086054599`*^38",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^10\)}], "+", 
          RowBox[{
            StyleBox["1.04361995728507173`*^36",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^11\)}], "-", 
          RowBox[{
            StyleBox["1.46025179813761907`*^33",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^12\)}], "+", 
          RowBox[{
            StyleBox["1.4369646318485163`*^30",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^13\)}], "-", 
          RowBox[{
            StyleBox["1.00080048850188929`*^27",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^14\)}], "+", 
          RowBox[{
            StyleBox["4.93497069051588077`*^23",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^15\)}], "-", 
          RowBox[{
            StyleBox["1.71147347748165312`*^20",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^16\)}], "+", 
          RowBox[{
            StyleBox["4.10852022984140763`*^16",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^17\)}], "-", 
          RowBox[{
            StyleBox["6.62516768409346656`*^12",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^18\)}], "+", 
          RowBox[{
            StyleBox["6.7928730335660834`*^8",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^19\)}], "-", 
          RowBox[{
            StyleBox["39704.900534129095`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^20\)}], "+", \(x\^21\)}]}],
      SequenceForm[ "dorthpoly[", 2, ",", 21, ",", x, "]=", 
        Plus[ -1.8374388273101348*^+51, 
          Times[ 3.8363853984760301*^+52, x], 
          Times[ -3.8166394546461538*^+52, 
            Power[ x, 2]], 
          Times[ 8.5935929492306516*^+51, 
            Power[ x, 3]], 
          Times[ -7.0031072597759821*^+50, 
            Power[ x, 4]], 
          Times[ 2.6075004688399073*^+49, 
            Power[ x, 5]], 
          Times[ -5.0975490479972407*^+47, 
            Power[ x, 6]], 
          Times[ 5.7345556342794266*^+45, 
            Power[ x, 7]], 
          Times[ -3.9581124842626078*^+43, 
            Power[ x, 8]], 
          Times[ 1.7560213537187792*^+41, 
            Power[ x, 9]], 
          Times[ -5.1825662708605469*^+38, 
            Power[ x, 10]], 
          Times[ 1.0436199572850716*^+36, 
            Power[ x, 11]], 
          Times[ -1.4602517981376194*^+33, 
            Power[ x, 12]], 
          Times[ 1.4369646318485164*^+30, 
            Power[ x, 13]], 
          Times[ -1.0008004885018893*^+27, 
            Power[ x, 14]], 
          Times[ 4.9349706905158811*^+23, 
            Power[ x, 15]], 
          Times[ -1.7114734774816532*^+20, 
            Power[ x, 16]], 
          Times[ 41085202298414072.0, 
            Power[ x, 17]], 
          Times[ -6625167684093.4668, 
            Power[ x, 18]], 
          Times[ 679287303.35660827, 
            Power[ x, 19]], 
          Times[ -39704.90053412909, 
            Power[ x, 20]], 
          Power[ x, 21]]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("dorthpoly["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "22", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "x", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        RowBox[{
          StyleBox["3.41238948632293892`*^54",
            StyleBoxAutoDelete->True,
            PrintPrecision->16], "-", 
          RowBox[{
            StyleBox["7.45015381810402033`*^55",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", "x"}], "+", 
          RowBox[{
            StyleBox["7.78055267131763539`*^55",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^2\)}], "-", 
          RowBox[{
            StyleBox["1.84637063229561739`*^55",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^3\)}], "+", 
          RowBox[{
            StyleBox["1.5922876901624039`*^54",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^4\)}], "-", 
          RowBox[{
            StyleBox["6.30044611038917423`*^52",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^5\)}], "+", 
          RowBox[{
            StyleBox["1.31472836917199886`*^51",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^6\)}], "-", 
          RowBox[{
            StyleBox["1.58609995432758328`*^49",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^7\)}], "+", 
          RowBox[{
            StyleBox["1.17995787106873395`*^47",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^8\)}], "-", 
          RowBox[{
            StyleBox["5.6737436909535841`*^44",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^9\)}], "+", 
          RowBox[{
            StyleBox["1.82624820884610059`*^42",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^10\)}], "-", 
          RowBox[{
            StyleBox["4.03967461815290374`*^39",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^11\)}], "+", 
          RowBox[{
            StyleBox["6.26140441004627135`*^36",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^12\)}], "-", 
          RowBox[{
            StyleBox["6.8945817430794678`*^33",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^13\)}], "+", 
          RowBox[{
            StyleBox["5.44011162519857727`*^30",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^14\)}], "-", 
          RowBox[{
            StyleBox["3.08706950923535305`*^27",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^15\)}], "+", 
          RowBox[{
            StyleBox["1.25757773311930476`*^24",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^16\)}], "-", 
          RowBox[{
            StyleBox["3.64687350866011827`*^20",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^17\)}], "+", 
          RowBox[{
            StyleBox["7.39869382665424257`*^16",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^18\)}], "-", 
          RowBox[{
            StyleBox["1.01784084153216558`*^13",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^19\)}], "+", 
          RowBox[{
            StyleBox["8.97848539008291801`*^8",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^20\)}], "-", 
          RowBox[{
            StyleBox["45492.4515582239674`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^21\)}], "+", \(x\^22\)}]}],
      SequenceForm[ "dorthpoly[", 2, ",", 22, ",", x, "]=", 
        Plus[ 3.4123894863229391*^+54, 
          Times[ -7.4501538181040191*^+55, x], 
          Times[ 7.7805526713176336*^+55, 
            Power[ x, 2]], 
          Times[ -1.8463706322956177*^+55, 
            Power[ x, 3]], 
          Times[ 1.5922876901624037*^+54, 
            Power[ x, 4]], 
          Times[ -6.3004461103891753*^+52, 
            Power[ x, 5]], 
          Times[ 1.3147283691719986*^+51, 
            Power[ x, 6]], 
          Times[ -1.5860999543275831*^+49, 
            Power[ x, 7]], 
          Times[ 1.1799578710687339*^+47, 
            Power[ x, 8]], 
          Times[ -5.6737436909535838*^+44, 
            Power[ x, 9]], 
          Times[ 1.8262482088461007*^+42, 
            Power[ x, 10]], 
          Times[ -4.0396746181529036*^+39, 
            Power[ x, 11]], 
          Times[ 6.2614044100462715*^+36, 
            Power[ x, 12]], 
          Times[ -6.8945817430794667*^+33, 
            Power[ x, 13]], 
          Times[ 5.4401116251985769*^+30, 
            Power[ x, 14]], 
          Times[ -3.0870695092353532*^+27, 
            Power[ x, 15]], 
          Times[ 1.2575777331193047*^+24, 
            Power[ x, 16]], 
          Times[ -3.6468735086601182*^+20, 
            Power[ x, 17]], 
          Times[ 73986938266542416.0, 
            Power[ x, 18]], 
          Times[ -10178408415321.656, 
            Power[ x, 19]], 
          Times[ 897848539.0082916, 
            Power[ x, 20]], 
          Times[ -45492.451558223969, 
            Power[ x, 21]], 
          Power[ x, 22]]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("dorthpoly["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "23", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "x", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        RowBox[{
          StyleBox["1.79034339357524885`*^57",
            StyleBoxAutoDelete->True,
            PrintPrecision->16], "-", 
          RowBox[{
            StyleBox["2.98370196914089458`*^58",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", "x"}], "+", 
          RowBox[{
            StyleBox["2.00258178648553197`*^58",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^2\)}], "-", 
          RowBox[{
            StyleBox["1.75007053133797114`*^57",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^3\)}], "-", 
          RowBox[{
            StyleBox["1.40065277666565046`*^56",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^4\)}], "+", 
          RowBox[{
            StyleBox["1.83858236551391573`*^55",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^5\)}], "-", 
          RowBox[{
            StyleBox["6.81332069124712624`*^53",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^6\)}], "+", 
          RowBox[{
            StyleBox["1.22032489569810187`*^52",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^7\)}], "-", 
          RowBox[{
            StyleBox["1.23715120078594398`*^50",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^8\)}], "+", 
          RowBox[{
            StyleBox["7.71632283052015832`*^47",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^9\)}], "-", 
          RowBox[{
            StyleBox["3.12349852906816716`*^45",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^10\)}], "+", 
          RowBox[{
            StyleBox["8.51695739252144434`*^42",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^11\)}], "-", 
          RowBox[{
            StyleBox["1.60695223407757374`*^40",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^12\)}], "+", 
          RowBox[{
            StyleBox["2.13901310939805977`*^37",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^13\)}], "-", 
          RowBox[{
            StyleBox["2.03587882311049117`*^34",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^14\)}], "+", 
          RowBox[{
            StyleBox["1.39700235061705013`*^31",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^15\)}], "-", 
          RowBox[{
            StyleBox["6.93335229833642507`*^27",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^16\)}], "+", 
          RowBox[{
            StyleBox["2.48329059772357618`*^24",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^17\)}], "-", 
          RowBox[{
            StyleBox["6.36261845297729067`*^20",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^18\)}], "+", 
          RowBox[{
            StyleBox["1.14570123739789231`*^17",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^19\)}], "-", 
          RowBox[{
            StyleBox["1.40488755199313235`*^13",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^20\)}], "+", 
          RowBox[{
            StyleBox["1.10900236965685783`*^9",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^21\)}], "-", 
          RowBox[{
            StyleBox["50471.7402300230055`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^22\)}], "+", \(x\^23\)}]}],
      SequenceForm[ "dorthpoly[", 2, ",", 23, ",", x, "]=", 
        Plus[ 1.7903433935752491*^+57, 
          Times[ -2.9837019691408949*^+58, x], 
          Times[ 2.0025817864855322*^+58, 
            Power[ x, 2]], 
          Times[ -1.7500705313379712*^+57, 
            Power[ x, 3]], 
          Times[ -1.4006527766656506*^+56, 
            Power[ x, 4]], 
          Times[ 1.8385823655139157*^+55, 
            Power[ x, 5]], 
          Times[ -6.8133206912471264*^+53, 
            Power[ x, 6]], 
          Times[ 1.2203248956981021*^+52, 
            Power[ x, 7]], 
          Times[ -1.237151200785944*^+50, 
            Power[ x, 8]], 
          Times[ 7.71632283052016*^+47, 
            Power[ x, 9]], 
          Times[ -3.1234985290681669*^+45, 
            Power[ x, 10]], 
          Times[ 8.516957392521443*^+42, 
            Power[ x, 11]], 
          Times[ -1.6069522340775735*^+40, 
            Power[ x, 12]], 
          Times[ 2.1390131093980601*^+37, 
            Power[ x, 13]], 
          Times[ -2.0358788231104912*^+34, 
            Power[ x, 14]], 
          Times[ 1.3970023506170503*^+31, 
            Power[ x, 15]], 
          Times[ -6.9333522983364234*^+27, 
            Power[ x, 16]], 
          Times[ 2.4832905977235762*^+24, 
            Power[ x, 17]], 
          Times[ -6.3626184529772911*^+20, 
            Power[ x, 18]], 
          Times[ 1.1457012373978923*^+17, 
            Power[ x, 19]], 
          Times[ -14048875519931.322, 
            Power[ x, 20]], 
          Times[ 1109002369.6568577, 
            Power[ x, 21]], 
          Times[ -50471.740230022995, 
            Power[ x, 22]], 
          Power[ x, 23]]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("dorthpoly["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "24", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "x", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        RowBox[{
          RowBox[{"-", 
            StyleBox["3.84902117068229454`*^61",
              StyleBoxAutoDelete->True,
              PrintPrecision->16]}], "+", 
          RowBox[{
            StyleBox["8.5959899502478585`*^62",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", "x"}], "-", 
          RowBox[{
            StyleBox["9.15519185237215182`*^62",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^2\)}], "+", 
          RowBox[{
            StyleBox["2.20817368552214343`*^62",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^3\)}], "-", 
          RowBox[{
            StyleBox["1.92805014285844151`*^61",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^4\)}], "+", 
          RowBox[{
            StyleBox["7.68929108098883951`*^59",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^5\)}], "-", 
          RowBox[{
            StyleBox["1.60835324320450006`*^58",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^6\)}], "+", 
          RowBox[{
            StyleBox["1.93144020390196295`*^56",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^7\)}], "-", 
          RowBox[{
            StyleBox["1.41714629435431422`*^54",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^8\)}], "+", 
          RowBox[{
            StyleBox["6.63506177657380913`*^51",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^9\)}], "-", 
          RowBox[{
            StyleBox["2.04078320974002247`*^49",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^10\)}], "+", 
          RowBox[{
            StyleBox["4.1887473761423255`*^46",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^11\)}], "-", 
          RowBox[{
            StyleBox["5.73011363990184019`*^43",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^12\)}], "+", 
          RowBox[{
            StyleBox["5.05021652651823149`*^40",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^13\)}], "-", 
          RowBox[{
            StyleBox["2.48585320596588621`*^37",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^14\)}], "+", 
          RowBox[{
            StyleBox["1.06457549302165932`*^33",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^15\)}], "+", 
          RowBox[{
            StyleBox["7.93571284063198145`*^30",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^16\)}], "-", 
          RowBox[{
            StyleBox["6.28056842538037507`*^27",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^17\)}], "+", 
          RowBox[{
            StyleBox["2.67589458756273668`*^24",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^18\)}], "-", 
          RowBox[{
            StyleBox["7.32115679935681296`*^20",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^19\)}], "+", 
          RowBox[{
            StyleBox["1.33488488090467827`*^17",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^20\)}], "-", 
          RowBox[{
            StyleBox["1.60878093592677551`*^13",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^21\)}], "+", 
          RowBox[{
            StyleBox["1.22594506386355051`*^9",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^22\)}], "-", 
          RowBox[{
            StyleBox["53257.3714922978425`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^23\)}], "+", \(x\^24\)}]}],
      SequenceForm[ "dorthpoly[", 2, ",", 24, ",", x, "]=", 
        Plus[ -3.849021170682295*^+61, 
          Times[ 8.5959899502478599*^+62, x], 
          Times[ -9.1551918523721521*^+62, 
            Power[ x, 2]], 
          Times[ 2.2081736855221437*^+62, 
            Power[ x, 3]], 
          Times[ -1.9280501428584413*^+61, 
            Power[ x, 4]], 
          Times[ 7.6892910809888389*^+59, 
            Power[ x, 5]], 
          Times[ -1.6083532432045001*^+58, 
            Power[ x, 6]], 
          Times[ 1.9314402039019629*^+56, 
            Power[ x, 7]], 
          Times[ -1.4171462943543144*^+54, 
            Power[ x, 8]], 
          Times[ 6.6350617765738102*^+51, 
            Power[ x, 9]], 
          Times[ -2.0407832097400221*^+49, 
            Power[ x, 10]], 
          Times[ 4.1887473761423253*^+46, 
            Power[ x, 11]], 
          Times[ -5.7301136399018406*^+43, 
            Power[ x, 12]], 
          Times[ 5.0502165265182314*^+40, 
            Power[ x, 13]], 
          Times[ -2.4858532059658863*^+37, 
            Power[ x, 14]], 
          Times[ 1.0645754930216593*^+33, 
            Power[ x, 15]], 
          Times[ 7.9357128406319803*^+30, 
            Power[ x, 16]], 
          Times[ -6.2805684253803743*^+27, 
            Power[ x, 17]], 
          Times[ 2.6758945875627362*^+24, 
            Power[ x, 18]], 
          Times[ -7.3211567993568127*^+20, 
            Power[ x, 19]], 
          Times[ 1.3348848809046782*^+17, 
            Power[ x, 20]], 
          Times[ -16087809359267.756, 
            Power[ x, 21]], 
          Times[ 1225945063.8635507, 
            Power[ x, 22]], 
          Times[ -53257.37149229784, 
            Power[ x, 23]], 
          Power[ x, 24]]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("dorthpoly["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "25", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "x", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        RowBox[{
          RowBox[{"-", 
            StyleBox["2.54070255953058277`*^65",
              StyleBoxAutoDelete->True,
              PrintPrecision->16]}], "+", 
          RowBox[{
            StyleBox["5.37160757038500857`*^66",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", "x"}], "-", 
          RowBox[{
            StyleBox["5.42630994618748818`*^66",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^2\)}], "+", 
          RowBox[{
            StyleBox["1.24426941216498665`*^66",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^3\)}], "-", 
          RowBox[{
            StyleBox["1.03590034426162946`*^65",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^4\)}], "+", 
          RowBox[{
            StyleBox["3.95420048597952842`*^63",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^5\)}], "-", 
          RowBox[{
            StyleBox["7.95737393325707653`*^61",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^6\)}], "+", 
          RowBox[{
            StyleBox["9.2613476004148616`*^59",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^7\)}], "-", 
          RowBox[{
            StyleBox["6.65814754091552352`*^57",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^8\)}], "+", 
          RowBox[{
            StyleBox["3.10647603513554049`*^55",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^9\)}], "-", 
          RowBox[{
            StyleBox["9.78302753680128489`*^52",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^10\)}], "+", 
          RowBox[{
            StyleBox["2.15048346147797753`*^50",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^11\)}], "-", 
          RowBox[{
            StyleBox["3.40467725467255055`*^47",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^12\)}], "+", 
          RowBox[{
            StyleBox["4.00777071071591173`*^44",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^13\)}], "-", 
          RowBox[{
            StyleBox["3.6236128253247708`*^41",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^14\)}], "+", 
          RowBox[{
            StyleBox["2.59037392640009445`*^38",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^15\)}], "-", 
          RowBox[{
            StyleBox["1.48883033086076306`*^35",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^16\)}], "+", 
          RowBox[{
            StyleBox["6.86664098272169987`*^31",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^17\)}], "-", 
          RowBox[{
            StyleBox["2.49480239455721974`*^28",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^18\)}], "+", 
          RowBox[{
            StyleBox["6.95065317959039852`*^24",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^19\)}], "-", 
          RowBox[{
            StyleBox["1.44166073180982801`*^21",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^20\)}], "+", 
          RowBox[{
            StyleBox["2.15512887207744263`*^17",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^21\)}], "-", 
          RowBox[{
            StyleBox["2.2289261308115309`*^13",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^22\)}], "+", 
          RowBox[{
            StyleBox["1.49920899353926646`*^9",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^23\)}], "-", 
          RowBox[{
            StyleBox["58537.9755463691431`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^24\)}], "+", \(x\^25\)}]}],
      SequenceForm[ "dorthpoly[", 2, ",", 25, ",", x, "]=", 
        Plus[ -2.5407025595305828*^+65, 
          Times[ 5.371607570385009*^+66, x], 
          Times[ -5.4263099461874876*^+66, 
            Power[ x, 2]], 
          Times[ 1.2442694121649867*^+66, 
            Power[ x, 3]], 
          Times[ -1.0359003442616293*^+65, 
            Power[ x, 4]], 
          Times[ 3.954200485979528*^+63, 
            Power[ x, 5]], 
          Times[ -7.9573739332570774*^+61, 
            Power[ x, 6]], 
          Times[ 9.2613476004148633*^+59, 
            Power[ x, 7]], 
          Times[ -6.6581475409155237*^+57, 
            Power[ x, 8]], 
          Times[ 3.1064760351355405*^+55, 
            Power[ x, 9]], 
          Times[ -9.7830275368012859*^+52, 
            Power[ x, 10]], 
          Times[ 2.1504834614779773*^+50, 
            Power[ x, 11]], 
          Times[ -3.404677254672551*^+47, 
            Power[ x, 12]], 
          Times[ 4.0077707107159124*^+44, 
            Power[ x, 13]], 
          Times[ -3.6236128253247702*^+41, 
            Power[ x, 14]], 
          Times[ 2.5903739264000948*^+38, 
            Power[ x, 15]], 
          Times[ -1.4888303308607632*^+35, 
            Power[ x, 16]], 
          Times[ 6.8666409827216991*^+31, 
            Power[ x, 17]], 
          Times[ -2.4948023945572195*^+28, 
            Power[ x, 18]], 
          Times[ 6.9506531795903975*^+24, 
            Power[ x, 19]], 
          Times[ -1.4416607318098279*^+21, 
            Power[ x, 20]], 
          Times[ 2.1551288720774429*^+17, 
            Power[ x, 21]], 
          Times[ -22289261308115.312, 
            Power[ x, 22]], 
          Times[ 1499208993.5392663, 
            Power[ x, 23]], 
          Times[ -58537.975546369154, 
            Power[ x, 24]], 
          Power[ x, 25]]],
      Editable->False]], "Print"],

Cell[BoxData[
    \({3.16666666666665719`\ Second, Null}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(MemoryInUse[]\)], "Input"],

Cell[BoxData[
    \(1204864\)], "Output"]
}, Open  ]]
}, Closed]]
}, Closed]]
},
FrontEndVersion->"Macintosh 3.0",
ScreenRectangle->{{0, 832}, {0, 604}},
WindowSize->{590, 412},
WindowMargins->{{84, Automatic}, {84, Automatic}},
MacintoshSystemPageSetup->"\<\
00<0001804P000000`d26_oQon@3:`8g0dL5N`?P0080001804P000000]P2:001
0000I00000400`<30?l00BL?00400@0000000000000006P801T1T00000000000
00000000004000000000000000000000\>"
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{
Cell[1709, 49, 1274, 21, 628, "Subsection"],

Cell[CellGroupData[{
Cell[3008, 74, 154, 4, 68, "Section"],

Cell[CellGroupData[{
Cell[3187, 82, 105, 3, 44, "Subsection"],
Cell[3295, 87, 56, 1, 27, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[3388, 93, 132, 4, 44, "Subsection"],
Cell[3523, 99, 71, 1, 27, "Input"],
Cell[3597, 102, 142, 2, 43, "Input"],

Cell[CellGroupData[{
Cell[3764, 108, 141, 2, 43, "Input"],
Cell[3908, 112, 298, 6, 22, "Print"],
Cell[4209, 120, 298, 6, 22, "Print"],
Cell[4510, 128, 300, 6, 22, "Print"],
Cell[4813, 136, 302, 6, 22, "Print"],
Cell[5118, 144, 306, 6, 22, "Print"],
Cell[5427, 152, 310, 6, 22, "Print"],
Cell[5740, 160, 314, 6, 22, "Print"],
Cell[6057, 168, 318, 6, 22, "Print"],
Cell[6378, 176, 322, 6, 22, "Print"],
Cell[6703, 184, 328, 6, 22, "Print"],
Cell[7034, 192, 336, 6, 22, "Print"],
Cell[7373, 200, 298, 6, 22, "Print"],
Cell[7674, 208, 298, 6, 22, "Print"],
Cell[7975, 216, 300, 6, 22, "Print"],
Cell[8278, 224, 302, 6, 22, "Print"],
Cell[8583, 232, 306, 6, 22, "Print"],
Cell[8892, 240, 310, 6, 22, "Print"],
Cell[9205, 248, 316, 6, 22, "Print"],
Cell[9524, 256, 320, 6, 22, "Print"],
Cell[9847, 264, 324, 6, 22, "Print"],
Cell[10174, 272, 330, 6, 22, "Print"],
Cell[10507, 280, 338, 6, 22, "Print"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{
Cell[10894, 292, 54, 0, 28, "Subsection"],

Cell[CellGroupData[{
Cell[10973, 296, 142, 2, 43, "Input"],
Cell[11118, 300, 175, 3, 37, "Message"]
}, Open  ]],

Cell[CellGroupData[{
Cell[11330, 308, 46, 1, 27, "Input"],
Cell[11379, 311, 40, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[11456, 317, 117, 4, 42, "Input"],
Cell[11576, 323, 38, 1, 22, "Print"],
Cell[11617, 326, 302, 6, 22, "Print"],
Cell[11922, 334, 312, 6, 22, "Print"],
Cell[12237, 342, 37, 1, 22, "Print"],
Cell[12277, 345, 306, 6, 22, "Print"],
Cell[12586, 353, 316, 6, 22, "Print"],
Cell[12905, 361, 37, 1, 22, "Print"],
Cell[12945, 364, 308, 6, 22, "Print"],
Cell[13256, 372, 318, 6, 22, "Print"],
Cell[13577, 380, 37, 1, 22, "Print"],
Cell[13617, 383, 310, 6, 22, "Print"],
Cell[13930, 391, 320, 6, 22, "Print"],
Cell[14253, 399, 37, 1, 22, "Print"],
Cell[14293, 402, 312, 6, 22, "Print"],
Cell[14608, 410, 322, 6, 22, "Print"],
Cell[14933, 418, 37, 1, 22, "Print"],
Cell[14973, 421, 312, 6, 22, "Print"],
Cell[15288, 429, 322, 6, 22, "Print"],
Cell[15613, 437, 37, 1, 22, "Print"],
Cell[15653, 440, 314, 6, 22, "Print"],
Cell[15970, 448, 324, 6, 22, "Print"],
Cell[16297, 456, 37, 1, 22, "Print"],
Cell[16337, 459, 314, 6, 22, "Print"],
Cell[16654, 467, 324, 6, 22, "Print"],
Cell[16981, 475, 37, 1, 22, "Print"],
Cell[17021, 478, 314, 6, 22, "Print"],
Cell[17338, 486, 324, 6, 22, "Print"],
Cell[17665, 494, 37, 1, 22, "Print"],
Cell[17705, 497, 38, 1, 22, "Print"],
Cell[17746, 500, 300, 6, 22, "Print"],
Cell[18049, 508, 310, 6, 22, "Print"],
Cell[18362, 516, 37, 1, 22, "Print"],
Cell[18402, 519, 304, 6, 22, "Print"],
Cell[18709, 527, 314, 6, 22, "Print"],
Cell[19026, 535, 37, 1, 22, "Print"],
Cell[19066, 538, 306, 6, 22, "Print"],
Cell[19375, 546, 316, 6, 22, "Print"],
Cell[19694, 554, 37, 1, 22, "Print"],
Cell[19734, 557, 308, 6, 22, "Print"],
Cell[20045, 565, 318, 6, 22, "Print"],
Cell[20366, 573, 37, 1, 22, "Print"],
Cell[20406, 576, 308, 6, 22, "Print"],
Cell[20717, 584, 318, 6, 22, "Print"],
Cell[21038, 592, 37, 1, 22, "Print"],
Cell[21078, 595, 308, 6, 22, "Print"],
Cell[21389, 603, 318, 6, 22, "Print"],
Cell[21710, 611, 37, 1, 22, "Print"],
Cell[21750, 614, 310, 6, 22, "Print"],
Cell[22063, 622, 320, 6, 22, "Print"],
Cell[22386, 630, 37, 1, 22, "Print"],
Cell[22426, 633, 310, 6, 22, "Print"],
Cell[22739, 641, 320, 6, 22, "Print"],
Cell[23062, 649, 37, 1, 22, "Print"],
Cell[23102, 652, 310, 6, 22, "Print"],
Cell[23415, 660, 320, 6, 22, "Print"],
Cell[23738, 668, 37, 1, 22, "Print"],
Cell[23778, 671, 312, 6, 22, "Print"],
Cell[24093, 679, 322, 6, 22, "Print"],
Cell[24418, 687, 37, 1, 22, "Print"],
Cell[24458, 690, 53, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[24548, 696, 46, 1, 27, "Input"],
Cell[24597, 699, 40, 1, 26, "Output"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{
Cell[24686, 706, 53, 0, 28, "Subsection"],
Cell[24742, 708, 142, 2, 43, "Input"],

Cell[CellGroupData[{
Cell[24909, 714, 46, 1, 27, "Input"],
Cell[24958, 717, 40, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[25035, 723, 116, 4, 42, "Input"],
Cell[25154, 729, 243, 5, 22, "Print"],
Cell[25400, 736, 253, 5, 22, "Print"],
Cell[25656, 743, 37, 1, 22, "Print"],
Cell[25696, 746, 245, 5, 22, "Print"],
Cell[25944, 753, 255, 5, 22, "Print"],
Cell[26202, 760, 37, 1, 22, "Print"],
Cell[26242, 763, 245, 5, 22, "Print"],
Cell[26490, 770, 255, 5, 22, "Print"],
Cell[26748, 777, 37, 1, 22, "Print"],
Cell[26788, 780, 247, 5, 22, "Print"],
Cell[27038, 787, 257, 5, 22, "Print"],
Cell[27298, 794, 37, 1, 22, "Print"],
Cell[27338, 797, 247, 5, 22, "Print"],
Cell[27588, 804, 257, 5, 22, "Print"],
Cell[27848, 811, 37, 1, 22, "Print"],
Cell[27888, 814, 247, 5, 22, "Print"],
Cell[28138, 821, 257, 5, 22, "Print"],
Cell[28398, 828, 37, 1, 22, "Print"],
Cell[28438, 831, 247, 5, 22, "Print"],
Cell[28688, 838, 257, 5, 22, "Print"],
Cell[28948, 845, 37, 1, 22, "Print"],
Cell[28988, 848, 247, 5, 22, "Print"],
Cell[29238, 855, 257, 5, 22, "Print"],
Cell[29498, 862, 37, 1, 22, "Print"],
Cell[29538, 865, 247, 5, 22, "Print"],
Cell[29788, 872, 257, 5, 22, "Print"],
Cell[30048, 879, 37, 1, 22, "Print"],
Cell[30088, 882, 249, 5, 22, "Print"],
Cell[30340, 889, 259, 5, 22, "Print"],
Cell[30602, 896, 37, 1, 22, "Print"],
Cell[30642, 899, 70, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[30749, 905, 46, 1, 27, "Input"],
Cell[30798, 908, 40, 1, 26, "Output"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{
Cell[30887, 915, 60, 0, 28, "Subsection"],
Cell[30950, 917, 142, 2, 43, "Input"],

Cell[CellGroupData[{
Cell[31117, 923, 46, 1, 27, "Input"],
Cell[31166, 926, 40, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[31243, 932, 84, 1, 27, "Input"],
Cell[31330, 935, 308, 6, 22, "Print"],
Cell[31641, 943, 343, 7, 22, "Print"],
Cell[31987, 952, 397, 9, 24, "Print"],
Cell[32387, 963, 481, 12, 24, "Print"],
Cell[32871, 977, 549, 14, 24, "Print"],
Cell[33423, 993, 638, 16, 24, "Print"],
Cell[34064, 1011, 731, 19, 39, "Print"],
Cell[34798, 1032, 830, 21, 41, "Print"],
Cell[35631, 1055, 937, 24, 41, "Print"],
Cell[36571, 1081, 1056, 26, 56, "Print"],
Cell[37630, 1109, 1181, 29, 73, "Print"],
Cell[38814, 1140, 70, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[38921, 1146, 46, 1, 27, "Input"],
Cell[38970, 1149, 41, 1, 26, "Output"]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[39072, 1157, 187, 5, 66, "Section"],

Cell[CellGroupData[{
Cell[39284, 1166, 105, 3, 44, "Subsection"],
Cell[39392, 1171, 56, 1, 27, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[39485, 1177, 54, 0, 44, "Subsection"],
Cell[39542, 1179, 140, 2, 43, "Input"],

Cell[CellGroupData[{
Cell[39707, 1185, 46, 1, 27, "Input"],
Cell[39756, 1188, 40, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[39833, 1194, 125, 4, 42, "Input"],
Cell[39961, 1200, 38, 1, 22, "Print"],
Cell[40002, 1203, 479, 11, 22, "Print"],
Cell[40484, 1216, 489, 11, 22, "Print"],
Cell[40976, 1229, 498, 11, 22, "Print"],
Cell[41477, 1242, 37, 1, 22, "Print"],
Cell[41517, 1245, 496, 11, 22, "Print"],
Cell[42016, 1258, 506, 11, 22, "Print"],
Cell[42525, 1271, 498, 11, 22, "Print"],
Cell[43026, 1284, 37, 1, 22, "Print"],
Cell[43066, 1287, 498, 11, 22, "Print"],
Cell[43567, 1300, 508, 11, 22, "Print"],
Cell[44078, 1313, 498, 11, 22, "Print"],
Cell[44579, 1326, 37, 1, 22, "Print"],
Cell[44619, 1329, 509, 11, 22, "Print"],
Cell[45131, 1342, 509, 11, 22, "Print"],
Cell[45643, 1355, 527, 12, 22, "Print"],
Cell[46173, 1369, 37, 1, 22, "Print"],
Cell[46213, 1372, 512, 11, 24, "Print"],
Cell[46728, 1385, 513, 11, 24, "Print"],
Cell[47244, 1398, 526, 12, 22, "Print"],
Cell[47773, 1412, 37, 1, 22, "Print"],
Cell[47813, 1415, 511, 11, 24, "Print"],
Cell[48327, 1428, 513, 11, 24, "Print"],
Cell[48843, 1441, 527, 12, 22, "Print"],
Cell[49373, 1455, 37, 1, 22, "Print"],
Cell[49413, 1458, 512, 11, 24, "Print"],
Cell[49928, 1471, 513, 11, 24, "Print"],
Cell[50444, 1484, 527, 12, 22, "Print"],
Cell[50974, 1498, 37, 1, 22, "Print"],
Cell[51014, 1501, 512, 11, 24, "Print"],
Cell[51529, 1514, 514, 11, 24, "Print"],
Cell[52046, 1527, 527, 12, 22, "Print"],
Cell[52576, 1541, 37, 1, 22, "Print"],
Cell[52616, 1544, 512, 11, 24, "Print"],
Cell[53131, 1557, 514, 11, 24, "Print"],
Cell[53648, 1570, 527, 12, 22, "Print"],
Cell[54178, 1584, 37, 1, 22, "Print"],
Cell[54218, 1587, 514, 11, 24, "Print"],
Cell[54735, 1600, 516, 11, 24, "Print"],
Cell[55254, 1613, 529, 12, 22, "Print"],
Cell[55786, 1627, 37, 1, 22, "Print"],
Cell[55826, 1630, 514, 11, 24, "Print"],
Cell[56343, 1643, 517, 11, 24, "Print"],
Cell[56863, 1656, 529, 12, 22, "Print"],
Cell[57395, 1670, 37, 1, 22, "Print"],
Cell[57435, 1673, 513, 11, 24, "Print"],
Cell[57951, 1686, 517, 11, 24, "Print"],
Cell[58471, 1699, 529, 12, 22, "Print"],
Cell[59003, 1713, 37, 1, 22, "Print"],
Cell[59043, 1716, 514, 11, 24, "Print"],
Cell[59560, 1729, 517, 11, 24, "Print"],
Cell[60080, 1742, 529, 12, 22, "Print"],
Cell[60612, 1756, 37, 1, 22, "Print"],
Cell[60652, 1759, 513, 11, 24, "Print"],
Cell[61168, 1772, 517, 11, 24, "Print"],
Cell[61688, 1785, 529, 12, 22, "Print"],
Cell[62220, 1799, 37, 1, 22, "Print"],
Cell[62260, 1802, 513, 11, 24, "Print"],
Cell[62776, 1815, 518, 11, 24, "Print"],
Cell[63297, 1828, 529, 12, 22, "Print"],
Cell[63829, 1842, 37, 1, 22, "Print"],
Cell[63869, 1845, 514, 11, 24, "Print"],
Cell[64386, 1858, 518, 11, 24, "Print"],
Cell[64907, 1871, 529, 12, 22, "Print"],
Cell[65439, 1885, 37, 1, 22, "Print"],
Cell[65479, 1888, 514, 11, 24, "Print"],
Cell[65996, 1901, 518, 11, 24, "Print"],
Cell[66517, 1914, 528, 12, 22, "Print"],
Cell[67048, 1928, 37, 1, 22, "Print"],
Cell[67088, 1931, 514, 11, 24, "Print"],
Cell[67605, 1944, 518, 11, 24, "Print"],
Cell[68126, 1957, 529, 12, 22, "Print"],
Cell[68658, 1971, 37, 1, 22, "Print"],
Cell[68698, 1974, 514, 11, 24, "Print"],
Cell[69215, 1987, 518, 11, 24, "Print"],
Cell[69736, 2000, 528, 12, 22, "Print"],
Cell[70267, 2014, 37, 1, 22, "Print"],
Cell[70307, 2017, 514, 11, 24, "Print"],
Cell[70824, 2030, 518, 11, 24, "Print"],
Cell[71345, 2043, 531, 12, 22, "Print"],
Cell[71879, 2057, 37, 1, 22, "Print"],
Cell[71919, 2060, 513, 11, 24, "Print"],
Cell[72435, 2073, 517, 11, 24, "Print"],
Cell[72955, 2086, 562, 13, 22, "Print"],
Cell[73520, 2101, 37, 1, 22, "Print"],
Cell[73560, 2104, 514, 11, 24, "Print"],
Cell[74077, 2117, 520, 11, 24, "Print"],
Cell[74600, 2130, 562, 13, 22, "Print"],
Cell[75165, 2145, 37, 1, 22, "Print"],
Cell[75205, 2148, 513, 11, 24, "Print"],
Cell[75721, 2161, 520, 11, 24, "Print"],
Cell[76244, 2174, 564, 13, 22, "Print"],
Cell[76811, 2189, 37, 1, 22, "Print"],
Cell[76851, 2192, 515, 11, 24, "Print"],
Cell[77369, 2205, 520, 11, 24, "Print"],
Cell[77892, 2218, 562, 13, 22, "Print"],
Cell[78457, 2233, 37, 1, 22, "Print"],
Cell[78497, 2236, 38, 1, 22, "Print"],
Cell[78538, 2239, 477, 11, 22, "Print"],
Cell[79018, 2252, 487, 11, 22, "Print"],
Cell[79508, 2265, 498, 11, 22, "Print"],
Cell[80009, 2278, 37, 1, 22, "Print"],
Cell[80049, 2281, 481, 11, 22, "Print"],
Cell[80533, 2294, 491, 11, 22, "Print"],
Cell[81027, 2307, 498, 11, 22, "Print"],
Cell[81528, 2320, 37, 1, 22, "Print"],
Cell[81568, 2323, 497, 11, 22, "Print"],
Cell[82068, 2336, 507, 11, 22, "Print"],
Cell[82578, 2349, 498, 11, 22, "Print"],
Cell[83079, 2362, 37, 1, 22, "Print"],
Cell[83119, 2365, 498, 11, 22, "Print"],
Cell[83620, 2378, 508, 11, 22, "Print"],
Cell[84131, 2391, 498, 11, 22, "Print"],
Cell[84632, 2404, 37, 1, 22, "Print"],
Cell[84672, 2407, 509, 11, 22, "Print"],
Cell[85184, 2420, 508, 11, 22, "Print"],
Cell[85695, 2433, 526, 12, 22, "Print"],
Cell[86224, 2447, 37, 1, 22, "Print"],
Cell[86264, 2450, 508, 11, 22, "Print"],
Cell[86775, 2463, 508, 11, 22, "Print"],
Cell[87286, 2476, 527, 12, 22, "Print"],
Cell[87816, 2490, 37, 1, 22, "Print"],
Cell[87856, 2493, 509, 11, 22, "Print"],
Cell[88368, 2506, 509, 11, 22, "Print"],
Cell[88880, 2519, 526, 12, 22, "Print"],
Cell[89409, 2533, 37, 1, 22, "Print"],
Cell[89449, 2536, 509, 11, 22, "Print"],
Cell[89961, 2549, 509, 11, 22, "Print"],
Cell[90473, 2562, 527, 12, 22, "Print"],
Cell[91003, 2576, 37, 1, 22, "Print"],
Cell[91043, 2579, 509, 11, 22, "Print"],
Cell[91555, 2592, 509, 11, 22, "Print"],
Cell[92067, 2605, 527, 12, 22, "Print"],
Cell[92597, 2619, 37, 1, 22, "Print"],
Cell[92637, 2622, 511, 11, 22, "Print"],
Cell[93151, 2635, 511, 11, 22, "Print"],
Cell[93665, 2648, 529, 12, 22, "Print"],
Cell[94197, 2662, 37, 1, 22, "Print"],
Cell[94237, 2665, 511, 11, 22, "Print"],
Cell[94751, 2678, 511, 11, 22, "Print"],
Cell[95265, 2691, 529, 12, 22, "Print"],
Cell[95797, 2705, 37, 1, 22, "Print"],
Cell[95837, 2708, 514, 11, 24, "Print"],
Cell[96354, 2721, 515, 11, 24, "Print"],
Cell[96872, 2734, 529, 12, 22, "Print"],
Cell[97404, 2748, 37, 1, 22, "Print"],
Cell[97444, 2751, 514, 11, 24, "Print"],
Cell[97961, 2764, 515, 11, 24, "Print"],
Cell[98479, 2777, 529, 12, 22, "Print"],
Cell[99011, 2791, 37, 1, 22, "Print"],
Cell[99051, 2794, 514, 11, 24, "Print"],
Cell[99568, 2807, 515, 11, 24, "Print"],
Cell[100086, 2820, 529, 12, 22, "Print"],
Cell[100618, 2834, 37, 1, 22, "Print"],
Cell[100658, 2837, 514, 11, 24, "Print"],
Cell[101175, 2850, 515, 11, 24, "Print"],
Cell[101693, 2863, 529, 12, 22, "Print"],
Cell[102225, 2877, 37, 1, 22, "Print"],
Cell[102265, 2880, 513, 11, 24, "Print"],
Cell[102781, 2893, 515, 11, 24, "Print"],
Cell[103299, 2906, 528, 12, 22, "Print"],
Cell[103830, 2920, 37, 1, 22, "Print"],
Cell[103870, 2923, 514, 11, 24, "Print"],
Cell[104387, 2936, 515, 11, 24, "Print"],
Cell[104905, 2949, 529, 12, 22, "Print"],
Cell[105437, 2963, 37, 1, 22, "Print"],
Cell[105477, 2966, 514, 11, 24, "Print"],
Cell[105994, 2979, 515, 11, 24, "Print"],
Cell[106512, 2992, 529, 12, 22, "Print"],
Cell[107044, 3006, 37, 1, 22, "Print"],
Cell[107084, 3009, 513, 11, 24, "Print"],
Cell[107600, 3022, 515, 11, 24, "Print"],
Cell[108118, 3035, 529, 12, 22, "Print"],
Cell[108650, 3049, 37, 1, 22, "Print"],
Cell[108690, 3052, 514, 11, 24, "Print"],
Cell[109207, 3065, 515, 11, 24, "Print"],
Cell[109725, 3078, 529, 12, 22, "Print"],
Cell[110257, 3092, 37, 1, 22, "Print"],
Cell[110297, 3095, 514, 11, 24, "Print"],
Cell[110814, 3108, 516, 11, 24, "Print"],
Cell[111333, 3121, 529, 12, 22, "Print"],
Cell[111865, 3135, 37, 1, 22, "Print"],
Cell[111905, 3138, 514, 11, 24, "Print"],
Cell[112422, 3151, 516, 11, 24, "Print"],
Cell[112941, 3164, 531, 12, 22, "Print"],
Cell[113475, 3178, 37, 1, 22, "Print"],
Cell[113515, 3181, 513, 11, 24, "Print"],
Cell[114031, 3194, 516, 11, 24, "Print"],
Cell[114550, 3207, 531, 12, 22, "Print"],
Cell[115084, 3221, 37, 1, 22, "Print"],
Cell[115124, 3224, 514, 11, 24, "Print"],
Cell[115641, 3237, 516, 11, 24, "Print"],
Cell[116160, 3250, 560, 13, 22, "Print"],
Cell[116723, 3265, 37, 1, 22, "Print"],
Cell[116763, 3268, 514, 11, 24, "Print"],
Cell[117280, 3281, 516, 11, 24, "Print"],
Cell[117799, 3294, 560, 13, 22, "Print"],
Cell[118362, 3309, 37, 1, 22, "Print"],
Cell[118402, 3312, 70, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[118509, 3318, 46, 1, 27, "Input"],
Cell[118558, 3321, 41, 1, 26, "Output"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{
Cell[118648, 3328, 53, 0, 28, "Subsection"],
Cell[118704, 3330, 142, 2, 43, "Input"],

Cell[CellGroupData[{
Cell[118871, 3336, 46, 1, 27, "Input"],
Cell[118920, 3339, 41, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[118998, 3345, 124, 4, 42, "Input"],
Cell[119125, 3351, 402, 10, 22, "Print"],
Cell[119530, 3363, 412, 10, 22, "Print"],
Cell[119945, 3375, 425, 10, 22, "Print"],
Cell[120373, 3387, 37, 1, 22, "Print"],
Cell[120413, 3390, 404, 10, 22, "Print"],
Cell[120820, 3402, 414, 10, 22, "Print"],
Cell[121237, 3414, 425, 10, 22, "Print"],
Cell[121665, 3426, 37, 1, 22, "Print"],
Cell[121705, 3429, 420, 10, 22, "Print"],
Cell[122128, 3441, 430, 10, 22, "Print"],
Cell[122561, 3453, 425, 10, 22, "Print"],
Cell[122989, 3465, 37, 1, 22, "Print"],
Cell[123029, 3468, 421, 10, 22, "Print"],
Cell[123453, 3480, 431, 10, 22, "Print"],
Cell[123887, 3492, 425, 10, 22, "Print"],
Cell[124315, 3504, 37, 1, 22, "Print"],
Cell[124355, 3507, 421, 10, 22, "Print"],
Cell[124779, 3519, 431, 10, 22, "Print"],
Cell[125213, 3531, 425, 10, 22, "Print"],
Cell[125641, 3543, 37, 1, 22, "Print"],
Cell[125681, 3546, 421, 10, 22, "Print"],
Cell[126105, 3558, 431, 10, 22, "Print"],
Cell[126539, 3570, 425, 10, 22, "Print"],
Cell[126967, 3582, 37, 1, 22, "Print"],
Cell[127007, 3585, 434, 10, 22, "Print"],
Cell[127444, 3597, 431, 10, 22, "Print"],
Cell[127878, 3609, 447, 10, 22, "Print"],
Cell[128328, 3621, 37, 1, 22, "Print"],
Cell[128368, 3624, 433, 10, 22, "Print"],
Cell[128804, 3636, 431, 10, 22, "Print"],
Cell[129238, 3648, 447, 10, 22, "Print"],
Cell[129688, 3660, 37, 1, 22, "Print"],
Cell[129728, 3663, 434, 10, 22, "Print"],
Cell[130165, 3675, 431, 10, 22, "Print"],
Cell[130599, 3687, 447, 10, 22, "Print"],
Cell[131049, 3699, 37, 1, 22, "Print"],
Cell[131089, 3702, 433, 10, 22, "Print"],
Cell[131525, 3714, 418, 10, 22, "Print"],
Cell[131946, 3726, 446, 10, 22, "Print"],
Cell[132395, 3738, 37, 1, 22, "Print"],
Cell[132435, 3741, 436, 10, 22, "Print"],
Cell[132874, 3753, 433, 10, 22, "Print"],
Cell[133310, 3765, 449, 10, 22, "Print"],
Cell[133762, 3777, 37, 1, 22, "Print"],
Cell[133802, 3780, 436, 10, 22, "Print"],
Cell[134241, 3792, 434, 10, 22, "Print"],
Cell[134678, 3804, 449, 10, 22, "Print"],
Cell[135130, 3816, 37, 1, 22, "Print"],
Cell[135170, 3819, 434, 10, 22, "Print"],
Cell[135607, 3831, 434, 10, 22, "Print"],
Cell[136044, 3843, 449, 10, 22, "Print"],
Cell[136496, 3855, 37, 1, 22, "Print"],
Cell[136536, 3858, 436, 10, 22, "Print"],
Cell[136975, 3870, 434, 10, 22, "Print"],
Cell[137412, 3882, 449, 10, 22, "Print"],
Cell[137864, 3894, 37, 1, 22, "Print"],
Cell[137904, 3897, 436, 10, 22, "Print"],
Cell[138343, 3909, 434, 10, 22, "Print"],
Cell[138780, 3921, 446, 10, 22, "Print"],
Cell[139229, 3933, 37, 1, 22, "Print"],
Cell[139269, 3936, 435, 10, 22, "Print"],
Cell[139707, 3948, 434, 10, 22, "Print"],
Cell[140144, 3960, 448, 10, 22, "Print"],
Cell[140595, 3972, 37, 1, 22, "Print"],
Cell[140635, 3975, 436, 10, 22, "Print"],
Cell[141074, 3987, 434, 10, 22, "Print"],
Cell[141511, 3999, 449, 10, 22, "Print"],
Cell[141963, 4011, 37, 1, 22, "Print"],
Cell[142003, 4014, 436, 10, 22, "Print"],
Cell[142442, 4026, 434, 10, 22, "Print"],
Cell[142879, 4038, 449, 10, 22, "Print"],
Cell[143331, 4050, 37, 1, 22, "Print"],
Cell[143371, 4053, 436, 10, 22, "Print"],
Cell[143810, 4065, 433, 10, 22, "Print"],
Cell[144246, 4077, 449, 10, 22, "Print"],
Cell[144698, 4089, 37, 1, 22, "Print"],
Cell[144738, 4092, 436, 10, 22, "Print"],
Cell[145177, 4104, 434, 10, 22, "Print"],
Cell[145614, 4116, 449, 10, 22, "Print"],
Cell[146066, 4128, 37, 1, 22, "Print"],
Cell[146106, 4131, 436, 10, 22, "Print"],
Cell[146545, 4143, 434, 10, 22, "Print"],
Cell[146982, 4155, 449, 10, 22, "Print"],
Cell[147434, 4167, 37, 1, 22, "Print"],
Cell[147474, 4170, 436, 10, 22, "Print"],
Cell[147913, 4182, 434, 10, 22, "Print"],
Cell[148350, 4194, 451, 10, 22, "Print"],
Cell[148804, 4206, 37, 1, 22, "Print"],
Cell[148844, 4209, 436, 10, 22, "Print"],
Cell[149283, 4221, 434, 10, 22, "Print"],
Cell[149720, 4233, 482, 11, 22, "Print"],
Cell[150205, 4246, 37, 1, 22, "Print"],
Cell[150245, 4249, 436, 10, 22, "Print"],
Cell[150684, 4261, 434, 10, 22, "Print"],
Cell[151121, 4273, 482, 11, 22, "Print"],
Cell[151606, 4286, 37, 1, 22, "Print"],
Cell[151646, 4289, 436, 10, 22, "Print"],
Cell[152085, 4301, 434, 10, 22, "Print"],
Cell[152522, 4313, 482, 11, 22, "Print"],
Cell[153007, 4326, 37, 1, 22, "Print"],
Cell[153047, 4329, 70, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[153154, 4335, 46, 1, 27, "Input"],
Cell[153203, 4338, 41, 1, 26, "Output"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{
Cell[153293, 4345, 60, 0, 28, "Subsection"],
Cell[153356, 4347, 142, 2, 43, "Input"],

Cell[CellGroupData[{
Cell[153523, 4353, 46, 1, 27, "Input"],
Cell[153572, 4356, 41, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[153650, 4362, 93, 1, 27, "Input"],
Cell[153746, 4365, 485, 11, 22, "Print"],
Cell[154234, 4378, 572, 14, 22, "Print"],
Cell[154809, 4394, 786, 20, 24, "Print"],
Cell[155598, 4416, 1019, 26, 24, "Print"],
Cell[156620, 4444, 1256, 32, 24, "Print"],
Cell[157879, 4478, 1474, 38, 39, "Print"],
Cell[159356, 4518, 1673, 43, 41, "Print"],
Cell[161032, 4563, 1989, 50, 75, "Print"],
Cell[163024, 4615, 2195, 55, 75, "Print"],
Cell[165222, 4672, 2459, 62, 92, "Print"],
Cell[167684, 4736, 2684, 67, 92, "Print"],
Cell[170371, 4805, 2961, 74, 109, "Print"],
Cell[173335, 4881, 3169, 79, 109, "Print"],
Cell[176507, 4962, 3437, 86, 126, "Print"],
Cell[179947, 5050, 3648, 91, 126, "Print"],
Cell[183598, 5143, 3924, 98, 143, "Print"],
Cell[187525, 5243, 4129, 103, 143, "Print"],
Cell[191657, 5348, 4401, 110, 160, "Print"],
Cell[196061, 5460, 4609, 115, 160, "Print"],
Cell[200673, 5577, 4881, 122, 177, "Print"],
Cell[205557, 5701, 5084, 127, 177, "Print"],
Cell[210644, 5830, 5357, 134, 194, "Print"],
Cell[216004, 5966, 5566, 139, 194, "Print"],
Cell[221573, 6107, 5810, 145, 211, "Print"],
Cell[227386, 6254, 6081, 152, 226, "Print"],
Cell[233470, 6408, 6319, 158, 228, "Print"],
Cell[239792, 6568, 70, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[239899, 6574, 46, 1, 27, "Input"],
Cell[239948, 6577, 41, 1, 26, "Output"]
}, Open  ]]
}, Closed]]
}, Closed]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

