(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 3.0,
MathReader 3.0, or any compatible application. The data for the notebook 
starts with the line of stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[    648770,      12968]*)
(*NotebookOutlinePosition[    649608,      12995]*)
(*  CellTagsIndexPosition[    649564,      12991]*)
(*WindowFrame->Normal*)



Notebook[{
Cell[TextData[{
  " :Author:  Z\[EAcute]lia da ROCHA \n\n:Address: \n            Departamento \
de Matem\[AAcute]tica Aplicada da\n            Faculdade de Ci\[EHat]ncias do \
Porto\n            Rua das Taipas, 135\n            4050 Porto\n            \
Portugal\n  \n            Tel: ++351 02 2080313\n            Fax: ++351 02 \
2004109\n            Email: mrdioh@fc.up.pt\n\n :Summary:\n    The ",
  StyleBox["testchv1",
    FontSize->18],
  " notebook contains the results produced by the package\n    chv.m \
corresponding to the ",
  StyleBox["example 1",
    FontSize->18],
  " of the first paper cited bellow.    \n\n :Date: July 1999. \n\n:Available \
at http://netlib.bell-labs.com/ in the numeralgo library in netlib:     \n\n \
:Notebook Version: 1.0 \n\n :Mathematica Version: 3.0   \n \n :Keywords: \
chebyshev's method, recurrence relations,  orthogonal polynomials \n  of \
dimension d, d-dimensional forms.\n\n :Sources:\n \n - Z\[EAcute]lia da \
Rocha, Shohat-Favard and Chebyshev's methods in d-orthogonality, \n Numerical \
Algorithms, 20 (1999) 139-164.\n   \n - About the example treated here see \
p.239 of:\n   A. Prudnikov, Orthogonal polynomials with ultra-exponential \
weight functions, \n   J.Comput.Appl.Math., 48 (1993) 239-241.\n"
}], "Subsection"],

Cell[CellGroupData[{

Cell["\<\
Computing the recurrence coefficients and the orthogonal \
polynomials performing formal computations\
\>", "Section",
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell["\<\
Loading the package chv.m, the package datachv1.m is automatically \
loaded \
\>", "Subsection"],

Cell[BoxData[
    \(\(<< chebyshev`chv`\ ; \)\)], "Input"]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
 The moments of the d-dimensional form are given in the package \
datachv1.m\
\>", "Subsection",
  AspectRatioFixed->True],

Cell[BoxData[
    \( (*\ showing\ the\ moments\ given\ *) \)], "Input"],

Cell[BoxData[
    \(\( (*\ set\ the\ values\ of\ d\ and\ imax\ *) \nd = 1; imax = \ 10; 
    \ \ \ \ \ \  (*\ for\ example\ *) \)\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Do[Print["\<form[\>", d, "\<,\>", r, "\<,\>", i, "\<]=\>", 
        form[d, r, i]], {r, 1, d}, {i, 0, imax}]\)], "Input"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]1\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]0
        \[InvisibleSpace]"]="\[InvisibleSpace]1\),
      SequenceForm[ "form[", 1, ",", 1, ",", 0, "]=", 1],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]1\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]"]="\[InvisibleSpace]1\),
      SequenceForm[ "form[", 1, ",", 1, ",", 1, "]=", 1],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]1\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]"]="\[InvisibleSpace]4\),
      SequenceForm[ "form[", 1, ",", 1, ",", 2, "]=", 4],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]1\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]"]="\[InvisibleSpace]36\),
      SequenceForm[ "form[", 1, ",", 1, ",", 3, "]=", 36],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]1\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]"]="\[InvisibleSpace]576\),
      SequenceForm[ "form[", 1, ",", 1, ",", 4, "]=", 576],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]1\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]"]="\[InvisibleSpace]14400\),
      SequenceForm[ "form[", 1, ",", 1, ",", 5, "]=", 14400],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]1\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]6
        \[InvisibleSpace]"]="\[InvisibleSpace]518400\),
      SequenceForm[ "form[", 1, ",", 1, ",", 6, "]=", 518400],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]1\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]7
        \[InvisibleSpace]"]="\[InvisibleSpace]25401600\),
      SequenceForm[ "form[", 1, ",", 1, ",", 7, "]=", 25401600],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]1\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]8
        \[InvisibleSpace]"]="\[InvisibleSpace]1625702400\),
      SequenceForm[ "form[", 1, ",", 1, ",", 8, "]=", 1625702400],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]1\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]9
        \[InvisibleSpace]"]="\[InvisibleSpace]131681894400\),
      SequenceForm[ "form[", 1, ",", 1, ",", 9, "]=", 131681894400],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]1\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]10
        \[InvisibleSpace]"]="\[InvisibleSpace]13168189440000\),
      SequenceForm[ "form[", 1, ",", 1, ",", 10, "]=", 13168189440000],
      Editable->False]], "Print"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Computing the gamma coefficients", "Subsection"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\( (*\ set\ the\ values\ of\ d\ and\ nmax\ *) \nd = 1; \ nmax = \ 30; 
    \ \ \ \ \  (*\ for\ example\ *) \)\)], "Input"],

Cell[BoxData[
    \(General::"spell1" \( : \ \) 
      "Possible spelling error: new symbol name \"\!\(nmax\)\" is similar to \
existing symbol \"\!\(imax\)\"."\)], "Message"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(MemoryInUse[]\)], "Input"],

Cell[BoxData[
    \(929728\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Timing[printgamma[d,nmax,Infinity,$MachinePrecision,False]]", "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    \("   "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]1\[InvisibleSpace]","\[InvisibleSpace]0
        \[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]"]="\[InvisibleSpace]3\),
      SequenceForm[ "gamma[", 1, ",", 0, ",", 1, "]=", 3],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]1\[InvisibleSpace]","\[InvisibleSpace]0
        \[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]"]="\[InvisibleSpace]656\/9\),
      SequenceForm[ "gamma[", 1, ",", 0, ",", 2, "]=", 
        Rational[ 656, 9]],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]1\[InvisibleSpace]","\[InvisibleSpace]0
        \[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]"]="\[InvisibleSpace]690363\/1681\),
      SequenceForm[ "gamma[", 1, ",", 0, ",", 3, "]=", 
        Rational[ 690363, 1681]],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]1\[InvisibleSpace]","\[InvisibleSpace]0
        \[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]"]="\[InvisibleSpace]1222773504\/896809\),
      SequenceForm[ "gamma[", 1, ",", 0, ",", 4, "]=", 
        Rational[ 1222773504, 896809]],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]1\[InvisibleSpace]","\[InvisibleSpace]0
        \[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]"]="\[InvisibleSpace]46476303126875\/13572017001\),
      SequenceForm[ "gamma[", 1, ",", 0, ",", 5, "]=", 
        Rational[ 46476303126875, 13572017001]],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]1\[InvisibleSpace]","\[InvisibleSpace]0
        \[InvisibleSpace]","\[InvisibleSpace]6
        \[InvisibleSpace]"]="\[InvisibleSpace]44597497750055921808
          \/6165994861774801\),
      SequenceForm[ "gamma[", 1, ",", 0, ",", 6, "]=", 
        Rational[ 44597497750055921808, 6165994861774801]],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]1\[InvisibleSpace]","\[InvisibleSpace]0
        \[InvisibleSpace]","\[InvisibleSpace]7
        \[InvisibleSpace]"]="\[InvisibleSpace]95931379685651794239752420211
          \/7067268727319545381861849\),
      SequenceForm[ "gamma[", 1, ",", 0, ",", 7, "]=", 
        Rational[ 95931379685651794239752420211, 7067268727319545381861849]],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]1\[InvisibleSpace]","\[InvisibleSpace]0
        \[InvisibleSpace]","\[InvisibleSpace]8
        \[InvisibleSpace]"]="\[InvisibleSpace]\
6053001749470244035369293961969907929088\/258901104079971380251735425022272921
          \),
      SequenceForm[ "gamma[", 1, ",", 0, ",", 8, "]=", 
        Rational[ 
        6053001749470244035369293961969907929088, 
          258901104079971380251735425022272921]],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]1\[InvisibleSpace]","\[InvisibleSpace]0
        \[InvisibleSpace]","\[InvisibleSpace]9
        \[InvisibleSpace]"]="\[InvisibleSpace]\
11657978535342834376364927947613578720236137625011451
          \/309008266428096320902238795683647025301011376041\),
      SequenceForm[ "gamma[", 1, ",", 0, ",", 9, "]=", 
        Rational[ 
        11657978535342834376364927947613578720236137625011451, 
          309008266428096320902238795683647025301011376041]],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]1\[InvisibleSpace]","\[InvisibleSpace]0
        \[InvisibleSpace]","\[InvisibleSpace]10
        \[InvisibleSpace]"]="\[InvisibleSpace]\
8707979811970751947011253827065086218662468134690555054474890000
          \/150552338547290281132372673279400531981412908532193330346481\),
      SequenceForm[ "gamma[", 1, ",", 0, ",", 10, "]=", 
        Rational[ 
        8707979811970751947011253827065086218662468134690555054474890000, 
          150552338547290281132372673279400531981412908532193330346481]],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]1\[InvisibleSpace]","\[InvisibleSpace]0
        \[InvisibleSpace]","\[InvisibleSpace]11
        \[InvisibleSpace]"]="\[InvisibleSpace]\
208803286870358009304992889202769180095410223412575065528483723776807581168403
          \/245394446181700889690244233682835562869178480605918251127691132713\
0393881\),
      SequenceForm[ "gamma[", 1, ",", 0, ",", 11, "]=", 
        Rational[ 
        2088032868703580093049928892027691800954102234125750655284837237768075\
81168403, 
          24539444618170088969024423368283556286917848060591825112769113271303\
93881]],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]1\[InvisibleSpace]","\[InvisibleSpace]0
        \[InvisibleSpace]","\[InvisibleSpace]12
        \[InvisibleSpace]"]="\[InvisibleSpace]\
163452348782623815886830687168935888851973552145560577926544578637507676896274\
773487611323136/
          13509699049650717787584021087325494843502754000666349040690162012327\
01654286248240290969\),
      SequenceForm[ "gamma[", 1, ",", 0, ",", 12, "]=", 
        Rational[ 
        1634523487826238158868306871689358888519735521455605779265445786375076\
76896274773487611323136, 
          13509699049650717787584021087325494843502754000666349040690162012327\
01654286248240290969]],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]1\[InvisibleSpace]","\[InvisibleSpace]0
        \[InvisibleSpace]","\[InvisibleSpace]13
        \[InvisibleSpace]"]="\[InvisibleSpace]\
470400404499660199313413442387078304848986389673905699558902877302596049463686\
726456461614125611754516959227/
          28133588060915736564606402251037209319124894139105287563560211231648\
70537928897455144840942333704247369\),
      SequenceForm[ "gamma[", 1, ",", 0, ",", 13, "]=", 
        Rational[ 
        4704004044996601993134134423870783048489863896739056995589028773025960\
49463686726456461614125611754516959227, 
          28133588060915736564606402251037209319124894139105287563560211231648\
70537928897455144840942333704247369]],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]1\[InvisibleSpace]","\[InvisibleSpace]0
        \[InvisibleSpace]","\[InvisibleSpace]14
        \[InvisibleSpace]"]="\[InvisibleSpace]\
452857786546145007626905242052058233850710891045035699049771304944812235436728\
00187529274879897129054562424897392350788123536/
          20079037002791665363262414191766720770149451386332384567762599759135\
3510225536816527038458198224179623431694137888609121\),
      SequenceForm[ "gamma[", 1, ",", 0, ",", 14, "]=", 
        Rational[ 
        4528577865461450076269052420520582338507108910450356990497713049448122\
3543672800187529274879897129054562424897392350788123536, 
          20079037002791665363262414191766720770149451386332384567762599759135\
3510225536816527038458198224179623431694137888609121]],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]1\[InvisibleSpace]","\[InvisibleSpace]0
        \[InvisibleSpace]","\[InvisibleSpace]15
        \[InvisibleSpace]"]="\[InvisibleSpace]\
147168812009336300312407421140805037559923729058452588804830457855536235845802\
983554679912674842815007297677113120477749558997931982107740291875/
          49394008196371772927408003576029859701563226743324499142178078270323\
1450523254593751923055879808945786255206368005318659629684525909334889\),
      SequenceForm[ "gamma[", 1, ",", 0, ",", 15, "]=", 
        Rational[ 
        1471688120093363003124074211408050375599237290584525888048304578555362\
35845802983554679912674842815007297677113120477749558997931982107740291875, 
          49394008196371772927408003576029859701563226743324499142178078270323\
1450523254593751923055879808945786255206368005318659629684525909334889]],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]1\[InvisibleSpace]","\[InvisibleSpace]0
        \[InvisibleSpace]","\[InvisibleSpace]16
        \[InvisibleSpace]"]="\[InvisibleSpace]\
131775219781675392413420071911815111934608860247103753522038658982131824172945\
335504581599581632894545598208347514752914090325662686189585707212991982105646\
6295652352/
          34091305666654251126009495048896738596210841992932749151820863910961\
387785491866259691489072905016026047015415271428486407761192130342812075105342\
51322824680889\),
      SequenceForm[ "gamma[", 1, ",", 0, ",", 16, "]=", 
        Rational[ 
        1317752197816753924134200719118151119346088602471037535220386589821318\
241729453355045815995816328945455982083475147529140903256626861895857072129919\
821056466295652352, 
          34091305666654251126009495048896738596210841992932749151820863910961\
387785491866259691489072905016026047015415271428486407761192130342812075105342\
51322824680889]],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]1\[InvisibleSpace]","\[InvisibleSpace]0
        \[InvisibleSpace]","\[InvisibleSpace]17
        \[InvisibleSpace]"]="\[InvisibleSpace]\
403981397593721382122682521898092265736723036272011448389119665510308740246649\
851586686949844407866079043147748653749114742357428686923527735436351169941973\
979790641575809358090798232545859/
          81852767488266907835690358521366009329964250574787474533558114929556\
659251863390100768637850695614499069585349979378993381132231424539973765995526\
3508718717127584391461816206105519041\),
      SequenceForm[ "gamma[", 1, ",", 0, ",", 17, "]=", 
        Rational[ 
        4039813975937213821226825218980922657367230362720114483891196655103087\
402466498515866869498444078660790431477486537491147423574286869235277354363511\
69941973979790641575809358090798232545859, 
          81852767488266907835690358521366009329964250574787474533558114929556\
659251863390100768637850695614499069585349979378993381132231424539973765995526\
3508718717127584391461816206105519041]],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]1\[InvisibleSpace]","\[InvisibleSpace]0
        \[InvisibleSpace]","\[InvisibleSpace]18
        \[InvisibleSpace]"]="\[InvisibleSpace]\
426421895977935078687806294728003218906360072364686702566534685600078450167866\
379167347736464270010050001259056878364028993028155513892295041465030451206807\
6942694285100091342485941904657580908889424104319058675472/
          68625848784083652757122685706343390589067587260532021691110649839257\
127896048941330617147993851170890843571749906395115169215737820186488025691824\
77492745324762749732712239710253124726684309012059360281135569\),
      SequenceForm[ "gamma[", 1, ",", 0, ",", 18, "]=", 
        Rational[ 
        4264218959779350786878062947280032189063600723646867025665346856000784\
501678663791673477364642700100500012590568783640289930281555138922950414650304\
512068076942694285100091342485941904657580908889424104319058675472, 
          68625848784083652757122685706343390589067587260532021691110649839257\
127896048941330617147993851170890843571749906395115169215737820186488025691824\
77492745324762749732712239710253124726684309012059360281135569]],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]1\[InvisibleSpace]","\[InvisibleSpace]0
        \[InvisibleSpace]","\[InvisibleSpace]19
        \[InvisibleSpace]"]="\[InvisibleSpace]\
140163788768951837066780684165069443891793891196585133848004015304675695040707\
655093399722853990893793792789504306546590492575706003638723266673508109496357\
127313436914712153175577773007574724597584808640925313249883976955998686320116\
63143811/181429579706202950054169912159295309712900584575258948657982385274362\
642457118906525679057505800979686982089262625564279338526652579509721501908621\
920920929865279987761847674846957268970516118802721377549343332362023987722913\
15620580841\),
      SequenceForm[ "gamma[", 1, ",", 0, ",", 19, "]=", 
        Rational[ 
        1401637887689518370667806841650694438917938911965851338480040153046756\
950407076550933997228539908937937927895043065465904925757060036387232666735081\
094963571273134369147121531755777730075747245975848086409253132498839769559986\
8632011663143811, 
          18142957970620295005416991215929530971290058457525894865798238527436\
264245711890652567905750580097968698208926262556427933852665257950972150190862\
192092092986527998776184767484695726897051611880272137754934333236202398772291\
315620580841]],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]1\[InvisibleSpace]","\[InvisibleSpace]0
        \[InvisibleSpace]","\[InvisibleSpace]20
        \[InvisibleSpace]"]="\[InvisibleSpace]\
160093611068986543448500645241284264173619910356166431180117251209083603655232\
636050007842422761901926140141469882960548033442134384684336606321427414179530\
044450660194303403148976244878309374691675903609972563080531667228938901443451\
6802426633562020061532406375625440000/
          16856023194727879440717385278254842073603073936360095296534916780406\
717362161614984870743663268631835437066759282495132774191507645418981486190653\
815250948380964294931333558744332889585144160925571957721045785056356233783807\
85204470687370026879097694207319294359449\),
      SequenceForm[ "gamma[", 1, ",", 0, ",", 20, "]=", 
        Rational[ 
        1600936110689865434485006452412842641736199103561664311801172512090836\
036552326360500078424227619019261401414698829605480334421343846843366063214274\
141795300444506601943034031489762448783093746916759036099725630805316672289389\
014434516802426633562020061532406375625440000, 
          16856023194727879440717385278254842073603073936360095296534916780406\
717362161614984870743663268631835437066759282495132774191507645418981486190653\
815250948380964294931333558744332889585144160925571957721045785056356233783807\
85204470687370026879097694207319294359449]],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]1\[InvisibleSpace]","\[InvisibleSpace]0
        \[InvisibleSpace]","\[InvisibleSpace]21
        \[InvisibleSpace]"]="\[InvisibleSpace]\
637830265217728504371154272829213589428882462000719534770740911516155428776361\
230333742536641387496154265766717667145356868629884946729963959073161571871802\
082515123862221677773301549042969153469774485267161160693185665424887682774870\
3901987121552092628081082916422364995724057393160746861618464173843/
          55182318246535034377488746975518304764975050072242733367466552701006\
102769865298278482281515290089420879022704578730041495005187811546545031827569\
605138947546249358689863712519428591424923900345647308584927113790030417477503\
88340134294488548820078157289425384740492235261551197531630633221973841\),
      SequenceForm[ "gamma[", 1, ",", 0, ",", 21, "]=", 
        Rational[ 
        6378302652177285043711542728292135894288824620007195347707409115161554\
287763612303337425366413874961542657667176671453568686298849467299639590731615\
718718020825151238622216777733015490429691534697744852671611606931856654248876\
827748703901987121552092628081082916422364995724057393160746861618464173843, 
          55182318246535034377488746975518304764975050072242733367466552701006\
102769865298278482281515290089420879022704578730041495005187811546545031827569\
605138947546249358689863712519428591424923900345647308584927113790030417477503\
88340134294488548820078157289425384740492235261551197531630633221973841]],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]1\[InvisibleSpace]","\[InvisibleSpace]0
        \[InvisibleSpace]","\[InvisibleSpace]22
        \[InvisibleSpace]"]="\[InvisibleSpace]\
109803177750604704654693959126609228960008170341015200422148167828320333648015\
055861587146229585729396926105270012907779192465351759111340061463050244498124\
483917317629640614512216600724074470521526770342114891745126106325085406997809\
529130449157271934307513917419684462616333528964054982956633055985164283752866\
84517916901501062544/
          78779958666266674666436135996350255062781155625333978720587182718105\
542727219870482061774850843490976203801361153205589196948561402276308092562479\
266720037183284897062497979272336636736261918496377560535987832636459680717269\
524665955063981147297852496458356903904677537467073173287509324121735258194211\
07717461979435528544161\),
      SequenceForm[ "gamma[", 1, ",", 0, ",", 22, "]=", 
        Rational[ 
        1098031777506047046546939591266092289600081703410152004221481678283203\
336480150558615871462295857293969261052700129077791924653517591113400614630502\
444981244839173176296406145122166007240744705215267703421148917451261063250854\
069978095291304491572719343075139174196844626163335289640549829566330559851642\
8375286684517916901501062544, 
          78779958666266674666436135996350255062781155625333978720587182718105\
542727219870482061774850843490976203801361153205589196948561402276308092562479\
266720037183284897062497979272336636736261918496377560535987832636459680717269\
524665955063981147297852496458356903904677537467073173287509324121735258194211\
07717461979435528544161]],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]1\[InvisibleSpace]","\[InvisibleSpace]0
        \[InvisibleSpace]","\[InvisibleSpace]23
        \[InvisibleSpace]"]="\[InvisibleSpace]\
663600031373478821722116435081356512242521160516582661011043810278741089113198\
032878905668391279153168328696135256551354490688064699752548752275057292875976\
090904501077743293286954037659324265890630381337210909368647217574208869135144\
972400425747010664499438680005877922687481310795727696590205715442609693416420\
410189947555440602610176762401326208338145920057323/
          39815156746154488324187905678103796671496989184002178754841378087195\
632469335871142091609872944710612581060761832299302126707679077621679104510451\
051724234507918266623614607078421909356706674061743744562420177075175833118550\
193149388455968167235001538512186400333569182422993171859086688534413776070862\
8515052490580964527507420643045899633626654639028196161\),
      SequenceForm[ "gamma[", 1, ",", 0, ",", 23, "]=", 
        Rational[ 
        6636000313734788217221164350813565122425211605165826610110438102787410\
891131980328789056683912791531683286961352565513544906880646997525487522750572\
928759760909045010777432932869540376593242658906303813372109093686472175742088\
691351449724004257470106644994386800058779226874813107957276965902057154426096\
93416420410189947555440602610176762401326208338145920057323, 
          39815156746154488324187905678103796671496989184002178754841378087195\
632469335871142091609872944710612581060761832299302126707679077621679104510451\
051724234507918266623614607078421909356706674061743744562420177075175833118550\
193149388455968167235001538512186400333569182422993171859086688534413776070862\
8515052490580964527507420643045899633626654639028196161]],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]1\[InvisibleSpace]","\[InvisibleSpace]0
        \[InvisibleSpace]","\[InvisibleSpace]24
        \[InvisibleSpace]"]="\[InvisibleSpace]\
141178066097730956370003252883690233655455671016297193116311864119508096804242\
382678780001909530416327865097777988803702920245408022778385067240883082492576\
213690157389046490413741446463580402864754705348489465713226417589230745359153\
307621279732424226422572757553152461786324438651516682313582260184328554917862\
032737563080742680711986730450215872379023663530615854531884037733390310687706\
6809344/7137964094304810830367366674651072592068943328586619638684789989877999\
294729272176253166893517345838213898837195951086012152310816700451554673891819\
288365314255735105947829217753233800856691217923291494550028780070302862672252\
007106609423765337578300000301686232709588415619451743888861758984773410676682\
506840490680157804314350714624846743356110840898627568306850545493359741409135\
17655769\),
      SequenceForm[ "gamma[", 1, ",", 0, ",", 24, "]=", 
        Rational[ 
        1411780660977309563700032528836902336554556710162971931163118641195080\
968042423826787800019095304163278650977779888037029202454080227783850672408830\
824925762136901573890464904137414464635804028647547053484894657132264175892307\
453591533076212797324242264225727575531524617863244386515166823135822601843285\
549178620327375630807426807119867304502158723790236635306158545318840377333903\
106877066809344, 
          71379640943048108303673666746510725920689433285866196386847899898779\
992947292721762531668935173458382138988371959510860121523108167004515546738918\
192883653142557351059478292177532338008566912179232914945500287800703028626722\
520071066094237653375783000003016862327095884156194517438888617589847734106766\
825068404906801578043143507146248467433561108408986275683068505454933597414091\
3517655769]],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]1\[InvisibleSpace]","\[InvisibleSpace]0
        \[InvisibleSpace]","\[InvisibleSpace]25
        \[InvisibleSpace]"]="\[InvisibleSpace]\
695413175704981298060847196679119166832642911935460075388027196027374963835356\
273965154624283022045227275077705155613336330990501831571937371139144845326443\
445942889054037518556995349285873753141525024807302538124804813741715648549719\
986490569525193129065419692273588826668121978091308523159654521895663028171976\
048554404239039558333937833912222219318320703523980879166424049686692060788453\
671488413328635954628572694304982669469921875/
          29837754150350249164321114543200177069228154478614137953163384816550\
622272922749429296333577334081294553711994810696801419966047205268741403896569\
809959068294282380169781899897052660779861560163310228905434968352803591443036\
723316519137791544390204962921401084056202043047192715902071612500436260948883\
743147556445640390768425345690962546109156048193236694369944956551790222637015\
5291455320695534661503680628950910488361306088561\),
      SequenceForm[ "gamma[", 1, ",", 0, ",", 25, "]=", 
        Rational[ 
        6954131757049812980608471966791191668326429119354600753880271960273749\
638353562739651546242830220452272750777051556133363309905018315719373711391448\
453264434459428890540375185569953492858737531415250248073025381248048137417156\
485497199864905695251931290654196922735888266681219780913085231596545218956630\
281719760485544042390395583339378339122222193183207035239808791664240496866920\
60788453671488413328635954628572694304982669469921875, 
          29837754150350249164321114543200177069228154478614137953163384816550\
622272922749429296333577334081294553711994810696801419966047205268741403896569\
809959068294282380169781899897052660779861560163310228905434968352803591443036\
723316519137791544390204962921401084056202043047192715902071612500436260948883\
743147556445640390768425345690962546109156048193236694369944956551790222637015\
5291455320695534661503680628950910488361306088561]],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]1\[InvisibleSpace]","\[InvisibleSpace]0
        \[InvisibleSpace]","\[InvisibleSpace]26
        \[InvisibleSpace]"]="\[InvisibleSpace]\
121155109960859380025525759691426289615395895331871295120727174211061390927532\
640220309550065719534925981609445821281865534433236943503495792406014341434913\
146367029175953135508522805507753563410167211931247216829390967042032973678042\
293684606204127394896224323736072142050564097307278321538926028932380887004839\
228510149417372146655874437839104277083649054480748825318398045286227744332472\
521184603290115564853291979253611310470074870093366476752016393638135955701486\
15459088/444008619636834948126740581680446994221163264100843603685704055439590\
372049661236948003352070070825471117801850849121728515141968916506347811524419\
574807020315509608872769301592125289732276123189646618162564710910468042907082\
517078625699534857931683800873762390048658905770783869347477635527537070453169\
867763093603682280759646196258026850086763991777959968719848639584074864792909\
376499873635414472759141949120473830667576484843754179412192636726982295462718\
5192397521\),
      SequenceForm[ "gamma[", 1, ",", 0, ",", 26, "]=", 
        Rational[ 
        1211551099608593800255257596914262896153958953318712951207271742110613\
909275326402203095500657195349259816094458212818655344332369435034957924060143\
414349131463670291759531355085228055077535634101672119312472168293909670420329\
736780422936846062041273948962243237360721420505640973072783215389260289323808\
870048392285101494173721466558744378391042770836490544807488253183980452862277\
443324725211846032901155648532919792536113104700748700933664767520163936381359\
5570148615459088, 
          44400861963683494812674058168044699422116326410084360368570405543959\
037204966123694800335207007082547111780185084912172851514196891650634781152441\
957480702031550960887276930159212528973227612318964661816256471091046804290708\
251707862569953485793168380087376239004865890577078386934747763552753707045316\
986776309360368228075964619625802685008676399177795996871984863958407486479290\
937649987363541447275914194912047383066757648484375417941219263672698229546271\
85192397521]],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]1\[InvisibleSpace]","\[InvisibleSpace]0
        \[InvisibleSpace]","\[InvisibleSpace]27
        \[InvisibleSpace]"]="\[InvisibleSpace]\
748095966685774460377035207783404073214563333128548761583374484195153446762021\
269382743247063969703686508190075428165794613617904962884086604464341443500837\
056235840893687382098878196127589419314480302057823137245682415992188724771640\
949123248960922687872579198075333130999274550036922711130331044754577558715177\
982103969828571791712066121934989909806781201650686209177031514642407804531492\
940697866088165928659417190813711060830223274143884792524041746266426621244610\
8358227236261680766450693964961309155614757502011/
          23557573630451231623214472811441198020802565102196127395660890313667\
915995529092683268383243310748503508645595167480803954548330915702626318282915\
144011288695697293172521450214668895028280327135967343019106023732766891489405\
119684816309035513163654187649939603638150427856797246620663898671359869678394\
013126558285531265767209691472614596267539269062220059199984685495199251814727\
354065336316842627986059499507902172643402418929009524222338893288413752642614\
59823512714241652715753998073257700371589292217917329\),
      SequenceForm[ "gamma[", 1, ",", 0, ",", 27, "]=", 
        Rational[ 
        7480959666857744603770352077834040732145633331285487615833744841951534\
467620212693827432470639697036865081900754281657946136179049628840866044643414\
435008370562358408936873820988781961275894193144803020578231372456824159921887\
247716409491232489609226878725791980753331309992745500369227111303310447545775\
587151779821039698285717917120661219349899098067812016506862091770315146424078\
045314929406978660881659286594171908137110608302232741438847925240417462664266\
212446108358227236261680766450693964961309155614757502011, 
          23557573630451231623214472811441198020802565102196127395660890313667\
915995529092683268383243310748503508645595167480803954548330915702626318282915\
144011288695697293172521450214668895028280327135967343019106023732766891489405\
119684816309035513163654187649939603638150427856797246620663898671359869678394\
013126558285531265767209691472614596267539269062220059199984685495199251814727\
354065336316842627986059499507902172643402418929009524222338893288413752642614\
59823512714241652715753998073257700371589292217917329]],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]1\[InvisibleSpace]","\[InvisibleSpace]0
        \[InvisibleSpace]","\[InvisibleSpace]28
        \[InvisibleSpace]"]="\[InvisibleSpace]\
249999401460564587683069311445656260749062960041011919264939781956143026539275\
745261516196826315288473179253396036596143996084910943334164942760113943415186\
092583385539067130149099438552537158372236048879733808624911006933933203982918\
083760661662881565342058948685587396372061317518929444716701348501328818656275\
835719302513470080122968139579997121565930711090829464356334017891247063596697\
108155818975648614638029997528158580494779625661527686376193493050033704019904\
816856735807772569116176350740193827248147008298558055061078970895205547161221\
29162998528/
          68021009698033058961892135317905618185333252290420383770107953784021\
470977512112767873853033279966005496489465725185332403477823931392944026890028\
904517492373284971250714556522778204089433851018401648950339748543457691103097\
979464762466490191283105095832551913474956423855303520709506186328047061281552\
455141547646921437705860004044887607236838913386211776900464092483365684726252\
205781430657738010853785271989020949097090663119669551014149209449938968417819\
117612380331578823001750153159523639718234248096555076610440900052933570266254\
65470786940361\),
      SequenceForm[ "gamma[", 1, ",", 0, ",", 28, "]=", 
        Rational[ 
        2499994014605645876830693114456562607490629600410119192649397819561430\
265392757452615161968263152884731792533960365961439960849109433341649427601139\
434151860925833855390671301490994385525371583722360488797338086249110069339332\
039829180837606616628815653420589486855873963720613175189294447167013485013288\
186562758357193025134700801229681395799971215659307110908294643563340178912470\
635966971081558189756486146380299975281585804947796256615276863761934930500337\
040199048168567358077725691161763507401938272481470082985580550610789708952055\
4716122129162998528, 
          68021009698033058961892135317905618185333252290420383770107953784021\
470977512112767873853033279966005496489465725185332403477823931392944026890028\
904517492373284971250714556522778204089433851018401648950339748543457691103097\
979464762466490191283105095832551913474956423855303520709506186328047061281552\
455141547646921437705860004044887607236838913386211776900464092483365684726252\
205781430657738010853785271989020949097090663119669551014149209449938968417819\
117612380331578823001750153159523639718234248096555076610440900052933570266254\
65470786940361]],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]1\[InvisibleSpace]","\[InvisibleSpace]0
        \[InvisibleSpace]","\[InvisibleSpace]29
        \[InvisibleSpace]"]="\[InvisibleSpace]\
297173885005474622729134080898138217386413324978837870150008128553573807148149\
477435316916331849658993733803012024672367011446355935587589897010927607853544\
706982795282075954545237363389014752951443290941156391622480855988990638904296\
530473630293992454997777324357756597490598159328256455338907556371751815005443\
254022044957625070261585607452627233839031415553399857329313366198687420641824\
053752799490414714257142355972623331744283585708066458548990080614819840243620\
230565109108730379601183791868066315421777360622289465979257774224860298452860\
0641576090350501909899696820711044202753431066726891/
          70223606489633460273920655936773964333529682707338281145603406607223\
889155483646754443786214746693751085917449833836291654749647059667536014556913\
907238479084385424106126987608769845149440300162973449255824364951810660937495\
991209273975045388468295573870950845011815086695931606659118398946261868622840\
899218208345998611985289288472396184993013027273393692593608505542635439558648\
544297487446858935108409925079350797449252692227088404834378218985923829257271\
745562518167299749769144890193462836372623809849624097774080489607046085436210\
0026013387789807113326481250036284973446217591914935961\),
      SequenceForm[ "gamma[", 1, ",", 0, ",", 29, "]=", 
        Rational[ 
        2971738850054746227291340808981382173864133249788378701500081285535738\
071481494774353169163318496589937338030120246723670114463559355875898970109276\
078535447069827952820759545452373633890147529514432909411563916224808559889906\
389042965304736302939924549977773243577565974905981593282564553389075563717518\
150054432540220449576250702615856074526272338390314155533998573293133661986874\
206418240537527994904147142571423559726233317442835857080664585489900806148198\
402436202305651091087303796011837918680663154217773606222894659792577742248602\
984528600641576090350501909899696820711044202753431066726891, 
          70223606489633460273920655936773964333529682707338281145603406607223\
889155483646754443786214746693751085917449833836291654749647059667536014556913\
907238479084385424106126987608769845149440300162973449255824364951810660937495\
991209273975045388468295573870950845011815086695931606659118398946261868622840\
899218208345998611985289288472396184993013027273393692593608505542635439558648\
544297487446858935108409925079350797449252692227088404834378218985923829257271\
745562518167299749769144890193462836372623809849624097774080489607046085436210\
0026013387789807113326481250036284973446217591914935961]],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]1\[InvisibleSpace]","\[InvisibleSpace]0
        \[InvisibleSpace]","\[InvisibleSpace]30
        \[InvisibleSpace]"]="\[InvisibleSpace]\
125854354854191127195482514353087458543749053950156965460324388145111659200880\
475448002523894184271435089505344542640703599670719144576995113447405484135091\
238415378651250007737163317507592333261572272227648025581203800180139248511461\
393215279814551027693738683028555906162449578060358415862177685130951279078164\
175546291890159676354357522584325700940716332484154652968231484561805695859081\
420149151989925988922166506525733735386780632885400715825630628220514919390120\
496454520337906670924004323637201429413684185567069017763469376383659674346091\
325441119697688717806983384037025730852084487238758551469173985747498892678470\
09067777327930000/
          25953397975152914657997637359757445054176929296243059550314427124576\
845861326171371198660160025264895521821970616646378699734926700370687200650074\
807258336258247150149154272093216211817538530827825655413166429380534573302157\
432094745445858995918003305955631199746650243233236587494614731105159077797166\
402156344121805946607778464430407567752281297376714960224887797658304273703795\
586553452053015785368306404305280248042925184727486221202215591481807559362828\
362826578766529102208305321940984681196056549650315987242571572686778937861897\
855467218864336825282632467443403971613652242556123679750602376436739360266428\
64543849860221687761\),
      SequenceForm[ "gamma[", 1, ",", 0, ",", 30, "]=", 
        Rational[ 
        1258543548541911271954825143530874585437490539501569654603243881451116\
592008804754480025238941842714350895053445426407035996707191445769951134474054\
841350912384153786512500077371633175075923332615722722276480255812038001801392\
485114613932152798145510276937386830285559061624495780603584158621776851309512\
790781641755462918901596763543575225843257009407163324841546529682314845618056\
958590814201491519899259889221665065257337353867806328854007158256306282205149\
193901204964545203379066709240043236372014294136841855670690177634693763836596\
743460913254411196976887178069833840370257308520844872387585514691739857474988\
9267847009067777327930000, 
          25953397975152914657997637359757445054176929296243059550314427124576\
845861326171371198660160025264895521821970616646378699734926700370687200650074\
807258336258247150149154272093216211817538530827825655413166429380534573302157\
432094745445858995918003305955631199746650243233236587494614731105159077797166\
402156344121805946607778464430407567752281297376714960224887797658304273703795\
586553452053015785368306404305280248042925184727486221202215591481807559362828\
362826578766529102208305321940984681196056549650315987242571572686778937861897\
855467218864336825282632467443403971613652242556123679750602376436739360266428\
64543849860221687761]],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    \({14.9666666666666685`\ Second, Null}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(MemoryInUse[]\)], "Input"],

Cell[BoxData[
    \(1245768\)], "Output"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Computing the beta coefficients", "Subsection"],

Cell[BoxData[
    \(\( (*\ set\ the\ values\ of\ d\ and\ nmax\ *) \nd = 1; \ nmax = \ 30; 
    \ \ \ \ \  (*\ for\ example\ *) \)\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(MemoryInUse[]\)], "Input"],

Cell[BoxData[
    \(1247552\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Timing[printbeta[d,nmax,Infinity,$MachinePrecision,False]]", "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    InterpretationBox[
      \("beta["\[InvisibleSpace]1\[InvisibleSpace]","\[InvisibleSpace]0
        \[InvisibleSpace]"]="\[InvisibleSpace]1\),
      SequenceForm[ "beta[", 1, ",", 0, "]=", 1],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("beta["\[InvisibleSpace]1\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]"]="\[InvisibleSpace]29\/3\),
      SequenceForm[ "beta[", 1, ",", 1, "]=", 
        Rational[ 29, 3]],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("beta["\[InvisibleSpace]1\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]"]="\[InvisibleSpace]3467\/123\),
      SequenceForm[ "beta[", 1, ",", 2, "]=", 
        Rational[ 3467, 123]],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("beta["\[InvisibleSpace]1\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]"]="\[InvisibleSpace]2196517\/38827\),
      SequenceForm[ "beta[", 1, ",", 3, "]=", 
        Rational[ 2196517, 38827]],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("beta["\[InvisibleSpace]1\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]"]="\[InvisibleSpace]10461407993\/110324553\),
      SequenceForm[ "beta[", 1, ",", 4, "]=", 
        Rational[ 10461407993, 110324553]],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("beta["\[InvisibleSpace]1\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]"]="\[InvisibleSpace]1307645484218021\/9147949884651
          \),
      SequenceForm[ "beta[", 1, ",", 5, "]=", 
        Rational[ 1307645484218021, 9147949884651]],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("beta["\[InvisibleSpace]1\[InvisibleSpace]","\[InvisibleSpace]6
        \[InvisibleSpace]"]="\[InvisibleSpace]41944829400355568963411
          \/208750431519156515507\),
      SequenceForm[ "beta[", 1, ",", 6, "]=", 
        Rational[ 41944829400355568963411, 208750431519156515507]],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("beta["\[InvisibleSpace]1\[InvisibleSpace]","\[InvisibleSpace]7
        \[InvisibleSpace]"]="\[InvisibleSpace]\
363585736298731290065727811165063\/1352672789824976295577428827577\),
      SequenceForm[ "beta[", 1, ",", 7, "]=", 
        Rational[ 
        363585736298731290065727811165063, 1352672789824976295577428827577]],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("beta["\[InvisibleSpace]1\[InvisibleSpace]","\[InvisibleSpace]8
        \[InvisibleSpace]"]="\[InvisibleSpace]\
98011500294787726427844438613708242690301729
          \/282847275659625351243481410791721228349569\),
      SequenceForm[ "beta[", 1, ",", 8, "]=", 
        Rational[ 
        98011500294787726427844438613708242690301729, 
          282847275659625351243481410791721228349569]],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("beta["\[InvisibleSpace]1\[InvisibleSpace]","\[InvisibleSpace]9
        \[InvisibleSpace]"]="\[InvisibleSpace]\
93633654146355457764851955626247610364117858287044099781
          \/215689399695937841438282261227114031516434778415282811\),
      SequenceForm[ "beta[", 1, ",", 9, "]=", 
        Rational[ 
        93633654146355457764851955626247610364117858287044099781, 
          215689399695937841438282261227114031516434778415282811]],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("beta["\[InvisibleSpace]1\[InvisibleSpace]","\[InvisibleSpace]10
        \[InvisibleSpace]"]="\[InvisibleSpace]\
323104974822499624799747002110926706878650323536313082594736487216179
          \/607821583519146160952473674781581202013081475843352599136148874819
          \),
      SequenceForm[ "beta[", 1, ",", 10, "]=", 
        Rational[ 
        323104974822499624799747002110926706878650323536313082594736487216179,
           607821583519146160952473674781581202013081475843352599136148874819]\
],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("beta["\[InvisibleSpace]1\[InvisibleSpace]","\[InvisibleSpace]11
        \[InvisibleSpace]"]="\[InvisibleSpace]\
367872309922923634132778369490640046933603963534780053733032817909273228020979\
60951\/57577817919494732461678305185721226522413057132280840518125908945146242\
685670617\),
      SequenceForm[ "beta[", 1, ",", 11, "]=", 
        Rational[ 
        3678723099229236341327783694906400469336039635347800537330328179092732\
2802097960951, 
          57577817919494732461678305185721226522413057132280840518125908945146\
242685670617]],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("beta["\[InvisibleSpace]1\[InvisibleSpace]","\[InvisibleSpace]12
        \[InvisibleSpace]"]="\[InvisibleSpace]\
466148769644807321666779151211698548455686281808144585134458158635994240885881\
02239974833350789921/
          61650329106162775334803442075049840031738007858056125857986967420294\
033332367803064775663289169\),
      SequenceForm[ "beta[", 1, ",", 12, "]=", 
        Rational[ 
        4661487696448073216667791512116985484556862818081445851344581586359942\
4088588102239974833350789921, 
          61650329106162775334803442075049840031738007858056125857986967420294\
033332367803064775663289169]],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("beta["\[InvisibleSpace]1\[InvisibleSpace]","\[InvisibleSpace]13
        \[InvisibleSpace]"]="\[InvisibleSpace]\
663801861808593990010569258114925355545439669729127464267500836993969821159730\
647578081400947596998931347075433277/
          75159520733997824748059568258863951392065091984057611511347809402084\
9936544111207902587303199646348118463345907\),
      SequenceForm[ "beta[", 1, ",", 13, "]=", 
        Rational[ 
        6638018618085939900105692581149253555454396697291274642675008369939698\
21159730647578081400947596998931347075433277, 
          75159520733997824748059568258863951392065091984057611511347809402084\
9936544111207902587303199646348118463345907]],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("beta["\[InvisibleSpace]1\[InvisibleSpace]","\[InvisibleSpace]14
        \[InvisibleSpace]"]="\[InvisibleSpace]\
321266607014723301769800988991265136350899997640064650220067653476586754576615\
232846826013685790397651814481616688640377371961831843/
          31492604184016659948751829932767480168987997738554137397121588950732\
3511738780692743997357038619305681012108948733380669441696163\),
      SequenceForm[ "beta[", 1, ",", 14, "]=", 
        Rational[ 
        3212666070147233017698009889912651363508999976400646502200676534765867\
54576615232846826013685790397651814481616688640377371961831843, 
          31492604184016659948751829932767480168987997738554137397121588950732\
3511738780692743997357038619305681012108948733380669441696163]],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("beta["\[InvisibleSpace]1\[InvisibleSpace]","\[InvisibleSpace]15
        \[InvisibleSpace]"]="\[InvisibleSpace]\
478861196284710335153752722686540961152979336607940665894674655251707392054297\
07517881641787356011251604653438046637586750542019456646717656639227356079/
          41035426542485647087379220131260534924767548540038766462890919452038\
189571687599858138352446284661691501071821742447511871605671775276186027686507\
889\),
      SequenceForm[ "beta[", 1, ",", 15, "]=", 
        Rational[ 
        4788611962847103351537527226865409611529793366079406658946746552517073\
920542970751788164178735601125160465343804663758675054201945664671765663922735\
6079, 410354265424856470873792201312605349247675485400387664628909194520381895\
71687599858138352446284661691501071821742447511871605671775276186027686507889]\
],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("beta["\[InvisibleSpace]1\[InvisibleSpace]","\[InvisibleSpace]16
        \[InvisibleSpace]"]="\[InvisibleSpace]\
221107932560752262199972926470655330027150929680560099968969297299373057137898\
036132612030259770208140356616826603446357491722383308441564758152579296744425\
8322316183555789131/
          16704693101353542942064112940184976458881704717039289301411721445498\
617487641267365530125313163860474592282441000053310928969987291384450629002959\
76205314976384106874964107\),
      SequenceForm[ "beta[", 1, ",", 16, "]=", 
        Rational[ 
        2211079325607522621999729264706553300271509296805600999689692972993730\
571378980361326120302597702081403566168266034463574917223833084415647581525792\
967444258322316183555789131, 
          16704693101353542942064112940184976458881704717039289301411721445498\
617487641267365530125313163860474592282441000053310928969987291384450629002959\
76205314976384106874964107]],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("beta["\[InvisibleSpace]1\[InvisibleSpace]","\[InvisibleSpace]17
        \[InvisibleSpace]"]="\[InvisibleSpace]\
353182328077838974655725780660428088627397749750704662461598875414591537090613\
905153748408190020725493441599467079738493219481836560105735123822054735390627\
4126328568468902538906671552136291029986423/
          23700665906696722011919095618474947437754508871107725847275731120029\
250172141293703082603645537694456604979641420619123579615424030853669029883181\
31419597459140221209175096263500684386864150347177\),
      SequenceForm[ "beta[", 1, ",", 17, "]=", 
        Rational[ 
        3531823280778389746557257806604280886273977497507046624615988754145915\
370906139051537484081900207254934415994670797384932194818365601057351238220547\
353906274126328568468902538906671552136291029986423, 
          23700665906696722011919095618474947437754508871107725847275731120029\
250172141293703082603645537694456604979641420619123579615424030853669029883181\
31419597459140221209175096263500684386864150347177]],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("beta["\[InvisibleSpace]1\[InvisibleSpace]","\[InvisibleSpace]18
        \[InvisibleSpace]"]="\[InvisibleSpace]\
588070263311015874648591013451366052375026359784222106890091755208776984162215\
697348831493631756165108798922056959427079025797959324218575821677934090311425\
780286471127901408387721578795388955560843459802489889215583289169787/
          35285632914654848063743469407464858459148625593835423959180369879187\
986156634375025728391732565745196415216539003232332339169764817370005187400664\
5140963012021435008968615636688570849006788195208462572592448637112891533227
          \),
      SequenceForm[ "beta[", 1, ",", 18, "]=", 
        Rational[ 
        5880702633110158746485910134513660523750263597842221068900917552087769\
841622156973488314936317561651087989220569594270790257979593242185758216779340\
90311425780286471127901408387721578795388955560843459802489889215583289169787,
           3528563291465484806374346940746485845914862559383542395918036987918\
798615663437502572839173256574519641521653900323233233916976481737000518740066\
45140963012021435008968615636688570849006788195208462572592448637112891533227]\
],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("beta["\[InvisibleSpace]1\[InvisibleSpace]","\[InvisibleSpace]19
        \[InvisibleSpace]"]="\[InvisibleSpace]\
102466348141725708663647315689080519367579108362769629395356441462819659958958\
349653438384937710786032602262313265748644473673668411802447312138806156621027\
410401659337126697347343850612917642895469985696242840835704951116129225475603\
70208258040783273103/
          55300824620772948224346527150841196002675226367320920170619100266609\
563750566615603602721340425945961741715145173291621275663159370976880881900759\
518848704836786756816080542178002341552482703076688837983444248276272785029180\
96768474401276402645032353\),
      SequenceForm[ "beta[", 1, ",", 19, "]=", 
        Rational[ 
        1024663481417257086636473156890805193675791083627696293953564414628196\
599589583496534383849377107860326022623132657486444736736684118024473121388061\
566210274104016593371266973473438506129176428954699856962428408357049511161292\
2547560370208258040783273103, 
          55300824620772948224346527150841196002675226367320920170619100266609\
563750566615603602721340425945961741715145173291621275663159370976880881900759\
518848704836786756816080542178002341552482703076688837983444248276272785029180\
96768474401276402645032353]],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("beta["\[InvisibleSpace]1\[InvisibleSpace]","\[InvisibleSpace]20
        \[InvisibleSpace]"]="\[InvisibleSpace]\
624928121721735057292220855809933746742153141434354587727334148187506444043514\
341424889643759503598796936074461614772434117169339143641197312757829966269569\
223966944215812856568277514642685380489031381497591708446891815310002524912007\
7356551428586023659530497057320350505545087643107/
          30498433341771016690199894967284774419825519078180609043407357335752\
068178667009897300039919137450125845284899025648481092685545975740050280693545\
958421908789167526344376371789857864238874129631484648066864774199204574874630\
17385874508679226920776330017175483330313721064266208147\),
      SequenceForm[ "beta[", 1, ",", 20, "]=", 
        Rational[ 
        6249281217217350572922208558099337467421531414343545877273341481875064\
440435143414248896437595035987969360744616147724341171693391436411973127578299\
662695692239669442158128565682775146426853804890313814975917084468918153100025\
249120077356551428586023659530497057320350505545087643107, 
          30498433341771016690199894967284774419825519078180609043407357335752\
068178667009897300039919137450125845284899025648481092685545975740050280693545\
958421908789167526344376371789857864238874129631484648066864774199204574874630\
17385874508679226920776330017175483330313721064266208147]],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("beta["\[InvisibleSpace]1\[InvisibleSpace]","\[InvisibleSpace]21
        \[InvisibleSpace]"]="\[InvisibleSpace]\
148685858214026326018467272078307395688312789234093964937033776767201683205699\
213172613875913917506548740624413302696111021009821457486111162673225220146325\
848273791330437712666165737236846484291341189950628201901674946140287062560180\
015698549927888036108875938770597923657574570965923256352904143017534765652678\
63/659337603248199649677419452285569998780167002201885985019161607251017976196\
963562007246121915908065361886761794838225447741922790581448052564611005470030\
246493853215564722892658037655735670934853099597864519128805213778073739930225\
554465557808020784640357134583605408692099426950874159196396318315023715442620\
1\),
      SequenceForm[ "beta[", 1, ",", 21, "]=", 
        Rational[ 
        1486858582140263260184672720783073956883127892340939649370337767672016\
832056992131726138759139175065487406244133026961110210098214574861111626732252\
201463258482737913304377126661657372368464842913411899506282019016749461402870\
625601800156985499278880361088759387705979236575745709659232563529041430175347\
6565267863, 
          65933760324819964967741945228556999878016700220188598501916160725101\
797619696356200724612191590806536188676179483822544774192279058144805256461100\
547003024649385321556472289265803765573567093485309959786451912880521377807373\
993022555446555780802078464035713458360540869209942695087415919639631831502371\
54426201]],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("beta["\[InvisibleSpace]1\[InvisibleSpace]","\[InvisibleSpace]22
        \[InvisibleSpace]"]="\[InvisibleSpace]\
138388820835624511480559766398240945741687338367657967835095100904360393638526\
970940405099975561216405903130010958833453798991830189209676560368847873048072\
078153037786360729313484022424908429254607490877754052757158267995574782054201\
022353390393748835671741938215940829118903602829616439184775645239742368435300\
776714993961283590862892199925521/
          56005681879189537622978309732965396860616682560855384184876168752433\
981230428102121865007888082064711781556844936739908172590481384670945307820065\
218492447352597004519855944450045067724081623566613723366680071137617874158011\
271092751046762910052691851901115066181394181149139964190086864717129624859994\
725967626376782164991877813439192911089\),
      SequenceForm[ "beta[", 1, ",", 22, "]=", 
        Rational[ 
        1383888208356245114805597663982409457416873383676579678350951009043603\
936385269709404050999755612164059031300109588334537989918301892096765603688478\
730480720781530377863607293134840224249084292546074908777540527571582679955747\
820542010223533903937488356717419382159408291189036028296164391847756452397423\
68435300776714993961283590862892199925521, 
          56005681879189537622978309732965396860616682560855384184876168752433\
981230428102121865007888082064711781556844936739908172590481384670945307820065\
218492447352597004519855944450045067724081623566613723366680071137617874158011\
271092751046762910052691851901115066181394181149139964190086864717129624859994\
725967626376782164991877813439192911089]],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("beta["\[InvisibleSpace]1\[InvisibleSpace]","\[InvisibleSpace]23
        \[InvisibleSpace]"]="\[InvisibleSpace]\
454623155487499719697400914573813345624000987217229739111070049062708559996496\
309134042857588046310600959235980472653277024643582782970978922640578540633367\
893650224307374402510684325387862520004126267094757369849726346183820823411845\
175561456772687880888902973971561359454594932559306512277836663129217634746944\
84028025413921161252861415412964617854943247249571247307391688197/
          16858207474793062981002222187279106154455723558862370725227326308165\
403704036630717072781291899586008777976106174592140851291240544895946351722667\
551040999406570784577212916537110657357897215935954077221005975444574792564487\
997364793515345252264349311343677854910860818997884397917817768402031058308147\
336031278292742192087802348488949223638123391952114768881647846349949947\),
      SequenceForm[ "beta[", 1, ",", 23, "]=", 
        Rational[ 
        4546231554874997196974009145738133456240009872172297391110700490627085\
599964963091340428575880463106009592359804726532770246435827829709789226405785\
406333678936502243073744025106843253878625200041262670947573698497263461838208\
234118451755614567726878808889029739715613594545949325593065122778366631292176\
3474694484028025413921161252861415412964617854943247249571247307391688197, 
          16858207474793062981002222187279106154455723558862370725227326308165\
403704036630717072781291899586008777976106174592140851291240544895946351722667\
551040999406570784577212916537110657357897215935954077221005975444574792564487\
997364793515345252264349311343677854910860818997884397917817768402031058308147\
336031278292742192087802348488949223638123391952114768881647846349949947]],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("beta["\[InvisibleSpace]1\[InvisibleSpace]","\[InvisibleSpace]24
        \[InvisibleSpace]"]="\[InvisibleSpace]\
427948191913157233291052336545577073890531618122470906995695824499591031966931\
995973355653178660671219231139197472760153477199569795212590045399957957094265\
895671363895982848189361036759043807277285972408824380215498757275097872551542\
259033418926689737809274244342084718582080857332859044841717113784967181402395\
169940121419454474869030540444449852436344931720216949066265732398410954334443\
21253677640607696902723/
          14593862332497673204085407143236075329949813458768480697353892345923\
050769797842713405072959158126222729677278748289674382349378715022408839465745\
715154486580364999733672181087556580970849281164811228672376518986550435817501\
318786996930032776205367886266876172710270600110192862218242189594034555137855\
860913350868184313726486206310864759600045660649920974627753098426157465655775\
969969973154022508231276266403\),
      SequenceForm[ "beta[", 1, ",", 24, "]=", 
        Rational[ 
        4279481919131572332910523365455770738905316181224709069956958244995910\
319669319959733556531786606712192311391974727601534771995697952125900453999579\
570942658956713638959828481893610367590438072772859724088243802154987572750978\
725515422590334189266897378092742443420847185820808573328590448417171137849671\
814023951699401214194544748690305404444498524363449317202169490662657323984109\
5433444321253677640607696902723, 
          14593862332497673204085407143236075329949813458768480697353892345923\
050769797842713405072959158126222729677278748289674382349378715022408839465745\
715154486580364999733672181087556580970849281164811228672376518986550435817501\
318786996930032776205367886266876172710270600110192862218242189594034555137855\
860913350868184313726486206310864759600045660649920974627753098426157465655775\
969969973154022508231276266403]],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("beta["\[InvisibleSpace]1\[InvisibleSpace]","\[InvisibleSpace]25
        \[InvisibleSpace]"]="\[InvisibleSpace]\
115669256559122802515721057951136613831836949008091250282120359927219783306831\
113430420148175669736218540186650126749475432112113173883619540093356827046541\
594196732475231120746609434716108450868461454378337441946184537436705575352893\
305698623639255268567320929847848465699896126344983440258103967150749446104867\
807020031181621010164628600351817945434978611587434906880514841582064686383565\
868897191965168043062687386044141386660711683286524410420356191/
          36398104392070003944606539993168724740909973980242532511155726618595\
506145694764121635505952358058072618959143709785118874055111221802900620344991\
763392185078767813808995059397881249838668740370857697565470708504381777408484\
836446008979566218536599121848305118084755029597735313048736838258912359288232\
591002873785176779692940430986982860517610088727823470419765327953401775994985\
202459035622661778037570385096598289706201041149174706240587375575841\),
      SequenceForm[ "beta[", 1, ",", 25, "]=", 
        Rational[ 
        1156692565591228025157210579511366138318369490080912502821203599272197\
833068311134304201481756697362185401866501267494754321121131738836195400933568\
270465415941967324752311207466094347161084508684614543783374419461845374367055\
753528933056986236392552685673209298478484656998961263449834402581039671507494\
461048678070200311816210101646286003518179454349786115874349068805148415820646\
86383565868897191965168043062687386044141386660711683286524410420356191, 
          36398104392070003944606539993168724740909973980242532511155726618595\
506145694764121635505952358058072618959143709785118874055111221802900620344991\
763392185078767813808995059397881249838668740370857697565470708504381777408484\
836446008979566218536599121848305118084755029597735313048736838258912359288232\
591002873785176779692940430986982860517610088727823470419765327953401775994985\
202459035622661778037570385096598289706201041149174706240587375575841]],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("beta["\[InvisibleSpace]1\[InvisibleSpace]","\[InvisibleSpace]26
        \[InvisibleSpace]"]="\[InvisibleSpace]\
111037294315031187447645286845045545623977483958189303016095900143462640120689\
976744468521317940426900080289900400021116491038866755105905916977443311736346\
013533702096684355426233295439948170186183982222635913978264287300473100395339\
577493153205453472729908504942270765763797055575104418434350088231432991187839\
654680054320874087811268207079666502109201566749953402477333662577645182664982\
616352395450925941926818148010246803826473325524342623420710359763470222119919\
27931767554912348625716929/
          32341561108965896485449793745658333479771664692137201602105530653529\
309105080295869543900596807723375077059969620453185736071560512876553496168031\
298456808455263325963095798015134478152663504246616095777940957302790422512499\
633721367699601735681518615820005346815640776869622543029550398891774747108402\
190650641787576520992256648544442090160517668511031517039622531046664623153634\
284356760394561643724199213201823600852466366017876263880012150013066188073936\
11078425859348433715356857103153\),
      SequenceForm[ "beta[", 1, ",", 26, "]=", 
        Rational[ 
        1110372943150311874476452868450455456239774839581893030160959001434626\
401206899767444685213179404269000802899004000211164910388667551059059169774433\
117363460135337020966843554262332954399481701861839822226359139782642873004731\
003953395774931532054534727299085049422707657637970555751044184343500882314329\
911878396546800543208740878112682070796665021092015667499534024773336625776451\
826649826163523954509259419268181480102468038264733255243426234207103597634702\
2211991927931767554912348625716929, 
          32341561108965896485449793745658333479771664692137201602105530653529\
309105080295869543900596807723375077059969620453185736071560512876553496168031\
298456808455263325963095798015134478152663504246616095777940957302790422512499\
633721367699601735681518615820005346815640776869622543029550398891774747108402\
190650641787576520992256648544442090160517668511031517039622531046664623153634\
284356760394561643724199213201823600852466366017876263880012150013066188073936\
11078425859348433715356857103153]],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("beta["\[InvisibleSpace]1\[InvisibleSpace]","\[InvisibleSpace]27
        \[InvisibleSpace]"]="\[InvisibleSpace]\
468181596416059282232881542773168624339958627696111238454273971891794323905013\
237191877202752705237519365439896877906698208891390619097276386583183900831119\
458279324494841108238239817495170554095562135790786170250401867585536235693333\
289061147746433894561641735313748660327971140931162492034300826326146928018977\
137320675469051178113932599810655891854922787661131850683040060846785769119019\
799531918366251425860464452685160432602822366129967851836195428649500408621438\
465062853099878050949269714281361256752956911604166097700114752277/
          12658633197857701901188438672501404754849603504240119402889687432798\
311793429931937625147002235582313382235374877681979045611464160298004401659789\
534352914959678086175546503408152805295886625621200919007251604270159754091162\
518471003312653004500155954862845960706173472691154728231082388784412845834464\
790693201094808812881025612630742021650895232883395898246216514494820976209241\
902325880573682159738693695870661603354237210734934722258780687661995178016098\
8605718590445326621472604569648265258746906448409967394099723154823134363\),
      SequenceForm[ "beta[", 1, ",", 27, "]=", 
        Rational[ 
        4681815964160592822328815427731686243399586276961112384542739718917943\
239050132371918772027527052375193654398968779066982088913906190972763865831839\
008311194582793244948411082382398174951705540955621357907861702504018675855362\
356933332890611477464338945616417353137486603279711409311624920343008263261469\
280189771373206754690511781139325998106558918549227876611318506830400608467857\
691190197995319183662514258604644526851604326028223661299678518361954286495004\
08621438465062853099878050949269714281361256752956911604166097700114752277, 
          12658633197857701901188438672501404754849603504240119402889687432798\
311793429931937625147002235582313382235374877681979045611464160298004401659789\
534352914959678086175546503408152805295886625621200919007251604270159754091162\
518471003312653004500155954862845960706173472691154728231082388784412845834464\
790693201094808812881025612630742021650895232883395898246216514494820976209241\
902325880573682159738693695870661603354237210734934722258780687661995178016098\
8605718590445326621472604569648265258746906448409967394099723154823134363]],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("beta["\[InvisibleSpace]1\[InvisibleSpace]","\[InvisibleSpace]28
        \[InvisibleSpace]"]="\[InvisibleSpace]\
868461950126519023107799574060898966331812672045948701141941908668876584511083\
626388538256429421424182412923278936702014005668919932236568227680321859753239\
653129189646651530722912659033975669465549831800608040539685048553402951439469\
037572415925353785525017249052851722624074562982103244857910659858094087883549\
546237373719076479465601327855592750945287505891151640198548711041641051442044\
376365522208683077251851119936887345802910338018399483964059899679343833008526\
343731426392214138877555331371430994830523199880797281189337778961378017416151\
3450845468896079755624123681/
          21855618540920352678520104886486618189012220597009322653192967746393\
122414308580115414535920205371976809256041275536660301409544552426383611415335\
384949275814011802714246993589879325674040718986736723979205897454790851415829\
396232397142948051576105242777762856859702176784700406804448345616903646029621\
615071422391441563866958743530594780250540183634921707813291270411208722699531\
995677437369782119509728788233793978220706457173706009728766876583258372615923\
251126373257551269427840938949583308729611337117416700489797106162759516359421\
32206955235802809235722254263718161\),
      SequenceForm[ "beta[", 1, ",", 28, "]=", 
        Rational[ 
        8684619501265190231077995740608989663318126720459487011419419086688765\
845110836263885382564294214241824129232789367020140056689199322365682276803218\
597532396531291896466515307229126590339756694655498318006080405396850485534029\
514394690375724159253537855250172490528517226240745629821032448579106598580940\
878835495462373737190764794656013278555927509452875058911516401985487110416410\
514420443763655222086830772518511199368873458029103380183994839640598996793438\
330085263437314263922141388775553313714309948305231998807972811893377789613780\
174161513450845468896079755624123681, 
          21855618540920352678520104886486618189012220597009322653192967746393\
122414308580115414535920205371976809256041275536660301409544552426383611415335\
384949275814011802714246993589879325674040718986736723979205897454790851415829\
396232397142948051576105242777762856859702176784700406804448345616903646029621\
615071422391441563866958743530594780250540183634921707813291270411208722699531\
995677437369782119509728788233793978220706457173706009728766876583258372615923\
251126373257551269427840938949583308729611337117416700489797106162759516359421\
32206955235802809235722254263718161]],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("beta["\[InvisibleSpace]1\[InvisibleSpace]","\[InvisibleSpace]29
        \[InvisibleSpace]"]="\[InvisibleSpace]\
574919968421279303061990750649866634783428192951839948397652015436434446669887\
718154647881034536589799873068734810570161893023534791301334592286542089321639\
106644312582508291057695886553957524812082761773386302311921596859261194695192\
510110142517517782848435020234355892126288802688656610897676683150380286941693\
154921950212876699132959770463371187655343572230734425934661841897737805327470\
935170075924263825679069587226851649714895146060737974299321740776414333956167\
587060711672701768557667567694822280394636389980008369325851314908679901278144\
6103854303883114686389863812383785407845058969793178883971038967901341/
          13500152615715083556409205897625869791666053779601316620639008707334\
721199031667321930795525109419818390238774074758900173569527010045823856122813\
181889702705651064239133540376162671478245652015667514079979745195645080654246\
653666211594866864448583828786312974306883467534672516802442124974603187226664\
681656218256640825172909795874608841306686844950209341032367672251080496509341\
911863723177242674683094622298958613250805290113588421904920873163942141547663\
586713403093313452251433857330073016495005586204953969516265039053327451096932\
59138525322676553744793613871011408392664468915125527688496871688563840550611
          \),
      SequenceForm[ "beta[", 1, ",", 29, "]=", 
        Rational[ 
        5749199684212793030619907506498666347834281929518399483976520154364344\
466698877181546478810345365897998730687348105701618930235347913013345922865420\
893216391066443125825082910576958865539575248120827617733863023119215968592611\
946951925101101425175177828484350202343558921262888026886566108976766831503802\
869416931549219502128766991329597704633711876553435722307344259346618418977378\
053274709351700759242638256790695872268516497148951460607379742993217407764143\
339561675870607116727017685576675676948222803946363899800083693258513149086799\
012781446103854303883114686389863812383785407845058969793178883971038967901341\
, 1350015261571508355640920589762586979166605377960131662063900870733472119903\
166732193079552510941981839023877407475890017356952701004582385612281318188970\
270565106423913354037616267147824565201566751407997974519564508065424665366621\
159486686444858382878631297430688346753467251680244212497460318722666468165621\
825664082517290979587460884130668684495020934103236767225108049650934191186372\
317724267468309462229895861325080529011358842190492087316394214154766358671340\
309331345225143385733007301649500558620495396951626503905332745109693259138525\
322676553744793613871011408392664468915125527688496871688563840550611]],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    \({6.48333333333334138`\ Second, Null}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(MemoryInUse[]\)], "Input"],

Cell[BoxData[
    \(1249312\)], "Output"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Computing the d-orthogonal polynomials", "Subsection"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\( (*\ set\ the\ values\ of\ d\ and\ nmax\ *) \nd = 1; \ 
    nmax = \ 30\ \ \ \ \  (*\ for\ example\ *) \)\)], "Input"],

Cell[BoxData[
    \(30\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(MemoryInUse[]\)], "Input"],

Cell[BoxData[
    \(1225112\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Timing[printdorthpoly[d,nmax,x,Infinity]]", "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("dorthpoly["\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "x", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", 
        InterpretationBox["\[Infinity]",
          DirectedInfinity[ 1]], "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", "1"}],
      SequenceForm[ "dorthpoly[", 1, ",", 0, ",", x, ",", 
        DirectedInfinity[ 1], "]=", 1],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("dorthpoly["\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "x", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", 
        InterpretationBox["\[Infinity]",
          DirectedInfinity[ 1]], "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", \(\( - 1\) + x\)}],
      SequenceForm[ "dorthpoly[", 1, ",", 1, ",", x, ",", 
        DirectedInfinity[ 1], "]=", 
        Plus[ -1, x]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("dorthpoly["\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "x", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", 
        InterpretationBox["\[Infinity]",
          DirectedInfinity[ 1]], "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", \(20\/3 - \(32\ x\)\/3 + x\^2\)}],
      SequenceForm[ "dorthpoly[", 1, ",", 2, ",", x, ",", 
        DirectedInfinity[ 1], "]=", 
        Plus[ 
          Rational[ 20, 3], 
          Times[ 
            Rational[ -32, 3], x], 
          Power[ x, 2]]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("dorthpoly["\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "x", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", 
        InterpretationBox["\[Infinity]",
          DirectedInfinity[ 1]], "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        \(\( - 4716\/41\) + \(9612\ x\)\/41 - \(1593\ x\^2\)\/41 + x\^3\)}],
      SequenceForm[ "dorthpoly[", 1, ",", 3, ",", x, ",", 
        DirectedInfinity[ 1], "]=", 
        Plus[ 
          Rational[ -4716, 41], 
          Times[ 
            Rational[ 9612, 41], x], 
          Times[ 
            Rational[ -1593, 41], 
            Power[ x, 2]], 
          Power[ x, 3]]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("dorthpoly["\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "4", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "x", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", 
        InterpretationBox["\[Infinity]",
          DirectedInfinity[ 1]], "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        \(3569472\/947 - \(8520192\ x\)\/947 + \(1914624\ x\^2\)\/947 - 
          \(90368\ x\^3\)\/947 + x\^4\)}],
      SequenceForm[ "dorthpoly[", 1, ",", 4, ",", x, ",", 
        DirectedInfinity[ 1], "]=", 
        Plus[ 
          Rational[ 3569472, 947], 
          Times[ 
            Rational[ -8520192, 947], x], 
          Times[ 
            Rational[ 1914624, 947], 
            Power[ x, 2]], 
          Times[ 
            Rational[ -90368, 947], 
            Power[ x, 3]], 
          Power[ x, 4]]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("dorthpoly["\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "x", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", 
        InterpretationBox["\[Infinity]",
          DirectedInfinity[ 1]], "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        \(\( - 7789195200\/38833\) + \(20863128000\ x\)\/38833 - 
          \(5736960000\ x\^2\)\/38833 + \(1130848000\ x\^3\)\/116499 - 
          \(22163875\ x\^4\)\/116499 + x\^5\)}],
      SequenceForm[ "dorthpoly[", 1, ",", 5, ",", x, ",", 
        DirectedInfinity[ 1], "]=", 
        Plus[ 
          Rational[ -7789195200, 38833], 
          Times[ 
            Rational[ 20863128000, 38833], x], 
          Times[ 
            Rational[ -5736960000, 38833], 
            Power[ x, 2]], 
          Times[ 
            Rational[ 1130848000, 116499], 
            Power[ x, 3]], 
          Times[ 
            Rational[ -22163875, 116499], 
            Power[ x, 4]], 
          Power[ x, 5]]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("dorthpoly["\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "6", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "x", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", 
        InterpretationBox["\[Infinity]",
          DirectedInfinity[ 1]], "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        \(1237890913977600\/78523849 - \(3626861673369600\ x\)\/78523849 + 
          \(1156778536824000\ x\^2\)\/78523849 - 
          \(94896518208000\ x\^3\)\/78523849 + 
          \(2628786397500\ x\^4\)\/78523849 - 
          \(26163643104\ x\^5\)\/78523849 + x\^6\)}],
      SequenceForm[ "dorthpoly[", 1, ",", 6, ",", x, ",", 
        DirectedInfinity[ 1], "]=", 
        Plus[ 
          Rational[ 1237890913977600, 78523849], 
          Times[ 
            Rational[ -3626861673369600, 78523849], x], 
          Times[ 
            Rational[ 1156778536824000, 78523849], 
            Power[ x, 2]], 
          Times[ 
            Rational[ -94896518208000, 78523849], 
            Power[ x, 3]], 
          Times[ 
            Rational[ 2628786397500, 78523849], 
            Power[ x, 4]], 
          Times[ 
            Rational[ -26163643104, 78523849], 
            Power[ x, 5]], 
          Power[ x, 6]]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("dorthpoly["\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "7", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "x", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", 
        InterpretationBox["\[Infinity]",
          DirectedInfinity[ 1]], "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        \(\( - 86115171006315360000\/50159122831\) + 
          \(14383748761596825004800\ x\)\/2658433510043 - 
          \(5151269895191546011200\ x\^2\)\/2658433510043 + 
          \(498061933049385768000\ x\^3\)\/2658433510043 - 
          \(17437219422556426500\ x\^4\)\/2658433510043 + 
          \(247750832282782500\ x\^5\)\/2658433510043 - 
          \(1419939755791067\ x\^6\)\/2658433510043 + x\^7\)}],
      SequenceForm[ "dorthpoly[", 1, ",", 7, ",", x, ",", 
        DirectedInfinity[ 1], "]=", 
        Plus[ 
          Rational[ -86115171006315360000, 50159122831], 
          Times[ 
            Rational[ 14383748761596825004800, 2658433510043], x], 
          Times[ 
            Rational[ -5151269895191546011200, 2658433510043], 
            Power[ x, 2]], 
          Times[ 
            Rational[ 498061933049385768000, 2658433510043], 
            Power[ x, 3]], 
          Times[ 
            Rational[ -17437219422556426500, 2658433510043], 
            Power[ x, 4]], 
          Times[ 
            Rational[ 247750832282782500, 2658433510043], 
            Power[ x, 5]], 
          Times[ 
            Rational[ -1419939755791067, 2658433510043], 
            Power[ x, 6]], 
          Power[ x, 7]]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("dorthpoly["\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "8", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "x", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", 
        InterpretationBox["\[Infinity]",
          DirectedInfinity[ 1]], "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        \(4663876584575720269030604800\/18845305713487457 - 
          \(15624267625154726839327129600\ x\)\/18845305713487457 + 
          \(6148880195021893038659174400\ x\^2\)\/18845305713487457 - 
          \(6087522701586583358763827200\ x\^3\)\/169607751421387113 + 
          \(253729741875746029003264000\ x\^4\)\/169607751421387113 - 
          \(1531341807673330811518976\ x\^5\)\/56535917140462371 + 
          \(113563466349360753732608\ x\^6\)\/508823254264161339 - 
          \(408542887981363576832\ x\^7\)\/508823254264161339 + x\^8\)}],
      SequenceForm[ "dorthpoly[", 1, ",", 8, ",", x, ",", 
        DirectedInfinity[ 1], "]=", 
        Plus[ 
          Rational[ 4663876584575720269030604800, 18845305713487457], 
          Times[ 
            Rational[ -15624267625154726839327129600, 18845305713487457], x], 
          
          Times[ 
            Rational[ 6148880195021893038659174400, 18845305713487457], 
            Power[ x, 2]], 
          Times[ 
            Rational[ -6087522701586583358763827200, 169607751421387113], 
            Power[ x, 3]], 
          Times[ 
            Rational[ 253729741875746029003264000, 169607751421387113], 
            Power[ x, 4]], 
          Times[ 
            Rational[ -1531341807673330811518976, 56535917140462371], 
            Power[ x, 5]], 
          Times[ 
            Rational[ 113563466349360753732608, 508823254264161339], 
            Power[ x, 6]], 
          Times[ 
            Rational[ -408542887981363576832, 508823254264161339], 
            Power[ x, 7]], 
          Power[ x, 8]]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("dorthpoly["\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "9", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "x", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", 
        InterpretationBox["\[Infinity]",
          DirectedInfinity[ 1]], "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        \(\( - 25358288425926524357659696493424230400
              \/555885119811725416275571\) + 
          \(89519900315163595485457375336296038400\ x
              \)\/555885119811725416275571 - 
          \(38127359980729859175596834947112140800\ 
              x\^2\)\/555885119811725416275571 + 
          \(4660096059951141296389671050062233600\ 
              x\^3\)\/555885119811725416275571 - 
          \(222867200805830848514182020322406400\ 
              x\^4\)\/555885119811725416275571 + 
          \(4837849484772718975784087019810816\ 
              x\^5\)\/555885119811725416275571 - 
          \(51106517212465934592906402487296\ x\^6\)\/555885119811725416275571
             + \(265731755370279488882582510592\ 
              x\^7\)\/555885119811725416275571 - 
          \(638953526207647567319474259\ x\^8\)\/555885119811725416275571 + 
          x\^9\)}],
      SequenceForm[ "dorthpoly[", 1, ",", 9, ",", x, ",", 
        DirectedInfinity[ 1], "]=", 
        Plus[ 
          Rational[
           -25358288425926524357659696493424230400, 555885119811725416275571],
           
          Times[ 
            Rational[ 
            89519900315163595485457375336296038400, 555885119811725416275571],
             x], 
          Times[ 
            Rational[
             -38127359980729859175596834947112140800, 
              555885119811725416275571], 
            Power[ x, 2]], 
          Times[ 
            Rational[ 
            4660096059951141296389671050062233600, 555885119811725416275571], 
            
            Power[ x, 3]], 
          Times[ 
            Rational[
             -222867200805830848514182020322406400, 555885119811725416275571],
             
            Power[ x, 4]], 
          Times[ 
            Rational[ 
            4837849484772718975784087019810816, 555885119811725416275571], 
            Power[ x, 5]], 
          Times[ 
            Rational[
             -51106517212465934592906402487296, 555885119811725416275571], 
            Power[ x, 6]], 
          Times[ 
            Rational[ 
            265731755370279488882582510592, 555885119811725416275571], 
            Power[ x, 7]], 
          Times[ 
            Rational[ -638953526207647567319474259, 555885119811725416275571],
             
            Power[ x, 8]], 
          Power[ x, 9]]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("dorthpoly["\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "10", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "x", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", 
        InterpretationBox["\[Infinity]",
          DirectedInfinity[ 1]], "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        \(4061131854479327491494963103021223922278400000
            \/388010745401838428431793236441 - 
          \(15006934097275790587058884997951095332864000000\ x
              \)\/388010745401838428431793236441 + 
          \(6839307721325471173460330729542561490688000000\ 
              x\^2\)\/388010745401838428431793236441 - 
          \(913282681538559987796413398513441402880000000\ 
              x\^3\)\/388010745401838428431793236441 + 
          \(48885611680661486244308246784306594816000000\ 
              x\^4\)\/388010745401838428431793236441 - 
          \(1224994549186378055034466617891038640537600\ 
              x\^5\)\/388010745401838428431793236441 + 
          \(15595659037388212478546135526099823104000\ 
              x\^6\)\/388010745401838428431793236441 - 
          \(104439397942851455646368195597015040000\ 
              x\^7\)\/388010745401838428431793236441 + 
          \(364455154047839010210076577717965500\ 
              x\^8\)\/388010745401838428431793236441 - 
          \(614433587002652856923719639132000\ 
              x\^9\)\/388010745401838428431793236441 + x\^10\)}],
      SequenceForm[ "dorthpoly[", 1, ",", 10, ",", x, ",", 
        DirectedInfinity[ 1], "]=", 
        Plus[ 
          Rational[ 
          4061131854479327491494963103021223922278400000, 
            388010745401838428431793236441], 
          Times[ 
            Rational[
             -15006934097275790587058884997951095332864000000, 
              388010745401838428431793236441], x], 
          Times[ 
            Rational[ 
            6839307721325471173460330729542561490688000000, 
              388010745401838428431793236441], 
            Power[ x, 2]], 
          Times[ 
            Rational[
             -913282681538559987796413398513441402880000000, 
              388010745401838428431793236441], 
            Power[ x, 3]], 
          Times[ 
            Rational[ 
            48885611680661486244308246784306594816000000, 
              388010745401838428431793236441], 
            Power[ x, 4]], 
          Times[ 
            Rational[
             -1224994549186378055034466617891038640537600, 
              388010745401838428431793236441], 
            Power[ x, 5]], 
          Times[ 
            Rational[ 
            15595659037388212478546135526099823104000, 
              388010745401838428431793236441], 
            Power[ x, 6]], 
          Times[ 
            Rational[
             -104439397942851455646368195597015040000, 
              388010745401838428431793236441], 
            Power[ x, 7]], 
          Times[ 
            Rational[ 
            364455154047839010210076577717965500, 
              388010745401838428431793236441], 
            Power[ x, 8]], 
          Times[ 
            Rational[
             -614433587002652856923719639132000, 
              388010745401838428431793236441], 
            Power[ x, 9]], 
          Power[ x, 10]]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("dorthpoly["\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "11", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "x", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", 
        InterpretationBox["\[Infinity]",
          DirectedInfinity[ 1]], "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        \(\( - 1527472323600125785020601538554861693929742640947200000
              \/522169029871980662059535883199430953\) + 
          \(5877280279765733583749632587440524715949004015411200000\ x
              \)\/522169029871980662059535883199430953 - 
          \(2841341115981644378228118026131391670430984554240000000\ 
              x\^2\)\/522169029871980662059535883199430953 + 
          \(409352852036222238025906870405493963874509989632000000\ 
              x\^3\)\/522169029871980662059535883199430953 - 
          \(24091865173644781178712801049963815906397900800000000\ 
              x\^4\)\/522169029871980662059535883199430953 + 
          \(679270802285620944438978599953165142827016056012800\ 
              x\^5\)\/522169029871980662059535883199430953 - 
          \(10028600113970251977964261362782419409682861772800\ 
              x\^6\)\/522169029871980662059535883199430953 + 
          \(81263782581951210015817719385133000584960512000\ 
              x\^7\)\/522169029871980662059535883199430953 - 
          \(366557416819326712172790912350570852833411500\ 
              x\^8\)\/522169029871980662059535883199430953 + 
          \(2699454218536230267552694886849866967862500\ 
              x\^9\)\/1566507089615941986178607649598292859 - 
          \(3313360674145437350720293476561245399819\ 
              x\^10\)\/1566507089615941986178607649598292859 + x\^11\)}],
      SequenceForm[ "dorthpoly[", 1, ",", 11, ",", x, ",", 
        DirectedInfinity[ 1], "]=", 
        Plus[ 
          Rational[
           -1527472323600125785020601538554861693929742640947200000, 
            522169029871980662059535883199430953], 
          Times[ 
            Rational[ 
            5877280279765733583749632587440524715949004015411200000, 
              522169029871980662059535883199430953], x], 
          Times[ 
            Rational[
             -2841341115981644378228118026131391670430984554240000000, 
              522169029871980662059535883199430953], 
            Power[ x, 2]], 
          Times[ 
            Rational[ 
            409352852036222238025906870405493963874509989632000000, 
              522169029871980662059535883199430953], 
            Power[ x, 3]], 
          Times[ 
            Rational[
             -24091865173644781178712801049963815906397900800000000, 
              522169029871980662059535883199430953], 
            Power[ x, 4]], 
          Times[ 
            Rational[ 
            679270802285620944438978599953165142827016056012800, 
              522169029871980662059535883199430953], 
            Power[ x, 5]], 
          Times[ 
            Rational[
             -10028600113970251977964261362782419409682861772800, 
              522169029871980662059535883199430953], 
            Power[ x, 6]], 
          Times[ 
            Rational[ 
            81263782581951210015817719385133000584960512000, 
              522169029871980662059535883199430953], 
            Power[ x, 7]], 
          Times[ 
            Rational[
             -366557416819326712172790912350570852833411500, 
              522169029871980662059535883199430953], 
            Power[ x, 8]], 
          Times[ 
            Rational[ 
            2699454218536230267552694886849866967862500, 
              1566507089615941986178607649598292859], 
            Power[ x, 9]], 
          Times[ 
            Rational[
             -3313360674145437350720293476561245399819, 
              1566507089615941986178607649598292859], 
            Power[ x, 10]], 
          Power[ x, 11]]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("dorthpoly["\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "12", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "x", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", 
        InterpretationBox["\[Infinity]",
          DirectedInfinity[ 1]], "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        \(35961314883510822119434051783318273547496440769673132228608000000
            \/36755542506744092114990811661629919421349563 - 
          \((14346699520597728312998240583802391654401428803450368575406080000\
0\ x)\)/36755542506744092114990811661629919421349563 + 
          \((73070923147356864108368237574324172690787739781536255423283200000
                \ x\^2)\)/36755542506744092114990811661629919421349563 - 
          \((11248562491945027404141218267328656933252844485989341659136000000
                \ x\^3)\)/36755542506744092114990811661629919421349563 + 
          \(718269124616249726562341890023920848175325371370829955328000000\ 
              x\^4\)\/36755542506744092114990811661629919421349563 - 
          \(22370964895084587217465370463332391979959489527386969571328000\ 
              x\^5\)\/36755542506744092114990811661629919421349563 + 
          \(373126192997289243354741927805598810899030157740290089779200\ 
              x\^6\)\/36755542506744092114990811661629919421349563 - 
          \(3518791545096138474483214688078496130795097486074547404800\ 
              x\^7\)\/36755542506744092114990811661629919421349563 + 
          \(19267800302633412746077287866404331637948697866695112000\ 
              x\^8\)\/36755542506744092114990811661629919421349563 - 
          \(61317180054909695630458807491493058147840829738816000\ 
              x\^9\)\/36755542506744092114990811661629919421349563 + 
          \(109881610634207088619413903306682264380831245902080\ 
              x\^10\)\/36755542506744092114990811661629919421349563 - 
          \(101226225621421215459796637876368453839463663872\ 
              x\^11\)\/36755542506744092114990811661629919421349563 + 
          x\^12\)}],
      SequenceForm[ "dorthpoly[", 1, ",", 12, ",", x, ",", 
        DirectedInfinity[ 1], "]=", 
        Plus[ 
          Rational[ 
          35961314883510822119434051783318273547496440769673132228608000000, 
            36755542506744092114990811661629919421349563], 
          Times[ 
            Rational[
             -1434669952059772831299824058380239165440142880345036857540608000\
00, 36755542506744092114990811661629919421349563], x], 
          Times[ 
            Rational[ 
            73070923147356864108368237574324172690787739781536255423283200000,
               36755542506744092114990811661629919421349563], 
            Power[ x, 2]], 
          Times[ 
            Rational[
             -1124856249194502740414121826732865693325284448598934165913600000\
0, 36755542506744092114990811661629919421349563], 
            Power[ x, 3]], 
          Times[ 
            Rational[ 
            718269124616249726562341890023920848175325371370829955328000000, 
              36755542506744092114990811661629919421349563], 
            Power[ x, 4]], 
          Times[ 
            Rational[
             -22370964895084587217465370463332391979959489527386969571328000, 
              36755542506744092114990811661629919421349563], 
            Power[ x, 5]], 
          Times[ 
            Rational[ 
            373126192997289243354741927805598810899030157740290089779200, 
              36755542506744092114990811661629919421349563], 
            Power[ x, 6]], 
          Times[ 
            Rational[
             -3518791545096138474483214688078496130795097486074547404800, 
              36755542506744092114990811661629919421349563], 
            Power[ x, 7]], 
          Times[ 
            Rational[ 
            19267800302633412746077287866404331637948697866695112000, 
              36755542506744092114990811661629919421349563], 
            Power[ x, 8]], 
          Times[ 
            Rational[
             -61317180054909695630458807491493058147840829738816000, 
              36755542506744092114990811661629919421349563], 
            Power[ x, 9]], 
          Times[ 
            Rational[ 
            109881610634207088619413903306682264380831245902080, 
              36755542506744092114990811661629919421349563], 
            Power[ x, 10]], 
          Times[ 
            Rational[
             -101226225621421215459796637876368453839463663872, 
              36755542506744092114990811661629919421349563], 
            Power[ x, 11]], 
          Power[ x, 12]]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("dorthpoly["\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "13", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "x", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", 
        InterpretationBox["\[Infinity]",
          DirectedInfinity[ 1]], "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        \(\( - 647200043846024172419984664685092276135155818038658415197237305\
733939200000/1677307010088365920694754530705588980060922274820963\) + 
          \((26677903750408962266541514991974485825272232910082720842932771544\
20326400000\ x)\)/1677307010088365920694754530705588980060922274820963 - 
          \((14235834233045018057765302415952617528817069910474294340346320985\
19449600000\ x\^2)\)/1677307010088365920694754530705588980060922274820963 + 
          \((23237265935405684447737675767952662646108142688896479357297198102\
6099200000\ x\^3)\)/1677307010088365920694754530705588980060922274820963 - 
          \((15933963357776964094180151935805372720646775576686571468079345273\
088000000\ x\^4)\)/1677307010088365920694754530705588980060922274820963 + 
          \((54069063519511012889917772526880305578886854797375952893253471547\
9244800\ x\^5)\)/1677307010088365920694754530705588980060922274820963 - 
          \((99979947202425126627494070480897626415402698080152114186911267905\
53600\ x\^6)\)/1677307010088365920694754530705588980060922274820963 + 
          \((10685998877179058849661513229787983511466892656233668504258232893\
4400\ x\^7)\)/1677307010088365920694754530705588980060922274820963 - 
          \((68294888539203932638195357888682736033866896786880472806085307680\
0\ x\^8)\)/1677307010088365920694754530705588980060922274820963 + 
          \(2645298236016536378490867628095223763146668663827349593904456000\ 
              x\^9\)\/1677307010088365920694754530705588980060922274820963 - 
          \(6160358910649911564700257678767452507054549801817712416967168\ 
              x\^10\)\/1677307010088365920694754530705588980060922274820963 + 
          \(8304201077741229903680423780340999560981757211655258470656\ 
              x\^11\)\/1677307010088365920694754530705588980060922274820963 - 
          \(5887610957296317991017855953938831455018977961393673939\ 
              x\^12\)\/1677307010088365920694754530705588980060922274820963 + 
          x\^13\)}],
      SequenceForm[ "dorthpoly[", 1, ",", 13, ",", x, ",", 
        DirectedInfinity[ 1], "]=", 
        Plus[ 
          Rational[
           -647200043846024172419984664685092276135155818038658415197237305733\
939200000, 1677307010088365920694754530705588980060922274820963], 
          Times[ 
            Rational[ 
            266779037504089622665415149919744858252722329100827208429327715442\
0326400000, 1677307010088365920694754530705588980060922274820963], x], 
          Times[ 
            Rational[
             -1423583423304501805776530241595261752881706991047429434034632098\
519449600000, 1677307010088365920694754530705588980060922274820963], 
            Power[ x, 2]], 
          Times[ 
            Rational[ 
            232372659354056844477376757679526626461081426888964793572971981026\
099200000, 1677307010088365920694754530705588980060922274820963], 
            Power[ x, 3]], 
          Times[ 
            Rational[
             -1593396335777696409418015193580537272064677557668657146807934527\
3088000000, 1677307010088365920694754530705588980060922274820963], 
            Power[ x, 4]], 
          Times[ 
            Rational[ 
            540690635195110128899177725268803055788868547973759528932534715479\
244800, 1677307010088365920694754530705588980060922274820963], 
            Power[ x, 5]], 
          Times[ 
            Rational[
             -9997994720242512662749407048089762641540269808015211418691126790\
553600, 1677307010088365920694754530705588980060922274820963], 
            Power[ x, 6]], 
          Times[ 
            Rational[ 
            106859988771790588496615132297879835114668926562336685042582328934\
400, 1677307010088365920694754530705588980060922274820963], 
            Power[ x, 7]], 
          Times[ 
            Rational[
             -6829488853920393263819535788868273603386689678688047280608530768\
00, 1677307010088365920694754530705588980060922274820963], 
            Power[ x, 8]], 
          Times[ 
            Rational[ 
            2645298236016536378490867628095223763146668663827349593904456000, 
              1677307010088365920694754530705588980060922274820963], 
            Power[ x, 9]], 
          Times[ 
            Rational[
             -6160358910649911564700257678767452507054549801817712416967168, 
              1677307010088365920694754530705588980060922274820963], 
            Power[ x, 10]], 
          Times[ 
            Rational[ 
            8304201077741229903680423780340999560981757211655258470656, 
              1677307010088365920694754530705588980060922274820963], 
            Power[ x, 11]], 
          Times[ 
            Rational[
             -5887610957296317991017855953938831455018977961393673939, 
              1677307010088365920694754530705588980060922274820963], 
            Power[ x, 12]], 
          Power[ x, 13]]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("dorthpoly["\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "14", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "x", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", 
        InterpretationBox["\[Infinity]",
          DirectedInfinity[ 1]], "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        \(26466891777612010199340554025320408220230957044116330406835099017393\
101938373427200000/
            149365461584038769758273404277419252133481504402227553055163 - 
          \((11239470402961132722811135440696570371310950881751850127549676365\
6015965945279283200000\ x)\)/
            149365461584038769758273404277419252133481504402227553055163 + 
          \((62551236097958102529437572133862053112770396678215042761819882541\
377615415944806400000\ x\^2)\)/
            149365461584038769758273404277419252133481504402227553055163 - 
          \((10759547294625481017713959174540571814878810395631664191454621626\
773019219381452800000\ x\^3)\)/
            149365461584038769758273404277419252133481504402227553055163 + 
          \((78583812088643011741771061022087660895025300283165998417777853538\
9593235017523200000\ x\^4)\)/
            149365461584038769758273404277419252133481504402227553055163 - 
          \((28743213490775913022528306353329641085390178848776070918348278895\
186407817596108800\ x\^5)\)/
            149365461584038769758273404277419252133481504402227553055163 + 
          \((58095133936686227001749756227710638891669693646722011149940027365\
6364238304460800\ x\^6)\)/
            149365461584038769758273404277419252133481504402227553055163 - 
          \((69038274196376994259559935422205923897183853421363634180896156827\
45053354393600\ x\^7)\)/
            149365461584038769758273404277419252133481504402227553055163 + 
          \((50137190770852993637920610323689906021177631404785467482580325797\
335617683200\ x\^8)\)/
            149365461584038769758273404277419252133481504402227553055163 - 
          \((22720349355576237560393841262723318836552730070108354734099930513\
8158284800\ x\^9)\)/
            149365461584038769758273404277419252133481504402227553055163 + 
          \((64540944220441369728606974949517893612487754922070981174758620021\
5084608\ x\^10)\)/149365461584038769758273404277419252133481504402227553055163
             - \((113291993967259246550826374529975788136955592807583783376418\
6177515008\ x\^11)\)/
            149365461584038769758273404277419252133481504402227553055163 + 
          \((35327239823493844903191393212106029272429063980079863097499804150\
68\ x\^12)\)/448096384752116309274820212832257756400444513206682659165489 - 
          \(1968643204100160383099889723687859651991672614855314437419024096\ 
              x\^13\)\/\
448096384752116309274820212832257756400444513206682659165489 + x\^14\)}],
      SequenceForm[ "dorthpoly[", 1, ",", 14, ",", x, ",", 
        DirectedInfinity[ 1], "]=", 
        Plus[ 
          Rational[ 
          26466891777612010199340554025320408220230957044116330406835099017393\
101938373427200000, 
            149365461584038769758273404277419252133481504402227553055163], 
          Times[ 
            Rational[
             -1123947040296113272281113544069657037131095088175185012754967636\
56015965945279283200000, 
              149365461584038769758273404277419252133481504402227553055163], 
            x], 
          Times[ 
            Rational[ 
            625512360979581025294375721338620531127703966782150427618198825413\
77615415944806400000, 
              149365461584038769758273404277419252133481504402227553055163], 
            Power[ x, 2]], 
          Times[ 
            Rational[
             -1075954729462548101771395917454057181487881039563166419145462162\
6773019219381452800000, 
              149365461584038769758273404277419252133481504402227553055163], 
            Power[ x, 3]], 
          Times[ 
            Rational[ 
            785838120886430117417710610220876608950253002831659984177778535389\
593235017523200000, 
              149365461584038769758273404277419252133481504402227553055163], 
            Power[ x, 4]], 
          Times[ 
            Rational[
             -2874321349077591302252830635332964108539017884877607091834827889\
5186407817596108800, 
              149365461584038769758273404277419252133481504402227553055163], 
            Power[ x, 5]], 
          Times[ 
            Rational[ 
            580951339366862270017497562277106388916696936467220111499400273656\
364238304460800, 
              149365461584038769758273404277419252133481504402227553055163], 
            Power[ x, 6]], 
          Times[ 
            Rational[
             -6903827419637699425955993542220592389718385342136363418089615682\
745053354393600, 
              149365461584038769758273404277419252133481504402227553055163], 
            Power[ x, 7]], 
          Times[ 
            Rational[ 
            501371907708529936379206103236899060211776314047854674825803257973\
35617683200, 149365461584038769758273404277419252133481504402227553055163], 
            Power[ x, 8]], 
          Times[ 
            Rational[
             -2272034935557623756039384126272331883655273007010835473409993051\
38158284800, 149365461584038769758273404277419252133481504402227553055163], 
            Power[ x, 9]], 
          Times[ 
            Rational[ 
            645409442204413697286069749495178936124877549220709811747586200215\
084608, 149365461584038769758273404277419252133481504402227553055163], 
            Power[ x, 10]], 
          Times[ 
            Rational[
             -1132919939672592465508263745299757881369555928075837833764186177\
515008, 149365461584038769758273404277419252133481504402227553055163], 
            Power[ x, 11]], 
          Times[ 
            Rational[ 
            353272398234938449031913932121060292724290639800798630974998041506\
8, 448096384752116309274820212832257756400444513206682659165489], 
            Power[ x, 12]], 
          Times[ 
            Rational[
             -1968643204100160383099889723687859651991672614855314437419024096\
, 448096384752116309274820212832257756400444513206682659165489], 
            Power[ x, 13]], 
          Power[ x, 14]]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("dorthpoly["\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "15", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "x", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", 
        InterpretationBox["\[Infinity]",
          DirectedInfinity[ 1]], "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        \(\( - 658798221672341309946826109782980882202874413717834043414898072\
60290349715606546100235337728000000/
              7028087093681450169241921575805237118101707223966913308062563558\
35667\) + 
          \((28750950157076872371845057009367734072087129575578256230127411954\
0009279268305820017241948160000000\ x)\)/
            702808709368145016924192157580523711810170722396691330806256355835\
667 - \((166244401664998563558132163130424362238505301685265553171318378442460\
185019384085825383219200000000\ x\^2)\)/
            702808709368145016924192157580523711810170722396691330806256355835\
667 + \((299806639205636044925164345212691841352322213241007818227669140724373\
80839178902872928337920000000\ x\^3)\)/
            702808709368145016924192157580523711810170722396691330806256355835\
667 - \((231687330800958953698615245761070943189026037106720839388060509840436\
0309338546522261908480000000\ x\^4)\)/
            702808709368145016924192157580523711810170722396691330806256355835\
667 + \((905692467151475508368671252925573261044071583671812567533751093011115\
56343330652572417187840000\ x\^5)\)/
            702808709368145016924192157580523711810170722396691330806256355835\
667 - \((197899324019781465531021698376791956654565651575292125876527155043375\
9152206400271852595200000\ x\^6)\)/
            702808709368145016924192157580523711810170722396691330806256355835\
667 + \((257735859316555004919322419147193426386568894368365166225740545058204\
50060997080359168000000\ x\^7)\)/
            702808709368145016924192157580523711810170722396691330806256355835\
667 - \((208604164783154990812070075997064927244559166628783236629884207233044\
373682921684114400000\ x\^8)\)/
            702808709368145016924192157580523711810170722396691330806256355835\
667 + \((107650650096953554062834971289153739447400925523692289426018850278903\
3381835976453600000\ x\^9)\)/
            702808709368145016924192157580523711810170722396691330806256355835\
667 - \((358487481080602679504582994753632640461312820253774249392400863451081\
6412445609230400\ x\^10)\)/
            702808709368145016924192157580523711810170722396691330806256355835\
667 + \((769012410023618124403348522753246077985335892007873734748013619699690\
2264570216000\ x\^11)\)/
            702808709368145016924192157580523711810170722396691330806256355835\
667 - \((104267232322113265386906098578561398030222935789513652608362852089841\
62133222500\ x\^12)\)/
            702808709368145016924192157580523711810170722396691330806256355835\
667 + \((853217643551233683020396722025312777045385327286081752474138532031659\
7674500\ x\^13)\)/
            702808709368145016924192157580523711810170722396691330806256355835\
667 - \((380464171215716311234426504729012937992538169538876017266530305737074\
9875\ x\^14)\)/
            702808709368145016924192157580523711810170722396691330806256355835\
667 + x\^15\)}],
      SequenceForm[ "dorthpoly[", 1, ",", 15, ",", x, ",", 
        DirectedInfinity[ 1], "]=", 
        Plus[ 
          Rational[
           -658798221672341309946826109782980882202874413717834043414898072602\
90349715606546100235337728000000, 
            702808709368145016924192157580523711810170722396691330806256355835\
667], 
          Times[ 
            Rational[ 
            287509501570768723718450570093677340720871295755782562301274119540\
009279268305820017241948160000000, 
              7028087093681450169241921575805237118101707223966913308062563558\
35667], x], 
          Times[ 
            Rational[
             -1662444016649985635581321631304243622385053016852655531713183784\
42460185019384085825383219200000000, 
              7028087093681450169241921575805237118101707223966913308062563558\
35667], 
            Power[ x, 2]], 
          Times[ 
            Rational[ 
            299806639205636044925164345212691841352322213241007818227669140724\
37380839178902872928337920000000, 
              7028087093681450169241921575805237118101707223966913308062563558\
35667], 
            Power[ x, 3]], 
          Times[ 
            Rational[
             -2316873308009589536986152457610709431890260371067208393880605098\
404360309338546522261908480000000, 
              7028087093681450169241921575805237118101707223966913308062563558\
35667], 
            Power[ x, 4]], 
          Times[ 
            Rational[ 
            905692467151475508368671252925573261044071583671812567533751093011\
11556343330652572417187840000, 
              7028087093681450169241921575805237118101707223966913308062563558\
35667], 
            Power[ x, 5]], 
          Times[ 
            Rational[
             -1978993240197814655310216983767919566545656515752921258765271550\
433759152206400271852595200000, 
              7028087093681450169241921575805237118101707223966913308062563558\
35667], 
            Power[ x, 6]], 
          Times[ 
            Rational[ 
            257735859316555004919322419147193426386568894368365166225740545058\
20450060997080359168000000, 
              7028087093681450169241921575805237118101707223966913308062563558\
35667], 
            Power[ x, 7]], 
          Times[ 
            Rational[
             -2086041647831549908120700759970649272445591666287832366298842072\
33044373682921684114400000, 
              7028087093681450169241921575805237118101707223966913308062563558\
35667], 
            Power[ x, 8]], 
          Times[ 
            Rational[ 
            107650650096953554062834971289153739447400925523692289426018850278\
9033381835976453600000, 
              7028087093681450169241921575805237118101707223966913308062563558\
35667], 
            Power[ x, 9]], 
          Times[ 
            Rational[
             -3584874810806026795045829947536326404613128202537742493924008634\
510816412445609230400, 
              7028087093681450169241921575805237118101707223966913308062563558\
35667], 
            Power[ x, 10]], 
          Times[ 
            Rational[ 
            769012410023618124403348522753246077985335892007873734748013619699\
6902264570216000, 
              7028087093681450169241921575805237118101707223966913308062563558\
35667], 
            Power[ x, 11]], 
          Times[ 
            Rational[
             -1042672323221132653869060985785613980302229357895136526083628520\
8984162133222500, 
              7028087093681450169241921575805237118101707223966913308062563558\
35667], 
            Power[ x, 12]], 
          Times[ 
            Rational[ 
            853217643551233683020396722025312777045385327286081752474138532031\
6597674500, 
              7028087093681450169241921575805237118101707223966913308062563558\
35667], 
            Power[ x, 13]], 
          Times[ 
            Rational[
             -3804641712157163112344265047290129379925381695388760172665303057\
370749875, 
              7028087093681450169241921575805237118101707223966913308062563558\
35667], 
            Power[ x, 14]], 
          Power[ x, 15]]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("dorthpoly["\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "16", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "x", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", 
        InterpretationBox["\[Infinity]",
          DirectedInfinity[ 1]], "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        \(33042735652303447116738581310599708836375454694842854524086369052281\
06041822193036261499243496081465540608000000/
            583877604183053514779602987834245699599065073565700541548628311737\
17339554354667 - 
          \((14788137933807566247716317832515277285761306916015209179848895527\
282002017198334406290638419997346379071488000000\ x)\)/
            583877604183053514779602987834245699599065073565700541548628311737\
17339554354667 + 
          \((88554919522104778314454248296646072016217333801567296829386985459\
79734298534256608966090776569603015311360000000\ x\^2)\)/
            583877604183053514779602987834245699599065073565700541548628311737\
17339554354667 - 
          \((16671915483766628025280696910559918591839929731794111340414087228\
98175348530557140681089646178148359864320000000\ x\^3)\)/
            583877604183053514779602987834245699599065073565700541548628311737\
17339554354667 + 
          \((13557879056852516813474650254547378844718344534138902647614310630\
4733916620823148504832154188743390003200000000\ x\^4)\)/
            583877604183053514779602987834245699599065073565700541548628311737\
17339554354667 - 
          \((56252027095911592382694017111694925378632866209222880468845447564\
40363870073915422308380441394324690698240000\ x\^5)\)/
            583877604183053514779602987834245699599065073565700541548628311737\
17339554354667 + 
          \((13171893108532749076110295084244082434552587445109632829025138850\
8399775021741297328778082535301227479040000\ x\^6)\)/
            583877604183053514779602987834245699599065073565700541548628311737\
17339554354667 - 
          \((18590008305934925786582635718629925896249823729495878806461726700\
45369559484108863504443936615904051200000\ x\^7)\)/
            583877604183053514779602987834245699599065073565700541548628311737\
17339554354667 + 
          \((16525339825355189716504359231344645975043411102590997182447201947\
756137288214076311382178739136102400000\ x\^8)\)/
            583877604183053514779602987834245699599065073565700541548628311737\
17339554354667 - 
          \((95232345198676625403320058249096645130447992329169213843368490988\
489632390201999804879292858368000000\ x\^9)\)/
            583877604183053514779602987834245699599065073565700541548628311737\
17339554354667 + 
          \((36180671232777081063137696580155257617369971470636159107222024682\
4449725443442492084924648023654400\ x\^10)\)/
            583877604183053514779602987834245699599065073565700541548628311737\
17339554354667 - 
          \((91140858191461803676218267077015932588819279781108970825004159552\
1508517154117404640638559846400\ x\^11)\)/
            583877604183053514779602987834245699599065073565700541548628311737\
17339554354667 + 
          \((15125681860018923625667920825344607286616934001627187474564301320\
66191830189705386596038656000\ x\^12)\)/
            583877604183053514779602987834245699599065073565700541548628311737\
17339554354667 - 
          \((16169703092227823898312393113434806807189645828789043839810370900\
66723620150567877066752000\ x\^13)\)/
            583877604183053514779602987834245699599065073565700541548628311737\
17339554354667 + 
          \((10602868431330182276123734673012214897600305109830728874178256645\
49057774295208488960000\ x\^14)\)/
            583877604183053514779602987834245699599065073565700541548628311737\
17339554354667 - 
          \((38421639458361804842810772730714474212621135254041719141495633548\
8286510092371034112\ x\^15)\)/
            583877604183053514779602987834245699599065073565700541548628311737\
17339554354667 + x\^16\)}],
      SequenceForm[ "dorthpoly[", 1, ",", 16, ",", x, ",", 
        DirectedInfinity[ 1], "]=", 
        Plus[ 
          Rational[ 
          33042735652303447116738581310599708836375454694842854524086369052281\
06041822193036261499243496081465540608000000, 
            583877604183053514779602987834245699599065073565700541548628311737\
17339554354667], 
          Times[ 
            Rational[
             -1478813793380756624771631783251527728576130691601520917984889552\
7282002017198334406290638419997346379071488000000, 
              5838776041830535147796029878342456995990650735657005415486283117\
3717339554354667], x], 
          Times[ 
            Rational[ 
            885549195221047783144542482966460720162173338015672968293869854597\
9734298534256608966090776569603015311360000000, 
              5838776041830535147796029878342456995990650735657005415486283117\
3717339554354667], 
            Power[ x, 2]], 
          Times[ 
            Rational[
             -1667191548376662802528069691055991859183992973179411134041408722\
898175348530557140681089646178148359864320000000, 
              5838776041830535147796029878342456995990650735657005415486283117\
3717339554354667], 
            Power[ x, 3]], 
          Times[ 
            Rational[ 
            135578790568525168134746502545473788447183445341389026476143106304\
733916620823148504832154188743390003200000000, 
              5838776041830535147796029878342456995990650735657005415486283117\
3717339554354667], 
            Power[ x, 4]], 
          Times[ 
            Rational[
             -5625202709591159238269401711169492537863286620922288046884544756\
440363870073915422308380441394324690698240000, 
              5838776041830535147796029878342456995990650735657005415486283117\
3717339554354667], 
            Power[ x, 5]], 
          Times[ 
            Rational[ 
            131718931085327490761102950842440824345525874451096328290251388508\
399775021741297328778082535301227479040000, 
              5838776041830535147796029878342456995990650735657005415486283117\
3717339554354667], 
            Power[ x, 6]], 
          Times[ 
            Rational[
             -1859000830593492578658263571862992589624982372949587880646172670\
045369559484108863504443936615904051200000, 
              5838776041830535147796029878342456995990650735657005415486283117\
3717339554354667], 
            Power[ x, 7]], 
          Times[ 
            Rational[ 
            165253398253551897165043592313446459750434111025909971824472019477\
56137288214076311382178739136102400000, 
              5838776041830535147796029878342456995990650735657005415486283117\
3717339554354667], 
            Power[ x, 8]], 
          Times[ 
            Rational[
             -9523234519867662540332005824909664513044799232916921384336849098\
8489632390201999804879292858368000000, 
              5838776041830535147796029878342456995990650735657005415486283117\
3717339554354667], 
            Power[ x, 9]], 
          Times[ 
            Rational[ 
            361806712327770810631376965801552576173699714706361591072220246824\
449725443442492084924648023654400, 
              5838776041830535147796029878342456995990650735657005415486283117\
3717339554354667], 
            Power[ x, 10]], 
          Times[ 
            Rational[
             -9114085819146180367621826707701593258881927978110897082500415955\
21508517154117404640638559846400, 
              5838776041830535147796029878342456995990650735657005415486283117\
3717339554354667], 
            Power[ x, 11]], 
          Times[ 
            Rational[ 
            151256818600189236256679208253446072866169340016271874745643013206\
6191830189705386596038656000, 
              5838776041830535147796029878342456995990650735657005415486283117\
3717339554354667], 
            Power[ x, 12]], 
          Times[ 
            Rational[
             -1616970309222782389831239311343480680718964582878904383981037090\
066723620150567877066752000, 
              5838776041830535147796029878342456995990650735657005415486283117\
3717339554354667], 
            Power[ x, 13]], 
          Times[ 
            Rational[ 
            106028684313301822761237346730122148976003051098307288741782566454\
9057774295208488960000, 
              5838776041830535147796029878342456995990650735657005415486283117\
3717339554354667], 
            Power[ x, 14]], 
          Times[ 
            Rational[
             -3842163945836180484281077273071447421262113525404171914149563354\
88286510092371034112, 
              5838776041830535147796029878342456995990650735657005415486283117\
3717339554354667], 
            Power[ x, 15]], 
          Power[ x, 16]]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("dorthpoly["\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "17", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "x", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", 
        InterpretationBox["\[Infinity]",
          DirectedInfinity[ 1]], "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        \(\( - 122938406313078621117085823461349447219827615840842971953539186\
336786111017308902910615855310366526691657650520845189120000000/
              3178880296082737847363788967763927154869039989947840787171050354\
874073934803101334167705369\) + 
          \((56320599660326256045795261307447896143460570955586054446536736338\
8614900196635758728146761305334586728720705348723277824000000\ x)\)/
            317888029608273784736378896776392715486903998994784078717105035487\
4073934803101334167705369 - 
          \((34831444945485220093634387948788663030462962746728100061945172983\
9874298026040547508483096826984470503116143730859442176000000\ x\^2)\)/
            317888029608273784736378896776392715486903998994784078717105035487\
4073934803101334167705369 + 
          \((68210025528030605275444967172697798777519882939454267615935114136\
306133364573724446216098551578050117667462323917291520000000\ x\^3)\)/
            317888029608273784736378896776392715486903998994784078717105035487\
4073934803101334167705369 - 
          \((58104208347802102006380723928385805971479366028001586385979657377\
95805646018649090988060608152324807953815266090024960000000\ x\^4)\)/
            317888029608273784736378896776392715486903998994784078717105035487\
4073934803101334167705369 + 
          \((25440963051975373807857076234043776066840553434714528482030654903\
1320304150632416878590819357043776904148704955046297600000\ x\^5)\)/
            317888029608273784736378896776392715486903998994784078717105035487\
4073934803101334167705369 - 
          \((63384861082223038016092344193500013028545328471618236045763144324\
63338782276431582391226669486759963955875164161310720000\ x\^6)\)/
            
            317888029608273784736378896776392715486903998994784078717105035487\
4073934803101334167705369 + 
          \((96077200834418955059846389582223497172292681954593656840038434573\
202542320671989209713207788670144184283667344916480000\ x\^7)\)/
            317888029608273784736378896776392715486903998994784078717105035487\
4073934803101334167705369 - 
          \((92738150315413134151227973683273443949379873464613851086402345185\
3741980468898512601594859514671670896775374438400000\ x\^8)\)/
            317888029608273784736378896776392715486903998994784078717105035487\
4073934803101334167705369 + 
          \((58804263981546847027138918041815826697140719879413006246967491317\
73633086799947198380355235443186466380870451200000\ x\^9)\)/
            317888029608273784736378896776392715486903998994784078717105035487\
4073934803101334167705369 - 
          \((24990487246453918777005091043825692061679668991816721497275505645\
534494738990226152668642020472213987252371456000\ x\^10)\)/
            317888029608273784736378896776392715486903998994784078717105035487\
4073934803101334167705369 + 
          \((71933039919448277765464128407399334487317015834490533386355273523\
288606834093304861215532059260546294821683200\ x\^11)\)/
            317888029608273784736378896776392715486903998994784078717105035487\
4073934803101334167705369 - 
          \((42117945728954609012122913090727456501977306875764764260102799934\
8313121445603729321876758147318114475622400\ x\^12)\)/
            953664088824821354209136690329178146460711996984352236151315106462\
2221804409304002503116107 + 
          \((55187644383501158840669699841574327657785976016704272435488383416\
9336067111668163151030324058075314176000\ x\^13)\)/
            953664088824821354209136690329178146460711996984352236151315106462\
2221804409304002503116107 - 
          \((15779145614276371986427743604364181807831584567342670176303692882\
4567640860315686100632409211908096000\ x\^14)\)/
            317888029608273784736378896776392715486903998994784078717105035487\
4073934803101334167705369 + 
          \((75767375846592782535211619536392058193693584623346370211332083474\
4863291234016084091859290225541120\ x\^15)\)/
            286099226647446406262741007098753443938213599095305670845394531938\
66665413227912007509348321 - 
          \((22613439129328853469179764337553218702938564686638848933636625613\
4697403345600778353693131209249\ x\^16)\)/
            286099226647446406262741007098753443938213599095305670845394531938\
66665413227912007509348321 + x\^17\)}],
      SequenceForm[ "dorthpoly[", 1, ",", 17, ",", x, ",", 
        DirectedInfinity[ 1], "]=", 
        Plus[ 
          Rational[
           -122938406313078621117085823461349447219827615840842971953539186336\
786111017308902910615855310366526691657650520845189120000000, 
            317888029608273784736378896776392715486903998994784078717105035487\
4073934803101334167705369], 
          Times[ 
            Rational[ 
            563205996603262560457952613074478961434605709555860544465367363388\
614900196635758728146761305334586728720705348723277824000000, 
              3178880296082737847363788967763927154869039989947840787171050354\
874073934803101334167705369], x], 
          Times[ 
            Rational[
             -3483144494548522009363438794878866303046296274672810006194517298\
39874298026040547508483096826984470503116143730859442176000000, 
              3178880296082737847363788967763927154869039989947840787171050354\
874073934803101334167705369], 
            Power[ x, 2]], 
          Times[ 
            Rational[ 
            682100255280306052754449671726977987775198829394542676159351141363\
06133364573724446216098551578050117667462323917291520000000, 
              3178880296082737847363788967763927154869039989947840787171050354\
874073934803101334167705369], 
            Power[ x, 3]], 
          Times[ 
            Rational[
             -5810420834780210200638072392838580597147936602800158638597965737\
795805646018649090988060608152324807953815266090024960000000, 
              3178880296082737847363788967763927154869039989947840787171050354\
874073934803101334167705369], 
            Power[ x, 4]], 
          Times[ 
            Rational[ 
            254409630519753738078570762340437760668405534347145284820306549031\
320304150632416878590819357043776904148704955046297600000, 
              3178880296082737847363788967763927154869039989947840787171050354\
874073934803101334167705369], 
            Power[ x, 5]], 
          Times[ 
            Rational[
             -6338486108222303801609234419350001302854532847161823604576314432\
463338782276431582391226669486759963955875164161310720000, 
              3178880296082737847363788967763927154869039989947840787171050354\
874073934803101334167705369], 
            Power[ x, 6]], 
          Times[ 
            Rational[ 
            960772008344189550598463895822234971722926819545936568400384345732\
02542320671989209713207788670144184283667344916480000, 
              3178880296082737847363788967763927154869039989947840787171050354\
874073934803101334167705369], 
            Power[ x, 7]], 
          Times[ 
            Rational[
             -9273815031541313415122797368327344394937987346461385108640234518\
53741980468898512601594859514671670896775374438400000, 
              3178880296082737847363788967763927154869039989947840787171050354\
874073934803101334167705369], 
            Power[ x, 8]], 
          Times[ 
            Rational[ 
            588042639815468470271389180418158266971407198794130062469674913177\
3633086799947198380355235443186466380870451200000, 
              3178880296082737847363788967763927154869039989947840787171050354\
874073934803101334167705369], 
            Power[ x, 9]], 
          Times[ 
            Rational[
             -2499048724645391877700509104382569206167966899181672149727550564\
5534494738990226152668642020472213987252371456000, 
              3178880296082737847363788967763927154869039989947840787171050354\
874073934803101334167705369], 
            Power[ x, 10]], 
          Times[ 
            Rational[ 
            719330399194482777654641284073993344873170158344905333863552735232\
88606834093304861215532059260546294821683200, 
              3178880296082737847363788967763927154869039989947840787171050354\
874073934803101334167705369], 
            Power[ x, 11]], 
          Times[ 
            Rational[
             -4211794572895460901212291309072745650197730687576476426010279993\
48313121445603729321876758147318114475622400, 
              9536640888248213542091366903291781464607119969843522361513151064\
622221804409304002503116107], 
            Power[ x, 12]], 
          Times[ 
            Rational[ 
            551876443835011588406696998415743276577859760167042724354883834169\
336067111668163151030324058075314176000, 
              9536640888248213542091366903291781464607119969843522361513151064\
622221804409304002503116107], 
            Power[ x, 13]], 
          Times[ 
            Rational[
             -1577914561427637198642774360436418180783158456734267017630369288\
24567640860315686100632409211908096000, 
              3178880296082737847363788967763927154869039989947840787171050354\
874073934803101334167705369], 
            Power[ x, 14]], 
          Times[ 
            Rational[ 
            757673758465927825352116195363920581936935846233463702113320834744\
863291234016084091859290225541120, 
              2860992266474464062627410070987534439382135990953056708453945319\
3866665413227912007509348321], 
            Power[ x, 15]], 
          Times[ 
            Rational[
             -2261343912932885346917976433755321870293856468663884893363662561\
34697403345600778353693131209249, 
              2860992266474464062627410070987534439382135990953056708453945319\
3866665413227912007509348321], 
            Power[ x, 16]], 
          Power[ x, 17]]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("dorthpoly["\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "18", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "x", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", 
        InterpretationBox["\[Infinity]",
          DirectedInfinity[ 1]], "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        \(24603446797320930053086968537126598335575000234431628180036992160749\
55535367973621142955479811499016742395522761930468036187410009161728000000/
            828407199293219884539685752039177572611035662341225410677662568009\
91447889569702092997318530271855003337 - 
          \((11519222612872838387092711136800909065005595470735930732044284317\
775410298167210950425809375396919605675068211338389836932185394539134976000000
                \ x)\)/8284071992932198845396857520391775726110356623412254106\
7766256800991447889569702092997318530271855003337 + 
          \((73399807318038717354764750290097221928816892557125137563303389654\
47077489364261125960589148642012829565300135450811067727160855404478464000000
                \ x\^2)\)/
            828407199293219884539685752039177572611035662341225410677662568009\
91447889569702092997318530271855003337 - 
          \((14904779637089557200997067575009577559814274545466495770279220067\
12583655570230063689693027804519742796358516415957066096112236398379008000000
                \ x\^3)\)/
            828407199293219884539685752039177572611035662341225410677662568009\
91447889569702092997318530271855003337 + 
          \((13247895141216019426685157397802921091931999583342937874986609740\
4165541726259801329857611085576808551460421377831157906314082994094080000000\ 
                x\^4)\)/
            828407199293219884539685752039177572611035662341225410677662568009\
91447889569702092997318530271855003337 - 
          \((60920497254430384897548568120640958272612801932846068509067712193\
51100406801380329319232876602305596471315551293756696242096420253859840000\ 
                x\^5)\)/
            828407199293219884539685752039177572611035662341225410677662568009\
91447889569702092997318530271855003337 + 
          \((16054080488837315870885814244629409229868564124644700143082233643\
4674763420729561980562488640069161720371936093611316401465684844871680000\ 
                x\^6)\)/
            828407199293219884539685752039177572611035662341225410677662568009\
91447889569702092997318530271855003337 - 
          \((25944505096052406863681255168862370908280670099601370805512475138\
00251127214490914479668608879929988273712293708435707828795835678720000\ x\^7)
              \)/8284071992932198845396857520391775726110356623412254106776625\
6800991447889569702092997318530271855003337 + 
          \((26945557211895782677279435965642451189714061912549455918521349586\
546425788790194828782050996497623312221534512196719643435652874240000\ x\^8)
              \)/8284071992932198845396857520391775726110356623412254106776625\
6800991447889569702092997318530271855003337 - 
          \((18583968620577859523111486189120784064826554289692011748564986285\
3596725816328481571240989962408528021063732499086251897493913600000\ x\^9)\)/
            828407199293219884539685752039177572611035662341225410677662568009\
91447889569702092997318530271855003337 + 
          \((87036048658902740126609137736212237783462615130180851599415713457\
9938286843820960567167408325690084388723482386966078264206950400\ x\^10)\)/
            828407199293219884539685752039177572611035662341225410677662568009\
91447889569702092997318530271855003337 - 
          \((28064574885472763757004723316967878673075053670703429500130494078\
14245488948116123809305429847217548070934720018505599339724800\ x\^11)\)/
            828407199293219884539685752039177572611035662341225410677662568009\
91447889569702092997318530271855003337 + 
          \((62673634788906448521943638181957338363882439608221926258347419704\
26143652122923508029809825612152343346318022853050110771200\ x\^12)\)/
            828407199293219884539685752039177572611035662341225410677662568009\
91447889569702092997318530271855003337 - 
          \((96701208126591779969880117564763528533987831329189570876351043652\
96831634604330089267109211448690576048404437578573414400\ x\^13)\)/
            828407199293219884539685752039177572611035662341225410677662568009\
91447889569702092997318530271855003337 + 
          \((10179070674124228406873275200395452124033450094816995502788346884\
307277789714835917987458854907198342178399064967168000\ x\^14)\)/
            828407199293219884539685752039177572611035662341225410677662568009\
91447889569702092997318530271855003337 - 
          \((71122028395610267520506168598433548520164756274346409686389143065\
07451954721025929160035048727693255656973469089792\ x\^15)\)/
            828407199293219884539685752039177572611035662341225410677662568009\
91447889569702092997318530271855003337 + 
          \((31287126117927312370360173152671340574283677960065975547566399235\
58267062073738344130263864020957108710961672124\ x\^16)\)/
            828407199293219884539685752039177572611035662341225410677662568009\
91447889569702092997318530271855003337 - 
          \((77822506957455073833116455935743575076011688097037382597874351994\
9410809165364174915788270077259322490053216\ x\^17)\)/
            828407199293219884539685752039177572611035662341225410677662568009\
91447889569702092997318530271855003337 + x\^18\)}],
      SequenceForm[ "dorthpoly[", 1, ",", 18, ",", x, ",", 
        DirectedInfinity[ 1], "]=", 
        Plus[ 
          Rational[ 
          24603446797320930053086968537126598335575000234431628180036992160749\
55535367973621142955479811499016742395522761930468036187410009161728000000, 
            828407199293219884539685752039177572611035662341225410677662568009\
91447889569702092997318530271855003337], 
          Times[ 
            Rational[
             -1151922261287283838709271113680090906500559547073593073204428431\
777541029816721095042580937539691960567506821133838983693218539453913497600000\
0, 828407199293219884539685752039177572611035662341225410677662568009914478895\
69702092997318530271855003337], x], 
          Times[ 
            Rational[ 
            733998073180387173547647502900972219288168925571251375633033896544\
7077489364261125960589148642012829565300135450811067727160855404478464000000, 
              8284071992932198845396857520391775726110356623412254106776625680\
0991447889569702092997318530271855003337], 
            Power[ x, 2]], 
          Times[ 
            Rational[
             -1490477963708955720099706757500957755981427454546649577027922006\
712583655570230063689693027804519742796358516415957066096112236398379008000000\
, 8284071992932198845396857520391775726110356623412254106776625680099144788956\
9702092997318530271855003337], 
            Power[ x, 3]], 
          Times[ 
            Rational[ 
            132478951412160194266851573978029210919319995833429378749866097404\
165541726259801329857611085576808551460421377831157906314082994094080000000, 
              8284071992932198845396857520391775726110356623412254106776625680\
0991447889569702092997318530271855003337], 
            Power[ x, 4]], 
          Times[ 
            Rational[
             -6092049725443038489754856812064095827261280193284606850906771219\
351100406801380329319232876602305596471315551293756696242096420253859840000, 
              8284071992932198845396857520391775726110356623412254106776625680\
0991447889569702092997318530271855003337], 
            Power[ x, 5]], 
          Times[ 
            Rational[ 
            160540804888373158708858142446294092298685641246447001430822336434\
674763420729561980562488640069161720371936093611316401465684844871680000, 
              8284071992932198845396857520391775726110356623412254106776625680\
0991447889569702092997318530271855003337], 
            Power[ x, 6]], 
          Times[ 
            Rational[
             -2594450509605240686368125516886237090828067009960137080551247513\
800251127214490914479668608879929988273712293708435707828795835678720000, 
              8284071992932198845396857520391775726110356623412254106776625680\
0991447889569702092997318530271855003337], 
            Power[ x, 7]], 
          Times[ 
            Rational[ 
            269455572118957826772794359656424511897140619125494559185213495865\
46425788790194828782050996497623312221534512196719643435652874240000, 
              8284071992932198845396857520391775726110356623412254106776625680\
0991447889569702092997318530271855003337], 
            Power[ x, 8]], 
          Times[ 
            Rational[
             -1858396862057785952311148618912078406482655428969201174856498628\
53596725816328481571240989962408528021063732499086251897493913600000, 
              8284071992932198845396857520391775726110356623412254106776625680\
0991447889569702092997318530271855003337], 
            Power[ x, 9]], 
          Times[ 
            Rational[ 
            870360486589027401266091377362122377834626151301808515994157134579\
938286843820960567167408325690084388723482386966078264206950400, 
              8284071992932198845396857520391775726110356623412254106776625680\
0991447889569702092997318530271855003337], 
            Power[ x, 10]], 
          Times[ 
            Rational[
             -2806457488547276375700472331696787867307505367070342950013049407\
814245488948116123809305429847217548070934720018505599339724800, 
              8284071992932198845396857520391775726110356623412254106776625680\
0991447889569702092997318530271855003337], 
            Power[ x, 11]], 
          Times[ 
            Rational[ 
            626736347889064485219436381819573383638824396082219262583474197042\
6143652122923508029809825612152343346318022853050110771200, 
              8284071992932198845396857520391775726110356623412254106776625680\
0991447889569702092997318530271855003337], 
            Power[ x, 12]], 
          Times[ 
            Rational[
             -9670120812659177996988011756476352853398783132918957087635104365\
296831634604330089267109211448690576048404437578573414400, 
              8284071992932198845396857520391775726110356623412254106776625680\
0991447889569702092997318530271855003337], 
            Power[ x, 13]], 
          Times[ 
            Rational[ 
            101790706741242284068732752003954521240334500948169955027883468843\
07277789714835917987458854907198342178399064967168000, 
              
              8284071992932198845396857520391775726110356623412254106776625680\
0991447889569702092997318530271855003337], 
            Power[ x, 14]], 
          Times[ 
            Rational[
             -7112202839561026752050616859843354852016475627434640968638914306\
507451954721025929160035048727693255656973469089792, 
              8284071992932198845396857520391775726110356623412254106776625680\
0991447889569702092997318530271855003337], 
            Power[ x, 15]], 
          Times[ 
            Rational[ 
            312871261179273123703601731526713405742836779600659755475663992355\
8267062073738344130263864020957108710961672124, 
              8284071992932198845396857520391775726110356623412254106776625680\
0991447889569702092997318530271855003337], 
            Power[ x, 16]], 
          Times[ 
            Rational[
             -7782250695745507383311645593574357507601168809703738259787435199\
49410809165364174915788270077259322490053216, 
              8284071992932198845396857520391775726110356623412254106776625680\
0991447889569702092997318530271855003337], 
            Power[ x, 17]], 
          Power[ x, 18]]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("dorthpoly["\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "19", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "x", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", 
        InterpretationBox["\[Infinity]",
          DirectedInfinity[ 1]], "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        \(\( - 108475050395337729263994340779399222734124743688850813640487782\
340688589869269980749725695116791160715004697200985947606568554201603479361388\
582067503104000000/
              4259455126024958489187798558080993563419762798222425579861897729\
137832046378218098732917290200460941181714094559989971\) + 
          \((51831431449103417886005922986047141352789158828652450354886877617\
126817591722834779547468840649768615995294939573877395637570696951843677744520\
6486155264000000\ x)\)/
            425945512602495848918779855808099356341976279822242557986189772913\
7832046378218098732917290200460941181714094559989971 - 
          \((33956824329332796666541713126672598097639694905226283252814760971\
376742149357259586575891909092943851459271465684735177426464777178280836341569\
5458828288000000\ x\^2)\)/
            425945512602495848918779855808099356341976279822242557986189772913\
7832046378218098732917290200460941181714094559989971 + 
          \((71308752589340266290605644770656359869521906070598172616147364130\
218124261393181296084854755156599475352091615826606373892960620907450946116572\
472672256000000\ x\^3)\)/
            425945512602495848918779855808099356341976279822242557986189772913\
7832046378218098732917290200460941181714094559989971 - 
          \((65913511777797694432457592934294079273962042679023751622371038968\
511504183049243977268340495023197344191561451145173090776232409841814656041294\
32797184000000\ x\^4)\)/
            425945512602495848918779855808099356341976279822242557986189772913\
7832046378218098732917290200460941181714094559989971 + 
          \((31703397131419002223544868754685768652429382030107081824141465906\
722249227716225259992849778437626215694220477179857631119825562574325917133581\
0706309120000\ x\^5)\)/
            425945512602495848918779855808099356341976279822242557986189772913\
7832046378218098732917290200460941181714094559989971 - 
          \((87929728041914737115361748603728920423986042380357165361603217986\
866462034507890930393800421441456634462969426407814636484708915202320294820824\
95365120000\ x\^6)\)/
            425945512602495848918779855808099356341976279822242557986189772913\
7832046378218098732917290200460941181714094559989971 + 
          \((15058586559616541079769151414498082050549045933731352456026657392\
254822221918967709426321699736985590329058795459026699693128742121272299156913\
7827840000\ x\^7)\)/
            425945512602495848918779855808099356341976279822242557986189772913\
7832046378218098732917290200460941181714094559989971 - 
          \((45143126560064039802442411036635459271757494806405821718153251639\
675132634324853591572500745857362361978145184804248108274368875430615328334807\
040000\ x\^8)\)/
            115120408811485364572643204272459285497831426978984475131402641328\
049514766978867533322088924336782194100380934053783 + 
          \((12414500227286614329933977227476689656789890560079245682438903378\
328779044148975576062143924523248499106896043233243685861371923225522307735224\
320000\ x\^9)\)/
            425945512602495848918779855808099356341976279822242557986189772913\
7832046378218098732917290200460941181714094559989971 - 
          \((63331682489433750872514197136452762434234182716696501932714056501\
097670237020524205691237629021867918916420741496638393752787046762960410719027\
200\ x\^10)\)/
            425945512602495848918779855808099356341976279822242557986189772913\
7832046378218098732917290200460941181714094559989971 + 
          \((22535251451634938222551110362792660348528716048688037260331372862\
864622025222718472402706496061766105663269081769434219401923251164823271505920\
0\ x\^11)\)/
            425945512602495848918779855808099356341976279822242557986189772913\
7832046378218098732917290200460941181714094559989971 - 
          \((56447512368997960829749981891506080799496468379749487704979564499\
2088897199563618149945015421901912285489614687762465246202008454992135782400\ 
                x\^12)\)/
            425945512602495848918779855808099356341976279822242557986189772913\
7832046378218098732917290200460941181714094559989971 + 
          \((99774346261471609257413316795085721175023485797840594684932380064\
8774483728295573937703490658168751393926602859865686556525476362120396800\ 
                x\^13)\)/
            425945512602495848918779855808099356341976279822242557986189772913\
7832046378218098732917290200460941181714094559989971 - 
          \((12381041827439196926231513942614057922241144699696853787642132137\
99983518415738261323439037906901655819205570653005059924033836895027200\ 
                x\^14)\)/
            425945512602495848918779855808099356341976279822242557986189772913\
7832046378218098732917290200460941181714094559989971 + 
          \((10627495468702157029621124626780286295464518544149368862585315682\
81091927307864023971497998340025924467484057135080175583059688800256\ x\^15)
              \)/4259455126024958489187798558080993563419762798222425579861897\
729137832046378218098732917290200460941181714094559989971 - 
          \((61287771234255906673945765138124820493152669607130136427827698933\
1387760721705296159817077978784902773475930351620478328461256676\ x\^16)\)/
            425945512602495848918779855808099356341976279822242557986189772913\
7832046378218098732917290200460941181714094559989971 + 
          \((22491143596359931851890821905318621348720602336910038090939338068\
7738773948851358978427184499263602388309150378301374835699012\ x\^17)\)/
            425945512602495848918779855808099356341976279822242557986189772913\
7832046378218098732917290200460941181714094559989971 - 
          \((47113122971907146962786615972495529782881770348563940600755255246\
465737830009166727733465570324606787308100163054496691779\ x\^18)\)/
            425945512602495848918779855808099356341976279822242557986189772913\
7832046378218098732917290200460941181714094559989971 + x\^19\)}],
      SequenceForm[ "dorthpoly[", 1, ",", 19, ",", x, ",", 
        DirectedInfinity[ 1], "]=", 
        Plus[ 
          Rational[
           -108475050395337729263994340779399222734124743688850813640487782340\
688589869269980749725695116791160715004697200985947606568554201603479361388582\
067503104000000, 
            425945512602495848918779855808099356341976279822242557986189772913\
7832046378218098732917290200460941181714094559989971], 
          Times[ 
            Rational[ 
            518314314491034178860059229860471413527891588286524503548868776171\
268175917228347795474688406497686159952949395738773956375706969518436777445206\
486155264000000, 
              4259455126024958489187798558080993563419762798222425579861897729\
137832046378218098732917290200460941181714094559989971], x], 
          Times[ 
            Rational[
             -3395682432933279666654171312667259809763969490522628325281476097\
137674214935725958657589190909294385145927146568473517742646477717828083634156\
95458828288000000, 
              4259455126024958489187798558080993563419762798222425579861897729\
137832046378218098732917290200460941181714094559989971], 
            Power[ x, 2]], 
          Times[ 
            Rational[ 
            713087525893402662906056447706563598695219060705981726161473641302\
181242613931812960848547551565994753520916158266063738929606209074509461165724\
72672256000000, 
              4259455126024958489187798558080993563419762798222425579861897729\
137832046378218098732917290200460941181714094559989971], 
            Power[ x, 3]], 
          Times[ 
            Rational[
             -6591351177779769443245759293429407927396204267902375162237103896\
851150418304924397726834049502319734419156145114517309077623240984181465604129\
432797184000000, 
              4259455126024958489187798558080993563419762798222425579861897729\
137832046378218098732917290200460941181714094559989971], 
            Power[ x, 4]], 
          Times[ 
            Rational[ 
            317033971314190022235448687546857686524293820301070818241414659067\
222492277162252599928497784376262156942204771798576311198255625743259171335810\
706309120000, 
              4259455126024958489187798558080993563419762798222425579861897729\
137832046378218098732917290200460941181714094559989971], 
            Power[ x, 5]], 
          Times[ 
            Rational[
             -8792972804191473711536174860372892042398604238035716536160321798\
686646203450789093039380042144145663446296942640781463648470891520232029482082\
495365120000, 
              4259455126024958489187798558080993563419762798222425579861897729\
137832046378218098732917290200460941181714094559989971], 
            Power[ x, 6]], 
          Times[ 
            Rational[ 
            150585865596165410797691514144980820505490459337313524560266573922\
548222219189677094263216997369855903290587954590266996931287421212722991569137\
827840000, 
              4259455126024958489187798558080993563419762798222425579861897729\
137832046378218098732917290200460941181714094559989971], 
            Power[ x, 7]], 
          Times[ 
            Rational[
             -4514312656006403980244241103663545927175749480640582171815325163\
967513263432485359157250074585736236197814518480424810827436887543061532833480\
7040000, 115120408811485364572643204272459285497831426978984475131402641328049\
514766978867533322088924336782194100380934053783], 
            Power[ x, 8]], 
          Times[ 
            Rational[ 
            124145002272866143299339772274766896567898905600792456824389033783\
287790441489755760621439245232484991068960432332436858613719232255223077352243\
20000, 42594551260249584891877985580809935634197627982224255798618977291378320\
46378218098732917290200460941181714094559989971], 
            Power[ x, 9]], 
          Times[ 
            Rational[
             -6333168248943375087251419713645276243423418271669650193271405650\
109767023702052420569123762902186791891642074149663839375278704676296041071902\
7200, 425945512602495848918779855808099356341976279822242557986189772913783204\
6378218098732917290200460941181714094559989971], 
            Power[ x, 10]], 
          Times[ 
            Rational[ 
            225352514516349382225511103627926603485287160486880372603313728628\
646220252227184724027064960617661056632690817694342194019232511648232715059200\
, 4259455126024958489187798558080993563419762798222425579861897729137832046378\
218098732917290200460941181714094559989971], 
            Power[ x, 11]], 
          Times[ 
            Rational[
             -5644751236899796082974998189150608079949646837974948770497956449\
92088897199563618149945015421901912285489614687762465246202008454992135782400,
               425945512602495848918779855808099356341976279822242557986189772\
9137832046378218098732917290200460941181714094559989971], 
            Power[ x, 12]], 
          Times[ 
            Rational[ 
            997743462614716092574133167950857211750234857978405946849323800648\
774483728295573937703490658168751393926602859865686556525476362120396800, 
              4259455126024958489187798558080993563419762798222425579861897729\
137832046378218098732917290200460941181714094559989971], 
            Power[ x, 13]], 
          Times[ 
            Rational[
             -1238104182743919692623151394261405792224114469969685378764213213\
799983518415738261323439037906901655819205570653005059924033836895027200, 
              4259455126024958489187798558080993563419762798222425579861897729\
137832046378218098732917290200460941181714094559989971], 
            Power[ x, 14]], 
          Times[ 
            Rational[ 
            106274954687021570296211246267802862954645185441493688625853156828\
1091927307864023971497998340025924467484057135080175583059688800256, 
              4259455126024958489187798558080993563419762798222425579861897729\
137832046378218098732917290200460941181714094559989971], 
            Power[ x, 15]], 
          Times[ 
            Rational[
             -6128777123425590667394576513812482049315266960713013642782769893\
31387760721705296159817077978784902773475930351620478328461256676, 
              4259455126024958489187798558080993563419762798222425579861897729\
137832046378218098732917290200460941181714094559989971], 
            Power[ x, 16]], 
          Times[ 
            Rational[ 
            224911435963599318518908219053186213487206023369100380909393380687\
738773948851358978427184499263602388309150378301374835699012, 
              4259455126024958489187798558080993563419762798222425579861897729\
137832046378218098732917290200460941181714094559989971], 
            Power[ x, 17]], 
          Times[ 
            Rational[
             -4711312297190714696278661597249552978288177034856394060075525524\
6465737830009166727733465570324606787308100163054496691779, 
              4259455126024958489187798558080993563419762798222425579861897729\
137832046378218098732917290200460941181714094559989971], 
            Power[ x, 18]], 
          Power[ x, 19]]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("dorthpoly["\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "20", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "x", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", 
        InterpretationBox["\[Infinity]",
          DirectedInfinity[ 1]], "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        \(10491524015299455723561971623834052621722233806195476827723475909017\
302493673517357573454780751007442134292711696002948857555754328030888293084355\
289002381613955914137600000000/
            432769160879200759786476357118863256585557136221586156062998811325\
315227806886113970743455024556267598761514455218207776793118603881 - 
          \((51097086667670413560250304736658949240505492513499495806928191586\
021766070865847341309732416671954520830546232493781469436118478427821581087655\
503520382427915800805376000000000\ x)\)/
            432769160879200759786476357118863256585557136221586156062998811325\
315227806886113970743455024556267598761514455218207776793118603881 + 
          \((34355461621125293961824555947343879506272920237833291087655057019\
453595497887383084211786101617691383552775855938336929810470963868510770175053\
989911654679058537512960000000000\ x\^2)\)/
            432769160879200759786476357118863256585557136221586156062998811325\
315227806886113970743455024556267598761514455218207776793118603881 - 
          \((74434796845755024263758977765920164865727286752326296629239025891\
508770712458608925399580288257177813292576199302774093485661325563850421114815\
21310472953450297556992000000000\ x\^3)\)/
            432769160879200759786476357118863256585557136221586156062998811325\
315227806886113970743455024556267598761514455218207776793118603881 + 
          \((71344379992705849144372514082865349594587920094091849314867203029\
246278308310655964092501512149347772733775474381023600606022520231291259129775\
5027105797452089786368000000000\ x\^4)\)/
            432769160879200759786476357118863256585557136221586156062998811325\
315227806886113970743455024556267598761514455218207776793118603881 - 
          \((35766774471276829795894555408686162238208466950760355717874839504\
244046722394698355424996069416039243861579689636427978407389971349829351839828\
274087395900626246303744000000\ x\^5)\)/
            432769160879200759786476357118863256585557136221586156062998811325\
315227806886113970743455024556267598761514455218207776793118603881 + 
          \((10396266198186480810350202572056151477909827294621198856909511091\
755268981438341927295068218816477729871678701974009832179357468581704277577872\
25733375441986733998080000000\ x\^6)\)/
            432769160879200759786476357118863256585557136221586156062998811325\
315227806886113970743455024556267598761514455218207776793118603881 - 
          \((18771340092842296087879976648292507761554680426831839883392595932\
545255218087466247260928907568265837423819493860858991208274330379669010804238\
072718653891228467200000000\ x\^7)\)/
            432769160879200759786476357118863256585557136221586156062998811325\
315227806886113970743455024556267598761514455218207776793118603881 + 
          \((22099572229333354163681302550544493250423798561556882251567982482\
015343680974105382750195757271602499296296795554712546417281942481019697876992\
6714893451248271360000000\ x\^8)\)/
            432769160879200759786476357118863256585557136221586156062998811325\
315227806886113970743455024556267598761514455218207776793118603881 - 
          \((17567961192921407932022163954863575926294412856733201456724683543\
373667460871654198616787551088735839523201280802288390855310069081977762085440\
10044397626327040000000\ x\^9)\)/
            432769160879200759786476357118863256585557136221586156062998811325\
315227806886113970743455024556267598761514455218207776793118603881 + 
          \((96713058056933373731767828423965327029158794625933160852811361859\
424096446461019561587224641468446804373908442969730362417560999984363608676982\
32361173615902720000\ x\^10)\)/
            432769160879200759786476357118863256585557136221586156062998811325\
315227806886113970743455024556267598761514455218207776793118603881 - 
          \((37532313721641785762817525403449826196516658597474366116233017512\
410494281881799169788238954516235560270935799109708044885084211687216707600507\
329157110169600000\ x\^11)\)/
            432769160879200759786476357118863256585557136221586156062998811325\
315227806886113970743455024556267598761514455218207776793118603881 + 
          \((10386841004165151243409897801535035320880755498300592199148949883\
767533907977572059157975637525748240991284188494589590593260343443321129736034\
0641529856000000\ x\^12)\)/
            432769160879200759786476357118863256585557136221586156062998811325\
315227806886113970743455024556267598761514455218207776793118603881 - 
          \((20615670751089589180115107939236129552748438180615577172389442773\
369997755131079143572148192726452452099649387054806926971699377907377461216459\
7986099200000\ x\^13)\)/
            432769160879200759786476357118863256585557136221586156062998811325\
315227806886113970743455024556267598761514455218207776793118603881 + 
          \((29337323660035879800841196877327378548527430151872812950818032432\
801120782921103891827432453338846807861426391125448299094843721573132220630086\
7788800000\ x\^14)\)/
            432769160879200759786476357118863256585557136221586156062998811325\
315227806886113970743455024556267598761514455218207776793118603881 - 
          \((29716013547874992531358264366155764157283733084084356200259054262\
651082585300896535134492257134521605430422506924221967265633856763831836016283\
4841600\ x\^15)\)/
            432769160879200759786476357118863256585557136221586156062998811325\
315227806886113970743455024556267598761514455218207776793118603881 + 
          \((21072904051217337688217250570183370800901493125057417969417816122\
690353190045003376901013618768345983068665457683216771016934213019467677602050\
4000\ x\^16)\)/
            432769160879200759786476357118863256585557136221586156062998811325\
315227806886113970743455024556267598761514455218207776793118603881 - 
          \((
              1014699923569954288881705862279298439980039632240609246267073255\
534333089979493521868056938697012453523154403915038082151519567307389894000000\
00\ x\^17)\)/
            432769160879200759786476357118863256585557136221586156062998811325\
315227806886113970743455024556267598761514455218207776793118603881 + 
          \((94159518353196906608511162990972404748677609119768693495318184324\
089992201600798902166023064752923836561424426035563448386802714360161504000\ 
                x\^18)\)/
            129830748263760227935942907135658976975667140866475846818899643397\
5945683420658341912230365073668802796284543365654623330379355811643 - 
          \((16765983626096000465529618983352681742672778590421664276708509266\
707803581173879152580883608867806582880444644096599800679420100651936000\ 
                x\^19)\)/
            129830748263760227935942907135658976975667140866475846818899643397\
5945683420658341912230365073668802796284543365654623330379355811643 + 
          x\^20\)}],
      SequenceForm[ "dorthpoly[", 1, ",", 20, ",", x, ",", 
        DirectedInfinity[ 1], "]=", 
        Plus[ 
          Rational[ 
          10491524015299455723561971623834052621722233806195476827723475909017\
302493673517357573454780751007442134292711696002948857555754328030888293084355\
289002381613955914137600000000, 
            432769160879200759786476357118863256585557136221586156062998811325\
315227806886113970743455024556267598761514455218207776793118603881], 
          Times[ 
            Rational[
             -5109708666767041356025030473665894924050549251349949580692819158\
602176607086584734130973241667195452083054623249378146943611847842782158108765\
5503520382427915800805376000000000, 
              4327691608792007597864763571188632565855571362215861560629988113\
25315227806886113970743455024556267598761514455218207776793118603881], x], 
          Times[ 
            Rational[ 
            343554616211252939618245559473438795062729202378332910876550570194\
535954978873830842117861016176913835527758559383369298104709638685107701750539\
89911654679058537512960000000000, 
              4327691608792007597864763571188632565855571362215861560629988113\
25315227806886113970743455024556267598761514455218207776793118603881], 
            Power[ x, 2]], 
          Times[ 
            Rational[
             -7443479684575502426375897776592016486572728675232629662923902589\
150877071245860892539958028825717781329257619930277409348566132556385042111481\
521310472953450297556992000000000, 
              4327691608792007597864763571188632565855571362215861560629988113\
25315227806886113970743455024556267598761514455218207776793118603881], 
            Power[ x, 3]], 
          Times[ 
            Rational[ 
            713443799927058491443725140828653495945879200940918493148672030292\
462783083106559640925015121493477727337754743810236006060225202312912591297755\
027105797452089786368000000000, 
              4327691608792007597864763571188632565855571362215861560629988113\
25315227806886113970743455024556267598761514455218207776793118603881], 
            Power[ x, 4]], 
          Times[ 
            Rational[
             -3576677447127682979589455540868616223820846695076035571787483950\
424404672239469835542499606941603924386157968963642797840738997134982935183982\
8274087395900626246303744000000, 
              4327691608792007597864763571188632565855571362215861560629988113\
25315227806886113970743455024556267598761514455218207776793118603881], 
            Power[ x, 5]], 
          Times[ 
            Rational[ 
            103962661981864808103502025720561514779098272946211988569095110917\
552689814383419272950682188164777298716787019740098321793574685817042775778722\
5733375441986733998080000000, 
              4327691608792007597864763571188632565855571362215861560629988113\
25315227806886113970743455024556267598761514455218207776793118603881], 
            Power[ x, 6]], 
          Times[ 
            Rational[
             -1877134009284229608787997664829250776155468042683183988339259593\
254525521808746624726092890756826583742381949386085899120827433037966901080423\
8072718653891228467200000000, 
              4327691608792007597864763571188632565855571362215861560629988113\
25315227806886113970743455024556267598761514455218207776793118603881], 
            Power[ x, 7]], 
          Times[ 
            Rational[ 
            220995722293333541636813025505444932504237985615568822515679824820\
153436809741053827501957572716024992962967955547125464172819424810196978769926\
714893451248271360000000, 
              4327691608792007597864763571188632565855571362215861560629988113\
25315227806886113970743455024556267598761514455218207776793118603881], 
            Power[ x, 8]], 
          Times[ 
            Rational[
             -1756796119292140793202216395486357592629441285673320145672468354\
337366746087165419861678755108873583952320128080228839085531006908197776208544\
010044397626327040000000, 
              4327691608792007597864763571188632565855571362215861560629988113\
25315227806886113970743455024556267598761514455218207776793118603881], 
            Power[ x, 9]], 
          Times[ 
            Rational[ 
            967130580569333737317678284239653270291587946259331608528113618594\
240964464610195615872246414684468043739084429697303624175609999843636086769823\
2361173615902720000, 
              4327691608792007597864763571188632565855571362215861560629988113\
25315227806886113970743455024556267598761514455218207776793118603881], 
            Power[ x, 10]], 
          Times[ 
            Rational[
             -3753231372164178576281752540344982619651665859747436611623301751\
241049428188179916978823895451623556027093579910970804488508421168721670760050\
7329157110169600000, 
              4327691608792007597864763571188632565855571362215861560629988113\
25315227806886113970743455024556267598761514455218207776793118603881], 
            Power[ x, 11]], 
          Times[ 
            Rational[ 
            103868410041651512434098978015350353208807554983005921991489498837\
675339079775720591579756375257482409912841884945895905932603434433211297360340\
641529856000000, 
              4327691608792007597864763571188632565855571362215861560629988113\
25315227806886113970743455024556267598761514455218207776793118603881], 
            Power[ x, 12]], 
          Times[ 
            Rational[
             -2061567075108958918011510793923612955274843818061557717238944277\
336999775513107914357214819272645245209964938705480692697169937790737746121645\
97986099200000, 
              4327691608792007597864763571188632565855571362215861560629988113\
25315227806886113970743455024556267598761514455218207776793118603881], 
            Power[ x, 13]], 
          Times[ 
            Rational[ 
            293373236600358798008411968773273785485274301518728129508180324328\
011207829211038918274324533388468078614263911254482990948437215731322206300867\
788800000, 
              4327691608792007597864763571188632565855571362215861560629988113\
25315227806886113970743455024556267598761514455218207776793118603881], 
            Power[ x, 14]], 
          Times[ 
            Rational[
             -2971601354787499253135826436615576415728373308408435620025905426\
265108258530089653513449225713452160543042250692422196726563385676383183601628\
34841600, 
              4327691608792007597864763571188632565855571362215861560629988113\
25315227806886113970743455024556267598761514455218207776793118603881], 
            Power[ x, 15]], 
          Times[ 
            Rational[ 
            210729040512173376882172505701833708009014931250574179694178161226\
903531900450033769010136187683459830686654576832167710169342130194676776020504\
000, 4327691608792007597864763571188632565855571362215861560629988113253152278\
06886113970743455024556267598761514455218207776793118603881], 
            Power[ x, 16]], 
          Times[ 
            Rational[
             -1014699923569954288881705862279298439980039632240609246267073255\
534333089979493521868056938697012453523154403915038082151519567307389894000000\
00, 43276916087920075978647635711886325658555713622158615606299881132531522780\
6886113970743455024556267598761514455218207776793118603881], 
            Power[ x, 17]], 
          Times[ 
            Rational[ 
            941595183531969066085111629909724047486776091197686934953181843240\
89992201600798902166023064752923836561424426035563448386802714360161504000, 
              1298307482637602279359429071356589769756671408664758468188996433\
975945683420658341912230365073668802796284543365654623330379355811643], 
            Power[ x, 18]], 
          Times[ 
            Rational[
             -1676598362609600046552961898335268174267277859042166427670850926\
6707803581173879152580883608867806582880444644096599800679420100651936000, 
              1298307482637602279359429071356589769756671408664758468188996433\
975945683420658341912230365073668802796284543365654623330379355811643], 
            Power[ x, 19]], 
          Power[ x, 20]]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("dorthpoly["\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "21", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "x", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", 
        InterpretationBox["\[Infinity]",
          DirectedInfinity[ 1]], "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        \(\( - 598711657529994995222396212922642330976969787742164141508854889\
786373615448318868274735889482466204795934212223686606031312511729449580243869\
21735848308961055744148675198880880808846950400000000/
              2349091702052838855446708898405302075746266714301024515291224316\
995088126172379641689767288507180912385003995629205078297878674485277604401388\
443529\) + 
          \((29688355988202959301512353229787177317234004048659771876863172214\
008788483514399938150541464371700831588555510926093484142983460946173886949168\
9888737868591089533256310466846179105072742400000000\ x)\)/
            234909170205283885544670889840530207574626671430102451529122431699\
508812617237964168976728850718091238500399562920507829787867448527760440138844\
3529 - \((
              2045249508218861525891489855353307915269634716615726205571862620\
627353061169382900898448670170459777199563528302611145281765284243615572315974\
00512262819299345117863208022212339883311104000000000\ x\^2)\)/
            234909170205283885544670889840530207574626671430102451529122431699\
508812617237964168976728850718091238500399562920507829787867448527760440138844\
3529 + \((
              4562393651380485609284062548152626549132082159593827168308622223\
171464675175883250834014168671047371293953288160687321197111178183330249314569\
8810852553637284531893292843821801477767168000000000\ x\^3)\)/
            234909170205283885544670889840530207574626671430102451529122431699\
508812617237964168976728850718091238500399562920507829787867448527760440138844\
3529 - \((
              4523024472631362262110992540889954432320414818861270729383860292\
438850883489088042673871582067501841776286107583638891895265883156600278348447\
410149954887094743711591425919277009469440000000000\ x\^4)\)/
            234909170205283885544670889840530207574626671430102451529122431699\
508812617237964168976728850718091238500399562920507829787867448527760440138844\
3529 + \((
              2356207360273523795010303428188565535362902876035659151376464804\
987974884695686521972959418391408807010401561768563904480734959272459841927891\
93347405222264945920762274164365354992664576000000\ x\^5)\)/
            234909170205283885544670889840530207574626671430102451529122431699\
508812617237964168976728850718091238500399562920507829787867448527760440138844\
3529 - \((
              7151473620729378169869081583941310302908945013363681504683981362\
974582587440117748117719905659609759758034784798449277092225291254447880115944\
454697999642535853651449110553795405807616000000\ x\^6)\)/
            234909170205283885544670889840530207574626671430102451529122431699\
508812617237964168976728850718091238500399562920507829787867448527760440138844\
3529 + \((
              1355476359770301797040817147264990427172526479610878478150970460\
692882750497976854188715261657086753744282092275799848322483890877317164297785\
30455007394500609471967800701680007249920000000\ x\^7)\)/
            234909170205283885544670889840530207574626671430102451529122431699\
508812617237964168976728850718091238500399562920507829787867448527760440138844\
3529 - \((
              1684982008459780954667609104846035750023402109422546362520964958\
736387724585508795625446095434225172919303435438019785392910638803342883692115\
965637398486014769360090133880677335040000000\ x\^8)\)/
            234909170205283885544670889840530207574626671430102451529122431699\
508812617237964168976728850718091238500399562920507829787867448527760440138844\
3529 + \((
              1423655582816043720659798092387964743164000083906562068178647659\
040825645259903379078430625920038870734440978267461714864008283302536031893818\
2169937980194895393056824609577369600000000\ x\^9)\)/
            234909170205283885544670889840530207574626671430102451529122431699\
508812617237964168976728850718091238500399562920507829787867448527760440138844\
3529 - \((
              8393045108467193218469175632792552509364936361125775948123399457\
208922254388376432003508039569680791870060545121476557605478475203288878953802\
3698324226914874499291231691871354880000\ x\^10)\)/
            234909170205283885544670889840530207574626671430102451529122431699\
508812617237964168976728850718091238500399562920507829787867448527760440138844\
3529 + \((
              3519040396060323521265259915350921980222320695286598059298520181\
073998003407599221732902815658520065526399121579615181445479809911023931319523\
31926971357500071822840431514746880000\ x\^11)\)/
            234909170205283885544670889840530207574626671430102451529122431699\
508812617237964168976728850718091238500399562920507829787867448527760440138844\
3529 - \((
              1063315461113234137816124877356881621061683597499340058821686508\
214581189959722133323327903714103304249274510246122809988414682609323567400879\
956228732397725946824517002854400000\ x\^12)\)/
            234909170205283885544670889840530207574626671430102451529122431699\
508812617237964168976728850718091238500399562920507829787867448527760440138844\
3529 + \((
              2334130685615722883168059522966079368858506423595503013170457360\
367064614618453746262300105744434622692372878698193889015628518578636690418984\
278524302585286239086644428800000\ x\^13)\)/
            234909170205283885544670889840530207574626671430102451529122431699\
508812617237964168976728850718091238500399562920507829787867448527760440138844\
3529 - \((
              3733507681320916046963921330830394193523400887025061505140262871\
073360984185977916824943292419440216976092971598778767764166933880939212612585\
516813949212397293486080000000\ x\^14)\)/
            234909170205283885544670889840530207574626671430102451529122431699\
508812617237964168976728850718091238500399562920507829787867448527760440138844\
3529 + \((
              4340892964940012772848474352631355340522777618087104735237262092\
896628482250257769394638867036885704745164351876268253774913296750651559307811\
652631740032941880272486400\ x\^15)\)/
            234909170205283885544670889840530207574626671430102451529122431699\
508812617237964168976728850718091238500399562920507829787867448527760440138844\
3529 - \((
              3635774821383530470423855605764590567367936597624097466083352118\
324860534161442939276870168830139924644726294744773229240721925221034425136271\
550171281825192944510400\ x\^16)\)/
            234909170205283885544670889840530207574626671430102451529122431699\
508812617237964168976728850718091238500399562920507829787867448527760440138844\
3529 + \((
              2154622734954429127854816651913231124852332362686192510851438063\
211056935277673167924003531560324388042516836522598840140867999620831451197030\
067410757729325656000\ x\^17)\)/
            234909170205283885544670889840530207574626671430102451529122431699\
508812617237964168976728850718091238500399562920507829787867448527760440138844\
3529 - \((
              8751975779366806376764491783778116823137361284657453764576993711\
750700770542261217823749652041520000555677498615009124571662639401347612004027\
25958581827712000\ x\^18)\)/
            234909170205283885544670889840530207574626671430102451529122431699\
508812617237964168976728850718091238500399562920507829787867448527760440138844\
3529 + \((
              2302953524351079513033127345295233062200619827612038682073060162\
954775216107795922521034626061108357245265620497545842636975873669251977567953\
03270863520000\ x\^19)\)/
            234909170205283885544670889840530207574626671430102451529122431699\
508812617237964168976728850718091238500399562920507829787867448527760440138844\
3529 - \((
              3514892646025912348476243499524758465990022798317644252235244660\
309921221284010580770337361680422741520525395827620263297352652046492991394764\
9984816249\ x\^20)\)/
            234909170205283885544670889840530207574626671430102451529122431699\
508812617237964168976728850718091238500399562920507829787867448527760440138844\
3529 + x\^21\)}],
      SequenceForm[ "dorthpoly[", 1, ",", 21, ",", x, ",", 
        DirectedInfinity[ 1], "]=", 
        Plus[ 
          Rational[
           -598711657529994995222396212922642330976969787742164141508854889786\
373615448318868274735889482466204795934212223686606031312511729449580243869217\
35848308961055744148675198880880808846950400000000, 
            234909170205283885544670889840530207574626671430102451529122431699\
508812617237964168976728850718091238500399562920507829787867448527760440138844\
3529], 
          Times[ 
            Rational[ 
            296883559882029593015123532297871773172340040486597718768631722140\
087884835143999381505414643717008315885555109260934841429834609461738869491689\
888737868591089533256310466846179105072742400000000, 
              2349091702052838855446708898405302075746266714301024515291224316\
995088126172379641689767288507180912385003995629205078297878674485277604401388\
443529], x], 
          Times[ 
            Rational[
             -2045249508218861525891489855353307915269634716615726205571862620\
627353061169382900898448670170459777199563528302611145281765284243615572315974\
00512262819299345117863208022212339883311104000000000, 
              2349091702052838855446708898405302075746266714301024515291224316\
995088126172379641689767288507180912385003995629205078297878674485277604401388\
443529], 
            Power[ x, 2]], 
          Times[ 
            Rational[ 
            456239365138048560928406254815262654913208215959382716830862222317\
146467517588325083401416867104737129395328816068732119711117818333024931456988\
10852553637284531893292843821801477767168000000000, 
              2349091702052838855446708898405302075746266714301024515291224316\
995088126172379641689767288507180912385003995629205078297878674485277604401388\
443529], 
            Power[ x, 3]], 
          Times[ 
            Rational[
             -4523024472631362262110992540889954432320414818861270729383860292\
438850883489088042673871582067501841776286107583638891895265883156600278348447\
410149954887094743711591425919277009469440000000000, 
              2349091702052838855446708898405302075746266714301024515291224316\
995088126172379641689767288507180912385003995629205078297878674485277604401388\
443529], 
            Power[ x, 4]], 
          Times[ 
            Rational[ 
            235620736027352379501030342818856553536290287603565915137646480498\
797488469568652197295941839140880701040156176856390448073495927245984192789193\
347405222264945920762274164365354992664576000000, 
              2349091702052838855446708898405302075746266714301024515291224316\
995088126172379641689767288507180912385003995629205078297878674485277604401388\
443529], 
            Power[ x, 5]], 
          Times[ 
            Rational[
             -7151473620729378169869081583941310302908945013363681504683981362\
974582587440117748117719905659609759758034784798449277092225291254447880115944\
454697999642535853651449110553795405807616000000, 
              2349091702052838855446708898405302075746266714301024515291224316\
995088126172379641689767288507180912385003995629205078297878674485277604401388\
443529], 
            Power[ x, 6]], 
          Times[ 
            Rational[ 
            135547635977030179704081714726499042717252647961087847815097046069\
288275049797685418871526165708675374428209227579984832248389087731716429778530\
455007394500609471967800701680007249920000000, 
              2349091702052838855446708898405302075746266714301024515291224316\
995088126172379641689767288507180912385003995629205078297878674485277604401388\
443529], 
            Power[ x, 7]], 
          Times[ 
            Rational[
             -1684982008459780954667609104846035750023402109422546362520964958\
736387724585508795625446095434225172919303435438019785392910638803342883692115\
965637398486014769360090133880677335040000000, 
              2349091702052838855446708898405302075746266714301024515291224316\
995088126172379641689767288507180912385003995629205078297878674485277604401388\
443529], 
            Power[ x, 8]], 
          Times[ 
            Rational[ 
            142365558281604372065979809238796474316400008390656206817864765904\
082564525990337907843062592003887073444097826746171486400828330253603189381821\
69937980194895393056824609577369600000000, 
              2349091702052838855446708898405302075746266714301024515291224316\
995088126172379641689767288507180912385003995629205078297878674485277604401388\
443529], 
            Power[ x, 9]], 
          Times[ 
            Rational[
             -8393045108467193218469175632792552509364936361125775948123399457\
208922254388376432003508039569680791870060545121476557605478475203288878953802\
3698324226914874499291231691871354880000, 
              2349091702052838855446708898405302075746266714301024515291224316\
995088126172379641689767288507180912385003995629205078297878674485277604401388\
443529], 
            Power[ x, 10]], 
          Times[ 
            Rational[ 
            351904039606032352126525991535092198022232069528659805929852018107\
399800340759922173290281565852006552639912157961518144547980991102393131952331\
926971357500071822840431514746880000, 
              2349091702052838855446708898405302075746266714301024515291224316\
995088126172379641689767288507180912385003995629205078297878674485277604401388\
443529], 
            Power[ x, 11]], 
          Times[ 
            Rational[
             -1063315461113234137816124877356881621061683597499340058821686508\
214581189959722133323327903714103304249274510246122809988414682609323567400879\
956228732397725946824517002854400000, 
              2349091702052838855446708898405302075746266714301024515291224316\
995088126172379641689767288507180912385003995629205078297878674485277604401388\
443529], 
            Power[ x, 12]], 
          Times[ 
            Rational[ 
            233413068561572288316805952296607936885850642359550301317045736036\
706461461845374626230010574443462269237287869819388901562851857863669041898427\
8524302585286239086644428800000, 
              
              2349091702052838855446708898405302075746266714301024515291224316\
995088126172379641689767288507180912385003995629205078297878674485277604401388\
443529], 
            Power[ x, 13]], 
          Times[ 
            Rational[
             -3733507681320916046963921330830394193523400887025061505140262871\
073360984185977916824943292419440216976092971598778767764166933880939212612585\
516813949212397293486080000000, 
              2349091702052838855446708898405302075746266714301024515291224316\
995088126172379641689767288507180912385003995629205078297878674485277604401388\
443529], 
            Power[ x, 14]], 
          Times[ 
            Rational[ 
            434089296494001277284847435263135534052277761808710473523726209289\
662848225025776939463886703688570474516435187626825377491329675065155930781165\
2631740032941880272486400, 
              2349091702052838855446708898405302075746266714301024515291224316\
995088126172379641689767288507180912385003995629205078297878674485277604401388\
443529], 
            Power[ x, 15]], 
          Times[ 
            Rational[
             -3635774821383530470423855605764590567367936597624097466083352118\
324860534161442939276870168830139924644726294744773229240721925221034425136271\
550171281825192944510400, 
              2349091702052838855446708898405302075746266714301024515291224316\
995088126172379641689767288507180912385003995629205078297878674485277604401388\
443529], 
            Power[ x, 16]], 
          Times[ 
            Rational[ 
            215462273495442912785481665191323112485233236268619251085143806321\
105693527767316792400353156032438804251683652259884014086799962083145119703006\
7410757729325656000, 
              2349091702052838855446708898405302075746266714301024515291224316\
995088126172379641689767288507180912385003995629205078297878674485277604401388\
443529], 
            Power[ x, 17]], 
          Times[ 
            Rational[
             -8751975779366806376764491783778116823137361284657453764576993711\
750700770542261217823749652041520000555677498615009124571662639401347612004027\
25958581827712000, 
              2349091702052838855446708898405302075746266714301024515291224316\
995088126172379641689767288507180912385003995629205078297878674485277604401388\
443529], 
            Power[ x, 18]], 
          Times[ 
            Rational[ 
            230295352435107951303312734529523306220061982761203868207306016295\
477521610779592252103462606110835724526562049754584263697587366925197756795303\
270863520000, 
              2349091702052838855446708898405302075746266714301024515291224316\
995088126172379641689767288507180912385003995629205078297878674485277604401388\
443529], 
            Power[ x, 19]], 
          Times[ 
            Rational[
             -3514892646025912348476243499524758465990022798317644252235244660\
309921221284010580770337361680422741520525395827620263297352652046492991394764\
9984816249, 
              2349091702052838855446708898405302075746266714301024515291224316\
995088126172379641689767288507180912385003995629205078297878674485277604401388\
443529], 
            Power[ x, 20]], 
          Power[ x, 21]]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("dorthpoly["\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "22", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "x", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", 
        InterpretationBox["\[Infinity]",
          DirectedInfinity[ 1]], "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        \(82670326868260249728635127994176332277239778282896974597407788638115\
682247181228338904345331915255090285797616838916063910449200446087660109698692\
955911032168516131844695528866565363725660349469412032512000000000/
            280677677534688665997018648637808999374443741553334901049487530217\
492905251051936954368098634735752980791750219871938042654085826533699236765550\
3815332790388716369 - 
          \((41696096838519337220013752393377391380114410492445885312948720349\
984651001416574678299905782531100504426532964887266965925785384828540116199841\
9380447294750900511179849651516763212945226155703556286028185600000000\ x)\)/
            280677677534688665997018648637808999374443741553334901049487530217\
492905251051936954368098634735752980791750219871938042654085826533699236765550\
3815332790388716369 + 
          \((29389181123410250920294696766101345945161359917386315375979847514\
877538866539530987492084160168039848493089407230366196829264243702308939777025\
6683046340314042854153852599847624416698191235418868435805798400000000\ x\^2)
              \)/2806776775346886659970186486378089993744437415533349010494875\
302174929052510519369543680986347357529807917502198719380426540858265336992367\
655503815332790388716369 - 
          \((67375859408132718528726571632726031687732213969517642870294101743\
529488942972194360104806359939884097483530042983428111767332578911841929136849\
851848167591131741794354520540531872904228389063395937091584000000000\ x\^3)
              \)/2806776775346886659970186486378089993744437415533349010494875\
302174929052510519369543680986347357529807917502198719380426540858265336992367\
655503815332790388716369 + 
          \((68932556151924769716378388569985756266490121334943559917183608609\
612117051927890687846799130993142577868166633254833545212697625531036426787520\
94149967163268970190432359401816726694629097737612093816832000000000\ x\^4)\)/
            280677677534688665997018648637808999374443741553334901049487530217\
492905251051936954368098634735752980791750219871938042654085826533699236765550\
3815332790388716369 - 
          \((37214744890183793436685181533554828940516289070397756867243784432\
805257846814179703170561340258045593375241263072383336969483218100579939694223\
7665200830905961921699079003171083760337306282070248605614080000000\ x\^5)\)/
            280677677534688665997018648637808999374443741553334901049487530217\
492905251051936954368098634735752980791750219871938042654085826533699236765550\
3815332790388716369 + 
          \((11757269199693644757261778219827345220416277288846510029359538405\
611652811427870404227455983274426351421572666801695251245300980429076639089469\
746373333881554794476624520510717420754170899932588030296064000000\ x\^6)\)/
            280677677534688665997018648637808999374443741553334901049487530217\
492905251051936954368098634735752980791750219871938042654085826533699236765550\
3815332790388716369 - 
          \((23305204687386914860969853635656129871569529459293869702535782983\
902008357314296484807103606031214611926437527336622095817500516840863633852359\
0440158515931388704480154231162714747997677169917491675136000000\ x\^7)\)/
            280677677534688665997018648637808999374443741553334901049487530217\
492905251051936954368098634735752980791750219871938042654085826533699236765550\
3815332790388716369 + 
          \((30453649860549480955859350265553136093197442854358597600706550638\
121510546667187495258474860932670450366278501630853918385050672693404323579108\
23230451719113663938582870905328264032909317756808069120000000\ x\^8)\)/
            280677677534688665997018648637808999374443741553334901049487530217\
492905251051936954368098634735752980791750219871938042654085826533699236765550\
3815332790388716369 - 
          \((27203159600167699040837979371228326555327555908805028528464905897\
590715321009459277159973243502531442827177811253341986890050578544470285970620\
394965870248074274620179332477825462990876312768348160000000\ x\^9)\)/
            280677677534688665997018648637808999374443741553334901049487530217\
492905251051936954368098634735752980791750219871938042654085826533699236765550\
3815332790388716369 + 
          \((17065588185783064381758218110764467884224222381800700474442001945\
358848648161281230250414840842390451499459957957055709550530007095414882755480\
0546735949048165484210277410000308078192131098175078400000\ x\^10)\)/
            280677677534688665997018648637808999374443741553334901049487530217\
492905251051936954368098634735752980791750219871938042654085826533699236765550\
3815332790388716369 - 
          \((76711015817685138390184497706592617122272735560276408983949462246\
523152254572321178335376549556531633214261486859379179902347555600360463909914\
7126989984911324663576950282044995663137339678392320000\ x\^11)\)/
            280677677534688665997018648637808999374443741553334901049487530217\
492905251051936954368098634735752980791750219871938042654085826533699236765550\
3815332790388716369 + 
          \((25068685768098322664256203273265083722973370425285179717055744905\
873001238966033888962932571363582073010269812910765170554601625924004359496598\
15725534674002478578130080179223229419060008058880000\ x\^12)\)/
            280677677534688665997018648637808999374443741553334901049487530217\
492905251051936954368098634735752980791750219871938042654085826533699236765550\
3815332790388716369 - 
          \((60142316033961580708249468213849491238251184827527284558604035574\
156978840473626203510812897787458400072225910513959111915122023231165737081917\
33140693172267100318018057945898312024352358400000\ x\^13)\)/
            280677677534688665997018648637808999374443741553334901049487530217\
492905251051936954368098634735752980791750219871938042654085826533699236765550\
3815332790388716369 + 
          \((10649377808071576460547354461488365095384528706373887843243264566\
351411389072095038543158260803539223686023712221384108939272294140238299312383\
715365006808672624906449513760449561457459200000\ x\^14)\)/
            280677677534688665997018648637808999374443741553334901049487530217\
492905251051936954368098634735752980791750219871938042654085826533699236765550\
3815332790388716369 - 
          \((13929581671896491063326515480535817397403860058791734502214265132\
127970089132065773940156115057273932600920041421814760416324391274456852962155\
338386307469260120272414570386430678269952000\ x\^15)\)/
            280677677534688665997018648637808999374443741553334901049487530217\
492905251051936954368098634735752980791750219871938042654085826533699236765550\
3815332790388716369 + 
          \((13403331035148916612540594477427824704790225594204268445596277151\
040896963602362418443605652335392339383670017814024423236211641239174171823714\
809190925327343349427432823870550289849600\ x\^16)\)/
            280677677534688665997018648637808999374443741553334901049487530217\
492905251051936954368098634735752980791750219871938042654085826533699236765550\
3815332790388716369 - 
          \((93890018261915057617826518680482005632306689455662731779606760359\
663038281436244879208352878312775141612197465476227648581232255426270336672421\
36297348056007629960227016037836902400\ x\^17)\)/
            280677677534688665997018648637808999374443741553334901049487530217\
492905251051936954368098634735752980791750219871938042654085826533699236765550\
3815332790388716369 + 
          \((46973044001318501358316674869218061766760646032297551553906688785\
870766454313682690198650675430734211646205613440287405253398906274124005246669\
61713509152782515258588641626296000\ x\^18)\)/
            280677677534688665997018648637808999374443741553334901049487530217\
492905251051936954368098634735752980791750219871938042654085826533699236765550\
3815332790388716369 - 
          \((16243401262847989947980231804653785504044375314405421018404977431\
757836029481526414281360413170948599728298199243846902542387482098525617991264\
97251346561636194155022856768000\ x\^19)\)/
            280677677534688665997018648637808999374443741553334901049487530217\
492905251051936954368098634735752980791750219871938042654085826533699236765550\
3815332790388716369 + 
          \((36662762262963432813338901207530834080178109560003851035786072918\
565640469093051846205423657856242572251522695528488349006725268777323791695787\
1779092181155439956165093020\ x\^20)\)/
            280677677534688665997018648637808999374443741553334901049487530217\
492905251051936954368098634735752980791750219871938042654085826533699236765550\
3815332790388716369 - 
          \((48326668639298641021558166536481567600872585143629055839072740599\
631552958969700747795454856539360719968967669506721438132644144045273595519583\
291951736365119765818336\ x\^21)\)/
            280677677534688665997018648637808999374443741553334901049487530217\
492905251051936954368098634735752980791750219871938042654085826533699236765550\
3815332790388716369 + x\^22\)}],
      SequenceForm[ "dorthpoly[", 1, ",", 22, ",", x, ",", 
        DirectedInfinity[ 1], "]=", 
        Plus[ 
          Rational[ 
          82670326868260249728635127994176332277239778282896974597407788638115\
682247181228338904345331915255090285797616838916063910449200446087660109698692\
955911032168516131844695528866565363725660349469412032512000000000, 
            280677677534688665997018648637808999374443741553334901049487530217\
492905251051936954368098634735752980791750219871938042654085826533699236765550\
3815332790388716369], 
          Times[ 
            Rational[
             -4169609683851933722001375239337739138011441049244588531294872034\
998465100141657467829990578253110050442653296488726696592578538482854011619984\
19380447294750900511179849651516763212945226155703556286028185600000000, 
              2806776775346886659970186486378089993744437415533349010494875302\
174929052510519369543680986347357529807917502198719380426540858265336992367655\
503815332790388716369], x], 
          Times[ 
            Rational[ 
            293891811234102509202946967661013459451613599173863153759798475148\
775388665395309874920841601680398484930894072303661968292642437023089397770256\
683046340314042854153852599847624416698191235418868435805798400000000, 
              2806776775346886659970186486378089993744437415533349010494875302\
174929052510519369543680986347357529807917502198719380426540858265336992367655\
503815332790388716369], 
            Power[ x, 2]], 
          Times[ 
            Rational[
             -6737585940813271852872657163272603168773221396951764287029410174\
352948894297219436010480635993988409748353004298342811176733257891184192913684\
9851848167591131741794354520540531872904228389063395937091584000000000, 
              2806776775346886659970186486378089993744437415533349010494875302\
174929052510519369543680986347357529807917502198719380426540858265336992367655\
503815332790388716369], 
            Power[ x, 3]], 
          Times[ 
            Rational[ 
            689325561519247697163783885699857562664901213349435599171836086096\
121170519278906878467991309931425778681666332548335452126976255310364267875209\
4149967163268970190432359401816726694629097737612093816832000000000, 
              2806776775346886659970186486378089993744437415533349010494875302\
174929052510519369543680986347357529807917502198719380426540858265336992367655\
503815332790388716369], 
            Power[ x, 4]], 
          Times[ 
            Rational[
             -3721474489018379343668518153355482894051628907039775686724378443\
280525784681417970317056134025804559337524126307238333696948321810057993969422\
37665200830905961921699079003171083760337306282070248605614080000000, 
              2806776775346886659970186486378089993744437415533349010494875302\
174929052510519369543680986347357529807917502198719380426540858265336992367655\
503815332790388716369], 
            Power[ x, 5]], 
          Times[ 
            Rational[ 
            117572691996936447572617782198273452204162772888465100293595384056\
116528114278704042274559832744263514215726668016952512453009804290766390894697\
46373333881554794476624520510717420754170899932588030296064000000, 
              2806776775346886659970186486378089993744437415533349010494875302\
174929052510519369543680986347357529807917502198719380426540858265336992367655\
503815332790388716369], 
            Power[ x, 6]], 
          Times[ 
            Rational[
             -2330520468738691486096985363565612987156952945929386970253578298\
390200835731429648480710360603121461192643752733662209581750051684086363385235\
90440158515931388704480154231162714747997677169917491675136000000, 
              2806776775346886659970186486378089993744437415533349010494875302\
174929052510519369543680986347357529807917502198719380426540858265336992367655\
503815332790388716369], 
            Power[ x, 7]], 
          Times[ 
            Rational[ 
            304536498605494809558593502655531360931974428543585976007065506381\
215105466671874952584748609326704503662785016308539183850506726934043235791082\
3230451719113663938582870905328264032909317756808069120000000, 
              2806776775346886659970186486378089993744437415533349010494875302\
174929052510519369543680986347357529807917502198719380426540858265336992367655\
503815332790388716369], 
            Power[ x, 8]], 
          Times[ 
            Rational[
             -2720315960016769904083797937122832655532755590880502852846490589\
759071532100945927715997324350253144282717781125334198689005057854447028597062\
0394965870248074274620179332477825462990876312768348160000000, 
              2806776775346886659970186486378089993744437415533349010494875302\
174929052510519369543680986347357529807917502198719380426540858265336992367655\
503815332790388716369], 
            Power[ x, 9]], 
          Times[ 
            Rational[ 
            170655881857830643817582181107644678842242223818007004744420019453\
588486481612812302504148408423904514994599579570557095505300070954148827554800\
546735949048165484210277410000308078192131098175078400000, 
              2806776775346886659970186486378089993744437415533349010494875302\
174929052510519369543680986347357529807917502198719380426540858265336992367655\
503815332790388716369], 
            Power[ x, 10]], 
          Times[ 
            Rational[
             -7671101581768513839018449770659261712227273556027640898394946224\
652315225457232117833537654955653163321426148685937917990234755560036046390991\
47126989984911324663576950282044995663137339678392320000, 
              2806776775346886659970186486378089993744437415533349010494875302\
174929052510519369543680986347357529807917502198719380426540858265336992367655\
503815332790388716369], 
            Power[ x, 11]], 
          Times[ 
            Rational[ 
            250686857680983226642562032732650837229733704252851797170557449058\
730012389660338889629325713635820730102698129107651705546016259240043594965981\
5725534674002478578130080179223229419060008058880000, 
              2806776775346886659970186486378089993744437415533349010494875302\
174929052510519369543680986347357529807917502198719380426540858265336992367655\
503815332790388716369], 
            Power[ x, 12]], 
          Times[ 
            Rational[
             -6014231603396158070824946821384949123825118482752728455860403557\
415697884047362620351081289778745840007222591051395911191512202323116573708191\
733140693172267100318018057945898312024352358400000, 
              2806776775346886659970186486378089993744437415533349010494875302\
174929052510519369543680986347357529807917502198719380426540858265336992367655\
503815332790388716369], 
            Power[ x, 13]], 
          Times[ 
            Rational[ 
            106493778080715764605473544614883650953845287063738878432432645663\
514113890720950385431582608035392236860237122213841089392722941402382993123837\
15365006808672624906449513760449561457459200000, 
              
              2806776775346886659970186486378089993744437415533349010494875302\
174929052510519369543680986347357529807917502198719380426540858265336992367655\
503815332790388716369], 
            Power[ x, 14]], 
          Times[ 
            Rational[
             -1392958167189649106332651548053581739740386005879173450221426513\
212797008913206577394015611505727393260092004142181476041632439127445685296215\
5338386307469260120272414570386430678269952000, 
              2806776775346886659970186486378089993744437415533349010494875302\
174929052510519369543680986347357529807917502198719380426540858265336992367655\
503815332790388716369], 
            Power[ x, 15]], 
          Times[ 
            Rational[ 
            134033310351489166125405944774278247047902255942042684455962771510\
408969636023624184436056523353923393836700178140244232362116412391741718237148\
09190925327343349427432823870550289849600, 
              2806776775346886659970186486378089993744437415533349010494875302\
174929052510519369543680986347357529807917502198719380426540858265336992367655\
503815332790388716369], 
            Power[ x, 16]], 
          Times[ 
            Rational[
             -9389001826191505761782651868048200563230668945566273177960676035\
966303828143624487920835287831277514161219746547622764858123225542627033667242\
136297348056007629960227016037836902400, 
              2806776775346886659970186486378089993744437415533349010494875302\
174929052510519369543680986347357529807917502198719380426540858265336992367655\
503815332790388716369], 
            Power[ x, 17]], 
          Times[ 
            Rational[ 
            469730440013185013583166748692180617667606460322975515539066887858\
707664543136826901986506754307342116462056134402874052533989062741240052466696\
1713509152782515258588641626296000, 
              2806776775346886659970186486378089993744437415533349010494875302\
174929052510519369543680986347357529807917502198719380426540858265336992367655\
503815332790388716369], 
            Power[ x, 18]], 
          Times[ 
            Rational[
             -1624340126284798994798023180465378550404437531440542101840497743\
175783602948152641428136041317094859972829819924384690254238748209852561799126\
497251346561636194155022856768000, 
              2806776775346886659970186486378089993744437415533349010494875302\
174929052510519369543680986347357529807917502198719380426540858265336992367655\
503815332790388716369], 
            Power[ x, 19]], 
          Times[ 
            Rational[ 
            366627622629634328133389012075308340801781095600038510357860729185\
656404690930518462054236578562425722515226955284883490067252687773237916957871\
779092181155439956165093020, 
              2806776775346886659970186486378089993744437415533349010494875302\
174929052510519369543680986347357529807917502198719380426540858265336992367655\
503815332790388716369], 
            Power[ x, 20]], 
          Times[ 
            Rational[
             -4832666863929864102155816653648156760087258514362905583907274059\
963155295896970074779545485653936071996896766950672143813264414404527359551958\
3291951736365119765818336, 
              2806776775346886659970186486378089993744437415533349010494875302\
174929052510519369543680986347357529807917502198719380426540858265336992367655\
503815332790388716369], 
            Power[ x, 21]], 
          Power[ x, 22]]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("dorthpoly["\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "23", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "x", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", 
        InterpretationBox["\[Infinity]",
          DirectedInfinity[ 1]], "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        \(\( - 247799983202099517110687464732199158437208810001545745052509818\
498293886665127335690079281137433247486653162718966525998800044314516364975771\
353749306755997983264375012670487897689892175004520490114675236119720672575566\
643200000000/
              6651245225616235298952872586918557381568217804928397925220264860\
800158094044897187910072585474141600738885694096380327447982577386777091654109\
678993962734682834601401363634303627\) + 
          \((12700868625851148916928836437197599430433487170936529888310249275\
301117925771571094431563145676940909359636505914798546450327641916078395031246\
102819919529182106022022075788391917248542879998673276115569498690203830487875\
58400000000\ x)\)/
            665124522561623529895287258691855738156821780492839792522026486080\
015809404489718791007258547414160073888569409638032744798257738677709165410967\
8993962734682834601401363634303627 - 
          \((91473244475979573033774992580080059841442730652371558717185623548\
414197086652225922809978824873538477029124645406300534916631384039196079778730\
541153677202158440069662313218254686191800858600820956004010384295760058132725\
7600000000\ x\^2)\)/
            665124522561623529895287258691855738156821780492839792522026486080\
015809404489718791007258547414160073888569409638032744798257738677709165410967\
8993962734682834601401363634303627 + 
          \((21516506405733412018867655898669968212165866323931874065466767976\
210385248428083115540284235554751139236383855636980337830239592118257610054222\
802396049757171396300808755416674144923149193814619601738492113446113808136273\
9200000000\ x\^3)\)/
            665124522561623529895287258691855738156821780492839792522026486080\
015809404489718791007258547414160073888569409638032744798257738677709165410967\
8993962734682834601401363634303627 - 
          \((22673414515686197612066345131105915065185600115872725865155161613\
759043360154856024713989451375907195383451847169166151101592294409915892016617\
620499917687710041940419387311519678076980080862531284783866512486223866494976\
000000000\ x\^4)\)/
            665124522561623529895287258691855738156821780492839792522026486080\
015809404489718791007258547414160073888569409638032744798257738677709165410967\
8993962734682834601401363634303627 + 
          \((12655885859016734021479205670400183152861664906029603390874767274\
350475736669582559313993079742794965481765174559085336445407943952802429559021\
375399010396375685802246645633819013865767495779871327872165024627640009574318\
08000000\ x\^5)\)/
            665124522561623529895287258691855738156821780492839792522026486080\
015809404489718791007258547414160073888569409638032744798257738677709165410967\
8993962734682834601401363634303627 - 
          \((41503930744727129809683094747701201769054067788342226369531009473\
304599486720063203577494165649284240931630028257715961317734834768036748962261\
307686477163753628444860929932639434635371770748005820912489651802574973566976\
000000\ x\^6)\)/
            665124522561623529895287258691855738156821780492839792522026486080\
015809404489718791007258547414160073888569409638032744798257738677709165410967\
8993962734682834601401363634303627 + 
          \((85757115439573698947309938769646891846086061577837212923005737122\
637319546944437101395957784413556264642677859620375046833670241470032476807044\
962281162056396466133985829915675703805865832960584409532367168143622563430400\
0000\ x\^7)\)/
            665124522561623529895287258691855738156821780492839792522026486080\
015809404489718791007258547414160073888569409638032744798257738677709165410967\
8993962734682834601401363634303627 - 
          \((11734772091513476414296164030511871642150888747299715244343913500\
620368071459205758887774872533152475852153916395647915272895876815022134833177\
379055830141612119548710173275289675332143803281583657557967951582250139648000\
000\ x\^8)\)/
            665124522561623529895287258691855738156821780492839792522026486080\
015809404489718791007258547414160073888569409638032744798257738677709165410967\
8993962734682834601401363634303627 + 
          \((11032145899217188415197130567053460490019421074260211150231483732\
427276421055667812285295923429345116273746354358281940955001976744192573666821\
744207655719038990282701857108190754661390414921441682308867741102112768000000\
0\ x\^9)\)/
            665124522561623529895287258691855738156821780492839792522026486080\
015809404489718791007258547414160073888569409638032744798257738677709165410967\
8993962734682834601401363634303627 - 
          \((73251521404534474942278522812213783291415747360400506027196126205\
468937349424809197414250755695591495558561770093151701970528134350812211913202\
8538118378884051715155726597177802070063949028164585070996082522104791040000\ 
                x\^10)\)/
            665124522561623529895287258691855738156821780492839792522026486080\
015809404489718791007258547414160073888569409638032744798257738677709165410967\
8993962734682834601401363634303627 + 
          \((35074611318117600775079361772727321593720131908768103135745026551\
854910106163214429963284766710434043122370450952283261048883671852899490962979\
13611504047486874784747930934764474083573791342569697409550672755425280000\ 
                x\^11)\)/
            665124522561623529895287258691855738156821780492839792522026486080\
015809404489718791007258547414160073888569409638032744798257738677709165410967\
8993962734682834601401363634303627 - 
          \((12300519509928782968950712871632953839725961960821566282193459918\
057866503255075579583871094033385408254151505746806328341560987313355874063444\
430707947512638450595400058854108896823378383381580558401363123896320000\ 
                x\^12)\)/
            665124522561623529895287258691855738156821780492839792522026486080\
015809404489718791007258547414160073888569409638032744798257738677709165410967\
8993962734682834601401363634303627 + 
          \((31945449199402220915166323769110689916591066357223063877946905177\
196124488055993379871987746917159735522302560886229552622608819164798524007615\
027240944108267587768866125990453030230656343056062491234195210240000\ x\^13)
              \)/6651245225616235298952872586918557381568217804928397925220264\
860800158094044897187910072585474141600738885694096380327447982577386777091654\
109678993962734682834601401363634303627 - 
          \((61875465401228724563445911581552629692006229935221111693192804398\
324066715102304724787372868385789304145490518994457847676534590716410395886409\
966412234187006845875834067129062925802690761301513512573337600000\ x\^14)\)/
            665124522561623529895287258691855738156821780492839792522026486080\
015809404489718791007258547414160073888569409638032744798257738677709165410967\
8993962734682834601401363634303627 + 
          \((13383531097272933066428597089879306741507182911222348643785975515\
837738853562908179022122486214294601215795162013703839857785247321870814713134\
36904317300690057075205634556194869578860900258818848692633600\ x\^15)\)/
            992723168002423178948189938346053340532569821631104167943323113552\
262402096253311628369042608080835931176969268116466783280981699518968903598459\
55133772159445292558229307974681 - 
          \((97144012390509898073535255825992100677835924014213190268068237065\
131359955291568597852488430026839753157628886358281367214752539038923360242943\
245283623428341821156726456226913604340080037267715242310400\ x\^16)\)/
            665124522561623529895287258691855738156821780492839792522026486080\
015809404489718791007258547414160073888569409638032744798257738677709165410967\
8993962734682834601401363634303627 + 
          \((78236278237576204843279575750635283823611385120048769015573126811\
009614894983550738875089942913445018966436240452528399926369110579360151869044\
589699329781629233090888023147168794221020604676168313600\ x\^17)\)/
            665124522561623529895287258691855738156821780492839792522026486080\
015809404489718791007258547414160073888569409638032744798257738677709165410967\
8993962734682834601401363634303627 - 
          \((46300384752821025301142341157094330905475923945902740229580294920\
349845907699633816461800211917956430154598308401392568863952043629248348419700\
031862804919480514063770382075430718587873979171227200\ x\^18)\)/
            665124522561623529895287258691855738156821780492839792522026486080\
015809404489718791007258547414160073888569409638032744798257738677709165410967\
8993962734682834601401363634303627 + 
          \((19733730535206968540077337465618986322251565597915613463731822594\
109702694480161439642168194033550167773763438714897501880619166726295524325455\
065774100371359421546469659495234936076555426344000\ x\^19)\)/
            665124522561623529895287258691855738156821780492839792522026486080\
015809404489718791007258547414160073888569409638032744798257738677709165410967\
8993962734682834601401363634303627 - 
          \((58572901046247192471135356622963118456977840712475992944087229867\
989041894213166215881861241603713981286246630304057171686313270122115562663979\
55016070688554258375109020895684734576388855492\ x\^20)\)/
            665124522561623529895287258691855738156821780492839792522026486080\
015809404489718791007258547414160073888569409638032744798257738677709165410967\
8993962734682834601401363634303627 + 
          \((34275217691953620380872878593496471546065617338443424014562306461\
683362461081148264348975513452021331058338132957960334493987145146276996117468\
65908695045229786284347694319019135096462252\ x\^21)\)/
            199537356768487058968586177607556721447046534147851937756607945824\
004742821346915637302177564224248022166570822891409823439477321603312749623290\
36981888204048503804204090902910881 - 
          \((
              3928657250880107592125496614946194923196752743306591795055613112\
641867100901254335713539486093475185813551085354885644521519744143242071782828\
62850362486274811865687544859053172013473\ x\^22)\)/
            199537356768487058968586177607556721447046534147851937756607945824\
004742821346915637302177564224248022166570822891409823439477321603312749623290\
36981888204048503804204090902910881 + x\^23\)}],
      SequenceForm[ "dorthpoly[", 1, ",", 23, ",", x, ",", 
        DirectedInfinity[ 1], "]=", 
        Plus[ 
          Rational[
           -247799983202099517110687464732199158437208810001545745052509818498\
293886665127335690079281137433247486653162718966525998800044314516364975771353\
749306755997983264375012670487897689892175004520490114675236119720672575566643\
200000000, 
            665124522561623529895287258691855738156821780492839792522026486080\
015809404489718791007258547414160073888569409638032744798257738677709165410967\
8993962734682834601401363634303627], 
          Times[ 
            Rational[ 
            127008686258511489169288364371975994304334871709365298883102492753\
011179257715710944315631456769409093596365059147985464503276419160783950312461\
028199195291821060220220757883919172485428799986732761155694986902038304878755\
8400000000, 
              6651245225616235298952872586918557381568217804928397925220264860\
800158094044897187910072585474141600738885694096380327447982577386777091654109\
678993962734682834601401363634303627], x], 
          Times[ 
            Rational[
             -9147324447597957303377499258008005984144273065237155871718562354\
841419708665222592280997882487353847702912464540630053491663138403919607977873\
054115367720215844006966231321825468619180085860082095600401038429576005813272\
57600000000, 
              6651245225616235298952872586918557381568217804928397925220264860\
800158094044897187910072585474141600738885694096380327447982577386777091654109\
678993962734682834601401363634303627], 
            Power[ x, 2]], 
          Times[ 
            Rational[ 
            215165064057334120188676558986699682121658663239318740654667679762\
103852484280831155402842355547511392363838556369803378302395921182576100542228\
023960497571713963008087554166741449231491938146196017384921134461138081362739\
200000000, 
              6651245225616235298952872586918557381568217804928397925220264860\
800158094044897187910072585474141600738885694096380327447982577386777091654109\
678993962734682834601401363634303627], 
            Power[ x, 3]], 
          Times[ 
            Rational[
             -2267341451568619761206634513110591506518560011587272586515516161\
375904336015485602471398945137590719538345184716916615110159229440991589201661\
762049991768771004194041938731151967807698008086253128478386651248622386649497\
6000000000, 
              6651245225616235298952872586918557381568217804928397925220264860\
800158094044897187910072585474141600738885694096380327447982577386777091654109\
678993962734682834601401363634303627], 
            Power[ x, 4]], 
          Times[ 
            Rational[ 
            126558858590167340214792056704001831528616649060296033908747672743\
504757366695825593139930797427949654817651745590853364454079439528024295590213\
753990103963756858022466456338190138657674957798713278721650246276400095743180\
8000000, 665124522561623529895287258691855738156821780492839792522026486080015\
809404489718791007258547414160073888569409638032744798257738677709165410967899\
3962734682834601401363634303627], 
            Power[ x, 5]], 
          Times[ 
            Rational[
             -4150393074472712980968309474770120176905406778834222636953100947\
330459948672006320357749416564928424093163002825771596131773483476803674896226\
130768647716375362844486092993263943463537177074800582091248965180257497356697\
6000000, 665124522561623529895287258691855738156821780492839792522026486080015\
809404489718791007258547414160073888569409638032744798257738677709165410967899\
3962734682834601401363634303627], 
            Power[ x, 6]], 
          Times[ 
            Rational[ 
            857571154395736989473099387696468918460860615778372129230057371226\
373195469444371013959577844135562646426778596203750468336702414700324768070449\
622811620563964661339858299156757038058658329605844095323671681436225634304000\
000, 6651245225616235298952872586918557381568217804928397925220264860800158094\
044897187910072585474141600738885694096380327447982577386777091654109678993962\
734682834601401363634303627], 
            Power[ x, 7]], 
          Times[ 
            Rational[
             -1173477209151347641429616403051187164215088874729971524434391350\
062036807145920575888777487253315247585215391639564791527289587681502213483317\
737905583014161211954871017327528967533214380328158365755796795158225013964800\
0000, 665124522561623529895287258691855738156821780492839792522026486080015809\
404489718791007258547414160073888569409638032744798257738677709165410967899396\
2734682834601401363634303627], 
            Power[ x, 8]], 
          Times[ 
            Rational[ 
            110321458992171884151971305670534604900194210742602111502314837324\
272764210556678122852959234293451162737463543582819409550019767441925736668217\
442076557190389902827018571081907546613904149214416823088677411021127680000000\
, 6651245225616235298952872586918557381568217804928397925220264860800158094044\
897187910072585474141600738885694096380327447982577386777091654109678993962734\
682834601401363634303627], 
            Power[ x, 9]], 
          Times[ 
            Rational[
             -7325152140453447494227852281221378329141574736040050602719612620\
546893734942480919741425075569559149555856177009315170197052813435081221191320\
28538118378884051715155726597177802070063949028164585070996082522104791040000,
               665124522561623529895287258691855738156821780492839792522026486\
080015809404489718791007258547414160073888569409638032744798257738677709165410\
9678993962734682834601401363634303627], 
            Power[ x, 10]], 
          Times[ 
            Rational[ 
            350746113181176007750793617727273215937201319087681031357450265518\
549101061632144299632847667104340431223704509522832610488836718528994909629791\
3611504047486874784747930934764474083573791342569697409550672755425280000, 
              6651245225616235298952872586918557381568217804928397925220264860\
800158094044897187910072585474141600738885694096380327447982577386777091654109\
678993962734682834601401363634303627], 
            Power[ x, 11]], 
          Times[ 
            Rational[
             -1230051950992878296895071287163295383972596196082156628219345991\
805786650325507557958387109403338540825415150574680632834156098731335587406344\
4430707947512638450595400058854108896823378383381580558401363123896320000, 
              6651245225616235298952872586918557381568217804928397925220264860\
800158094044897187910072585474141600738885694096380327447982577386777091654109\
678993962734682834601401363634303627], 
            Power[ x, 12]], 
          Times[ 
            Rational[ 
            319454491994022209151663237691106899165910663572230638779469051771\
961244880559933798719877469171597355223025608862295526226088191647985240076150\
27240944108267587768866125990453030230656343056062491234195210240000, 
              6651245225616235298952872586918557381568217804928397925220264860\
800158094044897187910072585474141600738885694096380327447982577386777091654109\
678993962734682834601401363634303627], 
            Power[ x, 13]], 
          Times[ 
            Rational[
             -6187546540122872456344591158155262969200622993522111169319280439\
832406671510230472478737286838578930414549051899445784767653459071641039588640\
9966412234187006845875834067129062925802690761301513512573337600000, 
              6651245225616235298952872586918557381568217804928397925220264860\
800158094044897187910072585474141600738885694096380327447982577386777091654109\
678993962734682834601401363634303627], 
            Power[ x, 14]], 
          Times[ 
            Rational[ 
            133835310972729330664285970898793067415071829112223486437859755158\
377388535629081790221224862142946012157951620137038398577852473218708147131343\
6904317300690057075205634556194869578860900258818848692633600, 
              9927231680024231789481899383460533405325698216311041679433231135\
522624020962533116283690426080808359311769692681164667832809816995189689035984\
5955133772159445292558229307974681], 
            Power[ x, 15]], 
          Times[ 
            Rational[
             -9714401239050989807353525582599210067783592401421319026806823706\
513135995529156859785248843002683975315762888635828136721475253903892336024294\
3245283623428341821156726456226913604340080037267715242310400, 
              6651245225616235298952872586918557381568217804928397925220264860\
800158094044897187910072585474141600738885694096380327447982577386777091654109\
678993962734682834601401363634303627], 
            Power[ x, 16]], 
          Times[ 
            Rational[ 
            782362782375762048432795757506352838236113851200487690155731268110\
096148949835507388750899429134450189664362404525283999263691105793601518690445\
89699329781629233090888023147168794221020604676168313600, 
              6651245225616235298952872586918557381568217804928397925220264860\
800158094044897187910072585474141600738885694096380327447982577386777091654109\
678993962734682834601401363634303627], 
            Power[ x, 17]], 
          Times[ 
            Rational[
             -4630038475282102530114234115709433090547592394590274022958029492\
034984590769963381646180021191795643015459830840139256886395204362924834841970\
0031862804919480514063770382075430718587873979171227200, 
              6651245225616235298952872586918557381568217804928397925220264860\
800158094044897187910072585474141600738885694096380327447982577386777091654109\
678993962734682834601401363634303627], 
            Power[ x, 18]], 
          Times[ 
            Rational[ 
            197337305352069685400773374656189863222515655979156134637318225941\
097026944801614396421681940335501677737634387148975018806191667262955243254550\
65774100371359421546469659495234936076555426344000, 
              6651245225616235298952872586918557381568217804928397925220264860\
800158094044897187910072585474141600738885694096380327447982577386777091654109\
678993962734682834601401363634303627], 
            Power[ x, 19]], 
          Times[ 
            Rational[
             -5857290104624719247113535662296311845697784071247599294408722986\
798904189421316621588186124160371398128624663030405717168631327012211556266397\
955016070688554258375109020895684734576388855492, 
              6651245225616235298952872586918557381568217804928397925220264860\
800158094044897187910072585474141600738885694096380327447982577386777091654109\
678993962734682834601401363634303627], 
            Power[ x, 20]], 
          Times[ 
            Rational[ 
            342752176919536203808728785934964715460656173384434240145623064616\
833624610811482643489755134520213310583381329579603344939871451462769961174686\
5908695045229786284347694319019135096462252, 
              1995373567684870589685861776075567214470465341478519377566079458\
240047428213469156373021775642242480221665708228914098234394773216033127496232\
9036981888204048503804204090902910881], 
            Power[ x, 21]], 
          Times[ 
            Rational[
             -3928657250880107592125496614946194923196752743306591795055613112\
641867100901254335713539486093475185813551085354885644521519744143242071782828\
62850362486274811865687544859053172013473, 
              1995373567684870589685861776075567214470465341478519377566079458\
240047428213469156373021775642242480221665708228914098234394773216033127496232\
9036981888204048503804204090902910881], 
            Power[ x, 22]], 
          Power[ x, 23]]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("dorthpoly["\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "24", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "x", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", 
        InterpretationBox["\[Infinity]",
          DirectedInfinity[ 1]], "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        \(43408912484586496060846861495418622545647772816960966648451278742642\
159968023238568383814590207632018832065915020045604038013759623025533617773554\
973620460726698195454306012708126641677290844909417767123737175573979251149801\
407393395744387891200000000/
            844864728480530830496350646802948780696413876213971190483504166576\
683148166010454762223899011295437174693427161428680382417753902971810199330140\
444503971100498782163127217295286500325954000719387 - 
          \((22591410791466135003680785517337568959145734496316076881371877709\
786430359186128087516658889798617037034500350321172452977642477591299812180561\
336998477349346044245719393498036486204363841700028182695022063426611249249037\
0440791641275405382451200000000\ x)\)/
            844864728480530830496350646802948780696413876213971190483504166576\
683148166010454762223899011295437174693427161428680382417753902971810199330140\
444503971100498782163127217295286500325954000719387 + 
          \((16606001849684134169487792501356196456873739820964634669141646274\
433122929584177373195881195609923475652164413759438472924060229618107313426751\
792947685638877717927803159673216576602469949143872079508755882768127257533155\
2255839182597703231078400000000\ x\^2)\)/
            844864728480530830496350646802948780696413876213971190483504166576\
683148166010454762223899011295437174693427161428680382417753902971810199330140\
444503971100498782163127217295286500325954000719387 - 
          \((40019116750772163563925870591224954728856969981104540545698834477\
126266086437388512137840683827523375329968870518335174889520248536610771180027\
654023111016311525597024980048754591977498650411715306379092986681607479846515\
080060989298961075404800000000\ x\^3)\)/
            844864728480530830496350646802948780696413876213971190483504166576\
683148166010454762223899011295437174693427161428680382417753902971810199330140\
444503971100498782163127217295286500325954000719387 + 
          \((43358244430384718727281436672771753338430480639326259399433785390\
545726913468434325330146741904896623096121701470701581310543975890470575627758\
801272602535324109193785247522904664761929474170209831451858862088700768147657\
68448597975842894643200000000\ x\^4)\)/
            844864728480530830496350646802948780696413876213971190483504166576\
683148166010454762223899011295437174693427161428680382417753902971810199330140\
444503971100498782163127217295286500325954000719387 - 
          \((24970439205531536969118759936944356635437680544376377268567498844\
563532650179703652314354098898129353196777133434958188760327356045800778386775\
187359385197173712913603623865602267414329895391536316960353494604249360037009\
9903180783023688777728000000\ x\^5)\)/
            844864728480530830496350646802948780696413876213971190483504166576\
683148166010454762223899011295437174693427161428680382417753902971810199330140\
444503971100498782163127217295286500325954000719387 + 
          \((84794150594358424114863676323568913704093392735350573432831868781\
214848415337151246025248701264297231625786071681219620496975108063860066892427\
023061826207933358684147713267366984221052128014573420142450161344518734227852\
60181083865804177408000000\ x\^6)\)/
            844864728480530830496350646802948780696413876213971190483504166576\
683148166010454762223899011295437174693427161428680382417753902971810199330140\
444503971100498782163127217295286500325954000719387 - 
          \((18211287549616560758820147117505578802694226440872401177535427511\
473999809172795663866708615133969280645692667254646928561746394025074968740779\
697276419499841780892120743633752654696115153749521323005008196134541880807465\
6808920941567410176000000\ x\^7)\)/
            844864728480530830496350646802948780696413876213971190483504166576\
683148166010454762223899011295437174693427161428680382417753902971810199330140\
444503971100498782163127217295286500325954000719387 + 
          \((26008460615305700101632405771274941943187250181608383090821657402\
757156700683700165192305466124041661216081108242257802266692594484976924187292\
581256122694981539450089016316183723266717286033525631834689069933550849272082\
60490892025004032000000\ x\^8)\)/
            844864728480530830496350646802948780696413876213971190483504166576\
683148166010454762223899011295437174693427161428680382417753902971810199330140\
444503971100498782163127217295286500325954000719387 - 
          \((25633632735061486725881540455488740505762392009170689457009541863\
900047687142665291619144722650298391736686916600884486458386540215327342452237\
914964115592772958558645134374037593212882535100982103453918253789500313415063\
850098756681728000000\ x\^9)\)/
            844864728480530830496350646802948780696413876213971190483504166576\
683148166010454762223899011295437174693427161428680382417753902971810199330140\
444503971100498782163127217295286500325954000719387 + 
          \((17932003321959080721990516348398806075150745887792871213444267085\
091416706150216724971426901582608917176092585331354539693503609818175349607345\
594043730517286192761408186233612010151865066613816246852508299834353587140262\
5693364403568640000\ x\^10)\)/
            844864728480530830496350646802948780696413876213971190483504166576\
683148166010454762223899011295437174693427161428680382417753902971810199330140\
444503971100498782163127217295286500325954000719387 - 
          \((90967549270546303025394508964426899373240266066336486705387317447\
448541835777945681609587858582869325578223606482314484593495356664876236819216\
131688208597280377328318742061768231625495379174148424921629620988387177269156\
2029845053440000\ x\^11)\)/
            844864728480530830496350646802948780696413876213971190483504166576\
683148166010454762223899011295437174693427161428680382417753902971810199330140\
444503971100498782163127217295286500325954000719387 + 
          \((34014008329708985767876120455203428412067146867045455745036828788\
733397167911505855620274966984996297257840988285926979890921689547146153261174\
494208874393930853380608057569880562191422804959336003094596780050873024589462\
83141857280000\ x\^12)\)/
            844864728480530830496350646802948780696413876213971190483504166576\
683148166010454762223899011295437174693427161428680382417753902971810199330140\
444503971100498782163127217295286500325954000719387 - 
          \((94880868301667416093298973220259999260877172433076588251758859647\
440430798086633277761252797437056227090200729510393177820770268346033330603940\
898885299262581503645314390997436479947608624353418989006160348083127784428166\
28981760000\ x\^13)\)/
            844864728480530830496350646802948780696413876213971190483504166576\
683148166010454762223899011295437174693427161428680382417753902971810199330140\
444503971100498782163127217295286500325954000719387 + 
          \((19910575706442076099988459707902892611959291285243845822471553628\
136557770774587658542338650224334683201659212073352252197756922256761631350019\
232504584105905348473618448948939247763058538781316511793015185075646804126848\
778240000\ x\^14)\)/
            844864728480530830496350646802948780696413876213971190483504166576\
683148166010454762223899011295437174693427161428680382417753902971810199330140\
444503971100498782163127217295286500325954000719387 - 
          \((31587649651435576166822126927735486975798965590497925224805424381\
772057280863794837887667768163119176574179561422463699573696559056117511274996\
810827704337129090581322346619987308584359530448991353384133552094158408687760\
179200\ x\^15)\)/
            844864728480530830496350646802948780696413876213971190483504166576\
683148166010454762223899011295437174693427161428680382417753902971810199330140\
444503971100498782163127217295286500325954000719387 + 
          \((37942524649902012081619159003563784717613308745344726714196072593\
286172545179187046448866779709731007880295509932725611053116679974563618242879\
763827381975041300760687889711879944487466196922495097856020419466159998008115\
200\ x\^16)\)/
            844864728480530830496350646802948780696413876213971190483504166576\
683148166010454762223899011295437174693427161428680382417753902971810199330140\
444503971100498782163127217295286500325954000719387 - 
          \((34429050501667273803171403700939546742723809880127609433620608125\
812290487667451542550896569232702771868196120304062702253356690344989141219656\
882959907625776220051692173839573649835624577991405248505004494824288020070400
                \ x\^17)\)/
            844864728480530830496350646802948780696413876213971190483504166576\
683148166010454762223899011295437174693427161428680382417753902971810199330140\
444503971100498782163127217295286500325954000719387 + 
          \((23441460211290573778018789007572785187311336597177771540051227323\
781752257781989164574523398010265774360413922524048180975559181574326832740507\
200622769433994451265486125091216795596870509666889232139613061591735500800\ 
                x\^18)\)/
            844864728480530830496350646802948780696413876213971190483504166576\
683148166010454762223899011295437174693427161428680382417753902971810199330140\
444503971100498782163127217295286500325954000719387 - 
          \((11826115946085497888841173902399631371590324059401718627318432569\
374108589440511927464160657685052196025428164894913717947952159420259339910861\
446985881344560991866757134933961515158065304128012757311552764769075200\ 
                x\^19)\)/
            844864728480530830496350646802948780696413876213971190483504166576\
683148166010454762223899011295437174693427161428680382417753902971810199330140\
444503971100498782163127217295286500325954000719387 + 
          \((43291307633060940791844739678049040988325691502664344156342547797\
177585962361510672306423721668322121796155690474808235134471729796094225075206\
26252852802757820952364950034135736328135688796493572008453321756672\ x\^20)
              \)/8448647284805308304963506468029487806964138762139711904835041\
665766831481660104547622238990112954371746934271614286803824177539029718101993\
30140444503971100498782163127217295286500325954000719387 - 
          \((11111348539128906285485718472166891755482523702914528518621943293\
112286231762306625234260129577156967546608528546087700766143252239482368226888\
10553237544975849316274824444734234985462535268608951539351601152\ x\^21)\)/
            844864728480530830496350646802948780696413876213971190483504166576\
683148166010454762223899011295437174693427161428680382417753902971810199330140\
444503971100498782163127217295286500325954000719387 + 
          \((18857594079076552497193107301319710379482520568005540074067390038\
396570607514405428963765105066639345938749668082391560784430423648853328133586\
3616337686773942707832238084606378565021434510208966247312384\ x\^22)\)/
            844864728480530830496350646802948780696413876213971190483504166576\
683148166010454762223899011295437174693427161428680382417753902971810199330140\
444503971100498782163127217295286500325954000719387 - 
          \((18912784844714290543220576113714306993977300949111942768785879824\
970697920610360440175199017399654126034757191311589333967311539786898129033738\
972582285434525110174648160206384830750231103134782046208\ x\^23)\)/
            844864728480530830496350646802948780696413876213971190483504166576\
683148166010454762223899011295437174693427161428680382417753902971810199330140\
444503971100498782163127217295286500325954000719387 + x\^24\)}],
      SequenceForm[ "dorthpoly[", 1, ",", 24, ",", x, ",", 
        DirectedInfinity[ 1], "]=", 
        Plus[ 
          Rational[ 
          43408912484586496060846861495418622545647772816960966648451278742642\
159968023238568383814590207632018832065915020045604038013759623025533617773554\
973620460726698195454306012708126641677290844909417767123737175573979251149801\
407393395744387891200000000, 
            844864728480530830496350646802948780696413876213971190483504166576\
683148166010454762223899011295437174693427161428680382417753902971810199330140\
444503971100498782163127217295286500325954000719387], 
          Times[ 
            Rational[
             -2259141079146613500368078551733756895914573449631607688137187770\
978643035918612808751665888979861703703450035032117245297764247759129981218056\
133699847734934604424571939349803648620436384170002818269502206342661124924903\
70440791641275405382451200000000, 
              8448647284805308304963506468029487806964138762139711904835041665\
766831481660104547622238990112954371746934271614286803824177539029718101993301\
40444503971100498782163127217295286500325954000719387], x], 
          Times[ 
            Rational[ 
            166060018496841341694877925013561964568737398209646346691416462744\
331229295841773731958811956099234756521644137594384729240602296181073134267517\
929476856388777179278031596732165766024699491438720795087558827681272575331552\
255839182597703231078400000000, 
              8448647284805308304963506468029487806964138762139711904835041665\
766831481660104547622238990112954371746934271614286803824177539029718101993301\
40444503971100498782163127217295286500325954000719387], 
            Power[ x, 2]], 
          Times[ 
            Rational[
             -4001911675077216356392587059122495472885696998110454054569883447\
712626608643738851213784068382752337532996887051833517488952024853661077118002\
765402311101631152559702498004875459197749865041171530637909298668160747984651\
5080060989298961075404800000000, 
              8448647284805308304963506468029487806964138762139711904835041665\
766831481660104547622238990112954371746934271614286803824177539029718101993301\
40444503971100498782163127217295286500325954000719387], 
            Power[ x, 3]], 
          Times[ 
            Rational[ 
            433582444303847187272814366727717533384304806393262593994337853905\
457269134684343253301467419048966230961217014707015813105439758904705756277588\
012726025353241091937852475229046647619294741702098314518588620887007681476576\
8448597975842894643200000000, 
              8448647284805308304963506468029487806964138762139711904835041665\
766831481660104547622238990112954371746934271614286803824177539029718101993301\
40444503971100498782163127217295286500325954000719387], 
            Power[ x, 4]], 
          Times[ 
            Rational[
             -2497043920553153696911875993694435663543768054437637726856749884\
456353265017970365231435409889812935319677713343495818876032735604580077838677\
518735938519717371291360362386560226741432989539153631696035349460424936003700\
99903180783023688777728000000, 
              8448647284805308304963506468029487806964138762139711904835041665\
766831481660104547622238990112954371746934271614286803824177539029718101993301\
40444503971100498782163127217295286500325954000719387], 
            Power[ x, 5]], 
          Times[ 
            Rational[ 
            847941505943584241148636763235689137040933927353505734328318687812\
148484153371512460252487012642972316257860716812196204969751080638600668924270\
230618262079333586841477132673669842210521280145734201424501613445187342278526\
0181083865804177408000000, 
              8448647284805308304963506468029487806964138762139711904835041665\
766831481660104547622238990112954371746934271614286803824177539029718101993301\
40444503971100498782163127217295286500325954000719387], 
            Power[ x, 6]], 
          Times[ 
            Rational[
             -1821128754961656075882014711750557880269422644087240117753542751\
147399980917279566386670861513396928064569266725464692856174639402507496874077\
969727641949984178089212074363375265469611515374952132300500819613454188080746\
56808920941567410176000000, 
              8448647284805308304963506468029487806964138762139711904835041665\
766831481660104547622238990112954371746934271614286803824177539029718101993301\
40444503971100498782163127217295286500325954000719387], 
            Power[ x, 7]], 
          Times[ 
            Rational[ 
            260084606153057001016324057712749419431872501816083830908216574027\
571567006837001651923054661240416612160811082422578022666925944849769241872925\
812561226949815394500890163161837232667172860335256318346890699335508492720826\
0490892025004032000000, 
              8448647284805308304963506468029487806964138762139711904835041665\
766831481660104547622238990112954371746934271614286803824177539029718101993301\
40444503971100498782163127217295286500325954000719387], 
            Power[ x, 8]], 
          Times[ 
            Rational[
             -2563363273506148672588154045548874050576239200917068945700954186\
390004768714266529161914472265029839173668691660088448645838654021532734245223\
791496411559277295855864513437403759321288253510098210345391825378950031341506\
3850098756681728000000, 
              8448647284805308304963506468029487806964138762139711904835041665\
766831481660104547622238990112954371746934271614286803824177539029718101993301\
40444503971100498782163127217295286500325954000719387], 
            Power[ x, 9]], 
          Times[ 
            Rational[ 
            179320033219590807219905163483988060751507458877928712134442670850\
914167061502167249714269015826089171760925853313545396935036098181753496073455\
940437305172861927614081862336120101518650666138162468525082998343535871402625\
693364403568640000, 
              8448647284805308304963506468029487806964138762139711904835041665\
766831481660104547622238990112954371746934271614286803824177539029718101993301\
40444503971100498782163127217295286500325954000719387], 
            Power[ x, 10]], 
          Times[ 
            Rational[
             -9096754927054630302539450896442689937324026606633648670538731744\
744854183577794568160958785858286932557822360648231448459349535666487623681921\
613168820859728037732831874206176823162549537917414842492162962098838717726915\
62029845053440000, 
              8448647284805308304963506468029487806964138762139711904835041665\
766831481660104547622238990112954371746934271614286803824177539029718101993301\
40444503971100498782163127217295286500325954000719387], 
            Power[ x, 11]], 
          Times[ 
            Rational[ 
            340140083297089857678761204552034284120671468670454557450368287887\
333971679115058556202749669849962972578409882859269798909216895471461532611744\
942088743939308533806080575698805621914228049593360030945967800508730245894628\
3141857280000, 
              8448647284805308304963506468029487806964138762139711904835041665\
766831481660104547622238990112954371746934271614286803824177539029718101993301\
40444503971100498782163127217295286500325954000719387], 
            Power[ x, 12]], 
          Times[ 
            Rational[
             -9488086830166741609329897322025999926087717243307658825175885964\
744043079808663327776125279743705622709020072951039317782077026834603333060394\
089888529926258150364531439099743647994760862435341898900616034808312778442816\
628981760000, 
              8448647284805308304963506468029487806964138762139711904835041665\
766831481660104547622238990112954371746934271614286803824177539029718101993301\
40444503971100498782163127217295286500325954000719387], 
            Power[ x, 13]], 
          Times[ 
            Rational[ 
            199105757064420760999884597079028926119592912852438458224715536281\
365577707745876585423386502243346832016592120733522521977569222567616313500192\
325045841059053484736184489489392477630585387813165117930151850756468041268487\
78240000, 
              8448647284805308304963506468029487806964138762139711904835041665\
766831481660104547622238990112954371746934271614286803824177539029718101993301\
40444503971100498782163127217295286500325954000719387], 
            Power[ x, 14]], 
          Times[ 
            Rational[
             -3158764965143557616682212692773548697579896559049792522480542438\
177205728086379483788766776816311917657417956142246369957369655905611751127499\
681082770433712909058132234661998730858435953044899135338413355209415840868776\
0179200, 844864728480530830496350646802948780696413876213971190483504166576683\
148166010454762223899011295437174693427161428680382417753902971810199330140444\
503971100498782163127217295286500325954000719387], 
            Power[ x, 15]], 
          Times[ 
            Rational[ 
            379425246499020120816191590035637847176133087453447267141960725932\
861725451791870464488667797097310078802955099327256110531166799745636182428797\
638273819750413007606878897118799444874661969224950978560204194661599980081152\
00, 84486472848053083049635064680294878069641387621397119048350416657668314816\
601045476222389901129543717469342716142868038241775390297181019933014044450397\
1100498782163127217295286500325954000719387], 
            Power[ x, 16]], 
          Times[ 
            Rational[
             -3442905050166727380317140370093954674272380988012760943362060812\
581229048766745154255089656923270277186819612030406270225335669034498914121965\
688295990762577622005169217383957364983562457799140524850500449482428802007040\
0, 844864728480530830496350646802948780696413876213971190483504166576683148166\
010454762223899011295437174693427161428680382417753902971810199330140444503971\
100498782163127217295286500325954000719387], 
            Power[ x, 17]], 
          Times[ 
            Rational[ 
            234414602112905737780187890075727851873113365971777715400512273237\
817522577819891645745233980102657743604139225240481809755591815743268327405072\
00622769433994451265486125091216795596870509666889232139613061591735500800, 
              8448647284805308304963506468029487806964138762139711904835041665\
766831481660104547622238990112954371746934271614286803824177539029718101993301\
40444503971100498782163127217295286500325954000719387], 
            Power[ x, 18]], 
          Times[ 
            Rational[
             -1182611594608549788884117390239963137159032405940171862731843256\
937410858944051192746416065768505219602542816489491371794795215942025933991086\
1446985881344560991866757134933961515158065304128012757311552764769075200, 
              8448647284805308304963506468029487806964138762139711904835041665\
766831481660104547622238990112954371746934271614286803824177539029718101993301\
40444503971100498782163127217295286500325954000719387], 
            Power[ x, 19]], 
          Times[ 
            Rational[ 
            432913076330609407918447396780490409883256915026643441563425477971\
775859623615106723064237216683221217961556904748082351344717297960942250752062\
6252852802757820952364950034135736328135688796493572008453321756672, 
              8448647284805308304963506468029487806964138762139711904835041665\
766831481660104547622238990112954371746934271614286803824177539029718101993301\
40444503971100498782163127217295286500325954000719387], 
            Power[ x, 20]], 
          Times[ 
            Rational[
             -1111134853912890628548571847216689175548252370291452851862194329\
311228623176230662523426012957715696754660852854608770076614325223948236822688\
810553237544975849316274824444734234985462535268608951539351601152, 
              8448647284805308304963506468029487806964138762139711904835041665\
766831481660104547622238990112954371746934271614286803824177539029718101993301\
40444503971100498782163127217295286500325954000719387], 
            Power[ x, 21]], 
          Times[ 
            Rational[ 
            188575940790765524971931073013197103794825205680055400740673900383\
965706075144054289637651050666393459387496680823915607844304236488533281335863\
616337686773942707832238084606378565021434510208966247312384, 
              8448647284805308304963506468029487806964138762139711904835041665\
766831481660104547622238990112954371746934271614286803824177539029718101993301\
40444503971100498782163127217295286500325954000719387], 
            Power[ x, 22]], 
          Times[ 
            Rational[
             -1891278484471429054322057611371430699397730094911194276878587982\
497069792061036044017519901739965412603475719131158933396731153978689812903373\
8972582285434525110174648160206384830750231103134782046208, 
              8448647284805308304963506468029487806964138762139711904835041665\
766831481660104547622238990112954371746934271614286803824177539029718101993301\
40444503971100498782163127217295286500325954000719387], 
            Power[ x, 23]], 
          Power[ x, 24]]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("dorthpoly["\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "25", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "x", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", 
        InterpretationBox["\[Infinity]",
          DirectedInfinity[ 1]], "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        \(\( - 132968872037745840144249702775735927707822453799900884967339411\
179765297830818950226551881940188324014497545254056054993015577603719143133702\
793893656955589883743651489773813837798731751510141751499427127126184558969310\
0308899023046933782774729459129999912075264000000000000/
              1727360823636748141365790156856888904050236232436827653922565020\
460012802483250453319951187513343102488752737573460454611546769178299207043106\
4684641028907458178147981726880184479317010430437929847740424822024870169\) + 
          \((70214140305060757973992730274932100955111951892644521473137578147\
532028118939522483209654422410472711515381651585386737396945343324260585609047\
274829787023550886221781024244598131185151280740853853491562603197354099144419\
06963474744898190711834643358093724876800000000000000\ x)\)/
            172736082363674814136579015685688890405023623243682765392256502046\
001280248325045331995118751334310248875273757346045461154676917829920704310646\
84641028907458178147981726880184479317010430437929847740424822024870169 - 
          \((52619661604494141599562594776155138293849476968676906817184716310\
397530778666317854152214235876013297118782657238257306502797054577785249664431\
827878294083369579718542882942826467924453722305710680576501478867693782414040\
93371907554433744067456368883152191488000000000000000\ x\^2)\)/
            172736082363674814136579015685688890405023623243682765392256502046\
001280248325045331995118751334310248875273757346045461154676917829920704310646\
84641028907458178147981726880184479317010430437929847740424822024870169 + 
          \((
              1297484148999184736589338642081047678092998198602961248315735866\
585900036786071034560990363514474381882018892296329707222090930890869731248820\
011070368774397159345116369313917158641276703992337958188920629271884093617805\
810764477653749419483089816176024983961600000000000000\ x\^3)\)/
            172736082363674814136579015685688890405023623243682765392256502046\
001280248325045331995118751334310248875273757346045461154676917829920704310646\
84641028907458178147981726880184479317010430437929847740424822024870169 - 
          \((14430391437193151851168267110093327705210380723448210795451867145\
818769042923011997383770422551672499260260298651026613367157020384607321822640\
495006139587678093373005909724249065746551885682197596328748503891420361742908\
1973370093920261696482623498316310118400000000000000\ x\^4)\)/
            172736082363674814136579015685688890405023623243682765392256502046\
001280248325045331995118751334310248875273757346045461154676917829920704310646\
84641028907458178147981726880184479317010430437929847740424822024870169 + 
          \((85585982768792550280980532103623712717861990875061423463147069654\
588613327753883071283442906869307185746323441019280341903289540338855130440718\
130202588481779570913468623616019148432744948685703843106074808549635290119088\
13531746398118465105051708618134939238400000000000\ x\^5)\)/
            172736082363674814136579015685688890405023623243682765392256502046\
001280248325045331995118751334310248875273757346045461154676917829920704310646\
84641028907458178147981726880184479317010430437929847740424822024870169 - 
          \((30029087710509857564349212952341126644945692700877326329133754505\
708399785670705944436765912311408331357603953725266489501458292495893197831763\
431635408292076571621265232329329707105518544698491882104157364455785101329455\
6662968633652124819099095772549873664000000000000\ x\^6)\)/
            172736082363674814136579015685688890405023623243682765392256502046\
001280248325045331995118751334310248875273757346045461154676917829920704310646\
84641028907458178147981726880184479317010430437929847740424822024870169 + 
          \((66867552533899392141657942481361584106937019487080347095010116142\
222019390356169350355999313391414227376299391560130490450316158148931614852775\
526788733199763665325887184512111115746166363535460292338390971573108579454123\
65153595319722597470866291566837760000000000000\ x\^7)\)/
            172736082363674814136579015685688890405023623243682765392256502046\
001280248325045331995118751334310248875273757346045461154676917829920704310646\
84641028907458178147981726880184479317010430437929847740424822024870169 - 
          \((99377575816476795634848726732020093621552331498450107462431184954\
264637770855693036533220781638278338157811136077548845994059948678542319185888\
808960345098448609383806462677441698730581943214204064096121373591355695163855\
092459058885310231104149034631168000000000000\ x\^8)\)/
            172736082363674814136579015685688890405023623243682765392256502046\
001280248325045331995118751334310248875273757346045461154676917829920704310646\
84641028907458178147981726880184479317010430437929847740424822024870169 + 
          \((10233359049706478771429678824513455098371595327826600584852871747\
728794576609818995143199112840398259807802248465952152862795095985125426533928\
282775066558659475193415174902072797379607563434538544103972058071297668389660\
89505907596608068523642879475712000000000000\ x\^9)\)/
            172736082363674814136579015685688890405023623243682765392256502046\
001280248325045331995118751334310248875273757346045461154676917829920704310646\
84641028907458178147981726880184479317010430437929847740424822024870169 - 
          \((75123970051904033376646087257297803974817685192178689926235190603\
198829748855956301062966135761667191683308198531795640966285275646205088654930\
123066565597262152960427082776649001302069113452748701431219762846753529406324\
27361270758513083158563934699520000000000\ x\^10)\)/
            172736082363674814136579015685688890405023623243682765392256502046\
001280248325045331995118751334310248875273757346045461154676917829920704310646\
84641028907458178147981726880184479317010430437929847740424822024870169 + 
          \((40188480163174893611680169015638090479611398967043164820921089437\
965214446223683903518858486708902824005013053473139523719997591838950501753286\
860127334069431233353841001895249210869859005585697439809293303402659396069648\
385454257262198788944455270400000000000\ x\^11)\)/
            172736082363674814136579015685688890405023623243682765392256502046\
001280248325045331995118751334310248875273757346045461154676917829920704310646\
84641028907458178147981726880184479317010430437929847740424822024870169 - 
          \((15934320845033293564804576775768474696098260093486751808499978084\
106378520996908998865644275611599561552612166211274671155020218300686737802260\
421019554317543639477560413251489649912273949079499840160147091716746822007229\
2119364955287574682042368000000000000\ x\^12)\)/
            172736082363674814136579015685688890405023623243682765392256502046\
001280248325045331995118751334310248875273757346045461154676917829920704310646\
84641028907458178147981726880184479317010430437929847740424822024870169 + 
          \((47430011770071812260576937999801396359268244896118051352479009947\
537736987906906942604481754589791649411756466843760557411131824763937420915670\
306910462189178047586330737935602534600242203002411685062272203520439399498035\
7607992765667592195276800000000000\ x\^13)\)/
            172736082363674814136579015685688890405023623243682765392256502046\
001280248325045331995118751334310248875273757346045461154676917829920704310646\
84641028907458178147981726880184479317010430437929847740424822024870169 - 
          \((10698753755672553322242366877601895609617120969418917759306156464\
687211349426603375836055037989641584528402702496999502972653191446865558910824\
502436505305004741038699429098960600519024762943393317949479476662803112797491\
23001355426325312307200000000000\ x\^14)\)/
            172736082363674814136579015685688890405023623243682765392256502046\
001280248325045331995118751334310248875273757346045461154676917829920704310646\
84641028907458178147981726880184479317010430437929847740424822024870169 + 
          \((18402858767357037769040569426920494237458234236399865487309289568\
981323734868083046209689185722994791238120143593932552330829056350514235661959\
078212604198235113388027156761385464226853071968192875386404897455480345585826\
20462232646088319303680000000\ x\^15)\)/
            172736082363674814136579015685688890405023623243682765392256502046\
001280248325045331995118751334310248875273757346045461154676917829920704310646\
84641028907458178147981726880184479317010430437929847740424822024870169 - 
          \((24216349650875876268908388482177340822809304437143033115340771827\
146577263304887220445300607632986081723848778101644539747336116733111846658257\
116536974408506979154136400182970408317645802300479685535552517794422146193381\
13066302823104966400000000\ x\^16)\)/
            172736082363674814136579015685688890405023623243682765392256502046\
001280248325045331995118751334310248875273757346045461154676917829920704310646\
84641028907458178147981726880184479317010430437929847740424822024870169 + 
          \((24380376701731698181022717493093857082954319413484644993714162208\
387343644462734489969136786642407298742736545878516393823481718071685730421302\
485120697760544207739910707400189799957196017916191866159735257006827503162349\
10215440693600000000000\ x\^17)\)/
            172736082363674814136579015685688890405023623243682765392256502046\
001280248325045331995118751334310248875273757346045461154676917829920704310646\
84641028907458178147981726880184479317010430437929847740424822024870169 - 
          \((18714961278910819366929506857026828439610935857172536076569856288\
156778889611046952390804164204547839204285006584114583791619061197143317997431\
109072183870093671099682087732833932569120931387351808579304567246583363553376\
17709643916800000000\ x\^18)\)/
            172736082363674814136579015685688890405023623243682765392256502046\
001280248325045331995118751334310248875273757346045461154676917829920704310646\
84641028907458178147981726880184479317010430437929847740424822024870169 + 
          \((10869274896824153573329972261120490650979144996956243222634605004\
543778153336047539918410239908725535793836947274197971583464359469400873206887\
529149818564934856891083163864561201435732220872660227627967505647998005618620\
93934067200000000\ x\^19)\)/
            172736082363674814136579015685688890405023623243682765392256502046\
001280248325045331995118751334310248875273757346045461154676917829920704310646\
84641028907458178147981726880184479317010430437929847740424822024870169 - 
          \((47125137234711000854675671054192688895419644441586185867735760111\
987518284105843594909272138419798395303620861507853006921868549872544558807072\
126274115533823142237966965626719858448680545325614077804175932389631847950776\
8009868800000\ x\^20)\)/
            172736082363674814136579015685688890405023623243682765392256502046\
001280248325045331995118751334310248875273757346045461154676917829920704310646\
84641028907458178147981726880184479317010430437929847740424822024870169 + 
          \((14925907625237186757174995854812757309053382697778468574240532608\
616843207764681172565725391663352380262341051700537466875884434667357453866008\
994629877621146171715986356344012245641144091787956069091856265898841878397356\
0512000000\ x\^21)\)/
            172736082363674814136579015685688890405023623243682765392256502046\
001280248325045331995118751334310248875273757346045461154676917829920704310646\
84641028907458178147981726880184479317010430437929847740424822024870169 - 
          \((33350797913592910144748859727816063897302857151381355229234389156\
159443181407615610311283050999746989137515468565337021065520252524176042625175\
826624375748338829681460656638208967649346755797402842696164443304774713374160\
000000\ x\^22)\)/
            172736082363674814136579015685688890405023623243682765392256502046\
001280248325045331995118751334310248875273757346045461154676917829920704310646\
84641028907458178147981726880184479317010430437929847740424822024870169 + 
          \((49552420468522262063716504982153307715386579994810597670167752195\
172901056219496250035626221732332442164508110209764402016530721311091238471017\
132741166227712876015223116547825758510108452948673921206656034335432529440000\
00\ x\^23)\)/
            172736082363674814136579015685688890405023623243682765392256502046\
001280248325045331995118751334310248875273757346045461154676917829920704310646\
84641028907458178147981726880184479317010430437929847740424822024870169 - 
          \((43733256082560330507453436284364490935181600474182367878193446630\
236225797754537768128277432647696379102901951422302140591213564188926640425148\
7724148924247369687213559310614249209247711671375710450987462450588825765625\ 
                x\^24)\)/
            172736082363674814136579015685688890405023623243682765392256502046\
001280248325045331995118751334310248875273757346045461154676917829920704310646\
84641028907458178147981726880184479317010430437929847740424822024870169 + 
          x\^25\)}],
      SequenceForm[ "dorthpoly[", 1, ",", 25, ",", x, ",", 
        DirectedInfinity[ 1], "]=", 
        Plus[ 
          Rational[
           -132968872037745840144249702775735927707822453799900884967339411179\
765297830818950226551881940188324014497545254056054993015577603719143133702793\
893656955589883743651489773813837798731751510141751499427127126184558969310030\
8899023046933782774729459129999912075264000000000000, 
            172736082363674814136579015685688890405023623243682765392256502046\
001280248325045331995118751334310248875273757346045461154676917829920704310646\
84641028907458178147981726880184479317010430437929847740424822024870169], 
          Times[ 
            Rational[ 
            702141403050607579739927302749321009551119518926445214731375781475\
320281189395224832096544224104727115153816515853867373969453433242605856090472\
748297870235508862217810242445981311851512807408538534915626031973540991444190\
6963474744898190711834643358093724876800000000000000, 
              1727360823636748141365790156856888904050236232436827653922565020\
460012802483250453319951187513343102488752737573460454611546769178299207043106\
4684641028907458178147981726880184479317010430437929847740424822024870169], 
            x], 
          Times[ 
            Rational[
             -5261966160449414159956259477615513829384947696867690681718471631\
039753077866631785415221423587601329711878265723825730650279705457778524966443\
182787829408336957971854288294282646792445372230571068057650147886769378241404\
093371907554433744067456368883152191488000000000000000, 
              1727360823636748141365790156856888904050236232436827653922565020\
460012802483250453319951187513343102488752737573460454611546769178299207043106\
4684641028907458178147981726880184479317010430437929847740424822024870169], 
            Power[ x, 2]], 
          Times[ 
            Rational[ 
            129748414899918473658933864208104767809299819860296124831573586658\
590003678607103456099036351447438188201889229632970722209093089086973124882001\
107036877439715934511636931391715864127670399233795818892062927188409361780581\
0764477653749419483089816176024983961600000000000000, 
              1727360823636748141365790156856888904050236232436827653922565020\
460012802483250453319951187513343102488752737573460454611546769178299207043106\
4684641028907458178147981726880184479317010430437929847740424822024870169], 
            Power[ x, 3]], 
          Times[ 
            Rational[
             -1443039143719315185116826711009332770521038072344821079545186714\
581876904292301199738377042255167249926026029865102661336715702038460732182264\
049500613958767809337300590972424906574655188568219759632874850389142036174290\
81973370093920261696482623498316310118400000000000000, 
              1727360823636748141365790156856888904050236232436827653922565020\
460012802483250453319951187513343102488752737573460454611546769178299207043106\
4684641028907458178147981726880184479317010430437929847740424822024870169], 
            Power[ x, 4]], 
          Times[ 
            Rational[ 
            855859827687925502809805321036237127178619908750614234631470696545\
886133277538830712834429068693071857463234410192803419032895403388551304407181\
302025884817795709134686236160191484327449486857038431060748085496352901190881\
3531746398118465105051708618134939238400000000000, 
              1727360823636748141365790156856888904050236232436827653922565020\
460012802483250453319951187513343102488752737573460454611546769178299207043106\
4684641028907458178147981726880184479317010430437929847740424822024870169], 
            Power[ x, 5]], 
          Times[ 
            Rational[
             -3002908771050985756434921295234112664494569270087732632913375450\
570839978567070594443676591231140833135760395372526648950145829249589319783176\
343163540829207657162126523232932970710551854469849188210415736445578510132945\
56662968633652124819099095772549873664000000000000, 
              1727360823636748141365790156856888904050236232436827653922565020\
460012802483250453319951187513343102488752737573460454611546769178299207043106\
4684641028907458178147981726880184479317010430437929847740424822024870169], 
            Power[ x, 6]], 
          Times[ 
            Rational[ 
            668675525338993921416579424813615841069370194870803470950101161422\
220193903561693503559993133914142273762993915601304904503161581489316148527755\
267887331997636653258871845121111157461663635354602923383909715731085794541236\
5153595319722597470866291566837760000000000000, 
              1727360823636748141365790156856888904050236232436827653922565020\
460012802483250453319951187513343102488752737573460454611546769178299207043106\
4684641028907458178147981726880184479317010430437929847740424822024870169], 
            Power[ x, 7]], 
          Times[ 
            Rational[
             -9937757581647679563484872673202009362155233149845010746243118495\
426463777085569303653322078163827833815781113607754884599405994867854231918588\
880896034509844860938380646267744169873058194321420406409612137359135569516385\
5092459058885310231104149034631168000000000000, 
              1727360823636748141365790156856888904050236232436827653922565020\
460012802483250453319951187513343102488752737573460454611546769178299207043106\
4684641028907458178147981726880184479317010430437929847740424822024870169], 
            Power[ x, 8]], 
          Times[ 
            Rational[ 
            102333590497064787714296788245134550983715953278266005848528717477\
287945766098189951431991128403982598078022484659521528627950959851254265339282\
827750665586594751934151749020727973796075634345385441039720580712976683896608\
9505907596608068523642879475712000000000000, 
              1727360823636748141365790156856888904050236232436827653922565020\
460012802483250453319951187513343102488752737573460454611546769178299207043106\
4684641028907458178147981726880184479317010430437929847740424822024870169], 
            Power[ x, 9]], 
          Times[ 
            Rational[
             -7512397005190403337664608725729780397481768519217868992623519060\
319882974885595630106296613576166719168330819853179564096628527564620508865493\
012306656559726215296042708277664900130206911345274870143121976284675352940632\
427361270758513083158563934699520000000000, 
              1727360823636748141365790156856888904050236232436827653922565020\
460012802483250453319951187513343102488752737573460454611546769178299207043106\
4684641028907458178147981726880184479317010430437929847740424822024870169], 
            Power[ x, 10]], 
          Times[ 
            Rational[ 
            401884801631748936116801690156380904796113989670431648209210894379\
652144462236839035188584867089028240050130534731395237199975918389505017532868\
601273340694312333538410018952492108698590055856974398092933034026593960696483\
85454257262198788944455270400000000000, 
              1727360823636748141365790156856888904050236232436827653922565020\
460012802483250453319951187513343102488752737573460454611546769178299207043106\
4684641028907458178147981726880184479317010430437929847740424822024870169], 
            Power[ x, 11]], 
          Times[ 
            Rational[
             -1593432084503329356480457677576847469609826009348675180849997808\
410637852099690899886564427561159956155261216621127467115502021830068673780226\
042101955431754363947756041325148964991227394907949984016014709171674682200722\
92119364955287574682042368000000000000, 
              1727360823636748141365790156856888904050236232436827653922565020\
460012802483250453319951187513343102488752737573460454611546769178299207043106\
4684641028907458178147981726880184479317010430437929847740424822024870169], 
            Power[ x, 12]], 
          Times[ 
            Rational[ 
            474300117700718122605769379998013963592682448961180513524790099475\
377369879069069426044817545897916494117564668437605574111318247639374209156703\
069104621891780475863307379356025346002422030024116850622722035204393994980357\
607992765667592195276800000000000, 
              1727360823636748141365790156856888904050236232436827653922565020\
460012802483250453319951187513343102488752737573460454611546769178299207043106\
4684641028907458178147981726880184479317010430437929847740424822024870169], 
            Power[ x, 13]], 
          Times[ 
            Rational[
             -1069875375567255332224236687760189560961712096941891775930615646\
468721134942660337583605503798964158452840270249699950297265319144686555891082\
450243650530500474103869942909896060051902476294339331794947947666280311279749\
123001355426325312307200000000000, 
              1727360823636748141365790156856888904050236232436827653922565020\
460012802483250453319951187513343102488752737573460454611546769178299207043106\
4684641028907458178147981726880184479317010430437929847740424822024870169], 
            Power[ x, 14]], 
          Times[ 
            Rational[ 
            184028587673570377690405694269204942374582342363998654873092895689\
813237348680830462096891857229947912381201435939325523308290563505142356619590\
782126041982351133880271567613854642268530719681928753864048974554803455858262\
0462232646088319303680000000, 
              1727360823636748141365790156856888904050236232436827653922565020\
460012802483250453319951187513343102488752737573460454611546769178299207043106\
4684641028907458178147981726880184479317010430437929847740424822024870169], 
            Power[ x, 15]], 
          Times[ 
            Rational[
             -2421634965087587626890838848217734082280930443714303311534077182\
714657726330488722044530060763298608172384877810164453974733611673311184665825\
711653697440850697915413640018297040831764580230047968553555251779442214619338\
113066302823104966400000000, 
              1727360823636748141365790156856888904050236232436827653922565020\
460012802483250453319951187513343102488752737573460454611546769178299207043106\
4684641028907458178147981726880184479317010430437929847740424822024870169], 
            Power[ x, 16]], 
          Times[ 
            Rational[ 
            243803767017316981810227174930938570829543194134846449937141622083\
873436444627344899691367866424072987427365458785163938234817180716857304213024\
851206977605442077399107074001897999571960179161918661597352570068275031623491\
0215440693600000000000, 
              1727360823636748141365790156856888904050236232436827653922565020\
460012802483250453319951187513343102488752737573460454611546769178299207043106\
4684641028907458178147981726880184479317010430437929847740424822024870169], 
            Power[ x, 17]], 
          Times[ 
            Rational[
             -1871496127891081936692950685702682843961093585717253607656985628\
815677888961104695239080416420454783920428500658411458379161906119714331799743\
110907218387009367109968208773283393256912093138735180857930456724658336355337\
617709643916800000000, 
              1727360823636748141365790156856888904050236232436827653922565020\
460012802483250453319951187513343102488752737573460454611546769178299207043106\
4684641028907458178147981726880184479317010430437929847740424822024870169], 
            Power[ x, 18]], 
          Times[ 
            Rational[ 
            108692748968241535733299722611204906509791449969562432226346050045\
437781533360475399184102399087255357938369472741979715834643594694008732068875\
291498185649348568910831638645612014357322208726602276279675056479980056186209\
3934067200000000, 
              1727360823636748141365790156856888904050236232436827653922565020\
460012802483250453319951187513343102488752737573460454611546769178299207043106\
4684641028907458178147981726880184479317010430437929847740424822024870169], 
            Power[ x, 19]], 
          Times[ 
            Rational[
             -4712513723471100085467567105419268889541964444158618586773576011\
198751828410584359490927213841979839530362086150785300692186854987254455880707\
212627411553382314223796696562671985844868054532561407780417593238963184795077\
68009868800000, 
              1727360823636748141365790156856888904050236232436827653922565020\
460012802483250453319951187513343102488752737573460454611546769178299207043106\
4684641028907458178147981726880184479317010430437929847740424822024870169], 
            Power[ x, 20]], 
          Times[ 
            Rational[ 
            149259076252371867571749958548127573090533826977784685742405326086\
168432077646811725657253916633523802623410517005374668758844346673574538660089\
946298776211461717159863563440122456411440917879560690918562658988418783973560\
512000000, 
              1727360823636748141365790156856888904050236232436827653922565020\
460012802483250453319951187513343102488752737573460454611546769178299207043106\
4684641028907458178147981726880184479317010430437929847740424822024870169], 
            Power[ x, 21]], 
          Times[ 
            Rational[
             -3335079791359291014474885972781606389730285715138135522923438915\
615944318140761561031128305099974698913751546856533702106552025252417604262517\
582662437574833882968146065663820896764934675579740284269616444330477471337416\
0000000, 172736082363674814136579015685688890405023623243682765392256502046001\
280248325045331995118751334310248875273757346045461154676917829920704310646846\
41028907458178147981726880184479317010430437929847740424822024870169], 
            Power[ x, 22]], 
          Times[ 
            Rational[ 
            495524204685222620637165049821533077153865799948105976701677521951\
729010562194962500356262217323324421645081102097644020165307213110912384710171\
327411662277128760152231165478257585101084529486739212066560343354325294400000\
0, 172736082363674814136579015685688890405023623243682765392256502046001280248\
325045331995118751334310248875273757346045461154676917829920704310646846410289\
07458178147981726880184479317010430437929847740424822024870169], 
            Power[ x, 23]], 
          Times[ 
            Rational[
             -4373325608256033050745343628436449093518160047418236787819344663\
023622579775453776812827743264769637910290195142230214059121356418892664042514\
87724148924247369687213559310614249209247711671375710450987462450588825765625,
               172736082363674814136579015685688890405023623243682765392256502\
046001280248325045331995118751334310248875273757346045461154676917829920704310\
64684641028907458178147981726880184479317010430437929847740424822024870169], 
            Power[ x, 24]], 
          Power[ x, 25]]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("dorthpoly["\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "26", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "x", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", 
        InterpretationBox["\[Infinity]",
          DirectedInfinity[ 1]], "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        \(29237869116768325792864634809680035089186016290042959790853150615581\
516157107232075028289512034559032647034919875865721731418103857187365798210963\
724650848124980011252181520623837522368792188762718941554756063364536308656286\
735859085328719717447185150777934385771535739666408067301376000000000000/
            234127911551592855835970180827295301195666187919677978700409376536\
328284483495599691160226953135136884470071814234190576373748698941080509733547\
548848468317843288911876248642689821731158777021357753730890056026430509066698\
951112345921 - 
          \((15654393549989603629299615255925178517279053328062294851883465049\
198119039624842095656608001266747558957475328559403627819829505376515603004924\
072668059227320512024770028787959119389863302603496572990981004074837289806091\
2927215400052434549418871542219567281286789381289713971522174976000000000000\ 
                x)\)/234127911551592855835970180827295301195666187919677978700\
409376536328284483495599691160226953135136884470071814234190576373748698941080\
509733547548848468317843288911876248642689821731158777021357753730890056026430\
509066698951112345921 + 
          \((11949340812586729975618931007848723289036023584213227105961758490\
170140934026597623396013689571676175599176715596642218511595398533141420357764\
858199498556530493932249658159117394878537774314077990465062150581677632214988\
3687984142847343175613988607793874158767098609378333256004403200000000000000\ 
                x\^2)\)/
            234127911551592855835970180827295301195666187919677978700409376536\
328284483495599691160226953135136884470071814234190576373748698941080509733547\
548848468317843288911876248642689821731158777021357753730890056026430509066698\
951112345921 - 
          \((30111385067387689442704162266226193305130577539477794087695053568\
917319768058820312816227517200748650169180873700194331019678338465356119556276\
132136656823517127640330457662567815152041015292737474947528735097065986513029\
976601720010600892765069763879519837366678579151469015361126400000000000000\ 
                x\^3)\)/
            234127911551592855835970180827295301195666187919677978700409376536\
328284483495599691160226953135136884470071814234190576373748698941080509733547\
548848468317843288911876248642689821731158777021357753730890056026430509066698\
951112345921 + 
          \((34328845795088815045005757330926475252949523796549236751831130080\
523707898187660108289717013712032674384542564854335363635523683116174780129750\
734059099836654469791226449210288285285329910497380931984457371351938988849437\
82507638887454668883571637295931986562108995623211918950400000000000000000\ 
                x\^4)\)/
            234127911551592855835970180827295301195666187919677978700409376536\
328284483495599691160226953135136884470071814234190576373748698941080509733547\
548848468317843288911876248642689821731158777021357753730890056026430509066698\
951112345921 - 
          \((20932824581531360599196435737565747029458070773929161224093617368\
917392973343569772802408799027632366635035507317135677545419618816531797245894\
588834272948581325129080661314338058230324695860457303102957823392816009394124\
4663183406927296355748360403046984190827024408604397981505945600000000000\ 
                x\^5)\)/
            234127911551592855835970180827295301195666187919677978700409376536\
328284483495599691160226953135136884470071814234190576373748698941080509733547\
548848468317843288911876248642689821731158777021357753730890056026430509066698\
951112345921 + 
          \((75739868794688583012586607309216670552943124654316151834295894749\
907057595620096744931357105744054311701468719481251217078678404524590227786106\
520522255458394018764776196298181086583838275315730007254480635462616060817489\
19659124653994913848331337244284475573529659149041838692761600000000000\ x\^6)
              \)/2341279115515928558359701808272953011956661879196779787004093\
765363282844834955996911602269531351368844700718142341905763737486989410805097\
335475488484683178432889118762486426898217311587770213577537308900560264305090\
66698951112345921 - 
          \((17447093482904962045336079762311747096829786512080869231256422686\
916610836618614005725537488302875608603500013553019513809058459287790989769071\
777752938035281439300093602879139425825626834131456524182616797451465797465058\
4151299176757207759405344121945349736451448863754672930816000000000000\ x\^7)
              \)/2341279115515928558359701808272953011956661879196779787004093\
765363282844834955996911602269531351368844700718142341905763737486989410805097\
335475488484683178432889118762486426898217311587770213577537308900560264305090\
66698951112345921 + 
          \((26913648963128361517036702408290858208081276696163382479356975924\
529619169905782199465698324165660776183050778166663856914390410561508978992305\
971708387448699600618376567010324583452303822467981173118864503573722577711051\
04439220132747462229411998066575131638974071266635415552000000000000\ x\^8)\)/
            234127911551592855835970180827295301195666187919677978700409376536\
328284483495599691160226953135136884470071814234190576373748698941080509733547\
548848468317843288911876248642689821731158777021357753730890056026430509066698\
951112345921 - 
          \((28869637758397373612836114081993130704773569134806155402468247342\
103511484967884915977720545579458991934841440629165398088753655840548170375370\
671249946482448135089637934289856378109920410628375881849963370455899864477136\
500094125518175840507212801466804780039552281104875520000000000000\ x\^9)\)/
            234127911551592855835970180827295301195666187919677978700409376536\
328284483495599691160226953135136884470071814234190576373748698941080509733547\
548848468317843288911876248642689821731158777021357753730890056026430509066698\
951112345921 + 
          \((22163815988999944476453672484949173386244138596983217167248883989\
733348773249320197218846028795468938541481508639466192386078059160956255865412\
510537605798441033233901687437323238829752714785980950800007630839229069339930\
4795636660861140699348985151234775764826161634795847680000000000\ x\^10)\)/
            234127911551592855835970180827295301195666187919677978700409376536\
328284483495599691160226953135136884470071814234190576373748698941080509733547\
548848468317843288911876248642689821731158777021357753730890056026430509066698\
951112345921 - 
          \((12453497503135606228355826168493243374680379337978211449806120149\
478099947033083617577043079905736763548713398987802642961149810829218980550774\
686607597306857540512891030435574230197194645359571508431391990454866762169533\
36522319517494051234706971401523123460279117314785280000000000\ x\^11)\)/
            234127911551592855835970180827295301195666187919677978700409376536\
328284483495599691160226953135136884470071814234190576373748698941080509733547\
548848468317843288911876248642689821731158777021357753730890056026430509066698\
951112345921 + 
          \((52113230583321394920875368424735954592390555434593809688229966409\
805575268315367658492395868891713287457963006099790005723094767252800198453386\
333042609182739763982413586669146104930493090514366345302587611110660433169441\
17248527076114097982119848352883402252521806233600000000000\ x\^12)\)/
            234127911551592855835970180827295301195666187919677978700409376536\
328284483495599691160226953135136884470071814234190576373748698941080509733547\
548848468317843288911876248642689821731158777021357753730890056026430509066698\
951112345921 - 
          \((16461438771183246336320343870037412711672713717324024889697177567\
652019727088562657215168652289595537982817831549590940103224316237755590653494\
029539795709021433438662484224119932099126423169886786508632170663674031952910\
746749922850824878789279526596344408366592819200000000000\ x\^13)\)/
            234127911551592855835970180827295301195666187919677978700409376536\
328284483495599691160226953135136884470071814234190576373748698941080509733547\
548848468317843288911876248642689821731158777021357753730890056026430509066698\
951112345921 + 
          \((39652313875170416785617977772736578246429633932430328194483576607\
397686753893491796143759912343053154263055504360905842338319855277264926496665\
651825466202214043066554646800670412369695688857846381489087043100163218755210\
291424056841997906376234481101205443870720000000000000\ x\^14)\)/
            234127911551592855835970180827295301195666187919677978700409376536\
328284483495599691160226953135136884470071814234190576373748698941080509733547\
548848468317843288911876248642689821731158777021357753730890056026430509066698\
951112345921 - 
          \((73367169659216307904257415675787500492428920041945520891794169076\
219984388395528801359967458736696671874077879288752027126256948162241481030482\
704294083353407276012788254454930463187396162156159833731423940620890847666500\
917497583771814582811868857567609334393733120000000\ x\^15)\)/
            234127911551592855835970180827295301195666187919677978700409376536\
328284483495599691160226953135136884470071814234190576373748698941080509733547\
548848468317843288911876248642689821731158777021357753730890056026430509066698\
951112345921 + 
          \((10474566639178495018259596168469441146551388643940580729362652313\
098320031886596259999115814955579353847037784276793759036329332939672408893629\
531728790346286377360749001742928077754786019029372308279750575453906943765930\
2602339838601926491924698050132948258718720000000\ x\^16)\)/
            234127911551592855835970180827295301195666187919677978700409376536\
328284483495599691160226953135136884470071814234190576373748698941080509733547\
548848468317843288911876248642689821731158777021357753730890056026430509066698\
951112345921 - 
          \((11560107587219129556806095334488846127148877338105352620746433233\
060386132456184789427725832494043089562445274292175543891175589461465632861850\
882107015723666328454734462222380107719249625474278619652114888498964645167129\
8365031140466454008209125237386196377600000000\ x\^17)\)/
            234127911551592855835970180827295301195666187919677978700409376536\
328284483495599691160226953135136884470071814234190576373748698941080509733547\
548848468317843288911876248642689821731158777021357753730890056026430509066698\
951112345921 + 
          \((98517037704608267712996217058761745355665128640797248273501086400\
661735755351185934740988473829650658507527036853934100758658088790652621538668\
230223731284481554745928866875133180370908173773175331506463288950679870371590\
170590196297807657305054139971731200000000\ x\^18)\)/
            234127911551592855835970180827295301195666187919677978700409376536\
328284483495599691160226953135136884470071814234190576373748698941080509733547\
548848468317843288911876248642689821731158777021357753730890056026430509066698\
951112345921 - 
          \((64545998852272172891981392375432343124203933113776348650667370928\
913961551531920473140538240617329118553105392145938753911942667655094700117235\
723898951561973984267911240664384921251276085151097885009862848267112458154827\
411427490949242094212786157056000000000\ x\^19)\)/
            234127911551592855835970180827295301195666187919677978700409376536\
328284483495599691160226953135136884470071814234190576373748698941080509733547\
548848468317843288911876248642689821731158777021357753730890056026430509066698\
951112345921 + 
          \((32234669971892358187678228603108330111990087390256405135179425872\
416473370925360191739845746629767613529580162807409495662222995068735001520383\
527176628208685629998064864022546139967066520100027490087626255000639309871967\
003096573986869108083958925619200000\ x\^20)\)/
            234127911551592855835970180827295301195666187919677978700409376536\
328284483495599691160226953135136884470071814234190576373748698941080509733547\
548848468317843288911876248642689821731158777021357753730890056026430509066698\
951112345921 - 
          \((10888949933034904478819774870612776909587323359212578905228617184\
535749220578668850318889130524416891386921952209808901839347186301792549544248\
186371258421326391505243795960864669735720351677229718373279777712797219277871\
2781500541487612153442447564800000\ x\^21)\)/
            210715120396433570252373162744565771076099569127710180830368438882\
695456035146039722044204257821623196023064632810771518736373829046972458760192\
793963621486058960020688623778420839558042899319221978357801050423787458160029\
0560011113289 + 
          \((30040269275308088847234739024559470398762361743775566737703837315\
330090085995066362432456365076172034276323528458337600945316684699608888131874\
555031761032991349943549886401468287463282298337175600390385428201292456256024\
439052782128245805968832000000\ x\^22)\)/
            210715120396433570252373162744565771076099569127710180830368438882\
695456035146039722044204257821623196023064632810771518736373829046972458760192\
793963621486058960020688623778420839558042899319221978357801050423787458160029\
0560011113289 - 
          \((19597905847637297624276599075560071481864810292446144367946403965\
128438170343196111826458804081797694284042594457629943827756369671876027635734\
572859325073526089886888490382370163518376669371600460673770124696824825688183\
89441487662115070208000000\ x\^23)\)/
            702383734654778567507910542481885903586998563759033936101228129608\
984853450486799073480680859405410653410215442702571729121246096823241529200642\
646545404953529866735628745928069465193476331064073261192670168079291527200096\
853337037763 + 
          \((76909946915680877444328396636514071088553577454120960755390700930\
658962958319974166404466479386965283392680283986499060859527330418332760220483\
770206195256872935649114990067649280613348049061553877512658851069015975005564\
7665927722019858437500\ x\^24)\)/
            210715120396433570252373162744565771076099569127710180830368438882\
695456035146039722044204257821623196023064632810771518736373829046972458760192\
793963621486058960020688623778420839558042899319221978357801050423787458160029\
0560011113289 - 
          \((60045074222067324737157132378513278579060773163412865733743443792\
567990659831010448749456404119250554508125197087185725610097454077072738194400\
678369884412797971099437791298603064803387513897895318974849119353849323608162\
529936990313524064\ x\^25)\)/
            210715120396433570252373162744565771076099569127710180830368438882\
695456035146039722044204257821623196023064632810771518736373829046972458760192\
793963621486058960020688623778420839558042899319221978357801050423787458160029\
0560011113289 + x\^26\)}],
      SequenceForm[ "dorthpoly[", 1, ",", 26, ",", x, ",", 
        DirectedInfinity[ 1], "]=", 
        Plus[ 
          Rational[ 
          29237869116768325792864634809680035089186016290042959790853150615581\
516157107232075028289512034559032647034919875865721731418103857187365798210963\
724650848124980011252181520623837522368792188762718941554756063364536308656286\
735859085328719717447185150777934385771535739666408067301376000000000000, 
            234127911551592855835970180827295301195666187919677978700409376536\
328284483495599691160226953135136884470071814234190576373748698941080509733547\
548848468317843288911876248642689821731158777021357753730890056026430509066698\
951112345921], 
          Times[ 
            Rational[
             -1565439354998960362929961525592517851727905332806229485188346504\
919811903962484209565660800126674755895747532855940362781982950537651560300492\
407266805922732051202477002878795911938986330260349657299098100407483728980609\
12927215400052434549418871542219567281286789381289713971522174976000000000000,
               234127911551592855835970180827295301195666187919677978700409376\
536328284483495599691160226953135136884470071814234190576373748698941080509733\
547548848468317843288911876248642689821731158777021357753730890056026430509066\
698951112345921], x], 
          Times[ 
            Rational[ 
            119493408125867299756189310078487232890360235842132271059617584901\
701409340265976233960136895716761755991767155966422185115953985331414203577648\
581994985565304939322496581591173948785377743140779904650621505816776322149883\
687984142847343175613988607793874158767098609378333256004403200000000000000, 
              2341279115515928558359701808272953011956661879196779787004093765\
363282844834955996911602269531351368844700718142341905763737486989410805097335\
475488484683178432889118762486426898217311587770213577537308900560264305090666\
98951112345921], 
            Power[ x, 2]], 
          Times[ 
            Rational[
             -3011138506738768944270416226622619330513057753947779408769505356\
891731976805882031281622751720074865016918087370019433101967833846535611955627\
613213665682351712764033045766256781515204101529273747494752873509706598651302\
9976601720010600892765069763879519837366678579151469015361126400000000000000, 
              2341279115515928558359701808272953011956661879196779787004093765\
363282844834955996911602269531351368844700718142341905763737486989410805097335\
475488484683178432889118762486426898217311587770213577537308900560264305090666\
98951112345921], 
            Power[ x, 3]], 
          Times[ 
            Rational[ 
            343288457950888150450057573309264752529495237965492367518311300805\
237078981876601082897170137120326743845425648543353636355236831161747801297507\
340590998366544697912264492102882852853299104973809319844573713519389888494378\
2507638887454668883571637295931986562108995623211918950400000000000000000, 
              2341279115515928558359701808272953011956661879196779787004093765\
363282844834955996911602269531351368844700718142341905763737486989410805097335\
475488484683178432889118762486426898217311587770213577537308900560264305090666\
98951112345921], 
            Power[ x, 4]], 
          Times[ 
            Rational[
             -2093282458153136059919643573756574702945807077392916122409361736\
891739297334356977280240879902763236663503550731713567754541961881653179724589\
458883427294858132512908066131433805823032469586045730310295782339281600939412\
44663183406927296355748360403046984190827024408604397981505945600000000000, 
              2341279115515928558359701808272953011956661879196779787004093765\
363282844834955996911602269531351368844700718142341905763737486989410805097335\
475488484683178432889118762486426898217311587770213577537308900560264305090666\
98951112345921], 
            Power[ x, 5]], 
          Times[ 
            Rational[ 
            757398687946885830125866073092166705529431246543161518342958947499\
070575956200967449313571057440543117014687194812512170786784045245902277861065\
205222554583940187647761962981810865838382753157300072544806354626160608174891\
9659124653994913848331337244284475573529659149041838692761600000000000, 
              2341279115515928558359701808272953011956661879196779787004093765\
363282844834955996911602269531351368844700718142341905763737486989410805097335\
475488484683178432889118762486426898217311587770213577537308900560264305090666\
98951112345921], 
            Power[ x, 6]], 
          Times[ 
            Rational[
             -1744709348290496204533607976231174709682978651208086923125642268\
691661083661861400572553748830287560860350001355301951380905845928779098976907\
177775293803528143930009360287913942582562683413145652418261679745146579746505\
84151299176757207759405344121945349736451448863754672930816000000000000, 
              2341279115515928558359701808272953011956661879196779787004093765\
363282844834955996911602269531351368844700718142341905763737486989410805097335\
475488484683178432889118762486426898217311587770213577537308900560264305090666\
98951112345921], 
            Power[ x, 7]], 
          Times[ 
            Rational[ 
            269136489631283615170367024082908582080812766961633824793569759245\
296191699057821994656983241656607761830507781666638569143904105615089789923059\
717083874486996006183765670103245834523038224679811731188645035737225777110510\
4439220132747462229411998066575131638974071266635415552000000000000, 
              2341279115515928558359701808272953011956661879196779787004093765\
363282844834955996911602269531351368844700718142341905763737486989410805097335\
475488484683178432889118762486426898217311587770213577537308900560264305090666\
98951112345921], 
            Power[ x, 8]], 
          Times[ 
            Rational[
             -2886963775839737361283611408199313070477356913480615540246824734\
210351148496788491597772054557945899193484144062916539808875365584054817037537\
067124994648244813508963793428985637810992041062837588184996337045589986447713\
6500094125518175840507212801466804780039552281104875520000000000000, 
              2341279115515928558359701808272953011956661879196779787004093765\
363282844834955996911602269531351368844700718142341905763737486989410805097335\
475488484683178432889118762486426898217311587770213577537308900560264305090666\
98951112345921], 
            Power[ x, 9]], 
          Times[ 
            Rational[ 
            221638159889999444764536724849491733862441385969832171672488839897\
333487732493201972188460287954689385414815086394661923860780591609562558654125\
105376057984410332339016874373232388297527147859809508000076308392290693399304\
795636660861140699348985151234775764826161634795847680000000000, 
              2341279115515928558359701808272953011956661879196779787004093765\
363282844834955996911602269531351368844700718142341905763737486989410805097335\
475488484683178432889118762486426898217311587770213577537308900560264305090666\
98951112345921], 
            Power[ x, 10]], 
          Times[ 
            Rational[
             -1245349750313560622835582616849324337468037933797821144980612014\
947809994703308361757704307990573676354871339898780264296114981082921898055077\
468660759730685754051289103043557423019719464535957150843139199045486676216953\
336522319517494051234706971401523123460279117314785280000000000, 
              2341279115515928558359701808272953011956661879196779787004093765\
363282844834955996911602269531351368844700718142341905763737486989410805097335\
475488484683178432889118762486426898217311587770213577537308900560264305090666\
98951112345921], 
            Power[ x, 11]], 
          Times[ 
            Rational[ 
            521132305833213949208753684247359545923905554345938096882299664098\
055752683153676584923958688917132874579630060997900057230947672528001984533863\
330426091827397639824135866691461049304930905143663453025876111106604331694411\
7248527076114097982119848352883402252521806233600000000000, 
              2341279115515928558359701808272953011956661879196779787004093765\
363282844834955996911602269531351368844700718142341905763737486989410805097335\
475488484683178432889118762486426898217311587770213577537308900560264305090666\
98951112345921], 
            Power[ x, 12]], 
          Times[ 
            Rational[
             -1646143877118324633632034387003741271167271371732402488969717756\
765201972708856265721516865228959553798281783154959094010322431623775559065349\
402953979570902143343866248422411993209912642316988678650863217066367403195291\
0746749922850824878789279526596344408366592819200000000000, 
              2341279115515928558359701808272953011956661879196779787004093765\
363282844834955996911602269531351368844700718142341905763737486989410805097335\
475488484683178432889118762486426898217311587770213577537308900560264305090666\
98951112345921], 
            Power[ x, 13]], 
          Times[ 
            Rational[ 
            396523138751704167856179777727365782464296339324303281944835766073\
976867538934917961437599123430531542630555043609058423383198552772649264966656\
518254662022140430665546468006704123696956888578463814890870431001632187552102\
91424056841997906376234481101205443870720000000000000, 
              2341279115515928558359701808272953011956661879196779787004093765\
363282844834955996911602269531351368844700718142341905763737486989410805097335\
475488484683178432889118762486426898217311587770213577537308900560264305090666\
98951112345921], 
            Power[ x, 14]], 
          Times[ 
            Rational[
             -7336716965921630790425741567578750049242892004194552089179416907\
621998438839552880135996745873669667187407787928875202712625694816224148103048\
270429408335340727601278825445493046318739616215615983373142394062089084766650\
0917497583771814582811868857567609334393733120000000, 
              2341279115515928558359701808272953011956661879196779787004093765\
363282844834955996911602269531351368844700718142341905763737486989410805097335\
475488484683178432889118762486426898217311587770213577537308900560264305090666\
98951112345921], 
            Power[ x, 15]], 
          Times[ 
            Rational[ 
            104745666391784950182595961684694411465513886439405807293626523130\
983200318865962599991158149555793538470377842767937590363293329396724088936295\
317287903462863773607490017429280777547860190293723082797505754539069437659302\
602339838601926491924698050132948258718720000000, 
              2341279115515928558359701808272953011956661879196779787004093765\
363282844834955996911602269531351368844700718142341905763737486989410805097335\
475488484683178432889118762486426898217311587770213577537308900560264305090666\
98951112345921], 
            Power[ x, 16]], 
          Times[ 
            Rational[
             -1156010758721912955680609533448884612714887733810535262074643323\
306038613245618478942772583249404308956244527429217554389117558946146563286185\
088210701572366632845473446222238010771924962547427861965211488849896464516712\
98365031140466454008209125237386196377600000000, 
              
              2341279115515928558359701808272953011956661879196779787004093765\
363282844834955996911602269531351368844700718142341905763737486989410805097335\
475488484683178432889118762486426898217311587770213577537308900560264305090666\
98951112345921], 
            Power[ x, 17]], 
          Times[ 
            Rational[ 
            985170377046082677129962170587617453556651286407972482735010864006\
617357553511859347409884738296506585075270368539341007586580887906526215386682\
302237312844815547459288668751331803709081737731753315064632889506798703715901\
70590196297807657305054139971731200000000, 
              2341279115515928558359701808272953011956661879196779787004093765\
363282844834955996911602269531351368844700718142341905763737486989410805097335\
475488484683178432889118762486426898217311587770213577537308900560264305090666\
98951112345921], 
            Power[ x, 18]], 
          Times[ 
            Rational[
             -6454599885227217289198139237543234312420393311377634865066737092\
891396155153192047314053824061732911855310539214593875391194266765509470011723\
572389895156197398426791124066438492125127608515109788500986284826711245815482\
7411427490949242094212786157056000000000, 
              2341279115515928558359701808272953011956661879196779787004093765\
363282844834955996911602269531351368844700718142341905763737486989410805097335\
475488484683178432889118762486426898217311587770213577537308900560264305090666\
98951112345921], 
            Power[ x, 19]], 
          Times[ 
            Rational[ 
            322346699718923581876782286031083301119900873902564051351794258724\
164733709253601917398457466297676135295801628074094956622229950687350015203835\
271766282086856299980648640225461399670665201000274900876262550006393098719670\
03096573986869108083958925619200000, 
              2341279115515928558359701808272953011956661879196779787004093765\
363282844834955996911602269531351368844700718142341905763737486989410805097335\
475488484683178432889118762486426898217311587770213577537308900560264305090666\
98951112345921], 
            Power[ x, 20]], 
          Times[ 
            Rational[
             -1088894993303490447881977487061277690958732335921257890522861718\
453574922057866885031888913052441689138692195220980890183934718630179254954424\
818637125842132639150524379596086466973572035167722971837327977771279721927787\
12781500541487612153442447564800000, 
              2107151203964335702523731627445657710760995691277101808303684388\
826954560351460397220442042578216231960230646328107715187363738290469724587601\
927939636214860589600206886237784208395580428993192219783578010504237874581600\
290560011113289], 
            Power[ x, 21]], 
          Times[ 
            Rational[ 
            300402692753080888472347390245594703987623617437755667377038373153\
300900859950663624324563650761720342763235284583376009453166846996088881318745\
550317610329913499435498864014682874632822983371756003903854282012924562560244\
39052782128245805968832000000, 
              2107151203964335702523731627445657710760995691277101808303684388\
826954560351460397220442042578216231960230646328107715187363738290469724587601\
927939636214860589600206886237784208395580428993192219783578010504237874581600\
290560011113289], 
            Power[ x, 22]], 
          Times[ 
            Rational[
             -1959790584763729762427659907556007148186481029244614436794640396\
512843817034319611182645880408179769428404259445762994382775636967187602763573\
457285932507352608988688849038237016351837666937160046067377012469682482568818\
389441487662115070208000000, 
              7023837346547785675079105424818859035869985637590339361012281296\
089848534504867990734806808594054106534102154427025717291212460968232415292006\
426465454049535298667356287459280694651934763310640732611926701680792915272000\
96853337037763], 
            Power[ x, 23]], 
          Times[ 
            Rational[ 
            769099469156808774443283966365140710885535774541209607553907009306\
589629583199741664044664793869652833926802839864990608595273304183327602204837\
702061952568729356491149900676492806133480490615538775126588510690159750055647\
665927722019858437500, 
              2107151203964335702523731627445657710760995691277101808303684388\
826954560351460397220442042578216231960230646328107715187363738290469724587601\
927939636214860589600206886237784208395580428993192219783578010504237874581600\
290560011113289], 
            Power[ x, 24]], 
          Times[ 
            Rational[
             -6004507422206732473715713237851327857906077316341286573374344379\
256799065983101044874945640411925055450812519708718572561009745407707273819440\
067836988441279797109943779129860306480338751389789531897484911935384932360816\
2529936990313524064, 
              2107151203964335702523731627445657710760995691277101808303684388\
826954560351460397220442042578216231960230646328107715187363738290469724587601\
927939636214860589600206886237784208395580428993192219783578010504237874581600\
290560011113289], 
            Power[ x, 25]], 
          Power[ x, 26]]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("dorthpoly["\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "27", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "x", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", 
        InterpretationBox["\[Infinity]",
          DirectedInfinity[ 1]], "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        \(\( - 335669587847681541130397478034412278933947229917931556168140382\
861601628820147037519481217912106634486020465503262190138446405194753524525214\
646250193211175961207341248702649407025295084494787058392861646387438304372161\
495766766404999756857779086177514366252469233640428271151749418908072706296795\
316805959680000000000000/
              1534847667700323660468838583357486608659055502418391771629263641\
643622150774443883560685435142259087862275163434164296750774145724903341551210\
940847958098517994195089082144858175479466596133155038794857210582579560790413\
020799289562805616724286914454059177\) + 
          \((18211627993263021793617550744090701178869677226468483446596237139\
284642460938434930778574386569927287308576285128374281988865133337807135157992\
634570694947697105168077863388130345304462531891217954595355545500699149350205\
987405392868452256306861412554012163154559600027334476086877744204433113460490\
20044771328000000000000\ x)\)/
            153484766770032366046883858335748660865905550241839177162926364164\
362215077444388356068543514225908786227516343416429675077414572490334155121094\
084795809851799419508908214485817547946659613315503879485721058257956079041302\
0799289562805616724286914454059177 - 
          \((14146849115896156761152209727302563605853798730418375133583242713\
970872105934828676582397329390541999254117542677530144689722211204914310798453\
150842314525601616112888169236444991552412282420402715792025979367810820553734\
569504185998547686012041958706846365185813055455887340233033061980218389781303\
03791398912000000000000\ x\^2)\)/
            153484766770032366046883858335748660865905550241839177162926364164\
362215077444388356068543514225908786227516343416429675077414572490334155121094\
084795809851799419508908214485817547946659613315503879485721058257956079041302\
0799289562805616724286914454059177 + 
          \((36392145345953884738361101023818850703772333789260748188263773108\
979732374019051183883458278137845723620553021247237891666784223178312215384354\
715518027046985298000111894115852681412137900455621707715458895611068090050810\
922857922393867829717443736740906612936479960996474100299833946551006865659642\
7630182400000000000000\ x\^3)\)/
            153484766770032366046883858335748660865905550241839177162926364164\
362215077444388356068543514225908786227516343416429675077414572490334155121094\
084795809851799419508908214485817547946659613315503879485721058257956079041302\
0799289562805616724286914454059177 - 
          \((42474433932846019162490694345924835564326017643359482901824293642\
727322324430427989448639956106481583311881199559100822126676595934086867319005\
229864473323137649146146016985606433558163876958077760614408132444270181206180\
931955851758309431745273585358277190598415404996307847631372347015545274805880\
304435200000000000000\ x\^4)\)/
            153484766770032366046883858335748660865905550241839177162926364164\
362215077444388356068543514225908786227516343416429675077414572490334155121094\
084795809851799419508908214485817547946659613315503879485721058257956079041302\
0799289562805616724286914454059177 + 
          \((26587994663485188212156496098826865050369860203502786714775109192\
431782264938767779220303629213749933226221095912574207663018116662720442100473\
277598805892211438986318736694040857708891437270763479551659694111475717954582\
504153669351643654640355058502795421109647250806359347376967742934933800614952\
51959808000000000000\ x\^5)\)/
            153484766770032366046883858335748660865905550241839177162926364164\
362215077444388356068543514225908786227516343416429675077414572490334155121094\
084795809851799419508908214485817547946659613315503879485721058257956079041302\
0799289562805616724286914454059177 - 
          \((99033663414374309143487331183176275009051198944146248537117018311\
532109025474583721454847395426243038778883422141499213324017990605828802073883\
949810101231744303506549621269866418444949570128986466780571811856282292193232\
865470846235520594782150688841523346066315527026834086530847042221692457140173\
458636800000000000\ x\^6)\)/
            153484766770032366046883858335748660865905550241839177162926364164\
362215077444388356068543514225908786227516343416429675077414572490334155121094\
084795809851799419508908214485817547946659613315503879485721058257956079041302\
0799289562805616724286914454059177 + 
          \((23552482447857208156368421041405873064040535207676053293800768455\
844962149511107712762478861394024493789658374327673851622468169797622700789678\
624309666059500048217512256845789911253477671545267483560860039866333068055078\
394728489065155398594341373767016829684942914552194480158415951137110404633882\
26355200000000000\ x\^7)\)/
            153484766770032366046883858335748660865905550241839177162926364164\
362215077444388356068543514225908786227516343416429675077414572490334155121094\
084795809851799419508908214485817547946659613315503879485721058257956079041302\
0799289562805616724286914454059177 - 
          \((37623972715946977795079731319445813065968759698530258484615724918\
382571872355717116307432397854376673806751017886581379871027710559425586249006\
746151735855423383393754139404955707953596068465585930056545794049433559640008\
498976574672313195230693296596640394247118415900513439860748065954473080328814\
592000000000000\ x\^8)\)/
            153484766770032366046883858335748660865905550241839177162926364164\
362215077444388356068543514225908786227516343416429675077414572490334155121094\
084795809851799419508908214485817547946659613315503879485721058257956079041302\
0799289562805616724286914454059177 + 
          \((41930226843206752315677983086686101561657703060840130246025672537\
541499942553831930888082711225885018864611498943921371451033244438712705563870\
937113363699278524784692141025171432363513527754366654034781929406946167654981\
291786468143692891434544491231883090970048416515676911881605953317748980423065\
6000000000000\ x\^9)\)/
            153484766770032366046883858335748660865905550241839177162926364164\
362215077444388356068543514225908786227516343416429675077414572490334155121094\
084795809851799419508908214485817547946659613315503879485721058257956079041302\
0799289562805616724286914454059177 - 
          \((33562708031041977512787484852684019849652982946879659211765459403\
694169609925847475569751530939779912582515566542933428453004719865894547646467\
382318171173860196271004632191518247591424328281209252001398230956338440329892\
906000710833175447853301387859647426888687934397773341173035017615764075577344\
00000000000\ x\^10)\)/
            153484766770032366046883858335748660865905550241839177162926364164\
362215077444388356068543514225908786227516343416429675077414572490334155121094\
084795809851799419508908214485817547946659613315503879485721058257956079041302\
0799289562805616724286914454059177 + 
          \((19738280133613661093522118802589755015969934378466185477498317311\
328293539020620656026707627529146342935645630034824201461689495725491913493238\
820041596149188701628407848471948968657792413535387442427349754369420152079199\
496584963722984124850159217749573785542899565337365352829760050481709491159040\
000000000\ x\^11)\)/
            153484766770032366046883858335748660865905550241839177162926364164\
362215077444388356068543514225908786227516343416429675077414572490334155121094\
084795809851799419508908214485817547946659613315503879485721058257956079041302\
0799289562805616724286914454059177 - 
          \((86822213228250639444414276743281088804058482925196759489548127102\
488000382508423769233933411111875558478280574011323068290803833000544513464008\
632546111019797683951250440025677947294717284499448588882679921086441382212408\
367435575086669704377615809835885799244075152685141455919457223648304168960000\
000000\ x\^12)\)/
            153484766770032366046883858335748660865905550241839177162926364164\
362215077444388356068543514225908786227516343416429675077414572490334155121094\
084795809851799419508908214485817547946659613315503879485721058257956079041302\
0799289562805616724286914454059177 + 
          \((28966613710107693638473336526365484935401920867675418473521906297\
927668299127004319070547630512485881109652834655391280814784068581441170977658\
383187426968108273595516737118010441079905059368082634814234017498662984355734\
645369220209095881296389402875624018452916617398633132879641786352926720000000\
0000\ x\^13)\)/
            153484766770032366046883858335748660865905550241839177162926364164\
362215077444388356068543514225908786227516343416429675077414572490334155121094\
084795809851799419508908214485817547946659613315503879485721058257956079041302\
0799289562805616724286914454059177 - 
          \((74097654082468975298342073270338269923076433531087864662264087750\
060339187312878635762938759780135071497511182934905181113053629813247771934550\
952486438605023968431294029065812155281981175525462171840925862323259623924030\
519223914226028648885383867178645436403141427327591534482047396085760000000000\
0\ x\^14)\)/
            153484766770032366046883858335748660865905550241839177162926364164\
362215077444388356068543514225908786227516343416429675077414572490334155121094\
084795809851799419508908214485817547946659613315503879485721058257956079041302\
0799289562805616724286914454059177 + 
          \((14650404308212833813692779003561550290525880410664494625725388559\
372312762124678241093782018892873092083126616851493033074552277505102057677299\
977394159431014318963263516708348234967997591064400439788872362613218557908935\
74906901711410868695063213154390736973270718956488381017196758669721600000000
                \ x\^15)\)/
            153484766770032366046883858335748660865905550241839177162926364164\
362215077444388356068543514225908786227516343416429675077414572490334155121094\
084795809851799419508908214485817547946659613315503879485721058257956079041302\
0799289562805616724286914454059177 - 
          \((22513495845741561739239206311511882060908208413989971767680780731\
994577459209685622585961546516738972461473779440172618085138393356113063974758\
736639214667662466822479341305769572592039255592464585951056170194898386516886\
71511094132950131642916089847299774287966836439966100184260682511360000000\ 
                x\^16)\)/
            153484766770032366046883858335748660865905550241839177162926364164\
362215077444388356068543514225908786227516343416429675077414572490334155121094\
084795809851799419508908214485817547946659613315503879485721058257956079041302\
0799289562805616724286914454059177 + 
          \((26974013902222680336718786240854142365718067869865450325430893622\
741032638245198647518531385708797254653721106963243517763723951498157126176485\
128555790608736436801048699173962636814436240301717612926788248956421065506166\
25661222580532573825892021944715756527074655973631922482637706240000000\ 
                x\^17)\)/
            153484766770032366046883858335748660865905550241839177162926364164\
362215077444388356068543514225908786227516343416429675077414572490334155121094\
084795809851799419508908214485817547946659613315503879485721058257956079041302\
0799289562805616724286914454059177 - 
          \((25214137836848276975361473785168802098494686744377724253805266912\
034825835578656372850218703103900080669994436723195968580763598761092951736470\
087553182173049618829456803398299213511658551769873398805928600475247303132079\
36144309825938776661743776442107582597276487535516198043027200000000\ x\^18)
              \)/1534847667700323660468838583357486608659055502418391771629263\
641643622150774443883560685435142259087862275163434164296750774145724903341551\
210940847958098517994195089082144858175479466596133155038794857210582579560790\
413020799289562805616724286914454059177 + 
          \((18350506192528718306870325829610352519736976582896102925837056829\
647388018180381072255605960581923081787940028708707008787237137160247313954283\
313895414811133619039626709416714680159177145703198794066113272674855102721387\
09141468593829380608296291673715638173488732577648953337600000000\ x\^19)\)/
            153484766770032366046883858335748660865905550241839177162926364164\
362215077444388356068543514225908786227516343416429675077414572490334155121094\
084795809851799419508908214485817547946659613315503879485721058257956079041302\
0799289562805616724286914454059177 - 
          \((10343894522448788126457004835771516393357720297407014240730941288\
469434741266815396574023899814105958358232516243404643246265956227178245707343\
012541181408883415835078837698696003481498897553052645231607884195311343152313\
98994371148078542732614932554572933082653000028730169856000000\ x\^20)\)/
            153484766770032366046883858335748660865905550241839177162926364164\
362215077444388356068543514225908786227516343416429675077414572490334155121094\
084795809851799419508908214485817547946659613315503879485721058257956079041302\
0799289562805616724286914454059177 + 
          \((44743862632340848784535524074025527991773043984728542056935225032\
004852659849240217531446093991793502637692035429196294259618226768647460808304\
687993988585910369391860924342484066867606590009913767436034007532801010028444\
5683161768145184717243508315499692715266827331696537600000\ x\^21)\)/
            153484766770032366046883858335748660865905550241839177162926364164\
362215077444388356068543514225908786227516343416429675077414572490334155121094\
084795809851799419508908214485817547946659613315503879485721058257956079041302\
0799289562805616724286914454059177 - 
          \((14635339932770631599088047931599882523121295099269253643819879075\
484508723530934122463065902813136232232057135643019218456403441094406817931437\
448369875054408397757865645577388753757713759020149614047390952993547025976677\
5840165792511527113498589491910292525033163435814400000\ x\^22)\)/
            153484766770032366046883858335748660865905550241839177162926364164\
362215077444388356068543514225908786227516343416429675077414572490334155121094\
084795809851799419508908214485817547946659613315503879485721058257956079041302\
0799289562805616724286914454059177 + 
          \((35382969348203169869012975188127905354038965424989438570536328237\
651970894249032300280521690463886181890639822719135013345811936702980015201910\
884100716318271438983847618456923998698064577493971387396166859837325167987717\
775440280385790089773357063473235470557608896000000\ x\^23)\)/
            153484766770032366046883858335748660865905550241839177162926364164\
362215077444388356068543514225908786227516343416429675077414572490334155121094\
084795809851799419508908214485817547946659613315503879485721058257956079041302\
0799289562805616724286914454059177 - 
          \((60998543836876181260954450217228973264854766102386101272122040817\
239459090367051454379815199275350194056232191596192604047927719879790436927950\
109347421843357697646966193300952417144498510042226931006836197819109017532347\
27886366840786167696561062524893455112555187500\ x\^24)\)/
            153484766770032366046883858335748660865905550241839177162926364164\
362215077444388356068543514225908786227516343416429675077414572490334155121094\
084795809851799419508908214485817547946659613315503879485721058257956079041302\
0799289562805616724286914454059177 + 
          \((70618370983122957465988753967005851561220389265066097449482454582\
846583043853472308369524919019361062688562616121400289136832174000696140840667\
945267581641004473535428373175540964439842511262300837787376059057917247982776\
2574793947028527042347708324759187040600780\ x\^25)\)/
            153484766770032366046883858335748660865905550241839177162926364164\
362215077444388356068543514225908786227516343416429675077414572490334155121094\
084795809851799419508908214485817547946659613315503879485721058257956079041302\
0799289562805616724286914454059177 - 
          \((49006341530621242949689391069905184389205919086725017768392239207\
278578223564008789932829851227084672079625678826250574358818892025425228244533\
918261884027441338646107433418697196186351012060023518573222252393777058700591\
791448698113694821266952273455533215513\ x\^26)\)/
            153484766770032366046883858335748660865905550241839177162926364164\
362215077444388356068543514225908786227516343416429675077414572490334155121094\
084795809851799419508908214485817547946659613315503879485721058257956079041302\
0799289562805616724286914454059177 + x\^27\)}],
      SequenceForm[ "dorthpoly[", 1, ",", 27, ",", x, ",", 
        DirectedInfinity[ 1], "]=", 
        Plus[ 
          Rational[
           -335669587847681541130397478034412278933947229917931556168140382861\
601628820147037519481217912106634486020465503262190138446405194753524525214646\
250193211175961207341248702649407025295084494787058392861646387438304372161495\
766766404999756857779086177514366252469233640428271151749418908072706296795316\
805959680000000000000, 
            153484766770032366046883858335748660865905550241839177162926364164\
362215077444388356068543514225908786227516343416429675077414572490334155121094\
084795809851799419508908214485817547946659613315503879485721058257956079041302\
0799289562805616724286914454059177], 
          Times[ 
            Rational[ 
            182116279932630217936175507440907011788696772264684834465962371392\
846424609384349307785743865699272873085762851283742819888651333378071351579926\
345706949476971051680778633881303453044625318912179545953555455006991493502059\
874053928684522563068614125540121631545596000273344760868777442044331134604902\
0044771328000000000000, 
              1534847667700323660468838583357486608659055502418391771629263641\
643622150774443883560685435142259087862275163434164296750774145724903341551210\
940847958098517994195089082144858175479466596133155038794857210582579560790413\
020799289562805616724286914454059177], x], 
          Times[ 
            Rational[
             -1414684911589615676115220972730256360585379873041837513358324271\
397087210593482867658239732939054199925411754267753014468972221120491431079845\
315084231452560161611288816923644499155241228242040271579202597936781082055373\
456950418599854768601204195870684636518581305545588734023303306198021838978130\
303791398912000000000000, 
              1534847667700323660468838583357486608659055502418391771629263641\
643622150774443883560685435142259087862275163434164296750774145724903341551210\
940847958098517994195089082144858175479466596133155038794857210582579560790413\
020799289562805616724286914454059177], 
            Power[ x, 2]], 
          Times[ 
            Rational[ 
            363921453459538847383611010238188507037723337892607481882637731089\
797323740190511838834582781378457236205530212472378916667842231783122153843547\
155180270469852980001118941158526814121379004556217077154588956110680900508109\
228579223938678297174437367409066129364799609964741002998339465510068656596427\
630182400000000000000, 
              1534847667700323660468838583357486608659055502418391771629263641\
643622150774443883560685435142259087862275163434164296750774145724903341551210\
940847958098517994195089082144858175479466596133155038794857210582579560790413\
020799289562805616724286914454059177], 
            Power[ x, 3]], 
          Times[ 
            Rational[
             -4247443393284601916249069434592483556432601764335948290182429364\
272732232443042798944863995610648158331188119955910082212667659593408686731900\
522986447332313764914614601698560643355816387695807776061440813244427018120618\
093195585175830943174527358535827719059841540499630784763137234701554527480588\
0304435200000000000000, 
              
              1534847667700323660468838583357486608659055502418391771629263641\
643622150774443883560685435142259087862275163434164296750774145724903341551210\
940847958098517994195089082144858175479466596133155038794857210582579560790413\
020799289562805616724286914454059177], 
            Power[ x, 4]], 
          Times[ 
            Rational[ 
            265879946634851882121564960988268650503698602035027867147751091924\
317822649387677792203036292137499332262210959125742076630181166627204421004732\
775988058922114389863187366940408577088914372707634795516596941114757179545825\
041536693516436546403550585027954211096472508063593473769677429349338006149525\
1959808000000000000, 
              1534847667700323660468838583357486608659055502418391771629263641\
643622150774443883560685435142259087862275163434164296750774145724903341551210\
940847958098517994195089082144858175479466596133155038794857210582579560790413\
020799289562805616724286914454059177], 
            Power[ x, 5]], 
          Times[ 
            Rational[
             -9903366341437430914348733118317627500905119894414624853711701831\
153210902547458372145484739542624303877888342214149921332401799060582880207388\
394981010123174430350654962126986641844494957012898646678057181185628229219323\
286547084623552059478215068884152334606631552702683408653084704222169245714017\
3458636800000000000, 
              1534847667700323660468838583357486608659055502418391771629263641\
643622150774443883560685435142259087862275163434164296750774145724903341551210\
940847958098517994195089082144858175479466596133155038794857210582579560790413\
020799289562805616724286914454059177], 
            Power[ x, 6]], 
          Times[ 
            Rational[ 
            235524824478572081563684210414058730640405352076760532938007684558\
449621495111077127624788613940244937896583743276738516224681697976227007896786\
243096660595000482175122568457899112534776715452674835608600398663330680550783\
947284890651553985943413737670168296849429145521944801584159511371104046338822\
6355200000000000, 
              1534847667700323660468838583357486608659055502418391771629263641\
643622150774443883560685435142259087862275163434164296750774145724903341551210\
940847958098517994195089082144858175479466596133155038794857210582579560790413\
020799289562805616724286914454059177], 
            Power[ x, 7]], 
          Times[ 
            Rational[
             -3762397271594697779507973131944581306596875969853025848461572491\
838257187235571711630743239785437667380675101788658137987102771055942558624900\
674615173585542338339375413940495570795359606846558593005654579404943355964000\
849897657467231319523069329659664039424711841590051343986074806595447308032881\
4592000000000000, 
              1534847667700323660468838583357486608659055502418391771629263641\
643622150774443883560685435142259087862275163434164296750774145724903341551210\
940847958098517994195089082144858175479466596133155038794857210582579560790413\
020799289562805616724286914454059177], 
            Power[ x, 8]], 
          Times[ 
            Rational[ 
            419302268432067523156779830866861015616577030608401302460256725375\
414999425538319308880827112258850188646114989439213714510332444387127055638709\
371133636992785247846921410251714323635135277543666540347819294069461676549812\
917864681436928914345444912318830909700484165156769118816059533177489804230656\
000000000000, 
              1534847667700323660468838583357486608659055502418391771629263641\
643622150774443883560685435142259087862275163434164296750774145724903341551210\
940847958098517994195089082144858175479466596133155038794857210582579560790413\
020799289562805616724286914454059177], 
            Power[ x, 9]], 
          Times[ 
            Rational[
             -3356270803104197751278748485268401984965298294687965921176545940\
369416960992584747556975153093977991258251556654293342845300471986589454764646\
738231817117386019627100463219151824759142432828120925200139823095633844032989\
290600071083317544785330138785964742688868793439777334117303501761576407557734\
400000000000, 
              1534847667700323660468838583357486608659055502418391771629263641\
643622150774443883560685435142259087862275163434164296750774145724903341551210\
940847958098517994195089082144858175479466596133155038794857210582579560790413\
020799289562805616724286914454059177], 
            Power[ x, 10]], 
          Times[ 
            Rational[ 
            197382801336136610935221188025897550159699343784661854774983173113\
282935390206206560267076275291463429356456300348242014616894957254919134932388\
200415961491887016284078484719489686577924135353874424273497543694201520791994\
965849637229841248501592177495737855428995653373653528297600504817094911590400\
00000000, 
              1534847667700323660468838583357486608659055502418391771629263641\
643622150774443883560685435142259087862275163434164296750774145724903341551210\
940847958098517994195089082144858175479466596133155038794857210582579560790413\
020799289562805616724286914454059177], 
            Power[ x, 11]], 
          Times[ 
            Rational[
             -8682221322825063944441427674328108880405848292519675948954812710\
248800038250842376923393341111187555847828057401132306829080383300054451346400\
863254611101979768395125044002567794729471728449944858888267992108644138221240\
836743557508666970437761580983588579924407515268514145591945722364830416896000\
0000000, 153484766770032366046883858335748660865905550241839177162926364164362\
215077444388356068543514225908786227516343416429675077414572490334155121094084\
795809851799419508908214485817547946659613315503879485721058257956079041302079\
9289562805616724286914454059177], 
            Power[ x, 12]], 
          Times[ 
            Rational[ 
            289666137101076936384733365263654849354019208676754184735219062979\
276682991270043190705476305124858811096528346553912808147840685814411709776583\
831874269681082735955167371180104410799050593680826348142340174986629843557346\
453692202090958812963894028756240184529166173986331328796417863529267200000000\
000, 1534847667700323660468838583357486608659055502418391771629263641643622150\
774443883560685435142259087862275163434164296750774145724903341551210940847958\
098517994195089082144858175479466596133155038794857210582579560790413020799289\
562805616724286914454059177], 
            Power[ x, 13]], 
          Times[ 
            Rational[
             -7409765408246897529834207327033826992307643353108786466226408775\
006033918731287863576293875978013507149751118293490518111305362981324777193455\
095248643860502396843129402906581215528198117552546217184092586232325962392403\
051922391422602864888538386717864543640314142732759153448204739608576000000000\
00, 15348476677003236604688385833574866086590555024183917716292636416436221507\
744438835606854351422590878622751634341642967507741457249033415512109408479580\
985179941950890821448581754794665961331550387948572105825795607904130207992895\
62805616724286914454059177], 
            Power[ x, 14]], 
          Times[ 
            Rational[ 
            146504043082128338136927790035615502905258804106644946257253885593\
723127621246782410937820188928730920831266168514930330745522775051020576772999\
773941594310143189632635167083482349679975910644004397888723626132185579089357\
4906901711410868695063213154390736973270718956488381017196758669721600000000, 
              1534847667700323660468838583357486608659055502418391771629263641\
643622150774443883560685435142259087862275163434164296750774145724903341551210\
940847958098517994195089082144858175479466596133155038794857210582579560790413\
020799289562805616724286914454059177], 
            Power[ x, 15]], 
          Times[ 
            Rational[
             -2251349584574156173923920631151188206090820841398997176768078073\
199457745920968562258596154651673897246147377944017261808513839335611306397475\
873663921466766246682247934130576957259203925559246458595105617019489838651688\
671511094132950131642916089847299774287966836439966100184260682511360000000, 
              1534847667700323660468838583357486608659055502418391771629263641\
643622150774443883560685435142259087862275163434164296750774145724903341551210\
940847958098517994195089082144858175479466596133155038794857210582579560790413\
020799289562805616724286914454059177], 
            Power[ x, 16]], 
          Times[ 
            Rational[ 
            269740139022226803367187862408541423657180678698654503254308936227\
410326382451986475185313857087972546537211069632435177637239514981571261764851\
285557906087364368010486991739626368144362403017176129267882489564210655061662\
5661222580532573825892021944715756527074655973631922482637706240000000, 
              1534847667700323660468838583357486608659055502418391771629263641\
643622150774443883560685435142259087862275163434164296750774145724903341551210\
940847958098517994195089082144858175479466596133155038794857210582579560790413\
020799289562805616724286914454059177], 
            Power[ x, 17]], 
          Times[ 
            Rational[
             -2521413783684827697536147378516880209849468674437772425380526691\
203482583557865637285021870310390008066999443672319596858076359876109295173647\
008755318217304961882945680339829921351165855176987339880592860047524730313207\
936144309825938776661743776442107582597276487535516198043027200000000, 
              1534847667700323660468838583357486608659055502418391771629263641\
643622150774443883560685435142259087862275163434164296750774145724903341551210\
940847958098517994195089082144858175479466596133155038794857210582579560790413\
020799289562805616724286914454059177], 
            Power[ x, 18]], 
          Times[ 
            Rational[ 
            183505061925287183068703258296103525197369765828961029258370568296\
473880181803810722556059605819230817879400287087070087872371371602473139542833\
138954148111336190396267094167146801591771457031987940661132726748551027213870\
9141468593829380608296291673715638173488732577648953337600000000, 
              1534847667700323660468838583357486608659055502418391771629263641\
643622150774443883560685435142259087862275163434164296750774145724903341551210\
940847958098517994195089082144858175479466596133155038794857210582579560790413\
020799289562805616724286914454059177], 
            Power[ x, 19]], 
          Times[ 
            Rational[
             -1034389452244878812645700483577151639335772029740701424073094128\
846943474126681539657402389981410595835823251624340464324626595622717824570734\
301254118140888341583507883769869600348149889755305264523160788419531134315231\
398994371148078542732614932554572933082653000028730169856000000, 
              1534847667700323660468838583357486608659055502418391771629263641\
643622150774443883560685435142259087862275163434164296750774145724903341551210\
940847958098517994195089082144858175479466596133155038794857210582579560790413\
020799289562805616724286914454059177], 
            Power[ x, 20]], 
          Times[ 
            Rational[ 
            447438626323408487845355240740255279917730439847285420569352250320\
048526598492402175314460939917935026376920354291962942596182267686474608083046\
879939885859103693918609243424840668676065900099137674360340075328010100284445\
683161768145184717243508315499692715266827331696537600000, 
              1534847667700323660468838583357486608659055502418391771629263641\
643622150774443883560685435142259087862275163434164296750774145724903341551210\
940847958098517994195089082144858175479466596133155038794857210582579560790413\
020799289562805616724286914454059177], 
            Power[ x, 21]], 
          Times[ 
            Rational[
             -1463533993277063159908804793159988252312129509926925364381987907\
548450872353093412246306590281313623223205713564301921845640344109440681793143\
744836987505440839775786564557738875375771375902014961404739095299354702597667\
75840165792511527113498589491910292525033163435814400000, 
              1534847667700323660468838583357486608659055502418391771629263641\
643622150774443883560685435142259087862275163434164296750774145724903341551210\
940847958098517994195089082144858175479466596133155038794857210582579560790413\
020799289562805616724286914454059177], 
            Power[ x, 22]], 
          Times[ 
            Rational[ 
            353829693482031698690129751881279053540389654249894385705363282376\
519708942490323002805216904638861818906398227191350133458119367029800152019108\
841007163182714389838476184569239986980645774939713873961668598373251679877177\
75440280385790089773357063473235470557608896000000, 
              1534847667700323660468838583357486608659055502418391771629263641\
643622150774443883560685435142259087862275163434164296750774145724903341551210\
940847958098517994195089082144858175479466596133155038794857210582579560790413\
020799289562805616724286914454059177], 
            Power[ x, 23]], 
          Times[ 
            Rational[
             -6099854383687618126095445021722897326485476610238610127212204081\
723945909036705145437981519927535019405623219159619260404792771987979043692795\
010934742184335769764696619330095241714449851004222693100683619781910901753234\
727886366840786167696561062524893455112555187500, 
              1534847667700323660468838583357486608659055502418391771629263641\
643622150774443883560685435142259087862275163434164296750774145724903341551210\
940847958098517994195089082144858175479466596133155038794857210582579560790413\
020799289562805616724286914454059177], 
            Power[ x, 24]], 
          Times[ 
            Rational[ 
            706183709831229574659887539670058515612203892650660974494824545828\
465830438534723083695249190193610626885626161214002891368321740006961408406679\
452675816410044735354283731755409644398425112623008377873760590579172479827762\
574793947028527042347708324759187040600780, 
              1534847667700323660468838583357486608659055502418391771629263641\
643622150774443883560685435142259087862275163434164296750774145724903341551210\
940847958098517994195089082144858175479466596133155038794857210582579560790413\
020799289562805616724286914454059177], 
            Power[ x, 25]], 
          Times[ 
            Rational[
             -4900634153062124294968939106990518438920591908672501776839223920\
727857822356400878993282985122708467207962567882625057435881889202542522824453\
391826188402744133864610743341869719618635101206002351857322225239377705870059\
1791448698113694821266952273455533215513, 
              1534847667700323660468838583357486608659055502418391771629263641\
643622150774443883560685435142259087862275163434164296750774145724903341551210\
940847958098517994195089082144858175479466596133155038794857210582579560790413\
020799289562805616724286914454059177], 
            Power[ x, 26]], 
          Power[ x, 27]]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("dorthpoly["\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "28", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "x", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", 
        InterpretationBox["\[Infinity]",
          DirectedInfinity[ 1]], "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        \(34003734595271758235340464462296616930903619906757443905522737079980\
193291506962029279014980750839136829870643230308120884739684965189120291467552\
487850148504330372812159469139049366465609992254849392732858241335779660587504\
420257774694617803969497075335255351595505092118272891239692074981065442740888\
613135016452643688127779569664000000000000/
            824748505291358857652025309974198155309108059560844088720381636001\
808919559029571778918484680568714808984806666806864208975107828263263358833613\
921821138466124987575779942964021677356417019924358199522079028947792862026962\
22001730258009567235634564320109035441399639839130019 - 
          \((18683645175920224922587288329536729086281142535385713465262735337\
813218760388850378672200265402425229363632781240464633787412324726530333171955\
752213175737713463400904041185799509484070742068120118898688566025594972305639\
907745024628031668218864024811897350613088157470711737089847934384987708442800\
1952254408719726223490823328104448000000000000\ x)\)/
            824748505291358857652025309974198155309108059560844088720381636001\
808919559029571778918484680568714808984806666806864208975107828263263358833613\
921821138466124987575779942964021677356417019924358199522079028947792862026962\
22001730258009567235634564320109035441399639839130019 + 
          \((14757979495858634473227278382826162968452589954708219760340358366\
865987141565997465901909934772991272183652491636505244662455643508873988061439\
691480690796751386657847023523319853802834735919827515006382504573089963975160\
075897643000715307700347935309450725427290100941477797315775487565058507403420\
9332806010752309028549134093647872000000000000\ x\^2)\)/
            824748505291358857652025309974198155309108059560844088720381636001\
808919559029571778918484680568714808984806666806864208975107828263263358833613\
921821138466124987575779942964021677356417019924358199522079028947792862026962\
22001730258009567235634564320109035441399639839130019 - 
          \((38717348248433052282666125521064171746389150884615068475565863522\
838975500216191744595343165875807237948606877791238828188950465937979111439274\
347064516938507338357586181871793997617676097872841241328496324620600515930271\
502045053888960178381864232239786827036607038095719850409449955723190085313672\
655146487336665748380573566500864000000000000\ x\^3)\)/
            824748505291358857652025309974198155309108059560844088720381636001\
808919559029571778918484680568714808984806666806864208975107828263263358833613\
921821138466124987575779942964021677356417019924358199522079028947792862026962\
22001730258009567235634564320109035441399639839130019 + 
          \((46206909586565789156860370511351455043999394118630459292662179773\
145438527107572840717015831604921293682266409805805832296789394181532597604555\
867317214376889984259111114752830174849795595896201245971613574977540363111113\
499779457116732769364696993141814173970284489216192216271235423757241925145519\
25504853734796653153684448870400000000000000\ x\^4)\)/
            824748505291358857652025309974198155309108059560844088720381636001\
808919559029571778918484680568714808984806666806864208975107828263263358833613\
921821138466124987575779942964021677356417019924358199522079028947792862026962\
22001730258009567235634564320109035441399639839130019 - 
          \((29652481986675045972437822053134917496098056917902353604091514658\
306972440526046300082940749667074998335725676882314423213375644431606016662574\
907214455005165697301529881315918499849023555906547550774628740787831726699998\
285293649006704253041654682626085353204916538879070716931697365976218894123708\
9551321225850985952260703807078400000000000\ x\^5)\)/
            824748505291358857652025309974198155309108059560844088720381636001\
808919559029571778918484680568714808984806666806864208975107828263263358833613\
921821138466124987575779942964021677356417019924358199522079028947792862026962\
22001730258009567235634564320109035441399639839130019 + 
          \((11352094851217737683517500715552232982728105278551428590195212198\
590907219658018882926057715638989956795503384663125014593045854331700134233101\
014311475589823828129554630868345984205701627164944152718242226187845807170394\
010130688001696834824753708575050407537517366799486434613299030140180435462866\
729797277523201211807042424012800000000000\ x\^6)\)/
            824748505291358857652025309974198155309108059560844088720381636001\
808919559029571778918484680568714808984806666806864208975107828263263358833613\
921821138466124987575779942964021677356417019924358199522079028947792862026962\
22001730258009567235634564320109035441399639839130019 - 
          \((27822967182246505312759745515056000126584638868624519843088908739\
585120228386006678712626677491204681425281995845609588008568458922367915182123\
367996009691198616063097052381304818348107356677473835449402557488423200239376\
497821382979931047556510755537378870800250294122521876369627405661462570847787\
2780049254783653124842402611200000000000\ x\^7)\)/
            824748505291358857652025309974198155309108059560844088720381636001\
808919559029571778918484680568714808984806666806864208975107828263263358833613\
921821138466124987575779942964021677356417019924358199522079028947792862026962\
22001730258009567235634564320109035441399639839130019 + 
          \((45932200009238499193075003962171775399161817748121559663084023023\
190863039457872920059800703463473649470250123645204304106412352832536214693104\
089520288424680482695043418718724516271406243693808657286338619033195865388147\
429402312835381461950879435741809635181319544918326749290341843188087497023689\
10646146225210955743520358400000000000\ x\^8)\)/
            824748505291358857652025309974198155309108059560844088720381636001\
808919559029571778918484680568714808984806666806864208975107828263263358833613\
921821138466124987575779942964021677356417019924358199522079028947792862026962\
22001730258009567235634564320109035441399639839130019 - 
          \((53058478336846656138557506839037998447422451219654589561755823329\
891359578893422742510278340989562211865453880080053668659065646701794579064320\
883269745801010719892918204495986363263494295453690827521216853462523251885076\
548356509056180631032666250302296703276756211951887684887902835290414560195476\
564097109212215778476032000000000000\ x\^9)\)/
            824748505291358857652025309974198155309108059560844088720381636001\
808919559029571778918484680568714808984806666806864208975107828263263358833613\
921821138466124987575779942964021677356417019924358199522079028947792862026962\
22001730258009567235634564320109035441399639839130019 + 
          \((44161807731617405178516383055512026676799146232389732779429119271\
238084478189861296462000569462074278999955356272513636964919036262332992685551\
204279923617355946711056951549769267033704062972919513161704965312682195640094\
156411275802824211504352598292324044250643274613346024991792601314024227218249\
6127432433382754636267520000000000\ x\^10)\)/
            824748505291358857652025309974198155309108059560844088720381636001\
808919559029571778918484680568714808984806666806864208975107828263263358833613\
921821138466124987575779942964021677356417019924358199522079028947792862026962\
22001730258009567235634564320109035441399639839130019 - 
          \((27100076975366970686960460945716389055476319838330360393964707746\
954779049196074478721940403280216617376827708022787029461880415402214986260919\
102099254656630466859773150190336490532204309263607890274504809459086610625215\
977186696701065442694813851984453344252388642144309490945232152944838587919358\
71736990978746131415040000000000\ x\^11)\)/
            824748505291358857652025309974198155309108059560844088720381636001\
808919559029571778918484680568714808984806666806864208975107828263263358833613\
921821138466124987575779942964021677356417019924358199522079028947792862026962\
22001730258009567235634564320109035441399639839130019 + 
          \((12485962649221443199321474043710310028668196883450570263516237505\
955426391733019170135403745295729792723362796864840893524894069595605953012813\
625013297297756827440332505885487006203392963487816861472097191170459550323085\
669293232169263684383025213833625989648468859985565769945779101662420303264582\
828719120817596661760000000000\ x\^12)\)/
            824748505291358857652025309974198155309108059560844088720381636001\
808919559029571778918484680568714808984806666806864208975107828263263358833613\
921821138466124987575779942964021677356417019924358199522079028947792862026962\
22001730258009567235634564320109035441399639839130019 - 
          \((43818804012987728570030321122754865434297913368882745491760666936\
986118073158055871858480936878272119575073102616777560163671808191483251556200\
522854083771376727864877989900794259344813640087773886774757464436652271991239\
039765523426885403587048413427271750639684963358981719171117659170474338806536\
065652912312811520000000000\ x\^13)\)/
            824748505291358857652025309974198155309108059560844088720381636001\
808919559029571778918484680568714808984806666806864208975107828263263358833613\
921821138466124987575779942964021677356417019924358199522079028947792862026962\
22001730258009567235634564320109035441399639839130019 + 
          \((11846919150512529536285697158331004756361368655482712392251433700\
200369458956910061965246767258583031162873623409227140597514369189174235888853\
732877342855884444183585389900854901715547946291440790856855563927696669345507\
595123953961196441722439189336364029229749310288913138162219131150066390537664\
7439704077107200000000000\ x\^14)\)/
            824748505291358857652025309974198155309108059560844088720381636001\
808919559029571778918484680568714808984806666806864208975107828263263358833613\
921821138466124987575779942964021677356417019924358199522079028947792862026962\
22001730258009567235634564320109035441399639839130019 - 
          \((24890506007857703752376212668605768336862835178570315296109511912\
727347333312829859999693811322184802012917287810463372384284330582961611470611\
278377212618686038063130589254451956289815522245552080344005610624662895290005\
522407022137213024370838727457736576067408163969755666660049586494908476692305\
9242431340871680000000\ x\^15)\)/
            824748505291358857652025309974198155309108059560844088720381636001\
808919559029571778918484680568714808984806666806864208975107828263263358833613\
921821138466124987575779942964021677356417019924358199522079028947792862026962\
22001730258009567235634564320109035441399639839130019 + 
          \((40898145785161901625133325934810242570997819741025770790183524901\
553031664267359985330960357465210074640980957536812451978940168661185193793106\
365102316834397171260115828177081751230171178682137603532752450724402202617984\
744793353329796928064372385135570309807125820390875473472274523803360987390867\
7628372828160000000\ x\^16)\)/
            824748505291358857652025309974198155309108059560844088720381636001\
808919559029571778918484680568714808984806666806864208975107828263263358833613\
921821138466124987575779942964021677356417019924358199522079028947792862026962\
22001730258009567235634564320109035441399639839130019 - 
          \((52773828392630774896006924554878999713642811189423016016788071795\
095302230251652405474559199323374199321663804106313872911709952513488702665081\
573263028345513382107067169778519854334495900792220401788938097551605233278541\
370489790163682433886189191303265789491001521806475279459790363023922480800915\
6741693440000000\ x\^17)\)/
            824748505291358857652025309974198155309108059560844088720381636001\
808919559029571778918484680568714808984806666806864208975107828263263358833613\
921821138466124987575779942964021677356417019924358199522079028947792862026962\
22001730258009567235634564320109035441399639839130019 + 
          \((53584226485224959100085700866132199259475962089292041648280448332\
107732311132320359618260621962044641948012046148492692566637049279178176127671\
082293639313954928747217383675554048075410909365530716238824869258241304768954\
802003954779677244944364060189182385475345316834887537893691077853178483232361\
2999680000000\ x\^18)\)/
            824748505291358857652025309974198155309108059560844088720381636001\
808919559029571778918484680568714808984806666806864208975107828263263358833613\
921821138466124987575779942964021677356417019924358199522079028947792862026962\
22001730258009567235634564320109035441399639839130019 - 
          \((42798002891034389231763078795112249112022736381915859120877129451\
240469299053727363924605238363818614682593344490748515374913548643035453724834\
223134532082378404079957816268399398434019692700862894116203509369658100476917\
845025028241045036233958405758349749146359790328578762732682636553039272508293\
1200000000\ x\^19)\)/
            824748505291358857652025309974198155309108059560844088720381636001\
808919559029571778918484680568714808984806666806864208975107828263263358833613\
921821138466124987575779942964021677356417019924358199522079028947792862026962\
22001730258009567235634564320109035441399639839130019 + 
          \((26812068053727323981179348309823132676255983632184955881299551997\
090501629230385230582062708372737207581017680069002293728369867646547516710115\
629299120898527314574610059038765598265551566712849280564018590188018757359396\
248547641278089345495669391538460082116924687661182763485825692637470449493754\
8800000\ x\^20)\)/
            824748505291358857652025309974198155309108059560844088720381636001\
808919559029571778918484680568714808984806666806864208975107828263263358833613\
921821138466124987575779942964021677356417019924358199522079028947792862026962\
22001730258009567235634564320109035441399639839130019 - 
          \((13097204735647483197202695675002673895144940638567848584543612271\
169217841480292222659021291836029726012361590550360953938199051224726524896106\
734227138010765083353059389739392177725829179930454950329470350096056428051777\
282935377863611905071038642738885147681745780457277385364013653813417319055360\
0000\ x\^21)\)/
            824748505291358857652025309974198155309108059560844088720381636001\
808919559029571778918484680568714808984806666806864208975107828263263358833613\
921821138466124987575779942964021677356417019924358199522079028947792862026962\
22001730258009567235634564320109035441399639839130019 + 
          \((49395387234627230670013112341108904721893562599601086159575286438\
489121931550749868885111115734646794305691397683345170831210946622019424277002\
982340034777180526123755029408366149081440355156637910620192465374312349378317\
701795454253212514352312202437507404172438347671347611915717409472318566400000
                \ x\^22)\)/
            824748505291358857652025309974198155309108059560844088720381636001\
808919559029571778918484680568714808984806666806864208975107828263263358833613\
921821138466124987575779942964021677356417019924358199522079028947792862026962\
22001730258009567235634564320109035441399639839130019 - 
          \((14165494150191084436688939935057204084666937234983321643232070025\
816766907486003321397736926449514331284892730017444529220171499726043987870362\
014118253150744639583607801955079983775129925058231826144529747108622384091920\
403957831133653551940418546988059141935463840493713444303898940622028800000\ 
                x\^23)\)/
            824748505291358857652025309974198155309108059560844088720381636001\
808919559029571778918484680568714808984806666806864208975107828263263358833613\
921821138466124987575779942964021677356417019924358199522079028947792862026962\
22001730258009567235634564320109035441399639839130019 + 
          \((30179853799902215243642081248226529343153981235810318827625640184\
961495308064118135045322347684297906200018455428458810414139658707772827608945\
309055370548249728572887630174752844681421992561525189569741247784652613823507\
65914979139374985228271982091380619194770436319426810367446408341000000\ 
                x\^24)\)/
            824748505291358857652025309974198155309108059560844088720381636001\
808919559029571778918484680568714808984806666806864208975107828263263358833613\
921821138466124987575779942964021677356417019924358199522079028947792862026962\
22001730258009567235634564320109035441399639839130019 - 
          \((46065810470590917012129825703543356636000238459971910859487609995\
312393384641307857011252460015792785921883492297296931624846699025067601264312\
585963519745602211235489534957643312230093305289082611628539337873008578112928\
0793139243546600550420918249163007768783269281335263364700688146944\ x\^25)\)/
            824748505291358857652025309974198155309108059560844088720381636001\
808919559029571778918484680568714808984806666806864208975107828263263358833613\
921821138466124987575779942964021677356417019924358199522079028947792862026962\
22001730258009567235634564320109035441399639839130019 + 
          \((47424273596719090683937598430340303663671667740816192897333238630\
635878178957366194165288634925173056618466736679148213433286794029257858835016\
913712477802469940909665261556726172342530171331530139867932895782015124382522\
860523306929480740250476885820584337672421192611961467844068608\ x\^26)\)/
            824748505291358857652025309974198155309108059560844088720381636001\
808919559029571778918484680568714808984806666806864208975107828263263358833613\
921821138466124987575779942964021677356417019924358199522079028947792862026962\
22001730258009567235634564320109035441399639839130019 - 
          \((
              2938384299655719896690122635863427112004536025820112019382608329\
982421778908063141557235093533325119430897493857849911233333497693740092291427\
229227471253509745990444832039821776381790527883337143573537769352413274150275\
444600035662374460948844210820227022600223777207939579539712\ x\^27)\)/
            824748505291358857652025309974198155309108059560844088720381636001\
808919559029571778918484680568714808984806666806864208975107828263263358833613\
921821138466124987575779942964021677356417019924358199522079028947792862026962\
22001730258009567235634564320109035441399639839130019 + x\^28\)}],
      SequenceForm[ "dorthpoly[", 1, ",", 28, ",", x, ",", 
        DirectedInfinity[ 1], "]=", 
        Plus[ 
          Rational[ 
          34003734595271758235340464462296616930903619906757443905522737079980\
193291506962029279014980750839136829870643230308120884739684965189120291467552\
487850148504330372812159469139049366465609992254849392732858241335779660587504\
420257774694617803969497075335255351595505092118272891239692074981065442740888\
613135016452643688127779569664000000000000, 
            824748505291358857652025309974198155309108059560844088720381636001\
808919559029571778918484680568714808984806666806864208975107828263263358833613\
921821138466124987575779942964021677356417019924358199522079028947792862026962\
22001730258009567235634564320109035441399639839130019], 
          Times[ 
            Rational[
             -1868364517592022492258728832953672908628114253538571346526273533\
781321876038885037867220026540242522936363278124046463378741232472653033317195\
575221317573771346340090404118579950948407074206812011889868856602559497230563\
990774502462803166821886402481189735061308815747071173708984793438498770844280\
01952254408719726223490823328104448000000000000, 
              8247485052913588576520253099741981553091080595608440887203816360\
018089195590295717789184846805687148089848066668068642089751078282632633588336\
139218211384661249875757799429640216773564170199243581995220790289477928620269\
6222001730258009567235634564320109035441399639839130019], x], 
          Times[ 
            Rational[ 
            147579794958586344732272783828261629684525899547082197603403583668\
659871415659974659019099347729912721836524916365052446624556435088739880614396\
914806907967513866578470235233198538028347359198275150063825045730899639751600\
758976430007153077003479353094507254272901009414777973157754875650585074034209\
332806010752309028549134093647872000000000000, 
              8247485052913588576520253099741981553091080595608440887203816360\
018089195590295717789184846805687148089848066668068642089751078282632633588336\
139218211384661249875757799429640216773564170199243581995220790289477928620269\
6222001730258009567235634564320109035441399639839130019], 
            Power[ x, 2]], 
          Times[ 
            Rational[
             -3871734824843305228266612552106417174638915088461506847556586352\
283897550021619174459534316587580723794860687779123882818895046593797911143927\
434706451693850733835758618187179399761767609787284124132849632462060051593027\
150204505388896017838186423223978682703660703809571985040944995572319008531367\
2655146487336665748380573566500864000000000000, 
              8247485052913588576520253099741981553091080595608440887203816360\
018089195590295717789184846805687148089848066668068642089751078282632633588336\
139218211384661249875757799429640216773564170199243581995220790289477928620269\
6222001730258009567235634564320109035441399639839130019], 
            Power[ x, 3]], 
          Times[ 
            Rational[ 
            462069095865657891568603705113514550439993941186304592926621797731\
454385271075728407170158316049212936822664098058058322967893941815325976045558\
673172143768899842591111147528301748497955958962012459716135749775403631111134\
997794571167327693646969931418141739702844892161922162712354237572419251455192\
5504853734796653153684448870400000000000000, 
              8247485052913588576520253099741981553091080595608440887203816360\
018089195590295717789184846805687148089848066668068642089751078282632633588336\
139218211384661249875757799429640216773564170199243581995220790289477928620269\
6222001730258009567235634564320109035441399639839130019], 
            Power[ x, 4]], 
          Times[ 
            Rational[
             -2965248198667504597243782205313491749609805691790235360409151465\
830697244052604630008294074966707499833572567688231442321337564443160601666257\
490721445500516569730152988131591849984902355590654755077462874078783172669999\
828529364900670425304165468262608535320491653887907071693169736597621889412370\
89551321225850985952260703807078400000000000, 
              8247485052913588576520253099741981553091080595608440887203816360\
018089195590295717789184846805687148089848066668068642089751078282632633588336\
139218211384661249875757799429640216773564170199243581995220790289477928620269\
6222001730258009567235634564320109035441399639839130019], 
            Power[ x, 5]], 
          Times[ 
            Rational[ 
            113520948512177376835175007155522329827281052785514285901952121985\
909072196580188829260577156389899567955033846631250145930458543317001342331010\
143114755898238281295546308683459842057016271649441527182422261878458071703940\
101306880016968348247537085750504075375173667994864346132990301401804354628667\
29797277523201211807042424012800000000000, 
              8247485052913588576520253099741981553091080595608440887203816360\
018089195590295717789184846805687148089848066668068642089751078282632633588336\
139218211384661249875757799429640216773564170199243581995220790289477928620269\
6222001730258009567235634564320109035441399639839130019], 
            Power[ x, 6]], 
          Times[ 
            Rational[
             -2782296718224650531275974551505600012658463886862451984308890873\
958512022838600667871262667749120468142528199584560958800856845892236791518212\
336799600969119861606309705238130481834810735667747383544940255748842320023937\
649782138297993104755651075553737887080025029412252187636962740566146257084778\
72780049254783653124842402611200000000000, 
              8247485052913588576520253099741981553091080595608440887203816360\
018089195590295717789184846805687148089848066668068642089751078282632633588336\
139218211384661249875757799429640216773564170199243581995220790289477928620269\
6222001730258009567235634564320109035441399639839130019], 
            Power[ x, 7]], 
          Times[ 
            Rational[ 
            459322000092384991930750039621717753991618177481215596630840230231\
908630394578729200598007034634736494702501236452043041064123528325362146931040\
895202884246804826950434187187245162714062436938086572863386190331958653881474\
294023128353814619508794357418096351813195449183267492903418431880874970236891\
0646146225210955743520358400000000000, 
              8247485052913588576520253099741981553091080595608440887203816360\
018089195590295717789184846805687148089848066668068642089751078282632633588336\
139218211384661249875757799429640216773564170199243581995220790289477928620269\
6222001730258009567235634564320109035441399639839130019], 
            Power[ x, 8]], 
          Times[ 
            Rational[
             -5305847833684665613855750683903799844742245121965458956175582332\
989135957889342274251027834098956221186545388008005366865906564670179457906432\
088326974580101071989291820449598636326349429545369082752121685346252325188507\
654835650905618063103266625030229670327675621195188768488790283529041456019547\
6564097109212215778476032000000000000, 
              8247485052913588576520253099741981553091080595608440887203816360\
018089195590295717789184846805687148089848066668068642089751078282632633588336\
139218211384661249875757799429640216773564170199243581995220790289477928620269\
6222001730258009567235634564320109035441399639839130019], 
            Power[ x, 9]], 
          Times[ 
            Rational[ 
            441618077316174051785163830555120266767991462323897327794291192712\
380844781898612964620005694620742789999553562725136369649190362623329926855512\
042799236173559467110569515497692670337040629729195131617049653126821956400941\
564112758028242115043525982923240442506432746133460249917926013140242272182496\
127432433382754636267520000000000, 
              8247485052913588576520253099741981553091080595608440887203816360\
018089195590295717789184846805687148089848066668068642089751078282632633588336\
139218211384661249875757799429640216773564170199243581995220790289477928620269\
6222001730258009567235634564320109035441399639839130019], 
            Power[ x, 10]], 
          Times[ 
            Rational[
             -2710007697536697068696046094571638905547631983833036039396470774\
695477904919607447872194040328021661737682770802278702946188041540221498626091\
910209925465663046685977315019033649053220430926360789027450480945908661062521\
597718669670106544269481385198445334425238864214430949094523215294483858791935\
871736990978746131415040000000000, 
              8247485052913588576520253099741981553091080595608440887203816360\
018089195590295717789184846805687148089848066668068642089751078282632633588336\
139218211384661249875757799429640216773564170199243581995220790289477928620269\
6222001730258009567235634564320109035441399639839130019], 
            Power[ x, 11]], 
          Times[ 
            Rational[ 
            124859626492214431993214740437103100286681968834505702635162375059\
554263917330191701354037452957297927233627968648408935248940695956059530128136\
250132972977568274403325058854870062033929634878168614720971911704595503230856\
692932321692636843830252138336259896484688599855657699457791016624203032645828\
28719120817596661760000000000, 
              8247485052913588576520253099741981553091080595608440887203816360\
018089195590295717789184846805687148089848066668068642089751078282632633588336\
139218211384661249875757799429640216773564170199243581995220790289477928620269\
6222001730258009567235634564320109035441399639839130019], 
            Power[ x, 12]], 
          Times[ 
            Rational[
             -4381880401298772857003032112275486543429791336888274549176066693\
698611807315805587185848093687827211957507310261677756016367180819148325155620\
052285408377137672786487798990079425934481364008777388677475746443665227199123\
903976552342688540358704841342727175063968496335898171917111765917047433880653\
6065652912312811520000000000, 
              8247485052913588576520253099741981553091080595608440887203816360\
018089195590295717789184846805687148089848066668068642089751078282632633588336\
139218211384661249875757799429640216773564170199243581995220790289477928620269\
6222001730258009567235634564320109035441399639839130019], 
            Power[ x, 13]], 
          Times[ 
            Rational[ 
            118469191505125295362856971583310047563613686554827123922514337002\
003694589569100619652467672585830311628736234092271405975143691891742358888537\
328773428558844441835853899008549017155479462914407908568555639276966693455075\
951239539611964417224391893363640292297493102889131381622191311500663905376647\
439704077107200000000000, 
              8247485052913588576520253099741981553091080595608440887203816360\
018089195590295717789184846805687148089848066668068642089751078282632633588336\
139218211384661249875757799429640216773564170199243581995220790289477928620269\
6222001730258009567235634564320109035441399639839130019], 
            Power[ x, 14]], 
          Times[ 
            Rational[
             -2489050600785770375237621266860576833686283517857031529610951191\
272734733331282985999969381132218480201291728781046337238428433058296161147061\
127837721261868603806313058925445195628981552224555208034400561062466289529000\
552240702213721302437083872745773657606740816396975566666004958649490847669230\
59242431340871680000000, 
              8247485052913588576520253099741981553091080595608440887203816360\
018089195590295717789184846805687148089848066668068642089751078282632633588336\
139218211384661249875757799429640216773564170199243581995220790289477928620269\
6222001730258009567235634564320109035441399639839130019], 
            Power[ x, 15]], 
          Times[ 
            Rational[ 
            408981457851619016251333259348102425709978197410257707901835249015\
530316642673599853309603574652100746409809575368124519789401686611851937931063\
651023168343971712601158281770817512301711786821376035327524507244022026179847\
447933533297969280643723851355703098071258203908754734722745238033609873908677\
628372828160000000, 
              8247485052913588576520253099741981553091080595608440887203816360\
018089195590295717789184846805687148089848066668068642089751078282632633588336\
139218211384661249875757799429640216773564170199243581995220790289477928620269\
6222001730258009567235634564320109035441399639839130019], 
            Power[ x, 16]], 
          Times[ 
            Rational[
             -5277382839263077489600692455487899971364281118942301601678807179\
509530223025165240547455919932337419932166380410631387291170995251348870266508\
157326302834551338210706716977851985433449590079222040178893809755160523327854\
137048979016368243388618919130326578949100152180647527945979036302392248080091\
56741693440000000, 
              8247485052913588576520253099741981553091080595608440887203816360\
018089195590295717789184846805687148089848066668068642089751078282632633588336\
139218211384661249875757799429640216773564170199243581995220790289477928620269\
6222001730258009567235634564320109035441399639839130019], 
            Power[ x, 17]], 
          Times[ 
            Rational[ 
            535842264852249591000857008661321992594759620892920416482804483321\
077323111323203596182606219620446419480120461484926925666370492791781761276710\
822936393139549287472173836755540480754109093655307162388248692582413047689548\
020039547796772449443640601891823854753453168348875378936910778531784832323612\
999680000000, 
              8247485052913588576520253099741981553091080595608440887203816360\
018089195590295717789184846805687148089848066668068642089751078282632633588336\
139218211384661249875757799429640216773564170199243581995220790289477928620269\
6222001730258009567235634564320109035441399639839130019], 
            Power[ x, 18]], 
          Times[ 
            Rational[
             -4279800289103438923176307879511224911202273638191585912087712945\
124046929905372736392460523836381861468259334449074851537491354864303545372483\
422313453208237840407995781626839939843401969270086289411620350936965810047691\
784502502824104503623395840575834974914635979032857876273268263655303927250829\
31200000000, 
              8247485052913588576520253099741981553091080595608440887203816360\
018089195590295717789184846805687148089848066668068642089751078282632633588336\
139218211384661249875757799429640216773564170199243581995220790289477928620269\
6222001730258009567235634564320109035441399639839130019], 
            Power[ x, 19]], 
          Times[ 
            Rational[ 
            268120680537273239811793483098231326762559836321849558812995519970\
905016292303852305820627083727372075810176800690022937283698676465475167101156\
292991208985273145746100590387655982655515667128492805640185901880187573593962\
485476412780893454956693915384600821169246876611827634858256926374704494937548\
800000, 8247485052913588576520253099741981553091080595608440887203816360018089\
195590295717789184846805687148089848066668068642089751078282632633588336139218\
211384661249875757799429640216773564170199243581995220790289477928620269622200\
1730258009567235634564320109035441399639839130019], 
            Power[ x, 20]], 
          Times[ 
            Rational[
             -1309720473564748319720269567500267389514494063856784858454361227\
116921784148029222265902129183602972601236159055036095393819905122472652489610\
673422713801076508335305938973939217772582917993045495032947035009605642805177\
728293537786361190507103864273888514768174578045727738536401365381341731905536\
00000, 82474850529135885765202530997419815530910805956084408872038163600180891\
955902957177891848468056871480898480666680686420897510782826326335883361392182\
113846612498757577994296402167735641701992435819952207902894779286202696222001\
730258009567235634564320109035441399639839130019], 
            Power[ x, 21]], 
          Times[ 
            Rational[ 
            493953872346272306700131123411089047218935625996010861595752864384\
891219315507498688851111157346467943056913976833451708312109466220194242770029\
823400347771805261237550294083661490814403551566379106201924653743123493783177\
01795454253212514352312202437507404172438347671347611915717409472318566400000,
               824748505291358857652025309974198155309108059560844088720381636\
001808919559029571778918484680568714808984806666806864208975107828263263358833\
613921821138466124987575779942964021677356417019924358199522079028947792862026\
96222001730258009567235634564320109035441399639839130019], 
            Power[ x, 22]], 
          Times[ 
            Rational[
             -1416549415019108443668893993505720408466693723498332164323207002\
581676690748600332139773692644951433128489273001744452922017149972604398787036\
201411825315074463958360780195507998377512992505823182614452974710862238409192\
0403957831133653551940418546988059141935463840493713444303898940622028800000, 
              8247485052913588576520253099741981553091080595608440887203816360\
018089195590295717789184846805687148089848066668068642089751078282632633588336\
139218211384661249875757799429640216773564170199243581995220790289477928620269\
6222001730258009567235634564320109035441399639839130019], 
            Power[ x, 23]], 
          Times[ 
            Rational[ 
            301798537999022152436420812482265293431539812358103188276256401849\
614953080641181350453223476842979062000184554284588104141396587077728276089453\
090553705482497285728876301747528446814219925615251895697412477846526138235076\
5914979139374985228271982091380619194770436319426810367446408341000000, 
              8247485052913588576520253099741981553091080595608440887203816360\
018089195590295717789184846805687148089848066668068642089751078282632633588336\
139218211384661249875757799429640216773564170199243581995220790289477928620269\
6222001730258009567235634564320109035441399639839130019], 
            Power[ x, 24]], 
          Times[ 
            Rational[
             -4606581047059091701212982570354335663600023845997191085948760999\
531239338464130785701125246001579278592188349229729693162484669902506760126431\
258596351974560221123548953495764331223009330528908261162853933787300857811292\
80793139243546600550420918249163007768783269281335263364700688146944, 
              8247485052913588576520253099741981553091080595608440887203816360\
018089195590295717789184846805687148089848066668068642089751078282632633588336\
139218211384661249875757799429640216773564170199243581995220790289477928620269\
6222001730258009567235634564320109035441399639839130019], 
            Power[ x, 25]], 
          Times[ 
            Rational[ 
            474242735967190906839375984303403036636716677408161928973332386306\
358781789573661941652886349251730566184667366791482134332867940292578588350169\
137124778024699409096652615567261723425301713315301398679328957820151243825228\
60523306929480740250476885820584337672421192611961467844068608, 
              8247485052913588576520253099741981553091080595608440887203816360\
018089195590295717789184846805687148089848066668068642089751078282632633588336\
139218211384661249875757799429640216773564170199243581995220790289477928620269\
6222001730258009567235634564320109035441399639839130019], 
            Power[ x, 26]], 
          Times[ 
            Rational[
             -2938384299655719896690122635863427112004536025820112019382608329\
982421778908063141557235093533325119430897493857849911233333497693740092291427\
229227471253509745990444832039821776381790527883337143573537769352413274150275\
444600035662374460948844210820227022600223777207939579539712, 
              8247485052913588576520253099741981553091080595608440887203816360\
018089195590295717789184846805687148089848066668068642089751078282632633588336\
139218211384661249875757799429640216773564170199243581995220790289477928620269\
6222001730258009567235634564320109035441399639839130019], 
            Power[ x, 27]], 
          Power[ x, 28]]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("dorthpoly["\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "29", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "x", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", 
        InterpretationBox["\[Infinity]",
          DirectedInfinity[ 1]], "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        \(\( - 737140975723000512977468823872656391488082377446718030924738918\
964051320696361919667763827910696463445888517445508379370025647527111994726159\
387567390750254384663428962838607224278242359811225962781322304503872489646315\
816510111640185307569767874350093599497143109425158792534495685931409380394398\
5851506921440796248896932107245325875220399070786342617088000000000000/
              8833245690737129438458967579776280823572137333122309476879457562\
193806849652971124519565816090166705871789146931343498013865508366486976398968\
139065005583478205629021808103899659306637346045887388982361827908758167923276\
623365650063585660493892359320770834602912096771934391899970967317537092073
              \) + \((40997271221526064681602610226965356145610367100286621624\
940891388738867120348531309395079486077724252122140705775524592591268345807654\
772091295775235308294356504666183403276777220746855717876705464445522159784187\
515343137799971507425799819248007272630242315485591095093665167232997698748559\
916578557055760954760391888288555397291758252188787102167353786368000000000000
                \ x)\)/8833245690737129438458967579776280823572137333122309476\
879457562193806849652971124519565816090166705871789146931343498013865508366486\
976398968139065005583478205629021808103899659306637346045887388982361827908758\
167923276623365650063585660493892359320770834602912096771934391899970967317537\
092073 - \((
              3290439990495044162073344759335718632327747122781672854273163551\
102109555636900087845679636500470620419265426525509608594239335142272808418695\
611432957918135305616737103554215664556366859433441600149963869997704732517452\
189048028326377783547789478612049916821998466048906836798176429884477231438745\
5139751307685772795103617408699170379491565690498943287296000000000000\ x\^2)
              \)/8833245690737129438458967579776280823572137333122309476879457\
562193806849652971124519565816090166705871789146931343498013865508366486976398\
968139065005583478205629021808103899659306637346045887388982361827908758167923\
276623365650063585660493892359320770834602912096771934391899970967317537092073
             + \((879567711177232288280022624327413645205877226623817258472533\
778976878896143860760530761847393591560385272381770416273435255100883401665904\
100532767047839650337636845810944995917568362219745904072992474859927202378548\
396019206668125233142137914281023358004931510841896655863404854993538106145137\
4314331387613418014134988820595018380911746391828118080847872000000000000\ 
                x\^3)\)/
            883324569073712943845896757977628082357213733312230947687945756219\
380684965297112451956581609016670587178914693134349801386550836648697639896813\
906500558347820562902180810389965930663734604588738898236182790875816792327662\
3365650063585660493892359320770834602912096771934391899970967317537092073 - 
          \((10722260070500336432146789315450689849459493172690922454124308564\
079746762262965351095212155876646685435368711196650543854172271397046930251055\
007703250379875944328486870438962463434463153272897117908997673496919081603536\
748221864091221815360714187936155557090661420012123063128516340170846301008072\
19774491718002787036271228534004116942850665915862745088000000000000\ x\^4)\)/
            883324569073712943845896757977628082357213733312230947687945756219\
380684965297112451956581609016670587178914693134349801386550836648697639896813\
906500558347820562902180810389965930663734604588738898236182790875816792327662\
3365650063585660493892359320770834602912096771934391899970967317537092073 + 
          \((
              7045258671816706368723902024378356499839979371446493658753750398\
362342932441577372646710369353877195696408497623876763943217102590790220011122\
436025458167719942580528192878503008982898507628210186193338958661060613118099\
306521396953099245664348033777228796073117330788411682822992007438323619435147\
1959645010873834388616360185932456229149070277741432012800000000000\ x\^5)\)/
            883324569073712943845896757977628082357213733312230947687945756219\
380684965297112451956581609016670587178914693134349801386550836648697639896813\
906500558347820562902180810389965930663734604588738898236182790875816792327662\
3365650063585660493892359320770834602912096771934391899970967317537092073 - 
          \((27682839066972008644702918096541690643660455484699933510005247917\
441874034648016296704762956805077988892850725011619938865653072234833941503631\
673597588613876790983612413712158205814422413984243586930774948750834314225034\
749563103349227514044977208031865940874560812319546533574383090116537876755907\
80331223641591500661110982105223565346403161104764108800000000000\ x\^6)\)/
            883324569073712943845896757977628082357213733312230947687945756219\
380684965297112451956581609016670587178914693134349801386550836648697639896813\
906500558347820562902180810389965930663734604588738898236182790875816792327662\
3365650063585660493892359320770834602912096771934391899970967317537092073 + 
          \((69808100052786743240603270871147920762400136442697521144904436187\
036382386627503551160439645127486485212144670050631906575866158072077734481239\
608444692159089627468816114254980678221389488890436945366518879964139983508283\
716321902128924708162506025548221022784451099786389974942518327554104633178005\
255283604443646971141132490961306478062380521200025600000000000\ x\^7)\)/
            883324569073712943845896757977628082357213733312230947687945756219\
380684965297112451956581609016670587178914693134349801386550836648697639896813\
906500558347820562902180810389965930663734604588738898236182790875816792327662\
3365650063585660493892359320770834602912096771934391899970967317537092073 - 
          \((11887839294692770985168937089184164919942281466864172514042917600\
973770949093350088456332579268668427041446853414807188247718145299994590210860\
644319099764879055308901839613013441049673433870546421274851877343708021833904\
727415382369464137847767517442793116531114972239140548580302463538074836343007\
18405226299841226852742681633351253203311190553395200000000000\ x\^8)\)/
            883324569073712943845896757977628082357213733312230947687945756219\
380684965297112451956581609016670587178914693134349801386550836648697639896813\
906500558347820562902180810389965930663734604588738898236182790875816792327662\
3365650063585660493892359320770834602912096771934391899970967317537092073 + 
          \((14203773769297181701268832005412291671643233532224757991702723583\
270576044761210312735076986957413781174462117858065129654158118742916162782649\
831741444991630414681327999256307176209196464407083581233581585183436693518333\
056573360464583547396261484652872717796285382568644009118310629772059311031722\
029544277019518358866274948231168855040374656204800000000000\ x\^9)\)/
            883324569073712943845896757977628082357213733312230947687945756219\
380684965297112451956581609016670587178914693134349801386550836648697639896813\
906500558347820562902180810389965930663734604588738898236182790875816792327662\
3365650063585660493892359320770834602912096771934391899970967317537092073 - 
          \((12263702438030010516974144029628202489438977030324912303532901646\
992985457200653689423734010227536136938437721835778307734641522661357756404574\
578656101621994343644213149179117746779528504156359685809493916805274889811617\
066878028511424701040641431853791707509644688494978152884916364654137486411235\
0465095528758686229247423258733852136103047331840000000000\ x\^10)\)/
            
            883324569073712943845896757977628082357213733312230947687945756219\
380684965297112451956581609016670587178914693134349801386550836648697639896813\
906500558347820562902180810389965930663734604588738898236182790875816792327662\
3365650063585660493892359320770834602912096771934391899970967317537092073 + 
          \((78313373423069036130075766423860697851106866160635511139008735077\
052980265089689576120875094162792896010207093751837321910967750275222928212283\
906720276098378336815863049659066695346682131565288645582614152892585469990900\
429419140952225206556153073407972632084410361997720691040249077440342589345999\
5624992355266634292195770297149549964207063040000000000\ x\^11)\)/
            883324569073712943845896757977628082357213733312230947687945756219\
380684965297112451956581609016670587178914693134349801386550836648697639896813\
906500558347820562902180810389965930663734604588738898236182790875816792327662\
3365650063585660493892359320770834602912096771934391899970967317537092073 - 
          \((37676270473753399477290919392158942163636477332903028103661510878\
420176596916422007905394512619259624755118377522557753734642272540035008636133\
313330069582479139872407360232411165899708283919295704298736149864733730780526\
070334211606438167016834500888853966793583949491653171224166163247638690117129\
29511372124568628005576267217286709725102080000000000\ x\^12)\)/
            883324569073712943845896757977628082357213733312230947687945756219\
380684965297112451956581609016670587178914693134349801386550836648697639896813\
906500558347820562902180810389965930663734604588738898236182790875816792327662\
3365650063585660493892359320770834602912096771934391899970967317537092073 + 
          \((13858896642408027816020713176527142399663193781946858560957871718\
375497775348844319206725877148454742952130800220583881660246805459134496125360\
555024158397506601441600432300083207985099070006801919960994585091316194510304\
483661617356067771547428136709171357248888863674423683466673517323240649136273\
818360588517115725861530153509555441500160000000000\ x\^13)\)/
            883324569073712943845896757977628082357213733312230947687945756219\
380684965297112451956581609016670587178914693134349801386550836648697639896813\
906500558347820562902180810389965930663734604588738898236182790875816792327662\
3365650063585660493892359320770834602912096771934391899970967317537092073 - 
          \((39438705834967003607871442782767205290134257925628310126653645015\
135211187551000845495153561717749890315631729935027171510620297945401372913440\
179197219464227478223268524022032158703291008495543597069834887868100596100436\
712702217455411251997109790205448145272582513950371802382440002770564322342116\
048696530248336542353213153731453911040000000000\ x\^14)\)/
            883324569073712943845896757977628082357213733312230947687945756219\
380684965297112451956581609016670587178914693134349801386550836648697639896813\
906500558347820562902180810389965930663734604588738898236182790875816792327662\
3365650063585660493892359320770834602912096771934391899970967317537092073 + 
          \((87630121022659303393515030642752465161518663920512627344329419909\
030648131655278423192892381281455229625807118338615125241053334890719329947088\
126829963097914532282123460485782019015493786962164122611016167991521081614360\
896378189851178053616767513849517347609165798276000534995022362197103222295164\
491197736062625338766641567065765314560000000\ x\^15)\)/
            883324569073712943845896757977628082357213733312230947687945756219\
380684965297112451956581609016670587178914693134349801386550836648697639896813\
906500558347820562902180810389965930663734604588738898236182790875816792327662\
3365650063585660493892359320770834602912096771934391899970967317537092073 - 
          \((15309424802877399270102308330016905311969646237519237023993986502\
121670216262314005290251267593107983560637277516535142105110395063156336773159\
978633779683272667233202394747578473462529232042240769612896925750948062035808\
819172718382756699967035393292710370281650935599815935563111408533528120773439\
3196354226459041224332513968497704960000000\ x\^16)\)/
            883324569073712943845896757977628082357213733312230947687945756219\
380684965297112451956581609016670587178914693134349801386550836648697639896813\
906500558347820562902180810389965930663734604588738898236182790875816792327662\
3365650063585660493892359320770834602912096771934391899970967317537092073 + 
          \((21134506250474377799978323953383801760212201187478331404636073581\
208457708055190434733651205967890079204838245523601997972137926978355026951571\
450376358374817332781548065355767524715351209276540336159240987231735579128357\
046863674604291361809899585423502434041459972505815344212806304747981773255301\
9040024059051710315169882023608320000000\ x\^17)\)/
            883324569073712943845896757977628082357213733312230947687945756219\
380684965297112451956581609016670587178914693134349801386550836648697639896813\
906500558347820562902180810389965930663734604588738898236182790875816792327662\
3365650063585660493892359320770834602912096771934391899970967317537092073 - 
          \((81708696261924268388671781861045072263870084737945956692072693911\
670146388251950002395767049603636341795976417943240707722099168678529094301705\
884993707250778308386448762762158148024925829220716313213913795105619084847751\
994452069886122873716833026588003798584711397210499387142422903076454467474116\
3721794392002361430122004480000000\ x\^18)\)/
            312128822994244856482649031087501089172160329792307755366765284883\
173386913532548569595965232868081479568521092980335618864505595988939095369898\
906890656660007266043173431233203509068457457451851200790170597482620774674085\
63129505525037669589725651310144291883081614035103858303784336811085131 + 
          \((20071693597153365609962593489582546042786543475218270307581660884\
394593035289200530144340514017503190244832782472195342955712112418162478243421\
525727175058098073108547066134202289745058220009913567118858860138229228669502\
125638881436679715847357353024829941589280495552443747321319891524044402690351\
2605443787258431382690037760000000\ x\^19)\)/
            883324569073712943845896757977628082357213733312230947687945756219\
380684965297112451956581609016670587178914693134349801386550836648697639896813\
906500558347820562902180810389965930663734604588738898236182790875816792327662\
3365650063585660493892359320770834602912096771934391899970967317537092073 - 
          \((13806644323305690805004824693307534712081650076827226244233130629\
494533789163137616763740070158152054724788005378549489783959622403655503158885\
590462750631233464051071910457343307486991716730260178907274497983119301255278\
839518603679032066171279582897919497005897085571328230413556813789212365944598\
7012971146793926741390489600000\ x\^20)\)/
            883324569073712943845896757977628082357213733312230947687945756219\
380684965297112451956581609016670587178914693134349801386550836648697639896813\
906500558347820562902180810389965930663734604588738898236182790875816792327662\
3365650063585660493892359320770834602912096771934391899970967317537092073 + 
          \((26498900286564752435402832442156594967670707066147245705655566608\
469022946431142669649373515615480361629621436882423798192637113745252136847340\
287309379938469430827609057495666471579396745326100960981784114502685516500875\
283527113092239712061121095814421296647043489482615437032230798061523680888168\
2826953066880619571200000\ x\^21)\)/
            312128822994244856482649031087501089172160329792307755366765284883\
173386913532548569595965232868081479568521092980335618864505595988939095369898\
906890656660007266043173431233203509068457457451851200790170597482620774674085\
63129505525037669589725651310144291883081614035103858303784336811085131 - 
          \((31953686594233471076364619462511238887200596079466972498077631559\
205924498331945519102904053466744820517741872989013833400452878421189826429701\
103321726387001333362975328718229079126910485937232086066679436015317865069989\
569707146795887341778826310003090659208953494237419058609275275426530290629420\
976360357880223027200000\ x\^22)\)/
            883324569073712943845896757977628082357213733312230947687945756219\
380684965297112451956581609016670587178914693134349801386550836648697639896813\
906500558347820562902180810389965930663734604588738898236182790875816792327662\
3365650063585660493892359320770834602912096771934391899970967317537092073 + 
          \((10570563565104131544832317987350074121311902977276143364668176582\
235955146818452517164674159667454051453040213298266418611297034507550240434173\
726650048228816703226089386729934829856181433302721548132072104554355344032069\
009440088170177225714903214349363868557118980475990236458869327786345720557894\
933372358557798400000\ x\^23)\)/
            883324569073712943845896757977628082357213733312230947687945756219\
380684965297112451956581609016670587178914693134349801386550836648697639896813\
906500558347820562902180810389965930663734604588738898236182790875816792327662\
3365650063585660493892359320770834602912096771934391899970967317537092073 - 
          \((26725427145876621507513926208761581804082793577675306770694240908\
687662798422860671937595347665732823550889479274275283285411273118588991989382\
233199832560098487220617348605979764886280470317969293233595575612925026298281\
735732383193291796713351206199932544598258560925738650061937266340250493242565\
18131711800600000\ x\^24)\)/
            883324569073712943845896757977628082357213733312230947687945756219\
380684965297112451956581609016670587178914693134349801386550836648697639896813\
906500558347820562902180810389965930663734604588738898236182790875816792327662\
3365650063585660493892359320770834602912096771934391899970967317537092073 + 
          \((50434522624956172786453202687011710567062347239757278201092932165\
458736981695009664151369869397943804630324632750582315620791603530705694619110\
664834566684194312942691979461486286186141262073966465041610469790018146829836\
904014607382502311361796446961133270542186117346876173609772717437540262905375\
4472863526848\ x\^25)\)/
            883324569073712943845896757977628082357213733312230947687945756219\
380684965297112451956581609016670587178914693134349801386550836648697639896813\
906500558347820562902180810389965930663734604588738898236182790875816792327662\
3365650063585660493892359320770834602912096771934391899970967317537092073 - 
          \((68484025489411048824266375845226558670784343899994271793917622247\
148148111927537458001252821142488114756306678107661659295470931231930696632636\
074167642635319417675922808245252133358286420663197983058803452419212740360526\
617359601746838059925702912742798399667828267206027814148345814638246712283391\
493104128\ x\^26)\)/
            883324569073712943845896757977628082357213733312230947687945756219\
380684965297112451956581609016670587178914693134349801386550836648697639896813\
906500558347820562902180810389965930663734604588738898236182790875816792327662\
3365650063585660493892359320770834602912096771934391899970967317537092073 + 
          \((18891948480594117089873589964729089092666066941158248539667743914\
731133860451692422095920043646853376949890854282854086957851648311464400269768\
983668151196737037681708938399746205635657041436785438959255547600089340325142\
409237339401280929204838352026016603092844144621378793970227089621153256217199\
598848\ x\^27)\)/
            264997370722113883153769027393288424707164119993669284306383726865\
814205489589133735586974482705001176153674407940304940415965250994609291969044\
171950167504346168870654243116989779199120381376621669470854837262745037698298\
70096950190756981481677077962312503808736290315803175699912901952611276219 - 
          \((10494233127307080109495571851494315040619449123526538221819693410\
441326180017915893904714627973504852635082898143977082370441203003294005932526\
287951870080318918257350389442277727027019620443793941728464002054241265917724\
032442967979352082845092054606386267362808570351024172104066152251812737503896\
11\ x\^28)\)/
            264997370722113883153769027393288424707164119993669284306383726865\
814205489589133735586974482705001176153674407940304940415965250994609291969044\
171950167504346168870654243116989779199120381376621669470854837262745037698298\
70096950190756981481677077962312503808736290315803175699912901952611276219 + 
          x\^29\)}],
      SequenceForm[ "dorthpoly[", 1, ",", 29, ",", x, ",", 
        DirectedInfinity[ 1], "]=", 
        Plus[ 
          Rational[
           -737140975723000512977468823872656391488082377446718030924738918964\
051320696361919667763827910696463445888517445508379370025647527111994726159387\
567390750254384663428962838607224278242359811225962781322304503872489646315816\
510111640185307569767874350093599497143109425158792534495685931409380394398585\
1506921440796248896932107245325875220399070786342617088000000000000, 
            883324569073712943845896757977628082357213733312230947687945756219\
380684965297112451956581609016670587178914693134349801386550836648697639896813\
906500558347820562902180810389965930663734604588738898236182790875816792327662\
3365650063585660493892359320770834602912096771934391899970967317537092073], 
          Times[ 
            Rational[ 
            409972712215260646816026102269653561456103671002866216249408913887\
388671203485313093950794860777242521221407057755245925912683458076547720912957\
752353082943565046661834032767772207468557178767054644455221597841875153431377\
999715074257998192480072726302423154855910950936651672329976987485599165785570\
55760954760391888288555397291758252188787102167353786368000000000000, 
              8833245690737129438458967579776280823572137333122309476879457562\
193806849652971124519565816090166705871789146931343498013865508366486976398968\
139065005583478205629021808103899659306637346045887388982361827908758167923276\
623365650063585660493892359320770834602912096771934391899970967317537092073], 
            x], 
          Times[ 
            Rational[
             -3290439990495044162073344759335718632327747122781672854273163551\
102109555636900087845679636500470620419265426525509608594239335142272808418695\
611432957918135305616737103554215664556366859433441600149963869997704732517452\
189048028326377783547789478612049916821998466048906836798176429884477231438745\
5139751307685772795103617408699170379491565690498943287296000000000000, 
              8833245690737129438458967579776280823572137333122309476879457562\
193806849652971124519565816090166705871789146931343498013865508366486976398968\
139065005583478205629021808103899659306637346045887388982361827908758167923276\
623365650063585660493892359320770834602912096771934391899970967317537092073], 
            
            Power[ x, 2]], 
          Times[ 
            Rational[ 
            879567711177232288280022624327413645205877226623817258472533778976\
878896143860760530761847393591560385272381770416273435255100883401665904100532\
767047839650337636845810944995917568362219745904072992474859927202378548396019\
206668125233142137914281023358004931510841896655863404854993538106145137431433\
1387613418014134988820595018380911746391828118080847872000000000000, 
              8833245690737129438458967579776280823572137333122309476879457562\
193806849652971124519565816090166705871789146931343498013865508366486976398968\
139065005583478205629021808103899659306637346045887388982361827908758167923276\
623365650063585660493892359320770834602912096771934391899970967317537092073], 
            
            Power[ x, 3]], 
          Times[ 
            Rational[
             -1072226007050033643214678931545068984945949317269092245412430856\
407974676226296535109521215587664668543536871119665054385417227139704693025105\
500770325037987594432848687043896246343446315327289711790899767349691908160353\
674822186409122181536071418793615555709066142001212306312851634017084630100807\
219774491718002787036271228534004116942850665915862745088000000000000, 
              8833245690737129438458967579776280823572137333122309476879457562\
193806849652971124519565816090166705871789146931343498013865508366486976398968\
139065005583478205629021808103899659306637346045887388982361827908758167923276\
623365650063585660493892359320770834602912096771934391899970967317537092073], 
            
            Power[ x, 4]], 
          Times[ 
            Rational[ 
            704525867181670636872390202437835649983997937144649365875375039836\
234293244157737264671036935387719569640849762387676394321710259079022001112243\
602545816771994258052819287850300898289850762821018619333895866106061311809930\
652139695309924566434803377722879607311733078841168282299200743832361943514719\
59645010873834388616360185932456229149070277741432012800000000000, 
              8833245690737129438458967579776280823572137333122309476879457562\
193806849652971124519565816090166705871789146931343498013865508366486976398968\
139065005583478205629021808103899659306637346045887388982361827908758167923276\
623365650063585660493892359320770834602912096771934391899970967317537092073], 
            
            Power[ x, 5]], 
          Times[ 
            Rational[
             -2768283906697200864470291809654169064366045548469993351000524791\
744187403464801629670476295680507798889285072501161993886565307223483394150363\
167359758861387679098361241371215820581442241398424358693077494875083431422503\
474956310334922751404497720803186594087456081231954653357438309011653787675590\
780331223641591500661110982105223565346403161104764108800000000000, 
              8833245690737129438458967579776280823572137333122309476879457562\
193806849652971124519565816090166705871789146931343498013865508366486976398968\
139065005583478205629021808103899659306637346045887388982361827908758167923276\
623365650063585660493892359320770834602912096771934391899970967317537092073], 
            
            Power[ x, 6]], 
          Times[ 
            Rational[ 
            698081000527867432406032708711479207624001364426975211449044361870\
363823866275035511604396451274864852121446700506319065758661580720777344812396\
084446921590896274688161142549806782213894888904369453665188799641399835082837\
163219021289247081625060255482210227844510997863899749425183275541046331780052\
55283604443646971141132490961306478062380521200025600000000000, 
              8833245690737129438458967579776280823572137333122309476879457562\
193806849652971124519565816090166705871789146931343498013865508366486976398968\
139065005583478205629021808103899659306637346045887388982361827908758167923276\
623365650063585660493892359320770834602912096771934391899970967317537092073], 
            
            Power[ x, 7]], 
          Times[ 
            Rational[
             -1188783929469277098516893708918416491994228146686417251404291760\
097377094909335008845633257926866842704144685341480718824771814529999459021086\
064431909976487905530890183961301344104967343387054642127485187734370802183390\
472741538236946413784776751744279311653111497223914054858030246353807483634300\
718405226299841226852742681633351253203311190553395200000000000, 
              8833245690737129438458967579776280823572137333122309476879457562\
193806849652971124519565816090166705871789146931343498013865508366486976398968\
139065005583478205629021808103899659306637346045887388982361827908758167923276\
623365650063585660493892359320770834602912096771934391899970967317537092073], 
            
            Power[ x, 8]], 
          Times[ 
            Rational[ 
            142037737692971817012688320054122916716432335322247579917027235832\
705760447612103127350769869574137811744621178580651296541581187429161627826498\
317414449916304146813279992563071762091964644070835812335815851834366935183330\
565733604645835473962614846528727177962853825686440091183106297720593110317220\
29544277019518358866274948231168855040374656204800000000000, 
              
              8833245690737129438458967579776280823572137333122309476879457562\
193806849652971124519565816090166705871789146931343498013865508366486976398968\
139065005583478205629021808103899659306637346045887388982361827908758167923276\
623365650063585660493892359320770834602912096771934391899970967317537092073], 
            
            Power[ x, 9]], 
          Times[ 
            Rational[
             -1226370243803001051697414402962820248943897703032491230353290164\
699298545720065368942373401022753613693843772183577830773464152266135775640457\
457865610162199434364421314917911774677952850415635968580949391680527488981161\
706687802851142470104064143185379170750964468849497815288491636465413748641123\
50465095528758686229247423258733852136103047331840000000000, 
              8833245690737129438458967579776280823572137333122309476879457562\
193806849652971124519565816090166705871789146931343498013865508366486976398968\
139065005583478205629021808103899659306637346045887388982361827908758167923276\
623365650063585660493892359320770834602912096771934391899970967317537092073], 
            
            Power[ x, 10]], 
          Times[ 
            Rational[ 
            783133734230690361300757664238606978511068661606355111390087350770\
529802650896895761208750941627928960102070937518373219109677502752229282122839\
067202760983783368158630496590666953466821315652886455826141528925854699909004\
294191409522252065561530734079726320844103619977206910402490774403425893459995\
624992355266634292195770297149549964207063040000000000, 
              8833245690737129438458967579776280823572137333122309476879457562\
193806849652971124519565816090166705871789146931343498013865508366486976398968\
139065005583478205629021808103899659306637346045887388982361827908758167923276\
623365650063585660493892359320770834602912096771934391899970967317537092073], 
            
            Power[ x, 11]], 
          Times[ 
            Rational[
             -3767627047375339947729091939215894216363647733290302810366151087\
842017659691642200790539451261925962475511837752255775373464227254003500863613\
331333006958247913987240736023241116589970828391929570429873614986473373078052\
607033421160643816701683450088885396679358394949165317122416616324763869011712\
929511372124568628005576267217286709725102080000000000, 
              8833245690737129438458967579776280823572137333122309476879457562\
193806849652971124519565816090166705871789146931343498013865508366486976398968\
139065005583478205629021808103899659306637346045887388982361827908758167923276\
623365650063585660493892359320770834602912096771934391899970967317537092073], 
            
            Power[ x, 12]], 
          Times[ 
            Rational[ 
            138588966424080278160207131765271423996631937819468585609578717183\
754977753488443192067258771484547429521308002205838816602468054591344961253605\
550241583975066014416004323000832079850990700068019199609945850913161945103044\
836616173560677715474281367091713572488888636744236834666735173232406491362738\
18360588517115725861530153509555441500160000000000, 
              8833245690737129438458967579776280823572137333122309476879457562\
193806849652971124519565816090166705871789146931343498013865508366486976398968\
139065005583478205629021808103899659306637346045887388982361827908758167923276\
623365650063585660493892359320770834602912096771934391899970967317537092073], 
            
            Power[ x, 13]], 
          Times[ 
            Rational[
             -3943870583496700360787144278276720529013425792562831012665364501\
513521118755100084549515356171774989031563172993502717151062029794540137291344\
017919721946422747822326852402203215870329100849554359706983488786810059610043\
671270221745541125199710979020544814527258251395037180238244000277056432234211\
6048696530248336542353213153731453911040000000000, 
              8833245690737129438458967579776280823572137333122309476879457562\
193806849652971124519565816090166705871789146931343498013865508366486976398968\
139065005583478205629021808103899659306637346045887388982361827908758167923276\
623365650063585660493892359320770834602912096771934391899970967317537092073], 
            
            Power[ x, 14]], 
          Times[ 
            Rational[ 
            876301210226593033935150306427524651615186639205126273443294199090\
306481316552784231928923812814552296258071183386151252410533348907193299470881\
268299630979145322821234604857820190154937869621641226110161679915210816143608\
963781898511780536167675138495173476091657982760005349950223621971032222951644\
91197736062625338766641567065765314560000000, 
              8833245690737129438458967579776280823572137333122309476879457562\
193806849652971124519565816090166705871789146931343498013865508366486976398968\
139065005583478205629021808103899659306637346045887388982361827908758167923276\
623365650063585660493892359320770834602912096771934391899970967317537092073], 
            
            Power[ x, 15]], 
          Times[ 
            Rational[
             -1530942480287739927010230833001690531196964623751923702399398650\
212167021626231400529025126759310798356063727751653514210511039506315633677315\
997863377968327266723320239474757847346252923204224076961289692575094806203580\
881917271838275669996703539329271037028165093559981593556311140853352812077343\
93196354226459041224332513968497704960000000, 
              8833245690737129438458967579776280823572137333122309476879457562\
193806849652971124519565816090166705871789146931343498013865508366486976398968\
139065005583478205629021808103899659306637346045887388982361827908758167923276\
623365650063585660493892359320770834602912096771934391899970967317537092073], 
            
            Power[ x, 16]], 
          Times[ 
            Rational[ 
            211345062504743777999783239533838017602122011874783314046360735812\
084577080551904347336512059678900792048382455236019979721379269783550269515714\
503763583748173327815480653557675247153512092765403361592409872317355791283570\
468636746042913618098995854235024340414599725058153442128063047479817732553019\
040024059051710315169882023608320000000, 
              8833245690737129438458967579776280823572137333122309476879457562\
193806849652971124519565816090166705871789146931343498013865508366486976398968\
139065005583478205629021808103899659306637346045887388982361827908758167923276\
623365650063585660493892359320770834602912096771934391899970967317537092073], 
            
            Power[ x, 17]], 
          Times[ 
            Rational[
             -8170869626192426838867178186104507226387008473794595669207269391\
167014638825195000239576704960363634179597641794324070772209916867852909430170\
588499370725077830838644876276215814802492582922071631321391379510561908484775\
199445206988612287371683302658800379858471139721049938714242290307645446747411\
63721794392002361430122004480000000, 
              3121288229942448564826490310875010891721603297923077553667652848\
831733869135325485695959652328680814795685210929803356188645055959889390953698\
989068906566600072660431734312332035090684574574518512007901705974826207746740\
8563129505525037669589725651310144291883081614035103858303784336811085131], 
            Power[ x, 18]], 
          Times[ 
            Rational[ 
            200716935971533656099625934895825460427865434752182703075816608843\
945930352892005301443405140175031902448327824721953429557121124181624782434215\
257271750580980731085470661342022897450582200099135671188588601382292286695021\
256388814366797158473573530248299415892804955524437473213198915240444026903512\
605443787258431382690037760000000, 
              8833245690737129438458967579776280823572137333122309476879457562\
193806849652971124519565816090166705871789146931343498013865508366486976398968\
139065005583478205629021808103899659306637346045887388982361827908758167923276\
623365650063585660493892359320770834602912096771934391899970967317537092073], 
            
            Power[ x, 19]], 
          Times[ 
            Rational[
             -1380664432330569080500482469330753471208165007682722624423313062\
949453378916313761676374007015815205472478800537854948978395962240365550315888\
559046275063123346405107191045734330748699171673026017890727449798311930125527\
883951860367903206617127958289791949700589708557132823041355681378921236594459\
87012971146793926741390489600000, 
              8833245690737129438458967579776280823572137333122309476879457562\
193806849652971124519565816090166705871789146931343498013865508366486976398968\
139065005583478205629021808103899659306637346045887388982361827908758167923276\
623365650063585660493892359320770834602912096771934391899970967317537092073], 
            
            Power[ x, 20]], 
          Times[ 
            Rational[ 
            264989002865647524354028324421565949676707070661472457056555666084\
690229464311426696493735156154803616296214368824237981926371137452521368473402\
873093799384694308276090574956664715793967453261009609817841145026855165008752\
835271130922397120611210958144212966470434894826154370322307980615236808881682\
826953066880619571200000, 
              3121288229942448564826490310875010891721603297923077553667652848\
831733869135325485695959652328680814795685210929803356188645055959889390953698\
989068906566600072660431734312332035090684574574518512007901705974826207746740\
8563129505525037669589725651310144291883081614035103858303784336811085131], 
            Power[ x, 21]], 
          Times[ 
            Rational[
             -3195368659423347107636461946251123888720059607946697249807763155\
920592449833194551910290405346674482051774187298901383340045287842118982642970\
110332172638700133336297532871822907912691048593723208606667943601531786506998\
956970714679588734177882631000309065920895349423741905860927527542653029062942\
0976360357880223027200000, 
              8833245690737129438458967579776280823572137333122309476879457562\
193806849652971124519565816090166705871789146931343498013865508366486976398968\
139065005583478205629021808103899659306637346045887388982361827908758167923276\
623365650063585660493892359320770834602912096771934391899970967317537092073], 
            
            Power[ x, 22]], 
          Times[ 
            Rational[ 
            105705635651041315448323179873500741213119029772761433646681765822\
359551468184525171646741596674540514530402132982664186112970345075502404341737\
266500482288167032260893867299348298561814333027215481320721045543553440320690\
094400881701772257149032143493638685571189804759902364588693277863457205578949\
33372358557798400000, 
              8833245690737129438458967579776280823572137333122309476879457562\
193806849652971124519565816090166705871789146931343498013865508366486976398968\
139065005583478205629021808103899659306637346045887388982361827908758167923276\
623365650063585660493892359320770834602912096771934391899970967317537092073], 
            
            Power[ x, 23]], 
          Times[ 
            Rational[
             -2672542714587662150751392620876158180408279357767530677069424090\
868766279842286067193759534766573282355088947927427528328541127311858899198938\
223319983256009848722061734860597976488628047031796929323359557561292502629828\
173573238319329179671335120619993254459825856092573865006193726634025049324256\
518131711800600000, 
              8833245690737129438458967579776280823572137333122309476879457562\
193806849652971124519565816090166705871789146931343498013865508366486976398968\
139065005583478205629021808103899659306637346045887388982361827908758167923276\
623365650063585660493892359320770834602912096771934391899970967317537092073], 
            
            Power[ x, 24]], 
          Times[ 
            Rational[ 
            504345226249561727864532026870117105670623472397572782010929321654\
587369816950096641513698693979438046303246327505823156207916035307056946191106\
648345666841943129426919794614862861861412620739664650416104697900181468298369\
040146073825023113617964469611332705421861173468761736097727174375402629053754\
472863526848, 
              8833245690737129438458967579776280823572137333122309476879457562\
193806849652971124519565816090166705871789146931343498013865508366486976398968\
139065005583478205629021808103899659306637346045887388982361827908758167923276\
623365650063585660493892359320770834602912096771934391899970967317537092073], 
            
            Power[ x, 25]], 
          Times[ 
            Rational[
             -6848402548941104882426637584522655867078434389999427179391762224\
714814811192753745800125282114248811475630667810766165929547093123193069663263\
607416764263531941767592280824525213335828642066319798305880345241921274036052\
661735960174683805992570291274279839966782826720602781414834581463824671228339\
1493104128, 
              8833245690737129438458967579776280823572137333122309476879457562\
193806849652971124519565816090166705871789146931343498013865508366486976398968\
139065005583478205629021808103899659306637346045887388982361827908758167923276\
623365650063585660493892359320770834602912096771934391899970967317537092073], 
            
            Power[ x, 26]], 
          Times[ 
            Rational[ 
            188919484805941170898735899647290890926660669411582485396677439147\
311338604516924220959200436468533769498908542828540869578516483114644002697689\
836681511967370376817089383997462056356570414367854389592555476000893403251424\
092373394012809292048383520260166030928441446213787939702270896211532562171995\
98848, 26499737072211388315376902739328842470716411999366928430638372686581420\
548958913373558697448270500117615367440794030494041596525099460929196904417195\
016750434616887065424311698977919912038137662166947085483726274503769829870096\
950190756981481677077962312503808736290315803175699912901952611276219], 
            Power[ x, 27]], 
          Times[ 
            Rational[
             -1049423312730708010949557185149431504061944912352653822181969341\
044132618001791589390471462797350485263508289814397708237044120300329400593252\
628795187008031891825735038944227772702701962044379394172846400205424126591772\
403244296797935208284509205460638626736280857035102417210406615225181273750389\
611, 2649973707221138831537690273932884247071641199936692843063837268658142054\
895891337355869744827050011761536744079403049404159652509946092919690441719501\
675043461688706542431169897791991203813766216694708548372627450376982987009695\
0190756981481677077962312503808736290315803175699912901952611276219], 
            Power[ x, 28]], 
          Power[ x, 29]]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("dorthpoly["\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "30", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "x", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", 
        InterpretationBox["\[Infinity]",
          DirectedInfinity[ 1]], "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        \(25530117371183901871427414398079693809582510922467443548923849277211\
088559732141990128074062303665090996031674952031238391637461019874697000900863\
130537921692114347896857671867578901264360826145506063453156808303195848178547\
646972410992196222536749067700571211265264354979295083203008339733296641165965\
387978022074871816462955364967355418560398850201610835434719538176600309760000\
0000000000/
            141120436553634517656835462768546162573779363834783677302314412831\
026976328146989423382687051653485802797594172053151453010016649397409909532354\
307475309732325845402146344261974465971962025805220362738909514862460355182512\
929540002098511173821027208264867308726236043510456523438262166908207764591152\
507698046412129 - 
          \((14365307222339563900543720692654938805126839938270801167942230788\
793861328546088978976399626390166500911152966283823347344923318020199207923964\
700335906936455910080414506369132515927153990725100643780656578049104261666984\
760089910649112713313648669547412837773786019052851710229768940390445108050628\
197107789313234494779044710802902534893184648360351068037530893591909331107840\
00000000000000\ x)\)/
            141120436553634517656835462768546162573779363834783677302314412831\
026976328146989423382687051653485802797594172053151453010016649397409909532354\
307475309732325845402146344261974465971962025805220362738909514862460355182512\
929540002098511173821027208264867308726236043510456523438262166908207764591152\
507698046412129 + 
          \((11707176267491139494972128677208157722432529399600366949458755045\
982751491184141157235594662600048934628330165290497093753927788110104264367954\
250153967256231066401274365102410399187279639194351288945674450357986423854775\
715418050321683567029385919625185960680235331393891449661518083421285098112331\
958873302031556449354426817077042324569248720821841548708886499054089718988800\
00000000000000\ x\^2)\)/
            141120436553634517656835462768546162573779363834783677302314412831\
026976328146989423382687051653485802797594172053151453010016649397409909532354\
307475309732325845402146344261974465971962025805220362738909514862460355182512\
929540002098511173821027208264867308726236043510456523438262166908207764591152\
507698046412129 - 
          \((31859714085255192635822194414031539588132154560686384185800958646\
641362631983759967821762777954099314594675017150928379406479265651389355651806\
305644834511034370846273659677233393634581008164819177982295487641530369830251\
985504002796198389083976462856301207341542702084844058066140156123707318396026\
790635402091823787009263621421056707177934300608452078873829871755035725004800\
0000000000000\ x\^3)\)/
            141120436553634517656835462768546162573779363834783677302314412831\
026976328146989423382687051653485802797594172053151453010016649397409909532354\
307475309732325845402146344261974465971962025805220362738909514862460355182512\
929540002098511173821027208264867308726236043510456523438262166908207764591152\
507698046412129 + 
          \((39632193975745640078882153721983165013926876503662008605216014636\
027371860845538953207389327674569988626223001980855785503392586128135178561741\
056712003077917182190979739864140780079074598614155422529846199893774255002944\
926250145666639376877580691550482262740913109230289932848609970941632518941845\
332830091939900656258004390959182119297878705915935094478953910521500270592000\
000000000000\ x\^4)\)/
            141120436553634517656835462768546162573779363834783677302314412831\
026976328146989423382687051653485802797594172053151453010016649397409909532354\
307475309732325845402146344261974465971962025805220362738909514862460355182512\
929540002098511173821027208264867308726236043510456523438262166908207764591152\
507698046412129 - 
          \((26633140323348042604636589782284051958925360158573537100995197707\
975515104113284905317906992172342777499125946937067951399773222583268185717504\
459448547756296526220047814998583789368580410245025398520920789003499964992340\
410878843887579969849556897346572373773662669686498103069198796377301489729222\
783046150652828416277170634537169123113234840269386430268791792877562589347840\
00000000000\ x\^5)\)/
            141120436553634517656835462768546162573779363834783677302314412831\
026976328146989423382687051653485802797594172053151453010016649397409909532354\
307475309732325845402146344261974465971962025805220362738909514862460355182512\
929540002098511173821027208264867308726236043510456523438262166908207764591152\
507698046412129 + 
          \((10726830535030935268033787572637785726084523334962420226875858822\
356540700332910658796838564134326948610603919076811832687414215449248777629913\
270046363420493740255436232770777682704335871643147299894565976984691359148766\
236325671683839854481828036826986079773565324734614915158975775190810299914444\
399225484181192791710052859664448943383193449203667908888493772193115668480000\
0000000000\ x\^6)\)/
            141120436553634517656835462768546162573779363834783677302314412831\
026976328146989423382687051653485802797594172053151453010016649397409909532354\
307475309732325845402146344261974465971962025805220362738909514862460355182512\
929540002098511173821027208264867308726236043510456523438262166908207764591152\
507698046412129 - 
          \((27790364565195154019990015168111332723763621438496651756793944886\
355361712003102398819770401471257809134490052589344625518668172102538960184793\
658254942426780823237666603364364425254106339572443643162300980702718104322294\
125133609185841117103856808442717526536691052313500226720475206862769538011118\
226448718031535162262629197750865555617017256657451330061650117672304640000000\
00000000\ x\^7)\)/
            141120436553634517656835462768546162573779363834783677302314412831\
026976328146989423382687051653485802797594172053151453010016649397409909532354\
307475309732325845402146344261974465971962025805220362738909514862460355182512\
929540002098511173821027208264867308726236043510456523438262166908207764591152\
507698046412129 + 
          \((48735974382344132196780208636849981279773528092058071975420875241\
529747635949203608272397272226985682193379240094114215263242153731242282590091\
569858907274933509685237851828025876611987107508416211146084465815659381338395\
074482669771638266208155486901632440425181552624821161135923769591942750227393\
104447703922662041336856384575970056193010701536328882984010814953881600000000\
000000\ x\^8)\)/
            141120436553634517656835462768546162573779363834783677302314412831\
026976328146989423382687051653485802797594172053151453010016649397409909532354\
307475309732325845402146344261974465971962025805220362738909514862460355182512\
929540002098511173821027208264867308726236043510456523438262166908207764591152\
507698046412129 - 
          \((60116492891724296552391059859281171554052371894963951848377934961\
581762084202778585429719153257709938090103514117365694776547286024736715842297\
305408927074726975641827264793171870682150222450331768352588419638082902187158\
303165286891314196194612449872155841953767007428575061391088789593356343194469\
849892278447253689592912412372938671784828917528298751238450750423040000000000\
0000\ x\^9)\)/
            141120436553634517656835462768546162573779363834783677302314412831\
026976328146989423382687051653485802797594172053151453010016649397409909532354\
307475309732325845402146344261974465971962025805220362738909514862460355182512\
929540002098511173821027208264867308726236043510456523438262166908207764591152\
507698046412129 + 
          \((53729072176482274051387492202580038574147859564140113478350728858\
901578236421793651916140362799558832309521856460229289606954868750093804067662\
441637027437483659596002471337047169760254791224645488433545823486626157514450\
727009662314674254536944107325761348534329457250577260770627311892041846706155\
828445887751918243636687796015881871081189955351969222700146710544384000000000\
00\ x\^10)\)/
            141120436553634517656835462768546162573779363834783677302314412831\
026976328146989423382687051653485802797594172053151453010016649397409909532354\
307475309732325845402146344261974465971962025805220362738909514862460355182512\
929540002098511173821027208264867308726236043510456523438262166908207764591152\
507698046412129 - 
          \((35617441340397771689934719674529905954312921813590270517687983666\
950411372645622152634138846767094147468352744339174395419602253500499891119384\
831559888341851120025200066831165910314728976756188721543731809838253234590313\
017797281461821505458374056442109290371386401293552664899990454265347087059613\
621124015802954944595474050598965379296493182256488536228929470464000000000000
                \ x\^11)\)/
            141120436553634517656835462768546162573779363834783677302314412831\
026976328146989423382687051653485802797594172053151453010016649397409909532354\
307475309732325845402146344261974465971962025805220362738909514862460355182512\
929540002098511173821027208264867308726236043510456523438262166908207764591152\
507698046412129 + 
          \((17843509202032169976146379605379914265803989995783630738146348465\
627838739545972779323846934380637696581966943135296047331622099764589354542897\
539758853751745415899786001609407515101095419617984741653840766116301622590575\
852066275025065324252173676986136281257094318155866961017192797807348882028966\
7830308797099429070949460021321597857923141973640540078981775360000000000000\ 
                x\^12)\)/
            141120436553634517656835462768546162573779363834783677302314412831\
026976328146989423382687051653485802797594172053151453010016649397409909532354\
307475309732325845402146344261974465971962025805220362738909514862460355182512\
929540002098511173821027208264867308726236043510456523438262166908207764591152\
507698046412129 - 
          \((68580470979086876203855133165151508026825960494832191992679769295\
462173974343318477625217233376581729521517274056469782008629059927865847602094\
975448505899095141195953922329673021877496555127317058174074016943945093203798\
959365099953376011427007463476542977589080569256458904937179573968112566705690\
0390537882197830607406010272928958210388795144242327839571968000000000000\ 
                x\^13)\)/
            141120436553634517656835462768546162573779363834783677302314412831\
026976328146989423382687051653485802797594172053151453010016649397409909532354\
307475309732325845402146344261974465971962025805220362738909514862460355182512\
929540002098511173821027208264867308726236043510456523438262166908207764591152\
507698046412129 + 
          \((20468293334771261320109334502600242861989474343953717977006550884\
687838045878161561640586893797321988440904422388469915864979297506747086835815\
306259954118909539582783191903741701284148612529546068189917454260601407256276\
506085147131107347934020073643671963905764627423839472144199211353599800912966\
35538870227994150471481688081456762984855809822347368333312000000000000\ 
                x\^14)\)/
            141120436553634517656835462768546162573779363834783677302314412831\
026976328146989423382687051653485802797594172053151453010016649397409909532354\
307475309732325845402146344261974465971962025805220362738909514862460355182512\
929540002098511173821027208264867308726236043510456523438262166908207764591152\
507698046412129 - 
          \((47897611637640484634732721105506575183761269327107691581209495162\
355192898228387835545746954608160902756085671915945968818716734808714393298258\
424924633274099458653106909256379725140899470560756025644316340520582858891080\
371553297483568402156257137403304496203643123905147668548144724254091656536676\
52236851058157720281014744328259591389661899606154398400512000000000\ x\^15)
              \)/1411204365536345176568354627685461625737793638347836773023144\
128310269763281469894233826870516534858027975941720531514530100166493974099095\
323543074753097323258454021463442619744659719620258052203627389095148624603551\
825129295400020985111738210272082648673087262360435104565234382621669082077645\
91152507698046412129 + 
          \((88544765294144139032770262302757622374037862349131956557553041550\
904708241438161204457648897581566967303275991756719972172930136554005665973624\
445743708026466687924563958041371424516258593798602052946289764260943320222311\
821911580408126888187463636651687692384013303320690293380186243913152375851049\
38886310090421392237025202820875522048917256015922749440000000000\ x\^16)\)/
            141120436553634517656835462768546162573779363834783677302314412831\
026976328146989423382687051653485802797594172053151453010016649397409909532354\
307475309732325845402146344261974465971962025805220362738909514862460355182512\
929540002098511173821027208264867308726236043510456523438262166908207764591152\
507698046412129 - 
          \((13003570493203385876983987800046542578762624431153534103697867660\
036000914295692657726067067456107632016213820728025106238074408134512133189245\
484353724709181144426785734230304269844620989334561414965635647421272510824581\
437755805317531392110929780305143422626726941669086108759069082558184094974436\
534091824445024620421655283529657490204802926903296000000000000\ x\^17)\)/
            141120436553634517656835462768546162573779363834783677302314412831\
026976328146989423382687051653485802797594172053151453010016649397409909532354\
307475309732325845402146344261974465971962025805220362738909514862460355182512\
929540002098511173821027208264867308726236043510456523438262166908207764591152\
507698046412129 + 
          \((15228780154305006107689106827061772233947051765531288796250185124\
667043679436476570769585971854422438164648022038904396639500283897627182767412\
013595337520555076445136849714406653390661389081123672154158666954346929368662\
896069627105448734991410390304575488013478809053294454984714844678782486171913\
335549798150866910539125197467172966422006139054080000000000\ x\^18)\)/
            141120436553634517656835462768546162573779363834783677302314412831\
026976328146989423382687051653485802797594172053151453010016649397409909532354\
307475309732325845402146344261974465971962025805220362738909514862460355182512\
929540002098511173821027208264867308726236043510456523438262166908207764591152\
507698046412129 - 
          \((51446875295886443875729194455245729808243740952689397764365392577\
969065798447164779392792492942669955583476875072921477662662711837194479425883\
027082479471528885856179989221526618615260414692980029505381505204757218561012\
886244143512875473443608509584550353584781432920868706181040898004282545583419\
62544725129944875828832652898599047503589258117120000000000\ x\^19)\)/
            509444775958620608741176020594451646891343503443569075061355030320\
007384544610631818411500256469083748099314961111876745366160104324649773411799\
049985868133696301901748302785727822158782913156845509487463348653481882208871\
675639407575625337493908221836170984501712117072748049612126422538630030174060\
55278994754778569 + 
          \((38477885035345725206251390796853390746062482579602203115320453249\
204719356058919717241027546402180382014666622735678001184530495000985426173966\
013028481552220257162367262378496509488350461546558399667763887756012911326195\
782131498236092886988571440556399604900534579557395933558111987394614347172573\
39382735264276982123019477537787620886008324633600000000\ x\^20)\)/
            509444775958620608741176020594451646891343503443569075061355030320\
007384544610631818411500256469083748099314961111876745366160104324649773411799\
049985868133696301901748302785727822158782913156845509487463348653481882208871\
675639407575625337493908221836170984501712117072748049612126422538630030174060\
55278994754778569 - 
          \((22957929647013793107852503570535130906286322939888420323404146093\
776978512347603530759737950332295014748627576631981961064907838759185998676953\
200424454484008354782759986649964542572890302133390788833757367371705088642197\
397456752850600921435416726353688048905093397680925322062439364730051241761749\
61431844095908391507153914512270315266620416000000000\ x\^21)\)/
            509444775958620608741176020594451646891343503443569075061355030320\
007384544610631818411500256469083748099314961111876745366160104324649773411799\
049985868133696301901748302785727822158782913156845509487463348653481882208871\
675639407575625337493908221836170984501712117072748049612126422538630030174060\
55278994754778569 + 
          \((10881997004268222698454535859984793285510367771505768089617733904\
359302439066050565708767110315585392954399740326767505334804535484672985190370\
913340626395381913198568254403733037900289047836651479699710491658821849275933\
468236484722627261478988508187489073341006565213570774283218937361910918163834\
58335253698185126796562463829261805973472000000000\ x\^22)\)/
            509444775958620608741176020594451646891343503443569075061355030320\
007384544610631818411500256469083748099314961111876745366160104324649773411799\
049985868133696301901748302785727822158782913156845509487463348653481882208871\
675639407575625337493908221836170984501712117072748049612126422538630030174060\
55278994754778569 - 
          \((40688321200344034829194183960223592033958128015136002152807890920\
467987453288706212449729617321887624757545012471408264504528308987724857912111\
839590024222554717826226569088268560340232567099742052301924105467184408722619\
142114982569285830543237106236678567365962172604323073190174755430540105055215\
8355850629908168414026883707165017600000000000\ x\^23)\)/
            509444775958620608741176020594451646891343503443569075061355030320\
007384544610631818411500256469083748099314961111876745366160104324649773411799\
049985868133696301901748302785727822158782913156845509487463348653481882208871\
675639407575625337493908221836170984501712117072748049612126422538630030174060\
55278994754778569 + 
          \((11871548273014859564763047367561479114584096707440230566568814294\
355328089914535441929541157225578825512123778014271603188169169795226674353810\
005149010545404734288065354098019944724158588458090227092147777720712101939571\
823460467478183557884508101925613628828024856412246090363264855503308690191593\
5789578838084988270681792349837376500000000\ x\^24)\)/
            509444775958620608741176020594451646891343503443569075061355030320\
007384544610631818411500256469083748099314961111876745366160104324649773411799\
049985868133696301901748302785727822158782913156845509487463348653481882208871\
675639407575625337493908221836170984501712117072748049612126422538630030174060\
55278994754778569 - 
          \((26596561489071535086313217659177952260926503001568845438960418848\
318300031528128400920300789006456151046725100136085548430853070228239539561724\
848300308345784323472918226642666103643411821183410810682993641183333182151913\
841535904782881318205814696644478154506778307547653548211892714695112914147068\
767189684280142613444961473889788825600\ x\^25)\)/
            509444775958620608741176020594451646891343503443569075061355030320\
007384544610631818411500256469083748099314961111876745366160104324649773411799\
049985868133696301901748302785727822158782913156845509487463348653481882208871\
675639407575625337493908221836170984501712117072748049612126422538630030174060\
55278994754778569 + 
          \((44668065249262025145993787637859393332703228364440968409861368267\
856026668114389244974268354457569804109008936152888481625277464493663012532488\
575223228873643048327869212200178671973906355535183839516583243638624607761816\
268508279331480438080719318759144420113295096351049038200999075181212491506452\
99807115240440931306833516814584000\ x\^26)\)/
            509444775958620608741176020594451646891343503443569075061355030320\
007384544610631818411500256469083748099314961111876745366160104324649773411799\
049985868133696301901748302785727822158782913156845509487463348653481882208871\
675639407575625337493908221836170984501712117072748049612126422538630030174060\
55278994754778569 - 
          \((54195909658050371688724930356588400081645588722189741461259627891\
558984304835195252152795298387027955048607347319687701824363331371724706958086\
159811223545539643129362583275122522187164495928107066079751556939069196826249\
374299923415579800378205950533179028361177040101042078450708890982897547276131\
3263393071187394100330761280000\ x\^27)\)/
            509444775958620608741176020594451646891343503443569075061355030320\
007384544610631818411500256469083748099314961111876745366160104324649773411799\
049985868133696301901748302785727822158782913156845509487463348653481882208871\
675639407575625337493908221836170984501712117072748049612126422538630030174060\
55278994754778569 + 
          \((44694897960200326536915490707115133747949704635502841029752883768\
744208198135064892477971897721642562198657760880839633961984565863261327369547\
058946688892238432415557498497045607697984672425670331792003415851640196543752\
488515306674165435082146478723510595830878189251900087193912516419315878715279\
826998093934965464721285500\ x\^28)\)/
            509444775958620608741176020594451646891343503443569075061355030320\
007384544610631818411500256469083748099314961111876745366160104324649773411799\
049985868133696301901748302785727822158782913156845509487463348653481882208871\
675639407575625337493908221836170984501712117072748049612126422538630030174060\
55278994754778569 - 
          \((22344192309096191256033350799386406205065221020695230172489129933\
162660432883924614764202660237583585433810004444876763149796932885009672737569\
375111966786343984754712725998013054829964904460952089883649139815206717754680\
642509936505747307148904785639969860092055281088680702419505686902531240787376\
52453516427707005292000\ x\^29)\)/
            509444775958620608741176020594451646891343503443569075061355030320\
007384544610631818411500256469083748099314961111876745366160104324649773411799\
049985868133696301901748302785727822158782913156845509487463348653481882208871\
675639407575625337493908221836170984501712117072748049612126422538630030174060\
55278994754778569 + x\^30\)}],
      SequenceForm[ "dorthpoly[", 1, ",", 30, ",", x, ",", 
        DirectedInfinity[ 1], "]=", 
        Plus[ 
          Rational[ 
          25530117371183901871427414398079693809582510922467443548923849277211\
088559732141990128074062303665090996031674952031238391637461019874697000900863\
130537921692114347896857671867578901264360826145506063453156808303195848178547\
646972410992196222536749067700571211265264354979295083203008339733296641165965\
387978022074871816462955364967355418560398850201610835434719538176600309760000\
0000000000, 
            141120436553634517656835462768546162573779363834783677302314412831\
026976328146989423382687051653485802797594172053151453010016649397409909532354\
307475309732325845402146344261974465971962025805220362738909514862460355182512\
929540002098511173821027208264867308726236043510456523438262166908207764591152\
507698046412129], 
          Times[ 
            Rational[
             -1436530722233956390054372069265493880512683993827080116794223078\
879386132854608897897639962639016650091115296628382334734492331802019920792396\
470033590693645591008041450636913251592715399072510064378065657804910426166698\
476008991064911271331364866954741283777378601905285171022976894039044510805062\
819710778931323449477904471080290253489318464836035106803753089359190933110784\
000000000000000, 
              1411204365536345176568354627685461625737793638347836773023144128\
310269763281469894233826870516534858027975941720531514530100166493974099095323\
543074753097323258454021463442619744659719620258052203627389095148624603551825\
129295400020985111738210272082648673087262360435104565234382621669082077645911\
52507698046412129], x], 
          Times[ 
            Rational[ 
            117071762674911394949721286772081577224325293996003669494587550459\
827514911841411572355946626000489346283301652904970937539277881101042643679542\
501539672562310664012743651024103991872796391943512889456744503579864238547757\
154180503216835670293859196251859606802353313938914496615180834212850981123319\
588733020315564493544268170770423245692487208218415487088864990540897189888000\
0000000000000, 
              1411204365536345176568354627685461625737793638347836773023144128\
310269763281469894233826870516534858027975941720531514530100166493974099095323\
543074753097323258454021463442619744659719620258052203627389095148624603551825\
129295400020985111738210272082648673087262360435104565234382621669082077645911\
52507698046412129], 
            Power[ x, 2]], 
          Times[ 
            Rational[
             -3185971408525519263582219441403153958813215456068638418580095864\
664136263198375996782176277795409931459467501715092837940647926565138935565180\
630564483451103437084627365967723339363458100816481917798229548764153036983025\
198550400279619838908397646285630120734154270208484405806614015612370731839602\
679063540209182378700926362142105670717793430060845207887382987175503572500480\
00000000000000, 
              1411204365536345176568354627685461625737793638347836773023144128\
310269763281469894233826870516534858027975941720531514530100166493974099095323\
543074753097323258454021463442619744659719620258052203627389095148624603551825\
129295400020985111738210272082648673087262360435104565234382621669082077645911\
52507698046412129], 
            Power[ x, 3]], 
          Times[ 
            Rational[ 
            396321939757456400788821537219831650139268765036620086052160146360\
273718608455389532073893276745699886262230019808557855033925861281351785617410\
567120030779171821909797398641407800790745986141554225298461998937742550029449\
262501456666393768775806915504822627409131092302899328486099709416325189418453\
328300919399006562580043909591821192978787059159350944789539105215002705920000\
00000000000, 
              1411204365536345176568354627685461625737793638347836773023144128\
310269763281469894233826870516534858027975941720531514530100166493974099095323\
543074753097323258454021463442619744659719620258052203627389095148624603551825\
129295400020985111738210272082648673087262360435104565234382621669082077645911\
52507698046412129], 
            Power[ x, 4]], 
          Times[ 
            Rational[
             -2663314032334804260463658978228405195892536015857353710099519770\
797551510411328490531790699217234277749912594693706795139977322258326818571750\
445944854775629652622004781499858378936858041024502539852092078900349996499234\
041087884388757996984955689734657237377366266968649810306919879637730148972922\
278304615065282841627717063453716912311323484026938643026879179287756258934784\
000000000000, 
              1411204365536345176568354627685461625737793638347836773023144128\
310269763281469894233826870516534858027975941720531514530100166493974099095323\
543074753097323258454021463442619744659719620258052203627389095148624603551825\
129295400020985111738210272082648673087262360435104565234382621669082077645911\
52507698046412129], 
            Power[ x, 5]], 
          Times[ 
            Rational[ 
            107268305350309352680337875726377857260845233349624202268758588223\
565407003329106587968385641343269486106039190768118326874142154492487776299132\
700463634204937402554362327707776827043358716431472998945659769846913591487662\
363256716838398544818280368269860797735653247346149151589757751908102999144443\
992254841811927917100528596644489433831934492036679088884937721931156684800000\
000000000, 
              1411204365536345176568354627685461625737793638347836773023144128\
310269763281469894233826870516534858027975941720531514530100166493974099095323\
543074753097323258454021463442619744659719620258052203627389095148624603551825\
129295400020985111738210272082648673087262360435104565234382621669082077645911\
52507698046412129], 
            Power[ x, 6]], 
          Times[ 
            Rational[
             -2779036456519515401999001516811133272376362143849665175679394488\
635536171200310239881977040147125780913449005258934462551866817210253896018479\
365825494242678082323766660336436442525410633957244364316230098070271810432229\
412513360918584111710385680844271752653669105231350022672047520686276953801111\
822644871803153516226262919775086555561701725665745133006165011767230464000000\
000000000, 
              1411204365536345176568354627685461625737793638347836773023144128\
310269763281469894233826870516534858027975941720531514530100166493974099095323\
543074753097323258454021463442619744659719620258052203627389095148624603551825\
129295400020985111738210272082648673087262360435104565234382621669082077645911\
52507698046412129], 
            Power[ x, 7]], 
          Times[ 
            Rational[ 
            487359743823441321967802086368499812797735280920580719754208752415\
297476359492036082723972722269856821933792400941142152632421537312422825900915\
698589072749335096852378518280258766119871075084162111460844658156593813383950\
744826697716382662081554869016324404251815526248211611359237695919427502273931\
044477039226620413368563845759700561930107015363288829840108149538816000000000\
00000, 14112043655363451765683546276854616257377936383478367730231441283102697\
632814698942338268705165348580279759417205315145301001664939740990953235430747\
530973232584540214634426197446597196202580522036273890951486246035518251292954\
000209851117382102720826486730872623604351045652343826216690820776459115250769\
8046412129], 
            Power[ x, 8]], 
          Times[ 
            Rational[
             -6011649289172429655239105985928117155405237189496395184837793496\
158176208420277858542971915325770993809010351411736569477654728602473671584229\
730540892707472697564182726479317187068215022245033176835258841963808290218715\
830316528689131419619461244987215584195376700742857506139108878959335634319446\
984989227844725368959291241237293867178482891752829875123845075042304000000000\
00000, 14112043655363451765683546276854616257377936383478367730231441283102697\
632814698942338268705165348580279759417205315145301001664939740990953235430747\
530973232584540214634426197446597196202580522036273890951486246035518251292954\
000209851117382102720826486730872623604351045652343826216690820776459115250769\
8046412129], 
            Power[ x, 9]], 
          Times[ 
            Rational[ 
            537290721764822740513874922025800385741478595641401134783507288589\
015782364217936519161403627995588323095218564602292896069548687500938040676624\
416370274374836595960024713370471697602547912246454884335458234866261575144507\
270096623146742545369441073257613485343294572505772607706273118920418467061558\
284458877519182436366877960158818710811899553519692227001467105443840000000000\
0, 141120436553634517656835462768546162573779363834783677302314412831026976328\
146989423382687051653485802797594172053151453010016649397409909532354307475309\
732325845402146344261974465971962025805220362738909514862460355182512929540002\
098511173821027208264867308726236043510456523438262166908207764591152507698046\
412129], 
            Power[ x, 10]], 
          Times[ 
            Rational[
             -3561744134039777168993471967452990595431292181359027051768798366\
695041137264562215263413884676709414746835274433917439541960225350049989111938\
483155988834185112002520006683116591031472897675618872154373180983825323459031\
301779728146182150545837405644210929037138640129355266489999045426534708705961\
362112401580295494459547405059896537929649318225648853622892947046400000000000\
0, 141120436553634517656835462768546162573779363834783677302314412831026976328\
146989423382687051653485802797594172053151453010016649397409909532354307475309\
732325845402146344261974465971962025805220362738909514862460355182512929540002\
098511173821027208264867308726236043510456523438262166908207764591152507698046\
412129], 
            Power[ x, 11]], 
          Times[ 
            Rational[ 
            178435092020321699761463796053799142658039899957836307381463484656\
278387395459727793238469343806376965819669431352960473316220997645893545428975\
397588537517454158997860016094075151010954196179847416538407661163016225905758\
520662750250653242521736769861362812570943181558669610171927978073488820289667\
830308797099429070949460021321597857923141973640540078981775360000000000000, 
              1411204365536345176568354627685461625737793638347836773023144128\
310269763281469894233826870516534858027975941720531514530100166493974099095323\
543074753097323258454021463442619744659719620258052203627389095148624603551825\
129295400020985111738210272082648673087262360435104565234382621669082077645911\
52507698046412129], 
            Power[ x, 12]], 
          Times[ 
            Rational[
             -6858047097908687620385513316515150802682596049483219199267976929\
546217397434331847762521723337658172952151727405646978200862905992786584760209\
497544850589909514119595392232967302187749655512731705817407401694394509320379\
895936509995337601142700746347654297758908056925645890493717957396811256670569\
00390537882197830607406010272928958210388795144242327839571968000000000000, 
              1411204365536345176568354627685461625737793638347836773023144128\
310269763281469894233826870516534858027975941720531514530100166493974099095323\
543074753097323258454021463442619744659719620258052203627389095148624603551825\
129295400020985111738210272082648673087262360435104565234382621669082077645911\
52507698046412129], 
            Power[ x, 13]], 
          Times[ 
            Rational[ 
            204682933347712613201093345026002428619894743439537179770065508846\
878380458781615616405868937973219884409044223884699158649792975067470868358153\
062599541189095395827831919037417012841486125295460681899174542606014072562765\
060851471311073479340200736436719639057646274238394721441992113535998009129663\
5538870227994150471481688081456762984855809822347368333312000000000000, 
              1411204365536345176568354627685461625737793638347836773023144128\
310269763281469894233826870516534858027975941720531514530100166493974099095323\
543074753097323258454021463442619744659719620258052203627389095148624603551825\
129295400020985111738210272082648673087262360435104565234382621669082077645911\
52507698046412129], 
            Power[ x, 14]], 
          Times[ 
            Rational[
             -4789761163764048463473272110550657518376126932710769158120949516\
235519289822838783554574695460816090275608567191594596881871673480871439329825\
842492463327409945865310690925637972514089947056075602564431634052058285889108\
037155329748356840215625713740330449620364312390514766854814472425409165653667\
652236851058157720281014744328259591389661899606154398400512000000000, 
              1411204365536345176568354627685461625737793638347836773023144128\
310269763281469894233826870516534858027975941720531514530100166493974099095323\
543074753097323258454021463442619744659719620258052203627389095148624603551825\
129295400020985111738210272082648673087262360435104565234382621669082077645911\
52507698046412129], 
            Power[ x, 15]], 
          Times[ 
            Rational[ 
            885447652941441390327702623027576223740378623491319565575530415509\
047082414381612044576488975815669673032759917567199721729301365540056659736244\
457437080264666879245639580413714245162585937986020529462897642609433202223118\
219115804081268881874636366516876923840133033206902933801862439131523758510493\
8886310090421392237025202820875522048917256015922749440000000000, 
              1411204365536345176568354627685461625737793638347836773023144128\
310269763281469894233826870516534858027975941720531514530100166493974099095323\
543074753097323258454021463442619744659719620258052203627389095148624603551825\
129295400020985111738210272082648673087262360435104565234382621669082077645911\
52507698046412129], 
            Power[ x, 16]], 
          Times[ 
            Rational[
             -1300357049320338587698398780004654257876262443115353410369786766\
003600091429569265772606706745610763201621382072802510623807440813451213318924\
548435372470918114442678573423030426984462098933456141496563564742127251082458\
143775580531753139211092978030514342262672694166908610875906908255818409497443\
6534091824445024620421655283529657490204802926903296000000000000, 
              1411204365536345176568354627685461625737793638347836773023144128\
310269763281469894233826870516534858027975941720531514530100166493974099095323\
543074753097323258454021463442619744659719620258052203627389095148624603551825\
129295400020985111738210272082648673087262360435104565234382621669082077645911\
52507698046412129], 
            Power[ x, 17]], 
          Times[ 
            Rational[ 
            152287801543050061076891068270617722339470517655312887962501851246\
670436794364765707695859718544224381646480220389043966395002838976271827674120\
135953375205550764451368497144066533906613890811236721541586669543469293686628\
960696271054487349914103903045754880134788090532944549847148446787824861719133\
35549798150866910539125197467172966422006139054080000000000, 
              1411204365536345176568354627685461625737793638347836773023144128\
310269763281469894233826870516534858027975941720531514530100166493974099095323\
543074753097323258454021463442619744659719620258052203627389095148624603551825\
129295400020985111738210272082648673087262360435104565234382621669082077645911\
52507698046412129], 
            Power[ x, 18]], 
          Times[ 
            Rational[
             -5144687529588644387572919445524572980824374095268939776436539257\
796906579844716477939279249294266995558347687507292147766266271183719447942588\
302708247947152888585617998922152661861526041469298002950538150520475721856101\
288624414351287547344360850958455035358478143292086870618104089800428254558341\
962544725129944875828832652898599047503589258117120000000000, 
              5094447759586206087411760205944516468913435034435690750613550303\
200073845446106318184115002564690837480993149611118767453661601043246497734117\
990499858681336963019017483027857278221587829131568455094874633486534818822088\
716756394075756253374939082218361709845017121170727480496121264225386300301740\
6055278994754778569], 
            Power[ x, 19]], 
          Times[ 
            Rational[ 
            384778850353457252062513907968533907460624825796022031153204532492\
047193560589197172410275464021803820146666227356780011845304950009854261739660\
130284815522202571623672623784965094883504615465583996677638877560129113261957\
821314982360928869885714405563996049005345795573959335581119873946143471725733\
9382735264276982123019477537787620886008324633600000000, 
              5094447759586206087411760205944516468913435034435690750613550303\
200073845446106318184115002564690837480993149611118767453661601043246497734117\
990499858681336963019017483027857278221587829131568455094874633486534818822088\
716756394075756253374939082218361709845017121170727480496121264225386300301740\
6055278994754778569], 
            Power[ x, 20]], 
          Times[ 
            Rational[
             -2295792964701379310785250357053513090628632293988842032340414609\
377697851234760353075973795033229501474862757663198196106490783875918599867695\
320042445448400835478275998664996454257289030213339078883375736737170508864219\
739745675285060092143541672635368804890509339768092532206243936473005124176174\
961431844095908391507153914512270315266620416000000000, 
              5094447759586206087411760205944516468913435034435690750613550303\
200073845446106318184115002564690837480993149611118767453661601043246497734117\
990499858681336963019017483027857278221587829131568455094874633486534818822088\
716756394075756253374939082218361709845017121170727480496121264225386300301740\
6055278994754778569], 
            Power[ x, 21]], 
          Times[ 
            Rational[ 
            108819970042682226984545358599847932855103677715057680896177339043\
593024390660505657087671103155853929543997403267675053348045354846729851903709\
133406263953819131985682544037330379002890478366514796997104916588218492759334\
682364847226272614789885081874890733410065652135707742832189373619109181638345\
8335253698185126796562463829261805973472000000000, 
              5094447759586206087411760205944516468913435034435690750613550303\
200073845446106318184115002564690837480993149611118767453661601043246497734117\
990499858681336963019017483027857278221587829131568455094874633486534818822088\
716756394075756253374939082218361709845017121170727480496121264225386300301740\
6055278994754778569], 
            Power[ x, 22]], 
          Times[ 
            Rational[
             -4068832120034403482919418396022359203395812801513600215280789092\
046798745328870621244972961732188762475754501247140826450452830898772485791211\
183959002422255471782622656908826856034023256709974205230192410546718440872261\
914211498256928583054323710623667856736596217260432307319017475543054010505521\
58355850629908168414026883707165017600000000000, 
              5094447759586206087411760205944516468913435034435690750613550303\
200073845446106318184115002564690837480993149611118767453661601043246497734117\
990499858681336963019017483027857278221587829131568455094874633486534818822088\
716756394075756253374939082218361709845017121170727480496121264225386300301740\
6055278994754778569], 
            Power[ x, 23]], 
          Times[ 
            Rational[ 
            118715482730148595647630473675614791145840967074402305665688142943\
553280899145354419295411572255788255121237780142716031881691697952266743538100\
051490105454047342880653540980199447241585884580902270921477777207121019395718\
234604674781835578845081019256136288280248564122460903632648555033086901915935\
789578838084988270681792349837376500000000, 
              5094447759586206087411760205944516468913435034435690750613550303\
200073845446106318184115002564690837480993149611118767453661601043246497734117\
990499858681336963019017483027857278221587829131568455094874633486534818822088\
716756394075756253374939082218361709845017121170727480496121264225386300301740\
6055278994754778569], 
            Power[ x, 24]], 
          Times[ 
            Rational[
             -2659656148907153508631321765917795226092650300156884543896041884\
831830003152812840092030078900645615104672510013608554843085307022823953956172\
484830030834578432347291822664266610364341182118341081068299364118333318215191\
384153590478288131820581469664447815450677830754765354821189271469511291414706\
8767189684280142613444961473889788825600, 
              5094447759586206087411760205944516468913435034435690750613550303\
200073845446106318184115002564690837480993149611118767453661601043246497734117\
990499858681336963019017483027857278221587829131568455094874633486534818822088\
716756394075756253374939082218361709845017121170727480496121264225386300301740\
6055278994754778569], 
            Power[ x, 25]], 
          Times[ 
            Rational[ 
            446680652492620251459937876378593933327032283644409684098613682678\
560266681143892449742683544575698041090089361528884816252774644936630125324885\
752232288736430483278692122001786719739063555351838395165832436386246077618162\
685082793314804380807193187591444201132950963510490382009990751812124915064529\
9807115240440931306833516814584000, 
              
              5094447759586206087411760205944516468913435034435690750613550303\
200073845446106318184115002564690837480993149611118767453661601043246497734117\
990499858681336963019017483027857278221587829131568455094874633486534818822088\
716756394075756253374939082218361709845017121170727480496121264225386300301740\
6055278994754778569], 
            Power[ x, 26]], 
          Times[ 
            Rational[
             -5419590965805037168872493035658840008164558872218974146125962789\
155898430483519525215279529838702795504860734731968770182436333137172470695808\
615981122354553964312936258327512252218716449592810706607975155693906919682624\
937429992341557980037820595053317902836117704010104207845070889098289754727613\
13263393071187394100330761280000, 
              5094447759586206087411760205944516468913435034435690750613550303\
200073845446106318184115002564690837480993149611118767453661601043246497734117\
990499858681336963019017483027857278221587829131568455094874633486534818822088\
716756394075756253374939082218361709845017121170727480496121264225386300301740\
6055278994754778569], 
            Power[ x, 27]], 
          Times[ 
            Rational[ 
            446948979602003265369154907071151337479497046355028410297528837687\
442081981350648924779718977216425621986577608808396339619845658632613273695470\
589466888922384324155574984970456076979846724256703317920034158516401965437524\
885153066741654350821464787235105958308781892519000871939125164193158787152798\
26998093934965464721285500, 
              5094447759586206087411760205944516468913435034435690750613550303\
200073845446106318184115002564690837480993149611118767453661601043246497734117\
990499858681336963019017483027857278221587829131568455094874633486534818822088\
716756394075756253374939082218361709845017121170727480496121264225386300301740\
6055278994754778569], 
            Power[ x, 28]], 
          Times[ 
            Rational[
             -2234419230909619125603335079938640620506522102069523017248912993\
316266043288392461476420266023758358543381000444487676314979693288500967273756\
937511196678634398475471272599801305482996490446095208988364913981520671775468\
064250993650574730714890478563996986009205528108868070241950568690253124078737\
652453516427707005292000, 
              5094447759586206087411760205944516468913435034435690750613550303\
200073845446106318184115002564690837480993149611118767453661601043246497734117\
990499858681336963019017483027857278221587829131568455094874633486534818822088\
716756394075756253374939082218361709845017121170727480496121264225386300301740\
6055278994754778569], 
            Power[ x, 29]], 
          Power[ x, 30]]],
      Editable->False]], "Print"],

Cell[BoxData[
    \({13.6166666666666746`\ Second, Null}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(MemoryInUse[]\)], "Input"],

Cell[BoxData[
    \(1356416\)], "Output"]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["\<\
Computing the recurrence coefficients and the orthogonal \
polynomials performing numerical computations with the machine precision\
\>",
   "Section",
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell["\<\
Loading the package chv.m, the package datachv1.m is automatically \
loaded \
\>", "Subsection"],

Cell[BoxData[
    \(\(<< chebyshev`chv`\ ; \)\)], "Input"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Computing the gamma coefficients", "Subsection"],

Cell[BoxData[
    \(\( (*\ set\ the\ values\ of\ d\ and\ nmax\ *) \nd = 1; \ nmax = \ 30; 
    \ \ \ \ \  (*\ for\ example\ *) \)\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(MemoryInUse[]\)], "Input"],

Cell[BoxData[
    \(949328\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Timing[printgamma[d,nmax,$MachinePrecision,$MachinePrecision,False]]\
\
\>", "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    \("   "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gamma["\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["3.`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gamma[", 1, ",", 0, ",", 1, "]=", 3.0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gamma["\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["72.8888888888888875`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gamma[", 1, ",", 0, ",", 2, "]=", 72.888888888888886],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gamma["\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["410.685901249256435`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gamma[", 1, ",", 0, ",", 3, "]=", 410.6859012492564],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gamma["\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "4", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["1363.47149058495409`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gamma[", 1, ",", 0, ",", 4, "]=", 1363.4714905849539],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gamma["\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "5", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["3424.42122813809124`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gamma[", 1, ",", 0, ",", 5, "]=", 3424.421228138091],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gamma["\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "6", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["7232.81461464269703`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gamma[", 1, ",", 0, ",", 6, "]=", 7232.814614642698],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gamma["\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "7", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["13574.0387675953178`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gamma[", 1, ",", 0, ",", 7, "]=", 13574.038767595317],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gamma["\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "8", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["23379.590330362765`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gamma[", 1, ",", 0, ",", 8, "]=", 23379.590330362764],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gamma["\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "9", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["37727.0765929188067`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gamma[", 1, ",", 0, ",", 9, "]=", 37727.076592918813],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gamma["\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "10", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["57840.216209976436`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gamma[", 1, ",", 0, ",", 10, "]=", 57840.216209976446],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gamma["\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "11", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["85088.8397055889456`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gamma[", 1, ",", 0, ",", 11, "]=", 85088.839705588951],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gamma["\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "12", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["120988.88984010141`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gamma[", 1, ",", 0, ",", 12, "]=", 120988.88984010142],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gamma["\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "13", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["167202.421523616422`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gamma[", 1, ",", 0, ",", 13, "]=", 167202.42152361642],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gamma["\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "14", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["225537.600528121195`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gamma[", 1, ",", 0, ",", 14, "]=", 225537.6005281212],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gamma["\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "15", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["297948.700149969525`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gamma[", 1, ",", 0, ",", 15, "]=", 297948.70014996955],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gamma["\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "16", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["386536.026762098714`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gamma[", 1, ",", 0, ",", 16, "]=", 386536.02676209871],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gamma["\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "17", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["493544.510954739035`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gamma[", 1, ",", 0, ",", 17, "]=", 493544.510954739],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gamma["\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "18", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["621346.087156382953`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gamma[", 1, ",", 0, ",", 18, "]=", 621346.08715638297],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gamma["\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "19", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["772272.08895048891`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gamma[", 1, ",", 0, ",", 19, "]=", 772272.08895048895],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gamma["\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "20", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["947322.559691572685`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gamma[", 1, ",", 0, ",", 20, "]=", 947322.55969157268],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gamma["\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "21", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["1.1375849074990969`*^6",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gamma[", 1, ",", 0, ",", 21, "]=", 1137584.9074990968],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gamma["\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "22", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["1.26883582708365838`*^6",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gamma[", 1, ",", 0, ",", 22, "]=", 1268835.8270836584],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gamma["\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "23", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["712140.827816452492`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gamma[", 1, ",", 0, ",", 23, "]=", 712140.82781645248],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gamma["\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "24", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        RowBox[{"-", 
          StyleBox["3.61802092602596792`*^7",
            StyleBoxAutoDelete->True,
            PrintPrecision->16]}]}],
      SequenceForm[ "gamma[", 1, ",", 0, ",", 24, "]=", -36180209.26025968],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gamma["\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "25", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        RowBox[{"-", 
          StyleBox["2.08953312366105947`*^6",
            StyleBoxAutoDelete->True,
            PrintPrecision->16]}]}],
      SequenceForm[ "gamma[", 1, ",", 0, ",", 25, "]=", -2089533.1236610597],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gamma["\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "26", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["1.85446748068387705`*^6",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gamma[", 1, ",", 0, ",", 26, "]=", 1854467.4806838769],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gamma["\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "27", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["5.36233399874974558`*^6",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gamma[", 1, ",", 0, ",", 27, "]=", 5362333.9987497451],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gamma["\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "28", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["1.3289346940394433`*^7",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gamma[", 1, ",", 0, ",", 28, "]=", 13289346.940394433],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gamma["\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "29", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        RowBox[{"-", 
          StyleBox["1.2781135424284491`*^7",
            StyleBoxAutoDelete->True,
            PrintPrecision->16]}]}],
      SequenceForm[ "gamma[", 1, ",", 0, ",", 29, "]=", -12781135.424284492],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gamma["\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "30", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        RowBox[{"-", 
          StyleBox["1.47865051530787949`*^7",
            StyleBoxAutoDelete->True,
            PrintPrecision->16]}]}],
      SequenceForm[ "gamma[", 1, ",", 0, ",", 30, "]=", -14786505.153078794],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    \({6.01666666666666571`\ Second, Null}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(MemoryInUse[]\)], "Input"],

Cell[BoxData[
    \(1123624\)], "Output"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Computing the beta coefficients", "Subsection"],

Cell[BoxData[
    \(\( (*\ set\ the\ values\ of\ d\ and\ nmax\ *) \nd = 1; \ 
    nmax = \ 30\ \ ; \ \ \  (*\ for\ example\ *) \)\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(MemoryInUse[]\)], "Input"],

Cell[BoxData[
    \(1126208\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Timing[printbeta[d,nmax,$MachinePrecision,$MachinePrecision,False]]\
\
\>", "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("beta["\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["1.`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "beta[", 1, ",", 0, "]=", 1.0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("beta["\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["9.66666666666666607`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "beta[", 1, ",", 1, "]=", 9.6666666666666661],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("beta["\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["28.1869918699186996`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "beta[", 1, ",", 2, "]=", 28.1869918699187],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("beta["\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["56.571895845674387`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "beta[", 1, ",", 3, "]=", 56.571895845674391],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("beta["\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "4", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["94.8239327378010621`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "beta[", 1, ",", 4, "]=", 94.823932737801059],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("beta["\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "5", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["142.944102307781362`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "beta[", 1, ",", 5, "]=", 142.94410230778138],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("beta["\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "6", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["200.932899132742681`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "beta[", 1, ",", 6, "]=", 200.9328991327427],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("beta["\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "7", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["268.790604079351691`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "beta[", 1, ",", 7, "]=", 268.79060407935168],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("beta["\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "8", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["346.517391996160295`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "beta[", 1, ",", 8, "]=", 346.51739199616031],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("beta["\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "9", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["434.113379134674381`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "beta[", 1, ",", 9, "]=", 434.11337913467435],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("beta["\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "10", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["531.578646682945787`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "beta[", 1, ",", 10, "]=", 531.57864668294576],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("beta["\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "11", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["638.913253476144848`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "beta[", 1, ",", 11, "]=", 638.91325347614486],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("beta["\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "12", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["756.117243708955477`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "beta[", 1, ",", 12, "]=", 756.11724370895547],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("beta["\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "13", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["883.190653461024233`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "beta[", 1, ",", 13, "]=", 883.19065346102423],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("beta["\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "14", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["1020.13351677636476`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "beta[", 1, ",", 14, "]=", 1020.1335167763648],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("beta["\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "15", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["1166.94589021324257`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "beta[", 1, ",", 15, "]=", 1166.9458902132426],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("beta["\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "16", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["1323.62838687533423`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "beta[", 1, ",", 16, "]=", 1323.6283868753344],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("beta["\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "17", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["1490.18918585539639`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "beta[", 1, ",", 17, "]=", 1490.1891858553963],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("beta["\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "18", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["1666.71084154824145`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "beta[", 1, ",", 18, "]=", 1666.7108415482414],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("beta["\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "19", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["1853.85512854306639`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "beta[", 1, ",", 19, "]=", 1853.8551285430665],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("beta["\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "20", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["2056.06988370358667`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "beta[", 1, ",", 20, "]=", 2056.069883703587],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("beta["\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "21", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["2300.41560730783256`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "beta[", 1, ",", 21, "]=", 2300.4156073078325],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("beta["\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "22", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["2768.01505965314165`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "beta[", 1, ",", 22, "]=", 2768.0150596531416],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("beta["\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "23", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["7395.71036308525187`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "beta[", 1, ",", 23, "]=", 7395.7103630852516],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("beta["\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "24", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        RowBox[{"-", 
          StyleBox["5913.93626379390102`",
            StyleBoxAutoDelete->True,
            PrintPrecision->16]}]}],
      SequenceForm[ "beta[", 1, ",", 24, "]=", -5913.9362637939003],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("beta["\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "25", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["4085.71018089592286`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "beta[", 1, ",", 25, "]=", 4085.7101808959228],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("beta["\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "26", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["3480.27154348979284`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "beta[", 1, ",", 26, "]=", 3480.2715434897923],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("beta["\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "27", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        RowBox[{"-", 
          StyleBox["662.334098384508962`",
            StyleBoxAutoDelete->True,
            PrintPrecision->16]}]}],
      SequenceForm[ "beta[", 1, ",", 27, "]=", -662.33409838450893],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("beta["\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "28", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["4656.76271078888781`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "beta[", 1, ",", 28, "]=", 4656.7627107888875],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("beta["\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "29", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        RowBox[{"-", 
          StyleBox["3926.1773947613916`",
            StyleBoxAutoDelete->True,
            PrintPrecision->16]}]}],
      SequenceForm[ "beta[", 1, ",", 29, "]=", -3926.177394761392],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    \({8.33333333333332859`\ Second, Null}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(MemoryInUse[]\)], "Input"],

Cell[BoxData[
    \(1128696\)], "Output"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Computing the d-orthogonal polynomials", "Subsection"],

Cell[BoxData[
    \(\( (*\ set\ the\ values\ of\ d\ and\ nmax\ *) \nd = 1; \ nmax = \ 30; 
    \ \ \ \ \  (*\ for\ example\ *) \)\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(MemoryInUse[]\)], "Input"],

Cell[BoxData[
    \(1130480\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Timing[printdorthpoly[d,nmax,x,$MachinePrecision]]", "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("dorthpoly["\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "x", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["1.`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "dorthpoly[", 1, ",", 0, ",", x, "]=", 1.0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("dorthpoly["\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "x", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        RowBox[{
          RowBox[{"-", 
            StyleBox["1.`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16]}], "+", "x"}]}],
      SequenceForm[ "dorthpoly[", 1, ",", 1, ",", x, "]=", 
        Plus[ -1.0, x]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("dorthpoly["\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "x", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        RowBox[{
          RowBox[{
            StyleBox["6.66666666666666607`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], "\[InvisibleSpace]"}], "-", 
          RowBox[{
            StyleBox["10.6666666666666665`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", "x"}], "+", \(x\^2\)}]}],
      SequenceForm[ "dorthpoly[", 1, ",", 2, ",", x, "]=", 
        Plus[ 6.6666666666666661, 
          Times[ -10.666666666666666, x], 
          Power[ x, 2]]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("dorthpoly["\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "x", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        RowBox[{
          RowBox[{"-", 
            StyleBox["115.024390243902407`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16]}], "+", 
          RowBox[{
            StyleBox["234.439024390243933`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", "x"}], "-", 
          RowBox[{
            StyleBox["38.8536585365853639`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^2\)}], "+", \(x\^3\)}]}],
      SequenceForm[ "dorthpoly[", 1, ",", 3, ",", x, "]=", 
        Plus[ -115.02439024390242, 
          Times[ 234.43902439024393, x], 
          Times[ -38.853658536585364, 
            Power[ x, 2]], 
          Power[ x, 3]]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("dorthpoly["\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "4", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "x", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        RowBox[{
          RowBox[{
            StyleBox["3769.24181626187726`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], "\[InvisibleSpace]"}], "-", 
          RowBox[{
            StyleBox["8997.03484688490107`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", "x"}], "+", 
          RowBox[{
            StyleBox["2021.77824709609232`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^2\)}], "-", 
          RowBox[{
            StyleBox["95.4255543822597473`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^3\)}], "+", \(x\^4\)}]}],
      SequenceForm[ "dorthpoly[", 1, ",", 4, ",", x, "]=", 
        Plus[ 3769.2418162618769, 
          Times[ -8997.0348468849006, x], 
          Times[ 2021.7782470960924, 
            Power[ x, 2]], 
          Times[ -95.425554382259747, 
            Power[ x, 3]], 
          Power[ x, 4]]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("dorthpoly["\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "x", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        RowBox[{
          RowBox[{"-", 
            StyleBox["200581.855638244288`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16]}], "+", 
          RowBox[{
            StyleBox["537252.542940279731`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", "x"}], "-", 
          RowBox[{
            StyleBox["147734.143640717219`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^2\)}], "+", 
          RowBox[{
            StyleBox["9706.93310672191422`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^3\)}], "-", 
          RowBox[{
            StyleBox["190.249487120060791`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^4\)}], "+", \(x\^5\)}]}],
      SequenceForm[ "dorthpoly[", 1, ",", 5, ",", x, "]=", 
        Plus[ -200581.85563824428, 
          Times[ 537252.5429402797, x], 
          Times[ -147734.14364071723, 
            Power[ x, 2]], 
          Times[ 9706.9331067219136, 
            Power[ x, 3]], 
          Times[ -190.24948712006079, 
            Power[ x, 4]], 
          Power[ x, 5]]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("dorthpoly["\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "6", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "x", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        RowBox[{
          StyleBox["1.57645216038448783`*^7",
            StyleBoxAutoDelete->True,
            PrintPrecision->16], "-", 
          RowBox[{
            StyleBox["4.61880271988384993`*^7",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", "x"}], "+", 
          RowBox[{
            StyleBox["1.47315567379277574`*^7",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^2\)}], "-", 
          RowBox[{
            StyleBox["1.2085056886093084`*^6",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^3\)}], "+", 
          RowBox[{
            StyleBox["33477.5540294767282`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^4\)}], "-", 
          RowBox[{
            StyleBox["333.193589427842207`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^5\)}], "+", \(x\^6\)}]}],
      SequenceForm[ "dorthpoly[", 1, ",", 6, ",", x, "]=", 
        Plus[ 15764521.603844879, 
          Times[ -46188027.198838502, x], 
          Times[ 14731556.737927757, 
            Power[ x, 2]], 
          Times[ -1208505.6886093083, 
            Power[ x, 3]], 
          Times[ 33477.554029476727, 
            Power[ x, 4]], 
          Times[ -333.1935894278422, 
            Power[ x, 5]], 
          Power[ x, 6]]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("dorthpoly["\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "7", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "x", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        RowBox[{
          RowBox[{"-", 
            StyleBox["1.71683965240886093`*^9",
              StyleBoxAutoDelete->True,
              PrintPrecision->16]}], "+", 
          RowBox[{
            StyleBox["5.41061068755603091`*^9",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", "x"}], "-", 
          RowBox[{
            StyleBox["1.93770875808284976`*^9",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^2\)}], "+", 
          RowBox[{
            StyleBox["1.87351660730950371`*^8",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^3\)}], "-", 
          RowBox[{
            StyleBox["6.55920840475484645`*^6",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^4\)}], "+", 
          RowBox[{
            StyleBox["93194.2933110151194`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^5\)}], "-", 
          RowBox[{
            StyleBox["534.126488560584888`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^6\)}], "+", \(x\^7\)}]}],
      SequenceForm[ "dorthpoly[", 1, ",", 7, ",", x, "]=", 
        Plus[ -1716839652.4088612, 
          Times[ 5410610687.5560303, x], 
          Times[ -1937708758.08285, 
            Power[ x, 2]], 
          Times[ 187351660.73095036, 
            Power[ x, 3]], 
          Times[ -6559208.4047548464, 
            Power[ x, 4]], 
          Times[ 93194.293311015121, 
            Power[ x, 5]], 
          Times[ -534.1264885605849, 
            Power[ x, 6]], 
          Power[ x, 7]]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("dorthpoly["\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "8", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "x", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        RowBox[{
          StyleBox["2.47482139875177598`*^11",
            StyleBoxAutoDelete->True,
            PrintPrecision->16], "-", 
          RowBox[{
            StyleBox["8.29080083003009704`*^11",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", "x"}], "+", 
          RowBox[{
            StyleBox["3.26281796034834181`*^11",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^2\)}], "-", 
          RowBox[{
            StyleBox["3.58917717531825219`*^10",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^3\)}], "+", 
          RowBox[{
            StyleBox["1.49597963388698262`*^9",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^4\)}], "-", 
          RowBox[{
            StyleBox["2.70861761005631196`*^7",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^5\)}], "+", 
          RowBox[{
            StyleBox["223188.43605840235`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^6\)}], "-", 
          RowBox[{
            StyleBox["802.917092639936491`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^7\)}], "+", \(x\^8\)}]}],
      SequenceForm[ "dorthpoly[", 1, ",", 8, ",", x, "]=", 
        Plus[ 247482139875.17764, 
          Times[ -829080083003.00977, x], 
          Times[ 326281796034.83423, 
            Power[ x, 2]], 
          Times[ -35891771753.182526, 
            Power[ x, 3]], 
          Times[ 1495979633.8869824, 
            Power[ x, 4]], 
          Times[ -27086176.10056312, 
            Power[ x, 5]], 
          Times[ 223188.43605840235, 
            Power[ x, 6]], 
          Times[ -802.91709263993653, 
            Power[ x, 7]], 
          Power[ x, 8]]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("dorthpoly["\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "9", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "x", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        RowBox[{
          RowBox[{"-", 
            StyleBox["4.56178579389339411`*^13",
              StyleBoxAutoDelete->True,
              PrintPrecision->16]}], "+", 
          RowBox[{
            StyleBox["1.61040288945895859`*^14",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", "x"}], "-", 
          RowBox[{
            StyleBox["6.85885601572838687`*^13",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^2\)}], "+", 
          RowBox[{
            StyleBox["8.38319986246636617`*^12",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^3\)}], "-", 
          RowBox[{
            StyleBox["4.00923127572429827`*^11",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^4\)}], "+", 
          RowBox[{
            StyleBox["8.70296633666364094`*^9",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^5\)}], "-", 
          RowBox[{
            StyleBox["9.19371924000808249`*^7",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^6\)}], "+", 
          RowBox[{
            StyleBox["478033.582658769784`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^7\)}], "-", 
          RowBox[{
            StyleBox["1149.43448463609687`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^8\)}], "+", \(x\^9\)}]}],
      SequenceForm[ "dorthpoly[", 1, ",", 9, ",", x, "]=", 
        Plus[ -45617857938933.938, 
          Times[ 161040288945895.88, x], 
          Times[ -68588560157283.852, 
            Power[ x, 2]], 
          Times[ 8383199862466.3652, 
            Power[ x, 3]], 
          Times[ -400923127572.42987, 
            Power[ x, 4]], 
          Times[ 8702966336.663641, 
            Power[ x, 5]], 
          Times[ -91937192.40008083, 
            Power[ x, 6]], 
          Times[ 478033.5826587698, 
            Power[ x, 7]], 
          Times[ -1149.4344846360968, 
            Power[ x, 8]], 
          Power[ x, 9]]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("dorthpoly["\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "10", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "x", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        RowBox[{
          StyleBox["1.0466544812305869`*^16",
            StyleBoxAutoDelete->True,
            PrintPrecision->16], "-", 
          RowBox[{
            StyleBox["3.86765940759480955`*^16",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", "x"}], "+", 
          RowBox[{
            StyleBox["1.76265935989249777`*^16",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^2\)}], "-", 
          RowBox[{
            StyleBox["2.35375615842601826`*^15",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^3\)}], "+", 
          RowBox[{
            StyleBox["1.25990355317075186`*^14",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^4\)}], "-", 
          RowBox[{
            StyleBox["3.15711501212156919`*^12",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^5\)}], "+", 
          RowBox[{
            StyleBox["4.01938843757883201`*^10",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^6\)}], "-", 
          RowBox[{
            StyleBox["2.6916625165614354`*^8",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^7\)}], "+", 
          RowBox[{
            StyleBox["939291.394285149827`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^8\)}], "-", 
          RowBox[{
            StyleBox["1583.54786377077116`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^9\)}], "+", \(x\^10\)}]}],
      SequenceForm[ "dorthpoly[", 1, ",", 10, ",", x, "]=", 
        Plus[ 10466544812305870.0, 
          Times[ -38676594075948096.0, x], 
          Times[ 17626593598924976.0, 
            Power[ x, 2]], 
          Times[ -2353756158426018.0, 
            Power[ x, 3]], 
          Times[ 125990355317075.2, 
            Power[ x, 4]], 
          Times[ -3157115012121.5688, 
            Power[ x, 5]], 
          Times[ 40193884375.788322, 
            Power[ x, 6]], 
          Times[ -269166251.65614349, 
            Power[ x, 7]], 
          Times[ 939291.39428514987, 
            Power[ x, 8]], 
          Times[ -1583.5478637707711, 
            Power[ x, 9]], 
          Power[ x, 10]]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("dorthpoly["\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "11", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "x", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        RowBox[{
          RowBox[{"-", 
            StyleBox["2.92524496054803186`*^18",
              StyleBoxAutoDelete->True,
              PrintPrecision->16]}], "+", 
          RowBox[{
            StyleBox["1.12555129508627338`*^19",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", "x"}], "-", 
          RowBox[{
            StyleBox["5.44142021599448888`*^18",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^2\)}], "+", 
          RowBox[{
            StyleBox["7.83947014340177439`*^17",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^3\)}], "-", 
          RowBox[{
            StyleBox["4.6138058350611022`*^16",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^4\)}], "+", 
          RowBox[{
            StyleBox["1.3008638263022989`*^15",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^5\)}], "-", 
          RowBox[{
            StyleBox["1.92056585873750478`*^13",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^6\)}], "+", 
          RowBox[{
            StyleBox["1.55627350387269398`*^11",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^7\)}], "-", 
          RowBox[{
            StyleBox["7.01989960760626008`*^8",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^8\)}], "+", 
          RowBox[{
            StyleBox["1.72323140845610955`*^6",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^9\)}], "-", 
          RowBox[{
            StyleBox["2115.12651045371669`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^10\)}], "+", \(x\^11\)}]}],
      SequenceForm[ "dorthpoly[", 1, ",", 11, ",", x, "]=", 
        Plus[ -2.9252449605480315*^+18, 
          Times[ 1.1255512950862733*^+19, x], 
          Times[ -5.4414202159944888*^+18, 
            Power[ x, 2]], 
          Times[ 7.8394701434017741*^+17, 
            Power[ x, 3]], 
          Times[ -46138058350611024.0, 
            Power[ x, 4]], 
          Times[ 1300863826302299.0, 
            Power[ x, 5]], 
          Times[ -19205658587375.047, 
            Power[ x, 6]], 
          Times[ 155627350387.26941, 
            Power[ x, 7]], 
          Times[ -701989960.76062596, 
            Power[ x, 8]], 
          Times[ 1723231.4084561097, 
            Power[ x, 9]], 
          Times[ -2115.1265104537169, 
            Power[ x, 10]], 
          Power[ x, 11]]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("dorthpoly["\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "12", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "x", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        RowBox[{
          StyleBox["9.78391621152782064`*^20",
            StyleBoxAutoDelete->True,
            PrintPrecision->16], "-", 
          RowBox[{
            StyleBox["3.90327513025266128`*^21",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", "x"}], "+", 
          RowBox[{
            StyleBox["1.98802460938828069`*^21",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^2\)}], "-", 
          RowBox[{
            StyleBox["3.0603717723063295`*^20",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^3\)}], "+", 
          RowBox[{
            StyleBox["1.95417908361764673`*^19",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^4\)}], "-", 
          RowBox[{
            StyleBox["6.08641944744318852`*^17",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^5\)}], "+", 
          RowBox[{
            StyleBox["1.01515626547177228`*^16",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^6\)}], "-", 
          RowBox[{
            StyleBox["9.57349913118535056`*^13",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^7\)}], "+", 
          RowBox[{
            StyleBox["5.24214825239263859`*^11",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^8\)}], "-", 
          RowBox[{
            StyleBox["1.66824309608307919`*^9",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^9\)}], "+", 
          RowBox[{
            StyleBox["2.98952492905815034`*^6",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^10\)}], "-", 
          RowBox[{
            StyleBox["2754.03976392986171`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^11\)}], "+", \(x\^12\)}]}],
      SequenceForm[ "dorthpoly[", 1, ",", 12, ",", x, "]=", 
        Plus[ 9.7839162115278202*^+20, 
          Times[ -3.9032751302526616*^+21, x], 
          Times[ 1.9880246093882807*^+21, 
            Power[ x, 2]], 
          Times[ -3.0603717723063294*^+20, 
            Power[ x, 3]], 
          Times[ 1.954179083617647*^+19, 
            Power[ x, 4]], 
          Times[ -6.0864194474431885*^+17, 
            Power[ x, 5]], 
          Times[ 10151562654717724.0, 
            Power[ x, 6]], 
          Times[ -95734991311853.5, 
            Power[ x, 7]], 
          Times[ 524214825239.26385, 
            Power[ x, 8]], 
          Times[ -1668243096.0830793, 
            Power[ x, 9]], 
          Times[ 2989524.9290581504, 
            Power[ x, 10]], 
          Times[ -2754.0397639298617, 
            Power[ x, 11]], 
          Power[ x, 12]]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("dorthpoly["\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "13", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "x", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        RowBox[{
          RowBox[{"-", 
            StyleBox["3.85856635566920491`*^23",
              StyleBoxAutoDelete->True,
              PrintPrecision->16]}], "+", 
          RowBox[{
            StyleBox["1.59052000803974298`*^24",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", "x"}], "-", 
          RowBox[{
            StyleBox["8.48731572119834432`*^23",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^2\)}], "+", 
          RowBox[{
            StyleBox["1.38539132571003452`*^23",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^3\)}], "-", 
          RowBox[{
            StyleBox["9.49972974219906163`*^21",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^4\)}], "+", 
          RowBox[{
            StyleBox["3.22356390324447472`*^20",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^5\)}], "-", 
          RowBox[{
            StyleBox["5.96074220743373395`*^18",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^6\)}], "+", 
          RowBox[{
            StyleBox["6.3709260059824988`*^16",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^7\)}], "-", 
          RowBox[{
            StyleBox["4.07169874051812907`*^14",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^8\)}], "+", 
          RowBox[{
            StyleBox["1.57711034183939684`*^12",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^9\)}], "-", 
          RowBox[{
            StyleBox["3.67276763707057529`*^9",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^10\)}], "+", 
          RowBox[{
            StyleBox["4.95091299458555766`*^6",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^11\)}], "-", 
          RowBox[{
            StyleBox["3510.1570076388171`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^12\)}], "+", \(x\^13\)}]}],
      SequenceForm[ "dorthpoly[", 1, ",", 13, ",", x, "]=", 
        Plus[ -3.8585663556692049*^+23, 
          Times[ 1.5905200080397432*^+24, x], 
          Times[ -8.4873157211983442*^+23, 
            Power[ x, 2]], 
          Times[ 1.3853913257100345*^+23, 
            Power[ x, 3]], 
          Times[ -9.499729742199062*^+21, 
            Power[ x, 4]], 
          Times[ 3.2235639032444748*^+20, 
            Power[ x, 5]], 
          Times[ -5.9607422074337341*^+18, 
            Power[ x, 6]], 
          Times[ 63709260059824992.0, 
            Power[ x, 7]], 
          Times[ -407169874051813.0, 
            Power[ x, 8]], 
          Times[ 1577110341839.397, 
            Power[ x, 9]], 
          Times[ -3672767637.0705757, 
            Power[ x, 10]], 
          Times[ 4950912.9945855578, 
            Power[ x, 11]], 
          Times[ -3510.157007638817, 
            Power[ x, 12]], 
          Power[ x, 13]]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("dorthpoly["\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "14", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "x", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        RowBox[{
          StyleBox["1.77195525853458875`*^26",
            StyleBoxAutoDelete->True,
            PrintPrecision->16], "-", 
          RowBox[{
            StyleBox["7.52481208227866993`*^26",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", "x"}], "+", 
          RowBox[{
            StyleBox["4.18779783063296484`*^26",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^2\)}], "-", 
          RowBox[{
            StyleBox["7.20350414882138334`*^25",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^3\)}], "+", 
          RowBox[{
            StyleBox["5.26117690257019798`*^24",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^4\)}], "-", 
          RowBox[{
            StyleBox["1.92435473758091539`*^23",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^5\)}], "+", 
          RowBox[{
            StyleBox["3.88946233750303971`*^21",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^6\)}], "-", 
          RowBox[{
            StyleBox["4.62210428593046174`*^19",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^7\)}], "+", 
          RowBox[{
            StyleBox["3.3566789901470444`*^17",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^8\)}], "-", 
          RowBox[{
            StyleBox["1.52112470208594308`*^15",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^9\)}], "+", 
          RowBox[{
            StyleBox["4.32100858389052078`*^12",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^10\)}], "-", 
          RowBox[{
            StyleBox["7.58488560248586907`*^9",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^11\)}], "+", 
          RowBox[{
            StyleBox["7.88384843438926186`*^6",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^12\)}], "-", 
          RowBox[{
            StyleBox["4393.34766109984098`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^13\)}], "+", \(x\^14\)}]}],
      SequenceForm[ "dorthpoly[", 1, ",", 14, ",", x, "]=", 
        Plus[ 1.7719552585345888*^+26, 
          Times[ -7.5248120822786701*^+26, x], 
          Times[ 4.1877978306329657*^+26, 
            Power[ x, 2]], 
          Times[ -7.2035041488213835*^+25, 
            Power[ x, 3]], 
          Times[ 5.2611769025701976*^+24, 
            Power[ x, 4]], 
          Times[ -1.9243547375809156*^+23, 
            Power[ x, 5]], 
          Times[ 3.8894623375030396*^+21, 
            Power[ x, 6]], 
          Times[ -4.6221042859304616*^+19, 
            Power[ x, 7]], 
          Times[ 3.3566789901470438*^+17, 
            Power[ x, 8]], 
          Times[ -1521124702085943.2, 
            Power[ x, 9]], 
          Times[ 4321008583890.5205, 
            Power[ x, 10]], 
          Times[ -7584885602.4858694, 
            Power[ x, 11]], 
          Times[ 7883848.4343892615, 
            Power[ x, 12]], 
          Times[ -4393.3476610998414, 
            Power[ x, 13]], 
          Power[ x, 14]]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("dorthpoly["\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "15", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "x", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        RowBox[{
          RowBox[{"-", 
            StyleBox["9.37379152123093106`*^28",
              StyleBoxAutoDelete->True,
              PrintPrecision->16]}], "+", 
          RowBox[{
            StyleBox["4.09086430578223847`*^29",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", "x"}], "-", 
          RowBox[{
            StyleBox["2.36542891791064224`*^29",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^2\)}], "+", 
          RowBox[{
            StyleBox["4.26583564482548194`*^28",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^3\)}], "-", 
          RowBox[{
            StyleBox["3.29659168576852845`*^27",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^4\)}], "+", 
          RowBox[{
            StyleBox["1.28867566711255632`*^26",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^5\)}], "-", 
          RowBox[{
            StyleBox["2.81583487165298596`*^24",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^6\)}], "+", 
          RowBox[{
            StyleBox["3.66722636933215406`*^22",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^7\)}], "-", 
          RowBox[{
            StyleBox["2.96815000749125381`*^20",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^8\)}], "+", 
          RowBox[{
            StyleBox["1.53172050854249537`*^18",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^9\)}], "-", 
          RowBox[{
            StyleBox["5.10078318462880542`*^15",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^10\)}], "+", 
          RowBox[{
            StyleBox["1.09419875706785241`*^13",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^11\)}], "-", 
          RowBox[{
            StyleBox["1.48357912426113962`*^10",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^12\)}], "+", 
          RowBox[{
            StyleBox["1.21401120338001389`*^7",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^13\)}], "-", 
          RowBox[{
            StyleBox["5413.4811778762053`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^14\)}], "+", \(x\^15\)}]}],
      SequenceForm[ "dorthpoly[", 1, ",", 15, ",", x, "]=", 
        Plus[ -9.3737915212309318*^+28, 
          Times[ 4.0908643057822381*^+29, x], 
          Times[ -2.365428917910642*^+29, 
            Power[ x, 2]], 
          Times[ 4.2658356448254816*^+28, 
            Power[ x, 3]], 
          Times[ -3.2965916857685284*^+27, 
            Power[ x, 4]], 
          Times[ 1.2886756671125563*^+26, 
            Power[ x, 5]], 
          Times[ -2.8158348716529866*^+24, 
            Power[ x, 6]], 
          Times[ 3.6672263693321539*^+22, 
            Power[ x, 7]], 
          Times[ -2.968150007491254*^+20, 
            Power[ x, 8]], 
          Times[ 1.5317205085424952*^+18, 
            Power[ x, 9]], 
          Times[ -5100783184628805.0, 
            Power[ x, 10]], 
          Times[ 10941987570678.525, 
            Power[ x, 11]], 
          Times[ -14835791242.611397, 
            Power[ x, 12]], 
          Times[ 12140112.033800138, 
            Power[ x, 13]], 
          Times[ -5413.4811778762059, 
            Power[ x, 14]], 
          Power[ x, 15]]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("dorthpoly["\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "16", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "x", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        RowBox[{
          StyleBox["5.6591898313733342`*^31",
            StyleBoxAutoDelete->True,
            PrintPrecision->16], "-", 
          RowBox[{
            StyleBox["2.53274668941703984`*^32",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", "x"}], "+", 
          RowBox[{
            StyleBox["1.51666949852520938`*^32",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^2\)}], "-", 
          RowBox[{
            StyleBox["2.85537896556711601`*^31",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^3\)}], "+", 
          RowBox[{
            StyleBox["2.32204165648715088`*^30",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^4\)}], "-", 
          RowBox[{
            StyleBox["9.63421697722822223`*^28",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^5\)}], "+", 
          RowBox[{
            StyleBox["2.25593424996454894`*^27",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^6\)}], "-", 
          RowBox[{
            StyleBox["3.18388826338850172`*^25",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^7\)}], "+", 
          RowBox[{
            StyleBox["2.83027494777651433`*^23",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^8\)}], "-", 
          RowBox[{
            StyleBox["1.63103282539561185`*^21",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^9\)}], "+", 
          RowBox[{
            StyleBox["6.19661959180685251`*^18",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^10\)}], "-", 
          RowBox[{
            StyleBox["1.56095838049496098`*^16",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^11\)}], "+", 
          RowBox[{
            StyleBox["2.59055707960998571`*^13",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^12\)}], "-", 
          RowBox[{
            StyleBox["2.76936528622511968`*^10",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^13\)}], "+", 
          RowBox[{
            StyleBox["1.81594029459195489`*^7",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^14\)}], "-", 
          RowBox[{
            StyleBox["6580.42706808944899`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^15\)}], "+", \(x\^16\)}]}],
      SequenceForm[ "dorthpoly[", 1, ",", 16, ",", x, "]=", 
        Plus[ 5.6591898313733354*^+31, 
          Times[ -2.5327466894170403*^+32, x], 
          Times[ 1.5166694985252092*^+32, 
            Power[ x, 2]], 
          Times[ -2.8553789655671158*^+31, 
            Power[ x, 3]], 
          Times[ 2.3220416564871509*^+30, 
            Power[ x, 4]], 
          Times[ -9.6342169772282203*^+28, 
            Power[ x, 5]], 
          Times[ 2.255934249964549*^+27, 
            Power[ x, 6]], 
          Times[ -3.1838882633885019*^+25, 
            Power[ x, 7]], 
          Times[ 2.8302749477765149*^+23, 
            Power[ x, 8]], 
          Times[ -1.6310328253956117*^+21, 
            Power[ x, 9]], 
          Times[ 6.1966195918068531*^+18, 
            Power[ x, 10]], 
          Times[ -15609583804949608.0, 
            Power[ x, 11]], 
          Times[ 25905570796099.855, 
            Power[ x, 12]], 
          Times[ -27693652862.251194, 
            Power[ x, 13]], 
          Times[ 18159402.945919551, 
            Power[ x, 14]], 
          Times[ -6580.4270680894488, 
            Power[ x, 15]], 
          Power[ x, 16]]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("dorthpoly["\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "17", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "x", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        RowBox[{
          RowBox[{"-", 
            StyleBox["3.86735617720912969`*^34",
              StyleBoxAutoDelete->True,
              PrintPrecision->16]}], "+", 
          RowBox[{
            StyleBox["1.77171489908010038`*^35",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", "x"}], "-", 
          RowBox[{
            StyleBox["1.0957160529280121`*^35",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^2\)}], "+", 
          RowBox[{
            StyleBox["2.14572818812563825`*^34",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^3\)}], "-", 
          RowBox[{
            StyleBox["1.82782258961515182`*^33",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^4\)}], "+", 
          RowBox[{
            StyleBox["8.00313152051741916`*^31",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^5\)}], "-", 
          RowBox[{
            StyleBox["1.99393915864276607`*^30",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^6\)}], "+", 
          RowBox[{
            StyleBox["3.02236320101784006`*^28",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^7\)}], "-", 
          RowBox[{
            StyleBox["2.91732417914838713`*^26",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^8\)}], "+", 
          RowBox[{
            StyleBox["1.84984368291472627`*^24",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^9\)}], "-", 
          RowBox[{
            StyleBox["7.86141795421766698`*^21",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^10\)}], "+", 
          RowBox[{
            StyleBox["2.26284354228973016`*^19",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^11\)}], "-", 
          RowBox[{
            StyleBox["4.41643648880850836`*^16",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^12\)}], "+", 
          RowBox[{
            StyleBox["5.78690851908550474`*^13",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^13\)}], "-", 
          RowBox[{
            StyleBox["4.96374485847302082`*^10",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^14\)}], "+", 
          RowBox[{
            StyleBox["2.64829069842434794`*^7",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^15\)}], "-", 
          RowBox[{
            StyleBox["7904.05545496478367`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^16\)}], "+", \(x\^17\)}]}],
      SequenceForm[ "dorthpoly[", 1, ",", 17, ",", x, "]=", 
        Plus[ -3.8673561772091298*^+34, 
          Times[ 1.7717148990801001*^+35, x], 
          Times[ -1.095716052928012*^+35, 
            Power[ x, 2]], 
          Times[ 2.1457281881256381*^+34, 
            Power[ x, 3]], 
          Times[ -1.8278225896151517*^+33, 
            Power[ x, 4]], 
          Times[ 8.0031315205174199*^+31, 
            Power[ x, 5]], 
          Times[ -1.9939391586427663*^+30, 
            Power[ x, 6]], 
          Times[ 3.0223632010178401*^+28, 
            Power[ x, 7]], 
          Times[ -2.9173241791483871*^+26, 
            Power[ x, 8]], 
          Times[ 1.8498436829147266*^+24, 
            Power[ x, 9]], 
          Times[ -7.8614179542176671*^+21, 
            Power[ x, 10]], 
          Times[ 2.2628435422897299*^+19, 
            Power[ x, 11]], 
          Times[ -44164364888085080.0, 
            Power[ x, 12]], 
          Times[ 57869085190855.047, 
            Power[ x, 13]], 
          Times[ -49637448584.730209, 
            Power[ x, 14]], 
          Times[ 26482906.984243475, 
            Power[ x, 15]], 
          Times[ -7904.0554549647832, 
            Power[ x, 16]], 
          Power[ x, 17]]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("dorthpoly["\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "18", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "x", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        RowBox[{
          StyleBox["2.97003027540292627`*^37",
            StyleBoxAutoDelete->True,
            PrintPrecision->16], "-", 
          RowBox[{
            StyleBox["1.39055389244520366`*^38",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", "x"}], "+", 
          RowBox[{
            StyleBox["8.86052021810969137`*^37",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^2\)}], "-", 
          RowBox[{
            StyleBox["1.7992414871079287`*^37",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^3\)}], "+", 
          RowBox[{
            StyleBox["1.59922782482047898`*^36",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^4\)}], "-", 
          RowBox[{
            StyleBox["7.35404739735708279`*^34",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^5\)}], "+", 
          RowBox[{
            StyleBox["1.93797392052343226`*^33",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^6\)}], "-", 
          RowBox[{
            StyleBox["3.13189629785974954`*^31",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^7\)}], "+", 
          RowBox[{
            StyleBox["3.25273459853537261`*^29",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^8\)}], "-", 
          RowBox[{
            StyleBox["2.24336217155627926`*^27",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^9\)}], "+", 
          RowBox[{
            StyleBox["1.0506536117768479`*^25",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^10\)}], "-", 
          RowBox[{
            StyleBox["3.38780433090255295`*^22",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^11\)}], "+", 
          RowBox[{
            StyleBox["7.5656142109728961`*^19",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^12\)}], "-", 
          RowBox[{
            StyleBox["1.1673219947639184`*^17",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^13\)}], "+", 
          RowBox[{
            StyleBox["1.2287580063909933`*^14",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^14\)}], "-", 
          RowBox[{
            StyleBox["8.585425652347066`*^10",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^15\)}], "+", 
          RowBox[{
            StyleBox["3.77679004366786097`*^7",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^16\)}], "-", 
          RowBox[{
            StyleBox["9394.24464082017962`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^17\)}], "+", \(x\^18\)}]}],
      SequenceForm[ "dorthpoly[", 1, ",", 18, ",", x, "]=", 
        Plus[ 2.9700302754029263*^+37, 
          Times[ -1.3905538924452038*^+38, x], 
          Times[ 8.8605202181096914*^+37, 
            Power[ x, 2]], 
          Times[ -1.7992414871079286*^+37, 
            Power[ x, 3]], 
          Times[ 1.5992278248204787*^+36, 
            Power[ x, 4]], 
          Times[ -7.354047397357082*^+34, 
            Power[ x, 5]], 
          Times[ 1.9379739205234326*^+33, 
            Power[ x, 6]], 
          Times[ -3.1318962978597493*^+31, 
            Power[ x, 7]], 
          Times[ 3.2527345985353722*^+29, 
            Power[ x, 8]], 
          Times[ -2.2433621715562794*^+27, 
            Power[ x, 9]], 
          Times[ 1.0506536117768479*^+25, 
            Power[ x, 10]], 
          Times[ -3.3878043309025532*^+22, 
            Power[ x, 11]], 
          Times[ 7.5656142109728981*^+19, 
            Power[ x, 12]], 
          Times[ -1.1673219947639184*^+17, 
            Power[ x, 13]], 
          Times[ 122875800639099.34, 
            Power[ x, 14]], 
          Times[ -85854256523.470657, 
            Power[ x, 15]], 
          Times[ 37767900.436678611, 
            Power[ x, 16]], 
          Times[ -9394.2446408201795, 
            Power[ x, 17]], 
          Power[ x, 18]]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("dorthpoly["\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "19", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "x", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        RowBox[{
          RowBox[{"-", 
            StyleBox["2.54721503139160621`*^40",
              StyleBoxAutoDelete->True,
              PrintPrecision->16]}], "+", 
          RowBox[{
            StyleBox["1.21710013122298255`*^41",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", "x"}], "-", 
          RowBox[{
            StyleBox["7.97364182699269807`*^40",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^2\)}], "+", 
          RowBox[{
            StyleBox["1.6744359995512541`*^40",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^3\)}], "-", 
          RowBox[{
            StyleBox["1.54773235453156088`*^39",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^4\)}], "+", 
          RowBox[{
            StyleBox["7.44427885364530972`*^37",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^5\)}], "-", 
          RowBox[{
            StyleBox["2.0646563236971529`*^36",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^6\)}], "+", 
          RowBox[{
            StyleBox["3.5358293573821129`*^34",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^7\)}], "-", 
          RowBox[{
            StyleBox["3.92188968616339028`*^32",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^8\)}], "+", 
          RowBox[{
            StyleBox["2.91491637847557569`*^30",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^9\)}], "-", 
          RowBox[{
            StyleBox["1.48700585408050889`*^28",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^10\)}], "+", 
          RowBox[{
            StyleBox["5.29113483828740616`*^25",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^11\)}], "-", 
          RowBox[{
            StyleBox["1.32533600278066843`*^23",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^12\)}], "+", 
          RowBox[{
            StyleBox["2.34258234884146077`*^20",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^13\)}], "-", 
          RowBox[{
            StyleBox["2.90688594110950848`*^17",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^14\)}], "+", 
          RowBox[{
            StyleBox["2.49514970148645565`*^14",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^15\)}], "-", 
          RowBox[{
            StyleBox["1.43891271714188011`*^11",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^16\)}], "+", 
          RowBox[{
            StyleBox["5.28040437405336771`*^7",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^17\)}], "-", 
          RowBox[{
            StyleBox["11060.9554823684219`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^18\)}], "+", \(x\^19\)}]}],
      SequenceForm[ "dorthpoly[", 1, ",", 19, ",", x, "]=", 
        Plus[ -2.5472150313916062*^+40, 
          Times[ 1.2171001312229824*^+41, x], 
          Times[ -7.9736418269926977*^+40, 
            Power[ x, 2]], 
          Times[ 1.6744359995512542*^+40, 
            Power[ x, 3]], 
          Times[ -1.5477323545315611*^+39, 
            Power[ x, 4]], 
          Times[ 7.4442788536453109*^+37, 
            Power[ x, 5]], 
          Times[ -2.0646563236971527*^+36, 
            Power[ x, 6]], 
          Times[ 3.535829357382113*^+34, 
            Power[ x, 7]], 
          Times[ -3.92188968616339*^+32, 
            Power[ x, 8]], 
          Times[ 2.9149163784755757*^+30, 
            Power[ x, 9]], 
          Times[ -1.487005854080509*^+28, 
            Power[ x, 10]], 
          Times[ 5.2911348382874063*^+25, 
            Power[ x, 11]], 
          Times[ -1.3253360027806684*^+23, 
            Power[ x, 12]], 
          Times[ 2.3425823488414607*^+20, 
            Power[ x, 13]], 
          Times[ -2.9068859411095078*^+17, 
            Power[ x, 14]], 
          Times[ 249514970148645.59, 
            Power[ x, 15]], 
          Times[ -143891271714.18802, 
            Power[ x, 16]], 
          Times[ 52804043.74053368, 
            Power[ x, 17]], 
          Times[ -11060.955482368421, 
            Power[ x, 18]], 
          Power[ x, 19]]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("dorthpoly["\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "20", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "x", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        RowBox[{
          StyleBox["2.42849616441570415`*^43",
            StyleBoxAutoDelete->True,
            PrintPrecision->16], "-", 
          RowBox[{
            StyleBox["1.18269608240441325`*^44",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", "x"}], "+", 
          RowBox[{
            StyleBox["7.95141533742053674`*^43",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^2\)}], "-", 
          RowBox[{
            StyleBox["1.7226314252369967`*^43",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^3\)}], "+", 
          RowBox[{
            StyleBox["1.65097691007402502`*^42",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^4\)}], "-", 
          RowBox[{
            StyleBox["8.27606222079035624`*^40",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^5\)}], "+", 
          RowBox[{
            StyleBox["2.40537333496709404`*^39",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^6\)}], "-", 
          RowBox[{
            StyleBox["4.34270492388123052`*^37",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^7\)}], "+", 
          RowBox[{
            StyleBox["5.11220210079992831`*^35",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^8\)}], "-", 
          RowBox[{
            StyleBox["4.06353565562719332`*^33",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^9\)}], "+", 
          RowBox[{
            StyleBox["2.23679460707798982`*^31",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^10\)}], "-", 
          RowBox[{
            StyleBox["8.67969658227087847`*^28",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^11\)}], "+", 
          RowBox[{
            StyleBox["2.40182316053629651`*^26",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^12\)}], "-", 
          RowBox[{
            StyleBox["4.76665410884069018`*^23",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^13\)}], "+", 
          RowBox[{
            StyleBox["6.78259224644684888`*^20",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^14\)}], "-", 
          RowBox[{
            StyleBox["6.86950355138615709`*^17",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^15\)}], "+", 
          RowBox[{
            StyleBox["4.87101446803069038`*^14",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^16\)}], "-", 
          RowBox[{
            StyleBox["2.34527406077510658`*^11",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^17\)}], "+", 
          RowBox[{
            StyleBox["7.25371806991584389`*^7",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^18\)}], "-", 
          RowBox[{
            StyleBox["12914.8106109114845`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^19\)}], "+", \(x\^20\)}]}],
      SequenceForm[ "dorthpoly[", 1, ",", 20, ",", x, "]=", 
        Plus[ 2.4284961644157035*^+43, 
          Times[ -1.1826960824044133*^+44, x], 
          Times[ 7.9514153374205366*^+43, 
            Power[ x, 2]], 
          Times[ -1.7226314252369967*^+43, 
            Power[ x, 3]], 
          Times[ 1.650976910074025*^+42, 
            Power[ x, 4]], 
          Times[ -8.2760622207903555*^+40, 
            Power[ x, 5]], 
          Times[ 2.4053733349670936*^+39, 
            Power[ x, 6]], 
          Times[ -4.3427049238812297*^+37, 
            Power[ x, 7]], 
          Times[ 5.1122021007999279*^+35, 
            Power[ x, 8]], 
          Times[ -4.063535655627193*^+33, 
            Power[ x, 9]], 
          Times[ 2.2367946070779894*^+31, 
            Power[ x, 10]], 
          Times[ -8.6796965822708781*^+28, 
            Power[ x, 11]], 
          Times[ 2.4018231605362962*^+26, 
            Power[ x, 12]], 
          Times[ -4.7666541088406905*^+23, 
            Power[ x, 13]], 
          Times[ 6.7825922464468487*^+20, 
            Power[ x, 14]], 
          Times[ -6.8695035513861568*^+17, 
            Power[ x, 15]], 
          Times[ 487101446803069.06, 
            Power[ x, 16]], 
          Times[ -234527406077.51065, 
            Power[ x, 17]], 
          Times[ 72537180.699158445, 
            Power[ x, 18]], 
          Times[ -12914.810610911487, 
            Power[ x, 19]], 
          Power[ x, 20]]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("dorthpoly["\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "21", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "x", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        RowBox[{
          RowBox[{"-", 
            StyleBox["2.58012356272205689`*^46",
              StyleBoxAutoDelete->True,
              PrintPrecision->16]}], "+", 
          RowBox[{
            StyleBox["1.27896223451126678`*^47",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", "x"}], "-", 
          RowBox[{
            StyleBox["8.80688178330269266`*^46",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^2\)}], "+", 
          RowBox[{
            StyleBox["1.96357101235398552`*^46",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^3\)}], "-", 
          RowBox[{
            StyleBox["1.94554844193327447`*^45",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^4\)}], "+", 
          RowBox[{
            StyleBox["1.01291266801383583`*^44",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^5\)}], "-", 
          RowBox[{
            StyleBox["3.07248078184922679`*^42",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^6\)}], "+", 
          RowBox[{
            StyleBox["5.81987122383235266`*^40",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^7\)}], "-", 
          RowBox[{
            StyleBox["7.23002069492478049`*^38",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^8\)}], "+", 
          RowBox[{
            StyleBox["6.10476744802640336`*^36",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^9\)}], "-", 
          RowBox[{
            StyleBox["3.59668540124247115`*^34",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^10\)}], "+", 
          RowBox[{
            StyleBox["1.5070445950890412`*^32",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^11\)}], "-", 
          RowBox[{
            StyleBox["4.55076522998195098`*^29",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^12\)}], "+", 
          RowBox[{
            StyleBox["9.98321601276281178`*^26",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^13\)}], "-", 
          RowBox[{
            StyleBox["1.59583791297382093`*^24",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^14\)}], "+", 
          RowBox[{
            StyleBox["1.85430600124209483`*^21",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^15\)}], "-", 
          RowBox[{
            StyleBox["1.55215352238129078`*^18",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^16\)}], "+", 
          RowBox[{
            StyleBox["9.19283721463812142`*^14",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^17\)}], "-", 
          RowBox[{
            StyleBox["3.73190626101623701`*^11",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^18\)}], "+", 
          RowBox[{
            StyleBox["9.8143611290297521`*^7",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^19\)}], "-", 
          RowBox[{
            StyleBox["14970.8804946150735`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^20\)}], "+", \(x\^21\)}]}],
      SequenceForm[ "dorthpoly[", 1, ",", 21, ",", x, "]=", 
        Plus[ -2.5801235627220566*^+46, 
          Times[ 1.2789622345112668*^+47, x], 
          Times[ -8.8068817833026936*^+46, 
            Power[ x, 2]], 
          Times[ 1.9635710123539856*^+46, 
            Power[ x, 3]], 
          Times[ -1.9455484419332744*^+45, 
            Power[ x, 4]], 
          Times[ 1.0129126680138358*^+44, 
            Power[ x, 5]], 
          Times[ -3.0724807818492268*^+42, 
            Power[ x, 6]], 
          Times[ 5.8198712238323523*^+40, 
            Power[ x, 7]], 
          Times[ -7.2300206949247814*^+38, 
            Power[ x, 8]], 
          Times[ 6.1047674480264031*^+36, 
            Power[ x, 9]], 
          Times[ -3.5966854012424708*^+34, 
            Power[ x, 10]], 
          Times[ 1.5070445950890415*^+32, 
            Power[ x, 11]], 
          Times[ -4.5507652299819518*^+29, 
            Power[ x, 12]], 
          Times[ 9.9832160127628101*^+26, 
            Power[ x, 13]], 
          Times[ -1.5958379129738211*^+24, 
            Power[ x, 14]], 
          Times[ 1.8543060012420948*^+21, 
            Power[ x, 15]], 
          Times[ -1.5521535223812908*^+18, 
            Power[ x, 16]], 
          Times[ 919283721463812.12, 
            Power[ x, 17]], 
          Times[ -373190626101.62366, 
            Power[ x, 18]], 
          Times[ 98143611.290297508, 
            Power[ x, 19]], 
          Times[ -14970.880494615074, 
            Power[ x, 20]], 
          Power[ x, 21]]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("dorthpoly["\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "22", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "x", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        RowBox[{
          StyleBox["3.17273592790975822`*^49",
            StyleBoxAutoDelete->True,
            PrintPrecision->16], "-", 
          RowBox[{
            StyleBox["1.59698548428172193`*^50",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", "x"}], "+", 
          RowBox[{
            StyleBox["1.12268678472632243`*^50",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^2\)}], "-", 
          RowBox[{
            StyleBox["2.5661967741263858`*^49",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^3\)}], "+", 
          RowBox[{
            StyleBox["2.61707929519057547`*^48",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^4\)}], "-", 
          RowBox[{
            StyleBox["1.40810324716872115`*^47",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^5\)}], "+", 
          RowBox[{
            StyleBox["4.43295760776138081`*^45",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^6\)}], "-", 
          RowBox[{
            StyleBox["8.7551750948813023`*^43",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^7\)}], "+", 
          RowBox[{
            StyleBox["1.139847561619165`*^42",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^8\)}], "-", 
          RowBox[{
            StyleBox["1.01438875529912797`*^40",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^9\)}], "+", 
          RowBox[{
            StyleBox["6.3398041902097626`*^37",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^10\)}], "-", 
          RowBox[{
            StyleBox["2.83910826420970643`*^35",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^11\)}], "+", 
          RowBox[{
            StyleBox["9.24341817742547178`*^32",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^12\)}], "-", 
          RowBox[{
            StyleBox["2.20938373833812606`*^30",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^13\)}], "+", 
          RowBox[{
            StyleBox["3.89783458568698382`*^27",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^14\)}], "-", 
          RowBox[{
            StyleBox["5.08004802274887889`*^24",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^15\)}], "+", 
          RowBox[{
            StyleBox["4.87078493476169782`*^21",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^16\)}], "-", 
          RowBox[{
            StyleBox["3.40009330523198238`*^18",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^17\)}], "+", 
          RowBox[{
            StyleBox["1.69526006025307163`*^15",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^18\)}], "-", 
          RowBox[{
            StyleBox["5.84270027637194999`*^11",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^19\)}], "+", 
          RowBox[{
            StyleBox["1.31445273527751327`*^8",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^20\)}], "-", 
          RowBox[{
            StyleBox["17271.296101922906`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^21\)}], "+", \(x\^22\)}]}],
      SequenceForm[ "dorthpoly[", 1, ",", 22, ",", x, "]=", 
        Plus[ 3.1727359279097588*^+49, 
          Times[ -1.5969854842817219*^+50, x], 
          Times[ 1.1226867847263222*^+50, 
            Power[ x, 2]], 
          Times[ -2.5661967741263857*^+49, 
            Power[ x, 3]], 
          Times[ 2.617079295190576*^+48, 
            Power[ x, 4]], 
          Times[ -1.408103247168721*^+47, 
            Power[ x, 5]], 
          Times[ 4.432957607761381*^+45, 
            Power[ x, 6]], 
          Times[ -8.7551750948813021*^+43, 
            Power[ x, 7]], 
          Times[ 1.1398475616191649*^+42, 
            Power[ x, 8]], 
          Times[ -1.014388755299128*^+40, 
            Power[ x, 9]], 
          Times[ 6.339804190209761*^+37, 
            Power[ x, 10]], 
          Times[ -2.8391082642097068*^+35, 
            Power[ x, 11]], 
          Times[ 9.2434181774254704*^+32, 
            Power[ x, 12]], 
          Times[ -2.209383738338126*^+30, 
            Power[ x, 13]], 
          Times[ 3.8978345856869842*^+27, 
            Power[ x, 14]], 
          Times[ -5.080048022748879*^+24, 
            Power[ x, 15]], 
          Times[ 4.8707849347616976*^+21, 
            Power[ x, 16]], 
          Times[ -3.4000933052319826*^+18, 
            Power[ x, 17]], 
          Times[ 1695260060253071.5, 
            Power[ x, 18]], 
          Times[ -584270027637.19507, 
            Power[ x, 19]], 
          Times[ 131445273.52775134, 
            Power[ x, 20]], 
          Times[ -17271.296101922908, 
            Power[ x, 21]], 
          Power[ x, 22]]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("dorthpoly["\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "23", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "x", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        RowBox[{
          RowBox[{"-", 
            StyleBox["5.50842761407232028`*^52",
              StyleBoxAutoDelete->True,
              PrintPrecision->16]}], "+", 
          RowBox[{
            StyleBox["2.79800403949719589`*^53",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", "x"}], "-", 
          RowBox[{
            StyleBox["1.9917621997258184`*^53",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^2\)}], "+", 
          RowBox[{
            StyleBox["4.62304893516474457`*^52",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^3\)}], "-", 
          RowBox[{
            StyleBox["4.80119530268347904`*^51",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^4\)}], "+", 
          RowBox[{
            StyleBox["2.63860190377856529`*^50",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^5\)}], "-", 
          RowBox[{
            StyleBox["8.51283004776803053`*^48",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^6\)}], "+", 
          RowBox[{
            StyleBox["1.7293291155496`*^47",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^7\)}], "-", 
          RowBox[{
            StyleBox["2.32529603839188858`*^45",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^8\)}], "+", 
          RowBox[{
            StyleBox["2.14723334176571079`*^43",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^9\)}], "-", 
          RowBox[{
            StyleBox["1.39994589332066276`*^41",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^10\)}], "+", 
          RowBox[{
            StyleBox["6.58048267507737438`*^38",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^11\)}], "-", 
          RowBox[{
            StyleBox["2.26508550175473022`*^36",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^12\)}], "+", 
          RowBox[{
            StyleBox["5.77324306336436343`*^33",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^13\)}], "-", 
          RowBox[{
            StyleBox["1.09737922533569642`*^31",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^14\)}], "+", 
          RowBox[{
            StyleBox["1.56066741276648413`*^28",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^15\)}], "-", 
          RowBox[{
            StyleBox["1.6593026076169421`*^25",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^16\)}], "+", 
          RowBox[{
            StyleBox["1.31158742868215716`*^22",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^17\)}], "-", 
          RowBox[{
            StyleBox["7.61908104531145546`*^18",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^18\)}], "+", 
          RowBox[{
            StyleBox["3.18800016545228359`*^15",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^19\)}], "-", 
          RowBox[{
            StyleBox["9.2911693474768171`*^11",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^20\)}], "+", 
          RowBox[{
            StyleBox["1.77983645410518924`*^8",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^21\)}], "-", 
          RowBox[{
            StyleBox["20039.3111615760499`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^22\)}], "+", \(x\^23\)}]}],
      SequenceForm[ "dorthpoly[", 1, ",", 23, ",", x, "]=", 
        Plus[ -5.508427614072321*^+52, 
          Times[ 2.798004039497196*^+53, x], 
          Times[ -1.9917621997258182*^+53, 
            Power[ x, 2]], 
          Times[ 4.6230489351647444*^+52, 
            Power[ x, 3]], 
          Times[ -4.8011953026834794*^+51, 
            Power[ x, 4]], 
          Times[ 2.6386019037785654*^+50, 
            Power[ x, 5]], 
          Times[ -8.5128300477680314*^+48, 
            Power[ x, 6]], 
          Times[ 1.7293291155495999*^+47, 
            Power[ x, 7]], 
          Times[ -2.3252960383918881*^+45, 
            Power[ x, 8]], 
          Times[ 2.1472333417657111*^+43, 
            Power[ x, 9]], 
          Times[ -1.3999458933206627*^+41, 
            Power[ x, 10]], 
          Times[ 6.5804826750773744*^+38, 
            Power[ x, 11]], 
          Times[ -2.2650855017547301*^+36, 
            Power[ x, 12]], 
          Times[ 5.7732430633643643*^+33, 
            Power[ x, 13]], 
          Times[ -1.0973792253356966*^+31, 
            Power[ x, 14]], 
          Times[ 1.5606674127664839*^+28, 
            Power[ x, 15]], 
          Times[ -1.6593026076169423*^+25, 
            Power[ x, 16]], 
          Times[ 1.3115874286821572*^+22, 
            Power[ x, 17]], 
          Times[ -7.6190810453114542*^+18, 
            Power[ x, 18]], 
          Times[ 3188000165452283.5, 
            Power[ x, 19]], 
          Times[ -929116934747.68176, 
            Power[ x, 20]], 
          Times[ 177983645.41051891, 
            Power[ x, 21]], 
          Times[ -20039.31116157605, 
            Power[ x, 22]], 
          Power[ x, 23]]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("dorthpoly["\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "24", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "x", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        RowBox[{
          StyleBox["3.84793003995549742`*^56",
            StyleBoxAutoDelete->True,
            PrintPrecision->16], "-", 
          RowBox[{
            StyleBox["1.95564997488379717`*^57",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", "x"}], "+", 
          RowBox[{
            StyleBox["1.39337832490996159`*^57",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^2\)}], "-", 
          RowBox[{
            StyleBox["3.23831550457791284`*^56",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^3\)}], "+", 
          RowBox[{
            StyleBox["3.36907513288657778`*^55",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^4\)}], "-", 
          RowBox[{
            StyleBox["1.85595795847686773`*^54",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^5\)}], "+", 
          RowBox[{
            StyleBox["6.0065395493372975`*^52",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^6\)}], "-", 
          RowBox[{
            StyleBox["1.22512537975582302`*^51",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^7\)}], "+", 
          RowBox[{
            StyleBox["1.65584169338148896`*^49",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^8\)}], "-", 
          RowBox[{
            StyleBox["1.53904578335716113`*^47",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^9\)}], "+", 
          RowBox[{
            StyleBox["1.01168343447458175`*^45",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^10\)}], "-", 
          RowBox[{
            StyleBox["4.8045444897958518`*^42",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^11\)}], "+", 
          RowBox[{
            StyleBox["1.67517030388368119`*^40",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^12\)}], "-", 
          RowBox[{
            StyleBox["4.3388926689704288`*^37",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^13\)}], "+", 
          RowBox[{
            StyleBox["8.41564250053184181`*^34",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^14\)}], "-", 
          RowBox[{
            StyleBox["1.22778524228354557`*^32",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^15\)}], "+", 
          RowBox[{
            StyleBox["1.34855204218577751`*^29",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^16\)}], "-", 
          RowBox[{
            StyleBox["1.11172888199098007`*^26",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^17\)}], "+", 
          RowBox[{
            StyleBox["6.82571270281451081`*^22",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^18\)}], "-", 
          RowBox[{
            StyleBox["3.07805243653145144`*^19",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^19\)}], "+", 
          RowBox[{
            StyleBox["9.9658723623811074`*^15",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^20\)}], "-", 
          RowBox[{
            StyleBox["2.23313283046646082`*^12",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^21\)}], "+", 
          RowBox[{
            StyleBox["3.25476445809460468`*^8",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^22\)}], "-", 
          RowBox[{
            StyleBox["27435.0215246613027`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^23\)}], "+", \(x\^24\)}]}],
      SequenceForm[ "dorthpoly[", 1, ",", 24, ",", x, "]=", 
        Plus[ 3.8479300399554973*^+56, 
          Times[ -1.9556499748837969*^+57, x], 
          Times[ 1.3933783249099614*^+57, 
            Power[ x, 2]], 
          Times[ -3.2383155045779123*^+56, 
            Power[ x, 3]], 
          Times[ 3.3690751328865773*^+55, 
            Power[ x, 4]], 
          Times[ -1.8559579584768677*^+54, 
            Power[ x, 5]], 
          Times[ 6.006539549337298*^+52, 
            Power[ x, 6]], 
          Times[ -1.2251253797558232*^+51, 
            Power[ x, 7]], 
          Times[ 1.655841693381489*^+49, 
            Power[ x, 8]], 
          Times[ -1.5390457833571611*^+47, 
            Power[ x, 9]], 
          Times[ 1.0116834344745818*^+45, 
            Power[ x, 10]], 
          Times[ -4.8045444897958524*^+42, 
            Power[ x, 11]], 
          Times[ 1.675170303883681*^+40, 
            Power[ x, 12]], 
          Times[ -4.3388926689704283*^+37, 
            Power[ x, 13]], 
          Times[ 8.4156425005318402*^+34, 
            Power[ x, 14]], 
          Times[ -1.2277852422835457*^+32, 
            Power[ x, 15]], 
          Times[ 1.3485520421857775*^+29, 
            Power[ x, 16]], 
          Times[ -1.1117288819909801*^+26, 
            Power[ x, 17]], 
          Times[ 6.8257127028145108*^+22, 
            Power[ x, 18]], 
          Times[ -3.0780524365314511*^+19, 
            Power[ x, 19]], 
          Times[ 9965872362381106.0, 
            Power[ x, 20]], 
          Times[ -2233132830466.4609, 
            Power[ x, 21]], 
          Times[ 325476445.80946046, 
            Power[ x, 22]], 
          Times[ -27435.021524661301, 
            Power[ x, 23]], 
          Power[ x, 24]]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("dorthpoly["\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "25", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "x", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        RowBox[{
          StyleBox["2.82680662662177439`*^59",
            StyleBoxAutoDelete->True,
            PrintPrecision->16], "-", 
          RowBox[{
            StyleBox["1.44196734674287663`*^60",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", "x"}], "+", 
          RowBox[{
            StyleBox["1.03215763661901194`*^60",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^2\)}], "-", 
          RowBox[{
            StyleBox["2.41096992341214422`*^59",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^3\)}], "+", 
          RowBox[{
            StyleBox["2.52128737373199385`*^58",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^4\)}], "-", 
          RowBox[{
            StyleBox["1.39580942006156805`*^57",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^5\)}], "+", 
          RowBox[{
            StyleBox["4.53709901236305235`*^55",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^6\)}], "-", 
          RowBox[{
            StyleBox["9.28499087494432018`*^53",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^7\)}], "+", 
          RowBox[{
            StyleBox["1.2570599735079726`*^52",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^8\)}], "-", 
          RowBox[{
            StyleBox["1.16749933692784391`*^50",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^9\)}], "+", 
          RowBox[{
            StyleBox["7.64093234944797661`*^47",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^10\)}], "-", 
          RowBox[{
            StyleBox["3.59376243295899167`*^45",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^11\)}], "+", 
          RowBox[{
            StyleBox["1.23126921460212046`*^43",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^12\)}], "-", 
          RowBox[{
            StyleBox["3.09705018156350364`*^40",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^13\)}], "+", 
          RowBox[{
            StyleBox["5.72727068754283408`*^37",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^14\)}], "-", 
          RowBox[{
            StyleBox["7.72952060482510461`*^34",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^15\)}], "+", 
          RowBox[{
            StyleBox["7.4407402664469231`*^31",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^16\)}], "-", 
          RowBox[{
            StyleBox["4.80790945243092515`*^28",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^17\)}], "+", 
          RowBox[{
            StyleBox["1.68354640047896157`*^25",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^18\)}], "+", 
          RowBox[{
            StyleBox["1.565580873325999`*^21",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^19\)}], "-", 
          RowBox[{
            StyleBox["5.45863552750966363`*^18",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^20\)}], "+", 
          RowBox[{
            StyleBox["3.19875267027321807`*^15",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^21\)}], "-", 
          RowBox[{
            StyleBox["1.03331234584042142`*^12",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^22\)}], "+", 
          RowBox[{
            StyleBox["1.99407686377059469`*^8",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^23\)}], "-", 
          RowBox[{
            StyleBox["21521.0852608673963`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^24\)}], "+", \(x\^25\)}]}],
      SequenceForm[ "dorthpoly[", 1, ",", 25, ",", x, "]=", 
        Plus[ 2.8268066266217751*^+59, 
          Times[ -1.4419673467428766*^+60, x], 
          Times[ 1.0321576366190119*^+60, 
            Power[ x, 2]], 
          Times[ -2.4109699234121446*^+59, 
            Power[ x, 3]], 
          Times[ 2.5212873737319936*^+58, 
            Power[ x, 4]], 
          Times[ -1.3958094200615679*^+57, 
            Power[ x, 5]], 
          Times[ 4.5370990123630522*^+55, 
            Power[ x, 6]], 
          Times[ -9.2849908749443194*^+53, 
            Power[ x, 7]], 
          Times[ 1.2570599735079727*^+52, 
            Power[ x, 8]], 
          Times[ -1.1674993369278441*^+50, 
            Power[ x, 9]], 
          Times[ 7.6409323494479777*^+47, 
            Power[ x, 10]], 
          Times[ -3.5937624329589918*^+45, 
            Power[ x, 11]], 
          Times[ 1.2312692146021204*^+43, 
            Power[ x, 12]], 
          Times[ -3.097050181563504*^+40, 
            Power[ x, 13]], 
          Times[ 5.7272706875428338*^+37, 
            Power[ x, 14]], 
          Times[ -7.729520604825104*^+34, 
            Power[ x, 15]], 
          Times[ 7.440740266446923*^+31, 
            Power[ x, 16]], 
          Times[ -4.8079094524309254*^+28, 
            Power[ x, 17]], 
          Times[ 1.6835464004789616*^+25, 
            Power[ x, 18]], 
          Times[ 1.565580873325999*^+21, 
            Power[ x, 19]], 
          Times[ -5.4586355275096637*^+18, 
            Power[ x, 20]], 
          Times[ 3198752670273218.0, 
            Power[ x, 21]], 
          Times[ -1033312345840.4215, 
            Power[ x, 22]], 
          Times[ 199407686.37705946, 
            Power[ x, 23]], 
          Times[ -21521.085260867399, 
            Power[ x, 24]], 
          Power[ x, 25]]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("dorthpoly["\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "26", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "x", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        RowBox[{
          RowBox[{"-", 
            StyleBox["3.50913533779521014`*^62",
              StyleBoxAutoDelete->True,
              PrintPrecision->16]}], "+", 
          RowBox[{
            StyleBox["1.80534794896290158`*^63",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", "x"}], "-", 
          RowBox[{
            StyleBox["1.30702876787978783`*^63",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^2\)}], "+", 
          RowBox[{
            StyleBox["3.09427842660432705`*^62",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^3\)}], "-", 
          RowBox[{
            StyleBox["3.28556510478598218`*^61",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^4\)}], "+", 
          RowBox[{
            StyleBox["1.85000000151352939`*^60",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^5\)}], "-", 
          RowBox[{
            StyleBox["6.12598922163025605`*^58",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^6\)}], "+", 
          RowBox[{
            StyleBox["1.27900910321457739`*^57",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^7\)}], "-", 
          RowBox[{
            StyleBox["1.76889657464808465`*^55",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^8\)}], "+", 
          RowBox[{
            StyleBox["1.67988278127045838`*^53",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^9\)}], "-", 
          RowBox[{
            StyleBox["1.12466739586662267`*^51",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^10\)}], "+", 
          RowBox[{
            StyleBox["5.40791013947499443`*^48",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^11\)}], "-", 
          RowBox[{
            StyleBox["1.88966157108119467`*^46",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^12\)}], "+", 
          RowBox[{
            StyleBox["4.81865872033784192`*^43",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^13\)}], "-", 
          RowBox[{
            StyleBox["8.91225457665298748`*^40",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^14\)}], "+", 
          RowBox[{
            StyleBox["1.16528723911846854`*^38",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^15\)}], "-", 
          RowBox[{
            StyleBox["9.95178725357004978`*^34",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^16\)}], "+", 
          RowBox[{
            StyleBox["3.85452163056139252`*^31",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^17\)}], "+", 
          RowBox[{
            StyleBox["2.57616066424647538`*^28",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^18\)}], "-", 
          RowBox[{
            StyleBox["5.38779709333553302`*^25",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^19\)}], "+", 
          RowBox[{
            StyleBox["4.46920040292460285`*^22",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^20\)}], "-", 
          RowBox[{
            StyleBox["2.31940168974076188`*^19",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^21\)}], "+", 
          RowBox[{
            StyleBox["8.10066125620921795`*^15",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^22\)}], "-", 
          RowBox[{
            StyleBox["1.90536074644420878`*^12",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^23\)}], "+", 
          RowBox[{
            StyleBox["2.89426136654975696`*^8",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^24\)}], "-", 
          RowBox[{
            StyleBox["25606.7954417633236`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^25\)}], "+", \(x\^26\)}]}],
      SequenceForm[ "dorthpoly[", 1, ",", 26, ",", x, "]=", 
        Plus[ -3.5091353377952102*^+62, 
          Times[ 1.8053479489629014*^+63, x], 
          Times[ -1.3070287678797879*^+63, 
            Power[ x, 2]], 
          Times[ 3.0942784266043268*^+62, 
            Power[ x, 3]], 
          Times[ -3.285565104785982*^+61, 
            Power[ x, 4]], 
          Times[ 1.8500000015135294*^+60, 
            Power[ x, 5]], 
          Times[ -6.1259892216302561*^+58, 
            Power[ x, 6]], 
          Times[ 1.2790091032145774*^+57, 
            Power[ x, 7]], 
          Times[ -1.7688965746480847*^+55, 
            Power[ x, 8]], 
          Times[ 1.6798827812704586*^+53, 
            Power[ x, 9]], 
          Times[ -1.1246673958666229*^+51, 
            Power[ x, 10]], 
          Times[ 5.4079101394749932*^+48, 
            Power[ x, 11]], 
          Times[ -1.8896615710811945*^+46, 
            Power[ x, 12]], 
          Times[ 4.8186587203378425*^+43, 
            Power[ x, 13]], 
          Times[ -8.9122545766529873*^+40, 
            Power[ x, 14]], 
          Times[ 1.1652872391184686*^+38, 
            Power[ x, 15]], 
          Times[ -9.9517872535700502*^+34, 
            Power[ x, 16]], 
          Times[ 3.854521630561393*^+31, 
            Power[ x, 17]], 
          Times[ 2.5761606642464753*^+28, 
            Power[ x, 18]], 
          Times[ -5.3877970933355328*^+25, 
            Power[ x, 19]], 
          Times[ 4.4692004029246028*^+22, 
            Power[ x, 20]], 
          Times[ -2.3194016897407615*^+19, 
            Power[ x, 21]], 
          Times[ 8100661256209218.0, 
            Power[ x, 22]], 
          Times[ -1905360746444.2087, 
            Power[ x, 23]], 
          Times[ 289426136.65497565, 
            Power[ x, 24]], 
          Times[ -25606.795441763323, 
            Power[ x, 25]], 
          Power[ x, 26]]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("dorthpoly["\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "27", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "x", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        RowBox[{
          StyleBox["6.97052289513133782`*^65",
            StyleBoxAutoDelete->True,
            PrintPrecision->16], "-", 
          RowBox[{
            StyleBox["3.60937045366435071`*^66",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", "x"}], "+", 
          RowBox[{
            StyleBox["2.63651760327403028`*^66",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^2\)}], "-", 
          RowBox[{
            StyleBox["6.31093412354948579`*^65",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^3\)}], "+", 
          RowBox[{
            StyleBox["6.78995607869091521`*^64",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^4\)}], "-", 
          RowBox[{
            StyleBox["3.88287483303506988`*^63",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^5\)}], "+", 
          RowBox[{
            StyleBox["1.30912033888460976`*^62",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^6\)}], "-", 
          RowBox[{
            StyleBox["2.79068751439531759`*^60",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^7\)}], "+", 
          RowBox[{
            StyleBox["3.95296448030588276`*^58",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^8\)}], "-", 
          RowBox[{
            StyleBox["3.85824834346619649`*^56",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^9\)}], "+", 
          RowBox[{
            StyleBox["2.66515015543674937`*^54",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^10\)}], "-", 
          RowBox[{
            StyleBox["1.3281147598805536`*^52",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^11\)}], "+", 
          RowBox[{
            StyleBox["4.83397768816078432`*^49",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^12\)}], "-", 
          RowBox[{
            StyleBox["1.29165235455063086`*^47",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^13\)}], "+", 
          RowBox[{
            StyleBox["2.52146874686777211`*^44",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^14\)}], "-", 
          RowBox[{
            StyleBox["3.51332701566867822`*^41",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^15\)}], "+", 
          RowBox[{
            StyleBox["3.24891835203080603`*^38",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^16\)}], "-", 
          RowBox[{
            StyleBox["1.44504574685729654`*^35",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^17\)}], "-", 
          RowBox[{
            StyleBox["8.23329907258400695`*^31",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^18\)}], "+", 
          RowBox[{
            StyleBox["2.10368256884827697`*^29",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^19\)}], "-", 
          RowBox[{
            StyleBox["1.99295418703199054`*^26",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^20\)}], "+", 
          RowBox[{
            StyleBox["1.19481498210742763`*^23",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^21\)}], "-", 
          RowBox[{
            StyleBox["4.94702736080926008`*^19",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^22\)}], "+", 
          RowBox[{
            StyleBox["1.43620389723568013`*^16",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^23\)}], "-", 
          RowBox[{
            StyleBox["2.87273214102140439`*^12",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^24\)}], "+", 
          RowBox[{
            StyleBox["3.7669027067022478`*^8",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^25\)}], "-", 
          RowBox[{
            StyleBox["29087.0669852531129`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^26\)}], "+", \(x\^27\)}]}],
      SequenceForm[ "dorthpoly[", 1, ",", 27, ",", x, "]=", 
        Plus[ 6.9705228951313379*^+65, 
          Times[ -3.6093704536643511*^+66, x], 
          Times[ 2.6365176032740303*^+66, 
            Power[ x, 2]], 
          Times[ -6.3109341235494853*^+65, 
            Power[ x, 3]], 
          Times[ 6.7899560786909141*^+64, 
            Power[ x, 4]], 
          Times[ -3.8828748330350701*^+63, 
            Power[ x, 5]], 
          Times[ 1.3091203388846096*^+62, 
            Power[ x, 6]], 
          Times[ -2.7906875143953177*^+60, 
            Power[ x, 7]], 
          Times[ 3.9529644803058833*^+58, 
            Power[ x, 8]], 
          Times[ -3.8582483434661964*^+56, 
            Power[ x, 9]], 
          Times[ 2.6651501554367498*^+54, 
            Power[ x, 10]], 
          Times[ -1.3281147598805534*^+52, 
            Power[ x, 11]], 
          Times[ 4.8339776881607831*^+49, 
            Power[ x, 12]], 
          Times[ -1.291652354550631*^+47, 
            Power[ x, 13]], 
          Times[ 2.5214687468677724*^+44, 
            Power[ x, 14]], 
          Times[ -3.5133270156686784*^+41, 
            Power[ x, 15]], 
          Times[ 3.2489183520308064*^+38, 
            Power[ x, 16]], 
          Times[ -1.4450457468572965*^+35, 
            Power[ x, 17]], 
          Times[ -8.2332990725840065*^+31, 
            Power[ x, 18]], 
          Times[ 2.1036825688482773*^+29, 
            Power[ x, 19]], 
          Times[ -1.9929541870319904*^+26, 
            Power[ x, 20]], 
          Times[ 1.1948149821074275*^+23, 
            Power[ x, 21]], 
          Times[ -4.9470273608092598*^+19, 
            Power[ x, 22]], 
          Times[ 14362038972356802.0, 
            Power[ x, 23]], 
          Times[ -2872732141021.4048, 
            Power[ x, 24]], 
          Times[ 376690270.67022479, 
            Power[ x, 25]], 
          Times[ -29087.066985253114, 
            Power[ x, 26]], 
          Power[ x, 27]]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("dorthpoly["\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "28", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "x", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        RowBox[{
          StyleBox["2.34339707250888196`*^69",
            StyleBoxAutoDelete->True,
            PrintPrecision->16], "-", 
          RowBox[{
            StyleBox["1.20707907591708352`*^70",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", "x"}], "+", 
          RowBox[{
            StyleBox["8.75137093853150282`*^69",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^2\)}], "-", 
          RowBox[{
            StyleBox["2.07461360952306872`*^69",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^3\)}], "+", 
          RowBox[{
            StyleBox["2.20524075627143067`*^68",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^4\)}], "-", 
          RowBox[{
            StyleBox["1.24241787466943565`*^67",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^5\)}], "+", 
          RowBox[{
            StyleBox["4.1132063189138508`*^65",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^6\)}], "-", 
          RowBox[{
            StyleBox["8.57592946370941788`*^63",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^7\)}], "+", 
          RowBox[{
            StyleBox["1.18245286560772466`*^62",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^8\)}], "-", 
          RowBox[{
            StyleBox["1.11682455418034809`*^60",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^9\)}], "+", 
          RowBox[{
            StyleBox["7.41023720505484639`*^57",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^10\)}], "-", 
          RowBox[{
            StyleBox["3.51304271680199287`*^55",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^11\)}], "+", 
          RowBox[{
            StyleBox["1.20065899825577981`*^53",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^12\)}], "-", 
          RowBox[{
            StyleBox["2.95603337730539728`*^50",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^13\)}], "+", 
          RowBox[{
            StyleBox["5.1574509467006866`*^47",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^14\)}], "-", 
          RowBox[{
            StyleBox["6.05418691501926709`*^44",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^15\)}], "+", 
          RowBox[{
            StyleBox["3.97502310556283333`*^41",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^16\)}], "+", 
          RowBox[{
            StyleBox["2.24892041314143176`*^37",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^17\)}], "-", 
          RowBox[{
            StyleBox["3.37178861026735088`*^35",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^18\)}], "+", 
          RowBox[{
            StyleBox["3.45912754346274908`*^32",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^19\)}], "-", 
          RowBox[{
            StyleBox["1.61285347252405379`*^29",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^20\)}], "+", 
          RowBox[{
            StyleBox["4.21531706438850584`*^24",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^21\)}], "+", 
          RowBox[{
            StyleBox["4.32771978771662624`*^22",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^22\)}], "-", 
          RowBox[{
            StyleBox["2.97406247638325069`*^19",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^23\)}], "+", 
          RowBox[{
            StyleBox["1.09073309071214241`*^16",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^24\)}], "-", 
          RowBox[{
            StyleBox["2.48592514043042722`*^12",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^25\)}], "+", 
          RowBox[{
            StyleBox["3.52062580385147594`*^8",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^26\)}], "-", 
          RowBox[{
            StyleBox["28424.7328868686022`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^27\)}], "+", \(x\^28\)}]}],
      SequenceForm[ "dorthpoly[", 1, ",", 28, ",", x, "]=", 
        Plus[ 2.343397072508882*^+69, 
          Times[ -1.2070790759170836*^+70, x], 
          Times[ 8.7513709385315019*^+69, 
            Power[ x, 2]], 
          Times[ -2.0746136095230689*^+69, 
            Power[ x, 3]], 
          Times[ 2.2052407562714308*^+68, 
            Power[ x, 4]], 
          Times[ -1.2424178746694353*^+67, 
            Power[ x, 5]], 
          Times[ 4.1132063189138506*^+65, 
            Power[ x, 6]], 
          Times[ -8.5759294637094181*^+63, 
            Power[ x, 7]], 
          Times[ 1.1824528656077245*^+62, 
            Power[ x, 8]], 
          Times[ -1.1168245541803481*^+60, 
            Power[ x, 9]], 
          Times[ 7.4102372050548447*^+57, 
            Power[ x, 10]], 
          Times[ -3.5130427168019926*^+55, 
            Power[ x, 11]], 
          Times[ 1.2006589982557799*^+53, 
            Power[ x, 12]], 
          Times[ -2.9560333773053973*^+50, 
            Power[ x, 13]], 
          Times[ 5.1574509467006857*^+47, 
            Power[ x, 14]], 
          Times[ -6.0541869150192669*^+44, 
            Power[ x, 15]], 
          Times[ 3.9750231055628332*^+41, 
            Power[ x, 16]], 
          Times[ 2.2489204131414316*^+37, 
            Power[ x, 17]], 
          Times[ -3.3717886102673508*^+35, 
            Power[ x, 18]], 
          Times[ 3.459127543462749*^+32, 
            Power[ x, 19]], 
          Times[ -1.6128534725240538*^+29, 
            Power[ x, 20]], 
          Times[ 4.2153170643885057*^+24, 
            Power[ x, 21]], 
          Times[ 4.3277197877166257*^+22, 
            Power[ x, 22]], 
          Times[ -2.9740624763832504*^+19, 
            Power[ x, 23]], 
          Times[ 10907330907121424.0, 
            Power[ x, 24]], 
          Times[ -2485925140430.4272, 
            Power[ x, 25]], 
          Times[ 352062580.38514763, 
            Power[ x, 26]], 
          Times[ -28424.732886868605, 
            Power[ x, 27]], 
          Power[ x, 28]]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("dorthpoly["\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "29", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "x", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        RowBox[{
          RowBox[{"-", 
            StyleBox["2.01760138147675016`*^73",
              StyleBoxAutoDelete->True,
              PrintPrecision->16]}], "+", 
          RowBox[{
            StyleBox["1.0417932788926878`*^74",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", "x"}], "-", 
          RowBox[{
            StyleBox["7.58027257899600215`*^73",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^2\)}], "+", 
          RowBox[{
            StyleBox["1.80565539756430162`*^73",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^3\)}], "-", 
          RowBox[{
            StyleBox["1.93134372621882803`*^72",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^4\)}], "+", 
          RowBox[{
            StyleBox["1.09677847157738383`*^71",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^5\)}], "-", 
          RowBox[{
            StyleBox["3.66758219653304973`*^69",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^6\)}], "+", 
          RowBox[{
            StyleBox["7.74338037498755227`*^67",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^7\)}], "-", 
          RowBox[{
            StyleBox["1.08453933486486974`*^66",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^8\)}], "+", 
          RowBox[{
            StyleBox["1.0446392306813681`*^64",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^9\)}], "-", 
          RowBox[{
            StyleBox["7.10426459126253462`*^61",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^10\)}], "+", 
          RowBox[{
            StyleBox["3.47502078662287994`*^59",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^11\)}], "-", 
          RowBox[{
            StyleBox["1.23665289831403013`*^57",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^12\)}], "+", 
          RowBox[{
            StyleBox["3.21314212675395882`*^54",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^13\)}], "-", 
          RowBox[{
            StyleBox["6.04817316051113973`*^51",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^14\)}], "+", 
          RowBox[{
            StyleBox["8.00401844429900677`*^48",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^15\)}], "-", 
          RowBox[{
            StyleBox["6.77409294486804292`*^45",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^16\)}], "+", 
          RowBox[{
            StyleBox["2.21314685083459394`*^42",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^17\)}], "+", 
          RowBox[{
            StyleBox["2.68680282942294867`*^39",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^18\)}], "-", 
          RowBox[{
            StyleBox["4.74366922764124065`*^36",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^19\)}], "+", 
          RowBox[{
            StyleBox["3.74548630800589865`*^33",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^20\)}], "-", 
          RowBox[{
            StyleBox["1.76874616125267891`*^30",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^21\)}], "+", 
          RowBox[{
            StyleBox["4.6011130497674948`*^26",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^22\)}], "-", 
          RowBox[{
            StyleBox["9.08988840216946414`*^21",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^23\)}], "-", 
          RowBox[{
            StyleBox["4.23567425174951317`*^19",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^24\)}], "+", 
          RowBox[{
            StyleBox["1.7477726706882759`*^16",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^25\)}], "-", 
          RowBox[{
            StyleBox["3.73884891198657598`*^12",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^26\)}], "+", 
          RowBox[{
            StyleBox["4.71140469616457391`*^8",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^27\)}], "-", 
          RowBox[{
            StyleBox["33081.4955976574953`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^28\)}], "+", \(x\^29\)}]}],
      SequenceForm[ "dorthpoly[", 1, ",", 29, ",", x, "]=", 
        Plus[ -2.0176013814767503*^+73, 
          Times[ 1.0417932788926876*^+74, x], 
          Times[ -7.5802725789960022*^+73, 
            Power[ x, 2]], 
          Times[ 1.8056553975643015*^+73, 
            Power[ x, 3]], 
          Times[ -1.9313437262188284*^+72, 
            Power[ x, 4]], 
          Times[ 1.0967784715773838*^+71, 
            Power[ x, 5]], 
          Times[ -3.6675821965330494*^+69, 
            Power[ x, 6]], 
          Times[ 7.7433803749875514*^+67, 
            Power[ x, 7]], 
          Times[ -1.0845393348648696*^+66, 
            Power[ x, 8]], 
          Times[ 1.0446392306813681*^+64, 
            Power[ x, 9]], 
          Times[ -7.104264591262534*^+61, 
            Power[ x, 10]], 
          Times[ 3.4750207866228808*^+59, 
            Power[ x, 11]], 
          Times[ -1.23665289831403*^+57, 
            Power[ x, 12]], 
          Times[ 3.2131421267539586*^+54, 
            Power[ x, 13]], 
          Times[ -6.048173160511141*^+51, 
            Power[ x, 14]], 
          Times[ 8.0040184442990075*^+48, 
            Power[ x, 15]], 
          Times[ -6.774092944868043*^+45, 
            Power[ x, 16]], 
          Times[ 2.213146850834594*^+42, 
            Power[ x, 17]], 
          Times[ 2.6868028294229485*^+39, 
            Power[ x, 18]], 
          Times[ -4.7436692276412399*^+36, 
            Power[ x, 19]], 
          Times[ 3.7454863080058984*^+33, 
            Power[ x, 20]], 
          Times[ -1.7687461612526789*^+30, 
            Power[ x, 21]], 
          Times[ 4.6011130497674951*^+26, 
            Power[ x, 22]], 
          Times[ -9.0898884021694644*^+21, 
            Power[ x, 23]], 
          Times[ -4.2356742517495136*^+19, 
            Power[ x, 24]], 
          Times[ 17477726706882760.0, 
            Power[ x, 25]], 
          Times[ -3738848911986.5762, 
            Power[ x, 26]], 
          Times[ 471140469.61645746, 
            Power[ x, 27]], 
          Times[ -33081.495597657493, 
            Power[ x, 28]], 
          Power[ x, 29]]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("dorthpoly["\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "30", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "x", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        RowBox[{
          RowBox[{"-", 
            StyleBox["4.92633340193258817`*^76",
              StyleBoxAutoDelete->True,
              PrintPrecision->16]}], "+", 
          RowBox[{
            StyleBox["2.54727934775303044`*^77",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", "x"}], "-", 
          RowBox[{
            StyleBox["1.85658312016429398`*^77",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^2\)}], "+", 
          RowBox[{
            StyleBox["4.43015138242905681`*^76",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^3\)}], "-", 
          RowBox[{
            StyleBox["4.74619345051328522`*^75",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^4\)}], "+", 
          RowBox[{
            StyleBox["2.69888229393570844`*^74",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^5\)}], "-", 
          RowBox[{
            StyleBox["9.0327557672935903`*^72",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^6\)}], "+", 
          RowBox[{
            StyleBox["1.90741151811836537`*^71",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^7\)}], "-", 
          RowBox[{
            StyleBox["2.66935099570957179`*^69",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^8\)}], "+", 
          RowBox[{
            StyleBox["2.56555641248111321`*^67",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^9\)}], "-", 
          RowBox[{
            StyleBox["1.73768392895496326`*^65",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^10\)}], "+", 
          RowBox[{
            StyleBox["8.4430541281641922`*^62",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^11\)}], "-", 
          RowBox[{
            StyleBox["2.97323805035512656`*^60",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^12\)}], "+", 
          RowBox[{
            StyleBox["7.60056679449837258`*^57",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^13\)}], "-", 
          RowBox[{
            StyleBox["1.39412507162588727`*^55",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^14\)}], "+", 
          RowBox[{
            StyleBox["1.76390848382696248`*^52",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^15\)}], "-", 
          RowBox[{
            StyleBox["1.35117412831686833`*^49",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^16\)}], "+", 
          RowBox[{
            StyleBox["2.20255175575408657`*^45",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^17\)}], "+", 
          RowBox[{
            StyleBox["8.4524826989072217`*^42",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^18\)}], "-", 
          RowBox[{
            StyleBox["1.15165263020803254`*^40",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^19\)}], "+", 
          RowBox[{
            StyleBox["7.90036458205407932`*^36",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^20\)}], "-", 
          RowBox[{
            StyleBox["3.14504834911911057`*^33",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^21\)}], "+", 
          RowBox[{
            StyleBox["5.90864170272818878`*^29",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^22\)}], "+", 
          RowBox[{
            StyleBox["4.43038379018758021`*^25",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^23\)}], "-", 
          RowBox[{
            StyleBox["3.59818999486848678`*^22",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^24\)}], "-", 
          RowBox[{
            StyleBox["5.50903288358931408`*^18",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^25\)}], "+", 
          RowBox[{
            StyleBox["7.29810214393845679`*^15",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^26\)}], "-", 
          RowBox[{
            StyleBox["2.25236821084735527`*^12",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^27\)}], "+", 
          RowBox[{
            StyleBox["3.54037784840320579`*^8",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^28\)}], "-", 
          RowBox[{
            StyleBox["29155.3182028961046`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^29\)}], "+", \(x\^30\)}]}],
      SequenceForm[ "dorthpoly[", 1, ",", 30, ",", x, "]=", 
        Plus[ -4.9263334019325874*^+76, 
          Times[ 2.5472793477530301*^+77, x], 
          Times[ -1.8565831201642936*^+77, 
            Power[ x, 2]], 
          Times[ 4.4301513824290571*^+76, 
            Power[ x, 3]], 
          Times[ -4.7461934505132848*^+75, 
            Power[ x, 4]], 
          Times[ 2.6988822939357088*^+74, 
            Power[ x, 5]], 
          Times[ -9.0327557672935896*^+72, 
            Power[ x, 6]], 
          Times[ 1.9074115181183655*^+71, 
            Power[ x, 7]], 
          Times[ -2.6693509957095715*^+69, 
            Power[ x, 8]], 
          Times[ 2.5655564124811135*^+67, 
            Power[ x, 9]], 
          Times[ -1.7376839289549633*^+65, 
            Power[ x, 10]], 
          Times[ 8.4430541281641924*^+62, 
            Power[ x, 11]], 
          Times[ -2.9732380503551269*^+60, 
            Power[ x, 12]], 
          Times[ 7.6005667944983716*^+57, 
            Power[ x, 13]], 
          Times[ -1.3941250716258873*^+55, 
            Power[ x, 14]], 
          Times[ 1.7639084838269624*^+52, 
            Power[ x, 15]], 
          Times[ -1.3511741283168683*^+49, 
            Power[ x, 16]], 
          Times[ 2.2025517557540867*^+45, 
            Power[ x, 17]], 
          Times[ 8.4524826989072226*^+42, 
            Power[ x, 18]], 
          Times[ -1.1516526302080325*^+40, 
            Power[ x, 19]], 
          Times[ 7.9003645820540799*^+36, 
            Power[ x, 20]], 
          Times[ -3.1450483491191104*^+33, 
            Power[ x, 21]], 
          Times[ 5.908641702728189*^+29, 
            Power[ x, 22]], 
          Times[ 4.4303837901875802*^+25, 
            Power[ x, 23]], 
          Times[ -3.5981899948684873*^+22, 
            Power[ x, 24]], 
          Times[ -5.5090328835893125*^+18, 
            Power[ x, 25]], 
          Times[ 7298102143938457.0, 
            Power[ x, 26]], 
          Times[ -2252368210847.3555, 
            Power[ x, 27]], 
          Times[ 354037784.84032065, 
            Power[ x, 28]], 
          Times[ -29155.318202896102, 
            Power[ x, 29]], 
          Power[ x, 30]]],
      Editable->False]], "Print"],

Cell[BoxData[
    \({3.44999999999998863`\ Second, Null}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(MemoryInUse[]\)], "Input"],

Cell[BoxData[
    \(1167824\)], "Output"]
}, Open  ]]
}, Closed]]
}, Closed]]
},
FrontEndVersion->"Macintosh 3.0",
ScreenRectangle->{{0, 832}, {0, 604}},
WindowSize->{764, 580},
WindowMargins->{{4, Automatic}, {Automatic, 1}},
MacintoshSystemPageSetup->"\<\
00<0001804P000000`d26_oQon@3:`8g0dL5N`?P0080001804P000000]P2:001
0000I00000400`<30?l00BL?00400@0000000000000006P801T1T00000000000
00000000004000000000000000000000\>"
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{
Cell[1709, 49, 1280, 21, 628, "Subsection"],

Cell[CellGroupData[{
Cell[3014, 74, 154, 4, 68, "Section"],

Cell[CellGroupData[{
Cell[3193, 82, 106, 3, 44, "Subsection"],
Cell[3302, 87, 58, 1, 27, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[3397, 93, 132, 4, 44, "Subsection"],
Cell[3532, 99, 71, 1, 27, "Input"],
Cell[3606, 102, 142, 2, 43, "Input"],

Cell[CellGroupData[{
Cell[3773, 108, 141, 2, 27, "Input"],
Cell[3917, 112, 298, 6, 22, "Print"],
Cell[4218, 120, 298, 6, 22, "Print"],
Cell[4519, 128, 298, 6, 22, "Print"],
Cell[4820, 136, 300, 6, 22, "Print"],
Cell[5123, 144, 302, 6, 22, "Print"],
Cell[5428, 152, 306, 6, 22, "Print"],
Cell[5737, 160, 308, 6, 22, "Print"],
Cell[6048, 168, 312, 6, 22, "Print"],
Cell[6363, 176, 316, 6, 22, "Print"],
Cell[6682, 184, 320, 6, 22, "Print"],
Cell[7005, 192, 326, 6, 22, "Print"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{
Cell[7380, 204, 54, 0, 28, "Subsection"],

Cell[CellGroupData[{
Cell[7459, 208, 142, 2, 43, "Input"],
Cell[7604, 212, 175, 3, 37, "Message"]
}, Open  ]],

Cell[CellGroupData[{
Cell[7816, 220, 46, 1, 27, "Input"],
Cell[7865, 223, 40, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[7942, 229, 102, 1, 27, "Input"],
Cell[8047, 232, 38, 1, 22, "Print"],
Cell[8088, 235, 300, 6, 22, "Print"],
Cell[8391, 243, 37, 1, 22, "Print"],
Cell[8431, 246, 330, 7, 38, "Print"],
Cell[8764, 255, 37, 1, 22, "Print"],
Cell[8804, 258, 342, 7, 38, "Print"],
Cell[9149, 267, 37, 1, 22, "Print"],
Cell[9189, 270, 354, 7, 38, "Print"],
Cell[9546, 279, 37, 1, 22, "Print"],
Cell[9586, 282, 372, 7, 38, "Print"],
Cell[9961, 291, 37, 1, 22, "Print"],
Cell[10001, 294, 405, 8, 38, "Print"],
Cell[10409, 304, 37, 1, 22, "Print"],
Cell[10449, 307, 441, 8, 38, "Print"],
Cell[10893, 317, 37, 1, 22, "Print"],
Cell[10933, 320, 507, 11, 38, "Print"],
Cell[11443, 333, 37, 1, 22, "Print"],
Cell[11483, 336, 557, 11, 38, "Print"],
Cell[12043, 349, 37, 1, 22, "Print"],
Cell[12083, 352, 605, 11, 38, "Print"],
Cell[12691, 365, 37, 1, 22, "Print"],
Cell[12731, 368, 665, 14, 38, "Print"],
Cell[13399, 384, 37, 1, 22, "Print"],
Cell[13439, 387, 726, 15, 52, "Print"],
Cell[14168, 404, 37, 1, 22, "Print"],
Cell[14208, 407, 786, 15, 82, "Print"],
Cell[14997, 424, 37, 1, 22, "Print"],
Cell[15037, 427, 854, 15, 82, "Print"],
Cell[15894, 444, 37, 1, 22, "Print"],
Cell[15934, 447, 928, 15, 82, "Print"],
Cell[16865, 464, 37, 1, 22, "Print"],
Cell[16905, 467, 1024, 19, 82, "Print"],
Cell[17932, 488, 37, 1, 22, "Print"],
Cell[17972, 491, 1116, 19, 97, "Print"],
Cell[19091, 512, 37, 1, 22, "Print"],
Cell[19131, 515, 1216, 19, 112, "Print"],
Cell[20350, 536, 37, 1, 22, "Print"],
Cell[20390, 539, 1325, 22, 112, "Print"],
Cell[21718, 563, 37, 1, 22, "Print"],
Cell[21758, 566, 1452, 23, 112, "Print"],
Cell[23213, 591, 37, 1, 22, "Print"],
Cell[23253, 594, 1572, 23, 142, "Print"],
Cell[24828, 619, 37, 1, 22, "Print"],
Cell[24868, 622, 1702, 27, 142, "Print"],
Cell[26573, 651, 37, 1, 22, "Print"],
Cell[26613, 654, 1828, 27, 142, "Print"],
Cell[28444, 683, 37, 1, 22, "Print"],
Cell[28484, 686, 1959, 30, 172, "Print"],
Cell[30446, 718, 37, 1, 22, "Print"],
Cell[30486, 721, 2124, 31, 172, "Print"],
Cell[32613, 754, 37, 1, 22, "Print"],
Cell[32653, 757, 2283, 34, 202, "Print"],
Cell[34939, 793, 37, 1, 22, "Print"],
Cell[34979, 796, 2460, 35, 202, "Print"],
Cell[37442, 833, 37, 1, 22, "Print"],
Cell[37482, 836, 2626, 39, 232, "Print"],
Cell[40111, 877, 37, 1, 22, "Print"],
Cell[40151, 880, 2790, 39, 232, "Print"],
Cell[42944, 921, 37, 1, 22, "Print"],
Cell[42984, 924, 2970, 43, 232, "Print"],
Cell[45957, 969, 37, 1, 22, "Print"],
Cell[45997, 972, 70, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[46104, 978, 46, 1, 27, "Input"],
Cell[46153, 981, 41, 1, 26, "Output"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{
Cell[46243, 988, 53, 0, 28, "Subsection"],
Cell[46299, 990, 142, 2, 43, "Input"],

Cell[CellGroupData[{
Cell[46466, 996, 46, 1, 27, "Input"],
Cell[46515, 999, 41, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[46593, 1005, 101, 1, 27, "Input"],
Cell[46697, 1008, 243, 5, 22, "Print"],
Cell[46943, 1015, 37, 1, 22, "Print"],
Cell[46983, 1018, 271, 6, 38, "Print"],
Cell[47257, 1026, 37, 1, 22, "Print"],
Cell[47297, 1029, 279, 6, 38, "Print"],
Cell[47579, 1037, 37, 1, 22, "Print"],
Cell[47619, 1040, 289, 6, 38, "Print"],
Cell[47911, 1048, 37, 1, 22, "Print"],
Cell[47951, 1051, 305, 6, 38, "Print"],
Cell[48259, 1059, 37, 1, 22, "Print"],
Cell[48299, 1062, 334, 7, 38, "Print"],
Cell[48636, 1071, 37, 1, 22, "Print"],
Cell[48676, 1074, 364, 7, 38, "Print"],
Cell[49043, 1083, 37, 1, 22, "Print"],
Cell[49083, 1086, 404, 8, 38, "Print"],
Cell[49490, 1096, 37, 1, 22, "Print"],
Cell[49530, 1099, 470, 10, 38, "Print"],
Cell[50003, 1111, 37, 1, 22, "Print"],
Cell[50043, 1114, 518, 10, 38, "Print"],
Cell[50564, 1126, 37, 1, 22, "Print"],
Cell[50604, 1129, 583, 12, 38, "Print"],
Cell[51190, 1143, 37, 1, 22, "Print"],
Cell[51230, 1146, 623, 13, 54, "Print"],
Cell[51856, 1161, 37, 1, 22, "Print"],
Cell[51896, 1164, 693, 14, 82, "Print"],
Cell[52592, 1180, 37, 1, 22, "Print"],
Cell[52632, 1183, 757, 14, 82, "Print"],
Cell[53392, 1199, 37, 1, 22, "Print"],
Cell[53432, 1202, 829, 14, 82, "Print"],
Cell[54264, 1218, 37, 1, 22, "Print"],
Cell[54304, 1221, 904, 16, 82, "Print"],
Cell[55211, 1239, 37, 1, 22, "Print"],
Cell[55251, 1242, 1009, 18, 82, "Print"],
Cell[56263, 1262, 37, 1, 22, "Print"],
Cell[56303, 1265, 1105, 18, 112, "Print"],
Cell[57411, 1285, 37, 1, 22, "Print"],
Cell[57451, 1288, 1222, 20, 112, "Print"],
Cell[58676, 1310, 37, 1, 22, "Print"],
Cell[58716, 1313, 1331, 22, 112, "Print"],
Cell[60050, 1337, 37, 1, 22, "Print"],
Cell[60090, 1340, 1449, 22, 142, "Print"],
Cell[61542, 1364, 37, 1, 22, "Print"],
Cell[61582, 1367, 1568, 25, 142, "Print"],
Cell[63153, 1394, 37, 1, 22, "Print"],
Cell[63193, 1397, 1703, 26, 142, "Print"],
Cell[64899, 1425, 37, 1, 22, "Print"],
Cell[64939, 1428, 1833, 26, 172, "Print"],
Cell[66775, 1456, 37, 1, 22, "Print"],
Cell[66815, 1459, 1985, 30, 172, "Print"],
Cell[68803, 1491, 37, 1, 22, "Print"],
Cell[68843, 1494, 2143, 30, 172, "Print"],
Cell[70989, 1526, 37, 1, 22, "Print"],
Cell[71029, 1529, 2315, 34, 202, "Print"],
Cell[73347, 1565, 37, 1, 22, "Print"],
Cell[73387, 1568, 2477, 34, 202, "Print"],
Cell[75867, 1604, 37, 1, 22, "Print"],
Cell[75907, 1607, 2645, 38, 232, "Print"],
Cell[78555, 1647, 37, 1, 22, "Print"],
Cell[78595, 1650, 2815, 39, 232, "Print"],
Cell[81413, 1691, 37, 1, 22, "Print"],
Cell[81453, 1694, 70, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[81560, 1700, 46, 1, 27, "Input"],
Cell[81609, 1703, 41, 1, 26, "Output"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{
Cell[81699, 1710, 60, 0, 28, "Subsection"],

Cell[CellGroupData[{
Cell[81784, 1714, 140, 2, 43, "Input"],
Cell[81927, 1718, 36, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[82000, 1724, 46, 1, 27, "Input"],
Cell[82049, 1727, 41, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[82127, 1733, 84, 1, 27, "Input"],
Cell[82214, 1736, 567, 12, 22, "Print"],
Cell[82784, 1750, 600, 13, 22, "Print"],
Cell[83387, 1765, 716, 17, 38, "Print"],
Cell[84106, 1784, 846, 21, 40, "Print"],
Cell[84955, 1807, 979, 25, 40, "Print"],
Cell[85937, 1834, 1163, 29, 77, "Print"],
Cell[87103, 1865, 1383, 34, 95, "Print"],
Cell[88489, 1901, 1692, 39, 149, "Print"],
Cell[90184, 1942, 2038, 44, 186, "Print"],
Cell[92225, 1988, 2785, 69, 312, "Print"],
Cell[95013, 2059, 3396, 81, 384, "Print"],
Cell[98412, 2142, 4003, 88, 421, "Print"],
Cell[102418, 2232, 4706, 96, 503, "Print"],
Cell[107127, 2330, 5322, 103, 623, "Print"],
Cell[112452, 2435, 6354, 130, 760, "Print"],
Cell[118809, 2567, 7417, 163, 1041, "Print"],
Cell[126229, 2732, 8781, 187, 1110, "Print"],
Cell[135013, 2921, 10124, 199, 1239, "Print"],
Cell[145140, 3122, 11760, 215, 1458, "Print"],
Cell[156903, 3339, 13467, 243, 1602, "Print"],
Cell[170373, 3584, 15409, 269, 1986, "Print"],
Cell[185785, 3855, 17720, 327, 2190, "Print"],
Cell[203508, 4184, 19861, 342, 2439, "Print"],
Cell[223372, 4528, 22249, 375, 2628, "Print"],
Cell[245624, 4905, 24963, 406, 2772, "Print"],
Cell[270590, 5313, 28097, 436, 3456, "Print"],
Cell[298690, 5751, 31467, 510, 3720, "Print"],
Cell[330160, 6263, 35111, 555, 4014, "Print"],
Cell[365274, 6820, 38705, 589, 4728, "Print"],
Cell[403982, 7411, 42866, 648, 5007, "Print"],
Cell[446851, 8061, 46713, 725, 5391, "Print"],
Cell[493567, 8788, 70, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[493674, 8794, 46, 1, 27, "Input"],
Cell[493723, 8797, 41, 1, 26, "Output"]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[493825, 8805, 187, 5, 48, "Section"],

Cell[CellGroupData[{
Cell[494037, 8814, 106, 3, 44, "Subsection"],
Cell[494146, 8819, 58, 1, 27, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[494241, 8825, 54, 0, 44, "Subsection"],
Cell[494298, 8827, 142, 2, 43, "Input"],

Cell[CellGroupData[{
Cell[494465, 8833, 46, 1, 27, "Input"],
Cell[494514, 8836, 40, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[494591, 8842, 121, 4, 27, "Input"],
Cell[494715, 8848, 38, 1, 22, "Print"],
Cell[494756, 8851, 477, 11, 22, "Print"],
Cell[495236, 8864, 37, 1, 22, "Print"],
Cell[495276, 8867, 509, 11, 22, "Print"],
Cell[495788, 8880, 37, 1, 22, "Print"],
Cell[495828, 8883, 508, 11, 22, "Print"],
Cell[496339, 8896, 37, 1, 22, "Print"],
Cell[496379, 8899, 509, 11, 22, "Print"],
Cell[496891, 8912, 37, 1, 22, "Print"],
Cell[496931, 8915, 508, 11, 22, "Print"],
Cell[497442, 8928, 37, 1, 22, "Print"],
Cell[497482, 8931, 508, 11, 22, "Print"],
Cell[497993, 8944, 37, 1, 22, "Print"],
Cell[498033, 8947, 509, 11, 22, "Print"],
Cell[498545, 8960, 37, 1, 22, "Print"],
Cell[498585, 8963, 508, 11, 22, "Print"],
Cell[499096, 8976, 37, 1, 22, "Print"],
Cell[499136, 8979, 509, 11, 22, "Print"],
Cell[499648, 8992, 37, 1, 22, "Print"],
Cell[499688, 8995, 510, 11, 22, "Print"],
Cell[500201, 9008, 37, 1, 22, "Print"],
Cell[500241, 9011, 511, 11, 22, "Print"],
Cell[500755, 9024, 37, 1, 22, "Print"],
Cell[500795, 9027, 510, 11, 22, "Print"],
Cell[501308, 9040, 37, 1, 22, "Print"],
Cell[501348, 9043, 511, 11, 22, "Print"],
Cell[501862, 9056, 37, 1, 22, "Print"],
Cell[501902, 9059, 510, 11, 22, "Print"],
Cell[502415, 9072, 37, 1, 22, "Print"],
Cell[502455, 9075, 511, 11, 22, "Print"],
Cell[502969, 9088, 37, 1, 22, "Print"],
Cell[503009, 9091, 511, 11, 22, "Print"],
Cell[503523, 9104, 37, 1, 22, "Print"],
Cell[503563, 9107, 509, 11, 22, "Print"],
Cell[504075, 9120, 37, 1, 22, "Print"],
Cell[504115, 9123, 511, 11, 22, "Print"],
Cell[504629, 9136, 37, 1, 22, "Print"],
Cell[504669, 9139, 510, 11, 22, "Print"],
Cell[505182, 9152, 37, 1, 22, "Print"],
Cell[505222, 9155, 511, 11, 22, "Print"],
Cell[505736, 9168, 37, 1, 22, "Print"],
Cell[505776, 9171, 513, 11, 24, "Print"],
Cell[506292, 9184, 37, 1, 22, "Print"],
Cell[506332, 9187, 514, 11, 24, "Print"],
Cell[506849, 9200, 37, 1, 22, "Print"],
Cell[506889, 9203, 511, 11, 22, "Print"],
Cell[507403, 9216, 37, 1, 22, "Print"],
Cell[507443, 9219, 544, 12, 24, "Print"],
Cell[507990, 9233, 37, 1, 22, "Print"],
Cell[508030, 9236, 545, 12, 24, "Print"],
Cell[508578, 9250, 37, 1, 22, "Print"],
Cell[508618, 9253, 514, 11, 24, "Print"],
Cell[509135, 9266, 37, 1, 22, "Print"],
Cell[509175, 9269, 514, 11, 24, "Print"],
Cell[509692, 9282, 37, 1, 22, "Print"],
Cell[509732, 9285, 513, 11, 24, "Print"],
Cell[510248, 9298, 37, 1, 22, "Print"],
Cell[510288, 9301, 544, 12, 24, "Print"],
Cell[510835, 9315, 37, 1, 22, "Print"],
Cell[510875, 9318, 545, 12, 24, "Print"],
Cell[511423, 9332, 37, 1, 22, "Print"],
Cell[511463, 9335, 70, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[511570, 9341, 46, 1, 27, "Input"],
Cell[511619, 9344, 41, 1, 26, "Output"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{
Cell[511709, 9351, 53, 0, 28, "Subsection"],
Cell[511765, 9353, 142, 2, 43, "Input"],

Cell[CellGroupData[{
Cell[511932, 9359, 46, 1, 27, "Input"],
Cell[511981, 9362, 41, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[512059, 9368, 120, 4, 27, "Input"],
Cell[512182, 9374, 402, 10, 22, "Print"],
Cell[512587, 9386, 37, 1, 22, "Print"],
Cell[512627, 9389, 434, 10, 22, "Print"],
Cell[513064, 9401, 37, 1, 22, "Print"],
Cell[513104, 9404, 432, 10, 22, "Print"],
Cell[513539, 9416, 37, 1, 22, "Print"],
Cell[513579, 9419, 433, 10, 22, "Print"],
Cell[514015, 9431, 37, 1, 22, "Print"],
Cell[514055, 9434, 434, 10, 22, "Print"],
Cell[514492, 9446, 37, 1, 22, "Print"],
Cell[514532, 9449, 434, 10, 22, "Print"],
Cell[514969, 9461, 37, 1, 22, "Print"],
Cell[515009, 9464, 433, 10, 22, "Print"],
Cell[515445, 9476, 37, 1, 22, "Print"],
Cell[515485, 9479, 434, 10, 22, "Print"],
Cell[515922, 9491, 37, 1, 22, "Print"],
Cell[515962, 9494, 434, 10, 22, "Print"],
Cell[516399, 9506, 37, 1, 22, "Print"],
Cell[516439, 9509, 434, 10, 22, "Print"],
Cell[516876, 9521, 37, 1, 22, "Print"],
Cell[516916, 9524, 436, 10, 22, "Print"],
Cell[517355, 9536, 37, 1, 22, "Print"],
Cell[517395, 9539, 436, 10, 22, "Print"],
Cell[517834, 9551, 37, 1, 22, "Print"],
Cell[517874, 9554, 436, 10, 22, "Print"],
Cell[518313, 9566, 37, 1, 22, "Print"],
Cell[518353, 9569, 436, 10, 22, "Print"],
Cell[518792, 9581, 37, 1, 22, "Print"],
Cell[518832, 9584, 436, 10, 22, "Print"],
Cell[519271, 9596, 37, 1, 22, "Print"],
Cell[519311, 9599, 436, 10, 22, "Print"],
Cell[519750, 9611, 37, 1, 22, "Print"],
Cell[519790, 9614, 436, 10, 22, "Print"],
Cell[520229, 9626, 37, 1, 22, "Print"],
Cell[520269, 9629, 436, 10, 22, "Print"],
Cell[520708, 9641, 37, 1, 22, "Print"],
Cell[520748, 9644, 436, 10, 22, "Print"],
Cell[521187, 9656, 37, 1, 22, "Print"],
Cell[521227, 9659, 436, 10, 22, "Print"],
Cell[521666, 9671, 37, 1, 22, "Print"],
Cell[521706, 9674, 435, 10, 22, "Print"],
Cell[522144, 9686, 37, 1, 22, "Print"],
Cell[522184, 9689, 436, 10, 22, "Print"],
Cell[522623, 9701, 37, 1, 22, "Print"],
Cell[522663, 9704, 436, 10, 22, "Print"],
Cell[523102, 9716, 37, 1, 22, "Print"],
Cell[523142, 9719, 436, 10, 22, "Print"],
Cell[523581, 9731, 37, 1, 22, "Print"],
Cell[523621, 9734, 467, 11, 22, "Print"],
Cell[524091, 9747, 37, 1, 22, "Print"],
Cell[524131, 9750, 436, 10, 22, "Print"],
Cell[524570, 9762, 37, 1, 22, "Print"],
Cell[524610, 9765, 436, 10, 22, "Print"],
Cell[525049, 9777, 37, 1, 22, "Print"],
Cell[525089, 9780, 467, 11, 22, "Print"],
Cell[525559, 9793, 37, 1, 22, "Print"],
Cell[525599, 9796, 436, 10, 22, "Print"],
Cell[526038, 9808, 37, 1, 22, "Print"],
Cell[526078, 9811, 465, 11, 22, "Print"],
Cell[526546, 9824, 37, 1, 22, "Print"],
Cell[526586, 9827, 70, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[526693, 9833, 46, 1, 27, "Input"],
Cell[526742, 9836, 41, 1, 26, "Output"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{
Cell[526832, 9843, 60, 0, 28, "Subsection"],
Cell[526895, 9845, 142, 2, 43, "Input"],

Cell[CellGroupData[{
Cell[527062, 9851, 46, 1, 27, "Input"],
Cell[527111, 9854, 41, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[527189, 9860, 93, 1, 27, "Input"],
Cell[527285, 9863, 485, 11, 22, "Print"],
Cell[527773, 9876, 572, 14, 22, "Print"],
Cell[528348, 9892, 846, 20, 24, "Print"],
Cell[529197, 9914, 1059, 26, 24, "Print"],
Cell[530259, 9942, 1303, 32, 39, "Print"],
Cell[531565, 9976, 1515, 38, 41, "Print"],
Cell[533083, 10016, 1722, 43, 41, "Print"],
Cell[534808, 10061, 1985, 50, 58, "Print"],
Cell[536796, 10113, 2189, 55, 58, "Print"],
Cell[538988, 10170, 2453, 62, 73, "Print"],
Cell[541444, 10234, 2661, 67, 75, "Print"],
Cell[544108, 10303, 2950, 74, 75, "Print"],
Cell[547061, 10379, 3160, 79, 75, "Print"],
Cell[550224, 10460, 3430, 86, 92, "Print"],
Cell[553657, 10548, 3646, 91, 92, "Print"],
Cell[557306, 10641, 3917, 98, 107, "Print"],
Cell[561226, 10741, 4126, 103, 109, "Print"],
Cell[565355, 10846, 4398, 110, 109, "Print"],
Cell[569756, 10958, 4603, 115, 109, "Print"],
Cell[574362, 11075, 4875, 122, 126, "Print"],
Cell[579240, 11199, 5087, 127, 126, "Print"],
Cell[584330, 11328, 5360, 134, 143, "Print"],
Cell[589693, 11464, 5556, 139, 143, "Print"],
Cell[595252, 11605, 5831, 146, 143, "Print"],
Cell[601086, 11753, 6041, 151, 143, "Print"],
Cell[607130, 11906, 6279, 157, 160, "Print"],
Cell[613412, 12065, 6557, 164, 160, "Print"],
Cell[619972, 12231, 6765, 169, 160, "Print"],
Cell[626740, 12402, 7002, 175, 177, "Print"],
Cell[633745, 12579, 7269, 182, 177, "Print"],
Cell[641017, 12763, 7513, 188, 194, "Print"],
Cell[648533, 12953, 70, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[648640, 12959, 46, 1, 27, "Input"],
Cell[648689, 12962, 41, 1, 26, "Output"]
}, Open  ]]
}, Closed]]
}, Closed]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

