(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 3.0,
MathReader 3.0, or any compatible application. The data for the notebook 
starts with the line of stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[   1056466,      29398]*)
(*NotebookOutlinePosition[   1057306,      29425]*)
(*  CellTagsIndexPosition[   1057262,      29421]*)
(*WindowFrame->Normal*)



Notebook[{
Cell[TextData[{
  " :Author:  Z\[EAcute]lia da ROCHA \n\n:Address: \n            Departamento \
de Matem\[AAcute]tica Aplicada da\n            Faculdade de Ci\[EHat]ncias do \
Porto\n            Rua das Taipas, 135\n            4050 Porto\n            \
Portugal\n  \n            Tel: ++351 02 2080313\n            Fax: ++351 02 \
2004109\n            Email: mrdioh@fc.up.pt\n\n :Summary:\n    The ",
  StyleBox["testshfv6",
    FontSize->18],
  " notebook contains the results produced by the package\n    shfv.m \
corresponding to the ",
  StyleBox["example 6",
    FontSize->18],
  " of the first paper cited bellow.    \n\n :Date:  July 1999. \n\n\
:Available at http://netlib.bell-labs.com/ in the numeralgo library in \
netlib:     \n\n :Notebook Version: 1.0 \n\n :Mathematica Version: 3.0   \n \n\
 :Keywords: Shohat-Favard's method, regular forms, d-dimensional canonical \
forms, \n d-orthogonal polynomial sequences.\n\n :Sources:\n \n - \
Z\[EAcute]lia da Rocha, Shohat-Favard and Chebyshev's methods in \
d-orthogonality, \n Numerical Algorithms, 20 (1999) 139 - 164.\n   \n - About \
the example treated here see p.286,293,294 of\n   K. Douak, The relation of \
the d-orthogonal polynomials to the Appell \npolynomials,  J. Comput. Appl. \
Math., 70 (1996) 279-295.\n"
}], "Subsection"],

Cell[CellGroupData[{

Cell["\<\
Computing the moments of the d-dimensional canonical form \
performing formal computations\
\>", "Section",
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell["\<\
Loading the package shfv.m, the package datashfv6.m is \
automatically loaded\
\>", "Subsection"],

Cell[BoxData[
    \(\(<< shohatfavard`shfv`\ ; \)\)], "Input"]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
The recurrence coefficients are given in the package \
datashfv6.m\
\>", "Subsection",
  AspectRatioFixed->True],

Cell[BoxData[
    \( (*\ showing\ the\ recurrence\ coefficients\ given\ *) \)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\( (*\ set\ the\ values\ of\ d\ and\ imax\ *) \nd = 5; imax = \ 10; 
    \ \ \ \ \ \  (*\ for\ example\ *) \)\)], "Input"],

Cell[BoxData[
    \(General::"spell1" \( : \ \) 
      "Possible spelling error: new symbol name \"\!\(imax\)\" is similar to \
existing symbol \"\!\(nmax\)\"."\)], "Message"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(Do[\ 
      Do[Print["\<gamma[\>", d, "\<,\>", r, "\<,\>", n, "\<]=\>", \n
          \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \
\ gamma[d, r, n]\ ], \ \ \ \ \ \ \ \n
        \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ {n, 1, imax + r - d + 1}]; 
      Print["\<  \>"], \ \n\ \ \ \ \ \ {r, 0, d - 1}]\ \)\)], "Input"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]0
        \[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]"]="\[InvisibleSpace]1\/6\),
      SequenceForm[ "gamma[", 5, ",", 0, ",", 1, "]=", 
        Rational[ 1, 6]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]0
        \[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]"]="\[InvisibleSpace]1\),
      SequenceForm[ "gamma[", 5, ",", 0, ",", 2, "]=", 1],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]0
        \[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]"]="\[InvisibleSpace]7\/2\),
      SequenceForm[ "gamma[", 5, ",", 0, ",", 3, "]=", 
        Rational[ 7, 2]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]0
        \[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]"]="\[InvisibleSpace]28\/3\),
      SequenceForm[ "gamma[", 5, ",", 0, ",", 4, "]=", 
        Rational[ 28, 3]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]0
        \[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]"]="\[InvisibleSpace]21\),
      SequenceForm[ "gamma[", 5, ",", 0, ",", 5, "]=", 21],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]0
        \[InvisibleSpace]","\[InvisibleSpace]6
        \[InvisibleSpace]"]="\[InvisibleSpace]42\),
      SequenceForm[ "gamma[", 5, ",", 0, ",", 6, "]=", 42],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gamma[", 5, ",", 1, ",", 1, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gamma[", 5, ",", 1, ",", 2, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gamma[", 5, ",", 1, ",", 3, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gamma[", 5, ",", 1, ",", 4, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gamma[", 5, ",", 1, ",", 5, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]6
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gamma[", 5, ",", 1, ",", 6, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]7
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gamma[", 5, ",", 1, ",", 7, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gamma[", 5, ",", 2, ",", 1, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gamma[", 5, ",", 2, ",", 2, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gamma[", 5, ",", 2, ",", 3, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gamma[", 5, ",", 2, ",", 4, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gamma[", 5, ",", 2, ",", 5, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]6
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gamma[", 5, ",", 2, ",", 6, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]7
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gamma[", 5, ",", 2, ",", 7, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]8
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gamma[", 5, ",", 2, ",", 8, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gamma[", 5, ",", 3, ",", 1, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gamma[", 5, ",", 3, ",", 2, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gamma[", 5, ",", 3, ",", 3, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gamma[", 5, ",", 3, ",", 4, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gamma[", 5, ",", 3, ",", 5, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]6
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gamma[", 5, ",", 3, ",", 6, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]7
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gamma[", 5, ",", 3, ",", 7, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]8
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gamma[", 5, ",", 3, ",", 8, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]9
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gamma[", 5, ",", 3, ",", 9, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gamma[", 5, ",", 4, ",", 1, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gamma[", 5, ",", 4, ",", 2, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gamma[", 5, ",", 4, ",", 3, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gamma[", 5, ",", 4, ",", 4, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gamma[", 5, ",", 4, ",", 5, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]6
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gamma[", 5, ",", 4, ",", 6, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]7
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gamma[", 5, ",", 4, ",", 7, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]8
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gamma[", 5, ",", 4, ",", 8, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]9
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gamma[", 5, ",", 4, ",", 9, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]10
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gamma[", 5, ",", 4, ",", 10, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(\ Do[Print["\<beta[\>", d, "\<,\>", n, "\<]=\>", beta[d, n]\ ], 
      \ \ \ \ \ \ \ \n\ \ \ \ \ \ \ \ \ \ {n, 0, imax - 1}]\)\)], "Input"],

Cell[BoxData[
    InterpretationBox[
      \("beta["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]0
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "beta[", 5, ",", 0, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("beta["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "beta[", 5, ",", 1, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("beta["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "beta[", 5, ",", 2, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("beta["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "beta[", 5, ",", 3, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("beta["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "beta[", 5, ",", 4, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("beta["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "beta[", 5, ",", 5, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("beta["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]6
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "beta[", 5, ",", 6, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("beta["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]7
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "beta[", 5, ",", 7, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("beta["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]8
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "beta[", 5, ",", 8, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("beta["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]9
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "beta[", 5, ",", 9, "]=", 0],
      Editable->False]], "Print"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["\<\
The exact expressions of the moments of the d-dimensional form are \
given in the package datashfv6.m\
\>", "Subsection"],

Cell[BoxData[
    \(\( (*\ set\ the\ values\ of\ d\ and\ nmax\ *) \nd = 5; \ 
    nmax = \ 10\ \ ; \ \ \  (*\ for\ example\ *) \)\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Timing[\n\t
      Do[Do[Print["\<formexact[\>", d "\<,\>", r, "\<,\>", i, "\<]=\>", \n
            \t\t\t\t\ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ 
            formexact[d, r, i]\ ], {i, 0, imax}]; \n\t\t\ \ \ \ \ 
        Print["\<   \>"], {r, 1, d}\ ]\n\ \ \ \ \ \ \ \ \ \ \ \ \ \ \ ]\)], 
  "Input"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]\(5\ ","\)\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]0
        \[InvisibleSpace]"]="\[InvisibleSpace]1\),
      SequenceForm[ "formexact[", 
        Times[ 5, ","], 1, ",", 0, "]=", 1],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]\(5\ ","\)\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 
        Times[ 5, ","], 1, ",", 1, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]\(5\ ","\)\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 
        Times[ 5, ","], 1, ",", 2, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]\(5\ ","\)\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 
        Times[ 5, ","], 1, ",", 3, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]\(5\ ","\)\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 
        Times[ 5, ","], 1, ",", 4, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]\(5\ ","\)\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 
        Times[ 5, ","], 1, ",", 5, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]\(5\ ","\)\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]6
        \[InvisibleSpace]"]="\[InvisibleSpace]1\/6\),
      SequenceForm[ "formexact[", 
        Times[ 5, ","], 1, ",", 6, "]=", 
        Rational[ 1, 6]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]\(5\ ","\)\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]7
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 
        Times[ 5, ","], 1, ",", 7, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]\(5\ ","\)\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]8
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 
        Times[ 5, ","], 1, ",", 8, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]\(5\ ","\)\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]9
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 
        Times[ 5, ","], 1, ",", 9, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]\(5\ ","\)\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]10
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 
        Times[ 5, ","], 1, ",", 10, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("   "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]\(5\ ","\)\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]0
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 
        Times[ 5, ","], 2, ",", 0, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]\(5\ ","\)\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]"]="\[InvisibleSpace]1\),
      SequenceForm[ "formexact[", 
        Times[ 5, ","], 2, ",", 1, "]=", 1],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]\(5\ ","\)\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 
        Times[ 5, ","], 2, ",", 2, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]\(5\ ","\)\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 
        Times[ 5, ","], 2, ",", 3, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]\(5\ ","\)\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 
        Times[ 5, ","], 2, ",", 4, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]\(5\ ","\)\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 
        Times[ 5, ","], 2, ",", 5, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]\(5\ ","\)\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]6
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 
        Times[ 5, ","], 2, ",", 6, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]\(5\ ","\)\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]7
        \[InvisibleSpace]"]="\[InvisibleSpace]7\/6\),
      SequenceForm[ "formexact[", 
        Times[ 5, ","], 2, ",", 7, "]=", 
        Rational[ 7, 6]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]\(5\ ","\)\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]8
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 
        Times[ 5, ","], 2, ",", 8, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]\(5\ ","\)\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]9
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 
        Times[ 5, ","], 2, ",", 9, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]\(5\ ","\)\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]10
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 
        Times[ 5, ","], 2, ",", 10, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("   "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]\(5\ ","\)\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]0
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 
        Times[ 5, ","], 3, ",", 0, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]\(5\ ","\)\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 
        Times[ 5, ","], 3, ",", 1, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]\(5\ ","\)\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]"]="\[InvisibleSpace]1\),
      SequenceForm[ "formexact[", 
        Times[ 5, ","], 3, ",", 2, "]=", 1],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]\(5\ ","\)\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 
        Times[ 5, ","], 3, ",", 3, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]\(5\ ","\)\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 
        Times[ 5, ","], 3, ",", 4, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]\(5\ ","\)\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 
        Times[ 5, ","], 3, ",", 5, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]\(5\ ","\)\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]6
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 
        Times[ 5, ","], 3, ",", 6, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]\(5\ ","\)\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]7
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 
        Times[ 5, ","], 3, ",", 7, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]\(5\ ","\)\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]8
        \[InvisibleSpace]"]="\[InvisibleSpace]14\/3\),
      SequenceForm[ "formexact[", 
        Times[ 5, ","], 3, ",", 8, "]=", 
        Rational[ 14, 3]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]\(5\ ","\)\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]9
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 
        Times[ 5, ","], 3, ",", 9, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]\(5\ ","\)\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]10
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 
        Times[ 5, ","], 3, ",", 10, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("   "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]\(5\ ","\)\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]0
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 
        Times[ 5, ","], 4, ",", 0, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]\(5\ ","\)\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 
        Times[ 5, ","], 4, ",", 1, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]\(5\ ","\)\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 
        Times[ 5, ","], 4, ",", 2, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]\(5\ ","\)\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]"]="\[InvisibleSpace]1\),
      SequenceForm[ "formexact[", 
        Times[ 5, ","], 4, ",", 3, "]=", 1],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]\(5\ ","\)\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 
        Times[ 5, ","], 4, ",", 4, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]\(5\ ","\)\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 
        Times[ 5, ","], 4, ",", 5, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]\(5\ ","\)\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]6
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 
        Times[ 5, ","], 4, ",", 6, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]\(5\ ","\)\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]7
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 
        Times[ 5, ","], 4, ",", 7, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]\(5\ ","\)\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]8
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 
        Times[ 5, ","], 4, ",", 8, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]\(5\ ","\)\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]9
        \[InvisibleSpace]"]="\[InvisibleSpace]14\),
      SequenceForm[ "formexact[", 
        Times[ 5, ","], 4, ",", 9, "]=", 14],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]\(5\ ","\)\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]10
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 
        Times[ 5, ","], 4, ",", 10, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("   "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]\(5\ ","\)\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]0
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 
        Times[ 5, ","], 5, ",", 0, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]\(5\ ","\)\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 
        Times[ 5, ","], 5, ",", 1, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]\(5\ ","\)\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 
        Times[ 5, ","], 5, ",", 2, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]\(5\ ","\)\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 
        Times[ 5, ","], 5, ",", 3, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]\(5\ ","\)\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]"]="\[InvisibleSpace]1\),
      SequenceForm[ "formexact[", 
        Times[ 5, ","], 5, ",", 4, "]=", 1],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]\(5\ ","\)\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 
        Times[ 5, ","], 5, ",", 5, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]\(5\ ","\)\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]6
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 
        Times[ 5, ","], 5, ",", 6, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]\(5\ ","\)\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]7
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 
        Times[ 5, ","], 5, ",", 7, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]\(5\ ","\)\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]8
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 
        Times[ 5, ","], 5, ",", 8, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]\(5\ ","\)\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]9
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 
        Times[ 5, ","], 5, ",", 9, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]\(5\ ","\)\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]10
        \[InvisibleSpace]"]="\[InvisibleSpace]35\),
      SequenceForm[ "formexact[", 
        Times[ 5, ","], 5, ",", 10, "]=", 35],
      Editable->False]], "Print"],

Cell[BoxData[
    \("   "\)], "Print"],

Cell[BoxData[
    \({18.2833333333333314`\ Second, Null}\)], "Output"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Computing the moments of the d-dimensional form", "Subsection"],

Cell[BoxData[
    \(\( (*\ set\ the\ values\ of\ d\ and\ nmax\ *) \nd = 5; \ nmax = \ 10; 
    \ \ \  (*\ for\ example\ *) \)\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(MemoryInUse[]\)], "Input"],

Cell[BoxData[
    \(897904\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Timing[printdcanform[d,nmax,Infinity,$MachinePrecision,True,False]]\
\
\>", "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    \("   "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]0
        \[InvisibleSpace]"]="\[InvisibleSpace]1\),
      SequenceForm[ "form[", 5, ",", 1, ",", 0, "]=", 1],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]0
        \[InvisibleSpace]"]="\[InvisibleSpace]1\),
      SequenceForm[ "formexact[", 5, ",", 1, ",", 0, "]=", 1],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 1, ",", 1, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 1, ",", 1, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 1, ",", 2, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 1, ",", 2, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 1, ",", 3, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 1, ",", 3, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 1, ",", 4, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 1, ",", 4, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 1, ",", 5, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 1, ",", 5, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]6
        \[InvisibleSpace]"]="\[InvisibleSpace]1\/6\),
      SequenceForm[ "form[", 5, ",", 1, ",", 6, "]=", 
        Rational[ 1, 6]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]6
        \[InvisibleSpace]"]="\[InvisibleSpace]1\/6\),
      SequenceForm[ "formexact[", 5, ",", 1, ",", 6, "]=", 
        Rational[ 1, 6]],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]7
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 1, ",", 7, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]7
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 1, ",", 7, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]8
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 1, ",", 8, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]8
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 1, ",", 8, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]9
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 1, ",", 9, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]9
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 1, ",", 9, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]10
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 1, ",", 10, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]10
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 1, ",", 10, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    \("   "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]0
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 2, ",", 0, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]0
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 2, ",", 0, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]"]="\[InvisibleSpace]1\),
      SequenceForm[ "form[", 5, ",", 2, ",", 1, "]=", 1],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]"]="\[InvisibleSpace]1\),
      SequenceForm[ "formexact[", 5, ",", 2, ",", 1, "]=", 1],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 2, ",", 2, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 2, ",", 2, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 2, ",", 3, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 2, ",", 3, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 2, ",", 4, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 2, ",", 4, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 2, ",", 5, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 2, ",", 5, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]6
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 2, ",", 6, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]6
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 2, ",", 6, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]7
        \[InvisibleSpace]"]="\[InvisibleSpace]7\/6\),
      SequenceForm[ "form[", 5, ",", 2, ",", 7, "]=", 
        Rational[ 7, 6]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]7
        \[InvisibleSpace]"]="\[InvisibleSpace]7\/6\),
      SequenceForm[ "formexact[", 5, ",", 2, ",", 7, "]=", 
        Rational[ 7, 6]],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]8
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 2, ",", 8, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]8
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 2, ",", 8, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]9
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 2, ",", 9, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]9
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 2, ",", 9, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]10
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 2, ",", 10, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]10
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 2, ",", 10, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    \("   "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]0
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 3, ",", 0, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]0
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 3, ",", 0, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 3, ",", 1, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 3, ",", 1, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]"]="\[InvisibleSpace]1\),
      SequenceForm[ "form[", 5, ",", 3, ",", 2, "]=", 1],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]"]="\[InvisibleSpace]1\),
      SequenceForm[ "formexact[", 5, ",", 3, ",", 2, "]=", 1],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 3, ",", 3, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 3, ",", 3, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 3, ",", 4, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 3, ",", 4, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 3, ",", 5, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 3, ",", 5, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]6
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 3, ",", 6, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]6
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 3, ",", 6, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]7
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 3, ",", 7, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]7
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 3, ",", 7, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]8
        \[InvisibleSpace]"]="\[InvisibleSpace]14\/3\),
      SequenceForm[ "form[", 5, ",", 3, ",", 8, "]=", 
        Rational[ 14, 3]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]8
        \[InvisibleSpace]"]="\[InvisibleSpace]14\/3\),
      SequenceForm[ "formexact[", 5, ",", 3, ",", 8, "]=", 
        Rational[ 14, 3]],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]9
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 3, ",", 9, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]9
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 3, ",", 9, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]10
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 3, ",", 10, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]10
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 3, ",", 10, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    \("   "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]0
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 4, ",", 0, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]0
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 4, ",", 0, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 4, ",", 1, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 4, ",", 1, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 4, ",", 2, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 4, ",", 2, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]"]="\[InvisibleSpace]1\),
      SequenceForm[ "form[", 5, ",", 4, ",", 3, "]=", 1],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]"]="\[InvisibleSpace]1\),
      SequenceForm[ "formexact[", 5, ",", 4, ",", 3, "]=", 1],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 4, ",", 4, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 4, ",", 4, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 4, ",", 5, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 4, ",", 5, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]6
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 4, ",", 6, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]6
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 4, ",", 6, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]7
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 4, ",", 7, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]7
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 4, ",", 7, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]8
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 4, ",", 8, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]8
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 4, ",", 8, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]9
        \[InvisibleSpace]"]="\[InvisibleSpace]14\),
      SequenceForm[ "form[", 5, ",", 4, ",", 9, "]=", 14],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]9
        \[InvisibleSpace]"]="\[InvisibleSpace]14\),
      SequenceForm[ "formexact[", 5, ",", 4, ",", 9, "]=", 14],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]10
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 4, ",", 10, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]10
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 4, ",", 10, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    \("   "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]0
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 5, ",", 0, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]0
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 5, ",", 0, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 5, ",", 1, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 5, ",", 1, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 5, ",", 2, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 5, ",", 2, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 5, ",", 3, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 5, ",", 3, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]"]="\[InvisibleSpace]1\),
      SequenceForm[ "form[", 5, ",", 5, ",", 4, "]=", 1],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]"]="\[InvisibleSpace]1\),
      SequenceForm[ "formexact[", 5, ",", 5, ",", 4, "]=", 1],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 5, ",", 5, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 5, ",", 5, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]6
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 5, ",", 6, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]6
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 5, ",", 6, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]7
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 5, ",", 7, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]7
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 5, ",", 7, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]8
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 5, ",", 8, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]8
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 5, ",", 8, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]9
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 5, ",", 9, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]9
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 5, ",", 9, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]10
        \[InvisibleSpace]"]="\[InvisibleSpace]35\),
      SequenceForm[ "form[", 5, ",", 5, ",", 10, "]=", 35],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]10
        \[InvisibleSpace]"]="\[InvisibleSpace]35\),
      SequenceForm[ "formexact[", 5, ",", 5, ",", 10, "]=", 35],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    \({30.1499999999999923`\ Second, Null}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(MemoryInUse[]\)], "Input"],

Cell[BoxData[
    \(905320\)], "Output"]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Computing the moments of the d-dimensional canonical form  \
performing numerical computations with the machine precision\
\>", "Section",
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell["\<\
Loading the package shfv.m, the package datashfv6.m is \
automatically loaded\
\>", "Subsection"],

Cell[BoxData[
    \(\(<< shohatfavard`shfv`\ ; \)\)], "Input"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Computing the moments of the d-dimensional form", "Subsection"],

Cell[BoxData[
    \(\( (*\ set\ the\ values\ of\ d\ and\ nmax\ *) \nd = 5; \ 
    nmax = \ 180\ ; \ \ \ \  (*\ for\ example\ *) \)\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(MemoryInUse[]\)], "Input"],

Cell[BoxData[
    \(906576\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Timing[printdcanform[d,nmax,$MachinePrecision,$MachinePrecision,\
True,True]]\
\>", "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    \("   "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("form["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["1.`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "form[", 5, ",", 1, ",", 0, "]=", 1.0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("formexact["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["1.`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "formexact[", 5, ",", 1, ",", 0, "]=", 1.0],
      Editable->False]], "Print"],

Cell[BoxData[
    \(MantissaExponent::"realx" \( : \ \) 
      "\!\(1\) is not an inexact real number."\)], "Message"],

Cell[BoxData[
    \(Part::"partw" \( : \ \) 
      "Part \!\(2\) of \!\(MantissaExponent[1]\) does not exist."\)], 
  "Message"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        InterpretationBox["\[Infinity]",
          DirectedInfinity[ 1]]}],
      SequenceForm[ "exactdigits[", 5, ",", 1, ",", 0, "]=", 
        DirectedInfinity[ 1]],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 1, ",", 1, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 1, ",", 1, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 1, ",", 1, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 1, ",", 2, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 1, ",", 2, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 1, ",", 2, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 1, ",", 3, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 1, ",", 3, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 1, ",", 3, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 1, ",", 4, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 1, ",", 4, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 1, ",", 4, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 1, ",", 5, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 1, ",", 5, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 1, ",", 5, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("form["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "6", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["0.166666666666666651`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "form[", 5, ",", 1, ",", 6, "]=", 0.16666666666666666],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("formexact["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "6", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["0.166666666666666651`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "formexact[", 5, ",", 1, ",", 6, "]=", 0.16666666666666666],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "6", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        InterpretationBox["\[Infinity]",
          DirectedInfinity[ 1]]}],
      SequenceForm[ "exactdigits[", 5, ",", 1, ",", 6, "]=", 
        DirectedInfinity[ 1]],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]7
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 1, ",", 7, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]7
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 1, ",", 7, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]7
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 1, ",", 7, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]8
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 1, ",", 8, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]8
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 1, ",", 8, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]8
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 1, ",", 8, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]9
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 1, ",", 9, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]9
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 1, ",", 9, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]9
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 1, ",", 9, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]10
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 1, ",", 10, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]10
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 1, ",", 10, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]10
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 1, ",", 10, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]11
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 1, ",", 11, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]11
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 1, ",", 11, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]11
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 1, ",", 11, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("form["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "12", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["12.8333333333333321`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "form[", 5, ",", 1, ",", 12, "]=", 12.833333333333332],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("formexact["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "12", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["12.8333333333333342`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "formexact[", 5, ",", 1, ",", 12, "]=", 12.833333333333334],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "12", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["15.7504697875350752`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 5, ",", 1, ",", 12, "]=", 15.750469787535074],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]13
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 1, ",", 13, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]13
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 1, ",", 13, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]13
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 1, ",", 13, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]14
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 1, ",", 14, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]14
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 1, ",", 14, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]14
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 1, ",", 14, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]15
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 1, ",", 15, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]15
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 1, ",", 15, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]15
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 1, ",", 15, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]16
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 1, ",", 16, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]16
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 1, ",", 16, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]16
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 1, ",", 16, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]17
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 1, ",", 17, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]17
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 1, ",", 17, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]17
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 1, ",", 17, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("form["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "18", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["13235.4444444444441`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "form[", 5, ",", 1, ",", 18, "]=", 13235.444444444442],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("formexact["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "18", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["13235.4444444444441`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "formexact[", 5, ",", 1, ",", 18, "]=", 13235.444444444445],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "18", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["15.439139835231284`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 5, ",", 1, ",", 18, "]=", 15.439139835231284],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]19
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 1, ",", 19, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]19
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 1, ",", 19, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]19
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 1, ",", 19, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]20
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 1, ",", 20, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]20
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 1, ",", 20, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]20
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 1, ",", 20, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]21
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 1, ",", 21, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]21
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 1, ",", 21, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]21
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 1, ",", 21, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]22
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 1, ",", 22, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]22
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 1, ",", 22, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]22
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 1, ",", 22, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]23
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 1, ",", 23, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]23
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 1, ",", 23, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]23
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 1, ",", 23, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("form["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "24", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["7.4226578351851824`*^7",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "form[", 5, ",", 1, ",", 24, "]=", 74226578.351851821],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("formexact["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "24", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["7.42265783518518595`*^7",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "formexact[", 5, ",", 1, ",", 24, "]=", 74226578.351851851],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "24", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["14.5257498915995286`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 5, ",", 1, ",", 24, "]=", 14.52574989159953],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]25
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 1, ",", 25, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]25
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 1, ",", 25, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]25
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 1, ",", 25, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]26
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 1, ",", 26, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]26
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 1, ",", 26, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]26
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 1, ",", 26, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]27
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 1, ",", 27, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]27
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 1, ",", 27, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]27
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 1, ",", 27, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]28
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 1, ",", 28, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]28
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 1, ",", 28, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]28
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 1, ",", 28, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]29
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 1, ",", 29, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]29
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 1, ",", 29, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]29
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 1, ",", 29, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("form["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "30", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["1.46912955202902821`*^12",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "form[", 5, ",", 1, ",", 30, "]=", 1469129552029.0283],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("formexact["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "30", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["1.46912955202902768`*^12",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "formexact[", 5, ",", 1, ",", 30, "]=", 1469129552029.0278],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "30", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["15.3113299523037937`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 5, ",", 1, ",", 30, "]=", 15.311329952303794],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]31
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 1, ",", 31, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]31
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 1, ",", 31, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]31
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 1, ",", 31, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]32
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 1, ",", 32, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]32
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 1, ",", 32, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]32
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 1, ",", 32, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]33
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 1, ",", 33, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]33
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 1, ",", 33, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]33
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 1, ",", 33, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]34
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 1, ",", 34, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]34
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 1, ",", 34, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]34
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 1, ",", 34, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]35
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 1, ",", 35, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]35
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 1, ",", 35, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]35
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 1, ",", 35, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("form["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "36", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["7.94877441223812475`*^16",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "form[", 5, ",", 1, ",", 36, "]=", 79487744122381248.0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("formexact["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "36", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["7.94877441223812475`*^16",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "formexact[", 5, ",", 1, ",", 36, "]=", 79487744122381232.0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "36", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["14.795880017344074`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 5, ",", 1, ",", 36, "]=", 14.795880017344075],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]37
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 1, ",", 37, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]37
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 1, ",", 37, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]37
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 1, ",", 37, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]38
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 1, ",", 38, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]38
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 1, ",", 38, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]38
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 1, ",", 38, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]39
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 1, ",", 39, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]39
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 1, ",", 39, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]39
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 1, ",", 39, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]40
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 1, ",", 40, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]40
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 1, ",", 40, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]40
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 1, ",", 40, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]41
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 1, ",", 41, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]41
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 1, ",", 41, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]41
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 1, ",", 41, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("form["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "42", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["9.92799274497051875`*^21",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "form[", 5, ",", 1, ",", 42, "]=", 9.9279927449705177*^+21],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("formexact["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "42", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["9.92799274497070527`*^21",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "formexact[", 5, ",", 1, ",", 42, "]=", 9.9279927449707065*^+21],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "42", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["12.7241275816170706`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 5, ",", 1, ",", 42, "]=", 12.72412758161707],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]43
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 1, ",", 43, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]43
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 1, ",", 43, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]43
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 1, ",", 43, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]44
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 1, ",", 44, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]44
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 1, ",", 44, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]44
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 1, ",", 44, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]45
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 1, ",", 45, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]45
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 1, ",", 45, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]45
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 1, ",", 45, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]46
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 1, ",", 46, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]46
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 1, ",", 46, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]46
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 1, ",", 46, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]47
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 1, ",", 47, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]47
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 1, ",", 47, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]47
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 1, ",", 47, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("form["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "48", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["2.53815587720429336`*^27",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "form[", 5, ",", 1, ",", 48, "]=", 2.5381558772042935*^+27],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("formexact["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "48", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["2.53815587720460378`*^27",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "formexact[", 5, ",", 1, ",", 48, "]=", 2.5381558772046036*^+27],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "48", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["12.5085510651213915`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 5, ",", 1, ",", 48, "]=", 12.508551065121392],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]49
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 1, ",", 49, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]49
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 1, ",", 49, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]49
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 1, ",", 49, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]50
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 1, ",", 50, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]50
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 1, ",", 50, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]50
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 1, ",", 50, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]51
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 1, ",", 51, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]51
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 1, ",", 51, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]51
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 1, ",", 51, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]52
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 1, ",", 52, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]52
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 1, ",", 52, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]52
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 1, ",", 52, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]53
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 1, ",", 53, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]53
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 1, ",", 53, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]53
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 1, ",", 53, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("form["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "54", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["1.21395130807873785`*^33",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "form[", 5, ",", 1, ",", 54, "]=", 1.2139513080787379*^+33],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("formexact["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "54", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["1.21395130807931539`*^33",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "formexact[", 5, ",", 1, ",", 54, "]=", 1.2139513080793155*^+33],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "54", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["12.238362534293885`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 5, ",", 1, ",", 54, "]=", 12.238362534293884],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]55
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 1, ",", 55, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]55
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 1, ",", 55, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]55
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 1, ",", 55, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]56
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 1, ",", 56, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]56
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 1, ",", 56, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]56
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 1, ",", 56, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]57
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 1, ",", 57, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]57
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 1, ",", 57, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]57
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 1, ",", 57, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]58
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 1, ",", 58, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]58
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 1, ",", 58, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]58
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 1, ",", 58, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]59
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 1, ",", 59, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]59
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 1, ",", 59, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]59
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 1, ",", 59, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("form["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "60", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["1.0129181389067885`*^39",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "form[", 5, ",", 1, ",", 60, "]=", 1.0129181389067884*^+39],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("formexact["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "60", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["1.01291813890832882`*^39",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "formexact[", 5, ",", 1, ",", 60, "]=", 1.0129181389083287*^+39],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "60", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["11.8123883096614479`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 5, ",", 1, ",", 60, "]=", 11.812388309661447],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]61
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 1, ",", 61, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]61
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 1, ",", 61, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]61
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 1, ",", 61, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]62
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 1, ",", 62, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]62
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 1, ",", 62, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]62
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 1, ",", 62, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]63
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 1, ",", 63, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]63
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 1, ",", 63, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]63
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 1, ",", 63, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]64
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 1, ",", 64, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]64
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 1, ",", 64, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]64
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 1, ",", 64, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]65
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 1, ",", 65, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]65
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 1, ",", 65, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]65
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 1, ",", 65, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("form["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "66", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["1.39443173008567322`*^45",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "form[", 5, ",", 1, ",", 66, "]=", 1.3944317300856735*^+45],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("formexact["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "66", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["1.39443173009187271`*^45",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "formexact[", 5, ",", 1, ",", 66, "]=", 1.3944317300918728*^+45],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "66", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["11.2076582709636629`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 5, ",", 1, ",", 66, "]=", 11.207658270963663],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]67
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 1, ",", 67, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]67
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 1, ",", 67, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]67
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 1, ",", 67, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]68
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 1, ",", 68, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]68
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 1, ",", 68, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]68
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 1, ",", 68, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]69
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 1, ",", 69, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]69
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 1, ",", 69, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]69
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 1, ",", 69, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]70
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 1, ",", 70, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]70
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 1, ",", 70, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]70
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 1, ",", 70, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]71
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 1, ",", 71, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]71
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 1, ",", 71, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]71
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 1, ",", 71, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("form["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "72", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["3.02589570538067098`*^51",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "form[", 5, ",", 1, ",", 72, "]=", 3.0258957053806713*^+51],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("formexact["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "72", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["3.02589570541812458`*^51",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "formexact[", 5, ",", 1, ",", 72, "]=", 3.0258957054181243*^+51],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "72", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["10.4265134749516752`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 5, ",", 1, ",", 72, "]=", 10.426513474951676],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]73
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 1, ",", 73, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]73
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 1, ",", 73, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]73
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 1, ",", 73, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]74
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 1, ",", 74, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]74
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 1, ",", 74, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]74
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 1, ",", 74, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]75
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 1, ",", 75, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]75
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 1, ",", 75, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]75
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 1, ",", 75, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]76
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 1, ",", 76, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]76
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 1, ",", 76, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]76
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 1, ",", 76, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]77
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 1, ",", 77, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]77
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 1, ",", 77, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]77
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 1, ",", 77, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("form["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "78", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["9.96418125915977981`*^57",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "form[", 5, ",", 1, ",", 78, "]=", 9.9641812591597778*^+57],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("formexact["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "78", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["9.96418125949096555`*^57",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "formexact[", 5, ",", 1, ",", 78, "]=", 9.9641812594909662*^+57],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "78", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["9.47992492629847305`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 5, ",", 1, ",", 78, "]=", 9.4799249262984731],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]79
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 1, ",", 79, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]79
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 1, ",", 79, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]79
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 1, ",", 79, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]80
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 1, ",", 80, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]80
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 1, ",", 80, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]80
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 1, ",", 80, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]81
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 1, ",", 81, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]81
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 1, ",", 81, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]81
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 1, ",", 81, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]82
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 1, ",", 82, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]82
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 1, ",", 82, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]82
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 1, ",", 82, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]83
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 1, ",", 83, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]83
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 1, ",", 83, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]83
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 1, ",", 83, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("form["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "84", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["4.82173307464644196`*^64",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "form[", 5, ",", 1, ",", 84, "]=", 4.8217330746464425*^+64],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("formexact["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "84", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["4.82173307506399062`*^64",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "formexact[", 5, ",", 1, ",", 84, "]=", 4.8217330750639917*^+64],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "84", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["9.37929227751213545`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 5, ",", 1, ",", 84, "]=", 9.3792922775121355],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]85
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 1, ",", 85, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]85
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 1, ",", 85, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]85
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 1, ",", 85, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]86
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 1, ",", 86, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]86
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 1, ",", 86, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]86
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 1, ",", 86, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]87
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 1, ",", 87, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]87
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 1, ",", 87, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]87
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 1, ",", 87, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]88
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 1, ",", 88, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]88
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 1, ",", 88, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]88
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 1, ",", 88, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]89
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 1, ",", 89, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]89
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 1, ",", 89, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]89
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 1, ",", 89, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("form["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "90", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["3.33564617092120752`*^71",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "form[", 5, ",", 1, ",", 90, "]=", 3.3356461709212072*^+71],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("formexact["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "90", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["3.33564617165525456`*^71",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "formexact[", 5, ",", 1, ",", 90, "]=", 3.3356461716552544*^+71],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "90", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["9.13427600216322588`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 5, ",", 1, ",", 90, "]=", 9.1342760021632259],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]91
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 1, ",", 91, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]91
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 1, ",", 91, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]91
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 1, ",", 91, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]92
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 1, ",", 92, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]92
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 1, ",", 92, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]92
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 1, ",", 92, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]93
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 1, ",", 93, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]93
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 1, ",", 93, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]93
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 1, ",", 93, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]94
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 1, ",", 94, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]94
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 1, ",", 94, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]94
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 1, ",", 94, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]95
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 1, ",", 95, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]95
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 1, ",", 95, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]95
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 1, ",", 95, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("form["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "96", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["3.22115117134890516`*^78",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "form[", 5, ",", 1, ",", 96, "]=", 3.2211511713489056*^+78],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("formexact["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "96", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["3.22115117310114262`*^78",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "formexact[", 5, ",", 1, ",", 96, "]=", 3.2211511731011425*^+78],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "96", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["8.75640717337252283`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 5, ",", 1, ",", 96, "]=", 8.7564071733725228],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]97
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 1, ",", 97, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]97
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 1, ",", 97, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]97
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 1, ",", 97, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]98
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 1, ",", 98, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]98
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 1, ",", 98, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]98
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 1, ",", 98, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]99
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 1, ",", 99, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]99
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 1, ",", 99, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]99
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 1, ",", 99, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]100
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 1, ",", 100, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]100
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 1, ",", 100, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]100
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 1, ",", 100, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]101
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 1, ",", 101, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]101
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 1, ",", 101, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]101
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 1, ",", 101, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("form["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "102", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["4.25238902585472011`*^85",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "form[", 5, ",", 1, ",", 102, "]=", 4.2523890258547209*^+85],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("formexact["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "102", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["4.25238903127698719`*^85",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "formexact[", 5, ",", 1, ",", 102, "]=", 4.2523890312769868*^+85],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "102", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["8.26581918792057024`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 5, ",", 1, ",", 102, "]=", 8.2658191879205702],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]103
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 1, ",", 103, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]103
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 1, ",", 103, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]103
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 1, ",", 103, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]104
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 1, ",", 104, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]104
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 1, ",", 104, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]104
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 1, ",", 104, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]105
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 1, ",", 105, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]105
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 1, ",", 105, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]105
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 1, ",", 105, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]106
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 1, ",", 106, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]106
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 1, ",", 106, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]106
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 1, ",", 106, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]107
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 1, ",", 107, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]107
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 1, ",", 107, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]107
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 1, ",", 107, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("form["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "108", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["7.53442297978323427`*^92",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "form[", 5, ",", 1, ",", 108, "]=", 7.5344229797832349*^+92],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("formexact["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "108", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["7.53442299981976226`*^92",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "formexact[", 5, ",", 1, ",", 108, "]=", 7.5344229998197614*^+92],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "108", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["7.69817756515494977`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 5, ",", 1, ",", 108, "]=", 7.6981775651549498],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]109
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 1, ",", 109, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]109
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 1, ",", 109, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]109
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 1, ",", 109, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]110
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 1, ",", 110, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]110
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 1, ",", 110, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]110
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 1, ",", 110, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]111
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 1, ",", 111, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]111
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 1, ",", 111, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]111
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 1, ",", 111, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]112
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 1, ",", 112, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]112
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 1, ",", 112, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]112
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 1, ",", 112, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]113
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 1, ",", 113, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]113
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 1, ",", 113, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]113
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 1, ",", 113, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("form["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "114", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["1.76260958970631858`*^100",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "form[", 5, ",", 1, ",", 114, "]=", 1.7626095897063184*^+100],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("formexact["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "114", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["1.76260959709956139`*^100",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "formexact[", 5, ",", 1, ",", 114, "]=", 1.7626095970995614*^+100],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "114", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["8.13116502055939349`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 5, ",", 1, ",", 114, "]=", 8.1311650205593935],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]115
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 1, ",", 115, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]115
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 1, ",", 115, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]115
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 1, ",", 115, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]116
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 1, ",", 116, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]116
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 1, ",", 116, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]116
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 1, ",", 116, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]117
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 1, ",", 117, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]117
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 1, ",", 117, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]117
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 1, ",", 117, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]118
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 1, ",", 118, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]118
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 1, ",", 118, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]118
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 1, ",", 118, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]119
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 1, ",", 119, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]119
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 1, ",", 119, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]119
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 1, ",", 119, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("form["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "120", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["5.36530349658074534`*^107",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "form[", 5, ",", 1, ",", 120, "]=", 5.3653034965807461*^+107],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("formexact["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "120", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["5.36530350296487767`*^107",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "formexact[", 5, ",", 1, ",", 120, "]=", 5.3653035029648769*^+107],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "120", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["8.19489822904017728`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 5, ",", 1, ",", 120, "]=", 8.1948982290401773],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]121
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 1, ",", 121, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]121
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 1, ",", 121, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]121
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 1, ",", 121, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]122
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 1, ",", 122, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]122
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 1, ",", 122, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]122
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 1, ",", 122, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]123
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 1, ",", 123, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]123
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 1, ",", 123, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]123
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 1, ",", 123, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]124
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 1, ",", 124, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]124
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 1, ",", 124, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]124
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 1, ",", 124, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]125
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 1, ",", 125, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]125
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 1, ",", 125, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]125
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 1, ",", 125, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("form["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "126", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["2.09721917637681398`*^115",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "form[", 5, ",", 1, ",", 126, "]=", 2.097219176376814*^+115],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("formexact["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "126", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["2.09721911885386536`*^115",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "formexact[", 5, ",", 1, ",", 126, "]=", 2.097219118853865*^+115],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "126", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["7.24015885674599246`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 5, ",", 1, ",", 126, "]=", 7.2401588567459925],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]127
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 1, ",", 127, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]127
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 1, ",", 127, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]127
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 1, ",", 127, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]128
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 1, ",", 128, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]128
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 1, ",", 128, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]128
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 1, ",", 128, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]129
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 1, ",", 129, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]129
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 1, ",", 129, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]129
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 1, ",", 129, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]130
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 1, ",", 130, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]130
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 1, ",", 130, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]130
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 1, ",", 130, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]131
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 1, ",", 131, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]131
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 1, ",", 131, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]131
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 1, ",", 131, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("form["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "132", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["1.04023013167448796`*^123",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "form[", 5, ",", 1, ",", 132, "]=", 1.0402301316744879*^+123],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("formexact["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "132", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["1.04022996664148292`*^123",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "formexact[", 5, ",", 1, ",", 132, "]=", 1.040229966641483*^+123],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "132", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["6.78242919284363665`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 5, ",", 1, ",", 132, "]=", 6.7824291928436367],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]133
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 1, ",", 133, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]133
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 1, ",", 133, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]133
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 1, ",", 133, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]134
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 1, ",", 134, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]134
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 1, ",", 134, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]134
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 1, ",", 134, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]135
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 1, ",", 135, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]135
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 1, ",", 135, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]135
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 1, ",", 135, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]136
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 1, ",", 136, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]136
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 1, ",", 136, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]136
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 1, ",", 136, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]137
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 1, ",", 137, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]137
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 1, ",", 137, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]137
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 1, ",", 137, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("form["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "138", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["6.47659632404872454`*^130",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "form[", 5, ",", 1, ",", 138, "]=", 6.4765963240487246*^+130],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("formexact["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "138", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["6.47659212691701391`*^130",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "formexact[", 5, ",", 1, ",", 138, "]=", 6.476592126917014*^+130],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "138", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["5.37704740193940722`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 5, ",", 1, ",", 138, "]=", 5.3770474019394072],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]139
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 1, ",", 139, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]139
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 1, ",", 139, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]139
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 1, ",", 139, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]140
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 1, ",", 140, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]140
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 1, ",", 140, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]140
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 1, ",", 140, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]141
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 1, ",", 141, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]141
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 1, ",", 141, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]141
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 1, ",", 141, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]142
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 1, ",", 142, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]142
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 1, ",", 142, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]142
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 1, ",", 142, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]143
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 1, ",", 143, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]143
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 1, ",", 143, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]143
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 1, ",", 143, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("form["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "144", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["5.01188824053002601`*^138",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "form[", 5, ",", 1, ",", 144, "]=", 5.0118882405300266*^+138],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("formexact["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "144", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["5.01187673974582281`*^138",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "formexact[", 5, ",", 1, ",", 144, "]=", 5.0118767397458234*^+138],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "144", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["4.93927254543177696`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 5, ",", 1, ",", 144, "]=", 4.939272545431777],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]145
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 1, ",", 145, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]145
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 1, ",", 145, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]145
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 1, ",", 145, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]146
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 1, ",", 146, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]146
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 1, ",", 146, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]146
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 1, ",", 146, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]147
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 1, ",", 147, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]147
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 1, ",", 147, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]147
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 1, ",", 147, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]148
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 1, ",", 148, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]148
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 1, ",", 148, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]148
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 1, ",", 148, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]149
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 1, ",", 149, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]149
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 1, ",", 149, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]149
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 1, ",", 149, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("form["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "150", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["4.77702269049955852`*^146",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "form[", 5, ",", 1, ",", 150, "]=", 4.7770226904995596*^+146],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("formexact["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "150", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["4.77698702545044451`*^146",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "formexact[", 5, ",", 1, ",", 150, "]=", 4.7769870254504451*^+146],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "150", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["4.44775717357413213`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 5, ",", 1, ",", 150, "]=", 4.4477571735741321],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]151
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 1, ",", 151, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]151
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 1, ",", 151, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]151
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 1, ",", 151, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]152
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 1, ",", 152, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]152
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 1, ",", 152, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]152
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 1, ",", 152, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]153
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 1, ",", 153, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]153
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 1, ",", 153, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]153
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 1, ",", 153, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]154
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 1, ",", 154, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]154
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 1, ",", 154, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]154
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 1, ",", 154, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]155
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 1, ",", 155, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]155
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 1, ",", 155, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]155
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 1, ",", 155, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("form["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "156", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["5.56154992742922527`*^154",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "form[", 5, ",", 1, ",", 156, "]=", 5.5615499274292257*^+154],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("formexact["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "156", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["5.56142327815007142`*^154",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "formexact[", 5, ",", 1, ",", 156, "]=", 5.5614232781500713*^+154],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "156", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["3.89739727772621336`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 5, ",", 1, ",", 156, "]=", 3.8973972777262134],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]157
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 1, ",", 157, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]157
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 1, ",", 157, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]157
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 1, ",", 157, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]158
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 1, ",", 158, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]158
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 1, ",", 158, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]158
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 1, ",", 158, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]159
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 1, ",", 159, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]159
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 1, ",", 159, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]159
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 1, ",", 159, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]160
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 1, ",", 160, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]160
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 1, ",", 160, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]160
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 1, ",", 160, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]161
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 1, ",", 161, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]161
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 1, ",", 161, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]161
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 1, ",", 161, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("form["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "162", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["7.84840923087037634`*^162",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "form[", 5, ",", 1, ",", 162, "]=", 7.8484092308703757*^+162],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("formexact["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "162", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["7.84789486395911684`*^162",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "formexact[", 5, ",", 1, ",", 162, "]=", 7.8478948639591181*^+162],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "162", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["3.28872697694316684`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 5, ",", 1, ",", 162, "]=", 3.2887269769431668],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]163
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 1, ",", 163, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]163
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 1, ",", 163, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]163
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 1, ",", 163, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]164
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 1, ",", 164, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]164
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 1, ",", 164, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]164
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 1, ",", 164, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]165
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 1, ",", 165, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]165
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 1, ",", 165, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]165
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 1, ",", 165, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]166
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 1, ",", 166, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]166
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 1, ",", 166, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]166
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 1, ",", 166, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]167
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 1, ",", 167, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]167
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 1, ",", 167, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]167
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 1, ",", 167, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("form["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "168", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["1.33302475289405153`*^171",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "form[", 5, ",", 1, ",", 168, "]=", 1.3330247528940515*^+171],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("formexact["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "168", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["1.33278665547591956`*^171",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "formexact[", 5, ",", 1, ",", 168, "]=", 1.3327866554759192*^+171],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "168", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["3.62324531394827431`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 5, ",", 1, ",", 168, "]=", 3.6232453139482743],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]169
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 1, ",", 169, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]169
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 1, ",", 169, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]169
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 1, ",", 169, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]170
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 1, ",", 170, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]170
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 1, ",", 170, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]170
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 1, ",", 170, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]171
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 1, ",", 171, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]171
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 1, ",", 171, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]171
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 1, ",", 171, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]172
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 1, ",", 172, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]172
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 1, ",", 172, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]172
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 1, ",", 172, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]173
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 1, ",", 173, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]173
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 1, ",", 173, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]173
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 1, ",", 173, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("form["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "174", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["2.70729920017372105`*^179",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "form[", 5, ",", 1, ",", 174, "]=", 2.7072992001737211*^+179],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("formexact["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "174", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["2.70604133191784868`*^179",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "formexact[", 5, ",", 1, ",", 174, "]=", 2.706041331917849*^+179],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "174", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["2.9003648427889459`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 5, ",", 1, ",", 174, "]=", 2.9003648427889459],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]175
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 1, ",", 175, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]175
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 1, ",", 175, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]175
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 1, ",", 175, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]176
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 1, ",", 176, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]176
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 1, ",", 176, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]176
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 1, ",", 176, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]177
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 1, ",", 177, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]177
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 1, ",", 177, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]177
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 1, ",", 177, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]178
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 1, ",", 178, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]178
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 1, ",", 178, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]178
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 1, ",", 178, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]179
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 1, ",", 179, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]179
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 1, ",", 179, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]179
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 1, ",", 179, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("form["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "180", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["6.53595928550422922`*^187",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "form[", 5, ",", 1, ",", 180, "]=", 6.5359592855042275*^+187],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("formexact["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "180", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["6.52828258920841086`*^187",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "formexact[", 5, ",", 1, ",", 180, "]=", 6.5282825892084103*^+187],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "180", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["2.11482564053940791`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 5, ",", 1, ",", 180, "]=", 2.1148256405394079],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    \("   "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]0
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 2, ",", 0, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]0
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 2, ",", 0, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]0
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 2, ",", 0, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("form["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["1.`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "form[", 5, ",", 2, ",", 1, "]=", 1.0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("formexact["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["1.`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "formexact[", 5, ",", 2, ",", 1, "]=", 1.0],
      Editable->False]], "Print"],

Cell[BoxData[
    \(MantissaExponent::"realx" \( : \ \) 
      "\!\(1\) is not an inexact real number."\)], "Message"],

Cell[BoxData[
    \(Part::"partw" \( : \ \) 
      "Part \!\(2\) of \!\(MantissaExponent[1]\) does not exist."\)], 
  "Message"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        InterpretationBox["\[Infinity]",
          DirectedInfinity[ 1]]}],
      SequenceForm[ "exactdigits[", 5, ",", 2, ",", 1, "]=", 
        DirectedInfinity[ 1]],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 2, ",", 2, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 2, ",", 2, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 2, ",", 2, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 2, ",", 3, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 2, ",", 3, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 2, ",", 3, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 2, ",", 4, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 2, ",", 4, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 2, ",", 4, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 2, ",", 5, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 2, ",", 5, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 2, ",", 5, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]6
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 2, ",", 6, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]6
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 2, ",", 6, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]6
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 2, ",", 6, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("form["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "7", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["1.16666666666666674`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "form[", 5, ",", 2, ",", 7, "]=", 1.1666666666666667],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("formexact["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "7", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["1.16666666666666674`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "formexact[", 5, ",", 2, ",", 7, "]=", 1.1666666666666667],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "7", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        InterpretationBox["\[Infinity]",
          DirectedInfinity[ 1]]}],
      SequenceForm[ "exactdigits[", 5, ",", 2, ",", 7, "]=", 
        DirectedInfinity[ 1]],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]8
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 2, ",", 8, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]8
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 2, ",", 8, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]8
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 2, ",", 8, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]9
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 2, ",", 9, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]9
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 2, ",", 9, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]9
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 2, ",", 9, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]10
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 2, ",", 10, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]10
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 2, ",", 10, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]10
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 2, ",", 10, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]11
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 2, ",", 11, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]11
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 2, ",", 11, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]11
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 2, ",", 11, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]12
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 2, ",", 12, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]12
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 2, ",", 12, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]12
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 2, ",", 12, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("form["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "13", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["166.833333333333344`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "form[", 5, ",", 2, ",", 13, "]=", 166.83333333333334],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("formexact["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "13", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["166.833333333333344`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "formexact[", 5, ",", 2, ",", 13, "]=", 166.83333333333334],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "13", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        InterpretationBox["\[Infinity]",
          DirectedInfinity[ 1]]}],
      SequenceForm[ "exactdigits[", 5, ",", 2, ",", 13, "]=", 
        DirectedInfinity[ 1]],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]14
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 2, ",", 14, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]14
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 2, ",", 14, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]14
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 2, ",", 14, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]15
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 2, ",", 15, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]15
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 2, ",", 15, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]15
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 2, ",", 15, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]16
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 2, ",", 16, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]16
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 2, ",", 16, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]16
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 2, ",", 16, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]17
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 2, ",", 17, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]17
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 2, ",", 17, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]17
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 2, ",", 17, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]18
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 2, ",", 18, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]18
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 2, ",", 18, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]18
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 2, ",", 18, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("form["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "19", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["251473.444444444416`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "form[", 5, ",", 2, ",", 19, "]=", 251473.44444444444],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("formexact["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "19", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["251473.444444444416`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "formexact[", 5, ",", 2, ",", 19, "]=", 251473.44444444444],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "19", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        InterpretationBox["\[Infinity]",
          DirectedInfinity[ 1]]}],
      SequenceForm[ "exactdigits[", 5, ",", 2, ",", 19, "]=", 
        DirectedInfinity[ 1]],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]20
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 2, ",", 20, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]20
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 2, ",", 20, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]20
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 2, ",", 20, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]21
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 2, ",", 21, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]21
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 2, ",", 21, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]21
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 2, ",", 21, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]22
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 2, ",", 22, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]22
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 2, ",", 22, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]22
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 2, ",", 22, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]23
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 2, ",", 23, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]23
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 2, ",", 23, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]23
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 2, ",", 23, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]24
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 2, ",", 24, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]24
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 2, ",", 24, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]24
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 2, ",", 24, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("form["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "25", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["1.85566445879629604`*^9",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "form[", 5, ",", 2, ",", 25, "]=", 1855664458.7962961],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("formexact["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "25", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["1.8556644587962964`*^9",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "formexact[", 5, ",", 2, ",", 25, "]=", 1855664458.7962964],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "25", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["15.6226599046075875`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 5, ",", 2, ",", 25, "]=", 15.622659904607588],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]26
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 2, ",", 26, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]26
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 2, ",", 26, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]26
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 2, ",", 26, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]27
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 2, ",", 27, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]27
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 2, ",", 27, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]27
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 2, ",", 27, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]28
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 2, ",", 28, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]28
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 2, ",", 28, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]28
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 2, ",", 28, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]29
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 2, ",", 29, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]29
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 2, ",", 29, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]29
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 2, ",", 29, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]30
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 2, ",", 30, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]30
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 2, ",", 30, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]30
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 2, ",", 30, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("form["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "31", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["4.55430161128998456`*^13",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "form[", 5, ",", 2, ",", 31, "]=", 45543016112899.844],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("formexact["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "31", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["4.55430161128998545`*^13",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "formexact[", 5, ",", 2, ",", 31, "]=", 45543016112899.859],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "31", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["14.8061799739838884`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 5, ",", 2, ",", 31, "]=", 14.806179973983888],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]32
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 2, ",", 32, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]32
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 2, ",", 32, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]32
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 2, ",", 32, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]33
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 2, ",", 33, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]33
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 2, ",", 33, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]33
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 2, ",", 33, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]34
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 2, ",", 34, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]34
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 2, ",", 34, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]34
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 2, ",", 34, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]35
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 2, ",", 35, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]35
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 2, ",", 35, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]35
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 2, ",", 35, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]36
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 2, ",", 36, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]36
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 2, ",", 36, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]36
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 2, ",", 36, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("form["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "37", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["2.94104653252808923`*^18",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "form[", 5, ",", 2, ",", 37, "]=", 2.9410465325280891*^+18],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("formexact["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "37", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["2.94104653252810521`*^18",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "formexact[", 5, ",", 2, ",", 37, "]=", 2.9410465325281055*^+18],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "37", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["13.7855800607042633`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 5, ",", 2, ",", 37, "]=", 13.785580060704264],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]38
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 2, ",", 38, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]38
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 2, ",", 38, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]38
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 2, ",", 38, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]39
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 2, ",", 39, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]39
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 2, ",", 39, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]39
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 2, ",", 39, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]40
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 2, ",", 40, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]40
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 2, ",", 40, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]40
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 2, ",", 40, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]41
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 2, ",", 41, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]41
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 2, ",", 41, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]41
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 2, ",", 41, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]42
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 2, ",", 42, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]42
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 2, ",", 42, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]42
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 2, ",", 42, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("form["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "43", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["4.26903688033729444`*^23",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "form[", 5, ",", 2, ",", 43, "]=", 4.2690368803372949*^+23],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("formexact["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "43", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["4.26903688033740458`*^23",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "formexact[", 5, ",", 2, ",", 43, "]=", 4.2690368803374043*^+23],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "43", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["12.9610325083325328`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 5, ",", 2, ",", 43, "]=", 12.961032508332533],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]44
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 2, ",", 44, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]44
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 2, ",", 44, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]44
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 2, ",", 44, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]45
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 2, ",", 45, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]45
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 2, ",", 45, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]45
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 2, ",", 45, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]46
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 2, ",", 46, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]46
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 2, ",", 46, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]46
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 2, ",", 46, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]47
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 2, ",", 47, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]47
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 2, ",", 47, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]47
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 2, ",", 47, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]48
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 2, ",", 48, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]48
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 2, ",", 48, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]48
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 2, ",", 48, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("form["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "49", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["1.24369637983016745`*^29",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "form[", 5, ",", 2, ",", 49, "]=", 1.2436963798301676*^+29],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("formexact["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "49", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["1.2436963798302556`*^29",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "formexact[", 5, ",", 2, ",", 49, "]=", 1.2436963798302558*^+29],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "49", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["13.054842464917582`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 5, ",", 2, ",", 49, "]=", 13.054842464917582],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]50
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 2, ",", 50, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]50
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 2, ",", 50, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]50
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 2, ",", 50, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]51
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 2, ",", 51, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]51
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 2, ",", 51, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]51
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 2, ",", 51, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]52
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 2, ",", 52, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]52
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 2, ",", 52, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]52
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 2, ",", 52, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]53
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 2, ",", 53, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]53
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 2, ",", 53, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]53
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 2, ",", 53, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]54
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 2, ",", 54, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]54
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 2, ",", 54, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]54
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 2, ",", 54, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("form["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "55", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["6.67673219443516252`*^34",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "form[", 5, ",", 2, ",", 55, "]=", 6.676732194435162*^+34],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("formexact["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "55", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["6.67673219443623544`*^34",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "formexact[", 5, ",", 2, ",", 55, "]=", 6.6767321944362356*^+34],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "55", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["11.9691572928553169`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 5, ",", 2, ",", 55, "]=", 11.969157292855318],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]56
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 2, ",", 56, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]56
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 2, ",", 56, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]56
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 2, ",", 56, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]57
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 2, ",", 57, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]57
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 2, ",", 57, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]57
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 2, ",", 57, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]58
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 2, ",", 58, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]58
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 2, ",", 58, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]58
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 2, ",", 58, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]59
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 2, ",", 59, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]59
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 2, ",", 59, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]59
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 2, ",", 59, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]60
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 2, ",", 60, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]60
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 2, ",", 60, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]60
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 2, ",", 60, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("form["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "61", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["6.17880064733811451`*^40",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "form[", 5, ",", 2, ",", 61, "]=", 6.1788006473381146*^+40],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("formexact["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "61", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["6.17880064734080569`*^40",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "formexact[", 5, ",", 2, ",", 61, "]=", 6.1788006473408052*^+40],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "61", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["11.5701532342335378`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 5, ",", 2, ",", 61, "]=", 11.570153234233537],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]62
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 2, ",", 62, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]62
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 2, ",", 62, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]62
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 2, ",", 62, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]63
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 2, ",", 63, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]63
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 2, ",", 63, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]63
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 2, ",", 63, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]64
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 2, ",", 64, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]64
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 2, ",", 64, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]64
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 2, ",", 64, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]65
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 2, ",", 65, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]65
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 2, ",", 65, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]65
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 2, ",", 65, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]66
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 2, ",", 66, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]66
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 2, ",", 66, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]66
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 2, ",", 66, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("form["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "67", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["9.34269259160104859`*^46",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "form[", 5, ",", 2, ",", 67, "]=", 9.3426925916010497*^+46],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("formexact["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "67", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["9.34269259161554899`*^46",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "formexact[", 5, ",", 2, ",", 67, "]=", 9.3426925916155496*^+46],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "67", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["10.8386351538798342`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 5, ",", 2, ",", 67, "]=", 10.838635153879835],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]68
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 2, ",", 68, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]68
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 2, ",", 68, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]68
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 2, ",", 68, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]69
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 2, ",", 69, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]69
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 2, ",", 69, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]69
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 2, ",", 69, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]70
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 2, ",", 70, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]70
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 2, ",", 70, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]70
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 2, ",", 70, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]71
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 2, ",", 71, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]71
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 2, ",", 71, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]71
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 2, ",", 71, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]72
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 2, ",", 72, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]72
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 2, ",", 72, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]72
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 2, ",", 72, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("form["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "73", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["2.20890386494247126`*^53",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "form[", 5, ",", 2, ",", 73, "]=", 2.2089038649424712*^+53],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("formexact["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "73", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["2.20890386495523038`*^53",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "formexact[", 5, ",", 2, ",", 73, "]=", 2.2089038649552305*^+53],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "73", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["10.894172718902495`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 5, ",", 2, ",", 73, "]=", 10.894172718902496],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]74
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 2, ",", 74, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]74
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 2, ",", 74, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]74
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 2, ",", 74, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]75
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 2, ",", 75, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]75
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 2, ",", 75, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]75
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 2, ",", 75, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]76
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 2, ",", 76, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]76
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 2, ",", 76, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]76
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 2, ",", 76, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]77
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 2, ",", 77, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]77
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 2, ",", 77, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]77
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 2, ",", 77, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]78
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 2, ",", 78, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]78
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 2, ",", 78, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]78
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 2, ",", 78, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("form["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "79", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["7.87170319484230684`*^59",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "form[", 5, ",", 2, ",", 79, "]=", 7.8717031948423062*^+59],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("formexact["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "79", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["7.87170319499786508`*^59",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "formexact[", 5, ",", 2, ",", 79, "]=", 7.8717031949978637*^+59],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "79", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["9.80810901695074477`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 5, ",", 2, ",", 79, "]=", 9.8081090169507448],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]80
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 2, ",", 80, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]80
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 2, ",", 80, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]80
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 2, ",", 80, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]81
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 2, ",", 81, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]81
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 2, ",", 81, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]81
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 2, ",", 81, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]82
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 2, ",", 82, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]82
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 2, ",", 82, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]82
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 2, ",", 82, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]83
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 2, ",", 83, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]83
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 2, ",", 83, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]83
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 2, ",", 83, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]84
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 2, ",", 84, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]84
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 2, ",", 84, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]84
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 2, ",", 84, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("form["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "85", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["4.09847311355333498`*^66",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "form[", 5, ",", 2, ",", 85, "]=", 4.0984731135533358*^+66],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("formexact["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "85", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["4.09847311380439283`*^66",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "formexact[", 5, ",", 2, ",", 85, "]=", 4.0984731138043927*^+66],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "85", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["9.60022785265047673`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 5, ",", 2, ",", 85, "]=", 9.6002278526504767],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]86
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 2, ",", 86, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]86
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 2, ",", 86, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]86
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 2, ",", 86, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]87
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 2, ",", 87, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]87
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 2, ",", 87, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]87
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 2, ",", 87, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]88
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 2, ",", 88, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]88
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 2, ",", 88, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]88
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 2, ",", 88, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]89
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 2, ",", 89, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]89
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 2, ",", 89, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]89
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 2, ",", 89, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]90
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 2, ",", 90, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]90
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 2, ",", 90, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]90
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 2, ",", 90, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("form["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "91", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["3.03543801567661164`*^73",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "form[", 5, ",", 2, ",", 91, "]=", 3.0354380156766117*^+73],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("formexact["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "91", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["3.03543801620628173`*^73",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "formexact[", 5, ",", 2, ",", 91, "]=", 3.0354380162062817*^+73],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "91", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["9.27599462056578261`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 5, ",", 2, ",", 91, "]=", 9.2759946205657826],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]92
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 2, ",", 92, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]92
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 2, ",", 92, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]92
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 2, ",", 92, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]93
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 2, ",", 93, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]93
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 2, ",", 93, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]93
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 2, ",", 93, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]94
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 2, ",", 94, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]94
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 2, ",", 94, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]94
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 2, ",", 94, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]95
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 2, ",", 95, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]95
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 2, ",", 95, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]95
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 2, ",", 95, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]96
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 2, ",", 96, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]96
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 2, ",", 96, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]96
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 2, ",", 96, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("form["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "97", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["3.12451663646651756`*^80",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "form[", 5, ",", 2, ",", 97, "]=", 3.1245166364665177*^+80],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("formexact["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "97", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["3.1245166379081084`*^80",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "formexact[", 5, ",", 2, ",", 97, "]=", 3.1245166379081082*^+80],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "97", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["8.84115809640272232`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 5, ",", 2, ",", 97, "]=", 8.8411580964027223],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]98
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 2, ",", 98, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]98
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 2, ",", 98, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]98
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 2, ",", 98, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]99
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 2, ",", 99, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]99
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 2, ",", 99, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]99
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 2, ",", 99, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]100
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 2, ",", 100, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]100
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 2, ",", 100, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]100
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 2, ",", 100, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]101
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 2, ",", 101, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]101
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 2, ",", 101, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]101
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 2, ",", 101, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]102
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 2, ",", 102, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]102
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 2, ",", 102, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]102
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 2, ",", 102, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("form["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "103", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["4.37996069729280268`*^87",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "form[", 5, ",", 2, ",", 103, "]=", 4.3799606972928031*^+87],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("formexact["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "103", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["4.37996070221529709`*^87",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "formexact[", 5, ",", 2, ",", 103, "]=", 4.3799607022152965*^+87],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "103", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["8.307814862336798`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 5, ",", 2, ",", 103, "]=", 8.307814862336798],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]104
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 2, ",", 104, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]104
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 2, ",", 104, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]104
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 2, ",", 104, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]105
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 2, ",", 105, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]105
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 2, ",", 105, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]105
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 2, ",", 105, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]106
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 2, ",", 106, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]106
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 2, ",", 106, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]106
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 2, ",", 106, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]107
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 2, ",", 107, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]107
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 2, ",", 107, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]107
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 2, ",", 107, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]108
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 2, ",", 108, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]108
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 2, ",", 108, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]108
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 2, ",", 108, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("form["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "109", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["8.21252104993195075`*^94",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "form[", 5, ",", 2, ",", 109, "]=", 8.2125210499319519*^+94],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("formexact["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "109", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["8.21252106980353957`*^94",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "formexact[", 5, ",", 2, ",", 109, "]=", 8.2125210698035403*^+94],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "109", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["7.70176741613720139`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 5, ",", 2, ",", 109, "]=", 7.7017674161372014],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]110
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 2, ",", 110, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]110
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 2, ",", 110, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]110
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 2, ",", 110, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]111
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 2, ",", 111, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]111
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 2, ",", 111, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]111
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 2, ",", 111, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]112
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 2, ",", 112, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]112
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 2, ",", 112, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]112
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 2, ",", 112, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]113
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 2, ",", 113, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]113
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 2, ",", 113, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]113
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 2, ",", 113, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]114
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 2, ",", 114, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]114
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 2, ",", 114, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]114
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 2, ",", 114, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("form["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "115", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["2.02700102855093655`*^102",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "form[", 5, ",", 2, ",", 115, "]=", 2.0270010285509363*^+102],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("formexact["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "115", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["2.02700103666449527`*^102",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "formexact[", 5, ",", 2, ",", 115, "]=", 2.0270010366644956*^+102],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "115", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["8.09078858525968769`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 5, ",", 2, ",", 115, "]=", 8.0907885852596877],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]116
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 2, ",", 116, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]116
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 2, ",", 116, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]116
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 2, ",", 116, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]117
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 2, ",", 117, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]117
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 2, ",", 117, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]117
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 2, ",", 117, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]118
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 2, ",", 118, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]118
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 2, ",", 118, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]118
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 2, ",", 118, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]119
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 2, ",", 119, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]119
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 2, ",", 119, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]119
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 2, ",", 119, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]120
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 2, ",", 120, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]120
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 2, ",", 120, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]120
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 2, ",", 120, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("form["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "121", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["6.49201722850601736`*^109",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "form[", 5, ",", 2, ",", 121, "]=", 6.4920172285060174*^+109],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("formexact["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "121", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["6.49201723858750057`*^109",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "formexact[", 5, ",", 2, ",", 121, "]=", 6.4920172385875008*^+109],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "121", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["7.99647556309712115`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 5, ",", 2, ",", 121, "]=", 7.9964755630971212],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]122
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 2, ",", 122, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]122
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 2, ",", 122, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]122
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 2, ",", 122, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]123
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 2, ",", 123, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]123
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 2, ",", 123, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]123
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 2, ",", 123, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]124
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 2, ",", 124, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]124
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 2, ",", 124, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]124
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 2, ",", 124, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]125
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 2, ",", 125, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]125
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 2, ",", 125, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]125
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 2, ",", 125, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]126
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 2, ",", 126, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]126
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 2, ",", 126, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]126
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 2, ",", 126, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("form["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "127", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["2.66346835066579146`*^117",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "form[", 5, ",", 2, ",", 127, "]=", 2.6634683506657911*^+117],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("formexact["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "127", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["2.66346828094440812`*^117",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "formexact[", 5, ",", 2, ",", 127, "]=", 2.663468280944408*^+117],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "127", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["7.15663400628899637`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 5, ",", 2, ",", 127, "]=", 7.1566340062889964],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]128
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 2, ",", 128, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]128
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 2, ",", 128, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]128
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 2, ",", 128, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]129
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 2, ",", 129, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]129
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 2, ",", 129, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]129
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 2, ",", 129, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]130
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 2, ",", 130, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]130
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 2, ",", 130, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]130
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 2, ",", 130, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]131
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 2, ",", 131, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]131
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 2, ",", 131, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]131
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 2, ",", 131, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]132
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 2, ",", 132, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]132
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 2, ",", 132, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]132
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 2, ",", 132, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("form["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "133", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["1.3835060758376969`*^125",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "form[", 5, ",", 2, ",", 133, "]=", 1.3835060758376972*^+125],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("formexact["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "133", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["1.38350585563317229`*^125",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "formexact[", 5, ",", 2, ",", 133, "]=", 1.3835058556331724*^+125],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "133", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["6.6571737613095081`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 5, ",", 2, ",", 133, "]=", 6.6571737613095081],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]134
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 2, ",", 134, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]134
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 2, ",", 134, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]134
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 2, ",", 134, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]135
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 2, ",", 135, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]135
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 2, ",", 135, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]135
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 2, ",", 135, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]136
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 2, ",", 136, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]136
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 2, ",", 136, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]136
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 2, ",", 136, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]137
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 2, ",", 137, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]137
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 2, ",", 137, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]137
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 2, ",", 137, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]138
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 2, ",", 138, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]138
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 2, ",", 138, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]138
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 2, ",", 138, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("form["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "139", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["9.00246893935850778`*^132",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "form[", 5, ",", 2, ",", 139, "]=", 9.0024689393585078*^+132],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("formexact["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "139", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["9.00246305641465127`*^132",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "formexact[", 5, ",", 2, ",", 139, "]=", 9.0024630564146497*^+132],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "139", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["5.23040529613788862`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 5, ",", 2, ",", 139, "]=", 5.2304052961378886],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]140
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 2, ",", 140, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]140
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 2, ",", 140, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]140
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 2, ",", 140, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]141
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 2, ",", 141, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]141
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 2, ",", 141, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]141
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 2, ",", 141, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]142
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 2, ",", 142, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]142
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 2, ",", 142, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]142
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 2, ",", 142, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]143
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 2, ",", 143, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]143
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 2, ",", 143, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]143
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 2, ",", 143, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]144
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 2, ",", 144, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]144
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 2, ",", 144, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]144
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 2, ",", 144, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("form["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "145", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["7.26723749308449828`*^140",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "form[", 5, ",", 2, ",", 145, "]=", 7.2672374930844997*^+140],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("formexact["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "145", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["7.26722127263144379`*^140",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "formexact[", 5, ",", 2, ",", 145, "]=", 7.267221272631444*^+140],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "145", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["4.78993701961582019`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 5, ",", 2, ",", 145, "]=", 4.7899370196158202],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]146
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 2, ",", 146, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]146
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 2, ",", 146, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]146
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 2, ",", 146, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]147
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 2, ",", 147, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]147
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 2, ",", 147, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]147
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 2, ",", 147, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]148
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 2, ",", 148, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]148
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 2, ",", 148, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]148
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 2, ",", 148, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]149
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 2, ",", 149, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]149
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 2, ",", 149, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]149
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 2, ",", 149, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]150
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 2, ",", 150, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]150
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 2, ",", 150, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]150
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 2, ",", 150, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("form["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "151", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["7.21329889434953219`*^148",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "form[", 5, ",", 2, ",", 151, "]=", 7.2132988943495322*^+148],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("formexact["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "151", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["7.21325040843017184`*^148",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "formexact[", 5, ",", 2, ",", 151, "]=", 7.213250408430172*^+148],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "151", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["4.31438436515071543`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 5, ",", 2, ",", 151, "]=", 4.3143843651507154],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]152
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 2, ",", 152, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]152
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 2, ",", 152, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]152
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 2, ",", 152, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]153
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 2, ",", 153, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]153
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 2, ",", 153, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]153
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 2, ",", 153, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]154
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 2, ",", 154, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]154
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 2, ",", 154, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]154
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 2, ",", 154, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]155
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 2, ",", 155, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]155
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 2, ",", 155, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]155
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 2, ",", 155, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]156
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 2, ",", 156, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]156
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 2, ",", 156, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]156
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 2, ",", 156, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("form["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "157", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["8.73159416998499082`*^156",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "form[", 5, ",", 2, ",", 157, "]=", 8.7315941699849908*^+156],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("formexact["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "157", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["8.73143454669561336`*^156",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "formexact[", 5, ",", 2, ",", 157, "]=", 8.7314345466956115*^+156],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "157", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["3.79690374386851203`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 5, ",", 2, ",", 157, "]=", 3.796903743868512],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]158
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 2, ",", 158, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]158
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 2, ",", 158, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]158
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 2, ",", 158, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]159
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 2, ",", 159, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]159
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 2, ",", 159, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]159
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 2, ",", 159, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]160
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 2, ",", 160, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]160
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 2, ",", 160, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]160
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 2, ",", 160, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]161
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 2, ",", 161, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]161
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 2, ",", 161, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]161
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 2, ",", 161, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]162
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 2, ",", 162, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]162
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 2, ",", 162, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]162
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 2, ",", 162, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("form["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "163", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["1.27926497071986089`*^165",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "form[", 5, ",", 2, ",", 163, "]=", 1.2792649707198609*^+165],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("formexact["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "163", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["1.27920686282533635`*^165",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "formexact[", 5, ",", 2, ",", 163, "]=", 1.2792068628253363*^+165],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "163", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["4.23576486045774913`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 5, ",", 2, ",", 163, "]=", 4.2357648604577491],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]164
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 2, ",", 164, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]164
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 2, ",", 164, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]164
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 2, ",", 164, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]165
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 2, ",", 165, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]165
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 2, ",", 165, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]165
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 2, ",", 165, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]166
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 2, ",", 166, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]166
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 2, ",", 166, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]166
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 2, ",", 166, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]167
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 2, ",", 167, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]167
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 2, ",", 167, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]167
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 2, ",", 167, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]168
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 2, ",", 168, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]168
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 2, ",", 168, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]168
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 2, ",", 168, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("form["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "169", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["2.25264312849857128`*^173",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "form[", 5, ",", 2, ",", 169, "]=", 2.2526431284985712*^+173],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("formexact["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "169", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["2.25240944775430396`*^173",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "formexact[", 5, ",", 2, ",", 169, "]=", 2.2524094477543033*^+173],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "169", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["3.6313770728143595`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 5, ",", 2, ",", 169, "]=", 3.6313770728143595],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]170
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 2, ",", 170, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]170
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 2, ",", 170, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]170
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 2, ",", 170, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]171
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 2, ",", 171, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]171
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 2, ",", 171, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]171
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 2, ",", 171, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]172
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 2, ",", 172, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]172
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 2, ",", 172, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]172
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 2, ",", 172, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]173
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 2, ",", 173, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]173
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 2, ",", 173, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]173
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 2, ",", 173, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]174
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 2, ",", 174, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]174
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 2, ",", 174, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]174
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 2, ",", 174, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("form["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "175", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["4.73660979199163367`*^181",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "form[", 5, ",", 2, ",", 175, "]=", 4.7366097919916324*^+181],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("formexact["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "175", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["4.73557233085623519`*^181",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "formexact[", 5, ",", 2, ",", 175, "]=", 4.7355723308562347*^+181],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "175", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["2.98402816353009825`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 5, ",", 2, ",", 175, "]=", 2.9840281635300983],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]176
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 2, ",", 176, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]176
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 2, ",", 176, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]176
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 2, ",", 176, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]177
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 2, ",", 177, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]177
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 2, ",", 177, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]177
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 2, ",", 177, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]178
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 2, ",", 178, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]178
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 2, ",", 178, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]178
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 2, ",", 178, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]179
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 2, ",", 179, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]179
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 2, ",", 179, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]179
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 2, ",", 179, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]180
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 2, ",", 180, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]180
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 2, ",", 180, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]180
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 2, ",", 180, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    \("   "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]0
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 3, ",", 0, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]0
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 3, ",", 0, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]0
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 3, ",", 0, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 3, ",", 1, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 3, ",", 1, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 3, ",", 1, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("form["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["1.`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "form[", 5, ",", 3, ",", 2, "]=", 1.0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("formexact["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["1.`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "formexact[", 5, ",", 3, ",", 2, "]=", 1.0],
      Editable->False]], "Print"],

Cell[BoxData[
    \(MantissaExponent::"realx" \( : \ \) 
      "\!\(1\) is not an inexact real number."\)], "Message"],

Cell[BoxData[
    \(General::"stop" \( : \ \) 
      "Further output of \!\(MantissaExponent :: \"realx\"\) will be \
suppressed during this calculation."\)], "Message"],

Cell[BoxData[
    \(Part::"partw" \( : \ \) 
      "Part \!\(2\) of \!\(MantissaExponent[1]\) does not exist."\)], 
  "Message"],

Cell[BoxData[
    \(General::"stop" \( : \ \) 
      "Further output of \!\(Part :: \"partw\"\) will be suppressed during \
this calculation."\)], "Message"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        InterpretationBox["\[Infinity]",
          DirectedInfinity[ 1]]}],
      SequenceForm[ "exactdigits[", 5, ",", 3, ",", 2, "]=", 
        DirectedInfinity[ 1]],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 3, ",", 3, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 3, ",", 3, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 3, ",", 3, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 3, ",", 4, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 3, ",", 4, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 3, ",", 4, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 3, ",", 5, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 3, ",", 5, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 3, ",", 5, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]6
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 3, ",", 6, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]6
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 3, ",", 6, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]6
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 3, ",", 6, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]7
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 3, ",", 7, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]7
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 3, ",", 7, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]7
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 3, ",", 7, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("form["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "8", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["4.66666666666666696`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "form[", 5, ",", 3, ",", 8, "]=", 4.666666666666667],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("formexact["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "8", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["4.66666666666666696`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "formexact[", 5, ",", 3, ",", 8, "]=", 4.666666666666667],
      
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "8", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        InterpretationBox["\[Infinity]",
          DirectedInfinity[ 1]]}],
      SequenceForm[ "exactdigits[", 5, ",", 3, ",", 8, "]=", 
        DirectedInfinity[ 1]],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]9
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 3, ",", 9, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]9
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 3, ",", 9, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]9
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 3, ",", 9, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]10
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 3, ",", 10, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]10
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 3, ",", 10, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]10
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 3, ",", 10, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]11
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 3, ",", 11, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]11
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 3, ",", 11, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]11
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 3, ",", 11, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]12
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 3, ",", 12, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]12
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 3, ",", 12, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]12
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 3, ",", 12, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]13
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 3, ",", 13, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]13
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 3, ",", 13, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]13
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 3, ",", 13, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("form["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "14", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["1167.8333333333335`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "form[", 5, ",", 3, ",", 14, "]=", 1167.8333333333335],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("formexact["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "14", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["1167.83333333333327`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "formexact[", 5, ",", 3, ",", 14, "]=", 1167.8333333333333],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "14", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["15.643259817887209`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 5, ",", 3, ",", 14, "]=", 15.643259817887209],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]15
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 3, ",", 15, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]15
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 3, ",", 15, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]15
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 3, ",", 15, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]16
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 3, ",", 16, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]16
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 3, ",", 16, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]16
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 3, ",", 16, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]17
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 3, ",", 17, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]17
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 3, ",", 17, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]17
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 3, ",", 17, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]18
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 3, ",", 18, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]18
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 3, ",", 18, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]18
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 3, ",", 18, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]19
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 3, ",", 19, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]19
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 3, ",", 19, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]19
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 3, ",", 19, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("form["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "20", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["2.51473444444444504`*^6",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "form[", 5, ",", 3, ",", 20, "]=", 2514734.444444445],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("formexact["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "20", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["2.5147344444444446`*^6",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "formexact[", 5, ",", 3, ",", 20, "]=", 2514734.4444444445],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "20", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["15.3319298655834179`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 5, ",", 3, ",", 20, "]=", 15.331929865583419],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]21
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 3, ",", 21, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]21
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 3, ",", 21, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]21
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 3, ",", 21, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]22
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 3, ",", 22, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]22
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 3, ",", 22, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]22
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 3, ",", 22, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]23
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 3, ",", 23, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]23
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 3, ",", 23, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]23
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 3, ",", 23, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]24
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 3, ",", 24, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]24
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 3, ",", 24, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]24
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 3, ",", 24, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]25
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 3, ",", 25, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]25
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 3, ",", 25, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]25
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 3, ",", 25, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("form["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "26", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["2.41236379643518539`*^10",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "form[", 5, ",", 3, ",", 26, "]=", 24123637964.351852],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("formexact["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "26", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["2.41236379643518539`*^10",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "formexact[", 5, ",", 3, ",", 26, "]=", 24123637964.351852],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "26", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        InterpretationBox["\[Infinity]",
          DirectedInfinity[ 1]]}],
      SequenceForm[ "exactdigits[", 5, ",", 3, ",", 26, "]=", 
        DirectedInfinity[ 1]],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]27
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 3, ",", 27, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]27
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 3, ",", 27, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]27
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 3, ",", 27, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]28
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 3, ",", 28, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]28
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 3, ",", 28, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]28
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 3, ",", 28, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]29
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 3, ",", 29, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]29
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 3, ",", 29, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]29
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 3, ",", 29, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]30
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 3, ",", 30, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]30
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 3, ",", 30, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]30
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 3, ",", 30, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]31
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 3, ",", 31, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]31
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 3, ",", 31, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]31
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 3, ",", 31, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("form["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "32", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["7.28688257806397565`*^14",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "form[", 5, ",", 3, ",", 32, "]=", 728688257806397.5],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("formexact["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "32", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["7.28688257806397654`*^14",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "formexact[", 5, ",", 3, ",", 32, "]=", 728688257806397.75],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "32", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["14.6020599913279625`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 5, ",", 3, ",", 32, "]=", 14.602059991327963],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]33
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 3, ",", 33, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]33
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 3, ",", 33, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]33
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 3, ",", 33, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]34
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 3, ",", 34, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]34
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 3, ",", 34, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]34
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 3, ",", 34, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]35
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 3, ",", 35, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]35
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 3, ",", 35, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]35
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 3, ",", 35, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]36
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 3, ",", 36, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]36
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 3, ",", 36, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]36
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 3, ",", 36, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]37
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 3, ",", 37, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]37
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 3, ",", 37, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]37
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 3, ",", 37, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("form["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "38", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["5.58798841180338268`*^19",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "form[", 5, ",", 3, ",", 38, "]=", 5.5879884118033826*^+19],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("formexact["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "38", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["5.58798841180340133`*^19",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "formexact[", 5, ",", 3, ",", 38, "]=", 5.5879884118034006*^+19],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "38", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["13.7441873755460397`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 5, ",", 3, ",", 38, "]=", 13.744187375546039],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]39
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 3, ",", 39, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]39
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 3, ",", 39, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]39
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 3, ",", 39, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]40
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 3, ",", 40, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]40
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 3, ",", 40, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]40
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 3, ",", 40, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]41
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 3, ",", 41, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]41
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 3, ",", 41, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]41
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 3, ",", 41, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]42
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 3, ",", 42, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]42
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 3, ",", 42, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]42
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 3, ",", 42, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]43
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 3, ",", 43, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]43
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 3, ",", 43, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]43
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 3, ",", 43, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("form["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "44", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["9.39188113674214442`*^24",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "form[", 5, ",", 3, ",", 44, "]=", 9.3918811367421434*^+24],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("formexact["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "44", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["9.3918811367422883`*^24",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "formexact[", 5, ",", 3, ",", 44, "]=", 9.3918811367422894*^+24],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "44", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["12.8355612217103477`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 5, ",", 3, ",", 44, "]=", 12.835561221710348],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]45
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 3, ",", 45, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]45
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 3, ",", 45, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]45
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 3, ",", 45, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]46
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 3, ",", 46, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]46
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 3, ",", 46, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]46
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 3, ",", 46, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]47
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 3, ",", 47, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]47
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 3, ",", 47, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]47
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 3, ",", 47, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]48
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 3, ",", 48, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]48
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 3, ",", 48, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]48
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 3, ",", 48, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]49
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 3, ",", 49, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]49
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 3, ",", 49, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]49
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 3, ",", 49, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("form["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "50", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["3.10924094957545449`*^30",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "form[", 5, ",", 3, ",", 50, "]=", 3.1092409495754546*^+30],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("formexact["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "50", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["3.10924094957563923`*^30",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "formexact[", 5, ",", 3, ",", 50, "]=", 3.1092409495756392*^+30],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "50", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["12.7336563687532455`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 5, ",", 3, ",", 50, "]=", 12.733656368753245],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]51
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 3, ",", 51, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]51
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 3, ",", 51, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]51
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 3, ",", 51, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]52
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 3, ",", 52, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]52
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 3, ",", 52, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]52
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 3, ",", 52, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]53
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 3, ",", 53, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]53
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 3, ",", 53, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]53
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 3, ",", 53, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]54
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 3, ",", 54, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]54
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 3, ",", 54, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]54
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 3, ",", 54, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]55
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 3, ",", 55, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]55
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 3, ",", 55, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]55
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 3, ",", 55, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("form["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "56", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["1.86948501444175043`*^36",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "form[", 5, ",", 3, ",", 56, "]=", 1.8694850144417503*^+36],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("formexact["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "56", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["1.8694850144421462`*^36",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "formexact[", 5, ",", 3, ",", 56, "]=", 1.8694850144421458*^+36],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "56", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["12.4028554964844728`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 5, ",", 3, ",", 56, "]=", 12.402855496484474],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]57
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 3, ",", 57, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]57
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 3, ",", 57, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]57
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 3, ",", 57, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]58
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 3, ",", 58, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]58
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 3, ",", 58, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]58
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 3, ",", 58, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]59
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 3, ",", 59, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]59
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 3, ",", 59, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]59
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 3, ",", 59, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]60
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 3, ",", 60, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]60
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 3, ",", 60, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]60
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 3, ",", 60, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]61
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 3, ",", 61, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]61
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 3, ",", 61, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]61
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 3, ",", 61, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("form["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "62", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["1.91542820067436565`*^42",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "form[", 5, ",", 3, ",", 62, "]=", 1.9154282006743657*^+42],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("formexact["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "62", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["1.9154282006756496`*^42",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "formexact[", 5, ",", 3, ",", 62, "]=", 1.9154282006756494*^+42],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "62", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["11.8915216338526551`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 5, ",", 3, ",", 62, "]=", 11.891521633852655],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]63
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 3, ",", 63, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]63
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 3, ",", 63, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]63
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 3, ",", 63, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]64
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 3, ",", 64, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]64
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 3, ",", 64, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]64
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 3, ",", 64, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]65
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 3, ",", 65, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]65
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 3, ",", 65, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]65
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 3, ",", 65, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]66
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 3, ",", 66, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]66
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 3, ",", 66, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]66
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 3, ",", 66, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]67
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 3, ",", 67, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]67
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 3, ",", 67, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]67
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 3, ",", 67, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("form["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "68", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["3.176515481143658`*^48",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "form[", 5, ",", 3, ",", 68, "]=", 3.1765154811436585*^+48],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("formexact["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "68", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["3.17651548114928683`*^48",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "formexact[", 5, ",", 3, ",", 68, "]=", 3.1765154811492863*^+48],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "68", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["11.2496612864026634`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 5, ",", 3, ",", 68, "]=", 11.249661286402663],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]69
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 3, ",", 69, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]69
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 3, ",", 69, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]69
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 3, ",", 69, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]70
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 3, ",", 70, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]70
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 3, ",", 70, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]70
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 3, ",", 70, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]71
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 3, ",", 71, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]71
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 3, ",", 71, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]71
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 3, ",", 71, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]72
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 3, ",", 72, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]72
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 3, ",", 72, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]72
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 3, ",", 72, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]73
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 3, ",", 73, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]73
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 3, ",", 73, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]73
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 3, ",", 73, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("form["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "74", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["8.17294430030141683`*^54",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "form[", 5, ",", 3, ",", 74, "]=", 8.1729443003014175*^+54],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("formexact["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "74", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["8.17294430033435403`*^54",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "formexact[", 5, ",", 3, ",", 74, "]=", 8.1729443003343541*^+54],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "74", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["10.4823210912911912`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 5, ",", 3, ",", 74, "]=", 10.48232109129119],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]75
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 3, ",", 75, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]75
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 3, ",", 75, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]75
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 3, ",", 75, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]76
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 3, ",", 76, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]76
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 3, ",", 76, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]76
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 3, ",", 76, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]77
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 3, ",", 77, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]77
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 3, ",", 77, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]77
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 3, ",", 77, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]78
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 3, ",", 78, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]78
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 3, ",", 78, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]78
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 3, ",", 78, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]79
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 3, ",", 79, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]79
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 3, ",", 79, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]79
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 3, ",", 79, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("form["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "80", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["3.1486812779702813`*^61",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "form[", 5, ",", 3, ",", 80, "]=", 3.1486812779702813*^+61],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("formexact["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "80", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["3.14868127799914532`*^61",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "formexact[", 5, ",", 3, ",", 80, "]=", 3.1486812779991453*^+61],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "80", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["10.539642183570641`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 5, ",", 3, ",", 80, "]=", 10.539642183570642],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]81
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 3, ",", 81, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]81
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 3, ",", 81, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]81
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 3, ",", 81, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]82
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 3, ",", 82, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]82
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 3, ",", 82, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]82
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 3, ",", 82, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]83
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 3, ",", 83, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]83
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 3, ",", 83, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]83
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 3, ",", 83, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]84
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 3, ",", 84, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]84
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 3, ",", 84, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]84
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 3, ",", 84, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]85
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 3, ",", 85, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]85
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 3, ",", 85, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]85
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 3, ",", 85, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("form["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "86", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["1.76234343889216056`*^68",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "form[", 5, ",", 3, ",", 86, "]=", 1.7623434388921606*^+68],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("formexact["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "86", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["1.76234343893588878`*^68",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "formexact[", 5, ",", 3, ",", 86, "]=", 1.7623434389358889*^+68],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "86", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["10.3592371723128096`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 5, ",", 3, ",", 86, "]=", 10.35923717231281],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]87
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 3, ",", 87, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]87
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 3, ",", 87, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]87
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 3, ",", 87, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]88
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 3, ",", 88, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]88
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 3, ",", 88, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]88
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 3, ",", 88, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]89
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 3, ",", 89, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]89
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 3, ",", 89, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]89
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 3, ",", 89, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]90
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 3, ",", 90, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]90
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 3, ",", 90, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]90
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 3, ",", 90, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]91
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 3, ",", 91, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]91
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 3, ",", 91, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]91
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 3, ",", 91, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("form["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "92", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["1.39630148735044269`*^75",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "form[", 5, ",", 3, ",", 92, "]=", 1.3963014873504426*^+75],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("formexact["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "92", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["1.39630148745488957`*^75",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "formexact[", 5, ",", 3, ",", 92, "]=", 1.3963014874548896*^+75],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "92", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["9.98110421451605134`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 5, ",", 3, ",", 92, "]=", 9.9811042145160513],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]93
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 3, ",", 93, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]93
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 3, ",", 93, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]93
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 3, ",", 93, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]94
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 3, ",", 94, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]94
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 3, ",", 94, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]94
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 3, ",", 94, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]95
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 3, ",", 95, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]95
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 3, ",", 95, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]95
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 3, ",", 95, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]96
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 3, ",", 96, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]96
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 3, ",", 96, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]96
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 3, ",", 96, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]97
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 3, ",", 97, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]97
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 3, ",", 97, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]97
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 3, ",", 97, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("form["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "98", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["1.53101315227012912`*^82",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "form[", 5, ",", 3, ",", 98, "]=", 1.531013152270129*^+82],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("formexact["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "98", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["1.53101315257497283`*^82",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "formexact[", 5, ",", 3, ",", 98, "]=", 1.5310131525749728*^+82],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "98", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["9.51592253655219622`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 5, ",", 3, ",", 98, "]=", 9.5159225365521962],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]99
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 3, ",", 99, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]99
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 3, ",", 99, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]99
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 3, ",", 99, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]100
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 3, ",", 100, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]100
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 3, ",", 100, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]100
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 3, ",", 100, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]101
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 3, ",", 101, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]101
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 3, ",", 101, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]101
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 3, ",", 101, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]102
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 3, ",", 102, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]102
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 3, ",", 102, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]102
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 3, ",", 102, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]103
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 3, ",", 103, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]103
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 3, ",", 103, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]103
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 3, ",", 103, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("form["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "104", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["2.27757956435274788`*^89",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "form[", 5, ",", 3, ",", 104, "]=", 2.277579564352748*^+89],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("formexact["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "104", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["2.27757956515195392`*^89",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "formexact[", 5, ",", 3, ",", 104, "]=", 2.2775795651519545*^+89],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "104", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["9.09734096272069336`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 5, ",", 3, ",", 104, "]=", 9.0973409627206934],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]105
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 3, ",", 105, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]105
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 3, ",", 105, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]105
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 3, ",", 105, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]106
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 3, ",", 106, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]106
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 3, ",", 106, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]106
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 3, ",", 106, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]107
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 3, ",", 107, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]107
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 3, ",", 107, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]107
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 3, ",", 107, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]108
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 3, ",", 108, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]108
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 3, ",", 108, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]108
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 3, ",", 108, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]109
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 3, ",", 109, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]109
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 3, ",", 109, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]109
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 3, ",", 109, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("form["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "110", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["4.51688658905414719`*^96",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "form[", 5, ",", 3, ",", 110, "]=", 4.5168865890541468*^+96],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("formexact["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "110", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["4.51688658839194623`*^96",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "formexact[", 5, ",", 3, ",", 110, "]=", 4.5168865883919471*^+96],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "110", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["9.17901103995272649`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 5, ",", 3, ",", 110, "]=", 9.1790110399527265],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]111
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 3, ",", 111, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]111
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 3, ",", 111, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]111
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 3, ",", 111, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]112
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 3, ",", 112, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]112
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 3, ",", 112, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]112
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 3, ",", 112, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]113
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 3, ",", 113, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]113
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 3, ",", 113, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]113
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 3, ",", 113, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]114
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 3, ",", 114, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]114
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 3, ",", 114, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]114
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 3, ",", 114, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]115
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 3, ",", 115, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]115
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 3, ",", 115, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]115
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 3, ",", 115, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("form["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "116", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["1.17566060672972949`*^104",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "form[", 5, ",", 3, ",", 116, "]=", 1.1756606067297294*^+104],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("formexact["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "116", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["1.17566060126540761`*^104",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "formexact[", 5, ",", 3, ",", 116, "]=", 1.1756606012654076*^+104],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "116", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["8.26246373304455516`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 5, ",", 3, ",", 116, "]=", 8.2624637330445552],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]117
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 3, ",", 117, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]117
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 3, ",", 117, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]117
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 3, ",", 117, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]118
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 3, ",", 118, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]118
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 3, ",", 118, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]118
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 3, ",", 118, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]119
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 3, ",", 119, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]119
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 3, ",", 119, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]119
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 3, ",", 119, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]120
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 3, ",", 120, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]120
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 3, ",", 120, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]120
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 3, ",", 120, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]121
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 3, ",", 121, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]121
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 3, ",", 121, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]121
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 3, ",", 121, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("form["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "122", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["3.96013061818217426`*^111",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "form[", 5, ",", 3, ",", 122, "]=", 3.9601306181821735*^+111],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("formexact["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "122", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["3.96013051553837556`*^111",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "formexact[", 5, ",", 3, ",", 122, "]=", 3.9601305155383754*^+111],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "122", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["6.98866728627609745`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 5, ",", 3, ",", 122, "]=", 6.9886672862760975],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]123
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 3, ",", 123, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]123
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 3, ",", 123, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]123
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 3, ",", 123, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]124
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 3, ",", 124, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]124
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 3, ",", 124, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]124
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 3, ",", 124, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]125
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 3, ",", 125, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]125
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 3, ",", 125, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]125
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 3, ",", 125, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]126
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 3, ",", 126, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]126
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 3, ",", 126, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]126
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 3, ",", 126, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]127
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 3, ",", 127, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]127
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 3, ",", 127, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]127
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 3, ",", 127, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("form["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "128", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["1.7046198814819256`*^119",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "form[", 5, ",", 3, ",", 128, "]=", 1.7046198814819255*^+119],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("formexact["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "128", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["1.70461969980442118`*^119",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "formexact[", 5, ",", 3, ",", 128, "]=", 1.7046196998044211*^+119],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "128", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["6.74069884456804402`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 5, ",", 3, ",", 128, "]=", 6.740698844568044],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]129
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 3, ",", 129, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]129
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 3, ",", 129, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]129
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 3, ",", 129, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]130
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 3, ",", 130, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]130
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 3, ",", 130, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]130
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 3, ",", 130, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]131
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 3, ",", 131, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]131
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 3, ",", 131, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]131
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 3, ",", 131, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]132
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 3, ",", 132, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]132
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 3, ",", 132, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]132
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 3, ",", 132, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]133
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 3, ",", 133, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]133
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 3, ",", 133, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]133
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 3, ",", 133, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("form["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "134", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["9.26949272488439746`*^126",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "form[", 5, ",", 3, ",", 134, "]=", 9.2694927248843963*^+126],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("formexact["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "134", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["9.269489232742254`*^126",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "formexact[", 5, ",", 3, ",", 134, "]=", 9.2694892327422556*^+126],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "134", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["5.45690808751307088`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 5, ",", 3, ",", 134, "]=", 5.4569080875130709],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]135
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 3, ",", 135, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]135
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 3, ",", 135, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]135
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 3, ",", 135, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]136
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 3, ",", 136, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]136
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 3, ",", 136, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]136
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 3, ",", 136, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]137
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 3, ",", 137, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]137
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 3, ",", 137, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]137
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 3, ",", 137, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]138
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 3, ",", 138, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]138
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 3, ",", 138, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]138
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 3, ",", 138, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]139
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 3, ",", 139, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]139
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 3, ",", 139, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]139
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 3, ",", 139, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("form["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "140", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["6.30173172117175006`*^134",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "form[", 5, ",", 3, ",", 140, "]=", 6.3017317211717506*^+134],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("formexact["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "140", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["6.30172413949025411`*^134",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "formexact[", 5, ",", 3, ",", 140, "]=", 6.3017241394902554*^+134],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "140", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["5.12023446414215754`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 5, ",", 3, ",", 140, "]=", 5.1202344641421575],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]141
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 3, ",", 141, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]141
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 3, ",", 141, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]141
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 3, ",", 141, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]142
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 3, ",", 142, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]142
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 3, ",", 142, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]142
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 3, ",", 142, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]143
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 3, ",", 143, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]143
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 3, ",", 143, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]143
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 3, ",", 143, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]144
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 3, ",", 144, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]144
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 3, ",", 144, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]144
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 3, ",", 144, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]145
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 3, ",", 145, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]145
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 3, ",", 145, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]145
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 3, ",", 145, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("form["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "146", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["5.30509028872736898`*^142",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "form[", 5, ",", 3, ",", 146, "]=", 5.3050902887273697*^+142],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("formexact["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "146", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["5.30507152902095402`*^142",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "formexact[", 5, ",", 3, ",", 146, "]=", 5.3050715290209542*^+142],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "146", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["4.7267739624994931`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 5, ",", 3, ",", 146, "]=", 4.7267739624994931],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]147
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 3, ",", 147, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]147
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 3, ",", 147, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]147
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 3, ",", 147, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]148
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 3, ",", 148, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]148
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 3, ",", 148, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]148
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 3, ",", 148, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]149
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 3, ",", 149, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]149
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 3, ",", 149, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]149
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 3, ",", 149, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]150
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 3, ",", 150, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]150
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 3, ",", 150, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]150
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 3, ",", 150, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]151
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 3, ",", 151, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]151
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 3, ",", 151, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]151
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 3, ",", 151, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("form["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "152", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["5.48212299531088476`*^150",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "form[", 5, ",", 3, ",", 152, "]=", 5.4821229953108861*^+150],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("formexact["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "152", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["5.48207031040692971`*^150",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "formexact[", 5, ",", 3, ",", 152, "]=", 5.4820703104069309*^+150],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "152", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["4.27831380733331911`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 5, ",", 3, ",", 152, "]=", 4.2783138073333191],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]153
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 3, ",", 153, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]153
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 3, ",", 153, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]153
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 3, ",", 153, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]154
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 3, ",", 154, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]154
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 3, ",", 154, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]154
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 3, ",", 154, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]155
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 3, ",", 155, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]155
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 3, ",", 155, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]155
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 3, ",", 155, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]156
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 3, ",", 156, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]156
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 3, ",", 156, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]156
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 3, ",", 156, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]157
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 3, ",", 157, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]157
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 3, ",", 157, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]157
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 3, ",", 157, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("form["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "158", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["6.89799908947824214`*^158",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "form[", 5, ",", 3, ",", 158, "]=", 6.8979990894782429*^+158],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("formexact["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "158", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["6.89783329188953509`*^158",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "formexact[", 5, ",", 3, ",", 158, "]=", 6.897833291889533*^+158],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "158", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["3.78042178993544553`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 5, ",", 3, ",", 158, "]=", 3.7804217899354455],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]159
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 3, ",", 159, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]159
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 3, ",", 159, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]159
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 3, ",", 159, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]160
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 3, ",", 160, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]160
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 3, ",", 160, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]160
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 3, ",", 160, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]161
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 3, ",", 161, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]161
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 3, ",", 161, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]161
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 3, ",", 161, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]162
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 3, ",", 162, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]162
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 3, ",", 162, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]162
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 3, ",", 162, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]163
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 3, ",", 163, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]163
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 3, ",", 163, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]163
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 3, ",", 163, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("form["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "164", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["1.04900665633644574`*^167",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "form[", 5, ",", 3, ",", 164, "]=", 1.0490066563364456*^+167],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("formexact["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "164", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["1.04894962751677578`*^167",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "formexact[", 5, ",", 3, ",", 164, "]=", 1.0489496275167757*^+167],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "164", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["4.24390561694957568`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 5, ",", 3, ",", 164, "]=", 4.2439056169495757],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]165
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 3, ",", 165, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]165
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 3, ",", 165, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]165
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 3, ",", 165, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]166
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 3, ",", 166, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]166
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 3, ",", 166, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]166
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 3, ",", 166, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]167
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 3, ",", 167, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]167
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 3, ",", 167, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]167
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 3, ",", 167, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]168
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 3, ",", 168, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]168
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 3, ",", 168, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]168
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 3, ",", 168, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]169
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 3, ",", 169, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]169
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 3, ",", 169, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]169
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 3, ",", 169, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("form["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "170", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["1.91475109388169055`*^175",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "form[", 5, ",", 3, ",", 170, "]=", 1.9147510938816902*^+175],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("formexact["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "170", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["1.91454803059115796`*^175",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "formexact[", 5, ",", 3, ",", 170, "]=", 1.914548030591158*^+175],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "170", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["3.69236858058468442`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 5, ",", 3, ",", 170, "]=", 3.6923685805846844],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]171
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 3, ",", 171, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]171
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 3, ",", 171, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]171
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 3, ",", 171, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]172
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 3, ",", 172, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]172
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 3, ",", 172, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]172
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 3, ",", 172, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]173
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 3, ",", 173, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]173
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 3, ",", 173, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]173
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 3, ",", 173, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]174
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 3, ",", 174, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]174
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 3, ",", 174, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]174
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 3, ",", 174, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]175
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 3, ",", 175, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]175
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 3, ",", 175, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]175
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 3, ",", 175, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("form["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "176", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["4.16793715097306805`*^183",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "form[", 5, ",", 3, ",", 176, "]=", 4.1679371509730683*^+183],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("formexact["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "176", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["4.1673036511534871`*^183",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "formexact[", 5, ",", 3, ",", 176, "]=", 4.1673036511534871*^+183],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "176", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["3.19825350446626543`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 5, ",", 3, ",", 176, "]=", 3.1982535044662654],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]177
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 3, ",", 177, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]177
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 3, ",", 177, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]177
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 3, ",", 177, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]178
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 3, ",", 178, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]178
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 3, ",", 178, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]178
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 3, ",", 178, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]179
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 3, ",", 179, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]179
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 3, ",", 179, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]179
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 3, ",", 179, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]180
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 3, ",", 180, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]180
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 3, ",", 180, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]180
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 3, ",", 180, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    \("   "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]0
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 4, ",", 0, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]0
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 4, ",", 0, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]0
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 4, ",", 0, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 4, ",", 1, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 4, ",", 1, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 4, ",", 1, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 4, ",", 2, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 4, ",", 2, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 4, ",", 2, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("form["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "4", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["1.`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "form[", 5, ",", 4, ",", 3, "]=", 1.0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("formexact["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "4", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["1.`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "formexact[", 5, ",", 4, ",", 3, "]=", 1.0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "4", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        InterpretationBox["\[Infinity]",
          DirectedInfinity[ 1]]}],
      SequenceForm[ "exactdigits[", 5, ",", 4, ",", 3, "]=", 
        DirectedInfinity[ 1]],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 4, ",", 4, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 4, ",", 4, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 4, ",", 4, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 4, ",", 5, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 4, ",", 5, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 4, ",", 5, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]6
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 4, ",", 6, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]6
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 4, ",", 6, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]6
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 4, ",", 6, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]7
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 4, ",", 7, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]7
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 4, ",", 7, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]7
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 4, ",", 7, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]8
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 4, ",", 8, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]8
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 4, ",", 8, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]8
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 4, ",", 8, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("form["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "4", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "9", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["13.9999999999999991`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "form[", 5, ",", 4, ",", 9, "]=", 14.0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("formexact["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "4", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "9", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["13.9999999999999991`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "formexact[", 5, ",", 4, ",", 9, "]=", 14.0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "4", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "9", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        InterpretationBox["\[Infinity]",
          DirectedInfinity[ 1]]}],
      SequenceForm[ "exactdigits[", 5, ",", 4, ",", 9, "]=", 
        DirectedInfinity[ 1]],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]10
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 4, ",", 10, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]10
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 4, ",", 10, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]10
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 4, ",", 10, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]11
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 4, ",", 11, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]11
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 4, ",", 11, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]11
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 4, ",", 11, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]12
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 4, ",", 12, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]12
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 4, ",", 12, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]12
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 4, ",", 12, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]13
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 4, ",", 13, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]13
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 4, ",", 13, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]13
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 4, ",", 13, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]14
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 4, ",", 14, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]14
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 4, ",", 14, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]14
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 4, ",", 14, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("form["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "4", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "15", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["5839.16666666666639`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "form[", 5, ",", 4, ",", 15, "]=", 5839.1666666666661],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("formexact["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "4", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "15", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["5839.16666666666728`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "formexact[", 5, ",", 4, ",", 15, "]=", 5839.166666666667],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "4", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "15", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["15.0411998265592465`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 5, ",", 4, ",", 15, "]=", 15.041199826559247],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]16
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 4, ",", 16, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]16
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 4, ",", 16, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]16
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 4, ",", 16, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]17
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 4, ",", 17, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]17
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 4, ",", 17, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]17
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 4, ",", 17, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]18
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 4, ",", 18, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]18
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 4, ",", 18, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]18
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 4, ",", 18, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]19
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 4, ",", 19, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]19
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 4, ",", 19, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]19
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 4, ",", 19, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]20
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 4, ",", 20, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]20
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 4, ",", 20, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]20
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 4, ",", 20, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("form["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "4", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "21", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["1.76031411111111069`*^7",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "form[", 5, ",", 4, ",", 21, "]=", 17603141.111111104],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("formexact["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "4", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "21", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["1.76031411111111113`*^7",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "formexact[", 5, ",", 4, ",", 21, "]=", 17603141.111111112],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "4", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "21", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["15.1278098829274938`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 5, ",", 4, ",", 21, "]=", 15.127809882927494],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]22
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 4, ",", 22, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]22
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 4, ",", 22, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]22
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 4, ",", 22, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]23
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 4, ",", 23, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]23
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 4, ",", 23, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]23
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 4, ",", 23, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]24
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 4, ",", 24, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]24
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 4, ",", 24, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]24
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 4, ",", 24, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]25
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 4, ",", 25, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]25
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 4, ",", 25, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]25
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 4, ",", 25, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]26
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 4, ",", 26, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]26
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 4, ",", 26, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]26
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 4, ",", 26, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("form["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "4", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "27", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["2.17112741679166765`*^11",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "form[", 5, ",", 4, ",", 27, "]=", 217112741679.16675],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("formexact["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "4", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "27", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["2.17112741679166676`*^11",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "formexact[", 5, ",", 4, ",", 27, "]=", 217112741679.16666],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "4", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "27", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["15.0383286802400562`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 5, ",", 4, ",", 27, "]=", 15.038328680240056],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]28
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 4, ",", 28, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]28
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 4, ",", 28, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]28
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 4, ",", 28, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]29
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 4, ",", 29, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]29
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 4, ",", 29, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]29
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 4, ",", 29, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]30
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 4, ",", 30, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]30
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 4, ",", 30, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]30
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 4, ",", 30, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]31
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 4, ",", 31, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]31
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 4, ",", 31, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]31
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 4, ",", 31, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]32
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 4, ",", 32, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]32
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 4, ",", 32, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]32
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 4, ",", 32, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("form["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "4", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "33", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["8.01557083587039898`*^15",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "form[", 5, ",", 4, ",", 33, "]=", 8015570835870400.0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("formexact["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "4", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "33", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["8.01557083587037588`*^15",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "formexact[", 5, ",", 4, ",", 33, "]=", 8015570835870375.0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "4", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "33", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["13.6020599913279616`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 5, ",", 4, ",", 33, "]=", 13.602059991327963],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]34
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 4, ",", 34, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]34
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 4, ",", 34, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]34
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 4, ",", 34, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]35
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 4, ",", 35, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]35
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 4, ",", 35, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]35
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 4, ",", 35, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]36
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 4, ",", 36, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]36
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 4, ",", 36, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]36
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 4, ",", 36, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]37
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 4, ",", 37, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]37
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 4, ",", 37, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]37
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 4, ",", 37, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]38
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 4, ",", 38, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]38
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 4, ",", 38, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]38
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 4, ",", 38, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("form["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "4", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "39", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["7.26438493534447182`*^20",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "form[", 5, ",", 4, ",", 39, "]=", 7.2643849353444721*^+20],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("formexact["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "4", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "39", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["7.26438493534441942`*^20",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "formexact[", 5, ",", 4, ",", 39, "]=", 7.2643849353444196*^+20],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "4", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "39", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["13.2804300823843579`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 5, ",", 4, ",", 39, "]=", 13.280430082384358],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]40
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 4, ",", 40, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]40
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 4, ",", 40, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]40
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 4, ",", 40, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]41
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 4, ",", 41, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]41
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 4, ",", 41, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]41
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 4, ",", 41, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]42
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 4, ",", 42, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]42
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 4, ",", 42, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]42
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 4, ",", 42, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]43
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 4, ",", 43, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]43
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 4, ",", 43, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]43
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 4, ",", 43, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]44
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 4, ",", 44, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]44
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 4, ",", 44, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]44
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 4, ",", 44, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("form["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "4", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "45", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["1.4087821705113706`*^26",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "form[", 5, ",", 4, ",", 45, "]=", 1.4087821705113706*^+26],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("formexact["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "4", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "45", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["1.40878217051134368`*^26",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "formexact[", 5, ",", 4, ",", 45, "]=", 1.4087821705113434*^+26],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "4", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "45", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["13.5663230604702178`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 5, ",", 4, ",", 45, "]=", 13.566323060470218],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]46
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 4, ",", 46, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]46
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 4, ",", 46, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]46
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 4, ",", 46, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]47
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 4, ",", 47, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]47
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 4, ",", 47, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]47
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 4, ",", 47, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]48
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 4, ",", 48, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]48
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 4, ",", 48, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]48
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 4, ",", 48, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]49
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 4, ",", 49, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]49
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 4, ",", 49, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]49
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 4, ",", 49, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]50
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 4, ",", 50, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]50
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 4, ",", 50, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]50
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 4, ",", 50, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("form["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "4", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "51", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["5.28570961427890928`*^31",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "form[", 5, ",", 4, ",", 51, "]=", 5.2857096142789091*^+31],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("formexact["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "4", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "51", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["5.28570961427858776`*^31",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "formexact[", 5, ",", 4, ",", 51, "]=", 5.2857096142785876*^+31],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "4", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "51", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["12.4927420136968048`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 5, ",", 4, ",", 51, "]=", 12.492742013696805],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]52
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 4, ",", 52, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]52
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 4, ",", 52, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]52
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 4, ",", 52, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]53
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 4, ",", 53, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]53
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 4, ",", 53, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]53
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 4, ",", 53, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]54
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 4, ",", 54, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]54
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 4, ",", 54, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]54
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 4, ",", 54, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]55
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 4, ",", 55, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]55
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 4, ",", 55, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]55
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 4, ",", 55, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]56
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 4, ",", 56, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]56
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 4, ",", 56, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]56
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 4, ",", 56, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("form["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "4", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "57", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["3.55202152744059551`*^37",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "form[", 5, ",", 4, ",", 57, "]=", 3.5520215274405959*^+37],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("formexact["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "4", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "57", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["3.55202152744007637`*^37",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "formexact[", 5, ",", 4, ",", 57, "]=", 3.5520215274400769*^+37],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "4", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "57", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["12.284842619769869`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 5, ",", 4, ",", 57, "]=", 12.284842619769869],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]58
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 4, ",", 58, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]58
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 4, ",", 58, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]58
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 4, ",", 58, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]59
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 4, ",", 59, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]59
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 4, ",", 59, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]59
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 4, ",", 59, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]60
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 4, ",", 60, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]60
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 4, ",", 60, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]60
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 4, ",", 60, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]61
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 4, ",", 61, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]61
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 4, ",", 61, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]61
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 4, ",", 61, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]62
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 4, ",", 62, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]62
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 4, ",", 62, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]62
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 4, ",", 62, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("form["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "4", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "63", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["4.02239922141977057`*^43",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "form[", 5, ",", 4, ",", 63, "]=", 4.0223992214197711*^+43],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("formexact["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "4", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "63", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["4.02239922141886374`*^43",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "formexact[", 5, ",", 4, ",", 63, "]=", 4.022399221418864*^+43],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "4", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "63", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["12.0423149295818987`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 5, ",", 4, ",", 63, "]=", 12.042314929581899],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]64
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 4, ",", 64, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]64
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 4, ",", 64, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]64
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 4, ",", 64, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]65
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 4, ",", 65, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]65
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 4, ",", 65, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]65
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 4, ",", 65, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]66
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 4, ",", 66, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]66
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 4, ",", 66, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]66
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 4, ",", 66, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]67
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 4, ",", 67, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]67
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 4, ",", 67, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]67
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 4, ",", 67, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]68
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 4, ",", 68, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]68
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 4, ",", 68, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]68
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 4, ",", 68, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("form["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "4", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "69", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["7.3059856066443487`*^49",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "form[", 5, ",", 4, ",", 69, "]=", 7.3059856066443487*^+49],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("formexact["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "4", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "69", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["7.30598560664335838`*^49",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "formexact[", 5, ",", 4, ",", 69, "]=", 7.305985606643359*^+49],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "4", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "69", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["12.0045175893318045`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 5, ",", 4, ",", 69, "]=", 12.004517589331805],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]70
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 4, ",", 70, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]70
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 4, ",", 70, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]70
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 4, ",", 70, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]71
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 4, ",", 71, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]71
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 4, ",", 71, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]71
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 4, ",", 71, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]72
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 4, ",", 72, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]72
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 4, ",", 72, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]72
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 4, ",", 72, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]73
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 4, ",", 73, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]73
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 4, ",", 73, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]73
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 4, ",", 73, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]74
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 4, ",", 74, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]74
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 4, ",", 74, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]74
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 4, ",", 74, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("form["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "4", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "75", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["2.04323607508273186`*^56",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "form[", 5, ",", 4, ",", 75, "]=", 2.043236075082732*^+56],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("formexact["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "4", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "75", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["2.0432360750835885`*^56",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "formexact[", 5, ",", 4, ",", 75, "]=", 2.0432360750835883*^+56],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "4", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "75", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["12.0673670718664216`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 5, ",", 4, ",", 75, "]=", 12.067367071866421],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]76
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 4, ",", 76, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]76
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 4, ",", 76, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]76
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 4, ",", 76, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]77
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 4, ",", 77, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]77
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 4, ",", 77, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]77
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 4, ",", 77, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]78
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 4, ",", 78, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]78
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 4, ",", 78, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]78
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 4, ",", 78, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]79
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 4, ",", 79, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]79
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 4, ",", 79, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]79
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 4, ",", 79, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]80
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 4, ",", 80, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]80
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 4, ",", 80, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]80
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 4, ",", 80, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("form["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "4", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "81", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["8.50143945058327688`*^62",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "form[", 5, ",", 4, ",", 81, "]=", 8.5014394505832781*^+62],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("formexact["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "4", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "81", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["8.50143945059769201`*^62",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "formexact[", 5, ",", 4, ",", 81, "]=", 8.5014394505976922*^+62],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "4", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "81", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["10.8412136775455403`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 5, ",", 4, ",", 81, "]=", 10.841213677545539],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]82
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 4, ",", 82, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]82
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 4, ",", 82, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]82
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 4, ",", 82, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]83
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 4, ",", 83, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]83
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 4, ",", 83, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]83
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 4, ",", 83, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]84
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 4, ",", 84, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]84
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 4, ",", 84, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]84
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 4, ",", 84, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]85
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 4, ",", 85, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]85
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 4, ",", 85, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]85
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 4, ",", 85, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]86
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 4, ",", 86, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]86
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 4, ",", 86, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]86
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 4, ",", 86, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("form["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "4", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "87", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["5.11079597290271614`*^69",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "form[", 5, ",", 4, ",", 87, "]=", 5.1107959729027162*^+69],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("formexact["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "4", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "87", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["5.11079597291407772`*^69",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "formexact[", 5, ",", 4, ",", 87, "]=", 5.1107959729140773*^+69],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "4", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "87", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["10.9445774885879876`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 5, ",", 4, ",", 87, "]=", 10.944577488587989],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]88
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 4, ",", 88, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]88
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 4, ",", 88, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]88
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 4, ",", 88, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]89
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 4, ",", 89, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]89
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 4, ",", 89, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]89
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 4, ",", 89, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]90
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 4, ",", 90, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]90
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 4, ",", 90, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]90
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 4, ",", 90, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]91
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 4, ",", 91, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]91
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 4, ",", 91, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]91
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 4, ",", 91, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]92
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 4, ",", 92, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]92
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 4, ",", 92, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]92
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 4, ",", 92, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("form["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "4", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "93", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["4.32853461115718296`*^76",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "form[", 5, ",", 4, ",", 93, "]=", 4.3285346111571833*^+76],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("formexact["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "4", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "93", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["4.32853461111015569`*^76",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "formexact[", 5, ",", 4, ",", 93, "]=", 4.3285346111101572*^+76],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "4", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "93", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["10.3276612428834235`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 5, ",", 4, ",", 93, "]=", 10.327661242883423],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]94
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 4, ",", 94, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]94
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 4, ",", 94, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]94
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 4, ",", 94, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]95
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 4, ",", 95, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]95
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 4, ",", 95, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]95
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 4, ",", 95, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]96
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 4, ",", 96, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]96
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 4, ",", 96, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]96
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 4, ",", 96, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]97
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 4, ",", 97, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]97
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 4, ",", 97, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]97
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 4, ",", 97, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]98
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 4, ",", 98, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]98
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 4, ",", 98, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]98
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 4, ",", 98, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("form["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "4", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "99", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["5.05234340400477854`*^83",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "form[", 5, ",", 4, ",", 99, "]=", 5.0523434040047796*^+83],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("formexact["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "4", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "99", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["5.05234340349741017`*^83",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "formexact[", 5, ",", 4, ",", 99, "]=", 5.0523434034974107*^+83],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "4", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "99", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["9.29467612120963337`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 5, ",", 4, ",", 99, "]=", 9.2946761212096334],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]100
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 4, ",", 100, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]100
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 4, ",", 100, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]100
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 4, ",", 100, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]101
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 4, ",", 101, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]101
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 4, ",", 101, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]101
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 4, ",", 101, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]102
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 4, ",", 102, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]102
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 4, ",", 102, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]102
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 4, ",", 102, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]103
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 4, ",", 103, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]103
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 4, ",", 103, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]103
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 4, ",", 103, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]104
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 4, ",", 104, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]104
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 4, ",", 104, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]104
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 4, ",", 104, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("form["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "4", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "105", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["7.97152848192934992`*^90",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "form[", 5, ",", 4, ",", 105, "]=", 7.9715284819293493*^+90],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("formexact["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "4", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "105", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["7.97152847803184094`*^90",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "formexact[", 5, ",", 4, ",", 105, "]=", 7.9715284780318409*^+90],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "4", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "105", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["8.40921294561761101`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 5, ",", 4, ",", 105, "]=", 8.409212945617611],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]106
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 4, ",", 106, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]106
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 4, ",", 106, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]106
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 4, ",", 106, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]107
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 4, ",", 107, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]107
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 4, ",", 107, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]107
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 4, ",", 107, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]108
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 4, ",", 108, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]108
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 4, ",", 108, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]108
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 4, ",", 108, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]109
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 4, ",", 109, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]109
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 4, ",", 109, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]109
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 4, ",", 109, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]110
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 4, ",", 110, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]110
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 4, ",", 110, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]110
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 4, ",", 110, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("form["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "4", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "111", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["1.67124804062905703`*^98",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "form[", 5, ",", 4, ",", 111, "]=", 1.671248040629057*^+98],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("formexact["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "4", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "111", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["1.67124803770502055`*^98",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "formexact[", 5, ",", 4, ",", 111, "]=", 1.6712480377050204*^+98],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "4", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "111", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["8.53401719325208318`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 5, ",", 4, ",", 111, "]=", 8.5340171932520832],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]112
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 4, ",", 112, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]112
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 4, ",", 112, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]112
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 4, ",", 112, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]113
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 4, ",", 113, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]113
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 4, ",", 113, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]113
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 4, ",", 113, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]114
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 4, ",", 114, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]114
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 4, ",", 114, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]114
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 4, ",", 114, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]115
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 4, ",", 115, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]115
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 4, ",", 115, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]115
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 4, ",", 115, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]116
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 4, ",", 116, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]116
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 4, ",", 116, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]116
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 4, ",", 116, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("form["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "4", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "117", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["4.58507636680013863`*^105",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "form[", 5, ",", 4, ",", 117, "]=", 4.5850763668001381*^+105],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("formexact["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "4", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "117", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["4.5850763449350893`*^105",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "formexact[", 5, ",", 4, ",", 117, "]=", 4.5850763449350895*^+105],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "4", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "117", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["7.66024955178957611`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 5, ",", 4, ",", 117, "]=", 7.6602495517895761],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]118
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 4, ",", 118, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]118
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 4, ",", 118, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]118
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 4, ",", 118, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]119
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 4, ",", 119, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]119
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 4, ",", 119, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]119
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 4, ",", 119, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]120
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 4, ",", 120, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]120
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 4, ",", 120, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]120
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 4, ",", 120, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]121
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 4, ",", 121, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]121
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 4, ",", 121, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]121
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 4, ",", 121, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]122
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 4, ",", 122, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]122
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 4, ",", 122, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]122
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 4, ",", 122, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("form["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "4", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "123", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["1.6236535258526108`*^113",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "form[", 5, ",", 4, ",", 123, "]=", 1.6236535258526111*^+113],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("formexact["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "4", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "123", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["1.62365351137073403`*^113",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "formexact[", 5, ",", 4, ",", 123, "]=", 1.6236535113707341*^+113],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "4", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "123", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["7.83917514753088084`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 5, ",", 4, ",", 123, "]=", 7.8391751475308808],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]124
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 4, ",", 124, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]124
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 4, ",", 124, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]124
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 4, ",", 124, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]125
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 4, ",", 125, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]125
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 4, ",", 125, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]125
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 4, ",", 125, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]126
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 4, ",", 126, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]126
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 4, ",", 126, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]126
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 4, ",", 126, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]127
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 4, ",", 127, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]127
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 4, ",", 127, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]127
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 4, ",", 127, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]128
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 4, ",", 128, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]128
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 4, ",", 128, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]128
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 4, ",", 128, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("form["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "4", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "129", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["7.32986473283687267`*^120",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "form[", 5, ",", 4, ",", 129, "]=", 7.3298647328368745*^+120],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("formexact["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "4", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "129", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["7.32986470915901211`*^120",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "formexact[", 5, ",", 4, ",", 129, "]=", 7.3298647091590115*^+120],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "4", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "129", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["7.6256574970366131`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 5, ",", 4, ",", 129, "]=", 7.6256574970366131],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]130
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 4, ",", 130, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]130
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 4, ",", 130, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]130
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 4, ",", 130, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]131
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 4, ",", 131, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]131
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 4, ",", 131, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]131
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 4, ",", 131, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]132
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 4, ",", 132, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]132
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 4, ",", 132, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]132
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 4, ",", 132, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]133
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 4, ",", 133, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]133
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 4, ",", 133, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]133
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 4, ",", 133, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]134
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 4, ",", 134, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]134
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 4, ",", 134, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]134
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 4, ",", 134, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("form["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "4", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "135", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["4.1712698876084655`*^128",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "form[", 5, ",", 4, ",", 135, "]=", 4.1712698876084648*^+128],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("formexact["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "4", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "135", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["4.17127015473401385`*^128",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "formexact[", 5, ",", 4, ",", 135, "]=", 4.1712701547340149*^+128],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "4", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "135", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["6.57328457049622727`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 5, ",", 4, ",", 135, "]=", 6.5732845704962273],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]136
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 4, ",", 136, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]136
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 4, ",", 136, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]136
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 4, ",", 136, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]137
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 4, ",", 137, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]137
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 4, ",", 137, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]137
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 4, ",", 137, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]138
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 4, ",", 138, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]138
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 4, ",", 138, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]138
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 4, ",", 138, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]139
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 4, ",", 139, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]139
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 4, ",", 139, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]139
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 4, ",", 139, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]140
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 4, ",", 140, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]140
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 4, ",", 140, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]140
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 4, ",", 140, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("form["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "4", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "141", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["2.96180923654925809`*^136",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "form[", 5, ",", 4, ",", 141, "]=", 2.9618092365492579*^+136],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("formexact["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "4", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "141", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["2.96181034556041922`*^136",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "formexact[", 5, ",", 4, ",", 141, "]=", 2.96181034556042*^+136],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "4", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "141", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["5.95506408267544884`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 5, ",", 4, ",", 141, "]=", 5.9550640826754488],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]142
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 4, ",", 142, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]142
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 4, ",", 142, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]142
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 4, ",", 142, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]143
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 4, ",", 143, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]143
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 4, ",", 143, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]143
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 4, ",", 143, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]144
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 4, ",", 144, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]144
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 4, ",", 144, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]144
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 4, ",", 144, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]145
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 4, ",", 145, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]145
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 4, ",", 145, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]145
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 4, ",", 145, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]146
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 4, ",", 146, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]146
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 4, ",", 146, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]146
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 4, ",", 146, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("form["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "4", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "147", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["2.5994812174976789`*^144",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "form[", 5, ",", 4, ",", 147, "]=", 2.5994812174976787*^+144],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("formexact["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "4", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "147", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["2.59948504922026746`*^144",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "formexact[", 5, ",", 4, ",", 147, "]=", 2.5994850492202676*^+144],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "4", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "147", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["5.41660594073695733`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 5, ",", 4, ",", 147, "]=", 5.4166059407369573],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]148
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 4, ",", 148, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]148
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 4, ",", 148, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]148
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 4, ",", 148, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]149
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 4, ",", 149, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]149
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 4, ",", 149, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]149
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 4, ",", 149, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]150
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 4, ",", 150, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]150
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 4, ",", 150, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]150
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 4, ",", 150, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]151
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 4, ",", 151, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]151
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 4, ",", 151, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]151
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 4, ",", 151, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]152
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 4, ",", 152, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]152
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 4, ",", 152, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]152
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 4, ",", 152, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("form["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "4", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "153", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["2.79584232842950308`*^152",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "form[", 5, ",", 4, ",", 153, "]=", 2.7958423284295036*^+152],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("formexact["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "4", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "153", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["2.7958558583075348`*^152",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "formexact[", 5, ",", 4, ",", 153, "]=", 2.7958558583075346*^+152],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "4", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "153", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["4.86870611845918688`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 5, ",", 4, ",", 153, "]=", 4.8687061184591869],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]154
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 4, ",", 154, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]154
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 4, ",", 154, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]154
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 4, ",", 154, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]155
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 4, ",", 155, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]155
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 4, ",", 155, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]155
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 4, ",", 155, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]156
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 4, ",", 156, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]156
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 4, ",", 156, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]156
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 4, ",", 156, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]157
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 4, ",", 157, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]157
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 4, ",", 157, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]157
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 4, ",", 157, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]158
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 4, ",", 158, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]158
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 4, ",", 158, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]158
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 4, ",", 158, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("form["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "4", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "159", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["3.655800093832819`*^160",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "form[", 5, ",", 4, ",", 159, "]=", 3.6558000938328185*^+160],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("formexact["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "4", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "159", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["3.6558516447014524`*^160",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "formexact[", 5, ",", 4, ",", 159, "]=", 3.6558516447014523*^+160],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "4", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "159", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["4.28776401244275007`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 5, ",", 4, ",", 159, "]=", 4.2877640124427501],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]160
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 4, ",", 160, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]160
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 4, ",", 160, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]160
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 4, ",", 160, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]161
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 4, ",", 161, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]161
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 4, ",", 161, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]161
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 4, ",", 161, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]162
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 4, ",", 162, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]162
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 4, ",", 162, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]162
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 4, ",", 162, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]163
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 4, ",", 163, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]163
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 4, ",", 163, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]163
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 4, ",", 163, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]164
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 4, ",", 164, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]164
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 4, ",", 164, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]164
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 4, ",", 164, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("form["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "4", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "165", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["5.76900806714114811`*^168",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "form[", 5, ",", 4, ",", 165, "]=", 5.7690080671411478*^+168],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("formexact["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "4", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "165", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["5.76922295134226459`*^168",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "formexact[", 5, ",", 4, ",", 165, "]=", 5.7692229513422664*^+168],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "4", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "165", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["3.66779551386767366`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 5, ",", 4, ",", 165, "]=", 3.6677955138676737],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]166
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 4, ",", 166, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]166
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 4, ",", 166, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]166
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 4, ",", 166, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]167
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 4, ",", 167, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]167
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 4, ",", 167, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]167
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 4, ",", 167, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]168
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 4, ",", 168, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]168
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 4, ",", 168, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]168
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 4, ",", 168, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]169
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 4, ",", 169, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]169
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 4, ",", 169, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]169
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 4, ",", 169, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]170
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 4, ",", 170, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]170
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 4, ",", 170, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]170
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 4, ",", 170, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("form["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "4", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "171", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["1.09119526838485425`*^177",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "form[", 5, ",", 4, ",", 171, "]=", 1.0911952683848542*^+177],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("formexact["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "4", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "171", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["1.09129237743695984`*^177",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "formexact[", 5, ",", 4, ",", 171, "]=", 1.09129237743696*^+177],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "4", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "171", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["4.01274028506225022`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 5, ",", 4, ",", 171, "]=", 4.0127402850622502],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]172
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 4, ",", 172, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]172
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 4, ",", 172, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]172
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 4, ",", 172, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]173
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 4, ",", 173, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]173
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 4, ",", 173, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]173
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 4, ",", 173, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]174
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 4, ",", 174, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]174
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 4, ",", 174, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]174
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 4, ",", 174, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]175
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 4, ",", 175, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]175
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 4, ",", 175, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]175
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 4, ",", 175, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]176
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 4, ",", 176, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]176
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 4, ",", 176, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]176
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 4, ",", 176, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("form["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "4", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "177", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["2.45825064580892327`*^185",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "form[", 5, ",", 4, ",", 177, "]=", 2.4582506458089234*^+185],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("formexact["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "4", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "177", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["2.45870915418055702`*^185",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "formexact[", 5, ",", 4, ",", 177, "]=", 2.4587091541805573*^+185],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "4", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "177", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["3.33865273039489807`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 5, ",", 4, ",", 177, "]=", 3.3386527303948981],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]178
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 4, ",", 178, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]178
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 4, ",", 178, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]178
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 4, ",", 178, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]179
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 4, ",", 179, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]179
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 4, ",", 179, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]179
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 4, ",", 179, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]180
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 4, ",", 180, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]180
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 4, ",", 180, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]180
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 4, ",", 180, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    \("   "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]0
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 5, ",", 0, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]0
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 5, ",", 0, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]0
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 5, ",", 0, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 5, ",", 1, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 5, ",", 1, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 5, ",", 1, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 5, ",", 2, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 5, ",", 2, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 5, ",", 2, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 5, ",", 3, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 5, ",", 3, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 5, ",", 3, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("form["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "5", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "4", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["1.`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "form[", 5, ",", 5, ",", 4, "]=", 1.0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("formexact["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "4", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["1.`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "formexact[", 5, ",", 5, ",", 4, "]=", 1.0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "4", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        InterpretationBox["\[Infinity]",
          DirectedInfinity[ 1]]}],
      SequenceForm[ "exactdigits[", 5, ",", 5, ",", 4, "]=", 
        DirectedInfinity[ 1]],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 5, ",", 5, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 5, ",", 5, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 5, ",", 5, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]6
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 5, ",", 6, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]6
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 5, ",", 6, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]6
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 5, ",", 6, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]7
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 5, ",", 7, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]7
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 5, ",", 7, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]7
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 5, ",", 7, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]8
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 5, ",", 8, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]8
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 5, ",", 8, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]8
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 5, ",", 8, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]9
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 5, ",", 9, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]9
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 5, ",", 9, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]9
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 5, ",", 9, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("form["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "5", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "10", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["35.`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "form[", 5, ",", 5, ",", 10, "]=", 35.0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("formexact["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "10", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["35.`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "formexact[", 5, ",", 5, ",", 10, "]=", 35.0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "10", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        InterpretationBox["\[Infinity]",
          DirectedInfinity[ 1]]}],
      SequenceForm[ "exactdigits[", 5, ",", 5, ",", 10, "]=", 
        DirectedInfinity[ 1]],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]11
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 5, ",", 11, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]11
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 5, ",", 11, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]11
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 5, ",", 11, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]12
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 5, ",", 12, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]12
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 5, ",", 12, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]12
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 5, ",", 12, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]13
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 5, ",", 13, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]13
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 5, ",", 13, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]13
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 5, ",", 13, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]14
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 5, ",", 14, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]14
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 5, ",", 14, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]14
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 5, ",", 14, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]15
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 5, ",", 15, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]15
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 5, ",", 15, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]15
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 5, ",", 15, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("form["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "5", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "16", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["23356.66666666667`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "form[", 5, ",", 5, ",", 16, "]=", 23356.666666666668],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("formexact["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "16", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["23356.66666666667`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "formexact[", 5, ",", 5, ",", 16, "]=", 23356.666666666668],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "16", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        InterpretationBox["\[Infinity]",
          DirectedInfinity[ 1]]}],
      SequenceForm[ "exactdigits[", 5, ",", 5, ",", 16, "]=", 
        DirectedInfinity[ 1]],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]17
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 5, ",", 17, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]17
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 5, ",", 17, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]17
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 5, ",", 17, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]18
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 5, ",", 18, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]18
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 5, ",", 18, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]18
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 5, ",", 18, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]19
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 5, ",", 19, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]19
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 5, ",", 19, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]19
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 5, ",", 19, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]20
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 5, ",", 20, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]20
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 5, ",", 20, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]20
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 5, ",", 20, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]21
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 5, ",", 21, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]21
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 5, ",", 21, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]21
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 5, ",", 21, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("form["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "5", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "22", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["9.68172761111111057`*^7",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "form[", 5, ",", 5, ",", 22, "]=", 96817276.111111104],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("formexact["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "22", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["9.68172761111111057`*^7",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "formexact[", 5, ",", 5, ",", 22, "]=", 96817276.111111104],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "22", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        InterpretationBox["\[Infinity]",
          DirectedInfinity[ 1]]}],
      SequenceForm[ "exactdigits[", 5, ",", 5, ",", 22, "]=", 
        DirectedInfinity[ 1]],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]23
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 5, ",", 23, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]23
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 5, ",", 23, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]23
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 5, ",", 23, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]24
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 5, ",", 24, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]24
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 5, ",", 24, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]24
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 5, ",", 24, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]25
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 5, ",", 25, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]25
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 5, ",", 25, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]25
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 5, ",", 25, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]26
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 5, ",", 26, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]26
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 5, ",", 26, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]26
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 5, ",", 26, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]27
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 5, ",", 27, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]27
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 5, ",", 27, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]27
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 5, ",", 27, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("form["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "5", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "28", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["1.51978919175416704`*^12",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "form[", 5, ",", 5, ",", 28, "]=", 1519789191754.167],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("formexact["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "28", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["1.51978919175416677`*^12",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "formexact[", 5, ",", 5, ",", 28, "]=", 1519789191754.1667],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "28", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["15.612359947967775`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 5, ",", 5, ",", 28, "]=", 15.612359947967775],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]29
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 5, ",", 29, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]29
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 5, ",", 29, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]29
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 5, ",", 29, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]30
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 5, ",", 30, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]30
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 5, ",", 30, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]30
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 5, ",", 30, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]31
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 5, ",", 31, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]31
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 5, ",", 31, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]31
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 5, ",", 31, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]32
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 5, ",", 32, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]32
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 5, ",", 32, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]32
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 5, ",", 32, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]33
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 5, ",", 33, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]33
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 5, ",", 33, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]33
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 5, ",", 33, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("form["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "5", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "34", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["6.81323521048981728`*^16",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "form[", 5, ",", 5, ",", 34, "]=", 68132352104898176.0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("formexact["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "34", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["6.81323521048981994`*^16",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "formexact[", 5, ",", 5, ",", 34, "]=", 68132352104898192.0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "34", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["14.795880017344074`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 5, ",", 5, ",", 34, "]=", 14.795880017344075],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]35
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 5, ",", 35, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]35
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 5, ",", 35, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]35
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 5, ",", 35, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]36
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 5, ",", 36, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]36
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 5, ",", 36, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]36
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 5, ",", 36, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]37
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 5, ",", 37, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]37
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 5, ",", 37, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]37
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 5, ",", 37, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]38
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 5, ",", 38, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]38
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 5, ",", 38, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]38
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 5, ",", 38, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]39
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 5, ",", 39, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]39
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 5, ",", 39, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]39
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 5, ",", 39, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("form["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "5", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "40", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["7.26438493534435814`*^21",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "form[", 5, ",", 5, ",", 40, "]=", 7.2643849353443588*^+21],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("formexact["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "40", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["7.2643849353444212`*^21",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "formexact[", 5, ",", 5, ",", 40, "]=", 7.2643849353444207*^+21],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "40", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["13.2085480750782324`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 5, ",", 5, ",", 40, "]=", 13.208548075078232],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]41
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 5, ",", 41, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]41
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 5, ",", 41, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]41
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 5, ",", 41, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]42
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 5, ",", 42, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]42
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 5, ",", 42, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]42
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 5, ",", 42, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]43
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 5, ",", 43, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]43
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 5, ",", 43, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]43
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 5, ",", 43, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]44
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 5, ",", 44, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]44
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 5, ",", 44, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]44
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 5, ",", 44, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]45
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 5, ",", 45, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]45
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 5, ",", 45, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]45
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 5, ",", 45, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("form["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "5", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "46", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["1.62009949608798597`*^27",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "form[", 5, ",", 5, ",", 46, "]=", 1.6200994960879858*^+27],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("formexact["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "46", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["1.62009949608804504`*^27",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "formexact[", 5, ",", 5, ",", 46, "]=", 1.6200994960880449*^+27],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "46", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["13.2284217048531127`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 5, ",", 5, ",", 46, "]=", 13.228421704853112],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]47
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 5, ",", 47, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]47
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 5, ",", 47, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]47
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 5, ",", 47, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]48
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 5, ",", 48, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]48
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 5, ",", 48, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]48
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 5, ",", 48, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]49
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 5, ",", 49, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]49
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 5, ",", 49, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]49
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 5, ",", 49, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]50
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 5, ",", 50, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]50
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 5, ",", 50, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]50
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 5, ",", 50, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]51
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 5, ",", 51, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]51
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 5, ",", 51, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]51
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 5, ",", 51, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("form["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "5", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "52", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["6.87142249856155729`*^32",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "form[", 5, ",", 5, ",", 52, "]=", 6.8714224985615565*^+32],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("formexact["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "52", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["6.87142249856216302`*^32",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "formexact[", 5, ",", 5, ",", 52, "]=", 6.8714224985621632*^+32],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "52", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["12.2170081513174055`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 5, ",", 5, ",", 52, "]=", 12.217008151317405],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]53
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 5, ",", 53, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]53
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 5, ",", 53, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]53
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 5, ",", 53, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]54
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 5, ",", 54, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]54
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 5, ",", 54, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]54
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 5, ",", 54, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]55
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 5, ",", 55, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]55
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 5, ",", 55, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]55
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 5, ",", 55, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]56
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 5, ",", 56, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]56
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 5, ",", 56, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]56
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 5, ",", 56, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]57
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 5, ",", 57, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]57
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 5, ",", 57, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]57
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 5, ",", 57, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("form["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "5", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "58", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["5.15043121478752485`*^38",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "form[", 5, ",", 5, ",", 58, "]=", 5.1504312147875258*^+38],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("formexact["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "58", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["5.15043121478811194`*^38",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "formexact[", 5, ",", 5, ",", 58, "]=", 5.1504312147881121*^+38],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "58", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["12.2318586082792424`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 5, ",", 5, ",", 58, "]=", 12.231858608279243],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]59
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 5, ",", 59, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]59
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 5, ",", 59, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]59
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 5, ",", 59, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]60
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 5, ",", 60, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]60
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 5, ",", 60, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]60
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 5, ",", 60, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]61
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 5, ",", 61, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]61
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 5, ",", 61, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]61
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 5, ",", 61, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]62
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 5, ",", 62, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]62
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 5, ",", 62, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]62
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 5, ",", 62, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]63
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 5, ",", 63, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]63
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 5, ",", 63, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]63
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 5, ",", 63, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("form["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "5", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "64", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["6.4358387542713924`*^44",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "form[", 5, ",", 5, ",", 64, "]=", 6.4358387542713929*^+44],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("formexact["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "64", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["6.43583875427018181`*^44",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "formexact[", 5, ",", 5, ",", 64, "]=", 6.4358387542701823*^+44],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "64", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["11.9169970620181331`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 5, ",", 5, ",", 64, "]=", 11.916997062018133],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]65
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 5, ",", 65, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]65
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 5, ",", 65, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]65
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 5, ",", 65, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]66
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 5, ",", 66, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]66
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 5, ",", 66, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]66
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 5, ",", 66, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]67
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 5, ",", 67, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]67
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 5, ",", 67, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]67
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 5, ",", 67, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]68
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 5, ",", 68, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]68
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 5, ",", 68, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]68
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 5, ",", 68, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]69
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 5, ",", 69, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]69
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 5, ",", 69, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]69
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 5, ",", 69, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("form["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "5", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "70", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["1.27854748116521754`*^51",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "form[", 5, ",", 5, ",", 70, "]=", 1.2785474811652174*^+51],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("formexact["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "70", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["1.27854748116258765`*^51",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "formexact[", 5, ",", 5, ",", 70, "]=", 1.2785474811625877*^+51],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "70", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["11.5800919049545858`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 5, ",", 5, ",", 70, "]=", 11.580091904954585],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]71
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 5, ",", 71, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]71
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 5, ",", 71, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]71
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 5, ",", 71, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]72
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 5, ",", 72, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]72
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 5, ",", 72, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]72
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 5, ",", 72, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]73
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 5, ",", 73, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]73
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 5, ",", 73, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]73
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 5, ",", 73, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]74
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 5, ",", 74, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]74
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 5, ",", 74, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]74
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 5, ",", 74, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]75
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 5, ",", 75, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]75
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 5, ",", 75, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]75
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 5, ",", 75, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("form["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "5", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "76", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["3.88214854269569542`*^57",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "form[", 5, ",", 5, ",", 76, "]=", 3.8821485426956955*^+57],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("formexact["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "76", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["3.88214854265881825`*^57",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "formexact[", 5, ",", 5, ",", 76, "]=", 3.8821485426588178*^+57],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "76", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["10.4332353877576133`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 5, ",", 5, ",", 76, "]=", 10.433235387757613],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]77
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 5, ",", 77, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]77
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 5, ",", 77, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]77
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 5, ",", 77, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]78
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 5, ",", 78, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]78
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 5, ",", 78, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]78
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 5, ",", 78, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]79
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 5, ",", 79, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]79
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 5, ",", 79, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]79
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 5, ",", 79, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]80
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 5, ",", 80, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]80
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 5, ",", 80, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]80
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 5, ",", 80, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]81
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 5, ",", 81, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]81
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 5, ",", 81, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]81
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 5, ",", 81, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("form["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "5", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "82", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["1.74279508743045923`*^64",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "form[", 5, ",", 5, ",", 82, "]=", 1.7427950874304596*^+64],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("formexact["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "82", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["1.7427950873725269`*^64",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "formexact[", 5, ",", 5, ",", 82, "]=", 1.7427950873725271*^+64],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "82", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["10.2370780040537079`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 5, ",", 5, ",", 82, "]=", 10.237078004053707],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]83
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 5, ",", 83, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]83
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 5, ",", 83, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]83
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 5, ",", 83, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]84
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 5, ",", 84, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]84
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 5, ",", 84, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]84
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 5, ",", 84, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]85
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 5, ",", 85, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]85
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 5, ",", 85, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]85
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 5, ",", 85, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]86
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 5, ",", 86, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]86
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 5, ",", 86, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]86
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 5, ",", 86, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]87
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 5, ",", 87, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]87
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 5, ",", 87, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]87
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 5, ",", 87, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("form["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "5", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "88", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["1.12437511415237634`*^71",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "form[", 5, ",", 5, ",", 88, "]=", 1.1243751141523762*^+71],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("formexact["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "88", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["1.12437511404109735`*^71",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "formexact[", 5, ",", 5, ",", 88, "]=", 1.1243751140410971*^+71],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "88", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["9.95358663975339652`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 5, ",", 5, ",", 88, "]=", 9.9535866397533965],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]89
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 5, ",", 89, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]89
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 5, ",", 89, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]89
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 5, ",", 89, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]90
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 5, ",", 90, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]90
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 5, ",", 90, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]90
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 5, ",", 90, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]91
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 5, ",", 91, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]91
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 5, ",", 91, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]91
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 5, ",", 91, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]92
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 5, ",", 92, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]92
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 5, ",", 92, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]92
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 5, ",", 92, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]93
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 5, ",", 93, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]93
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 5, ",", 93, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]93
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 5, ",", 93, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("form["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "5", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "94", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["1.01720563388341433`*^78",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "form[", 5, ",", 5, ",", 94, "]=", 1.0172056338834144*^+78],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("formexact["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "94", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["1.017205633610887`*^78",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "formexact[", 5, ",", 5, ",", 94, "]=", 1.0172056336108871*^+78],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "94", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["9.564590096938133`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 5, ",", 5, ",", 94, "]=", 9.564590096938133],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]95
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 5, ",", 95, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]95
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 5, ",", 95, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]95
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 5, ",", 95, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]96
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 5, ",", 96, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]96
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 5, ",", 96, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]96
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 5, ",", 96, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]97
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 5, ",", 97, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]97
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 5, ",", 97, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]97
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 5, ",", 97, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]98
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 5, ",", 98, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]98
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 5, ",", 98, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]98
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 5, ",", 98, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]99
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 5, ",", 99, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]99
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 5, ",", 99, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]99
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 5, ",", 99, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("form["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "5", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "100", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["1.26308585175704579`*^85",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "form[", 5, ",", 5, ",", 100, "]=", 1.263085851757046*^+85],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("formexact["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "100", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["1.26308585087435276`*^85",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "formexact[", 5, ",", 5, ",", 100, "]=", 1.2630858508743527*^+85],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "100", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["9.05419015627920487`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 5, ",", 5, ",", 100, "]=", 9.0541901562792049],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]101
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 5, ",", 101, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]101
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 5, ",", 101, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]101
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 5, ",", 101, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]102
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 5, ",", 102, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]102
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 5, ",", 102, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]102
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 5, ",", 102, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]103
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 5, ",", 103, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]103
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 5, ",", 103, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]103
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 5, ",", 103, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]104
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 5, ",", 104, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]104
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 5, ",", 104, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]104
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 5, ",", 104, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]105
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 5, ",", 105, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]105
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 5, ",", 105, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]105
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 5, ",", 105, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("form["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "5", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "106", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["2.11245505055418769`*^92",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "form[", 5, ",", 5, ",", 106, "]=", 2.1124550505541876*^+92],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("formexact["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "106", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["2.11245504667843775`*^92",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "formexact[", 5, ",", 5, ",", 106, "]=", 2.1124550466784376*^+92],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "106", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["8.41164424789403142`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 5, ",", 5, ",", 106, "]=", 8.4116442478940314],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]107
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 5, ",", 107, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]107
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 5, ",", 107, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]107
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 5, ",", 107, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]108
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 5, ",", 108, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]108
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 5, ",", 108, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]108
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 5, ",", 108, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]109
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 5, ",", 109, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]109
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 5, ",", 109, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]109
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 5, ",", 109, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]110
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 5, ",", 110, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]110
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 5, ",", 110, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]110
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 5, ",", 110, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]111
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 5, ",", 111, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]111
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 5, ",", 111, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]111
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 5, ",", 111, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("form["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "5", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "112", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["4.67949452851388425`*^99",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "form[", 5, ",", 5, ",", 112, "]=", 4.6794945285138841*^+99],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("formexact["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "112", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["4.67949450557405555`*^99",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "formexact[", 5, ",", 5, ",", 112, "]=", 4.6794945055740563*^+99],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "112", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["7.63940984536620248`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 5, ",", 5, ",", 112, "]=", 7.6394098453662025],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]113
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 5, ",", 113, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]113
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 5, ",", 113, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]113
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 5, ",", 113, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]114
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 5, ",", 114, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]114
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 5, ",", 114, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]114
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 5, ",", 114, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]115
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 5, ",", 115, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]115
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 5, ",", 115, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]115
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 5, ",", 115, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]116
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 5, ",", 116, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]116
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 5, ",", 116, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]116
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 5, ",", 116, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]117
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 5, ",", 117, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]117
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 5, ",", 117, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]117
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 5, ",", 117, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("form["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "5", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "118", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["1.3525975394152998`*^107",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "form[", 5, ",", 5, ",", 118, "]=", 1.3525975394153001*^+107],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("formexact["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "118", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["1.35259752175585168`*^107",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "formexact[", 5, ",", 5, ",", 118, "]=", 1.3525975217558516*^+107],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "118", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["7.75302286361166181`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 5, ",", 5, ",", 118, "]=", 7.7530228636116618],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]119
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 5, ",", 119, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]119
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 5, ",", 119, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]119
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 5, ",", 119, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]120
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 5, ",", 120, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]120
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 5, ",", 120, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]120
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 5, ",", 120, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]121
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 5, ",", 121, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]121
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 5, ",", 121, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]121
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 5, ",", 121, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]122
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 5, ",", 122, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]122
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 5, ",", 122, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]122
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 5, ",", 122, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]123
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 5, ",", 123, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]123
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 5, ",", 123, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]123
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 5, ",", 123, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("form["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "5", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "124", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["5.03332605431124768`*^114",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "form[", 5, ",", 5, ",", 124, "]=", 5.0333260543112483*^+114],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("formexact["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "124", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["5.03332588524927704`*^114",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "formexact[", 5, ",", 5, ",", 124, "]=", 5.0333258852492761*^+114],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "124", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["6.7719540692062452`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 5, ",", 5, ",", 124, "]=", 6.7719540692062452],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]125
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 5, ",", 125, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]125
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 5, ",", 125, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]125
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 5, ",", 125, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]126
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 5, ",", 126, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]126
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 5, ",", 126, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]126
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 5, ",", 126, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]127
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 5, ",", 127, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]127
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 5, ",", 127, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]127
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 5, ",", 127, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]128
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 5, ",", 128, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]128
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 5, ",", 5, ",", 128, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]128
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 5, ",", 5, ",", 128, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]129
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 5, ",", 5, ",", 129, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]5\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]129
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceF