(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 3.0,
MathReader 3.0, or any compatible application. The data for the notebook 
starts with the line of stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     40685,        874]*)
(*NotebookOutlinePosition[     41523,        901]*)
(*  CellTagsIndexPosition[     41479,        897]*)
(*WindowFrame->Normal*)



Notebook[{
Cell[TextData[{
  " :Author:  Z\[EAcute]lia da ROCHA \n\n:Address: \n            Departamento \
de Matem\[AAcute]tica Aplicada da\n            Faculdade de Ci\[EHat]ncias do \
Porto\n            Rua das Taipas, 135\n            4050 Porto\n            \
Portugal\n  \n            Tel: ++351 02 2080313\n            Fax: ++351 02 \
2004109\n            Email: mrdioh@fc.up.pt\n\n :Sumary:\n    The ",
  StyleBox["testshfv52",
    FontSize->18],
  " notebook contains the results produced by the package\n    shfv.m \
corresponding to the ",
  StyleBox["example 5.2",
    FontSize->18],
  " of the first paper cited bellow.    \n\n :Date: July 1999. \n\n:Available \
at http://netlib.bell-labs.com/ in the numeralgo library in netlib:     \n\n \
:Notebook Version: 1.0 \n\n :Mathematica Version: 3.0   \n \n :Keywords: \
Shohat-Favard's method, regular forms, d-dimensional canonical forms, \n \
d-orthogonal polynomial sequences.\n\n :Sources:\n \n - Z\[EAcute]lia da \
Rocha, Shohat-Favard and Chebyshev's methods in d-orthogonality, \n Numerical \
Algorithms, 20 (1999) 139-164.\n   \n - About the example treated here see \
p.286 of:\n   K. Douak, The relation of the d-orthogonal polynomials to the \
Appell polynomials,  \n   J. Comput. Appl. Math., 70 (1996) 279-295."
}], "Subsection"],

Cell[CellGroupData[{

Cell["\<\
Computing the moments of the d-dimensional canonical form \
performing formal computations\
\>", "Section",
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell["\<\
Loading the package shfv.m, the package datashfv52.m is \
automatically loaded\
\>", "Subsection"],

Cell[BoxData[
    \(\(<< shohatfavard`shfv`\ ; \)\)], "Input"]
}, Closed]],

Cell[CellGroupData[{

Cell["\<\
The recurrence coefficients are given in the package datashfv52.m\
\
\>", "Subsection",
  AspectRatioFixed->True],

Cell[BoxData[
    \( (*\ showing\ the\ recurrence\ coefficients\ given\ *) \)], "Input"],

Cell[BoxData[
    \(\( (*\ set\ the\ values\ of\ d\ and\ imax\ *) \nd = 3; imax = \ 10; 
    \ \ \ \ \ \  (*\ for\ example\ *) \)\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(Do[\ 
      Do[Print["\<gamma[\>", d, "\<,\>", r, "\<,\>", n, "\<]=\>", \n
          \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \
\ gamma[d, r, n]\ ], \ \ \ \ \ \ \ \n
        \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ {n, 1, imax + r - d + 1}]; 
      Print["\<  \>"], \ \n\ \ \ \ \ \ {r, 0, d - 1}]\ \)\)], "Input"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]0
        \[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]"]="\[InvisibleSpace]1\/4\),
      SequenceForm[ "gamma[", 3, ",", 0, ",", 1, "]=", 
        Rational[ 1, 4]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]0
        \[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]"]="\[InvisibleSpace]1\),
      SequenceForm[ "gamma[", 3, ",", 0, ",", 2, "]=", 1],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]0
        \[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]"]="\[InvisibleSpace]5\/2\),
      SequenceForm[ "gamma[", 3, ",", 0, ",", 3, "]=", 
        Rational[ 5, 2]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]0
        \[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]"]="\[InvisibleSpace]5\),
      SequenceForm[ "gamma[", 3, ",", 0, ",", 4, "]=", 5],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]0
        \[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]"]="\[InvisibleSpace]35\/4\),
      SequenceForm[ "gamma[", 3, ",", 0, ",", 5, "]=", 
        Rational[ 35, 4]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]0
        \[InvisibleSpace]","\[InvisibleSpace]6
        \[InvisibleSpace]"]="\[InvisibleSpace]14\),
      SequenceForm[ "gamma[", 3, ",", 0, ",", 6, "]=", 14],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]0
        \[InvisibleSpace]","\[InvisibleSpace]7
        \[InvisibleSpace]"]="\[InvisibleSpace]21\),
      SequenceForm[ "gamma[", 3, ",", 0, ",", 7, "]=", 21],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]0
        \[InvisibleSpace]","\[InvisibleSpace]8
        \[InvisibleSpace]"]="\[InvisibleSpace]30\),
      SequenceForm[ "gamma[", 3, ",", 0, ",", 8, "]=", 30],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]"]="\[InvisibleSpace]1\/2\),
      SequenceForm[ "gamma[", 3, ",", 1, ",", 1, "]=", 
        Rational[ 1, 2]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]"]="\[InvisibleSpace]3\/2\),
      SequenceForm[ "gamma[", 3, ",", 1, ",", 2, "]=", 
        Rational[ 3, 2]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]"]="\[InvisibleSpace]3\),
      SequenceForm[ "gamma[", 3, ",", 1, ",", 3, "]=", 3],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]"]="\[InvisibleSpace]5\),
      SequenceForm[ "gamma[", 3, ",", 1, ",", 4, "]=", 5],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]"]="\[InvisibleSpace]15\/2\),
      SequenceForm[ "gamma[", 3, ",", 1, ",", 5, "]=", 
        Rational[ 15, 2]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]6
        \[InvisibleSpace]"]="\[InvisibleSpace]21\/2\),
      SequenceForm[ "gamma[", 3, ",", 1, ",", 6, "]=", 
        Rational[ 21, 2]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]7
        \[InvisibleSpace]"]="\[InvisibleSpace]14\),
      SequenceForm[ "gamma[", 3, ",", 1, ",", 7, "]=", 14],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]8
        \[InvisibleSpace]"]="\[InvisibleSpace]18\),
      SequenceForm[ "gamma[", 3, ",", 1, ",", 8, "]=", 18],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]9
        \[InvisibleSpace]"]="\[InvisibleSpace]45\/2\),
      SequenceForm[ "gamma[", 3, ",", 1, ",", 9, "]=", 
        Rational[ 45, 2]],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]"]="\[InvisibleSpace]2\/3\),
      SequenceForm[ "gamma[", 3, ",", 2, ",", 1, "]=", 
        Rational[ 2, 3]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]"]="\[InvisibleSpace]4\/3\),
      SequenceForm[ "gamma[", 3, ",", 2, ",", 2, "]=", 
        Rational[ 4, 3]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]"]="\[InvisibleSpace]2\),
      SequenceForm[ "gamma[", 3, ",", 2, ",", 3, "]=", 2],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]"]="\[InvisibleSpace]8\/3\),
      SequenceForm[ "gamma[", 3, ",", 2, ",", 4, "]=", 
        Rational[ 8, 3]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]"]="\[InvisibleSpace]10\/3\),
      SequenceForm[ "gamma[", 3, ",", 2, ",", 5, "]=", 
        Rational[ 10, 3]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]6
        \[InvisibleSpace]"]="\[InvisibleSpace]4\),
      SequenceForm[ "gamma[", 3, ",", 2, ",", 6, "]=", 4],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]7
        \[InvisibleSpace]"]="\[InvisibleSpace]14\/3\),
      SequenceForm[ "gamma[", 3, ",", 2, ",", 7, "]=", 
        Rational[ 14, 3]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]8
        \[InvisibleSpace]"]="\[InvisibleSpace]16\/3\),
      SequenceForm[ "gamma[", 3, ",", 2, ",", 8, "]=", 
        Rational[ 16, 3]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]9
        \[InvisibleSpace]"]="\[InvisibleSpace]6\),
      SequenceForm[ "gamma[", 3, ",", 2, ",", 9, "]=", 6],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]10
        \[InvisibleSpace]"]="\[InvisibleSpace]20\/3\),
      SequenceForm[ "gamma[", 3, ",", 2, ",", 10, "]=", 
        Rational[ 20, 3]],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(\ Do[Print["\<beta[\>", d, "\<,\>", n, "\<]=\>", beta[d, n]\ ], 
      \ \ \ \ \ \ \ \n\ \ \ \ \ \ \ \ \ \ {n, 0, imax - 1}]\)\)], "Input"],

Cell[BoxData[
    InterpretationBox[
      \("beta["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]0
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "beta[", 3, ",", 0, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("beta["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "beta[", 3, ",", 1, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("beta["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "beta[", 3, ",", 2, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("beta["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "beta[", 3, ",", 3, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("beta["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "beta[", 3, ",", 4, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("beta["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "beta[", 3, ",", 5, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("beta["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]6
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "beta[", 3, ",", 6, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("beta["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]7
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "beta[", 3, ",", 7, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("beta["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]8
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "beta[", 3, ",", 8, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("beta["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]9
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "beta[", 3, ",", 9, "]=", 0],
      Editable->False]], "Print"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Computing the moments of the d-dimensional form", "Subsection"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\( (*\ set\ the\ values\ of\ d\ and\ nmax\ *) \nd = 3; \ nmax = \ 100; 
    \ \ \  (*\ for\ example\ *) \)\)], "Input"],

Cell[BoxData[
    \(General::"spell1" \( : \ \) 
      "Possible spelling error: new symbol name \"\!\(nmax\)\" is similar to \
existing symbol \"\!\(imax\)\"."\)], "Message"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(MemoryInUse[]\)], "Input"],

Cell[BoxData[
    \(877736\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell["dcanonicalform[d,nmax,Infinity]", "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    \({{1, 0, 2\/3, 1\/2, 19\/12, 10\/3, 85\/9, 665\/24, 40145\/432, 980\/3, 
        90335\/72, 1468775\/288, 38046085\/1728, 7212205\/72, 310665355\/648, 
        8297163875\/3456, 260394359225\/20736, 22160813675\/324, 
        12039597695125\/31104, 31396934644075\/13824, 
        10296439913584825\/746496, 2691989682507125\/31104, 
        104561691957297575\/186624, 5579122899023749075\/1492992, 
        229736958654546768425\/8957952, 4220079995530774375\/23328, 
        17604093927077850066875\/13436928, 19373263897290956778125\/1990656, 
        884858545599841962524375\/11943936, 
        862111380076449315938125\/1492992, 
        10312204670740852041036875\/2239488, 
        896755463229398888355865625\/23887872, 
        134442758605660353687974760625\/429981696, 
        2977232425872362405266894375\/1119744, 
        4959882653700805778962791651875\/214990848, 
        175545711875044049701133437090625\/859963392, 
        9498746239274496455014827910721875\/5159780352, 
        1211998134720331387371050011028125\/71663616, 
        612204351657980366956356781936465625\/3869835264, 
        15541698677803354718841299487357615625\/10319560704, 
        903079282833503423035107519244066496875\/61917364224, 
        138958248783410922687235697574932265625\/967458816, 
        133531709049312443527492383170012669403125\/92876046336, 
        1810833728622938730661174668522294775934375\/123834728448, 
        336726080737397265630934174492396677200759375\/2229025112064, 
        49055851178443100034907909945094715973578125\/30958682112, 
        1566883360525448479210408043100017726774171875\/92876046336, 
        270846078790558929688366628043561579643420421875\/1486016741376, 
        17809428565458612411504409926732289310258087515625\/8916100448256, 
        1030883437202117347652114400101650906398364609375\/46438023168, 
        3345236773902660924189564362315100213206771495328125\/13374150672384, 
        50937607421758767319715924210509606889998345012890625
          \/17832200896512, 
        3536710044691020542019725147591611883968533802517921875
          \/106993205379072, 
        5182611499339201266634339635129908142757124238175203125
          \/13374150672384, 
        369203142993640704653399041553253057479478758053527296875
          \/80244904034304, 
        1315176171226682635445145296487873840453959142410142265625
          \/23776267862016, 
        2593117466889722754326056903933498378394296420047112602265625
          \/3851755393646592, 
        5199153154860854244655167276423269833845615011470460078125
          \/626913312768, 
        199096893010618606631049118584208765259851933791879167447890625
          \/1925877696823296, 
        10043795157245690626632377285995536208164678543582700980823203125
          \/7703510787293184, 
        768779400827630554047938115577388724928968582757919970819488359375
          \/46221064723759104, 
        413277437983626289104414907791969016909119001133494775494415234375
          \/1925877696823296, 
        379093107784127341759970648439462918066839553181961410009988515625
          \/135413275557888, 
        1137757760821886664595173226828387382188912038599657850894924313046875
          \/30814043149172736, 
        9100999410537609806348569848785658875040757036982448929077394541039062\
5\/184884258895036416, 
        4790023981033399539138620062674371009763260294933312984189808478515625
          \/722204136308736, 
        2504316117552377488623205698182828317977839921702128337556578278339414\
0625\/277326388342554624, 
        4593174830063807564795170366073816328044648110264922342073933280043628\
90625\/369768517790072832, 
        1148869165343986766014338396801713905918358235914903286909424672817203\
84765625\/6655833320221310976, 
        6718641181715163104085511612080831269954777336541225742532381814652601\
4453125\/277326388342554624, 
        5713873954140354596077483424312901543946443649170397719978654490340542\
848828125\/1663958330055327744, 
        6542368170789160010111770461932171639437181601122842645259658081082024\
23279296875\/13311666640442621952, 
        5672299237202709437741249041346954641208162468410915502586182824006676\
8138281640625\/79869999842655731712, 
        1436520684752271174397415398466558567577283979131937868546498671557720\
462787890625\/138663194171277312, 
        1827462492206408141774672441151843710857164372909627904782424821247444\
3186258377734375\/119804999763983597568, 
        3620798882436572098453906710597200296780474294071612661609810332128070\
51742631533203125\/159739999685311463424, 
        3257731812363720268154399764756965149434927688548886063300200000042846\
5156436740693359375\/958439998111868780544, 
        6161365556102657732340380112931813254442793639775697590357170599273242\
3189979748095703125\/119804999763983597568, 
        2821581455792815438909416364203479454827948009884228274331955633643384\
706141314856220703125/359414999291950792704, 
        2317290164861300296743424095498621326478563302887944538860650446353325\
84763959992277666015625/1916879996223737561088, 
        6478731238040772741842099327140003631549599931339727160227909147356553\
4241362412027795400390625/34503839932027276099584, 
        1957781911237853034238600773431241146758216777654594456941338679774452\
88894619064319677734375/6655833320221310976, 
        2969153500865815048860109629589215288724142062041562128634219732044022\
78070779467205624111328125/638959998741245853696, 
        1891925577753121003792604084588099603784557544532560136980822652546611\
0118395519049654210029296875/2555839994964983414784, 
        1823217885428728806162490490482017130390042710019701181209394086010864\
522808927751454434618681640625/15335039969789900488704, 
        1230101735999278715981819686909227884780959843509299605962736106084508\
238103743068225829924267578125/638959998741245853696, 
        3614241632399728674607076315915618860458489801009454843547246755415629\
30268120432094708633995751953125/11501279977342425366528, 
        1585769125752965091874992358158835115403215616768346646548830685616288\
1630677924113948278046060498046875/30670079939579800977408, 
        1577818288374504591845386413349642345900667776217125824518603468634884\
080473651457855655488092180712890625/184020479637478805864448, 
        2060092568205295262285883836116516019399897157306575220394195527299922\
53310322801192858496130452685546875/1437659997167803170816, 
        6661387050506240894862973529872528969829788495273448823485503704470192\
98935774330987570842034443628857421875/276030719456218208796672, 
        5024116378835658194338704408278428227285836532370283128939730030067145\
918353219963251379281642166312255859375/122680319758319203909632, 
        4638701864413176503778663830551371387644470997208317967363550970515989\
442810059742654728676711342522578564453125/6624737266949237011120128, 
        3329347208583337749495295770414401400988767781597718548199293426222834\
033599416223628036270559697382336767578125/276030719456218208796672, 
        8666050207781276201295229517020351958963715229134189081780653382834340\
8748358055008094106286632060632323095703125/414046079184327313195008, 
        4847366396165414255755069621073495184862236836375963548519067956626232\
8329542768588176785027316796503580561279296875/13249474533898474022240256, 
        5120626542185195502804566540132622534852154263954554504452622875428801\
256802777861880969342325510312024432922119140625/79496847203390844133441536, 
        2364598480483083095612952863941687777132978108448922709237491990190835\
38062799311928399157882371638497230893798828125/207023039592163656597504, 
        2432281140613936940083502562192609195850314150397235953134392002219790\
582452219177450258468322790254022729553963134765625/
          119245270805086266200162304, 
        1944029949080446578822578304265599906926630779649748956726668037827511\
1082751010748800537438841118763104984717030029296875/
          52997898135593896088961024, 
        2112193876436898523109745665740111515286456333170705055221392893669944\
209573396587031875844632736592131572187447289306640625/
          317987388813563376533766144}, {0, 1, 0, 2, 2, 95\/12, 20, 595\/9, 
        665\/3, 40145\/48, 9800\/3, 993685\/72, 1468775\/24, 494599105\/1728, 
        50485435\/36, 1553326775\/216, 8297163875\/216, 4426704106825\/20736, 
        22160813675\/18, 228752356207375\/31104, 156984673220375\/3456, 
        72075079395093775\/248832, 29611886507578375\/15552, 
        2404918915017844225\/186624, 5579122899023749075\/62208, 
        5743423966363669210625\/8957952, 54861039941900066875\/11664, 
        17604093927077850066875\/497664, 135612847281036697446875\/497664, 
        25660897822395416913206875\/11943936, 
        4310556900382246579690625\/248832, 
        319678344792966413272143125\/2239488, 
        896755463229398888355865625\/746496, 
        1478870344662263890567722366875\/143327232, 
        50612951239830160889537204375\/559872, 
        173595892879528202263697707815625\/214990848, 
        175545711875044049701133437090625\/23887872, 
        351453610853156368835548632696709375\/5159780352, 
        23027964559686296360049950209534375\/35831808, 
        7958656571553744770432638165174053125\/1289945088, 
        77708493389016773594206497436788078125\/1289945088, 
        37026250596173640344439408289006726371875\/61917364224, 
        972707741483876458810649883024525859375\/161243136, 
        5741863489120435071682172476310544784334375\/92876046336, 
        19919171014852326037272921353745242535278125\/30958682112, 
        1683630403686986328154670872461983386003796875\/247669456896, 
        1128284577104191300802881928737178467392296875\/15479341056, 
        73643517944696078522889178025700833158386078125\/92876046336, 
        270846078790558929688366628043561579643420421875\/30958682112, 
        872661999707472008163716086409882176202646288265625\/8916100448256, 
        25772085930052933691302860002541272659959115234375\/23219011584, 
        56869025156345235711222594159356703624515115420578125\/4458050224128, 
        662188896482863975156307014736624889569978485167578125
          \/4458050224128, 
        187445632368624088727045432822355429850332291533449859375
          \/106993205379072, 
        5182611499339201266634339635129908142757124238175203125
          \/247669456896, 
        20306172864650238755936947285428918161371331692944001328125
          \/80244904034304, 
        9206233198586778448116017075415116883177713996870995859375
          \/2972033482752, 
        49269231870904732332195081174736469189491631980895139443046875
          \/1283918464548864, 
        150775441490964773094999851016274825181522835332643342265625
          \/313456656384, 
        11746716687626497791231897996468317150331264093720870879425546875
          \/1925877696823296, 
        50218975786228453133161886429977681040823392717913504904116015625
          \/641959232274432, 
        46895543450485463796924225050220712220667083548233118219988789921875
          \/46221064723759104, 
        12811600577492414962236862141551039524182689035138338040326872265625
          \/962938848411648, 
        2653651754488891392319794539076240426467876872273729870069919609375
          \/15045919506432, 
        1137757760821886664595173226828387382188912038599657850894924313046875
          \/481469424205824, 
        5915649616849446374126570401710678268776492074038591803900306451675390\
625\/184884258895036416, 
        5269026379136739493052482068941808110739586324426644282608789326367187\
5\/120367356051456, 
        1677891798760092917377547817782494973045152747540425986162907446487407\
421875\/277326388342554624, 
        7808397211108472860151789622325487757675901787450367981525686576074169\
140625\/92442129447518208, 
        2642399080291169561832978312643941983612223942604277559891676747479568\
849609375\/2218611106740436992, 
        2351524413600307086429929064228290944484172067789429009886333635128410\
505859375\/138663194171277312, 
        4056850507439651763215013231262160096201974990910982381184844688141785\
42266796875\/1663958330055327744, 
        6542368170789160010111770461932171639437181601122842645259658081082024\
23279296875\/184884258895036416, 
        4140778443157977889551111800183276888081958601939968316887913461524874\
074094559765625\/79869999842655731712, 
        5315126533583403345270436974326266700035950722788170113622045084763565\
7123151953125\/69331597085638656, 
        4568656230516020354436681102879609277142910932274069761956062053118610\
79656459443359375\/39934999921327865856, 
        6879517876629486987062422750134680563882901158736064057058639631043333\
983109999130859375\/39934999921327865856, 
        2508453495520064606478887818862863165064894320182642268741154000032991\
817045629033388671875/958439998111868780544, 
        8009775222933455052042494146811357230775631731708406867464321779055215\
01469736725244140625\/19967499960663932928, 
        2229049350076324196738438927720748769314078927808540336722244950578273\
91785163873641435546875/359414999291950792704, 
        1158645082430650148371712047749310663239281651443972269430325223176662\
923819799961388330078125/119804999763983597568, 
        6478731238040772741842099327140003631549599931339727160227909147356553\
4241362412027795400390625/425973332494163902464, 
        8026905836075197440378263171068088701708688788383837273459488587075256\
844679381637106787109375/3327916660110655488, 
        2464397405718626490553890992559048689641037911494496566766402377596538\
9079874695778066801240234375/638959998741245853696, 
        1324347904427184702654822859211669722649190281172792095886575856782627\
70828768633347579470205078125/212986666247081951232, 
        1549735202614419485238116916909714560831536303516746004027984973109234\
84438758858873626942587939453125/15335039969789900488704, 
        5289437464796898478721824653709679904558127327089988305639765256163385\
4238460951933710686743505859375/319479999370622926848, 
        1048130073395921315636052131615529469532962042292741904628701559070532\
4977775492530746550385876806640625/3833759992447475122176, 
        1744346038328261601062491593974718626943537178445181311203713754177916\
97937457165253431058506665478515625/3833759992447475122176, 
        1404258276653309086742393907881181687851594320833241983821557087085046\
83162154979749153338440204083447265625/184020479637478805864448, 
        1030046284102647631142941918058258009699948578653287610197097763649961\
266551614005964292480652263427734375/79869999842655731712, 
        6061862215960679214325305912184001362545107530698838429371808371067875\
6203155464119868946625134370226025390625/276030719456218208796672, 
        1155546767132201384697902013904038492275742402445165119656137906915443\
56122124059154781723477769825181884765625/30670079939579800977408, 
        1437997577968084716171385787470925130169786009134578569882700800859956\
72727111852022296588978051618199935498046875/2208245755649745670373376, 
        1564793188034168742262789012094768658464720857350927717653667910324731\
99579172562510517704716305776969828076171875/138015359728109104398336, 
        8232747697392212391230468041169334361015529467677479627691620713692623\
831094015225768940097230045760070694091796875/414046079184327313195008, 
        4847366396165414255755069621073495184862236836375963548519067956626232\
8329542768588176785027316796503580561279296875/138015359728109104398336, 
        4967007745919639637720429543928643858806589636035917869319044189165937\
21909869452602454026205574500266369993445556640625/
          79496847203390844133441536, 
        1158653255436710716850346903331427010795159273139972127526371075193509\
3365077166284491558736236210286364313796142578125/103511519796081828298752, 
        2675509254675330634091852818411870115435345565436959548447831202441769\
6406974410951952843151550692794250025093594482421875/
          13249474533898474022240256, 
        4860074872701116447056445760663999767316576949124372391816670094568777\
77068775268720013435971027969077624617925750732421875/
          13249474533898474022240256}, {0, 0, 1, 0, 4, 5, 95\/4, 70, 2380\/9, 
        1995\/2, 200725\/48, 53900\/3, 993685\/12, 19094075\/48, 
        3462193735\/1728, 252427175\/24, 1553326775\/27, 141051785875\/432, 
        4426704106825\/2304, 421055459825\/36, 1143761781036875\/15552, 
        1098892712542625\/2304, 792825873346031525\/248832, 
        681073389674302625\/31104, 2404918915017844225\/15552, 
        139478072475593726875\/124416, 74664511562727699738125\/8957952, 
        54861039941900066875\/864, 123228657489544950468125\/248832, 
        3932772571150064225959375\/995328, 
        128304489111977084566034375\/3981312, 
        133627263911849643970409375\/497664, 
        319678344792966413272143125\/139968, 
        9864310095523387771914521875\/497664, 
        25140795859258486139651280236875\/143327232, 
        1771453293394055631133802153125\/1119744, 
        173595892879528202263697707815625\/11943936, 
        6495191339376629838941937172353125\/47775744, 
        6677618606209971007875424021237478125\/5159780352, 
        299363539275921852680649352723946875\/23887872, 
        39793282857768723852163190825870265625\/322486272, 
        3186048228949687717362466394908311203125\/2579890176, 
        259183754173215482411075858023047084603125\/20639121408, 
        41826432883806687728857944970054611953125\/322486272, 
        63160498380324785788503897239415992627678125\/46438023168, 
        99595855074261630186364606768726212676390625\/6879707136, 
        38723499284800685547557430066625617878087328125\/247669456896, 
        53029375123896991137735450650647387967437953125\/30958682112, 
        73643517944696078522889178025700833158386078125\/3869835264, 
        13271457860737387554729964774134517402527600671875\/61917364224, 
        21816549992686800204092902160247054405066157206640625\/8916100448256, 
        438125460810899872752148620043201635219304958984375\/15479341056, 
        739297327032488064245893724071637147118696500467515625
          \/2229025112064, 
        35096011513591790683284271781041119147208859713881640625
          \/8916100448256, 
        187445632368624088727045432822355429850332291533449859375
          \/3962711310336, 
        285043632463656069664888679932144947851641833099636171875
          \/495338913792, 
        142143210052551671291558630998002427129599321850608009296875
          \/20061226008576, 
        174918430773148790514204324432887220780376565940548921328125
          \/1981355655168, 
        1428807724256237237633657354067357606495257327445959043848359375
          \/1283918464548864, 
        8895751047966921612604991209960214685709847284625957193671875
          \/626913312768, 
        58733583438132488956159489982341585751656320468604354397127734375
          \/320979616137216, 
        3063357522959935641122875072228638543490226955792723799151076953125
          \/1283918464548864, 
        1453761846965049377704650976556842078840679589995226664819652487578125
          \/46221064723759104, 
        89681204042446904735658034990857276669278823245968366282288105859375
          \/213986410758144, 
        2653651754488891392319794539076240426467876872273729870069919609375
          \/470184984576, 
        7395425445342263319868625974384517984227928250897776030817008034804687\
5\/962938848411648, 
        6507214578534391011539227441881746095654141281442450984290337096842929\
6875\/61628086298345472, 
        3530247674021615460345162986191011434195522837365851669347888848666015\
625\/240734712102912, 
        2852416057892157959541831290230241454176759670818724176476942659028592\
6171875\/138663194171277312, 
        1795931358554948757834911613134862184265457411113584635750907912497058\
90234375\/61628086298345472, 
        9248396781019093466415424094253796942642783799114971459620868616178490\
9736328125\/2218611106740436992, 
        1669582333656218031365249635602086570583762168130494597019296880941171\
45916015625\/277326388342554624, 
        4056850507439651763215013231262160096201974990910982381184844688141785\
42266796875\/46221064723759104, 
        4775928764676086807381592437210485296789142568819675131039550399189877\
6899388671875\/369768517790072832, 
        1532088023968451819133911366067812448590324682717788277248527980764203\
40741498711328125\/79869999842655731712, 
        1328781633395850836317609243581566675008987680697042528405511271190891\
428078798828125\/46221064723759104, 
        8680446837980438673429694095471257626571530771320732547716517900925360\
513472729423828125\/19967499960663932928, 
        5297228765004704980038065517603704034189833892226769323935152515903367\
16699469933076171875\/79869999842655731712, 
        3260989544176083988422554164521722114584362616237434949363500200042889\
3621593177434052734375/319479999370622926848, 
        6327722426117429491113570375980972212312749068049641425296814205453619\
8616109201294287109375/39934999921327865856, 
        1114524675038162098369219463860374384657039463904270168361122475289136\
958925819368207177734375/44926874911493849088, 
        1158645082430650148371712047749310663239281651443972269430325223176662\
923819799961388330078125/2958148142320582656, 
        2656279807596716824155260724127401488935335971849288135693442750416186\
903895858893139611416015625/425973332494163902464, 
        6662331843942413875513958431986513622418211694358584936971375527272463\
18108388675879863330078125/6655833320221310976, 
        1725078184003038543387723694791334082748726538046147596736481664317577\
23559122870446467608681640625/106493333123540975616, 
        1125695718763106997256599430329919264251811738996873281503589478265233\
5520445333834544254967431640625/425973332494163902464, 
        6663861371242003786523902742711772611575606105122007817320335384369709\
830866630931565958531281396484375/15335039969789900488704, 
        1533936864791100558829329149575807172321856924856096608635531924287381\
772915367606077609915561669921875/212986666247081951232, 
        1152943080735513447199657344777082416486258246522016095091571714977585\
74755530417838212054244644873046875/958439998111868780544, 
        1552467974112152824945617518637499577979748088816211366971305241218346\
1116433687707555364207093227587890625/7667519984894950244352, 
        7021291383266545433711969539405908439257971604166209919107785435425234\
15810774898745766692201020417236328125/20446719959719867318272, 
        9373421185334093443400771454330147888269532065744917252793589649214647\
5256196874542750615739355971923828125/159739999685311463424, 
        1394228309670956219294820359802320313385374732060732838755515925345611\
392672575674756985772378090515198583984375/138015359728109104398336, 
        3582194978109824292563496243102519326054801447580011870934027511437875\
039785845833798233427810864580638427734375/20446719959719867318272, 
        6758588616449998166005513201113348111797994242932519278448693764041796\
618174257045047939681968426055396968408203125/2208245755649745670373376, 
        1486553528632460305149649561490030225541484814483381331770984514808495\
3960021393438499181948049048812133667236328125/276030719456218208796672, 
        8232747697392212391230468041169334361015529467677479627691620713692623\
831094015225768940097230045760070694091796875/8625959983006819024896, 
        4701945404280451828082417532441290329316369731284684642063495917927445\
847965648553053148147649729260847314444091796875/276030719456218208796672, 
        2433833795500623422483010476525035490815228921657599755966331652691309\
2373583603177520247284073150513052129678832275390625/
          79496847203390844133441536, 
        1274518580980381788535381593664569711874675200453969340279008182712860\
27015848829129407146098598313150007451757568359375/23002559954684850733056, 
        6688773136688326585229632046029675288588363913592398871119578006104424\
10174360273798821078788767319856250627339862060546875/
          6624737266949237011120128}}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(MemoryInUse[]\)], "Input"],

Cell[BoxData[
    \(1676496\)], "Output"]
}, Open  ]]
}, Closed]]
}, Closed]]
},
FrontEndVersion->"Macintosh 3.0",
ScreenRectangle->{{0, 832}, {0, 604}},
WindowSize->{764, 580},
WindowMargins->{{4, Automatic}, {Automatic, 1}},
MacintoshSystemPageSetup->"\<\
00<0001804P000000`d26_oQon@3:`8g0dL5N`?P0080001804P000000]P2:001
0000I00000400`<30?l00BL?00400@0000000000000006P801T1T00000000000
00000000004000000000000000000000\>"
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{
Cell[1709, 49, 1291, 21, 612, "Subsection"],

Cell[CellGroupData[{
Cell[3025, 74, 143, 4, 68, "Section"],

Cell[CellGroupData[{
Cell[3193, 82, 108, 3, 44, "Subsection"],
Cell[3304, 87, 62, 1, 27, "Input"]
}, Closed]],

Cell[CellGroupData[{
Cell[3403, 93, 123, 4, 28, "Subsection"],
Cell[3529, 99, 88, 1, 27, "Input"],
Cell[3620, 102, 142, 2, 43, "Input"],

Cell[CellGroupData[{
Cell[3787, 108, 361, 6, 75, "Input"],
Cell[4151, 116, 326, 7, 38, "Print"],
Cell[4480, 125, 300, 6, 22, "Print"],
Cell[4783, 133, 326, 7, 38, "Print"],
Cell[5112, 142, 300, 6, 22, "Print"],
Cell[5415, 150, 328, 7, 38, "Print"],
Cell[5746, 159, 302, 6, 22, "Print"],
Cell[6051, 167, 302, 6, 22, "Print"],
Cell[6356, 175, 302, 6, 22, "Print"],
Cell[6661, 183, 37, 1, 22, "Print"],
Cell[6701, 186, 326, 7, 38, "Print"],
Cell[7030, 195, 326, 7, 38, "Print"],
Cell[7359, 204, 300, 6, 22, "Print"],
Cell[7662, 212, 300, 6, 22, "Print"],
Cell[7965, 220, 328, 7, 38, "Print"],
Cell[8296, 229, 328, 7, 38, "Print"],
Cell[8627, 238, 302, 6, 22, "Print"],
Cell[8932, 246, 302, 6, 22, "Print"],
Cell[9237, 254, 328, 7, 38, "Print"],
Cell[9568, 263, 37, 1, 22, "Print"],
Cell[9608, 266, 326, 7, 38, "Print"],
Cell[9937, 275, 326, 7, 38, "Print"],
Cell[10266, 284, 300, 6, 22, "Print"],
Cell[10569, 292, 326, 7, 38, "Print"],
Cell[10898, 301, 328, 7, 38, "Print"],
Cell[11229, 310, 300, 6, 22, "Print"],
Cell[11532, 318, 328, 7, 38, "Print"],
Cell[11863, 327, 328, 7, 38, "Print"],
Cell[12194, 336, 300, 6, 22, "Print"],
Cell[12497, 344, 330, 7, 38, "Print"],
Cell[12830, 353, 37, 1, 22, "Print"]
}, Open  ]],

Cell[CellGroupData[{
Cell[12904, 359, 161, 2, 43, "Input"],
Cell[13068, 363, 243, 5, 22, "Print"],
Cell[13314, 370, 243, 5, 22, "Print"],
Cell[13560, 377, 243, 5, 22, "Print"],
Cell[13806, 384, 243, 5, 22, "Print"],
Cell[14052, 391, 243, 5, 22, "Print"],
Cell[14298, 398, 243, 5, 22, "Print"],
Cell[14544, 405, 243, 5, 22, "Print"],
Cell[14790, 412, 243, 5, 22, "Print"],
Cell[15036, 419, 243, 5, 22, "Print"],
Cell[15282, 426, 243, 5, 22, "Print"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{
Cell[15574, 437, 69, 0, 28, "Subsection"],

Cell[CellGroupData[{
Cell[15668, 441, 139, 2, 43, "Input"],
Cell[15810, 445, 175, 3, 37, "Message"]
}, Open  ]],

Cell[CellGroupData[{
Cell[16022, 453, 46, 1, 27, "Input"],
Cell[16071, 456, 40, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[16148, 462, 74, 1, 27, "Input"],
Cell[16225, 465, 24293, 395, 6741, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[40555, 865, 46, 1, 27, "Input"],
Cell[40604, 868, 41, 1, 26, "Output"]
}, Open  ]]
}, Closed]]
}, Closed]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

