(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 3.0,
MathReader 3.0, or any compatible application. The data for the notebook 
starts with the line of stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     37975,       1067]*)
(*NotebookOutlinePosition[     38813,       1094]*)
(*  CellTagsIndexPosition[     38769,       1090]*)
(*WindowFrame->Normal*)



Notebook[{
Cell[TextData[{
  " :Author:  Z\[EAcute]lia da ROCHA \n\n:Address: \n            Departamento \
de Matem\[AAcute]tica Aplicada da\n            Faculdade de Ci\[EHat]ncias do \
Porto\n            Rua das Taipas, 135\n            4050 Porto\n            \
Portugal\n  \n            Tel: ++351 02 2080313\n            Fax: ++351 02 \
2004109\n            Email: mrdioh@fc.up.pt\n\n :Summary:\n    The ",
  StyleBox["testshfv51",
    FontSize->18],
  " notebook contains the results produced by the package\n    shfv.m \
corresponding to the ",
  StyleBox["example 5.1",
    FontSize->18],
  " of the first paper cited bellow.    \n\n :Date: July 1999. \n\n:Available \
at http://netlib.bell-labs.com/ in the numeralgo library in netlib:     \n\n \
:Notebook Version: 1.0 \n\n :Mathematica Version: 3.0   \n \n :Keywords: \
Shohat-Favard's method, regular forms, d-dimensional canonical forms, \n \
d-orthogonal polynomial sequences.\n\n :Sources:\n \n - Z\[EAcute]lia da \
Rocha, Shohat-Favard and Chebyshev's methods in d-orthogonality, \n Numerical \
Algorithms, 20 (1999) 139 - 164.\n   \n - About the example treated here see \
p.286 of:\n \n   K. Douak, The relation of the d-orthogonal polynomials to \
the Appell polynomials,  \n   J. Comput. Appl. Math., 70 (1996) 279-295."
}], "Subsection"],

Cell[CellGroupData[{

Cell["\<\
Computing the moments of the d-dimensional canonical form \
performing formal computations\
\>", "Section",
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell["\<\
Loading the package shfv.m, the package datashfv51.m is \
automatically loaded\
\>", "Subsection"],

Cell[BoxData[
    \(\(<< shohatfavard`shfv`\ ; \)\)], "Input"]
}, Closed]],

Cell[CellGroupData[{

Cell["\<\
The recurrence coefficients are given in the package datashfv51.m\
\
\>", "Subsection",
  AspectRatioFixed->True],

Cell[BoxData[
    \( (*\ showing\ the\ recurrence\ coefficients\ given\ *) \)], "Input"],

Cell[BoxData[
    \(\( (*\ set\ the\ values\ of\ d\ and\ imax\ *) \nd = 3; imax = \ 10; 
    \ \ \ \ \ \  (*\ for\ example\ *) \)\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(Do[\ 
      Do[Print["\<gamma[\>", d, "\<,\>", r, "\<,\>", n, "\<]=\>", \n
          \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \
\ gamma[d, r, n]\ ], \ \ \ \ \ \ \ \n
        \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ {n, 1, imax + r - d + 1}]; 
      Print["\<  \>"], \ \n\ \ \ \ \ \ {r, 0, d - 1}]\ \)\)], "Input"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]0
        \[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]"]="\[InvisibleSpace]1\/4\),
      SequenceForm[ "gamma[", 3, ",", 0, ",", 1, "]=", 
        Rational[ 1, 4]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]0
        \[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]"]="\[InvisibleSpace]1\),
      SequenceForm[ "gamma[", 3, ",", 0, ",", 2, "]=", 1],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]0
        \[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]"]="\[InvisibleSpace]5\/2\),
      SequenceForm[ "gamma[", 3, ",", 0, ",", 3, "]=", 
        Rational[ 5, 2]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]0
        \[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]"]="\[InvisibleSpace]5\),
      SequenceForm[ "gamma[", 3, ",", 0, ",", 4, "]=", 5],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]0
        \[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]"]="\[InvisibleSpace]35\/4\),
      SequenceForm[ "gamma[", 3, ",", 0, ",", 5, "]=", 
        Rational[ 35, 4]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]0
        \[InvisibleSpace]","\[InvisibleSpace]6
        \[InvisibleSpace]"]="\[InvisibleSpace]14\),
      SequenceForm[ "gamma[", 3, ",", 0, ",", 6, "]=", 14],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]0
        \[InvisibleSpace]","\[InvisibleSpace]7
        \[InvisibleSpace]"]="\[InvisibleSpace]21\),
      SequenceForm[ "gamma[", 3, ",", 0, ",", 7, "]=", 21],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]0
        \[InvisibleSpace]","\[InvisibleSpace]8
        \[InvisibleSpace]"]="\[InvisibleSpace]30\),
      SequenceForm[ "gamma[", 3, ",", 0, ",", 8, "]=", 30],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]"]="\[InvisibleSpace]shohatfavard`datashfv51`Private`\
g11\),
      SequenceForm[ 
      "gamma[", 3, ",", 1, ",", 1, "]=", shohatfavard`datashfv51`Private`g11],
      
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]"]="\[InvisibleSpace]\(3\ 
          shohatfavard`datashfv51`Private`g11\)\),
      SequenceForm[ "gamma[", 3, ",", 1, ",", 2, "]=", 
        Times[ 3, shohatfavard`datashfv51`Private`g11]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]"]="\[InvisibleSpace]\(6\ 
          shohatfavard`datashfv51`Private`g11\)\),
      SequenceForm[ "gamma[", 3, ",", 1, ",", 3, "]=", 
        Times[ 6, shohatfavard`datashfv51`Private`g11]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]"]="\[InvisibleSpace]\(10\ 
          shohatfavard`datashfv51`Private`g11\)\),
      SequenceForm[ "gamma[", 3, ",", 1, ",", 4, "]=", 
        Times[ 10, shohatfavard`datashfv51`Private`g11]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]"]="\[InvisibleSpace]\(15\ 
          shohatfavard`datashfv51`Private`g11\)\),
      SequenceForm[ "gamma[", 3, ",", 1, ",", 5, "]=", 
        Times[ 15, shohatfavard`datashfv51`Private`g11]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]6
        \[InvisibleSpace]"]="\[InvisibleSpace]\(21\ 
          shohatfavard`datashfv51`Private`g11\)\),
      SequenceForm[ "gamma[", 3, ",", 1, ",", 6, "]=", 
        Times[ 21, shohatfavard`datashfv51`Private`g11]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]7
        \[InvisibleSpace]"]="\[InvisibleSpace]\(28\ 
          shohatfavard`datashfv51`Private`g11\)\),
      SequenceForm[ "gamma[", 3, ",", 1, ",", 7, "]=", 
        Times[ 28, shohatfavard`datashfv51`Private`g11]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]8
        \[InvisibleSpace]"]="\[InvisibleSpace]\(36\ 
          shohatfavard`datashfv51`Private`g11\)\),
      SequenceForm[ "gamma[", 3, ",", 1, ",", 8, "]=", 
        Times[ 36, shohatfavard`datashfv51`Private`g11]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]9
        \[InvisibleSpace]"]="\[InvisibleSpace]\(45\ 
          shohatfavard`datashfv51`Private`g11\)\),
      SequenceForm[ "gamma[", 3, ",", 1, ",", 9, "]=", 
        Times[ 45, shohatfavard`datashfv51`Private`g11]],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]"]="\[InvisibleSpace]shohatfavard`datashfv51`Private`\
g12\),
      SequenceForm[ 
      "gamma[", 3, ",", 2, ",", 1, "]=", shohatfavard`datashfv51`Private`g12],
      
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]"]="\[InvisibleSpace]\(2\ 
          shohatfavard`datashfv51`Private`g12\)\),
      SequenceForm[ "gamma[", 3, ",", 2, ",", 2, "]=", 
        Times[ 2, shohatfavard`datashfv51`Private`g12]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]"]="\[InvisibleSpace]\(3\ 
          shohatfavard`datashfv51`Private`g12\)\),
      SequenceForm[ "gamma[", 3, ",", 2, ",", 3, "]=", 
        Times[ 3, shohatfavard`datashfv51`Private`g12]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]"]="\[InvisibleSpace]\(4\ 
          shohatfavard`datashfv51`Private`g12\)\),
      SequenceForm[ "gamma[", 3, ",", 2, ",", 4, "]=", 
        Times[ 4, shohatfavard`datashfv51`Private`g12]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]"]="\[InvisibleSpace]\(5\ 
          shohatfavard`datashfv51`Private`g12\)\),
      SequenceForm[ "gamma[", 3, ",", 2, ",", 5, "]=", 
        Times[ 5, shohatfavard`datashfv51`Private`g12]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]6
        \[InvisibleSpace]"]="\[InvisibleSpace]\(6\ 
          shohatfavard`datashfv51`Private`g12\)\),
      SequenceForm[ "gamma[", 3, ",", 2, ",", 6, "]=", 
        Times[ 6, shohatfavard`datashfv51`Private`g12]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]7
        \[InvisibleSpace]"]="\[InvisibleSpace]\(7\ 
          shohatfavard`datashfv51`Private`g12\)\),
      SequenceForm[ "gamma[", 3, ",", 2, ",", 7, "]=", 
        Times[ 7, shohatfavard`datashfv51`Private`g12]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]8
        \[InvisibleSpace]"]="\[InvisibleSpace]\(8\ 
          shohatfavard`datashfv51`Private`g12\)\),
      SequenceForm[ "gamma[", 3, ",", 2, ",", 8, "]=", 
        Times[ 8, shohatfavard`datashfv51`Private`g12]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]9
        \[InvisibleSpace]"]="\[InvisibleSpace]\(9\ 
          shohatfavard`datashfv51`Private`g12\)\),
      SequenceForm[ "gamma[", 3, ",", 2, ",", 9, "]=", 
        Times[ 9, shohatfavard`datashfv51`Private`g12]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]10
        \[InvisibleSpace]"]="\[InvisibleSpace]\(10\ 
          shohatfavard`datashfv51`Private`g12\)\),
      SequenceForm[ "gamma[", 3, ",", 2, ",", 10, "]=", 
        Times[ 10, shohatfavard`datashfv51`Private`g12]],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(\ Do[Print["\<beta[\>", d, "\<,\>", n, "\<]=\>", beta[d, n]\ ], 
      \ \ \ \ \ \ \ \n\ \ \ \ \ \ \ \ \ \ {n, 0, imax - 1}]\)\)], "Input"],

Cell[BoxData[
    InterpretationBox[
      \("beta["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]0
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "beta[", 3, ",", 0, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("beta["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "beta[", 3, ",", 1, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("beta["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "beta[", 3, ",", 2, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("beta["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "beta[", 3, ",", 3, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("beta["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "beta[", 3, ",", 4, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("beta["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "beta[", 3, ",", 5, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("beta["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]6
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "beta[", 3, ",", 6, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("beta["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]7
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "beta[", 3, ",", 7, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("beta["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]8
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "beta[", 3, ",", 8, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("beta["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]9
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "beta[", 3, ",", 9, "]=", 0],
      Editable->False]], "Print"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Computing the moments of the d-dimensional form", "Subsection"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\( (*\ set\ the\ values\ of\ d\ and\ nmax\ *) \nd = 3; \ nmax = \ 10; 
    \ \ \  (*\ for\ example\ *) \)\)], "Input"],

Cell[BoxData[
    \(General::"spell1" \( : \ \) 
      "Possible spelling error: new symbol name \"\!\(nmax\)\" is similar to \
existing symbol \"\!\(imax\)\"."\)], "Message"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(MemoryInUse[]\)], "Input"],

Cell[BoxData[
    \(877424\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Timing[printdcanform[d,nmax,Infinity,$MachinePrecision,False]]\
\>",
   "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    \("   "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]0
        \[InvisibleSpace]"]="\[InvisibleSpace]1\),
      SequenceForm[ "form[", 3, ",", 1, ",", 0, "]=", 1],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 3, ",", 1, ",", 1, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]"]="\[InvisibleSpace]shohatfavard`datashfv51`Private`\
g12\),
      SequenceForm[ 
      "form[", 3, ",", 1, ",", 2, "]=", shohatfavard`datashfv51`Private`g12],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]"]="\[InvisibleSpace]shohatfavard`datashfv51`Private`\
g11\),
      SequenceForm[ 
      "form[", 3, ",", 1, ",", 3, "]=", shohatfavard`datashfv51`Private`g11],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]"]="\[InvisibleSpace]\(1\/4 + 
          3\ shohatfavard`datashfv51`Private`g12\^2\)\),
      SequenceForm[ "form[", 3, ",", 1, ",", 4, "]=", 
        Plus[ 
          Rational[ 1, 4], 
          Times[ 3, 
            Power[ shohatfavard`datashfv51`Private`g12, 2]]]],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]"]="\[InvisibleSpace]\(10\ 
          shohatfavard`datashfv51`Private`g11\ 
          shohatfavard`datashfv51`Private`g12\)\),
      SequenceForm[ "form[", 3, ",", 1, ",", 5, "]=", 
        Times[ 
        10, shohatfavard`datashfv51`Private`g11, 
          shohatfavard`datashfv51`Private`g12]],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]6
        \[InvisibleSpace]"]="\[InvisibleSpace]\(10\ 
            shohatfavard`datashfv51`Private`g11\^2 + 
          15\/4\ \((
              shohatfavard`datashfv51`Private`g12 + 
                4\ shohatfavard`datashfv51`Private`g12\^3)\)\)\),
      SequenceForm[ "form[", 3, ",", 1, ",", 6, "]=", 
        Plus[ 
          Times[ 10, 
            Power[ shohatfavard`datashfv51`Private`g11, 2]], 
          Times[ 
            Rational[ 15, 4], 
            Plus[ shohatfavard`datashfv51`Private`g12, 
              Times[ 4, 
                Power[ shohatfavard`datashfv51`Private`g12, 3]]]]]],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]7
        \[InvisibleSpace]"]="\[InvisibleSpace]\(35\/4\ 
          \((shohatfavard`datashfv51`Private`g11 + 
              12\ shohatfavard`datashfv51`Private`g11\ 
                shohatfavard`datashfv51`Private`g12\^2)\)\)\),
      SequenceForm[ "form[", 3, ",", 1, ",", 7, "]=", 
        Times[ 
          Rational[ 35, 4], 
          Plus[ shohatfavard`datashfv51`Private`g11, 
            Times[ 12, shohatfavard`datashfv51`Private`g11, 
              Power[ shohatfavard`datashfv51`Private`g12, 2]]]]],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]8
        \[InvisibleSpace]"]="\[InvisibleSpace]\(35\/16\ 
          \((1 + 128\ shohatfavard`datashfv51`Private`g11\^2\ 
                shohatfavard`datashfv51`Private`g12 + 
              24\ shohatfavard`datashfv51`Private`g12\^2 + 
              48\ shohatfavard`datashfv51`Private`g12\^4)\)\)\),
      SequenceForm[ "form[", 3, ",", 1, ",", 8, "]=", 
        Times[ 
          Rational[ 35, 16], 
          Plus[ 1, 
            Times[ 128, 
              Power[ shohatfavard`datashfv51`Private`g11, 2], 
              shohatfavard`datashfv51`Private`g12], 
            Times[ 24, 
              Power[ shohatfavard`datashfv51`Private`g12, 2]], 
            Times[ 48, 
              Power[ shohatfavard`datashfv51`Private`g12, 4]]]]],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]9
        \[InvisibleSpace]"]="\[InvisibleSpace]\(35\ 
          shohatfavard`datashfv51`Private`g11\ \((
          8\ shohatfavard`datashfv51`Private`g11\^2 + 
            9\ \((shohatfavard`datashfv51`Private`g12 + 
                  4\ shohatfavard`datashfv51`Private`g12\^3)\))\)\)\),
      SequenceForm[ "form[", 3, ",", 1, ",", 9, "]=", 
        Times[ 35, shohatfavard`datashfv51`Private`g11, 
          Plus[ 
            Times[ 8, 
              Power[ shohatfavard`datashfv51`Private`g11, 2]], 
            Times[ 9, 
              Plus[ shohatfavard`datashfv51`Private`g12, 
                Times[ 4, 
                  Power[ shohatfavard`datashfv51`Private`g12, 3]]]]]]],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]10
        \[InvisibleSpace]"]="\[InvisibleSpace]\(105\/16\ 
          \((80\ shohatfavard`datashfv51`Private`g11\^2\ \((
                1 + 12\ shohatfavard`datashfv51`Private`g12\^2)\) + 
              3\ shohatfavard`datashfv51`Private`g12\ \((
                5 + 40\ shohatfavard`datashfv51`Private`g12\^2 + 
                  48\ shohatfavard`datashfv51`Private`g12\^4)\))\)\)\),
      SequenceForm[ "form[", 3, ",", 1, ",", 10, "]=", 
        Times[ 
          Rational[ 105, 16], 
          Plus[ 
            Times[ 80, 
              Power[ shohatfavard`datashfv51`Private`g11, 2], 
              Plus[ 1, 
                Times[ 12, 
                  Power[ shohatfavard`datashfv51`Private`g12, 2]]]], 
            Times[ 3, shohatfavard`datashfv51`Private`g12, 
              Plus[ 5, 
                Times[ 40, 
                  Power[ shohatfavard`datashfv51`Private`g12, 2]], 
                Times[ 48, 
                  Power[ shohatfavard`datashfv51`Private`g12, 4]]]]]]],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    \("   "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]0
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 3, ",", 2, ",", 0, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]"]="\[InvisibleSpace]1\),
      SequenceForm[ "form[", 3, ",", 2, ",", 1, "]=", 1],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 3, ",", 2, ",", 2, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]"]="\[InvisibleSpace]\(3\ 
          shohatfavard`datashfv51`Private`g12\)\),
      SequenceForm[ "form[", 3, ",", 2, ",", 3, "]=", 
        Times[ 3, shohatfavard`datashfv51`Private`g12]],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]"]="\[InvisibleSpace]\(4\ 
          shohatfavard`datashfv51`Private`g11\)\),
      SequenceForm[ "form[", 3, ",", 2, ",", 4, "]=", 
        Times[ 4, shohatfavard`datashfv51`Private`g11]],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]"]="\[InvisibleSpace]\(5\/4 + 
          15\ shohatfavard`datashfv51`Private`g12\^2\)\),
      SequenceForm[ "form[", 3, ",", 2, ",", 5, "]=", 
        Plus[ 
          Rational[ 5, 4], 
          Times[ 15, 
            Power[ shohatfavard`datashfv51`Private`g12, 2]]]],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]6
        \[InvisibleSpace]"]="\[InvisibleSpace]\(60\ 
          shohatfavard`datashfv51`Private`g11\ 
          shohatfavard`datashfv51`Private`g12\)\),
      SequenceForm[ "form[", 3, ",", 2, ",", 6, "]=", 
        Times[ 
        60, shohatfavard`datashfv51`Private`g11, 
          shohatfavard`datashfv51`Private`g12]],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]7
        \[InvisibleSpace]"]="\[InvisibleSpace]\(35\/4\ 
          \((8\ shohatfavard`datashfv51`Private`g11\^2 + 
              3\ \((shohatfavard`datashfv51`Private`g12 + 
                    4\ shohatfavard`datashfv51`Private`g12\^3)\))\)\)\),
      SequenceForm[ "form[", 3, ",", 2, ",", 7, "]=", 
        Times[ 
          Rational[ 35, 4], 
          Plus[ 
            Times[ 8, 
              Power[ shohatfavard`datashfv51`Private`g11, 2]], 
            Times[ 3, 
              Plus[ shohatfavard`datashfv51`Private`g12, 
                Times[ 4, 
                  Power[ shohatfavard`datashfv51`Private`g12, 3]]]]]]],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]8
        \[InvisibleSpace]"]="\[InvisibleSpace]\(70\ 
          \((shohatfavard`datashfv51`Private`g11 + 
              12\ shohatfavard`datashfv51`Private`g11\ 
                shohatfavard`datashfv51`Private`g12\^2)\)\)\),
      SequenceForm[ "form[", 3, ",", 2, ",", 8, "]=", 
        Times[ 70, 
          Plus[ shohatfavard`datashfv51`Private`g11, 
            Times[ 12, shohatfavard`datashfv51`Private`g11, 
              Power[ shohatfavard`datashfv51`Private`g12, 2]]]]],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]9
        \[InvisibleSpace]"]="\[InvisibleSpace]\(315\/16\ 
          \((1 + 128\ shohatfavard`datashfv51`Private`g11\^2\ 
                shohatfavard`datashfv51`Private`g12 + 
              24\ shohatfavard`datashfv51`Private`g12\^2 + 
              48\ shohatfavard`datashfv51`Private`g12\^4)\)\)\),
      SequenceForm[ "form[", 3, ",", 2, ",", 9, "]=", 
        Times[ 
          Rational[ 315, 16], 
          Plus[ 1, 
            Times[ 128, 
              Power[ shohatfavard`datashfv51`Private`g11, 2], 
              shohatfavard`datashfv51`Private`g12], 
            Times[ 24, 
              Power[ shohatfavard`datashfv51`Private`g12, 2]], 
            Times[ 48, 
              Power[ shohatfavard`datashfv51`Private`g12, 4]]]]],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]10
        \[InvisibleSpace]"]="\[InvisibleSpace]\(350\ 
          shohatfavard`datashfv51`Private`g11\ \((
          8\ shohatfavard`datashfv51`Private`g11\^2 + 
            9\ \((shohatfavard`datashfv51`Private`g12 + 
                  4\ shohatfavard`datashfv51`Private`g12\^3)\))\)\)\),
      SequenceForm[ "form[", 3, ",", 2, ",", 10, "]=", 
        Times[ 350, shohatfavard`datashfv51`Private`g11, 
          Plus[ 
            Times[ 8, 
              Power[ shohatfavard`datashfv51`Private`g11, 2]], 
            Times[ 9, 
              Plus[ shohatfavard`datashfv51`Private`g12, 
                Times[ 4, 
                  Power[ shohatfavard`datashfv51`Private`g12, 3]]]]]]],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    \("   "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]0
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 3, ",", 3, ",", 0, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 3, ",", 3, ",", 1, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]"]="\[InvisibleSpace]1\),
      SequenceForm[ "form[", 3, ",", 3, ",", 2, "]=", 1],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 3, ",", 3, ",", 3, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]"]="\[InvisibleSpace]\(6\ 
          shohatfavard`datashfv51`Private`g12\)\),
      SequenceForm[ "form[", 3, ",", 3, ",", 4, "]=", 
        Times[ 6, shohatfavard`datashfv51`Private`g12]],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]"]="\[InvisibleSpace]\(10\ 
          shohatfavard`datashfv51`Private`g11\)\),
      SequenceForm[ "form[", 3, ",", 3, ",", 5, "]=", 
        Times[ 10, shohatfavard`datashfv51`Private`g11]],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]6
        \[InvisibleSpace]"]="\[InvisibleSpace]\(15\/4 + 
          45\ shohatfavard`datashfv51`Private`g12\^2\)\),
      SequenceForm[ "form[", 3, ",", 3, ",", 6, "]=", 
        Plus[ 
          Rational[ 15, 4], 
          Times[ 45, 
            Power[ shohatfavard`datashfv51`Private`g12, 2]]]],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]7
        \[InvisibleSpace]"]="\[InvisibleSpace]\(210\ 
          shohatfavard`datashfv51`Private`g11\ 
          shohatfavard`datashfv51`Private`g12\)\),
      SequenceForm[ "form[", 3, ",", 3, ",", 7, "]=", 
        Times[ 
        210, shohatfavard`datashfv51`Private`g11, 
          shohatfavard`datashfv51`Private`g12]],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]8
        \[InvisibleSpace]"]="\[InvisibleSpace]\(35\ 
          \((8\ shohatfavard`datashfv51`Private`g11\^2 + 
              3\ \((shohatfavard`datashfv51`Private`g12 + 
                    4\ shohatfavard`datashfv51`Private`g12\^3)\))\)\)\),
      SequenceForm[ "form[", 3, ",", 3, ",", 8, "]=", 
        Times[ 35, 
          Plus[ 
            Times[ 8, 
              Power[ shohatfavard`datashfv51`Private`g11, 2]], 
            Times[ 3, 
              Plus[ shohatfavard`datashfv51`Private`g12, 
                Times[ 4, 
                  Power[ shohatfavard`datashfv51`Private`g12, 3]]]]]]],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]9
        \[InvisibleSpace]"]="\[InvisibleSpace]\(315\ 
          \((shohatfavard`datashfv51`Private`g11 + 
              12\ shohatfavard`datashfv51`Private`g11\ 
                shohatfavard`datashfv51`Private`g12\^2)\)\)\),
      SequenceForm[ "form[", 3, ",", 3, ",", 9, "]=", 
        Times[ 315, 
          Plus[ shohatfavard`datashfv51`Private`g11, 
            Times[ 12, shohatfavard`datashfv51`Private`g11, 
              Power[ shohatfavard`datashfv51`Private`g12, 2]]]]],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]3\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]10
        \[InvisibleSpace]"]="\[InvisibleSpace]\(1575\/16\ 
          \((1 + 128\ shohatfavard`datashfv51`Private`g11\^2\ 
                shohatfavard`datashfv51`Private`g12 + 
              24\ shohatfavard`datashfv51`Private`g12\^2 + 
              48\ shohatfavard`datashfv51`Private`g12\^4)\)\)\),
      SequenceForm[ "form[", 3, ",", 3, ",", 10, "]=", 
        Times[ 
          Rational[ 1575, 16], 
          Plus[ 1, 
            Times[ 128, 
              Power[ shohatfavard`datashfv51`Private`g11, 2], 
              shohatfavard`datashfv51`Private`g12], 
            Times[ 24, 
              Power[ shohatfavard`datashfv51`Private`g12, 2]], 
            Times[ 48, 
              Power[ shohatfavard`datashfv51`Private`g12, 4]]]]],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    \({11.6333333333333399`\ Second, Null}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(MemoryInUse[]\)], "Input"],

Cell[BoxData[
    \(889464\)], "Output"]
}, Open  ]]
}, Closed]]
}, Closed]]
},
FrontEndVersion->"Macintosh 3.0",
ScreenRectangle->{{0, 832}, {0, 604}},
WindowSize->{764, 580},
WindowMargins->{{4, Automatic}, {Automatic, 1}},
MacintoshSystemPageSetup->"\<\
00<0001804P000000`d26_oQon@3:`8g0dL5N`?P0080001804P000000]P2:001
0000I00000400`<30?l00BL?00400@0000000000000006P801T1T00000000000
00000000004000000000000000000000\>"
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{
Cell[1709, 49, 1297, 21, 628, "Subsection"],

Cell[CellGroupData[{
Cell[3031, 74, 143, 4, 68, "Section"],

Cell[CellGroupData[{
Cell[3199, 82, 108, 3, 44, "Subsection"],
Cell[3310, 87, 62, 1, 27, "Input"]
}, Closed]],

Cell[CellGroupData[{
Cell[3409, 93, 123, 4, 28, "Subsection"],
Cell[3535, 99, 88, 1, 27, "Input"],
Cell[3626, 102, 142, 2, 43, "Input"],

Cell[CellGroupData[{
Cell[3793, 108, 361, 6, 75, "Input"],
Cell[4157, 116, 326, 7, 38, "Print"],
Cell[4486, 125, 300, 6, 22, "Print"],
Cell[4789, 133, 326, 7, 38, "Print"],
Cell[5118, 142, 300, 6, 22, "Print"],
Cell[5421, 150, 328, 7, 38, "Print"],
Cell[5752, 159, 302, 6, 22, "Print"],
Cell[6057, 167, 302, 6, 22, "Print"],
Cell[6362, 175, 302, 6, 22, "Print"],
Cell[6667, 183, 37, 1, 22, "Print"],
Cell[6707, 186, 384, 9, 22, "Print"],
Cell[7094, 197, 406, 8, 22, "Print"],
Cell[7503, 207, 406, 8, 22, "Print"],
Cell[7912, 217, 408, 8, 22, "Print"],
Cell[8323, 227, 408, 8, 22, "Print"],
Cell[8734, 237, 408, 8, 22, "Print"],
Cell[9145, 247, 408, 8, 22, "Print"],
Cell[9556, 257, 408, 8, 22, "Print"],
Cell[9967, 267, 408, 8, 22, "Print"],
Cell[10378, 277, 37, 1, 22, "Print"],
Cell[10418, 280, 384, 9, 22, "Print"],
Cell[10805, 291, 406, 8, 22, "Print"],
Cell[11214, 301, 406, 8, 22, "Print"],
Cell[11623, 311, 406, 8, 22, "Print"],
Cell[12032, 321, 406, 8, 22, "Print"],
Cell[12441, 331, 406, 8, 22, "Print"],
Cell[12850, 341, 406, 8, 22, "Print"],
Cell[13259, 351, 406, 8, 22, "Print"],
Cell[13668, 361, 406, 8, 22, "Print"],
Cell[14077, 371, 410, 8, 22, "Print"],
Cell[14490, 381, 37, 1, 22, "Print"]
}, Open  ]],

Cell[CellGroupData[{
Cell[14564, 387, 161, 2, 43, "Input"],
Cell[14728, 391, 243, 5, 22, "Print"],
Cell[14974, 398, 243, 5, 22, "Print"],
Cell[15220, 405, 243, 5, 22, "Print"],
Cell[15466, 412, 243, 5, 22, "Print"],
Cell[15712, 419, 243, 5, 22, "Print"],
Cell[15958, 426, 243, 5, 22, "Print"],
Cell[16204, 433, 243, 5, 22, "Print"],
Cell[16450, 440, 243, 5, 22, "Print"],
Cell[16696, 447, 243, 5, 22, "Print"],
Cell[16942, 454, 243, 5, 22, "Print"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{
Cell[17234, 465, 69, 0, 28, "Subsection"],

Cell[CellGroupData[{
Cell[17328, 469, 138, 2, 43, "Input"],
Cell[17469, 473, 175, 3, 37, "Message"]
}, Open  ]],

Cell[CellGroupData[{
Cell[17681, 481, 46, 1, 27, "Input"],
Cell[17730, 484, 40, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[17807, 490, 116, 4, 27, "Input"],
Cell[17926, 496, 38, 1, 22, "Print"],
Cell[17967, 499, 298, 6, 22, "Print"],
Cell[18268, 507, 39, 1, 22, "Print"],
Cell[18310, 510, 298, 6, 22, "Print"],
Cell[18611, 518, 39, 1, 22, "Print"],
Cell[18653, 521, 375, 8, 22, "Print"],
Cell[19031, 531, 39, 1, 22, "Print"],
Cell[19073, 534, 375, 8, 22, "Print"],
Cell[19451, 544, 39, 1, 22, "Print"],
Cell[19493, 547, 484, 11, 38, "Print"],
Cell[19980, 560, 39, 1, 22, "Print"],
Cell[20022, 563, 511, 11, 22, "Print"],
Cell[20536, 576, 39, 1, 22, "Print"],
Cell[20578, 579, 789, 18, 56, "Print"],
Cell[21370, 599, 39, 1, 22, "Print"],
Cell[21412, 602, 697, 14, 59, "Print"],
Cell[22112, 618, 39, 1, 22, "Print"],
Cell[22154, 621, 929, 20, 75, "Print"],
Cell[23086, 643, 39, 1, 22, "Print"],
Cell[23128, 646, 872, 18, 47, "Print"],
Cell[24003, 666, 39, 1, 22, "Print"],
Cell[24045, 669, 1183, 25, 79, "Print"],
Cell[25231, 696, 39, 1, 22, "Print"],
Cell[25273, 699, 38, 1, 22, "Print"],
Cell[25314, 702, 298, 6, 22, "Print"],
Cell[25615, 710, 39, 1, 22, "Print"],
Cell[25657, 713, 298, 6, 22, "Print"],
Cell[25958, 721, 39, 1, 22, "Print"],
Cell[26000, 724, 298, 6, 22, "Print"],
Cell[26301, 732, 39, 1, 22, "Print"],
Cell[26343, 735, 404, 8, 22, "Print"],
Cell[26750, 745, 39, 1, 22, "Print"],
Cell[26792, 748, 404, 8, 22, "Print"],
Cell[27199, 758, 39, 1, 22, "Print"],
Cell[27241, 761, 486, 11, 38, "Print"],
Cell[27730, 774, 39, 1, 22, "Print"],
Cell[27772, 777, 511, 11, 22, "Print"],
Cell[28286, 790, 39, 1, 22, "Print"],
Cell[28328, 793, 819, 18, 59, "Print"],
Cell[29150, 813, 39, 1, 22, "Print"],
Cell[29192, 816, 669, 13, 45, "Print"],
Cell[29864, 831, 39, 1, 22, "Print"],
Cell[29906, 834, 931, 20, 75, "Print"],
Cell[30840, 856, 39, 1, 22, "Print"],
Cell[30882, 859, 876, 18, 47, "Print"],
Cell[31761, 879, 39, 1, 22, "Print"],
Cell[31803, 882, 38, 1, 22, "Print"],
Cell[31844, 885, 298, 6, 22, "Print"],
Cell[32145, 893, 39, 1, 22, "Print"],
Cell[32187, 896, 298, 6, 22, "Print"],
Cell[32488, 904, 39, 1, 22, "Print"],
Cell[32530, 907, 298, 6, 22, "Print"],
Cell[32831, 915, 39, 1, 22, "Print"],
Cell[32873, 918, 298, 6, 22, "Print"],
Cell[33174, 926, 39, 1, 22, "Print"],
Cell[33216, 929, 404, 8, 22, "Print"],
Cell[33623, 939, 39, 1, 22, "Print"],
Cell[33665, 942, 406, 8, 22, "Print"],
Cell[34074, 952, 39, 1, 22, "Print"],
Cell[34116, 955, 488, 11, 38, "Print"],
Cell[34607, 968, 39, 1, 22, "Print"],
Cell[34649, 971, 513, 11, 22, "Print"],
Cell[35165, 984, 39, 1, 22, "Print"],
Cell[35207, 987, 791, 17, 47, "Print"],
Cell[36001, 1006, 39, 1, 22, "Print"],
Cell[36043, 1009, 671, 13, 45, "Print"],
Cell[36717, 1024, 39, 1, 22, "Print"],
Cell[36759, 1027, 935, 20, 75, "Print"],
Cell[37697, 1049, 39, 1, 22, "Print"],
Cell[37739, 1052, 70, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[37846, 1058, 46, 1, 27, "Input"],
Cell[37895, 1061, 40, 1, 26, "Output"]
}, Open  ]]
}, Closed]]
}, Closed]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

