(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 3.0,
MathReader 3.0, or any compatible application. The data for the notebook 
starts with the line of stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[    189192,       5272]*)
(*NotebookOutlinePosition[    190084,       5301]*)
(*  CellTagsIndexPosition[    190040,       5297]*)
(*WindowFrame->Normal*)



Notebook[{
Cell[TextData[{
  " :Author:  Z\[EAcute]lia da ROCHA \n\n:Address: \n            Departamento \
de Matem\[AAcute]tica Aplicada da\n            Faculdade de Ci\[EHat]ncias do \
Porto\n            Rua das Taipas, 135\n            4050 Porto\n            \
Portugal\n  \n            Tel: ++351 02 2080313\n            Fax: ++351 02 \
2004109\n            Email: mrdioh@fc.up.pt\n\n :Summary:\n    The ",
  StyleBox["testshfv2",
    FontSize->18],
  " notebook contains the results produced by the package\n    shfv.m \
corresponding to the ",
  StyleBox["example 2",
    FontSize->18],
  " of the first paper cited bellow.    \n\n :Date: July 1999. \n\n:Available \
at http://netlib.bell-labs.com/ in the numeralgo library in netlib:     \n\n \
:Notebook Version: 1.0 \n\n :Mathematica Version: 3.0   \n \n :Keywords: \
Shohat-Favard's method, regular forms, d-dimensional canonical forms, \n \
d-orthogonal polynomial sequences.\n\n :Sources:\n \n - Z\[EAcute]lia da \
Rocha, Shohat-Favard and Chebyshev's methods in d-orthogonality, \n Numerical \
Algorithms, 20 (1999) 139-164.\n   \n - About the example treated here see \
pp. 90, 106 of:\n   K. Douak, P. Maroni, Les polyn\[OHat]mes orthogonaux \
\"classiques\" de dimension deux, \n   Analysis 12,  71-107 (1992)\n"
}], "Subsection"],

Cell[CellGroupData[{

Cell["\<\
Computing the moments of the d-dimensional canonical form \
performing formal computations\
\>", "Section",
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell["\<\
Loading the package shfv.m, the package datashfv2.m is \
automatically loaded\
\>", "Subsection"],

Cell[BoxData[
    \(\(<< shohatfavard`shfv`\ ; \)\)], "Input"]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
The recurrence coefficients are given in the package \
datashfv2.m\
\>", "Subsection",
  AspectRatioFixed->True],

Cell[BoxData[
    \( (*\ showing\ the\ recurrence\ coefficients\ given\ *) \)], "Input"],

Cell[BoxData[
    \(\( (*\ set\ the\ values\ of\ d\ and\ imax\ *) \nd = 2; imax = \ 10; 
    \ \ \ \ \ \  (*\ for\ example\ *) \)\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(Do[\ 
      Do[Print["\<gamma[\>", d, "\<,\>", r, "\<,\>", n, "\<]=\>", \n
          \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \
\ gamma[d, r, n]\ ], \ \ \ \ \ \ \ \n
        \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ {n, 1, imax + r - d + 1}]; 
      Print["\<  \>"], \ \n\ \ \ \ \ \ {r, 0, d - 1}]\ \)\)], "Input"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]0
        \[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]"]="\[InvisibleSpace]216\/49\),
      SequenceForm[ "gamma[", 2, ",", 0, ",", 1, "]=", 
        Rational[ 216, 49]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]0
        \[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]"]="\[InvisibleSpace]6912\/13\),
      SequenceForm[ "gamma[", 2, ",", 0, ",", 2, "]=", 
        Rational[ 6912, 13]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]0
        \[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]"]="\[InvisibleSpace]249480\/3211\),
      SequenceForm[ "gamma[", 2, ",", 0, ",", 3, "]=", 
        Rational[ 249480, 3211]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]0
        \[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]"]="\[InvisibleSpace]81900\/19\),
      SequenceForm[ "gamma[", 2, ",", 0, ",", 4, "]=", 
        Rational[ 81900, 19]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]0
        \[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]"]="\[InvisibleSpace]96235776\/287375\),
      SequenceForm[ "gamma[", 2, ",", 0, ",", 5, "]=", 
        Rational[ 96235776, 287375]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]0
        \[InvisibleSpace]","\[InvisibleSpace]6
        \[InvisibleSpace]"]="\[InvisibleSpace]2232576\/155\),
      SequenceForm[ "gamma[", 2, ",", 0, ",", 6, "]=", 
        Rational[ 2232576, 155]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]0
        \[InvisibleSpace]","\[InvisibleSpace]7
        \[InvisibleSpace]"]="\[InvisibleSpace]9137145600\/10275973\),
      SequenceForm[ "gamma[", 2, ",", 0, ",", 7, "]=", 
        Rational[ 9137145600, 10275973]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]0
        \[InvisibleSpace]","\[InvisibleSpace]8
        \[InvisibleSpace]"]="\[InvisibleSpace]21312720\/629\),
      SequenceForm[ "gamma[", 2, ",", 0, ",", 8, "]=", 
        Rational[ 21312720, 629]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]0
        \[InvisibleSpace]","\[InvisibleSpace]9
        \[InvisibleSpace]"]="\[InvisibleSpace]2917810350\/1573499\),
      SequenceForm[ "gamma[", 2, ",", 0, ",", 9, "]=", 
        Rational[ 2917810350, 1573499]],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]"]="\[InvisibleSpace]33\/7\),
      SequenceForm[ "gamma[", 2, ",", 1, ",", 1, "]=", 
        Rational[ 33, 7]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]"]="\[InvisibleSpace]3288\/49\),
      SequenceForm[ "gamma[", 2, ",", 1, ",", 2, "]=", 
        Rational[ 3288, 49]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]"]="\[InvisibleSpace]24696\/169\),
      SequenceForm[ "gamma[", 2, ",", 1, ",", 3, "]=", 
        Rational[ 24696, 169]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]"]="\[InvisibleSpace]79035\/247\),
      SequenceForm[ "gamma[", 2, ",", 1, ",", 4, "]=", 
        Rational[ 79035, 247]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]"]="\[InvisibleSpace]5430516\/11495\),
      SequenceForm[ "gamma[", 2, ",", 1, ",", 5, "]=", 
        Rational[ 5430516, 11495]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]6
        \[InvisibleSpace]"]="\[InvisibleSpace]5209344\/6875\),
      SequenceForm[ "gamma[", 2, ",", 1, ",", 6, "]=", 
        Rational[ 5209344, 6875]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]7
        \[InvisibleSpace]"]="\[InvisibleSpace]16069440\/16337\),
      SequenceForm[ "gamma[", 2, ",", 1, ",", 7, "]=", 
        Rational[ 16069440, 16337]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]8
        \[InvisibleSpace]"]="\[InvisibleSpace]457561632\/331483\),
      SequenceForm[ "gamma[", 2, ",", 1, ",", 8, "]=", 
        Rational[ 457561632, 331483]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]9
        \[InvisibleSpace]"]="\[InvisibleSpace]10689705\/6364\),
      SequenceForm[ "gamma[", 2, ",", 1, ",", 9, "]=", 
        Rational[ 10689705, 6364]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]10
        \[InvisibleSpace]"]="\[InvisibleSpace]93043020\/42527\),
      SequenceForm[ "gamma[", 2, ",", 1, ",", 10, "]=", 
        Rational[ 93043020, 42527]],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(\ Do[Print["\<beta[\>", d, "\<,\>", n, "\<]=\>", beta[d, n]\ ], 
      \ \ \ \ \ \ \ \n\ \ \ \ \ \ \ \ \ \ {n, 0, imax - 1}]\)\)], "Input"],

Cell[BoxData[
    InterpretationBox[
      \("beta["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]0
        \[InvisibleSpace]"]="\[InvisibleSpace]1\),
      SequenceForm[ "beta[", 2, ",", 0, "]=", 1],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("beta["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]"]="\[InvisibleSpace]73\/7\),
      SequenceForm[ "beta[", 2, ",", 1, "]=", 
        Rational[ 73, 7]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("beta["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]"]="\[InvisibleSpace]1312\/91\),
      SequenceForm[ "beta[", 2, ",", 2, "]=", 
        Rational[ 1312, 91]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("beta["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]"]="\[InvisibleSpace]379\/13\),
      SequenceForm[ "beta[", 2, ",", 3, "]=", 
        Rational[ 379, 13]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("beta["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]"]="\[InvisibleSpace]305\/11\),
      SequenceForm[ "beta[", 2, ",", 4, "]=", 
        Rational[ 305, 11]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("beta["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]"]="\[InvisibleSpace]13154\/275\),
      SequenceForm[ "beta[", 2, ",", 5, "]=", 
        Rational[ 13154, 275]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("beta["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]6
        \[InvisibleSpace]"]="\[InvisibleSpace]31816\/775\),
      SequenceForm[ "beta[", 2, ",", 6, "]=", 
        Rational[ 31816, 775]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("beta["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]7
        \[InvisibleSpace]"]="\[InvisibleSpace]35048\/527\),
      SequenceForm[ "beta[", 2, ",", 7, "]=", 
        Rational[ 35048, 527]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("beta["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]8
        \[InvisibleSpace]"]="\[InvisibleSpace]1849\/34\),
      SequenceForm[ "beta[", 2, ",", 8, "]=", 
        Rational[ 1849, 34]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("beta["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]9
        \[InvisibleSpace]"]="\[InvisibleSpace]7325\/86\),
      SequenceForm[ "beta[", 2, ",", 9, "]=", 
        Rational[ 7325, 86]],
      Editable->False]], "Print"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["\<\
The exact expressions of the moments of the d-dimensional form are \
given in the package datashfv2.m\
\>", "Subsection"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\( (*\ set\ the\ values\ of\ d\ and\ nmax\ *) \nd = 2; \ nmax = \ 10\ ; 
    \ \ \ \  (*\ for\ example\ *) \)\)], "Input"],

Cell[BoxData[
    \(General::"spell1" \( : \ \) 
      "Possible spelling error: new symbol name \"\!\(nmax\)\" is similar to \
existing symbol \"\!\(imax\)\"."\)], "Message"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Timing[\n\t
      Do[Do[Print["\<formexact[\>", d "\<,\>", r, "\<,\>", i, "\<]=\>", \n
            \t\t\t\t\ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ 
            formexact[d, r, i]\ ], {i, 0, imax}]; \n\t\t\ \ \ \ \ 
        Print["\<   \>"], {r, 1, d}\ ]\n\ \ \ \ \ \ \ \ \ \ \ \ \ \ \ ]\)], 
  "Input"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]\(2\ ","\)\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]0
        \[InvisibleSpace]"]="\[InvisibleSpace]1\),
      SequenceForm[ "formexact[", 
        Times[ 2, ","], 1, ",", 0, "]=", 1],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]\(2\ ","\)\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]"]="\[InvisibleSpace]1\),
      SequenceForm[ "formexact[", 
        Times[ 2, ","], 1, ",", 1, "]=", 1],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]\(2\ ","\)\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]"]="\[InvisibleSpace]40\/7\),
      SequenceForm[ "formexact[", 
        Times[ 2, ","], 1, ",", 2, "]=", 
        Rational[ 40, 7]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]\(2\ ","\)\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]"]="\[InvisibleSpace]64\),
      SequenceForm[ "formexact[", 
        Times[ 2, ","], 1, ",", 3, "]=", 64],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]\(2\ ","\)\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]"]="\[InvisibleSpace]14080\/13\),
      SequenceForm[ "formexact[", 
        Times[ 2, ","], 1, ",", 4, "]=", 
        Rational[ 14080, 13]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]\(2\ ","\)\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]"]="\[InvisibleSpace]24640\),
      SequenceForm[ "formexact[", 
        Times[ 2, ","], 1, ",", 5, "]=", 24640],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]\(2\ ","\)\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]6
        \[InvisibleSpace]"]="\[InvisibleSpace]13404160\/19\),
      SequenceForm[ "formexact[", 
        Times[ 2, ","], 1, ",", 6, "]=", 
        Rational[ 13404160, 19]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]\(2\ ","\)\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]7
        \[InvisibleSpace]"]="\[InvisibleSpace]24371200\),
      SequenceForm[ "formexact[", 
        Times[ 2, ","], 1, ",", 7, "]=", 24371200],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]\(2\ ","\)\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]8
        \[InvisibleSpace]"]="\[InvisibleSpace]986546176\),
      SequenceForm[ "formexact[", 
        Times[ 2, ","], 1, ",", 8, "]=", 986546176],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]\(2\ ","\)\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]9
        \[InvisibleSpace]"]="\[InvisibleSpace]45803929600\),
      SequenceForm[ "formexact[", 
        Times[ 2, ","], 1, ",", 9, "]=", 45803929600],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]\(2\ ","\)\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]10
        \[InvisibleSpace]"]="\[InvisibleSpace]74385581670400\/31\),
      SequenceForm[ "formexact[", 
        Times[ 2, ","], 1, ",", 10, "]=", 
        Rational[ 74385581670400, 31]],
      Editable->False]], "Print"],

Cell[BoxData[
    \("   "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]\(2\ ","\)\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]0
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 
        Times[ 2, ","], 2, ",", 0, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]\(2\ ","\)\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]"]="\[InvisibleSpace]1\),
      SequenceForm[ "formexact[", 
        Times[ 2, ","], 2, ",", 1, "]=", 1],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]\(2\ ","\)\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]"]="\[InvisibleSpace]80\/7\),
      SequenceForm[ "formexact[", 
        Times[ 2, ","], 2, ",", 2, "]=", 
        Rational[ 80, 7]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]\(2\ ","\)\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]"]="\[InvisibleSpace]192\),
      SequenceForm[ "formexact[", 
        Times[ 2, ","], 2, ",", 3, "]=", 192],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]\(2\ ","\)\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]"]="\[InvisibleSpace]56320\/13\),
      SequenceForm[ "formexact[", 
        Times[ 2, ","], 2, ",", 4, "]=", 
        Rational[ 56320, 13]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]\(2\ ","\)\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]"]="\[InvisibleSpace]123200\),
      SequenceForm[ "formexact[", 
        Times[ 2, ","], 2, ",", 5, "]=", 123200],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]\(2\ ","\)\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]6
        \[InvisibleSpace]"]="\[InvisibleSpace]80424960\/19\),
      SequenceForm[ "formexact[", 
        Times[ 2, ","], 2, ",", 6, "]=", 
        Rational[ 80424960, 19]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]\(2\ ","\)\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]7
        \[InvisibleSpace]"]="\[InvisibleSpace]170598400\),
      SequenceForm[ "formexact[", 
        Times[ 2, ","], 2, ",", 7, "]=", 170598400],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]\(2\ ","\)\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]8
        \[InvisibleSpace]"]="\[InvisibleSpace]7892369408\),
      SequenceForm[ "formexact[", 
        Times[ 2, ","], 2, ",", 8, "]=", 7892369408],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]\(2\ ","\)\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]9
        \[InvisibleSpace]"]="\[InvisibleSpace]412235366400\),
      SequenceForm[ "formexact[", 
        Times[ 2, ","], 2, ",", 9, "]=", 412235366400],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]\(2\ ","\)\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]10
        \[InvisibleSpace]"]="\[InvisibleSpace]743855816704000\/31\),
      SequenceForm[ "formexact[", 
        Times[ 2, ","], 2, ",", 10, "]=", 
        Rational[ 743855816704000, 31]],
      Editable->False]], "Print"],

Cell[BoxData[
    \("   "\)], "Print"],

Cell[BoxData[
    \({4.76666666666666571`\ Second, Null}\)], "Output"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Computing the moments of the d-dimensional form", "Subsection"],

Cell[BoxData[
    \(\( (*\ set\ the\ values\ of\ d\ and\ nmax\ *) \nd = 2; \ nmax = \ 10\ ; 
    \ \  (*\ for\ example\ *) \)\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(MemoryInUse[]\)], "Input"],

Cell[BoxData[
    \(896160\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Timing[printdcanform[d,nmax,Infinity,$MachinePrecision,True,False]]\
\
\>", "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    \("   "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]0
        \[InvisibleSpace]"]="\[InvisibleSpace]1\),
      SequenceForm[ "form[", 2, ",", 1, ",", 0, "]=", 1],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]0
        \[InvisibleSpace]"]="\[InvisibleSpace]1\),
      SequenceForm[ "formexact[", 2, ",", 1, ",", 0, "]=", 1],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]"]="\[InvisibleSpace]1\),
      SequenceForm[ "form[", 2, ",", 1, ",", 1, "]=", 1],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]"]="\[InvisibleSpace]1\),
      SequenceForm[ "formexact[", 2, ",", 1, ",", 1, "]=", 1],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]"]="\[InvisibleSpace]40\/7\),
      SequenceForm[ "form[", 2, ",", 1, ",", 2, "]=", 
        Rational[ 40, 7]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]"]="\[InvisibleSpace]40\/7\),
      SequenceForm[ "formexact[", 2, ",", 1, ",", 2, "]=", 
        Rational[ 40, 7]],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]"]="\[InvisibleSpace]64\),
      SequenceForm[ "form[", 2, ",", 1, ",", 3, "]=", 64],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]"]="\[InvisibleSpace]64\),
      SequenceForm[ "formexact[", 2, ",", 1, ",", 3, "]=", 64],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]"]="\[InvisibleSpace]14080\/13\),
      SequenceForm[ "form[", 2, ",", 1, ",", 4, "]=", 
        Rational[ 14080, 13]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]"]="\[InvisibleSpace]14080\/13\),
      SequenceForm[ "formexact[", 2, ",", 1, ",", 4, "]=", 
        Rational[ 14080, 13]],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]"]="\[InvisibleSpace]24640\),
      SequenceForm[ "form[", 2, ",", 1, ",", 5, "]=", 24640],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]"]="\[InvisibleSpace]24640\),
      SequenceForm[ "formexact[", 2, ",", 1, ",", 5, "]=", 24640],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]6
        \[InvisibleSpace]"]="\[InvisibleSpace]13404160\/19\),
      SequenceForm[ "form[", 2, ",", 1, ",", 6, "]=", 
        Rational[ 13404160, 19]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]6
        \[InvisibleSpace]"]="\[InvisibleSpace]13404160\/19\),
      SequenceForm[ "formexact[", 2, ",", 1, ",", 6, "]=", 
        Rational[ 13404160, 19]],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]7
        \[InvisibleSpace]"]="\[InvisibleSpace]24371200\),
      SequenceForm[ "form[", 2, ",", 1, ",", 7, "]=", 24371200],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]7
        \[InvisibleSpace]"]="\[InvisibleSpace]24371200\),
      SequenceForm[ "formexact[", 2, ",", 1, ",", 7, "]=", 24371200],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]8
        \[InvisibleSpace]"]="\[InvisibleSpace]986546176\),
      SequenceForm[ "form[", 2, ",", 1, ",", 8, "]=", 986546176],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]8
        \[InvisibleSpace]"]="\[InvisibleSpace]986546176\),
      SequenceForm[ "formexact[", 2, ",", 1, ",", 8, "]=", 986546176],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]9
        \[InvisibleSpace]"]="\[InvisibleSpace]45803929600\),
      SequenceForm[ "form[", 2, ",", 1, ",", 9, "]=", 45803929600],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]9
        \[InvisibleSpace]"]="\[InvisibleSpace]45803929600\),
      SequenceForm[ "formexact[", 2, ",", 1, ",", 9, "]=", 45803929600],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]10
        \[InvisibleSpace]"]="\[InvisibleSpace]74385581670400\/31\),
      SequenceForm[ "form[", 2, ",", 1, ",", 10, "]=", 
        Rational[ 74385581670400, 31]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]10
        \[InvisibleSpace]"]="\[InvisibleSpace]74385581670400\/31\),
      SequenceForm[ "formexact[", 2, ",", 1, ",", 10, "]=", 
        Rational[ 74385581670400, 31]],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    \("   "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]0
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 2, ",", 2, ",", 0, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]0
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 2, ",", 2, ",", 0, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]"]="\[InvisibleSpace]1\),
      SequenceForm[ "form[", 2, ",", 2, ",", 1, "]=", 1],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]"]="\[InvisibleSpace]1\),
      SequenceForm[ "formexact[", 2, ",", 2, ",", 1, "]=", 1],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]"]="\[InvisibleSpace]80\/7\),
      SequenceForm[ "form[", 2, ",", 2, ",", 2, "]=", 
        Rational[ 80, 7]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]"]="\[InvisibleSpace]80\/7\),
      SequenceForm[ "formexact[", 2, ",", 2, ",", 2, "]=", 
        Rational[ 80, 7]],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]"]="\[InvisibleSpace]192\),
      SequenceForm[ "form[", 2, ",", 2, ",", 3, "]=", 192],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]"]="\[InvisibleSpace]192\),
      SequenceForm[ "formexact[", 2, ",", 2, ",", 3, "]=", 192],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]"]="\[InvisibleSpace]56320\/13\),
      SequenceForm[ "form[", 2, ",", 2, ",", 4, "]=", 
        Rational[ 56320, 13]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]"]="\[InvisibleSpace]56320\/13\),
      SequenceForm[ "formexact[", 2, ",", 2, ",", 4, "]=", 
        Rational[ 56320, 13]],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]"]="\[InvisibleSpace]123200\),
      SequenceForm[ "form[", 2, ",", 2, ",", 5, "]=", 123200],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]"]="\[InvisibleSpace]123200\),
      SequenceForm[ "formexact[", 2, ",", 2, ",", 5, "]=", 123200],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]6
        \[InvisibleSpace]"]="\[InvisibleSpace]80424960\/19\),
      SequenceForm[ "form[", 2, ",", 2, ",", 6, "]=", 
        Rational[ 80424960, 19]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]6
        \[InvisibleSpace]"]="\[InvisibleSpace]80424960\/19\),
      SequenceForm[ "formexact[", 2, ",", 2, ",", 6, "]=", 
        Rational[ 80424960, 19]],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]7
        \[InvisibleSpace]"]="\[InvisibleSpace]170598400\),
      SequenceForm[ "form[", 2, ",", 2, ",", 7, "]=", 170598400],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]7
        \[InvisibleSpace]"]="\[InvisibleSpace]170598400\),
      SequenceForm[ "formexact[", 2, ",", 2, ",", 7, "]=", 170598400],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]8
        \[InvisibleSpace]"]="\[InvisibleSpace]7892369408\),
      SequenceForm[ "form[", 2, ",", 2, ",", 8, "]=", 7892369408],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]8
        \[InvisibleSpace]"]="\[InvisibleSpace]7892369408\),
      SequenceForm[ "formexact[", 2, ",", 2, ",", 8, "]=", 7892369408],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]9
        \[InvisibleSpace]"]="\[InvisibleSpace]412235366400\),
      SequenceForm[ "form[", 2, ",", 2, ",", 9, "]=", 412235366400],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]9
        \[InvisibleSpace]"]="\[InvisibleSpace]412235366400\),
      SequenceForm[ "formexact[", 2, ",", 2, ",", 9, "]=", 412235366400],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]10
        \[InvisibleSpace]"]="\[InvisibleSpace]743855816704000\/31\),
      SequenceForm[ "form[", 2, ",", 2, ",", 10, "]=", 
        Rational[ 743855816704000, 31]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]10
        \[InvisibleSpace]"]="\[InvisibleSpace]743855816704000\/31\),
      SequenceForm[ "formexact[", 2, ",", 2, ",", 10, "]=", 
        Rational[ 743855816704000, 31]],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    \({12.5`\ Second, Null}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(MemoryInUse[]\)], "Input"],

Cell[BoxData[
    \(906544\)], "Output"]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["\<\
Computing the moments of the d-dimensional canonical form  \
performing numerical computations with the machine precision\
\>", "Section",
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell["\<\
Loading the package shfv.m, the package datashfv2.m is automaticaly \
loaded\
\>", "Subsection"],

Cell[BoxData[
    \(\(<< shohatfavard`shfv`\ ; \)\)], "Input"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Computing the moments of the d-dimensional form", "Subsection"],

Cell[BoxData[
    \(\( (*\ set\ the\ values\ of\ d\ and\ nmax\ *) \nd = 2; \ nmax = \ 45\ ; 
    \ \ \ \  (*\ for\ example\ *) \)\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(MemoryInUse[]\)], "Input"],

Cell[BoxData[
    \(903504\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Timing[printdcanform[d,nmax,$MachinePrecision,$MachinePrecision,\
True,True]]\
\>", "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    \("   "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("form["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["1.`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "form[", 2, ",", 1, ",", 0, "]=", 1.0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("formexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["1.`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "formexact[", 2, ",", 1, ",", 0, "]=", 1.0],
      Editable->False]], "Print"],

Cell[BoxData[
    \(MantissaExponent::"realx" \( : \ \) 
      "\!\(1\) is not an inexact real number."\)], "Message"],

Cell[BoxData[
    \(Part::"partw" \( : \ \) 
      "Part \!\(2\) of \!\(MantissaExponent[1]\) does not exist."\)], 
  "Message"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        InterpretationBox["\[Infinity]",
          DirectedInfinity[ 1]]}],
      SequenceForm[ "exactdigits[", 2, ",", 1, ",", 0, "]=", 
        DirectedInfinity[ 1]],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("form["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["1.`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "form[", 2, ",", 1, ",", 1, "]=", 1.0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("formexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["1.`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "formexact[", 2, ",", 1, ",", 1, "]=", 1.0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        InterpretationBox["\[Infinity]",
          DirectedInfinity[ 1]]}],
      SequenceForm[ "exactdigits[", 2, ",", 1, ",", 1, "]=", 
        DirectedInfinity[ 1]],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("form["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["5.71428571428571441`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "form[", 2, ",", 1, ",", 2, "]=", 5.7142857142857144],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("formexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["5.71428571428571441`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "formexact[", 2, ",", 1, ",", 2, "]=", 5.7142857142857144],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        InterpretationBox["\[Infinity]",
          DirectedInfinity[ 1]]}],
      SequenceForm[ "exactdigits[", 2, ",", 1, ",", 2, "]=", 
        DirectedInfinity[ 1]],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("form["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["64.0000000000000035`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "form[", 2, ",", 1, ",", 3, "]=", 64.0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("formexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["64.0000000000000035`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "formexact[", 2, ",", 1, ",", 3, "]=", 64.0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        InterpretationBox["\[Infinity]",
          DirectedInfinity[ 1]]}],
      SequenceForm[ "exactdigits[", 2, ",", 1, ",", 3, "]=", 
        DirectedInfinity[ 1]],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("form["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "4", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["1083.07692307692327`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "form[", 2, ",", 1, ",", 4, "]=", 1083.0769230769233],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("formexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "4", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["1083.07692307692304`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "formexact[", 2, ",", 1, ",", 4, "]=", 1083.0769230769231],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "4", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["15.643259817887209`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 2, ",", 1, ",", 4, "]=", 15.643259817887209],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("form["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "5", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["24640.0000000000085`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "form[", 2, ",", 1, ",", 5, "]=", 24640.000000000007],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("formexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "5", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["24639.9999999999996`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "formexact[", 2, ",", 1, ",", 5, "]=", 24640.0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "5", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["15.1381098395673063`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 2, ",", 1, ",", 5, "]=", 15.138109839567306],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("form["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "6", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["705482.105263157244`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "form[", 2, ",", 1, ",", 6, "]=", 705482.10526315728],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("formexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "6", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["705482.105263157865`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "formexact[", 2, ",", 1, ",", 6, "]=", 705482.10526315786],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "6", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["14.235019852575359`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 2, ",", 1, ",", 6, "]=", 14.235019852575359],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("form["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "7", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["2.43711999999998196`*^7",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "form[", 2, ",", 1, ",", 7, "]=", 24371199.999999821],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("formexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "7", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["2.43711999999999973`*^7",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "formexact[", 2, ",", 1, ",", 7, "]=", 24371200.0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "7", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["13.7475986412158834`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 2, ",", 1, ",", 7, "]=", 13.747598641215884],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("form["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "8", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["9.86546175999982821`*^8",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "form[", 2, ",", 1, ",", 8, "]=", 986546175.99998283],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("formexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "8", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["9.86546176000000052`*^8",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "formexact[", 2, ",", 1, ",", 8, "]=", 986546176.0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "8", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["12.7653274081763168`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 2, ",", 1, ",", 8, "]=", 12.765327408176317],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("form["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "9", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["4.58039295999995133`*^10",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "form[", 2, ",", 1, ",", 9, "]=", 45803929599.999512],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("formexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "9", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["4.58039295999999929`*^10",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "formexact[", 2, ",", 1, ",", 9, "]=", 45803929600.0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "9", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["13.3113299523037942`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 2, ",", 1, ",", 9, "]=", 13.311329952303794],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("form["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "10", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["2.39953489259367946`*^12",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "form[", 2, ",", 1, ",", 10, "]=", 2399534892593.6797],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("formexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "10", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["2.39953489259354846`*^12",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "formexact[", 2, ",", 1, ",", 10, "]=", 2399534892593.5483],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "10", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["12.8815776723013852`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 2, ",", 1, ",", 10, "]=", 12.881577672301384],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("form["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "11", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["1.40019918438434647`*^14",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "form[", 2, ",", 1, ",", 11, "]=", 140019918438434.62],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("formexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "11", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["1.40019918438399981`*^14",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "formexact[", 2, ",", 1, ",", 11, "]=", 140019918438400.0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "11", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["12.4606102179274946`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 2, ",", 1, ",", 11, "]=", 12.460610217927496],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("form["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "12", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["9.00668664550337538`*^15",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "form[", 2, ",", 1, ",", 12, "]=", 9006686645503376.0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("formexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "12", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["9.00668664549708175`*^15",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "formexact[", 2, ",", 1, ",", 12, "]=", 9006686645497081.0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "12", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["11.2010042655561181`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 2, ",", 1, ",", 12, "]=", 11.201004265556119],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("form["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "13", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["6.33170071179533344`*^17",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "form[", 2, ",", 1, ",", 13, "]=", 6.3317007117953331*^+17],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("formexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "13", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["6.33170071178444793`*^17",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "formexact[", 2, ",", 1, ",", 13, "]=", 6.331700711784448*^+17],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "13", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["10.9631667788368902`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 2, ",", 1, ",", 13, "]=", 10.963166778836891],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("form["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "14", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["4.82976240342779128`*^19",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "form[", 2, ",", 1, ",", 14, "]=", 4.8297624034277917*^+19],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("formexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "14", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["4.82976240340767226`*^19",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "formexact[", 2, ",", 1, ",", 14, "]=", 4.8297624034076721*^+19],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "14", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["10.6963816938991174`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 2, ",", 1, ",", 14, "]=", 10.696381693899117],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("form["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "15", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["3.97300455101891092`*^21",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "form[", 2, ",", 1, ",", 15, "]=", 3.9730045510189108*^+21],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("formexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "15", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["3.9730045509770937`*^21",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "formexact[", 2, ",", 1, ",", 15, "]=", 3.9730045509770936*^+21],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "15", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["10.3786449370807587`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 2, ",", 1, ",", 15, "]=", 10.378644937080759],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("form["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "16", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["3.50597381201936153`*^23",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "form[", 2, ",", 1, ",", 16, "]=", 3.505973812019361*^+23],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("formexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "16", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["3.50597381192346002`*^23",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "formexact[", 2, ",", 1, ",", 16, "]=", 3.5059738119234598*^+23],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "16", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["10.0181757275171445`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 2, ",", 1, ",", 16, "]=", 10.018175727517145],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("form["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "17", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["3.30370609223540911`*^25",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "form[", 2, ",", 1, ",", 17, "]=", 3.3037060922354096*^+25],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("formexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "17", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["3.30370609200479892`*^25",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "formexact[", 2, ",", 1, ",", 17, "]=", 3.3037060920047986*^+25],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "17", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["9.63712004215111051`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 2, ",", 1, ",", 17, "]=", 9.6371200421511105],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("form["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "18", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["3.31091417858541792`*^27",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "form[", 2, ",", 1, ",", 18, "]=", 3.3109141785854176*^+27],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("formexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "18", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["3.3109141780237179`*^27",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "formexact[", 2, ",", 1, ",", 18, "]=", 3.3109141780237183*^+27],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "18", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["9.25049614909240602`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 2, ",", 1, ",", 18, "]=", 9.250496149092406],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("form["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "19", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["3.51641919734471297`*^29",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "form[", 2, ",", 1, ",", 19, "]=", 3.516419197344713*^+29],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("formexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "19", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["3.5164191959700175`*^29",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "formexact[", 2, ",", 1, ",", 19, "]=", 3.5164191959700181*^+29],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "19", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["8.86179366744482166`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 2, ",", 1, ",", 19, "]=", 8.8617936674448217],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("form["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "20", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["3.94530704885726546`*^31",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "form[", 2, ",", 1, ",", 20, "]=", 3.9453070488572659*^+31],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("formexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "20", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["3.94530704544570554`*^31",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "formexact[", 2, ",", 1, ",", 20, "]=", 3.9453070454457054*^+31],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "20", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["8.4670469245650537`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 2, ",", 1, ",", 20, "]=", 8.4670469245650537],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("form["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "21", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["4.66285977306012977`*^33",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "form[", 2, ",", 1, ",", 21, "]=", 4.6628597730601308*^+33],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("formexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "21", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["4.6628597643361429`*^33",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "formexact[", 2, ",", 1, ",", 21, "]=", 4.6628597643361433*^+33],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "21", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["8.05928496307858566`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 2, ",", 1, ",", 21, "]=", 8.0592849630785857],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("form["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "22", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["5.79029752170893452`*^35",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "form[", 2, ",", 1, ",", 22, "]=", 5.7902975217089346*^+35],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("formexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "22", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["5.79029749839950813`*^35",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "formexact[", 2, ",", 1, ",", 22, "]=", 5.7902974983995093*^+35],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "22", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["7.63246843312661482`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 2, ",", 1, ",", 22, "]=", 7.6324684331266148],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("form["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "23", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["7.53731303755497883`*^37",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "form[", 2, ",", 1, ",", 23, "]=", 7.5373130375549799*^+37],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("formexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "23", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["7.53731297220233198`*^37",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "formexact[", 2, ",", 1, ",", 23, "]=", 7.5373129722023325*^+37],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "23", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["7.1847368142094794`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 2, ",", 1, ",", 23, "]=", 7.1847368142094794],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("form["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "24", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["1.02631359364263552`*^40",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "form[", 2, ",", 1, ",", 24, "]=", 1.0263135936426355*^+40],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("formexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "24", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["1.02631357457111205`*^40",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "formexact[", 2, ",", 1, ",", 24, "]=", 1.026313574571112*^+40],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "24", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["7.71961461235965629`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 2, ",", 1, ",", 24, "]=", 7.7196146123596563],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("form["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "25", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["1.45898582791578013`*^42",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "form[", 2, ",", 1, ",", 25, "]=", 1.45898582791578*^+42],
      
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("formexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "25", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["1.45898577100872302`*^42",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "formexact[", 2, ",", 1, ",", 25, "]=", 1.458985771008723*^+42],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "25", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["7.24483387429563663`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 2, ",", 1, ",", 25, "]=", 7.2448338742956366],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("form["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "26", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["2.161515291621106`*^44",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "form[", 2, ",", 1, ",", 26, "]=", 2.161515291621106*^+44],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("formexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "26", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["2.1615151220108979`*^44",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "formexact[", 2, ",", 1, ",", 26, "]=", 2.161515122010898*^+44],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "26", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["6.77054801335237499`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 2, ",", 1, ",", 26, "]=", 6.770548013352375],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("form["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "27", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["3.3318969715440394`*^46",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "form[", 2, ",", 1, ",", 27, "]=", 3.33189697154404*^+46],
      
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("formexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "27", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["3.3318964807582625`*^46",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "formexact[", 2, ",", 1, ",", 27, "]=", 3.3318964807582624*^+46],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "27", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["6.30910803109632212`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 2, ",", 1, ",", 27, "]=", 6.3091080310963221],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("form["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "28", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["5.33573954629540203`*^48",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "form[", 2, ",", 1, ",", 28, "]=", 5.3357395462954027*^+48],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("formexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "28", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["5.33573822306840828`*^48",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "formexact[", 2, ",", 1, ",", 28, "]=", 5.3357382230684079*^+48],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "28", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["5.87836564777676073`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 2, ",", 1, ",", 28, "]=", 5.8783656477767607],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("form["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "29", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["8.864604509134681`*^50",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "form[", 2, ",", 1, ",", 29, "]=", 8.8646045091346804*^+50],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("formexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "29", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["8.86460145696137757`*^50",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "formexact[", 2, ",", 1, ",", 29, "]=", 8.8646014569613781*^+50],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "29", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["5.51539081078757931`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 2, ",", 1, ",", 29, "]=", 5.5153908107875793],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("form["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "30", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["1.5258808416399578`*^53",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "form[", 2, ",", 1, ",", 30, "]=", 1.5258808416399579*^+53],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("formexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "30", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["1.52588040903124184`*^53",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "formexact[", 2, ",", 1, ",", 30, "]=", 1.5258804090312419*^+53],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "30", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["6.36390473486566321`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 2, ",", 1, ",", 30, "]=", 6.3639047348656632],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("form["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "31", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["2.71801405120851358`*^55",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "form[", 2, ",", 1, ",", 31, "]=", 2.7180140512085138*^+55],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("formexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "31", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["2.71801506051267161`*^55",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "formexact[", 2, ",", 1, ",", 31, "]=", 2.7180150605126716*^+55],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "31", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["5.99597793770679032`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 2, ",", 1, ",", 31, "]=", 5.9959779377067903],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("form["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "32", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["5.00449688258497182`*^57",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "form[", 2, ",", 1, ",", 32, "]=", 5.0044968825849724*^+57],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("formexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "32", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["5.00451020420168113`*^57",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "formexact[", 2, ",", 1, ",", 32, "]=", 5.0045102042016825*^+57],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "32", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["4.87544306603380306`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 2, ",", 1, ",", 32, "]=", 4.8754430660338031],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("form["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "33", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["9.51449114952590946`*^59",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "form[", 2, ",", 1, ",", 33, "]=", 9.5144911495259092*^+59],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("formexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "33", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["9.51457480022823709`*^59",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "formexact[", 2, ",", 1, ",", 33, "]=", 9.5145748002282394*^+59],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "33", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["4.07753040835551416`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 2, ",", 1, ",", 33, "]=", 4.0775304083555142],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("form["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "34", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["1.86592212289049612`*^62",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "form[", 2, ",", 1, ",", 34, "]=", 1.8659221228904962*^+62],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("formexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "34", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["1.86596515499621737`*^62",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "formexact[", 2, ",", 1, ",", 34, "]=", 1.8659651549962175*^+62],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "34", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["4.36620740174942056`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 2, ",", 1, ",", 34, "]=", 4.3662074017494206],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("form["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "35", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["3.77115982713347985`*^64",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "form[", 2, ",", 1, ",", 35, "]=", 3.7711598271334799*^+64],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("formexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "35", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["3.77136202647537421`*^64",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "formexact[", 2, ",", 1, ",", 35, "]=", 3.7713620264753741*^+64],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "35", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["3.69422026225725375`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 2, ",", 1, ",", 35, "]=", 3.6942202622572538],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("form["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "36", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["7.84766899640331683`*^66",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "form[", 2, ",", 1, ",", 36, "]=", 7.8476689964033172*^+66],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("formexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "36", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["7.8485849732630637`*^66",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "formexact[", 2, ",", 1, ",", 36, "]=", 7.8485849732630639*^+66],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "36", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["3.03811549774183475`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 2, ",", 1, ",", 36, "]=", 3.0381154977418348],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("form["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "37", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["1.68001826528785329`*^69",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "form[", 2, ",", 1, ",", 37, "]=", 1.6800182652878534*^+69],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("formexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "37", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["1.68043810409685923`*^69",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "formexact[", 2, ",", 1, ",", 37, "]=", 1.6804381040968594*^+69],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "37", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["3.37691741864037453`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 2, ",", 1, ",", 37, "]=", 3.3769174186403745],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("form["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "38", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["3.69666532652414758`*^71",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "form[", 2, ",", 1, ",", 38, "]=", 3.6966653265241476*^+71],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("formexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "38", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["3.69871732964345278`*^71",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "formexact[", 2, ",", 1, ",", 38, "]=", 3.6987173296434527*^+71],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "38", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["2.68782198337699185`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 2, ",", 1, ",", 38, "]=", 2.6878219833769919],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("form["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "39", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["8.35170585616027416`*^73",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "form[", 2, ",", 1, ",", 39, "]=", 8.3517058561602737*^+73],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("formexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "39", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["8.36286257244807806`*^73",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "formexact[", 2, ",", 1, ",", 39, "]=", 8.3628625724480775*^+73],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "39", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["1.95246361076898722`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 2, ",", 1, ",", 39, "]=", 1.9524636107689872],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("form["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "40", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["1.9342204267287375`*^76",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "form[", 2, ",", 1, ",", 40, "]=", 1.9342204267287377*^+76],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("formexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "40", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["1.94101349160852763`*^76",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "formexact[", 2, ",", 1, ",", 40, "]=", 1.9410134916085276*^+76],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "40", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["2.16793423749228963`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 2, ",", 1, ",", 40, "]=", 2.1679342374922896],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("form["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "41", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["4.57652677904577132`*^78",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "form[", 2, ",", 1, ",", 41, "]=", 4.5765267790457705*^+78],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("formexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "41", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["4.62149051018146472`*^78",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "formexact[", 2, ",", 1, ",", 41, "]=", 4.6214905101814651*^+78],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "41", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["1.34713765775016725`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 2, ",", 1, ",", 41, "]=", 1.3471376577501673],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("form["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "42", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["1.09697984985036821`*^81",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "form[", 2, ",", 1, ",", 42, "]=", 1.0969798498503683*^+81],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("formexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "42", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["1.12808036075295592`*^81",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "formexact[", 2, ",", 1, ",", 42, "]=", 1.1280803607529559*^+81],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "42", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["1.50723247655670888`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 2, ",", 1, ",", 42, "]=", 1.5072324765567089],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("form["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "43", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["2.6028867306892307`*^83",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "form[", 2, ",", 1, ",", 43, "]=", 2.6028867306892306*^+83],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("formexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "43", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["2.82124220683077719`*^83",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "formexact[", 2, ",", 1, ",", 43, "]=", 2.8212422068307775*^+83],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "43", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["0.660835911925687469`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 2, ",", 1, ",", 43, "]=", 0.66083591192568747],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("form["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "44", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["5.69313088220053042`*^85",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "form[", 2, ",", 1, ",", 44, "]=", 5.6931308822005296*^+85],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("formexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "44", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["7.2249255311771634`*^85",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "formexact[", 2, ",", 1, ",", 44, "]=", 7.2249255311771636*^+85],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "44", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        RowBox[{"-", 
          StyleBox["0.185200548068166881`",
            StyleBoxAutoDelete->True,
            PrintPrecision->2]}]}],
      SequenceForm[ 
      "exactdigits[", 2, ",", 1, ",", 44, "]=", -0.18520054806816688],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("form["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "45", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["8.27207042306273088`*^87",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "form[", 2, ",", 1, ",", 45, "]=", 8.2720704230627305*^+87],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("formexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "45", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["1.89356798259763863`*^88",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "formexact[", 2, ",", 1, ",", 45, "]=", 1.8935679825976385*^+88],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "45", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        RowBox[{"-", 
          StyleBox["1.0279042289352418`",
            StyleBoxAutoDelete->True,
            PrintPrecision->2]}]}],
      SequenceForm[ 
      "exactdigits[", 2, ",", 1, ",", 45, "]=", -1.0279042289352418],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    \("   "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]0
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 2, ",", 2, ",", 0, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("formexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]0
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "formexact[", 2, ",", 2, ",", 0, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]0
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 2, ",", 2, ",", 0, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("form["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["1.`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "form[", 2, ",", 2, ",", 1, "]=", 1.0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("formexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["1.`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "formexact[", 2, ",", 2, ",", 1, "]=", 1.0],
      Editable->False]], "Print"],

Cell[BoxData[
    \(MantissaExponent::"realx" \( : \ \) 
      "\!\(1\) is not an inexact real number."\)], "Message"],

Cell[BoxData[
    \(Part::"partw" \( : \ \) 
      "Part \!\(2\) of \!\(MantissaExponent[1]\) does not exist."\)], 
  "Message"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        InterpretationBox["\[Infinity]",
          DirectedInfinity[ 1]]}],
      SequenceForm[ "exactdigits[", 2, ",", 2, ",", 1, "]=", 
        DirectedInfinity[ 1]],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("form["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["11.4285714285714279`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "form[", 2, ",", 2, ",", 2, "]=", 11.428571428571429],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("formexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["11.4285714285714279`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "formexact[", 2, ",", 2, ",", 2, "]=", 11.428571428571429],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        InterpretationBox["\[Infinity]",
          DirectedInfinity[ 1]]}],
      SequenceForm[ "exactdigits[", 2, ",", 2, ",", 2, "]=", 
        DirectedInfinity[ 1]],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("form["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["192.000000000000028`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "form[", 2, ",", 2, ",", 3, "]=", 192.00000000000003],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("formexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["191.999999999999992`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "formexact[", 2, ",", 2, ",", 3, "]=", 192.0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["15.5463498048791493`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 2, ",", 2, ",", 3, "]=", 15.546349804879149],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("form["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "4", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["4332.30769230769396`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "form[", 2, ",", 2, ",", 4, "]=", 4332.3076923076942],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("formexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "4", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["4332.30769230769219`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "formexact[", 2, ",", 2, ",", 4, "]=", 4332.3076923076924],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "4", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["14.7401698308952644`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 2, ",", 2, ",", 4, "]=", 14.740169830895265],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("form["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "5", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["123200.000000000065`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "form[", 2, ",", 2, ",", 5, "]=", 123200.00000000006],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("formexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "5", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["123199.999999999998`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "formexact[", 2, ",", 2, ",", 5, "]=", 123200.0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "5", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["15.2350198525753599`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 2, ",", 2, ",", 5, "]=", 15.235019852575359],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("form["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "6", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["4.2328926315789479`*^6",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "form[", 2, ",", 2, ",", 6, "]=", 4232892.6315789483],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("formexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "6", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["4.23289263157894701`*^6",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "formexact[", 2, ",", 2, ",", 6, "]=", 4232892.6315789474],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "6", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["15.030899869919434`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 2, ",", 2, ",", 6, "]=", 15.030899869919434],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("form["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "7", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["1.70598399999999772`*^8",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "form[", 2, ",", 2, ",", 7, "]=", 170598399.99999976],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("formexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "7", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["1.70598400000000012`*^8",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "formexact[", 2, ",", 2, ",", 7, "]=", 170598400.0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "7", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["14.6226599046075866`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 2, ",", 2, ",", 7, "]=", 14.622659904607586],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("form["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "8", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["7.89236940799999331`*^9",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "form[", 2, ",", 2, ",", 8, "]=", 7892369407.9999924],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("formexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "8", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["7.89236940800000041`*^9",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "formexact[", 2, ",", 2, ",", 8, "]=", 7892369408.0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "8", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["14.1175099262876795`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 2, ",", 2, ",", 8, "]=", 14.11750992628768],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("form["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "9", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["4.12235366400005887`*^11",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "form[", 2, ",", 2, ",", 9, "]=", 412235366400.00586],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("formexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "9", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["4.12235366400000025`*^11",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "formexact[", 2, ",", 2, ",", 9, "]=", 412235366400.0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "9", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["13.2321487062561682`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 2, ",", 2, ",", 9, "]=", 13.232148706256169],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("form["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "10", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["2.39953489259368746`*^13",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "form[", 2, ",", 2, ",", 10, "]=", 23995348925936.875],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("formexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "10", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["2.39953489259354801`*^13",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "formexact[", 2, ",", 2, ",", 10, "]=", 23995348925935.484],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "10", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["12.8567899673389751`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 2, ",", 2, ",", 10, "]=", 12.856789967338974],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("form["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "11", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["1.54021910282260794`*^15",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "form[", 2, ",", 2, ",", 11, "]=", 1540219102822608.0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("formexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "11", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["1.54021910282240011`*^15",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "formexact[", 2, ",", 2, ",", 11, "]=", 1540219102822400.0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "11", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["12.6819366650372389`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 2, ",", 2, ",", 11, "]=", 12.681936665037238],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("form["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "12", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["1.08080239745990279`*^17",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "form[", 2, ",", 2, ",", 12, "]=", 1.0808023974599027*^+17],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("formexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "12", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["1.08080239745964989`*^17",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "formexact[", 2, ",", 2, ",", 12, "]=", 1.0808023974596498*^+17],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "12", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["12.596948147411866`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 2, ",", 2, ",", 12, "]=", 12.596948147411867],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("form["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "13", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["8.23121092532226406`*^18",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "form[", 2, ",", 2, ",", 13, "]=", 8.2312109253222646*^+18],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("formexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "13", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["8.23121092531978248`*^18",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "formexact[", 2, ",", 2, ",", 13, "]=", 8.2312109253197824*^+18],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "13", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["11.6051674278659389`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 2, ",", 2, ",", 13, "]=", 11.60516742786594],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("form["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "14", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["6.76166736477193985`*^20",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "form[", 2, ",", 2, ",", 14, "]=", 6.7616673647719403*^+20],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("formexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "14", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["6.76166736477074081`*^20",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "formexact[", 2, ",", 2, ",", 14, "]=", 6.761667364770741*^+20],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "14", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["11.9210689796458723`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 2, ",", 2, ",", 14, "]=", 11.921068979645872],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("form["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "15", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["5.95950682646269491`*^22",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "form[", 2, ",", 2, ",", 15, "]=", 5.9595068264626944*^+22],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("formexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "15", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["5.95950682646564011`*^22",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "formexact[", 2, ",", 2, ",", 15, "]=", 5.9595068264656404*^+22],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "15", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["11.5307555924943683`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 2, ",", 2, ",", 15, "]=", 11.530755592494369],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("form["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "16", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["5.60955809906384228`*^24",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "form[", 2, ",", 2, ",", 16, "]=", 5.6095580990638433*^+24],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("formexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "16", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["5.60955809907753621`*^24",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "formexact[", 2, ",", 2, ",", 16, "]=", 5.6095580990775356*^+24],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "16", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["10.8635218260285281`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 2, ",", 2, ",", 16, "]=", 10.863521826028528],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("form["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "17", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["5.61630035636652102`*^26",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "form[", 2, ",", 2, ",", 17, "]=", 5.6163003563665214*^+26],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("formexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "17", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["5.61630035640815883`*^26",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "formexact[", 2, ",", 2, ",", 17, "]=", 5.6163003564081579*^+26],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "17", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["10.3805263714177065`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 2, ",", 2, ",", 17, "]=", 10.380526371417707],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("form["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "18", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["5.95964552032349192`*^28",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "form[", 2, ",", 2, ",", 18, "]=", 5.9596455203234923*^+28],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("formexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "18", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["5.95964552044269257`*^28",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "formexact[", 2, ",", 2, ",", 18, "]=", 5.9596455204426926*^+28],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "18", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["9.92372281701935676`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 2, ",", 2, ",", 18, "]=", 9.9237228170193568],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("form["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "19", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["6.68119647200435551`*^30",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "form[", 2, ",", 2, ",", 19, "]=", 6.681196472004355*^+30],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("formexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "19", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["6.68119647234303393`*^30",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "formexact[", 2, ",", 2, ",", 19, "]=", 6.6811964723430336*^+30],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "19", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["9.47021227841191759`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 2, ",", 2, ",", 19, "]=", 9.4702122784119176],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("form["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "20", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["7.89061408996743551`*^32",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "form[", 2, ",", 2, ",", 20, "]=", 7.8906140899674354*^+32],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("formexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "20", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["7.89061409089141108`*^32",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "formexact[", 2, ",", 2, ",", 20, "]=", 7.8906140908914112*^+32],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "20", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["9.03433940642258903`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 2, ",", 2, ",", 20, "]=", 9.034339406422589],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("form["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "21", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["9.79200550283517046`*^34",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "form[", 2, ",", 2, ",", 21, "]=", 9.7920055028351686*^+34],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("formexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "21", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["9.79200550510589984`*^34",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "formexact[", 2, ",", 2, ",", 21, "]=", 9.7920055051059*^+34],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "21", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["8.64383421987551869`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 2, ",", 2, ",", 21, "]=", 8.6438342198755187],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("form["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "22", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["1.27386544920132238`*^37",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "form[", 2, ",", 2, ",", 22, "]=", 1.2738654492013223*^+37],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("formexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "22", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["1.27386544964789183`*^37",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "formexact[", 2, ",", 2, ",", 22, "]=", 1.2738654496478919*^+37],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "22", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["9.35011080381051229`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 2, ",", 2, ",", 22, "]=", 9.3501108038105123],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("form["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "23", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["1.73358198320383438`*^39",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "form[", 2, ",", 2, ",", 23, "]=", 1.7335819832038341*^+39],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("formexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "23", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["1.73358198360653625`*^39",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "formexact[", 2, ",", 2, ",", 23, "]=", 1.7335819836065363*^+39],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "23", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["9.39501593582964389`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 2, ",", 2, ",", 23, "]=", 9.3950159358296439],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("form["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "24", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["2.4631525810397008`*^41",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "form[", 2, ",", 2, ",", 24, "]=", 2.463152581039701*^+41],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("formexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "24", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["2.46315257897066874`*^41",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "formexact[", 2, ",", 2, ",", 24, "]=", 2.4631525789706692*^+41],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "24", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["8.6842328221381777`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 2, ",", 2, ",", 24, "]=", 8.6842328221381777],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("form["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "25", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["3.64746444386017731`*^43",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "form[", 2, ",", 2, ",", 25, "]=", 3.6474644438601772*^+43],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("formexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "25", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["3.64746442752180755`*^43",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "formexact[", 2, ",", 2, ",", 25, "]=", 3.6474644275218079*^+43],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "25", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["7.78679129219663224`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 2, ",", 2, ",", 25, "]=", 7.7867912921966322],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("form["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "26", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["5.61993939321622626`*^45",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "form[", 2, ",", 2, ",", 26, "]=", 5.6199393932162262*^+45],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("formexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "26", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["5.61993931722833384`*^45",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "formexact[", 2, ",", 2, ",", 26, "]=", 5.6199393172283345*^+45],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "26", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["7.11925560514816879`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 2, ",", 2, ",", 26, "]=", 7.1192556051481688],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("form["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "27", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["8.99612078068309628`*^47",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "form[", 2, ",", 2, ",", 27, "]=", 8.996120780683095*^+47],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("formexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "27", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["8.99612049804730773`*^47",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "formexact[", 2, ",", 2, ",", 27, "]=", 8.9961204980473083*^+47],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "27", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["6.54877284959592742`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 2, ",", 2, ",", 27, "]=", 6.5487728495959274],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("form["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "28", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["1.49400679004567322`*^50",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "form[", 2, ",", 2, ",", 28, "]=", 1.4940067900456731*^+50],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("formexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "28", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["1.49400670245915412`*^50",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "formexact[", 2, ",", 2, ",", 28, "]=", 1.4940067024591542*^+50],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "28", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["7.05756273389481236`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 2, ",", 2, ",", 28, "]=", 7.0575627338948124],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("form["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "29", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["2.57073463280608427`*^52",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "form[", 2, ",", 2, ",", 29, "]=", 2.5707346328060845*^+52],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("formexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "29", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["2.57073442251880024`*^52",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "formexact[", 2, ",", 2, ",", 29, "]=", 2.5707344225187995*^+52],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "29", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["6.67718698599149718`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 2, ",", 2, ",", 29, "]=", 6.6771869859914972],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("form["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "30", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["4.57764144975981679`*^54",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "form[", 2, ",", 2, ",", 30, "]=", 4.5776414497598171*^+54],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("formexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "30", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["4.57764122709372589`*^54",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "formexact[", 2, ",", 2, ",", 30, "]=", 4.5776412270937261*^+54],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "30", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["6.65234591518947127`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 2, ",", 2, ",", 30, "]=", 6.6523459151894713],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("form["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "31", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["8.42584515378925935`*^56",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "form[", 2, ",", 2, ",", 31, "]=", 8.4258451537892611*^+56],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("formexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "31", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["8.42584668758928145`*^56",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "formexact[", 2, ",", 2, ",", 31, "]=", 8.425846687589282*^+56],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "31", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["5.81423126066857776`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 2, ",", 2, ",", 31, "]=", 5.8142312606685778],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("form["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "32", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["1.6014417795283502`*^59",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "form[", 2, ",", 2, ",", 32, "]=", 1.6014417795283506*^+59],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("formexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "32", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["1.60144326534453789`*^59",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "formexact[", 2, ",", 2, ",", 32, "]=", 1.6014432653445384*^+59],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "32", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["5.82803491438160392`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 2, ",", 2, ",", 32, "]=", 5.8280349143816039],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("form["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "33", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["3.13980082362567936`*^61",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "form[", 2, ",", 2, ",", 33, "]=", 3.1398008236256797*^+61],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("formexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "33", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["3.13980968407531824`*^61",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "formexact[", 2, ",", 2, ",", 33, "]=", 3.1398096840753185*^+61],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "33", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["5.05254423853386924`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 2, ",", 2, ",", 33, "]=", 5.0525442385338692],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("form["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "34", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["6.34423694189455567`*^63",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "form[", 2, ",", 2, ",", 34, "]=", 6.3442369418945557*^+63],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("formexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "34", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["6.34428152698714065`*^63",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "formexact[", 2, ",", 2, ",", 34, "]=", 6.3442815269871404*^+63],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "34", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["4.35081032717189941`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 2, ",", 2, ",", 34, "]=", 4.3508103271718994],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("form["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "35", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["1.31995611837295845`*^66",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "form[", 2, ",", 2, ",", 35, "]=", 1.3199561183729584*^+66],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("formexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "35", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["1.31997670926638077`*^66",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "formexact[", 2, ",", 2, ",", 35, "]=", 1.3199767092663809*^+66],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "35", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["4.6863248092801939`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 2, ",", 2, ",", 35, "]=", 4.6863248092801939],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("form["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "36", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["2.82539936547934278`*^68",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "form[", 2, ",", 2, ",", 36, "]=", 2.8253993654793425*^+68],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("formexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "36", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["2.82549059037470318`*^68",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "formexact[", 2, ",", 2, ",", 36, "]=", 2.8254905903747029*^+68],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "36", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["4.03988662612121629`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 2, ",", 2, ",", 36, "]=", 4.0398866261212163],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("form["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "37", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["6.21721752591605181`*^70",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "form[", 2, ",", 2, ",", 37, "]=", 6.2172175259160528*^+70],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("formexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "37", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["6.21762098515838079`*^70",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "formexact[", 2, ",", 2, ",", 37, "]=", 6.2176209851583805*^+70],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "37", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["3.39420033139107601`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 2, ",", 2, ",", 37, "]=", 3.394200331391076],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("form["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "38", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["1.40532540615691159`*^73",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "form[", 2, ",", 2, ",", 38, "]=", 1.4053254061569116*^+73],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("formexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "38", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["1.40551258526451183`*^73",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "formexact[", 2, ",", 2, ",", 38, "]=", 1.405512585264512*^+73],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "38", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["3.72774262760754027`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 2, ",", 2, ",", 38, "]=", 3.7277426276075403],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("form["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "39", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["3.26055145624945019`*^75",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "form[", 2, ",", 2, ",", 39, "]=", 3.2605514562494498*^+75],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("formexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "39", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["3.26151640325475034`*^75",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "formexact[", 2, ",", 2, ",", 39, "]=", 3.2615164032547505*^+75],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "39", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["3.01549653736861955`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 2, ",", 2, ",", 39, "]=", 3.0154965373686196],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("form["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "40", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["7.75831261902605184`*^77",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "form[", 2, ",", 2, ",", 40, "]=", 7.7583126190260511*^+77],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("formexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "40", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["7.76405396643410927`*^77",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "formexact[", 2, ",", 2, ",", 40, "]=", 7.76405396643411*^+77],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "40", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["2.24098617324420956`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 2, ",", 2, ",", 40, "]=", 2.2409861732442096],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("form["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "41", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["1.89091654192328473`*^80",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "form[", 2, ",", 2, ",", 41, "]=", 1.8909165419232849*^+80],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("formexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "41", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["1.89481110917440087`*^80",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "formexact[", 2, ",", 2, ",", 41, "]=", 1.8948111091744007*^+80],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "41", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["2.40954079239287466`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 2, ",", 2, ",", 41, "]=", 2.4095407923928747],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("form["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "42", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["4.70926819750162017`*^82",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "form[", 2, ",", 2, ",", 42, "]=", 4.7092681975016213*^+82],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("formexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "42", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["4.73793751516241545`*^82",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "formexact[", 2, ",", 2, ",", 42, "]=", 4.737937515162415*^+82],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "42", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["1.54258264328228733`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 2, ",", 2, ",", 42, "]=", 1.5425826432822873],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("form["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "43", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["1.19132061340663808`*^85",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "form[", 2, ",", 2, ",", 43, "]=", 1.1913206134066383*^+85],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("formexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "43", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["1.21313414893723425`*^85",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "formexact[", 2, ",", 2, ",", 43, "]=", 1.2131341489372342*^+85],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "43", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["1.66127393841084369`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 2, ",", 2, ",", 43, "]=", 1.6612739384108437],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("form["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "44", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["3.01262207775412305`*^87",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "form[", 2, ",", 2, ",", 44, "]=", 3.0126220777541229*^+87],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("formexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "44", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["3.17896723371795131`*^87",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "formexact[", 2, ",", 2, ",", 44, "]=", 3.1789672337179518*^+87],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "44", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["0.778989841436654728`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 2, ",", 2, ",", 44, "]=", 0.77898984143665473],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("form["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "45", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["7.26882114667791068`*^89",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "form[", 2, ",", 2, ",", 45, "]=", 7.2688211466779103*^+89],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("formexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "45", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["8.52105592168937242`*^89",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "formexact[", 2, ",", 2, ",", 45, "]=", 8.5210559216893724*^+89],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "45", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        RowBox[{"-", 
          StyleBox["0.0976857601309859546`",
            StyleBoxAutoDelete->True,
            PrintPrecision->2]}]}],
      SequenceForm[ 
      "exactdigits[", 2, ",", 2, ",", 45, "]=", -0.097685760130985955],
      Editable->False]], "Print"],

Cell[BoxData[
    \("    "\)], "Print"],

Cell[BoxData[
    \({61.4166666666666571`\ Second, Null}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(MemoryInUse[]\)], "Input"],

Cell[BoxData[
    \(1015992\)], "Output"]
}, Open  ]]
}, Closed]]
}, Closed]]
},
FrontEndVersion->"Macintosh 3.0",
ScreenRectangle->{{0, 832}, {0, 604}},
WindowSize->{764, 580},
WindowMargins->{{4, Automatic}, {Automatic, 1}},
PrintingCopies->1,
PrintingPageRange->{1, Automatic},
MacintoshSystemPageSetup->"\<\
00<0004/0B`000003;H8`_n3ohL==`Tf0fL5N`?P0080004/0B`000000]P2:001
0000I00000400`<30?l00BL?00400@:OYV0000000000060801T1T00000000000
00000000004000000000000000000000\>"
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{
Cell[1709, 49, 1286, 21, 628, "Subsection"],

Cell[CellGroupData[{
Cell[3020, 74, 143, 4, 68, "Section"],

Cell[CellGroupData[{
Cell[3188, 82, 107, 3, 44, "Subsection"],
Cell[3298, 87, 62, 1, 27, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[3397, 93, 122, 4, 44, "Subsection"],
Cell[3522, 99, 88, 1, 27, "Input"],
Cell[3613, 102, 142, 2, 43, "Input"],

Cell[CellGroupData[{
Cell[3780, 108, 361, 6, 75, "Input"],
Cell[4144, 116, 332, 7, 38, "Print"],
Cell[4479, 125, 334, 7, 38, "Print"],
Cell[4816, 134, 342, 7, 38, "Print"],
Cell[5161, 143, 336, 7, 38, "Print"],
Cell[5500, 152, 350, 7, 38, "Print"],
Cell[5853, 161, 342, 7, 38, "Print"],
Cell[6198, 170, 358, 7, 38, "Print"],
Cell[6559, 179, 344, 7, 38, "Print"],
Cell[6906, 188, 356, 7, 38, "Print"],
Cell[7265, 197, 37, 1, 22, "Print"],
Cell[7305, 200, 328, 7, 38, "Print"],
Cell[7636, 209, 334, 7, 38, "Print"],
Cell[7973, 218, 338, 7, 38, "Print"],
Cell[8314, 227, 338, 7, 38, "Print"],
Cell[8655, 236, 346, 7, 38, "Print"],
Cell[9004, 245, 344, 7, 38, "Print"],
Cell[9351, 254, 348, 7, 38, "Print"],
Cell[9702, 263, 352, 7, 38, "Print"],
Cell[10057, 272, 346, 7, 38, "Print"],
Cell[10406, 281, 350, 7, 38, "Print"],
Cell[10759, 290, 37, 1, 22, "Print"]
}, Open  ]],

Cell[CellGroupData[{
Cell[10833, 296, 161, 2, 43, "Input"],
Cell[10997, 300, 243, 5, 22, "Print"],
Cell[11243, 307, 271, 6, 38, "Print"],
Cell[11517, 315, 277, 6, 38, "Print"],
Cell[11797, 323, 275, 6, 38, "Print"],
Cell[12075, 331, 275, 6, 38, "Print"],
Cell[12353, 339, 281, 6, 38, "Print"],
Cell[12637, 347, 281, 6, 38, "Print"],
Cell[12921, 355, 281, 6, 38, "Print"],
Cell[13205, 363, 277, 6, 38, "Print"],
Cell[13485, 371, 277, 6, 38, "Print"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{
Cell[13811, 383, 131, 3, 28, "Subsection"],

Cell[CellGroupData[{
Cell[13967, 390, 142, 2, 43, "Input"],
Cell[14112, 394, 175, 3, 37, "Message"]
}, Open  ]],

Cell[CellGroupData[{
Cell[14324, 402, 336, 6, 91, "Input"],
Cell[14663, 410, 314, 7, 22, "Print"],
Cell[14980, 419, 314, 7, 22, "Print"],
Cell[15297, 428, 342, 8, 38, "Print"],
Cell[15642, 438, 316, 7, 22, "Print"],
Cell[15961, 447, 350, 8, 38, "Print"],
Cell[16314, 457, 322, 7, 22, "Print"],
Cell[16639, 466, 356, 8, 38, "Print"],
Cell[16998, 476, 328, 7, 22, "Print"],
Cell[17329, 485, 330, 7, 22, "Print"],
Cell[17662, 494, 334, 7, 22, "Print"],
Cell[17999, 503, 370, 8, 38, "Print"],
Cell[18372, 513, 38, 1, 22, "Print"],
Cell[18413, 516, 314, 7, 22, "Print"],
Cell[18730, 525, 314, 7, 22, "Print"],
Cell[19047, 534, 342, 8, 38, "Print"],
Cell[19392, 544, 318, 7, 22, "Print"],
Cell[19713, 553, 350, 8, 38, "Print"],
Cell[20066, 563, 324, 7, 22, "Print"],
Cell[20393, 572, 356, 8, 38, "Print"],
Cell[20752, 582, 330, 7, 22, "Print"],
Cell[21085, 591, 332, 7, 22, "Print"],
Cell[21420, 600, 336, 7, 22, "Print"],
Cell[21759, 609, 372, 8, 38, "Print"],
Cell[22134, 619, 38, 1, 22, "Print"],
Cell[22175, 622, 70, 1, 26, "Output"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{
Cell[22294, 629, 69, 0, 28, "Subsection"],
Cell[22366, 631, 138, 2, 43, "Input"],

Cell[CellGroupData[{
Cell[22529, 637, 46, 1, 27, "Input"],
Cell[22578, 640, 40, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[22655, 646, 120, 4, 27, "Input"],
Cell[22778, 652, 38, 1, 22, "Print"],
Cell[22819, 655, 298, 6, 22, "Print"],
Cell[23120, 663, 308, 6, 22, "Print"],
Cell[23431, 671, 39, 1, 22, "Print"],
Cell[23473, 674, 298, 6, 22, "Print"],
Cell[23774, 682, 308, 6, 22, "Print"],
Cell[24085, 690, 39, 1, 22, "Print"],
Cell[24127, 693, 326, 7, 38, "Print"],
Cell[24456, 702, 336, 7, 38, "Print"],
Cell[24795, 711, 39, 1, 22, "Print"],
Cell[24837, 714, 300, 6, 22, "Print"],
Cell[25140, 722, 310, 6, 22, "Print"],
Cell[25453, 730, 39, 1, 22, "Print"],
Cell[25495, 733, 334, 7, 38, "Print"],
Cell[25832, 742, 344, 7, 38, "Print"],
Cell[26179, 751, 39, 1, 22, "Print"],
Cell[26221, 754, 306, 6, 22, "Print"],
Cell[26530, 762, 316, 6, 22, "Print"],
Cell[26849, 770, 39, 1, 22, "Print"],
Cell[26891, 773, 340, 7, 38, "Print"],
Cell[27234, 782, 350, 7, 38, "Print"],
Cell[27587, 791, 39, 1, 22, "Print"],
Cell[27629, 794, 312, 6, 22, "Print"],
Cell[27944, 802, 322, 6, 22, "Print"],
Cell[28269, 810, 39, 1, 22, "Print"],
Cell[28311, 813, 314, 6, 22, "Print"],
Cell[28628, 821, 324, 6, 22, "Print"],
Cell[28955, 829, 39, 1, 22, "Print"],
Cell[28997, 832, 318, 6, 22, "Print"],
Cell[29318, 840, 328, 6, 22, "Print"],
Cell[29649, 848, 39, 1, 22, "Print"],
Cell[29691, 851, 354, 7, 38, "Print"],
Cell[30048, 860, 364, 7, 38, "Print"],
Cell[30415, 869, 39, 1, 22, "Print"],
Cell[30457, 872, 38, 1, 22, "Print"],
Cell[30498, 875, 298, 6, 22, "Print"],
Cell[30799, 883, 308, 6, 22, "Print"],
Cell[31110, 891, 39, 1, 22, "Print"],
Cell[31152, 894, 298, 6, 22, "Print"],
Cell[31453, 902, 308, 6, 22, "Print"],
Cell[31764, 910, 39, 1, 22, "Print"],
Cell[31806, 913, 326, 7, 38, "Print"],
Cell[32135, 922, 336, 7, 38, "Print"],
Cell[32474, 931, 39, 1, 22, "Print"],
Cell[32516, 934, 302, 6, 22, "Print"],
Cell[32821, 942, 312, 6, 22, "Print"],
Cell[33136, 950, 39, 1, 22, "Print"],
Cell[33178, 953, 334, 7, 38, "Print"],
Cell[33515, 962, 344, 7, 38, "Print"],
Cell[33862, 971, 39, 1, 22, "Print"],
Cell[33904, 974, 308, 6, 22, "Print"],
Cell[34215, 982, 318, 6, 22, "Print"],
Cell[34536, 990, 39, 1, 22, "Print"],
Cell[34578, 993, 340, 7, 38, "Print"],
Cell[34921, 1002, 350, 7, 38, "Print"],
Cell[35274, 1011, 39, 1, 22, "Print"],
Cell[35316, 1014, 314, 6, 22, "Print"],
Cell[35633, 1022, 324, 6, 22, "Print"],
Cell[35960, 1030, 39, 1, 22, "Print"],
Cell[36002, 1033, 316, 6, 22, "Print"],
Cell[36321, 1041, 326, 6, 22, "Print"],
Cell[36650, 1049, 39, 1, 22, "Print"],
Cell[36692, 1052, 320, 6, 22, "Print"],
Cell[37015, 1060, 330, 6, 22, "Print"],
Cell[37348, 1068, 39, 1, 22, "Print"],
Cell[37390, 1071, 356, 7, 38, "Print"],
Cell[37749, 1080, 366, 7, 38, "Print"],
Cell[38118, 1089, 39, 1, 22, "Print"],
Cell[38160, 1092, 55, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[38252, 1098, 46, 1, 27, "Input"],
Cell[38301, 1101, 40, 1, 26, "Output"]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[38402, 1109, 174, 4, 48, "Section"],

Cell[CellGroupData[{
Cell[38601, 1117, 106, 3, 44, "Subsection"],
Cell[38710, 1122, 62, 1, 27, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[38809, 1128, 69, 0, 44, "Subsection"],
Cell[38881, 1130, 142, 2, 43, "Input"],

Cell[CellGroupData[{
Cell[39048, 1136, 46, 1, 27, "Input"],
Cell[39097, 1139, 40, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[39174, 1145, 128, 4, 27, "Input"],
Cell[39305, 1151, 38, 1, 22, "Print"],
Cell[39346, 1154, 475, 11, 22, "Print"],
Cell[39824, 1167, 485, 11, 22, "Print"],
Cell[40312, 1180, 118, 2, 22, "Message"],
Cell[40433, 1184, 128, 3, 22, "Message"],
Cell[40564, 1189, 498, 11, 22, "Print"],
Cell[41065, 1202, 39, 1, 22, "Print"],
Cell[41107, 1205, 475, 11, 22, "Print"],
Cell[41585, 1218, 485, 11, 22, "Print"],
Cell[42073, 1231, 498, 11, 22, "Print"],
Cell[42574, 1244, 39, 1, 22, "Print"],
Cell[42616, 1247, 507, 11, 22, "Print"],
Cell[43126, 1260, 524, 12, 22, "Print"],
Cell[43653, 1274, 498, 11, 22, "Print"],
Cell[44154, 1287, 39, 1, 22, "Print"],
Cell[44196, 1290, 493, 11, 22, "Print"],
Cell[44692, 1303, 503, 11, 22, "Print"],
Cell[45198, 1316, 498, 11, 22, "Print"],
Cell[45699, 1329, 39, 1, 22, "Print"],
Cell[45741, 1332, 507, 11, 22, "Print"],
Cell[46251, 1345, 524, 12, 22, "Print"],
Cell[46778, 1359, 526, 12, 22, "Print"],
Cell[47307, 1373, 39, 1, 22, "Print"],
Cell[47349, 1376, 507, 11, 22, "Print"],
Cell[47859, 1389, 506, 11, 22, "Print"],
Cell[48368, 1402, 527, 12, 22, "Print"],
Cell[48898, 1416, 39, 1, 22, "Print"],
Cell[48940, 1419, 507, 11, 22, "Print"],
Cell[49450, 1432, 524, 12, 22, "Print"],
Cell[49977, 1446, 526, 12, 22, "Print"],
Cell[50506, 1460, 39, 1, 22, "Print"],
Cell[50548, 1463, 510, 11, 24, "Print"],
Cell[51061, 1476, 512, 11, 24, "Print"],
Cell[51576, 1489, 527, 12, 22, "Print"],
Cell[52106, 1503, 39, 1, 22, "Print"],
Cell[52148, 1506, 510, 11, 24, "Print"],
Cell[52661, 1519, 513, 11, 24, "Print"],
Cell[53177, 1532, 527, 12, 22, "Print"],
Cell[53707, 1546, 39, 1, 22, "Print"],
Cell[53749, 1549, 511, 11, 24, "Print"],
Cell[54263, 1562, 516, 11, 24, "Print"],
Cell[54782, 1575, 527, 12, 22, "Print"],
Cell[55312, 1589, 39, 1, 22, "Print"],
Cell[55354, 1592, 513, 11, 24, "Print"],
Cell[55870, 1605, 530, 12, 24, "Print"],
Cell[56403, 1619, 529, 12, 22, "Print"],
Cell[56935, 1633, 39, 1, 22, "Print"],
Cell[56977, 1636, 513, 11, 24, "Print"],
Cell[57493, 1649, 529, 12, 24, "Print"],
Cell[58025, 1663, 529, 12, 22, "Print"],
Cell[58557, 1677, 39, 1, 22, "Print"],
Cell[58599, 1680, 513, 11, 24, "Print"],
Cell[59115, 1693, 530, 12, 24, "Print"],
Cell[59648, 1707, 529, 12, 22, "Print"],
Cell[60180, 1721, 39, 1, 22, "Print"],
Cell[60222, 1724, 525, 12, 24, "Print"],
Cell[60750, 1738, 534, 12, 24, "Print"],
Cell[61287, 1752, 529, 12, 22, "Print"],
Cell[61819, 1766, 39, 1, 22, "Print"],
Cell[61861, 1769, 525, 12, 24, "Print"],
Cell[62389, 1783, 535, 12, 24, "Print"],
Cell[62927, 1797, 529, 12, 22, "Print"],
Cell[63459, 1811, 39, 1, 22, "Print"],
Cell[63501, 1814, 525, 12, 24, "Print"],
Cell[64029, 1828, 534, 12, 24, "Print"],
Cell[64566, 1842, 529, 12, 22, "Print"],
Cell[65098, 1856, 39, 1, 22, "Print"],
Cell[65140, 1859, 524, 12, 24, "Print"],
Cell[65667, 1873, 535, 12, 24, "Print"],
Cell[66205, 1887, 529, 12, 22, "Print"],
Cell[66737, 1901, 39, 1, 22, "Print"],
Cell[66779, 1904, 525, 12, 24, "Print"],
Cell[67307, 1918, 535, 12, 24, "Print"],
Cell[67845, 1932, 529, 12, 22, "Print"],
Cell[68377, 1946, 39, 1, 22, "Print"],
Cell[68419, 1949, 525, 12, 24, "Print"],
Cell[68947, 1963, 534, 12, 24, "Print"],
Cell[69484, 1977, 528, 12, 22, "Print"],
Cell[70015, 1991, 39, 1, 22, "Print"],
Cell[70057, 1994, 524, 12, 24, "Print"],
Cell[70584, 2008, 534, 12, 24, "Print"],
Cell[71121, 2022, 529, 12, 22, "Print"],
Cell[71653, 2036, 39, 1, 22, "Print"],
Cell[71695, 2039, 525, 12, 24, "Print"],
Cell[72223, 2053, 535, 12, 24, "Print"],
Cell[72761, 2067, 528, 12, 22, "Print"],
Cell[73292, 2081, 39, 1, 22, "Print"],
Cell[73334, 2084, 525, 12, 24, "Print"],
Cell[73862, 2098, 534, 12, 24, "Print"],
Cell[74399, 2112, 529, 12, 22, "Print"],
Cell[74931, 2126, 39, 1, 22, "Print"],
Cell[74973, 2129, 525, 12, 24, "Print"],
Cell[75501, 2143, 535, 12, 24, "Print"],
Cell[76039, 2157, 529, 12, 22, "Print"],
Cell[76571, 2171, 39, 1, 22, "Print"],
Cell[76613, 2174, 525, 12, 24, "Print"],
Cell[77141, 2188, 535, 12, 24, "Print"],
Cell[77679, 2202, 528, 12, 22, "Print"],
Cell[78210, 2216, 39, 1, 22, "Print"],
Cell[78252, 2219, 525, 12, 24, "Print"],
Cell[78780, 2233, 534, 12, 24, "Print"],
Cell[79317, 2247, 529, 12, 22, "Print"],
Cell[79849, 2261, 39, 1, 22, "Print"],
Cell[79891, 2264, 523, 12, 24, "Print"],
Cell[80417, 2278, 534, 12, 24, "Print"],
Cell[80954, 2292, 529, 12, 22, "Print"],
Cell[81486, 2306, 39, 1, 22, "Print"],
Cell[81528, 2309, 522, 12, 24, "Print"],
Cell[82053, 2323, 533, 12, 24, "Print"],
Cell[82589, 2337, 528, 12, 22, "Print"],
Cell[83120, 2351, 39, 1, 22, "Print"],
Cell[83162, 2354, 522, 12, 24, "Print"],
Cell[83687, 2368, 534, 12, 24, "Print"],
Cell[84224, 2382, 529, 12, 22, "Print"],
Cell[84756, 2396, 39, 1, 22, "Print"],
Cell[84798, 2399, 525, 12, 24, "Print"],
Cell[85326, 2413, 535, 12, 24, "Print"],
Cell[85864, 2427, 529, 12, 22, "Print"],
Cell[86396, 2441, 39, 1, 22, "Print"],
Cell[86438, 2444, 523, 12, 24, "Print"],
Cell[86964, 2458, 535, 12, 24, "Print"],
Cell[87502, 2472, 529, 12, 22, "Print"],
Cell[88034, 2486, 39, 1, 22, "Print"],
Cell[88076, 2489, 524, 12, 24, "Print"],
Cell[88603, 2503, 535, 12, 24, "Print"],
Cell[89141, 2517, 529, 12, 22, "Print"],
Cell[89673, 2531, 39, 1, 22, "Print"],
Cell[89715, 2534, 525, 12, 24, "Print"],
Cell[90243, 2548, 535, 12, 24, "Print"],
Cell[90781, 2562, 529, 12, 22, "Print"],
Cell[91313, 2576, 39, 1, 22, "Print"],
Cell[91355, 2579, 525, 12, 24, "Print"],
Cell[91883, 2593, 535, 12, 24, "Print"],
Cell[92421, 2607, 529, 12, 22, "Print"],
Cell[92953, 2621, 39, 1, 22, "Print"],
Cell[92995, 2624, 525, 12, 24, "Print"],
Cell[93523, 2638, 535, 12, 24, "Print"],
Cell[94061, 2652, 529, 12, 22, "Print"],
Cell[94593, 2666, 39, 1, 22, "Print"],
Cell[94635, 2669, 525, 12, 24, "Print"],
Cell[95163, 2683, 535, 12, 24, "Print"],
Cell[95701, 2697, 529, 12, 22, "Print"],
Cell[96233, 2711, 39, 1, 22, "Print"],
Cell[96275, 2714, 525, 12, 24, "Print"],
Cell[96803, 2728, 535, 12, 24, "Print"],
Cell[97341, 2742, 529, 12, 22, "Print"],
Cell[97873, 2756, 39, 1, 22, "Print"],
Cell[97915, 2759, 525, 12, 24, "Print"],
Cell[98443, 2773, 534, 12, 24, "Print"],
Cell[98980, 2787, 529, 12, 22, "Print"],
Cell[99512, 2801, 39, 1, 22, "Print"],
Cell[99554, 2804, 525, 12, 24, "Print"],
Cell[100082, 2818, 535, 12, 24, "Print"],
Cell[100620, 2832, 529, 12, 22, "Print"],
Cell[101152, 2846, 39, 1, 22, "Print"],
Cell[101194, 2849, 525, 12, 24, "Print"],
Cell[101722, 2863, 535, 12, 24, "Print"],
Cell[102260, 2877, 529, 12, 22, "Print"],
Cell[102792, 2891, 39, 1, 22, "Print"],
Cell[102834, 2894, 525, 12, 24, "Print"],
Cell[103362, 2908, 535, 12, 24, "Print"],
Cell[103900, 2922, 529, 12, 22, "Print"],
Cell[104432, 2936, 39, 1, 22, "Print"],
Cell[104474, 2939, 524, 12, 24, "Print"],
Cell[105001, 2953, 535, 12, 24, "Print"],
Cell[105539, 2967, 529, 12, 22, "Print"],
Cell[106071, 2981, 39, 1, 22, "Print"],
Cell[106113, 2984, 525, 12, 24, "Print"],
Cell[106641, 2998, 535, 12, 24, "Print"],
Cell[107179, 3012, 529, 12, 22, "Print"],
Cell[107711, 3026, 39, 1, 22, "Print"],
Cell[107753, 3029, 525, 12, 24, "Print"],
Cell[108281, 3043, 535, 12, 24, "Print"],
Cell[108819, 3057, 529, 12, 22, "Print"],
Cell[109351, 3071, 39, 1, 22, "Print"],
Cell[109393, 3074, 524, 12, 24, "Print"],
Cell[109920, 3088, 535, 12, 24, "Print"],
Cell[110458, 3102, 531, 12, 22, "Print"],
Cell[110992, 3116, 39, 1, 22, "Print"],
Cell[111034, 3119, 525, 12, 24, "Print"],
Cell[111562, 3133, 534, 12, 24, "Print"],
Cell[112099, 3147, 562, 13, 22, "Print"],
Cell[112664, 3162, 39, 1, 22, "Print"],
Cell[112706, 3165, 525, 12, 24, "Print"],
Cell[113234, 3179, 535, 12, 24, "Print"],
Cell[113772, 3193, 559, 13, 22, "Print"],
Cell[114334, 3208, 39, 1, 22, "Print"],
Cell[114376, 3211, 38, 1, 22, "Print"],
Cell[114417, 3214, 298, 6, 22, "Print"],
Cell[114718, 3222, 308, 6, 22, "Print"],
Cell[115029, 3230, 306, 6, 22, "Print"],
Cell[115338, 3238, 39, 1, 22, "Print"],
Cell[115380, 3241, 475, 11, 22, "Print"],
Cell[115858, 3254, 485, 11, 22, "Print"],
Cell[116346, 3267, 118, 2, 22, "Message"],
Cell[116467, 3271, 128, 3, 22, "Message"],
Cell[116598, 3276, 498, 11, 22, "Print"],
Cell[117099, 3289, 39, 1, 22, "Print"],
Cell[117141, 3292, 507, 11, 22, "Print"],
Cell[117651, 3305, 524, 12, 22, "Print"],
Cell[118178, 3319, 498, 11, 22, "Print"],
Cell[118679, 3332, 39, 1, 22, "Print"],
Cell[118721, 3335, 507, 11, 22, "Print"],
Cell[119231, 3348, 504, 11, 22, "Print"],
Cell[119738, 3361, 527, 12, 22, "Print"],
Cell[120268, 3375, 39, 1, 22, "Print"],
Cell[120310, 3378, 507, 11, 22, "Print"],
Cell[120820, 3391, 524, 12, 22, "Print"],
Cell[121347, 3405, 527, 12, 22, "Print"],
Cell[121877, 3419, 39, 1, 22, "Print"],
Cell[121919, 3422, 507, 11, 22, "Print"],
Cell[122429, 3435, 507, 11, 22, "Print"],
Cell[122939, 3448, 527, 12, 22, "Print"],
Cell[123469, 3462, 39, 1, 22, "Print"],
Cell[123511, 3465, 509, 11, 24, "Print"],
Cell[124023, 3478, 527, 12, 24, "Print"],
Cell[124553, 3492, 526, 12, 22, "Print"],
Cell[125082, 3506, 39, 1, 22, "Print"],
Cell[125124, 3509, 510, 11, 24, "Print"],
Cell[125637, 3522, 513, 11, 24, "Print"],
Cell[126153, 3535, 527, 12, 22, "Print"],
Cell[126683, 3549, 39, 1, 22, "Print"],
Cell[126725, 3552, 510, 11, 24, "Print"],
Cell[127238, 3565, 514, 11, 24, "Print"],
Cell[127755, 3578, 526, 12, 22, "Print"],
Cell[128284, 3592, 39, 1, 22, "Print"],
Cell[128326, 3595, 511, 11, 24, "Print"],
Cell[128840, 3608, 517, 11, 24, "Print"],
Cell[129360, 3621, 527, 12, 22, "Print"],
Cell[129890, 3635, 39, 1, 22, "Print"],
Cell[129932, 3638, 513, 11, 24, "Print"],
Cell[130448, 3651, 530, 12, 24, "Print"],
Cell[130981, 3665, 529, 12, 22, "Print"],
Cell[131513, 3679, 39, 1, 22, "Print"],
Cell[131555, 3682, 513, 11, 24, "Print"],
Cell[132071, 3695, 530, 12, 24, "Print"],
Cell[132604, 3709, 529, 12, 22, "Print"],
Cell[133136, 3723, 39, 1, 22, "Print"],
Cell[133178, 3726, 525, 12, 24, "Print"],
Cell[133706, 3740, 535, 12, 24, "Print"],
Cell[134244, 3754, 528, 12, 22, "Print"],
Cell[134775, 3768, 39, 1, 22, "Print"],
Cell[134817, 3771, 525, 12, 24, "Print"],
Cell[135345, 3785, 535, 12, 24, "Print"],
Cell[135883, 3799, 528, 12, 22, "Print"],
Cell[136414, 3813, 39, 1, 22, "Print"],
Cell[136456, 3816, 525, 12, 24, "Print"],
Cell[136984, 3830, 534, 12, 24, "Print"],
Cell[137521, 3844, 529, 12, 22, "Print"],
Cell[138053, 3858, 39, 1, 22, "Print"],
Cell[138095, 3861, 525, 12, 24, "Print"],
Cell[138623, 3875, 535, 12, 24, "Print"],
Cell[139161, 3889, 529, 12, 22, "Print"],
Cell[139693, 3903, 39, 1, 22, "Print"],
Cell[139735, 3906, 525, 12, 24, "Print"],
Cell[140263, 3920, 535, 12, 24, "Print"],
Cell[140801, 3934, 529, 12, 22, "Print"],
Cell[141333, 3948, 39, 1, 22, "Print"],
Cell[141375, 3951, 525, 12, 24, "Print"],
Cell[141903, 3965, 535, 12, 24, "Print"],
Cell[142441, 3979, 529, 12, 22, "Print"],
Cell[142973, 3993, 39, 1, 22, "Print"],
Cell[143015, 3996, 525, 12, 24, "Print"],
Cell[143543, 4010, 535, 12, 24, "Print"],
Cell[144081, 4024, 529, 12, 22, "Print"],
Cell[144613, 4038, 39, 1, 22, "Print"],
Cell[144655, 4041, 524, 12, 24, "Print"],
Cell[145182, 4055, 535, 12, 24, "Print"],
Cell[145720, 4069, 529, 12, 22, "Print"],
Cell[146252, 4083, 39, 1, 22, "Print"],
Cell[146294, 4086, 525, 12, 24, "Print"],
Cell[146822, 4100, 535, 12, 24, "Print"],
Cell[147360, 4114, 528, 12, 22, "Print"],
Cell[147891, 4128, 39, 1, 22, "Print"],
Cell[147933, 4131, 525, 12, 24, "Print"],
Cell[148461, 4145, 532, 12, 24, "Print"],
Cell[148996, 4159, 529, 12, 22, "Print"],
Cell[149528, 4173, 39, 1, 22, "Print"],
Cell[149570, 4176, 525, 12, 24, "Print"],
Cell[150098, 4190, 535, 12, 24, "Print"],
Cell[150636, 4204, 529, 12, 22, "Print"],
Cell[151168, 4218, 39, 1, 22, "Print"],
Cell[151210, 4221, 525, 12, 24, "Print"],
Cell[151738, 4235, 535, 12, 24, "Print"],
Cell[152276, 4249, 529, 12, 22, "Print"],
Cell[152808, 4263, 39, 1, 22, "Print"],
Cell[152850, 4266, 523, 12, 24, "Print"],
Cell[153376, 4280, 535, 12, 24, "Print"],
Cell[153914, 4294, 528, 12, 22, "Print"],
Cell[154445, 4308, 39, 1, 22, "Print"],
Cell[154487, 4311, 525, 12, 24, "Print"],
Cell[155015, 4325, 535, 12, 24, "Print"],
Cell[155553, 4339, 529, 12, 22, "Print"],
Cell[156085, 4353, 39, 1, 22, "Print"],
Cell[156127, 4356, 525, 12, 24, "Print"],
Cell[156655, 4370, 535, 12, 24, "Print"],
Cell[157193, 4384, 529, 12, 22, "Print"],
Cell[157725, 4398, 39, 1, 22, "Print"],
Cell[157767, 4401, 524, 12, 24, "Print"],
Cell[158294, 4415, 535, 12, 24, "Print"],
Cell[158832, 4429, 529, 12, 22, "Print"],
Cell[159364, 4443, 39, 1, 22, "Print"],
Cell[159406, 4446, 525, 12, 24, "Print"],
Cell[159934, 4460, 535, 12, 24, "Print"],
Cell[160472, 4474, 529, 12, 22, "Print"],
Cell[161004, 4488, 39, 1, 22, "Print"],
Cell[161046, 4491, 525, 12, 24, "Print"],
Cell[161574, 4505, 535, 12, 24, "Print"],
Cell[162112, 4519, 529, 12, 22, "Print"],
Cell[162644, 4533, 39, 1, 22, "Print"],
Cell[162686, 4536, 525, 12, 24, "Print"],
Cell[163214, 4550, 535, 12, 24, "Print"],
Cell[163752, 4564, 529, 12, 22, "Print"],
Cell[164284, 4578, 39, 1, 22, "Print"],
Cell[164326, 4581, 525, 12, 24, "Print"],
Cell[164854, 4595, 534, 12, 24, "Print"],
Cell[165391, 4609, 529, 12, 22, "Print"],
Cell[165923, 4623, 39, 1, 22, "Print"],
Cell[165965, 4626, 524, 12, 24, "Print"],
Cell[166492, 4640, 535, 12, 24, "Print"],
Cell[167030, 4654, 529, 12, 22, "Print"],
Cell[167562, 4668, 39, 1, 22, "Print"],
Cell[167604, 4671, 525, 12, 24, "Print"],
Cell[168132, 4685, 535, 12, 24, "Print"],
Cell[168670, 4699, 529, 12, 22, "Print"],
Cell[169202, 4713, 39, 1, 22, "Print"],
Cell[169244, 4716, 525, 12, 24, "Print"],
Cell[169772, 4730, 535, 12, 24, "Print"],
Cell[170310, 4744, 529, 12, 22, "Print"],
Cell[170842, 4758, 39, 1, 22, "Print"],
Cell[170884, 4761, 525, 12, 24, "Print"],
Cell[171412, 4775, 535, 12, 24, "Print"],
Cell[171950, 4789, 528, 12, 22, "Print"],
Cell[172481, 4803, 39, 1, 22, "Print"],
Cell[172523, 4806, 525, 12, 24, "Print"],
Cell[173051, 4820, 535, 12, 24, "Print"],
Cell[173589, 4834, 529, 12, 22, "Print"],
Cell[174121, 4848, 39, 1, 22, "Print"],
Cell[174163, 4851, 525, 12, 24, "Print"],
Cell[174691, 4865, 535, 12, 24, "Print"],
Cell[175229, 4879, 528, 12, 22, "Print"],
Cell[175760, 4893, 39, 1, 22, "Print"],
Cell[175802, 4896, 525, 12, 24, "Print"],
Cell[176330, 4910, 534, 12, 24, "Print"],
Cell[176867, 4924, 529, 12, 22, "Print"],
Cell[177399, 4938, 39, 1, 22, "Print"],
Cell[177441, 4941, 525, 12, 24, "Print"],
Cell[177969, 4955, 535, 12, 24, "Print"],
Cell[178507, 4969, 529, 12, 22, "Print"],
Cell[179039, 4983, 39, 1, 22, "Print"],
Cell[179081, 4986, 525, 12, 24, "Print"],
Cell[179609, 5000, 533, 12, 24, "Print"],
Cell[180145, 5014, 529, 12, 22, "Print"],
Cell[180677, 5028, 39, 1, 22, "Print"],
Cell[180719, 5031, 525, 12, 24, "Print"],
Cell[181247, 5045, 535, 12, 24, "Print"],
Cell[181785, 5059, 529, 12, 22, "Print"],
Cell[182317, 5073, 39, 1, 22, "Print"],
Cell[182359, 5076, 525, 12, 24, "Print"],
Cell[182887, 5090, 534, 12, 24, "Print"],
Cell[183424, 5104, 529, 12, 22, "Print"],
Cell[183956, 5118, 39, 1, 22, "Print"],
Cell[183998, 5121, 525, 12, 24, "Print"],
Cell[184526, 5135, 535, 12, 24, "Print"],
Cell[185064, 5149, 529, 12, 22, "Print"],
Cell[185596, 5163, 39, 1, 22, "Print"],
Cell[185638, 5166, 525, 12, 24, "Print"],
Cell[186166, 5180, 535, 12, 24, "Print"],
Cell[186704, 5194, 531, 12, 22, "Print"],
Cell[187238, 5208, 39, 1, 22, "Print"],
Cell[187280, 5211, 525, 12, 24, "Print"],
Cell[187808, 5225, 535, 12, 24, "Print"],
Cell[188346, 5239, 564, 13, 22, "Print"],
Cell[188913, 5254, 39, 1, 22, "Print"],
Cell[188955, 5257, 70, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[189062, 5263, 46, 1, 27, "Input"],
Cell[189111, 5266, 41, 1, 26, "Output"]
}, Open  ]]
}, Closed]]
}, Closed]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

