(* :Title: datashfvnew.m   *)

(* :Context: shohatfavard`datashfvnew` *)

(* :Author:  Zlia da ROCHA *)

(* :Address: 
            Departamento de Matemtica Aplicada da
            Faculdade de Cincias do Porto
            Rua das Taipas, 135
            4050 Porto
            Portugal
  
            Tel: ++351 02 2080313
            Fax: ++351 02 2004109
            Email: mrdioh@fc.up.pt
*)
(* :Summary:
    The datashfvnew package contains the definitions 
    gamma, beta and formexact that the package shfv 
    needs, corresponding to a new example given
    by the user.    
*)
(* :Date: July 1999. *)

(* :Available at http://netlib.bell-labs.com/ in the 
    numeralgo library in netlib:       *)

(* :Package Version: 1.0 *)

(* :Mathematica Version: 3.0 *)  
 
(* :Keywords: Shohat Favard's method, regular forms,
              d-dimensional canonical forms, 
              d-orthogonal polynomial sequences.
*)
(* :Sources:

 - Z. da Rocha, Shohat-Favard and Chebyshev's
   methods in d-orthogonality, Numerical Algorithms,
   20 (1999) 139 - 164.
*)

(* :Warnings: How to load this package.

This package must be putted in a directory named
shohatfavard. 
Note that the directory containing the shohatfavard
directory must be on the file search path $Path.

This package contains the definitions needed in the
package shfv.m. 
The context corresponding to this package 
(shohatfavard`datashfvnew`) must be written in the
BeginPackage command of the package shfv.m
Then, when you load the package shfv.m doing 
<<shohatfavard`shfv`or Needs["shohatfavard`shfv`"]
this package is automatically loaded. 
*)


BeginPackage["shohatfavard`datashfvnew`"]

datashfvnew::usage="is a package that contains
the definitions of

- the d gamma coefficients and the beta coefficient
  that appear in the (d+1)-order recurrence relation
  satisfied by orthogonal polynomials of dimension d
  (gamma, beta)
  
- the exact expressions of the moments of the d
  dimensional form, with respect to which the
  polynomials are orthogonal of dimension d
  (formexact),
  
corresponding to a new example given by the user.

The definitions gamma, beta and formexact are used in
the package shfv."


gamma::usage="
gamma[ d, r, n ], is the n-th gamma coefficient
of order r (n>=1, 0<=r<=d-1), that appears in the
(d+1)-order recurrence relation satisfied by
orthogonal polynomials of dimension d.

gamma is used in the package shfv.m."


beta::usage="
beta[ d, n ], n>=0, is the n-th beta coefficient, 
that appears in the (d+1)-order recurrence relation
satisfied by orthogonal polynomials of dimension d.

beta is used in the package shfv.m."


formexact::usage="
formexact[ d, alpha, n ] is the exact expression
of the n-th moment (n>=0) of the form of order
alpha (1<=alpha<=d), with respect to which the
polynomials are orthogonal of dimension d.

formexact is used in the package shfv.m." 


Begin["`Private`"]

(*___________________________________________________

                   Error Messages
 ___________________________________________________*)
 
gamma::badarg2=
   "wrong value to the second argument r=`1` in gamma; 
    r must be an integer and verify 0<=r<=`2`;
    try again"

gamma::badarg3=
   "wrong value to the third argument n=`1` in gamma;
    n must be an integer;
    try again" 

beta::badarg2=
   "wrong value to the second argument n=`1` in beta;
    n must be an integer;
    try again"
    
formexact::badarg2=
   "wrong value to the second argument
    alpha=`1` in formexact;
    alpha must be an integer and verify
    1<=alpha<=`2`;
    try again"

formexact::badarg3=
   "wrong value to the third argument n=`1` in formexact;
    n must be an integer;
    try again"  

(*______________________________________________

               Exported definitions
________________________________________________*)
(*______________________________________________

              the gamma coefficients
_______________________________________________*)

gamma[d_,r_,n_]:=gamma[d,r,n]=

Block[{ro1,ld,m,s,m3,m6,m9},
        
(*___________ checking the arguments____________*)
  
  If[Or[r<0,r>=d,Not[IntegerQ[r]]],
  
  Return[Message[gamma::badarg2,r,d-1]]
    ];
    
  If[Not[IntegerQ[n]],
  
    Return[Message[gamma::badarg3,n]]
    ];
    
(*______________________________________________*)
		
  (* TO FILL IN BY THE USER *)
    
(*_____________________________________________*)
   
]; (*end of Block*)
(*_____________________________________________*) 
   
(*______________________________________________

              the beta coefficients
_______________________________________________*)

beta[d_,n_]:=beta[d,n]=

 Block[{m,s,ro1,ld,m3,m6,m9},
 
 (*___________ checking the arguments___________*)
      
      If[Not[IntegerQ[n]],
      
     Return[Message[beta::badarg3,n]]
        ];  
 (*_____________________________________________*) 
 
 (* TO FILL IN BY THE USER *)
 
(*_____________________________________________*)
   
  ]; (*end of Block*)          
         
(*________________________________________________

    the exact expression of the moments of the 
    d-dimensional form
_________________________________________________*)

formexact[d_,alpha_,n_]:=formexact[d,alpha,n]=

 Block[{ro1,ld,m3,fact},
 (*___________ checking the arguments___________*)
   If[Or[alpha<1,alpha>d,Not[IntegerQ[alpha]]],
    
 	  Return[Message[formexact::badarg2,alpha,d]]
 	 ];	 
   
   If[Not[IntegerQ[n]],
   
      Return[Message[formexact::badarg3,n]]
     ];
(*_______________________________________________*)
                 
(* TO FILL IN BY THE USER *)

(*______________________________________________*)
        
];(*end of Block*) 

(*______________________________________________*)
   
   
End[]

EndPackage[]