(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 3.0,
MathReader 3.0, or any compatible application. The data for the notebook 
starts with the line of stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[    236181,       6754]*)
(*NotebookOutlinePosition[    237021,       6781]*)
(*  CellTagsIndexPosition[    236977,       6777]*)
(*WindowFrame->Normal*)



Notebook[{
Cell[TextData[{
  " :Author:  Z\[EAcute]lia da ROCHA \n\n:Address: \n            Departamento \
de Matem\[AAcute]tica Aplicada da\n            Faculdade de Ci\[EHat]ncias do \
Porto\n            Rua das Taipas, 135\n            4050 Porto\n            \
Portugal\n  \n            Tel: ++351 02 2080313\n            Fax: ++351 02 \
2004109\n            Email: mrdioh@fc.up.pt\n\n :Summary:\n    The ",
  StyleBox["testmodchv43",
    FontSize->18],
  " notebook contains the results produced by the package\n    modchv.m \
corresponding to the ",
  StyleBox["example 4.3",
    FontSize->18],
  " of the first paper cited bellow.    \n\n :Date: July 1999. \n\n:Available \
at http://netlib.bell-labs.com/ in the numeralgo library in netlib:     \n\n \
:Notebook Version: 1.0 \n\n :Mathematica Version: 3.0   \n \n :Keywords: \
chebyshev's method, recurrence relations,  orthogonal polynomials of \
dimension d, d-dimensional forms.\n\n :Sources:\n \n - Z\[EAcute]lia da \
Rocha, Shohat-Favard and Chebyshev's methods in d-orthogonality, \n Numerical \
Algorithms, 20 (1999) 139-164.\n   \n - About the example treated here see \
pp. 82, 103 of\n   K. Douak, P. Maroni, Les polyn\[OHat]mes orthogonaux \
\"classiques\" de dimension deux, Analysis 12,  71-107 (1992),\n   and p. 34 \
of\n   K. Douak, P. Maroni, On d-orthogonal Tchebyshev polynomials, I, Appl. \
Numer. Math.,\n 24 (1997) 23-53."
}], "Subsection"],

Cell[CellGroupData[{

Cell["\<\
Computing the recurrence coefficients and the orthogonal \
polynomials performing formal computations\
\>", "Section",
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell["\<\
Loading the package modchv.m, the package datamodchv43.m is \
automatically loaded\
\>", "Subsection"],

Cell[BoxData[
    \(\(<< modchebyshev`modchv`; \)\)], "Input"]
}, Closed]],

Cell[CellGroupData[{

Cell["\<\
The moments of the d-dimensional form are given in the package \
datamodchv43.m\
\>", "Subsection",
  AspectRatioFixed->True],

Cell[BoxData[
    \( (*\ showing\ the\ moments\ given\ *) \)], "Input"],

Cell[BoxData[
    \(\( (*\ set\ the\ values\ of\ d\ and\ imax\ *) \nd = 2; imax = \ 10; 
    \ \ \ \ \ \  (*\ for\ example\ *) \)\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Do[Print["\<form[\>", d, "\<,\>", r, "\<,\>", i, "\<]=\>", 
        form[d, r, i]], {r, 1, d}, {i, 0, imax}]\)], "Input"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]0
        \[InvisibleSpace]"]="\[InvisibleSpace]1\),
      SequenceForm[ "form[", 2, ",", 1, ",", 0, "]=", 1],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 2, ",", 1, ",", 1, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 2, ",", 1, ",", 2, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]"]="\[InvisibleSpace]1\),
      SequenceForm[ "form[", 2, ",", 1, ",", 3, "]=", 1],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 2, ",", 1, ",", 4, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 2, ",", 1, ",", 5, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]6
        \[InvisibleSpace]"]="\[InvisibleSpace]20\/7\),
      SequenceForm[ "form[", 2, ",", 1, ",", 6, "]=", 
        Rational[ 20, 7]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]7
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 2, ",", 1, ",", 7, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]8
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 2, ",", 1, ",", 8, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]9
        \[InvisibleSpace]"]="\[InvisibleSpace]32\/3\),
      SequenceForm[ "form[", 2, ",", 1, ",", 9, "]=", 
        Rational[ 32, 3]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]10
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 2, ",", 1, ",", 10, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]0
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 2, ",", 2, ",", 0, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]"]="\[InvisibleSpace]1\),
      SequenceForm[ "form[", 2, ",", 2, ",", 1, "]=", 1],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 2, ",", 2, ",", 2, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 2, ",", 2, ",", 3, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]"]="\[InvisibleSpace]2\),
      SequenceForm[ "form[", 2, ",", 2, ",", 4, "]=", 2],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 2, ",", 2, ",", 5, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]6
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 2, ",", 2, ",", 6, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]7
        \[InvisibleSpace]"]="\[InvisibleSpace]20\/3\),
      SequenceForm[ "form[", 2, ",", 2, ",", 7, "]=", 
        Rational[ 20, 3]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]8
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 2, ",", 2, ",", 8, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]9
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 2, ",", 2, ",", 9, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]10
        \[InvisibleSpace]"]="\[InvisibleSpace]80\/3\),
      SequenceForm[ "form[", 2, ",", 2, ",", 10, "]=", 
        Rational[ 80, 3]],
      Editable->False]], "Print"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["\<\
The auxiliary sequence of d-orthogonal polynomials is given in the \
package datamodchv43.m\
\>", "Subsection"],

Cell[BoxData[
    \( (*\ 
      showing\ the\ coefficients\ of\ the\ auxiliary\ sequence\ given\ *) \)],
   "Input"],

Cell[BoxData[
    \(\( (*\ set\ the\ values\ of\ d\ and\ imax\ *) \nd = 2; imax = \ 10; 
    \ \ \ \ \ \  (*\ for\ example\ *) \)\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(Do[\ 
      Do[Print["\<auxgamma[\>", d, "\<,\>", r, "\<,\>", n, "\<]=\>", \n
          \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \
\ auxgamma[d, r, n]\ ], \ \ \ \ \ \ \ \n
        \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ {n, 1, imax + r - d + 1}]; 
      Print["\<___________\>"], \ \n\ \ \ \ \ \ {r, 0, d - 1}]\ \)\)], "Input"],

Cell[BoxData[
    InterpretationBox[
      \("auxgamma["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]0
        \[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]"]="\[InvisibleSpace]1\/2\),
      SequenceForm[ "auxgamma[", 2, ",", 0, ",", 1, "]=", 
        Rational[ 1, 2]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("auxgamma["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]0
        \[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]"]="\[InvisibleSpace]7\/10\),
      SequenceForm[ "auxgamma[", 2, ",", 0, ",", 2, "]=", 
        Rational[ 7, 10]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("auxgamma["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]0
        \[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]"]="\[InvisibleSpace]4\/5\),
      SequenceForm[ "auxgamma[", 2, ",", 0, ",", 3, "]=", 
        Rational[ 4, 5]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("auxgamma["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]0
        \[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]"]="\[InvisibleSpace]6\/7\),
      SequenceForm[ "auxgamma[", 2, ",", 0, ",", 4, "]=", 
        Rational[ 6, 7]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("auxgamma["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]0
        \[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]"]="\[InvisibleSpace]25\/28\),
      SequenceForm[ "auxgamma[", 2, ",", 0, ",", 5, "]=", 
        Rational[ 25, 28]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("auxgamma["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]0
        \[InvisibleSpace]","\[InvisibleSpace]6
        \[InvisibleSpace]"]="\[InvisibleSpace]11\/12\),
      SequenceForm[ "auxgamma[", 2, ",", 0, ",", 6, "]=", 
        Rational[ 11, 12]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("auxgamma["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]0
        \[InvisibleSpace]","\[InvisibleSpace]7
        \[InvisibleSpace]"]="\[InvisibleSpace]14\/15\),
      SequenceForm[ "auxgamma[", 2, ",", 0, ",", 7, "]=", 
        Rational[ 14, 15]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("auxgamma["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]0
        \[InvisibleSpace]","\[InvisibleSpace]8
        \[InvisibleSpace]"]="\[InvisibleSpace]52\/55\),
      SequenceForm[ "auxgamma[", 2, ",", 0, ",", 8, "]=", 
        Rational[ 52, 55]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("auxgamma["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]0
        \[InvisibleSpace]","\[InvisibleSpace]9
        \[InvisibleSpace]"]="\[InvisibleSpace]21\/22\),
      SequenceForm[ "auxgamma[", 2, ",", 0, ",", 9, "]=", 
        Rational[ 21, 22]],
      Editable->False]], "Print"],

Cell[BoxData[
    \("___________"\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("auxgamma["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "auxgamma[", 2, ",", 1, ",", 1, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("auxgamma["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "auxgamma[", 2, ",", 1, ",", 2, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("auxgamma["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "auxgamma[", 2, ",", 1, ",", 3, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("auxgamma["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "auxgamma[", 2, ",", 1, ",", 4, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("auxgamma["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "auxgamma[", 2, ",", 1, ",", 5, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("auxgamma["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]6
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "auxgamma[", 2, ",", 1, ",", 6, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("auxgamma["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]7
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "auxgamma[", 2, ",", 1, ",", 7, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("auxgamma["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]8
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "auxgamma[", 2, ",", 1, ",", 8, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("auxgamma["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]9
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "auxgamma[", 2, ",", 1, ",", 9, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("auxgamma["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]10
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "auxgamma[", 2, ",", 1, ",", 10, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("___________"\)], "Print"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(\ Do[Print["\<auxbeta[\>", d, "\<,\>", n, "\<]=\>", auxbeta[d, n]\ ], 
      \ \ \ \ \ \ \ \n\ \ \ \ \ \ \ \ \ \ {n, 0, imax - 1}]\)\)], "Input"],

Cell[BoxData[
    InterpretationBox[
      \("auxbeta["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]0
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "auxbeta[", 2, ",", 0, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("auxbeta["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "auxbeta[", 2, ",", 1, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("auxbeta["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "auxbeta[", 2, ",", 2, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("auxbeta["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "auxbeta[", 2, ",", 3, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("auxbeta["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "auxbeta[", 2, ",", 4, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("auxbeta["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "auxbeta[", 2, ",", 5, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("auxbeta["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]6
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "auxbeta[", 2, ",", 6, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("auxbeta["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]7
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "auxbeta[", 2, ",", 7, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("auxbeta["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]8
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "auxbeta[", 2, ",", 8, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("auxbeta["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]9
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "auxbeta[", 2, ",", 9, "]=", 0],
      Editable->False]], "Print"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Computing the modified gamma coefficients", "Subsection"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\( (*\ set\ the\ values\ of\ d\ and\ nmax\ *) \nd = 2; \ 
    nmax = \ 10\ \ \ ; \ \  (*\ for\ example\ *) \)\)], "Input"],

Cell[BoxData[
    \(General::"spell1" \( : \ \) 
      "Possible spelling error: new symbol name \"\!\(nmax\)\" is similar to \
existing symbol \"\!\(imax\)\"."\)], "Message"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(MemoryInUse[]\)], "Input"],

Cell[BoxData[
    \(966672\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Timing[printmodgamma[d,nmax,Infinity,$MachinePrecision,True,False]]\
\
\>", "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    \("   "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("modgamma["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]0
        \[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]"]="\[InvisibleSpace]1\),
      SequenceForm[ "modgamma[", 2, ",", 0, ",", 1, "]=", 1],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]0
        \[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]"]="\[InvisibleSpace]1\),
      SequenceForm[ "gammaexact[", 2, ",", 0, ",", 1, "]=", 1],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("modgamma["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]0
        \[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]"]="\[InvisibleSpace]1\),
      SequenceForm[ "modgamma[", 2, ",", 0, ",", 2, "]=", 1],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]0
        \[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]"]="\[InvisibleSpace]1\),
      SequenceForm[ "gammaexact[", 2, ",", 0, ",", 2, "]=", 1],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("modgamma["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]0
        \[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]"]="\[InvisibleSpace]6\/7\),
      SequenceForm[ "modgamma[", 2, ",", 0, ",", 3, "]=", 
        Rational[ 6, 7]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]0
        \[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]"]="\[InvisibleSpace]6\/7\),
      SequenceForm[ "gammaexact[", 2, ",", 0, ",", 3, "]=", 
        Rational[ 6, 7]],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("modgamma["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]0
        \[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]"]="\[InvisibleSpace]20\/21\),
      SequenceForm[ "modgamma[", 2, ",", 0, ",", 4, "]=", 
        Rational[ 20, 21]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]0
        \[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]"]="\[InvisibleSpace]20\/21\),
      SequenceForm[ "gammaexact[", 2, ",", 0, ",", 4, "]=", 
        Rational[ 20, 21]],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("modgamma["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]0
        \[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]"]="\[InvisibleSpace]6\/7\),
      SequenceForm[ "modgamma[", 2, ",", 0, ",", 5, "]=", 
        Rational[ 6, 7]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]0
        \[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]"]="\[InvisibleSpace]6\/7\),
      SequenceForm[ "gammaexact[", 2, ",", 0, ",", 5, "]=", 
        Rational[ 6, 7]],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("modgamma["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]0
        \[InvisibleSpace]","\[InvisibleSpace]6
        \[InvisibleSpace]"]="\[InvisibleSpace]14\/15\),
      SequenceForm[ "modgamma[", 2, ",", 0, ",", 6, "]=", 
        Rational[ 14, 15]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]0
        \[InvisibleSpace]","\[InvisibleSpace]6
        \[InvisibleSpace]"]="\[InvisibleSpace]14\/15\),
      SequenceForm[ "gammaexact[", 2, ",", 0, ",", 6, "]=", 
        Rational[ 14, 15]],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("modgamma["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]0
        \[InvisibleSpace]","\[InvisibleSpace]7
        \[InvisibleSpace]"]="\[InvisibleSpace]56\/65\),
      SequenceForm[ "modgamma[", 2, ",", 0, ",", 7, "]=", 
        Rational[ 56, 65]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]0
        \[InvisibleSpace]","\[InvisibleSpace]7
        \[InvisibleSpace]"]="\[InvisibleSpace]56\/65\),
      SequenceForm[ "gammaexact[", 2, ",", 0, ",", 7, "]=", 
        Rational[ 56, 65]],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("modgamma["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]0
        \[InvisibleSpace]","\[InvisibleSpace]8
        \[InvisibleSpace]"]="\[InvisibleSpace]12\/13\),
      SequenceForm[ "modgamma[", 2, ",", 0, ",", 8, "]=", 
        Rational[ 12, 13]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]0
        \[InvisibleSpace]","\[InvisibleSpace]8
        \[InvisibleSpace]"]="\[InvisibleSpace]12\/13\),
      SequenceForm[ "gammaexact[", 2, ",", 0, ",", 8, "]=", 
        Rational[ 12, 13]],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("modgamma["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]0
        \[InvisibleSpace]","\[InvisibleSpace]9
        \[InvisibleSpace]"]="\[InvisibleSpace]45\/52\),
      SequenceForm[ "modgamma[", 2, ",", 0, ",", 9, "]=", 
        Rational[ 45, 52]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]0
        \[InvisibleSpace]","\[InvisibleSpace]9
        \[InvisibleSpace]"]="\[InvisibleSpace]45\/52\),
      SequenceForm[ "gammaexact[", 2, ",", 0, ",", 9, "]=", 
        Rational[ 45, 52]],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    \("   "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("modgamma["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "modgamma[", 2, ",", 1, ",", 1, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 2, ",", 1, ",", 1, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("modgamma["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "modgamma[", 2, ",", 1, ",", 2, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 2, ",", 1, ",", 2, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("modgamma["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "modgamma[", 2, ",", 1, ",", 3, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 2, ",", 1, ",", 3, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("modgamma["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "modgamma[", 2, ",", 1, ",", 4, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 2, ",", 1, ",", 4, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("modgamma["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "modgamma[", 2, ",", 1, ",", 5, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 2, ",", 1, ",", 5, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("modgamma["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]6
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "modgamma[", 2, ",", 1, ",", 6, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]6
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 2, ",", 1, ",", 6, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("modgamma["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]7
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "modgamma[", 2, ",", 1, ",", 7, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]7
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 2, ",", 1, ",", 7, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("modgamma["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]8
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "modgamma[", 2, ",", 1, ",", 8, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]8
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 2, ",", 1, ",", 8, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("modgamma["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]9
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "modgamma[", 2, ",", 1, ",", 9, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]9
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 2, ",", 1, ",", 9, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("modgamma["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]10
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "modgamma[", 2, ",", 1, ",", 10, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]10
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 2, ",", 1, ",", 10, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    \({6.48333333333334138`\ Second, Null}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(MemoryInUse[]\)], "Input"],

Cell[BoxData[
    \(1037480\)], "Output"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Computing the modified beta coefficients", "Subsection"],

Cell[BoxData[
    \(\( (*\ set\ the\ values\ of\ d\ and\ nmax\ *) \nd = 2; \ 
    nmax = \ 10\ \ ; \ \ \  (*\ for\ example\ *) \)\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(MemoryInUse[]\)], "Input"],

Cell[BoxData[
    \(1039296\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Timing[printmodbeta[d,nmax,Infinity,$MachinePrecision,True,False]]\
\
\>", "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    InterpretationBox[
      \("modbeta["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]0
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "modbeta[", 2, ",", 0, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("betaexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]0
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "betaexact[", 2, ",", 0, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("modbeta["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "modbeta[", 2, ",", 1, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("betaexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "betaexact[", 2, ",", 1, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("modbeta["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "modbeta[", 2, ",", 2, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("betaexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "betaexact[", 2, ",", 2, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("modbeta["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "modbeta[", 2, ",", 3, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("betaexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "betaexact[", 2, ",", 3, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("modbeta["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "modbeta[", 2, ",", 4, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("betaexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "betaexact[", 2, ",", 4, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("modbeta["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "modbeta[", 2, ",", 5, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("betaexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "betaexact[", 2, ",", 5, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("modbeta["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]6
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "modbeta[", 2, ",", 6, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("betaexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]6
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "betaexact[", 2, ",", 6, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("modbeta["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]7
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "modbeta[", 2, ",", 7, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("betaexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]7
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "betaexact[", 2, ",", 7, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("modbeta["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]8
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "modbeta[", 2, ",", 8, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("betaexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]8
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "betaexact[", 2, ",", 8, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("modbeta["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]9
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "modbeta[", 2, ",", 9, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("betaexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]9
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "betaexact[", 2, ",", 9, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    \({3.78333333333334564`\ Second, Null}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(MemoryInUse[]\)], "Input"],

Cell[BoxData[
    \(1042080\)], "Output"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["\<\
Computing the d-orthogonal polynomials from the modified \
coefficients\
\>", "Subsection"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\( (*\ set\ the\ values\ of\ d\ and\ nmax\ *) \nd = 2; \ 
    nmax = \ 10\ \ \ \ \  (*\ for\ example\ *) \)\)], "Input"],

Cell[BoxData[
    \(10\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(MemoryInUse[]\)], "Input"],

Cell[BoxData[
    \(1040168\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Timing[printmoddorthpoly[d,nmax,x,Infinity]]", "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("moddorthpoly["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "x", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", 
        InterpretationBox["\[Infinity]",
          DirectedInfinity[ 1]], "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", "1"}],
      SequenceForm[ "moddorthpoly[", 2, ",", 0, ",", x, ",", 
        DirectedInfinity[ 1], "]=", 1],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("moddorthpoly["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "x", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", 
        InterpretationBox["\[Infinity]",
          DirectedInfinity[ 1]], "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", "x"}],
      SequenceForm[ "moddorthpoly[", 2, ",", 1, ",", x, ",", 
        DirectedInfinity[ 1], "]=", x],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("moddorthpoly["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "x", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", 
        InterpretationBox["\[Infinity]",
          DirectedInfinity[ 1]], "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", \(x\^2\)}],
      SequenceForm[ "moddorthpoly[", 2, ",", 2, ",", x, ",", 
        DirectedInfinity[ 1], "]=", 
        Power[ x, 2]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("moddorthpoly["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "x", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", 
        InterpretationBox["\[Infinity]",
          DirectedInfinity[ 1]], "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", \(\( - 1\) + x\^3\)}],
      SequenceForm[ "moddorthpoly[", 2, ",", 3, ",", x, ",", 
        DirectedInfinity[ 1], "]=", 
        Plus[ -1, 
          Power[ x, 3]]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("moddorthpoly["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "4", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "x", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", 
        InterpretationBox["\[Infinity]",
          DirectedInfinity[ 1]], "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", \(\( - 2\)\ x + x\^4\)}],
      SequenceForm[ "moddorthpoly[", 2, ",", 4, ",", x, ",", 
        DirectedInfinity[ 1], "]=", 
        Plus[ 
          Times[ -2, x], 
          Power[ x, 4]]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("moddorthpoly["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "x", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", 
        InterpretationBox["\[Infinity]",
          DirectedInfinity[ 1]], "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", \(\( - \(20\ x\^2\)\/7\) + x\^5\)}],
      SequenceForm[ "moddorthpoly[", 2, ",", 5, ",", x, ",", 
        DirectedInfinity[ 1], "]=", 
        Plus[ 
          Times[ 
            Rational[ -20, 7], 
            Power[ x, 2]], 
          Power[ x, 5]]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("moddorthpoly["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "6", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "x", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", 
        InterpretationBox["\[Infinity]",
          DirectedInfinity[ 1]], "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", \(20\/21 - \(80\ x\^3\)\/21 + x\^6\)}],
      SequenceForm[ "moddorthpoly[", 2, ",", 6, ",", x, ",", 
        DirectedInfinity[ 1], "]=", 
        Plus[ 
          Rational[ 20, 21], 
          Times[ 
            Rational[ -80, 21], 
            Power[ x, 3]], 
          Power[ x, 6]]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("moddorthpoly["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "7", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "x", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", 
        InterpretationBox["\[Infinity]",
          DirectedInfinity[ 1]], "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", \(\(8\ x\)\/3 - \(14\ x\^4\)\/3 + x\^7\)}],
      SequenceForm[ "moddorthpoly[", 2, ",", 7, ",", x, ",", 
        DirectedInfinity[ 1], "]=", 
        Plus[ 
          Times[ 
            Rational[ 8, 3], x], 
          Times[ 
            Rational[ -14, 3], 
            Power[ x, 4]], 
          Power[ x, 7]]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("moddorthpoly["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "8", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "x", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", 
        InterpretationBox["\[Infinity]",
          DirectedInfinity[ 1]], "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", \(\(16\ x\^2\)\/3 - \(28\ x\^5\)\/5 + x\^8\)}],
      SequenceForm[ "moddorthpoly[", 2, ",", 8, ",", x, ",", 
        DirectedInfinity[ 1], "]=", 
        Plus[ 
          Times[ 
            Rational[ 16, 3], 
            Power[ x, 2]], 
          Times[ 
            Rational[ -28, 5], 
            Power[ x, 5]], 
          Power[ x, 8]]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("moddorthpoly["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "9", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "x", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", 
        InterpretationBox["\[Infinity]",
          DirectedInfinity[ 1]], "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        \(\( - 32\/39\) + \(112\ x\^3\)\/13 - \(84\ x\^6\)\/13 + x\^9\)}],
      SequenceForm[ "moddorthpoly[", 2, ",", 9, ",", x, ",", 
        DirectedInfinity[ 1], "]=", 
        Plus[ 
          Rational[ -32, 39], 
          Times[ 
            Rational[ 112, 13], 
            Power[ x, 3]], 
          Times[ 
            Rational[ -84, 13], 
            Power[ x, 6]], 
          Power[ x, 9]]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("moddorthpoly["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "10", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "x", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", 
        InterpretationBox["\[Infinity]",
          DirectedInfinity[ 1]], "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        \(\( - \(128\ x\)\/39\) + \(168\ x\^4\)\/13 - \(96\ x\^7\)\/13 + 
          x\^10\)}],
      SequenceForm[ "moddorthpoly[", 2, ",", 10, ",", x, ",", 
        DirectedInfinity[ 1], "]=", 
        Plus[ 
          Times[ 
            Rational[ -128, 39], x], 
          Times[ 
            Rational[ 168, 13], 
            Power[ x, 4]], 
          Times[ 
            Rational[ -96, 13], 
            Power[ x, 7]], 
          Power[ x, 10]]],
      Editable->False]], "Print"],

Cell[BoxData[
    \({2.3333333333333428`\ Second, Null}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(MemoryInUse[]\)], "Input"],

Cell[BoxData[
    \(1045648\)], "Output"]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["\<\
Computing the recurrence coefficients and the orthogonal \
polynomials performing numerical computations with the machine precision\
\>",
   "Section",
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell["\<\
Loading the package modchv.m, the package datamodchv43.m is \
automatically loaded\
\>", "Subsection"],

Cell[BoxData[
    \(\(<< modchebyshev`modchv`; \)\)], "Input"]
}, Closed]],

Cell[CellGroupData[{

Cell["Computing the modified gamma coefficients", "Subsection"],

Cell[BoxData[
    \(\( (*\ set\ the\ values\ of\ d\ and\ nmax\ *) \nd = 2; \ nmax = \ 50; 
    \ \ \ \ \  (*\ for\ example\ *) \)\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(MemoryInUse[]\)], "Input"],

Cell[BoxData[
    \(983832\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Timing[printmodgamma[d,nmax,$MachinePrecision,$MachinePrecision,\
True,True]]\
\>", "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    \("   "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("modgamma["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\),
         "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["1.`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "modgamma[", 2, ",", 0, ",", 1, "]=", 1.0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["1.`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gammaexact[", 2, ",", 0, ",", 1, "]=", 1.0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        InterpretationBox["\[Infinity]",
          DirectedInfinity[ 1]]}],
      SequenceForm[ "exactdigits[", 2, ",", 0, ",", 1, "]=", 
        DirectedInfinity[ 1]],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("modgamma["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\),
         "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["1.`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "modgamma[", 2, ",", 0, ",", 2, "]=", 1.0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["1.`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gammaexact[", 2, ",", 0, ",", 2, "]=", 1.0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        InterpretationBox["\[Infinity]",
          DirectedInfinity[ 1]]}],
      SequenceForm[ "exactdigits[", 2, ",", 0, ",", 2, "]=", 
        DirectedInfinity[ 1]],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("modgamma["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\),
         "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["0.857142857142856762`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "modgamma[", 2, ",", 0, ",", 3, "]=", 0.85714285714285676],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["0.857142857142857117`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "gammaexact[", 2, ",", 0, ",", 3, "]=", 0.8571428571428571],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["14.4774685154713411`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 2, ",", 0, ",", 3, "]=", 14.47746851547134],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("modgamma["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\),
         "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "4", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["0.952380952380954326`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "modgamma[", 2, ",", 0, ",", 4, "]=", 0.95238095238095433],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "4", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["0.952380952380952372`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "gammaexact[", 2, ",", 0, ",", 4, "]=", 0.95238095238095233],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "4", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["13.6993172650876959`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 2, ",", 0, ",", 4, "]=", 13.699317265087696],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("modgamma["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\),
         "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "5", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["0.857142857142853742`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "modgamma[", 2, ",", 0, ",", 5, "]=", 0.85714285714285376],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "5", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["0.857142857142857117`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "gammaexact[", 2, ",", 0, ",", 5, "]=", 0.8571428571428571],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "5", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["13.477468515471338`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 2, ",", 0, ",", 5, "]=", 13.477468515471339],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("modgamma["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\),
         "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "6", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["0.933333333333336412`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "modgamma[", 2, ",", 0, ",", 6, "]=", 0.93333333333333646],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "6", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["0.933333333333333392`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "gammaexact[", 2, ",", 0, ",", 6, "]=", 0.93333333333333335],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "6", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["13.507431738848783`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 2, ",", 0, ",", 6, "]=", 13.507431738848783],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("modgamma["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\),
         "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "7", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["0.861538461538460431`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "modgamma[", 2, ",", 0, ",", 7, "]=", 0.86153846153846037],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "7", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["0.861538461538461675`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "gammaexact[", 2, ",", 0, ",", 7, "]=", 0.86153846153846159],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "7", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["13.9131970850327757`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 2, ",", 0, ",", 7, "]=", 13.913197085032776],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("modgamma["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\),
         "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "8", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["0.923076923076923172`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "modgamma[", 2, ",", 0, ",", 8, "]=", 0.92307692307692324],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "8", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["0.923076923076923172`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "gammaexact[", 2, ",", 0, ",", 8, "]=", 0.92307692307692313],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "8", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["14.9545897701910002`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 2, ",", 0, ",", 8, "]=", 14.954589770191001],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("modgamma["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\),
         "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "9", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["0.865384615384608402`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "modgamma[", 2, ",", 0, ",", 9, "]=", 0.86538461538460842],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "9", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["0.865384615384615329`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "gammaexact[", 2, ",", 0, ",", 9, "]=", 0.86538461538461542],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "9", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["13.1552492207374216`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 2, ",", 0, ",", 9, "]=", 13.155249220737421],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("modgamma["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\),
         "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "10", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["0.916666666666687923`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "modgamma[", 2, ",", 0, ",", 10, "]=", 0.91666666666668795],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "10", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["0.916666666666666607`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "gammaexact[", 2, ",", 0, ",", 10, "]=", 0.91666666666666663],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "10", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["12.6712885414874532`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 2, ",", 0, ",", 10, "]=", 12.671288541487453],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("modgamma["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\),
         "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "11", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["0.868421052631537015`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "modgamma[", 2, ",", 0, ",", 11, "]=", 0.86842105263153702],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "11", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["0.868421052631578938`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "gammaexact[", 2, ",", 0, ",", 11, "]=", 0.86842105263157898],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "11", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["12.3770979703537764`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 2, ",", 0, ",", 11, "]=", 12.377097970353777],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("modgamma["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\),
         "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "12", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["0.912280701754435696`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "modgamma[", 2, ",", 0, ",", 12, "]=", 0.91228070175443576],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "12", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["0.912280701754385958`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "gammaexact[", 2, ",", 0, ",", 12, "]=", 0.91228070175438591],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "12", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["12.3023434291876787`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 2, ",", 0, ",", 12, "]=", 12.30234342918768],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("modgamma["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\),
         "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "13", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["0.870813397129181865`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "modgamma[", 2, ",", 0, ",", 13, "]=", 0.87081339712918193],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "13", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["0.870813397129186661`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "gammaexact[", 2, ",", 0, ",", 13, "]=", 0.87081339712918659],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "13", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["13.3313404797931012`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 2, ",", 0, ",", 13, "]=", 13.3313404797931],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("modgamma["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\),
         "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "14", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["0.909090909090765997`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "modgamma[", 2, ",", 0, ",", 14, "]=", 0.90909090909076595],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "14", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["0.909090909090908994`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "gammaexact[", 2, ",", 0, ",", 14, "]=", 0.90909090909090906],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "14", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["11.8443368528376002`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 2, ",", 0, ",", 14, "]=", 11.8443368528376],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("modgamma["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\),
         "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "15", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["0.872727272727770575`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "modgamma[", 2, ",", 0, ",", 15, "]=", 0.87272727272777062],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "15", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["0.872727272727272662`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "gammaexact[", 2, ",", 0, ",", 15, "]=", 0.87272727272727268],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "15", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["11.302827322810891`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 2, ",", 0, ",", 15, "]=", 11.302827322810892],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("modgamma["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\),
         "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "16", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["0.906666666665565657`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "modgamma[", 2, ",", 0, ",", 16, "]=", 0.90666666666556572],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "16", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["0.906666666666666642`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "gammaexact[", 2, ",", 0, ",", 16, "]=", 0.90666666666666662],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "16", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["10.9582532520952181`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 2, ",", 0, ",", 16, "]=", 10.958253252095218],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("modgamma["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\),
         "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "17", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["0.874285714287896098`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "modgamma[", 2, ",", 0, ",", 17, "]=", 0.87428571428789603],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "17", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["0.874285714285714377`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "gammaexact[", 2, ",", 0, ",", 17, "]=", 0.87428571428571433],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "17", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["10.6612051145415653`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 2, ",", 0, ",", 17, "]=", 10.661205114541564],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("modgamma["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\),
         "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "18", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["0.904761904758179902`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "modgamma[", 2, ",", 0, ",", 18, "]=", 0.90476190475817986],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "18", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["0.904761904761904744`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "gammaexact[", 2, ",", 0, ",", 18, "]=", 0.90476190476190477],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "18", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["10.4288843011849574`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 2, ",", 0, ",", 18, "]=", 10.428884301184958],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("modgamma["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\),
         "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "19", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["0.875576036872547902`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "modgamma[", 2, ",", 0, ",", 19, "]=", 0.87557603687254792],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "19", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["0.87557603686635943`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "gammaexact[", 2, ",", 0, ",", 19, "]=", 0.87557603686635943],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "19", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["10.2084150144504914`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 2, ",", 0, ",", 19, "]=", 10.208415014450491],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("modgamma["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\),
         "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "20", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["0.903225806442429934`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "modgamma[", 2, ",", 0, ",", 20, "]=", 0.90322580644242989],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "20", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["0.903225806451612811`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "gammaexact[", 2, ",", 0, ",", 20, "]=", 0.90322580645161288],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "20", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["10.0370159972217187`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 2, ",", 0, ",", 20, "]=", 10.037015997221719],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("modgamma["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\),
         "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "21", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["0.876660341568466527`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "modgamma[", 2, ",", 0, ",", 21, "]=", 0.87666034156846651],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "21", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["0.876660341555977318`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "gammaexact[", 2, ",", 0, ",", 21, "]=", 0.87666034155597727],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "21", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["9.90346427135212614`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 2, ",", 0, ",", 21, "]=", 9.9034642713521261],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("modgamma["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\),
         "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "22", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["0.901960784300750972`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "modgamma[", 2, ",", 0, ",", 22, "]=", 0.90196078430075088],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "22", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["0.901960784313725483`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "gammaexact[", 2, ",", 0, ",", 22, "]=", 0.90196078431372551],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "22", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["9.88690530678635504`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 2, ",", 0, ",", 22, "]=", 9.886905306786355],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("modgamma["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\),
         "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "23", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["0.877583465822871389`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "modgamma[", 2, ",", 0, ",", 23, "]=", 0.87758346582287139],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "23", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["0.877583465818759833`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "gammaexact[", 2, ",", 0, ",", 23, "]=", 0.8775834658187599],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "23", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["10.3860008750286292`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 2, ",", 0, ",", 23, "]=", 10.38600087502863],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("modgamma["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\),
         "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "24", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["0.900900900928386505`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "modgamma[", 2, ",", 0, ",", 24, "]=", 0.90090090092838648],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "24", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["0.900900900900900936`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "gammaexact[", 2, ",", 0, ",", 24, "]=", 0.90090090090090091],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "24", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["9.56089526199782824`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 2, ",", 0, ",", 24, "]=", 9.5608952619978282],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("modgamma["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\),
         "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "25", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["0.878378378265590598`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "modgamma[", 2, ",", 0, ",", 25, "]=", 0.87837837826559051],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "25", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["0.878378378378378421`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "gammaexact[", 2, ",", 0, ",", 25, "]=", 0.8783783783783784],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "25", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["8.94773752737679828`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 2, ",", 0, ",", 25, "]=", 8.9477375273767983],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("modgamma["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\),
         "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "26", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["0.900000000286975065`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "modgamma[", 2, ",", 0, ",", 26, "]=", 0.90000000028697502],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "26", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["0.9`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "gammaexact[", 2, ",", 0, ",", 26, "]=", 0.90000000000000002],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "26", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["8.54215593647337634`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 2, ",", 0, ",", 26, "]=", 8.5421559364733763],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("modgamma["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\),
         "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "27", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["0.879069766832458121`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "modgamma[", 2, ",", 0, ",", 27, "]=", 0.87906976683245808],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "27", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["0.879069767441860427`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "gammaexact[", 2, ",", 0, ",", 27, "]=", 0.87906976744186049],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "27", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["8.21509582732209686`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 2, ",", 0, ",", 27, "]=", 8.2150958273220969],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("modgamma["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\),
         "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "28", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["0.899224807191579422`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "modgamma[", 2, ",", 0, ",", 28, "]=", 0.89922480719157938],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "28", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["0.899224806201550386`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "gammaexact[", 2, ",", 0, ",", 28, "]=", 0.89922480620155043],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "28", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["8.00435210676849173`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 2, ",", 0, ",", 28, "]=", 8.0043521067684917],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("modgamma["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\),
         "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "29", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["0.879676439960562994`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "modgamma[", 2, ",", 0, ",", 29, "]=", 0.87967643996056299],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "29", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["0.879676440849342888`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "gammaexact[", 2, ",", 0, ",", 29, "]=", 0.87967644084934282],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "29", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["8.05120581106471355`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 2, ",", 0, ",", 29, "]=", 8.0512058110647136],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("modgamma["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\),
         "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "30", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["0.89855072292855258`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "modgamma[", 2, ",", 0, ",", 30, "]=", 0.89855072292855254],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "30", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["0.898550724637681241`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "gammaexact[", 2, ",", 0, ",", 30, "]=", 0.89855072463768115],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "30", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["7.76722525425051912`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 2, ",", 0, ",", 30, "]=", 7.7672252542505191],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("modgamma["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\),
         "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "31", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["0.880212968476071466`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "modgamma[", 2, ",", 0, ",", 31, "]=", 0.88021296847607144],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "31", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["0.880212954747116249`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "gammaexact[", 2, ",", 0, ",", 31, "]=", 0.88021295474711625],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "31", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["6.86236251231524629`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 2, ",", 0, ",", 31, "]=", 6.8623625123152463],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("modgamma["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\),
         "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "32", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["0.897959132264174719`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "modgamma[", 2, ",", 0, ",", 32, "]=", 0.89795913226417468],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "32", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["0.897959183673469318`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "gammaexact[", 2, ",", 0, ",", 32, "]=", 0.89795918367346939],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "32", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["6.2889583542265699`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 2, ",", 0, ",", 32, "]=", 6.2889583542265699],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("modgamma["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\),
         "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "33", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["0.880690903628044985`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "modgamma[", 2, ",", 0, ",", 33, "]=", 0.88069090362804492],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "33", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["0.880690737833594994`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "gammaexact[", 2, ",", 0, ",", 33, "]=", 0.88069073783359497],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "33", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["5.78043001177049298`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 2, ",", 0, ",", 33, "]=", 5.780430011770493],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("modgamma["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\),
         "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "34", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["0.897435436460517443`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "modgamma[", 2, ",", 0, ",", 34, "]=", 0.89743543646051749],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "34", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["0.897435897435897445`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "gammaexact[", 2, ",", 0, ",", 34, "]=", 0.89743589743589747],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "34", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["5.33632226902429707`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 2, ",", 0, ",", 34, "]=", 5.3363222690242971],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("modgamma["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\),
         "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "35", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["0.881120139220066711`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "modgamma[", 2, ",", 0, ",", 35, "]=", 0.88112013922006671],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "35", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["0.881118881118881169`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "gammaexact[", 2, ",", 0, ",", 35, "]=", 0.88111888111888115],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "35", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["4.90028442839405009`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 2, ",", 0, ",", 35, "]=", 4.9002844283940501],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("modgamma["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\),
         "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "36", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["0.896966514233311329`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "modgamma[", 2, ",", 0, ",", 36, "]=", 0.89696651423331142],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "36", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["0.896969696969696883`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "gammaexact[", 2, ",", 0, ",", 36, "]=", 0.89696969696969697],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "36", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["4.4971993309172662`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 2, ",", 0, ",", 36, "]=", 4.4971993309172662],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("modgamma["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\),
         "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "37", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["0.881512860460248148`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "modgamma[", 2, ",", 0, ",", 37, "]=", 0.88151286046024813],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "37", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["0.881504702194357392`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "gammaexact[", 2, ",", 0, ",", 37, "]=", 0.88150470219435739],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "37", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["4.08840214444710703`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 2, ",", 0, ",", 37, "]=", 4.088402144447107],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("modgamma["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\),
         "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "38", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["0.896531808161298471`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "modgamma[", 2, ",", 0, ",", 38, "]=", 0.8965318081612984],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "38", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["0.89655172413793096`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "gammaexact[", 2, ",", 0, ",", 38, "]=", 0.89655172413793105],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "38", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["3.70079839195267545`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 2, ",", 0, ",", 38, "]=", 3.7007983919526755],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("modgamma["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\),
         "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "39", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["0.881904056410251868`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "modgamma[", 2, ",", 0, ",", 39, "]=", 0.88190405641025194],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "39", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["0.88185415488976826`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "gammaexact[", 2, ",", 0, ",", 39, "]=", 0.88185415488976826],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "39", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["3.30188622135838016`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 2, ",", 0, ",", 39, "]=", 3.3018862213583802],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("modgamma["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\),
         "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "40", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["0.896054267693242678`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "modgamma[", 2, ",", 0, ",", 40, "]=", 0.89605426769324259],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "40", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["0.896174863387978071`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "gammaexact[", 2, ",", 0, ",", 40, "]=", 0.89617486338797814],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "40", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["2.91866819622546316`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 2, ",", 0, ",", 40, "]=", 2.9186681962254633],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("modgamma["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\),
         "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "41", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["0.882472613119296411`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "modgamma[", 2, ",", 0, ",", 41, "]=", 0.88247261311929637],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "41", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["0.882172131147541094`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "gammaexact[", 2, ",", 0, ",", 41, "]=", 0.88217213114754101],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "41", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["2.52218157957484612`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 2, ",", 0, ",", 41, "]=", 2.5221815795748461],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("modgamma["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\),
         "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "42", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["0.895107375989606879`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "modgamma[", 2, ",", 0, ",", 42, "]=", 0.89510737598960688],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "42", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["0.895833333333333392`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "gammaexact[", 2, ",", 0, ",", 42, "]=", 0.89583333333333337],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "42", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["2.13908889710769667`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 2, ",", 0, ",", 42, "]=", 2.1390888971076967],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("modgamma["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\),
         "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "43", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["0.884270061254586003`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "modgamma[", 2, ",", 0, ",", 43, "]=", 0.88427006125458607],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "43", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["0.882462686567164134`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "gammaexact[", 2, ",", 0, ",", 43, "]=", 0.8824626865671642],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "43", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["1.74295180437800611`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 2, ",", 0, ",", 43, "]=", 1.7429518043780061],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("modgamma["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\),
         "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "44", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["0.891148221979362809`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "modgamma[", 2, ",", 0, ",", 44, "]=", 0.89114822197936283],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "44", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["0.89552238805970159`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "gammaexact[", 2, ",", 0, ",", 44, "]=", 0.89552238805970152],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "44", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["1.35910473149377741`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 2, ",", 0, ",", 44, "]=", 1.3591047314937774],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("modgamma["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\),
         "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "45", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["0.893594757059421773`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "modgamma[", 2, ",", 0, ",", 45, "]=", 0.89359475705942182],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "45", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["0.88272921108742004`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "gammaexact[", 2, ",", 0, ",", 45, "]=", 0.88272921108742008],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "45", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["0.963948446364136835`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 2, ",", 0, ",", 45, "]=", 0.96394844636413679],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("modgamma["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\),
         "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "46", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["0.868833871498877385`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "modgamma[", 2, ",", 0, ",", 46, "]=", 0.86883387149887736],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "46", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["0.895238095238095255`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "gammaexact[", 2, ",", 0, ",", 46, "]=", 0.89523809523809528],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "46", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["0.578326595860762893`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 2, ",", 0, ",", 46, "]=", 0.57832659586076285],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("modgamma["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\),
         "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "47", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["0.947853379958763753`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "modgamma[", 2, ",", 0, ",", 47, "]=", 0.94785337995876384],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "47", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["0.882974559686888404`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "gammaexact[", 2, ",", 0, ",", 47, "]=", 0.88297455968688843],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "47", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["0.187897055746234507`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 2, ",", 0, ",", 47, "]=", 0.1878970557462345],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("modgamma["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\),
         "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "48", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["0.733612046711790366`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "modgamma[", 2, ",", 0, ",", 48, "]=", 0.73361204671179037],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "48", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["0.894977168949771595`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "gammaexact[", 2, ",", 0, ",", 48, "]=", 0.89497716894977164],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "48", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        RowBox[{"-", 
          StyleBox["0.207809671300288023`",
            StyleBoxAutoDelete->True,
            PrintPrecision->2]}]}],
      SequenceForm[ 
      "exactdigits[", 2, ",", 0, ",", 48, "]=", -0.20780967130028805],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("modgamma["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\),
         "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "49", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["1.25801903149128868`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "modgamma[", 2, ",", 0, ",", 49, "]=", 1.2580190314912887],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "49", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["0.883201153568853669`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "gammaexact[", 2, ",", 0, ",", 49, "]=", 0.88320115356885365],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "49", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["0.426179702475055499`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 2, ",", 0, ",", 49, "]=", 0.42617970247505554],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    \("   "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("modgamma["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "modgamma[", 2, ",", 1, ",", 1, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 2, ",", 1, ",", 1, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 2, ",", 1, ",", 1, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("modgamma["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "modgamma[", 2, ",", 1, ",", 2, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 2, ",", 1, ",", 2, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 2, ",", 1, ",", 2, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("modgamma["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "modgamma[", 2, ",", 1, ",", 3, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 2, ",", 1, ",", 3, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 2, ",", 1, ",", 3, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("modgamma["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "modgamma[", 2, ",", 1, ",", 4, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 2, ",", 1, ",", 4, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 2, ",", 1, ",", 4, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("modgamma["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "modgamma[", 2, ",", 1, ",", 5, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 2, ",", 1, ",", 5, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 2, ",", 1, ",", 5, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("modgamma["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]6
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "modgamma[", 2, ",", 1, ",", 6, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]6
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 2, ",", 1, ",", 6, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]6
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 2, ",", 1, ",", 6, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("modgamma["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]7
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "modgamma[", 2, ",", 1, ",", 7, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]7
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 2, ",", 1, ",", 7, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]7
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 2, ",", 1, ",", 7, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("modgamma["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]8
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "modgamma[", 2, ",", 1, ",", 8, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]8
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 2, ",", 1, ",", 8, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]8
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 2, ",", 1, ",", 8, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("modgamma["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]9
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "modgamma[", 2, ",", 1, ",", 9, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]9
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 2, ",", 1, ",", 9, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]9
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 2, ",", 1, ",", 9, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("modgamma["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]10
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "modgamma[", 2, ",", 1, ",", 10, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]10
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 2, ",", 1, ",", 10, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]10
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 2, ",", 1, ",", 10, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("modgamma["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]11
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "modgamma[", 2, ",", 1, ",", 11, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]11
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 2, ",", 1, ",", 11, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]11
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 2, ",", 1, ",", 11, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("modgamma["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]12
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "modgamma[", 2, ",", 1, ",", 12, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]12
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 2, ",", 1, ",", 12, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]12
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 2, ",", 1, ",", 12, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("modgamma["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]13
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "modgamma[", 2, ",", 1, ",", 13, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]13
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 2, ",", 1, ",", 13, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]13
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 2, ",", 1, ",", 13, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("modgamma["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]14
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "modgamma[", 2, ",", 1, ",", 14, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]14
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 2, ",", 1, ",", 14, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]14
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 2, ",", 1, ",", 14, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("modgamma["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]15
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "modgamma[", 2, ",", 1, ",", 15, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]15
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 2, ",", 1, ",", 15, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]15
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 2, ",", 1, ",", 15, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("modgamma["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]16
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "modgamma[", 2, ",", 1, ",", 16, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]16
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 2, ",", 1, ",", 16, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]16
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 2, ",", 1, ",", 16, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("modgamma["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]17
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "modgamma[", 2, ",", 1, ",", 17, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]17
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 2, ",", 1, ",", 17, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]17
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 2, ",", 1, ",", 17, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("modgamma["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]18
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "modgamma[", 2, ",", 1, ",", 18, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]18
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 2, ",", 1, ",", 18, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]18
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 2, ",", 1, ",", 18, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("modgamma["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]19
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "modgamma[", 2, ",", 1, ",", 19, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]19
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 2, ",", 1, ",", 19, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]19
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 2, ",", 1, ",", 19, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("modgamma["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]20
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "modgamma[", 2, ",", 1, ",", 20, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]20
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 2, ",", 1, ",", 20, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]20
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 2, ",", 1, ",", 20, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("modgamma["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]21
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "modgamma[", 2, ",", 1, ",", 21, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]21
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 2, ",", 1, ",", 21, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]21
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 2, ",", 1, ",", 21, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("modgamma["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]22
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "modgamma[", 2, ",", 1, ",", 22, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]22
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 2, ",", 1, ",", 22, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]22
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 2, ",", 1, ",", 22, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("modgamma["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]23
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "modgamma[", 2, ",", 1, ",", 23, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]23
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 2, ",", 1, ",", 23, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]23
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 2, ",", 1, ",", 23, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("modgamma["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]24
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "modgamma[", 2, ",", 1, ",", 24, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]24
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 2, ",", 1, ",", 24, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]24
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 2, ",", 1, ",", 24, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("modgamma["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]25
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "modgamma[", 2, ",", 1, ",", 25, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]25
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 2, ",", 1, ",", 25, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]25
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 2, ",", 1, ",", 25, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("modgamma["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]26
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "modgamma[", 2, ",", 1, ",", 26, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]26
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 2, ",", 1, ",", 26, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]26
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 2, ",", 1, ",", 26, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("modgamma["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]27
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "modgamma[", 2, ",", 1, ",", 27, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]27
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 2, ",", 1, ",", 27, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]27
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 2, ",", 1, ",", 27, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("modgamma["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]28
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "modgamma[", 2, ",", 1, ",", 28, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]28
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 2, ",", 1, ",", 28, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]28
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 2, ",", 1, ",", 28, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("modgamma["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]29
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "modgamma[", 2, ",", 1, ",", 29, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]29
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 2, ",", 1, ",", 29, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]29
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 2, ",", 1, ",", 29, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("modgamma["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]30
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "modgamma[", 2, ",", 1, ",", 30, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]30
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 2, ",", 1, ",", 30, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]30
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 2, ",", 1, ",", 30, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("modgamma["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]31
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "modgamma[", 2, ",", 1, ",", 31, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]31
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 2, ",", 1, ",", 31, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]31
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 2, ",", 1, ",", 31, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("modgamma["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]32
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "modgamma[", 2, ",", 1, ",", 32, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]32
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 2, ",", 1, ",", 32, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]32
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 2, ",", 1, ",", 32, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("modgamma["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]33
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "modgamma[", 2, ",", 1, ",", 33, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]33
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 2, ",", 1, ",", 33, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]33
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 2, ",", 1, ",", 33, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("modgamma["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]34
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "modgamma[", 2, ",", 1, ",", 34, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]34
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 2, ",", 1, ",", 34, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]34
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 2, ",", 1, ",", 34, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("modgamma["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]35
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "modgamma[", 2, ",", 1, ",", 35, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]35
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 2, ",", 1, ",", 35, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]35
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 2, ",", 1, ",", 35, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("modgamma["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]36
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "modgamma[", 2, ",", 1, ",", 36, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]36
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 2, ",", 1, ",", 36, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]36
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 2, ",", 1, ",", 36, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("modgamma["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]37
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "modgamma[", 2, ",", 1, ",", 37, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]37
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 2, ",", 1, ",", 37, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]37
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 2, ",", 1, ",", 37, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("modgamma["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]38
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "modgamma[", 2, ",", 1, ",", 38, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]38
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 2, ",", 1, ",", 38, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]38
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 2, ",", 1, ",", 38, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("modgamma["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]39
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "modgamma[", 2, ",", 1, ",", 39, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]39
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 2, ",", 1, ",", 39, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]39
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 2, ",", 1, ",", 39, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("modgamma["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]40
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "modgamma[", 2, ",", 1, ",", 40, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]40
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 2, ",", 1, ",", 40, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]40
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 2, ",", 1, ",", 40, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("modgamma["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]41
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "modgamma[", 2, ",", 1, ",", 41, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]41
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 2, ",", 1, ",", 41, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]41
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 2, ",", 1, ",", 41, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("modgamma["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]42
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "modgamma[", 2, ",", 1, ",", 42, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]42
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 2, ",", 1, ",", 42, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]42
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 2, ",", 1, ",", 42, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("modgamma["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]43
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "modgamma[", 2, ",", 1, ",", 43, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]43
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 2, ",", 1, ",", 43, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]43
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 2, ",", 1, ",", 43, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("modgamma["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]44
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "modgamma[", 2, ",", 1, ",", 44, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]44
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 2, ",", 1, ",", 44, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]44
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 2, ",", 1, ",", 44, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("modgamma["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]45
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "modgamma[", 2, ",", 1, ",", 45, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]45
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 2, ",", 1, ",", 45, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]45
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 2, ",", 1, ",", 45, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("modgamma["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]46
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "modgamma[", 2, ",", 1, ",", 46, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]46
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 2, ",", 1, ",", 46, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]46
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 2, ",", 1, ",", 46, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("modgamma["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]47
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "modgamma[", 2, ",", 1, ",", 47, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]47
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 2, ",", 1, ",", 47, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]47
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 2, ",", 1, ",", 47, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("modgamma["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]48
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "modgamma[", 2, ",", 1, ",", 48, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]48
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 2, ",", 1, ",", 48, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]48
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 2, ",", 1, ",", 48, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("modgamma["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]49
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "modgamma[", 2, ",", 1, ",", 49, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]49
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 2, ",", 1, ",", 49, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]49
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 2, ",", 1, ",", 49, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("modgamma["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]50
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "modgamma[", 2, ",", 1, ",", 50, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]50
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 2, ",", 1, ",", 50, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]50
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 2, ",", 1, ",", 50, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    \({73.1833333333333335`\ Second, Null}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(MemoryInUse[]\)], "Input"],

Cell[BoxData[
    \(2010400\)], "Output"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Computing the modified beta coefficients", "Subsection"],

Cell[BoxData[
    \(\( (*\ set\ the\ values\ of\ d\ and\ nmax\ *) \nd = 2; \ 
    nmax = \ 50\ \ ; \ \ \  (*\ for\ example\ *) \)\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(MemoryInUse[]\)], "Input"],

Cell[BoxData[
    \(2012184\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Timing[printmodbeta[d,nmax,$MachinePrecision,$MachinePrecision,True,\
True]]\
\>", "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    InterpretationBox[
      \("modbeta["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]0
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "modbeta[", 2, ",", 0, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("betaexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]0
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "betaexact[", 2, ",", 0, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]0
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 2, ",", 0, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("modbeta["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "modbeta[", 2, ",", 1, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("betaexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "betaexact[", 2, ",", 1, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 2, ",", 1, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("modbeta["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "modbeta[", 2, ",", 2, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("betaexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "betaexact[", 2, ",", 2, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 2, ",", 2, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("modbeta["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "modbeta[", 2, ",", 3, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("betaexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "betaexact[", 2, ",", 3, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 2, ",", 3, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("modbeta["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "modbeta[", 2, ",", 4, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("betaexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "betaexact[", 2, ",", 4, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 2, ",", 4, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("modbeta["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "modbeta[", 2, ",", 5, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("betaexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "betaexact[", 2, ",", 5, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 2, ",", 5, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("modbeta["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]6
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "modbeta[", 2, ",", 6, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("betaexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]6
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "betaexact[", 2, ",", 6, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]6
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 2, ",", 6, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("modbeta["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]7
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "modbeta[", 2, ",", 7, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("betaexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]7
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "betaexact[", 2, ",", 7, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]7
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 2, ",", 7, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("modbeta["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]8
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "modbeta[", 2, ",", 8, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("betaexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]8
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "betaexact[", 2, ",", 8, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]8
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 2, ",", 8, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("modbeta["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]9
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "modbeta[", 2, ",", 9, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("betaexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]9
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "betaexact[", 2, ",", 9, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]9
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 2, ",", 9, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("modbeta["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]10
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "modbeta[", 2, ",", 10, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("betaexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]10
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "betaexact[", 2, ",", 10, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]10
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 2, ",", 10, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("modbeta["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]11
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "modbeta[", 2, ",", 11, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("betaexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]11
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "betaexact[", 2, ",", 11, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]11
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 2, ",", 11, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("modbeta["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]12
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "modbeta[", 2, ",", 12, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("betaexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]12
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "betaexact[", 2, ",", 12, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]12
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 2, ",", 12, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("modbeta["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]13
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "modbeta[", 2, ",", 13, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("betaexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]13
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "betaexact[", 2, ",", 13, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]13
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 2, ",", 13, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("modbeta["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]14
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "modbeta[", 2, ",", 14, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("betaexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]14
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "betaexact[", 2, ",", 14, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]14
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 2, ",", 14, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("modbeta["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]15
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "modbeta[", 2, ",", 15, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("betaexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]15
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "betaexact[", 2, ",", 15, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]15
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 2, ",", 15, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("modbeta["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]16
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "modbeta[", 2, ",", 16, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("betaexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]16
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "betaexact[", 2, ",", 16, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]16
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 2, ",", 16, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("modbeta["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]17
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "modbeta[", 2, ",", 17, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("betaexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]17
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "betaexact[", 2, ",", 17, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]17
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 2, ",", 17, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("modbeta["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]18
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "modbeta[", 2, ",", 18, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("betaexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]18
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "betaexact[", 2, ",", 18, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]18
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 2, ",", 18, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("modbeta["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]19
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "modbeta[", 2, ",", 19, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("betaexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]19
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "betaexact[", 2, ",", 19, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]19
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 2, ",", 19, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("modbeta["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]20
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "modbeta[", 2, ",", 20, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("betaexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]20
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "betaexact[", 2, ",", 20, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]20
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 2, ",", 20, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("modbeta["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]21
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "modbeta[", 2, ",", 21, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("betaexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]21
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "betaexact[", 2, ",", 21, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]21
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 2, ",", 21, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("modbeta["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]22
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "modbeta[", 2, ",", 22, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("betaexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]22
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "betaexact[", 2, ",", 22, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]22
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 2, ",", 22, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("modbeta["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]23
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "modbeta[", 2, ",", 23, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("betaexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]23
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "betaexact[", 2, ",", 23, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]23
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 2, ",", 23, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("modbeta["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]24
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "modbeta[", 2, ",", 24, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("betaexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]24
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "betaexact[", 2, ",", 24, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]24
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 2, ",", 24, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("modbeta["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]25
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "modbeta[", 2, ",", 25, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("betaexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]25
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "betaexact[", 2, ",", 25, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]25
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 2, ",", 25, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("modbeta["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]26
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "modbeta[", 2, ",", 26, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("betaexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]26
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "betaexact[", 2, ",", 26, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]26
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 2, ",", 26, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("modbeta["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]27
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "modbeta[", 2, ",", 27, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("betaexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]27
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "betaexact[", 2, ",", 27, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]27
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 2, ",", 27, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("modbeta["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]28
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "modbeta[", 2, ",", 28, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("betaexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]28
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "betaexact[", 2, ",", 28, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]28
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 2, ",", 28, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("modbeta["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]29
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "modbeta[", 2, ",", 29, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("betaexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]29
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "betaexact[", 2, ",", 29, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]29
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 2, ",", 29, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("modbeta["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]30
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "modbeta[", 2, ",", 30, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("betaexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]30
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "betaexact[", 2, ",", 30, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]30
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 2, ",", 30, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("modbeta["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]31
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "modbeta[", 2, ",", 31, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("betaexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]31
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "betaexact[", 2, ",", 31, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]31
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 2, ",", 31, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("modbeta["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]32
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "modbeta[", 2, ",", 32, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("betaexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]32
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "betaexact[", 2, ",", 32, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]32
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 2, ",", 32, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("modbeta["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]33
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "modbeta[", 2, ",", 33, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("betaexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]33
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "betaexact[", 2, ",", 33, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]33
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 2, ",", 33, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("modbeta["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]34
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "modbeta[", 2, ",", 34, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("betaexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]34
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "betaexact[", 2, ",", 34, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]34
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 2, ",", 34, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("modbeta["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]35
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "modbeta[", 2, ",", 35, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("betaexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]35
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "betaexact[", 2, ",", 35, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]35
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 2, ",", 35, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("modbeta["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]36
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "modbeta[", 2, ",", 36, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("betaexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]36
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "betaexact[", 2, ",", 36, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]36
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 2, ",", 36, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("modbeta["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]37
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "modbeta[", 2, ",", 37, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("betaexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]37
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "betaexact[", 2, ",", 37, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]37
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 2, ",", 37, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("modbeta["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]38
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "modbeta[", 2, ",", 38, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("betaexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]38
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "betaexact[", 2, ",", 38, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]38
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 2, ",", 38, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("modbeta["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]39
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "modbeta[", 2, ",", 39, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("betaexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]39
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "betaexact[", 2, ",", 39, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]39
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 2, ",", 39, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("modbeta["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]40
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "modbeta[", 2, ",", 40, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("betaexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]40
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "betaexact[", 2, ",", 40, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]40
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 2, ",", 40, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("modbeta["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]41
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "modbeta[", 2, ",", 41, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("betaexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]41
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "betaexact[", 2, ",", 41, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]41
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 2, ",", 41, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("modbeta["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]42
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "modbeta[", 2, ",", 42, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("betaexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]42
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "betaexact[", 2, ",", 42, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]42
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 2, ",", 42, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("modbeta["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]43
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "modbeta[", 2, ",", 43, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("betaexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]43
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "betaexact[", 2, ",", 43, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]43
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 2, ",", 43, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("modbeta["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]44
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "modbeta[", 2, ",", 44, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("betaexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]44
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "betaexact[", 2, ",", 44, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]44
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 2, ",", 44, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("modbeta["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]45
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "modbeta[", 2, ",", 45, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("betaexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]45
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "betaexact[", 2, ",", 45, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]45
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 2, ",", 45, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("modbeta["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]46
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "modbeta[", 2, ",", 46, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("betaexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]46
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "betaexact[", 2, ",", 46, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]46
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 2, ",", 46, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("modbeta["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]47
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "modbeta[", 2, ",", 47, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("betaexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]47
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "betaexact[", 2, ",", 47, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]47
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 2, ",", 47, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("modbeta["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]48
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "modbeta[", 2, ",", 48, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("betaexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]48
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "betaexact[", 2, ",", 48, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]48
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 2, ",", 48, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("modbeta["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]49
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "modbeta[", 2, ",", 49, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("betaexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]49
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "betaexact[", 2, ",", 49, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]49
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 2, ",", 49, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    \({24.7833333333333305`\ Second, Null}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(MemoryInUse[]\)], "Input"],

Cell[BoxData[
    \(2018312\)], "Output"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["\<\
Computing the d-orthogonal polynomials from the modified \
coefficients\
\>", "Subsection"],

Cell[BoxData[
    \(\( (*\ set\ the\ values\ of\ d\ and\ nmax\ *) \nd = 2; \ nmax = \ 15\ ; 
    \ \ \  (*\ for\ example\ *) \)\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(MemoryInUse[]\)], "Input"],

Cell[BoxData[
    \(2020096\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Timing[printmoddorthpoly[d,nmax,x,$MachinePrecision]]", "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("moddorthpoly["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "x", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["1.`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "moddorthpoly[", 2, ",", 0, ",", x, "]=", 1.0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("moddorthpoly["\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]x
        \[InvisibleSpace]"]="\[InvisibleSpace]x\),
      SequenceForm[ "moddorthpoly[", 2, ",", 1, ",", x, "]=", x],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("moddorthpoly["\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]x
        \[InvisibleSpace]"]="\[InvisibleSpace]x\^2\),
      SequenceForm[ "moddorthpoly[", 2, ",", 2, ",", x, "]=", 
        Power[ x, 2]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("moddorthpoly["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "x", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        RowBox[{
          RowBox[{"-", 
            StyleBox["1.`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16]}], "+", \(x\^3\)}]}],
      SequenceForm[ "moddorthpoly[", 2, ",", 3, ",", x, "]=", 
        Plus[ -1.0, 
          Power[ x, 3]]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("moddorthpoly["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "4", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "x", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        RowBox[{
          RowBox[{
            RowBox[{"-", 
              StyleBox["2.`",
                StyleBoxAutoDelete->True,
                PrintPrecision->16]}], " ", "x"}], "+", \(x\^4\)}]}],
      SequenceForm[ "moddorthpoly[", 2, ",", 4, ",", x, "]=", 
        Plus[ 
          Times[ -2.0, x], 
          Power[ x, 4]]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("moddorthpoly["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "x", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        RowBox[{
          RowBox[{
            RowBox[{"-", 
              StyleBox["2.85714285714285676`",
                StyleBoxAutoDelete->True,
                PrintPrecision->16]}], " ", \(x\^2\)}], "+", \(x\^5\)}]}],
      SequenceForm[ "moddorthpoly[", 2, ",", 5, ",", x, "]=", 
        Plus[ 
          Times[ -2.8571428571428568, 
            Power[ x, 2]], 
          Power[ x, 5]]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("moddorthpoly["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "6", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "x", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        RowBox[{
          RowBox[{
            StyleBox["0.952380952380954326`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], "\[InvisibleSpace]"}], "-", 
          RowBox[{
            StyleBox["3.80952380952381108`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^3\)}], "+", \(x\^6\)}]}],
      SequenceForm[ "moddorthpoly[", 2, ",", 6, ",", x, "]=", 
        Plus[ 0.95238095238095433, 
          Times[ -3.8095238095238111, 
            Power[ x, 3]], 
          Power[ x, 6]]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("moddorthpoly["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "7", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "x", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        RowBox[{
          RowBox[{
            StyleBox["2.66666666666666163`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", "x"}], "-", 
          RowBox[{
            StyleBox["4.66666666666666518`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^4\)}], "+", \(x\^7\)}]}],
      SequenceForm[ "moddorthpoly[", 2, ",", 7, ",", x, "]=", 
        Plus[ 
          Times[ 2.6666666666666616, x], 
          Times[ -4.6666666666666652, 
            Power[ x, 4]], 
          Power[ x, 7]]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("moddorthpoly["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "8", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "x", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        RowBox[{
          RowBox[{
            StyleBox["5.33333333333333747`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^2\)}], "-", 
          RowBox[{
            StyleBox["5.60000000000000142`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^5\)}], "+", \(x\^8\)}]}],
      SequenceForm[ "moddorthpoly[", 2, ",", 8, ",", x, "]=", 
        Plus[ 
          Times[ 5.3333333333333375, 
            Power[ x, 2]], 
          Times[ -5.6000000000000014, 
            Power[ x, 5]], 
          Power[ x, 8]]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("moddorthpoly["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "9", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "x", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        RowBox[{
          RowBox[{"-", 
            StyleBox["0.820512820512820972`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16]}], "+", 
          RowBox[{
            StyleBox["8.61538461538461675`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^3\)}], "-", 
          RowBox[{
            StyleBox["6.46153846153846167`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^6\)}], "+", \(x\^9\)}]}],
      SequenceForm[ "moddorthpoly[", 2, ",", 9, ",", x, "]=", 
        Plus[ -0.82051282051282104, 
          Times[ 8.6153846153846168, 
            Power[ x, 3]], 
          Times[ -6.4615384615384617, 
            Power[ x, 6]], 
          Power[ x, 9]]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("moddorthpoly["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "10", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "x", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        RowBox[{
          RowBox[{
            RowBox[{"-", 
              StyleBox["3.28205128205127838`",
                StyleBoxAutoDelete->True,
                PrintPrecision->16]}], " ", "x"}], "+", 
          RowBox[{
            StyleBox["12.9230769230769237`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^4\)}], "-", 
          RowBox[{
            StyleBox["7.38461538461538502`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^7\)}], "+", \(x\^10\)}]}],
      SequenceForm[ "moddorthpoly[", 2, ",", 10, ",", x, "]=", 
        Plus[ 
          Times[ -3.2820512820512784, x], 
          Times[ 12.923076923076923, 
            Power[ x, 4]], 
          Times[ -7.384615384615385, 
            Power[ x, 7]], 
          Power[ x, 10]]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("moddorthpoly["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "11", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "x", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        RowBox[{
          RowBox[{
            RowBox[{"-", 
              StyleBox["7.89743589743586049`",
                StyleBoxAutoDelete->True,
                PrintPrecision->16]}], " ", \(x\^2\)}], "+", 
          RowBox[{
            StyleBox["17.7692307692307309`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^5\)}], "-", 
          RowBox[{
            StyleBox["8.24999999999999289`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^8\)}], "+", \(x\^11\)}]}],
      SequenceForm[ "moddorthpoly[", 2, ",", 11, ",", x, "]=", 
        Plus[ 
          Times[ -7.8974358974358605, 
            Power[ x, 2]], 
          Times[ 17.769230769230731, 
            Power[ x, 5]], 
          Times[ -8.2499999999999929, 
            Power[ x, 8]], 
          Power[ x, 11]]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("moddorthpoly["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "12", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "x", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        RowBox[{
          RowBox[{
            StyleBox["0.75213675213677007`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], "\[InvisibleSpace]"}], "-", 
          RowBox[{
            StyleBox["15.7948717948719412`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^3\)}], "+", 
          RowBox[{
            StyleBox["23.6923076923077946`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^6\)}], "-", 
          RowBox[{
            StyleBox["9.16666666666668028`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^9\)}], "+", \(x\^12\)}]}],
      SequenceForm[ "moddorthpoly[", 2, ",", 12, ",", x, "]=", 
        Plus[ 0.75213675213677011, 
          Times[ -15.794871794871941, 
            Power[ x, 3]], 
          Times[ 23.692307692307793, 
            Power[ x, 6]], 
          Times[ -9.1666666666666803, 
            Power[ x, 9]], 
          Power[ x, 12]]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("moddorthpoly["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "13", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "x", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        RowBox[{
          RowBox[{
            StyleBox["3.60233918128642649`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", "x"}], "-", 
          RowBox[{
            StyleBox["27.0175438596487271`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^4\)}], "+", 
          RowBox[{
            StyleBox["30.1052631578945284`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^7\)}], "-", 
          RowBox[{
            StyleBox["10.035087719298219`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^10\)}], "+", \(x\^13\)}]}],
      SequenceForm[ "moddorthpoly[", 2, ",", 13, ",", x, "]=", 
        Plus[ 
          Times[ 3.6023391812864265, x], 
          Times[ -27.017543859648725, 
            Power[ x, 4]], 
          Times[ 30.105263157894527, 
            Power[ x, 7]], 
          Times[ -10.035087719298218, 
            Power[ x, 10]], 
          Power[ x, 13]]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("moddorthpoly["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "14", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "x", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        RowBox[{
          RowBox[{
            StyleBox["10.8070175438598848`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^2\)}], "-", 
          RowBox[{
            StyleBox["43.2280701754390506`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^5\)}], "+", 
          RowBox[{
            StyleBox["37.6315789473686157`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^8\)}], "-", 
          RowBox[{
            StyleBox["10.9473684210526522`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^11\)}], "+", \(x\^14\)}]}],
      SequenceForm[ "moddorthpoly[", 2, ",", 14, ",", x, "]=", 
        Plus[ 
          Times[ 10.807017543859885, 
            Power[ x, 2]], 
          Times[ -43.228070175439051, 
            Power[ x, 5]], 
          Times[ 37.631578947368617, 
            Power[ x, 8]], 
          Times[ -10.947368421052653, 
            Power[ x, 11]], 
          Power[ x, 14]]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("moddorthpoly["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "15", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "x", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        RowBox[{
          RowBox[{"-", 
            StyleBox["0.654970760233930349`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16]}], "+", 
          RowBox[{
            StyleBox["24.5614035087722193`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^3\)}], "-", 
          RowBox[{
            StyleBox["63.8596491228074469`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^6\)}], "+", 
          RowBox[{
            StyleBox["45.6140350877194666`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^9\)}], "-", 
          RowBox[{
            StyleBox["11.8181818181818343`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^12\)}], "+", \(x\^15\)}]}],
      SequenceForm[ "moddorthpoly[", 2, ",", 15, ",", x, "]=", 
        Plus[ -0.6549707602339303, 
          Times[ 24.561403508772219, 
            Power[ x, 3]], 
          Times[ -63.859649122807447, 
            Power[ x, 6]], 
          Times[ 45.614035087719465, 
            Power[ x, 9]], 
          Times[ -11.818181818181834, 
            Power[ x, 12]], 
          Power[ x, 15]]],
      Editable->False]], "Print"],

Cell[BoxData[
    \({2.85000000000002273`\ Second, Null}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(MemoryInUse[]\)], "Input"],

Cell[BoxData[
    \(2027224\)], "Output"]
}, Open  ]]
}, Closed]]
}, Closed]]
},
FrontEndVersion->"Macintosh 3.0",
ScreenRectangle->{{0, 832}, {0, 604}},
WindowSize->{590, 412},
WindowMargins->{{Automatic, 87}, {Automatic, 66}},
MacintoshSystemPageSetup->"\<\
00<0001804P000000`d26_oQon@3:`8g0dL5N`?P0080001804P000000]P2:001
0000I00000400`<30?l00BL?00400@0000000000000006P801T1T00000000000
00000000004000000000000000000000\>"
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{
Cell[1709, 49, 1409, 23, 660, "Subsection"],

Cell[CellGroupData[{
Cell[3143, 76, 154, 4, 68, "Section"],

Cell[CellGroupData[{
Cell[3322, 84, 112, 3, 44, "Subsection"],
Cell[3437, 89, 62, 1, 27, "Input"]
}, Closed]],

Cell[CellGroupData[{
Cell[3536, 95, 135, 4, 28, "Subsection"],
Cell[3674, 101, 71, 1, 27, "Input"],
Cell[3748, 104, 142, 2, 43, "Input"],

Cell[CellGroupData[{
Cell[3915, 110, 141, 2, 43, "Input"],
Cell[4059, 114, 298, 6, 22, "Print"],
Cell[4360, 122, 298, 6, 22, "Print"],
Cell[4661, 130, 298, 6, 22, "Print"],
Cell[4962, 138, 298, 6, 22, "Print"],
Cell[5263, 146, 298, 6, 22, "Print"],
Cell[5564, 154, 298, 6, 22, "Print"],
Cell[5865, 162, 326, 7, 38, "Print"],
Cell[6194, 171, 298, 6, 22, "Print"],
Cell[6495, 179, 298, 6, 22, "Print"],
Cell[6796, 187, 326, 7, 38, "Print"],
Cell[7125, 196, 300, 6, 22, "Print"],
Cell[7428, 204, 298, 6, 22, "Print"],
Cell[7729, 212, 298, 6, 22, "Print"],
Cell[8030, 220, 298, 6, 22, "Print"],
Cell[8331, 228, 298, 6, 22, "Print"],
Cell[8632, 236, 298, 6, 22, "Print"],
Cell[8933, 244, 298, 6, 22, "Print"],
Cell[9234, 252, 298, 6, 22, "Print"],
Cell[9535, 260, 326, 7, 38, "Print"],
Cell[9864, 269, 298, 6, 22, "Print"],
Cell[10165, 277, 298, 6, 22, "Print"],
Cell[10466, 285, 328, 7, 38, "Print"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{
Cell[10843, 298, 121, 3, 44, "Subsection"],
Cell[10967, 303, 116, 3, 43, "Input"],
Cell[11086, 308, 142, 2, 43, "Input"],

Cell[CellGroupData[{
Cell[11253, 314, 376, 6, 75, "Input"],
Cell[11632, 322, 332, 7, 38, "Print"],
Cell[11967, 331, 334, 7, 38, "Print"],
Cell[12304, 340, 332, 7, 38, "Print"],
Cell[12639, 349, 332, 7, 38, "Print"],
Cell[12974, 358, 336, 7, 38, "Print"],
Cell[13313, 367, 336, 7, 38, "Print"],
Cell[13652, 376, 336, 7, 38, "Print"],
Cell[13991, 385, 336, 7, 38, "Print"],
Cell[14330, 394, 336, 7, 38, "Print"],
Cell[14669, 403, 46, 1, 22, "Print"],
Cell[14718, 406, 306, 6, 22, "Print"],
Cell[15027, 414, 306, 6, 22, "Print"],
Cell[15336, 422, 306, 6, 22, "Print"],
Cell[15645, 430, 306, 6, 22, "Print"],
Cell[15954, 438, 306, 6, 22, "Print"],
Cell[16263, 446, 306, 6, 22, "Print"],
Cell[16572, 454, 306, 6, 22, "Print"],
Cell[16881, 462, 306, 6, 22, "Print"],
Cell[17190, 470, 306, 6, 22, "Print"],
Cell[17499, 478, 308, 6, 22, "Print"],
Cell[17810, 486, 46, 1, 22, "Print"]
}, Open  ]],

Cell[CellGroupData[{
Cell[17893, 492, 167, 2, 43, "Input"],
Cell[18063, 496, 249, 5, 22, "Print"],
Cell[18315, 503, 249, 5, 22, "Print"],
Cell[18567, 510, 249, 5, 22, "Print"],
Cell[18819, 517, 249, 5, 22, "Print"],
Cell[19071, 524, 249, 5, 22, "Print"],
Cell[19323, 531, 249, 5, 22, "Print"],
Cell[19575, 538, 249, 5, 22, "Print"],
Cell[19827, 545, 249, 5, 22, "Print"],
Cell[20079, 552, 249, 5, 22, "Print"],
Cell[20331, 559, 249, 5, 22, "Print"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{
Cell[20629, 570, 63, 0, 28, "Subsection"],

Cell[CellGroupData[{
Cell[20717, 574, 142, 2, 43, "Input"],
Cell[20862, 578, 175, 3, 37, "Message"]
}, Open  ]],

Cell[CellGroupData[{
Cell[21074, 586, 46, 1, 27, "Input"],
Cell[21123, 589, 40, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[21200, 595, 120, 4, 42, "Input"],
Cell[21323, 601, 38, 1, 22, "Print"],
Cell[21364, 604, 306, 6, 22, "Print"],
Cell[21673, 612, 310, 6, 22, "Print"],
Cell[21986, 620, 37, 1, 22, "Print"],
Cell[22026, 623, 306, 6, 22, "Print"],
Cell[22335, 631, 310, 6, 22, "Print"],
Cell[22648, 639, 37, 1, 22, "Print"],
Cell[22688, 642, 332, 7, 38, "Print"],
Cell[23023, 651, 336, 7, 38, "Print"],
Cell[23362, 660, 37, 1, 22, "Print"],
Cell[23402, 663, 336, 7, 38, "Print"],
Cell[23741, 672, 340, 7, 38, "Print"],
Cell[24084, 681, 37, 1, 22, "Print"],
Cell[24124, 684, 332, 7, 38, "Print"],
Cell[24459, 693, 336, 7, 38, "Print"],
Cell[24798, 702, 37, 1, 22, "Print"],
Cell[24838, 705, 336, 7, 38, "Print"],
Cell[25177, 714, 340, 7, 38, "Print"],
Cell[25520, 723, 37, 1, 22, "Print"],
Cell[25560, 726, 336, 7, 38, "Print"],
Cell[25899, 735, 340, 7, 38, "Print"],
Cell[26242, 744, 37, 1, 22, "Print"],
Cell[26282, 747, 336, 7, 38, "Print"],
Cell[26621, 756, 340, 7, 38, "Print"],
Cell[26964, 765, 37, 1, 22, "Print"],
Cell[27004, 768, 336, 7, 38, "Print"],
Cell[27343, 777, 340, 7, 38, "Print"],
Cell[27686, 786, 37, 1, 22, "Print"],
Cell[27726, 789, 38, 1, 22, "Print"],
Cell[27767, 792, 306, 6, 22, "Print"],
Cell[28076, 800, 310, 6, 22, "Print"],
Cell[28389, 808, 37, 1, 22, "Print"],
Cell[28429, 811, 306, 6, 22, "Print"],
Cell[28738, 819, 310, 6, 22, "Print"],
Cell[29051, 827, 37, 1, 22, "Print"],
Cell[29091, 830, 306, 6, 22, "Print"],
Cell[29400, 838, 310, 6, 22, "Print"],
Cell[29713, 846, 37, 1, 22, "Print"],
Cell[29753, 849, 306, 6, 22, "Print"],
Cell[30062, 857, 310, 6, 22, "Print"],
Cell[30375, 865, 37, 1, 22, "Print"],
Cell[30415, 868, 306, 6, 22, "Print"],
Cell[30724, 876, 310, 6, 22, "Print"],
Cell[31037, 884, 37, 1, 22, "Print"],
Cell[31077, 887, 306, 6, 22, "Print"],
Cell[31386, 895, 310, 6, 22, "Print"],
Cell[31699, 903, 37, 1, 22, "Print"],
Cell[31739, 906, 306, 6, 22, "Print"],
Cell[32048, 914, 310, 6, 22, "Print"],
Cell[32361, 922, 37, 1, 22, "Print"],
Cell[32401, 925, 306, 6, 22, "Print"],
Cell[32710, 933, 310, 6, 22, "Print"],
Cell[33023, 941, 37, 1, 22, "Print"],
Cell[33063, 944, 306, 6, 22, "Print"],
Cell[33372, 952, 310, 6, 22, "Print"],
Cell[33685, 960, 37, 1, 22, "Print"],
Cell[33725, 963, 308, 6, 22, "Print"],
Cell[34036, 971, 312, 6, 22, "Print"],
Cell[34351, 979, 37, 1, 22, "Print"],
Cell[34391, 982, 70, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[34498, 988, 46, 1, 27, "Input"],
Cell[34547, 991, 41, 1, 26, "Output"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{
Cell[34637, 998, 62, 0, 28, "Subsection"],
Cell[34702, 1000, 142, 2, 43, "Input"],

Cell[CellGroupData[{
Cell[34869, 1006, 46, 1, 27, "Input"],
Cell[34918, 1009, 41, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[34996, 1015, 119, 4, 42, "Input"],
Cell[35118, 1021, 249, 5, 22, "Print"],
Cell[35370, 1028, 253, 5, 22, "Print"],
Cell[35626, 1035, 37, 1, 22, "Print"],
Cell[35666, 1038, 249, 5, 22, "Print"],
Cell[35918, 1045, 253, 5, 22, "Print"],
Cell[36174, 1052, 37, 1, 22, "Print"],
Cell[36214, 1055, 249, 5, 22, "Print"],
Cell[36466, 1062, 253, 5, 22, "Print"],
Cell[36722, 1069, 37, 1, 22, "Print"],
Cell[36762, 1072, 249, 5, 22, "Print"],
Cell[37014, 1079, 253, 5, 22, "Print"],
Cell[37270, 1086, 37, 1, 22, "Print"],
Cell[37310, 1089, 249, 5, 22, "Print"],
Cell[37562, 1096, 253, 5, 22, "Print"],
Cell[37818, 1103, 37, 1, 22, "Print"],
Cell[37858, 1106, 249, 5, 22, "Print"],
Cell[38110, 1113, 253, 5, 22, "Print"],
Cell[38366, 1120, 37, 1, 22, "Print"],
Cell[38406, 1123, 249, 5, 22, "Print"],
Cell[38658, 1130, 253, 5, 22, "Print"],
Cell[38914, 1137, 37, 1, 22, "Print"],
Cell[38954, 1140, 249, 5, 22, "Print"],
Cell[39206, 1147, 253, 5, 22, "Print"],
Cell[39462, 1154, 37, 1, 22, "Print"],
Cell[39502, 1157, 249, 5, 22, "Print"],
Cell[39754, 1164, 253, 5, 22, "Print"],
Cell[40010, 1171, 37, 1, 22, "Print"],
Cell[40050, 1174, 249, 5, 22, "Print"],
Cell[40302, 1181, 253, 5, 22, "Print"],
Cell[40558, 1188, 37, 1, 22, "Print"],
Cell[40598, 1191, 70, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[40705, 1197, 46, 1, 27, "Input"],
Cell[40754, 1200, 41, 1, 26, "Output"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{
Cell[40844, 1207, 101, 3, 28, "Subsection"],

Cell[CellGroupData[{
Cell[40970, 1214, 140, 2, 43, "Input"],
Cell[41113, 1218, 36, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[41186, 1224, 46, 1, 27, "Input"],
Cell[41235, 1227, 41, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[41313, 1233, 87, 1, 27, "Input"],
Cell[41403, 1236, 573, 12, 22, "Print"],
Cell[41979, 1250, 573, 12, 22, "Print"],
Cell[42555, 1264, 598, 13, 24, "Print"],
Cell[43156, 1279, 631, 14, 24, "Print"],
Cell[43790, 1295, 656, 15, 24, "Print"],
Cell[44449, 1312, 719, 17, 40, "Print"],
Cell[45171, 1331, 753, 18, 40, "Print"],
Cell[45927, 1351, 778, 19, 40, "Print"],
Cell[46708, 1372, 807, 20, 40, "Print"],
Cell[47518, 1394, 869, 22, 40, "Print"],
Cell[48390, 1418, 917, 24, 40, "Print"],
Cell[49310, 1444, 69, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[49416, 1450, 46, 1, 27, "Input"],
Cell[49465, 1453, 41, 1, 26, "Output"]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[49567, 1461, 187, 5, 66, "Section"],

Cell[CellGroupData[{
Cell[49779, 1470, 112, 3, 44, "Subsection"],
Cell[49894, 1475, 62, 1, 27, "Input"]
}, Closed]],

Cell[CellGroupData[{
Cell[49993, 1481, 63, 0, 28, "Subsection"],
Cell[50059, 1483, 142, 2, 43, "Input"],

Cell[CellGroupData[{
Cell[50226, 1489, 46, 1, 27, "Input"],
Cell[50275, 1492, 40, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[50352, 1498, 128, 4, 42, "Input"],
Cell[50483, 1504, 38, 1, 22, "Print"],
Cell[50524, 1507, 483, 11, 22, "Print"],
Cell[51010, 1520, 487, 11, 22, "Print"],
Cell[51500, 1533, 498, 11, 22, "Print"],
Cell[52001, 1546, 37, 1, 22, "Print"],
Cell[52041, 1549, 483, 11, 22, "Print"],
Cell[52527, 1562, 487, 11, 22, "Print"],
Cell[53017, 1575, 498, 11, 22, "Print"],
Cell[53518, 1588, 37, 1, 22, "Print"],
Cell[53558, 1591, 524, 12, 22, "Print"],
Cell[54085, 1605, 527, 12, 22, "Print"],
Cell[54615, 1619, 526, 12, 22, "Print"],
Cell[55144, 1633, 37, 1, 22, "Print"],
Cell[55184, 1636, 524, 12, 22, "Print"],
Cell[55711, 1650, 528, 12, 22, "Print"],
Cell[56242, 1664, 527, 12, 22, "Print"],
Cell[56772, 1678, 37, 1, 22, "Print"],
Cell[56812, 1681, 524, 12, 22, "Print"],
Cell[57339, 1695, 527, 12, 22, "Print"],
Cell[57869, 1709, 526, 12, 22, "Print"],
Cell[58398, 1723, 37, 1, 22, "Print"],
Cell[58438, 1726, 524, 12, 22, "Print"],
Cell[58965, 1740, 528, 12, 22, "Print"],
Cell[59496, 1754, 526, 12, 22, "Print"],
Cell[60025, 1768, 37, 1, 22, "Print"],
Cell[60065, 1771, 524, 12, 22, "Print"],
Cell[60592, 1785, 528, 12, 22, "Print"],
Cell[61123, 1799, 527, 12, 22, "Print"],
Cell[61653, 1813, 37, 1, 22, "Print"],
Cell[61693, 1816, 524, 12, 22, "Print"],
Cell[62220, 1830, 528, 12, 22, "Print"],
Cell[62751, 1844, 527, 12, 22, "Print"],
Cell[63281, 1858, 37, 1, 22, "Print"],
Cell[63321, 1861, 524, 12, 22, "Print"],
Cell[63848, 1875, 528, 12, 22, "Print"],
Cell[64379, 1889, 527, 12, 22, "Print"],
Cell[64909, 1903, 37, 1, 22, "Print"],
Cell[64949, 1906, 526, 12, 22, "Print"],
Cell[65478, 1920, 530, 12, 22, "Print"],
Cell[66011, 1934, 529, 12, 22, "Print"],
Cell[66543, 1948, 37, 1, 22, "Print"],
Cell[66583, 1951, 526, 12, 22, "Print"],
Cell[67112, 1965, 530, 12, 22, "Print"],
Cell[67645, 1979, 529, 12, 22, "Print"],
Cell[68177, 1993, 37, 1, 22, "Print"],
Cell[68217, 1996, 526, 12, 22, "Print"],
Cell[68746, 2010, 530, 12, 22, "Print"],
Cell[69279, 2024, 528, 12, 22, "Print"],
Cell[69810, 2038, 37, 1, 22, "Print"],
Cell[69850, 2041, 526, 12, 22, "Print"],
Cell[70379, 2055, 530, 12, 22, "Print"],
Cell[70912, 2069, 527, 12, 22, "Print"],
Cell[71442, 2083, 37, 1, 22, "Print"],
Cell[71482, 2086, 526, 12, 22, "Print"],
Cell[72011, 2100, 530, 12, 22, "Print"],
Cell[72544, 2114, 527, 12, 22, "Print"],
Cell[73074, 2128, 37, 1, 22, "Print"],
Cell[73114, 2131, 526, 12, 22, "Print"],
Cell[73643, 2145, 530, 12, 22, "Print"],
Cell[74176, 2159, 528, 12, 22, "Print"],
Cell[74707, 2173, 37, 1, 22, "Print"],
Cell[74747, 2176, 526, 12, 22, "Print"],
Cell[75276, 2190, 530, 12, 22, "Print"],
Cell[75809, 2204, 529, 12, 22, "Print"],
Cell[76341, 2218, 37, 1, 22, "Print"],
Cell[76381, 2221, 526, 12, 22, "Print"],
Cell[76910, 2235, 530, 12, 22, "Print"],
Cell[77443, 2249, 529, 12, 22, "Print"],
Cell[77975, 2263, 37, 1, 22, "Print"],
Cell[78015, 2266, 526, 12, 22, "Print"],
Cell[78544, 2280, 530, 12, 22, "Print"],
Cell[79077, 2294, 529, 12, 22, "Print"],
Cell[79609, 2308, 37, 1, 22, "Print"],
Cell[79649, 2311, 526, 12, 22, "Print"],
Cell[80178, 2325, 529, 12, 22, "Print"],
Cell[80710, 2339, 529, 12, 22, "Print"],
Cell[81242, 2353, 37, 1, 22, "Print"],
Cell[81282, 2356, 526, 12, 22, "Print"],
Cell[81811, 2370, 530, 12, 22, "Print"],
Cell[82344, 2384, 529, 12, 22, "Print"],
Cell[82876, 2398, 37, 1, 22, "Print"],
Cell[82916, 2401, 526, 12, 22, "Print"],
Cell[83445, 2415, 530, 12, 22, "Print"],
Cell[83978, 2429, 529, 12, 22, "Print"],
Cell[84510, 2443, 37, 1, 22, "Print"],
Cell[84550, 2446, 526, 12, 22, "Print"],
Cell[85079, 2460, 530, 12, 22, "Print"],
Cell[85612, 2474, 528, 12, 22, "Print"],
Cell[86143, 2488, 37, 1, 22, "Print"],
Cell[86183, 2491, 526, 12, 22, "Print"],
Cell[86712, 2505, 529, 12, 22, "Print"],
Cell[87244, 2519, 528, 12, 22, "Print"],
Cell[87775, 2533, 37, 1, 22, "Print"],
Cell[87815, 2536, 526, 12, 22, "Print"],
Cell[88344, 2550, 530, 12, 22, "Print"],
Cell[88877, 2564, 529, 12, 22, "Print"],
Cell[89409, 2578, 37, 1, 22, "Print"],
Cell[89449, 2581, 526, 12, 22, "Print"],
Cell[89978, 2595, 529, 12, 22, "Print"],
Cell[90510, 2609, 529, 12, 22, "Print"],
Cell[91042, 2623, 37, 1, 22, "Print"],
Cell[91082, 2626, 526, 12, 22, "Print"],
Cell[91611, 2640, 513, 12, 22, "Print"],
Cell[92127, 2654, 529, 12, 22, "Print"],
Cell[92659, 2668, 37, 1, 22, "Print"],
Cell[92699, 2671, 526, 12, 22, "Print"],
Cell[93228, 2685, 530, 12, 22, "Print"],
Cell[93761, 2699, 529, 12, 22, "Print"],
Cell[94293, 2713, 37, 1, 22, "Print"],
Cell[94333, 2716, 526, 12, 22, "Print"],
Cell[94862, 2730, 530, 12, 22, "Print"],
Cell[95395, 2744, 529, 12, 22, "Print"],
Cell[95927, 2758, 37, 1, 22, "Print"],
Cell[95967, 2761, 526, 12, 22, "Print"],
Cell[96496, 2775, 530, 12, 22, "Print"],
Cell[97029, 2789, 529, 12, 22, "Print"],
Cell[97561, 2803, 37, 1, 22, "Print"],
Cell[97601, 2806, 525, 12, 22, "Print"],
Cell[98129, 2820, 530, 12, 22, "Print"],
Cell[98662, 2834, 529, 12, 22, "Print"],
Cell[99194, 2848, 37, 1, 22, "Print"],
Cell[99234, 2851, 526, 12, 22, "Print"],
Cell[99763, 2865, 530, 12, 22, "Print"],
Cell[100296, 2879, 529, 12, 22, "Print"],
Cell[100828, 2893, 37, 1, 22, "Print"],
Cell[100868, 2896, 526, 12, 22, "Print"],
Cell[101397, 2910, 530, 12, 22, "Print"],
Cell[101930, 2924, 528, 12, 22, "Print"],
Cell[102461, 2938, 37, 1, 22, "Print"],
Cell[102501, 2941, 526, 12, 22, "Print"],
Cell[103030, 2955, 530, 12, 22, "Print"],
Cell[103563, 2969, 528, 12, 22, "Print"],
Cell[104094, 2983, 37, 1, 22, "Print"],
Cell[104134, 2986, 526, 12, 22, "Print"],
Cell[104663, 3000, 530, 12, 22, "Print"],
Cell[105196, 3014, 529, 12, 22, "Print"],
Cell[105728, 3028, 37, 1, 22, "Print"],
Cell[105768, 3031, 526, 12, 22, "Print"],
Cell[106297, 3045, 530, 12, 22, "Print"],
Cell[106830, 3059, 529, 12, 22, "Print"],
Cell[107362, 3073, 37, 1, 22, "Print"],
Cell[107402, 3076, 526, 12, 22, "Print"],
Cell[107931, 3090, 530, 12, 22, "Print"],
Cell[108464, 3104, 528, 12, 22, "Print"],
Cell[108995, 3118, 37, 1, 22, "Print"],
Cell[109035, 3121, 526, 12, 22, "Print"],
Cell[109564, 3135, 530, 12, 22, "Print"],
Cell[110097, 3149, 528, 12, 22, "Print"],
Cell[110628, 3163, 37, 1, 22, "Print"],
Cell[110668, 3166, 525, 12, 22, "Print"],
Cell[111196, 3180, 529, 12, 22, "Print"],
Cell[111728, 3194, 529, 12, 22, "Print"],
Cell[112260, 3208, 37, 1, 22, "Print"],
Cell[112300, 3211, 526, 12, 22, "Print"],
Cell[112829, 3225, 529, 12, 22, "Print"],
Cell[113361, 3239, 529, 12, 22, "Print"],
Cell[113893, 3253, 37, 1, 22, "Print"],
Cell[113933, 3256, 526, 12, 22, "Print"],
Cell[114462, 3270, 530, 12, 22, "Print"],
Cell[114995, 3284, 529, 12, 22, "Print"],
Cell[115527, 3298, 37, 1, 22, "Print"],
Cell[115567, 3301, 526, 12, 22, "Print"],
Cell[116096, 3315, 530, 12, 22, "Print"],
Cell[116629, 3329, 529, 12, 22, "Print"],
Cell[117161, 3343, 37, 1, 22, "Print"],
Cell[117201, 3346, 526, 12, 22, "Print"],
Cell[117730, 3360, 530, 12, 22, "Print"],
Cell[118263, 3374, 529, 12, 22, "Print"],
Cell[118795, 3388, 37, 1, 22, "Print"],
Cell[118835, 3391, 526, 12, 22, "Print"],
Cell[119364, 3405, 529, 12, 22, "Print"],
Cell[119896, 3419, 529, 12, 22, "Print"],
Cell[120428, 3433, 37, 1, 22, "Print"],
Cell[120468, 3436, 526, 12, 22, "Print"],
Cell[120997, 3450, 529, 12, 22, "Print"],
Cell[121529, 3464, 529, 12, 22, "Print"],
Cell[122061, 3478, 37, 1, 22, "Print"],
Cell[122101, 3481, 526, 12, 22, "Print"],
Cell[122630, 3495, 529, 12, 22, "Print"],
Cell[123162, 3509, 531, 12, 22, "Print"],
Cell[123696, 3523, 37, 1, 22, "Print"],
Cell[123736, 3526, 526, 12, 22, "Print"],
Cell[124265, 3540, 530, 12, 22, "Print"],
Cell[124798, 3554, 531, 12, 22, "Print"],
Cell[125332, 3568, 37, 1, 22, "Print"],
Cell[125372, 3571, 526, 12, 22, "Print"],
Cell[125901, 3585, 530, 12, 22, "Print"],
Cell[126434, 3599, 530, 12, 22, "Print"],
Cell[126967, 3613, 37, 1, 22, "Print"],
Cell[127007, 3616, 526, 12, 22, "Print"],
Cell[127536, 3630, 530, 12, 22, "Print"],
Cell[128069, 3644, 562, 13, 22, "Print"],
Cell[128634, 3659, 37, 1, 22, "Print"],
Cell[128674, 3662, 524, 12, 22, "Print"],
Cell[129201, 3676, 530, 12, 22, "Print"],
Cell[129734, 3690, 531, 12, 22, "Print"],
Cell[130268, 3704, 37, 1, 22, "Print"],
Cell[130308, 3707, 38, 1, 22, "Print"],
Cell[130349, 3710, 306, 6, 22, "Print"],
Cell[130658, 3718, 310, 6, 22, "Print"],
Cell[130971, 3726, 306, 6, 22, "Print"],
Cell[131280, 3734, 37, 1, 22, "Print"],
Cell[131320, 3737, 306, 6, 22, "Print"],
Cell[131629, 3745, 310, 6, 22, "Print"],
Cell[131942, 3753, 306, 6, 22, "Print"],
Cell[132251, 3761, 37, 1, 22, "Print"],
Cell[132291, 3764, 306, 6, 22, "Print"],
Cell[132600, 3772, 310, 6, 22, "Print"],
Cell[132913, 3780, 306, 6, 22, "Print"],
Cell[133222, 3788, 37, 1, 22, "Print"],
Cell[133262, 3791, 306, 6, 22, "Print"],
Cell[133571, 3799, 310, 6, 22, "Print"],
Cell[133884, 3807, 306, 6, 22, "Print"],
Cell[134193, 3815, 37, 1, 22, "Print"],
Cell[134233, 3818, 306, 6, 22, "Print"],
Cell[134542, 3826, 310, 6, 22, "Print"],
Cell[134855, 3834, 306, 6, 22, "Print"],
Cell[135164, 3842, 37, 1, 22, "Print"],
Cell[135204, 3845, 306, 6, 22, "Print"],
Cell[135513, 3853, 310, 6, 22, "Print"],
Cell[135826, 3861, 306, 6, 22, "Print"],
Cell[136135, 3869, 37, 1, 22, "Print"],
Cell[136175, 3872, 306, 6, 22, "Print"],
Cell[136484, 3880, 310, 6, 22, "Print"],
Cell[136797, 3888, 306, 6, 22, "Print"],
Cell[137106, 3896, 37, 1, 22, "Print"],
Cell[137146, 3899, 306, 6, 22, "Print"],
Cell[137455, 3907, 310, 6, 22, "Print"],
Cell[137768, 3915, 306, 6, 22, "Print"],
Cell[138077, 3923, 37, 1, 22, "Print"],
Cell[138117, 3926, 306, 6, 22, "Print"],
Cell[138426, 3934, 310, 6, 22, "Print"],
Cell[138739, 3942, 306, 6, 22, "Print"],
Cell[139048, 3950, 37, 1, 22, "Print"],
Cell[139088, 3953, 308, 6, 22, "Print"],
Cell[139399, 3961, 312, 6, 22, "Print"],
Cell[139714, 3969, 308, 6, 22, "Print"],
Cell[140025, 3977, 37, 1, 22, "Print"],
Cell[140065, 3980, 308, 6, 22, "Print"],
Cell[140376, 3988, 312, 6, 22, "Print"],
Cell[140691, 3996, 308, 6, 22, "Print"],
Cell[141002, 4004, 37, 1, 22, "Print"],
Cell[141042, 4007, 308, 6, 22, "Print"],
Cell[141353, 4015, 312, 6, 22, "Print"],
Cell[141668, 4023, 308, 6, 22, "Print"],
Cell[141979, 4031, 37, 1, 22, "Print"],
Cell[142019, 4034, 308, 6, 22, "Print"],
Cell[142330, 4042, 312, 6, 22, "Print"],
Cell[142645, 4050, 308, 6, 22, "Print"],
Cell[142956, 4058, 37, 1, 22, "Print"],
Cell[142996, 4061, 308, 6, 22, "Print"],
Cell[143307, 4069, 312, 6, 22, "Print"],
Cell[143622, 4077, 308, 6, 22, "Print"],
Cell[143933, 4085, 37, 1, 22, "Print"],
Cell[143973, 4088, 308, 6, 22, "Print"],
Cell[144284, 4096, 312, 6, 22, "Print"],
Cell[144599, 4104, 308, 6, 22, "Print"],
Cell[144910, 4112, 37, 1, 22, "Print"],
Cell[144950, 4115, 308, 6, 22, "Print"],
Cell[145261, 4123, 312, 6, 22, "Print"],
Cell[145576, 4131, 308, 6, 22, "Print"],
Cell[145887, 4139, 37, 1, 22, "Print"],
Cell[145927, 4142, 308, 6, 22, "Print"],
Cell[146238, 4150, 312, 6, 22, "Print"],
Cell[146553, 4158, 308, 6, 22, "Print"],
Cell[146864, 4166, 37, 1, 22, "Print"],
Cell[146904, 4169, 308, 6, 22, "Print"],
Cell[147215, 4177, 312, 6, 22, "Print"],
Cell[147530, 4185, 308, 6, 22, "Print"],
Cell[147841, 4193, 37, 1, 22, "Print"],
Cell[147881, 4196, 308, 6, 22, "Print"],
Cell[148192, 4204, 312, 6, 22, "Print"],
Cell[148507, 4212, 308, 6, 22, "Print"],
Cell[148818, 4220, 37, 1, 22, "Print"],
Cell[148858, 4223, 308, 6, 22, "Print"],
Cell[149169, 4231, 312, 6, 22, "Print"],
Cell[149484, 4239, 308, 6, 22, "Print"],
Cell[149795, 4247, 37, 1, 22, "Print"],
Cell[149835, 4250, 308, 6, 22, "Print"],
Cell[150146, 4258, 312, 6, 22, "Print"],
Cell[150461, 4266, 308, 6, 22, "Print"],
Cell[150772, 4274, 37, 1, 22, "Print"],
Cell[150812, 4277, 308, 6, 22, "Print"],
Cell[151123, 4285, 312, 6, 22, "Print"],
Cell[151438, 4293, 308, 6, 22, "Print"],
Cell[151749, 4301, 37, 1, 22, "Print"],
Cell[151789, 4304, 308, 6, 22, "Print"],
Cell[152100, 4312, 312, 6, 22, "Print"],
Cell[152415, 4320, 308, 6, 22, "Print"],
Cell[152726, 4328, 37, 1, 22, "Print"],
Cell[152766, 4331, 308, 6, 22, "Print"],
Cell[153077, 4339, 312, 6, 22, "Print"],
Cell[153392, 4347, 308, 6, 22, "Print"],
Cell[153703, 4355, 37, 1, 22, "Print"],
Cell[153743, 4358, 308, 6, 22, "Print"],
Cell[154054, 4366, 312, 6, 22, "Print"],
Cell[154369, 4374, 308, 6, 22, "Print"],
Cell[154680, 4382, 37, 1, 22, "Print"],
Cell[154720, 4385, 308, 6, 22, "Print"],
Cell[155031, 4393, 312, 6, 22, "Print"],
Cell[155346, 4401, 308, 6, 22, "Print"],
Cell[155657, 4409, 37, 1, 22, "Print"],
Cell[155697, 4412, 308, 6, 22, "Print"],
Cell[156008, 4420, 312, 6, 22, "Print"],
Cell[156323, 4428, 308, 6, 22, "Print"],
Cell[156634, 4436, 37, 1, 22, "Print"],
Cell[156674, 4439, 308, 6, 22, "Print"],
Cell[156985, 4447, 312, 6, 22, "Print"],
Cell[157300, 4455, 308, 6, 22, "Print"],
Cell[157611, 4463, 37, 1, 22, "Print"],
Cell[157651, 4466, 308, 6, 22, "Print"],
Cell[157962, 4474, 312, 6, 22, "Print"],
Cell[158277, 4482, 308, 6, 22, "Print"],
Cell[158588, 4490, 37, 1, 22, "Print"],
Cell[158628, 4493, 308, 6, 22, "Print"],
Cell[158939, 4501, 312, 6, 22, "Print"],
Cell[159254, 4509, 308, 6, 22, "Print"],
Cell[159565, 4517, 37, 1, 22, "Print"],
Cell[159605, 4520, 308, 6, 22, "Print"],
Cell[159916, 4528, 312, 6, 22, "Print"],
Cell[160231, 4536, 308, 6, 22, "Print"],
Cell[160542, 4544, 37, 1, 22, "Print"],
Cell[160582, 4547, 308, 6, 22, "Print"],
Cell[160893, 4555, 312, 6, 22, "Print"],
Cell[161208, 4563, 308, 6, 22, "Print"],
Cell[161519, 4571, 37, 1, 22, "Print"],
Cell[161559, 4574, 308, 6, 22, "Print"],
Cell[161870, 4582, 312, 6, 22, "Print"],
Cell[162185, 4590, 308, 6, 22, "Print"],
Cell[162496, 4598, 37, 1, 22, "Print"],
Cell[162536, 4601, 308, 6, 22, "Print"],
Cell[162847, 4609, 312, 6, 22, "Print"],
Cell[163162, 4617, 308, 6, 22, "Print"],
Cell[163473, 4625, 37, 1, 22, "Print"],
Cell[163513, 4628, 308, 6, 22, "Print"],
Cell[163824, 4636, 312, 6, 22, "Print"],
Cell[164139, 4644, 308, 6, 22, "Print"],
Cell[164450, 4652, 37, 1, 22, "Print"],
Cell[164490, 4655, 308, 6, 22, "Print"],
Cell[164801, 4663, 312, 6, 22, "Print"],
Cell[165116, 4671, 308, 6, 22, "Print"],
Cell[165427, 4679, 37, 1, 22, "Print"],
Cell[165467, 4682, 308, 6, 22, "Print"],
Cell[165778, 4690, 312, 6, 22, "Print"],
Cell[166093, 4698, 308, 6, 22, "Print"],
Cell[166404, 4706, 37, 1, 22, "Print"],
Cell[166444, 4709, 308, 6, 22, "Print"],
Cell[166755, 4717, 312, 6, 22, "Print"],
Cell[167070, 4725, 308, 6, 22, "Print"],
Cell[167381, 4733, 37, 1, 22, "Print"],
Cell[167421, 4736, 308, 6, 22, "Print"],
Cell[167732, 4744, 312, 6, 22, "Print"],
Cell[168047, 4752, 308, 6, 22, "Print"],
Cell[168358, 4760, 37, 1, 22, "Print"],
Cell[168398, 4763, 308, 6, 22, "Print"],
Cell[168709, 4771, 312, 6, 22, "Print"],
Cell[169024, 4779, 308, 6, 22, "Print"],
Cell[169335, 4787, 37, 1, 22, "Print"],
Cell[169375, 4790, 308, 6, 22, "Print"],
Cell[169686, 4798, 312, 6, 22, "Print"],
Cell[170001, 4806, 308, 6, 22, "Print"],
Cell[170312, 4814, 37, 1, 22, "Print"],
Cell[170352, 4817, 308, 6, 22, "Print"],
Cell[170663, 4825, 312, 6, 22, "Print"],
Cell[170978, 4833, 308, 6, 22, "Print"],
Cell[171289, 4841, 37, 1, 22, "Print"],
Cell[171329, 4844, 308, 6, 22, "Print"],
Cell[171640, 4852, 312, 6, 22, "Print"],
Cell[171955, 4860, 308, 6, 22, "Print"],
Cell[172266, 4868, 37, 1, 22, "Print"],
Cell[172306, 4871, 308, 6, 22, "Print"],
Cell[172617, 4879, 312, 6, 22, "Print"],
Cell[172932, 4887, 308, 6, 22, "Print"],
Cell[173243, 4895, 37, 1, 22, "Print"],
Cell[173283, 4898, 308, 6, 22, "Print"],
Cell[173594, 4906, 312, 6, 22, "Print"],
Cell[173909, 4914, 308, 6, 22, "Print"],
Cell[174220, 4922, 37, 1, 22, "Print"],
Cell[174260, 4925, 308, 6, 22, "Print"],
Cell[174571, 4933, 312, 6, 22, "Print"],
Cell[174886, 4941, 308, 6, 22, "Print"],
Cell[175197, 4949, 37, 1, 22, "Print"],
Cell[175237, 4952, 308, 6, 22, "Print"],
Cell[175548, 4960, 312, 6, 22, "Print"],
Cell[175863, 4968, 308, 6, 22, "Print"],
Cell[176174, 4976, 37, 1, 22, "Print"],
Cell[176214, 4979, 308, 6, 22, "Print"],
Cell[176525, 4987, 312, 6, 22, "Print"],
Cell[176840, 4995, 308, 6, 22, "Print"],
Cell[177151, 5003, 37, 1, 22, "Print"],
Cell[177191, 5006, 308, 6, 22, "Print"],
Cell[177502, 5014, 312, 6, 22, "Print"],
Cell[177817, 5022, 308, 6, 22, "Print"],
Cell[178128, 5030, 37, 1, 22, "Print"],
Cell[178168, 5033, 308, 6, 22, "Print"],
Cell[178479, 5041, 312, 6, 22, "Print"],
Cell[178794, 5049, 308, 6, 22, "Print"],
Cell[179105, 5057, 37, 1, 22, "Print"],
Cell[179145, 5060, 70, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[179252, 5066, 46, 1, 27, "Input"],
Cell[179301, 5069, 41, 1, 26, "Output"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{
Cell[179391, 5076, 62, 0, 28, "Subsection"],
Cell[179456, 5078, 142, 2, 43, "Input"],

Cell[CellGroupData[{
Cell[179623, 5084, 46, 1, 27, "Input"],
Cell[179672, 5087, 41, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[179750, 5093, 127, 4, 42, "Input"],
Cell[179880, 5099, 249, 5, 22, "Print"],
Cell[180132, 5106, 253, 5, 22, "Print"],
Cell[180388, 5113, 251, 5, 22, "Print"],
Cell[180642, 5120, 37, 1, 22, "Print"],
Cell[180682, 5123, 249, 5, 22, "Print"],
Cell[180934, 5130, 253, 5, 22, "Print"],
Cell[181190, 5137, 251, 5, 22, "Print"],
Cell[181444, 5144, 37, 1, 22, "Print"],
Cell[181484, 5147, 249, 5, 22, "Print"],
Cell[181736, 5154, 253, 5, 22, "Print"],
Cell[181992, 5161, 251, 5, 22, "Print"],
Cell[182246, 5168, 37, 1, 22, "Print"],
Cell[182286, 5171, 249, 5, 22, "Print"],
Cell[182538, 5178, 253, 5, 22, "Print"],
Cell[182794, 5185, 251, 5, 22, "Print"],
Cell[183048, 5192, 37, 1, 22, "Print"],
Cell[183088, 5195, 249, 5, 22, "Print"],
Cell[183340, 5202, 253, 5, 22, "Print"],
Cell[183596, 5209, 251, 5, 22, "Print"],
Cell[183850, 5216, 37, 1, 22, "Print"],
Cell[183890, 5219, 249, 5, 22, "Print"],
Cell[184142, 5226, 253, 5, 22, "Print"],
Cell[184398, 5233, 251, 5, 22, "Print"],
Cell[184652, 5240, 37, 1, 22, "Print"],
Cell[184692, 5243, 249, 5, 22, "Print"],
Cell[184944, 5250, 253, 5, 22, "Print"],
Cell[185200, 5257, 251, 5, 22, "Print"],
Cell[185454, 5264, 37, 1, 22, "Print"],
Cell[185494, 5267, 249, 5, 22, "Print"],
Cell[185746, 5274, 253, 5, 22, "Print"],
Cell[186002, 5281, 251, 5, 22, "Print"],
Cell[186256, 5288, 37, 1, 22, "Print"],
Cell[186296, 5291, 249, 5, 22, "Print"],
Cell[186548, 5298, 253, 5, 22, "Print"],
Cell[186804, 5305, 251, 5, 22, "Print"],
Cell[187058, 5312, 37, 1, 22, "Print"],
Cell[187098, 5315, 249, 5, 22, "Print"],
Cell[187350, 5322, 253, 5, 22, "Print"],
Cell[187606, 5329, 251, 5, 22, "Print"],
Cell[187860, 5336, 37, 1, 22, "Print"],
Cell[187900, 5339, 251, 5, 22, "Print"],
Cell[188154, 5346, 255, 5, 22, "Print"],
Cell[188412, 5353, 253, 5, 22, "Print"],
Cell[188668, 5360, 37, 1, 22, "Print"],
Cell[188708, 5363, 251, 5, 22, "Print"],
Cell[188962, 5370, 255, 5, 22, "Print"],
Cell[189220, 5377, 253, 5, 22, "Print"],
Cell[189476, 5384, 37, 1, 22, "Print"],
Cell[189516, 5387, 251, 5, 22, "Print"],
Cell[189770, 5394, 255, 5, 22, "Print"],
Cell[190028, 5401, 253, 5, 22, "Print"],
Cell[190284, 5408, 37, 1, 22, "Print"],
Cell[190324, 5411, 251, 5, 22, "Print"],
Cell[190578, 5418, 255, 5, 22, "Print"],
Cell[190836, 5425, 253, 5, 22, "Print"],
Cell[191092, 5432, 37, 1, 22, "Print"],
Cell[191132, 5435, 251, 5, 22, "Print"],
Cell[191386, 5442, 255, 5, 22, "Print"],
Cell[191644, 5449, 253, 5, 22, "Print"],
Cell[191900, 5456, 37, 1, 22, "Print"],
Cell[191940, 5459, 251, 5, 22, "Print"],
Cell[192194, 5466, 255, 5, 22, "Print"],
Cell[192452, 5473, 253, 5, 22, "Print"],
Cell[192708, 5480, 37, 1, 22, "Print"],
Cell[192748, 5483, 251, 5, 22, "Print"],
Cell[193002, 5490, 255, 5, 22, "Print"],
Cell[193260, 5497, 253, 5, 22, "Print"],
Cell[193516, 5504, 37, 1, 22, "Print"],
Cell[193556, 5507, 251, 5, 22, "Print"],
Cell[193810, 5514, 255, 5, 22, "Print"],
Cell[194068, 5521, 253, 5, 22, "Print"],
Cell[194324, 5528, 37, 1, 22, "Print"],
Cell[194364, 5531, 251, 5, 22, "Print"],
Cell[194618, 5538, 255, 5, 22, "Print"],
Cell[194876, 5545, 253, 5, 22, "Print"],
Cell[195132, 5552, 37, 1, 22, "Print"],
Cell[195172, 5555, 251, 5, 22, "Print"],
Cell[195426, 5562, 255, 5, 22, "Print"],
Cell[195684, 5569, 253, 5, 22, "Print"],
Cell[195940, 5576, 37, 1, 22, "Print"],
Cell[195980, 5579, 251, 5, 22, "Print"],
Cell[196234, 5586, 255, 5, 22, "Print"],
Cell[196492, 5593, 253, 5, 22, "Print"],
Cell[196748, 5600, 37, 1, 22, "Print"],
Cell[196788, 5603, 251, 5, 22, "Print"],
Cell[197042, 5610, 255, 5, 22, "Print"],
Cell[197300, 5617, 253, 5, 22, "Print"],
Cell[197556, 5624, 37, 1, 22, "Print"],
Cell[197596, 5627, 251, 5, 22, "Print"],
Cell[197850, 5634, 255, 5, 22, "Print"],
Cell[198108, 5641, 253, 5, 22, "Print"],
Cell[198364, 5648, 37, 1, 22, "Print"],
Cell[198404, 5651, 251, 5, 22, "Print"],
Cell[198658, 5658, 255, 5, 22, "Print"],
Cell[198916, 5665, 253, 5, 22, "Print"],
Cell[199172, 5672, 37, 1, 22, "Print"],
Cell[199212, 5675, 251, 5, 22, "Print"],
Cell[199466, 5682, 255, 5, 22, "Print"],
Cell[199724, 5689, 253, 5, 22, "Print"],
Cell[199980, 5696, 37, 1, 22, "Print"],
Cell[200020, 5699, 251, 5, 22, "Print"],
Cell[200274, 5706, 255, 5, 22, "Print"],
Cell[200532, 5713, 253, 5, 22, "Print"],
Cell[200788, 5720, 37, 1, 22, "Print"],
Cell[200828, 5723, 251, 5, 22, "Print"],
Cell[201082, 5730, 255, 5, 22, "Print"],
Cell[201340, 5737, 253, 5, 22, "Print"],
Cell[201596, 5744, 37, 1, 22, "Print"],
Cell[201636, 5747, 251, 5, 22, "Print"],
Cell[201890, 5754, 255, 5, 22, "Print"],
Cell[202148, 5761, 253, 5, 22, "Print"],
Cell[202404, 5768, 37, 1, 22, "Print"],
Cell[202444, 5771, 251, 5, 22, "Print"],
Cell[202698, 5778, 255, 5, 22, "Print"],
Cell[202956, 5785, 253, 5, 22, "Print"],
Cell[203212, 5792, 37, 1, 22, "Print"],
Cell[203252, 5795, 251, 5, 22, "Print"],
Cell[203506, 5802, 255, 5, 22, "Print"],
Cell[203764, 5809, 253, 5, 22, "Print"],
Cell[204020, 5816, 37, 1, 22, "Print"],
Cell[204060, 5819, 251, 5, 22, "Print"],
Cell[204314, 5826, 255, 5, 22, "Print"],
Cell[204572, 5833, 253, 5, 22, "Print"],
Cell[204828, 5840, 37, 1, 22, "Print"],
Cell[204868, 5843, 251, 5, 22, "Print"],
Cell[205122, 5850, 255, 5, 22, "Print"],
Cell[205380, 5857, 253, 5, 22, "Print"],
Cell[205636, 5864, 37, 1, 22, "Print"],
Cell[205676, 5867, 251, 5, 22, "Print"],
Cell[205930, 5874, 255, 5, 22, "Print"],
Cell[206188, 5881, 253, 5, 22, "Print"],
Cell[206444, 5888, 37, 1, 22, "Print"],
Cell[206484, 5891, 251, 5, 22, "Print"],
Cell[206738, 5898, 255, 5, 22, "Print"],
Cell[206996, 5905, 253, 5, 22, "Print"],
Cell[207252, 5912, 37, 1, 22, "Print"],
Cell[207292, 5915, 251, 5, 22, "Print"],
Cell[207546, 5922, 255, 5, 22, "Print"],
Cell[207804, 5929, 253, 5, 22, "Print"],
Cell[208060, 5936, 37, 1, 22, "Print"],
Cell[208100, 5939, 251, 5, 22, "Print"],
Cell[208354, 5946, 255, 5, 22, "Print"],
Cell[208612, 5953, 253, 5, 22, "Print"],
Cell[208868, 5960, 37, 1, 22, "Print"],
Cell[208908, 5963, 251, 5, 22, "Print"],
Cell[209162, 5970, 255, 5, 22, "Print"],
Cell[209420, 5977, 253, 5, 22, "Print"],
Cell[209676, 5984, 37, 1, 22, "Print"],
Cell[209716, 5987, 251, 5, 22, "Print"],
Cell[209970, 5994, 255, 5, 22, "Print"],
Cell[210228, 6001, 253, 5, 22, "Print"],
Cell[210484, 6008, 37, 1, 22, "Print"],
Cell[210524, 6011, 251, 5, 22, "Print"],
Cell[210778, 6018, 255, 5, 22, "Print"],
Cell[211036, 6025, 253, 5, 22, "Print"],
Cell[211292, 6032, 37, 1, 22, "Print"],
Cell[211332, 6035, 251, 5, 22, "Print"],
Cell[211586, 6042, 255, 5, 22, "Print"],
Cell[211844, 6049, 253, 5, 22, "Print"],
Cell[212100, 6056, 37, 1, 22, "Print"],
Cell[212140, 6059, 251, 5, 22, "Print"],
Cell[212394, 6066, 255, 5, 22, "Print"],
Cell[212652, 6073, 253, 5, 22, "Print"],
Cell[212908, 6080, 37, 1, 22, "Print"],
Cell[212948, 6083, 251, 5, 22, "Print"],
Cell[213202, 6090, 255, 5, 22, "Print"],
Cell[213460, 6097, 253, 5, 22, "Print"],
Cell[213716, 6104, 37, 1, 22, "Print"],
Cell[213756, 6107, 251, 5, 22, "Print"],
Cell[214010, 6114, 255, 5, 22, "Print"],
Cell[214268, 6121, 253, 5, 22, "Print"],
Cell[214524, 6128, 37, 1, 22, "Print"],
Cell[214564, 6131, 251, 5, 22, "Print"],
Cell[214818, 6138, 255, 5, 22, "Print"],
Cell[215076, 6145, 253, 5, 22, "Print"],
Cell[215332, 6152, 37, 1, 22, "Print"],
Cell[215372, 6155, 251, 5, 22, "Print"],
Cell[215626, 6162, 255, 5, 22, "Print"],
Cell[215884, 6169, 253, 5, 22, "Print"],
Cell[216140, 6176, 37, 1, 22, "Print"],
Cell[216180, 6179, 251, 5, 22, "Print"],
Cell[216434, 6186, 255, 5, 22, "Print"],
Cell[216692, 6193, 253, 5, 22, "Print"],
Cell[216948, 6200, 37, 1, 22, "Print"],
Cell[216988, 6203, 251, 5, 22, "Print"],
Cell[217242, 6210, 255, 5, 22, "Print"],
Cell[217500, 6217, 253, 5, 22, "Print"],
Cell[217756, 6224, 37, 1, 22, "Print"],
Cell[217796, 6227, 251, 5, 22, "Print"],
Cell[218050, 6234, 255, 5, 22, "Print"],
Cell[218308, 6241, 253, 5, 22, "Print"],
Cell[218564, 6248, 37, 1, 22, "Print"],
Cell[218604, 6251, 251, 5, 22, "Print"],
Cell[218858, 6258, 255, 5, 22, "Print"],
Cell[219116, 6265, 253, 5, 22, "Print"],
Cell[219372, 6272, 37, 1, 22, "Print"],
Cell[219412, 6275, 251, 5, 22, "Print"],
Cell[219666, 6282, 255, 5, 22, "Print"],
Cell[219924, 6289, 253, 5, 22, "Print"],
Cell[220180, 6296, 37, 1, 22, "Print"],
Cell[220220, 6299, 70, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[220327, 6305, 46, 1, 27, "Input"],
Cell[220376, 6308, 41, 1, 26, "Output"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{
Cell[220466, 6315, 101, 3, 28, "Subsection"],
Cell[220570, 6320, 140, 2, 43, "Input"],

Cell[CellGroupData[{
Cell[220735, 6326, 46, 1, 27, "Input"],
Cell[220784, 6329, 41, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[220862, 6335, 96, 1, 27, "Input"],
Cell[220961, 6338, 491, 11, 22, "Print"],
Cell[221455, 6351, 323, 7, 22, "Print"],
Cell[221781, 6360, 346, 8, 24, "Print"],
Cell[222130, 6370, 605, 15, 24, "Print"],
Cell[222738, 6387, 666, 17, 24, "Print"],
Cell[223407, 6406, 727, 18, 24, "Print"],
Cell[224137, 6426, 883, 21, 24, "Print"],
Cell[225023, 6449, 892, 22, 24, "Print"],
Cell[225918, 6473, 921, 23, 24, "Print"],
Cell[226842, 6498, 1096, 27, 39, "Print"],
Cell[227941, 6527, 1158, 29, 41, "Print"],
Cell[229102, 6558, 1188, 30, 41, "Print"],
Cell[230293, 6590, 1343, 33, 41, "Print"],
Cell[231639, 6625, 1354, 34, 41, "Print"],
Cell[232996, 6661, 1384, 35, 41, "Print"],
Cell[234383, 6698, 1558, 39, 41, "Print"],
Cell[235944, 6739, 70, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[236051, 6745, 46, 1, 27, "Input"],
Cell[236100, 6748, 41, 1, 26, "Output"]
}, Open  ]]
}, Closed]]
}, Closed]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

