(* :Title: datamodchvnew.m   *)

(* :Context: modchebyshev`datamodchvnew` *)

(* :Author:  Zlia da ROCHA *)

(* :Address: 
            Departamento de Matemtica Aplicada da
            Faculdade de Cincias do Porto
            Rua das Taipas, 135
            4050 Porto
            Portugal
  
            Tel: ++351 02 2080313
            Fax: ++351 02 2004109
            Email: mrdioh@fc.up.pt
*)
(* :Summary:
    The datamodchvnew package contains the definitions
    form, auxgamma, auxbeta, gammaexact and betaexact
    that the package modchv needs, corresponding to 
    a new example given by the user.    
*)
(* :Date: July 1999. *)

(* :Available at http://netlib.bell-labs.com/ in the 
    numeralgo library in netlib:       *)

(* :Package Version: 1.0 *)

(* :Mathematica Version: 3.0 *)  
 
(* :Keywords: Modified Chebyshev's method, recurrence
              relations, orthogonal polynomials of 
              dimension d, d-dimensional forms.
*)
(* :Sources:

 - Z. da Rocha, Shohat-Favard and Chebyshev's
   methods in d-orthogonality, Numerical Algorithms,
   20 (1999) 139-164.
*)

(* :Warnings: How to load this package.

This package must be putted in a directory named 
modchebyshev. 
Note that the directory containing the modchebyshev
directory must be on the file search path $Path.

This package contains the definitions needed in the
package modchv.m. 
The context corresponding to this package 
(modchebyshev`datamodchvnew`) must be written in the
BeginPackage command of the package modchv.m.
Then, when you load the package modchv.m doing 
<<modchebyshev`modchv`or Needs["modchebyshev`modchv`"],
in any notebook, this package is automatically loaded. 
*)



BeginPackage["modchebyshev`datamodchvnew`"]

datamodchvnew::usage="is a package that contains
the definitions of:

- the moments of the d forms with respect to which
  the polynomials are orthogonal of dimension d
  (form),
  
- the d gamma coefficients and the beta coefficient
  of the recurrence relation of the auxiliary family
  of orthogonal polynomials of dimension d 
  (auxgamma, auxbeta),
  
- the exact expression of the d gamma coefficients
  and the beta coefficient that appear in the 
  (d+1)-order recurrence relation satisfied by 
  orthogonal polynomials of dimension d, in the case
  they are known (gammaexact, betaexact),
  
corresponding to a new example given by the user.

The definitions form, auxgamma, auxbeta, gammaexact 
and betaexact are used in the package modchv.m."


form::usage="
form[d, alpha, n] is the moment of order n (n>=0)
of the form of order alpha (1<=alpha<=d), with
respect to which the polynomials are orthogonal
of dimension d.
form is used in the package modchv.m."

auxgamma::usage="
auxgamma[ d, r, n ], n>=1,
is the n-th gamma coefficient of order r (0<=r<=d-1),
that appears in the (d+1)-order recurrence relation
satisfied by the auxiliary sequence of orthogonal
polynomials of dimension d.
auxgamma is used in the package modchv.m."

auxbeta::usage="
auxbeta[ d, n ], n>=1,
is the n-th beta coefficient that appears in the 
(d+1)-order recurrence relation satisfied by the
auxiliary sequence of orthogonal polynomials of
dimension d.
auxbeta is used in the package modchv.m."

gammaexact::usage="
gammaexact[ d, r, n ], is the exact expression of
the n-th gamma coefficient of order r (n>=1,
0<=r<=d-1), that appears in the (d+1)-order recurrence
relation satisfied by orthogonal polynomials of
dimension d.
gammaexact is used in the package modchv.m."

betaexact::usage="
betaexact[ d, n ], n>=0, is the exact expression of
the n-th beta coefficient, that appears in the 
(d+1)-order recurrence relation satisfied by
orthogonal polynomials of dimension d.
betaexact is used in the package modchv.m."


Begin["`Private`"]

(*___________________________________________

                Error Messages
 __________________________________________*)
   
form::badarg2=
   "wrong value to the second argument
    alpha=`1` in form;
    alpha must be an integer and verify
    1<=alpha<=`2`;
    try again"

form::badarg3=
   "wrong value to the third argument n=`1` in form;
    n must be an integer;
    try again" 

auxgamma::badarg2=
   "wrong value to the second argument r=`1`
    in auxgamma; r must be an integer and
    verify 0<=r<=`2`;
    try again"

auxgamma::badarg3=
   "wrong value to the third argument n=`1`
    in auxgamma;
    n must be an integer;
    try again" 

auxbeta::badarg2=
   "wrong value to the second argument n=`1`
    in auxbeta;
    n must be an integer;
    try again" 

gammaexact::badarg2=
   "wrong value to the second argument r=`1`
    in gammaexact; r must be an integer and
    verify 0<=r<=`2`;
    try again"

gammaexact::badarg3=
   "wrong value to the third argument n=`1`
    in gammaexact;
    n must be an integer;
    try again" 

betaexact::badarg2=
   "wrong value to the second argument n=`1`
    in betaexact;
    n must be an integer;
    try again" 

(*___________________________________________

             Exported definition
___________________________________________*)
(*___________________________________________

   the moments of the d-dimensional form
___________________________________________*)

form[d_,alpha_,n_]:=form[d,alpha,n]=

 Block[{},
 
 (*_________ checking the arguments _________*)
   If[Or[alpha<1,alpha>d,Not[IntegerQ[alpha]]],
    
 	  Return[Message[form::badarg2,alpha,d]]
 	 ];	 
   
   If[Not[IntegerQ[n]],
   
      Return[Message[form::badarg3,n]]
     ];
(*_________________________________________*)

    (* TO FILL IN BY THE USER *)
    
(*_____________________________________________*)
   
]; (*end of Block*)  
 
 
(*_______________________________________________

the gamma coefficients of the auxiliary sequence 
of d-orthogonal polynomials
________________________________________________*)

auxgamma[d_,r_,n_]:=auxgamma[d,r,n]=

 Block[{},
 (*_________ checking the arguments __________*)  
  If[Or[r<0,r>=d,Not[IntegerQ[r]]],
  
  Return[Message[auxgamma::badarg2,r,d-1]]
    ];
    
  If[Not[IntegerQ[n]],
  
    Return[Message[auxgamma::badarg3,n]]
    ];
 (*____________________________________________*)
 
  (* TO FILL IN BY THE USER *)
        
(*_____________________________________________*)        
        
 ];(*end of Block*) 
 
(*___________________________________________
   
the beta coefficients of the auxiliary sequence 
of d-orthogonal polynomials
_____________________________________________*)

auxbeta[d_,n_]:=auxbeta[d,n]=

 Block[{},
 (*_________ checking the arguments __________*)
  If[Not[IntegerQ[n]],
  
    Return[Message[auxbeta::badarg2,n]]
    ];
(*____________________________________________*) 

 (* TO FILL IN BY THE USER *)
 
(*____________________________________________*)
        
 ];(*end of Block*)  
 
(*_________________________________________________

  the exact expression of the gamma coefficients
_________________________________________________*) 

gammaexact[d_,r_,n_]:=gammaexact[d,r,n]=

 Block[{},
 
 (*_________ checking the arguments __________*) 
  If[Or[r<0,r>=d,Not[IntegerQ[r]]],
  
  Return[Message[gammaexact::badarg2,r,d-1]]
    ];
    
  If[Not[IntegerQ[n]],
  
    Return[Message[gammaexact::badarg3,n]]
    ];
(*____________________________________________*)

     (* TO FILL IN BY THE USER *)
        
(*_________________________________________________*)

];(*end of Block*)


(*_________________________________________________

  the exact expression of the beta coefficients
_________________________________________________*) 

betaexact[d_,n_]:=betaexact[d,n]=

 Block[{},
  (*_________ checking the arguments _________*)
      
      If[Not[IntegerQ[n]],
      
     Return[Message[betaexact::badarg3,n]]
        ];   
  (*__________________________________________*)
             
    (* TO FILL IN BY THE USER *)
    
 (*_____________________________________________*) 
   
      ];(*end of Block*)          
(*_______________________________________________*)

 
   
End[]

EndPackage[]