#include <stdio.h>
#include <string.h>
#include "misc.h"
#include "version.h"

/*
 * compare different version/release numbers
 * returns 0 if versions are equivalent
 *         > 1 if a is more recent (higher version) than b
 *         < 1 if a is less recent (lower version) than b
 *
 * version numbering is assumed to work as follows:
 *
 * levels are separated by '.' and the most significant level is on
 * the left
 *
 * each level is evaluated as an integer.  a level with a value of
 * '11' is more recent than a level with a value of '2'. and
 * a level with a value of '01' is equivalent to a level with a value
 * of '1'.  
 *
 * routines that get version/release numbers are expected to mung them
 * as necessary so that this routine does the right thing when comparing
 * them.
 *
 * this routine scribbles on 'a' and 'b'.
 */

static int
really_version_compare (char *a, char *b)
{
    char *adot, *bdot;
    int ai, bi;

    if (*a == '\0' && *b == '\0')
	return 0;

    if (adot = strchr (a, '.'))
	*adot++ = '\0';
    else
	adot = "";
    ai = atoi (a);

    if (bdot = strchr (b, '.'))
	*bdot++ = '\0';
    else
	bdot = "";
    bi = atoi (b);

    if (ai == bi)
	return really_version_compare (adot, bdot);
    else
	return ai-bi;
}

/*
 * like the above except we check boundary conditions and
 * avoid scribbling on the arguments
 */

int
version_compare (char *a, char *b)
{
    int x;

    if (a == NULL && b == NULL)
	return 0;
    if (a == NULL)
	return -1;
    if (b == NULL)
	return 1;

    x = really_version_compare (a = xstrdup (a), b = xstrdup (b));

    free (a);
    free (b);
    return x;
}
