/*
 * routines for dealing with URIs (for now, only one)
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "uri.h"

struct {
    char *prefix;
    int plen;
    int port;
} prefixes[] = {
    { "http:", 5, 80 },
    NULL
};

/*
 * canonicalize a URI of the form {prefix}://{host}[:{port}]/{stuff}
 * result is returned in a malloc'ed string
 *
 * URI MUST have all component parts and a FQDN for a host name
 *
 * XXX doesn't work for all kinds of URIs
 * XXX currently, doesn't attempt to rationalize %XX notation
 */

char *
canonicalize_uri (char *uri)
{
    int port = -1;
    char *result = malloc (strlen (uri) * 3);
    char *dest = result;
    int i;

    /*
     * copy and lowercase uri prefix
     */
    for (i = 0; prefixes[i].prefix != NULL; ++i) {
	if (strncasecmp (uri, prefixes[i].prefix, prefixes[i].plen) == 0) {
	    port = prefixes[i].port;
	    break;
	}
    }
    while (*uri && *uri != ':')
	*dest++ = isupper (*uri) ? tolower (*uri++) : *uri++;
    if (*uri == ':')
	*dest++ = *uri++;
    while (*uri == '/')
	*dest++ = *uri++;

    /*
     * copy and lowercase host name
     */
    while (*uri && *uri != '/' && *uri != ':')
	*dest++ = isupper (*uri) ? tolower (*uri++) : *uri++;

    /*
     * if port # is present, and is the same as default, remove it
     * else copy port # without leading zeros
     */
    if (*uri == ':') {
	int x;
	char *ptr;

	for (x = 0, ptr = uri+1; isdigit (*ptr); x = x * 10 + (*ptr++ - '0'));
	if (x == port)
	    uri = ptr;
	else {
	    *dest++ = *uri++;
	    while (*uri == '0')
		++uri;
	    while (*uri && *uri != '/')
		*dest++ = *uri++;
	}
    }
    strcpy (dest, uri);
    result = realloc (result, strlen (result) + 1);
    return result;
}
