#include "conf.h"

#ifdef HAVE_UNAME
#include <stdio.h>
#include <string.h>
#include <sys/utsname.h>
#include "symtab.h"

uname_init ()
{
    struct utsname name;

    uname (&name);
    symtab_set_value_str ("link.uname.sysname", strdup (name.sysname));
    symtab_set_value_str ("link.uname.nodename", strdup (name.nodename));
    symtab_set_value_str ("link.uname.release", strdup (name.release));
    symtab_set_value_str ("link.uname.version", strdup (name.version));
    symtab_set_value_str ("link.uname.machine", strdup (name.machine));
}
#endif /* HAVE_UNAME */
